(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     81083,       2536]
NotebookOptionsPosition[     70639,       2168]
NotebookOutlinePosition[     71942,       2206]
CellTagsIndexPosition[     71856,       2201]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InverseJacobiSD" :> 
          Documentation`HelpLookup["paclet:ref/InverseJacobiSD"], "JacobiSN" :> 
          Documentation`HelpLookup["paclet:ref/JacobiSN"], "JacobiSC" :> 
          Documentation`HelpLookup["paclet:ref/JacobiSC"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"InverseJacobiSD\"\>", 
       2->"\<\"JacobiSN\"\>", 3->"\<\"JacobiSC\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Elliptic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["JacobiSD", "ObjectName",
 CellID->9964],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["JacobiSD",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/JacobiSD"], "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Jacobi elliptic function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"sd", "(", 
        RowBox[{"u", "|", "m"}], ")"}], TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21566]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"sd", "(", "u", ")"}], "=", 
    FractionBox[
     RowBox[{"sin", "(", "\[Phi]", ")"}], 
     SqrtBox[
      RowBox[{"1", "-", 
       RowBox[{"m", " ", 
        RowBox[{
         SuperscriptBox["sin", "2"], "(", "\[Phi]", ")"}]}]}]]]}], 
   TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Phi]", "=", 
    RowBox[{"am", "(", 
     RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->16882],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"sd", "(", 
    RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " is a doubly periodic function in ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " with periods ",
 Cell[BoxData[
  FormBox[
   RowBox[{"4", " ", 
    RowBox[{"K", "(", "m", ")"}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"4", " ", "\[ImaginaryI]", " ", 
    RowBox[{"K", "(", 
     RowBox[{"1", "-", "m"}], ")"}]}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox["K", TraditionalForm]], "InlineMath"],
 " is the elliptic integral ",
 Cell[BoxData[
  ButtonBox["EllipticK",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticK"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->318360977],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiSD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiSD"]], "InlineFormula"],
 " is a meromorphic function in both arguments."
}], "Notes",
 CellID->308964962],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["JacobiSD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiSD"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->769215972],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiSD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiSD"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiSD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiSD"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->88617458],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->541084954],

Cell["Evaluate numerically:", "ExampleText",
 CellID->297820305],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiSD", "[", 
  RowBox[{"2.5", ",", "0.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->244687452],

Cell[BoxData["1.1465331575209883`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->256459024]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->472748319],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"JacobiSD", "[", 
    RowBox[{"u", ",", 
     RowBox[{"1", "/", "3"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"-", "6"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->277635963],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6584129]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28588389],

Cell["Series expansions:", "ExampleText",
 CellID->134741977],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"JacobiSD", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "7"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->386567672],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"z", "+", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "m"}]}], ")"}], " ", 
    SuperscriptBox["z", "3"]}], "+", 
   RowBox[{
    FractionBox["1", "120"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"16", " ", "m"}], "+", 
      RowBox[{"16", " ", 
       SuperscriptBox["m", "2"]}]}], ")"}], " ", 
    SuperscriptBox["z", "5"]}], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"138", " ", "m"}], "-", 
       RowBox[{"408", " ", 
        SuperscriptBox["m", "2"]}], "+", 
       RowBox[{"272", " ", 
        SuperscriptBox["m", "3"]}]}], ")"}], " ", 
     SuperscriptBox["z", "7"]}], "5040"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "8"],
    SeriesData[$CellContext`z, 0, {}, 1, 8, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   1, 0, Rational[1, 6] (-1 + 2 $CellContext`m), 0, 
    Rational[1, 120] (1 - 16 $CellContext`m + 16 $CellContext`m^2), 0, 
    Rational[1, 5040] (-1 + 138 $CellContext`m - 408 $CellContext`m^2 + 
     272 $CellContext`m^3)}, 1, 8, 1],
  Editable->False]], "Output",
 ImageSize->{517, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->263101226]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"JacobiSD", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->111422725],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"Sin", "[", "z", "]"}], "+", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "z", " ", 
       RowBox[{"Cos", "[", "z", "]"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "z", "]"}], "3"]}], "+", 
      RowBox[{
       RowBox[{"Cos", "[", "z", "]"}], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "z"}], "]"}]}]}], ")"}], " ", "m"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "2"],
    SeriesData[$CellContext`m, 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 0, {
    Sin[$CellContext`z], 
    Rational[1, 8] ((-2) $CellContext`z Cos[$CellContext`z] + 
     4 Sin[$CellContext`z]^3 + Cos[$CellContext`z] Sin[2 $CellContext`z])}, 0,
    2, 1],
  Editable->False]], "Output",
 ImageSize->{393, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->292829065]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5965],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->129846035],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiSD", "[", 
  RowBox[{
   RowBox[{"1.5", "+", 
    RowBox[{"0.5", "I"}]}], ",", 
   RowBox[{"1", "-", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->759271466],

Cell[BoxData[
 RowBox[{"0.907667441441693`", "\[InvisibleSpace]", "-", 
  RowBox[{"1.9572604008537893`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->316293021]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->952308874],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->6417250],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"JacobiSD", "[", 
    RowBox[{"2", ",", 
     RowBox[{"1", "/", "3"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->391684793],

Cell[BoxData["1.\
1819752862582337358329489397616918505544786400184459725349475513362`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->63473053]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->189588955],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->174359713],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiSD", "[", 
  RowBox[{"2", ",", "0.33333333333333333333333333333333333333"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->472054173],

Cell[BoxData["1.18197528625823373583294893976169185055447864002`36.\
939157541039975"], "Output",
 ImageSize->{270, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->162049058]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->922083953],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiSD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiSD"]], "InlineFormula"],
 " threads element\[Hyphen]wise over lists:"
}], "ExampleText",
 CellID->87194919],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiSD", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->361152767],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiSD", "[", 
    RowBox[{"1", ",", "m"}], "]"}], ",", 
   RowBox[{"JacobiSD", "[", 
    RowBox[{"2", ",", "m"}], "]"}]}], "}"}]], "Output",
 ImageSize->{220, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->149223905]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->121451203],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->216197542],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiSD", "[", 
    RowBox[{"z", ",", "0"}], "]"}], ",", 
   RowBox[{"JacobiSD", "[", 
    RowBox[{"z", ",", "1"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->270801590],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Sin", "[", "z", "]"}], ",", 
   RowBox[{"Sinh", "[", "z", "]"}]}], "}"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->65775018]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiSD", "[", 
    RowBox[{"0", ",", "m"}], "]"}], ",", 
   RowBox[{"JacobiSD", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"EllipticK", "[", "m", "]"}], "/", "2"}], ",", "m"}], "]"}], 
   ",", 
   RowBox[{"JacobiSD", "[", 
    RowBox[{
     RowBox[{"EllipticK", "[", "m", "]"}], ",", "m"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->830342569],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   FractionBox["1", 
    RowBox[{
     SqrtBox[
      RowBox[{"1", "+", 
       SqrtBox[
        RowBox[{"1", "-", "m"}]]}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", "m"}], ")"}], 
      RowBox[{"1", "/", "4"}]]}]], ",", 
   FractionBox["1", 
    SqrtBox[
     RowBox[{"1", "-", "m"}]]]}], "}"}]], "Output",
 ImageSize->{241, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->114890509]
}, Open  ]],

Cell["\<\
Parity transformation and periodicity relations are automatically applied:\
\>", "ExampleText",
 CellID->439505732],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiSD", "[", 
  RowBox[{
   RowBox[{"-", "u"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->290495360],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"JacobiSD", "[", 
   RowBox[{"u", ",", "m"}], "]"}]}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->544361790]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiSD", "[", 
  RowBox[{
   RowBox[{"u", "+", 
    RowBox[{"4", 
     RowBox[{"EllipticK", "[", "m", "]"}]}], "+", 
    RowBox[{"4", "I", " ", 
     RowBox[{"EllipticK", "[", 
      RowBox[{"1", "-", "m"}], "]"}]}]}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->550321537],

Cell[BoxData[
 RowBox[{"JacobiSD", "[", 
  RowBox[{"u", ",", "m"}], "]"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1026073426]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->326179915],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting;"
}], "ExampleText",
 CellID->31189566],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"JacobiSD", "[", 
   RowBox[{"u", ",", "m"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19997062],

Cell[BoxData[
 FormBox[
  RowBox[{"sd", "(", 
   RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{48, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->199862227]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7749],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiSD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiSD"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellID->416500379],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiSD", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcSin", "[", "z", "]"}], "+", 
    RowBox[{
     RowBox[{"O", "[", "z", "]"}], "^", "10"}]}], ",", "m"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->474046052],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"z", "+", 
   FractionBox[
    RowBox[{"m", " ", 
     SuperscriptBox["z", "3"]}], "3"], "+", 
   RowBox[{
    FractionBox["1", "30"], " ", 
    RowBox[{"(", 
     RowBox[{"m", "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["m", "2"]}]}], ")"}], " ", 
    SuperscriptBox["z", "5"]}], "+", 
   RowBox[{
    FractionBox["1", "630"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"12", " ", "m"}], "+", 
      RowBox[{"19", " ", 
       SuperscriptBox["m", "2"]}], "+", 
      RowBox[{"34", " ", 
       SuperscriptBox["m", "3"]}]}], ")"}], " ", 
    SuperscriptBox["z", "7"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "9"],
    SeriesData[$CellContext`z, 0, {}, 1, 9, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   1, 0, Rational[1, 3] $CellContext`m, 0, 
    Rational[1, 30] ($CellContext`m + 4 $CellContext`m^2), 0, 
    Rational[1, 630] (12 $CellContext`m + 19 $CellContext`m^2 + 
     34 $CellContext`m^3)}, 1, 9, 1],
  Editable->False]], "Output",
 ImageSize->{381, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->950385806]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29353],

Cell["Conformal map from a rectangle to the unit disk:", "ExampleText",
 CellID->570863902],

Cell[BoxData[
 RowBox[{
  RowBox[{"w", "[", 
   RowBox[{"z_", ",", 
    RowBox[{"{", 
     RowBox[{"a_", ",", "b_"}], "}"}]}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"m", "=", 
      RowBox[{"InverseEllipticNomeQ", "[", 
       RowBox[{"Exp", "[", 
        RowBox[{
         RowBox[{"-", "Pi"}], " ", "2", " ", 
         RowBox[{"b", "/", "a"}]}], "]"}], "]"}]}], "}"}], ",", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", "-", 
      RowBox[{
       RowBox[{"JacobiSD", "[", 
        RowBox[{
         FractionBox[
          RowBox[{"z", " ", 
           RowBox[{"EllipticK", "[", "m", "]"}]}], "a"], ",", "m"}], "]"}], 
       RowBox[{"JacobiDN", "[", 
        RowBox[{
         FractionBox[
          RowBox[{"z", " ", 
           RowBox[{"EllipticK", "[", "m", "]"}]}], "a"], ",", "m"}], "]"}], 
       " "}]}], 
     RowBox[{"\[ImaginaryI]", "+", 
      RowBox[{
       RowBox[{"JacobiSD", "[", 
        RowBox[{
         FractionBox[
          RowBox[{"z", " ", 
           RowBox[{"EllipticK", "[", "m", "]"}]}], "a"], ",", "m"}], "]"}], 
       RowBox[{"JacobiDN", "[", 
        RowBox[{
         FractionBox[
          RowBox[{"z", " ", 
           RowBox[{"EllipticK", "[", "m", "]"}]}], "a"], ",", "m"}], "]"}], 
       " "}]}]]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->199487360],

Cell["Visualize the map:", "ExampleText",
 CellID->318950862],

Cell[BoxData[
 RowBox[{
  RowBox[{"points", "=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"pp", "=", "25"}], ",", 
       RowBox[{"a", "=", "1."}], ",", 
       RowBox[{"b", "=", "2."}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"x", " ", "+", " ", 
          RowBox[{"I", " ", "y"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"-", " ", "a"}], ",", "a", ",", 
           RowBox[{"2", 
            RowBox[{"a", "/", "pp"}]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"y", ",", "0", ",", 
           RowBox[{"2", " ", "b"}], ",", 
           RowBox[{"2", 
            RowBox[{"b", "/", "pp"}]}]}], "}"}]}], "]"}], ",", "1"}], "]"}]}],
     "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->576994587],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Re", "[", "#", "]"}], ",", 
          RowBox[{"Im", "[", "#", "]"}]}], "}"}], "]"}], "&"}], "/@", " ", 
      RowBox[{"f", "[", "points", "]"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", " ", 
     RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", " ", 
     RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"Identity", ",", 
       RowBox[{
        RowBox[{"w", "[", 
         RowBox[{"#", ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "&"}]}], "}"}]}], "}"}]}],
   "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->584095858],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 189},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->112260789]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->323870425],

Cell[TextData[{
 "Generator for the hierarchy of solutions of the nonlinear diffusion \
equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox[
     RowBox[{"\[PartialD]", 
      RowBox[{"u", "(", 
       RowBox[{"t", ",", "x"}], ")"}]}], 
     RowBox[{"\[PartialD]", "t"}],
     MultilineFunction->None], "=", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["\[PartialD]", "2"], 
       RowBox[{"u", "(", 
        RowBox[{"t", ",", "x"}], ")"}]}], 
      RowBox[{
       RowBox[{"\[PartialD]", "x"}], "\[ThinSpace]", 
       RowBox[{"\[PartialD]", "x"}]}],
      MultilineFunction->None], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"u", "(", 
        RowBox[{"t", ",", "x"}], ")"}], "3"]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->69906327],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[CurlyPhi]", "[", 
    RowBox[{"0", ",", "y_"}], "]"}], ":=", 
   RowBox[{"1", "/", 
    RowBox[{"JacobiSD", "[", 
     RowBox[{"y", ",", 
      RowBox[{"1", "/", "2"}]}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[CurlyPhi]", "[", 
   RowBox[{"n_", ",", "y_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"\[CurlyPhi]", "[", 
      RowBox[{
       RowBox[{"n", "-", "1"}], ",", "y"}], "]"}], ",", "y"}], "]"}], "/", 
   RowBox[{"\[CurlyPhi]", "[", 
    RowBox[{
     RowBox[{"n", "-", "1"}], ",", "y"}], "]"}]}]}], "\n", 
 RowBox[{
  RowBox[{"u", "[", 
   RowBox[{"n_", ",", 
    RowBox[{"{", 
     RowBox[{"t_", ",", "x_"}], "}"}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{"2", " ", "x", " ", 
    RowBox[{"\[CurlyPhi]", "[", 
     RowBox[{"n", ",", "y"}], "]"}]}], "/.", 
   RowBox[{"y", "->", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"6", " ", "t"}]}]}]}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->548759095],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"u", "[", 
     RowBox[{"k", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "x"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "0", ",", "2"}], "}"}]}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->458022657],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "x"}], 
    RowBox[{"JacobiSD", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"6", " ", "t"}], "+", 
       SuperscriptBox["x", "2"]}], ",", 
      FractionBox["1", "2"]}], "]"}]], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", "x", " ", 
      RowBox[{"JacobiCD", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"6", " ", "t"}], "+", 
         SuperscriptBox["x", "2"]}], ",", 
        FractionBox["1", "2"]}], "]"}], " ", 
      RowBox[{"JacobiND", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"6", " ", "t"}], "+", 
         SuperscriptBox["x", "2"]}], ",", 
        FractionBox["1", "2"]}], "]"}]}], 
     RowBox[{"JacobiSD", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"6", " ", "t"}], "+", 
        SuperscriptBox["x", "2"]}], ",", 
       FractionBox["1", "2"]}], "]"}]]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox[
           RowBox[{"JacobiND", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"6", " ", "t"}], "+", 
              SuperscriptBox["x", "2"]}], ",", 
             FractionBox["1", "2"]}], "]"}], "2"]}], " ", 
         SuperscriptBox[
          RowBox[{"JacobiSD", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"6", " ", "t"}], "+", 
             SuperscriptBox["x", "2"]}], ",", 
            FractionBox["1", "2"]}], "]"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"JacobiCD", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"6", " ", "t"}], "+", 
             SuperscriptBox["x", "2"]}], ",", 
            FractionBox["1", "2"]}], "]"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox[
             RowBox[{"JacobiND", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"6", " ", "t"}], "+", 
                SuperscriptBox["x", "2"]}], ",", 
               FractionBox["1", "2"]}], "]"}], "2"]}], "+", 
           SuperscriptBox[
            RowBox[{"JacobiSD", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"6", " ", "t"}], "+", 
               SuperscriptBox["x", "2"]}], ",", 
              FractionBox["1", "2"]}], "]"}], "2"]}], ")"}]}]}], ")"}]}], 
     ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"JacobiCD", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"6", " ", "t"}], "+", 
         SuperscriptBox["x", "2"]}], ",", 
        FractionBox["1", "2"]}], "]"}], " ", 
      RowBox[{"JacobiND", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"6", " ", "t"}], "+", 
         SuperscriptBox["x", "2"]}], ",", 
        FractionBox["1", "2"]}], "]"}], " ", 
      RowBox[{"JacobiSD", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"6", " ", "t"}], "+", 
         SuperscriptBox["x", "2"]}], ",", 
        FractionBox["1", "2"]}], "]"}]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{542, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->632840362]
}, Open  ]],

Cell["Numerical check of the solutions:", "ExampleText",
 CellID->482807538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"%", ",", "t"}], "]"}], "-", 
   RowBox[{"D", "[", 
    RowBox[{"%", ",", "x", ",", "x"}], "]"}], "+", 
   RowBox[{"2", 
    RowBox[{"%", "^", "3"}]}]}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "2"}], ",", 
    RowBox[{"t", "\[Rule]", 
     RowBox[{"N", "[", 
      RowBox[{"3", ",", "100"}], "]"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->919980924],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0``92.71148769418691", ",", "0``94.49970142984378", ",", 
   "0``92.4876527161328"}], "}"}]], "Output",
 ImageSize->{205, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->211453536]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->208884986],

Cell["Conformal map from an ellipse to the unit disk:", "ExampleText",
 CellID->539250045],

Cell[BoxData[
 RowBox[{
  RowBox[{"w", "[", 
   RowBox[{"z_", ",", 
    RowBox[{"{", 
     RowBox[{"a_", ",", "b_"}], "}"}]}], "]"}], ":=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"m", "=", 
       RowBox[{"InverseEllipticNomeQ", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "-", "b"}], ")"}], "^", "2"}], "/", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", "b"}], ")"}], "^", "2"}]}], "]"}]}], ",", "u"}], 
     "}"}], ",", 
    RowBox[{
     RowBox[{"u", "=", 
      RowBox[{"2", " ", 
       RowBox[{
        RowBox[{"EllipticK", "[", "m", "]"}], "/", "Pi"}], " ", 
       RowBox[{"ArcSin", "[", 
        RowBox[{"z", "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}]}], "]"}]}], "]"}]}]}], ";", 
     RowBox[{
      SuperscriptBox["m", 
       RowBox[{"1", "/", "2"}]], 
      RowBox[{"JacobiSD", "[", 
       RowBox[{"u", ",", "m"}], "]"}], 
      RowBox[{"JacobiDN", "[", 
       RowBox[{"u", ",", "m"}], "]"}]}]}]}], "]"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35115403],

Cell["Visualize the map:", "ExampleText",
 CellID->250879779],

Cell[BoxData[
 RowBox[{
  RowBox[{"points", "=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", "=", "2"}], "}"}], ",", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"r", "/", "8."}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", " ", 
             RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}]}], " ", "+", " ", 
            RowBox[{"I", " ", 
             RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}]}], ")"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"r", ",", "8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\[CurlyPhi]", ",", "0", ",", 
           RowBox[{"2", "Pi"}], ",", 
           RowBox[{"2", 
            RowBox[{"Pi", "/", "36"}]}]}], "}"}]}], "]"}], ",", "1"}], 
      "]"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->231984289],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Re", "[", "#", "]"}], ",", 
          RowBox[{"Im", "[", "#", "]"}]}], "}"}], "]"}], "&"}], "/@", " ", 
      RowBox[{"f", "[", "points", "]"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"Identity", ",", 
       RowBox[{
        RowBox[{"w", "[", 
         RowBox[{"#", ",", 
          RowBox[{"{", 
           RowBox[{"2.", ",", "1"}], "}"}]}], "]"}], "&"}]}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->670912061],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnUtvHMcRgIfcB3fFt0SKIlcSKdJSRCkWrDi2EASG7IsowMjNgM+EEEAO
ECRQ/Auig8/xxSdDx/wE/YrkH+SH5JLNzPRMd+/XVVO9S8rWwQZMbU0/putd
Xf2YP5x/+/KPfz7/9psX50dnr87/+vKbF387evaXV+Wj3lJRLP29KIp/3ijK
39PyV/1/9d/r8n/3s/vXctmgV0E917L8W1TP9oWy6mf1bNLR7mb5u3q0LLRb
rev9r/rbDyVFsYK6u0mNfvJk3+zlAHAvaXGl/ue/5d/qcTFwT33xzzyu941O
6XgqglV8vbHQONrWty70/rjl3sLjiHu5mTmeaTP+lYgK1b/D5t8JyicoX/W9
5Oqq+/Wf8u8PZfsND8Wj7QMmdr+Up/CySs1jEf7uu+/KRy9fvixOhHK9t7Ma
Pjo6Kh+NRqPiOcrXO1q9ffv2888/f/PmTWar7y9Yq3r4jwabzXfyhvjpPdD1
KeBfzdFLoO9TwPP0Euj9FHBeL3l4nwFPnbcVH54Dn/dZfuKnHwLLx4AfzdFL
wP4xYLmXO1Pn3StNrQoPG1q28HFTfld8W6DaY8Dy22J7Uf4tPkCt2tfN+BLJ
gsQ93J1KunizGTWjs0nznFbOfi9hjlzmNGvRXtrvZQ8sz9OQn2oclu7dSd4z
vwSkfVA28zS69UUfNP8eTYPkx8/vofUWKH4E+C7gQ8BXxdFQm7dAzyPAdwEf
Ap7nLYFSR4DvAj4ErL+ljehizL8GPMka4wEw+xqw3Mvt8u+PRZFI+gEw+Bqw
3FsVr2iztmEij5xBvIuY7H2KES+lfIaC5JpsXTfxNJ2JpD3TVtTWpCNiPUl6
qGRem90P0TrPOo+msreS8akqfIZ+6xlXpBNXUP5Z02476ZGyyjEwoj/Gm0g/
2vO5OBXV+CgLw6C3FgV+g/6vTHOzGjJFaGnDm9YxsjWUX0X7y6WYTqE9g2Kk
0GaWrLQxYuoVQs83RYqF+sdNP5sXwlyPRW3M2lwL9fcJeroJ+Hci7zams5mM
9l/O4vYAjwyY9e81/aZaTQoRlu3pbTxljLEHeGTArM+Z4dZ0NgPEUT4Avk8A
P5wDC10fRyjPg0P7NZQTyyMRq0CVJ4DzsPotWp0C/jRrFGHUlHR9FFJkZ9H0
GsqvZdF0NlJcLtK4YIh6A8CfAv4EMNvTwsm0Z0S6BnhH7DWUr6B8x+iPGdd2
psJ+B4CJHX31WNRf+npSl/0TrzzqUR8DvCryiG8J9UkFYr1qvE+ibipjof4A
MMd3B/BYlPVQznhC7p/4appJHlO22Nu2gQ1l+Y6iiYwuqImbok6E+juGRdgQ
pSLUv5Ele5xFy7IWej0RqUPZIi91WTpE/U3AtOIbomxZWG5jlLKGhV73UX9f
pJLuQa9lYR3abwI+BbwBeB6sw6hpZ0gVWjNKLDWDVt/CWo+xKv1hDMxZRN5o
qW8WNpyFzL5f0uv7aPd7wKcilm0EnDNHvmHoFGdyfYMSnH+RMn30x3kQbQLX
f8nn+2hPi0lOEKaFlila/51r5n5DxEuf//VRfgsw6c75Jfkm0c3PViL8d9EP
6SFLNukd2u+i/3aW4WaXba5l/nn/GP3Sqt4Q5ZByG+AeYFo99keru2rIJT2o
ZSFuivX1uEeGrf4sPVxM7iuQ0SznHLQjjCh64vgCLJfr/fF919B+PI2zJwGf
ZWNcluVntuWWUc7+iLcstzaftJwK42HKjWz/9VkK6dMT8QmwXM72nMvq46G/
ID0tPV02xk9/xhiUdiHPjuvtGQPTzsn0ypOHrpwU4zfZX+nzKNKNMxLKCXMU
lj+z4r1ltKeecVb/0ChnrlGmcxtpaTk0RrGMM+nViAVnQLRObM+40qLaHUPa
HhrltJ6OKu2upXbP2QFGSR2m76BOE+t5YcoS30dfcTCVo3H6NMaaxJMzO8ZG
O+i/zVS74EiOKANMS8K8PzWKlr/25Cu+fQmFtrSKWfCKh0tIzzVwHJQG6gg9
WBvJ0nJa+TdKAbkh42jlCfVMGfmzDjxGgJfn4LoeR5LrLBfj6BnO0drMCa94
eEai5By17veokzJ3dctGvK04jtyj/2MGjf3JtNGliVkY+h/Sw4oLSY986Qp+
S49qaVvE3PWMLQl97SdSoUd3hBm1S+OULDXHz+iEsz2uCWwm+Oh90b7lcV63
j4w4yfnFOR3D9OS0lrTSdfnQl/sCcqzud+zrpT8SSa97GPoOfUXymhaBGrIh
WYShh31DauptjMfxXraIjK/Ia2aUb0v1B7FclT+SuXceB3cNHU39O7i5mzLH
t05/CJwcKpyjTHBk6UmIw1le+arM4sizVcwaFJwnHXZInu1Q1uDLB7GMXJSP
+ZoormdOOljom6Y/OticeETO2BhJUB/3SI2iWTUIfPaVibMc5XAVkjY1lJ8A
ZnZIXrU0vOsglp35+F3hXnfqu5yII4BnbCzFl19+GfN+3MFZx5VxB6cNrdX5
X4+4H+uWdAJPPJ9k5vn0vCY51aXhJwpmjPzpca1Yix6cs3zZA3O36r5i48h5
+hhZD4FNIim7kcR+9dVXityzL3l9WtebGsdgyacdZ+Y6orHrgMmvWrvX3Sie
PHkSuyGAIROsR/LMTNGHk7tjwEtO+3vun+rvZJazsGq61RJ1npxPODuInq6v
r8ecbOIzT5fyb215ek5T6irT4Ln6/X4s0Ym0UBpkC6FbDDkyLmYitHp8VcU0
tFTWUCiN8OIJvep48yr849LSUhE5PoCeMGuKRWF8kDVSJfZocxnVCCrZWtKt
R0ce3/JosqxB6ldiqRoOh7HE9b1slcVOqhzVqr/OvzmyFSF6bzDe2dlJpa1j
TUEeu26l1gS5kiwtvXpelEFLgrnOdWiiG9arV69iBwwQBFlHv/Kaiz5O+thB
pOMhOuVKiJMzLVrhui5pLvJEsVWuFuSp5+XJSc+4LH/06NH9+/cdscq/DqyI
1YcV60X2yhHT00WxYrr0EN6ZRjmF9SKx6nJWIC+OQZyW0Gt11op7kq11aNOq
iLW1j5bjE/NZo9QoO2HKi3zHU/2WBnpZ7hOWfcn5+XkJf/HFF658JchQbYdK
aZmhdSlAg8Ggfk0sPX30JdvOMBZxT3EjGaI0xOIia2eHFxNXOIexlVleXi47
3rJkomOFg+/kmMRspjBJnEcaagk07j/g2aRHohbR6mxvb8/w32tEyf9er+qu
+mtFJx91cBmYHxwc0IvL+WXdl9T634+7u6Lofrxbu+IzIzpH17L8+PjYDYbZ
WWuncj32tZipXjfgRC6Z0wPokBkhyzvGjfozVHY1SuI6iWkyB05KarK31Lx6
9WoJPnjwwLU4OztzYEF4xSgX6w887MhRZ7o7beXIPUs5Y+1gyPJEtBUDL4fO
2DQ5u7KVMzIlweRVVf09osdZiwXM//ZIvgupc7GEe2ONqmRTOuCsSLvvYCeG
roaLlqv/KpnreVmLfZir6ePoBF4xyq36fu9rjnY2ts9Z15LhMVdilVLyI7qW
Krav7+14+WQfeuqk7eOPPy7hyWTSSJuuhQPATtp8+2ntoZ2OlxLuXvIubZyu
F1Y8KtdHJFRpZiV8IaPUULMIM4x+rNOxlJaov3jxwvX77Nmz8snp6Wnzntev
X29tbZXFzTgCzHKx/sDDjZ3Llb5aYkdl9CYaiIW8bTKT29vbK+EqQnQ7N4IX
WIXejA29GgDuUe8A9y9fzpJY2srLQIJ6XoKSCKOuP4ztlHMKlETrLJB0AjEL
t7Vi1vfFsxH/ezG/x6xjwOYA+rAK+R4b+jEA3APsdks4uLJo9VsaLZlvfhXv
Gwpz9/w8Xby6EWaQ8dyduRvIytClGwvmHcNzLzNy9jJ+GmbDVg6LcDtzz/Zw
TUyVzmvkXcD6Gj7Xwpw/i2MA58+8L032uLEHcb/JTIyervhNO/xXvCeva199
Xh6ReQVY4iQz4yWsmZFHWUNmEQcebmZzccaaOSR9dTIvh8hdCQvYpjnjcvos
nfJyXB40z7Vycbm3zSVxrd2O8tyfs8GcuHw0jfcrYm3Xv8Cad+etMsCOy1m+
dZ9tFTOJPgurZCvlkRnrM2bOilmVIEHbgv1OMg7xxH6a5pXo73Q6u6g77s5l
HLxEeSNfZxyEjNOVSNZc3G6tQshzvth9a5mGTUmmsGaKvR0dKworkQ0Jvmw3
koLgi8g1WjiebBTXRJU8Uox5jLC+E4WYyJGsnh2qV0OVdR1aCvld+q4YZAWR
Iw4c9LsffA3eYGB5lZrGq/AqvjlGvJoW0HvI6+C65k9a3fEICisEYrKcKwTW
LBl2O7FzNc/Gqc6in3G8PC7yPbF+8l5MfbzyioG4TDKrz8neJz0yZXQir/C4
HVA5m5o0yRhJ26XUPY/ynmo9tuBOqO71SX0fimXh5fVJaA2MILZRxMvhXmDk
9UkjBrQyksn6ZJeE6PGnGN0oJxHcrkfftkNgUmFQpcJXJRXEHbTcBanthkjV
yFzBo67I9sPthgBaEA6/GwKL12uKPtBSyGcQ4DFXYgMRrTSpkmCdlLP2I6Z7
MKApwq457DEYpnIhc0WnBW2DuGvZ3DsV2l9HOW3A9qxVBkflU3+UUUaw1PQw
2tlbFuSz96G1fKoAEq/smtnvkCH5Jq/wHvlUwew4pVMFtGPWmWTZw8NeK/id
KLrG+NBaAZP3MlJeJQ7ap45CL9yzSKucnjKiTOmrBcsJp9FvRxzHm66yThGp
c9h8z8w7XLgfmbdDyPuPYTWScwOynWRb+W4TrO137lWj9BDW7UN6LlCXXEqm
dWeKwTv/UvlGEkZNmIEpWjnpsDrsR7b8AZbPEMg8pTxxJtY1Kww8JqxbBcJy
Tom4hnLe4wve+I4pP/ZZHMqDLnvyWRzUT/b0z85a+Q75TJIe8xE/3vjM26xJ
d/mksh5taPcIZe0YNPdZhPdudtgI9p13WluXRZ6UzPN4ugek3Qg3vmp3Jll3
JdAyWXdYsJxRlnxXAstp4RnfFMnMghbIWkWVz8RyjULvL+8UOTnNnLzlJXWv
2cZxTqfrSLvzLhtm7sTsQ4fnkPft6vShHFh3FMl3f+jzcHoJegX5NF2hzkXk
9rqHk0/cW14pwPKJe/195D9P3Ic7O2w50O800q0xTxUvdqeR3h/lK/dOI942
+yngX1+ATl1nEhh9M6KTTzqTfqSHHsnyfXl3/4T+eGcWMw4PjXK21++Mke9q
op+R7+bT7Q3vtJH1P8DW3Xq015dzpw7lP48+6QyHdNKzGNRT2tlbgCmH8p1T
XBGy6KjHBzzlLJ9vWXz81ll/6w4rmU9txNTefdTuMNgXtZBWoDv7YsPIcHW8
r/1WJK2inLXW37PYzW6695Zv3LNuk+UdQ/J9bnpMJ8N6FpXvs26UkvOh+vso
+5TVxaSDsq/7HPleROp+Hpdo+Wh5dZmV71/RdYaWnJZWmwHwvVxdWez2Tz3C
m739U6YaeaVnMWi3TgBb8Sdly5Ll+6jPM3EW11hfvlt29u5wPfol9rQMnB3x
7drd4Xlfo6AdkCWcvMK6nLnPTJ9bybGWzrtD1Ofc8hQwY8u8W6/zvkXA3AWp
Ys146GMsrPUc2OXccG59Q4D5CsblvEePPmPebwQcov7l3XBe6csnBg0/UfSK
WR352wAB5vce8u7U515vixd5sO4/pbOQ4WsYVkaRkmas/UXl8nca9Cxgu6dO
9jx30dtlf1uHEkrs5UwbJVLPA5NL/AaUlcnr/orFPfTGGzOss8Wsf0/REGJN
/8n7M2l36JN4Z7d8koZYt6expK8LcubJ76LxW7H81hXlYLGvD23hafpNLs6I
5a+R6Rln62tkMh6BsnnfL1oUD30mTrys79QRr3YHbk7WX46T8nCqKnyWhUso
b78amJ5msPJwFxlpzvcayzGWj6ox5n2vcb7R8ztjzKrJX31bBLtfvhS6QPkC
3A05aa7e6tkTrrymXynkzvkfxfFouVX5O5L5eYm870j+SxxPF43pyTlORgby
e/89TXNzca0z9PJc7GWx76nTK/+U3x2e/fZxwO86xsComTeQtTeAb4pjk79B
HcbG6PJQlH2LAvI3qMMYeWPKoSjReW8JvfxJlHOrlzNgmCdPZxjxPK0uT3Yr
Pn/fye8PgR2jvkdZI/gQ2D4GPE8vAXt+bTWvlzxNzquVz/uKws+B9Vkn5d+l
nbqHcT8FzDldVy8Bn6eA5+kl4PkUcF4vF+WqrQk/j9xc3GZw5um9bCHHsccN
FTbE3t7LuOw9Lm9XBgM1f/BQVeF1/atY+j/EpJyt\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 167},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->113377521]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->52439645],

Cell["Cartesian coordinates of a pendulum:", "ExampleText",
 CellID->238044846],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Omega]", "=", 
        SqrtBox[
         FractionBox["g", "\[ScriptL]"]]}], ",", 
       RowBox[{"m", "=", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"\[CurlyPhi]0", "/", "2"}], "]"}], "2"]}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "[", "t_", "]"}], " ", "=", " ", 
       RowBox[{"2", "\[ScriptL]", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"\[CurlyPhi]0", "/", "2"}], "]"}], 
        RowBox[{"JacobiSD", "[", 
         RowBox[{
          RowBox[{"\[Omega]", " ", "t"}], ",", "m"}], "]"}], 
        RowBox[{
         RowBox[{"JacobiDN", "[", 
          RowBox[{
           RowBox[{"\[Omega]", " ", "t"}], ",", "m"}], "]"}], "^", "2"}]}]}], 
      ";", 
      RowBox[{
       RowBox[{"y", "[", "t_", "]"}], " ", "=", 
       RowBox[{
        RowBox[{"-", "\[ScriptL]"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{
            RowBox[{"JacobiDN", "[", 
             RowBox[{
              RowBox[{"\[Omega]", " ", "t"}], ",", "m"}], "]"}], "^", "2"}]}],
           "-", "1"}], ")"}]}]}]}]}], "]"}], ";"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42362533],

Cell["Plot the time dependence of the coordinates:", "ExampleText",
 CellID->17651317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], ",", 
       RowBox[{"y", "[", "t", "]"}]}], "}"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[ScriptL]", "\[Rule]", "1"}], ",", 
       RowBox[{"g", "\[Rule]", "9.81"}], ",", 
       RowBox[{"\[CurlyPhi]0", "\[Rule]", 
        RowBox[{"Pi", "/", "4"}]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0.1", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22928806],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->131507570]
}, Open  ]],

Cell["Plot the trajectory:", "ExampleText",
 CellID->504412009],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], ",", 
       RowBox[{"y", "[", "t", "]"}]}], "}"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[ScriptL]", "\[Rule]", "1"}], ",", 
       RowBox[{"g", "\[Rule]", "9.81"}], ",", 
       RowBox[{"\[CurlyPhi]0", "\[Rule]", 
        RowBox[{"Pi", "/", "2"}]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0.1", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1050792162],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->825947560]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1367],

Cell["Compose with inverse functions:", "ExampleText",
 CellID->182095253],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiSD", "[", 
    RowBox[{
     RowBox[{"InverseJacobiSD", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", 
   RowBox[{"InverseJacobiSD", "[", 
    RowBox[{
     RowBox[{"JacobiSD", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->493765924],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   RowBox[{"InverseJacobiSD", "[", 
    RowBox[{
     RowBox[{"JacobiSD", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], "}"}]], "Output",
 ImageSize->{269, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->62760353]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " to disregard multivaluedness of the inverse function:"
}], "ExampleText",
 CellID->505999971],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->68594752],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", "z"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->803278641]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27094000],

Cell["Solve a transcendental equation:", "ExampleText",
 CellID->28603597],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"JacobiSD", "[", 
       RowBox[{"x", ",", "m"}], "]"}], "2"], "+", 
     RowBox[{"3", 
      RowBox[{"JacobiSD", "[", 
       RowBox[{"x", ",", "m"}], "]"}]}]}], "==", "a"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->798905],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->814679974],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"InverseJacobiSD", "[", 
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "-", 
          SqrtBox[
           RowBox[{"9", "+", 
            RowBox[{"4", " ", "a"}]}]]}], ")"}]}], ",", "m"}], "]"}]}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"InverseJacobiSD", "[", 
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "+", 
          SqrtBox[
           RowBox[{"9", "+", 
            RowBox[{"4", " ", "a"}]}]]}], ")"}]}], ",", "m"}], "]"}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{302, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->476383133]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->187645606],

Cell["Integrals:", "ExampleText",
 CellID->230428239],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"JacobiSD", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", " ", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->128430086],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"ArcSin", "[", 
    RowBox[{
     SqrtBox["m"], " ", 
     RowBox[{"JacobiCD", "[", 
      RowBox[{"z", ",", "m"}], "]"}]}], "]"}], " ", 
   SqrtBox[
    RowBox[{"1", "-", 
     RowBox[{"m", " ", 
      SuperscriptBox[
       RowBox[{"JacobiCD", "[", 
        RowBox[{"z", ",", "m"}], "]"}], "2"]}]}]], " ", 
   RowBox[{"JacobiDN", "[", 
    RowBox[{"z", ",", "m"}], "]"}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
   SqrtBox["m"]}]]], "Output",
 ImageSize->{437, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->109701586]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14016],

Cell["\<\
Machine-precision input is insufficient to give the correct answer:\
\>", "ExampleText",
 CellID->291661378],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiSD", "[", 
  RowBox[{
   RowBox[{"10.", "^", "16"}], ",", "Pi"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16218361],

Cell[BoxData[
 RowBox[{"0.`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->106571963]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"JacobiSD", "[", 
    RowBox[{
     RowBox[{"10", "^", "16"}], ",", "Pi"}], "]"}], ",", "20"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->46458592],

Cell[BoxData[
 RowBox[{"1.23994627036033081526471140166902763187`20.150514997831998", "+", 
  RowBox[{"0``20.05711213121136", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{237, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2313003]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->93508236],

Cell["\<\
Currently only simple simplification rules are built in for Jacobi functions:\
\
\>", "ExampleText",
 CellID->91718301],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox[
    RowBox[{"JacobiSD", "[", 
     RowBox[{"u", ",", "m"}], "]"}], "2"], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"JacobiCD", "[", 
        RowBox[{"u", ",", "m"}], "]"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"JacobiSD", "[", 
        RowBox[{"u", ",", "m"}], "]"}], "2"]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"JacobiSN", "[", 
      RowBox[{"u", ",", "m"}], "]"}], "2"]}]}], "//", " ", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->74336280],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"JacobiSD", "[", 
    RowBox[{"u", ",", "m"}], "]"}], "2"], "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"JacobiCD", "[", 
       RowBox[{"u", ",", "m"}], "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"JacobiSD", "[", 
       RowBox[{"u", ",", "m"}], "]"}], "2"]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"JacobiSN", "[", 
     RowBox[{"u", ",", "m"}], "]"}], "2"]}]}]], "Output",
 ImageSize->{449, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->284318241]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20417],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseJacobiSD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseJacobiSD"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiSN",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiSN"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiSC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiSC"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17095]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22347],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->32146]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->994208711],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->308263758]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"JacobiSD - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 51, 39.1848590}", "context" -> "System`", 
    "keywords" -> {
     "doubly periodic function", "elliptic Jacobi function", 
      "Jacobi elliptic function sd", "sd"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "JacobiSD[u, m] gives the Jacobi elliptic function sd(u | m).", 
    "synonyms" -> {"Jacobi SD"}, "title" -> "JacobiSD", "type" -> "Symbol", 
    "uri" -> "ref/JacobiSD"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6338, 226, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->88617458]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 71714, 2194}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2018, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2641, 77, 45, 1, 70, "ObjectName",
 CellID->9964],
Cell[2689, 80, 676, 22, 70, "Usage",
 CellID->21566]
}, Open  ]],
Cell[CellGroupData[{
Cell[3402, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3880, 124, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4003, 130, 561, 22, 70, "Notes",
 CellID->16882],
Cell[4567, 154, 839, 30, 70, "Notes",
 CellID->318360977],
Cell[5409, 186, 216, 7, 70, "Notes",
 CellID->308964962],
Cell[5628, 195, 248, 8, 70, "Notes",
 CellID->769215972],
Cell[5879, 205, 218, 7, 70, "Notes",
 CellID->31226],
Cell[6100, 214, 201, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6338, 226, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->88617458],
Cell[CellGroupData[{
Cell[6722, 240, 148, 5, 70, "ExampleSection",
 CellID->541084954],
Cell[6873, 247, 64, 1, 70, "ExampleText",
 CellID->297820305],
Cell[CellGroupData[{
Cell[6962, 252, 131, 4, 28, "Input",
 CellID->244687452],
Cell[7096, 258, 176, 5, 36, "Output",
 CellID->256459024]
}, Open  ]],
Cell[7287, 266, 125, 3, 70, "ExampleDelimiter",
 CellID->472748319],
Cell[CellGroupData[{
Cell[7437, 273, 290, 10, 28, "Input",
 CellID->277635963],
Cell[7730, 285, 3212, 57, 131, "Output",
 Evaluatable->False,
 CellID->6584129]
}, Open  ]],
Cell[10957, 345, 124, 3, 70, "ExampleDelimiter",
 CellID->28588389],
Cell[11084, 350, 61, 1, 70, "ExampleText",
 CellID->134741977],
Cell[CellGroupData[{
Cell[11170, 355, 245, 8, 70, "Input",
 CellID->386567672],
Cell[11418, 365, 1409, 44, 56, "Output",
 CellID->263101226]
}, Open  ]],
Cell[CellGroupData[{
Cell[12864, 414, 245, 8, 70, "Input",
 CellID->111422725],
Cell[13112, 424, 1056, 33, 51, "Output",
 CellID->292829065]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14217, 463, 215, 7, 70, "ExampleSection",
 CellID->5965],
Cell[14435, 472, 74, 1, 70, "ExampleText",
 CellID->129846035],
Cell[CellGroupData[{
Cell[14534, 477, 199, 7, 70, "Input",
 CellID->759271466],
Cell[14736, 486, 272, 7, 36, "Output",
 CellID->316293021]
}, Open  ]],
Cell[15023, 496, 125, 3, 70, "ExampleDelimiter",
 CellID->952308874],
Cell[15151, 501, 68, 1, 70, "ExampleText",
 CellID->6417250],
Cell[CellGroupData[{
Cell[15244, 506, 208, 7, 70, "Input",
 CellID->391684793],
Cell[15455, 515, 234, 7, 36, "Output",
 CellID->63473053]
}, Open  ]],
Cell[15704, 525, 125, 3, 70, "ExampleDelimiter",
 CellID->189588955],
Cell[15832, 530, 113, 3, 70, "ExampleText",
 CellID->174359713],
Cell[CellGroupData[{
Cell[15970, 537, 169, 5, 70, "Input",
 CellID->472054173],
Cell[16142, 544, 228, 6, 36, "Output",
 CellID->162049058]
}, Open  ]],
Cell[16385, 553, 125, 3, 70, "ExampleDelimiter",
 CellID->922083953],
Cell[16513, 558, 217, 7, 70, "ExampleText",
 CellID->87194919],
Cell[CellGroupData[{
Cell[16755, 569, 176, 6, 70, "Input",
 CellID->361152767],
Cell[16934, 577, 326, 11, 36, "Output",
 CellID->149223905]
}, Open  ]],
Cell[17275, 591, 125, 3, 70, "ExampleDelimiter",
 CellID->121451203],
Cell[17403, 596, 91, 1, 70, "ExampleText",
 CellID->216197542],
Cell[CellGroupData[{
Cell[17519, 601, 237, 8, 70, "Input",
 CellID->270801590],
Cell[17759, 611, 266, 9, 36, "Output",
 CellID->65775018]
}, Open  ]],
Cell[CellGroupData[{
Cell[18062, 625, 420, 15, 70, "Input",
 CellID->830342569],
Cell[18485, 642, 520, 20, 62, "Output",
 CellID->114890509]
}, Open  ]],
Cell[19020, 665, 125, 3, 70, "ExampleText",
 CellID->439505732],
Cell[CellGroupData[{
Cell[19170, 672, 146, 5, 70, "Input",
 CellID->290495360],
Cell[19319, 679, 235, 8, 36, "Output",
 CellID->544361790]
}, Open  ]],
Cell[CellGroupData[{
Cell[19591, 692, 316, 10, 70, "Input",
 CellID->550321537],
Cell[19910, 704, 217, 7, 36, "Output",
 CellID->1026073426]
}, Open  ]],
Cell[20142, 714, 125, 3, 70, "ExampleDelimiter",
 CellID->326179915],
Cell[20270, 719, 202, 7, 70, "ExampleText",
 CellID->31189566],
Cell[CellGroupData[{
Cell[20497, 730, 165, 5, 70, "Input",
 CellID->19997062],
Cell[20665, 737, 278, 9, 50, "Output",
 CellID->199862227]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20992, 752, 238, 7, 70, "ExampleSection",
 CellID->7749],
Cell[21233, 761, 211, 7, 70, "ExampleText",
 CellID->416500379],
Cell[CellGroupData[{
Cell[21469, 772, 245, 9, 70, "Input",
 CellID->474046052],
Cell[21717, 783, 1198, 38, 54, "Output",
 CellID->950385806]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22964, 827, 223, 7, 70, "ExampleSection",
 CellID->29353],
Cell[23190, 836, 91, 1, 70, "ExampleText",
 CellID->570863902],
Cell[23284, 839, 1347, 43, 70, "Input",
 CellID->199487360],
Cell[24634, 884, 61, 1, 70, "ExampleText",
 CellID->318950862],
Cell[24698, 887, 910, 28, 70, "Input",
 CellID->576994587],
Cell[CellGroupData[{
Cell[25633, 919, 861, 27, 70, "Input",
 CellID->584095858],
Cell[26497, 948, 6410, 109, 70, "Output",
 Evaluatable->False,
 CellID->112260789]
}, Open  ]],
Cell[32922, 1060, 125, 3, 70, "ExampleDelimiter",
 CellID->323870425],
Cell[33050, 1065, 831, 29, 70, "ExampleText",
 CellID->69906327],
Cell[33884, 1096, 1020, 35, 70, "Input",
 CellID->548759095],
Cell[CellGroupData[{
Cell[34929, 1135, 331, 12, 70, "Input",
 CellID->458022657],
Cell[35263, 1149, 3258, 104, 160, "Output",
 CellID->632840362]
}, Open  ]],
Cell[38536, 1256, 76, 1, 70, "ExampleText",
 CellID->482807538],
Cell[CellGroupData[{
Cell[38637, 1261, 457, 16, 70, "Input",
 CellID->919980924],
Cell[39097, 1279, 277, 9, 39, "Output",
 CellID->211453536]
}, Open  ]],
Cell[39389, 1291, 125, 3, 70, "ExampleDelimiter",
 CellID->208884986],
Cell[39517, 1296, 90, 1, 70, "ExampleText",
 CellID->539250045],
Cell[39610, 1299, 1185, 39, 70, "Input",
 CellID->35115403],
Cell[40798, 1340, 61, 1, 70, "ExampleText",
 CellID->250879779],
Cell[40862, 1343, 917, 28, 70, "Input",
 CellID->231984289],
Cell[CellGroupData[{
Cell[41804, 1375, 802, 26, 70, "Input",
 CellID->670912061],
Cell[42609, 1403, 6536, 111, 70, "Output",
 Evaluatable->False,
 CellID->113377521]
}, Open  ]],
Cell[49160, 1517, 124, 3, 70, "ExampleDelimiter",
 CellID->52439645],
Cell[49287, 1522, 79, 1, 70, "ExampleText",
 CellID->238044846],
Cell[49369, 1525, 1300, 41, 70, "Input",
 CellID->42362533],
Cell[50672, 1568, 86, 1, 70, "ExampleText",
 CellID->17651317],
Cell[CellGroupData[{
Cell[50783, 1573, 583, 18, 70, "Input",
 CellID->22928806],
Cell[51369, 1593, 6056, 103, 70, "Output",
 Evaluatable->False,
 CellID->131507570]
}, Open  ]],
Cell[57440, 1699, 63, 1, 70, "ExampleText",
 CellID->504412009],
Cell[CellGroupData[{
Cell[57528, 1704, 595, 18, 70, "Input",
 CellID->1050792162],
Cell[58126, 1724, 2676, 48, 70, "Output",
 Evaluatable->False,
 CellID->825947560]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[60851, 1778, 232, 7, 70, "ExampleSection",
 CellID->1367],
Cell[61086, 1787, 74, 1, 70, "ExampleText",
 CellID->182095253],
Cell[CellGroupData[{
Cell[61185, 1792, 381, 12, 70, "Input",
 CellID->493765924],
Cell[61569, 1806, 336, 11, 36, "Output",
 CellID->62760353]
}, Open  ]],
Cell[61920, 1820, 246, 8, 70, "ExampleText",
 CellID->505999971],
Cell[CellGroupData[{
Cell[62191, 1832, 106, 3, 70, "Input",
 CellID->68594752],
Cell[62300, 1837, 203, 7, 36, "Output",
 CellID->803278641]
}, Open  ]],
Cell[62518, 1847, 124, 3, 70, "ExampleDelimiter",
 CellID->27094000],
Cell[62645, 1852, 74, 1, 70, "ExampleText",
 CellID->28603597],
Cell[CellGroupData[{
Cell[62744, 1857, 356, 13, 70, "Input",
 CellID->798905],
Cell[63103, 1872, 453, 8, 70, "Message",
 CellID->814679974],
Cell[63559, 1882, 917, 33, 81, "Output",
 CellID->476383133]
}, Open  ]],
Cell[64491, 1918, 125, 3, 70, "ExampleDelimiter",
 CellID->187645606],
Cell[64619, 1923, 53, 1, 70, "ExampleText",
 CellID->230428239],
Cell[CellGroupData[{
Cell[64697, 1928, 194, 6, 70, "Input",
 CellID->128430086],
Cell[64894, 1936, 679, 25, 70, "Output",
 CellID->109701586]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[65622, 1967, 226, 7, 70, "ExampleSection",
 CellID->14016],
Cell[65851, 1976, 118, 3, 70, "ExampleText",
 CellID->291661378],
Cell[CellGroupData[{
Cell[65994, 1983, 154, 5, 70, "Input",
 CellID->16218361],
Cell[66151, 1990, 240, 7, 36, "Output",
 CellID->106571963]
}, Open  ]],
Cell[CellGroupData[{
Cell[66428, 2002, 213, 8, 70, "Input",
 CellID->46458592],
Cell[66644, 2012, 291, 7, 36, "Output",
 CellID->2313003]
}, Open  ]],
Cell[66950, 2022, 124, 3, 70, "ExampleDelimiter",
 CellID->93508236],
Cell[67077, 2027, 129, 4, 70, "ExampleText",
 CellID->91718301],
Cell[CellGroupData[{
Cell[67231, 2035, 582, 20, 70, "Input",
 CellID->74336280],
Cell[67816, 2057, 614, 21, 39, "Output",
 CellID->284318241]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[68491, 2085, 311, 9, 70, "SeeAlsoSection",
 CellID->20417],
Cell[68805, 2096, 710, 26, 70, "SeeAlso",
 CellID->17095]
}, Open  ]],
Cell[CellGroupData[{
Cell[69552, 2127, 314, 9, 70, "TutorialsSection",
 CellID->22347],
Cell[69869, 2138, 192, 4, 70, "Tutorials",
 CellID->32146]
}, Open  ]],
Cell[CellGroupData[{
Cell[70098, 2147, 319, 9, 70, "MoreAboutSection",
 CellID->994208711],
Cell[70420, 2158, 147, 3, 70, "MoreAbout",
 CellID->308263758]
}, Open  ]],
Cell[70582, 2164, 27, 0, 70, "History"],
Cell[70612, 2166, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

