(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    136665,       3438]
NotebookOptionsPosition[    123998,       3001]
NotebookOutlinePosition[    125730,       3048]
CellTagsIndexPosition[    125592,       3042]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EllipticE" :> Documentation`HelpLookup["paclet:ref/EllipticE"],
           "EllipticF" :> Documentation`HelpLookup["paclet:ref/EllipticF"], 
          "EllipticK" :> Documentation`HelpLookup["paclet:ref/EllipticK"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"EllipticE\"\>", 
       2->"\<\"EllipticF\"\>", 3->"\<\"EllipticK\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals" :> 
          Documentation`HelpLookup["paclet:guide/EllipticIntegrals"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["JacobiZeta", "ObjectName",
 CellID->16342],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["JacobiZeta",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/JacobiZeta"], "[", 
       RowBox[{
        StyleBox["\[Phi]", "TR"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Jacobi zeta function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"Z", "(", 
        RowBox[{"\[Phi]", "\[VerticalSeparator]", "m"}], ")"}], 
       TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11591]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "The Jacobi zeta function is given in terms of elliptic integrals by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Z", "(", 
     RowBox[{"\[Phi]", "\[VerticalSeparator]", "m"}], ")"}], "=", 
    RowBox[{
     RowBox[{"E", "(", 
      RowBox[{"\[Phi]", "\[VerticalSeparator]", "m"}], ")"}], "-", 
     RowBox[{
      RowBox[{"E", "(", "m", ")"}], 
      RowBox[{
       RowBox[{"F", "(", 
        RowBox[{
         RowBox[{"\[Phi]", "\[VerticalSeparator]"}], "m"}], ")"}], "/", 
       RowBox[{"K", "(", "m", ")"}]}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->13516],

Cell[TextData[{
 "Argument conventions for elliptic integrals are discussed in ",
 ButtonBox["Elliptic Integrals and Elliptic Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/EllipticIntegralsAndEllipticFunctions"],
 ". "
}], "Notes",
 CellID->30335],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["JacobiZeta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiZeta"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->81412305],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiZeta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiZeta"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiZeta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiZeta"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1785033],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->418437676],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiZeta", "[", 
  RowBox[{"2", ",", "0.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->959432246],

Cell[BoxData[
 RowBox[{"-", "0.11777235923324855`"}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->725970962]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->731383664],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"JacobiZeta", "[", 
    RowBox[{"z", ",", "0.5"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->238478560],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18510446]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->79153870],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"JacobiZeta", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->170631485],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox[
       RowBox[{"EllipticE", "[", "m", "]"}], 
       RowBox[{"EllipticK", "[", "m", "]"}]]}], ")"}], " ", "z"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["m", "6"]}], "-", 
      FractionBox[
       RowBox[{"m", " ", 
        RowBox[{"EllipticE", "[", "m", "]"}]}], 
       RowBox[{"6", " ", 
        RowBox[{"EllipticK", "[", "m", "]"}]}]]}], ")"}], " ", 
    SuperscriptBox["z", "3"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "5"],
    SeriesData[$CellContext`z, 0, {}, 1, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   1 - EllipticE[$CellContext`m]/EllipticK[$CellContext`m], 0, 
    Rational[-1, 6] $CellContext`m + 
    Rational[-1, 6] $CellContext`m EllipticE[$CellContext`m]/
     EllipticK[$CellContext`m]}, 1, 5, 1],
  Editable->False]], "Output",
 ImageSize->{354, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->223256776]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17189909],

Cell["Evaluate for complex arguments and parameters:", "ExampleText",
 CellID->372998495],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiZeta", "[", 
  RowBox[{
   RowBox[{"2", "+", 
    RowBox[{"3", " ", "I"}]}], ",", 
   RowBox[{"0.8", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->554334279],

Cell[BoxData[
 RowBox[{"8.187364241352167`", "\[InvisibleSpace]", "+", 
  RowBox[{"2.131468363667087`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->60083789]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->765126842],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->323614177],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"JacobiZeta", "[", 
    RowBox[{"2", ",", "3"}], "]"}], ",", "30"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->73868089],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "-", "0.210943789958196804870285060444608977493720266535`29.75252704881831"}\
], "+", 
  RowBox[{
  "0.483396461384815292721547361495735185882115559984`30.112663771156704", 
   " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{484, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21398814]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->169295586],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->318734415],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiZeta", "[", 
  RowBox[{"2", ",", "3.0000000000000000000000"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->797775294],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.21094378995819680487028506044463549053`20.23553284451543"}],
   "+", 
  RowBox[{
  "0.48339646138481529272154736149535159184`20.734090910469742", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{351, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->483901088]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12384622],

Cell["Simple exact results are generated automatically:", "ExampleText",
 CellID->407719598],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiZeta", "[", 
  RowBox[{"z", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28338900],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40292874]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiZeta", "[", 
  RowBox[{
   RowBox[{"Pi", "/", "2"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->455555963],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->30357685]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->448093564],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiZeta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiZeta"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->272327389],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiZeta", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.2", ",", "0.5", ",", "1.8"}], "}"}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->55130512],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.19732226751588172`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.09264330886095298`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.456992352075574`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.25194155472396756`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.10663887600932777`"}], "+", 
    RowBox[{"0.22516785339128437`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{462, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->452130192]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->60034805],

Cell["Series expansion at the origin in the parameter:", "ExampleText",
 CellID->753888311],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"JacobiZeta", "[", 
     RowBox[{"z", ",", "m"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"m", ",", "0", ",", "2"}], "}"}]}], "]"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->702600695],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"2", " ", "z"}], "]"}], " ", "m"}], "+", 
   RowBox[{
    FractionBox["1", "64"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "z"}], "]"}]}], "-", 
      RowBox[{"Sin", "[", 
       RowBox[{"4", " ", "z"}], "]"}]}], ")"}], " ", 
    SuperscriptBox["m", "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "3"],
    SeriesData[$CellContext`m, 0, {}, 1, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 0, {
   Rational[1, 4] Sin[2 $CellContext`z], 
    Rational[1, 64] (4 Sin[2 $CellContext`z] - Sin[4 $CellContext`z])}, 1, 3, 
   1],
  Editable->False]], "Output",
 ImageSize->{317, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->534138530]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->40126218],

Cell["Find series expansions at branch points and branch cuts:", "ExampleText",
 CellID->97742251],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"JacobiZeta", "[", 
     RowBox[{"z", ",", "m"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"m", ",", "1", ",", "0"}], "}"}]}], "]"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->474678262],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{555, 315},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->310969311]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->158062656],

Cell["Find limits at branch cuts:", "ExampleText",
 CellID->270618372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"JacobiZeta", "[", 
    RowBox[{
     RowBox[{"2", "+", 
      RowBox[{"\[CurlyEpsilon]", " ", "I"}]}], ",", "2"}], "]"}], ",", 
   RowBox[{"\[CurlyEpsilon]", "->", "0"}], ",", 
   RowBox[{"Direction", "->", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->470560910],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"EllipticK", "[", "2", "]"}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"EllipticE", "[", "2", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"EllipticF", "[", 
        RowBox[{"2", ",", "2"}], "]"}], "+", 
       RowBox[{
        SqrtBox["2"], " ", 
        RowBox[{"EllipticK", "[", 
         FractionBox["1", "2"], "]"}]}]}], ")"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        SqrtBox["2"], " ", 
        RowBox[{"EllipticE", "[", 
         FractionBox["1", "2"], "]"}]}], "+", 
       RowBox[{"EllipticE", "[", 
        RowBox[{"2", ",", "2"}], "]"}], "-", 
       RowBox[{
        SqrtBox["2"], " ", 
        RowBox[{"EllipticK", "[", 
         FractionBox["1", "2"], "]"}]}]}], ")"}], " ", 
     RowBox[{"EllipticK", "[", "2", "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{501, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->225108730]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"JacobiZeta", "[", 
    RowBox[{
     RowBox[{"2", "+", 
      RowBox[{"\[CurlyEpsilon]", " ", "I"}]}], ",", "2"}], "]"}], ",", 
   RowBox[{"\[CurlyEpsilon]", "->", "0"}], ",", 
   RowBox[{"Direction", "->", 
    RowBox[{"-", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->104764587],

Cell[BoxData[
 RowBox[{
  RowBox[{"EllipticE", "[", 
   RowBox[{"2", ",", "2"}], "]"}], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"EllipticE", "[", "2", "]"}], " ", 
    RowBox[{"EllipticF", "[", 
     RowBox[{"2", ",", "2"}], "]"}]}], 
   RowBox[{"EllipticK", "[", "2", "]"}]]}]], "Output",
 ImageSize->{313, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->304821584]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->37488419],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->375716569],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"JacobiZeta", "[", 
   RowBox[{"z", ",", "m"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2435037],

Cell[BoxData[
 FormBox[
  RowBox[{"\[CapitalZeta]", "(", 
   RowBox[{"z", "\[VerticalSeparator]", "m"}], ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->839750240]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->75536765],

Cell["Infinite arguments give symbolic results:", "ExampleText",
 CellID->386075714],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiZeta", "[", 
  RowBox[{"z", ",", "Infinity"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->340696178],

Cell[BoxData["ComplexInfinity"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->111360423]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16207486],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiZeta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiZeta"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellID->324857562],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiZeta", "[", 
  RowBox[{"z", ",", 
   RowBox[{"m", "+", 
    FractionBox[
     SuperscriptBox["m", "2"], "2"], "+", 
    FractionBox[
     SuperscriptBox["m", "3"], "3"], "+", 
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "4"]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->324972472],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{468, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->664263373]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->34714565],

Cell[TextData[{
 "Plot of the real part of ",
 Cell[BoxData[
  ButtonBox["JacobiZeta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiZeta"]], "InlineFormula"],
 " over the complex plane: "
}], "ExampleText",
 CellID->122087082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"JacobiZeta", "[", 
     RowBox[{
      RowBox[{"x", "+", 
       RowBox[{"I", " ", "y"}]}], ",", "0.3"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", " ", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->78219954],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{213, 179},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->354936836]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->598000115],

Cell["\<\
Supersymmetric zero\[Hyphen]energy solution of the Schr\[ODoubleDot]dinger \
equation in a periodic potential: \
\>", "ExampleText",
 CellID->300028062],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"w", "[", "x_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"m", "^", "2"}], 
     RowBox[{
      RowBox[{"JacobiSN", "[", 
       RowBox[{"x", ",", "m"}], "]"}], "^", "2"}], 
     RowBox[{
      RowBox[{"JacobiCD", "[", 
       RowBox[{"x", ",", "m"}], "]"}], "^", "2"}]}], "-", 
    RowBox[{"(", 
     RowBox[{"2", "-", "m", "-", 
      RowBox[{"2", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"EllipticE", "[", "m", "]"}], "/", 
         RowBox[{"EllipticK", "[", "m", "]"}]}], ")"}]}]}], ")"}]}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49365648],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"v", "[", "x_", "]"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"w", "[", "x", "]"}], "^", "2"}], "+", 
     RowBox[{
      RowBox[{"w", "'"}], "[", "x", "]"}]}]}], ";"}], "  "}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10350991],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Psi]0", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"m", " ", 
      RowBox[{"JacobiCD", "[", 
       RowBox[{"x", ",", "m"}], "]"}], " ", 
      RowBox[{"JacobiSN", "[", 
       RowBox[{"x", ",", "m"}], "]"}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"JacobiZeta", "[", 
       RowBox[{
        RowBox[{"JacobiAmplitude", "[", 
         RowBox[{"x", ",", "m"}], "]"}], ",", "m"}], "]"}]}]}], "]"}], "/", 
   "10"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->161058727],

Cell["\<\
Check the Schr\[ODoubleDot]dinger equation: \
\>", "ExampleText",
 CellID->538267423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"\[Psi]0", "[", "x", "]"}], ",", "x", ",", "x"}], "]"}]}], "+",
     
    RowBox[{
     RowBox[{"v", "[", "x", "]"}], " ", 
     RowBox[{"\[Psi]0", "[", "x", "]"}]}]}], "/.", 
   RowBox[{"m", "->", 
    RowBox[{"1", "/", "3"}]}]}], "/.", 
  RowBox[{"x", "->", "2``100"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->931223572],

Cell[BoxData["0``98.87973717927018"], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->810841298]
}, Open  ]],

Cell["\<\
Plot the superpotential, the potential, and the wave function: \
\>", "ExampleText",
 CellID->68706843],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", " ", 
      RowBox[{
       RowBox[{"w", "[", "x", "]"}], ",", 
       RowBox[{"v", "[", "x", "]"}], ",", 
       RowBox[{"\[Psi]0", "[", "x", "]"}]}], "}"}], "/.", 
     RowBox[{"m", "->", "0.8"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->123744241],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 128},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->558938195]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->277188052],

Cell["Define a conformal map: ", "ExampleText",
 CellID->256731006],

Cell[BoxData[
 RowBox[{
  RowBox[{"z", "[", 
   RowBox[{"w_", ",", "m_"}], "]"}], ":=", " ", 
  RowBox[{
   RowBox[{"JacobiZeta", "[", 
    RowBox[{
     RowBox[{"JacobiAmplitude", "[", 
      RowBox[{"w", ",", "m"}], "]"}], ",", "m"}], "]"}], "+", 
   RowBox[{"w", " ", 
    RowBox[{"Pi", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"EllipticK", "[", "m", "]"}], " ", 
       RowBox[{"EllipticK", "[", 
        RowBox[{"1", "-", "m"}], "]"}]}], ")"}]}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->136263380],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Re", "[", "#", "]"}], ",", 
       RowBox[{"Im", "[", "#", "]"}]}], "}"}], "&"}], "[", 
    RowBox[{"z", "[", 
     RowBox[{
      RowBox[{"u", "+", 
       RowBox[{"I", " ", "v"}]}], ",", "0.4"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0.01", ",", 
     RowBox[{"EllipticK", "[", "0.39", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0.01", ",", 
     RowBox[{"EllipticK", "[", "0.59", "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->85829649],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{247, 210},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->166302876]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->593563728],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " to express ",
 Cell[BoxData[
  ButtonBox["JacobiZeta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiZeta"]], "InlineFormula"],
 " in terms of incomplete elliptic integrals:"
}], "ExampleText",
 CellID->99476291],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"JacobiZeta", "[", 
   RowBox[{"z", ",", "m"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->651765088],

Cell[BoxData[
 RowBox[{
  RowBox[{"EllipticE", "[", 
   RowBox[{"z", ",", "m"}], "]"}], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"EllipticE", "[", "m", "]"}], " ", 
    RowBox[{"EllipticF", "[", 
     RowBox[{"z", ",", "m"}], "]"}]}], 
   RowBox[{"EllipticK", "[", "m", "]"}]]}]], "Output",
 ImageSize->{313, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->36554247]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->269574926],

Cell["Expand special cases:", "ExampleText",
 CellID->462014322],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiZeta", "[", 
    RowBox[{"z", ",", "1"}], "]"}], " ", ",", 
   RowBox[{"JacobiZeta", "[", 
    RowBox[{"z", ",", "1"}], "]"}], " ", ",", 
   RowBox[{"JacobiZeta", "[", 
    RowBox[{
     RowBox[{"ArcCsc", "[", 
      RowBox[{"Sqrt", "[", "m", "]"}], "]"}], ",", "m"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31650150],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiZeta", "[", 
    RowBox[{"z", ",", "1"}], "]"}], ",", 
   RowBox[{"JacobiZeta", "[", 
    RowBox[{"z", ",", "1"}], "]"}], ",", 
   RowBox[{"JacobiZeta", "[", 
    RowBox[{
     RowBox[{"ArcCsc", "[", 
      SqrtBox["m"], "]"}], ",", "m"}], "]"}]}], "}"}]], "Output",
 ImageSize->{441, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->423960410]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->67239524],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"EllipticE", "[", 
    RowBox[{"z", ",", "1"}], "]"}], ",", 
   RowBox[{"EllipticE", "[", 
    RowBox[{"z", ",", "1"}], "]"}], ",", 
   RowBox[{
    RowBox[{
     SqrtBox["m"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"EllipticE", "[", 
        FractionBox["1", "m"], "]"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          FractionBox["1", "m"]}], ")"}], " ", 
        RowBox[{"EllipticK", "[", 
         FractionBox["1", "m"], "]"}]}]}], ")"}]}], "-", 
    FractionBox[
     RowBox[{
      RowBox[{"EllipticE", "[", "m", "]"}], " ", 
      RowBox[{"EllipticK", "[", 
       FractionBox["1", "m"], "]"}]}], 
     RowBox[{
      SqrtBox["m"], " ", 
      RowBox[{"EllipticK", "[", "m", "]"}]}]]}]}], "}"}]], "Output",
 ImageSize->{495, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->249856244]
}, Open  ]],

Cell["Some special cases require argument restrictions:", "ExampleText",
 CellID->19197208],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"JacobiZeta", "[", 
   RowBox[{"z", ",", "1"}], "]"}], " "}]], "Input",
 CellLabel->"In[3]:=",
 CellID->381510624],

Cell[BoxData[
 RowBox[{"JacobiZeta", "[", 
  RowBox[{"z", ",", "1"}], "]"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->38985775]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->151153183],

Cell[BoxData[
 RowBox[{"EllipticE", "[", 
  RowBox[{"z", ",", "1"}], "]"}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->229956382]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"%", ",", " ", 
   RowBox[{"0", "<", "z", "<", 
    RowBox[{"Pi", "/", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->449191556],

Cell[BoxData[
 RowBox[{"Sin", "[", "z", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->46996875]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->194034239],

Cell["Numerically find a root of a transcendental equation:", "ExampleText",
 CellID->382665562],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"JacobiZeta", "[", 
       RowBox[{"z", ",", "2"}], "]"}], "3"], "+", 
     RowBox[{"JacobiZeta", "[", 
      RowBox[{"z", ",", "2"}], "]"}], "+", "z"}], "\[Equal]", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", "I"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9101994],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", 
   RowBox[{
    RowBox[{"-", "0.3847324015751319`"}], "+", 
    RowBox[{"1.1319901822621385`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{178, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->90381094]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->477291001],

Cell["\<\
Machine-precision input is insufficient to give a correct answer:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->118174822],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiZeta", "[", 
  RowBox[{
   RowBox[{"10.", "^", "20"}], ",", "Pi"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->457566305],

Cell[BoxData[
 RowBox[{"0.`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->43841738]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"JacobiZeta", "[", 
    RowBox[{
     RowBox[{"10", "^", "20"}], ",", "Pi"}], "]"}], ",", "20"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->867520818],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.54007386095491888680905266929202995929`19.91397965446237"}],
   "+", 
  RowBox[{
  "0.75844327063651577623773356304642531402`20.06144959846556", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{344, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->671987966]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->194449374],

Cell[TextData[{
 "A larger setting for ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " can be needed:"
}], "ExampleText",
 CellID->313170659],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"JacobiZeta", "[", 
    RowBox[{
     RowBox[{"10", "^", "50"}], ",", "Pi"}], "]"}], ",", "20"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->168822062],

Cell[BoxData[
 RowBox[{
  RowBox[{"Divide", "::", "\<\"indet\"\>"}], ":", 
  " ", "\<\"Indeterminate expression \\!\\(0``0\\/0``0\\) encountered. \\!\\(\
\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/indet\\\", \
ButtonNote -> \\\"Divide::indet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->87559414],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \
\\!\\(JacobiZeta[\\(\\(100000000000000000000000000000000000000000000000000, \
\[Pi]\\)\\)]\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/meprec\\\", ButtonNote -> \
\\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->191765068],

Cell[BoxData[
 RowBox[{"0.35284762560178819709589519512`18.184287437035575", "-", 
  RowBox[{
  "0.68683187743793214994619914177`18.66651924056011", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{308, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38465561]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "100"}], "}"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"JacobiZeta", "[", 
      RowBox[{
       RowBox[{"10", "^", "50"}], ",", "Pi"}], "]"}], ",", "20"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->77012200],

Cell[BoxData[
 RowBox[{
  RowBox[{"Divide", "::", "\<\"indet\"\>"}], ":", 
  " ", "\<\"Indeterminate expression \\!\\(0``0\\/0``0\\) encountered. \\!\\(\
\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/indet\\\", \
ButtonNote -> \\\"Divide::indet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->473922634],

Cell[BoxData[
 RowBox[{"0.35284762560178819709589519507811931712`19.810391834317148", "-", 
  RowBox[{
  "0.68683187743793214994619914177795120565`20.099655078567856", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{336, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->330283225]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->632971069],

Cell[TextData[{
 "The alternative definition ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[CapitalZeta]", "(", 
     RowBox[{"z", "\[VerticalSeparator]", "m"}], ")"}], "=", 
    RowBox[{
     RowBox[{"E", "(", 
      RowBox[{"z", "\[VerticalSeparator]", "m"}], ")"}], "-", 
     RowBox[{"z", " ", 
      RowBox[{
       RowBox[{"E", "(", "m", ")"}], "/", 
       RowBox[{"K", "(", "m", ")"}]}]}]}]}], TraditionalForm]], "InlineMath",
  GeneratedCell->False,
  CellAutoOverwrite->False],
 " requires ",
 Cell[BoxData[
  ButtonBox["JacobiAmplitude",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiAmplitude"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->349957946],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"JacobiZeta", "[", 
    RowBox[{
     RowBox[{"JacobiAmplitude", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], "\[Equal]", 
   RowBox[{
    RowBox[{"EllipticE", "[", 
     RowBox[{
      RowBox[{"JacobiAmplitude", "[", 
       RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], "-", 
    RowBox[{"z", " ", 
     RowBox[{
      RowBox[{"EllipticE", "[", "m", "]"}], "/", 
      RowBox[{"EllipticK", "[", "m", "]"}]}]}]}]}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"z", "->", "2"}], ",", 
    RowBox[{"m", "\[Rule]", 
     RowBox[{"N", "[", 
      RowBox[{
       RowBox[{"1", "/", "3"}], ",", "100"}], "]"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->48895106],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->659886838]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the following definition:"
}], "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->171153650],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"JacobiZeta", "[", 
    RowBox[{"z", ",", "m"}], "]"}], "\[Equal]", 
   RowBox[{
    RowBox[{"EllipticE", "[", 
     RowBox[{"z", ",", "m"}], "]"}], "-", 
    RowBox[{
     RowBox[{"EllipticF", "[", 
      RowBox[{"z", ",", "m"}], "]"}], " ", 
     RowBox[{
      RowBox[{"EllipticE", "[", "m", "]"}], " ", "/", 
      RowBox[{"EllipticK", "[", "m", "]"}]}]}]}]}], " ", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"z", "->", "2"}], ",", 
    RowBox[{"m", "->", 
     RowBox[{"N", "[", 
      RowBox[{
       RowBox[{"1", "/", "3"}], ",", "100"}], "]"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->113599240],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->169338714]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->210013028],

Cell["In traditional form the vertical separator must be used:", "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->477012697],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"\[CapitalZeta]", "(", 
   RowBox[{"z", "\[VerticalSeparator]", "m"}], ")"}], 
  TraditionalForm]], "Input",
 CellLabel->"In[1]:=",
 CellID->149089388],

Cell[BoxData[
 RowBox[{"JacobiZeta", "[", 
  RowBox[{"z", ",", "m"}], "]"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->88279287]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31518],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipticE",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticE"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipticF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticF"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipticK",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticK"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14718]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7214],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->6079]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->6246],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/JacobiZetaFunction.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/EllipticIntegrals/JacobiZeta/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->159698262],

Cell[TextData[ButtonBox["Elliptic Integrals",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticIntegrals"]], "MoreAbout",
 CellID->301200198]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"JacobiZeta - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 51, 41.7005484}", "context" -> "System`", 
    "keywords" -> {"Jacobi zeta", "Jacobi zeta function", "zeta function"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "JacobiZeta[\\[Phi], m] gives the Jacobi zeta function Z(\\[Phi] \
\\[VerticalSeparator] m). ", "synonyms" -> {"jacobi zeta"}, "title" -> 
    "JacobiZeta", "type" -> "Symbol", "uri" -> "ref/JacobiZeta"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5633, 192, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1785033]},
 "XRef-2005-4-26-23-37-1.8558342"->{
  Cell[117611, 2755, 733, 24, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342",
   CellID->349957946],
  Cell[119290, 2817, 183, 6, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342",
   CellID->171153650],
  Cell[120473, 2864, 144, 2, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342",
   CellID->477012697]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 125058, 3025},
 {"XRef-2005-4-26-23-37-1.8558342", 125213, 3029}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1996, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2619, 76, 48, 1, 70, "ObjectName",
 CellID->16342],
Cell[2670, 79, 713, 23, 70, "Usage",
 CellID->11591]
}, Open  ]],
Cell[CellGroupData[{
Cell[3420, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3898, 124, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4021, 130, 620, 20, 70, "Notes",
 CellID->13516],
Cell[4644, 152, 265, 7, 70, "Notes",
 CellID->30335],
Cell[4912, 161, 251, 8, 70, "Notes",
 CellID->81412305],
Cell[5166, 171, 222, 7, 70, "Notes",
 CellID->31226],
Cell[5391, 180, 205, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[5633, 192, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1785033],
Cell[CellGroupData[{
Cell[6016, 206, 148, 5, 70, "ExampleSection",
 CellID->418437676],
Cell[CellGroupData[{
Cell[6189, 215, 131, 4, 28, "Input",
 CellID->959432246],
Cell[6323, 221, 194, 6, 36, "Output",
 CellID->725970962]
}, Open  ]],
Cell[6532, 230, 125, 3, 70, "ExampleDelimiter",
 CellID->731383664],
Cell[CellGroupData[{
Cell[6682, 237, 268, 9, 28, "Input",
 CellID->238478560],
Cell[6953, 248, 5169, 89, 170, "Output",
 Evaluatable->False,
 CellID->18510446]
}, Open  ]],
Cell[12137, 340, 124, 3, 70, "ExampleDelimiter",
 CellID->79153870],
Cell[CellGroupData[{
Cell[12286, 347, 247, 8, 70, "Input",
 CellID->170631485],
Cell[12536, 357, 1118, 35, 53, "Output",
 CellID->223256776]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13703, 398, 219, 7, 70, "ExampleSection",
 CellID->17189909],
Cell[13925, 407, 89, 1, 70, "ExampleText",
 CellID->372998495],
Cell[CellGroupData[{
Cell[14039, 412, 199, 7, 70, "Input",
 CellID->554334279],
Cell[14241, 421, 270, 7, 36, "Output",
 CellID->60083789]
}, Open  ]],
Cell[14526, 431, 125, 3, 70, "ExampleDelimiter",
 CellID->765126842],
Cell[14654, 436, 70, 1, 70, "ExampleText",
 CellID->323614177],
Cell[CellGroupData[{
Cell[14749, 441, 183, 6, 70, "Input",
 CellID->73868089],
Cell[14935, 449, 380, 12, 36, "Output",
 CellID->21398814]
}, Open  ]],
Cell[15330, 464, 125, 3, 70, "ExampleDelimiter",
 CellID->169295586],
Cell[15458, 469, 113, 3, 70, "ExampleText",
 CellID->318734415],
Cell[CellGroupData[{
Cell[15596, 476, 152, 4, 70, "Input",
 CellID->797775294],
Cell[15751, 482, 359, 11, 36, "Output",
 CellID->483901088]
}, Open  ]],
Cell[16125, 496, 124, 3, 70, "ExampleDelimiter",
 CellID->12384622],
Cell[16252, 501, 92, 1, 70, "ExampleText",
 CellID->407719598],
Cell[CellGroupData[{
Cell[16369, 506, 128, 4, 70, "Input",
 CellID->28338900],
Cell[16500, 512, 157, 5, 36, "Output",
 CellID->40292874]
}, Open  ]],
Cell[CellGroupData[{
Cell[16694, 522, 154, 5, 70, "Input",
 CellID->455555963],
Cell[16851, 529, 157, 5, 36, "Output",
 CellID->30357685]
}, Open  ]],
Cell[17023, 537, 125, 3, 70, "ExampleDelimiter",
 CellID->448093564],
Cell[17151, 542, 214, 7, 70, "ExampleText",
 CellID->272327389],
Cell[CellGroupData[{
Cell[17390, 553, 196, 7, 70, "Input",
 CellID->55130512],
Cell[17589, 562, 574, 15, 36, "Output",
 CellID->452130192]
}, Open  ]],
Cell[18178, 580, 124, 3, 70, "ExampleDelimiter",
 CellID->60034805],
Cell[18305, 585, 91, 1, 70, "ExampleText",
 CellID->753888311],
Cell[CellGroupData[{
Cell[18421, 590, 270, 9, 70, "Input",
 CellID->702600695],
Cell[18694, 601, 946, 31, 51, "Output",
 CellID->534138530]
}, Open  ]],
Cell[19655, 635, 124, 3, 70, "ExampleDelimiter",
 CellID->40126218],
Cell[19782, 640, 98, 1, 70, "ExampleText",
 CellID->97742251],
Cell[CellGroupData[{
Cell[19905, 645, 270, 9, 70, "Input",
 CellID->474678262],
Cell[20178, 656, 9903, 166, 70, "Output",
 Evaluatable->False,
 CellID->310969311]
}, Open  ]],
Cell[30096, 825, 125, 3, 70, "ExampleDelimiter",
 CellID->158062656],
Cell[30224, 830, 70, 1, 70, "ExampleText",
 CellID->270618372],
Cell[CellGroupData[{
Cell[30319, 835, 336, 10, 70, "Input",
 CellID->470560910],
Cell[30658, 847, 1023, 34, 83, "Output",
 CellID->225108730]
}, Open  ]],
Cell[CellGroupData[{
Cell[31718, 886, 356, 11, 70, "Input",
 CellID->104764587],
Cell[32077, 899, 425, 14, 53, "Output",
 CellID->304821584]
}, Open  ]],
Cell[32517, 916, 124, 3, 70, "ExampleDelimiter",
 CellID->37488419],
Cell[32644, 921, 203, 7, 70, "ExampleText",
 CellID->375716569],
Cell[CellGroupData[{
Cell[32872, 932, 166, 5, 70, "Input",
 CellID->2435037],
Cell[33041, 939, 290, 9, 50, "Output",
 CellID->839750240]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[33380, 954, 242, 7, 70, "ExampleSection",
 CellID->75536765],
Cell[33625, 963, 84, 1, 70, "ExampleText",
 CellID->386075714],
Cell[CellGroupData[{
Cell[33734, 968, 136, 4, 70, "Input",
 CellID->340696178],
Cell[33873, 974, 173, 5, 36, "Output",
 CellID->111360423]
}, Open  ]],
Cell[34061, 982, 124, 3, 70, "ExampleDelimiter",
 CellID->16207486],
Cell[34188, 987, 215, 7, 70, "ExampleText",
 CellID->324857562],
Cell[CellGroupData[{
Cell[34428, 998, 330, 11, 70, "Input",
 CellID->324972472],
Cell[34761, 1011, 2635, 47, 70, "Output",
 Evaluatable->False,
 CellID->664263373]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[37445, 1064, 226, 7, 70, "ExampleSection",
 CellID->34714565],
Cell[37674, 1073, 236, 8, 70, "ExampleText",
 CellID->122087082],
Cell[CellGroupData[{
Cell[37935, 1085, 451, 15, 70, "Input",
 CellID->78219954],
Cell[38389, 1102, 39041, 644, 70, "Output",
 Evaluatable->False,
 CellID->354936836]
}, Open  ]],
Cell[77445, 1749, 125, 3, 70, "ExampleDelimiter",
 CellID->598000115],
Cell[77573, 1754, 162, 4, 70, "ExampleText",
 CellID->300028062],
Cell[77738, 1760, 630, 22, 70, "Input",
 CellID->49365648],
Cell[78371, 1784, 296, 11, 70, "Input",
 CellID->10350991],
Cell[78670, 1797, 555, 18, 70, "Input",
 CellID->161058727],
Cell[79228, 1817, 95, 3, 70, "ExampleText",
 CellID->538267423],
Cell[CellGroupData[{
Cell[79348, 1824, 445, 16, 70, "Input",
 CellID->931223572],
Cell[79796, 1842, 177, 5, 36, "Output",
 CellID->810841298]
}, Open  ]],
Cell[79988, 1850, 113, 3, 70, "ExampleText",
 CellID->68706843],
Cell[CellGroupData[{
Cell[80126, 1857, 446, 14, 70, "Input",
 CellID->123744241],
Cell[80575, 1873, 6077, 104, 70, "Output",
 Evaluatable->False,
 CellID->558938195]
}, Open  ]],
Cell[86667, 1980, 125, 3, 70, "ExampleDelimiter",
 CellID->277188052],
Cell[86795, 1985, 67, 1, 70, "ExampleText",
 CellID->256731006],
Cell[86865, 1988, 524, 17, 70, "Input",
 CellID->136263380],
Cell[CellGroupData[{
Cell[87414, 2009, 633, 20, 70, "Input",
 CellID->85829649],
Cell[88050, 2031, 19098, 317, 70, "Output",
 Evaluatable->False,
 CellID->166302876]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[107197, 2354, 237, 7, 70, "ExampleSection",
 CellID->593563728],
Cell[107437, 2363, 380, 13, 70, "ExampleText",
 CellID->99476291],
Cell[CellGroupData[{
Cell[107842, 2380, 171, 5, 70, "Input",
 CellID->651765088],
Cell[108016, 2387, 424, 14, 53, "Output",
 CellID->36554247]
}, Open  ]],
Cell[108455, 2404, 125, 3, 70, "ExampleDelimiter",
 CellID->269574926],
Cell[108583, 2409, 64, 1, 70, "ExampleText",
 CellID->462014322],
Cell[CellGroupData[{
Cell[108672, 2414, 397, 13, 70, "Input",
 CellID->31650150],
Cell[109072, 2429, 455, 15, 43, "Output",
 CellID->423960410]
}, Open  ]],
Cell[CellGroupData[{
Cell[109564, 2449, 109, 3, 70, "Input",
 CellID->67239524],
Cell[109676, 2454, 972, 33, 86, "Output",
 CellID->249856244]
}, Open  ]],
Cell[110663, 2490, 91, 1, 70, "ExampleText",
 CellID->19197208],
Cell[CellGroupData[{
Cell[110779, 2495, 148, 5, 70, "Input",
 CellID->381510624],
Cell[110930, 2502, 217, 7, 36, "Output",
 CellID->38985775]
}, Open  ]],
Cell[CellGroupData[{
Cell[111184, 2514, 110, 3, 70, "Input",
 CellID->151153183],
Cell[111297, 2519, 217, 7, 36, "Output",
 CellID->229956382]
}, Open  ]],
Cell[CellGroupData[{
Cell[111551, 2531, 198, 6, 70, "Input",
 CellID->449191556],
Cell[111752, 2539, 186, 6, 36, "Output",
 CellID->46996875]
}, Open  ]],
Cell[111953, 2548, 125, 3, 70, "ExampleDelimiter",
 CellID->194034239],
Cell[112081, 2553, 96, 1, 70, "ExampleText",
 CellID->382665562],
Cell[CellGroupData[{
Cell[112202, 2558, 408, 13, 70, "Input",
 CellID->9101994],
Cell[112613, 2573, 329, 11, 36, "Output",
 CellID->90381094]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[112991, 2590, 230, 7, 70, "ExampleSection",
 CellID->477291001],
Cell[113224, 2599, 253, 7, 70, "ExampleText",
 CellID->118174822],
Cell[CellGroupData[{
Cell[113502, 2610, 157, 5, 70, "Input",
 CellID->457566305],
Cell[113662, 2617, 239, 7, 36, "Output",
 CellID->43841738]
}, Open  ]],
Cell[CellGroupData[{
Cell[113938, 2629, 216, 8, 70, "Input",
 CellID->867520818],
Cell[114157, 2639, 358, 11, 36, "Output",
 CellID->671987966]
}, Open  ]],
Cell[114530, 2653, 125, 3, 70, "ExampleDelimiter",
 CellID->194449374],
Cell[114658, 2658, 246, 8, 70, "ExampleText",
 CellID->313170659],
Cell[CellGroupData[{
Cell[114929, 2670, 216, 8, 70, "Input",
 CellID->168822062],
Cell[115148, 2680, 382, 7, 70, "Message",
 CellID->87559414],
Cell[115533, 2689, 501, 10, 70, "Message",
 CellID->191765068],
Cell[116037, 2701, 319, 9, 36, "Output",
 CellID->38465561]
}, Open  ]],
Cell[CellGroupData[{
Cell[116393, 2715, 347, 12, 70, "Input",
 CellID->77012200],
Cell[116743, 2729, 383, 7, 70, "Message",
 CellID->473922634],
Cell[117129, 2738, 339, 9, 36, "Output",
 CellID->330283225]
}, Open  ]],
Cell[117483, 2750, 125, 3, 70, "ExampleDelimiter",
 CellID->632971069],
Cell[117611, 2755, 733, 24, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->349957946],
Cell[CellGroupData[{
Cell[118369, 2783, 742, 24, 70, "Input",
 CellID->48895106],
Cell[119114, 2809, 161, 5, 36, "Output",
 CellID->659886838]
}, Open  ]],
Cell[119290, 2817, 183, 6, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->171153650],
Cell[CellGroupData[{
Cell[119498, 2827, 668, 22, 70, "Input",
 CellID->113599240],
Cell[120169, 2851, 161, 5, 36, "Output",
 CellID->169338714]
}, Open  ]],
Cell[120345, 2859, 125, 3, 70, "ExampleDelimiter",
 CellID->210013028],
Cell[120473, 2864, 144, 2, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->477012697],
Cell[CellGroupData[{
Cell[120642, 2870, 185, 6, 70, "Input",
 CellID->149089388],
Cell[120830, 2878, 217, 7, 36, "Output",
 CellID->88279287]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[121108, 2892, 311, 9, 70, "SeeAlsoSection",
 CellID->31518],
Cell[121422, 2903, 702, 26, 70, "SeeAlso",
 CellID->14718]
}, Open  ]],
Cell[CellGroupData[{
Cell[122161, 2934, 313, 9, 70, "TutorialsSection",
 CellID->7214],
Cell[122477, 2945, 191, 4, 70, "Tutorials",
 CellID->6079]
}, Open  ]],
Cell[CellGroupData[{
Cell[122705, 2954, 320, 9, 70, "RelatedLinksSection",
 CellID->6246],
Cell[123028, 2965, 189, 4, 70, "RelatedLinks"],
Cell[123220, 2971, 200, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[123457, 2980, 319, 9, 70, "MoreAboutSection",
 CellID->159698262],
Cell[123779, 2991, 147, 3, 70, "MoreAbout",
 CellID->301200198]
}, Open  ]],
Cell[123941, 2997, 27, 0, 70, "History"],
Cell[123971, 2999, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

