(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     64496,       2162]
NotebookOptionsPosition[     54828,       1822]
NotebookOutlinePosition[     56320,       1862]
CellTagsIndexPosition[     56234,       1857]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Advanced Matrix Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AdvancedMatrixOperations"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Advanced Matrix Operations\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Eigensystem" :> 
          Documentation`HelpLookup["paclet:ref/Eigensystem"], 
          "SingularValueDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/SingularValueDecomposition"], 
          "QRDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/QRDecomposition"], 
          "SchurDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/SchurDecomposition"], 
          "MatrixExp" :> Documentation`HelpLookup["paclet:ref/MatrixExp"], 
          "Minors" :> Documentation`HelpLookup["paclet:ref/Minors"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Eigensystem\"\>", 
       2->"\<\"SingularValueDecomposition\"\>", 3->"\<\"QRDecomposition\"\>", 
       4->"\<\"SchurDecomposition\"\>", 5->"\<\"MatrixExp\"\>", 
       6->"\<\"Minors\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Matrix Decompositions" :> 
          Documentation`HelpLookup["paclet:guide/MatrixDecompositions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Matrix Decompositions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["JordanDecomposition", "ObjectName",
 CellID->30899],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["JordanDecomposition",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/JordanDecomposition"], "[", 
       StyleBox["m", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields the Jordan decomposition of a square matrix ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     ". The result is a list ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["s", "TI"], ",", 
        StyleBox["j", "TI"]}], "}"}]], "InlineFormula"],
     " where ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " is a similarity matrix and ",
     Cell[BoxData[
      StyleBox["j", "TI"]], "InlineFormula"],
     " is the Jordan canonical form of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17496]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The original matrix ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is equal to ",
 Cell[BoxData[
  RowBox[{"s", ".", "j", ".", 
   RowBox[{
    ButtonBox["Inverse",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Inverse"], "[", "s", "]"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->1644],

Cell[TextData[{
 "The matrix ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " can be either numerical or symbolic. "
}], "Notes",
 CellID->15452]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->655100676],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->265291295],

Cell["\<\
Find the Jordan decomposition of a 3\[Times]3 matrix:\
\>", "ExampleText",
 CellID->374879823],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JordanDecomposition", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"27", ",", "48", ",", "81"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "6"}], ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "3"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->156054371],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "18", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", 
        FractionBox["1", "4"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "12", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "12"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{495, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->271212465]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"MatrixForm", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->204734845],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWTtPG0EQPt/5wBiDX5CH0pAo/4AmRUi6RIqUXxBSWCgSFFESQkFHSUlJ
SemSBsklpUuXlJSUlJSbmX3crj/G9p0fFEHy7e3t7Mw3j92dHb52jvZ//Owc
Hex1tj4fdn7vH+z93fr065A+JaUoiq7ot/0iondFb/p3pRS14bPGz+Ti4kLp
vyimR0qkLdu2qU1sP0pOTk4s3a6evaq/3tzc9Ho9fk11nyUZKj0rzfp6TjTi
a9MhGQwGKOH8/NwSooS21B/B++Hh4fj42POuuq+GfbQEvDbya5Ocnp4SI379
lvGO+/3+MvDYhH5zDE8yKpk2kxxY4Z1DbhxnrGT1Iaq7uztJn2fQb4yR7X3a
dFgs17IyEVFTPjKYiYscI5UixdJXA2w+fhBbkUhpgfYG4dnZmSVJxFlV8SvG
TyxSGbS3t7c2UmSdODZjot60ltkI2tB7dd2nML++vnYWnRZvAv0K2GJFRPoF
+nU3y8bwLIjK0F+eARGtqpDrlIhwzzDe7Ha7NkKfHhFGv0FI4UA7RlFEvj8L
Ijnu2XcxwZLjfRIe1ircKVgmrw/3vTLEvWxHywWlvLdckoB79GhdINcPFsNK
Tu4YQ3EuKR9hvLJQaTv0KC9cp51gPIuvhUljP8WClBjm4fhi/RZbVKtzlYqR
jvToV7eOGEV4Aldtuz4WDVowBe5ryq9abt8K6CTPyLtQTcIwkcppgPtlydAn
puHnMqCoifwx+3oNs/LtqIgS/bQ2QgvGyIk5oy/l8gHLT+0+jPE47ruJLBIZ
mb9EP0y6wUNLah5640lfzHuTVkMDxjnL493tzVyw45pYHYF9upWsZ7tT9hGW
+WiAVq3OVQO0vnxX4Mw2zXHiLGJPmE4veV+Q7xl4X5qkZZjvhHmO6zdmQu72
Y3ereF4Q3ezn8P8qbUfJp3kxKfPNX4vm2o7LdJn6NLP9TUjK87k1dJeXl3Rx
VqrwXdT2i9xq5GrKuubo79/jcHi5jIMrOOmTyveVuAb0i1Q1ZBwmL6FLr1Fy
qIpB6O7v71XgTfYis0iU966rDOpaCDmWX7O6na0dMH3ZraZCyAiWUDPq9Xq2
IihHAlbp5FNERmN0ocC3dbasTtjtdjObY4aTU6ea42UWylCNjkxtrVcBCa1c
2uCZ2Hb2sz5oOU/bcdSjiG8yPWx8GD2wLouZaD49MFPGKvNL5W844c7yKsMQ
U2xwJuTqbpiX+31oOJeJyf7fNZcaaCJWJidqgjLqwHU3kOX9IvOaJaKbIMHI
bSmfO4SZicsp/mgq8x+BqPQPA48hhg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->628425662]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1152],

Cell[TextData[{
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " is a 4\[Times]4 matrix:"
}], "ExampleText",
 CellID->298373400],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9135919],

Cell["Compute the Jordan decomposition using exact arithmetic:", "ExampleText",
 CellID->243736488],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JordanDecomposition", "[", "m", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->639134889],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{376, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->405336905]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"MatrixForm", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->977190697],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWjtz2kAQFhIPG8gkMWQmpYv8iRRpnSo/gvF4xi4y9jgu6CgpKVVSqmRc
qaSkpKRUqZKS8rJ7D+60OWEBJ0fM4Bl0D93u3ne7t7fa86/By/3d78HLw+3g
+ufz4On+4fbP9c3jM3QFNc/zXuH3/asHdQY1/ntlDErz2cVnMJ1OGf/zfHg0
YGgHysAT77Hsy7LFx49GIzm+x9thGMp2QOhU2ZF8G3zQZrMRInm/eOsFq9Uq
jmOsilE4Y8G1zTu3bU7j5fReWXubCudyucQqHxWAuDRN1byLSrD3dsmcm2ql
pIS2gVSvV1lIYYWHw6FGOplMDA2VgTRJEgFLIm2recjepnOkwhbH4zEIweon
3gYFz+dzrNadI22RtbzcIvUXi0WrJIRgpbA1NEKQLxG/J0JutdKWy9Kl9gAC
KehWDikLaRRFEpOJVPu3spBqD/heSGFTgI3mI0VP5APRB2b3/JzK8FwfLfQ2
z9+VfJHeh0m0rdJvSJty/3Gmrhi10rc62a9YNnK4fIM7tZcOob/ISMddgVZU
J1zsu4XugD5p2/fNxRsz3mdn0hnYR7UkxkCi49GAOKEN2sMwt5kZcVUXO52f
73ANqq73M/Yz9mpg921UFV4L8/RAz/mFZaMXevr48n1nBx+Tn+KjTqHDZklP
WDqezlKduHZpVEeNAtJ879+TW0mhsW1NaCYQBT7p137RiAHpMAWBHGsHzT2P
s33O++ohj7sbLZ8S97yoHfM6jQI+kkaBKuqgUZxLj7fPtxD1hof5fOrR/p+3
P2M/Yz9d7Pt9xZ0a5uxX3DERVHUx7s4F0FOkz+wRyK5cgIq+bFFY9bIgp06t
M72HUOt7oyLUYRiu12tmsReaQxJxZ5Iks9kMq7YcqS3aUPzEzgBiYIFVM+MZ
x7G8Azrmm4buxW2OlWbq5Xsatxbbdfl70czEmuhggeWauUen7x0Qne3Gwz0q
el+2z+1VMVTaZj+zrE3TM+wYdEL/aZoKkzBuA32wRpe6Qkk+2EBPoZE6c48G
oGTuNgVHrSvfMSqTt7jVBGhRFLlGt72jFg5H3lELjgJwOeg07x5p18tAJ32x
QIfracuDqLzKN2Y/mc2TXv1PgVf7C+7g028=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{177, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->23548697]
}, Open  ]],

Cell["Compute the Jordan decomposition using machine arithmetic:", \
"ExampleText",
 CellID->47640490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JordanDecomposition", "[", 
  RowBox[{"N", "[", "m", "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->231247919],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.7071067811865475`"}], ",", "0.`", ",", 
       RowBox[{"-", "3.510833468576701`*^-17"}], ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.7071067811865476`"}], ",", "0.`", ",", 
       RowBox[{"-", "5.551115123125783`*^-17"}], ",", 
       RowBox[{"-", "0.49999999999999983`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "6.982261990806649`*^-17"}], ",", "0.`", ",", 
       "0.9999999999999999`", ",", 
       RowBox[{"-", "1.0000000000000002`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`", ",", "0.`", ",", "0.`"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.`", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1.`", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1.`", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "1.`"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{532, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->744077568]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"MatrixForm", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->28486545],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "0.7071067811865475`"}], "0.`", 
        RowBox[{"-", "3.510833468576701`*^-17"}], "0.5`"},
       {
        RowBox[{"-", "0.7071067811865476`"}], "0.`", 
        RowBox[{"-", "5.551115123125783`*^-17"}], 
        RowBox[{"-", "0.49999999999999983`"}]},
       {
        RowBox[{"-", "6.982261990806649`*^-17"}], "0.`", 
        "0.9999999999999999`", 
        RowBox[{"-", "1.0000000000000002`"}]},
       {"0.`", "1.`", "0.`", "0.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1.`", "0", "0", "0"},
       {"0", "1.`", "1", "0"},
       {"0", "0", "1.`", "1"},
       {"0", "0", "0", "1.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 ImageSize->{412, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->610747383]
}, Open  ]],

Cell["\<\
Compute the Jordan decomposition using 20\[Hyphen]digit arithmetic:\
\>", "ExampleText",
 CellID->395115245],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JordanDecomposition", "[", 
  RowBox[{"N", "[", 
   RowBox[{"m", ",", "20"}], "]"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->7569028],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
       "-", "0.7071067811865475244008443621050712553`19.69897000433602"}], 
       ",", "0", ",", "0``19.69897000433602", ",", "1.`18.744727494896697"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
       "-", "0.70710678118654752440084436210454330871`19.69897000433602"}], 
       ",", "0", ",", "0``19.69897000433602", ",", "0``19.22184874961636"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "4.444320398590561220336805492815040573`19.69897000433602*^-31", ",", 
       "0", ",", "1.`19.22184874961636", ",", 
       RowBox[{"-", "1.`18.744727494896697"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "1.`19.69897000433602", ",", "0``19.69897000433602", ",", 
       "0``19.22184874961636"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.`20.", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1.`20.", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1.`20.", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "1.`20."}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{562, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->530291742]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22564],

Cell["\<\
Here is a function that tests diagonalizability of a square matrix:\
\>", "ExampleText",
 CellID->349441936],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DiagonalizableQ", "[", 
    RowBox[{
     RowBox[{"m_", "?", "MatrixQ"}], "/;", 
     RowBox[{"Apply", "[", 
      RowBox[{"Equal", ",", 
       RowBox[{"Dimensions", "[", "m", "]"}]}], "]"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"s", ",", "j"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", "j"}], "}"}], "=", 
       RowBox[{"JordanDecomposition", "[", "m", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Length", "[", 
        RowBox[{"Cases", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"ArrayRules", "[", "j", "]"}], "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"1", ";;", 
              RowBox[{"-", "2"}]}], ",", "1"}], "]"}], "]"}], ",", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
           RowBox[{"j", "\[Equal]", 
            RowBox[{"i", "+", "1"}]}]}]}], "]"}], "]"}], "\[Equal]", 
       "0"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->514698379],

Cell["Test if a particular matrix is diagonalizable:", "ExampleText",
 CellID->45597465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiagonalizableQ", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->88214799],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->187278484]
}, Open  ]],

Cell["\<\
Estimate the probability that a 4\[Times]4 matrix of ones and zeros will be \
diagonalizable:\
\>", "ExampleText",
 CellID->25824886],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"trials", "=", "100"}], ",", 
     RowBox[{"count", "=", "0"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"DiagonalizableQ", "[", 
         RowBox[{"RandomInteger", "[", 
          RowBox[{"1", ",", 
           RowBox[{"{", 
            RowBox[{"4", ",", "4"}], "}"}]}], "]"}], "]"}], ",", 
        RowBox[{"count", "++"}]}], "]"}], ",", 
      RowBox[{"{", "trials", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"N", "[", 
     RowBox[{"count", "/", "trials"}], "]"}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->41311879],

Cell[BoxData["0.68`"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->177451978]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5512],

Cell[TextData[{
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " is a 4\[Times]4 matrix:"
}], "ExampleText",
 CellID->477305177],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->804046083],

Cell["Find the Jordan decomposition:", "ExampleText",
 CellID->395995826],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"s", ",", "j"}], "}"}], "=", 
  RowBox[{"JordanDecomposition", "[", "m", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->984286834],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{384, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->343233826]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"MatrixForm", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->276783169],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWr1u2zAQliX/JHLatHFSdMzQl+jQNZ36EEZQIBmKFmkGbx49etToUaOR
SaNHjx49etTo0aN6JI8ifT3ZsiUjMuIAFimSd8ePdzyeePnRfX74+av7/Hjf
vf3+1P3z8Hj/9/bu9xM0eTXHcV7g9/WzA/UEavL3kiRQ2s8L8fRGo1Ei/xwX
Hg0Y2obSc1S/KDvY3pTj+/0+ju/I9yAI8N0jdLpsI31DDlqtVkqkbFe9jjef
z6MoElU1SsxYcfVlY/ouaZyM1iu2talxzmYzUZWjPBAXx7Ged14Ju7Sm64Vy
fAuvWbUieDuEtqVXuNfrGaTD4dDSUDFMbVbiYrFQgBCjr+eBrc0CGK9ZiYPB
ANiL6gf5DqqdTCaiWi+M8YKVaFbxPMXoTqfTVgFsN4RWrRNYJmwHgw0kI9bi
2N6xEjls0kbRcovo7xOhVfZu9rvCCPrE/uIY37MSwzBENDZG482KYOT9Trob
0d+Vj5RvVXJhO4B1ZuMVq+KiRdje+hpLSWX5qUuGnvP2ujwT/GESPiv9jrxT
7t9O1BWj1vrWp/kVlj6WZ1u4U3vRfHS0sW4vYm8I66wTLvyeoR6bnhm0f9tc
d9mZlHf2nhToPMQlfZI6jy3a/dBqDdBIojqo6czcEtFXV9cn1CfUr4Ha5WZe
4VWwTwbhG28SE5m4zv8nkYvt7Q18bH46wtEnzH6zpKcnHX9O+vVpykujOmrk
kMathZZCo9ea0oynCvFsbZGQFQ0IOnGlIDjW9pp7Fmd+zrvqIYt7OVo+Ju7U
/vW9jY6wqIVmRWg6MvMTPkIr09fl++bnR+3n7alHez0/n/1Nx0Vzb2kN3rL+
jw37bl9qx4Z5/XutSCRVXYybv/fteyE7msp7mthRGBeNVe+m49ipzW3uPtQm
H5SHOgiC5XKZMPZCo5A0UzAej0WVuw3log77PtHxgBhYiKp9qxlFEeZ2it+p
8vkGgE3v5LGfRrH59t6mm1tz52pjhGXGlTsURpNnEBi53Eb52Gg2rHiGisdm
rPhjsm7l227Nds/4xXGszMPK+Llgn+XrTchzwSo6GhPqr3xMAGgti6k4Gr25
B8FmS1C5TAAYhmHZGNPMtHJHmJlWHBXsQ2I0EjrkvX4IjOivFUaxqpzX1qf9
l4Q/ve1x+v8JnNo/H+3Qcg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{177, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->164502656]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is equal to ",
 Cell[BoxData[
  RowBox[{"s", ".", "j", ".", 
   RowBox[{
    ButtonBox["Inverse",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Inverse"], "[", "s", "]"}]}]], "InlineFormula"],
 ":",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->1644,
  ButtonNote->"1644"]
}], "ExampleText",
 CellID->512642418],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "==", 
  RowBox[{"s", ".", "j", ".", 
   RowBox[{"Inverse", "[", "s", "]"}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->565671495],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->740341442]
}, Open  ]],

Cell[TextData[{
 "The eigenvalues of ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " are on the diagonal of ",
 Cell[BoxData[
  FormBox["j", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->143096873],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", "m", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->336470099],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1", ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->308249814]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->551922890],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a 3\[Times]3 matrix:"
}], "ExampleText",
 CellID->16460696],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"27", ",", "48", ",", "81"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "6"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "3"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->519037726],

Cell["Find its Jordan decomposition:", "ExampleText",
 CellID->577378060],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"s", ",", "j"}], "}"}], "=", 
  RowBox[{"JordanDecomposition", "[", "m", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->675809585],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "18", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", 
        FractionBox["1", "4"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "12", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "12"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{495, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->70125958]
}, Open  ]],

Cell[TextData[{
 "Because of the canonical form of ",
 Cell[BoxData[
  StyleBox["j", "TI"]], "InlineFormula"],
 ", the ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " matrix power of ",
 Cell[BoxData[
  StyleBox["j", "TI"]], "InlineFormula"],
 " is given by:"
}], "ExampleText",
 CellID->157768250],

Cell[BoxData[
 RowBox[{
  RowBox[{"jp", "[", "n_", "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SuperscriptBox["6", "n"], ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      SuperscriptBox["12", "n"], ",", 
      RowBox[{"n", " ", 
       SuperscriptBox["12", 
        RowBox[{"n", "-", "1"}]]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", 
      SuperscriptBox["12", "n"]}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->19498693],

Cell[TextData[{
 "Form the power series for the matrix exponential of",
 Cell[BoxData[
  RowBox[{" ", 
   StyleBox["j", "TI"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->349026279],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"js", "=", 
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"#", "===", "0"}], ",", "0", ",", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{"#", "/", 
          RowBox[{"n", "!"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]}], "]"}], 
     "&"}], ",", 
    RowBox[{"jp", "[", "n", "]"}], ",", 
    RowBox[{"{", "2", "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->86730409],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", "6"], ",", "0", ",", "0"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"0", ",", 
     SuperscriptBox["\[ExponentialE]", "12"], ",", 
     SuperscriptBox["\[ExponentialE]", "12"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     SuperscriptBox["\[ExponentialE]", "12"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{250, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->80957568]
}, Open  ]],

Cell[TextData[{
 "The matrix exponential of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is then given by:"
}], "ExampleText",
 CellID->246141936],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", ".", "js", ".", 
  RowBox[{"Inverse", "[", "s", "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->84234159],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox[
       SuperscriptBox["\[ExponentialE]", "6"], "2"], "+", 
      FractionBox[
       RowBox[{"37", " ", 
        SuperscriptBox["\[ExponentialE]", "12"]}], "2"]}], ",", 
     RowBox[{
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", "6"]}], "+", 
      RowBox[{"68", " ", 
       SuperscriptBox["\[ExponentialE]", "12"]}]}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"27", " ", 
        SuperscriptBox["\[ExponentialE]", "6"]}], "2"], "+", 
      FractionBox[
       RowBox[{"297", " ", 
        SuperscriptBox["\[ExponentialE]", "12"]}], "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox["\[ExponentialE]", "6"], "2"]}], "-", 
      FractionBox[
       RowBox[{"17", " ", 
        SuperscriptBox["\[ExponentialE]", "12"]}], "2"]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", 
       SuperscriptBox["\[ExponentialE]", "6"]}], "-", 
      RowBox[{"31", " ", 
       SuperscriptBox["\[ExponentialE]", "12"]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"27", " ", 
         SuperscriptBox["\[ExponentialE]", "6"]}], "2"]}], "-", 
      FractionBox[
       RowBox[{"135", " ", 
        SuperscriptBox["\[ExponentialE]", "12"]}], "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox[
       SuperscriptBox["\[ExponentialE]", "6"], "6"], "+", 
      FractionBox[
       RowBox[{"11", " ", 
        SuperscriptBox["\[ExponentialE]", "12"]}], "6"]}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", "6"]}], "3"], "+", 
      FractionBox[
       RowBox[{"20", " ", 
        SuperscriptBox["\[ExponentialE]", "12"]}], "3"]}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"9", " ", 
        SuperscriptBox["\[ExponentialE]", "6"]}], "2"], "+", 
      FractionBox[
       RowBox[{"29", " ", 
        SuperscriptBox["\[ExponentialE]", "12"]}], "2"]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{578, 66},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->12879759]
}, Open  ]],

Cell[TextData[{
 "This is equivalent to the value given by ",
 Cell[BoxData[
  ButtonBox["MatrixExp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixExp"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->607049572],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"MatrixExp", "[", "m", "]"}], "-", "%"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->560237712],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->117885603]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19058],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is diagonalizable, the Jordan decomposition is effectively the same as ",
 Cell[BoxData[
  ButtonBox["Eigensystem",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eigensystem"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->442069711],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"m", "=", 
  RowBox[{"m", "+", 
   RowBox[{"Transpose", "[", "m", "]"}], "+", 
   RowBox[{"DiagonalMatrix", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->187221917],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{228, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->176888265]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"s", ",", "j"}], "}"}], "=", 
  RowBox[{"JordanDecomposition", "[", "m", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->216689426],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{572, 221},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->177259375]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"vals", ",", "vecs"}], "}"}], "=", 
  RowBox[{"Eigensystem", "[", "m", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->173036540],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{522, 221},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->437546082]
}, Open  ]],

Cell["The ordering is different:", "ExampleText",
 CellID->263963005],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ord", "=", 
  RowBox[{"Ordering", "[", 
   RowBox[{
    RowBox[{"Diagonal", "[", "j", "]"}], ",", "All", ",", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Abs", "[", "#1", "]"}], ">", 
        RowBox[{"Abs", "[", "#2", "]"}]}], ",", "True", ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Abs", "[", "#1", "]"}], "\[Equal]", 
          RowBox[{"Abs", "[", "#2", "]"}]}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"#1", "<", "0"}], ",", "True", ",", "False"}], "]"}], ",", 
         "False"}], "]"}]}], "]"}], "&"}]}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->209670614],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "1", ",", "2"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->226198281]
}, Open  ]],

Cell[TextData[{
 "The eigenvalues are on the diagonal of ",
 Cell[BoxData[
  StyleBox["j", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->622270996],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Tr", "[", 
    RowBox[{"j", ",", "List"}], "]"}], "[", 
   RowBox[{"[", "ord", "]"}], "]"}], "===", "vals"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1800787],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->129630509]
}, Open  ]],

Cell[TextData[{
 "The eigenvectors are the columns of ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->751286647],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Transpose", "[", "s", "]"}], "[", 
   RowBox[{"[", "ord", "]"}], "]"}], "===", "vecs"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->68973015],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->584687030]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17539],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a 4\[Times]4 matrix with one small entry:"
}], "ExampleText",
 CellID->654840365],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"1", "-", 
        SuperscriptBox["10", 
         RowBox[{"-", "16"}]]}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"1", "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "16"}]]}]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->375660474],

Cell["Find the Jordan decomposition using exact arithmetic:", "ExampleText",
 CellID->504462052],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"s", ",", "j"}], "}"}], "=", 
   RowBox[{"JordanDecomposition", "[", "m", "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->669419681],

Cell[TextData[{
 "This shows that ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is diagonalizable:"
}], "ExampleText",
 CellID->156106417],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ArrayRules", "[", "j", "]"}], "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"1", ";;", 
       RowBox[{"-", "2"}]}], ",", "1"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
    RowBox[{"j", "\[Equal]", 
     RowBox[{"i", "+", "1"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->408322898],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->107653439]
}, Open  ]],

Cell["\<\
Find the Jordan decomposition with machine\[Hyphen]number arithmetic:\
\>", "ExampleText",
 CellID->401184781],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"sn", ",", "jn"}], "}"}], "=", 
  RowBox[{"JordanDecomposition", "[", 
   RowBox[{"N", "[", "m", "]"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->35407651],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.7071067811865475`"}], ",", "0.`", ",", 
       RowBox[{"-", "3.510833468576701`*^-17"}], ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.7071067811865476`"}], ",", "0.`", ",", 
       RowBox[{"-", "5.551115123125783`*^-17"}], ",", 
       RowBox[{"-", "0.49999999999999983`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "6.982261990806649`*^-17"}], ",", "0.`", ",", 
       "0.9999999999999999`", ",", 
       RowBox[{"-", "1.0000000000000002`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`", ",", "0.`", ",", "0.`"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.`", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1.`", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1.`", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "1.`"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{532, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->185805588]
}, Open  ]],

Cell["\<\
Computation with machine number arithmetic indicates that the matrix is not \
diagonalizable:\
\>", "ExampleText",
 CellID->308389134],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ArrayRules", "[", "jn", "]"}], "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"1", ";;", 
       RowBox[{"-", "2"}]}], ",", "1"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
    RowBox[{"j", "\[Equal]", 
     RowBox[{"i", "+", "1"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->112449164],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->354177979]
}, Open  ]],

Cell[TextData[{
 "To machine precision, ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " is indistinguishable from a nearby non-diagonalizable matrix:"
}], "ExampleText",
 CellID->30795636],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "[", "m", "]"}], "-", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}], ",", "1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}], ",", "1", ",", "1"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->591168858],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`", ",", "0.`", ",", "0.`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{466, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->75359196]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11562],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eigensystem",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Eigensystem"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SingularValueDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SingularValueDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["QRDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/QRDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SchurDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SchurDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MatrixExp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MatrixExp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Minors",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Minors"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21376]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9332],

Cell[TextData[ButtonBox["Advanced Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedMatrixOperations"]], "Tutorials",
 CellID->4897]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->52637324],

Cell[TextData[ButtonBox["Matrix Decompositions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixDecompositions"]], "MoreAbout",
 CellID->470439311]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"JordanDecomposition - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 51, 43.6537234}", "context" -> "System`", 
    "keywords" -> {
     "invariant subspaces", "Jordan canonical form", "Jordan decomposition", 
      "Jordan form", "similarity transformation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "JordanDecomposition[m] yields the Jordan decomposition of a square \
matrix m. The result is a list {s, j} where s is a similarity matrix and j is \
the Jordan canonical form of m. ", "synonyms" -> {"jordan decomposition"}, 
    "title" -> "JordanDecomposition", "type" -> "Symbol", "uri" -> 
    "ref/JordanDecomposition"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5251, 169, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->655100676]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 56091, 1850}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2412, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3035, 84, 57, 1, 70, "ObjectName",
 CellID->30899],
Cell[3095, 87, 1060, 33, 70, "Usage",
 CellID->17496]
}, Open  ]],
Cell[CellGroupData[{
Cell[4192, 125, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4670, 142, 382, 14, 70, "Notes",
 CellID->1644],
Cell[5055, 158, 159, 6, 70, "Notes",
 CellID->15452]
}, Closed]],
Cell[CellGroupData[{
Cell[5251, 169, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->655100676],
Cell[CellGroupData[{
Cell[5636, 183, 148, 5, 70, "ExampleSection",
 CellID->265291295],
Cell[5787, 190, 104, 3, 70, "ExampleText",
 CellID->374879823],
Cell[CellGroupData[{
Cell[5916, 197, 380, 12, 28, "Input",
 CellID->156054371],
Cell[6299, 211, 799, 27, 51, "Output",
 CellID->271212465]
}, Open  ]],
Cell[CellGroupData[{
Cell[7135, 243, 131, 4, 28, "Input",
 CellID->204734845],
Cell[7269, 249, 1525, 29, 72, "Output",
 Evaluatable->False,
 CellID->628425662]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8843, 284, 215, 7, 70, "ExampleSection",
 CellID->1152],
Cell[9061, 293, 146, 5, 70, "ExampleText",
 CellID->298373400],
Cell[9210, 300, 518, 17, 70, "Input",
 CellID->9135919],
Cell[9731, 319, 99, 1, 70, "ExampleText",
 CellID->243736488],
Cell[CellGroupData[{
Cell[9855, 324, 115, 3, 70, "Input",
 CellID->639134889],
Cell[9973, 329, 952, 29, 54, "Output",
 CellID->405336905]
}, Open  ]],
Cell[CellGroupData[{
Cell[10962, 363, 131, 4, 70, "Input",
 CellID->977190697],
Cell[11096, 369, 1345, 26, 70, "Output",
 Evaluatable->False,
 CellID->23548697]
}, Open  ]],
Cell[12456, 398, 102, 2, 70, "ExampleText",
 CellID->47640490],
Cell[CellGroupData[{
Cell[12583, 404, 143, 4, 70, "Input",
 CellID->231247919],
Cell[12729, 410, 1284, 37, 77, "Output",
 CellID->744077568]
}, Open  ]],
Cell[CellGroupData[{
Cell[14050, 452, 130, 4, 70, "Input",
 CellID->28486545],
Cell[14183, 458, 1897, 53, 88, "Output",
 CellID->610747383]
}, Open  ]],
Cell[16095, 514, 118, 3, 70, "ExampleText",
 CellID->395115245],
Cell[CellGroupData[{
Cell[16238, 521, 166, 5, 70, "Input",
 CellID->7569028],
Cell[16407, 528, 1441, 41, 132, "Output",
 CellID->530291742]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17897, 575, 223, 7, 70, "ExampleSection",
 CellID->22564],
Cell[18123, 584, 118, 3, 70, "ExampleText",
 CellID->349441936],
Cell[18244, 589, 1201, 36, 70, "Input",
 CellID->514698379],
Cell[19448, 627, 88, 1, 70, "ExampleText",
 CellID->45597465],
Cell[CellGroupData[{
Cell[19561, 632, 259, 9, 70, "Input",
 CellID->88214799],
Cell[19823, 643, 162, 5, 36, "Output",
 CellID->187278484]
}, Open  ]],
Cell[20000, 651, 143, 4, 70, "ExampleText",
 CellID->25824886],
Cell[CellGroupData[{
Cell[20168, 659, 766, 23, 70, "Input",
 CellID->41311879],
Cell[20937, 684, 162, 5, 36, "Output",
 CellID->177451978]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21148, 695, 232, 7, 70, "ExampleSection",
 CellID->5512],
Cell[21383, 704, 146, 5, 70, "ExampleText",
 CellID->477305177],
Cell[21532, 711, 520, 17, 70, "Input",
 CellID->804046083],
Cell[22055, 730, 73, 1, 70, "ExampleText",
 CellID->395995826],
Cell[CellGroupData[{
Cell[22153, 735, 185, 6, 70, "Input",
 CellID->984286834],
Cell[22341, 743, 975, 30, 54, "Output",
 CellID->343233826]
}, Open  ]],
Cell[CellGroupData[{
Cell[23353, 778, 131, 4, 70, "Input",
 CellID->276783169],
Cell[23487, 784, 1395, 27, 70, "Output",
 Evaluatable->False,
 CellID->164502656]
}, Open  ]],
Cell[24897, 814, 423, 16, 70, "ExampleText",
 CellID->512642418],
Cell[CellGroupData[{
Cell[25345, 834, 161, 5, 70, "Input",
 CellID->565671495],
Cell[25509, 841, 161, 5, 36, "Output",
 CellID->740341442]
}, Open  ]],
Cell[25685, 849, 240, 9, 70, "ExampleText",
 CellID->143096873],
Cell[CellGroupData[{
Cell[25950, 862, 107, 3, 70, "Input",
 CellID->336470099],
Cell[26060, 867, 223, 7, 36, "Output",
 CellID->308249814]
}, Open  ]],
Cell[26298, 877, 125, 3, 70, "ExampleDelimiter",
 CellID->551922890],
Cell[26426, 882, 138, 5, 70, "ExampleText",
 CellID->16460696],
Cell[26567, 889, 384, 13, 70, "Input",
 CellID->519037726],
Cell[26954, 904, 73, 1, 70, "ExampleText",
 CellID->577378060],
Cell[CellGroupData[{
Cell[27052, 909, 185, 6, 70, "Input",
 CellID->675809585],
Cell[27240, 917, 798, 27, 51, "Output",
 CellID->70125958]
}, Open  ]],
Cell[28053, 947, 395, 15, 70, "ExampleText",
 CellID->157768250],
Cell[28451, 964, 534, 18, 70, "Input",
 CellID->19498693],
Cell[28988, 984, 191, 7, 70, "ExampleText",
 CellID->349026279],
Cell[CellGroupData[{
Cell[29204, 995, 535, 18, 70, "Input",
 CellID->86730409],
Cell[29742, 1015, 561, 18, 39, "Output",
 CellID->80957568]
}, Open  ]],
Cell[30318, 1036, 164, 6, 70, "ExampleText",
 CellID->246141936],
Cell[CellGroupData[{
Cell[30507, 1046, 136, 4, 70, "Input",
 CellID->84234159],
Cell[30646, 1052, 2272, 73, 87, "Output",
 CellID->12879759]
}, Open  ]],
Cell[32933, 1128, 226, 8, 70, "ExampleText",
 CellID->607049572],
Cell[CellGroupData[{
Cell[33184, 1140, 164, 5, 70, "Input",
 CellID->560237712],
Cell[33351, 1147, 391, 13, 36, "Output",
 CellID->117885603]
}, Open  ]],
Cell[33757, 1163, 121, 3, 70, "ExampleDelimiter",
 CellID->19058],
Cell[33881, 1168, 326, 11, 70, "ExampleText",
 CellID->442069711],
Cell[CellGroupData[{
Cell[34232, 1183, 513, 17, 70, "Input",
 CellID->187221917],
Cell[34748, 1202, 433, 15, 36, "Output",
 CellID->176888265]
}, Open  ]],
Cell[CellGroupData[{
Cell[35218, 1222, 185, 6, 70, "Input",
 CellID->216689426],
Cell[35406, 1230, 4239, 74, 70, "Output",
 Evaluatable->False,
 CellID->177259375]
}, Open  ]],
Cell[CellGroupData[{
Cell[39682, 1309, 183, 6, 70, "Input",
 CellID->173036540],
Cell[39868, 1317, 3714, 65, 70, "Output",
 Evaluatable->False,
 CellID->437546082]
}, Open  ]],
Cell[43597, 1385, 69, 1, 70, "ExampleText",
 CellID->263963005],
Cell[CellGroupData[{
Cell[43691, 1390, 715, 21, 70, "Input",
 CellID->209670614],
Cell[44409, 1413, 213, 7, 36, "Output",
 CellID->226198281]
}, Open  ]],
Cell[44637, 1423, 160, 6, 70, "ExampleText",
 CellID->622270996],
Cell[CellGroupData[{
Cell[44822, 1433, 207, 7, 70, "Input",
 CellID->1800787],
Cell[45032, 1442, 161, 5, 36, "Output",
 CellID->129630509]
}, Open  ]],
Cell[45208, 1450, 157, 6, 70, "ExampleText",
 CellID->751286647],
Cell[CellGroupData[{
Cell[45390, 1460, 187, 6, 70, "Input",
 CellID->68973015],
Cell[45580, 1468, 161, 5, 36, "Output",
 CellID->584687030]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[45790, 1479, 226, 7, 70, "ExampleSection",
 CellID->17539],
Cell[46019, 1488, 160, 5, 70, "ExampleText",
 CellID->654840365],
Cell[46182, 1495, 687, 22, 70, "Input",
 CellID->375660474],
Cell[46872, 1519, 96, 1, 70, "ExampleText",
 CellID->504462052],
Cell[46971, 1522, 206, 7, 70, "Input",
 CellID->669419681],
Cell[47180, 1531, 155, 6, 70, "ExampleText",
 CellID->156106417],
Cell[CellGroupData[{
Cell[47360, 1541, 430, 15, 70, "Input",
 CellID->408322898],
Cell[47793, 1558, 175, 6, 36, "Output",
 CellID->107653439]
}, Open  ]],
Cell[47983, 1567, 120, 3, 70, "ExampleText",
 CellID->401184781],
Cell[CellGroupData[{
Cell[48128, 1574, 215, 7, 70, "Input",
 CellID->35407651],
Cell[48346, 1583, 1284, 37, 77, "Output",
 CellID->185805588]
}, Open  ]],
Cell[49645, 1623, 144, 4, 70, "ExampleText",
 CellID->308389134],
Cell[CellGroupData[{
Cell[49814, 1631, 431, 15, 70, "Input",
 CellID->112449164],
Cell[50248, 1648, 302, 11, 36, "Output",
 CellID->354177979]
}, Open  ]],
Cell[50565, 1662, 210, 6, 70, "ExampleText",
 CellID->30795636],
Cell[CellGroupData[{
Cell[50800, 1672, 515, 16, 70, "Input",
 CellID->591168858],
Cell[51318, 1690, 534, 16, 36, "Output",
 CellID->75359196]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[51913, 1713, 311, 9, 70, "SeeAlsoSection",
 CellID->11562],
Cell[52227, 1724, 1505, 53, 70, "SeeAlso",
 CellID->21376]
}, Open  ]],
Cell[CellGroupData[{
Cell[53769, 1782, 313, 9, 70, "TutorialsSection",
 CellID->9332],
Cell[54085, 1793, 160, 3, 70, "Tutorials",
 CellID->4897]
}, Open  ]],
Cell[CellGroupData[{
Cell[54282, 1801, 318, 9, 70, "MoreAboutSection",
 CellID->52637324],
Cell[54603, 1812, 153, 3, 70, "MoreAbout",
 CellID->470439311]
}, Open  ]],
Cell[54771, 1818, 27, 0, 70, "History"],
Cell[54801, 1820, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

