(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    893461,      17587]
NotebookOptionsPosition[    862671,      16556]
NotebookOutlinePosition[    865333,      16612]
CellTagsIndexPosition[    865245,      16607]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ParametricPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/ParametricPlot3D"], 
          "GraphData" :> Documentation`HelpLookup["paclet:ref/GraphData"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"ParametricPlot3D\"\>", 
       2->"\<\"GraphData\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computational Geometry" :> 
          Documentation`HelpLookup["paclet:guide/ComputationalGeometry"], 
          "Integrated Data Sources" :> 
          Documentation`HelpLookup["paclet:guide/DataCollections"], 
          "Discrete Mathematics" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteMathematics"], 
          "Mathematical Data" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalData"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Computational Geometry\"\>", 
       2->"\<\"Integrated Data Sources\"\>", 
       3->"\<\"Discrete Mathematics\"\>", 4->"\<\"Mathematical Data\"\>", 
       5->"\<\"New in 6.0: Mathematics & Algorithms\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["KnotData", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["KnotData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/KnotData"], "[", 
       RowBox[{
        StyleBox["knot", "TI"], ",", "\"\<\!\(\*
StyleBox[\"property\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the specified property for a knot."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["KnotData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/KnotData"], "[", 
       StyleBox["knot", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives an image of the knot."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["KnotData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/KnotData"], "[", "\"\<\!\(\*
StyleBox[\"class\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of knots in the specified class."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Prime knots with crossing numbers up to 10 can be specified in Alexander\
\[Dash]Briggs ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["k", "TI"]}], "}"}]], "InlineFormula"],
 " notation. "
}], "Notes",
 CellID->251288686],

Cell[TextData[{
 "Knots can also be specified in Dowker notation ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["i", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["i", "TI"], 
     StyleBox["2", "TR"]], ",", 
    SubscriptBox[
     StyleBox["i", "TI"], 
     StyleBox["3", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 ", and in Conway notation ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"nnnn\", \"TI\"]\)\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->118621099],

Cell["Special knot specifications include:", "Notes",
 CellID->366924191],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"\"\<PretzelKnot\>\"", ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}], Cell[TextData[{
     "(",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["n", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["n", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}]]],
     ")-pretzel knot "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"\"\<TorusKnot\>\"", ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["m", "TI"], ",", 
        StyleBox["n", "TI"]}], "}"}]}], "}"}], Cell[TextData[{
     Cell[BoxData[Cell[TextData[{
       "(",
       Cell[BoxData[
        RowBox[{
         StyleBox["m", "TI"], ",", 
         StyleBox["n", "TI"]}]]],
       ")"
      }], "TableText"]], "InlineFormula"],
     "-torus knot (",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " coprime)"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->362536805],

Cell[TextData[{
 "Knots with standard names can be specified by their names, such as ",
 Cell[BoxData["\"\<Trefoil\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<FigureEight\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->702683572],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["KnotData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/KnotData"], "[", "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " gives a list of classical named knots."
}], "Notes",
 CellID->202801788],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["KnotData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/KnotData"], "[", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"], "]"}]], "InlineFormula"],
 " gives a list of knots that have Alexander\[Dash]Briggs notations."
}], "Notes",
 CellID->586939930],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"KnotData", "[", "\"\<Properties\>\"", "]"}], " "}]], 
  "InlineFormula"],
 "gives a list of possible properties for knots."
}], "Notes",
 CellID->1460270283],

Cell["Graphical representations for knots include:", "Notes",
 CellID->216343133],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Image\>\"", Cell[
    "3D image of the knot", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ImageData\>\"", Cell[
    "graphics data for the 3D knot image", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<KnotDiagram\>\"", Cell[
    "2D diagram of the knot", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<KnotDiagramData\>\"", Cell[
    "graphics data for the 2D knot diagram", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->744846437],

Cell["Invariants for knots include:", "Notes",
 CellID->990219751],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ArfInvariant\>\"", Cell[
    "Arf invariant", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<BraidIndex\>\"", Cell[
    "braid index", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<BridgeIndex\>\"", Cell[
    "bridge index", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ColoringNumberSet\>\"", Cell[
    "list of colorable numbers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ConcordanceOrder\>\"", Cell[
    "concordance order", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CrossingNumber\>\"", Cell[
    "crossing number", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DegreeThreeVassiliev\>\"", Cell[
    "degree-3 Vassiliev invariant", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DegreeTwoVassiliev\>\"", Cell[
    "degree-2 Vassiliev invariant", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Determinant\>\"", Cell[
    "determinant", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Genus\>\"", Cell[
    "genus of knot complement", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<HyperbolicVolume\>\"", Cell[
    "hyperbolic volume", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NakanishiIndex\>\"", Cell[
    "Nakanishi index", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<OzsvathSzaboTau\>\"", Cell[
    "Ozsvath-Szabo tau invariant", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Signature\>\"", Cell[
    "signature", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SmoothFourGenus\>\"", Cell[
    "smooth 4-genus", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<StickNumber\>\"", Cell[
    "stick number", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SuperbridgeIndex\>\"", Cell[
    "superbridge index", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ThurstonBennequin\>\"", Cell[
    "Thurston-Bennequin number", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<TopologicalFourGenus\>\"", Cell[
    "topological 4-genus", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnknottingNumber\>\"", Cell[
    "unknotting number", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True, True}}}},
 CellID->532929866],

Cell["Polynomial invariants given as pure functions include:", "Notes",
 CellID->1552299899],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<AlexanderPolynomial\>\"", Cell[
    "Alexander polynomial", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<BLMHoPolynomial\>\"", Cell[
    "BLMHo polynomial", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<BracketPolynomial\>\"", Cell[
    "normalized bracket polynomial", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ConwayPolynomial\>\"", Cell[
    "Conway polynomial", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<HOMFLYPolynomial\>\"", Cell[
    "HOMFLY polynomial", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<JonesPolynomial\>\"", Cell[
    "Jones polynomial", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<KauffmanPolynomial\>\"", Cell[
    "Kauffman polynomial", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->1945449872],

Cell["Other properties include:", "Notes",
 CellID->1236121833],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<SeifertMatrix\>\"", Cell[
    "Seifert matrix", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SpaceCurve\>\"", Cell[
    "space curve function for a knot embedding", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->742846153],

Cell["Graphical representations for knots as braids include:", "Notes",
 CellID->1220558805],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<BraidDiagram\>\"", Cell[
    "2D diagram of the knot as a braid", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<BraidDiagramData\>\"", Cell[
    "graphics data for the 2D braid diagram", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<BraidImage\>\"", Cell[
    "3D image of the knot as a braid", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<BraidImageData\>\"", Cell[
    "graphics data for the 3D braid image", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->1168039491],

Cell["Notations for knots include:", "Notes",
 CellID->1319528465],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<AlexanderBriggsList\>\"", Cell[
    TextData[{
     "Alexander-Briggs ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["k", "TI"]}], "}"}]], "InlineFormula"],
     " list"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<AlexanderBriggsNotation\>\"", Cell[
    "Alexander-Briggs notation for display", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<BraidWord\>\"", Cell[
    "braid word as a list", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<BraidWordNotation\>\"", Cell[
    "braid word in algebraic notation", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ConwayNotation\>\"", Cell[
    "Conway notation for display", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ConwayString\>\"", Cell[
    "Conway notation as a string", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DowkerList\>\"", Cell[TextData[{
     "Dowker",
     Cell[BoxData[
      RowBox[{" ", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["i", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["i", "TI"], 
          StyleBox["2", "TR"]], ",", 
         SubscriptBox[
          StyleBox["i", "TI"], 
          StyleBox["3", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
     " list"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DowkerNotation\>\"", Cell[
    "Dowker notation for display", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->1699742731],

Cell["Naming-related properties include:", "Notes",
 CellID->2072244902],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<AlternateNames\>\"", Cell[
    "alternate English names", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Name\>\"", Cell[
    "English or mathematical name", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<StandardName\>\"", Cell[TextData[{
     "standard ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " name"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->228247197],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["KnotData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/KnotData"], "[", 
   RowBox[{
    StyleBox["knot", "TI"], ",", "\"\<Classes\>\""}], "]"}]], 
  "InlineFormula"],
 " gives a list of the classes in which ",
 Cell[BoxData[
  StyleBox["knot", "TI"]], "InlineFormula"],
 " occurs."
}], "Notes",
 CellID->433103127],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["KnotData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/KnotData"], "[", "\"\<\!\(\*
StyleBox[\"class\", \"TI\"]\)\!\(\*
StyleBox[\"\\\"\<\>\", \"TI\"]\)\>", "]"}]], "InlineFormula"],
 " gives a list of knots in the specified class."
}], "Notes",
 CellID->1358085380],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["KnotData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/KnotData"], "[", 
   RowBox[{
    StyleBox["knot", "TI"], ",", "\"\<\!\(\*
StyleBox[\"class\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " depending on whether ",
 Cell[BoxData[
  StyleBox["knot", "TI"]], "InlineFormula"],
 " is in the specified class."
}], "Notes",
 CellID->912420354],

Cell["Basic classes of knots include:", "Notes",
 CellID->2078739005],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<AlmostAlternating\>\"", Cell[
    "almost alternating", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Alternating\>\"", Cell[
    "alternating", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Amphichiral\>\"", Cell[
    "amphichiral", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Chiral\>\"", Cell[
    "chiral ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Hyperbolic\>\"", Cell[
    "hyperbolic", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Invertible\>\"", Cell[
    "invertible ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Nonalternating\>\"", Cell[
    "non-alternating ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Prime\>\"", Cell[
    "prime ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Ribbon\>\"", Cell[
    "ribbon", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Satellite\>\"", Cell[
    "satellite ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Slice\>\"", Cell[
    "slice", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Torus\>\"", Cell[
    "torus ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Twist\>\"", Cell[
    "twist", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, {
     None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True}}}},
 CellID->951888296],

Cell["Negative classes of knots include:", "Notes",
 CellID->1342175806],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Composite\>\"", Cell[
    "not prime", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NonalmostAlternating\>\"", Cell[
    "not almost alternating", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Nonhyperbolic\>\"", Cell[
    "not hyperbolic", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Noninvertible\>\"", Cell[
    "not invertible", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Nonribbon\>\"", Cell[
    "not ribbon", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Nonsatellite\>\"", Cell[
    "not satellite", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Nonslice\>\"", Cell[
    "not slice", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Nontorus\>\"", Cell[
    "not torus", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Nontwist\>\"", Cell[
    "not twist", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True, True}}}},
 CellID->780543354],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["KnotData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/KnotData"]], "InlineFormula"],
 " may require internet connectivity. "
}], "Notes",
 CellID->94188222]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->242634408],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->77081446],

Cell["The trefoil knot:", "ExampleText",
 CellID->1788057144],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", "\"\<Trefoil\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1345756366],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5785626]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32657897],

Cell["The Alexander polynomial of the trefoil knot:", "ExampleText",
 CellID->2137746737],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"KnotData", "[", 
   RowBox[{"\"\<Trefoil\>\"", ",", " ", "\"\<AlexanderPolynomial\>\""}], 
   "]"}], "[", "x", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->848794894],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  FractionBox["1", "x"], "+", "x"}]], "Output",
 ImageSize->{63, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->855368486]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(24)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Names and Classes",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(10)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1518270382],

Cell["Obtain a list of classical named knots:", "ExampleText",
 CellID->365686779],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2146980586],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Unknot\"\>", ",", "\<\"Trefoil\"\>", 
   ",", "\<\"FigureEight\"\>", ",", "\<\"SolomonSeal\"\>", 
   ",", "\<\"Stevedore\"\>", ",", "\<\"PerkoPair\"\>"}], "}"}]], "Output",
 ImageSize->{445, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->993786642]
}, Open  ]],

Cell["Obtain a list of knots that have Alexander-Briggs notations:", \
"ExampleText",
 CellID->925589599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"KnotData", "[", "All", "]"}], "//", "Short"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12851525],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "1"}], "}"}], ",", 
    RowBox[{"\[LeftSkeleton]", "242", "\[RightSkeleton]"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "162"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "163"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "164"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "165"}], "}"}]}], "}"}],
  Short]], "Output",
 ImageSize->{554, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//Short=",
 CellID->232622916]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->371013458],

Cell[BoxData["250"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->397073585]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->735107713],

Cell[TextData[{
 "A knot can be specified by its standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " name:"
}], "ExampleText",
 CellID->1320705563],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", "\"\<FigureEight\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->707421949],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->835045072]
}, Open  ]],

Cell["Knots can also be specified in Alexander-Brigg notation:", "ExampleText",
 CellID->2006031198],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "1"}], "}"}], ",", "\"\<ArfInvariant\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->977937755],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1827844805]
}, Open  ]],

Cell["Conway notation:", "ExampleText",
 CellID->503356452],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", 
  RowBox[{"\"\<22\>\"", ",", " ", "\"\<ArfInvariant\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->973803231],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1727742251]
}, Open  ]],

Cell["Dowker notation:", "ExampleText",
 CellID->2020570533],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "6", ",", "8", ",", "2"}], "}"}], ",", " ", 
   "\"\<ArfInvariant\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->738029630],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->2037621470]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1664094946],

Cell[TextData[{
 "A torus knot is specified a pair of coprime integers ",
 Cell[BoxData[
  RowBox[{"(", 
   StyleBox[
    RowBox[{"m", ",", "n"}], "TI"], ")"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1764222541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<TorusKnot\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "5"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->369309031],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 178},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->381771976]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->769423020],

Cell["\<\
A pretzel knot is specified by the number of crossings of its tangles:\
\>", "ExampleText",
 CellID->169728548],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<PretzelKnot\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "3", ",", "2"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->981532458],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{138, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->252906650]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1367233059],

Cell["Find the English name of an knot:", "ExampleText",
 CellID->668291069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}], ",", " ", "\"\<Name\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->628522873],

Cell[BoxData["\<\"trefoil\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->382327581]
}, Open  ]],

Cell["A list of alternate names can also be found:", "ExampleText",
 CellID->2061826860],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}], ",", " ", "\"\<AlternateNames\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1327908028],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"trefoil\"\>", ",", "\<\"threefoil\"\>", 
   ",", "\<\"overhand knot\"\>"}], "}"}]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->508582043]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2003065306],

Cell["Find the list of knot classes:", "ExampleText",
 CellID->1564947570],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", "\"\<Classes\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1841584181],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Alternating\"\>", ",", "\<\"Nonalternating\"\>", 
   ",", "\<\"Amphichiral\"\>", ",", "\<\"Chiral\"\>", 
   ",", "\<\"Hyperbolic\"\>", ",", "\<\"Nonhyperbolic\"\>", 
   ",", "\<\"Prime\"\>", ",", "\<\"Composite\"\>", ",", "\<\"Invertible\"\>", 
   ",", "\<\"Noninvertible\"\>", ",", "\<\"Satellite\"\>", 
   ",", "\<\"Nonsatellite\"\>", ",", "\<\"Torus\"\>", 
   ",", "\<\"Nontorus\"\>"}], "}"}]], "Output",
 ImageSize->{576, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->99959040]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->679373326],

Cell["Find the list of knots belonging to a class:", "ExampleText",
 CellID->56938983],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", "\"\<Torus\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1343264366],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "19"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "124"}], "}"}]}], "}"}]], "Output",
 ImageSize->{338, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->138592230]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", "\"\<Noninvertible\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->222482558],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"8", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "35"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "38"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "49"}], "}"}]}], "}"}]], "Output",
 ImageSize->{409, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1239885026]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1713805141],

Cell["Test whether an element belongs to a class:", "ExampleText",
 CellID->1872331223],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}], ",", "\"\<Torus\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1192985470],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->225571212]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1626039502],

Cell["Get a list of classes in which a knot belongs:", "ExampleText",
 CellID->2116502039],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}], ",", "\"\<Classes\>\""}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1130640565],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Alternating\"\>", ",", "\<\"Chiral\"\>", 
   ",", "\<\"Nonhyperbolic\"\>", ",", "\<\"Prime\"\>", 
   ",", "\<\"Invertible\"\>", ",", "\<\"Nonsatellite\"\>", 
   ",", "\<\"Torus\"\>"}], "}"}]], "Output",
 ImageSize->{520, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->866723129]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2146102911],

Cell["A list of knots which are non invertible and alternating:", \
"ExampleText",
 CellID->1628990020],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<Noninvertible\>\"", ",", "\"\<Alternating\>\""}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1502915977],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"8", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "35"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "38"}], "}"}]}], "}"}]], "Output",
 ImageSize->{352, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1749091717]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties ",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1169616620],

Cell["Get a list of possible properties:", "ExampleText",
 CellID->930597320],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"KnotData", "[", "\"\<Properties\>\"", "]"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->425756139],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"AlexanderBriggsList\"\>", 
   ",", "\<\"AlexanderBriggsNotation\"\>", ",", "\<\"AlexanderPolynomial\"\>",
    ",", "\<\"AlternateNames\"\>", ",", "\<\"Alternating\"\>", 
   ",", "\<\"Amphichiral\"\>", ",", "\<\"ArfInvariant\"\>", 
   ",", "\<\"BLMHoPolynomial\"\>", ",", "\<\"BracketPolynomial\"\>", 
   ",", "\<\"BraidDiagram\"\>", ",", "\<\"BraidDiagramData\"\>", 
   ",", "\<\"BraidImage\"\>", ",", "\<\"BraidImageData\"\>", 
   ",", "\<\"BraidIndex\"\>", ",", "\<\"BraidWord\"\>", 
   ",", "\<\"BraidWordNotation\"\>", ",", "\<\"BridgeIndex\"\>", 
   ",", "\<\"Chiral\"\>", ",", "\<\"ColoringNumberSet\"\>", 
   ",", "\<\"Composite\"\>", ",", "\<\"ConcordanceOrder\"\>", 
   ",", "\<\"ConwayNotation\"\>", ",", "\<\"ConwayPolynomial\"\>", 
   ",", "\<\"ConwayString\"\>", ",", "\<\"CrossingNumber\"\>", 
   ",", "\<\"DegreeThreeVassiliev\"\>", ",", "\<\"DegreeTwoVassiliev\"\>", 
   ",", "\<\"Determinant\"\>", ",", "\<\"DowkerList\"\>", 
   ",", "\<\"DowkerNotation\"\>", ",", "\<\"Genus\"\>", 
   ",", "\<\"HOMFLYPolynomial\"\>", ",", "\<\"Hyperbolic\"\>", 
   ",", "\<\"HyperbolicVolume\"\>", ",", "\<\"Image\"\>", 
   ",", "\<\"ImageData\"\>", ",", "\<\"Information\"\>", 
   ",", "\<\"Invertible\"\>", ",", "\<\"JonesPolynomial\"\>", 
   ",", "\<\"KauffmanPolynomial\"\>", ",", "\<\"KnotDiagram\"\>", 
   ",", "\<\"KnotDiagramData\"\>", ",", "\<\"NakanishiIndex\"\>", 
   ",", "\<\"Name\"\>", ",", "\<\"Nonalternating\"\>", 
   ",", "\<\"Nonhyperbolic\"\>", ",", "\<\"Noninvertible\"\>", 
   ",", "\<\"Nonsatellite\"\>", ",", "\<\"Nontorus\"\>", 
   ",", "\<\"OzsvathSzaboTau\"\>", ",", "\<\"Prime\"\>", 
   ",", "\<\"Satellite\"\>", ",", "\<\"SeifertMatrix\"\>", 
   ",", "\<\"Signature\"\>", ",", "\<\"SmoothFourGenus\"\>", 
   ",", "\<\"SpaceCurve\"\>", ",", "\<\"StandardName\"\>", 
   ",", "\<\"StickNumber\"\>", ",", "\<\"SuperbridgeIndex\"\>", 
   ",", "\<\"ThurstonBennequin\"\>", ",", "\<\"TopologicalFourGenus\"\>", 
   ",", "\<\"Torus\"\>", ",", "\<\"UnknottingNumber\"\>"}], "}"}]], "Output",
 ImageSize->{577, 220},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30756598]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1744689671],

Cell[BoxData["63"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->54437312]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->686267939],

Cell["Get a list of available properties for a particular knot:", \
"ExampleText",
 CellID->2118066383],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"KnotData", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"4", ",", "1"}], "}"}], ",", "\"\<Properties\>\""}], "]"}], " ", 
  "//", "Short"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1652766409],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"\<\"AlexanderBriggsList\"\>", 
    ",", "\<\"AlexanderBriggsNotation\"\>", ",", 
    RowBox[{"\[LeftSkeleton]", "59", "\[RightSkeleton]"}], 
    ",", "\<\"Torus\"\>", ",", "\<\"UnknottingNumber\"\>"}], "}"}],
  Short]], "Output",
 ImageSize->{546, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->101043053]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1746677940],

Cell["Image of a knot:", "ExampleText",
 CellID->314683090],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5", ",", "2"}], "}"}], ",", " ", "\"\<Image\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1773954716],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->96509764]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1961909090],

Cell["Diagram of a knot:", "ExampleText",
 CellID->252563117],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<TorusKnot\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"11", ",", "21"}], "}"}]}], "}"}], ",", " ", 
   "\"\<KnotDiagram\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1400620947],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->724298472]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->715630839],

Cell["Get more information about a knot:", "ExampleText",
 CellID->1699087873],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}], ",", "\"\<Information\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1479827352],

Cell[BoxData[
 TagBox[
  ButtonBox[
   PaneSelectorBox[{
    False->"\<\"http://mathworld.wolfram.com/TrefoilKnot.html\"\>", True->
    StyleBox["\<\"http://mathworld.wolfram.com/TrefoilKnot.html\"\>", 
     "HyperlinkActive"]}, Dynamic[
     CurrentValue["MouseOver"]],
    BaselinePosition->Baseline,
    FrameMargins->0,
    ImageSize->Automatic],
   BaseStyle->"Hyperlink",
   ButtonData->{
     URL["http://mathworld.wolfram.com/TrefoilKnot.html"], None},
   ButtonNote->"http://mathworld.wolfram.com/TrefoilKnot.html"],
  Annotation[#, "http://mathworld.wolfram.com/TrefoilKnot.html", 
   "Hyperlink"]& ]], "Output",
 ImageSize->{319, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1450189157]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1951726184],

Cell["Get different notational forms: ", "ExampleText",
 CellID->1996750210],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"8", ",", "18"}], "}"}], ",", "\"\<AlexanderBriggsNotation\>\""}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->653827801],

Cell[BoxData[
 SubscriptBox["8", "18"]], "Output",
 ImageSize->{22, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->503960871]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"8", ",", "18"}], "}"}], ",", "\"\<ConwayNotation\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->656366731],

Cell[BoxData["\<\"8*\"\>"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1348813111]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"8", ",", "18"}], "}"}], ",", "\"\<DowkerNotation\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->394855129],

Cell[BoxData["\<\"6 8 10 12 14 16 2 4\"\>"], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->605683873]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13959903],

Cell["Get different notational forms, useful for input: ", "ExampleText",
 CellID->548372198],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"KnotData", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"8", ",", "18"}], "}"}], ",", "\"\<AlexanderBriggsList\>\""}], 
   "]"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1639202509],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"8", ",", "18"}], "}"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1722404123]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"8", ",", "18"}], "}"}], ",", "\"\<ConwayString\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->757178157],

Cell[BoxData["\<\"[8*]\"\>"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2005165052]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"8", ",", "18"}], "}"}], ",", "\"\<DowkerList\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->4507713],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "6", ",", "8", ",", "10", ",", "12", ",", "14", ",", "16", ",", "2", ",", 
   "4"}], "}"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->366533701]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Property Values",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1828711349],

Cell[TextData[{
 "A property value can be any valid ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression:"
}], "ExampleText",
 CellID->1875338644],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"7", ",", "1"}], "}"}], ",", " ", "\"\<ArfInvariant\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->94904096],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->859757463]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"10", ",", "122"}], "}"}], ",", "\"\<ColoringNumberSet\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1921174684],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "5", ",", "7"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2106417704]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"KnotData", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "1"}], "}"}], ",", "\"\<AlexanderBriggsNotation\>\""}],
    "]"}], " "}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1294430333],

Cell[BoxData[
 SubscriptBox["3", "1"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1013782012]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->194288694],

Cell["Polynomial invariants are given as pure functions:", "ExampleText",
 CellID->1234936618],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", " ", "=", " ", 
  RowBox[{"KnotData", "[", 
   RowBox[{"\"\<FigureEight\>\"", ",", "\"\<HOMFLYPolynomial\>\""}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150290471],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   FractionBox["1", 
    SuperscriptBox["#1", "2"]], "+", 
   SuperscriptBox["#1", "2"], "-", 
   SuperscriptBox["#2", "2"]}], "&"}]], "Output",
 ImageSize->{130, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1916166532]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1583034252],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  FractionBox["1", 
   SuperscriptBox["x", "2"]], "+", 
  SuperscriptBox["x", "2"], "-", 
  SuperscriptBox["y", "2"]}]], "Output",
 ImageSize->{99, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1346132912]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->60630814],

Cell[TextData[{
 "A space curve for a knot is given as ",
 Cell[BoxData[
  ButtonBox["Function",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Function"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1114842220],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", " ", "=", " ", 
  RowBox[{"KnotData", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "1"}], "}"}], ",", "\"\<SpaceCurve\>\""}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87081229],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "#1", "]"}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "#1"}], "]"}]}]}], ",", 
    RowBox[{
     RowBox[{"Cos", "[", "#1", "]"}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "#1"}], "]"}]}]}], ",", 
    RowBox[{"-", 
     RowBox[{"Sin", "[", 
      RowBox[{"3", " ", "#1"}], "]"}]}]}], "}"}], "&"}]], "Output",
 ImageSize->{379, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->111199935]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"f", "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"Axes", " ", "\[Rule]", " ", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->134953409],

Cell[GraphicsData["CompressedBitmap", "\<\
eJydmvluFEcQxsd7+FzfBnwtNsZg8AGBYAhgDARiiFAICkqUW3HIRoCEiAhR
pCjPkH/zIrzeKNmqqdqZ+U2vZxckbNd0zfdV93RXVVf3Z4dvn7deHb598exw
9cGbw9+ev3j2++rB6zftR9WBKIretf//Mx+1//6v/Zf+fxfHcRT93f5ZbbVa
uyr91f5ZaUsVkeRxrP+iD7X1T9OtmdYVffqHSUO5p29MdySD1P5pSK+ttSFS
rcPT/uOytr8yrMku7S/t/WmR6p1247ikOs8NYw59Yd8uqHbLEI/3pP2zaS+g
tQp5R7V/MkuW0VqDvK3aPxj2yZ60vzPsU2itQ95S7a8N+zRaByFvqvaXpn22
J+2nZsl5tA5B1vboiWFvl2ifU+3Hhn2xJ+1Hhn0JrcOQN1T7oWlfQesIZB2F
6MAsudaT9j3Dvo7WUchnVPuuYe+hdQzyumrvG/Z+T9p7hn0XrQ3IOjOi64Z9
D63jkNdU+6ppH/SkfcUs+RStE5B1RutaloeP0DoJeVW1Lxr24560tw37CVqn
IK+o9nnTforWaci6bnVuiSVf9aS9btjflGg3VXvNsL/vSXvFsH9E6wxk9U76
Ux4eonUW8pJqL5olv/SkfcKwf0UrPfSiah8z7BdoPQZZfbD2Rh6+tLdOBLUm
TUtGsL6/9+/9OBzvyDGvb4+btq6oavt1axWvX2mLt+M0PmbfZkxR29QHpN41
Rasb2g1rp9eibQnacJz1vinakKHtxpmIewSa2qoeXtC2gDZiaB8YGlcK0VRO
etTx9SnaGORNQ+Xs6Y7quUFL/20Cr2HWbhgu5wRx51Lceudpgh4Re9yw1+I0
b5AZpXjt3/Jnrf2Da3I25Tgiy9gA2yRkX6XSA2EhXs2e0wOH2Zm1cEZOWV8X
jHXO0BnFZK7Ja4xAM0FWrhKyTkMWVs/n5DF9us9NWqU4BTbmMGfANmNo05k+
i8y5OYr3mJGE2alF9lnIY3H6vcUKztwxe05fMRVkpxb92VwGzee2yPN4r4H3
OKaTQXZmSmQ/BrkSp6tXrFgqsYLzLGwFZ8lpoKgflEne8n/zxt/Em+Ml/BNB
fq4R8s9ar3VxJo8j/w6rfVowHrQgmPnB50izx6NZ+829A9nJk7DTxzDbWwNK
w9i5vugJ1/u0phG0RlDFt3AMRuz5hPXdvf5GsDfdWceCrIwNq0AZtDGYCViV
lc/1OQZha5gP0hpfhz4LPbPgDq6MfTTITr+q7Ln1twTcKuSdPu0YCdrBXLRp
vV6x3laAeuG9WBnvmSF6pGUfT5oVl/tkHQ6yhvIhEYeAtuzfIpED/PTBvfEz
nnisZV64CLkSp1loP5FgKGgFazjjZgXX9EIQvftMKLNmMGjNIuSROOwDfBV6
1sPKCMewN3bGVt8HHAfaHGSycS2WWVMPWsN6mXugeaAxW3IvXWYF8xWdtYlL
SB7q3lm2GMt4k7mpZ8j0hYxevhMaLDA140y8zzw7Kvax35tgZ5zw8eM4VwvW
LMZp7C9+kfxIM3eTcdgKWZLz5sE9SM4GrxYwX6QN/KqcHYyOHlWPmglFa+bs
Le6oGJX4xRdtRFgV9W9BD19uiXtJZg+0ZBhy0yyR8aj5HOyBOZ/l+C7kKGYi
M5NYMws4P8st8H0QfTYtqAUYpe9eCwvvBvuxxDPDZoklzBe405u3seCejNGl
3CKf19wdqEW56M0aUbe5zVHkrrVSsKFqSMzKsxG8/TNiXWkqDteT3sOC9p9c
8cwfQrUcUWfux7UZZpcH9PtZHyT9FUaZfzJ/a50IBqS++imxrVPnrHfeNL6N
OK2FVFvFk6de+eKO12F+wdjDsZLqfdXyk86srHfeNzvp2xPeShw+7WHU5Rpp
GuewjbLOwvT00Kwp8tEbMG9g3GV+7D7e6yVZXy+9ZK1hQFkZAcv2L/SWXg8Z
iosnad1Z6UfKciTKszbGdRvjTg6eqBS+aMLqZ8PMkRktmTN7XlWPs2d0SR7R
nY1PuToZGZnpe/5YM9ZrmXZJHMKsHG+yMsZMQR6N0x2mjOyNnlhZRyIrPSj3
Eb6LV8VOdqZnimnMCMSnhL1h35WziP6F+4W643cY70CDOSpXS8LPKpLGldyK
V0+b848yltrjzHt3S9jl2w20RWFNmFl9zma8Ai4ZinTwAMisN9QLyIyBnVhp
c9536dUAOkepVkBn1ni+8KVFQ4awUhg56dcnYAzlJXlGraS7Vyx8CY+9eqdk
308yUvyP++ZjFGfGxS/g/rMep15cfnNOcAVUCszMi1lNDO15RGQ8oVfch6ye
IBdLdU6rDawkncK7wlW39Sy9pO/bgzwW5Er6qxGo5XdPumcTjFyTxn0TzxtH
cDHjb5Z8Hfdr9DwfQdYom7thlPCxDsO8nt6Y3p2nGFcDY+Dvp71k/YWZK1l9
1SzE6SlvMcaQZdm+GytajGDM6ZbibPUxH1MqnZHjvSXWjkbzIx6nZxppHSsf
OQY62CvADtahcv5/Pc5WZvK4qc3cM4XO3zzLyebX3Em570x2Z7yTxfzVT+22
7DdPQCcMLalb+q0PomS9hXzjHbSfitOzC0FLqv9l5yZeV2Qk3M58L1ohaslp
2xm8xbyOGVjolp00+4wbMduTk2TeRwvV9dJYkurJXaKa+YSqZc6Cmtx58Bs7
wZqdaWfRdg2tYb8HDS25vcJ6T6jH3rOsnty8amSy+uR+ECt76sX3iyftD82G
5O4Uq3CMDfdNW79WIXNkNLtj2sn9Pd9/UuuW2Z3cfOQOjmdM1+PMLiJiPZ+5
yq5pJzdMebuPedMl01aPH102e6m1Y1oa9yLeAWRFxG+oaLYa7aKVJ6pnDVtv
0VkE4KxNZa+KPVDta3F2NqZaXpHW+3AR7xVyjvo9kc9V+wZamUt5LeoL1b6J
Vq6mOdPWG24R7yxyTz1l2t+q9i3rXeisWES9qxbdVlrmA15D0RtqOivz8dtX
tSbLUfa+Y8vK69Kqt8o0uxSCVypFA/8D/EwkaA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->515260644]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "=", " ", 
  RowBox[{"KnotData", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"7", ",", "2"}], "}"}], ",", "\"\<SpaceCurve\>\""}], 
   "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1849215138],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "6.283185307179586`"}], "}"}], "}"}], 
        ",", "\<\"<>\"\>"}], "]"}],
      False,
      Editable->False], "[", "#1", "]"}], ",", 
    RowBox[{
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "6.283185307179586`"}], "}"}], "}"}], 
        ",", "\<\"<>\"\>"}], "]"}],
      False,
      Editable->False], "[", "#1", "]"}], ",", 
    RowBox[{
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "6.283185307179586`"}], "}"}], "}"}], 
        ",", "\<\"<>\"\>"}], "]"}],
      False,
      Editable->False], "[", "#1", "]"}]}], "}"}], "&"}]], "Output",
 ImageSize->{352, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->159198022]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"g", "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"Axes", " ", "\[Rule]", " ", "False"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->114632519],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->662717089]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1772724453],

Cell[TextData[{
 "3D images of knots are ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->2139246740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"KnotData", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"7", ",", "1"}], "}"}], ",", " ", "\"\<Image\>\""}], "]"}], " ", 
  "//", "Head"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->499020386],

Cell[BoxData["Graphics3D"], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1039533064]
}, Open  ]],

Cell["Get the 3D primitives for the \"Image\": ", "ExampleText",
 CellID->213864802],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"KnotData", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"7", ",", "1"}], "}"}], ",", " ", "\"\<ImageData\>\""}], "]"}], 
  " ", "//", "Short"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1745451175],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"GraphicsComplex", "[", 
    RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}], "]"}], "}"}],
  Short]], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//Short=",
 CellID->811572692]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->429025249],

Cell[TextData[{
 "2D diagrams of knots are ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " objects: "
}], "ExampleText",
 CellID->268422764],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"KnotData", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"7", ",", "1"}], "}"}], ",", " ", "\"\<KnotDiagram\>\""}], "]"}],
   " ", "//", "Head"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1535864782],

Cell[BoxData["Graphics"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->525954134]
}, Open  ]],

Cell["Get the 2D primitives for the \"KnotDiagram\": ", "ExampleText",
 CellID->185084929],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"KnotData", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"7", ",", "1"}], "}"}], ",", " ", "\"\<KnotDiagramData\>\""}], 
   "]"}], " ", "//", "Short"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->423047553],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "0.5252709465`"}], ",", "0.`"}], "}"}], ",", 
           RowBox[{"\[LeftSkeleton]", "146", "\[RightSkeleton]"}]}], "}"}], 
         "]"}], "}"}]}], "}"}], "}"}], ",", 
    RowBox[{"\[LeftSkeleton]", "6", "\[RightSkeleton]"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}], "}"}], "]"}], 
        "}"}]}], "}"}], "}"}]}], "}"}],
  Short]], "Output",
 ImageSize->{571, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//Short=",
 CellID->39705527]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->852451040],

Cell[TextData[{
 "A property that is not applicable to a knot has the value ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Missing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Missing"], "[", "\"\<NotApplicable\>\"", "]"}]], 
  "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1281220143],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<TorusKnot\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}]}], "}"}], ",", 
   "\"\<HyperbolicVolume\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->648414932],

Cell[BoxData[
 RowBox[{"Missing", "[", "\<\"NotApplicable\"\>", "]"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->106671966]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->160146669],

Cell[TextData[{
 "A property that is not available for a knot has the value ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Missing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Missing"], "[", "\"\<NotAvailable\>\"", "]"}]], 
  "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->187464565],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<PretzelKnot\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "5"}], "}"}]}], "}"}], ",", 
   "\"\<OzsvathSzaboTau\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10131782],

Cell[BoxData[
 RowBox[{"Missing", "[", "\<\"NotAvailable\"\>", "]"}]], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33197264]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1309815905],

Cell[TextData[{
 "A property that is unknown for a knot has the value ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Missing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Missing"], "[", "\"\<Unknown\>\"", "]"}]], 
  "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->221049938],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"8", ",", "13"}], "}"}], ",", " ", "\"\<ConcordanceOrder\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->39598656],

Cell[BoxData[
 RowBox[{"Missing", "[", "\<\"Unknown\"\>", "]"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11276529]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1304052878],

Cell["Specify a list of properties for a knot: ", "ExampleText",
 CellID->451374594],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "\"\<AlexanderBriggsNotation\>\"", ",", " ", "\"\<ConwayNotation\>\"", 
     ",", "\"\<Prime\>\""}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1340560154],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["5", "2"], ",", "\<\"32\"\>", ",", "True"}], "}"}]], "Output",\

 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->258429233]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1020263627],

Cell["Braid index of a knot:", "ExampleText",
 CellID->908517580],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "1"}], "}"}], ",", "\"\<BraidIndex\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1622964794],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1191751654]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->731399553],

Cell["Braid word as a list:", "ExampleText",
 CellID->435891843],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "1"}], "}"}], ",", "\"\<BraidWord\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->846236890],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{224, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->671128321]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1991203653],

Cell["Braid word notation:", "ExampleText",
 CellID->714231107],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "1"}], "}"}], ",", "\"\<BraidWordNotation\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1796112266],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1U80OgjAMLow/o8hFExAPPIhnPfkQCzGBg9Eg7z+7dQgZLEiMJKPtt+9r
uzKuvK1ud97WJS8uDX9Wdfkqzo8GIeYAwAlXkgL6Aj21dkIIhk6ubYiW3j5G
kYwkLNQDWwtOqpWBmnEysx+oLK7uxDN2bXi0kE9VgJHpmOB/GLRBhBHqDrJB
N4kvtQoN+k66JOFPHbGpb7FEO0Kj6X6Gs7VqY+vU7JrNbD1/Qa3p81MNmdeH
/n7HRrxWrFRHmbaOQuWf4hk3QLp7C06qg4Hmf2dletbH4czxEG8d6BBD\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->121513731]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1922124770],

Cell["Braid image:", "ExampleText",
 CellID->45204272],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "1"}], "}"}], ",", "\"\<BraidImage\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1686472113],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{114, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->136880620]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell[TextData[{
 "The ",
 Cell[BoxData["20"], "InlineFormula"],
 " amphichiral knots having ",
 Cell[BoxData["10"], "InlineFormula"],
 " or fewer crossings:"
}], "ExampleText",
 CellID->2013064109],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", "\"\<Amphichiral\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150393535],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "33"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "37"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "43"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "45"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "79"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "81"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "88"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "99"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "109"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "115"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "118"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "123"}], "}"}]}], "}"}]], "Output",
 ImageSize->{458, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->664578845]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->182521853],

Cell["Number of prime knots per crossing numbers:", "ExampleText",
 CellID->1038135455],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"KnotData", "[", 
      RowBox[{"#", ",", 
       RowBox[{"{", 
        RowBox[{"\"\<CrossingNumber\>\"", ",", " ", "\"\<Prime\>\""}], 
        "}"}]}], "]"}], " ", "&"}], " ", "/@", " ", 
    RowBox[{"KnotData", "[", "All", "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->326550819],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Count", "[", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"#", ",", " ", "True"}], "}"}]}], "]"}], " ", "&"}], "/@", " ", 
  
  RowBox[{"Range", "[", "10", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->644734821],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "1", ",", "1", ",", "2", ",", "3", ",", "7", ",", "21", 
   ",", "49", ",", "165"}], "}"}]], "Output",
 ImageSize->{217, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1725603995]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1647565075],

Cell["The trefoil is a tricolorable knot:", "ExampleText",
 CellID->1293239606],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", 
  RowBox[{"\"\<Trefoil\>\"", ",", "\"\<ColoringNumberSet\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->796066755],

Cell[BoxData[
 RowBox[{"{", "3", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->608924719]
}, Open  ]],

Cell["Tricolorable trefoil:", "ExampleText",
 CellID->972071107],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Transpose", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Red", ",", "Blue", ",", "Green", ",", "Red"}], "}"}], ",", 
     RowBox[{"KnotData", "[", 
      RowBox[{"\"\<Trefoil\>\"", ",", " ", "\"\<KnotDiagramData\>\""}], 
      "]"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1690992620],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->153757452]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->997556379],

Cell["The two-bridge knots are exactly the rational knots:", "ExampleText",
 CellID->525229724],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"knots", " ", "=", 
  RowBox[{"Select", "[", 
   RowBox[{
    RowBox[{"KnotData", "[", "All", "]"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"KnotData", "[", 
       RowBox[{"#", ",", "\"\<BridgeIndex\>\""}], "]"}], " ", "\[Equal]", " ",
       "2"}], "&"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1378182098],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{520, 186},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->622175287]
}, Open  ]],

Cell["Number of rational knots per crossing numbers:", "ExampleText",
 CellID->1594148161],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "[", 
   RowBox[{"x", ",", 
    RowBox[{"Count", "[", 
     RowBox[{"%", ",", " ", 
      RowBox[{"_", "?", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"KnotData", "[", 
           RowBox[{"#", ",", " ", "\"\<CrossingNumber\>\""}], "]"}], 
          "\[Equal]", "x"}], "&"}], ")"}]}]}], "]"}]}], "]"}], " ", "/@", " ",
   
  RowBox[{"Range", "[", "10", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->435331138],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "1", ",", "1", ",", "2", ",", "3", ",", "7", ",", "12", 
   ",", "24", ",", "45"}], "}"}]], "Output",
 ImageSize->{210, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1851695291]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"%", ",", 
   RowBox[{"Filling", "->", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1631575639],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 0.}, {2., 0.}, {3., 1.}, {4., 1.}, {5., 2.}, {6., 
   3.}, {7., 7.}, {8., 12.}, {9., 24.}, {10., 45.}, {3., 0.}, {4., 0.}, {5., 
   0.}, {6., 0.}, {7., 0.}, {8., 0.}, {9., 0.}, {10., 0.}, {1., 0.}, {2., 
   0.}, {3., 1.}, {4., 1.}, {5., 2.}, {6., 3.}, {7., 7.}, {8., 12.}, {9., 
   24.}, {10., 45.}}, {{{}, {}, {}, {}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.2], LineBox[{11, 3}], LineBox[{12, 4}], 
      LineBox[{13, 5}], LineBox[{14, 6}], LineBox[{15, 7}], LineBox[{16, 8}], 
      LineBox[{17, 9}], LineBox[{18, 10}]}}, {{}, 
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{19, 20, 21, 22, 23, 24, 25, 26, 27, 28}]}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 10.}, {0., 45.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->109743513]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->647109500],

Cell["A stick knot:", "ExampleText",
 CellID->1112178092],

Cell[BoxData[
 RowBox[{
  RowBox[{"points", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"KnotData", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"5", ",", "2"}], "}"}], ",", "\"\<SpaceCurve\>\""}], "]"}], 
      "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", "0.5"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->770476583],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Red", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Cylinder", "[", 
        RowBox[{"#", ",", " ", "0.2"}], "]"}], "&"}], " ", "/@", " ", 
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{"points", ",", " ", 
         RowBox[{"Append", "[", 
          RowBox[{
           RowBox[{"Rest", "[", "points", "]"}], ",", " ", 
           RowBox[{"First", "[", "points", "]"}]}], "]"}]}], "}"}], "]"}]}]}],
     "}"}], " ", ",", 
   RowBox[{"Boxed", "\[Rule]", " ", "False"}], ",", 
   RowBox[{"ViewPoint", "\[Rule]", " ", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"-", "0.5"}], ",", "5"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->445093023],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 0, 0], 
   CylinderBox[{{-2., -2.666666666666667, -0.16666666666666666`}, {
    0.3749687964498989, -1.5676055121729418`, -0.5066492177082621}}, 0.2], 
   CylinderBox[{{
    0.3749687964498989, -1.5676055121729418`, -0.5066492177082621}, {
    0.026596870833048514`, -0.027420847766606707`, 0.5414184459162842}}, 0.2],
    CylinderBox[{{0.026596870833048514`, -0.027420847766606707`, 
    0.5414184459162842}, {-1.8755321191811747`, 
    2.9319121205305683`, -0.5292380414840084}}, 0.2], 
   CylinderBox[{{-1.8755321191811747`, 
    2.9319121205305683`, -0.5292380414840084}, {-0.5342522819150702, 
    4.192514640958961, 0.5354066209206029}}, 0.2], 
   CylinderBox[{{-0.5342522819150702, 4.192514640958961, 
    0.5354066209206029}, {2.3211119726391507`, 
    1.1580554102606477`, -0.5444665186399221}}, 0.2], 
   CylinderBox[{{2.3211119726391507`, 
    1.1580554102606477`, -0.5444665186399221}, {
    2.7667713916631587`, -2.4910047881216633`, 0.023871847912754336`}}, 0.2], 
   CylinderBox[{{2.7667713916631587`, -2.4910047881216633`, 
    0.023871847912754336`}, {0.12688582544520818`, -1.973238585210593, 
    0.6659568819489088}}, 0.2], 
   CylinderBox[{{0.12688582544520818`, -1.973238585210593, 
    0.6659568819489088}, {-0.47197604869746906`, -0.5247105724451935, \
-0.41075532780143725`}}, 0.2], 
   CylinderBox[{{-0.47197604869746906`, -0.5247105724451935, \
-0.41075532780143725`}, {1.5470934944595798`, 1.901423301681951, 
    0.4294087288270175}}, 0.2], 
   CylinderBox[{{1.5470934944595798`, 1.901423301681951, 
    0.4294087288270175}, {1.2491131267640647`, 
    4.464395077077012, -0.3069474444820009}}, 0.2], 
   CylinderBox[{{1.2491131267640647`, 
    4.464395077077012, -0.3069474444820009}, {-1.51267873219528, 
    2.3406891063208657`, 0.30358018104318113`}}, 0.2], 
   CylinderBox[{{-1.51267873219528, 2.3406891063208657`, 
    0.30358018104318113`}, {-3.266574256853465, -1.9195243980745107`, 
    0.08786904413561623}}, 0.2], 
   CylinderBox[{{-3.266574256853465, -1.9195243980745107`, 
    0.08786904413561623}, {-2., -2.666666666666667, -0.16666666666666666`}}, 
    0.2]},
  Boxed->False,
  ViewPoint->{0, -0.5, 5}]], "Output",
 ImageSize->{184, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2068200291,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(13)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 "Graphics data of knots can be used in ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->1347366831],

Cell[BoxData[
 RowBox[{
  RowBox[{"data1", " ", "=", " ", 
   RowBox[{"KnotData", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6", ",", "2"}], "}"}], ",", "\"\<ImageData\>\""}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1849870484],

Cell[BoxData[
 RowBox[{
  RowBox[{"data2", " ", "=", " ", 
   RowBox[{"KnotData", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6", ",", "2"}], "}"}], ",", "\"\<BraidDiagramData\>\""}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1081920943],

Cell["A 3D image:", "ExampleText",
 CellID->32308904],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"Green", ",", "data1"}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1652466969],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->141988257]
}, Open  ]],

Cell["A braid image:", "ExampleText",
 CellID->1557074205],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Transpose", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}], ",", "data2"}], 
    "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->510441093],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{75, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->253180354]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->328833270],

Cell["Alexander polynomials are symmetric:", "ExampleText",
 CellID->1225345159],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"KnotData", "[", 
       RowBox[{"#", ",", "\"\<AlexanderPolynomial\>\""}], "]"}], "[", "t", 
      "]"}], " ", "\[Equal]", "  ", 
     RowBox[{
      RowBox[{"KnotData", "[", 
       RowBox[{"#", ",", "\"\<AlexanderPolynomial\>\""}], "]"}], "[", 
      RowBox[{"1", "/", "t"}], "]"}]}], " ", ")"}], "&"}], " ", "/@", " ", 
  RowBox[{"Take", "[", 
   RowBox[{
    RowBox[{"KnotData", "[", "All", "]"}], ",", " ", "10"}], "]"}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->7912583],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 ImageSize->{399, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1387476493]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->125743379],

Cell[TextData[{
 "Alexander polynomials of oriented knots take values ",
 Cell[BoxData["1"], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 " at ",
 Cell[BoxData["1"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->245062205],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"KnotData", "[", 
     RowBox[{"#", ",", "\"\<AlexanderPolynomial\>\""}], "]"}], "[", "1", 
    "]"}], " ", "&"}], " ", "/@", " ", 
  RowBox[{"Take", "[", 
   RowBox[{
    RowBox[{"KnotData", "[", "All", "]"}], ",", " ", "10"}], "]"}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->2034328136],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
   ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1939978725]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->970820138],

Cell["\<\
Alexander polynomials can be expressed in terms of the Seifert matrix:\
\>", "ExampleText",
 CellID->2140793107],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Det", "[", 
    RowBox[{
     RowBox[{"t", " ", "#"}], " ", "-", " ", 
     RowBox[{"Transpose", "[", "#", "]"}]}], "]"}], " ", "&"}], " ", "@", " ",
   
  RowBox[{"KnotData", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "1"}], "}"}], ",", " ", "\"\<SeifertMatrix\>\""}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1368727511],

Cell[BoxData[
 RowBox[{"1", "-", "t", "+", 
  SuperscriptBox["t", "2"]}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2125702321]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"t", " ", 
   RowBox[{
    RowBox[{"KnotData", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "1"}], "}"}], ",", "\"\<AlexanderPolynomial\>\""}], 
     "]"}], "[", "t", "]"}]}], "//", "Apart"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->789503556],

Cell[BoxData[
 RowBox[{"1", "-", "t", "+", 
  SuperscriptBox["t", "2"]}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1140957555]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->611791480],

Cell["\<\
Conway polynomials are modified versions of Alexander polynomials:\
\>", "ExampleText",
 CellID->227702524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"KnotData", "[", 
   RowBox[{"\"\<Trefoil\>\"", ",", "\"\<AlexanderPolynomial\>\""}], "]"}], 
  "[", 
  RowBox[{"t", "^", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->180461914],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  FractionBox["1", 
   SuperscriptBox["t", "2"]], "+", 
  SuperscriptBox["t", "2"]}]], "Output",
 ImageSize->{74, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1192142822]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"KnotData", "[", 
    RowBox[{"\"\<Trefoil\>\"", ",", " ", "\"\<ConwayPolynomial\>\""}], "]"}], 
   "[", 
   RowBox[{"t", "-", 
    RowBox[{"1", "/", "t"}]}], "]"}], " ", "//", "Apart"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1442899368],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  FractionBox["1", 
   SuperscriptBox["t", "2"]], "+", 
  SuperscriptBox["t", "2"]}]], "Output",
 ImageSize->{74, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->321982844]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1854035451],

Cell["Identities for Jones polynomials:", "ExampleText",
 CellID->786106987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"KnotData", "[", 
      RowBox[{"#", ",", "\"\<JonesPolynomial\>\""}], "]"}], "[", "1", "]"}], 
    "\[Equal]", "1"}], " ", "&"}], " ", "/@", " ", 
  RowBox[{"{", 
   RowBox[{"\"\<Trefoil\>\"", ",", " ", "\"\<FigureEight\>\""}], 
   "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->780734165],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2054352315]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"KnotData", "[", 
      RowBox[{"#", ",", "\"\<JonesPolynomial\>\""}], "]"}], "[", 
     RowBox[{"E", "^", 
      RowBox[{"(", 
       RowBox[{"2", " ", "Pi", " ", 
        RowBox[{"I", "/", "3"}]}], ")"}]}], "]"}], "\[Equal]", "1"}], " ", 
   "&"}], " ", "/@", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"7", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"8", ",", "2"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->412105970],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->257281739]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"KnotData", "[", 
       RowBox[{"#", ",", "\"\<JonesPolynomial\>\""}], "]"}], "'"}], "[", "1", 
     "]"}], "\[Equal]", " ", "0"}], " ", "&"}], " ", "/@", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"9", ",", "14"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "165"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1662998501],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1249605962]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1752136214],

Cell[TextData[{
 "A torus knot ",
 Cell[BoxData[
  FormBox[
   RowBox[{"T", "(", 
    RowBox[{"p", ",", "q"}], ")"}], TraditionalForm]], "InlineMath"],
 " has a mirror ",
 Cell[BoxData[
  FormBox[
   RowBox[{"T", "(", 
    RowBox[{"p", ",", 
     RowBox[{"-", "q"}]}], ")"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->1857581034],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Framed", "[", 
    RowBox[{"KnotData", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<TorusKnot\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"4", ",", "9"}], "}"}]}], "}"}], ",", 
      "\"\<KnotDiagram\>\""}], "]"}], "]"}], ",", 
   RowBox[{"Framed", "[", 
    RowBox[{"KnotData", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<TorusKnot\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"4", ",", 
          RowBox[{"-", "9"}]}], "}"}]}], "}"}], ",", "\"\<KnotDiagram\>\""}], 
     "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->247178352],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{406, 192},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1821245]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1516916218],

Cell[TextData[{
 "The torus ",
 Cell[BoxData[
  FormBox[
   RowBox[{"T", "(", 
    RowBox[{"p", ",", "q"}], ")"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"T", "(", 
    RowBox[{
     RowBox[{"-", "p"}], ",", 
     RowBox[{"-", "q"}]}], ")"}], TraditionalForm]], "InlineMath"],
 " are equivalent:"
}], "ExampleText",
 CellID->649822830],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Framed", "[", 
    RowBox[{"KnotData", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<TorusKnot\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"8", ",", "11"}], "}"}]}], "}"}], ",", 
      "\"\<KnotDiagram\>\""}], "]"}], "]"}], ",", 
   RowBox[{"Framed", "[", 
    RowBox[{"KnotData", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<TorusKnot\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "8"}], ",", 
          RowBox[{"-", "11"}]}], "}"}]}], "}"}], ",", "\"\<KnotDiagram\>\""}],
      "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1617958815],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{406, 192},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->136664489]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2078356264],

Cell["\<\
Kauffman polynomials are generalizations of Jones polynomials:\
\>", "ExampleText",
 CellID->2112210593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"KnotData", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "2"}], "}"}], ",", "\"\<KauffmanPolynomial\>\""}], 
    "]"}], "[", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"t", "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "4"}], ")"}]}]}], ",", 
    RowBox[{
     RowBox[{"t", "^", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "/", "4"}], ")"}]}], "+", 
     RowBox[{"t", "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "4"}], ")"}]}]}]}], "]"}], "//", "Apart"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->2018751641],

Cell[BoxData[
 RowBox[{"t", "-", 
  SuperscriptBox["t", "2"], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["t", "3"]}], "-", 
  SuperscriptBox["t", "4"], "+", 
  SuperscriptBox["t", "5"], "-", 
  SuperscriptBox["t", "6"]}]], "Output",
 ImageSize->{147, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1146422221]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"KnotData", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"5", ",", "2"}], "}"}], ",", "\"\<JonesPolynomial\>\""}], "]"}], 
  "[", 
  RowBox[{"1", "/", "t"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1528701600],

Cell[BoxData[
 RowBox[{"t", "-", 
  SuperscriptBox["t", "2"], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["t", "3"]}], "-", 
  SuperscriptBox["t", "4"], "+", 
  SuperscriptBox["t", "5"], "-", 
  SuperscriptBox["t", "6"]}]], "Output",
 ImageSize->{147, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->694987463]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2097425510],

Cell["\<\
Kauffman polynomials extend BLMHo polynomials to two variables:\
\>", "ExampleText",
 CellID->992292367],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"KnotData", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"5", ",", "2"}], "}"}], ",", "\"\<KauffmanPolynomial\>\""}], 
   "]"}], "[", 
  RowBox[{"1", ",", "t"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->557407184],

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{"4", " ", "t"}], "-", 
  RowBox[{"2", " ", 
   SuperscriptBox["t", "2"]}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["t", "3"]}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["t", "4"]}]}]], "Output",
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->490734608]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"KnotData", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"5", ",", "2"}], "}"}], ",", "\"\<BLMHoPolynomial\>\""}], "]"}], 
  "[", "t", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->168514940],

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{"4", " ", "t"}], "-", 
  RowBox[{"2", " ", 
   SuperscriptBox["t", "2"]}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["t", "3"]}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["t", "4"]}]}]], "Output",
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1439352176]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->486481065],

Cell["Kauffman and normalized bracket polynomials:", "ExampleText",
 CellID->66962311],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"KnotData", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "2"}], "}"}], ",", "\"\<KauffmanPolynomial\>\""}], 
    "]"}], "[", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"t", "^", 
      RowBox[{"-", "3"}]}]}], ",", 
    RowBox[{
     RowBox[{"1", "/", "t"}], "+", "t"}]}], "]"}], "//", "Apart"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1241415237],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", 
    SuperscriptBox["t", "24"]]}], "+", 
  FractionBox["1", 
   SuperscriptBox["t", "20"]], "-", 
  FractionBox["1", 
   SuperscriptBox["t", "16"]], "+", 
  FractionBox["2", 
   SuperscriptBox["t", "12"]], "-", 
  FractionBox["1", 
   SuperscriptBox["t", "8"]], "+", 
  FractionBox["1", 
   SuperscriptBox["t", "4"]]}]], "Output",
 ImageSize->{195, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1936222224]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"KnotData", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"5", ",", "2"}], "}"}], ",", "\"\<BracketPolynomial\>\""}], 
   "]"}], "[", "t", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->154129949],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", 
    SuperscriptBox["t", "24"]]}], "+", 
  FractionBox["1", 
   SuperscriptBox["t", "20"]], "-", 
  FractionBox["1", 
   SuperscriptBox["t", "16"]], "+", 
  FractionBox["2", 
   SuperscriptBox["t", "12"]], "-", 
  FractionBox["1", 
   SuperscriptBox["t", "8"]], "+", 
  FractionBox["1", 
   SuperscriptBox["t", "4"]]}]], "Output",
 ImageSize->{195, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1267215777]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->281768181],

Cell["\<\
Relation between normalized bracket polynomials and Jones polynomials:\
\>", "ExampleText",
 CellID->476376432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"KnotData", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"5", ",", "2"}], "}"}], ",", "\"\<BracketPolynomial\>\""}], 
   "]"}], "[", "t", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->639656608],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", 
    SuperscriptBox["t", "24"]]}], "+", 
  FractionBox["1", 
   SuperscriptBox["t", "20"]], "-", 
  FractionBox["1", 
   SuperscriptBox["t", "16"]], "+", 
  FractionBox["2", 
   SuperscriptBox["t", "12"]], "-", 
  FractionBox["1", 
   SuperscriptBox["t", "8"]], "+", 
  FractionBox["1", 
   SuperscriptBox["t", "4"]]}]], "Output",
 ImageSize->{195, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1500236740]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"KnotData", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"5", ",", "2"}], "}"}], ",", "\"\<JonesPolynomial\>\""}], "]"}], 
  "[", 
  RowBox[{"t", "^", "4"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->832107687],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", 
    SuperscriptBox["t", "24"]]}], "+", 
  FractionBox["1", 
   SuperscriptBox["t", "20"]], "-", 
  FractionBox["1", 
   SuperscriptBox["t", "16"]], "+", 
  FractionBox["2", 
   SuperscriptBox["t", "12"]], "-", 
  FractionBox["1", 
   SuperscriptBox["t", "8"]], "+", 
  FractionBox["1", 
   SuperscriptBox["t", "4"]]}]], "Output",
 ImageSize->{195, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->873389753]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->243141049],

Cell["\<\
The Arf invariant of a knot is related to the Alexander polynomial:\
\>", "ExampleText",
 CellID->1957713949],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "=", 
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{"KnotData", "[", "All", "]"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"Mod", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"KnotData", "[", 
           RowBox[{"#", ",", " ", "\"\<AlexanderPolynomial\>\""}], "]"}], "[",
           
          RowBox[{"-", "1"}], "]"}], ",", "8"}], "]"}], "\[Equal]", "1"}], 
      "&"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1701385156],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"KnotData", "[", 
    RowBox[{"#", ",", "\"\<ArfInvariant\>\""}], "]"}], " ", "&"}], " ", "/@", 
  " ", 
  RowBox[{"Take", "[", 
   RowBox[{"a", ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2098578722],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1010851426]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{"KnotData", "[", "All", "]"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{"Mod", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"KnotData", "[", 
            RowBox[{"#", ",", " ", "\"\<AlexanderPolynomial\>\""}], "]"}], 
           "[", 
           RowBox[{"-", "1"}], "]"}], ",", "8"}], "]"}], "]"}], "\[Equal]", 
       "5"}], "&"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->721968037],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"KnotData", "[", 
    RowBox[{"#", ",", "\"\<ArfInvariant\>\""}], "]"}], " ", "&"}], " ", "/@", 
  " ", 
  RowBox[{"Take", "[", 
   RowBox[{"b", ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->834192309],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
   ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->636785365]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell[TextData[{
 "The Perko pair is represented by the unique knot ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["10", "161"], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->865346106],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", 
  RowBox[{"\"\<Perko pair\>\"", ",", "\"\<AlexanderBriggsNotation\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1112746058],

Cell[BoxData[
 SubscriptBox["10", "161"]], "Output",
 ImageSize->{34, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->997680118]
}, Open  ]],

Cell[TextData[{
 "Exactly ",
 Cell[BoxData[
  FormBox["165", TraditionalForm]], "InlineMath"],
 " distinct prime knots with ",
 Cell[BoxData[
  FormBox["10", TraditionalForm]], "InlineMath"],
 " crossings are listed:"
}], "ExampleText",
 CellID->423333015],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Count", "[", 
  RowBox[{
   RowBox[{"KnotData", "[", "\"\<Prime\>\"", "]"}], ",", 
   RowBox[{"_", "?", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"KnotData", "[", 
        RowBox[{"#", ",", " ", "\"\<CrossingNumber\>\""}], "]"}], "\[Equal]", 
       " ", "10"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->344660594],

Cell[BoxData["165"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1061107109]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->744975096],

Cell["\<\
Braids of an even pretzel knot are shifted to end with a braid having an even \
crossing number:\
\>", "ExampleText",
 CellID->966776462],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KnotData", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<PretzelKnot\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "2", ",", "3"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->155055900],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{140, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17022521]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->589267740],

Cell["A tabbed list of knot diagrams:", "ExampleText",
 CellID->1046463213],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TabView", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"KnotData", "[", 
       RowBox[{"#", ",", "\"\<KnotDiagramData\>\""}], "]"}], ",", " ", 
      RowBox[{"Epilog", " ", "\[Rule]", " ", 
       RowBox[{"Inset", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"KnotData", "[", 
            RowBox[{"#", ",", "\"\<AlexanderBriggsNotation\>\""}], "]"}], ",",
            "Large"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"Right", ",", "Bottom"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Right", ",", "Bottom"}], "}"}]}], "]"}]}]}], "]"}], " ", 
    "&"}], " ", "/@", " ", 
   RowBox[{"Take", "[", 
    RowBox[{
     RowBox[{"KnotData", "[", "All", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "6"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1214271710],

Cell[BoxData[
 TabViewBox[{{1,"1"->
  GraphicsBox[{LineBox[CompressedData["
1:eJwt1Hs0FPgXAHBLFGpRtlVYRFbNeL/yvHmTLXnbIlNhpPJIkahEiPGKhLTl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     "]], LineBox[CompressedData["
1:eJwV13c8lV8YAHBJVsoIpYhCKLLKih4UshokuyIpDSPJrMgoeyauvWe2bMe6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     "]], LineBox[CompressedData["
1:eJwV13k4VF8cBnBJSSVSUilbm1JIUbbe/JQtZUkpipJCaZMIIYmorJUlyhIi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     "]], LineBox[CompressedData["
1:eJwt1nk8lN/3AHCpKKEkKq0SZcuapeQgRNkqkSXtWSokilJ2WQsfpCxF1ggh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     "]]},
   Epilog->InsetBox[
     BoxData[
      FormBox[
       StyleBox[
        SubscriptBox["3", "1"], Large, StripOnInput -> False], 
       TraditionalForm]], {Right, Bottom}, {Right, Bottom}]]}, {2,"2"->
  GraphicsBox[{LineBox[CompressedData["
1:eJwV13k8lF0bB3BbCemxFiIVeSRLsq9XSBJZkrK0WsoSGpVsZYlIKExRllRP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     "]], LineBox[CompressedData["
1:eJwV1nk8VF8bAHCEVlTUL5GSQlRoVdFTomQJiUiWvGUpIYnKlhJFlmxpERGi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     "]], LineBox[CompressedData["
1:eJwV13c81d8fB3AZWdFARSgVkaaUZJyUlajMRIOyR0YyKgplhMgsK5lRZGSP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     "]], LineBox[CompressedData["
1:eJwd13c81d//AHCpkJLM7EpSlNWwGi+UolIolFWhUJ9CVkUDSUQaSEIJWSF7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     "]], LineBox[CompressedData["
1:eJwV1nc81V8YB3CyKZVUSEY7MkJFpRNFEkIZFYUS0ZSsrFQqlezsvfee8dj7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     "]]},
   Epilog->InsetBox[
     BoxData[
      FormBox[
       StyleBox[
        SubscriptBox["4", "1"], Large, StripOnInput -> False], 
       TraditionalForm]], {Right, Bottom}, {Right, Bottom}]]}, {3,"3"->
  GraphicsBox[{LineBox[CompressedData["
1:eJwd1nc81d8fB3AiEaVhj69ChDJCGfEuK8o3W1IhSUIyIpSRIiF7Za+QTVbW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     "]], LineBox[CompressedData["
1:eJwV1nk8VO8XB3CVpKgQoRJKe5aSQr5OhaiEqKS+X/1EZS1UREpKKiVKhhKl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     "]], LineBox[CompressedData["
1:eJwV13k4lU0UAHBLkrSRiFAILWRLZesoRVHJVpHIli9SKRRSpKRs2SqKLBFK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     "]], LineBox[CompressedData["
1:eJwV1nc8V98bAHCrqEQJZUUllIooofGEyCjJTCHzi4zsmU1kjz5mRvjYVD5S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     "]], LineBox[CompressedData["
1:eJwV13c81d8fB3AJJRlRoUIlaVBCUuGKymhqGSkp0kCZlZVIKpnZIUplVeZX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     "]], LineBox[CompressedData["
1:eJwV1nc8le0bAHApIaJSkiihQUjRD60rRZKRkayWlt70vk2jU0myGpSVvUdo
0SmFwxn3c6SNDpLxpIyUmcj2u84f53M+38/9PM9939c9rmvZ4dN2x0RFRESm
8Cf8bxPrGzvSIACPqhqvyjEmu8TQUKO5UQA7facfZgwx2ccrleydmgWQad61
Xr2fyQ6adz/RskUAXRZysd7tTLaOmt7M9R0C+HyYuUO5CtsvER2xAQFcmr3U
4Wg2k71fL/pp+qwa8Oor9WyxYbL5C309qoxqYIjTXhaX9ZTdfsesryGlBsKW
vs9bsraA/cXnj37ZZA1Yeg1Hr855wj4kNhxu41oLVa4SmmTkIfuAyU57NXYt
jJYeMTGSzWMztcI25SyugxiO8oGRPffZWnFvU1Su1sFun1Sf3gOZbPvKCNNv
dB2sT3Pgv/BMYx/MlHoERp9hakbA3IlLSezUz1rLFsZ9BvW6Mz9D7sWwF3ke
W32p/zM4bXGc5b4ggp2i/rhF0qweQuLVZbXcbrB9Pho3h6bXg8PEo6g3By6x
J8xffksdqocF0uvXU5Z72aUGa3ZttPkCjbfHW0D0HNQo6dwOzf4CUWI2l9tD
AyBgQ6/ztcEv8ET2aaaO5R04fLjHxMW8AV5Mzs8ZvhANvrdZXl+iG8DLu0is
sSEexkRmNZW0N8Cqj5zuZU6poPhrg5yofiNk+tYddVybAYKZDcsXMxphuFTj
kWltFmwI6mPUkUawcdqXb5CfA4f+kVW8OLMJ/i2/tTzf4QE86G1VzzRtgrfX
lgZSnY/Ab6bim7zgJrhluILNcMoHv1nf/ep5TWColTLQnFYAX87MHt0i0gxL
ol/3is9ggram7JMso2ZYl90Z+3jfM3gk1fIz5FQz5OmpXNmR8Bw2pnlqslKb
Yb52qQejvxDANgEiPzRDD3ks8lD7JXRrtPcUDTdDwqfi++cPFUHyrbdmxmo0
DKp47UjMLYZdCubttWY03K6WujivvgROb7F9LH6KhpFuBYs25VJ4tqTgIeMm
DXKsaL9V5mWwXznUVzmLBgml44uSTrLBYpu0om0ZDQOssPvTbDiww5T15j5a
9Nmv8C12HFDqvmUyiW5Y2el8aQ8HolmekXlsGhh6TP8/ThyIt29NEuHSEJkw
3aDNjQP3NJ4fSic02JdEruCc58DB/CMMVgUN43fdpu2L4UDc9HbavJqGQKf/
ZWk2cyD22g5+LLp8olIs7CsHirWen+hAh3k839T/jQMdkhmd1z/REGRjov2i
gwOHGmd9KhLQwJKuUzDu5wCDctmyqI6GVfmF861mcIHxkmGe3UBDOivcy1ST
C1S8RGsX2t5LMTpDiwsy2YKNeo00hFxYd2PaGi7MMZitxkbP6xnuZ+lxYRvs
+vipiYZraZv4azdzYdXb7XF9NA0u/wb+K2eDz/9g8v9+x/4LdicWenLhgsSr
ev1WGsKX8P+b4cMFgX7Rw7Po+XeTF9oxuLBfXvXOT/SRs+5dXb5ciClzNq1v
o4HHKkxTCeGCOHPybF4HDe193v/zi+dC1X3ZtMW/aHiY86NlKZsLn1QWBdqg
lVt1vE5wuZD8btPKQHRFxqqv+YQLDsuKs7rRW1JU1htXcMHm2tebJV00hMqH
fDtYxYUhTUbfrh4aqq+57Yj+zoXB1KoJg34azi5Pl/oqzoPwPutEN/T73mXH
xiV5cDnstcgtNKvEKE5BmgeirPTFTWjV00vDbebwwGi2c6zvbxrMOkzZZQo8
gOneuYUDNMzQnz83SoMHjAUB4mODNFweOOChasEDda9JV+UhGhauXSe7wYoH
21xrPQG9TFMm1HY3D+KKbo74o5cc/yDvZ88D1aGLW8X/0lCc89utwZUHPp1y
FTOGaVj7H1198xQPFMKNEz6N0HDl8e+pd6E8mP+tW9CH3ucwGi99lwcWLd0V
s0dpsJ1TKGEZwYM/5z/SO9D87nX73tzjwd+Hxyueo1me6d+oFB6wrttfDRrD
/te6nCgo4IFf7RbXFHTw6qHVPUwe5Ews7H+BNuj4ydUs5EGSHWPXD7TG+1dH
M4p50FVvyTQdp2Hu9SeBEYQHkhdiHAfQkjKGa07U8IDWPPpRfIIGE23mgvQ6
jF/jSxElNLd49YeGeh6IvPx6ZzuaZTH5zLqZB8nyPgfvoHMv3HBe18ED+6PV
6Wno1/o2H092Yjv7WgoT/bSoXT7jF453VTlVi161+dRiuT4e6ATplS2apMHP
2Wikb5gHdtMD3mqgq/9rHl85xgOVtKFwIzQjZXn1gQkebKlYtcsJLeV7vf/t
NAKbg2XcI9ALDzaJZs4i4PaudFMquufKQES9NAET031vH6Hvy/j+kZElUOJq
JVeBHsqvX31RjoB1s5XVCHrBKikPCyUCid9iVsyYokFnudo8lyUEjojyuTLo
Tin/uydUCCg3MjeroS1EReUC1Qnk9NhZmKPZQSE6LC0CC/nqenboP5TDndc6
BG7syG90QVdSJq9qdQkYRtAXPNDenp6sPn383naZohto/7CUEtXNBMbclR7f
RX99PyzQAQLHXxUfjRH2n23N32BMIPVKpHwmuj28SdPOlICjD5mbh25xnp26
34yA0+B/H56g/Vau7DphTmBRmdrtYvRLmCl51YrA00eqoWy05VZe/Y3dGC/3
kN0UOuSpw7UoWwLypbs/VaA9+kumku0JcP3OK7wXzsexb0+uAwHngJ4lVejV
xj1+TEcCr+NK2gXomRIF10udCYwaGxQ3CPuLPze7aj/G06eB34wOVToR9eUg
gUaJ0ogWtOQP2d/f3Qg8ompVWtG6TsdWdB8hMHFF7Uw7eurVkbVDx7D/mcl+
P4TxipgpN+VOoFPX2O4nOn6e+VvxkxifD+Jtv9DuGStc5pwisKqgy7Ab3ZgS
z1b4j8DSBz+tetDjh1PHVM4QgLBxtV50uZmejMY5Agwt5RKhN+Ra/9W9gPvD
0UyuD+30rbvQ0Avn0+KpJfQya2mrrT4ENJMyZgodY5ZVZMYgsNb1bZrw/Wca
z8atLxOQ6umYEPbnt1tffq8vgcyVfxSF/iO3bOZ+PwJ99T+Hu9Dy1Z7vjvgT
+FpbHiMcf1ur9j8nA3A9+vz/dqL33zdpPBNEwGN4kYJw/gEXni/3DiHQygka
aUPb3r9keuUmgXeLqYTv6Kr4iI3XbxMQb3g3+RU9mjsofiOMQGRlgqow/oI1
qXlhdwns+bBaXLg+e4ND1aIiCGzP9n5Yhw6WKjoXF0XAVpMxT7iexxcuiU2+
R+C0lo5RJfq32MvIjFgCN33DVN4J13+d/7GceAIhLrCWoHOfRN0qSMb9N//y
+TJ0QdTTogepON5zFT5F6NbcO+ysdAKxsZffPUbv/O5pF5dNYCrxi2IueoGZ
Fx2Rg/ubo6+VgR52Vje5nUdgkH4dcw89IeUT5fuYQI/CWP8ddNbP+X7e+Ti/
X/Nlhefn6F+r7WeeEjjzuSecgbZSvG7jVkjglQazSHj+PCZ9A43LCOTeSNUU
ns+xcn9tIw4BA5/dB4Tnt6Bk6qEuD+N5qXm2ATo9x37d0nKCdaphqKxwvJKd
DqPvCXRl5sqJCdfv4caivo8ENByf7xvF+0P2YutAexWBudyQ/7Wiw+as7K2u
wfWdHiPxXHjfPB4cz2kiIJprn5GDtlK6qphMEygtvy6SiB4s2Cgb2YLxbdcU
9UcXCjb5Xm4jUDtHWtUCPf1c61mrbgKmgoaPm9Dr4m/vNO4lYC42DDro1B8m
Q/r9BMI1Rd3noA95C2oXDxK41iD4WIX3rUjNnwcd4wQkj129w0U75GRs+DJJ
QM1299wC9N8USH0nQoH3WwtX4X2ud0m7L38GBYbpOhLm6J0ux9O9pSmwzdjL
zcd8YRjgYzmxmALl6oAf8Wh69LP7wiUUrAwMLg9A150LtVurQkH2jf5sRzRb
qjH6qDoFY8G5wyOYj14dP/+pQouCfw3Wf9FFy3dlLw/ZTIExi+0hjzaszdFL
AQqmSZcwxzD/te/NmlNoTEG/8q/jfLQh19vguykFW4L9nR3Q3WVtBhut8fuW
iifdMb+W3xCdajlAQXIE/+BOdPgm2dHBQxQ0dF6R0kBvWVxKJI9QUNk8HtCJ
+frctHaerjsF+gcCp46j5f9+PH35NAWedy1n78H8nl6gcnWWHwUuj+cdGvqD
98PLe5bT0iiQvizHqUTz9Jidv9IpULWbTuehI/YYuNZmUtBck+B8AJ2472hJ
Xg4Fk6dVjXlYfxgdqT5tm0/BiciFNVewPtmuLZZ1j01BYJFON+nF/P9uXEWk
mYLqiq3L7qF55cbb2mh8/lOK3An0oMJ+gzct2B6rqyeFnpE4IymyDeOxSHa/
NdZPuiMxDurdFFBRto4VWF/d+V3rvXmcAq24i7ybnTRYj3Ydslbkw2v+UU0b
dEFS4Jq9SnxYoelmsgB9M+7u6/1L+JDy4XxY8g+8Hy+2HzylyoewQQvGI6z/
nvb3zg/W5IOCvtoDFtaHpqEnE55u4MOwoblJagsN4ukB/S0ufPC5ZfuL8ZmG
3porvqnxfJgcCI/2QWd7Bqc/Qe/V5oAX+p/SgPIytMW89siz6NOmLjJN6LmZ
jhtPoCPWn01alMCHPU1VQQ7ofaHWRRHoJ46qc3TRYoLyjoBEPtymlF5qo0WP
mc6KQgtExA6tRn9PfKGVgT7bkfxkBVpjmvdZLjrVY9hKGZ0U7zY6gRbdsS14
Fhok2iW9k/iglrlIRwL9TDRldRB6pLJZIIa2y7CwikbfvbdOdZpwPHVX7zLR
WyunSv5ifU9J7JHvQ/PTTQ8PojX18wym0FnbL0oMoP3F/jjJJPNhe1/unh50
XdzhBC1011j26C/h+/uCWRvR3Jrw1E60Nz+laRf6xZWTOzrQPz49mHRG8wd0
u1rRMiEPlv6D/j8Xj4tW
     "]]},
   Epilog->InsetBox[
     BoxData[
      FormBox[
       StyleBox[
        SubscriptBox["5", "1"], Large, StripOnInput -> False], 
       TraditionalForm]], {Right, Bottom}, {Right, Bottom}]]}, {4,"4"->
  GraphicsBox[{LineBox[CompressedData["
1:eJwd1Qs0VlkbB3CSZFySEhFelGt41Vsq9Jduk6HJNVJTU6JcMjRIH6WSQiV0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     "]], LineBox[CompressedData["
1:eJwV13lYTO8XAPCUtCnaCxX6ovhGQiR1aNOelEqNJZQsLSS+hDZJpUhaEVJI
C61zb9uZe2emJEZRRKlQRCHZovB7f3/MM8/neec+c+55zznvvbO2Ba/3ExcT
E/tDPv//1jpt/37i0hS8syt/6t05LXC05NaJ35tS0Lkn59IL3Rbw1o+q/BCX
gkPumfO/zGoBC6O0torOFNRbnWilrd0CIy1h3S+iz+FltX3/HVBrAaHNWGvW
w1RM5q/qnSnVAsZm87BkWzo+XXlzy5eWh3A788T70aAL6JwrmePh8RB6zHQe
3PySi1nHY7OOOorAwsTkkk78DQy3+Vy42v0BCN2HUg/XFKKx5Cqn11vvg3ef
vI7N8G10bXUI7Pdqhri6HFEAvxTF49fmxW67BxIjMl/NTpSjsrO0d6xnE5Tt
mTCeKVOJYzI3c7a73oXMHjrK27oKI0qX/OrhNMLiqU5tjvZVuO7rxV01Xo3Q
dCGmyNSlCucun/Qs3b0RQou+DypsrMIHtR1cJ8dGkJtCZSXurcJpd4+F1Zg2
gm8Fa/PiXBVS3Y3D6dMaQcJLlNHdVYXDcpy3Th0NENIQdtHcn4u+/ifaatwa
oMGz4IrMbi72e9nVvnAh6yOno1sDubjTQSHvr0MDxPs/f+EZxsXdhpmhllYN
cMKs6a35CS6G/CpUal7aAIusRCNhV7l4LPnxuueqDVB5xWhp7DMuXqya/WD0
qRDmmFxZNNjFRa2CtxXT2oSw63PQuFMvFy9fKLq4qkUI0JcvLfuWi7mRxnsj
7wqB31DR6/OVi4X29nLStBAez1ho4q9AYXX3Pjv1bCG4/3R4rrSawo5JjHAZ
RwghkxyNJCwpNA5j5u3xEkKzeUbwsDWF518z8VfchbBd+2Im40ChM491knMS
whLVldnmnhQKDgvae82EMMBky14LpLB4qLE/UUcIcTOS1ZQzKYx+JJJ89UoA
USHGOy5nU9i1+uFO9R4BfPNKSdS7ROHK2w+bHDsFENQ26Lc4l8JviS1J3McC
wM/yoFVE4W7rR6pJArJ+/fniTUjhBqp9zorrAugbX3o2/DWF+jld1sm7BDB9
l4l8az+FdTM75uzzE8BUG6/G2QMUulx7LOnuK4DDXnKfq4coDLt5T6i5UQDD
sq7y9d8o5JVR1vm2AmiTKJowRYpGz8bz1rXzBGC6/L6GngyNg3Zn51zWFcDG
rzl+ZnI0HrufKBmtQ65XjM7hTKHxamu0cK26AKwn2UUGqtP4sTPE+vEkcn+G
Cy52zKUxetjR+n0/HwaqB55U6NGoGmo758FLPpx8OwxJ82m88c1S8s4LPvxd
KHXBaCGNol8rhWHtfMjO3RDgsoxGDUl96wlCPrw+3PyjxYLG25qS1hp5fDBo
yy8a9qaxy6LOymYbHzjpynYrOTRqhalcCt7Mh6Fqv9jITTRuvrHnW6Y3H/q0
jLvEt9L4Um7a9cH1fLD8+PdH9w4a37QdlEqx5MOTlvHUr4Ekfn/De53/8CF1
fsoE6WAaF2XFzZacxYczpZIyGiE0BjZ3H1moReI1Uegz2E/j50VJC6JU+VD1
VJVneJDG76PvTs+dxIfKzYKac8doFEu85rLvLQvvf5tmBx+n0aLu143s1yyY
pZ2ZbBdBY8wnVzFBDwufc+wKP0fSONFdrFStg4U8JqpB8wSN0lqblGrvsnBf
4GrSSWzvUrG7X8BCVP7YqqxYGuOj5PgKDAtrR3y+ycbRKPuGDvWlWfDgNOoI
42mcelutfdItFoY+divsSaBx/ctAA8PrLIRbiRLlE2k8pyyM3ZjLgv2CcgPb
0zSq/RdqXJTNwsUEBanzyTROW9OS4ZrIgmYHx1v7DI2c0HnDR+JYmCCKXJFP
fCn/uG1eDAtN+XdTb56lcaaswc/v4SzY3mypiT1H4+zH8d4X97KgG1t89Ddx
lmaXYWgAC6ZzB/X3pdKouHWhlP0OFh7b56x1PE/j76FH5T98yO+ztLnlxGFL
5iSIPFnwXKOqqJ5G6vHwoa35biyoLguPbiXumDRD3s2BhVCHb5l66TSucwp6
rb+WBS/XsYxwYkEqjxazZCGE4TmpZtBYMdPPv2QlC0HfEyQ4xPo7uatijVnI
ufP9cg7x1WIZZY4RC8b2dxPUM2lMXlmCMvPJ9V9XdDgRT4wSS++dw8Ixeqts
JPGRxvV7ubPI/vwRzCwh/iyfb5GsxQJff3BaB3GA+w8NP00Wmi97jf4m7s62
+2SqyoJLwzlKJ4v028sLQiVFFqrFdXzMiB/M+3jh3WRyP9XRPR7EVkGr9/Ok
WehZb2m9l5iuOGebMZGF4MVvEo8RLxrr0w4SYyGhZrgsgfjGmuXfrMYZyPQY
oFOJtU7FN08fZUAiYP2VTOJUUefVkS8MjKRX+mURv2oy+K/pEwPFqsMy6cRQ
s9v5yiADHyyCk5KJ1+zj/HPoLQO2dPFwNLHitaafTq8ZcFWeuzSUuE3qsOif
HgYKBtd7bSEu8VicO/acga6ukk1riWts6AOPnjBwMqrCagGx3pmn1gWPGDA9
0C0vR6z2dr1qpIiB8y436DckP9ckR1553GPgn5J423risavhJQYNDMTOF6tJ
ITYPrTo0kWXAeUusoi/xacNd5p11DKi8TXX8l1gpxVu8jGZgL+f63i9kPz84
uPJPVTLwaePy/VXE5hoqUVtKGVh8hNkURmxUvMvUuJgBr6TCgTekXo7LD+S9
zmNgd6VYfBaxztoct+orDKTuNlG0JR6eI/7n7EUS7xvozCT1d+P2Byvz8wxk
vBLXNiVuvyv+UuUsA0pPUu2fkfpltvceGkxkAOVlt8sQe41NScuMYWB2XJ/L
BVL/6/w/TQuOYMB92yE9feKkRWXZ1uEkXzfv5Kwg/RJDj58c2c9AMud50VzS
X0rlvpMdtzHQ+GXirWzSf8Fbep8u28xA/sWgWlnimlD2go43A0m6D2f3JJF8
S3fIfXFlIEE6THwj6Xc3R5+4rDUMTF9kW1VM5sHKPKmpMWYM/Nj5K/oPmRcK
9/3O7DVh4M3U+wHnT9GYgJv3wWIGJli07U8h80Z0dUNt30wG7H67/Gog82hZ
f+7XBzMYiG+2zxmNoTFl6/AsrgYDlleTzNZFk/1dUu4dP5UB6aWj/S1k/m0o
f29uIMZAkcxLS41DpF4iK3L39/Ag7k9x0xQyPxV8Lin6dPKgTGplqEQYyZeZ
7n7Lpzxw9dyypIfM2zonAymVhzz4+yH5QEAQOQ9knMIr6nmgNFl8K0vmuYGz
M2fkEg9k1s30Orqdxp14uflZFg8KCszCjbaR+KQX6DNpPDDJsbZK3UJjsYda
yZkkHnxLXvlxLjlPvjitf7bgGA9qrq6QynCm8aH0l9itHB78eKY9faETibdX
ISLJiwfjY1N6GQcSn1aDX7U7D85yEo/32JL6ee8xpuzEg+H5izW+kPNq43Mj
iwYzHli0JU09akwjWnA05unw4K6a0U316SS/KYF+pXwEvRJ+qrUmjSq82SqT
ahHi9XVXhZDztHKKYqp3BcLZBQJBjTKZV5tMxCTyERp/dOCCyTQerZuW7HoS
IexU7u3gcQqPjxou6LdF2GXLkU54TqHSsYUSfQ/qQX1h2TudDgplDKf4Jgrr
IdcgQLysncKtZsLDRnX14HynrfNeC4XBBcPPIorqQcu81fRhA4Uf0//aqifW
Azju0NQto1DVpi1ihW09hFPrUn/FUpj/fjKsYevAQsLKTiOGQk1xM+0eug7E
NbKsjSLJ/51cdetoaR3sbLdV9jlCYYbqu4aqK3XwSrN3SmQQhWt1yyfNi6iD
7dk/v6t7UHjr0EuzH6Z14PTXWBg9m8J/f3kfdqushdNbhjZv16FQ7PSfp2HF
tWDi2N+wegaFibwfLzPyayHQRk9iRJU8Hxkc//48rRbytK8sXyhD4ff2XvVN
B2uB68v2y3/iovuOBUPrlteClrO+eCBFng8jrDlfqRoIvrgmHddw0eevvL9a
TTVYrzf4GW3GxT7oPXqwrBo09QsoCxMuJmoeUX1SUA1qkhYuXEMu5vssvZea
WQ01E5MHDuhw8cA+xWUyB6shPsN0hcV4FQ5m9d7qNKyG8DvrSvXKqzD0TMD7
6ddpKH8WsWy1WhUuSb+/YTiZglV+7xbtoSvQOy7iV8z2Ksh49+Z0sVU5DjED
u0PcKmDJ9OuLqeOl+PFPlOse2TK4sPms/h6323hgNOflh8rbEK33Jmbx7kJ8
L/sk0MW1ELgL2j5ItV1HadsWedU912Gf63qld6tysWBU3S6l8iqkJpRvKOjN
wnkK/5g/eZUJYj9j/uCdJPSp8nlwwfc0rAj9zXqrhGBJ93k5+ncQpH1IPuyd
FAnjB69t4nccRzmByh3P1eehKyXAJGToHGbr7/xhufwKrKHbg94656B8uS47
V+4GpAX5Z51KzsfbGRarlqYVQ2iHWsKc+kK0/+nxfkVAGZz6uzJYwbMU9YVx
T+vbKsF9XfRG+TsV2Py18M2gMQ0VrEaXuxKFw8dmWY721YJX6H/lCztrUL5J
VveFHg+eRV0uaDuO+K5yc2n3XzLnRDI28xoZtMvmNYQ18mHCz8sR8W18jOPc
yXm3k7wHLJo/Wfe+EC0P5pyO1mmE0c/LowfHG5E/mJ5sVnQXXHx5UxzV7uH2
S9cKFGffg5mLyoKUje6j04rwh4Z5zbC8auqYSYIIxebHpLb/uA+15zrzP21v
wWXvNC8JnEXgU2bgsya3Ff871/hxkPjCwPmencQbJeVWK7uIYJm/xo5k4qmW
bi99idOWHwjsJO7/NaD9l7jPKCIq7Forjq/RO2niKoL8xFclBXmt6L7pw8QS
NxEIhd3aSjdasfaeq1078fQB0fUVxCefOSSNE3e4di7cQqzzREzFwV0EoWO2
UEQ8TS9oxgDxvzcO+drcbEUL1Q2asz1EINg6u/BIQSsaT1D2tCM2+Plk6VVi
zhH/8yHEIx036huJzaeI5JE4LyjnkcqtVlS5cnnMx1MEmSPdYyXEvo9kjGOI
JRrCTrYTP4+TCblF3N6rpzhOPPNQ06tR4uyh13PtClsxsCR++kwvESS/GCwN
Jm7a3uO2lviF6lSzdOI/afcSg/6/nrbubi3xPUsHfhpxHqfY7TXx/wCVl08j

     "]], LineBox[CompressedData["
1:eJwl13c8Vf8fB3AjhFBWSzJDWohIeVe+KaWslkRWQ4qs9tBAlEpDi6KSRKRk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     "]], LineBox[CompressedData["
1:eJwV1nc81d8fB3AhCUXZoiUVkhRfDXpnREJllJFIshORlCQJpYysooGsRBlZ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     "]], LineBox[CompressedData["
1:eJwl13k4VN8fB3DZSqKSJdmSUkSWorKEJCWhUoqUSotE2pREiVSiha8ioqKF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     "]], LineBox[CompressedData["
1:eJwd13k8VN8bB3CiFKVUkiVKaVGUskTysZc2RbvSQllSKZJISdGqlBCholCK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     "]]},
   Epilog->InsetBox[
     BoxData[
      FormBox[
       StyleBox[
        SubscriptBox["5", "2"], Large, StripOnInput -> False], 
       TraditionalForm]], {Right, Bottom}, {Right, Bottom}]]}, {5,"5"->
  GraphicsBox[{LineBox[CompressedData["
1:eJwV13c81H8cB3BNISt7lFEkexWK3uKXEUUa+vkh9aMUZUVFihLdaWgoZJSR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     "]], LineBox[CompressedData["
1:eJwV1nc4le8bAHBKJRWiUlJZlRANI5RbZURDpOgUvhUykgr5Cg1KylZGCcko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     "]], LineBox[CompressedData["
1:eJwV2Hk8VF8UAPAsWZKylSwlRWlPaPupEwmtqBTJVlGRJEQURVpsIUukssuS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     "]], LineBox[CompressedData["
1:eJwV13c8lV8cB3BSMtIQ0rKytZFktiQlvyKraZWRUdKkhEpL5NqipWGVFCr6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     "]], LineBox[CompressedData["
1:eJwV2Xc8lH8cAHAzI1QSWlRCIaWMRD5GWZkllVVpyY4kGSkjI0JkJLL3dnf2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     "]], LineBox[CompressedData["
1:eJwV12k4VV0UB/AilSGpNCCSBkJKiUJtlCEZMnOJhOKV8RpDCCHzlOHSJVNJ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     "]], LineBox[CompressedData["
1:eJwV13c8VW0cAHAK2VJZ8VJZDSOrpfrJijJ6syVJbyqSyMyMymxwbdde18jM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     "]]},
   Epilog->InsetBox[
     BoxData[
      FormBox[
       StyleBox[
        SubscriptBox["6", "1"], Large, StripOnInput -> False], 
       TraditionalForm]], {Right, Bottom}, {Right, Bottom}]]}}, 1]], "Output",\

 ImageSize->{198, 215},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->394451271]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->708330627],

Cell["Random-colored torus knots:", "ExampleText",
 CellID->73470108],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"RGBColor", " ", "@@", " ", 
          RowBox[{"RandomReal", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}], ",", "3"}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"Length", "[", "#", "]"}], "}"}]}], "]"}], ",", " ", "#"}], 
      "}"}], "]"}], "]"}], "&"}], " ", "@", 
  RowBox[{"KnotData", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<TorusKnot\>\"", ",", 
      RowBox[{"{", 
       RowBox[{"7", ",", "30"}], "}"}]}], "}"}], ",", 
    "\"\<KnotDiagramData\>\""}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1410992668],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->140435554]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1924746764],

Cell["A torus knot sits on a torus:", "ExampleText",
 CellID->1672687787],

Cell[BoxData[
 RowBox[{
  RowBox[{"torus", "=", " ", 
   RowBox[{"First", " ", "@", " ", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{"2", "Pi", " ", "r"}], "]"}], 
          RowBox[{"(", 
           RowBox[{"4", "+", 
            RowBox[{"Cos", "[", 
             RowBox[{"2", "Pi", " ", "s"}], "]"}]}], ")"}]}], ",", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"2", "Pi", " ", "r"}], "]"}], 
          RowBox[{"(", 
           RowBox[{"4", "+", 
            RowBox[{"Cos", "[", 
             RowBox[{"2", "Pi", " ", "s"}], "]"}]}], ")"}]}], ",", 
         RowBox[{"Sin", "[", 
          RowBox[{"2", "Pi", " ", "s"}], "]"}]}], "}"}], "/", "11"}], ",", 
      RowBox[{"{", 
       RowBox[{"r", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"s", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"Mesh", "\[Rule]", " ", "None"}], ",", 
      RowBox[{"Axes", "\[Rule]", " ", "None"}], ",", " ", 
      RowBox[{"Boxed", "\[Rule]", " ", "False"}], ",", 
      RowBox[{"ColorFunction", "\[Rule]", " ", 
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
         RowBox[{"RGBColor", "[", 
          RowBox[{"x", ",", "y", ",", "0."}], "]"}]}], "]"}]}]}], "]"}]}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->155213232],

Cell[BoxData[
 RowBox[{
  RowBox[{"torusknot", " ", "=", " ", 
   RowBox[{"KnotData", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<TorusKnot\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "11"}], "}"}]}], "}"}], ",", "\"\<ImageData\>\""}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->63424345],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"torus", ",", "torusknot"}], "}"}], ",", 
   RowBox[{"Boxed", "\[Rule]", " ", "False"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1623642766],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->564088204]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->604441226],

Cell[TextData[{
 "The knot ",
 Cell[BoxData[
  SubscriptBox["8", "3"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1099371308],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Orange", ",", " ", 
     RowBox[{"Specularity", "[", 
      RowBox[{"White", ",", "70"}], "]"}], ",", 
     RowBox[{"KnotData", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"8", ",", "3"}], "}"}], ",", "\"\<ImageData\>\""}], "]"}]}], 
    "}"}], ",", 
   RowBox[{"Boxed", "\[Rule]", " ", "False"}], ",", 
   RowBox[{"ViewPoint", "\[Rule]", " ", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0.1", ",", "5"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1246035072],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->306296114]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->769492857],

Cell["A pretzel knot rendered with spheres:", "ExampleText",
 CellID->719925365],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"pretzel", "[", "t_", "]"}], "=", 
   RowBox[{
    RowBox[{"KnotData", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<PretzelKnot\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", "5", ",", "7"}], "}"}]}], "}"}], ",", 
      "\"\<SpaceCurve\>\""}], "]"}], "[", "t", "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2084585733],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"Specularity", "[", 
        RowBox[{"0.9", ",", "50"}], "]"}], ",", 
       RowBox[{"Sphere", "[", 
        RowBox[{
         RowBox[{"pretzel", "[", "t", "]"}], ",", "0.3"}], "]"}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", "0.015"}], "}"}]}], "]"}], ",", 
   RowBox[{"Boxed", "\[Rule]", " ", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->721148022],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->529834243]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1739326885],

Cell["Color a knot:", "ExampleText",
 CellID->1319553231],

Cell[BoxData[
 RowBox[{
  RowBox[{"coloredknot", "[", 
   RowBox[{"knot_", ",", " ", "colorFunction_"}], "]"}], " ", ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", " ", "=", " ", 
      RowBox[{"First", " ", "@", " ", 
       RowBox[{"KnotData", "[", 
        RowBox[{"knot", ",", "\"\<ImageData\>\""}], "]"}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Graphics3D", "[", 
     RowBox[{
      RowBox[{"GraphicsComplex", "[", 
       RowBox[{
        RowBox[{"a", "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
        RowBox[{"a", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", 
        RowBox[{"a", "[", 
         RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
        RowBox[{"VertexColors", " ", "\[Rule]", " ", 
         RowBox[{"colorFunction", " ", "@@@", 
          RowBox[{"a", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}]}]}], "]"}], ",", " ", 
      RowBox[{"Boxed", " ", "\[Rule]", " ", "False"}]}], "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->667530848],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"coloredknot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<TorusKnot\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "8"}], "}"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"Hue", "[", 
     RowBox[{"Sin", "[", "#1", "]"}], "]"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->319976922],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->195024667]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ParametricPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ParametricPlot3D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphData"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->1584193535],

Cell[TextData[{
 ButtonBox["Demonstrations with KnotData",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=KnotData"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[ButtonBox["KnotData Source Information",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
KnotDataSourceInformation.html"], None}]], "RelatedLinks",
 CellID->1038487239]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Computational Geometry",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComputationalGeometry"]], "MoreAbout",
 CellID->328222746],

Cell[TextData[ButtonBox["Integrated Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataCollections"]], "MoreAbout",
 CellID->513407357],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "MoreAbout",
 CellID->223128240],

Cell[TextData[ButtonBox["Mathematical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalData"]], "MoreAbout",
 CellID->99315638],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->718985519]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"KnotData - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 51, 53.1695920}", "context" -> "System`", 
    "keywords" -> {
     "Alexander polynomial", "Alexander-Briggs list", 
      "Alexander-Briggs notation", "almost alternating knot", 
      "alternating knot", "amphichiral knot", "arf invariant", "BLMHo", 
      "bracket polynomial", "braid diagram", "braid image", "braid index", 
      "braid word", "braid word notation", "bridge index", "chiral knot", 
      "coloring number set", "composite", "concordance order", 
      "conway notation", "conway polynomial", "conway string", 
      "crossing number", "degree three Vassiliev", "degree two Vassiliev", 
      "Dowker list", "Dowker notation", "figure eight", "genus", "HOMFLY", 
      "hyperbolic knot", "hyperbolic volume", "invertible knot", 
      "Jones polynomial", "Kauffman polynomial", "knot", "knot determinant", 
      "knot diagram", "knot invariants", "knot theory", "Nakanishi index", 
      "non-almost alternating", "non-alternating knot", "non-hyperbolic knot",
       "non-invertible knot", "non-ribbon knot", "non-satellite knot", 
      "non-slice knot", "non-torus knot", "non-twist knot", "pretzel knot", 
      "prime knot", "ribbon knot", "satellite knot", "Seifert matrix", 
      "signature", "slice knot", "space curve", "stick number", 
      "superbridge index", "thurston bennequin", "torus", "torus knot", 
      "trefoil", "twist knot", "unknot", "unknotting number"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "KnotData[knot, \" property\"] gives the specified property for a knot. \
KnotData[knot] gives an image of the knot. KnotData[\"class\"] gives a list \
of knots in the specified class.", "synonyms" -> {"knot data"}, "title" -> 
    "KnotData", "type" -> "Symbol", "uri" -> "ref/KnotData"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[23097, 661, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->242634408]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 865101, 16600}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1937, 44, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2560, 71, 1573, 37, 70, "ObjectNameGrid"],
Cell[4136, 110, 1174, 35, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5347, 150, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5825, 167, 283, 10, 70, "Notes",
 CellID->251288686],
Cell[6111, 179, 555, 20, 70, "Notes",
 CellID->118621099],
Cell[6669, 201, 73, 1, 70, "Notes",
 CellID->366924191],
Cell[6745, 204, 1594, 54, 70, "2ColumnTableMod",
 CellID->362536805],
Cell[8342, 260, 243, 7, 70, "Notes",
 CellID->702683572],
Cell[8588, 269, 260, 9, 70, "Notes",
 CellID->202801788],
Cell[8851, 280, 342, 11, 70, "Notes",
 CellID->586939930],
Cell[9196, 293, 211, 7, 70, "Notes",
 CellID->1460270283],
Cell[9410, 302, 81, 1, 70, "Notes",
 CellID->216343133],
Cell[9494, 305, 748, 15, 70, "2ColumnTableMod",
 CellID->744846437],
Cell[10245, 322, 66, 1, 70, "Notes",
 CellID->990219751],
Cell[10314, 325, 2684, 52, 70, "2ColumnTableMod",
 CellID->532929866],
Cell[13001, 379, 92, 1, 70, "Notes",
 CellID->1552299899],
Cell[13096, 382, 1119, 23, 70, "2ColumnTableMod",
 CellID->1945449872],
Cell[14218, 407, 63, 1, 70, "Notes",
 CellID->1236121833],
Cell[14284, 410, 494, 11, 70, "2ColumnTableMod",
 CellID->742846153],
Cell[14781, 423, 92, 1, 70, "Notes",
 CellID->1220558805],
Cell[14876, 426, 785, 15, 70, "2ColumnTableMod",
 CellID->1168039491],
Cell[15664, 443, 66, 1, 70, "Notes",
 CellID->1319528465],
Cell[15733, 446, 1911, 49, 70, "2ColumnTableMod",
 CellID->1699742731],
Cell[17647, 497, 72, 1, 70, "Notes",
 CellID->2072244902],
Cell[17722, 500, 684, 17, 70, "2ColumnTableMod",
 CellID->228247197],
Cell[18409, 519, 378, 14, 70, "Notes",
 CellID->433103127],
Cell[18790, 535, 329, 10, 70, "Notes",
 CellID->1358085380],
Cell[19122, 547, 652, 24, 70, "Notes",
 CellID->912420354],
Cell[19777, 573, 69, 1, 70, "Notes",
 CellID->2078739005],
Cell[19849, 576, 1658, 38, 70, "2ColumnTableMod",
 CellID->951888296],
Cell[21510, 616, 72, 1, 70, "Notes",
 CellID->1342175806],
Cell[21585, 619, 1255, 27, 70, "2ColumnTableMod",
 CellID->780543354],
Cell[22843, 648, 217, 8, 70, "Notes",
 CellID->94188222]
}, Closed]],
Cell[CellGroupData[{
Cell[23097, 661, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->242634408],
Cell[CellGroupData[{
Cell[23482, 675, 147, 5, 70, "ExampleSection",
 CellID->77081446],
Cell[23632, 682, 61, 1, 70, "ExampleText",
 CellID->1788057144],
Cell[CellGroupData[{
Cell[23718, 687, 119, 3, 28, "Input",
 CellID->1345756366],
Cell[23840, 692, 39023, 644, 201, "Output",
 Evaluatable->False,
 CellID->5785626]
}, Open  ]],
Cell[62878, 1339, 124, 3, 70, "ExampleDelimiter",
 CellID->32657897],
Cell[63005, 1344, 89, 1, 70, "ExampleText",
 CellID->2137746737],
Cell[CellGroupData[{
Cell[63119, 1349, 205, 6, 70, "Input",
 CellID->848794894],
Cell[63327, 1357, 229, 8, 51, "Output",
 CellID->855368486]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[63605, 1371, 222, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[CellGroupData[{
Cell[63852, 1382, 240, 7, 70, "ExampleSubsection",
 CellID->1518270382],
Cell[64095, 1391, 82, 1, 70, "ExampleText",
 CellID->365686779],
Cell[CellGroupData[{
Cell[64202, 1396, 100, 3, 70, "Input",
 CellID->2146980586],
Cell[64305, 1401, 347, 9, 36, "Output",
 CellID->993786642]
}, Open  ]],
Cell[64667, 1413, 105, 2, 70, "ExampleText",
 CellID->925589599],
Cell[CellGroupData[{
Cell[64797, 1419, 133, 4, 70, "Input",
 CellID->12851525],
Cell[64933, 1425, 778, 26, 36, "Output",
 CellID->232622916]
}, Open  ]],
Cell[CellGroupData[{
Cell[65748, 1456, 102, 3, 70, "Input",
 CellID->371013458],
Cell[65853, 1461, 160, 5, 36, "Output",
 CellID->397073585]
}, Open  ]],
Cell[66028, 1469, 125, 3, 70, "ExampleDelimiter",
 CellID->735107713],
Cell[66156, 1474, 159, 6, 70, "ExampleText",
 CellID->1320705563],
Cell[CellGroupData[{
Cell[66340, 1484, 122, 3, 70, "Input",
 CellID->707421949],
Cell[66465, 1489, 44226, 729, 70, "Output",
 Evaluatable->False,
 CellID->835045072]
}, Open  ]],
Cell[110706, 2221, 100, 1, 70, "ExampleText",
 CellID->2006031198],
Cell[CellGroupData[{
Cell[110831, 2226, 198, 7, 70, "Input",
 CellID->977937755],
Cell[111032, 2235, 159, 5, 36, "Output",
 CellID->1827844805]
}, Open  ]],
Cell[111206, 2243, 59, 1, 70, "ExampleText",
 CellID->503356452],
Cell[CellGroupData[{
Cell[111290, 2248, 160, 4, 70, "Input",
 CellID->973803231],
Cell[111453, 2254, 159, 5, 36, "Output",
 CellID->1727742251]
}, Open  ]],
Cell[111627, 2262, 60, 1, 70, "ExampleText",
 CellID->2020570533],
Cell[CellGroupData[{
Cell[111712, 2267, 224, 7, 70, "Input",
 CellID->738029630],
Cell[111939, 2276, 159, 5, 36, "Output",
 CellID->2037621470]
}, Open  ]],
Cell[112113, 2284, 126, 3, 70, "ExampleDelimiter",
 CellID->1664094946],
Cell[112242, 2289, 224, 8, 70, "ExampleText",
 CellID->1764222541],
Cell[CellGroupData[{
Cell[112491, 2301, 218, 7, 70, "Input",
 CellID->369309031],
Cell[112712, 2310, 55259, 910, 70, "Output",
 Evaluatable->False,
 CellID->381771976]
}, Open  ]],
Cell[167986, 3223, 125, 3, 70, "ExampleDelimiter",
 CellID->769423020],
Cell[168114, 3228, 121, 3, 70, "ExampleText",
 CellID->169728548],
Cell[CellGroupData[{
Cell[168260, 3235, 230, 7, 70, "Input",
 CellID->981532458],
Cell[168493, 3244, 47048, 775, 70, "Output",
 Evaluatable->False,
 CellID->252906650]
}, Open  ]],
Cell[215556, 4022, 126, 3, 70, "ExampleDelimiter",
 CellID->1367233059],
Cell[215685, 4027, 76, 1, 70, "ExampleText",
 CellID->668291069],
Cell[CellGroupData[{
Cell[215786, 4032, 195, 7, 70, "Input",
 CellID->628522873],
Cell[215984, 4041, 172, 5, 36, "Output",
 CellID->382327581]
}, Open  ]],
Cell[216171, 4049, 88, 1, 70, "ExampleText",
 CellID->2061826860],
Cell[CellGroupData[{
Cell[216284, 4054, 206, 7, 70, "Input",
 CellID->1327908028],
Cell[216493, 4063, 268, 8, 36, "Output",
 CellID->508582043]
}, Open  ]],
Cell[216776, 4074, 126, 3, 70, "ExampleDelimiter",
 CellID->2003065306],
Cell[216905, 4079, 74, 1, 70, "ExampleText",
 CellID->1564947570],
Cell[CellGroupData[{
Cell[217004, 4084, 119, 3, 70, "Input",
 CellID->1841584181],
Cell[217126, 4089, 581, 13, 54, "Output",
 CellID->99959040]
}, Open  ]],
Cell[217722, 4105, 125, 3, 70, "ExampleDelimiter",
 CellID->679373326],
Cell[217850, 4110, 86, 1, 70, "ExampleText",
 CellID->56938983],
Cell[CellGroupData[{
Cell[217961, 4115, 117, 3, 70, "Input",
 CellID->1343264366],
Cell[218081, 4120, 542, 19, 36, "Output",
 CellID->138592230]
}, Open  ]],
Cell[CellGroupData[{
Cell[218660, 4144, 124, 3, 70, "Input",
 CellID->222482558],
Cell[218787, 4149, 605, 21, 36, "Output",
 CellID->1239885026]
}, Open  ]],
Cell[219407, 4173, 126, 3, 70, "ExampleDelimiter",
 CellID->1713805141],
Cell[219536, 4178, 87, 1, 70, "ExampleText",
 CellID->1872331223],
Cell[CellGroupData[{
Cell[219648, 4183, 189, 6, 70, "Input",
 CellID->1192985470],
Cell[219840, 4191, 161, 5, 36, "Output",
 CellID->225571212]
}, Open  ]],
Cell[220016, 4199, 126, 3, 70, "ExampleDelimiter",
 CellID->1626039502],
Cell[220145, 4204, 90, 1, 70, "ExampleText",
 CellID->2116502039],
Cell[CellGroupData[{
Cell[220260, 4209, 193, 7, 70, "Input",
 CellID->1130640565],
Cell[220456, 4218, 377, 10, 36, "Output",
 CellID->866723129]
}, Open  ]],
Cell[220848, 4231, 126, 3, 70, "ExampleDelimiter",
 CellID->2146102911],
Cell[220977, 4236, 103, 2, 70, "ExampleText",
 CellID->1628990020],
Cell[CellGroupData[{
Cell[221105, 4242, 193, 6, 70, "Input",
 CellID->1502915977],
Cell[221301, 4250, 545, 19, 36, "Output",
 CellID->1749091717]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[221895, 4275, 233, 7, 70, "ExampleSubsection",
 CellID->1169616620],
Cell[222131, 4284, 77, 1, 70, "ExampleText",
 CellID->930597320],
Cell[CellGroupData[{
Cell[222233, 4289, 139, 4, 70, "Input",
 CellID->425756139],
Cell[222375, 4295, 2188, 38, 241, "Output",
 CellID->30756598]
}, Open  ]],
Cell[CellGroupData[{
Cell[224600, 4338, 103, 3, 70, "Input",
 CellID->1744689671],
Cell[224706, 4343, 158, 5, 36, "Output",
 CellID->54437312]
}, Open  ]],
Cell[224879, 4351, 125, 3, 70, "ExampleDelimiter",
 CellID->686267939],
Cell[225007, 4356, 103, 2, 70, "ExampleText",
 CellID->2118066383],
Cell[CellGroupData[{
Cell[225135, 4362, 233, 8, 70, "Input",
 CellID->1652766409],
Cell[225371, 4372, 418, 12, 36, "Output",
 CellID->101043053]
}, Open  ]],
Cell[225804, 4387, 126, 3, 70, "ExampleDelimiter",
 CellID->1746677940],
Cell[225933, 4392, 59, 1, 70, "ExampleText",
 CellID->314683090],
Cell[CellGroupData[{
Cell[226017, 4397, 197, 7, 70, "Input",
 CellID->1773954716],
Cell[226217, 4406, 45148, 744, 70, "Output",
 Evaluatable->False,
 CellID->96509764]
}, Open  ]],
Cell[271380, 5153, 126, 3, 70, "ExampleDelimiter",
 CellID->1961909090],
Cell[271509, 5158, 61, 1, 70, "ExampleText",
 CellID->252563117],
Cell[CellGroupData[{
Cell[271595, 5163, 275, 9, 70, "Input",
 CellID->1400620947],
Cell[271873, 5174, 15999, 266, 70, "Output",
 Evaluatable->False,
 CellID->724298472]
}, Open  ]],
Cell[287887, 5443, 125, 3, 70, "ExampleDelimiter",
 CellID->715630839],
Cell[288015, 5448, 78, 1, 70, "ExampleText",
 CellID->1699087873],
Cell[CellGroupData[{
Cell[288118, 5453, 198, 7, 70, "Input",
 CellID->1479827352],
Cell[288319, 5462, 754, 21, 70, "Output",
 CellID->1450189157]
}, Open  ]],
Cell[289088, 5486, 126, 3, 70, "ExampleDelimiter",
 CellID->1951726184],
Cell[289217, 5491, 76, 1, 70, "ExampleText",
 CellID->1996750210],
Cell[CellGroupData[{
Cell[289318, 5496, 210, 7, 70, "Input",
 CellID->653827801],
Cell[289531, 5505, 180, 6, 36, "Output",
 CellID->503960871]
}, Open  ]],
Cell[CellGroupData[{
Cell[289748, 5516, 201, 7, 70, "Input",
 CellID->656366731],
Cell[289952, 5525, 168, 5, 36, "Output",
 CellID->1348813111]
}, Open  ]],
Cell[CellGroupData[{
Cell[290157, 5535, 201, 7, 70, "Input",
 CellID->394855129],
Cell[290361, 5544, 185, 5, 36, "Output",
 CellID->605683873]
}, Open  ]],
Cell[290561, 5552, 124, 3, 70, "ExampleDelimiter",
 CellID->13959903],
Cell[290688, 5557, 93, 1, 70, "ExampleText",
 CellID->548372198],
Cell[CellGroupData[{
Cell[290806, 5562, 229, 8, 70, "Input",
 CellID->1639202509],
Cell[291038, 5572, 205, 7, 36, "Output",
 CellID->1722404123]
}, Open  ]],
Cell[CellGroupData[{
Cell[291280, 5584, 199, 7, 70, "Input",
 CellID->757178157],
Cell[291482, 5593, 170, 5, 36, "Output",
 CellID->2005165052]
}, Open  ]],
Cell[CellGroupData[{
Cell[291689, 5603, 195, 7, 70, "Input",
 CellID->4507713],
Cell[291887, 5612, 275, 9, 36, "Output",
 CellID->366533701]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[292211, 5627, 237, 7, 70, "ExampleSubsection",
 CellID->1828711349],
Cell[292451, 5636, 159, 6, 70, "ExampleText",
 CellID->1875338644],
Cell[CellGroupData[{
Cell[292635, 5646, 202, 7, 70, "Input",
 CellID->94904096],
Cell[292840, 5655, 158, 5, 36, "Output",
 CellID->859757463]
}, Open  ]],
Cell[CellGroupData[{
Cell[293035, 5665, 207, 7, 70, "Input",
 CellID->1921174684],
Cell[293245, 5674, 214, 7, 36, "Output",
 CellID->2106417704]
}, Open  ]],
Cell[CellGroupData[{
Cell[293496, 5686, 232, 8, 70, "Input",
 CellID->1294430333],
Cell[293731, 5696, 180, 6, 36, "Output",
 CellID->1013782012]
}, Open  ]],
Cell[293926, 5705, 125, 3, 70, "ExampleDelimiter",
 CellID->194288694],
Cell[294054, 5710, 94, 1, 70, "ExampleText",
 CellID->1234936618],
Cell[CellGroupData[{
Cell[294173, 5715, 206, 6, 70, "Input",
 CellID->150290471],
Cell[294382, 5723, 340, 12, 52, "Output",
 CellID->1916166532]
}, Open  ]],
Cell[CellGroupData[{
Cell[294759, 5740, 121, 4, 70, "Input",
 CellID->1583034252],
Cell[294883, 5746, 313, 11, 52, "Output",
 CellID->1346132912]
}, Open  ]],
Cell[295211, 5760, 124, 3, 70, "ExampleDelimiter",
 CellID->60630814],
Cell[295338, 5765, 375, 13, 70, "ExampleText",
 CellID->1114842220],
Cell[CellGroupData[{
Cell[295738, 5782, 232, 8, 70, "Input",
 CellID->87081229],
Cell[295973, 5792, 610, 21, 36, "Output",
 CellID->111199935]
}, Open  ]],
Cell[CellGroupData[{
Cell[296620, 5818, 307, 9, 70, "Input",
 CellID->134953409],
Cell[296930, 5829, 3242, 57, 70, "Output",
 Evaluatable->False,
 CellID->515260644]
}, Open  ]],
Cell[CellGroupData[{
Cell[300209, 5891, 229, 8, 70, "Input",
 CellID->1849215138],
Cell[300441, 5901, 1097, 38, 71, "Output",
 CellID->159198022]
}, Open  ]],
Cell[CellGroupData[{
Cell[301575, 5944, 307, 9, 70, "Input",
 CellID->114632519],
Cell[301885, 5955, 2852, 51, 70, "Output",
 Evaluatable->False,
 CellID->662717089]
}, Open  ]],
Cell[304752, 6009, 126, 3, 70, "ExampleDelimiter",
 CellID->1772724453],
Cell[304881, 6014, 219, 8, 70, "ExampleText",
 CellID->2139246740],
Cell[CellGroupData[{
Cell[305125, 6026, 231, 8, 70, "Input",
 CellID->499020386],
Cell[305359, 6036, 168, 5, 36, "Output",
 CellID->1039533064]
}, Open  ]],
Cell[305542, 6044, 84, 1, 70, "ExampleText",
 CellID->213864802],
Cell[CellGroupData[{
Cell[305651, 6049, 237, 8, 70, "Input",
 CellID->1745451175],
Cell[305891, 6059, 305, 10, 36, "Output",
 CellID->811572692]
}, Open  ]],
Cell[306211, 6072, 125, 3, 70, "ExampleDelimiter",
 CellID->429025249],
Cell[306339, 6077, 217, 8, 70, "ExampleText",
 CellID->268422764],
Cell[CellGroupData[{
Cell[306581, 6089, 238, 8, 70, "Input",
 CellID->1535864782],
Cell[306822, 6099, 165, 5, 36, "Output",
 CellID->525954134]
}, Open  ]],
Cell[307002, 6107, 90, 1, 70, "ExampleText",
 CellID->185084929],
Cell[CellGroupData[{
Cell[307117, 6112, 243, 8, 70, "Input",
 CellID->423047553],
Cell[307363, 6122, 1034, 34, 36, "Output",
 CellID->39705527]
}, Open  ]],
Cell[308412, 6159, 125, 3, 70, "ExampleDelimiter",
 CellID->852451040],
Cell[308540, 6164, 294, 10, 70, "ExampleText",
 CellID->1281220143],
Cell[CellGroupData[{
Cell[308859, 6178, 272, 9, 70, "Input",
 CellID->648414932],
Cell[309134, 6189, 212, 6, 36, "Output",
 CellID->106671966]
}, Open  ]],
Cell[309361, 6198, 125, 3, 70, "ExampleDelimiter",
 CellID->160146669],
Cell[309489, 6203, 292, 10, 70, "ExampleText",
 CellID->187464565],
Cell[CellGroupData[{
Cell[309806, 6217, 282, 9, 70, "Input",
 CellID->10131782],
Cell[310091, 6228, 210, 6, 36, "Output",
 CellID->33197264]
}, Open  ]],
Cell[310316, 6237, 126, 3, 70, "ExampleDelimiter",
 CellID->1309815905],
Cell[310445, 6242, 281, 10, 70, "ExampleText",
 CellID->221049938],
Cell[CellGroupData[{
Cell[310751, 6256, 207, 7, 70, "Input",
 CellID->39598656],
Cell[310961, 6265, 205, 6, 36, "Output",
 CellID->11276529]
}, Open  ]],
Cell[311181, 6274, 126, 3, 70, "ExampleDelimiter",
 CellID->1304052878],
Cell[311310, 6279, 84, 1, 70, "ExampleText",
 CellID->451374594],
Cell[CellGroupData[{
Cell[311419, 6284, 315, 10, 70, "Input",
 CellID->1340560154],
Cell[311737, 6296, 250, 9, 36, "Output",
 CellID->258429233]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[312048, 6312, 244, 7, 70, "ExampleSection",
 CellID->1020263627],
Cell[312295, 6321, 65, 1, 70, "ExampleText",
 CellID->908517580],
Cell[CellGroupData[{
Cell[312385, 6326, 197, 7, 70, "Input",
 CellID->1622964794],
Cell[312585, 6335, 159, 5, 36, "Output",
 CellID->1191751654]
}, Open  ]],
Cell[312759, 6343, 125, 3, 70, "ExampleDelimiter",
 CellID->731399553],
Cell[312887, 6348, 64, 1, 70, "ExampleText",
 CellID->435891843],
Cell[CellGroupData[{
Cell[312976, 6353, 195, 7, 70, "Input",
 CellID->846236890],
Cell[313174, 6362, 462, 17, 36, "Output",
 CellID->671128321]
}, Open  ]],
Cell[313651, 6382, 126, 3, 70, "ExampleDelimiter",
 CellID->1991203653],
Cell[313780, 6387, 63, 1, 70, "ExampleText",
 CellID->714231107],
Cell[CellGroupData[{
Cell[313868, 6392, 204, 7, 70, "Input",
 CellID->1796112266],
Cell[314075, 6401, 511, 12, 70, "Output",
 Evaluatable->False,
 CellID->121513731]
}, Open  ]],
Cell[314601, 6416, 126, 3, 70, "ExampleDelimiter",
 CellID->1922124770],
Cell[314730, 6421, 54, 1, 70, "ExampleText",
 CellID->45204272],
Cell[CellGroupData[{
Cell[314809, 6426, 197, 7, 70, "Input",
 CellID->1686472113],
Cell[315009, 6435, 13657, 228, 70, "Output",
 Evaluatable->False,
 CellID->136880620]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[328715, 6669, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[328945, 6678, 197, 7, 70, "ExampleText",
 CellID->2013064109],
Cell[CellGroupData[{
Cell[329167, 6689, 122, 3, 70, "Input",
 CellID->150393535],
Cell[329292, 6694, 1397, 47, 71, "Output",
 CellID->664578845]
}, Open  ]],
Cell[330704, 6744, 125, 3, 70, "ExampleDelimiter",
 CellID->182521853],
Cell[330832, 6749, 87, 1, 70, "ExampleText",
 CellID->1038135455],
Cell[330922, 6752, 388, 12, 70, "Input",
 CellID->326550819],
Cell[CellGroupData[{
Cell[331335, 6768, 276, 10, 70, "Input",
 CellID->644734821],
Cell[331614, 6780, 296, 9, 36, "Output",
 CellID->1725603995]
}, Open  ]],
Cell[331925, 6792, 126, 3, 70, "ExampleDelimiter",
 CellID->1647565075],
Cell[332054, 6797, 79, 1, 70, "ExampleText",
 CellID->1293239606],
Cell[CellGroupData[{
Cell[332158, 6802, 168, 5, 70, "Input",
 CellID->796066755],
Cell[332329, 6809, 180, 6, 36, "Output",
 CellID->608924719]
}, Open  ]],
Cell[332524, 6818, 64, 1, 70, "ExampleText",
 CellID->972071107],
Cell[CellGroupData[{
Cell[332613, 6823, 387, 11, 70, "Input",
 CellID->1690992620],
Cell[333003, 6836, 4686, 81, 70, "Output",
 Evaluatable->False,
 CellID->153757452]
}, Open  ]],
Cell[337704, 6920, 125, 3, 70, "ExampleDelimiter",
 CellID->997556379],
Cell[337832, 6925, 95, 1, 70, "ExampleText",
 CellID->525229724],
Cell[CellGroupData[{
Cell[337952, 6930, 353, 11, 70, "Input",
 CellID->1378182098],
Cell[338308, 6943, 5032, 87, 70, "Output",
 Evaluatable->False,
 CellID->622175287]
}, Open  ]],
Cell[343355, 7033, 90, 1, 70, "ExampleText",
 CellID->1594148161],
Cell[CellGroupData[{
Cell[343470, 7038, 491, 16, 70, "Input",
 CellID->435331138],
Cell[343964, 7056, 295, 9, 36, "Output",
 CellID->1851695291]
}, Open  ]],
Cell[CellGroupData[{
Cell[344296, 7070, 162, 5, 70, "Input",
 CellID->1631575639],
Cell[344461, 7077, 1041, 24, 139, "Output",
 CellID->109743513]
}, Open  ]],
Cell[345517, 7104, 125, 3, 70, "ExampleDelimiter",
 CellID->647109500],
Cell[345645, 7109, 57, 1, 70, "ExampleText",
 CellID->1112178092],
Cell[345705, 7112, 463, 15, 70, "Input",
 CellID->770476583],
Cell[CellGroupData[{
Cell[346193, 7131, 780, 23, 70, "Input",
 CellID->445093023],
Cell[346976, 7156, 15204, 260, 227, 2202, 42, "CachedBoxData", "BoxData", \
"Output",
 CellID->2068200291]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[362229, 7422, 239, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[362471, 7431, 356, 13, 70, "ExampleText",
 CellID->1347366831],
Cell[362830, 7446, 258, 9, 70, "Input",
 CellID->1849870484],
Cell[363091, 7457, 267, 9, 70, "Input",
 CellID->1081920943],
Cell[363361, 7468, 53, 1, 70, "ExampleText",
 CellID->32308904],
Cell[CellGroupData[{
Cell[363439, 7473, 162, 5, 70, "Input",
 CellID->1652466969],
Cell[363604, 7480, 10648, 179, 70, "Output",
 Evaluatable->False,
 CellID->141988257]
}, Open  ]],
Cell[374267, 7662, 58, 1, 70, "ExampleText",
 CellID->1557074205],
Cell[CellGroupData[{
Cell[374350, 7667, 270, 9, 70, "Input",
 CellID->510441093],
Cell[374623, 7678, 4059, 71, 70, "Output",
 Evaluatable->False,
 CellID->253180354]
}, Open  ]],
Cell[378697, 7752, 125, 3, 70, "ExampleDelimiter",
 CellID->328833270],
Cell[378825, 7757, 80, 1, 70, "ExampleText",
 CellID->1225345159],
Cell[CellGroupData[{
Cell[378930, 7762, 575, 18, 70, "Input",
 CellID->7912583],
Cell[379508, 7782, 322, 9, 36, "Output",
 CellID->1387476493]
}, Open  ]],
Cell[379845, 7794, 125, 3, 70, "ExampleDelimiter",
 CellID->125743379],
Cell[379973, 7799, 266, 10, 70, "ExampleText",
 CellID->245062205],
Cell[CellGroupData[{
Cell[380264, 7813, 352, 12, 70, "Input",
 CellID->2034328136],
Cell[380619, 7827, 292, 9, 36, "Output",
 CellID->1939978725]
}, Open  ]],
Cell[380926, 7839, 125, 3, 70, "ExampleDelimiter",
 CellID->970820138],
Cell[381054, 7844, 122, 3, 70, "ExampleText",
 CellID->2140793107],
Cell[CellGroupData[{
Cell[381201, 7851, 399, 14, 70, "Input",
 CellID->1368727511],
Cell[381603, 7867, 215, 7, 36, "Output",
 CellID->2125702321]
}, Open  ]],
Cell[CellGroupData[{
Cell[381855, 7879, 299, 10, 70, "Input",
 CellID->789503556],
Cell[382157, 7891, 215, 7, 36, "Output",
 CellID->1140957555]
}, Open  ]],
Cell[382387, 7901, 125, 3, 70, "ExampleDelimiter",
 CellID->611791480],
Cell[382515, 7906, 117, 3, 70, "ExampleText",
 CellID->227702524],
Cell[CellGroupData[{
Cell[382657, 7913, 222, 7, 70, "Input",
 CellID->180461914],
Cell[382882, 7922, 279, 10, 52, "Output",
 CellID->1192142822]
}, Open  ]],
Cell[CellGroupData[{
Cell[383198, 7937, 287, 9, 70, "Input",
 CellID->1442899368],
Cell[383488, 7948, 278, 10, 52, "Output",
 CellID->321982844]
}, Open  ]],
Cell[383781, 7961, 126, 3, 70, "ExampleDelimiter",
 CellID->1854035451],
Cell[383910, 7966, 76, 1, 70, "ExampleText",
 CellID->786106987],
Cell[CellGroupData[{
Cell[384011, 7971, 367, 12, 70, "Input",
 CellID->780734165],
Cell[384381, 7985, 210, 7, 36, "Output",
 CellID->2054352315]
}, Open  ]],
Cell[CellGroupData[{
Cell[384628, 7997, 548, 19, 70, "Input",
 CellID->412105970],
Cell[385179, 8018, 209, 7, 36, "Output",
 CellID->257281739]
}, Open  ]],
Cell[CellGroupData[{
Cell[385425, 8030, 462, 16, 70, "Input",
 CellID->1662998501],
Cell[385890, 8048, 210, 7, 36, "Output",
 CellID->1249605962]
}, Open  ]],
Cell[386115, 8058, 126, 3, 70, "ExampleDelimiter",
 CellID->1752136214],
Cell[386244, 8063, 354, 14, 70, "ExampleText",
 CellID->1857581034],
Cell[CellGroupData[{
Cell[386623, 8081, 644, 21, 70, "Input",
 CellID->247178352],
Cell[387270, 8104, 16408, 273, 70, "Output",
 Evaluatable->False,
 CellID->1821245]
}, Open  ]],
Cell[403693, 8380, 126, 3, 70, "ExampleDelimiter",
 CellID->1516916218],
Cell[403822, 8385, 377, 15, 70, "ExampleText",
 CellID->649822830],
Cell[CellGroupData[{
Cell[404224, 8404, 673, 22, 70, "Input",
 CellID->1617958815],
Cell[404900, 8428, 21924, 363, 70, "Output",
 Evaluatable->False,
 CellID->136664489]
}, Open  ]],
Cell[426839, 8794, 126, 3, 70, "ExampleDelimiter",
 CellID->2078356264],
Cell[426968, 8799, 114, 3, 70, "ExampleText",
 CellID->2112210593],
Cell[CellGroupData[{
Cell[427107, 8806, 608, 23, 70, "Input",
 CellID->2018751641],
Cell[427718, 8831, 366, 12, 36, "Output",
 CellID->1146422221]
}, Open  ]],
Cell[CellGroupData[{
Cell[428121, 8848, 256, 9, 70, "Input",
 CellID->1528701600],
Cell[428380, 8859, 365, 12, 36, "Output",
 CellID->694987463]
}, Open  ]],
Cell[428760, 8874, 126, 3, 70, "ExampleDelimiter",
 CellID->2097425510],
Cell[428889, 8879, 114, 3, 70, "ExampleText",
 CellID->992292367],
Cell[CellGroupData[{
Cell[429028, 8886, 259, 9, 70, "Input",
 CellID->557407184],
Cell[429290, 8897, 378, 13, 36, "Output",
 CellID->490734608]
}, Open  ]],
Cell[CellGroupData[{
Cell[429705, 8915, 232, 8, 70, "Input",
 CellID->168514940],
Cell[429940, 8925, 379, 13, 36, "Output",
 CellID->1439352176]
}, Open  ]],
Cell[430334, 8941, 125, 3, 70, "ExampleDelimiter",
 CellID->486481065],
Cell[430462, 8946, 86, 1, 70, "ExampleText",
 CellID->66962311],
Cell[CellGroupData[{
Cell[430573, 8951, 413, 15, 70, "Input",
 CellID->1241415237],
Cell[430989, 8968, 522, 19, 52, "Output",
 CellID->1936222224]
}, Open  ]],
Cell[CellGroupData[{
Cell[431548, 8992, 235, 8, 70, "Input",
 CellID->154129949],
Cell[431786, 9002, 522, 19, 52, "Output",
 CellID->1267215777]
}, Open  ]],
Cell[432323, 9024, 125, 3, 70, "ExampleDelimiter",
 CellID->281768181],
Cell[432451, 9029, 121, 3, 70, "ExampleText",
 CellID->476376432],
Cell[CellGroupData[{
Cell[432597, 9036, 235, 8, 70, "Input",
 CellID->639656608],
Cell[432835, 9046, 522, 19, 52, "Output",
 CellID->1500236740]
}, Open  ]],
Cell[CellGroupData[{
Cell[433394, 9070, 255, 9, 70, "Input",
 CellID->832107687],
Cell[433652, 9081, 521, 19, 52, "Output",
 CellID->873389753]
}, Open  ]],
Cell[434188, 9103, 125, 3, 70, "ExampleDelimiter",
 CellID->243141049],
Cell[434316, 9108, 119, 3, 70, "ExampleText",
 CellID->1957713949],
Cell[434438, 9113, 524, 17, 70, "Input",
 CellID->1701385156],
Cell[CellGroupData[{
Cell[434987, 9134, 266, 9, 70, "Input",
 CellID->2098578722],
Cell[435256, 9145, 292, 9, 36, "Output",
 CellID->1010851426]
}, Open  ]],
Cell[435563, 9157, 561, 18, 70, "Input",
 CellID->721968037],
Cell[CellGroupData[{
Cell[436149, 9179, 265, 9, 70, "Input",
 CellID->834192309],
Cell[436417, 9190, 291, 9, 36, "Output",
 CellID->636785365]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[436757, 9205, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[436991, 9214, 203, 7, 70, "ExampleText",
 CellID->865346106],
Cell[CellGroupData[{
Cell[437219, 9225, 178, 5, 70, "Input",
 CellID->1112746058],
Cell[437400, 9232, 182, 6, 36, "Output",
 CellID->997680118]
}, Open  ]],
Cell[437597, 9241, 256, 9, 70, "ExampleText",
 CellID->423333015],
Cell[CellGroupData[{
Cell[437878, 9254, 385, 12, 70, "Input",
 CellID->344660594],
Cell[438266, 9268, 161, 5, 36, "Output",
 CellID->1061107109]
}, Open  ]],
Cell[438442, 9276, 125, 3, 70, "ExampleDelimiter",
 CellID->744975096],
Cell[438570, 9281, 147, 4, 70, "ExampleText",
 CellID->966776462],
Cell[CellGroupData[{
Cell[438742, 9289, 230, 7, 70, "Input",
 CellID->155055900],
Cell[438975, 9298, 51948, 856, 70, "Output",
 Evaluatable->False,
 CellID->17022521]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[490972, 10160, 228, 7, 70, "ExampleSection",
 CellID->589267740],
Cell[491203, 10169, 75, 1, 70, "ExampleText",
 CellID->1046463213],
Cell[CellGroupData[{
Cell[491303, 10174, 931, 27, 70, "Input",
 CellID->1214271710],
Cell[492237, 10203, 228203, 3790, 70, "Output",
 CellID->394451271]
}, Open  ]],
Cell[720455, 13996, 125, 3, 70, "ExampleDelimiter",
 CellID->708330627],
Cell[720583, 14001, 69, 1, 70, "ExampleText",
 CellID->73470108],
Cell[CellGroupData[{
Cell[720677, 14006, 793, 25, 70, "Input",
 CellID->1410992668],
Cell[721473, 14033, 25166, 417, 70, "Output",
 Evaluatable->False,
 CellID->140435554]
}, Open  ]],
Cell[746654, 14453, 126, 3, 70, "ExampleDelimiter",
 CellID->1924746764],
Cell[746783, 14458, 73, 1, 70, "ExampleText",
 CellID->1672687787],
Cell[746859, 14461, 1481, 41, 70, "Input",
 CellID->155213232],
Cell[748343, 14504, 336, 11, 70, "Input",
 CellID->63424345],
Cell[CellGroupData[{
Cell[748704, 14519, 234, 7, 70, "Input",
 CellID->1623642766],
Cell[748941, 14528, 30111, 498, 70, "Output",
 Evaluatable->False,
 CellID->564088204]
}, Open  ]],
Cell[779067, 15029, 125, 3, 70, "ExampleDelimiter",
 CellID->604441226],
Cell[779195, 15034, 134, 6, 70, "ExampleText",
 CellID->1099371308],
Cell[CellGroupData[{
Cell[779354, 15044, 574, 17, 70, "Input",
 CellID->1246035072],
Cell[779931, 15063, 39964, 659, 70, "Output",
 Evaluatable->False,
 CellID->306296114]
}, Open  ]],
Cell[819910, 15725, 125, 3, 70, "ExampleDelimiter",
 CellID->769492857],
Cell[820038, 15730, 80, 1, 70, "ExampleText",
 CellID->719925365],
Cell[820121, 15733, 405, 13, 70, "Input",
 CellID->2084585733],
Cell[CellGroupData[{
Cell[820551, 15750, 587, 18, 70, "Input",
 CellID->721148022],
Cell[821141, 15770, 13397, 224, 70, "Output",
 Evaluatable->False,
 CellID->529834243]
}, Open  ]],
Cell[834553, 15997, 126, 3, 70, "ExampleDelimiter",
 CellID->1739326885],
Cell[834682, 16002, 57, 1, 70, "ExampleText",
 CellID->1319553231],
Cell[834742, 16005, 1075, 30, 70, "Input",
 CellID->667530848],
Cell[CellGroupData[{
Cell[835842, 16039, 333, 11, 70, "Input",
 CellID->319976922],
Cell[836178, 16052, 23478, 389, 70, "Output",
 Evaluatable->False,
 CellID->195024667]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[859717, 16448, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[860036, 16459, 473, 17, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[860546, 16481, 326, 9, 70, "RelatedLinksSection",
 CellID->1584193535],
Cell[860875, 16492, 361, 12, 70, "RelatedLinks"],
Cell[861239, 16506, 230, 5, 70, "RelatedLinks",
 CellID->1038487239]
}, Open  ]],
Cell[CellGroupData[{
Cell[861506, 16516, 299, 8, 70, "MoreAboutSection"],
Cell[861808, 16526, 155, 3, 70, "MoreAbout",
 CellID->328222746],
Cell[861966, 16531, 150, 3, 70, "MoreAbout",
 CellID->513407357],
Cell[862119, 16536, 151, 3, 70, "MoreAbout",
 CellID->223128240],
Cell[862273, 16541, 144, 3, 70, "MoreAbout",
 CellID->99315638],
Cell[862420, 16546, 179, 3, 70, "MoreAbout",
 CellID->718985519]
}, Open  ]],
Cell[862614, 16552, 27, 0, 70, "History"],
Cell[862644, 16554, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

