(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     90634,       2330]
NotebookOptionsPosition[     81723,       2033]
NotebookOutlinePosition[     82997,       2071]
CellTagsIndexPosition[     82911,       2066]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GCD" :> Documentation`HelpLookup["paclet:ref/GCD"], 
          "PolynomialLCM" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialLCM"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"GCD\"\>", 
       2->"\<\"PolynomialLCM\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer Functions" :> 
          Documentation`HelpLookup["paclet:guide/IntegerFunctions"], 
          "Number Theoretic Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NumberTheoreticFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Integer Functions\"\>", 
       2->"\<\"Number Theoretic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LCM", "ObjectName",
 CellID->31243],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LCM",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LCM"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the least common multiple of the integers ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15804]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Integer mathematical function, suitable for both symbolic and numerical \
manipulation.\
\>", "Notes",
 CellID->126685801],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LCM",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LCM"]], "InlineFormula"],
 " also works with rational numbers; ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LCM",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LCM"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["r", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["r", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " gives the least rational number ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 " for which all the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", "/", 
    SubscriptBox["r", "i"]}], TraditionalForm]], "InlineMath"],
 " are integers. "
}], "Notes",
 CellID->12992],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LCM",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LCM"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->555347927],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LCM",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LCM"]], "InlineFormula"],
 " has attributes ",
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Orderless",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Orderless"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26167]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->21397871],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->97034666],

Cell["Least common multiple of three integers:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LCM", "[", 
  RowBox[{"2", ",", "3", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["30"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39217535]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LCM",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LCM"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LCM", "[", 
  RowBox[{"2", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5", ",", "7"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", "10", ",", "14"}], "}"}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->231928024]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Use rational arguments:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LCM", "[", 
  RowBox[{
   RowBox[{"1", "/", "3"}], ",", 
   RowBox[{"2", "/", "5"}], ",", 
   RowBox[{"3", "/", "7"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->441371647]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "/", "3"}], ",", 
    RowBox[{"2", "/", "5"}], ",", 
    RowBox[{"3", "/", "7"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"18", ",", "15", ",", "14"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->226196647]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Use with Gaussian integers:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LCM", "[", 
  RowBox[{
   RowBox[{"3", "-", 
    RowBox[{"4", "I"}]}], ",", 
   RowBox[{"5", "-", 
    RowBox[{"6", "I"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"9", "+", 
  RowBox[{"38", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->813831332]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->444699584],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->557828371],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LCM", "[", 
   RowBox[{"m", ",", "n"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->498633172],

Cell[BoxData[
 FormBox[
  RowBox[{"lcm", "(", 
   RowBox[{"m", ",", "n"}], ")"}], TraditionalForm]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->73006854]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 "The LCM of the first ",
 Cell[BoxData[
  FormBox["100", TraditionalForm]], "InlineFormula"],
 " integers:"
}], "ExampleText",
 CellID->264496307],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"LCM", ",", 
   RowBox[{"Range", "[", "100", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11880853],

Cell[BoxData["69720375229712477164533808935312303556800"], "Output",
 ImageSize->{319, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->132706666]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20351805],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"LCM", "[", 
     RowBox[{"m", ",", "n"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"m", ",", "60"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "60"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37344415],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{184, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->885927617]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Maximal order of group elements from the symmetric group of order ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " (Landau\[CloseCurlyQuote]s function):"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Max", "[", 
    RowBox[{"LCM", "@@@", 
     RowBox[{"IntegerPartitions", "[", "n", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "6", ",", "6", ",", "12", ",", "15",
    ",", "20", ",", "30", ",", "30", ",", "60", ",", "60", ",", "84", ",", 
   "105", ",", "140", ",", "210", ",", "210", ",", "420", ",", "420"}], 
  "}"}]], "Output",
 ImageSize->{511, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->705958177]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Cumulative LCMs:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"FoldList", "[", 
   RowBox[{"LCM", ",", "1", ",", 
    RowBox[{"Range", "[", 
     RowBox[{"2", ",", "10"}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "6", ",", "12", ",", "60", ",", "60", ",", "420", ",", 
   "840", ",", "2520", ",", "2520"}], "}"}]], "Output",
 ImageSize->{280, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->79060792]
}, Open  ]],

Cell["\<\
Plot the logarithm of the data (if Riemann\[CloseCurlyQuote]s hypothesis \
holds, this grows linearly):\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Log", "[", 
   RowBox[{"FoldList", "[", 
    RowBox[{"LCM", ",", "1", ",", 
     RowBox[{"Range", "[", 
      RowBox[{"2", ",", "100"}], "]"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxdy11I01EcxvHD6kIqbUiWNKtpS3LJ0Flrc778mq6tNefenJNCy6bdFV0U
lb0cMgp6gbqJIIioi4gishcv1OIfaBREqXVhVJAQhvZioilqRcV+BOc5cDh8
zpcnu3F3uEknhEj8vf/e5PleLtRDo46Z3y7LEP+nkM5onpl/8ydbT4cvv+pa
PDiHkl5Ep61N7y5t07MzwVmU/WzspD0vk22kBn3fJzG6lJ1DOaFDJ2YjK9gm
cC4lJpe1te81sVeDzbS/bqRz6kIeOx9sARfQkl9vPr+dNrMLqSWQv8sZLmBb
wUX04eMXi66yiL0WvA5sA6+nesP1b23NNrYd7KDCiVVp7To7uxjspMbu3gcT
Bge7BFxKucd9L2cPlLDLwOV0/sbWixnD5WyiO6XmgYoqSlqCxQboYOGC7qL8
kdSd+wwu7hWqJVhUQq+ksdfNnc8nK7i7VUs33V35tMs54Oa+UbUECw90Dz20
Pm5I7fFw96qWXjrXY/1hfOTlvkm1BAsfdB9tGb7fEunwcd+sWoKFHzpYVEGv
olMvvhZTt597QLUM0IKsYHxPf4B7tWoJFkEan+tPmNdUJ01gCdaCdLbVPnj7
apD3IdUElmAtRNO9B68cuRfifVg1hWlq/FZrxpMw78EaWERUE1iCtQgtHPWc
6Xgf4X1UNUXJcM1qm2eK8h6sRWlHX8rRgbIa3teoJrAEa2ARg32M0jtag8vr
Y7wHa2BRq5rAEqyBRRz2cepPS98+dKyW92ANLOr++w+LvajW
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  ImageMargins->0.,
  ImageSize->{223., Automatic},
  PlotRange->{{0., 100.}, {0., 94.0453112293574}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{227, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->105560304]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["LCMs of Fibonacci numbers:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Mod", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"LCM", "[", 
       RowBox[{
        RowBox[{"Fibonacci", "[", "j", "]"}], ",", 
        RowBox[{"Fibonacci", "[", "k", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "100"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "100"}], "}"}]}], "]"}], ",", 
    RowBox[{"Fibonacci", "[", "11", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJy9Wl1T28gSlcYSg1mtHZIhxmCyHoMBY+MFgscbPoyXWcAuLUaRLM08b933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   "], {{0, 0}, {100, 100}}, {0, 88}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  ImageMargins->0.,
  ImageSize->{201., Automatic},
  PlotRangeClipping->True]], "Output",
 ImageSize->{205, 201},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->174517136]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["LCMs of binomial coefficients:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"LCM", "@@", 
    RowBox[{"Binomial", "[", 
     RowBox[{"n", ",", " ", 
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", "n"}], "]"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "3", ",", "12", ",", "10", ",", "60", ",", 
   "105", ",", "280", ",", "252", ",", "2520", ",", "2310", ",", "27720"}], 
  "}"}]], "Output",
 ImageSize->{379, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19505719]
}, Open  ]],

Cell["Compare with:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", "n"}], " ", 
    RowBox[{"LCM", "@@", 
     RowBox[{"Range", "[", 
      RowBox[{"1", ",", "n"}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "13"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "3", ",", "12", ",", "10", ",", "60", ",", 
   "105", ",", "280", ",", "252", ",", "2520", ",", "2310", ",", "27720"}], 
  "}"}]], "Output",
 ImageSize->{379, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->646772013]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["One\[Hyphen]argument form:", "ExampleText",
 CellID->384127646],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LCM", "[", "4", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->62600892],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->181529069]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Compute LCM from factorization:", "ExampleText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"lcm", "[", "args__", "]"}], ":=", 
  RowBox[{"Times", "@@", 
   RowBox[{"(", 
    RowBox[{"Power", "@@@", 
     RowBox[{"(", 
      RowBox[{"Last", "/@", 
       RowBox[{"Split", "[", 
        RowBox[{
         RowBox[{"Sort", "[", 
          RowBox[{"Flatten", "[", 
           RowBox[{
            RowBox[{"FactorInteger", "[", 
             RowBox[{"{", "args", "}"}], "]"}], ",", " ", "1"}], "]"}], "]"}],
          ",", 
         RowBox[{
          RowBox[{
           RowBox[{"#1", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "===", 
           RowBox[{"#2", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], "&"}]}], "]"}]}], ")"}]}], 
    ")"}]}]}]], "Input",
 CellLabel->"In[1]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lcm", "[", 
  RowBox[{"2", ",", "4", ",", "5", ",", "10", ",", "14"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["140"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->81097597]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LCM", "[", 
  RowBox[{"2", ",", "4", ",", "5", ",", "10", ",", "14"}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData["140"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->8058126]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Use in sums:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"LCM", "[", 
    RowBox[{"3", ",", "k"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"k", ",", "100"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["11784"], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->178452749]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Simplify expressions containing ",
 Cell[BoxData[
  ButtonBox["LCM",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LCM"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"LCM", "[", 
    RowBox[{"a", ",", 
     RowBox[{"a", " ", "b"}]}], "]"}], ",", 
   RowBox[{
    RowBox[{"Element", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "Integers"}], "]"}], "&&", 
    RowBox[{"a", ">", "0"}], "&&", 
    RowBox[{"b", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"a", " ", "b"}]], "Output",
 ImageSize->{21, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->372842275]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"LCM", "[", 
     RowBox[{"m", ",", "n"}], "]"}], 
    RowBox[{"GCD", "[", 
     RowBox[{"m", ",", "n"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"Element", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"m", ",", "n"}], "}"}], ",", "Integers"}], "]"}], "&&", 
    RowBox[{"m", ">", "0"}], "&&", 
    RowBox[{"n", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"m", " ", "n"}]], "Output",
 ImageSize->{21, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->94282075]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Reduce inequalities involving ",
 Cell[BoxData[
  ButtonBox["LCM",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LCM"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"LCM", "[", 
      RowBox[{"a", ",", "3"}], "]"}], "<", "6"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"-", "10"}], "<", "a", "<", "10"}]}], ",", "a", ",", 
   "Integers"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "\[Equal]", 
   RowBox[{"-", "3"}]}], "||", 
  RowBox[{"a", "\[Equal]", 
   RowBox[{"-", "1"}]}], "||", 
  RowBox[{"a", "\[Equal]", "0"}], "||", 
  RowBox[{"a", "\[Equal]", "1"}], "||", 
  RowBox[{"a", "\[Equal]", "3"}]}]], "Output",
 ImageSize->{253, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->482094293]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->234590829],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LCM",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LCM"]], "InlineFormula"],
 " sorts its arguments:"
}], "ExampleText",
 CellID->100721816],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LCM", "[", 
  RowBox[{"b", ",", " ", "a"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31529916],

Cell[BoxData[
 RowBox[{"LCM", "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->257628052]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Signs are discarded:", "ExampleText",
 CellID->712636638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LCM", "[", 
  RowBox[{
   RowBox[{"-", "3"}], ",", "7"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->609684990],

Cell[BoxData["21"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->326804311]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->55091055],

Cell["The arguments must be explicit integers:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LCM", "[", 
  RowBox[{"2.", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"LCM", "::", "\<\"exact\"\>"}], ":", 
  " ", "\<\"Argument \\!\\(2.`\\) in \\!\\(LCM[\\(\\(2.`, 3\\)\\)]\\) is not \
an exact number. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/exact\\\", ButtonNote -> \
\\\"LCM::exact\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->346180458],

Cell[BoxData[
 RowBox[{"LCM", "[", 
  RowBox[{"2.`", ",", "3"}], "]"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->421540003]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Plot the argument of the Fourier transform of the LCMs:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Arg", "[", 
   RowBox[{"Fourier", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"LCM", "[", 
       RowBox[{"m", ",", " ", "n"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"m", ",", "100"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "100"}], "}"}]}], "]"}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{182, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30013409]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Form LCMs of 1 with rational numbers:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"#", ",", 
      RowBox[{"LCM", "[", 
       RowBox[{"1", ",", "#"}], "]"}]}], "}"}], "&"}], "/@", " ", 
   RowBox[{"Union", "[", 
    RowBox[{"Flatten", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"i", "/", "j"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "40"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"2", "j"}]}], "}"}]}], "]"}], "]"}], "]"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{258, 171},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->88640786]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10551],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GCD"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialLCM",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialLCM"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7891]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32668],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->18370]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->25402],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/LeastCommonMultiple.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/IntegerFunctions/LCM/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
LCM"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->654011928],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "MoreAbout",
 CellID->140818022],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->238113035]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LCM - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 52, 24.6860238}", "context" -> "System`", 
    "keywords" -> {
     "common denominator", "ilcm", "least common multiple", 
      "lowest common multiple"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LCM[n_1, n_2, ...] gives the least common multiple of the integers n_i. \
", "synonyms" -> {}, "title" -> "LCM", "type" -> "Symbol", "uri" -> 
    "ref/LCM"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5660, 199, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->21397871]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 82769, 2059}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2083, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2706, 79, 41, 1, 70, "ObjectName",
 CellID->31243],
Cell[2750, 82, 816, 27, 70, "Usage",
 CellID->15804]
}, Open  ]],
Cell[CellGroupData[{
Cell[3603, 114, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4081, 131, 132, 4, 70, "Notes",
 CellID->126685801],
Cell[4216, 137, 784, 29, 70, "Notes",
 CellID->12992],
Cell[5003, 168, 195, 7, 70, "Notes",
 CellID->555347927],
Cell[5201, 177, 422, 17, 70, "Notes",
 CellID->26167]
}, Closed]],
Cell[CellGroupData[{
Cell[5660, 199, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->21397871],
Cell[CellGroupData[{
Cell[6044, 213, 147, 5, 70, "ExampleSection",
 CellID->97034666],
Cell[6194, 220, 63, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[6282, 224, 112, 3, 28, "Input"],
Cell[6397, 229, 158, 5, 36, "Output",
 CellID->39217535]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6604, 240, 200, 6, 70, "ExampleSection"],
Cell[6807, 248, 180, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[7012, 258, 161, 5, 70, "Input"],
Cell[7176, 265, 215, 7, 36, "Output",
 CellID->231928024]
}, Open  ]],
Cell[7406, 275, 105, 2, 70, "ExampleDelimiter"],
Cell[7514, 279, 46, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[7585, 283, 184, 6, 70, "Input"],
Cell[7772, 291, 158, 5, 36, "Output",
 CellID->441371647]
}, Open  ]],
Cell[CellGroupData[{
Cell[7967, 301, 204, 7, 70, "Input"],
Cell[8174, 310, 216, 7, 36, "Output",
 CellID->226196647]
}, Open  ]],
Cell[8405, 320, 105, 2, 70, "ExampleDelimiter"],
Cell[8513, 324, 50, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[8588, 328, 190, 7, 70, "Input"],
Cell[8781, 337, 216, 7, 36, "Output",
 CellID->813831332]
}, Open  ]],
Cell[9012, 347, 125, 3, 70, "ExampleDelimiter",
 CellID->444699584],
Cell[9140, 352, 203, 7, 70, "ExampleText",
 CellID->557828371],
Cell[CellGroupData[{
Cell[9368, 363, 161, 5, 70, "Input",
 CellID->498633172],
Cell[9532, 370, 256, 8, 50, "Output",
 CellID->73006854]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9837, 384, 207, 6, 70, "ExampleSection"],
Cell[10047, 392, 163, 6, 70, "ExampleText",
 CellID->264496307],
Cell[CellGroupData[{
Cell[10235, 402, 160, 5, 70, "Input",
 CellID->11880853],
Cell[10398, 409, 199, 5, 36, "Output",
 CellID->132706666]
}, Open  ]],
Cell[10612, 417, 124, 3, 70, "ExampleDelimiter",
 CellID->20351805],
Cell[CellGroupData[{
Cell[10761, 424, 332, 11, 70, "Input",
 CellID->37344415],
Cell[11096, 437, 8443, 142, 70, "Output",
 Evaluatable->False,
 CellID->885927617]
}, Open  ]],
Cell[19554, 582, 105, 2, 70, "ExampleDelimiter"],
Cell[19662, 586, 211, 5, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[19898, 595, 261, 8, 70, "Input"],
Cell[20162, 605, 418, 11, 36, "Output",
 CellID->705958177]
}, Open  ]],
Cell[20595, 619, 105, 2, 70, "ExampleDelimiter"],
Cell[20703, 623, 39, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[20767, 627, 199, 6, 70, "Input"],
Cell[20969, 635, 303, 9, 36, "Output",
 CellID->79060792]
}, Open  ]],
Cell[21287, 647, 134, 3, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[21446, 654, 251, 7, 70, "Input"],
Cell[21700, 663, 1313, 31, 164, "Output",
 CellID->105560304]
}, Open  ]],
Cell[23028, 697, 105, 2, 70, "ExampleDelimiter"],
Cell[23136, 701, 49, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[23210, 705, 508, 15, 70, "Input"],
Cell[23721, 722, 5635, 99, 222, "Output",
 CellID->174517136]
}, Open  ]],
Cell[29371, 824, 105, 2, 70, "ExampleDelimiter"],
Cell[29479, 828, 53, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[29557, 832, 323, 10, 70, "Input"],
Cell[29883, 844, 342, 10, 36, "Output",
 CellID->19505719]
}, Open  ]],
Cell[30240, 857, 36, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[30301, 861, 293, 10, 70, "Input"],
Cell[30597, 873, 343, 10, 36, "Output",
 CellID->646772013]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30989, 889, 217, 6, 70, "ExampleSection"],
Cell[31209, 897, 69, 1, 70, "ExampleText",
 CellID->384127646],
Cell[CellGroupData[{
Cell[31303, 902, 98, 3, 70, "Input",
 CellID->62600892],
Cell[31404, 907, 158, 5, 36, "Output",
 CellID->181529069]
}, Open  ]],
Cell[31577, 915, 105, 2, 70, "ExampleDelimiter"],
Cell[31685, 919, 54, 0, 70, "ExampleText"],
Cell[31742, 921, 733, 23, 70, "Input"],
Cell[CellGroupData[{
Cell[32500, 948, 134, 3, 70, "Input"],
Cell[32637, 953, 159, 5, 36, "Output",
 CellID->81097597]
}, Open  ]],
Cell[CellGroupData[{
Cell[32833, 963, 134, 3, 70, "Input"],
Cell[32970, 968, 158, 5, 36, "Output",
 CellID->8058126]
}, Open  ]],
Cell[33143, 976, 105, 2, 70, "ExampleDelimiter"],
Cell[33251, 980, 35, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[33311, 984, 214, 7, 70, "Input"],
Cell[33528, 993, 162, 5, 36, "Output",
 CellID->178452749]
}, Open  ]],
Cell[33705, 1001, 105, 2, 70, "ExampleDelimiter"],
Cell[33813, 1005, 185, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[34023, 1016, 403, 13, 70, "Input"],
Cell[34429, 1031, 180, 6, 36, "Output",
 CellID->372842275]
}, Open  ]],
Cell[CellGroupData[{
Cell[34646, 1042, 456, 15, 70, "Input"],
Cell[35105, 1059, 179, 6, 36, "Output",
 CellID->94282075]
}, Open  ]],
Cell[35299, 1068, 105, 2, 70, "ExampleDelimiter"],
Cell[35407, 1072, 183, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[35615, 1083, 304, 10, 70, "Input"],
Cell[35922, 1095, 403, 13, 36, "Output",
 CellID->482094293]
}, Open  ]],
Cell[36340, 1111, 125, 3, 70, "ExampleDelimiter",
 CellID->234590829],
Cell[36468, 1116, 188, 7, 70, "ExampleText",
 CellID->100721816],
Cell[CellGroupData[{
Cell[36681, 1127, 126, 4, 70, "Input",
 CellID->31529916],
Cell[36810, 1133, 210, 7, 36, "Output",
 CellID->257628052]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[37069, 1146, 210, 6, 70, "ExampleSection"],
Cell[37282, 1154, 63, 1, 70, "ExampleText",
 CellID->712636638],
Cell[CellGroupData[{
Cell[37370, 1159, 141, 5, 70, "Input",
 CellID->609684990],
Cell[37514, 1166, 159, 5, 36, "Output",
 CellID->326804311]
}, Open  ]],
Cell[37688, 1174, 124, 3, 70, "ExampleDelimiter",
 CellID->55091055],
Cell[37815, 1179, 63, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[37903, 1183, 103, 3, 70, "Input"],
Cell[38009, 1188, 402, 8, 70, "Message",
 CellID->346180458],
Cell[38414, 1198, 212, 7, 36, "Output",
 CellID->421540003]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38675, 1211, 208, 6, 70, "ExampleSection"],
Cell[38886, 1219, 78, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[38989, 1223, 404, 13, 70, "Input"],
Cell[39396, 1238, 31094, 514, 70, "Output",
 Evaluatable->False,
 CellID->30013409]
}, Open  ]],
Cell[70505, 1755, 105, 2, 70, "ExampleDelimiter"],
Cell[70613, 1759, 60, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[70698, 1763, 556, 19, 70, "Input"],
Cell[71257, 1784, 7218, 122, 70, "Output",
 Evaluatable->False,
 CellID->88640786]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[78536, 1913, 311, 9, 70, "SeeAlsoSection",
 CellID->10551],
Cell[78850, 1924, 450, 17, 70, "SeeAlso",
 CellID->7891]
}, Open  ]],
Cell[CellGroupData[{
Cell[79337, 1946, 314, 9, 70, "TutorialsSection",
 CellID->32668],
Cell[79654, 1957, 198, 4, 70, "Tutorials",
 CellID->18370]
}, Open  ]],
Cell[CellGroupData[{
Cell[79889, 1966, 321, 9, 70, "RelatedLinksSection",
 CellID->25402],
Cell[80213, 1977, 190, 4, 70, "RelatedLinks"],
Cell[80406, 1983, 192, 4, 70, "RelatedLinks"],
Cell[80601, 1989, 381, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[81019, 2007, 319, 9, 70, "MoreAboutSection",
 CellID->654011928],
Cell[81341, 2018, 145, 3, 70, "MoreAbout",
 CellID->140818022],
Cell[81489, 2023, 162, 3, 70, "MoreAbout",
 CellID->238113035]
}, Open  ]],
Cell[81666, 2029, 27, 0, 70, "History"],
Cell[81696, 2031, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

