(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10800,        387]
NotebookOptionsPosition[      8155,        299]
NotebookOutlinePosition[      9398,        335]
CellTagsIndexPosition[      9314,        330]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Loops and Control Structures" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LoopsAndControlStructures"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Loops and Control Structures\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Catch" :> Documentation`HelpLookup["paclet:ref/Catch"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Catch\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Flow Control" :> 
          Documentation`HelpLookup["paclet:guide/FlowControl"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Flow Control\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Label", "ObjectName",
 CellID->9035],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Label",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Label"], "[", 
       StyleBox["tag", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a point in a compound expression to which \
control can be transferred using ",
     Cell[BoxData[
      ButtonBox["Goto",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Goto"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31287]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Label",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Label"]], "InlineFormula"],
 " must appear as an explicit element of a ",
 Cell[BoxData[
  ButtonBox["CompoundExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CompoundExpression"]], "InlineFormula"],
 " object. "
}], "Notes",
 CellID->32203],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Label",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Label"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7537]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->541500834],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->346540644],

Cell[TextData[{
 "Write a loop using ",
 Cell[BoxData[
  ButtonBox["Goto",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Goto"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Label",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Label"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->379349084],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "a_", "]"}], " ", ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", " ", "=", " ", "1."}], ",", "xp"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Label", "[", "begin", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{"xp", " ", "-", " ", "x"}], "]"}], " ", "<", " ", 
        SuperscriptBox["10", 
         RowBox[{"-", "8"}]]}], ",", 
       RowBox[{"Goto", "[", "end", "]"}]}], "]"}], ";", "\[IndentingNewLine]",
      
     RowBox[{"xp", " ", "=", " ", "x"}], ";", "\[IndentingNewLine]", 
     RowBox[{"x", " ", "=", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "+", 
         RowBox[{"a", "/", "x"}]}], ")"}], "/", "2"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Goto", "[", "begin", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Label", "[", "end", "]"}], ";", "\[IndentingNewLine]", "x"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->106177899],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "2", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->497843867],

Cell[BoxData["1.414213562373095`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->334268934]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25370],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->29636]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13579],

Cell[TextData[ButtonBox["Loops and Control Structures",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LoopsAndControlStructures"]], "Tutorials",
 CellID->27021]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Flow Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FlowControl"]], "MoreAbout",
 CellID->228498332]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Label - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 52, 9.3575064}", "context" -> "System`", 
    "keywords" -> {"goto", "goto destination"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Label[tag] represents a point in a compound expression to which control \
can be transferred using Goto. ", "synonyms" -> {}, "title" -> "Label", 
    "type" -> "Symbol", "uri" -> "ref/Label"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4270, 150, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->541500834]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9171, 323}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1725, 46, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2348, 73, 42, 1, 70, "ObjectName",
 CellID->9035],
Cell[2393, 76, 664, 21, 70, "Usage",
 CellID->31287]
}, Open  ]],
Cell[CellGroupData[{
Cell[3094, 102, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3572, 119, 355, 12, 70, "Notes",
 CellID->32203],
Cell[3930, 133, 303, 12, 70, "Notes",
 CellID->7537]
}, Closed]],
Cell[CellGroupData[{
Cell[4270, 150, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->541500834],
Cell[CellGroupData[{
Cell[4655, 164, 148, 5, 70, "ExampleSection",
 CellID->346540644],
Cell[4806, 171, 317, 13, 70, "ExampleText",
 CellID->379349084],
Cell[5126, 186, 1100, 31, 70, "Input",
 CellID->106177899],
Cell[CellGroupData[{
Cell[6251, 221, 97, 3, 28, "Input",
 CellID->497843867],
Cell[6351, 226, 175, 5, 36, "Output",
 CellID->334268934]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6587, 238, 311, 9, 70, "SeeAlsoSection",
 CellID->25370],
Cell[6901, 249, 190, 6, 70, "SeeAlso",
 CellID->29636]
}, Open  ]],
Cell[CellGroupData[{
Cell[7128, 260, 314, 9, 70, "TutorialsSection",
 CellID->13579],
Cell[7445, 271, 164, 3, 70, "Tutorials",
 CellID->27021]
}, Open  ]],
Cell[CellGroupData[{
Cell[7646, 279, 299, 8, 70, "MoreAboutSection"],
Cell[7948, 289, 135, 3, 70, "MoreAbout",
 CellID->228498332]
}, Open  ]],
Cell[8098, 295, 27, 0, 70, "History"],
Cell[8128, 297, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

