(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     58590,       1563]
NotebookOptionsPosition[     52602,       1358]
NotebookOutlinePosition[     54017,       1397]
CellTagsIndexPosition[     53931,       1392]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Style" :> Documentation`HelpLookup["paclet:ref/Style"], 
          "BaseStyle" :> Documentation`HelpLookup["paclet:ref/BaseStyle"], 
          "TicksStyle" :> Documentation`HelpLookup["paclet:ref/TicksStyle"], 
          "FrameStyle" :> 
          Documentation`HelpLookup["paclet:ref/FrameStyle"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Style\"\>", 2->"\<\"BaseStyle\"\>", 
       3->"\<\"TicksStyle\"\>", 4->"\<\"FrameStyle\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Annotation & Appearance" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsAnnotationAndAppearance"], 
          "Graphics Styling in Notebooks" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsStylingInNotebooks"],
           "Options & Styling for Interactive Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:guide/OptionsAndStylingForInteractiveManipulation"], 
          "New in 6.0: Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FormattingAndStyling"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graphics Annotation & Appearance\"\>", 
       2->"\<\"Graphics Styling in Notebooks\"\>", 
       3->"\<\"Options & Styling for Interactive Manipulation\"\>", 
       4->"\<\"New in 6.0: Formatting & Styling\"\>", 
       5->"\<\"New in 6.0: Graphics & Visualization Options\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["LabelStyle", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["LabelStyle",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LabelStyle"]], "InlineFormula"],
     " \[LineSeparator]is an option for formatting and related constructs \
that specifies the style to use in displaying their label-like elements. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32501]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Any style specification as used in ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 " can be used as a setting for ",
 Cell[BoxData[
  ButtonBox["LabelStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LabelStyle"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->3535],

Cell["Typical forms of settings include: ", "Notes",
 CellID->4692],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"style\", \"TI\"]\)\>\"", Cell[
    "a named style from the current stylesheets ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["opt", "TI"], "1"], "->", 
       SubscriptBox[
        StyleBox["val", "TI"], "1"]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[
    "a list of explicit option settings ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"style\", \"TI\"]\)\>\"", ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["opt", "TI"], "1"], "->", 
       SubscriptBox[
        StyleBox["val", "TI"], "1"]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[
    "a named style modified by option settings ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->26808],

Cell[TextData[{
 "Color directives such as ",
 Cell[BoxData[
  ButtonBox["Red",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Red"]], "InlineFormula"],
 ", as well as text specifications such as ",
 Cell[BoxData[
  ButtonBox["Bold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Bold"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Small",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Small"]], "InlineFormula"],
 ", can be given in place of options, just as in ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->5153],

Cell[TextData[{
 "Giving the option setting ",
 Cell[BoxData[
  RowBox[{"LabelStyle", "->", 
   StyleBox["spec", "TI"]}]], "InlineFormula"],
 " is effectively equivalent to replacing the label-like elements of a \
formatting or related construct by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"], "[", 
   RowBox[{
    StyleBox["label", "TI"], ",", 
    StyleBox["spec", "TI"]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->14041],

Cell[TextData[{
 "Any outside styles not explicitly overridden by settings in ",
 Cell[BoxData[
  ButtonBox["LabelStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LabelStyle"]], "InlineFormula"],
 " will still be used."
}], "Notes",
 CellID->3528]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->337634936],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->318455258],

Cell["Specify overall style of all the label-like elements:", "ExampleText",
 CellID->1544021785],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", "Orange"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8685113],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->264070272]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", "Orange"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->271359613],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->115398069]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->648820976],

Cell[TextData[{
 "Frame labels are affected by ",
 Cell[BoxData[
  ButtonBox["LabelStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LabelStyle"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->1959667813],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", "\"\<abc\>\""}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Blue", ",", "Large"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2146602050],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$22308$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$22308$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
      "Options" :> {FrameLabel -> "abc", LabelStyle -> Directive[
          RGBColor[0, 0, 1], Large]}, "DefaultOptions" :> {}],
     ImageSizeCache->{273., {64., 69.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{277, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->466487419]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4501],

Cell[TextData[{
 "Use compounded styles, using ",
 Cell[BoxData[
  ButtonBox["Directive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Directive"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1538555329],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Bold", ",", 
      RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->952974595],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->203581194]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->142900083],

Cell[TextData[{
 "Individually styled labels can be used with ",
 Cell[BoxData[
  ButtonBox["LabelStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LabelStyle"]], "InlineFormula"],
 ", and have higher priority:"
}], "ExampleText",
 CellID->182715136],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"Style", "[", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], ",", "Blue", ",", "20"}], "]"}]}], ",", 
   
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Orange", ",", 
      RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11780652],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 128},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->177513344]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"Style", "[", 
     RowBox[{"\"\<abc\>\"", ",", "Red", ",", "Italic"}], "]"}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Blue", ",", "Large"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->162628140],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$452$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$452$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
      "Options" :> {FrameLabel -> Style["abc", 
          RGBColor[1, 0, 0], Italic], LabelStyle -> Directive[
          RGBColor[0, 0, 1], Large]}, "DefaultOptions" :> {}],
     ImageSizeCache->{273., {64., 69.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{277, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4060669]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->636],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AxesStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AxesStyle"]], "InlineFormula"],
 " can be used to together with ",
 Cell[BoxData[
  ButtonBox["LabelStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LabelStyle"]], "InlineFormula"],
 " and has higher priority: "
}], "ExampleText",
 CellID->76579695],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Blue", ",", 
      RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], "]"}]}], ",", 
   
   RowBox[{"AxesStyle", "\[Rule]", "Orange"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->659551913],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1149082]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->59691103],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TicksStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TicksStyle"]], "InlineFormula"],
 " can be used to together with ",
 Cell[BoxData[
  ButtonBox["LabelStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LabelStyle"]], "InlineFormula"],
 " and has higher priority: "
}], "ExampleText",
 CellID->16302533],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Blue", ",", 
      RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], "]"}]}], ",", 
   
   RowBox[{"TicksStyle", "\[Rule]", "Orange"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->610817034],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->509402669]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->301092200],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FrameStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameStyle"]], "InlineFormula"],
 " can be used to together with ",
 Cell[BoxData[
  ButtonBox["LabelStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LabelStyle"]], "InlineFormula"],
 " and has higher priority: "
}], "ExampleText",
 CellID->320190893],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Red", ",", 
      RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], "]"}]}], ",", 
   
   RowBox[{"FrameStyle", "\[Rule]", "Green"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14609354],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->386502831]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->141439839],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FrameTicksStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameTicksStyle"]], "InlineFormula"],
 " can be used together with ",
 Cell[BoxData[
  ButtonBox["LabelStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LabelStyle"]], "InlineFormula"],
 " and has higher priority:"
}], "ExampleText",
 CellID->271652939],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Red", ",", 
      RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], "]"}]}], ",", 
   
   RowBox[{"FrameTicksStyle", "\[Rule]", "Green"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->131785817],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWluIVVUY3u5zzlyc+8WZ4zgzjjOjmY4zo2aTjTaZqUwXoge1iB4mqcaH
0sxe6qVe6qV8KIqEyIcu0OXBSIzAIBIiIRIiISoIg7CHJEh6EILT/69/rf3v
+fba++yjSEQDc87691rrv3z/Za291rl77vD8w4/NHd6/b25o16G5g/P79z05
tPPAIXpUWBQEwQn6P1IOqF2hlvk/UanQd/LzEf4sUaMS/dHwWfP1KH8WbB89
vcN8zcefUnM2ehpW3Bgzs6hcHcc0La7mc4Q+C2RkL32X6LvP6EcNK3qJ7S/H
voNi1G+fFgyvYYNGvI/R6wWOy4Du9s7qSeel0q1kdtQi/s7QogxSmX9dIPZd
e+lLPajWItWDfA3SfT5dyIklF20UJOcvic1nOvSOCjM08FtWBr7+UelPQ2pk
6eJi28Vun53TW8kf09nZw35l4SUzh/4Kpl6YvyLQ1fqr0f+L+UWlA+sBjN46
8Vag0VsHIwpAF2ukr2h+PdEXLvx5+oufPzv10/nzf9hIRN2uiexa58dy36HM
VbgYJOeX7HP0AtZTM6/h0qXLzzz96d7d79Lnc8+eevCB9546fJJQaaky22Wi
CRL7TCpav9+eaNS0oX/84fd9D31IwNv+M1/9QvTZb34NdsB44TrgRy0adbOh
SfH988fp03qRrDvw+MfM9XYvV1PlE7WoBGM3G/rixb9IQ+bd4HhberuXd59F
iDXhGiYaErpkKjcbDX3uu99Iw8uX/w622XHi3RHgeZOhPzn5/QvPf87NJkO/
8/bZo6+f4eY2rw7IZSpmCX0GzYYm6YQaeaQmLq+8/OUH73/LTYkVQpks4eat
qVzYvqmY/7nZZmgKP0pEbt6SicONMLoNuM3ksmATzOrw6JCXi87qAK7pXNg+
mU11h3KOm10QH1sycbgBfCCzSRFSh5tbc1mw0fn/ztljHIOybyCFbDncUgOX
j46fe+nF09wULqQYqZfNhe0TSwgyAk5nU3bde89brJPUC1lluBl6ddgA2Mse
lpKFUqYSVZ1qlggXMoOMUS7K1WRhkXLejne1uFrNWw84LwWbTVSXyGbqj1jX
xFvRXwroC++ofwFvt4b41hwmhbeUUOVNlYMWDLZDeFPxoDLGHqoE+fWeNDRh
Sby4KW8ZGv8SF5ofodeD8VUutnqDFK2TIoXWHVrsVAp10pB0KTwr1H0LcNd8
WQZ+Fu4UyARZOncfUixtEqJP1kCNaYlWgotAc9zTK8YEWDoAszcAd1xh/Rkz
ARYOAj0JiGAU+LmOG1pXlOWVhXk5CV5M58p4TMDs5cBduBErYugsT8dxHCwc
AnocLMbdhN/idaDTCtB5HCyuhatyWQFSxsHydK6MB1o+DPSYx/J0HMdAlxHQ
dQwsxtzzWzwGXEZAivRrlNfCVS0dBXqNs5weURUP6jNxRMtXgk7CTTMzeiPJ
XAHXguUrgcsakOLXkStYIUhGgnCnUi2Ln+WuFl8PdIOXu+xa9SzN7D8T+2/M
ZtGclhhaaLh5HViyGiz1yzZv/PakgU/uWtNl23dVsobCTyzTuinSdae1GnD3
S2+wUttTpR6JVs46O7YzXcNSxF8EW610rRCtNbNXQcw1pmIU908uDYSp0SA8
9ubX4i3N21WAj1/ygriri3qjgBIuutJG8WZrjfRrRvqluAwMIYIkn3WvsRbQ
G/Wj58tI1Z3+JCZXWmSwoo0CMotTdQ7q41w1y0YBlbWAivRr1mZIiD1FdIYB
nXWAjvRrfjZlYl8ALGW27tDWAUrSr/m3uJK1qhQgDmTFkx2qcleEhgGhdN2T
UtRzsgfQvazsOPTNcAgQaq5BiiI1BEhNAFLSr++E6VLCqMIrUssBqQlACvc5
TZl+KAJCgxBD6yGGBsHWllwIFWEWc+FMw53xIGiTjzsiNACxEr3V2WwcALo1
E/868FY/xIi8VWsW9oNNLZn4i+66HvQDAhuBWz9I8+te7RRObNL32j6HCIHG
502bANGo38ZY21VI1TfePrBNpGoFkX59Y84vtRD5Td+B+yCS8VxH+jWvnN9q
t1N2bFpVyqDJFEgqgybtXjvjt3u+00+RqvudMqA9BWiWAW2/1P5KvAqhNM2h
MkSUSNPToTJElF9aNWRlz6bZYW6wYrm4GXzcAxHW4ZXqMl12C5qLPSBNuGsV
6wE/tzvtM/f/IkXParodkja3pgHJbhc9BB43O1NtSErRaOiGaJiGaOiGaMgn
RfYpuq/pAnoaoqTL0bbOdGX6owl07gSb5OxUK7P069l7ZyWr8i4G3DsB960O
d5u1nV5bqyFkVl9a6TpA9xnQXWJH9wjdubnH8W0HG2bAhjY3nszgG5ElmfjL
6qv7mFawYRvY0Ar+6s7EP7rTsLHQArrdVrEVhOgF/XZ8Ty6EWkDnZrBpO8RM
M+RBPiliudYdiS0KFHIF4y53ZZrz0q93Sr2ZfmhzXrR3Zo0OCXsbtNP1E1Ic
BY0OOXvv1Zvph+hmhnTREwG1ZZehSXGqoawr9pe9uvNqWgqSJ34SoVKRWZqs
0rqfmY3166kctch/NMSdI2esjdzE1arD2UAI8V1mwUkhBJnrXS5KKLa0n1qE
ID11/HOcB/MpvZFWT/4gkGa2HiVcd2x/g+zhw/cQ5vjua+N0l48XdVNsmVP+
6GbZv3Ze2W0+ARU7A/53b9SvYn7ovM7GeH4xcKU3+oMeOQVzoRL8u7/x+K/P
T/uNSuJk69WKy3pm8Zqhkr8hekKcDO9aSptbwuAgPK0H2uxkg930WYqdTkp2
RaO8T0LgJL+o0hESU6LFHp+uibFhDqnJJ0XgbW4Dg73wtMGvv18HtCr2a0y/
tPvgabEGHNFvhVwScFSxVqRSbbnfh0AOnHz+S9GqqsxCHL9SfL6ThT0xixbI
k/jb7R3dA1L9ubHH6tIMvY1A+/MvmbfBon8AJ9ksPg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->748530295]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24205],

Cell["Interactive manipulation of label style:", "ExampleText",
 CellID->57126534],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"Sin", "[", "x", "]"}], ",", "Large"}], "]"}]}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"c", ",", "s"}], "]"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "Black", ",", "\"\<color\>\""}], "}"}], ",", 
     "Black"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"s", ",", "Plain", ",", "\"\<style\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Plain", ",", "Italic", ",", "Bold"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29357999],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`c$$ = GrayLevel[0], $CellContext`s$$ = 
    Plain, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`c$$], 
       GrayLevel[0], "color"}, 
      GrayLevel[0]}, {{
       Hold[$CellContext`s$$], Plain, "style"}, {Plain, Italic, Bold}}}, 
    Typeset`size$$ = {180., {64., 69.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True, $CellContext`s$2233$$ =
     0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`c$$ = GrayLevel[0], $CellContext`s$$ = 
        Plain}, "ControllerVariables" :> {
        Hold[$CellContext`s$$, $CellContext`s$2233$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        Sin[$CellContext`x], {$CellContext`x, 0, 10}, PlotLabel -> Style[
          Sin[$CellContext`x], Large], LabelStyle -> 
        Directive[$CellContext`c$$, $CellContext`s$$]], 
      "Specifications" :> {{{$CellContext`c$$, 
          GrayLevel[0], "color"}, 
         GrayLevel[0]}, {{$CellContext`s$$, Plain, "style"}, {
         Plain, Italic, Bold}}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{246., {124., 129.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{250, 255},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->287688367]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14379],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BaseStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BaseStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TicksStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TicksStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrameStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrameStyle"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10632]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->14934460],

Cell[TextData[ButtonBox["Graphics Annotation & Appearance",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsAnnotationAndAppearance"]], "MoreAbout",
 CellID->35323917],

Cell[TextData[ButtonBox["Graphics Styling in Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsStylingInNotebooks"]], "MoreAbout",
 CellID->603498010],

Cell[TextData[ButtonBox["Options & Styling for Interactive Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/OptionsAndStylingForInteractiveManipulation"]], "MoreAbout",
 CellID->318634024],

Cell[TextData[ButtonBox["New in 6.0: Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FormattingAndStyling"]], "MoreAbout",
 CellID->245300986],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->61147501]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LabelStyle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 52, 9.5918874}", "context" -> "System`", 
    "keywords" -> {
     "colored labels", "label color", "label size", "plot label", 
      "label controls", "axes tick labels", "frame tick labels"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "LabelStyle is an option for formatting and related constructs that \
specifies the style to use in displaying their label-like elements. ", 
    "synonyms" -> {"label style"}, "title" -> "LabelStyle", "type" -> 
    "Symbol", "uri" -> "ref/LabelStyle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8723, 265, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->337634936]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 53788, 1385}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2362, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2985, 79, 1575, 37, 70, "ObjectNameGrid"],
Cell[4563, 118, 514, 14, 70, "Usage",
 CellID->32501]
}, Open  ]],
Cell[CellGroupData[{
Cell[5114, 137, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5592, 154, 359, 13, 70, "Notes",
 CellID->3535],
Cell[5954, 169, 67, 1, 70, "Notes",
 CellID->4692],
Cell[6024, 172, 1265, 34, 70, "2ColumnTableMod",
 CellID->26808],
Cell[7292, 208, 631, 23, 70, "Notes",
 CellID->5153],
Cell[7926, 233, 502, 17, 70, "Notes",
 CellID->14041],
Cell[8431, 252, 255, 8, 70, "Notes",
 CellID->3528]
}, Closed]],
Cell[CellGroupData[{
Cell[8723, 265, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->337634936],
Cell[CellGroupData[{
Cell[9108, 279, 148, 5, 70, "ExampleSection",
 CellID->318455258],
Cell[9259, 286, 97, 1, 70, "ExampleText",
 CellID->1544021785],
Cell[CellGroupData[{
Cell[9381, 291, 346, 10, 28, "Input",
 CellID->8685113],
Cell[9730, 303, 3084, 55, 142, "Output",
 Evaluatable->False,
 CellID->264070272]
}, Open  ]],
Cell[CellGroupData[{
Cell[12851, 363, 536, 16, 47, "Input",
 CellID->271359613],
Cell[13390, 381, 3067, 54, 163, "Output",
 Evaluatable->False,
 CellID->115398069]
}, Open  ]],
Cell[16472, 438, 125, 3, 70, "ExampleDelimiter",
 CellID->648820976],
Cell[16600, 443, 218, 8, 70, "ExampleText",
 CellID->1959667813],
Cell[CellGroupData[{
Cell[16843, 455, 368, 10, 70, "Input",
 CellID->2146602050],
Cell[17214, 467, 1642, 36, 70, "Output",
 CellID->466487419]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18905, 509, 215, 7, 70, "ExampleSection",
 CellID->4501],
Cell[19123, 518, 215, 8, 70, "ExampleText",
 CellID->1538555329],
Cell[CellGroupData[{
Cell[19363, 530, 471, 14, 70, "Input",
 CellID->952974595],
Cell[19837, 546, 2998, 53, 70, "Output",
 Evaluatable->False,
 CellID->203581194]
}, Open  ]],
Cell[22850, 602, 125, 3, 70, "ExampleDelimiter",
 CellID->142900083],
Cell[22978, 607, 257, 8, 70, "ExampleText",
 CellID->182715136],
Cell[CellGroupData[{
Cell[23260, 619, 552, 17, 70, "Input",
 CellID->11780652],
Cell[23815, 638, 3100, 55, 70, "Output",
 Evaluatable->False,
 CellID->177513344]
}, Open  ]],
Cell[CellGroupData[{
Cell[26952, 698, 444, 12, 70, "Input",
 CellID->162628140],
Cell[27399, 712, 1681, 37, 70, "Output",
 CellID->4060669]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29129, 755, 231, 7, 70, "ExampleSection",
 CellID->636],
Cell[29363, 764, 362, 12, 70, "ExampleText",
 CellID->76579695],
Cell[CellGroupData[{
Cell[29750, 780, 665, 20, 70, "Input",
 CellID->659551913],
Cell[30418, 802, 3057, 54, 70, "Output",
 Evaluatable->False,
 CellID->1149082]
}, Open  ]],
Cell[33490, 859, 124, 3, 70, "ExampleDelimiter",
 CellID->59691103],
Cell[33617, 864, 364, 12, 70, "ExampleText",
 CellID->16302533],
Cell[CellGroupData[{
Cell[34006, 880, 666, 20, 70, "Input",
 CellID->610817034],
Cell[34675, 902, 3104, 55, 70, "Output",
 Evaluatable->False,
 CellID->509402669]
}, Open  ]],
Cell[37794, 960, 125, 3, 70, "ExampleDelimiter",
 CellID->301092200],
Cell[37922, 965, 365, 12, 70, "ExampleText",
 CellID->320190893],
Cell[CellGroupData[{
Cell[38312, 981, 711, 21, 70, "Input",
 CellID->14609354],
Cell[39026, 1004, 3100, 55, 70, "Output",
 Evaluatable->False,
 CellID->386502831]
}, Open  ]],
Cell[42141, 1062, 125, 3, 70, "ExampleDelimiter",
 CellID->141439839],
Cell[42269, 1067, 371, 12, 70, "ExampleText",
 CellID->271652939],
Cell[CellGroupData[{
Cell[42665, 1083, 717, 21, 70, "Input",
 CellID->131785817],
Cell[43385, 1106, 3185, 56, 70, "Output",
 Evaluatable->False,
 CellID->748530295]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[46619, 1168, 224, 7, 70, "ExampleSection",
 CellID->24205],
Cell[46846, 1177, 82, 1, 70, "ExampleText",
 CellID->57126534],
Cell[CellGroupData[{
Cell[46953, 1182, 909, 28, 70, "Input",
 CellID->29357999],
Cell[47865, 1212, 2063, 45, 70, "Output",
 CellID->287688367]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[49989, 1264, 311, 9, 70, "SeeAlsoSection",
 CellID->14379],
Cell[50303, 1275, 945, 35, 70, "SeeAlso",
 CellID->10632]
}, Open  ]],
Cell[CellGroupData[{
Cell[51285, 1315, 318, 9, 70, "MoreAboutSection",
 CellID->14934460],
Cell[51606, 1326, 174, 3, 70, "MoreAbout",
 CellID->35323917],
Cell[51783, 1331, 167, 3, 70, "MoreAbout",
 CellID->603498010],
Cell[51953, 1336, 204, 4, 70, "MoreAbout",
 CellID->318634024],
Cell[52160, 1342, 171, 3, 70, "MoreAbout",
 CellID->245300986],
Cell[52334, 1347, 196, 4, 70, "MoreAbout",
 CellID->61147501]
}, Open  ]],
Cell[52545, 1354, 27, 0, 70, "History"],
Cell[52575, 1356, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

