(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     48536,       1700]
NotebookOptionsPosition[     39915,       1401]
NotebookOutlinePosition[     41228,       1438]
CellTagsIndexPosition[     41142,       1433]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Orthogonal Polynomials" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OrthogonalPolynomials"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Orthogonal Polynomials\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"HermiteH" :> Documentation`HelpLookup["paclet:ref/HermiteH"], 
          "WhittakerM" :> Documentation`HelpLookup["paclet:ref/WhittakerM"], 
          "WhittakerW" :> Documentation`HelpLookup["paclet:ref/WhittakerW"], 
          "Hypergeometric1F1" :> 
          Documentation`HelpLookup["paclet:ref/Hypergeometric1F1"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"HermiteH\"\>", 
       2->"\<\"WhittakerM\"\>", 3->"\<\"WhittakerW\"\>", 
       4->"\<\"Hypergeometric1F1\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functions for Separable Coordinate Systems" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsForSeparableCoordinateSystems"], 
          "Functions Used in Quantum Mechanics" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsUsedInQuantumMechanics"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Functions for Separable Coordinate Systems\"\>", 
       2->"\<\"Functions Used in Quantum Mechanics\"\>", 
       3->"\<\"Mathematical Functions\"\>", 
       4->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LaguerreL", "ObjectName",
 CellID->11464],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LaguerreL",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LaguerreL"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Laguerre polynomial ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["L", "n"], "(", "x", ")"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LaguerreL",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LaguerreL"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["a", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the generalized Laguerre polynomial ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["L", "n", "a"], "(", "x", ")"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->9770]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell["Explicit polynomials are given when possible. ", "Notes",
 CellID->26319],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["L", "n"], "(", "x", ")"}], "=", 
    RowBox[{
     SubsuperscriptBox["L", "n", "0"], "(", "x", ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->17102],

Cell[TextData[{
 "The Laguerre polynomials are orthogonal with weight function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "a"], 
    SuperscriptBox["e", 
     RowBox[{"-", "x"}]]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->30057],

Cell[TextData[{
 "They satisfy the differential equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"x", "\[InvisibleSpace]", 
      SuperscriptBox["y", "\[Prime]\[Prime]"]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "1", "-", "x"}], ")"}], "\[InvisibleSpace]", 
      SuperscriptBox["y", "\[Prime]"]}], "+", 
     RowBox[{"n", "\[InvisibleSpace]", "y"}]}], "=", "0"}], TraditionalForm]],
   "InlineMath"],
 ". "
}], "Notes",
 CellID->25089],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["LaguerreL",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LaguerreL"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->77116636],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LaguerreL",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LaguerreL"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LaguerreL",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LaguerreL"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["LaguerreL",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LaguerreL"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " is an entire function of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " with no branch cut discontinuities. "
}], "Notes",
 CellID->18035]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->140151918],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->711529044],

Cell[TextData[{
 "Compute the 5",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " ",
 Cell[BoxData[
  ButtonBox["LaguerreL",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LaguerreL"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->114644423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaguerreL", "[", 
  RowBox[{"5", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->152028103],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "120"], " ", 
  RowBox[{"(", 
   RowBox[{"120", "-", 
    RowBox[{"600", " ", "x"}], "+", 
    RowBox[{"600", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"200", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"25", " ", 
     SuperscriptBox["x", "4"]}], "-", 
    SuperscriptBox["x", "5"]}], ")"}]}]], "Output",
 ImageSize->{277, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10286065]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12200919],

Cell[TextData[{
 "Plot the 10",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " Laguerre polynomial:"
}], "ExampleText",
 CellID->570747958],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"LaguerreL", "[", 
    RowBox[{"10", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->66189890],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->228052471]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->237090919],

Cell[TextData[{
 "Compute the associated Laguerre polynomial ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["L", "2", "a"], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->826402225],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaguerreL", "[", 
  RowBox[{"2", ",", "a", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1011782960],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", 
    RowBox[{"3", " ", "a"}], "+", 
    SuperscriptBox["a", "2"], "-", 
    RowBox[{"4", " ", "x"}], "-", 
    RowBox[{"2", " ", "a", " ", "x"}], "+", 
    SuperscriptBox["x", "2"]}], ")"}]}]], "Output",
 ImageSize->{189, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->53973846]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22637],

Cell["Evaluate for fractional orders:", "ExampleText",
 CellID->508524632],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaguerreL", "[", 
  RowBox[{
   RowBox[{"1", "/", "2"}], ",", "1.4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->73794714],

Cell[BoxData["0.1411848901483768`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->136244546]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->198854089],

Cell["Evaluate for complex orders and arguments:", "ExampleText",
 CellID->198656248],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaguerreL", "[", 
  RowBox[{
   RowBox[{"2", "+", " ", "I"}], ",", " ", 
   RowBox[{"3", "-", "I"}], ",", " ", 
   RowBox[{"1.4", "+", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->156546548],

Cell[BoxData[
 RowBox[{"10.935259600990435`", "\[InvisibleSpace]", "-", 
  RowBox[{"8.710722812264521`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->433749266]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8120641],

Cell["Evaluate to high precision:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->506947147],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"LaguerreL", "[", 
    RowBox[{
     RowBox[{"1", "/", "3"}], ",", "1", ",", "3"}], "]"}], ",", " ", "50"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35337661],

Cell[BoxData["0.\
2948249512114390126158682567644066998479894698094827080781179538387`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->516349775]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1957241618],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->299425436],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaguerreL", "[", 
  RowBox[{
   RowBox[{"1", "/", "3"}], ",", "1", ",", 
   "3.00000000000000000000000000000000"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->335750350],

Cell[BoxData["0.294824951211439012615868256764406764826771977545`31.\
662709991914156"], "Output",
 ImageSize->{242, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->147763742]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->118486367],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LaguerreL",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LaguerreL"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->278926135],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaguerreL", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->672268429],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "-", "x"}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"2", "-", 
      RowBox[{"4", " ", "x"}], "+", 
      SuperscriptBox["x", "2"]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"(", 
     RowBox[{"6", "-", 
      RowBox[{"18", " ", "x"}], "+", 
      RowBox[{"9", " ", 
       SuperscriptBox["x", "2"]}], "-", 
      SuperscriptBox["x", "3"]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{289, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->77775976]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->217169454],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->246869236],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LaguerreL", "[", 
   RowBox[{"n", ",", "\[Mu]", ",", "z"}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->668769163],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubsuperscriptBox["L", "n", "\[Mu]"], "(", "z", ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{30, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->595226776]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10795],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LaguerreL",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LaguerreL"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->153856329],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaguerreL", "[", 
  RowBox[{
   RowBox[{"1", "/", "3"}], ",", " ", "1", ",", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "+", 
    RowBox[{
     RowBox[{"O", "[", "x", "]"}], "^", "4"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->461441216],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["4", "3"], "-", 
   FractionBox[
    RowBox[{"2", " ", "x"}], "9"], "-", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "2"]}], "81"], "+", 
   FractionBox[
    RowBox[{"49", " ", 
     SuperscriptBox["x", "3"]}], "1458"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
    Rational[4, 3], 
    Rational[-2, 9], 
    Rational[-2, 81], 
    Rational[49, 1458]}, 0, 4, 1],
  Editable->False]], "Output",
 ImageSize->{181, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->721840373]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29307],

Cell["Solve the Laguerre differential equation:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->524121862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", " ", 
       RowBox[{
        RowBox[{"y", "''"}], "[", "x", "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", "1", "-", "x"}], ")"}], 
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
      RowBox[{"n", " ", 
       RowBox[{"y", "[", "x", "]"}]}]}], "==", "0"}], "}"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->56539914],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"HypergeometricU", "[", 
       RowBox[{
        RowBox[{"-", "n"}], ",", 
        RowBox[{"1", "+", "a"}], ",", "x"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"LaguerreL", "[", 
       RowBox[{"n", ",", "a", ",", "x"}], "]"}]}]}]}], "}"}], "}"}]], "Output",\

 ImageSize->{461, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->227255482]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->80640399],

Cell[TextData[{
 "Generalized Fourier series for functions defined on ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"[", 
     RowBox[{"0", ",", "\[Infinity]"}]}], ")"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->499645027],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Integrate", "[", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Exp", "[", 
       RowBox[{"-", "x"}], "]"}], 
      RowBox[{"LaguerreL", "[", 
       RowBox[{"n", ",", "x"}], "]"}], 
      RowBox[{"Sin", "[", "x", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1672423905],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "2"], ",", "0", ",", 
   RowBox[{"-", 
    FractionBox["1", "4"]}], ",", 
   RowBox[{"-", 
    FractionBox["1", "4"]}], ",", 
   RowBox[{"-", 
    FractionBox["1", "8"]}], ",", "0", ",", 
   FractionBox["1", "16"], ",", 
   FractionBox["1", "16"], ",", 
   FractionBox["1", "32"], ",", "0", ",", 
   RowBox[{"-", 
    FractionBox["1", "64"]}]}], "}"}]], "Output",
 ImageSize->{299, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->428490194]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"%", ".", " ", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"LaguerreL", "[", 
         RowBox[{"n", ",", "x"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"4", " ", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->280357935],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->306769591]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->636980434],

Cell["Radial wave-function of the hydrogen atom:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->35125552],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Psi]", "[", 
   RowBox[{"n_", ",", "l_", ",", "r_"}], "]"}], ":=", 
  RowBox[{
   SqrtBox[
    FractionBox[
     RowBox[{" ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "l", "-", "1"}], ")"}], "!"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"n", "+", "l"}], ")"}], "!"}]]], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox["r", "n"]}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox[
      RowBox[{"2", "r"}], "n"], ")"}], "l"], 
   FractionBox["2", 
    SuperscriptBox["n", "2"]], " ", 
   RowBox[{"LaguerreL", "[", 
    RowBox[{
     RowBox[{"n", "-", "l", "-", "1"}], ",", " ", 
     RowBox[{
      RowBox[{"2", "l"}], "+", "1"}], ",", 
     FractionBox[
      RowBox[{"2", "r"}], "n"]}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->504859851],

Cell["\<\
Compute the energy eigenvalue from the differential equation:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->327079488],

Cell[BoxData[
 RowBox[{
  RowBox[{"energy", "[", 
   RowBox[{"w_", ",", "r_", ",", " ", "n_", ",", " ", "l_"}], "]"}], ":=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    FractionBox["1", "w"], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"w", ",", "r", ",", "r"}], "]"}], "+", 
      RowBox[{
       FractionBox["2", 
        RowBox[{" ", "r"}]], 
       RowBox[{"D", "[", 
        RowBox[{"w", ",", "r"}], "]"}]}], "-", 
      RowBox[{
       FractionBox[
        RowBox[{"l", 
         RowBox[{"(", 
          RowBox[{"l", "+", "1"}], ")"}]}], 
        SuperscriptBox["r", "2"]], "w"}], "+", 
      RowBox[{
       FractionBox["2", "r"], "w"}]}], ")"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->724627],

Cell[TextData[{
 "The energy is independent of the orbital quantum number ",
 Cell[BoxData["l"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->758486141],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"energy", "[", 
      RowBox[{
       RowBox[{"\[Psi]", "[", 
        RowBox[{"n", ",", "l", ",", "r"}], "]"}], ",", "r", ",", "n", ",", 
       "l"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"l", ",", "0", ",", 
       RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->132969564],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "4"], ",", 
     FractionBox["1", "4"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "9"], ",", 
     FractionBox["1", "9"], ",", 
     FractionBox["1", "9"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "16"], ",", 
     FractionBox["1", "16"], ",", 
     FractionBox["1", "16"], ",", 
     FractionBox["1", "16"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{310, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->18940977]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9218],

Cell["Get the list of coefficients in a Laguerre polynomial:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->307622842],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefficientList", "[", 
  RowBox[{
   RowBox[{"LaguerreL", "[", 
    RowBox[{"4", ",", "a", ",", "x"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23428342],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", 
    FractionBox[
     RowBox[{"25", " ", "a"}], "12"], "+", 
    FractionBox[
     RowBox[{"35", " ", 
      SuperscriptBox["a", "2"]}], "24"], "+", 
    FractionBox[
     RowBox[{"5", " ", 
      SuperscriptBox["a", "3"]}], "12"], "+", 
    FractionBox[
     SuperscriptBox["a", "4"], "24"]}], ",", 
   RowBox[{
    RowBox[{"-", "4"}], "-", 
    FractionBox[
     RowBox[{"13", " ", "a"}], "3"], "-", 
    FractionBox[
     RowBox[{"3", " ", 
      SuperscriptBox["a", "2"]}], "2"], "-", 
    FractionBox[
     SuperscriptBox["a", "3"], "6"]}], ",", 
   RowBox[{"3", "+", 
    FractionBox[
     RowBox[{"7", " ", "a"}], "4"], "+", 
    FractionBox[
     SuperscriptBox["a", "2"], "4"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["2", "3"]}], "-", 
    FractionBox["a", "6"]}], ",", 
   FractionBox["1", "24"]}], "}"}]], "Output",
 ImageSize->{482, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->364299607]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29779869],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " to expand ",
 Cell[BoxData[
  ButtonBox["LaguerreL",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LaguerreL"]], "InlineFormula"],
 " functions into simpler functions:"
}], "ExampleText",
 CellID->164539929],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"LaguerreL", "[", 
   RowBox[{
    RowBox[{"1", "/", "2"}], ",", 
    RowBox[{
     RowBox[{"-", "1"}], "/", "2"}], ",", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->772213971],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", "x"], "-", 
     RowBox[{
      SqrtBox["\[Pi]"], " ", 
      SqrtBox["x"], " ", 
      RowBox[{"Erfi", "[", 
       SqrtBox["x"], "]"}]}]}], ")"}]}], "\[Pi]"]], "Output",
 ImageSize->{178, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->259446945]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1480],

Cell["\<\
Cancellations in the polynomial form may lead to inaccurate numerical \
results:\
\>", "ExampleText",
 CellID->108685218],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LaguerreL", "[", 
   RowBox[{"100", ",", "0", ",", "x"}], "]"}], "/.", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"N", "[", 
    RowBox[{"5", ",", "16"}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->380814599],

Cell[BoxData["0``-2.497003890758287"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->166921876]
}, Open  ]],

Cell["Evaluate the function directly:", "ExampleText",
 CellID->753914464],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaguerreL", "[", 
  RowBox[{"100", ",", "0", ",", 
   RowBox[{"N", "[", 
    RowBox[{"5", ",", "16"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->83976469],

Cell[BoxData["1.45552716253288126068343592661`15.532763400665978"], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->79832384]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19366],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["HermiteH",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HermiteH"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WhittakerM",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WhittakerM"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WhittakerW",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WhittakerW"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hypergeometric1F1",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hypergeometric1F1"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4246]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13340],

Cell[TextData[ButtonBox["Orthogonal Polynomials",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OrthogonalPolynomials"]], "Tutorials",
 CellID->3346]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->912],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/LauerrePolynomial.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/Polynomials/LaguerreL/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
LaguerreL"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->779934887],

Cell[TextData[ButtonBox["Functions for Separable Coordinate Systems",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/FunctionsForSeparableCoordinateSystems"]], "MoreAbout",
 CellID->12264257],

Cell[TextData[ButtonBox["Functions Used in Quantum Mechanics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInQuantumMechanics"]], "MoreAbout",
 CellID->401145326],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->8898544],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->60626233]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LaguerreL - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 52, 11.9356974}", "context" -> "System`", 
    "keywords" -> {"Laguerre functions"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LaguerreL[n, x] gives the Laguerre polynomial L_n (x). LaguerreL[n, a, \
x] gives the generalized Laguerre polynomial SubsuperscriptBox[L, n, a](x). ",
     "synonyms" -> {"Laguerre L"}, "title" -> "LaguerreL", "type" -> "Symbol",
     "uri" -> "ref/LaguerreL"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7438, 254, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->140151918]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 40999, 1426}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2675, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3298, 89, 47, 1, 70, "ObjectName",
 CellID->11464],
Cell[3348, 92, 1230, 41, 70, "Usage",
 CellID->9770]
}, Open  ]],
Cell[CellGroupData[{
Cell[4615, 138, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5093, 155, 120, 4, 70, "Notes",
 CellID->20640],
Cell[5216, 161, 79, 1, 70, "Notes",
 CellID->26319],
Cell[5298, 164, 261, 11, 70, "Notes",
 CellID->17102],
Cell[5562, 177, 272, 10, 70, "Notes",
 CellID->30057],
Cell[5837, 189, 489, 16, 70, "Notes",
 CellID->25089],
Cell[6329, 207, 249, 8, 70, "Notes",
 CellID->77116636],
Cell[6581, 217, 220, 7, 70, "Notes",
 CellID->31226],
Cell[6804, 226, 203, 7, 70, "Notes",
 CellID->28162],
Cell[7010, 235, 391, 14, 70, "Notes",
 CellID->18035]
}, Closed]],
Cell[CellGroupData[{
Cell[7438, 254, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->140151918],
Cell[CellGroupData[{
Cell[7823, 268, 148, 5, 70, "ExampleSection",
 CellID->711529044],
Cell[7974, 275, 286, 12, 70, "ExampleText",
 CellID->114644423],
Cell[CellGroupData[{
Cell[8285, 291, 128, 4, 28, "Input",
 CellID->152028103],
Cell[8416, 297, 506, 17, 51, "Output",
 CellID->10286065]
}, Open  ]],
Cell[8937, 317, 124, 3, 70, "ExampleDelimiter",
 CellID->12200919],
Cell[9064, 322, 177, 7, 70, "ExampleText",
 CellID->570747958],
Cell[CellGroupData[{
Cell[9266, 333, 245, 8, 28, "Input",
 CellID->66189890],
Cell[9514, 343, 2457, 44, 125, "Output",
 Evaluatable->False,
 CellID->228052471]
}, Open  ]],
Cell[11986, 390, 125, 3, 70, "ExampleDelimiter",
 CellID->237090919],
Cell[12114, 395, 237, 9, 70, "ExampleText",
 CellID->826402225],
Cell[CellGroupData[{
Cell[12376, 408, 139, 4, 70, "Input",
 CellID->1011782960],
Cell[12518, 414, 425, 14, 51, "Output",
 CellID->53973846]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12992, 434, 216, 7, 70, "ExampleSection",
 CellID->22637],
Cell[13211, 443, 74, 1, 70, "ExampleText",
 CellID->508524632],
Cell[CellGroupData[{
Cell[13310, 448, 153, 5, 70, "Input",
 CellID->73794714],
Cell[13466, 455, 176, 5, 36, "Output",
 CellID->136244546]
}, Open  ]],
Cell[13657, 463, 125, 3, 70, "ExampleDelimiter",
 CellID->198854089],
Cell[13785, 468, 85, 1, 70, "ExampleText",
 CellID->198656248],
Cell[CellGroupData[{
Cell[13895, 473, 227, 7, 70, "Input",
 CellID->156546548],
Cell[14125, 482, 272, 7, 36, "Output",
 CellID->433749266]
}, Open  ]],
Cell[14412, 492, 123, 3, 70, "ExampleDelimiter",
 CellID->8120641],
Cell[14538, 497, 207, 5, 70, "ExampleText",
 CellID->506947147],
Cell[CellGroupData[{
Cell[14770, 506, 226, 8, 70, "Input",
 CellID->35337661],
Cell[14999, 516, 235, 7, 36, "Output",
 CellID->516349775]
}, Open  ]],
Cell[15249, 526, 126, 3, 70, "ExampleDelimiter",
 CellID->1957241618],
Cell[15378, 531, 113, 3, 70, "ExampleText",
 CellID->299425436],
Cell[CellGroupData[{
Cell[15516, 538, 199, 6, 70, "Input",
 CellID->335750350],
Cell[15718, 546, 229, 6, 36, "Output",
 CellID->147763742]
}, Open  ]],
Cell[15962, 555, 125, 3, 70, "ExampleDelimiter",
 CellID->118486367],
Cell[16090, 560, 212, 7, 70, "ExampleText",
 CellID->278926135],
Cell[CellGroupData[{
Cell[16327, 571, 187, 6, 70, "Input",
 CellID->672268429],
Cell[16517, 579, 630, 22, 51, "Output",
 CellID->77775976]
}, Open  ]],
Cell[17162, 604, 125, 3, 70, "ExampleDelimiter",
 CellID->217169454],
Cell[17290, 609, 203, 7, 70, "ExampleText",
 CellID->246869236],
Cell[CellGroupData[{
Cell[17518, 620, 184, 6, 70, "Input",
 CellID->668769163],
Cell[17705, 628, 271, 9, 52, "Output",
 CellID->595226776]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18025, 643, 239, 7, 70, "ExampleSection",
 CellID->10795],
Cell[18267, 652, 350, 11, 70, "ExampleText",
 CellID->153856329],
Cell[CellGroupData[{
Cell[18642, 667, 279, 9, 70, "Input",
 CellID->461441216],
Cell[18924, 678, 758, 27, 54, "Output",
 CellID->721840373]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19731, 711, 223, 7, 70, "ExampleSection",
 CellID->29307],
Cell[19957, 720, 221, 5, 70, "ExampleText",
 CellID->524121862],
Cell[CellGroupData[{
Cell[20203, 729, 545, 18, 70, "Input",
 CellID->56539914],
Cell[20751, 749, 622, 21, 36, "Output",
 CellID->227255482]
}, Open  ]],
Cell[21388, 773, 124, 3, 70, "ExampleDelimiter",
 CellID->80640399],
Cell[21515, 778, 395, 14, 70, "ExampleText",
 CellID->499645027],
Cell[CellGroupData[{
Cell[21935, 796, 507, 16, 70, "Input",
 CellID->1672423905],
Cell[22445, 814, 554, 19, 51, "Output",
 CellID->428490194]
}, Open  ]],
Cell[CellGroupData[{
Cell[23036, 838, 528, 17, 70, "Input",
 CellID->280357935],
Cell[23567, 857, 4178, 73, 70, "Output",
 Evaluatable->False,
 CellID->306769591]
}, Open  ]],
Cell[27760, 933, 125, 3, 70, "ExampleDelimiter",
 CellID->636980434],
Cell[27888, 938, 221, 5, 70, "ExampleText",
 CellID->35125552],
Cell[28112, 945, 867, 31, 70, "Input",
 CellID->504859851],
Cell[28982, 978, 249, 7, 70, "ExampleText",
 CellID->327079488],
Cell[29234, 987, 744, 25, 70, "Input",
 CellID->724627],
Cell[29981, 1014, 295, 9, 70, "ExampleText",
 CellID->758486141],
Cell[CellGroupData[{
Cell[30301, 1027, 500, 16, 70, "Input",
 CellID->132969564],
Cell[30804, 1045, 644, 23, 51, "Output",
 CellID->18940977]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31497, 1074, 232, 7, 70, "ExampleSection",
 CellID->9218],
Cell[31732, 1083, 234, 5, 70, "ExampleText",
 CellID->307622842],
Cell[CellGroupData[{
Cell[31991, 1092, 205, 6, 70, "Input",
 CellID->23428342],
Cell[32199, 1100, 1035, 37, 54, "Output",
 CellID->364299607]
}, Open  ]],
Cell[33249, 1140, 124, 3, 70, "ExampleDelimiter",
 CellID->29779869],
Cell[33376, 1145, 369, 13, 70, "ExampleText",
 CellID->164539929],
Cell[CellGroupData[{
Cell[33770, 1162, 251, 8, 70, "Input",
 CellID->772213971],
Cell[34024, 1172, 420, 15, 60, "Output",
 CellID->259446945]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[34493, 1193, 225, 7, 70, "ExampleSection",
 CellID->1480],
Cell[34721, 1202, 131, 4, 70, "ExampleText",
 CellID->108685218],
Cell[CellGroupData[{
Cell[34877, 1210, 249, 8, 70, "Input",
 CellID->380814599],
Cell[35129, 1220, 178, 5, 36, "Output",
 CellID->166921876]
}, Open  ]],
Cell[35322, 1228, 74, 1, 70, "ExampleText",
 CellID->753914464],
Cell[CellGroupData[{
Cell[35421, 1233, 194, 6, 70, "Input",
 CellID->83976469],
Cell[35618, 1241, 207, 5, 36, "Output",
 CellID->79832384]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[35886, 1253, 311, 9, 70, "SeeAlsoSection",
 CellID->19366],
Cell[36200, 1264, 966, 35, 70, "SeeAlso",
 CellID->4246]
}, Open  ]],
Cell[CellGroupData[{
Cell[37203, 1304, 314, 9, 70, "TutorialsSection",
 CellID->13340],
Cell[37520, 1315, 153, 3, 70, "Tutorials",
 CellID->3346]
}, Open  ]],
Cell[CellGroupData[{
Cell[37710, 1323, 319, 9, 70, "RelatedLinksSection",
 CellID->912],
Cell[38032, 1334, 188, 4, 70, "RelatedLinks"],
Cell[38223, 1340, 193, 4, 70, "RelatedLinks"],
Cell[38419, 1346, 387, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[38843, 1364, 319, 9, 70, "MoreAboutSection",
 CellID->779934887],
Cell[39165, 1375, 194, 4, 70, "MoreAbout",
 CellID->12264257],
Cell[39362, 1381, 178, 3, 70, "MoreAbout",
 CellID->401145326],
Cell[39543, 1386, 153, 3, 70, "MoreAbout",
 CellID->8898544],
Cell[39699, 1391, 144, 3, 70, "MoreAbout",
 CellID->60626233]
}, Open  ]],
Cell[39858, 1397, 27, 0, 70, "History"],
Cell[39888, 1399, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

