(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13631,        450]
NotebookOptionsPosition[     10741,        354]
NotebookOutlinePosition[     11975,        390]
CellTagsIndexPosition[     11890,        385]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Smaller" :> Documentation`HelpLookup["paclet:ref/Smaller"], 
          "Large" :> Documentation`HelpLookup["paclet:ref/Large"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Smaller\"\>", 
       2->"\<\"Large\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Font Options" :> 
          Documentation`HelpLookup["paclet:guide/FontOptions"], 
          "Notebook Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NotebookFormattingAndStyling"], "Text Styling" :> 
          Documentation`HelpLookup["paclet:guide/TextStyling"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Font Options\"\>", 
       2->"\<\"Notebook Formatting & Styling\"\>", 
       3->"\<\"Text Styling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Larger", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Larger",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Larger"]], "InlineFormula"],
     " \[LineSeparator]is a style or option setting that specifies that \
objects should be larger."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7998]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", "Larger"}], "]"}]], "InlineFormula"],
 " displays with text in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " larger."
}], "Notes",
 CellID->26269],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Larger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Larger"]], "InlineFormula"],
 " typically represents the same size change as the ",
 StyleBox["Alt", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["+", "KeyEvent"],
 " keyboard command."
}], "Notes",
 CellID->155784377]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->156768995],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->366248975],

Cell["Make a letter incrementally larger:", "ExampleText",
 CellID->270832958],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Style", "[", 
     RowBox[{"#", ",", "Larger"}], "]"}], "&"}], ",", "\"\<X\>\"", ",", "5"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->146258601],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVj1Pw0AMveSaFGjpB21p6ACd+BPdYWIDiTWqkNoBAW2AGbH3Lx/34cDl
xU3SjUiJ83yO79m+8+UuzVZPz2m2Xqbz2036ulovt/Obl41WyUAIsdP3ZSL0
u9Jv9t4ppWVLP0MNv0hGVivNUxore4lvwOE/sToBPAB8BngE+BzwVeNZTa6G
JEckxySnJOf7vbV+tWQrPel/E+uHgbZQIr/QKiIrSbLFjJspQ5I4Hnv6feNt
Wh25LEcWgtayjPxI80BMpEeVo23OF2DODplLfzbICH5n7I5B32Ey4ePA8ZZO
oIWJaAC4z8aNKxdz2avhj99jHCZ+0wgM34CtVp3HPsRh99bfOs41FTUb1nDE
Wjqe6AUrjDy5HpDvznLeJzUcEPMdwcdczRH7HaPMCbsSVgbXMs8pZH33DtDa
ehUqPIY4koo8KKbCTTpgV3Edr1sz0yk3U8VJMK2xx5OFz/G1KvZdZIFrFXdA
wuYdY+XnXqhiT/d9Gy8zwGyGSl4fWEYzsGrGkPd1oVydsaM5H3kfvodR9G33
bWFtdpT/B/NIWZEkJywXmzPxyTHBzic+QIu1tfGId9DieWGrIDLQ4o7uHmC1
BS2uXHuCiTf9jLUyJum07h9QBD8aPU2+\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{142, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->429309221]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25312579],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Larger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Larger"]], "InlineFormula"],
 " to make text larger relative to the surrounding text style:"
}], "ExampleText",
 CellID->750789520],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Style", "[", 
     RowBox[{
      RowBox[{"Row", "[", 
       RowBox[{"{", 
        RowBox[{"\"\<aaa\>\"", ",", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<aaa\>\"", ",", "Larger"}], "]"}], ",", "\"\<aaa\>\""}],
         "}"}], "]"}], ",", 
      RowBox[{"FontSize", "\[Rule]", "sz"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"sz", ",", 
      RowBox[{"{", 
       RowBox[{"11", ",", "16", ",", "24"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->486284470],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFVktTwjAQTt8FdHR0HD0y3kXlJnrWk1dFbx3GGTj4GOS38HdjskloWVLC
9oHM0K/fbpr9drtN8pwtph+f2WI2yfpP8+xnOpv89h+/58IUeIyxpfjfXjBx
z8Ud/JecCyxeA3GNhMsXGAgMHTwRGGt7KDB18Ig4vweqJGOScviBykDPRrFL
tb7AWHNwqGGgtIovbkhbYM3UNrqOP9SZdHTU1MGTlvXY328bWRd5R2eZEu37
qQYehdU3zbuI446u629ar6qStCb6nRSxafXYj+MZVN8vHt1zcNwBHUu0Ov5D
oh6vUhayZmbVKNpTon0/amX0rqAHCI8qRQ90LrhLI6L9BPFTB4+J85fZYe0F
r9yfuwjPiKrSknmgz9mIONsVPDXgzXTXAGa75mpnM/XrOfgNPDXk6hxzjHAI
3s1zVNnV1/UwJwhzu4strGHbNYbNNlK3hTOP6Xm8U/kOu633qtipccvs9xuZ
QcRoNVIXISq34i9py25fyU/R4lR4x00PmjM5xsb1I78trnoLeCdz8UA/HSF0
7ZCY5zXZlktdjk+ULt62HpW1+dpjC7bd2ba4D6DqUrME4TvnpLV2bU1kbi5V
RhakzvO6Fn2Vf5jnr53/aym8jxduvoGQ5V1hENRvrC0UK57R4LiJSrWmeryq
iixViNC+OlOrYpv5DfznJd4vXtLt3h+MtfJ8\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->321238539]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24138],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Smaller",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Smaller"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Large",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Large"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18121]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->2327018],

Cell[TextData[ButtonBox["Font Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FontOptions"]], "MoreAbout",
 CellID->66726027],

Cell[TextData[ButtonBox["Notebook Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NotebookFormattingAndStyling"]], "MoreAbout",
 CellID->174576959],

Cell[TextData[ButtonBox["Text Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TextStyling"]], "MoreAbout",
 CellID->399532407]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Larger - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 52, 14.2795074}", "context" -> "System`", 
    "keywords" -> {"enlarge text", "enlarge formulas"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Larger is a style or option setting that specifies that objects should \
be larger.", "synonyms" -> {}, "title" -> "Larger", "type" -> "Symbol", "uri" -> 
    "ref/Larger"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5394, 169, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->156768995]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11747, 378}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1511, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2134, 63, 1571, 37, 70, "ObjectNameGrid"],
Cell[3708, 102, 455, 14, 70, "Usage",
 CellID->7998]
}, Open  ]],
Cell[CellGroupData[{
Cell[4200, 121, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4678, 138, 341, 13, 70, "Notes",
 CellID->26269],
Cell[5022, 153, 335, 11, 70, "Notes",
 CellID->155784377]
}, Closed]],
Cell[CellGroupData[{
Cell[5394, 169, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->156768995],
Cell[CellGroupData[{
Cell[5779, 183, 148, 5, 70, "ExampleSection",
 CellID->366248975],
Cell[5930, 190, 78, 1, 70, "ExampleText",
 CellID->270832958],
Cell[CellGroupData[{
Cell[6033, 195, 232, 8, 28, "Input",
 CellID->146258601],
Cell[6268, 205, 854, 18, 51, "Output",
 Evaluatable->False,
 CellID->429309221]
}, Open  ]],
Cell[7137, 226, 124, 3, 70, "ExampleDelimiter",
 CellID->25312579],
Cell[7264, 231, 242, 8, 70, "ExampleText",
 CellID->750789520],
Cell[CellGroupData[{
Cell[7531, 243, 597, 19, 47, "Input",
 CellID->486284470],
Cell[8131, 264, 919, 19, 70, "Output",
 Evaluatable->False,
 CellID->321238539]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9111, 290, 311, 9, 70, "SeeAlsoSection",
 CellID->24138],
Cell[9425, 301, 443, 17, 70, "SeeAlso",
 CellID->18121]
}, Open  ]],
Cell[CellGroupData[{
Cell[9905, 323, 317, 9, 70, "MoreAboutSection",
 CellID->2327018],
Cell[10225, 334, 134, 3, 70, "MoreAbout",
 CellID->66726027],
Cell[10362, 339, 169, 3, 70, "MoreAbout",
 CellID->174576959],
Cell[10534, 344, 135, 3, 70, "MoreAbout",
 CellID->399532407]
}, Open  ]],
Cell[10684, 350, 27, 0, 70, "History"],
Cell[10714, 352, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

