(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     44403,       1638]
NotebookOptionsPosition[     36359,       1356]
NotebookOutlinePosition[     37704,       1394]
CellTagsIndexPosition[     37618,       1389]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Rationalize" :> 
          Documentation`HelpLookup["paclet:ref/Rationalize"], 
          "ContinuedFraction" :> 
          Documentation`HelpLookup["paclet:ref/ContinuedFraction"], 
          "RootApproximant" :> 
          Documentation`HelpLookup["paclet:ref/RootApproximant"], 
          "LatticeData" :> 
          Documentation`HelpLookup["paclet:ref/LatticeData"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Rationalize\"\>", 
       2->"\<\"ContinuedFraction\"\>", 3->"\<\"RootApproximant\"\>", 
       4->"\<\"LatticeData\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cryptographic Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/CryptographicNumberTheory"], 
          "Discrete & Integer Data" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteAndIntegerData"], 
          "Matrix Decompositions" :> 
          Documentation`HelpLookup["paclet:guide/MatrixDecompositions"], 
          "Number Recognition" :> 
          Documentation`HelpLookup["paclet:guide/NumberRecognition"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Cryptographic Number Theory\"\>", 
       2->"\<\"Discrete & Integer Data\"\>", 
       3->"\<\"Matrix Decompositions\"\>", 4->"\<\"Number Recognition\"\>", 
       5->"\<\"Number Theory\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LatticeReduce", "ObjectName",
 CellID->215],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LatticeReduce",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LatticeReduce"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["v", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["v", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a reduced basis for the set of vectors ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29781]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The elements of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can be integers, Gaussian integers, or Gaussian rational numbers. "
}], "Notes",
 CellID->26378]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->4494424],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->830533441],

Cell["Find the reduced norm basis for a lattice:", "ExampleText",
 CellID->462501186],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LatticeReduce", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0", ",", "1345"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0", ",", "35"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1", ",", "154"}], "}"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->217453264],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "9", ",", 
     RowBox[{"-", "2"}], ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", 
     RowBox[{"-", "9"}], ",", 
     RowBox[{"-", "6"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "3"}], ",", 
     RowBox[{"-", "8"}], ",", "8"}], "}"}]}], "}"}]], "Output",
 ImageSize->{306, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->531374775]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8135],

Cell[TextData[{
 "Starting with trivial integer linear relationships, ",
 Cell[BoxData[
  ButtonBox["LatticeReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LatticeReduce"]], "InlineFormula"],
 " can produce more interesting ones:"
}], "ExampleText",
 CellID->789795981],

Cell[BoxData[
 RowBox[{
  RowBox[{
   UnderscriptBox[
    UnderscriptBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {
         StyleBox["1", "TR"], 
         StyleBox["0", "TR"], "\[CenterEllipsis]", 
         StyleBox["0", "TR"], 
         RowBox[{"-", 
          StyleBox["a0", "TI"]}]},
        {
         StyleBox["0", "TR"], 
         StyleBox["1", "TR"], "\[CenterEllipsis]", 
         StyleBox["0", "TR"], 
         RowBox[{"-", 
          StyleBox["a1", "TI"]}]},
        {
         StyleBox["0", "TR"], " ", "\[DescendingEllipsis]", " ", 
         "\[VerticalEllipsis]"},
        {
         StyleBox["0", "TR"], " ", " ", 
         StyleBox["1", "TR"], 
         RowBox[{"-", 
          StyleBox["an", "TI"]}]},
        {
         StyleBox["0", "TR"], 
         StyleBox["0", "TR"], " ", 
         StyleBox["0", "TR"], 
         StyleBox["0", "TR"]}
       }], "\[NoBreak]", ")"}], "\[UnderBrace]"], 
    StyleBox["a", "TI"]], ".", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       StyleBox["a0", "TI"]},
      {
       StyleBox["a1", "TI"]},
      {"\[VerticalEllipsis]"},
      {
       StyleBox["an", "TI"]},
      {
       StyleBox["1", "TR"]}
     }], "\[NoBreak]", ")"}]}], "\[Equal]", 
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      StyleBox["0", "TR"]},
     {
      StyleBox["0", "TR"]},
     {"\[VerticalEllipsis]"},
     {
      StyleBox["0", "TR"]},
     {
      StyleBox["0", "TR"]}
    }], "\[NoBreak]", ")"}]}]], "Output",
 ImageSize->{190, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->580286186],

Cell[TextData[{
 "Find integer linear relationships for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"a", "\[InvisibleSpace]", "1"}], "=", "2"}], TraditionalForm]], 
  "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"a", "\[InvisibleSpace]", "2"}], "=", "3"}], TraditionalForm]], 
  "InlineMath"],
 " of the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"x", "\[InvisibleSpace]", "0"}], "+", 
     RowBox[{
     "a", "\[InvisibleSpace]", "1", " ", "x", "\[InvisibleSpace]", "1"}], "+",
      
     RowBox[{
     "a", "\[InvisibleSpace]", "2", " ", "x", "\[InvisibleSpace]", "2"}]}], 
    "\[LongEqual]", "0"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->20453240],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "3"}]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->538934424],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", ".", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "1"}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->66196700],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->116050538]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LatticeReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LatticeReduce"]], "InlineFormula"],
 " preserves linear relationships and the third row provides ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "\[InvisibleSpace]", "0"}], "=", 
    RowBox[{"-", "1"}]}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "\[InvisibleSpace]", "1"}], "=", 
    RowBox[{"-", "1"}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "\[InvisibleSpace]", "2"}], "=", "1"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->210385617],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"b", "=", 
  RowBox[{"LatticeReduce", "[", "a", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->17369312],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", "1", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{306, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->752313524]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"b", ".", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "1"}], "}"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->50546257],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->631053435]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12233046],

Cell[TextData[{
 "Find polynomial relationships ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"x", "\[InvisibleSpace]", "4", " ", 
      SuperscriptBox["t", "4"]}], "+", 
     RowBox[{"x", "\[InvisibleSpace]", "3", " ", 
      SuperscriptBox["t", "3"]}], "+", 
     RowBox[{"x", "\[InvisibleSpace]", "2", " ", 
      SuperscriptBox["t", "2"]}], "+", 
     RowBox[{"x", "\[InvisibleSpace]", "1", " ", "t"}], "+", "x0"}], 
    "\[LongEqual]", "0"}], TraditionalForm]], "InlineMath"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", 
    RadicalBox["3", "3"]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->142834578],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a0", ",", "a1", ",", "a2", ",", "a3", ",", "a4"}], "}"}], "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Round", "[", 
     RowBox[{
      RowBox[{"10", "^", "7"}], 
      RowBox[{
       RowBox[{"Power", "[", 
        RowBox[{"3", ",", 
         RowBox[{"1", "/", "3"}]}], "]"}], "^", "i"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "4"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->34930800],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "10000000", ",", "14422496", ",", "20800838", ",", "30000000", ",", 
   "43267487"}], "}"}]], "Output",
 ImageSize->{364, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->140225211]
}, Open  ]],

Cell["The trivial initial relationships:", "ExampleText",
 CellID->280268035],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "a0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "a1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", 
       RowBox[{"-", "a2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "a3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "a4"}]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->160825336],

Cell["The reduced relationships:", "ExampleText",
 CellID->454315477],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"b", "=", 
  RowBox[{"LatticeReduce", "[", "a", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->154165201],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"34", ",", 
     RowBox[{"-", "12"}], ",", 
     RowBox[{"-", "10"}], ",", "98", ",", 
     RowBox[{"-", "39"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "50", ",", 
     RowBox[{"-", "95"}], ",", "4", ",", "148"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "26", ",", "213", ",", "9", ",", "76"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{444, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->344605986]
}, Open  ]],

Cell["The first relationship:", "ExampleText",
 CellID->216153764],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"b", "[", 
   RowBox[{"[", "1", "]"}], "]"}], ".", 
  SuperscriptBox["t", 
   RowBox[{"Range", "[", 
    RowBox[{"0", ",", "4"}], "]"}]]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->885435],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "3"}], "+", 
  SuperscriptBox["t", "3"]}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->423257652]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "/.", 
   RowBox[{"t", "->", 
    RowBox[{"Power", "[", 
     RowBox[{"3", ",", 
      RowBox[{"1", "/", "3"}]}], "]"}]}]}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->193413075],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->304420727]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->357075580],

Cell[TextData[{
 "Find linear relationships ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["x0", "TI"], "+", 
    RowBox[{
     StyleBox["x1", "TI"], " ", 
     RowBox[{
      ButtonBox["ArcTan",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ArcTan"], "[", 
      StyleBox["1", "TR"], "]"}]}], "+", 
    RowBox[{
     StyleBox["x2", "TI"], " ", 
     RowBox[{
      ButtonBox["ArcTan",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ArcTan"], "[", 
      RowBox[{
       StyleBox["1", "TR"], "/", 
       StyleBox["5", "TR"]}], "]"}]}], "+", 
    RowBox[{
     StyleBox["x3", "TI"], " ", 
     RowBox[{
      ButtonBox["ArcTan",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ArcTan"], "[", 
      RowBox[{
       StyleBox["1", "TR"], "/", 
       StyleBox["239", "TR"]}], "]"}]}]}], "=", 
   StyleBox["0", "TR"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->194328882],

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"ArcTan", "[", "1", "]"}], ",", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"1", "/", "5"}], "]"}], ",", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"1", "/", "239"}], "]"}], ",", "1"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->106085657],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a0", ",", "a1", ",", "a2", ",", "a3", ",", "a4"}], "}"}], "=", 
  RowBox[{"Round", "[", 
   RowBox[{
    RowBox[{"10", "^", "20"}], " ", "v"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->475642346],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "100000000000000000000", ",", "78539816339744830962", ",", 
   "19739555984988075837", ",", "418407600207472386", ",", 
   "100000000000000000000"}], "}"}]], "Output",
 ImageSize->{490, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->16960023]
}, Open  ]],

Cell["Initial trivial relationships:", "ExampleText",
 CellID->4872216],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", 
      RowBox[{"-", "a0"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", 
      RowBox[{"-", "a1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", 
      RowBox[{"-", "a2"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", 
      RowBox[{"-", "a3"}]}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->357854638],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", "100000000000000000000"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", 
     RowBox[{"-", "78539816339744830962"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", 
     RowBox[{"-", "19739555984988075837"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", 
     RowBox[{"-", "418407600207472386"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{531, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->74800317]
}, Open  ]],

Cell["Reduced relationships:", "ExampleText",
 CellID->130101884],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"b", "=", 
  RowBox[{"LatticeReduce", "[", "a", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->132854317],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", 
     RowBox[{"-", "4"}], ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "325302"}], ",", "315725", ",", "367312", ",", "1153518", 
     ",", "928458"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "381213"}], ",", "314234", ",", "633857", ",", "2221192", 
     ",", 
     RowBox[{"-", "2330529"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3210817"}], ",", "4041574", ",", "249764", ",", 
     RowBox[{"-", "3042512"}], ",", "306976"}], "}"}]}], "}"}]], "Output",
 ImageSize->{427, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->200482618]
}, Open  ]],

Cell["The first relationship:", "ExampleText",
 CellID->429834244],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"b", "[", 
   RowBox[{"[", "1", "]"}], "]"}], ".", "v"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->453662716],

Cell[BoxData[
 RowBox[{
  FractionBox["\[Pi]", "4"], "+", 
  RowBox[{"ArcTan", "[", 
   FractionBox["1", "239"], "]"}], "-", 
  RowBox[{"4", " ", 
   RowBox[{"ArcTan", "[", 
    FractionBox["1", "5"], "]"}]}]}]], "Output",
 ImageSize->{200, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->68404196]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->195462936],

Cell[BoxData[
 RowBox[{"-", "1.1102230246251565`*^-16"}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->242710276]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4200],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LatticeReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LatticeReduce"]], "InlineFormula"],
 " produces a new reduced basis for the same lattice:"
}], "ExampleText",
 CellID->15119638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "=", 
  RowBox[{"RandomInteger", "[", 
   RowBox[{"10", ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->117099070],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"7", ",", "2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "9", ",", "10"}], "}"}]}], "}"}]], "Output",
 ImageSize->{227, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->241044880]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"b", "=", 
  RowBox[{"LatticeReduce", "[", "a", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->46664457],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "4"}], ",", "7", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{228, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->62277257]
}, Open  ]],

Cell["The product of the norms will decrease:", "ExampleText",
 CellID->800332815],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Times", "@@", 
   RowBox[{"(", 
    RowBox[{"Norm", "/@", " ", "a"}], ")"}]}], "\[GreaterEqual]", 
  RowBox[{"Times", "@@", 
   RowBox[{"(", 
    RowBox[{"Norm", "/@", "b"}], ")"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->321239900],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->153576324]
}, Open  ]],

Cell["\<\
The determinant, or volume of the generator cell, is preserved:\
\>", "ExampleText",
 CellID->620498690],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Det", "[", "a", "]"}], "\[Equal]", 
  RowBox[{"Det", "[", "b", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->806208974],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->13166874]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->976569598],

Cell[TextData[{
 "The lattice is generated by ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["v", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["v", "TI"], 
     StyleBox["2", "TR"]]}], "}"}]], "InlineFormula"],
 ", but also by ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["w", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["w", "TI"], 
     StyleBox["2", "TR"]]}], "}"}]], "InlineFormula"],
 " produced by ",
 Cell[BoxData[
  ButtonBox["LatticeReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LatticeReduce"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->400474908],

Cell[BoxData[{
 RowBox[{
  RowBox[{"v1", "=", 
   RowBox[{"{", 
    RowBox[{"12", ",", "2"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v2", "=", 
   RowBox[{"{", 
    RowBox[{"13", ",", "4"}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->312992737],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"w1", ",", "w2"}], "}"}], "=", 
  RowBox[{"LatticeReduce", "[", 
   RowBox[{"{", 
    RowBox[{"v1", ",", "v2"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23187587],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", 
     RowBox[{"-", "4"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->586884894]
}, Open  ]],

Cell[TextData[{
 "The original cell is pink, and the one produced by ",
 Cell[BoxData[
  ButtonBox["LatticeReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LatticeReduce"]], "InlineFormula"],
 " is cyan:"
}], "ExampleText",
 CellID->62891255],

Cell[BoxData[
 RowBox[{
  RowBox[{"lattice", " ", "=", " ", 
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"n1", " ", "v1"}], "+", 
          RowBox[{"n2", " ", "v2"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"n1", ",", 
           RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"n2", ",", 
           RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}], ",", "1"}], "]"}], 
     ",", 
     RowBox[{
      RowBox[{
       RowBox[{"0", "<=", 
        RowBox[{"#", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "\[LessEqual]", "25"}], "&&", 
       RowBox[{
        RowBox[{"-", "4"}], "<=", 
        RowBox[{"#", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "\[LessEqual]", "8"}]}], "&"}]}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->210374321],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Opacity", "[", "0.8", "]"}], ",", "Pink", ",", 
       RowBox[{"Tooltip", "[", 
        RowBox[{
         RowBox[{"Polygon", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", "v1", ",", 
            RowBox[{"v1", "+", "v2"}], ",", "v2"}], "}"}], "]"}], ",", 
         "\"\<v-cell\>\""}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Opacity", "[", "0.8", "]"}], ",", "Cyan", ",", 
       RowBox[{"Tooltip", "[", 
        RowBox[{
         RowBox[{"Polygon", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", "w2", ",", 
            RowBox[{"w2", "+", "w1"}], ",", "w1"}], "}"}], "]"}], ",", 
         "\"\<w-cell\>\""}], "]"}]}], "}"}], ",", 
     RowBox[{"Point", "[", "lattice", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", "v1"}], "}"}], "]"}]}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{"Green", ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", "v2"}], "}"}], "]"}]}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{"Blue", ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", "w1"}], "}"}], "]"}]}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{"Yellow", ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", "w2"}], "}"}], "]"}]}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->225410277],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[1, 0.5, 0.5], Opacity[0.8], 
    TagBox[
     TooltipBox[PolygonBox[{{0, 0}, {12, 2}, {25, 6}, {13, 4}}],
      "\"v-cell\""],
     Annotation[#, "v-cell", "Tooltip"]& ]}, 
   {RGBColor[0, 1, 1], Opacity[0.8], 
    TagBox[
     TooltipBox[PolygonBox[{{0, 0}, {9, -4}, {10, -2}, {1, 2}}],
      "\"w-cell\""],
     Annotation[#, "w-cell", "Tooltip"]& ]}, 
   PointBox[{{4, 8}, {3, 6}, {2, 4}, {15, 8}, {1, 2}, {14, 6}, {0, 0}, {13, 
    4}, {12, 2}, {25, 6}, {11, 0}, {24, 4}, {10, -2}, {23, 2}, {9, -4}, {22, 
    0}, {21, -2}}], 
   {RGBColor[1, 0, 0], ArrowBox[{{0, 0}, {12, 2}}]}, 
   {RGBColor[0, 1, 0], ArrowBox[{{0, 0}, {13, 4}}]}, 
   {RGBColor[0, 0, 1], ArrowBox[{{0, 0}, {1, 2}}]}, 
   {RGBColor[1, 1, 0], ArrowBox[{{0, 0}, {9, -4}}]}},
  Axes->True]], "Output",
 ImageSize->{184, 89},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->434856420]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17705],

Cell["\<\
The set of vectors must have rational or Gaussian rational coefficients:\
\>", "ExampleText",
 CellID->1498354893],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LatticeReduce", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4.5"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->920573409],

Cell[BoxData[
 RowBox[{
  RowBox[{"LatticeReduce", "::", "\<\"latm\"\>"}], ":", 
  " ", "\<\"Matrix contains an entry that is not rational. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/LatticeReduce/latm\\\", \
ButtonNote -> \\\"LatticeReduce::latm\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->489418879],

Cell[BoxData[
 RowBox[{"LatticeReduce", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4.5`"}], "}"}]}], "}"}], "]"}]], "Output",
 ImageSize->{227, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9545779]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22797],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rationalize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rationalize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ContinuedFraction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContinuedFraction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RootApproximant",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RootApproximant"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LatticeData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LatticeData"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5364]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11085],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->15766]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->3316],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#27255"], None}]], "RelatedLinks",
 CellID->25052],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
LatticeReduce"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->142324827],

Cell[TextData[ButtonBox["Cryptographic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CryptographicNumberTheory"]], "MoreAbout",
 CellID->116977456],

Cell[TextData[ButtonBox["Discrete & Integer Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteAndIntegerData"]], "MoreAbout",
 CellID->133070027],

Cell[TextData[ButtonBox["Matrix Decompositions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixDecompositions"]], "MoreAbout",
 CellID->77478830],

Cell[TextData[ButtonBox["Number Recognition",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberRecognition"]], "MoreAbout",
 CellID->137884353],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->21861205]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LatticeReduce - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 52, 19.9359022}", "context" -> "System`", 
    "keywords" -> {
     "basis vectors", "combinatorial algorithms", 
      "Lenstra-Lenstra-Lovasz algorithm", "LLL algorithm"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LatticeReduce[{v_1, v_2, ...}] gives a reduced basis for the set of \
vectors v_i. ", "synonyms" -> {"lattice reduce"}, "title" -> "LatticeReduce", 
    "type" -> "Symbol", "uri" -> "ref/LatticeReduce"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5156, 158, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->4494424]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 37477, 1382}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2820, 65, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3443, 92, 49, 1, 70, "ObjectName",
 CellID->215],
Cell[3495, 95, 869, 28, 70, "Usage",
 CellID->29781]
}, Open  ]],
Cell[CellGroupData[{
Cell[4401, 128, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4879, 145, 240, 8, 70, "Notes",
 CellID->26378]
}, Closed]],
Cell[CellGroupData[{
Cell[5156, 158, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->4494424],
Cell[CellGroupData[{
Cell[5539, 172, 148, 5, 70, "ExampleSection",
 CellID->830533441],
Cell[5690, 179, 85, 1, 70, "ExampleText",
 CellID->462501186],
Cell[CellGroupData[{
Cell[5800, 184, 388, 12, 28, "Input",
 CellID->217453264],
Cell[6191, 198, 526, 18, 36, "Output",
 CellID->531374775]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6766, 222, 222, 7, 70, "ExampleSection",
 CellID->8135],
Cell[6991, 231, 279, 8, 70, "ExampleText",
 CellID->789795981],
Cell[7273, 241, 1596, 59, 114, "Output",
 CellID->580286186],
Cell[8872, 302, 748, 27, 70, "ExampleText",
 CellID->20453240],
Cell[9623, 331, 457, 15, 70, "Input",
 CellID->538934424],
Cell[CellGroupData[{
Cell[10105, 350, 158, 5, 70, "Input",
 CellID->66196700],
Cell[10266, 357, 213, 7, 36, "Output",
 CellID->116050538]
}, Open  ]],
Cell[10494, 367, 699, 25, 70, "ExampleText",
 CellID->210385617],
Cell[CellGroupData[{
Cell[11218, 396, 131, 4, 70, "Input",
 CellID->17369312],
Cell[11352, 402, 526, 18, 36, "Output",
 CellID->752313524]
}, Open  ]],
Cell[CellGroupData[{
Cell[11915, 425, 158, 5, 70, "Input",
 CellID->50546257],
Cell[12076, 432, 213, 7, 36, "Output",
 CellID->631053435]
}, Open  ]],
Cell[12304, 442, 124, 3, 70, "ExampleDelimiter",
 CellID->12233046],
Cell[12431, 447, 666, 21, 70, "ExampleText",
 CellID->142834578],
Cell[CellGroupData[{
Cell[13122, 472, 496, 16, 70, "Input",
 CellID->34930800],
Cell[13621, 490, 276, 9, 36, "Output",
 CellID->140225211]
}, Open  ]],
Cell[13912, 502, 77, 1, 70, "ExampleText",
 CellID->280268035],
Cell[13992, 505, 724, 21, 70, "Input",
 CellID->160825336],
Cell[14719, 528, 69, 1, 70, "ExampleText",
 CellID->454315477],
Cell[CellGroupData[{
Cell[14813, 533, 132, 4, 70, "Input",
 CellID->154165201],
Cell[14948, 539, 775, 25, 54, "Output",
 CellID->344605986]
}, Open  ]],
Cell[15738, 567, 66, 1, 70, "ExampleText",
 CellID->216153764],
Cell[CellGroupData[{
Cell[15829, 572, 223, 8, 70, "Input",
 CellID->885435],
Cell[16055, 582, 222, 8, 36, "Output",
 CellID->423257652]
}, Open  ]],
Cell[CellGroupData[{
Cell[16314, 595, 240, 8, 70, "Input",
 CellID->193413075],
Cell[16557, 605, 158, 5, 36, "Output",
 CellID->304420727]
}, Open  ]],
Cell[16730, 613, 125, 3, 70, "ExampleDelimiter",
 CellID->357075580],
Cell[16858, 618, 916, 34, 70, "ExampleText",
 CellID->194328882],
Cell[17777, 654, 353, 11, 70, "Input",
 CellID->106085657],
Cell[CellGroupData[{
Cell[18155, 669, 257, 8, 70, "Input",
 CellID->475642346],
Cell[18415, 679, 339, 10, 54, "Output",
 CellID->16960023]
}, Open  ]],
Cell[18769, 692, 71, 1, 70, "ExampleText",
 CellID->4872216],
Cell[CellGroupData[{
Cell[18865, 697, 575, 17, 70, "Input",
 CellID->357854638],
Cell[19443, 716, 698, 19, 54, "Output",
 CellID->74800317]
}, Open  ]],
Cell[20156, 738, 65, 1, 70, "ExampleText",
 CellID->130101884],
Cell[CellGroupData[{
Cell[20246, 743, 132, 4, 70, "Input",
 CellID->132854317],
Cell[20381, 749, 759, 23, 71, "Output",
 CellID->200482618]
}, Open  ]],
Cell[21155, 775, 66, 1, 70, "ExampleText",
 CellID->429834244],
Cell[CellGroupData[{
Cell[21246, 780, 144, 5, 70, "Input",
 CellID->453662716],
Cell[21393, 787, 352, 12, 51, "Output",
 CellID->68404196]
}, Open  ]],
Cell[CellGroupData[{
Cell[21782, 804, 97, 3, 70, "Input",
 CellID->195462936],
Cell[21882, 809, 199, 6, 36, "Output",
 CellID->242710276]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22130, 821, 232, 7, 70, "ExampleSection",
 CellID->4200],
Cell[22365, 830, 237, 7, 70, "ExampleText",
 CellID->15119638],
Cell[CellGroupData[{
Cell[22627, 841, 208, 7, 70, "Input",
 CellID->117099070],
Cell[22838, 850, 393, 13, 36, "Output",
 CellID->241044880]
}, Open  ]],
Cell[CellGroupData[{
Cell[23268, 868, 131, 4, 70, "Input",
 CellID->46664457],
Cell[23402, 874, 432, 15, 36, "Output",
 CellID->62277257]
}, Open  ]],
Cell[23849, 892, 82, 1, 70, "ExampleText",
 CellID->800332815],
Cell[CellGroupData[{
Cell[23956, 897, 273, 9, 70, "Input",
 CellID->321239900],
Cell[24232, 908, 161, 5, 36, "Output",
 CellID->153576324]
}, Open  ]],
Cell[24408, 916, 114, 3, 70, "ExampleText",
 CellID->620498690],
Cell[CellGroupData[{
Cell[24547, 923, 159, 5, 70, "Input",
 CellID->806208974],
Cell[24709, 930, 161, 5, 36, "Output",
 CellID->13166874]
}, Open  ]],
Cell[24885, 938, 125, 3, 70, "ExampleDelimiter",
 CellID->976569598],
Cell[25013, 943, 700, 28, 70, "ExampleText",
 CellID->400474908],
Cell[25716, 973, 282, 10, 70, "Input",
 CellID->312992737],
Cell[CellGroupData[{
Cell[26023, 987, 231, 8, 70, "Input",
 CellID->23187587],
Cell[26257, 997, 323, 12, 36, "Output",
 CellID->586884894]
}, Open  ]],
Cell[26595, 1012, 251, 8, 70, "ExampleText",
 CellID->62891255],
Cell[26849, 1022, 932, 30, 70, "Input",
 CellID->210374321],
Cell[CellGroupData[{
Cell[27806, 1056, 2046, 64, 70, "Input",
 CellID->225410277],
Cell[29855, 1122, 944, 24, 70, "Output",
 CellID->434856420]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30848, 1152, 226, 7, 70, "ExampleSection",
 CellID->17705],
Cell[31077, 1161, 124, 3, 70, "ExampleText",
 CellID->1498354893],
Cell[CellGroupData[{
Cell[31226, 1168, 260, 9, 70, "Input",
 CellID->920573409],
Cell[31489, 1179, 388, 7, 70, "Message",
 CellID->489418879],
Cell[31880, 1188, 348, 12, 36, "Output",
 CellID->9545779]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[32289, 1207, 311, 9, 70, "SeeAlsoSection",
 CellID->22797],
Cell[32603, 1218, 984, 35, 70, "SeeAlso",
 CellID->5364]
}, Open  ]],
Cell[CellGroupData[{
Cell[33624, 1258, 314, 9, 70, "TutorialsSection",
 CellID->11085],
Cell[33941, 1269, 198, 4, 70, "Tutorials",
 CellID->15766]
}, Open  ]],
Cell[CellGroupData[{
Cell[34176, 1278, 320, 9, 70, "RelatedLinksSection",
 CellID->3316],
Cell[34499, 1289, 267, 6, 70, "RelatedLinks",
 CellID->25052],
Cell[34769, 1297, 391, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35197, 1315, 319, 9, 70, "MoreAboutSection",
 CellID->142324827],
Cell[35519, 1326, 164, 3, 70, "MoreAbout",
 CellID->116977456],
Cell[35686, 1331, 157, 3, 70, "MoreAbout",
 CellID->133070027],
Cell[35846, 1336, 152, 3, 70, "MoreAbout",
 CellID->77478830],
Cell[36001, 1341, 147, 3, 70, "MoreAbout",
 CellID->137884353],
Cell[36151, 1346, 136, 3, 70, "MoreAbout",
 CellID->21861205]
}, Open  ]],
Cell[36302, 1352, 27, 0, 70, "History"],
Cell[36332, 1354, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

