(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    493357,      11933]
NotebookOptionsPosition[    471949,      11214]
NotebookOutlinePosition[    474264,      11270]
CellTagsIndexPosition[    474149,      11264]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Graph Drawing in Mathematica " :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphDrawingIntroduction"], 
          "Hierarchical Drawing of Directed Graphs" :> 
          Documentation`HelpLookup["paclet:tutorial/LayeredGraphDrawing"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Introduction to Graph Drawing in Mathematica \"\>", 
       2->"\<\"Hierarchical Drawing of Directed Graphs\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TreePlot" :> Documentation`HelpLookup["paclet:ref/TreePlot"], 
          "GraphPlot" :> Documentation`HelpLookup["paclet:ref/GraphPlot"], 
          "GraphPlot3D" :> Documentation`HelpLookup["paclet:ref/GraphPlot3D"],
           "GraphData" :> 
          Documentation`HelpLookup["paclet:ref/GraphData"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"TreePlot\"\>", 
       2->"\<\"GraphPlot\"\>", 3->"\<\"GraphPlot3D\"\>", 
       4->"\<\"GraphData\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DataVisualization"], 
          "Discrete Mathematics" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteMathematics"], 
          "New in 6.0: Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60DataVisualization"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Data Visualization\"\>", 
       2->"\<\"Discrete Mathematics\"\>", 
       3->"\<\"New in 6.0: Data Visualization\"\>", 
       4->"\<\"New in 6.0: Mathematics & Algorithms\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["LayeredGraphPlot", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LayeredGraphPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LayeredGraphPlot"], "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox[
           StyleBox["v", "TI"], 
           RowBox[{
            StyleBox["i", "TI"], "\[InvisibleSpace]", 
            StyleBox["1", "TR"]}]], "->", 
          SubscriptBox[
           StyleBox["v", "TI"], 
           RowBox[{
            StyleBox["j", "TI"], "\[InvisibleSpace]", 
            StyleBox["1", "TR"]}]]}], ",", 
         RowBox[{
          SubscriptBox[
           StyleBox["v", "TI"], 
           RowBox[{
            StyleBox["i", "TI"], "\[InvisibleSpace]", 
            StyleBox["2", "TR"]}]], "->", 
          SubscriptBox[
           StyleBox["v", "TI"], 
           RowBox[{
            StyleBox["j", "TI"], "\[InvisibleSpace]", 
            StyleBox["2", "TR"]}]]}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a layered plot of the graph in which vertex ",
     
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["ik", "TI"]]], "InlineFormula"],
     " is connected to vertex ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["jk", "TI"]]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LayeredGraphPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LayeredGraphPlot"], "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SubscriptBox[
             StyleBox["v", "TI"], 
             RowBox[{
              StyleBox["i", "TI"], "\[InvisibleSpace]", 
              StyleBox["1", "TR"]}]], "->", 
            SubscriptBox[
             StyleBox["v", "TI"], 
             RowBox[{
              StyleBox["j", "TI"], "\[InvisibleSpace]", 
              StyleBox["1", "TR"]}]]}], ",", 
           SubscriptBox[
            StyleBox["lbl", "TI"], 
            StyleBox["1", "TR"]]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]associates labels ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["lbl", "TI"], 
       StyleBox["k", "TI"]]], "InlineFormula"],
     " with edges in the graph."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LayeredGraphPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LayeredGraphPlot"], "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["pos", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]places the dominant vertices in the plot at position ",
     Cell[BoxData[
      StyleBox["pos", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LayeredGraphPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LayeredGraphPlot"], "[", 
       StyleBox["m", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a layered plot of the graph represented by \
the adjacency matrix ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->18997]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 " attempts to draw the vertices of a graph in a series of \
\[OpenCurlyDoubleQuote]layers\[CloseCurlyDoubleQuote]. "
}], "Notes",
 CellID->39936999],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 " by default puts \[OpenCurlyDoubleQuote]dominant\[CloseCurlyDoubleQuote] \
vertices at the top, and puts vertices lower in the \
\[OpenCurlyDoubleQuote]hierarchy\[CloseCurlyDoubleQuote] progressively \
further down."
}], "Notes",
 CellID->222274573],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["LayeredGraphPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LayeredGraphPlot"], "[", 
   RowBox[{
    StyleBox["g", "TI"], ",", 
    StyleBox["pos", "TI"]}], "]"}]], "InlineFormula"],
 " places the dominant vertices at position ",
 Cell[BoxData[
  StyleBox["pos", "TI"]], "InlineFormula"],
 ". Possible positions are: ",
 Cell[BoxData[
  ButtonBox["Top",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Top"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Bottom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Bottom"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Left",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Left"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Right",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Right"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->443019707],

Cell[TextData[{
 "The vertex names ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " and the labels ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["lbl", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " can be any expressions."
}], "Notes",
 CellID->174694386],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ", with the following additions and changes:"
}], "Notes",
 CellID->77467358],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DataRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DataRange"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the range of vertex coordinates to generate", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DirectedEdges",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DirectedEdges"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to show edges as directed arrows", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["EdgeLabeling",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EdgeLabeling"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to include labels given for edges", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["EdgeRenderingFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EdgeRenderingFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "function to give explicit graphics for edges", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Frame",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Frame"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to draw a frame around the plot", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FrameTicks",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrameTicks"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "what ticks to include on the frame", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MultiedgeStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MultiedgeStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to draw multiple edges between vertices", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PackingMethod",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PackingMethod"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the method to use for packing components", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotRangePadding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRangePadding"], "Automatic", Cell[
    "how much padding to include around the plot", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "overall graphics directives for vertices and edges", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SelfLoopStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SelfLoopStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to draw edges linking a vertex to itself", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["VertexCoordinateRules",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/VertexCoordinateRules"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "rules for explicit vertex coordinates", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["VertexLabeling",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/VertexLabeling"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether to show vertex names as labels", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["VertexRenderingFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/VertexRenderingFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "function to give explicit graphics for vertices", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True}}}},
 CellID->353462848],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexLabeling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexLabeling"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", vertices are displayed as points, with their names ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " given in tooltips. "
}], "Notes",
 CellID->16670666],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["v", "TI"], 
     StyleBox["k", "TI"]], ",", 
    StyleBox["vlab", "TI"]}], "]"}]], "InlineFormula"],
 " can be used to specify an alternative tooltip for a vertex. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"], "[", 
   RowBox[{
    RowBox[{
     SubscriptBox[
      StyleBox["v", "TI"], 
      StyleBox["i", "TI"]], "->", 
     SubscriptBox[
      StyleBox["v", "TI"], 
      StyleBox["j", "TI"]]}], ",", 
    StyleBox["lbl", "TI"]}], "]"}]], "InlineFormula"],
 " specifies a tooltip for an edge."
}], "Notes",
 CellID->762729751],

Cell[TextData[{
 "Explicit settings for ",
 Cell[BoxData[
  ButtonBox["VertexRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexRenderingFunction"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["EdgeRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeRenderingFunction"]], "InlineFormula"],
 " override settings for ",
 Cell[BoxData[
  ButtonBox["VertexLabeling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexLabeling"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["EdgeLabeling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeLabeling"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["DirectedEdges",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DirectedEdges"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->442256812],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexRenderingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexRenderingFunction"], "->", 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 ", each vertex is rendered with the graphics primitives given by ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["r", "TI"], 
     StyleBox["k", "TI"]], ",", 
    SubscriptBox[
     StyleBox["v", "TI"], 
     StyleBox["k", "TI"]]}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["r", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " is the position where the vertex is being placed, and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " is its name."
}], "Notes",
 CellID->183388779],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EdgeRenderingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EdgeRenderingFunction"], "->", 
   StyleBox["g", "TI"]}]], "InlineFormula"],
 ", each edge is rendered with the graphics primitives given by ",
 Cell[BoxData[
  RowBox[{
   StyleBox["g", "TI"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["i", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["j", "TI"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["i", "TI"]], ",", 
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["j", "TI"]]}], "}"}], ",", 
    SubscriptBox[
     StyleBox["lbl", "TI"], 
     StyleBox["ij", "TI"]]}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["r", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["r", "TI"], 
   StyleBox["j", "TI"]]], "InlineFormula"],
 " are the beginning and ending points of the edge, ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["j", "TI"]]], "InlineFormula"],
 " are the beginning and ending vertices, and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["lbl", "TI"], 
   StyleBox["ij", "TI"]]], "InlineFormula"],
 " is any label specified for the edge."
}], "Notes",
 CellID->144575570],

Cell[TextData[{
 "The graphics primitives obtained by applying by ",
 Cell[BoxData[
  ButtonBox["EdgeRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeRenderingFunction"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["VertexRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexRenderingFunction"]], "InlineFormula"],
 " are in effect directly spliced into the graphic generated by ",
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["Inset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inset"]], "InlineFormula"],
 " can be used to insert an arbitrary expression."
}], "Notes",
 CellID->100047542],

Cell[TextData[{
 "In the graphics generated by ",
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 ", edges are effectively drawn first, and vertices afterwards."
}], "Notes",
 CellID->106749993],

Cell["\<\
The graph does not need to be connected. Disconnected components are \
typically arranged so as to fill area roughly uniformly.\
\>", "Notes",
 CellID->70117131],

Cell["\<\
When a graph is specified by an adjacency matrix, the names of its vertices \
are taken to be successive integers starting at 1.\
\>", "Notes",
 CellID->68112695],

Cell[TextData[{
 "The adjacency matrix ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LayeredGraphPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LayeredGraphPlot"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 " can be a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " object."
}], "Notes",
 CellID->3967714],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MultiedgeStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MultiedgeStyle"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", multiple edges are not shown if the graph is specified by an adjacency \
matrix."
}], "Notes",
 CellID->424434705],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 " returns an object of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"], "[", 
   RowBox[{
    ButtonBox["Annotation",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Annotation"], "[", 
    RowBox[{
     StyleBox["data", "TI"], ",", 
     RowBox[{
      ButtonBox["VertexCoordinateRules",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/VertexCoordinateRules"], "->", 
      StyleBox["rules", "TI"]}]}], "]"}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->68183324]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->333886168],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(5)", "ExampleCount"]
}], "ExampleSection",
 CellID->222349679],

Cell["Draw a directed graph using a hierarchical layout:", "ExampleText",
 CellID->527862779],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "2"}], ",", 
    RowBox[{"1", "\[Rule]", "3"}], ",", 
    RowBox[{"2", "\[Rule]", "3"}], ",", 
    RowBox[{"1", "\[Rule]", "4"}], ",", 
    RowBox[{"2", "\[Rule]", "4"}], ",", 
    RowBox[{"1", "\[Rule]", "5"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->166014746],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 2.}, {1., 1.}, {0., 0.}, {2., 0.}, {-1., 
    1.}, {0., 1.}, {2., 1.}, {0., 1.9530864197530864`}, {0., 
    1.9012345679012346`}, {0., 1.8444444444444446`}, {0., 
    1.782716049382716}, {0., 1.7160493827160495`}, {0., 
    1.6444444444444444`}, {0., 1.567901234567901}, {0., 
    1.4864197530864196`}, {0., 1.4}, {0., 1.3111111111111111`}, {0., 
    1.222222222222222}, {0., 1.1333333333333333`}, {0., 
    1.0444444444444445`}, {0., 0.9555555555555555}, {0., 
    0.8666666666666667}, {0., 0.7777777777777778}, {0., 0.6888888888888889}, {
    0., 0.6}, {0., 0.5135802469135802}, {0., 0.43209876543209874`}, {0., 
    0.3555555555555555}, {0., 0.2839506172839506}, {0., 
    0.21728395061728392`}, {0., 0.15555555555555553`}, {0., 
    0.09876543209876541}, {0., 0.04691358024691357}, {0.09928677930370411, 
    1.950356610348148}, {0.21936933943703868`, 1.8903153302814806`}, {
    0.3602476804000037, 1.8198761597999982`}, {0.5219218021925992, 
    1.7390390989037003`}, {0.7043917048148252, 1.6478041475925873`}, {
    0.9076573882666816, 1.5461713058666593`}, {1.1317188525481685`, 
    1.4341405737259159`}, {1.3765760976592858`, 1.311711951170357}, {
    1.6422291236000337`, 1.1788854381999831`}, {1.7173168384000266`, 
    1.1364033091950485`}, {1.7835707044000204`, 1.0884615613802366`}, {
    1.840990721600015, 1.035060194755548}, {1.8895768900000105`, 
    0.9761992093209825}, {1.9293292096000068`, 0.9118786050765398}, {
    1.9602476804000037`, 0.8420983820222203}, {1.9823323024000017`, 
    0.7668585401580238}, {1.9955830756000004`, 0.6861590794839504}, {2., 
    0.6}, {2., 0.5135802469135802}, {2., 0.43209876543209874`}, {2., 
    0.3555555555555555}, {2., 0.2839506172839506}, {2., 
    0.21728395061728392`}, {2., 0.15555555555555553`}, {2., 
    0.09876543209876541}, {2., 0.04691358024691357}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028937842778793417`, 0.8}}], 
      ArrowBox[{1, 2}], 
      ArrowBox[{1, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
       23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 3}], 
      ArrowBox[{1, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48,
        49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 4}], ArrowBox[{1, 5}], 
      ArrowBox[{2, 3}], ArrowBox[{2, 4}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 2.}, {1., 1.}, {0., 0.}, {2., 0.}, {-1., 
     1.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{154, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->2037157713]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32707144],

Cell["Include vertex labels:", "ExampleText",
 CellID->367941274],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->738297439],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWF1sFFUUvuzMdv+721K0hQqLGm3VmMY0pjGNqTRUEmJSH0wagpUVTYpE
UEpCEx4IqVBoQIwpwTRGoCKYqKUPBmIgVm3CBkWL+NBSCCVZYtd2tV23ZQIV
xnPvnZ2ZPXf2p2QbTbTZnc7Ze77vO/fv3DPzQmhry+tvhrZuWB8KPr8l9FbL
hvWtwYbNW+AnaQEhpBW+L5YSuFfhjn1bVRX+8+uD9CpN39g3Nbx26vJa4qEX
KX65eTYxSJueYO2J623wu6n9yqt3/5piTSaWm9GOW1M9qnqBeOiF298ZLH9e
23jn9tdGO7Mn/meZK4sNLhJMZEEWNpm10xlXLxh2NnY7Qkn/ChXaZxnc7Tmx
UzZbDiNkM0VBdP9s7NY9Tq+SGk2+R2Zu7PO7dvK8SyIDB/PAMtD+0pXTp8nj
rH1WUTgR8WZgmY6k5Ds5PtKs/H7u08ZGIKpM8oCZuPYG8fGMOPLKXczj1wZO
Beee+vrwgQOPMgdlcrK7uprGRD3szJ+zTo6OvhcM0lsHvcgA3Ftc3LNyZWJs
7GHm8WN39ztO57ft7cTJ7MHDh/vWraO3bkse7nXj/Pmuigqq+FAy+o8bGj5Z
vZq4cmJxJePmQ0CWm8aA2u6cWNwItQzZnpxYPAj1ALK9ObF4EWoJsn05sfgQ
qgzZhTmxFCLU/cj2Z2Z5t7yc3voRahGyAxlYYsPDu71sSAIItRDZRRlYfjlx
YqfNRm+LLFGGXQy2rX/HDo8JPdTb21lSAmuMtYr9xzF92dLyw6FDRgyytv+P
KLEv4EM89CIpsT6V/ZESNOp6z3qbGqPf7yRe6i8rsc+U8VNciCOOrVoF94YO
298SZJD41deUWBfV6QLd3/bHr26kTYuQDmeZne6FVGP4z4ztjnyzxpinPYEA
dN1CBVBGNmP22xlUZvogdRn+YE/83Gq0R8LhD2tq9F2UP5XpyK5kO51X77yw
6zMG/pAQyXyqwFr+vKlJzxSCSuo5mrtaah1jqOprHnYz7ZvPUtW6NshdXUL1
Do6C71NYiAcrK09t2sQzU96jsK4tcBRHV6zY4/fr+THvUVjjjSgCph0D5yfP
QkIUqdVX/tR5zhs6efJIXR3NiYG06mYW+z2sRiIbeHFFsHVI65CzbW2QFeGm
yDISWRuHuUaQOn6GLj+fR/v7P6iqGujo4Lsy73ud5Vp5bHAQugYDPTE0VJJZ
Z/yn0L3oOE060CGY1vuy6kAanbNOgaBTmv7MkvmZBTrwSXs68oOLno781Epc
385EBKXFJiUI62a0k0IYTuanMMic2bZtIVIqTq4wKEfVO+eUaCfXUmLv3/rj
DG20CVqs4NFGB2Af1dbSPVKEmLkdvXhxf1kZ1M3cTuFZauKBCPaVlh6trxd4
AsmsCPUJQLmdwsPcCJtTCX7nQ6rhDB5/sqeAu3T8OBAWCkzs+YPQWaPnqB8x
4EpRxLOnBFaHUnwhwuN61SfgH2H4xRreh/C4avYK+AqGX6Ka6oAMtbtHwD/G
8OWqqT7M8AThFvDsWZE9E1C8G+FdCO8S8E8y/FIN70J4J8KL+7qK4ZdpeCfC
OxDeIeCfYvighncgfAHCi/u9muGXa/gChLcjvF3AP83wyafg7alv/Uaaw3vZ
s7S4+2tMuPRP8nwnw5mq455Jj3Po7xG4EJzDACC16RF2sMcvHdPJybOZo/pq
83PUq87SS9IqPDt6p2Htne2d0H8Lle79m7U3fmv0z3rN/LoLvQt/+XY8bHjx
9+Zkwd9K0TpN\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{115, 81},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->143878606]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->628343972],

Cell["Show edge labels:", "ExampleText",
 CellID->270550211],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "2"}], ",", 
    RowBox[{"1", "\[Rule]", "3"}], ",", 
    RowBox[{"2", "\[Rule]", "3"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "4"}], ",", "\"\<1\[Rule]4\>\""}], "}"}], ",", 
    RowBox[{"2", "\[Rule]", "4"}], ",", 
    RowBox[{"1", "\[Rule]", "5"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1965963005],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 2.}, {1., 1.}, {0., 0.}, {2., 0.}, {-1., 
    1.}, {0., 1.}, {2., 1.}, {0., 1.9530864197530864`}, {0., 
    1.9012345679012346`}, {0., 1.8444444444444446`}, {0., 
    1.782716049382716}, {0., 1.7160493827160495`}, {0., 
    1.6444444444444444`}, {0., 1.567901234567901}, {0., 
    1.4864197530864196`}, {0., 1.4}, {0., 1.3111111111111111`}, {0., 
    1.222222222222222}, {0., 1.1333333333333333`}, {0., 
    1.0444444444444445`}, {0., 0.9555555555555555}, {0., 
    0.8666666666666667}, {0., 0.7777777777777778}, {0., 0.6888888888888889}, {
    0., 0.6}, {0., 0.5135802469135802}, {0., 0.43209876543209874`}, {0., 
    0.3555555555555555}, {0., 0.2839506172839506}, {0., 
    0.21728395061728392`}, {0., 0.15555555555555553`}, {0., 
    0.09876543209876541}, {0., 0.04691358024691357}, {0.09928677930370411, 
    1.950356610348148}, {0.21936933943703868`, 1.8903153302814806`}, {
    0.3602476804000037, 1.8198761597999982`}, {0.5219218021925992, 
    1.7390390989037003`}, {0.7043917048148252, 1.6478041475925873`}, {
    0.9076573882666816, 1.5461713058666593`}, {1.1317188525481685`, 
    1.4341405737259159`}, {1.3765760976592858`, 1.311711951170357}, {
    1.6422291236000337`, 1.1788854381999831`}, {1.7173168384000266`, 
    1.1364033091950485`}, {1.7835707044000204`, 1.0884615613802366`}, {
    1.840990721600015, 1.035060194755548}, {1.8895768900000105`, 
    0.9761992093209825}, {1.9293292096000068`, 0.9118786050765398}, {
    1.9602476804000037`, 0.8420983820222203}, {1.9823323024000017`, 
    0.7668585401580238}, {1.9955830756000004`, 0.6861590794839504}, {2., 
    0.6}, {2., 0.5135802469135802}, {2., 0.43209876543209874`}, {2., 
    0.3555555555555555}, {2., 0.2839506172839506}, {2., 
    0.21728395061728392`}, {2., 0.15555555555555553`}, {2., 
    0.09876543209876541}, {2., 0.04691358024691357}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028937842778793417`, 0.8}}], 
      ArrowBox[{1, 2}], 
      ArrowBox[{1, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
       23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 3}], 
      {Arrowheads[{{0.5, 0.5, 
          GraphicsBox[{
            GrayLevel[0], 
            InsetBox[
             BoxData[
              FormBox[
               StyleBox["\"1\[Rule]4\"", StripOnInput -> False], 
               TraditionalForm]], {0, 0}, 
             ImageScaled[{0.5, 0.5}], Automatic, None, Background -> 
             GrayLevel[1]]}]}, {0.028937842778793417`, 0.8}}], 
       ArrowBox[{1, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 
        48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 4}]}, 
      ArrowBox[{1, 5}], ArrowBox[{2, 3}], ArrowBox[{2, 4}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 2.}, {1., 1.}, {0., 0.}, {2., 0.}, {-1., 
     1.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2114808080]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->997625586],

Cell["Draw a graph specified by its adjacency matrix:", "ExampleText",
 CellID->1321317486],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "5"}], "}"}]}], "}"}], "\[Rule]", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->911830074],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", "a", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->593166176],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 2.}, {1., 1.}, {0., 0.}, {2., 0.}, {-1., 
    1.}, {0., 1.}, {2., 1.}, {0., 1.9530864197530864`}, {0., 
    1.9012345679012346`}, {0., 1.8444444444444446`}, {0., 
    1.782716049382716}, {0., 1.7160493827160495`}, {0., 
    1.6444444444444444`}, {0., 1.567901234567901}, {0., 
    1.4864197530864196`}, {0., 1.4}, {0., 1.3111111111111111`}, {0., 
    1.222222222222222}, {0., 1.1333333333333333`}, {0., 
    1.0444444444444445`}, {0., 0.9555555555555555}, {0., 
    0.8666666666666667}, {0., 0.7777777777777778}, {0., 0.6888888888888889}, {
    0., 0.6}, {0., 0.5135802469135802}, {0., 0.43209876543209874`}, {0., 
    0.3555555555555555}, {0., 0.2839506172839506}, {0., 
    0.21728395061728392`}, {0., 0.15555555555555553`}, {0., 
    0.09876543209876541}, {0., 0.04691358024691357}, {0.09928677930370411, 
    1.950356610348148}, {0.21936933943703868`, 1.8903153302814806`}, {
    0.3602476804000037, 1.8198761597999982`}, {0.5219218021925992, 
    1.7390390989037003`}, {0.7043917048148252, 1.6478041475925873`}, {
    0.9076573882666816, 1.5461713058666593`}, {1.1317188525481685`, 
    1.4341405737259159`}, {1.3765760976592858`, 1.311711951170357}, {
    1.6422291236000337`, 1.1788854381999831`}, {1.7173168384000266`, 
    1.1364033091950485`}, {1.7835707044000204`, 1.0884615613802366`}, {
    1.840990721600015, 1.035060194755548}, {1.8895768900000105`, 
    0.9761992093209825}, {1.9293292096000068`, 0.9118786050765398}, {
    1.9602476804000037`, 0.8420983820222203}, {1.9823323024000017`, 
    0.7668585401580238}, {1.9955830756000004`, 0.6861590794839504}, {2., 
    0.6}, {2., 0.5135802469135802}, {2., 0.43209876543209874`}, {2., 
    0.3555555555555555}, {2., 0.2839506172839506}, {2., 
    0.21728395061728392`}, {2., 0.15555555555555553`}, {2., 
    0.09876543209876541}, {2., 0.04691358024691357}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028937842778793417`, 0.8}}], 
      ArrowBox[{1, 2}], 
      ArrowBox[{1, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
       23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 3}], 
      ArrowBox[{1, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48,
        49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 4}], ArrowBox[{1, 5}], 
      ArrowBox[{2, 3}], ArrowBox[{2, 4}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 2.}, {1., 1.}, {0., 0.}, {2., 0.}, {-1., 
     1.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->951272319]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->184183475],

Cell["Drawing a graph with different orientation from the default:", \
"ExampleText",
 CellID->388077390],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "5"}]}], "}"}], ",", "Left"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->404507675],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{-2., -2.1437387455469636`*^-15}, \
{-1.000000000000001, 0.9999999999999989}, {0., 
    0.}, {-2.1437387455469636`*^-15, 
    2.}, {-0.9999999999999989, -1.000000000000001}, {-1., \
-1.0718693727734818`*^-15}, {-1.0000000000000022`, 
    1.999999999999999}, {-1.9530864197530864`, -2.093453515713146*^-15}, \
{-1.9012345679012346`, -2.037875103791558*^-15}, {-1.8444444444444446`, \
-1.9770035097822*^-15}, {-1.782716049382716, -1.9108387336850714`*^-15}, \
{-1.7160493827160495`, -1.8393807755001727`*^-15}, {-1.6444444444444444`, \
-1.7626296352275034`*^-15}, {-1.567901234567901, -1.680585312867064*^-15}, \
{-1.4864197530864196`, -1.5932478084188545`*^-15}, {-1.4, \
-1.5006171218828745`*^-15}, {-1.3111111111111111`, \
-1.4053398443030095`*^-15}, {-1.222222222222222, -1.3100625667231445`*^-15}, \
{-1.1333333333333333`, -1.2147852891432793`*^-15}, {-1.0444444444444445`, \
-1.1195080115634143`*^-15}, {-0.9555555555555555, -1.0242307339835493`*^-15}, \
{-0.8666666666666667, -9.289534564036843*^-16}, {-0.7777777777777778, \
-8.336761788238192*^-16}, {-0.6888888888888889, -7.383989012439541*^-16}, \
{-0.6, -6.431216236640891*^-16}, {-0.5135802469135802, \
-5.504909371281092*^-16}, {-0.43209876543209874`, -4.631534326798995*^-16}, \
{-0.3555555555555555, -3.811091103194602*^-16}, {-0.2839506172839506, \
-3.043579700467911*^-16}, {-0.21728395061728392`, -2.3290001186189233`*^-16}, \
{-0.15555555555555553`, -1.667352357647638*^-16}, {-0.09876543209876541, \
-1.058636417554056*^-16}, {-0.04691358024691357, -5.028522983381766*^-17}, \
{-1.950356610348148, 0.09928677930370201}, {-1.8903153302814808`, 
    0.21936933943703663`}, {-1.8198761597999986`, 
    0.36024768040000177`}, {-1.739039098903701, 
    0.5219218021925973}, {-1.6478041475925882`, 
    0.7043917048148234}, {-1.5461713058666602`, 
    0.90765738826668}, {-1.434140573725917, 
    1.131718852548167}, {-1.3117119511703585`, 
    1.3765760976592845`}, {-1.178885438199985, 
    1.6422291236000324`}, {-1.1364033091950503`, 
    1.7173168384000252`}, {-1.0884615613802386`, 
    1.783570704400019}, {-1.03506019475555, 
    1.8409907216000139`}, {-0.9761992093209846, 
    1.8895768900000094`}, {-0.9118786050765421, 
    1.9293292096000056`}, {-0.8420983820222225, 
    1.9602476804000029`}, {-0.766858540158026, 
    1.9823323024000008`}, {-0.6861590794839526, 
    1.9955830755999997`}, {-0.6000000000000022, 
    1.9999999999999993`}, {-0.5135802469135824, 
    1.9999999999999993`}, {-0.4320987654321009, 
    1.9999999999999996`}, {-0.35555555555555773`, 
    1.9999999999999996`}, {-0.28395061728395277`, 
    1.9999999999999998`}, {-0.2172839506172861, 
    1.9999999999999998`}, {-0.1555555555555577, 
    1.9999999999999998`}, {-0.09876543209876756, 2.}, {-0.04691358024691572, 
    2.}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028937842778793414`, 0.8}}], 
      ArrowBox[{1, 2}], 
      ArrowBox[{1, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
       23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 3}], 
      ArrowBox[{1, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48,
        49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 4}], ArrowBox[{1, 5}], 
      ArrowBox[{2, 3}], ArrowBox[{2, 4}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{-2., -2.1437387455469636`*^-15}, \
{-1.000000000000001, 0.9999999999999989}, {0., 
     0.}, {-2.1437387455469636`*^-15, 
     2.}, {-0.9999999999999989, -1.000000000000001}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{148, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1835022778]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1470226601],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Graph Specification",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->369255627],

Cell["Specify a graph using a rule list: ", "ExampleText",
 CellID->1096410170],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"0", "\[Rule]", "3"}], ",", 
    RowBox[{"0", "\[Rule]", "5"}], ",", 
    RowBox[{"0", "\[Rule]", "8"}], ",", 
    RowBox[{"0", "\[Rule]", "10"}], ",", 
    RowBox[{"3", "\[Rule]", "8"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->430275],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 2.}, {-1., 1.}, {0., 1.}, {2., 0.}, {1., 
    1.}, {2., 1.}, {0.09928677930370411, 1.950356610348148}, {
    0.21936933943703868`, 1.8903153302814806`}, {0.3602476804000037, 
    1.8198761597999982`}, {0.5219218021925992, 1.7390390989037003`}, {
    0.7043917048148252, 1.6478041475925873`}, {0.9076573882666816, 
    1.5461713058666593`}, {1.1317188525481685`, 1.4341405737259159`}, {
    1.3765760976592858`, 1.311711951170357}, {1.6422291236000337`, 
    1.1788854381999831`}, {1.7173168384000266`, 1.1364033091950485`}, {
    1.7835707044000204`, 1.0884615613802366`}, {1.840990721600015, 
    1.035060194755548}, {1.8895768900000105`, 0.9761992093209825}, {
    1.9293292096000068`, 0.9118786050765398}, {1.9602476804000037`, 
    0.8420983820222203}, {1.9823323024000017`, 0.7668585401580238}, {
    1.9955830756000004`, 0.6861590794839504}, {2., 0.6}, {2., 
    0.5135802469135802}, {2., 0.43209876543209874`}, {2., 
    0.3555555555555555}, {2., 0.2839506172839506}, {2., 
    0.21728395061728392`}, {2., 0.15555555555555553`}, {2., 
    0.09876543209876541}, {2., 0.04691358024691357}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028937842778793417`, 0.8}}], 
      ArrowBox[{1, 2}], ArrowBox[{1, 3}], 
      ArrowBox[{1, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
       22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 4}], ArrowBox[{1, 5}], 
      ArrowBox[{2, 4}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "10"],
       Annotation[#, 10, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 2.}, {-1., 1.}, {0., 1.}, {2., 0.}, {1., 
     1.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->301061336]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->56963074],

Cell["Specify a graph using a dense adjacency matrix: ", "ExampleText",
 CellID->155380432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->273676337],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 2.}, {-1., 1.}, {0., 1.}, {2., 0.}, {1., 
    1.}, {2., 1.}, {0.09928677930370411, 1.950356610348148}, {
    0.21936933943703868`, 1.8903153302814806`}, {0.3602476804000037, 
    1.8198761597999982`}, {0.5219218021925992, 1.7390390989037003`}, {
    0.7043917048148252, 1.6478041475925873`}, {0.9076573882666816, 
    1.5461713058666593`}, {1.1317188525481685`, 1.4341405737259159`}, {
    1.3765760976592858`, 1.311711951170357}, {1.6422291236000337`, 
    1.1788854381999831`}, {1.7173168384000266`, 1.1364033091950485`}, {
    1.7835707044000204`, 1.0884615613802366`}, {1.840990721600015, 
    1.035060194755548}, {1.8895768900000105`, 0.9761992093209825}, {
    1.9293292096000068`, 0.9118786050765398}, {1.9602476804000037`, 
    0.8420983820222203}, {1.9823323024000017`, 0.7668585401580238}, {
    1.9955830756000004`, 0.6861590794839504}, {2., 0.6}, {2., 
    0.5135802469135802}, {2., 0.43209876543209874`}, {2., 
    0.3555555555555555}, {2., 0.2839506172839506}, {2., 
    0.21728395061728392`}, {2., 0.15555555555555553`}, {2., 
    0.09876543209876541}, {2., 0.04691358024691357}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028937842778793417`, 0.8}}], 
      ArrowBox[{1, 2}], ArrowBox[{1, 3}], 
      ArrowBox[{1, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
       22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 4}], ArrowBox[{1, 5}], 
      ArrowBox[{2, 4}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 2.}, {-1., 1.}, {0., 1.}, {2., 0.}, {1., 
     1.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->78781227]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1640804889],

Cell["Specify a graph using a sparse adjacency matrix: ", "ExampleText",
 CellID->1544973088],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "4"}], "}"}]}], "}"}], "\[Rule]", "1"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1430216091],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 2.}, {-1., 1.}, {0., 1.}, {2., 0.}, {1., 
    1.}, {2., 1.}, {0.09928677930370411, 1.950356610348148}, {
    0.21936933943703868`, 1.8903153302814806`}, {0.3602476804000037, 
    1.8198761597999982`}, {0.5219218021925992, 1.7390390989037003`}, {
    0.7043917048148252, 1.6478041475925873`}, {0.9076573882666816, 
    1.5461713058666593`}, {1.1317188525481685`, 1.4341405737259159`}, {
    1.3765760976592858`, 1.311711951170357}, {1.6422291236000337`, 
    1.1788854381999831`}, {1.7173168384000266`, 1.1364033091950485`}, {
    1.7835707044000204`, 1.0884615613802366`}, {1.840990721600015, 
    1.035060194755548}, {1.8895768900000105`, 0.9761992093209825}, {
    1.9293292096000068`, 0.9118786050765398}, {1.9602476804000037`, 
    0.8420983820222203}, {1.9823323024000017`, 0.7668585401580238}, {
    1.9955830756000004`, 0.6861590794839504}, {2., 0.6}, {2., 
    0.5135802469135802}, {2., 0.43209876543209874`}, {2., 
    0.3555555555555555}, {2., 0.2839506172839506}, {2., 
    0.21728395061728392`}, {2., 0.15555555555555553`}, {2., 
    0.09876543209876541}, {2., 0.04691358024691357}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028937842778793417`, 0.8}}], 
      ArrowBox[{1, 2}], ArrowBox[{1, 3}], 
      ArrowBox[{1, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
       22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 4}], ArrowBox[{1, 5}], 
      ArrowBox[{2, 4}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 2.}, {-1., 1.}, {0., 1.}, {2., 0.}, {1., 
     1.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->833331136]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Graph Styling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->4212966],

Cell["Give labels for some edges:", "ExampleText",
 CellID->124062807],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "2"}], ",", 
    RowBox[{"1", "\[Rule]", "7"}], ",", 
    RowBox[{"1", "\[Rule]", "11"}], ",", 
    RowBox[{"2", "\[Rule]", "5"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "5"}], ",", "\"\<1\[Rule]5\>\""}], "}"}]}], 
   "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1524298092],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 2.}, {-1., 1.}, {0., 1.}, {1., 1.}, {2., 
    0.}, {2., 1.}, {0.09928677930370411, 1.950356610348148}, {
    0.21936933943703868`, 1.8903153302814806`}, {0.3602476804000037, 
    1.8198761597999982`}, {0.5219218021925992, 1.7390390989037003`}, {
    0.7043917048148252, 1.6478041475925873`}, {0.9076573882666816, 
    1.5461713058666593`}, {1.1317188525481685`, 1.4341405737259159`}, {
    1.3765760976592858`, 1.311711951170357}, {1.6422291236000337`, 
    1.1788854381999831`}, {1.7173168384000266`, 1.1364033091950485`}, {
    1.7835707044000204`, 1.0884615613802366`}, {1.840990721600015, 
    1.035060194755548}, {1.8895768900000105`, 0.9761992093209825}, {
    1.9293292096000068`, 0.9118786050765398}, {1.9602476804000037`, 
    0.8420983820222203}, {1.9823323024000017`, 0.7668585401580238}, {
    1.9955830756000004`, 0.6861590794839504}, {2., 0.6}, {2., 
    0.5135802469135802}, {2., 0.43209876543209874`}, {2., 
    0.3555555555555555}, {2., 0.2839506172839506}, {2., 
    0.21728395061728392`}, {2., 0.15555555555555553`}, {2., 
    0.09876543209876541}, {2., 0.04691358024691357}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028937842778793417`, 0.8}}], 
      ArrowBox[{1, 2}], ArrowBox[{1, 3}], ArrowBox[{1, 4}], 
      {Arrowheads[{{0.5, 0.5, 
          GraphicsBox[{
            GrayLevel[0], 
            InsetBox[
             BoxData[
              FormBox[
               StyleBox["\"1\[Rule]5\"", StripOnInput -> False], 
               TraditionalForm]], {0, 0}, 
             ImageScaled[{0.5, 0.5}], Automatic, None, Background -> 
             GrayLevel[1]]}]}, {0.028937842778793417`, 0.8}}], 
       ArrowBox[{1, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
        22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 5}]}, ArrowBox[{2, 5}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 2.}, {-1., 1.}, {0., 1.}, {1., 1.}, {2., 
     0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1941135591]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1093274895],

Cell["Give vertex labels:", "ExampleText",
 CellID->250888577],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"1", "\[Rule]", "7"}], ",", 
     RowBox[{"1", "\[Rule]", "11"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "5"}], ",", 
     RowBox[{"1", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1908060239],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxlj30w1Hkcx3+xdBRbV0qbqVztNZuu9pQebs1+vmmJSLV5GJsTZUkSyh1J
D5wwRY96sqpDu93uhXYJrfSTLaR0Sks5ZBdt9GDXethlH87NXX9c95l5z2ve
8573Z+ZtvzOayTbBMGzrhP7mF4f+gRL/l/Df+LP/kp97//sD5n4xkhde9yBk
dpc1M9EI309LFES0PgPeTONiDW6AR63fRB2zeA1No4Geg016WF/jds9zRAYd
1doEVKiD5en3x5Ms30FTtPS23GcceGLN0LYHn4BHUA6+qtOCT9HYtt1Wagg5
6gELzTWQs4p14uCUUcC6ZBceEEeAPJJztYM1Dqnf3h0p6VGDq/C7vI6rOnDW
PXfY66CGlBWUiORKPYivLr3SxhqE9qSs4foSAxgsH9ON+1WwLYvlVppmhK8Y
N+3aDighzrG+0J6EIdHZU+wW8Sd4mnyJRAvCUJcj04S94wOUruRE8E5jKCfy
CjFY2gdLPJtzdhVhSEYLzaqzU8CyR1C0X4yh0gLRIY5TD5S17LE9M+E7pfcJ
MV4yKC/p3JRwB0N+lmlc0dwOcAzkeDv8jqGVu448KVK3ArnpVxKfM5GXhR16
uaAZzhEHhKo0DCVMPrJng1sjJJDSZppFYajxovXgmuGH0Kpku3RvwpCvk4E0
niuG4nOnaJkUDDG86Gofdz7cDBS29GaUQbV1c6TJwMTuJLfA5VsfQ7CQ65pe
pQesLJRPmiGFLkV81qlIHdyqigmvkXXCOpHHelvtGNQIFsZtsOyF5GlzwxeF
aUFCH7Kp9n0PeSYfNCLRKERZXcjkUlSQn3FPI+kchtTrcnrcpGFIyc8M8+9X
A1cqt/dy1ML6LYEuUVIVeDd7ukf4jQG11W7wpKMKjNJLslT/cRjdRaNCohLK
O2o/XnPSgePHaK1VwADE97/aW67UwdJ55OLacx+BrmsMepahh3bWxeTf8t6D
1QyepFuvh3UFkpiS433QvSyEM7rZAIGjt5IUdAVUbzb2Whw1wFJ/JpfR2APc
n44VkE4aQFRT0t9AlUM2c8kfb04YoIok9Jm/6A2cvewSSrxgAIbNmV+2rGiD
3A2Pd/L5BtDGEXZSTkvhzo77DYX1Bmhfa63kr34O7V32uXaDBmirY22/EdAA
056oW4bJRgh4K3FidNQAc97KQ2tDjRBxrbgzbKgc8tvkGYpbRhBasBbUP+BB
ytq4p/5TMVSjnu+DO8WCmnL458sGDAWR41XevrfBN9E2k2Vhgtyp7JDVh8vg
wJzu3Wtmm6Ilx/3YhVNLIFzTdT7zawJqNBVsdqdcgd65Fc7LFATUXGEruJNe
iDcy91GJqWYodoAfha96hM9aFTs9p90MeSSIhTeuvcD3MQ5WlvaZobH6Qq7z
rD9xrCV+DlNghg7mNYwtEsjwKVVD4vSFZmie5bGNtf69eJUNP4ocTEBCxvXy
RPd3+OT5JFprtCnamCG3l0M/Tp+uudzNNkG54apsjs17PPjp9tzr/pNQsSR7
b0pFP16Z4TFQwcKQs0N2gDW1DydSUvxU5kZgC1osxZy3OHmdDce1Vg9hxPi6
JGo3XpDk+eNiKz0MeBN4NhGdeGTdw9fR/Tp4eb5HGK6W4jBJrFIE64FW2Wfq
tf0JrluRr7MON0Clz9GgSvO7OC2x6F2HwghBLj/wZozF4n8ByGhqXw==
    "], {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028937842778793417`, 0.7}}], 
      ArrowBox[{1, 2}], ArrowBox[{1, 3}], ArrowBox[{1, 4}], 
      ArrowBox[{1, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
       22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 5}], 
      ArrowBox[{1, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
        48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 5}], ArrowBox[{2, 5}], 
      ArrowBox[{5, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73,
        74, 75, 76, 77, 78, 79, 80, 81, 5}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["7",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["11",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 2.}, {-1., 1.}, {0., 1.}, {1., 1.}, {2., 
     0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 137},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->878932605]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1301177980],

Cell["Do not show multiedges or self-loops:", "ExampleText",
 CellID->956609091],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"1", "\[Rule]", "7"}], ",", 
     RowBox[{"1", "\[Rule]", "11"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "5"}], ",", 
     RowBox[{"1", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"MultiedgeStyle", "\[Rule]", "None"}], ",", 
   RowBox[{"SelfLoopStyle", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->417724249],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 2.}, {-1., 1.}, {0., 1.}, {1., 1.}, {2., 
    0.}, {2., 1.}, {0.09928677930370411, 1.950356610348148}, {
    0.21936933943703868`, 1.8903153302814806`}, {0.3602476804000037, 
    1.8198761597999982`}, {0.5219218021925992, 1.7390390989037003`}, {
    0.7043917048148252, 1.6478041475925873`}, {0.9076573882666816, 
    1.5461713058666593`}, {1.1317188525481685`, 1.4341405737259159`}, {
    1.3765760976592858`, 1.311711951170357}, {1.6422291236000337`, 
    1.1788854381999831`}, {1.7173168384000266`, 1.1364033091950485`}, {
    1.7835707044000204`, 1.0884615613802366`}, {1.840990721600015, 
    1.035060194755548}, {1.8895768900000105`, 0.9761992093209825}, {
    1.9293292096000068`, 0.9118786050765398}, {1.9602476804000037`, 
    0.8420983820222203}, {1.9823323024000017`, 0.7668585401580238}, {
    1.9955830756000004`, 0.6861590794839504}, {2., 0.6}, {2., 
    0.5135802469135802}, {2., 0.43209876543209874`}, {2., 
    0.3555555555555555}, {2., 0.2839506172839506}, {2., 
    0.21728395061728392`}, {2., 0.15555555555555553`}, {2., 
    0.09876543209876541}, {2., 0.04691358024691357}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028937842778793417`, 0.8}}], 
      ArrowBox[{1, 2}], ArrowBox[{1, 3}], ArrowBox[{1, 4}], 
      ArrowBox[{1, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
       22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 5}], ArrowBox[{2, 5}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 2.}, {-1., 1.}, {0., 1.}, {1., 1.}, {2., 
     0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->864705255]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->622455388],

Cell["Show edges as lines:", "ExampleText",
 CellID->1768796684],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"1", "\[Rule]", "7"}], ",", 
     RowBox[{"1", "\[Rule]", "11"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"1", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->926176801],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 2.}, {-1., 1.}, {0., 1.}, {1., 1.}, {2., 
    0.}, {2., 1.}, {0.09928677930370411, 1.950356610348148}, {
    0.21936933943703868`, 1.8903153302814806`}, {0.3602476804000037, 
    1.8198761597999982`}, {0.5219218021925992, 1.7390390989037003`}, {
    0.7043917048148252, 1.6478041475925873`}, {0.9076573882666816, 
    1.5461713058666593`}, {1.1317188525481685`, 1.4341405737259159`}, {
    1.3765760976592858`, 1.311711951170357}, {1.6422291236000337`, 
    1.1788854381999831`}, {1.7173168384000266`, 1.1364033091950485`}, {
    1.7835707044000204`, 1.0884615613802366`}, {1.840990721600015, 
    1.035060194755548}, {1.8895768900000105`, 0.9761992093209825}, {
    1.9293292096000068`, 0.9118786050765398}, {1.9602476804000037`, 
    0.8420983820222203}, {1.9823323024000017`, 0.7668585401580238}, {
    1.9955830756000004`, 0.6861590794839504}, {2., 0.6}, {2., 
    0.5135802469135802}, {2., 0.43209876543209874`}, {2., 
    0.3555555555555555}, {2., 0.2839506172839506}, {2., 
    0.21728395061728392`}, {2., 0.15555555555555553`}, {2., 
    0.09876543209876541}, {2., 0.04691358024691357}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 7, 8, 9, 10, 11, 12, 13, 14, 15, 
        16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 
        5}, {2, 5}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 2.}, {-1., 1.}, {0., 1.}, {1., 1.}, {2., 
     0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->778523393]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->996109397],

Cell["Plot a disconnected graph using different packing methods: ", \
"ExampleText",
 CellID->2995],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "@", 
    RowBox[{"LayeredGraphPlot", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"i", "\[Rule]", 
         RowBox[{"Mod", "[", 
          RowBox[{
           RowBox[{"i", "^", "2"}], ",", "31"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "0", ",", "31"}], "}"}]}], "]"}], ",", 
      RowBox[{"PackingMethod", "\[Rule]", "pm"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"pm", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Automatic\>\"", ",", "\"\<ClosestPacking\>\""}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[1]:=",
 CellID->1209134277],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    GraphicsBox[
     TagBox[GraphicsComplexBox[CompressedData["
1:eJxtlntQU2caxsPFGwRIAiSU5IREUIyWuhXBeD1HDcgqWhXl5toiKCBQUFdK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       "], {
        {RGBColor[0.5, 0., 0.], Arrowheads[{{0.018237666660839726`, 0.8}}], 
         ArrowBox[{1, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 
          53, 54, 55, 56, 57, 58, 59, 60, 61, 1}], 
         ArrowBox[{2, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 
          76, 77, 78, 79, 80, 81, 82, 83, 84, 2}], ArrowBox[{3, 4}], 
         ArrowBox[{4, 7}], ArrowBox[{5, 6}], ArrowBox[{6, 14}], 
         ArrowBox[{7, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 
          99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112,
           113, 114, 115, 116, 117, 118, 119, 13}], 
         ArrowBox[{8, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 
          131, 132, 133, 134, 135, 9}], 
         ArrowBox[{9, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 
          147, 148, 149, 150, 151, 8}], ArrowBox[{10, 8}], ArrowBox[{11, 12}],
          ArrowBox[{12, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162,
           163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 
          176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 21}], 
         ArrowBox[{13, 3}], ArrowBox[{14, 19}], ArrowBox[{15, 11}], 
         ArrowBox[{16, 17}], 
         ArrowBox[{17, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 
          198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 
          211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 6}], 
         ArrowBox[{18, 19}], ArrowBox[{19, 17}], ArrowBox[{20, 21}], 
         ArrowBox[{21, 15}], ArrowBox[{22, 13}], ArrowBox[{23, 15}], 
         ArrowBox[{24, 11}], ArrowBox[{25, 14}], ArrowBox[{26, 3}], 
         ArrowBox[{27, 12}], ArrowBox[{28, 9}], ArrowBox[{29, 7}], 
         ArrowBox[{30, 4}], ArrowBox[{31, 2}], ArrowBox[{32, 1}]}, 
        {RGBColor[0, 0, 0.7], 
         TagBox[
          TooltipBox[PointBox[1],
           "0"],
          Annotation[#, 0, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[2],
           "1"],
          Annotation[#, 1, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[3],
           "2"],
          Annotation[#, 2, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[4],
           "4"],
          Annotation[#, 4, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[5],
           "3"],
          Annotation[#, 3, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[6],
           "9"],
          Annotation[#, 9, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[7],
           "16"],
          Annotation[#, 16, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[8],
           "5"],
          Annotation[#, 5, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[9],
           "25"],
          Annotation[#, 25, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[10],
           "6"],
          Annotation[#, 6, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[11],
           "7"],
          Annotation[#, 7, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[12],
           "18"],
          Annotation[#, 18, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[13],
           "8"],
          Annotation[#, 8, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[14],
           "19"],
          Annotation[#, 19, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[15],
           "10"],
          Annotation[#, 10, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[16],
           "11"],
          Annotation[#, 11, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[17],
           "28"],
          Annotation[#, 28, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[18],
           "12"],
          Annotation[#, 12, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[19],
           "20"],
          Annotation[#, 20, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[20],
           "13"],
          Annotation[#, 13, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[21],
           "14"],
          Annotation[#, 14, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[22],
           "15"],
          Annotation[#, 15, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[23],
           "17"],
          Annotation[#, 17, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[24],
           "21"],
          Annotation[#, 21, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[25],
           "22"],
          Annotation[#, 22, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[26],
           "23"],
          Annotation[#, 23, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[27],
           "24"],
          Annotation[#, 24, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[28],
           "26"],
          Annotation[#, 26, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[29],
           "27"],
          Annotation[#, 27, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[30],
           "29"],
          Annotation[#, 29, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[31],
           "30"],
          Annotation[#, 30, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[32],
           "31"],
          Annotation[#, 31, "Tooltip"]& ]}}],
      Annotation[#, 
       VertexCoordinateRules -> {{7.288244444444445, -6.864613333333334}, {
        4.128502222222223, -6.864613333333334}, {
        1.5520933333333335`, -2.5520933333333335`}, {
        1.5520933333333335`, -3.5520933333333335`}, {
        5.656280000000001, -0.5520933333333335}, {
        5.656280000000001, -1.5520933333333335`}, {
        1.5520933333333335`, -4.5520933333333335`}, {
        1.5520933333333335`, -6.656280000000001}, {
        1.5520933333333335`, -7.656280000000001}, {
        1.5520933333333335`, -5.656280000000001}, {
        7.760466666666668, -3.5520933333333335`}, {
        7.760466666666668, -4.5520933333333335`}, {
        2.5520933333333335`, -1.5520933333333335`}, {
        4.656280000000001, -2.5520933333333335`}, {
        7.760466666666668, -2.5520933333333335`}, {
        3.6562800000000006`, -3.5520933333333335`}, {
        4.656280000000001, -4.5520933333333335`}, {
        3.6562800000000006`, -2.5520933333333335`}, {
        4.656280000000001, -3.5520933333333335`}, {
        8.760466666666668, -0.5520933333333335}, {
        8.760466666666668, -1.5520933333333335`}, {
        2.5520933333333335`, -0.5520933333333335}, {
        7.760466666666668, -1.5520933333333335`}, {
        6.760466666666668, -2.5520933333333335`}, {
        4.656280000000001, -1.5520933333333335`}, {
        1.5520933333333335`, -1.5520933333333335`}, {
        6.760466666666668, -3.5520933333333335`}, {
        0.5520933333333335, -6.656280000000001}, {
        0.5520933333333335, -3.5520933333333335`}, {
        0.5520933333333335, -2.5520933333333335`}, {
        4.128502222222223, -5.864613333333334}, {
        7.288244444444445, -5.864613333333334}}]& ],
     AspectRatio->Automatic,
     FrameTicks->None,
     PlotRange->All,
     PlotRangePadding->Scaled[0.1]],
    StripOnInput->False], ",", 
   FrameBox[
    GraphicsBox[
     TagBox[GraphicsComplexBox[CompressedData["
1:eJxd1ns4VOkfAHC3Mc24DjOuM8yMKGvTblKr1HlJ1qVU+pFbtC7ZaEk3VKSS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       "], {
        {RGBColor[0.5, 0., 0.], Arrowheads[{{0.017212407356732757`, 0.8}}], 
         ArrowBox[{1, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 
          53, 54, 55, 56, 57, 58, 59, 60, 61, 1}], 
         ArrowBox[{2, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 
          76, 77, 78, 79, 80, 81, 82, 83, 84, 2}], ArrowBox[{3, 4}], 
         ArrowBox[{4, 7}], ArrowBox[{5, 6}], ArrowBox[{6, 14}], 
         ArrowBox[{7, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 
          99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112,
           113, 114, 115, 116, 117, 118, 119, 13}], 
         ArrowBox[{8, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 
          131, 132, 133, 134, 135, 9}], 
         ArrowBox[{9, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 
          147, 148, 149, 150, 151, 8}], ArrowBox[{10, 8}], ArrowBox[{11, 12}],
          ArrowBox[{12, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162,
           163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 
          176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 21}], 
         ArrowBox[{13, 3}], ArrowBox[{14, 19}], ArrowBox[{15, 11}], 
         ArrowBox[{16, 17}], 
         ArrowBox[{17, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 
          198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 
          211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 6}], 
         ArrowBox[{18, 19}], ArrowBox[{19, 17}], ArrowBox[{20, 21}], 
         ArrowBox[{21, 15}], ArrowBox[{22, 13}], ArrowBox[{23, 15}], 
         ArrowBox[{24, 11}], ArrowBox[{25, 14}], ArrowBox[{26, 3}], 
         ArrowBox[{27, 12}], ArrowBox[{28, 9}], ArrowBox[{29, 7}], 
         ArrowBox[{30, 4}], ArrowBox[{31, 2}], ArrowBox[{32, 1}]}, 
        {RGBColor[0, 0, 0.7], 
         TagBox[
          TooltipBox[PointBox[1],
           "0"],
          Annotation[#, 0, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[2],
           "1"],
          Annotation[#, 1, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[3],
           "2"],
          Annotation[#, 2, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[4],
           "4"],
          Annotation[#, 4, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[5],
           "3"],
          Annotation[#, 3, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[6],
           "9"],
          Annotation[#, 9, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[7],
           "16"],
          Annotation[#, 16, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[8],
           "5"],
          Annotation[#, 5, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[9],
           "25"],
          Annotation[#, 25, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[10],
           "6"],
          Annotation[#, 6, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[11],
           "7"],
          Annotation[#, 7, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[12],
           "18"],
          Annotation[#, 18, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[13],
           "8"],
          Annotation[#, 8, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[14],
           "19"],
          Annotation[#, 19, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[15],
           "10"],
          Annotation[#, 10, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[16],
           "11"],
          Annotation[#, 11, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[17],
           "28"],
          Annotation[#, 28, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[18],
           "12"],
          Annotation[#, 12, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[19],
           "20"],
          Annotation[#, 20, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[20],
           "13"],
          Annotation[#, 13, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[21],
           "14"],
          Annotation[#, 14, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[22],
           "15"],
          Annotation[#, 15, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[23],
           "17"],
          Annotation[#, 17, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[24],
           "21"],
          Annotation[#, 21, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[25],
           "22"],
          Annotation[#, 22, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[26],
           "23"],
          Annotation[#, 23, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[27],
           "24"],
          Annotation[#, 24, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[28],
           "26"],
          Annotation[#, 26, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[29],
           "27"],
          Annotation[#, 27, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[30],
           "29"],
          Annotation[#, 29, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[31],
           "30"],
          Annotation[#, 30, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[32],
           "31"],
          Annotation[#, 31, "Tooltip"]& ]}}],
      Annotation[#, 
       VertexCoordinateRules -> {{2.994805811729095, -8.943183617543195}, {
        7.237447378345313, -0.957034786265607}, {
        0.9982686039096986, -1.9965372078193964`}, {
        0.9982686039096986, -2.9965372078193964`}, {
        5.242641566616218, -2.492208717593642}, {
        5.242641566616218, -3.492208717593642}, {
        0.9982686039096986, -3.9965372078193964`}, {
        0.9991343019548493, -6.488745925413039}, {
        0.9991343019548493, -7.488745925413039}, {
        0.9991343019548493, -5.488745925413039}, {
        7.237447378345313, -8.237447378345312}, {
        7.237447378345313, -9.237447378345312}, {
        1.9982686039096986`, -0.9965372078193964}, {
        4.242641566616218, -4.492208717593642}, {
        7.237447378345313, -7.237447378345312}, {
        3.242641566616218, -5.492208717593642}, {
        4.242641566616218, -6.492208717593642}, {
        3.242641566616218, -4.492208717593642}, {
        4.242641566616218, -5.492208717593642}, {
        8.237447378345312, -5.237447378345312}, {
        8.237447378345312, -6.237447378345312}, {1.9982686039096986`, 
        0.0034627921806036355`}, {7.237447378345313, -6.237447378345312}, {
        6.237447378345313, -7.237447378345312}, {
        4.242641566616218, -3.492208717593642}, {
        0.9982686039096986, -0.9965372078193964}, {
        6.237447378345313, -8.237447378345312}, {-0.0008656980451506868, \
-6.488745925413039}, {-0.0017313960903013736`, -2.9965372078193964`}, \
{-0.0017313960903013736`, -1.9965372078193964`}, {7.237447378345313, 
        0.04296521373439299}, {2.994805811729095, -7.943183617543195}}]& ],
     AspectRatio->Automatic,
     FrameTicks->None,
     PlotRange->All,
     PlotRangePadding->Scaled[0.1]],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{410, 221},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[1]=",
 CellID->1944265731]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1529467861],

Cell["Draw with different orientations:", "ExampleText",
 CellID->1551442486],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "@", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"LayeredGraphPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "3"}], ",", 
        RowBox[{"1", "\[Rule]", "4"}], ",", 
        RowBox[{"1", "\[Rule]", "5"}], ",", 
        RowBox[{"3", "\[Rule]", "5"}], ",", 
        RowBox[{"3", "\[Rule]", "6"}]}], "}"}], ",", "pos", ",", 
      RowBox[{"PlotLabel", "\[Rule]", "pos"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"pos", ",", 
      RowBox[{"{", 
       RowBox[{"Left", ",", "Top", ",", "Right", ",", "Bottom"}], "}"}]}], 
     "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1155268122],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{-2., -2.1437508791444563`*^-15}, \
{-1.000000000000001, 
      0.9999999999999989}, {-0.9999999999999989, -1.000000000000001}, {0., 
      0.}, {-1.0718754395722282`*^-15, 
      1.}, {-1., -1.0718754395722282`*^-15}, {-1.9530864197530864`, \
-2.093465364695389*^-15}, {-1.9012345679012346`, -2.037886638199051*^-15}, \
{-1.8444444444444446`, -1.977014699655443*^-15}, {-1.782716049382716, \
-1.9108495490645648`*^-15}, {-1.7160493827160495`, \
-1.8393911864264162`*^-15}, {-1.6444444444444444`, \
-1.7626396117409973`*^-15}, {-1.567901234567901, -1.6805948250083084`*^-15}, \
{-1.4864197530864196`, -1.593256826228349*^-15}, {-1.4, \
-1.5006256154011195`*^-15}, {-1.3111111111111111`, \
-1.4053477985502547`*^-15}, {-1.222222222222222, -1.31006998169939*^-15}, \
{-1.1333333333333333`, -1.2147921648485253`*^-15}, {-1.0444444444444445`, \
-1.1195143479976605`*^-15}, {-0.9555555555555555, -1.0242365311467958`*^-15}, \
{-0.8666666666666667, -9.28958714295931*^-16}, {-0.7777777777777778, \
-8.336808974450664*^-16}, {-0.6888888888888889, -7.384030805942017*^-16}, \
{-0.6, -6.431252637433369*^-16}, {-0.5135802469135802, \
-5.504940529161073*^-16}, {-0.43209876543209874`, -4.631560541361479*^-16}, \
{-0.3555555555555555, -3.8111126740345887`*^-16}, {-0.2839506172839506, \
-3.0435969271804006`*^-16}, {-0.21728395061728392`, \
-2.3290133007989155`*^-16}, {-0.15555555555555553`, \
-1.6673617948901325`*^-16}, {-0.09876543209876541, \
-1.0586424094540523`*^-16}, {-0.04691358024691357, -5.028551444906748*^-17}}, \
{
       {RGBColor[0.5, 0., 0.], Arrowheads[{{0.03384563758389261, 0.8}}], 
        ArrowBox[{1, 2}], ArrowBox[{1, 3}], 
        ArrowBox[{1, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
         22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 4}], ArrowBox[{2, 4}], 
        ArrowBox[{2, 5}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "6"],
         Annotation[#, 6, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{-2., -2.1437508791444563`*^-15}, \
{-1.000000000000001, 
       0.9999999999999989}, {-0.9999999999999989, -1.000000000000001}, {0., 
       0.}, {-1.0718754395722282`*^-15, 1.}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotLabel->FormBox["Left", TraditionalForm],
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], "\[InvisibleSpace]", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0., 2.}, {1., 1.}, {-1., 1.}, {0., 0.}, {1., 0.}, {
      0., 1.}, {0., 1.9530864197530864`}, {0., 1.9012345679012346`}, {0., 
      1.8444444444444446`}, {0., 1.782716049382716}, {0., 
      1.7160493827160495`}, {0., 1.6444444444444444`}, {0., 
      1.567901234567901}, {0., 1.4864197530864196`}, {0., 1.4}, {0., 
      1.3111111111111111`}, {0., 1.222222222222222}, {0., 
      1.1333333333333333`}, {0., 1.0444444444444445`}, {0., 
      0.9555555555555555}, {0., 0.8666666666666667}, {0., 
      0.7777777777777778}, {0., 0.6888888888888889}, {0., 0.6}, {0., 
      0.5135802469135802}, {0., 0.43209876543209874`}, {0., 
      0.3555555555555555}, {0., 0.2839506172839506}, {0., 
      0.21728395061728392`}, {0., 0.15555555555555553`}, {0., 
      0.09876543209876541}, {0., 0.04691358024691357}}, {
       {RGBColor[0.5, 0., 0.], Arrowheads[{{0.03384563758389261, 0.8}}], 
        ArrowBox[{1, 2}], ArrowBox[{1, 3}], 
        ArrowBox[{1, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
         22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 4}], ArrowBox[{2, 4}], 
        ArrowBox[{2, 5}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "6"],
         Annotation[#, 6, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0., 2.}, {1., 1.}, {-1., 1.}, {0., 0.}, {1., 
       0.}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotLabel->FormBox["Top", TraditionalForm],
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], "\[InvisibleSpace]", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{2., 5.66553889764798*^-16}, {
      1.0000000000000002`, -0.9999999999999997}, {0.9999999999999997, 
      1.0000000000000002`}, {0., 0.}, {2.83276944882399*^-16, -1.}, {1., 
      2.83276944882399*^-16}, {1.9530864197530864`, 5.53264354078957*^-16}, {
      1.9012345679012346`, 5.385759198998697*^-16}, {1.8444444444444446`, 
      5.224885872275359*^-16}, {1.782716049382716, 5.050023560619558*^-16}, {
      1.7160493827160495`, 4.861172264031291*^-16}, {1.6444444444444444`, 
      4.658331982510562*^-16}, {1.567901234567901, 4.441502716057367*^-16}, {
      1.4864197530864196`, 4.2106844646717083`*^-16}, {1.4, 
      3.965877228353586*^-16}, {1.3111111111111111`, 
      3.714075499569231*^-16}, {1.222222222222222, 
      3.4622737707848764`*^-16}, {1.1333333333333333`, 
      3.2104720420005217`*^-16}, {1.0444444444444445`, 
      2.9586703132161674`*^-16}, {0.9555555555555555, 
      2.7068685844318127`*^-16}, {0.8666666666666667, 
      2.455066855647458*^-16}, {0.7777777777777778, 
      2.2032651268631032`*^-16}, {0.6888888888888889, 
      1.9514633980787487`*^-16}, {0.6, 1.699661669294394*^-16}, {
      0.5135802469135802, 1.4548544329762713`*^-16}, {0.43209876543209874`, 
      1.2240361815906128`*^-16}, {0.3555555555555555, 
      1.0072069151374185`*^-16}, {0.2839506172839506, 
      8.043666336166884*^-17}, {0.21728395061728392`, 
      6.155153370284224*^-17}, {0.15555555555555553`, 
      4.4065302537262056`*^-17}, {0.09876543209876541, 
      2.797796986492829*^-17}, {0.04691358024691357, 
      1.3289535685840937`*^-17}}, {
       {RGBColor[0.5, 0., 0.], Arrowheads[{{0.03384563758389261, 0.8}}], 
        ArrowBox[{1, 2}], ArrowBox[{1, 3}], 
        ArrowBox[{1, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
         22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 4}], ArrowBox[{2, 4}], 
        ArrowBox[{2, 5}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "6"],
         Annotation[#, 6, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{2., 5.66553889764798*^-16}, {
       1.0000000000000002`, -0.9999999999999997}, {0.9999999999999997, 
       1.0000000000000002`}, {0., 0.}, {2.83276944882399*^-16, -1.}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotLabel->FormBox["Right", TraditionalForm],
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], "\[InvisibleSpace]", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{
      1.133107779529596*^-15, -2.}, {-0.9999999999999994, \
-1.0000000000000007`}, {1.0000000000000007`, -0.9999999999999994}, {0., 
      0.}, {-1., -5.66553889764798*^-16}, {5.66553889764798*^-16, -1.}, {
      1.106528708157914*^-15, -1.9530864197530864`}, {
      1.0771518397997394`*^-15, -1.9012345679012346`}, {
      1.0449771744550718`*^-15, -1.8444444444444446`}, {
      1.0100047121239115`*^-15, -1.782716049382716}, {
      9.722344528062583*^-16, -1.7160493827160495`}, {
      9.316663965021123*^-16, -1.6444444444444444`}, {
      8.883005432114734*^-16, -1.567901234567901}, {
      8.421368929343417*^-16, -1.4864197530864196`}, {
      7.931754456707172*^-16, -1.4}, {
      7.428150999138462*^-16, -1.3111111111111111`}, {
      6.924547541569753*^-16, -1.222222222222222}, {
      6.420944084001043*^-16, -1.1333333333333333`}, {
      5.917340626432335*^-16, -1.0444444444444445`}, {
      5.413737168863625*^-16, -0.9555555555555555}, {
      4.910133711294916*^-16, -0.8666666666666667}, {
      4.4065302537262064`*^-16, -0.7777777777777778}, {
      3.9029267961574974`*^-16, -0.6888888888888889}, {
      3.399323338588788*^-16, -0.6}, {
      2.9097088659525426`*^-16, -0.5135802469135802}, {
      2.4480723631812256`*^-16, -0.43209876543209874`}, {
      2.014413830274837*^-16, -0.3555555555555555}, {
      1.6087332672333768`*^-16, -0.2839506172839506}, {
      1.231030674056845*^-16, -0.21728395061728392`}, {
      8.813060507452411*^-17, -0.15555555555555553`}, {
      5.595593972985658*^-17, -0.09876543209876541}, {
      2.6579071371681874`*^-17, -0.04691358024691357}}, {
       {RGBColor[0.5, 0., 0.], Arrowheads[{{0.03384563758389261, 0.8}}], 
        ArrowBox[{1, 2}], ArrowBox[{1, 3}], 
        ArrowBox[{1, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
         22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 4}], ArrowBox[{2, 4}], 
        ArrowBox[{2, 5}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "6"],
         Annotation[#, 6, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{
       1.133107779529596*^-15, -2.}, {-0.9999999999999994, \
-1.0000000000000007`}, {1.0000000000000007`, -0.9999999999999994}, {0., 
       0.}, {-1., -5.66553889764798*^-16}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotLabel->FormBox["Bottom", TraditionalForm],
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]]}],
  Row[{
    Graphics[
     Annotation[
      GraphicsComplex[{{-2., -2.1437508791444563`*^-15}, {-1.000000000000001, 
       0.9999999999999989}, {-0.9999999999999989, -1.000000000000001}, {0., 
       0.}, {-1.0718754395722282`*^-15, 
       1.}, {-1., -1.0718754395722282`*^-15}, {-1.9530864197530864`, \
-2.093465364695389*^-15}, {-1.9012345679012346`, -2.037886638199051*^-15}, \
{-1.8444444444444446`, -1.977014699655443*^-15}, {-1.782716049382716, \
-1.9108495490645648`*^-15}, {-1.7160493827160495`, \
-1.8393911864264162`*^-15}, {-1.6444444444444444`, \
-1.7626396117409973`*^-15}, {-1.567901234567901, -1.6805948250083084`*^-15}, \
{-1.4864197530864196`, -1.593256826228349*^-15}, {-1.4, \
-1.5006256154011195`*^-15}, {-1.3111111111111111`, \
-1.4053477985502547`*^-15}, {-1.222222222222222, -1.31006998169939*^-15}, \
{-1.1333333333333333`, -1.2147921648485253`*^-15}, {-1.0444444444444445`, \
-1.1195143479976605`*^-15}, {-0.9555555555555555, -1.0242365311467958`*^-15}, \
{-0.8666666666666667, -9.28958714295931*^-16}, {-0.7777777777777778, \
-8.336808974450664*^-16}, {-0.6888888888888889, -7.384030805942017*^-16}, \
{-0.6, -6.431252637433369*^-16}, {-0.5135802469135802, \
-5.504940529161073*^-16}, {-0.43209876543209874`, -4.631560541361479*^-16}, \
{-0.3555555555555555, -3.8111126740345887`*^-16}, {-0.2839506172839506, \
-3.0435969271804006`*^-16}, {-0.21728395061728392`, \
-2.3290133007989155`*^-16}, {-0.15555555555555553`, \
-1.6673617948901325`*^-16}, {-0.09876543209876541, \
-1.0586424094540523`*^-16}, {-0.04691358024691357, -5.028551444906748*^-17}}, \
{{
         RGBColor[0.5, 0., 0.], 
         Arrowheads[{{0.03384563758389261, 0.8}}], 
         Arrow[{1, 2}], 
         Arrow[{1, 3}], 
         Arrow[{1, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
          22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 4}], 
         Arrow[{2, 4}], 
         Arrow[{2, 5}]}, {
         RGBColor[0, 0, 0.7], 
         Tooltip[
          Point[1], 1], 
         Tooltip[
          Point[2], 3], 
         Tooltip[
          Point[3], 4], 
         Tooltip[
          Point[4], 5], 
         Tooltip[
          Point[5], 6]}}, {}], 
      VertexCoordinateRules -> {{-2., -2.1437508791444563`*^-15}, \
{-1.000000000000001, 
       0.9999999999999989}, {-0.9999999999999989, -1.000000000000001}, {0., 
       0.}, {-1.0718754395722282`*^-15, 1.}}], FrameTicks -> None, PlotRange -> 
     All, PlotRangePadding -> Scaled[0.1], AspectRatio -> Automatic, 
     PlotLabel -> Left], 
    Graphics[
     Annotation[
      GraphicsComplex[{{0., 2.}, {1., 1.}, {-1., 1.}, {0., 0.}, {1., 0.}, {0.,
        1.}, {0., 1.9530864197530864`}, {0., 1.9012345679012346`}, {0., 
       1.8444444444444446`}, {0., 1.782716049382716}, {0., 
       1.7160493827160495`}, {0., 1.6444444444444444`}, {0., 
       1.567901234567901}, {0., 1.4864197530864196`}, {0., 1.4}, {0., 
       1.3111111111111111`}, {0., 1.222222222222222}, {0., 
       1.1333333333333333`}, {0., 1.0444444444444445`}, {0., 
       0.9555555555555555}, {0., 0.8666666666666667}, {0., 
       0.7777777777777778}, {0., 0.6888888888888889}, {0., 0.6}, {0., 
       0.5135802469135802}, {0., 0.43209876543209874`}, {0., 
       0.3555555555555555}, {0., 0.2839506172839506}, {0., 
       0.21728395061728392`}, {0., 0.15555555555555553`}, {0., 
       0.09876543209876541}, {0., 0.04691358024691357}}, {{
         RGBColor[0.5, 0., 0.], 
         Arrowheads[{{0.03384563758389261, 0.8}}], 
         Arrow[{1, 2}], 
         Arrow[{1, 3}], 
         Arrow[{1, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
          22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 4}], 
         Arrow[{2, 4}], 
         Arrow[{2, 5}]}, {
         RGBColor[0, 0, 0.7], 
         Tooltip[
          Point[1], 1], 
         Tooltip[
          Point[2], 3], 
         Tooltip[
          Point[3], 4], 
         Tooltip[
          Point[4], 5], 
         Tooltip[
          Point[5], 6]}}, {}], 
      VertexCoordinateRules -> {{0., 2.}, {1., 1.}, {-1., 1.}, {0., 0.}, {1., 
       0.}}], FrameTicks -> None, PlotRange -> All, PlotRangePadding -> 
     Scaled[0.1], AspectRatio -> Automatic, PlotLabel -> Top], 
    Graphics[
     Annotation[
      GraphicsComplex[{{2., 5.66553889764798*^-16}, {
       1.0000000000000002`, -0.9999999999999997}, {0.9999999999999997, 
       1.0000000000000002`}, {0., 0.}, {2.83276944882399*^-16, -1.}, {1., 
       2.83276944882399*^-16}, {1.9530864197530864`, 5.53264354078957*^-16}, {
       1.9012345679012346`, 5.385759198998697*^-16}, {1.8444444444444446`, 
       5.224885872275359*^-16}, {1.782716049382716, 5.050023560619558*^-16}, {
       1.7160493827160495`, 4.861172264031291*^-16}, {1.6444444444444444`, 
       4.658331982510562*^-16}, {1.567901234567901, 4.441502716057367*^-16}, {
       1.4864197530864196`, 4.2106844646717083`*^-16}, {1.4, 
       3.965877228353586*^-16}, {1.3111111111111111`, 
       3.714075499569231*^-16}, {1.222222222222222, 
       3.4622737707848764`*^-16}, {1.1333333333333333`, 
       3.2104720420005217`*^-16}, {1.0444444444444445`, 
       2.9586703132161674`*^-16}, {0.9555555555555555, 
       2.7068685844318127`*^-16}, {0.8666666666666667, 
       2.455066855647458*^-16}, {0.7777777777777778, 2.2032651268631032`*^-16}
       , {0.6888888888888889, 1.9514633980787487`*^-16}, {0.6, 
       1.699661669294394*^-16}, {0.5135802469135802, 
       1.4548544329762713`*^-16}, {0.43209876543209874`, 
       1.2240361815906128`*^-16}, {0.3555555555555555, 
       1.0072069151374185`*^-16}, {0.2839506172839506, 
       8.043666336166884*^-17}, {0.21728395061728392`, 
       6.155153370284224*^-17}, {0.15555555555555553`, 
       4.4065302537262056`*^-17}, {0.09876543209876541, 
       2.797796986492829*^-17}, {0.04691358024691357, 
       1.3289535685840937`*^-17}}, {{
         RGBColor[0.5, 0., 0.], 
         Arrowheads[{{0.03384563758389261, 0.8}}], 
         Arrow[{1, 2}], 
         Arrow[{1, 3}], 
         Arrow[{1, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
          22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 4}], 
         Arrow[{2, 4}], 
         Arrow[{2, 5}]}, {
         RGBColor[0, 0, 0.7], 
         Tooltip[
          Point[1], 1], 
         Tooltip[
          Point[2], 3], 
         Tooltip[
          Point[3], 4], 
         Tooltip[
          Point[4], 5], 
         Tooltip[
          Point[5], 6]}}, {}], 
      VertexCoordinateRules -> {{2., 5.66553889764798*^-16}, {
       1.0000000000000002`, -0.9999999999999997}, {0.9999999999999997, 
       1.0000000000000002`}, {0., 0.}, {2.83276944882399*^-16, -1.}}], 
     FrameTicks -> None, PlotRange -> All, PlotRangePadding -> Scaled[0.1], 
     AspectRatio -> Automatic, PlotLabel -> Right], 
    Graphics[
     Annotation[
      GraphicsComplex[{{
       1.133107779529596*^-15, -2.}, {-0.9999999999999994, \
-1.0000000000000007`}, {1.0000000000000007`, -0.9999999999999994}, {0., 
       0.}, {-1., -5.66553889764798*^-16}, {5.66553889764798*^-16, -1.}, {
       1.106528708157914*^-15, -1.9530864197530864`}, {
       1.0771518397997394`*^-15, -1.9012345679012346`}, {
       1.0449771744550718`*^-15, -1.8444444444444446`}, {
       1.0100047121239115`*^-15, -1.782716049382716}, {
       9.722344528062583*^-16, -1.7160493827160495`}, {
       9.316663965021123*^-16, -1.6444444444444444`}, {
       8.883005432114734*^-16, -1.567901234567901}, {
       8.421368929343417*^-16, -1.4864197530864196`}, {
       7.931754456707172*^-16, -1.4}, {
       7.428150999138462*^-16, -1.3111111111111111`}, {
       6.924547541569753*^-16, -1.222222222222222}, {
       6.420944084001043*^-16, -1.1333333333333333`}, {
       5.917340626432335*^-16, -1.0444444444444445`}, {
       5.413737168863625*^-16, -0.9555555555555555}, {
       4.910133711294916*^-16, -0.8666666666666667}, {
       4.4065302537262064`*^-16, -0.7777777777777778}, {
       3.9029267961574974`*^-16, -0.6888888888888889}, {
       3.399323338588788*^-16, -0.6}, {
       2.9097088659525426`*^-16, -0.5135802469135802}, {
       2.4480723631812256`*^-16, -0.43209876543209874`}, {
       2.014413830274837*^-16, -0.3555555555555555}, {
       1.6087332672333768`*^-16, -0.2839506172839506}, {
       1.231030674056845*^-16, -0.21728395061728392`}, {
       8.813060507452411*^-17, -0.15555555555555553`}, {
       5.595593972985658*^-17, -0.09876543209876541}, {
       2.6579071371681874`*^-17, -0.04691358024691357}}, {{
         RGBColor[0.5, 0., 0.], 
         Arrowheads[{{0.03384563758389261, 0.8}}], 
         Arrow[{1, 2}], 
         Arrow[{1, 3}], 
         Arrow[{1, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
          22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 4}], 
         Arrow[{2, 4}], 
         Arrow[{2, 5}]}, {
         RGBColor[0, 0, 0.7], 
         Tooltip[
          Point[1], 1], 
         Tooltip[
          Point[2], 3], 
         Tooltip[
          Point[3], 4], 
         Tooltip[
          Point[4], 5], 
         Tooltip[
          Point[5], 6]}}, {}], 
      VertexCoordinateRules -> {{
       1.133107779529596*^-15, -2.}, {-0.9999999999999994, \
-1.0000000000000007`}, {1.0000000000000007`, -0.9999999999999994}, {0., 
       0.}, {-1., -5.66553889764798*^-16}}], FrameTicks -> None, PlotRange -> 
     All, PlotRangePadding -> Scaled[0.1], AspectRatio -> Automatic, 
     PlotLabel -> Bottom]}]]], "Output",
 ImageSize->{404, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->16323902]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(13)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->908861633],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "DirectedEdges",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->203839123],

Cell["By default edges are shown as arrows:", "ExampleText",
 CellID->675090761],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "2"}], ",", 
    RowBox[{"1", "\[Rule]", "3"}], ",", 
    RowBox[{"2", "\[Rule]", "3"}], ",", 
    RowBox[{"1", "\[Rule]", "4"}], ",", 
    RowBox[{"2", "\[Rule]", "4"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1122960432],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 2.}, {0., 1.}, {-1., 0.}, {1., 0.}, {-1., 
    1.}, {1., 1.}, {-0.04835996651265902, 
    1.951640033487341}, {-0.10455097716174719`, 
    1.8954490228382528`}, {-0.16857303194726453`, 
    1.8314269680527355`}, {-0.24042613086921105`, 
    1.759573869130789}, {-0.32011027392758673`, 
    1.6798897260724133`}, {-0.4076254611223915, 
    1.5923745388776085`}, {-0.5029716924536255, 
    1.4970283075463744`}, {-0.6061489679212887, 
    1.3938510320787112`}, {-0.717157287525381, 
    1.282842712474619}, {-0.7765193382916591, 
    1.2185423901034025`}, {-0.8288976183795514, 
    1.1513492952006954`}, {-0.8742921277890582, 
    1.0812634277664972`}, {-0.9127028665201793, 
    1.0082847878008083`}, {-0.9441298345729148, 
    0.9324133753036284}, {-0.9685730319472645, 
    0.8536491902749577}, {-0.9860324586432286, 
    0.771992232714796}, {-0.9965081146608071, 0.6874425026231434}, {-1., 
    0.6}, {-1., 0.5135802469135802}, {-1., 0.43209876543209874`}, {-1., 
    0.3555555555555555}, {-1., 0.2839506172839506}, {-1., 
    0.21728395061728392`}, {-1., 0.15555555555555553`}, {-1., 
    0.09876543209876541}, {-1., 0.04691358024691357}, {0.04835996651265902, 
    1.951640033487341}, {0.10455097716174719`, 1.8954490228382528`}, {
    0.16857303194726453`, 1.8314269680527355`}, {0.24042613086921105`, 
    1.759573869130789}, {0.32011027392758673`, 1.6798897260724133`}, {
    0.4076254611223915, 1.5923745388776085`}, {0.5029716924536255, 
    1.4970283075463744`}, {0.6061489679212887, 1.3938510320787112`}, {
    0.717157287525381, 1.282842712474619}, {0.7765193382916591, 
    1.2185423901034025`}, {0.8288976183795514, 1.1513492952006954`}, {
    0.8742921277890582, 1.0812634277664972`}, {0.9127028665201793, 
    1.0082847878008083`}, {0.9441298345729148, 0.9324133753036284}, {
    0.9685730319472645, 0.8536491902749577}, {0.9860324586432286, 
    0.771992232714796}, {0.9965081146608071, 0.6874425026231434}, {1., 0.6}, {
    1., 0.5135802469135802}, {1., 0.43209876543209874`}, {1., 
    0.3555555555555555}, {1., 0.2839506172839506}, {1., 
    0.21728395061728392`}, {1., 0.15555555555555553`}, {1., 
    0.09876543209876541}, {1., 0.04691358024691357}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.03384563758389261, 0.8}}], 
      ArrowBox[{1, 2}], 
      ArrowBox[{1, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
       22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 3}], 
      ArrowBox[{1, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
        48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 4}], ArrowBox[{2, 3}], 
      ArrowBox[{2, 4}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 2.}, {0., 1.}, {-1., 0.}, {1., 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->780008646]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->503110463],

Cell["Do not show the direction of edges:", "ExampleText",
 CellID->2036916947],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}]}], "}"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", " ", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1851389954],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 2.}, {0., 1.}, {-1., 0.}, {1., 0.}, {-1., 
    1.}, {1., 1.}, {-0.04835996651265902, 
    1.951640033487341}, {-0.10455097716174719`, 
    1.8954490228382528`}, {-0.16857303194726453`, 
    1.8314269680527355`}, {-0.24042613086921105`, 
    1.759573869130789}, {-0.32011027392758673`, 
    1.6798897260724133`}, {-0.4076254611223915, 
    1.5923745388776085`}, {-0.5029716924536255, 
    1.4970283075463744`}, {-0.6061489679212887, 
    1.3938510320787112`}, {-0.717157287525381, 
    1.282842712474619}, {-0.7765193382916591, 
    1.2185423901034025`}, {-0.8288976183795514, 
    1.1513492952006954`}, {-0.8742921277890582, 
    1.0812634277664972`}, {-0.9127028665201793, 
    1.0082847878008083`}, {-0.9441298345729148, 
    0.9324133753036284}, {-0.9685730319472645, 
    0.8536491902749577}, {-0.9860324586432286, 
    0.771992232714796}, {-0.9965081146608071, 0.6874425026231434}, {-1., 
    0.6}, {-1., 0.5135802469135802}, {-1., 0.43209876543209874`}, {-1., 
    0.3555555555555555}, {-1., 0.2839506172839506}, {-1., 
    0.21728395061728392`}, {-1., 0.15555555555555553`}, {-1., 
    0.09876543209876541}, {-1., 0.04691358024691357}, {0.04835996651265902, 
    1.951640033487341}, {0.10455097716174719`, 1.8954490228382528`}, {
    0.16857303194726453`, 1.8314269680527355`}, {0.24042613086921105`, 
    1.759573869130789}, {0.32011027392758673`, 1.6798897260724133`}, {
    0.4076254611223915, 1.5923745388776085`}, {0.5029716924536255, 
    1.4970283075463744`}, {0.6061489679212887, 1.3938510320787112`}, {
    0.717157287525381, 1.282842712474619}, {0.7765193382916591, 
    1.2185423901034025`}, {0.8288976183795514, 1.1513492952006954`}, {
    0.8742921277890582, 1.0812634277664972`}, {0.9127028665201793, 
    1.0082847878008083`}, {0.9441298345729148, 0.9324133753036284}, {
    0.9685730319472645, 0.8536491902749577}, {0.9860324586432286, 
    0.771992232714796}, {0.9965081146608071, 0.6874425026231434}, {1., 0.6}, {
    1., 0.5135802469135802}, {1., 0.43209876543209874`}, {1., 
    0.3555555555555555}, {1., 0.2839506172839506}, {1., 
    0.21728395061728392`}, {1., 0.15555555555555553`}, {1., 
    0.09876543209876541}, {1., 0.04691358024691357}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 
        20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 3}, {1, 33, 34, 
        35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
        52, 53, 54, 55, 56, 57, 58, 4}, {2, 3}, {2, 4}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 2.}, {0., 1.}, {-1., 0.}, {1., 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->173098865]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "EdgeLabeling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->238189510],

Cell["By default edge labels are shown:", "ExampleText",
 CellID->825767658],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "2"}], ",", 
    RowBox[{"1", "\[Rule]", "3"}], ",", 
    RowBox[{"1", "\[Rule]", "4"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"2", "\[Rule]", "4"}], ",", "\"\<2\[Rule]4\>\""}], "}"}]}], 
   "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->612297678],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 2.}, {-1., 1.}, {0., 1.}, {1., 0.}, {1., 
    1.}, {0.04835996651265902, 1.951640033487341}, {0.10455097716174719`, 
    1.8954490228382528`}, {0.16857303194726453`, 1.8314269680527355`}, {
    0.24042613086921105`, 1.759573869130789}, {0.32011027392758673`, 
    1.6798897260724133`}, {0.4076254611223915, 1.5923745388776085`}, {
    0.5029716924536255, 1.4970283075463744`}, {0.6061489679212887, 
    1.3938510320787112`}, {0.717157287525381, 1.282842712474619}, {
    0.7765193382916591, 1.2185423901034025`}, {0.8288976183795514, 
    1.1513492952006954`}, {0.8742921277890582, 1.0812634277664972`}, {
    0.9127028665201793, 1.0082847878008083`}, {0.9441298345729148, 
    0.9324133753036284}, {0.9685730319472645, 0.8536491902749577}, {
    0.9860324586432286, 0.771992232714796}, {0.9965081146608071, 
    0.6874425026231434}, {1., 0.6}, {1., 0.5135802469135802}, {1., 
    0.43209876543209874`}, {1., 0.3555555555555555}, {1., 
    0.2839506172839506}, {1., 0.21728395061728392`}, {1., 
    0.15555555555555553`}, {1., 0.09876543209876541}, {1., 
    0.04691358024691357}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.03384563758389261, 0.8}}], 
      ArrowBox[{1, 2}], ArrowBox[{1, 3}], 
      ArrowBox[{1, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
        22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 4}], 
      {Arrowheads[{{0.5, 0.5, 
          GraphicsBox[{
            GrayLevel[0], 
            InsetBox[
             BoxData[
              FormBox[
               StyleBox["\"2\[Rule]4\"", StripOnInput -> False], 
               TraditionalForm]], {0, 0}, 
             ImageScaled[{0.5, 0.5}], Automatic, None, Background -> 
             GrayLevel[1]]}]}, {0.03384563758389261, 0.8}}], 
       ArrowBox[{2, 4}]}}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 2.}, {-1., 1.}, {0., 1.}, {1., 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->599698120]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1515268568],

Cell["Displays the edge label as a tooltip:", "ExampleText",
 CellID->384406038],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", "\[Rule]", "4"}], ",", "\"\<2\[Rule]4\>\""}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"EdgeLabeling", "\[Rule]", " ", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->349905032],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 2.}, {-1., 1.}, {0., 1.}, {1., 0.}, {1., 
    1.}, {0.04835996651265902, 1.951640033487341}, {0.10455097716174719`, 
    1.8954490228382528`}, {0.16857303194726453`, 1.8314269680527355`}, {
    0.24042613086921105`, 1.759573869130789}, {0.32011027392758673`, 
    1.6798897260724133`}, {0.4076254611223915, 1.5923745388776085`}, {
    0.5029716924536255, 1.4970283075463744`}, {0.6061489679212887, 
    1.3938510320787112`}, {0.717157287525381, 1.282842712474619}, {
    0.7765193382916591, 1.2185423901034025`}, {0.8288976183795514, 
    1.1513492952006954`}, {0.8742921277890582, 1.0812634277664972`}, {
    0.9127028665201793, 1.0082847878008083`}, {0.9441298345729148, 
    0.9324133753036284}, {0.9685730319472645, 0.8536491902749577}, {
    0.9860324586432286, 0.771992232714796}, {0.9965081146608071, 
    0.6874425026231434}, {1., 0.6}, {1., 0.5135802469135802}, {1., 
    0.43209876543209874`}, {1., 0.3555555555555555}, {1., 
    0.2839506172839506}, {1., 0.21728395061728392`}, {1., 
    0.15555555555555553`}, {1., 0.09876543209876541}, {1., 
    0.04691358024691357}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.03384563758389261, 0.8}}], 
      ArrowBox[{1, 2}], ArrowBox[{1, 3}], 
      ArrowBox[{1, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
        22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 4}], 
      TagBox[
       TooltipBox[ArrowBox[{2, 4}],
        "\"2\[Rule]4\""],
       Annotation[#, "2\[Rule]4", "Tooltip"]& ]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 2.}, {-1., 1.}, {0., 1.}, {1., 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->662946272]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2141000564],

Cell["Displays the edge label both explicitly and as a tooltip:", \
"ExampleText",
 CellID->2014701195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", "\[Rule]", "4"}], ",", "\"\<2\[Rule]4\>\""}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"EdgeLabeling", "\[Rule]", " ", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->682974758],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 2.}, {-1., 1.}, {0., 1.}, {1., 0.}, {1., 
    1.}, {0.04835996651265902, 1.951640033487341}, {0.10455097716174719`, 
    1.8954490228382528`}, {0.16857303194726453`, 1.8314269680527355`}, {
    0.24042613086921105`, 1.759573869130789}, {0.32011027392758673`, 
    1.6798897260724133`}, {0.4076254611223915, 1.5923745388776085`}, {
    0.5029716924536255, 1.4970283075463744`}, {0.6061489679212887, 
    1.3938510320787112`}, {0.717157287525381, 1.282842712474619}, {
    0.7765193382916591, 1.2185423901034025`}, {0.8288976183795514, 
    1.1513492952006954`}, {0.8742921277890582, 1.0812634277664972`}, {
    0.9127028665201793, 1.0082847878008083`}, {0.9441298345729148, 
    0.9324133753036284}, {0.9685730319472645, 0.8536491902749577}, {
    0.9860324586432286, 0.771992232714796}, {0.9965081146608071, 
    0.6874425026231434}, {1., 0.6}, {1., 0.5135802469135802}, {1., 
    0.43209876543209874`}, {1., 0.3555555555555555}, {1., 
    0.2839506172839506}, {1., 0.21728395061728392`}, {1., 
    0.15555555555555553`}, {1., 0.09876543209876541}, {1., 
    0.04691358024691357}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.03384563758389261, 0.8}}], 
      ArrowBox[{1, 2}], ArrowBox[{1, 3}], 
      ArrowBox[{1, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
        22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 4}], 
      TagBox[
       TooltipBox[
        {Arrowheads[{{0.5, 0.5, 
            GraphicsBox[{
              GrayLevel[0], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox["\"2\[Rule]4\"", StripOnInput -> False], 
                 TraditionalForm]], {0, 0}, 
               ImageScaled[{0.5, 0.5}], Automatic, None, Background -> 
               GrayLevel[1]]}]}, {0.03384563758389261, 0.8}}], 
         ArrowBox[{2, 4}]},
        "\"2\[Rule]4\""],
       Annotation[#, "2\[Rule]4", "Tooltip"]& ]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 2.}, {-1., 1.}, {0., 1.}, {1., 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->451858819]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "EdgeRenderingFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->65693485],

Cell["Change the setback used for arrows: ", "ExampleText",
 CellID->77945437],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0", "\[Rule]", "3"}], ",", 
     RowBox[{"0", "\[Rule]", "0"}], ",", 
     RowBox[{"0", "\[Rule]", "4"}], ",", 
     RowBox[{"0", "\[Rule]", "6"}], ",", 
     RowBox[{"0", "\[Rule]", "9"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}], ",", 
     RowBox[{"4", "\[Rule]", "6"}], ",", 
     RowBox[{"4", "\[Rule]", "9"}]}], "}"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Arrow", "[", 
       RowBox[{"#1", ",", "0.1"}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->264703168],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{{ArrowBox[{{0., 2.}, {1., 1.}}, 0.1], 
      ArrowBox[{{0., 2.}, {-1., 1.}}, 0.1], 
      ArrowBox[{{0., 2.}, {-0.09928677930370411, 
       1.950356610348148}, {-0.21936933943703868`, 
       1.8903153302814806`}, {-0.3602476804000037, 
       1.8198761597999982`}, {-0.5219218021925992, 
       1.7390390989037003`}, {-0.7043917048148252, 
       1.6478041475925873`}, {-0.9076573882666816, 
       1.5461713058666593`}, {-1.1317188525481685`, 
       1.4341405737259159`}, {-1.3765760976592858`, 
       1.311711951170357}, {-1.6422291236000337`, 
       1.1788854381999831`}, {-1.7173168384000266`, 
       1.1364033091950485`}, {-1.7835707044000204`, 
       1.0884615613802366`}, {-1.840990721600015, 
       1.035060194755548}, {-1.8895768900000105`, 
       0.9761992093209825}, {-1.9293292096000068`, 
       0.9118786050765398}, {-1.9602476804000037`, 
       0.8420983820222203}, {-1.9823323024000017`, 
       0.7668585401580238}, {-1.9955830756000004`, 0.6861590794839504}, {-2., 
       0.6}, {-2., 0.5135802469135802}, {-2., 0.43209876543209874`}, {-2., 
       0.3555555555555555}, {-2., 0.2839506172839506}, {-2., 
       0.21728395061728392`}, {-2., 0.15555555555555553`}, {-2., 
       0.09876543209876541}, {-2., 0.04691358024691357}, {-2., 0.}}, 0.1], 
      ArrowBox[{{0., 2.}, {0., 1.9530864197530864`}, {0., 
       1.9012345679012346`}, {0., 1.8444444444444446`}, {0., 
       1.782716049382716}, {0., 1.7160493827160495`}, {0., 
       1.6444444444444444`}, {0., 1.567901234567901}, {0., 
       1.4864197530864196`}, {0., 1.4}, {0., 1.3111111111111111`}, {0., 
       1.222222222222222}, {0., 1.1333333333333333`}, {0., 
       1.0444444444444445`}, {0., 0.9555555555555555}, {0., 
       0.8666666666666667}, {0., 0.7777777777777778}, {0., 
       0.6888888888888889}, {0., 0.6}, {0., 0.5135802469135802}, {0., 
       0.43209876543209874`}, {0., 0.3555555555555555}, {0., 
       0.2839506172839506}, {0., 0.21728395061728392`}, {0., 
       0.15555555555555553`}, {0., 0.09876543209876541}, {0., 
       0.04691358024691357}, {0., 0.}}, 0.1], 
      ArrowBox[{{0., 2.}, {-0.00531331459137388, 
       2.000948117474736}, {-0.09771917290361028, 
       2.031433991524679}, {-0.17787194615874247`, 
       2.0866043105968166`}, {-0.239342469537288, 
       2.162033787080336}, {-0.2772001073258379, 
       2.251672118323622}, {-0.2884082460282613, 
       2.34832928977943}, {-0.2720678653348288, 
       2.4442522960177864`}, {-0.22948964978488584`, 
       2.531747020016395}, {-0.16408885694685985`, 
       2.6037953889303944`}, {-0.08111137488431298, 2.6546183034234634`}, {
       0.01278705778236207, 2.6801391872199156`}, {0.11007471787767953`, 
       2.6783109749269665`}, {0.20294802760572658`, 2.64928030998163}, {
       0.28395749031999473`, 2.5953757821777836`}, {0.3466052249544112, 
       2.520921148257618}, {0.3858661700522773, 2.4318885174022262`}, {
       0.39859115089696323`, 2.335419320092865}, {0.3837594791722352, 
       2.2392514840931916`}, {0.3425608237840363, 2.1510987645593365`}, {
       0.27829978587185145`, 2.0780320130682592`}, {0.19613083217999885`, 
       2.0259120148315333`}, {0.10264484814980684`, 1.998919387006203}, {
       0.0053404738810816565`, 1.9992192456094968`}, {0., 2.}}, 0.1], 
      ArrowBox[{{1., 1.}, {1., 0.}}, 0.1], 
      ArrowBox[{{-1., 1.}, {-2., 0.}}, 0.1], 
      ArrowBox[{{-1., 1.}, {0., 0.}}, 0.1]}, 
     GraphicsComplexBox[CompressedData["
1:eJxt0gtMU1cYB/DbFzK7QIiOhMdgmhmMqUVhOMfDc8zGKzCdMOfYZFwa1Nip
bGtBslcoVCcwIaImwp52KwM7mQLiCrqDlGJROgqy0oloBWFFCpTOVmkvdG0X
j9vdvnw3J7+b+53ce/53hSA/YxeTIIhM9+VZaQX/XiyAtqJ/m+j47+g/Cz/3
uDr+/74FrL7p+8uwUIkilf4rG15wgdiU13alLe9FHzvPpLZvWgRKzfup6X5D
aLK7v3BD2AKIrJ7NOtlsROIQaUPwDSc4HPKoiCyfQGHzV+7uyXYAQfGA5DPu
NDLlVISHXX4EckkQeyjEinRbjYIEqx1kHvi0XuxjR3pNh0JNPQC+wjpudZID
Udd4jtZbVlCp/nLjig+dKG2uOP4C3wo2L3kzX1JGobr0Y4o3hHPguUjDT03i
BeQ/kp38RZUF8BKedbTELSJuojbcJ2EW5K2P2HLk9iIKiN2xNJQ/DTRcu4KX
7UJRNVlbiqz3QVZv2TLZRRfaLxicCi43gUDRqNQ07UKqk1dHWbZxfL7R3hrD
/vp8xRDIN2Jr/StOSH4Yxg7cd8XdeuygorYYwBvAbthjHrX1Xcc+vmnS3Srs
O5N66lyKEtuxprfMj1OP86r3voALW3AsyiJ+dxGbbyhZayhZwOaKZC8zDlPY
jlzPgPOJv9/qaeyn40dqwwPnsddFxC4nNQ+xd3vLji33jj/AHttY6e4/sVd6
y4qdy20lua1P/j/v5x+fwb7U7qkp7Jc8242ZsD3TJHcCm5YPQcuHoOVD0PIh
aPkQtHwIWj4ELR/icT7f2kQ+QlUB6szhBc4xCJjI0ynC2UpE1pkLSUjAz3fo
lpR0daPrcm1N9nkCSvNrI7plv6KU4c53DGkMeI+8KZVf7kc/h5kV+1hMWPzd
qlvJBQOotP32CNnDhBds89ur9vaj2aODqwaPsuCPO9Nb7+doUWjb+An2ZjZU
q0ODRgg1YoqTz1YPsmFqdKHfRVUL6jqSd6g+ngP3MiaGgtaVg4zmAzrzexxo
VOzeNrz2EoiSzbzK38+B7VlnP4h29ICDhUuNyvUcuCHu1FM73eciS7xGvq5i
Q3mGqPEqXw+En1AthjVs2HQQcnybDOCjZyofSsQsuMyWVyAt+R3U2gMyLY1M
eErz/FRplQH41nzVSE0y4Lmuzjip+Tdwmrr7iiiGASlh8x8Nff2g6i0J6PuG
gLny+TO64B5ARHe+HRBDwBaWqWcmqQ2Elq4er3a6wIvbT5ffu1MAkm7ot2kp
F/gLVJLo1Q==
      "], 
      {RGBColor[0, 0, 0.7], 
       TagBox[
        TooltipBox[PointBox[1],
         "0"],
        Annotation[#, 0, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[2],
         "3"],
        Annotation[#, 3, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[3],
         "4"],
        Annotation[#, 4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[4],
         "6"],
        Annotation[#, 6, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[5],
         "9"],
        Annotation[#, 9, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[6],
         "5"],
        Annotation[#, 5, "Tooltip"]& ]}]},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 2.}, {1., 1.}, {-1., 1.}, {-2., 0.}, {0., 
     0.}, {1., 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 161},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11066279]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8083945],

Cell["Draw self-loops as red arrows and otherwise gray: ", "ExampleText",
 CellID->162176399],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0", "\[Rule]", "3"}], ",", 
     RowBox[{"0", "\[Rule]", "0"}], ",", 
     RowBox[{"0", "\[Rule]", "4"}], ",", 
     RowBox[{"0", "\[Rule]", "6"}], ",", 
     RowBox[{"0", "\[Rule]", "9"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}], ",", 
     RowBox[{"4", "\[Rule]", "6"}], ",", 
     RowBox[{"4", "\[Rule]", "9"}]}], "}"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"If", " ", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"First", "[", "#2", "]"}], "\[Equal]", 
         RowBox[{"Last", "[", "#2", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"Red", ",", " ", 
          RowBox[{"Arrow", "[", "#1", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0.5", "]"}], ",", " ", 
          RowBox[{"Arrow", "[", "#1", "]"}]}], "}"}]}], "]"}], "&"}], 
     ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1956840094],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{{
      {GrayLevel[0.5], ArrowBox[{{0., 2.}, {1., 1.}}]}, 
      {GrayLevel[0.5], ArrowBox[{{0., 2.}, {-1., 1.}}]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{0., 2.}, {-0.09928677930370411, 
        1.950356610348148}, {-0.21936933943703868`, 
        1.8903153302814806`}, {-0.3602476804000037, 
        1.8198761597999982`}, {-0.5219218021925992, 
        1.7390390989037003`}, {-0.7043917048148252, 
        1.6478041475925873`}, {-0.9076573882666816, 
        1.5461713058666593`}, {-1.1317188525481685`, 
        1.4341405737259159`}, {-1.3765760976592858`, 
        1.311711951170357}, {-1.6422291236000337`, 
        1.1788854381999831`}, {-1.7173168384000266`, 
        1.1364033091950485`}, {-1.7835707044000204`, 
        1.0884615613802366`}, {-1.840990721600015, 
        1.035060194755548}, {-1.8895768900000105`, 
        0.9761992093209825}, {-1.9293292096000068`, 
        0.9118786050765398}, {-1.9602476804000037`, 
        0.8420983820222203}, {-1.9823323024000017`, 
        0.7668585401580238}, {-1.9955830756000004`, 0.6861590794839504}, {-2.,
         0.6}, {-2., 0.5135802469135802}, {-2., 0.43209876543209874`}, {-2., 
        0.3555555555555555}, {-2., 0.2839506172839506}, {-2., 
        0.21728395061728392`}, {-2., 0.15555555555555553`}, {-2., 
        0.09876543209876541}, {-2., 0.04691358024691357}, {-2., 0.}}]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{0., 2.}, {0., 1.9530864197530864`}, {0., 
        1.9012345679012346`}, {0., 1.8444444444444446`}, {0., 
        1.782716049382716}, {0., 1.7160493827160495`}, {0., 
        1.6444444444444444`}, {0., 1.567901234567901}, {0., 
        1.4864197530864196`}, {0., 1.4}, {0., 1.3111111111111111`}, {0., 
        1.222222222222222}, {0., 1.1333333333333333`}, {0., 
        1.0444444444444445`}, {0., 0.9555555555555555}, {0., 
        0.8666666666666667}, {0., 0.7777777777777778}, {0., 
        0.6888888888888889}, {0., 0.6}, {0., 0.5135802469135802}, {0., 
        0.43209876543209874`}, {0., 0.3555555555555555}, {0., 
        0.2839506172839506}, {0., 0.21728395061728392`}, {0., 
        0.15555555555555553`}, {0., 0.09876543209876541}, {0., 
        0.04691358024691357}, {0., 0.}}]}, 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{0., 2.}, {-0.005313314591455049, 
        2.0009481174742594`}, {-0.09771917290375644, 
        2.0314339915242243`}, {-0.17787194615894503`, 
        2.0866043105964005`}, {-0.2393424695375338, 
        2.1620337870799733`}, {-0.27720010732611033`, 
        2.2516721183233224`}, {-0.28840824602854165`, 
        2.3483292897791976`}, {-0.27206786533509764`, 
        2.4442522960176216`}, {-0.22948964978512473`, 
        2.531747020016292}, {-0.16408885694705272`, 
        2.603795388930342}, {-0.08111137488444747, 2.654618303423447}, {
        0.012787057782293634`, 2.680139187219917}, {0.11007471787767954`, 
        2.6783109749269665`}, {0.20294802760579192`, 2.6492803099816102`}, {
        0.2839574903201171, 2.595375782177725}, {0.3466052249545776, 
        2.520921148257507}, {0.3858661700524713, 2.431888517402053}, {
        0.3985911508971662, 2.335419320092624}, {0.38375947917242775`, 
        2.239251484092883}, {0.34256082378419983`, 2.1510987645589656`}, {
        0.2782997858719698, 2.078032013067837}, {0.19613083218005942`, 
        2.0259120148310745`}, {0.10264484814980163`, 1.9989193870057251`}, {
        0.0053404738810079845`, 1.9992192456090192`}, {0., 2.}}]}, 
      {GrayLevel[0.5], ArrowBox[{{1., 1.}, {1., 0.}}]}, 
      {GrayLevel[0.5], ArrowBox[{{-1., 1.}, {-2., 0.}}]}, 
      {GrayLevel[0.5], ArrowBox[{{-1., 1.}, {0., 0.}}]}}, 
     GraphicsComplexBox[CompressedData["
1:eJxt0gtMU1cYB/DTF6JdYETHwmMwiQRjalGUxVXwHOMUHQxlDLeOgZdOJDIR
t7aEOGIsK05AIVRdpntomunABjaFQepjB+lAYHQUxkonIgWGFihYOh7SFrq2
i8ftbl++m5Pfzf1O7j3/u1KU+2YmEwCQ7LrcK63Q34sF0lb8b4PG/47+s8hz
T6vx/+9b4Op73j/2ZatxpNo3rGqjEwp27smMX9GBC+xXd93csgjVrR/uSvDp
xaMtXXmvhCzASMVj4blaI5YEyasCf7XDE0FP8qmShzhk/s5gVpoNio53yz7l
TmDTvtLQkNtPYAYFBUVBVqzbbRTFWmdh8uFjlRKvWaxvbVQ1O6ahd/YVrmKH
DTvaebb6+1ZY1vzlppVH7Th+6njMD3wr3LrknVxZsQNfSahQ7c2egi9HGr67
LlnAvv1pcV+UWyAv9iVb3eZFzN2uDfWKfQz3r49IPPlgEfsJ3l4WzJ+ArdxZ
FS/NiaPOCxPzrWNQ2FG8XNngxDminvHAEhP0Fw/JTRNOrDl3d4g1M0LOd4On
hom/vlbaC3ONxFrf0rOyb/uI/Q/dcbWeOCD/RjTkdRNXZZmHZjp/Jj6zZdTV
GuKBUb3j+51qYtuajmIfTiXJq9LzAk5iUUWURfLBIjHfULjWULhAzBUrtzFO
OIhtGe4B+zN/s9vdxM/F9F8I9Z8nXhchWEG1zhEf8NQs8WXP+DTx8KYyV/9J
HOYpK3EGt57i1j/7/zyff2aS+NZNd40Tv+rebthE7J6muA+JafkAWj6Alg+g
5QNo+QBaPoCWD6DlA57mw39f6pWtkeKKVJ7/FAOggyk6VShbjSmlOY9CAPlI
dEsKf2rBYUrt+bRrAAUrLkS0KH/BLxqa0g3xDPS85J788u0u/EKwWXWIxUSC
hvD7cdJunK9+0E+1MdElb1tK+cEuXHCqJ7znNAvFH0uoH9unxRvVI2fZW9lo
zBgc0A+a8SlxXLWih41WCfN8GjR1+OLJ/UWVMRyUmDXSG7CuBKbUHtaZj3DQ
oOpAUt/aWzBKOfkGP4eDJkTVH22wtcHX85YZ1es5qHvb50vfc51LyPZ26i0N
G72bLq65y9fDIwWOOsMaNhIWIY73dQOcWV42J5OwUCorUyov/B1+PO2XbKlh
onD9qvFPyg0w6bOvahyjDBSla9osN/8G0+cHXxNHM9Aece2jqs4uaNgrg50X
AXpUPX9VF9gG5/hNqX7RAMUwTW2TO27AuqOrRxR2J8xZeqnkjwEpHGjXJ2kd
TvgX6l7kRA==
      "], 
      {RGBColor[0, 0, 0.7], 
       TagBox[
        TooltipBox[PointBox[1],
         "0"],
        Annotation[#, 0, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[2],
         "3"],
        Annotation[#, 3, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[3],
         "4"],
        Annotation[#, 4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[4],
         "6"],
        Annotation[#, 6, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[5],
         "9"],
        Annotation[#, 9, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[6],
         "5"],
        Annotation[#, 5, "Tooltip"]& ]}]}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 2.}, {1., 1.}, {-1., 1.}, {-2., 0.}, {0., 
     0.}, {1., 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 161},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->421269745]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->420690581],

Cell["Use a custom arrow head: ", "ExampleText",
 CellID->293080936],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h", "=", 
  RowBox[{"Graphics", "[", 
   RowBox[{"Line", "[", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}]}], "}"}]}], "}"}], "}"}], "]"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->874236904],

Cell[BoxData[
 GraphicsBox[
  LineBox[NCache[{{{-1, Rational[1, 2]}, {0, 
      0}, {-1, Rational[-1, 2]}}}, {{{-1, 0.5}, {0, 0}, {-1, -0.5}}}]],
  ImageSize->{39., Automatic}]], "Output",
 ImageSize->{43, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->399529566]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0", "\[Rule]", "3"}], ",", 
     RowBox[{"0", "\[Rule]", "0"}], ",", 
     RowBox[{"0", "\[Rule]", "4"}], ",", 
     RowBox[{"0", "\[Rule]", "6"}], ",", 
     RowBox[{"0", "\[Rule]", "9"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}], ",", 
     RowBox[{"4", "\[Rule]", "6"}], ",", 
     RowBox[{"4", "\[Rule]", "9"}]}], "}"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Arrowheads", "[", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"Automatic", ",", "Automatic", ",", "h"}], "}"}], "}"}], 
         "]"}], ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"#1", ",", "0.1"}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->183329943],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{{
      {Arrowheads[{{Automatic, Automatic, 
          GraphicsBox[
           LineBox[
            NCache[{{{-1, 
                Rational[1, 2]}, {0, 0}, {-1, 
                Rational[-1, 2]}}}, {{{-1, 0.5}, {0, 0}, {-1, -0.5}}}]]]}}], 
       ArrowBox[{{0., 2.}, {1., 1.}}, 0.1]}, 
      {Arrowheads[{{Automatic, Automatic, 
          GraphicsBox[
           LineBox[
            NCache[{{{-1, 
                Rational[1, 2]}, {0, 0}, {-1, 
                Rational[-1, 2]}}}, {{{-1, 0.5}, {0, 0}, {-1, -0.5}}}]]]}}], 
       ArrowBox[{{0., 2.}, {-1., 1.}}, 0.1]}, 
      {Arrowheads[{{Automatic, Automatic, 
          GraphicsBox[
           LineBox[
            NCache[{{{-1, 
                Rational[1, 2]}, {0, 0}, {-1, 
                Rational[-1, 2]}}}, {{{-1, 0.5}, {0, 0}, {-1, -0.5}}}]]]}}], 
       ArrowBox[{{0., 2.}, {-0.09928677930370411, 
        1.950356610348148}, {-0.21936933943703868`, 
        1.8903153302814806`}, {-0.3602476804000037, 
        1.8198761597999982`}, {-0.5219218021925992, 
        1.7390390989037003`}, {-0.7043917048148252, 
        1.6478041475925873`}, {-0.9076573882666816, 
        1.5461713058666593`}, {-1.1317188525481685`, 
        1.4341405737259159`}, {-1.3765760976592858`, 
        1.311711951170357}, {-1.6422291236000337`, 
        1.1788854381999831`}, {-1.7173168384000266`, 
        1.1364033091950485`}, {-1.7835707044000204`, 
        1.0884615613802366`}, {-1.840990721600015, 
        1.035060194755548}, {-1.8895768900000105`, 
        0.9761992093209825}, {-1.9293292096000068`, 
        0.9118786050765398}, {-1.9602476804000037`, 
        0.8420983820222203}, {-1.9823323024000017`, 
        0.7668585401580238}, {-1.9955830756000004`, 0.6861590794839504}, {-2.,
         0.6}, {-2., 0.5135802469135802}, {-2., 0.43209876543209874`}, {-2., 
        0.3555555555555555}, {-2., 0.2839506172839506}, {-2., 
        0.21728395061728392`}, {-2., 0.15555555555555553`}, {-2., 
        0.09876543209876541}, {-2., 0.04691358024691357}, {-2., 0.}}, 0.1]}, 
      {Arrowheads[{{Automatic, Automatic, 
          GraphicsBox[
           LineBox[
            NCache[{{{-1, 
                Rational[1, 2]}, {0, 0}, {-1, 
                Rational[-1, 2]}}}, {{{-1, 0.5}, {0, 0}, {-1, -0.5}}}]]]}}], 
       ArrowBox[{{0., 2.}, {0., 1.9530864197530864`}, {0., 
        1.9012345679012346`}, {0., 1.8444444444444446`}, {0., 
        1.782716049382716}, {0., 1.7160493827160495`}, {0., 
        1.6444444444444444`}, {0., 1.567901234567901}, {0., 
        1.4864197530864196`}, {0., 1.4}, {0., 1.3111111111111111`}, {0., 
        1.222222222222222}, {0., 1.1333333333333333`}, {0., 
        1.0444444444444445`}, {0., 0.9555555555555555}, {0., 
        0.8666666666666667}, {0., 0.7777777777777778}, {0., 
        0.6888888888888889}, {0., 0.6}, {0., 0.5135802469135802}, {0., 
        0.43209876543209874`}, {0., 0.3555555555555555}, {0., 
        0.2839506172839506}, {0., 0.21728395061728392`}, {0., 
        0.15555555555555553`}, {0., 0.09876543209876541}, {0., 
        0.04691358024691357}, {0., 0.}}, 0.1]}, 
      {Arrowheads[{{Automatic, Automatic, 
          GraphicsBox[
           LineBox[
            NCache[{{{-1, 
                Rational[1, 2]}, {0, 0}, {-1, 
                Rational[-1, 2]}}}, {{{-1, 0.5}, {0, 0}, {-1, -0.5}}}]]]}}], 
       ArrowBox[{{0., 2.}, {-0.00531331459137388, 
        2.000948117474736}, {-0.09771917290361028, 
        2.031433991524679}, {-0.17787194615874247`, 
        2.0866043105968166`}, {-0.239342469537288, 
        2.162033787080336}, {-0.2772001073258379, 
        2.251672118323622}, {-0.2884082460282613, 
        2.34832928977943}, {-0.2720678653348288, 
        2.4442522960177864`}, {-0.22948964978488584`, 
        2.531747020016395}, {-0.16408885694685985`, 
        2.6037953889303944`}, {-0.08111137488431298, 2.6546183034234634`}, {
        0.01278705778236207, 2.6801391872199156`}, {0.11007471787767953`, 
        2.6783109749269665`}, {0.20294802760572658`, 2.64928030998163}, {
        0.28395749031999473`, 2.5953757821777836`}, {0.3466052249544112, 
        2.520921148257618}, {0.3858661700522773, 2.4318885174022262`}, {
        0.39859115089696323`, 2.335419320092865}, {0.3837594791722352, 
        2.2392514840931916`}, {0.3425608237840363, 2.1510987645593365`}, {
        0.27829978587185145`, 2.0780320130682592`}, {0.19613083217999885`, 
        2.0259120148315333`}, {0.10264484814980684`, 1.998919387006203}, {
        0.0053404738810816565`, 1.9992192456094968`}, {0., 2.}}, 0.1]}, 
      {Arrowheads[{{Automatic, Automatic, 
          GraphicsBox[
           LineBox[
            NCache[{{{-1, 
                Rational[1, 2]}, {0, 0}, {-1, 
                Rational[-1, 2]}}}, {{{-1, 0.5}, {0, 0}, {-1, -0.5}}}]]]}}], 
       ArrowBox[{{1., 1.}, {1., 0.}}, 0.1]}, 
      {Arrowheads[{{Automatic, Automatic, 
          GraphicsBox[
           LineBox[
            NCache[{{{-1, 
                Rational[1, 2]}, {0, 0}, {-1, 
                Rational[-1, 2]}}}, {{{-1, 0.5}, {0, 0}, {-1, -0.5}}}]]]}}], 
       ArrowBox[{{-1., 1.}, {-2., 0.}}, 0.1]}, 
      {Arrowheads[{{Automatic, Automatic, 
          GraphicsBox[
           LineBox[
            NCache[{{{-1, 
                Rational[1, 2]}, {0, 0}, {-1, 
                Rational[-1, 2]}}}, {{{-1, 0.5}, {0, 0}, {-1, -0.5}}}]]]}}], 
       ArrowBox[{{-1., 1.}, {0., 0.}}, 0.1]}}, 
     GraphicsComplexBox[CompressedData["
1:eJxt0gtMU1cYB/DbFzK7QIiOhMdgmhmMqUVhOMfDc8zGKzCdMOfYZFwa1Nip
bGtBslcoVCcwIaImwp52KwM7mQLiCrqDlGJROgqy0oloBWFFCpTOVmkvdG0X
j9vdvnw3J7+b+53ce/53hSA/YxeTIIhM9+VZaQX/XiyAtqJ/m+j47+g/Cz/3
uDr+/74FrL7p+8uwUIkilf4rG15wgdiU13alLe9FHzvPpLZvWgRKzfup6X5D
aLK7v3BD2AKIrJ7NOtlsROIQaUPwDSc4HPKoiCyfQGHzV+7uyXYAQfGA5DPu
NDLlVISHXX4EckkQeyjEinRbjYIEqx1kHvi0XuxjR3pNh0JNPQC+wjpudZID
Udd4jtZbVlCp/nLjig+dKG2uOP4C3wo2L3kzX1JGobr0Y4o3hHPguUjDT03i
BeQ/kp38RZUF8BKedbTELSJuojbcJ2EW5K2P2HLk9iIKiN2xNJQ/DTRcu4KX
7UJRNVlbiqz3QVZv2TLZRRfaLxicCi43gUDRqNQ07UKqk1dHWbZxfL7R3hrD
/vp8xRDIN2Jr/StOSH4Yxg7cd8XdeuygorYYwBvAbthjHrX1Xcc+vmnS3Srs
O5N66lyKEtuxprfMj1OP86r3voALW3AsyiJ+dxGbbyhZayhZwOaKZC8zDlPY
jlzPgPOJv9/qaeyn40dqwwPnsddFxC4nNQ+xd3vLji33jj/AHttY6e4/sVd6
y4qdy20lua1P/j/v5x+fwb7U7qkp7Jc8242ZsD3TJHcCm5YPQcuHoOVD0PIh
aPkQtHwIWj4ELR/icT7f2kQ+QlUB6szhBc4xCJjI0ynC2UpE1pkLSUjAz3fo
lpR0daPrcm1N9nkCSvNrI7plv6KU4c53DGkMeI+8KZVf7kc/h5kV+1hMWPzd
qlvJBQOotP32CNnDhBds89ur9vaj2aODqwaPsuCPO9Nb7+doUWjb+An2ZjZU
q0ODRgg1YoqTz1YPsmFqdKHfRVUL6jqSd6g+ngP3MiaGgtaVg4zmAzrzexxo
VOzeNrz2EoiSzbzK38+B7VlnP4h29ICDhUuNyvUcuCHu1FM73eciS7xGvq5i
Q3mGqPEqXw+En1AthjVs2HQQcnybDOCjZyofSsQsuMyWVyAt+R3U2gMyLY1M
eErz/FRplQH41nzVSE0y4Lmuzjip+Tdwmrr7iiiGASlh8x8Nff2g6i0J6PuG
gLny+TO64B5ARHe+HRBDwBaWqWcmqQ2Elq4er3a6wIvbT5ffu1MAkm7ot2kp
F/gLVJLo1Q==
      "], 
      {RGBColor[0, 0, 0.7], 
       TagBox[
        TooltipBox[PointBox[1],
         "0"],
        Annotation[#, 0, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[2],
         "3"],
        Annotation[#, 3, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[3],
         "4"],
        Annotation[#, 4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[4],
         "6"],
        Annotation[#, 6, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[5],
         "9"],
        Annotation[#, 9, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[6],
         "5"],
        Annotation[#, 5, "Tooltip"]& ]}]},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 2.}, {1., 1.}, {-1., 1.}, {-2., 0.}, {0., 
     0.}, {1., 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 161},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->121783570]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->209288608],

Cell["Draws vertices only:", "ExampleText",
 CellID->26472224],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", "10", "}"}], ",", 
     RowBox[{"{", "10", "}"}]}], "]"}], ",", " ", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1020060192],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxVVQ9MlGUYfz0FvyV2h3zKHXecB2S0QF2KBlJ+b4LKH1kh0zQVzhMXDqy4
PLUi+eaahuNOENsxivkXb1gjaNMIivssARV02oRObMZQVArt2nJygtRzHe+f
2Ni3373v8z6/3/P8nveNsry7eqsKIbQX/v3f//9F4/8+LqEtgE0YvT16b2ek
WglgA0ZHf0ic0f6XFMBarLjzd7Q6wibWRYwmlUWUDaDAOUiD5V7DbRYvYDTf
plTq/56Ih323OjoeLBl3B6BXQvft57h1hA433pg95nMTPvLmY5m6hBBM+TSq
HlpWP5Yo34iGeVuv9ktkXcnMBn56hfCVMy05p+tnUj3yl3emu/sEhZ4/7Qjw
nUr3o1fMy049nML0F26zMr1ajLP09tRiA6b6PfNKzfIsTON7Dv3aWz+D8bU5
tqu/CcY0X82bjtRiDY2Xh17reqs6iMXX5DoXFIxQPahiqCQm+3uJ5uuzOm7a
ht10f8sRA6s/nNe2qGVTZ4xC+mFOieUwxDvnchj0zPTceDLHSPUq4udxUgrR
C/UVLYOsPtDfT1o4DOe16DpZP4HPve11nc4RN623S8P1A3QL69pd53U0Xj67
BtbDWf01u6uYPtgfvOEQw5Cvdtf7rB/AZ1LZ0GcHTBP6BYwj3pm2+b0oTNaV
gaoVxxOjWX3coRVvOMh+8IfH1/mhnfQTvkNJbabJpH/Qr/LW8tRiLT0fJQ1y
WINxUZadYRErdRdXnm3U0PNRWwP4dwo7X55awfoJ56E/mxiGuB3h3PwBX9uK
+wzD/FlTy5l/IP70UnXa5OmUD9pTC34QmN667zh/w+/N5++w86B+GV9x8wvr
e1+uvDJG/IEwXmNI77U9T+PNH8WDf2JpPBqP4zDor/aovygl+8Ffll3Jw+Xk
PPCDT32p5JxBIfVF1d3cfQA8CtI4PwGfKxkXGIZ89VoOgx8qDJWsflDvk7kn
F+Xdov7D2a0O9wjJB3pcRS9dWG+iehRfDPCPonr6fV3dtS6yLmK8Ow/8OZvq
QRtnHWR+BL53u7l5BL6jscnsvgS+WxKTGIb65HeFh/xG/AvxHlWuvYDcT8Bn
sNLK5gHiE08oo/90sPvTE8LdxwKWf4nn+gv6Vn2bVzoegQPQK5nm3l01/zrx
O8T3XP4j6FE0pvHeuOMpF2MwyWdemgXz8hwmfI+u19TkpZN10H9s2Hv9AzJf
4OeBIsf+AyQfzEvDnv1iURjNj1fuazQ2kfmA/IXeBGMzmTeY1weLRYfRSPPj
p+mQn/D1z9Pi5T9d1dP8yqfbIm/nhNP88uOfM7Q95D6B96Tk0brxZ0k/EZav
FTddKiT+E3C/0+/fObS+pmde5LCITcsXcn4A3huCny4TyPvj15PwunpjKNWD
k6tgHkVWz4xmDsP9kz/GYZjHoL7ItdWhjO/Htfu+3qSlfJWw+B9/30LuS6jP
Tj3nP5jXyMNhL5xRUT5I5ezTp5H3w1/fV3Vs/oFPu9WlSyHvnVeSW3O49xn2
dy/g3l+v9C+Vm/du
    "], {
     {RGBColor[0.5, 0., 0.]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 9.}, {-7.174776328611188*^-10, 
     8.}, {-3.889386951789561, 7.}, {1.110613080638359, 
     6.}, {-4.889386957787735, 5.}, {2.1106130669651293`, 
     4.}, {-3.8893869155097605`, 3.}, {1.256730796611862, 
     2.}, {-1.8893869175643658`, 1.}, {1.2567308006969142`, 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{154, 193},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->199672138]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MultiedgeStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->100942717],

Cell["Spread multiple edges by a specified scaled distance:", "ExampleText",
 CellID->1029865650],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"LayeredGraphPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0", "\[Rule]", "3"}], ",", 
       RowBox[{"0", "\[Rule]", "6"}], ",", 
       RowBox[{"0", "\[Rule]", "8"}], ",", 
       RowBox[{"0", "\[Rule]", "8"}], ",", 
       RowBox[{"1", "\[Rule]", "6"}], ",", 
       RowBox[{"6", "\[Rule]", "8"}], ",", 
       RowBox[{"8", "\[Rule]", "9"}]}], "}"}], ",", 
     RowBox[{"MultiedgeStyle", "\[Rule]", "s"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "10."}], ",", 
       RowBox[{"1", "/", "5."}], ",", 
       RowBox[{"1", "/", "4."}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->40554687],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0., 3.}, {-1., 2.}, {1., 2.}, {1., 1.}, {1., 3.}, {
      1., 0.}, {0., 2.}, {0.02063054595499122, 2.954881724744429}, {
      0.03875436575319789, 2.905014157356692}, {0.054371459394620014`, 
      2.8503972978367904`}, {0.06748182687925759, 2.791031146184723}, {
      0.07808546820711061, 2.72691570240049}, {0.08618238337817909, 
      2.658050966484092}, {0.091772572392463, 2.5844369384355286`}, {
      0.09485603524996238, 2.5060736182547996`}, {0.0954327719506772, 
      2.4229610059419056`}, {0.09817062534730354, 2.338883308173466}, {
      0.10773743829253749`, 2.257624731626101}, {0.12413321078637901`, 
      2.1791852762998105`}, {0.14735794282882814`, 2.1035649421945948`}, {
      0.17741163441988483`, 2.0307637293104532`}, {0.21429428555954913`, 
      1.960781637647387}, {0.258005896247821, 1.893618667205395}, {
      0.3085464664847005, 1.8292748179844778`}, {0.36591599627018756`, 
      1.7677500899846352`}, {0.47431310977301727`, 1.6588093967566946`}, {
      0.5732243894481899, 1.555777485447277}, {0.6626498352957054, 
      1.4586543560563827`}, {0.7425894473155639, 1.3674400085840113`}, {
      0.8130432255077652, 1.2821344430301629`}, {0.8740111698723095, 
      1.2027376593948376`}, {0.9254932804091968, 1.1292496576780353`}, {
      0.9674895571184269, 1.0616704378797561`}, {-0.02063054595499122, 
      2.951291114761744}, {-0.03875436575319789, 
      2.897454978445777}, {-0.054371459394620014`, 
      2.8384915910520987`}, {-0.06748182687925759, 
      2.7744009525807094`}, {-0.07808546820711061, 
      2.7051830630316087`}, {-0.08618238337817909, 
      2.630837922404797}, {-0.091772572392463, 
      2.551365530700274}, {-0.09485603524996238, 
      2.46676588791804}, {-0.0954327719506772, 
      2.3770389940580947`}, {-0.09118717481669318, 
      2.28623116354053}, {-0.07980363617009602, 
      2.1983887107854363`}, {-0.0612821560108857, 
      2.1135116357928148`}, {-0.03562273433906224, 
      2.0315999385626653`}, {-0.0028253711546256297`, 1.952653619094987}, {
      0.037109933542424124`, 1.8766726773897806`}, {0.08418317975208703, 
      1.8036571134470458`}, {0.13839436747436307`, 1.733606927266783}, {
      0.19974349670925226`, 1.6665221188489916`}, {0.31336846492678705`, 
      1.5534550645439487`}, {0.4208165384035701, 1.4501402705138058`}, {
      0.5220877171396012, 1.3565777367585625`}, {0.6171820011348806, 
      1.2727674632782193`}, {0.7060993903894082, 1.1987094500727757`}, {
      0.7888398849031838, 1.134403697142232}, {0.8654034846762076, 
      1.0798502044865883`}, {0.9357901897084797, 1.0350489721058442`}}, {
       {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028937842778793417`, 0.8}}], 
        ArrowBox[{1, 2}], ArrowBox[{1, 3}], 
        ArrowBox[{1, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22,
          23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 4}], 
        ArrowBox[{1, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 
         48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 4}], 
        ArrowBox[{3, 4}], ArrowBox[{4, 6}], ArrowBox[{5, 3}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "0"],
         Annotation[#, 0, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "8"],
         Annotation[#, 8, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "9"],
         Annotation[#, 9, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0., 3.}, {-1., 2.}, {1., 2.}, {1., 1.}, {1., 
       3.}, {1., 0.}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0., 3.}, {-1., 2.}, {1., 2.}, {1., 1.}, {1., 3.}, {
      1., 0.}, {0., 2.}, {0.04126109190998244, 2.956677029735771}, {
      0.07750873150639578, 2.90879374681215}, {0.10874291878924003`, 
      2.8563501512291363`}, {0.13496365375851518`, 2.7993462429867297`}, {
      0.15617093641422122`, 2.737782022084931}, {0.17236476675635817`, 
      2.67165748852374}, {0.183545144784926, 2.600972642303156}, {
      0.18971207049992475`, 2.5257274834231795`}, {0.1908655439013544, 
      2.4459220118838108`}, {0.19284903126948547`, 2.3652085414279598`}, {
      0.2015059988845884, 2.2872393857985367`}, {0.21683644674666322`, 
      2.212014544995541}, {0.23884037485570994`, 2.139534019018974}, {
      0.2675177832117286, 2.069797807868835}, {0.3028686718147191, 
      2.0028059115451233`}, {0.3448930406646815, 1.93855833004784}, {
      0.39359088976161577`, 1.8770550633769845`}, {0.448962219105522, 
      1.8182961115325569`}, {0.5547538059678789, 1.7114328628967266`}, {
      0.6494041011394932, 1.608554978877283}, {0.732913104620365, 
      1.5096624594742258`}, {0.805280816410494, 1.4147553046875552`}, {
      0.8665072365098805, 1.323833514517271}, {0.9165923649185242, 
      1.2368970889633735`}, {0.9555362016364255, 1.1539460280258624`}, {
      0.983338746663584, 1.074980331704738}, {-0.04126109190998244, 
      2.9494958097704016`}, {-0.07750873150639578, 
      2.893675388990319}, {-0.10874291878924003`, 
      2.832538737659753}, {-0.13496365375851518`, 
      2.7660858557787025`}, {-0.15617093641422122`, 
      2.6943167433471675`}, {-0.17236476675635817`, 
      2.6172314003651493`}, {-0.183545144784926, 
      2.5348298268326466`}, {-0.18971207049992475`, 
      2.4471120227496597`}, {-0.1908655439013544, 
      2.354077988116189}, {-0.18586654093092692`, 
      2.259904354647357}, {-0.17357603753035422`, 
      2.1687677540582855`}, {-0.15399403369963635`, 
      2.080668186348975}, {-0.12712052943877328`, 
      1.9956056515194254`}, {-0.09295552474776501, 
      1.9135801495696367`}, {-0.051499019626611554`, 
      1.834591680499609}, {-0.002751014075312909, 1.758640244309342}, {
      0.053288491906130935`, 1.685725840998836}, {0.11661949831771996`, 
      1.6158484705680909`}, {0.23286631644060857`, 1.5007307575284765`}, {
      0.34458977730172724`, 1.397285570788541}, {0.45178988090107597`, 
      1.3055129103482843`}, {0.5544666272386548, 1.2254127762077065`}, {
      0.6526200163144636, 1.1569851683668075`}, {0.7462500481285027, 
      1.1002300868255874`}, {0.8353567226807717, 1.055147531584046}, {
      0.9199400399712708, 1.0217375026421835`}}, {
       {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028937842778793417`, 0.8}}], 
        ArrowBox[{1, 2}], ArrowBox[{1, 3}], 
        ArrowBox[{1, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22,
          23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 4}], 
        ArrowBox[{1, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 
         48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 4}], 
        ArrowBox[{3, 4}], ArrowBox[{4, 6}], ArrowBox[{5, 3}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "0"],
         Annotation[#, 0, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "8"],
         Annotation[#, 8, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "9"],
         Annotation[#, 9, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0., 3.}, {-1., 2.}, {1., 2.}, {1., 1.}, {1., 
       3.}, {1., 0.}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0., 3.}, {-1., 2.}, {1., 2.}, {1., 1.}, {1., 3.}, {
      1., 0.}, {0., 2.}, {0.051576364887478056`, 2.9575746822314426`}, {
      0.09688591438299474, 2.910683541539879}, {0.13592864848655004`, 
      2.859326577925309}, {0.16870456719814397`, 2.803503791387733}, {
      0.19521367051777652`, 2.7432151819271517`}, {0.2154559584454477, 
      2.6784607495435635`}, {0.22943143098115754`, 2.60924049423697}, {
      0.23714008812490595`, 2.5355544160073693`}, {0.23858192987669302`, 
      2.4574025148547634`}, {0.24018810476306277`, 2.3783709223901943`}, {
      0.2483897613105592, 2.3020457702247055`}, {0.2631868995191824, 
      2.228427058358297}, {0.28457951938893233`, 2.1575147867909683`}, {
      0.31256762091980894`, 2.08930895552272}, {0.34715120411181233`, 
      2.023809564553552}, {0.38833026896494244`, 1.961016613883464}, {
      0.43610481547919927`, 1.900930103512456}, {0.4904748436545828, 
      1.8435500334405284`}, {0.5949658681444356, 1.737729513405961}, {
      0.6874876130769756, 1.6349321780066874`}, {0.768040078452203, 
      1.5351580272427077`}, {0.8366232642701176, 1.4384070611140218`}, {
      0.8932371705307195, 1.3446792796206297`}, {0.9378817972340087, 
      1.2539746827625315`}, {0.9705571443799852, 1.166293270539727}, {
      0.991263211968649, 1.0816350429522166`}, {-0.051576364887478056`, 
      2.94859815727473}, {-0.09688591438299474, 
      2.8917855942625903`}, {-0.13592864848655004`, 
      2.82956231096358}, {-0.16870456719814397`, 
      2.7619283073776986`}, {-0.19521367051777652`, 
      2.688883583504947}, {-0.2154559584454477, 
      2.6104281393453252`}, {-0.22943143098115754`, 
      2.526561974898833}, {-0.23714008812490595`, 
      2.43728509016547}, {-0.23858192987669302`, 
      2.3425974851452365`}, {-0.23320633429516052`, 
      2.2467407854994312`}, {-0.22046267943895032`, 
      2.1539566168893534`}, {-0.20035096530806237`, 
      2.064244979315003}, {-0.17287119190249672`, 
      1.977605872776379}, {-0.13802335922225334`, 
      1.8940392972734825`}, {-0.09580746726733225, 
      1.8135452528063132`}, {-0.04622351603773342, 1.7361237393748707`}, {
      0.01072849446654313, 1.6617747569791557`}, {0.0750485642454974, 
      1.5904983056191677`}, {0.19260818254204756`, 1.4743580631350335`}, {
      0.3064709917020853, 1.3708501505602892`}, {0.41663699172561053`, 
      1.279974567894935}, {0.5231061826126233, 1.2017313151389708`}, {
      0.6258785643631236, 1.1361203922923966`}, {0.7249541369771114, 
      1.0831417993552124`}, {0.8203329004545867, 1.0427955363274182`}, {
      0.9120148547955496, 1.0150816032090142`}}, {
       {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028937842778793417`, 0.8}}], 
        ArrowBox[{1, 2}], ArrowBox[{1, 3}], 
        ArrowBox[{1, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22,
          23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 4}], 
        ArrowBox[{1, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 
         48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 4}], 
        ArrowBox[{3, 4}], ArrowBox[{4, 6}], ArrowBox[{5, 3}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "0"],
         Annotation[#, 0, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "8"],
         Annotation[#, 8, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "9"],
         Annotation[#, 9, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0., 3.}, {-1., 2.}, {1., 2.}, {1., 1.}, {1., 
       3.}, {1., 0.}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]]}], "}"}]], "Output",
 ImageSize->{341, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->392360784]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PackingMethod",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->47225018],

Cell["Pack disconnected components using different methods:", "ExampleText",
 CellID->1302252890],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "@", 
  RowBox[{"Partition", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"LayeredGraphPlot", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"i", "\[Rule]", 
           RowBox[{"Mod", "[", 
            RowBox[{
             RowBox[{"i", "^", "2"}], ",", "42"}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "0", ",", "42"}], "}"}]}], "]"}], ",", 
        RowBox[{"PackingMethod", "\[Rule]", "m"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", "m"}], ",", 
        RowBox[{"BaselinePosition", "\[Rule]", "Top"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "150"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"m", ",", 
        RowBox[{"{", 
         RowBox[{
         "\"\<Layered\>\"", ",", "\"\<LayeredTop\>\"", ",", 
          "\"\<LayeredLeft\>\"", ",", "\"\<ClosestPacking\>\"", ",", 
          "\"\<ClosestPackingCenter\>\"", ",", "\"\<NestedGrid\>\""}], 
         "}"}]}], "}"}]}], "]"}], ",", "3"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->47617879],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[
      TagBox[GraphicsComplexBox[CompressedData["
1:eJxdWHk8lNsbnxlLtsKMZTbDbKVs2UJ1vSdbpE2LrFm6FBLVdaPbnqWFm6Qr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        "], {
         {RGBColor[0.5, 0., 0.], Arrowheads[{{0.016368405372095118`, 0.8}}], 
          ArrowBox[{1, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57,
            58, 59, 60, 61, 62, 63, 64, 65, 66, 1}], 
          ArrowBox[{2, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
            81, 82, 83, 84, 85, 86, 87, 88, 89, 2}], ArrowBox[{3, 4}], 
          ArrowBox[{4, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 
           103, 104, 105, 7}], ArrowBox[{5, 6}], 
          ArrowBox[{6, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 
           117, 118, 119, 120, 121, 15}], 
          ArrowBox[{7, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 
           133, 134, 135, 136, 137, 4}], ArrowBox[{8, 9}], 
          ArrowBox[{9, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 
           149, 150, 151, 152, 153, 18}], ArrowBox[{10, 11}], 
          ArrowBox[{11, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
            165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 11}], 
          ArrowBox[{12, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187,
            188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 12}], 
          ArrowBox[{13, 14}], 
          ArrowBox[{14, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210,
            211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 14}], 
          ArrowBox[{15, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233,
            234, 235, 236, 237, 238, 6}], ArrowBox[{16, 7}], 
          ArrowBox[{17, 18}], 
          ArrowBox[{18, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249,
            250, 251, 252, 253, 254, 9}], ArrowBox[{19, 20}], 
          ArrowBox[{20, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265,
            266, 267, 268, 269, 270, 26}], ArrowBox[{21, 2}], 
          ArrowBox[{22, 23}], 
          ArrowBox[{23, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281,
            282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 23}], 
          ArrowBox[{24, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304,
            305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 24}], 
          ArrowBox[{25, 18}], 
          ArrowBox[{26, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327,
            328, 329, 330, 331, 332, 20}], ArrowBox[{27, 9}], 
          ArrowBox[{28, 14}], 
          ArrowBox[{29, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343,
            344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 29}], 
          ArrowBox[{30, 9}], ArrowBox[{31, 26}], ArrowBox[{32, 4}], 
          ArrowBox[{33, 24}], ArrowBox[{34, 2}], ArrowBox[{35, 18}], 
          ArrowBox[{36, 7}], ArrowBox[{37, 15}], ArrowBox[{38, 14}], 
          ArrowBox[{39, 12}], ArrowBox[{40, 7}], ArrowBox[{41, 4}], 
          ArrowBox[{42, 2}], ArrowBox[{43, 1}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "0"],
           Annotation[#, 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "9"],
           Annotation[#, 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "16"],
           Annotation[#, 16, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[8],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[9],
            "25"],
           Annotation[#, 25, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[10],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[11],
            "36"],
           Annotation[#, 36, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[12],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[13],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[14],
            "22"],
           Annotation[#, 22, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[15],
            "39"],
           Annotation[#, 39, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[16],
            "10"],
           Annotation[#, 10, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[17],
            "11"],
           Annotation[#, 11, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[18],
            "37"],
           Annotation[#, 37, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[19],
            "12"],
           Annotation[#, 12, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[20],
            "18"],
           Annotation[#, 18, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[21],
            "13"],
           Annotation[#, 13, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[22],
            "14"],
           Annotation[#, 14, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[23],
            "28"],
           Annotation[#, 28, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[24],
            "15"],
           Annotation[#, 15, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[25],
            "17"],
           Annotation[#, 17, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[26],
            "30"],
           Annotation[#, 30, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[27],
            "19"],
           Annotation[#, 19, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[28],
            "20"],
           Annotation[#, 20, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[29],
            "21"],
           Annotation[#, 21, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[30],
            "23"],
           Annotation[#, 23, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[31],
            "24"],
           Annotation[#, 24, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[32],
            "26"],
           Annotation[#, 26, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[33],
            "27"],
           Annotation[#, 27, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[34],
            "29"],
           Annotation[#, 29, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[35],
            "31"],
           Annotation[#, 31, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[36],
            "32"],
           Annotation[#, 32, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[37],
            "33"],
           Annotation[#, 33, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[38],
            "34"],
           Annotation[#, 34, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[39],
            "35"],
           Annotation[#, 35, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[40],
            "38"],
           Annotation[#, 38, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[41],
            "40"],
           Annotation[#, 40, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[42],
            "41"],
           Annotation[#, 41, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[43],
            "42"],
           Annotation[#, 42, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{8.892522931834364, -4.112852864061183}, {
         6.339461814455547, -1.4464872714851824`}, {
         2.446487271485182, -0.4464872714851822}, {
         3.446487271485182, -1.4464872714851822`}, {
         9.392522931834364, -5.7792184566371825`}, {
         9.392522931834364, -6.7792184566371825`}, {
         2.446487271485182, -2.446487271485182}, {
         2.446487271485182, -3.3394618144555466`}, {
         3.446487271485182, -4.339461814455547}, {
         8.892522931834364, -0.4464872714851824}, {
         8.892522931834364, -1.4464872714851824`}, {
         1.1065738458936352`, -7.232436357425912}, {
         5.339461814455547, -3.3394618144555475`}, {
         6.339461814455547, -4.3394618144555475`}, {
         8.392522931834364, -7.7792184566371825`}, {
         0.4464872714851822, -1.4464872714851822`}, {
         0.4464872714851822, -4.339461814455547}, {
         2.446487271485182, -5.339461814455547}, {
         1.4464872714851822`, -8.785497474804728}, {
         1.4464872714851822`, -9.785497474804728}, {
         5.339461814455547, -0.4464872714851824}, {
         3.7018902078738787`, -6.232436357425912}, {
         3.7018902078738787`, -7.232436357425912}, {
         6.29720656985412, -7.232436357425912}, {
         1.4464872714851822`, -4.339461814455547}, {
         0.4464872714851822, -10.785497474804728`}, {
         3.446487271485182, -3.3394618144555466`}, {
         6.339461814455547, -3.3394618144555475`}, {
         5.946035660349182, -9.785497474804728}, {
         4.446487271485182, -3.3394618144555466`}, {
         0.4464872714851822, -9.785497474804728}, {
         3.446487271485182, -0.4464872714851822}, {
         6.29720656985412, -6.232436357425912}, {
         6.339461814455547, -0.4464872714851824}, {
         2.446487271485182, -4.339461814455547}, {
         1.4464872714851822`, -1.4464872714851822`}, {
         8.392522931834364, -6.7792184566371825`}, {
         7.339461814455547, -3.3394618144555475`}, {
         1.1065738458936352`, -6.232436357425912}, {
         2.446487271485182, -1.4464872714851822`}, {
         4.446487271485182, -0.4464872714851822}, {
         7.339461814455547, -0.4464872714851824}, {
         8.892522931834364, -3.112852864061183}}]& ],
      AspectRatio->Automatic,
      BaselinePosition->Top,
      FrameTicks->None,
      ImageSize->150,
      PlotLabel->FormBox["\"Layered\"", TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]], 
     GraphicsBox[
      TagBox[GraphicsComplexBox[CompressedData["
1:eJxdWHk8VN0bH8NkSTFkG7PeK5WthLTfg1KW8qbNmokoUtq0Fyotki0t0qIS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        "], {
         {RGBColor[0.5, 0., 0.], Arrowheads[{{0.016997985723869097`, 0.8}}], 
          ArrowBox[{1, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57,
            58, 59, 60, 61, 62, 63, 64, 65, 66, 1}], 
          ArrowBox[{2, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
            81, 82, 83, 84, 85, 86, 87, 88, 89, 2}], ArrowBox[{3, 4}], 
          ArrowBox[{4, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 
           103, 104, 105, 7}], ArrowBox[{5, 6}], 
          ArrowBox[{6, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 
           117, 118, 119, 120, 121, 15}], 
          ArrowBox[{7, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 
           133, 134, 135, 136, 137, 4}], ArrowBox[{8, 9}], 
          ArrowBox[{9, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 
           149, 150, 151, 152, 153, 18}], ArrowBox[{10, 11}], 
          ArrowBox[{11, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
            165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 11}], 
          ArrowBox[{12, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187,
            188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 12}], 
          ArrowBox[{13, 14}], 
          ArrowBox[{14, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210,
            211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 14}], 
          ArrowBox[{15, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233,
            234, 235, 236, 237, 238, 6}], ArrowBox[{16, 7}], 
          ArrowBox[{17, 18}], 
          ArrowBox[{18, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249,
            250, 251, 252, 253, 254, 9}], ArrowBox[{19, 20}], 
          ArrowBox[{20, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265,
            266, 267, 268, 269, 270, 26}], ArrowBox[{21, 2}], 
          ArrowBox[{22, 23}], 
          ArrowBox[{23, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281,
            282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 23}], 
          ArrowBox[{24, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304,
            305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 24}], 
          ArrowBox[{25, 18}], 
          ArrowBox[{26, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327,
            328, 329, 330, 331, 332, 20}], ArrowBox[{27, 9}], 
          ArrowBox[{28, 14}], 
          ArrowBox[{29, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343,
            344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 29}], 
          ArrowBox[{30, 9}], ArrowBox[{31, 26}], ArrowBox[{32, 4}], 
          ArrowBox[{33, 24}], ArrowBox[{34, 2}], ArrowBox[{35, 18}], 
          ArrowBox[{36, 7}], ArrowBox[{37, 15}], ArrowBox[{38, 14}], 
          ArrowBox[{39, 12}], ArrowBox[{40, 7}], ArrowBox[{41, 4}], 
          ArrowBox[{42, 2}], ArrowBox[{43, 1}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "0"],
           Annotation[#, 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "9"],
           Annotation[#, 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "16"],
           Annotation[#, 16, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[8],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[9],
            "25"],
           Annotation[#, 25, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[10],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[11],
            "36"],
           Annotation[#, 36, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[12],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[13],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[14],
            "22"],
           Annotation[#, 22, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[15],
            "39"],
           Annotation[#, 39, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[16],
            "10"],
           Annotation[#, 10, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[17],
            "11"],
           Annotation[#, 11, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[18],
            "37"],
           Annotation[#, 37, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[19],
            "12"],
           Annotation[#, 12, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[20],
            "18"],
           Annotation[#, 18, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[21],
            "13"],
           Annotation[#, 13, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[22],
            "14"],
           Annotation[#, 14, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[23],
            "28"],
           Annotation[#, 28, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[24],
            "15"],
           Annotation[#, 15, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[25],
            "17"],
           Annotation[#, 17, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[26],
            "30"],
           Annotation[#, 30, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[27],
            "19"],
           Annotation[#, 19, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[28],
            "20"],
           Annotation[#, 20, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[29],
            "21"],
           Annotation[#, 21, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[30],
            "23"],
           Annotation[#, 23, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[31],
            "24"],
           Annotation[#, 24, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[32],
            "26"],
           Annotation[#, 26, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[33],
            "27"],
           Annotation[#, 27, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[34],
            "29"],
           Annotation[#, 29, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[35],
            "31"],
           Annotation[#, 31, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[36],
            "32"],
           Annotation[#, 32, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[37],
            "33"],
           Annotation[#, 33, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[38],
            "34"],
           Annotation[#, 34, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[39],
            "35"],
           Annotation[#, 35, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[40],
            "38"],
           Annotation[#, 38, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[41],
            "40"],
           Annotation[#, 40, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[42],
            "41"],
           Annotation[#, 41, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[43],
            "42"],
           Annotation[#, 42, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{5.532869229468176, -7.232436357425911}, {
         1.4464872714851822`, -4.339461814455547}, {
         2.446487271485182, -0.4464872714851822}, {
         3.446487271485182, -1.4464872714851822`}, {
         8.085930346846993, -6.232436357425911}, {
         8.085930346846993, -7.232436357425911}, {
         2.446487271485182, -2.446487271485182}, {
         7.339461814455547, -0.4464872714851822}, {
         8.339461814455547, -1.4464872714851822`}, {
         3.3197215376809055`, -6.232436357425911}, {
         3.3197215376809055`, -7.232436357425911}, {
         6.892522931834364, -4.339461814455547}, {
         3.3394618144555466`, -3.3394618144555466`}, {
         4.339461814455547, -4.339461814455547}, {
         7.085930346846993, -8.232436357425911}, {
         0.4464872714851822, -1.4464872714851822`}, {
         5.339461814455547, -1.4464872714851822`}, {
         7.339461814455547, -2.446487271485182}, {
         9.978904889817358, -6.232436357425911}, {
         9.978904889817358, -7.232436357425911}, {
         0.4464872714851822, -3.3394618144555466`}, {
         9.105670623621634, -3.3394618144555466`}, {
         9.105670623621634, -4.339461814455547}, {
         1.1065738458936352`, -7.232436357425911}, {
         6.339461814455547, -1.4464872714851822`}, {
         8.978904889817358, -8.232436357425911}, {
         8.339461814455547, -0.4464872714851822}, {
         4.339461814455547, -3.3394618144555466`}, {
         1.1065738458936352`, -9.785497474804728}, {
         9.339461814455547, -0.4464872714851822}, {
         8.978904889817358, -7.232436357425911}, {
         3.446487271485182, -0.4464872714851822}, {
         1.1065738458936352`, -6.232436357425911}, {
         1.4464872714851822`, -3.3394618144555466`}, {
         7.339461814455547, -1.4464872714851822`}, {
         1.4464872714851822`, -1.4464872714851822`}, {
         7.085930346846993, -7.232436357425911}, {
         5.339461814455547, -3.3394618144555466`}, {
         6.892522931834364, -3.3394618144555466`}, {
         2.446487271485182, -1.4464872714851822`}, {
         4.446487271485182, -0.4464872714851822}, {
         2.446487271485182, -3.3394618144555466`}, {
         5.532869229468176, -6.232436357425911}}]& ],
      AspectRatio->Automatic,
      BaselinePosition->Top,
      FrameTicks->None,
      ImageSize->150,
      PlotLabel->FormBox["\"LayeredTop\"", TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]], 
     GraphicsBox[
      TagBox[GraphicsComplexBox[CompressedData["
1:eJxdmHk8lNsfx82gbCWDMYbhmXmG269FWSKKOUoilXTLbSdL6QqlW6kkFSXV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        "], {
         {RGBColor[0.5, 0., 0.], Arrowheads[{{0.016623792495888003`, 0.8}}], 
          ArrowBox[{1, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57,
            58, 59, 60, 61, 62, 63, 64, 65, 66, 1}], 
          ArrowBox[{2, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
            81, 82, 83, 84, 85, 86, 87, 88, 89, 2}], ArrowBox[{3, 4}], 
          ArrowBox[{4, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 
           103, 104, 105, 7}], ArrowBox[{5, 6}], 
          ArrowBox[{6, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 
           117, 118, 119, 120, 121, 15}], 
          ArrowBox[{7, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 
           133, 134, 135, 136, 137, 4}], ArrowBox[{8, 9}], 
          ArrowBox[{9, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 
           149, 150, 151, 152, 153, 18}], ArrowBox[{10, 11}], 
          ArrowBox[{11, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
            165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 11}], 
          ArrowBox[{12, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187,
            188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 12}], 
          ArrowBox[{13, 14}], 
          ArrowBox[{14, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210,
            211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 14}], 
          ArrowBox[{15, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233,
            234, 235, 236, 237, 238, 6}], ArrowBox[{16, 7}], 
          ArrowBox[{17, 18}], 
          ArrowBox[{18, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249,
            250, 251, 252, 253, 254, 9}], ArrowBox[{19, 20}], 
          ArrowBox[{20, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265,
            266, 267, 268, 269, 270, 26}], ArrowBox[{21, 2}], 
          ArrowBox[{22, 23}], 
          ArrowBox[{23, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281,
            282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 23}], 
          ArrowBox[{24, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304,
            305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 24}], 
          ArrowBox[{25, 18}], 
          ArrowBox[{26, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327,
            328, 329, 330, 331, 332, 20}], ArrowBox[{27, 9}], 
          ArrowBox[{28, 14}], 
          ArrowBox[{29, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343,
            344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 29}], 
          ArrowBox[{30, 9}], ArrowBox[{31, 26}], ArrowBox[{32, 4}], 
          ArrowBox[{33, 24}], ArrowBox[{34, 2}], ArrowBox[{35, 18}], 
          ArrowBox[{36, 7}], ArrowBox[{37, 15}], ArrowBox[{38, 14}], 
          ArrowBox[{39, 12}], ArrowBox[{40, 7}], ArrowBox[{41, 4}], 
          ArrowBox[{42, 2}], ArrowBox[{43, 1}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "0"],
           Annotation[#, 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "9"],
           Annotation[#, 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "16"],
           Annotation[#, 16, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[8],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[9],
            "25"],
           Annotation[#, 25, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[10],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[11],
            "36"],
           Annotation[#, 36, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[12],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[13],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[14],
            "22"],
           Annotation[#, 22, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[15],
            "39"],
           Annotation[#, 39, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[16],
            "10"],
           Annotation[#, 10, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[17],
            "11"],
           Annotation[#, 11, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[18],
            "37"],
           Annotation[#, 37, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[19],
            "12"],
           Annotation[#, 12, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[20],
            "18"],
           Annotation[#, 18, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[21],
            "13"],
           Annotation[#, 13, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[22],
            "14"],
           Annotation[#, 14, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[23],
            "28"],
           Annotation[#, 28, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[24],
            "15"],
           Annotation[#, 15, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[25],
            "17"],
           Annotation[#, 17, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[26],
            "30"],
           Annotation[#, 30, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[27],
            "19"],
           Annotation[#, 19, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[28],
            "20"],
           Annotation[#, 20, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[29],
            "21"],
           Annotation[#, 21, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[30],
            "23"],
           Annotation[#, 23, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[31],
            "24"],
           Annotation[#, 24, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[32],
            "26"],
           Annotation[#, 26, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[33],
            "27"],
           Annotation[#, 27, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[34],
            "29"],
           Annotation[#, 29, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[35],
            "31"],
           Annotation[#, 31, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[36],
            "32"],
           Annotation[#, 32, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[37],
            "33"],
           Annotation[#, 33, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[38],
            "34"],
           Annotation[#, 34, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[39],
            "35"],
           Annotation[#, 35, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[40],
            "38"],
           Annotation[#, 38, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[41],
            "40"],
           Annotation[#, 40, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[42],
            "41"],
           Annotation[#, 41, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[43],
            "42"],
           Annotation[#, 42, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{5.9995483888639995`, -6.72256621903859}, {
         1.4464872714851822`, -7.232436357425911}, {
         2.446487271485182, -0.4464872714851822}, {
         3.446487271485182, -1.4464872714851822`}, {
         8.946035660349182, -5.552609506242817}, {
         8.946035660349182, -6.552609506242817}, {
         2.446487271485182, -2.446487271485182}, {
         2.446487271485182, -3.3394618144555466`}, {
         3.446487271485182, -4.339461814455547}, {
         8.446035660349182, -2.9995483888639995`}, {
         8.446035660349182, -3.9995483888639995`}, {
         5.9995483888639995`, -1.4464872714851822`}, {
         0.4464872714851822, -8.785497474804728}, {
         1.4464872714851822`, -9.785497474804728}, {
         7.946035660349182, -7.552609506242817}, {
         0.4464872714851822, -1.4464872714851822`}, {
         0.4464872714851822, -4.339461814455547}, {
         2.446487271485182, -5.339461814455547}, {
         6.339461814455547, -8.445584049213181}, {
         6.339461814455547, -9.445584049213181}, {
         0.4464872714851823, -6.232436357425911}, {
         8.446035660349182, -0.4464872714851822}, {
         8.446035660349182, -1.4464872714851822`}, {
         5.9995483888639995`, -3.9995483888639995`}, {
         1.4464872714851822`, -4.339461814455547}, {
         5.339461814455547, -10.445584049213181`}, {
         3.446487271485182, -3.3394618144555466`}, {
         1.4464872714851822`, -8.785497474804728}, {
         8.285949085940729, -9.445584049213181}, {
         4.446487271485182, -3.3394618144555466`}, {
         5.339461814455547, -9.445584049213181}, {
         3.446487271485182, -0.4464872714851822}, {
         5.9995483888639995`, -2.9995483888639995`}, {
         1.4464872714851822`, -6.232436357425911}, {
         2.446487271485182, -4.339461814455547}, {
         1.4464872714851822`, -1.4464872714851822`}, {
         7.946035660349182, -6.552609506242817}, {
         2.446487271485182, -8.785497474804728}, {
         5.9995483888639995`, -0.4464872714851822}, {
         2.446487271485182, -1.4464872714851822`}, {
         4.446487271485182, -0.4464872714851822}, {
         2.446487271485182, -6.232436357425911}, {
         5.9995483888639995`, -5.72256621903859}}]& ],
      AspectRatio->Automatic,
      BaselinePosition->Top,
      FrameTicks->None,
      ImageSize->150,
      PlotLabel->FormBox["\"LayeredLeft\"", TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]]},
    {
     GraphicsBox[
      TagBox[GraphicsComplexBox[CompressedData["
1:eJxdmHk8VPv/x2dibEPGkmUM4xyECkmFlns+oW6lQt1QlgoVoeSGuCkle6G+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        "], {
         {RGBColor[0.5, 0., 0.], Arrowheads[{{0.016712943395539564`, 0.8}}], 
          ArrowBox[{1, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57,
            58, 59, 60, 61, 62, 63, 64, 65, 66, 1}], 
          ArrowBox[{2, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
            81, 82, 83, 84, 85, 86, 87, 88, 89, 2}], ArrowBox[{3, 4}], 
          ArrowBox[{4, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 
           103, 104, 105, 7}], ArrowBox[{5, 6}], 
          ArrowBox[{6, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 
           117, 118, 119, 120, 121, 15}], 
          ArrowBox[{7, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 
           133, 134, 135, 136, 137, 4}], ArrowBox[{8, 9}], 
          ArrowBox[{9, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 
           149, 150, 151, 152, 153, 18}], ArrowBox[{10, 11}], 
          ArrowBox[{11, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
            165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 11}], 
          ArrowBox[{12, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187,
            188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 12}], 
          ArrowBox[{13, 14}], 
          ArrowBox[{14, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210,
            211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 14}], 
          ArrowBox[{15, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233,
            234, 235, 236, 237, 238, 6}], ArrowBox[{16, 7}], 
          ArrowBox[{17, 18}], 
          ArrowBox[{18, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249,
            250, 251, 252, 253, 254, 9}], ArrowBox[{19, 20}], 
          ArrowBox[{20, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265,
            266, 267, 268, 269, 270, 26}], ArrowBox[{21, 2}], 
          ArrowBox[{22, 23}], 
          ArrowBox[{23, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281,
            282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 23}], 
          ArrowBox[{24, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304,
            305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 24}], 
          ArrowBox[{25, 18}], 
          ArrowBox[{26, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327,
            328, 329, 330, 331, 332, 20}], ArrowBox[{27, 9}], 
          ArrowBox[{28, 14}], 
          ArrowBox[{29, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343,
            344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 29}], 
          ArrowBox[{30, 9}], ArrowBox[{31, 26}], ArrowBox[{32, 4}], 
          ArrowBox[{33, 24}], ArrowBox[{34, 2}], ArrowBox[{35, 18}], 
          ArrowBox[{36, 7}], ArrowBox[{37, 15}], ArrowBox[{38, 14}], 
          ArrowBox[{39, 12}], ArrowBox[{40, 7}], ArrowBox[{41, 4}], 
          ArrowBox[{42, 2}], ArrowBox[{43, 1}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "0"],
           Annotation[#, 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "9"],
           Annotation[#, 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "16"],
           Annotation[#, 16, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[8],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[9],
            "25"],
           Annotation[#, 25, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[10],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[11],
            "36"],
           Annotation[#, 36, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[12],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[13],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[14],
            "22"],
           Annotation[#, 22, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[15],
            "39"],
           Annotation[#, 39, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[16],
            "10"],
           Annotation[#, 10, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[17],
            "11"],
           Annotation[#, 11, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[18],
            "37"],
           Annotation[#, 37, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[19],
            "12"],
           Annotation[#, 12, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[20],
            "18"],
           Annotation[#, 18, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[21],
            "13"],
           Annotation[#, 13, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[22],
            "14"],
           Annotation[#, 14, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[23],
            "28"],
           Annotation[#, 28, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[24],
            "15"],
           Annotation[#, 15, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[25],
            "17"],
           Annotation[#, 17, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[26],
            "30"],
           Annotation[#, 30, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[27],
            "19"],
           Annotation[#, 19, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[28],
            "20"],
           Annotation[#, 20, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[29],
            "21"],
           Annotation[#, 21, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[30],
            "23"],
           Annotation[#, 23, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[31],
            "24"],
           Annotation[#, 24, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[32],
            "26"],
           Annotation[#, 26, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[33],
            "27"],
           Annotation[#, 27, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[34],
            "29"],
           Annotation[#, 29, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[35],
            "31"],
           Annotation[#, 31, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[36],
            "32"],
           Annotation[#, 32, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[37],
            "33"],
           Annotation[#, 33, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[38],
            "34"],
           Annotation[#, 34, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[39],
            "35"],
           Annotation[#, 35, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[40],
            "38"],
           Annotation[#, 38, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[41],
            "40"],
           Annotation[#, 40, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[42],
            "41"],
           Annotation[#, 41, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[43],
            "42"],
           Annotation[#, 42, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{5.458602697050173, -8.66111646376271}, {
         5.458602697050173, -5.830729880107064}, {1.8195342323500583`, 
         0.19131811895552975`}, {2.8195342323500583`, -0.8086818810444703}, {
         0.9043409405222356, -7.693330221228054}, {
         0.9043409405222356, -8.693330221228054}, {
         1.8195342323500583`, -1.8086818810444703`}, {
         3.234727524177881, -2.234727524177881}, {
         4.234727524177881, -3.234727524177881}, {
         8.0868188104447, -2.809025177495889}, {
         8.0868188104447, -3.809025177495889}, {
         3.234727524177881, -6.639411761151535}, {-0.19131811895553064`, \
-5.032900350368182}, {
         0.8086818810444694, -6.032900350368182}, {-0.09565905947776443, \
-9.693330221228054}, {-0.1804657676499417, -0.8086818810444703}, {
         1.234727524177881, -3.234727524177881}, {
         3.234727524177881, -4.234727524177881}, {9.395500691489172, 
         0.19131811895552975`}, {9.395500691489172, -0.8086818810444703}, {
         4.458602697050173, -4.830729880107064}, {6.873795988877996, 
         0.021361406159756235`}, {6.873795988877996, -0.9786385938402438}, {
         7.682477869922465, -6.841582231412652}, {
         2.234727524177881, -3.234727524177881}, {
         8.395500691489172, -1.8086818810444703`}, {
         4.234727524177881, -2.234727524177881}, {
         0.8086818810444694, -5.032900350368182}, {
         2.628216113394528, -8.895500691489172}, {
         5.234727524177881, -2.234727524177881}, {
         8.395500691489172, -0.8086818810444703}, {2.8195342323500583`, 
         0.19131811895552975`}, {7.682477869922465, -5.841582231412652}, {
         5.458602697050173, -4.830729880107064}, {
         3.234727524177881, -3.234727524177881}, {
         0.8195342323500583, -0.8086818810444703}, {-0.09565905947776443, \
-8.693330221228054}, {1.8086818810444694`, -5.032900350368182}, {
         3.234727524177881, -5.639411761151535}, {
         1.8195342323500583`, -0.8086818810444703}, {3.8195342323500583`, 
         0.19131811895552975`}, {6.458602697050173, -4.830729880107064}, {
         5.458602697050173, -7.66111646376271}}]& ],
      AspectRatio->Automatic,
      BaselinePosition->Top,
      FrameTicks->None,
      ImageSize->150,
      PlotLabel->FormBox["\"ClosestPacking\"", TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]], 
     GraphicsBox[
      TagBox[GraphicsComplexBox[CompressedData["
1:eJxtWHk81Ov3n0GW2WeoiDZFi64Qym15Hi0iqkvXpbKULRWtKltS6lJIspcW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        "], {
         {RGBColor[0.5, 0., 0.], Arrowheads[{{0.017032471975829872`, 0.8}}], 
          ArrowBox[{1, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57,
            58, 59, 60, 61, 62, 63, 64, 65, 66, 1}], 
          ArrowBox[{2, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
            81, 82, 83, 84, 85, 86, 87, 88, 89, 2}], ArrowBox[{3, 4}], 
          ArrowBox[{4, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 
           103, 104, 105, 7}], ArrowBox[{5, 6}], 
          ArrowBox[{6, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 
           117, 118, 119, 120, 121, 15}], 
          ArrowBox[{7, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 
           133, 134, 135, 136, 137, 4}], ArrowBox[{8, 9}], 
          ArrowBox[{9, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 
           149, 150, 151, 152, 153, 18}], ArrowBox[{10, 11}], 
          ArrowBox[{11, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
            165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 11}], 
          ArrowBox[{12, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187,
            188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 12}], 
          ArrowBox[{13, 14}], 
          ArrowBox[{14, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210,
            211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 14}], 
          ArrowBox[{15, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233,
            234, 235, 236, 237, 238, 6}], ArrowBox[{16, 7}], 
          ArrowBox[{17, 18}], 
          ArrowBox[{18, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249,
            250, 251, 252, 253, 254, 9}], ArrowBox[{19, 20}], 
          ArrowBox[{20, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265,
            266, 267, 268, 269, 270, 26}], ArrowBox[{21, 2}], 
          ArrowBox[{22, 23}], 
          ArrowBox[{23, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281,
            282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 23}], 
          ArrowBox[{24, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304,
            305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 24}], 
          ArrowBox[{25, 18}], 
          ArrowBox[{26, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327,
            328, 329, 330, 331, 332, 20}], ArrowBox[{27, 9}], 
          ArrowBox[{28, 14}], 
          ArrowBox[{29, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343,
            344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 29}], 
          ArrowBox[{30, 9}], ArrowBox[{31, 26}], ArrowBox[{32, 4}], 
          ArrowBox[{33, 24}], ArrowBox[{34, 2}], ArrowBox[{35, 18}], 
          ArrowBox[{36, 7}], ArrowBox[{37, 15}], ArrowBox[{38, 14}], 
          ArrowBox[{39, 12}], ArrowBox[{40, 7}], ArrowBox[{41, 4}], 
          ArrowBox[{42, 2}], ArrowBox[{43, 1}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "0"],
           Annotation[#, 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "9"],
           Annotation[#, 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "16"],
           Annotation[#, 16, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[8],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[9],
            "25"],
           Annotation[#, 25, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[10],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[11],
            "36"],
           Annotation[#, 36, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[12],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[13],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[14],
            "22"],
           Annotation[#, 22, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[15],
            "39"],
           Annotation[#, 39, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[16],
            "10"],
           Annotation[#, 10, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[17],
            "11"],
           Annotation[#, 11, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[18],
            "37"],
           Annotation[#, 37, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[19],
            "12"],
           Annotation[#, 12, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[20],
            "18"],
           Annotation[#, 18, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[21],
            "13"],
           Annotation[#, 13, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[22],
            "14"],
           Annotation[#, 14, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[23],
            "28"],
           Annotation[#, 28, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[24],
            "15"],
           Annotation[#, 15, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[25],
            "17"],
           Annotation[#, 17, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[26],
            "30"],
           Annotation[#, 30, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[27],
            "19"],
           Annotation[#, 19, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[28],
            "20"],
           Annotation[#, 20, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[29],
            "21"],
           Annotation[#, 21, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[30],
            "23"],
           Annotation[#, 23, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[31],
            "24"],
           Annotation[#, 24, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[32],
            "26"],
           Annotation[#, 26, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[33],
            "27"],
           Annotation[#, 27, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[34],
            "29"],
           Annotation[#, 29, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[35],
            "31"],
           Annotation[#, 31, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[36],
            "32"],
           Annotation[#, 32, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[37],
            "33"],
           Annotation[#, 33, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[38],
            "34"],
           Annotation[#, 34, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[39],
            "35"],
           Annotation[#, 35, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[40],
            "38"],
           Annotation[#, 38, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[41],
            "40"],
           Annotation[#, 40, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[42],
            "41"],
           Annotation[#, 41, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[43],
            "42"],
           Annotation[#, 42, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{4.04340940522235, 3.064770811382107}, {
         2.223875172872293, -2.596002355929184}, {0., 1.}, {1., 0.}, {
         4.745579875483468, -2.234727524177881}, {
         4.745579875483468, -3.234727524177881}, {
         0., -1.}, {-1.8195342323500583`, 
         3.021704702611175}, {-0.8195342323500583, 
         2.021704702611175}, {-3.436897994438998, 
         4.873452692426577}, {-3.436897994438998, 3.873452692426577}, {
         1.8195342323500583`, 
         2.660429870859872}, {-3.223875172872294, -1.7981728261903016`}, \
{-2.223875172872294, -2.7981728261903016`}, {
         3.745579875483468, -4.234727524177881}, {-2., 
         0.}, {-3.8195342323500583`, 
         2.021704702611175}, {-1.8195342323500583`, 
         1.0217047026111752`}, {-3.745579875483468, 
         0.5956590594777649}, {-3.745579875483468, -0.4043409405222351}, {
         1.223875172872293, -1.5960023559291838`}, {0., -2.809025177495889}, {
         0., -3.809025177495889}, {3.6390684647001166`, 
         0.2343842277264614}, {-2.8195342323500583`, 
         2.021704702611175}, {-4.745579875483468, -1.4043409405222351`}, \
{-0.8195342323500583, 
         3.021704702611175}, {-2.223875172872294, -1.7981728261903016`}, \
{-4.447750345744586, -4.447750345744586}, {0.1804657676499417, 
         3.021704702611175}, {-4.745579875483468, -0.4043409405222351}, {1., 
         1.}, {3.6390684647001166`, 1.2343842277264614`}, {
         2.223875172872293, -1.5960023559291838`}, {-1.8195342323500583`, 
         2.021704702611175}, {-1., 0.}, {
         3.745579875483468, -3.234727524177881}, {-1.2238751728722939`, \
-1.7981728261903016`}, {1.8195342323500583`, 3.660429870859872}, {0., 0.}, {
         2., 1.}, {3.223875172872293, -1.5960023559291838`}, {
         4.04340940522235, 4.0647708113821075`}}]& ],
      AspectRatio->Automatic,
      BaselinePosition->Top,
      FrameTicks->None,
      ImageSize->150,
      PlotLabel->FormBox["\"ClosestPackingCenter\"", TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]], 
     GraphicsBox[
      TagBox[GraphicsComplexBox[CompressedData["
1:eJx1V3tcTdkXv/em24PR1K1EXbdx73XPIXQ9ksJZHlPkMSJR8ko1k4YkFZW3
PGYyKdKDCiOlx3iGxuSqkERCBlF5VMhbo3f55Zy7dp/6fH7nn/PZZ5+99lrf
tfb3u9cP7r6zPQU8Hm8Zn8f79t5eV9fgnUkBT/1wYzPg3oaA4zD2rYD8pqaW
s87m6u9y9boe6nG/bmNj6GpPivsQe9xQm9jD/7nvH5muY/KQ8dH6+nV6WyzV
9gYCN1aq7cjU/zWq7Rh0i0tO7HQbE3+5N038xXFXf03Iu+v+3ce4L0XGXeNE
e4pueGmT/dFe93i5/54y3Pv7bv4qiL+Yv67zVLc4zMi4Kx7d40W8EF9jtT/D
iX9d89WZz67+DPg/9WVC/MP1M4ujluufpODCjWVrquYbqWifcBunSgryHUt2
WDB/qNI2/Wi4X5eGwzH8+staGaq9ntoXFg2lwbo6tl3yMkeVLbVyu21Pw8Pr
Be5njApVdbmhCeVONCgCU3Sk0++qlAEJnus7xsGH53kF2T9U7a91+fWcHQ0D
l8ZNEQgqVO4VTbF/WtAwsve/V77f+kylGCVxdNOmwU81aMXywBeqtoKK7YVP
KKh7ucSLd6ZKhf6HJIx4tkJSrdKT6Hjrbuicrz51PTFoNkXWp2m/d7YcSsEo
tf3A1t1bxYYUKNT7P/Zz+M1Z2GFP7V9fuc/sek0KKLX/c/JP7e0hoqBMHd+6
zZWjAywosFHH7+515PG4WRQcVePzImRB1sYQCm6o8btkMjcsL42CGjW+xseV
5RdOm8GAjXpJTh31evO5bP14fTEs7HlyqUOiIRR/F2OZ97MY5n3UCnQNMISk
B2Zr55wQw6eIpqBbowzh7Zy1l0c+FwOTVe72T5UIluzRnOTYKgZZqEtByk4R
lNfb3dvTIgbfdX9s/kyJIOWZ6qngqRjWLFx+b+otA2AKv44pTxfDZaVLpdZ6
A7ge6JA2c5kYYg/MTDs43gD8DxYa0b3EsPNfxRudPgakfh9svGUbqmMAcQ79
y9JmmpH5yasSfgxrMCXrb4lfZdX/ZUrse2pSeneCTcn+wz4eMpu02BRWqv3L
cH6esWWRKfHffK/vsKS1piS+FXpFQZvSTUn84x/NUunXmRJ8oEf+6uipZgS/
+nHnDExTO/F1zz9vQA8zh6rYsOubfOSQ3WPH0kkyc9BqD96k6yqH5tp9LXkm
5jB6bXhk4xQ5RA5uC0nvZQ4RC/PmzrKWQ+Zpm0wezxwaDvKFfSg5iPPe6+2u
lkD+gV8uOJrIwTMxfpnghgRWNp9bpKmD51kCcy5fvmLVLIN3Lq6LSkT9ue9D
ZHCuesWgEfViME40zxNLZNDrT92g+AdisAmv95mvL4Njhx4+1rsghoM2Z+z6
95CBv2Te2IQYMVzI/Rjk3yAFWW3elemBYvhJ4NK44I0UtlZU11BOYtjzyivq
caUUClNLnMcqxVBDWz37UiqF9QMbXEuWasDE8X3iYmhjeDB45P4xVhqwS1ug
ky40hkdXfNpHa2vA61bZ4B1VRmBd0ItX9kAAsQV7zljlG8HxF4KrQ5MF4GWn
Z3jliBEMTfgyzG6VAHiTy9eO2WoEOXNnPLAcIwBnfvDVQx5G8JV9+CDZvTtS
w94I4uO+PW1qnhJBzvWXhTJpG5MyZUb4nT0iML7k2pqb2sp8kDVV2gWIIPRs
VETMoFbm1ObV0XddRZB1Ilz/VmoLUxvxriF0ggjWlNmO+F3awvTVv9Q4gxbB
f+kFF1vim5n48kcWMwxE0PP+6pCpes3MlCVrb2xuNQDubQb0THfFnA9SOMD+
Jwbh6199C3ky6MfaEcO/KxcsetyBP7ePGDbsksdvHSADzo+OfDnUvP5nuAw4
P8XgMG3j6C0TZZDKxiGGpLeWkcWOMnX+xfD3QMXghCUyMGdxkKjzL4f5LE4S
qJ9SMOScrRz4LI4SuOv6aWvIVDn8zOIsgVUZI49nOcshjs2DBJzkDUFLlsmh
ls2TBHKq/mgI8pXD5B6bt83VMIfQ9k0LG4PlMCDp95tFhuYwMOdU74owOYSy
+dci9c/lX4vUfxmbfy1S/1z+haT+ufwLSf1z+ReS+ufyLyT1z+Vfk9T/rZvf
HgGp/8VVdR5RkQJS/z0XD2lf4iQg9T/etbBgmpGA1H/ZvGs7vUr5pP5t3iXE
XY3kk/pvvv+ifP0MPqn/7cuzc45q8Un9I9+iviHfor4h36K+Id+iviHfor4h
36K+Id+iviHfor4h36K+Id+iPiHfdtU3M6JvyLc4j3yL65FvUd+Qb1HfkG9R
35BvUd+Qb1HfkG9R35BvUd+Qb1HfkG9R38x9Qm4k6PII3uEVS3WPF/AI3hEj
7fxOruETvEdcd+Td0xAQvG9e1o6M9hYQvM+Oke4vThAQvDOFx87NOCggeE94
EnNH6SkgeK9O77OtppVP8N4mzPQo9OETvB47pttuyOERPPE+hXhPczu+UyOs
ncH5xs/JViuoNgbXi4+XNAwXtjKI93r7EreDo1oYxDv585koj4JmBvGODc++
536lmUG8f9nwvrzUooVBvON93b66NLYwiPfz/f7iJOM2BvF+NXHsm8xV7Qzi
nUvr+Fyp/cog3toediOWbVWCU/bmaYs77ucBwycd6HFACX5f71iUJcvAKkey
M/mkEt5/arNyj5RB2jB+2a48JVzMrT9/wE8Gl3qbWEy8rQT30l8GiaZ2nLeF
F6cX3ldC6fljldqmMgg+X2QZ1zEOtsodO7TjvFl8ps9mFSshlDpR7ZIjBYO3
6xwycpVwJOrYG+toKayJCT+284QSIux/cNQIlELlkl8nqOKUIKze/WmMu5Tc
r//KftrXf4EUvMM3n168vHO+dO7SGfudOtdb8dccXz2x075ZSz7jPapz/+JR
A/LDhnb6tzJieMrcoZ3+/1Zxv+DJyM74EnPe9o2e0Bm/gWWxz7o5nfjc+ztt
fj/vTvxgV8rli5s68dU+o++weGwTU8TqrAjmpMbcC9/bxGxjdVgEMwMpjT0f
mhhOp0UQ5VfzddqsZiaA1XERnLBuDjiS1cyksDovguSrhof8JS3Md+w9QAQ7
nDwdE3e3MOfZe4IIBGx5tjLv2XuEIYwc8e3hww6WJ4zgiGmvAytW8sGLvYcY
wZdDd/lJ6Xzoz95TjCA/2cr6bC0f3DwDXPk8Y1CkjgmKGywA6bzmBue+xlBg
4O5ls1IA/92nG8KUxqA1yGzAltMC8Nfpnb99ijGERNtNXNAogKvbfeWzFxnD
tkfaycMSeURP6dIi72uFPKKnCtt9/OsNPKKnhdZ1X+UUn+jpPLM2mzuufKKn
d911S7Ij+ERPJ6Wdpm5f4xM95bPxC4iecvFrEj3l4tckesrFr0n0lItfk+gp
F7+Q6CkXv5DoKRe/kOgpF7+Q6Cn3pomermf/o4mecnZooqdz2X1ooqd+rB80
0dN7rJ800VMuDproKZvnITTRUw4HiuhpIosTRfSUw5EiesrhTBE95fJAET29
z+aJInrK5ZEiekqxeVYQPUW+wfs18g3ev5Fv8H6OfIP3d+QbvN8j3+D9H/kG
+xfkG+wfkG+wv0C+wf4D+Qb7E+Qb7F+Qb3Ae+QbXI9+gfeQb3B/5BvsX5Bv0
H/kG40O+wfiRbxAf5BvED/kG8cX+HMfYn+P/2J+jPezPcT/sz9Ef7M/RX+zP
EW/szzFe7M8RD+zPES/sz7v2ixTBG/tznMf+HNdjf472sT/H/bE/R7yxP0f/
sT/H+LA/x/ixP0d8sD9H/LA/R3xfsXWuIPwWyZ4DBeE3R/acKAi/ZbPnSEH4
LYE9ZxThN1v2HFKE30zYc0oRfuPON0X4jTvnFOE3X5YHaMJvHE/QhN84HqEJ
v3E8QxN+s2Z5iO7kN5anaMJv1SyP0YTffn+UI9XtOC+CFFmGfnolE9/quc9+
gxIO9/yUcT7vEfPwS0hczzVK2L6gOCDUtZRRLWx0oTyUUBL6ovl23m3G4Gel
qOonJYyr8/9wzKuQKZpf8q7CuuM8edxMMJZeY/rHLjz4yVwJiuikaJntNUYS
WbpKS1cJNbZbap5nFDLD7Urq6r9YwuqjEyuLTEqY1EO7B7rVWMLTopiys4dL
GY8P+YFBTyxhkF/ygN6GZcwFl3e6ho8soZ3tOyrJvLd95vvGL8/Jer1+Z6Pk
J6qJ/WuZi76Pr3tJ9tf0W2xXsO818S+rX2yZlV8t8f92Tfh8m6BaEp+lhnSy
87HXJP6b5vb86XqvCD7j7ppczb1bTfAbFryDPtr/BYP4bsx4RwcNesr8D8gK
3fI=
        "], {
         {RGBColor[0.5, 0., 0.], Arrowheads[{{0.012720265120627773`, 0.8}}], 
          ArrowBox[{1, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57,
            58, 59, 60, 61, 62, 63, 64, 65, 66, 1}], 
          ArrowBox[{2, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
            81, 82, 83, 84, 85, 86, 87, 88, 89, 2}], ArrowBox[{3, 4}], 
          ArrowBox[{4, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 
           103, 104, 105, 7}], ArrowBox[{5, 6}], 
          ArrowBox[{6, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 
           117, 118, 119, 120, 121, 15}], 
          ArrowBox[{7, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 
           133, 134, 135, 136, 137, 4}], ArrowBox[{8, 9}], 
          ArrowBox[{9, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 
           149, 150, 151, 152, 153, 18}], ArrowBox[{10, 11}], 
          ArrowBox[{11, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
            165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 11}], 
          ArrowBox[{12, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187,
            188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 12}], 
          ArrowBox[{13, 14}], 
          ArrowBox[{14, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210,
            211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 14}], 
          ArrowBox[{15, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233,
            234, 235, 236, 237, 238, 6}], ArrowBox[{16, 7}], 
          ArrowBox[{17, 18}], 
          ArrowBox[{18, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249,
            250, 251, 252, 253, 254, 9}], ArrowBox[{19, 20}], 
          ArrowBox[{20, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265,
            266, 267, 268, 269, 270, 26}], ArrowBox[{21, 2}], 
          ArrowBox[{22, 23}], 
          ArrowBox[{23, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281,
            282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 23}], 
          ArrowBox[{24, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304,
            305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 24}], 
          ArrowBox[{25, 18}], 
          ArrowBox[{26, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327,
            328, 329, 330, 331, 332, 20}], ArrowBox[{27, 9}], 
          ArrowBox[{28, 14}], 
          ArrowBox[{29, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343,
            344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 29}], 
          ArrowBox[{30, 9}], ArrowBox[{31, 26}], ArrowBox[{32, 4}], 
          ArrowBox[{33, 24}], ArrowBox[{34, 2}], ArrowBox[{35, 18}], 
          ArrowBox[{36, 7}], ArrowBox[{37, 15}], ArrowBox[{38, 14}], 
          ArrowBox[{39, 12}], ArrowBox[{40, 7}], ArrowBox[{41, 4}], 
          ArrowBox[{42, 2}], ArrowBox[{43, 1}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "0"],
           Annotation[#, 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "9"],
           Annotation[#, 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "16"],
           Annotation[#, 16, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[8],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[9],
            "25"],
           Annotation[#, 25, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[10],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[11],
            "36"],
           Annotation[#, 36, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[12],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[13],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[14],
            "22"],
           Annotation[#, 22, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[15],
            "39"],
           Annotation[#, 39, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[16],
            "10"],
           Annotation[#, 10, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[17],
            "11"],
           Annotation[#, 11, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[18],
            "37"],
           Annotation[#, 37, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[19],
            "12"],
           Annotation[#, 12, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[20],
            "18"],
           Annotation[#, 18, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[21],
            "13"],
           Annotation[#, 13, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[22],
            "14"],
           Annotation[#, 14, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[23],
            "28"],
           Annotation[#, 28, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[24],
            "15"],
           Annotation[#, 15, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[25],
            "17"],
           Annotation[#, 17, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[26],
            "30"],
           Annotation[#, 30, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[27],
            "19"],
           Annotation[#, 19, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[28],
            "20"],
           Annotation[#, 20, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[29],
            "21"],
           Annotation[#, 21, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[30],
            "23"],
           Annotation[#, 23, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[31],
            "24"],
           Annotation[#, 24, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[32],
            "26"],
           Annotation[#, 26, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[33],
            "27"],
           Annotation[#, 27, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[34],
            "29"],
           Annotation[#, 29, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[35],
            "31"],
           Annotation[#, 31, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[36],
            "32"],
           Annotation[#, 32, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[37],
            "33"],
           Annotation[#, 33, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[38],
            "34"],
           Annotation[#, 34, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[39],
            "35"],
           Annotation[#, 35, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[40],
            "38"],
           Annotation[#, 38, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[41],
            "40"],
           Annotation[#, 40, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[42],
            "41"],
           Annotation[#, 41, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[43],
            "42"],
           Annotation[#, 42, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{12.338699100999076`, 0.}, {
         7.169349550499538, 5.169349550499538}, {7.169349550499538, 
         11.838699100999074`}, {8.169349550499538, 10.838699100999076`}, {2.5,
          6.669349550499538}, {2.5, 5.669349550499538}, {7.169349550499538, 
         9.838699100999076}, {2., 11.838699100999074`}, {3., 
         10.838699100999076`}, {7.169349550499538, 1.}, {7.169349550499538, 
         0.}, {2., 0.}, {16.508048651498612`, 11.338699100999074`}, {
         17.508048651498612`, 10.338699100999076`}, {1.5, 
         4.669349550499538}, {5.169349550499538, 10.838699100999076`}, {0., 
         10.838699100999076`}, {2., 9.838699100999076}, {12.838699100999076`, 
         11.838699100999074`}, {12.838699100999076`, 10.838699100999076`}, {
         6.169349550499538, 6.169349550499538}, {17.508048651498612`, 
         6.169349550499538}, {17.508048651498612`, 5.169349550499538}, {
         12.338699100999076`, 5.169349550499538}, {1., 10.838699100999076`}, {
         11.838699100999076`, 9.838699100999076}, {3., 11.838699100999074`}, {
         17.508048651498612`, 11.338699100999074`}, {17.508048651498612`, 
         0.5}, {4., 11.838699100999074`}, {11.838699100999076`, 
         10.838699100999076`}, {8.169349550499538, 11.838699100999074`}, {
         12.338699100999076`, 6.169349550499538}, {7.169349550499538, 
         6.169349550499538}, {2., 10.838699100999076`}, {6.169349550499538, 
         10.838699100999076`}, {1.5, 5.669349550499538}, {18.508048651498612`,
          11.338699100999074`}, {2., 1.}, {7.169349550499538, 
         10.838699100999076`}, {9.169349550499538, 11.838699100999074`}, {
         8.169349550499538, 6.169349550499538}, {12.338699100999076`, 
         1.}}]& ],
      AspectRatio->Automatic,
      BaselinePosition->Top,
      FrameTicks->None,
      ImageSize->150,
      PlotLabel->FormBox["\"NestedGrid\"", TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]]}
   }],
  "Grid"]], "Output",
 ImageSize->{470, 393},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->799579235]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotRangePadding",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->44888674],

Cell[TextData[{
 "Use different ",
 Cell[BoxData[
  ButtonBox["PlotRangePadding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRangePadding"]], "InlineFormula"],
 " around the graph: "
}], "ExampleText",
 CellID->1808033363],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "[", 
    RowBox[{
     RowBox[{"LayeredGraphPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"0", "\[Rule]", "4"}], ",", 
         RowBox[{"0", "\[Rule]", "6"}], ",", 
         RowBox[{"0", "\[Rule]", "10"}], ",", 
         RowBox[{"2", "\[Rule]", "4"}], ",", 
         RowBox[{"2", "\[Rule]", "5"}], ",", 
         RowBox[{"2", "\[Rule]", "10"}], ",", 
         RowBox[{"5", "\[Rule]", "6"}]}], "}"}], ",", 
       RowBox[{"PlotRangePadding", "\[Rule]", "p"}]}], "]"}], ",", 
     RowBox[{"FrameMargins", "\[Rule]", "0"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0.1", ",", 
       RowBox[{"Scaled", "[", "0.1", "]"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->500288768],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    GraphicsBox[
     TagBox[
      GraphicsComplexBox[{{0., 2.}, {-1., 1.}, {1., 0.}, {0., 1.}, {-1., 
       2.}, {-2., 1.}, {1., 1.}, {0.04835996651265902, 1.951640033487341}, {
       0.10455097716174719`, 1.8954490228382528`}, {0.16857303194726453`, 
       1.8314269680527355`}, {0.24042613086921105`, 1.759573869130789}, {
       0.32011027392758673`, 1.6798897260724133`}, {0.4076254611223915, 
       1.5923745388776085`}, {0.5029716924536255, 1.4970283075463744`}, {
       0.6061489679212887, 1.3938510320787112`}, {0.717157287525381, 
       1.282842712474619}, {0.7765193382916591, 1.2185423901034025`}, {
       0.8288976183795514, 1.1513492952006954`}, {0.8742921277890582, 
       1.0812634277664972`}, {0.9127028665201793, 1.0082847878008083`}, {
       0.9441298345729148, 0.9324133753036284}, {0.9685730319472645, 
       0.8536491902749577}, {0.9860324586432286, 0.771992232714796}, {
       0.9965081146608071, 0.6874425026231434}, {1., 0.6}, {1., 
       0.5135802469135802}, {1., 0.43209876543209874`}, {1., 
       0.3555555555555555}, {1., 0.2839506172839506}, {1., 
       0.21728395061728392`}, {1., 0.15555555555555553`}, {1., 
       0.09876543209876541}, {1., 0.04691358024691357}}, {
        {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028937842778793417`, 0.8}}], 
         ArrowBox[{1, 2}], 
         ArrowBox[{1, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
          22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 3}], 
         ArrowBox[{1, 4}], ArrowBox[{5, 2}], ArrowBox[{5, 6}], 
         ArrowBox[{5, 4}], ArrowBox[{6, 3}]}, 
        {RGBColor[0, 0, 0.7], 
         TagBox[
          TooltipBox[PointBox[1],
           "0"],
          Annotation[#, 0, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[2],
           "4"],
          Annotation[#, 4, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[3],
           "6"],
          Annotation[#, 6, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[4],
           "10"],
          Annotation[#, 10, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[5],
           "2"],
          Annotation[#, 2, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[6],
           "5"],
          Annotation[#, 5, "Tooltip"]& ]}}],
      Annotation[#, 
       VertexCoordinateRules -> {{0., 2.}, {-1., 1.}, {1., 0.}, {0., 
        1.}, {-1., 2.}, {-2., 1.}}]& ],
     AspectRatio->Automatic,
     FrameTicks->None,
     PlotRange->All,
     PlotRangePadding->0],
    FrameMargins->0,
    StripOnInput->False], ",", 
   FrameBox[
    GraphicsBox[
     TagBox[
      GraphicsComplexBox[{{0., 2.}, {-1., 1.}, {1., 0.}, {0., 1.}, {-1., 
       2.}, {-2., 1.}, {1., 1.}, {0.04835996651265902, 1.951640033487341}, {
       0.10455097716174719`, 1.8954490228382528`}, {0.16857303194726453`, 
       1.8314269680527355`}, {0.24042613086921105`, 1.759573869130789}, {
       0.32011027392758673`, 1.6798897260724133`}, {0.4076254611223915, 
       1.5923745388776085`}, {0.5029716924536255, 1.4970283075463744`}, {
       0.6061489679212887, 1.3938510320787112`}, {0.717157287525381, 
       1.282842712474619}, {0.7765193382916591, 1.2185423901034025`}, {
       0.8288976183795514, 1.1513492952006954`}, {0.8742921277890582, 
       1.0812634277664972`}, {0.9127028665201793, 1.0082847878008083`}, {
       0.9441298345729148, 0.9324133753036284}, {0.9685730319472645, 
       0.8536491902749577}, {0.9860324586432286, 0.771992232714796}, {
       0.9965081146608071, 0.6874425026231434}, {1., 0.6}, {1., 
       0.5135802469135802}, {1., 0.43209876543209874`}, {1., 
       0.3555555555555555}, {1., 0.2839506172839506}, {1., 
       0.21728395061728392`}, {1., 0.15555555555555553`}, {1., 
       0.09876543209876541}, {1., 0.04691358024691357}}, {
        {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028937842778793417`, 0.8}}], 
         ArrowBox[{1, 2}], 
         ArrowBox[{1, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
          22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 3}], 
         ArrowBox[{1, 4}], ArrowBox[{5, 2}], ArrowBox[{5, 6}], 
         ArrowBox[{5, 4}], ArrowBox[{6, 3}]}, 
        {RGBColor[0, 0, 0.7], 
         TagBox[
          TooltipBox[PointBox[1],
           "0"],
          Annotation[#, 0, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[2],
           "4"],
          Annotation[#, 4, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[3],
           "6"],
          Annotation[#, 6, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[4],
           "10"],
          Annotation[#, 10, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[5],
           "2"],
          Annotation[#, 2, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[6],
           "5"],
          Annotation[#, 5, "Tooltip"]& ]}}],
      Annotation[#, 
       VertexCoordinateRules -> {{0., 2.}, {-1., 1.}, {1., 0.}, {0., 
        1.}, {-1., 2.}, {-2., 1.}}]& ],
     AspectRatio->Automatic,
     FrameTicks->None,
     PlotRange->All,
     PlotRangePadding->0.1],
    FrameMargins->0,
    StripOnInput->False], ",", 
   FrameBox[
    GraphicsBox[
     TagBox[
      GraphicsComplexBox[{{0., 2.}, {-1., 1.}, {1., 0.}, {0., 1.}, {-1., 
       2.}, {-2., 1.}, {1., 1.}, {0.04835996651265902, 1.951640033487341}, {
       0.10455097716174719`, 1.8954490228382528`}, {0.16857303194726453`, 
       1.8314269680527355`}, {0.24042613086921105`, 1.759573869130789}, {
       0.32011027392758673`, 1.6798897260724133`}, {0.4076254611223915, 
       1.5923745388776085`}, {0.5029716924536255, 1.4970283075463744`}, {
       0.6061489679212887, 1.3938510320787112`}, {0.717157287525381, 
       1.282842712474619}, {0.7765193382916591, 1.2185423901034025`}, {
       0.8288976183795514, 1.1513492952006954`}, {0.8742921277890582, 
       1.0812634277664972`}, {0.9127028665201793, 1.0082847878008083`}, {
       0.9441298345729148, 0.9324133753036284}, {0.9685730319472645, 
       0.8536491902749577}, {0.9860324586432286, 0.771992232714796}, {
       0.9965081146608071, 0.6874425026231434}, {1., 0.6}, {1., 
       0.5135802469135802}, {1., 0.43209876543209874`}, {1., 
       0.3555555555555555}, {1., 0.2839506172839506}, {1., 
       0.21728395061728392`}, {1., 0.15555555555555553`}, {1., 
       0.09876543209876541}, {1., 0.04691358024691357}}, {
        {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028937842778793417`, 0.8}}], 
         ArrowBox[{1, 2}], 
         ArrowBox[{1, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
          22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 3}], 
         ArrowBox[{1, 4}], ArrowBox[{5, 2}], ArrowBox[{5, 6}], 
         ArrowBox[{5, 4}], ArrowBox[{6, 3}]}, 
        {RGBColor[0, 0, 0.7], 
         TagBox[
          TooltipBox[PointBox[1],
           "0"],
          Annotation[#, 0, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[2],
           "4"],
          Annotation[#, 4, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[3],
           "6"],
          Annotation[#, 6, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[4],
           "10"],
          Annotation[#, 10, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[5],
           "2"],
          Annotation[#, 2, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[6],
           "5"],
          Annotation[#, 5, "Tooltip"]& ]}}],
      Annotation[#, 
       VertexCoordinateRules -> {{0., 2.}, {-1., 1.}, {1., 0.}, {0., 
        1.}, {-1., 2.}, {-2., 1.}}]& ],
     AspectRatio->Automatic,
     FrameTicks->None,
     PlotRange->All,
     PlotRangePadding->Scaled[0.1]],
    FrameMargins->0,
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{497, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->448834164]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->179618439],

Cell["Specify an overall style for the graph: ", "ExampleText",
 CellID->1676190373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"LayeredGraphPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "4"}], ",", 
       RowBox[{"1", "\[Rule]", "9"}], ",", 
       RowBox[{"4", "\[Rule]", "5"}], ",", 
       RowBox[{"0", "\[Rule]", "5"}], ",", 
       RowBox[{"3", "\[Rule]", "5"}], ",", 
       RowBox[{"3", "\[Rule]", "8"}], ",", 
       RowBox[{"3", "\[Rule]", "9"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "ps"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"ps", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Dashed", ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Red", ",", 
         RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Dashed"}], "]"}]}], 
      "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14566157],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0., 2.}, {0., 1.}, {2., 0.}, {1., 0.}, {1., 1.}, {
      3., 1.}, {3., 0.}, {2., 1.}, {0.09928677930370411, 1.950356610348148}, {
      0.21936933943703868`, 1.8903153302814806`}, {0.3602476804000037, 
      1.8198761597999982`}, {0.5219218021925992, 1.7390390989037003`}, {
      0.7043917048148252, 1.6478041475925873`}, {0.9076573882666816, 
      1.5461713058666593`}, {1.1317188525481685`, 1.4341405737259159`}, {
      1.3765760976592858`, 1.311711951170357}, {1.6422291236000337`, 
      1.1788854381999831`}, {1.7173168384000266`, 1.1364033091950485`}, {
      1.7835707044000204`, 1.0884615613802366`}, {1.840990721600015, 
      1.035060194755548}, {1.8895768900000105`, 0.9761992093209825}, {
      1.9293292096000068`, 0.9118786050765398}, {1.9602476804000037`, 
      0.8420983820222203}, {1.9823323024000017`, 0.7668585401580238}, {
      1.9955830756000004`, 0.6861590794839504}, {2., 0.6}, {2., 
      0.5135802469135802}, {2., 0.43209876543209874`}, {2., 
      0.3555555555555555}, {2., 0.2839506172839506}, {2., 
      0.21728395061728392`}, {2., 0.15555555555555553`}, {2., 
      0.09876543209876541}, {2., 0.04691358024691357}}, {
       {RGBColor[1, 0, 0], Arrowheads[{{0.028937842778793417`, 0.8}}], 
        ArrowBox[{1, 2}], 
        ArrowBox[{1, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
         23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 3}], 
        ArrowBox[{2, 4}], ArrowBox[{5, 4}], ArrowBox[{6, 4}], 
        ArrowBox[{6, 7}], ArrowBox[{6, 3}]}, 
       {RGBColor[1, 0, 0], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "9"],
         Annotation[#, 9, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "0"],
         Annotation[#, 0, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[7],
          "8"],
         Annotation[#, 8, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0., 2.}, {0., 1.}, {2., 0.}, {1., 0.}, {1., 
       1.}, {3., 1.}, {3., 0.}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0., 2.}, {0., 1.}, {2., 0.}, {1., 0.}, {1., 1.}, {
      3., 1.}, {3., 0.}, {2., 1.}, {0.09928677930370411, 1.950356610348148}, {
      0.21936933943703868`, 1.8903153302814806`}, {0.3602476804000037, 
      1.8198761597999982`}, {0.5219218021925992, 1.7390390989037003`}, {
      0.7043917048148252, 1.6478041475925873`}, {0.9076573882666816, 
      1.5461713058666593`}, {1.1317188525481685`, 1.4341405737259159`}, {
      1.3765760976592858`, 1.311711951170357}, {1.6422291236000337`, 
      1.1788854381999831`}, {1.7173168384000266`, 1.1364033091950485`}, {
      1.7835707044000204`, 1.0884615613802366`}, {1.840990721600015, 
      1.035060194755548}, {1.8895768900000105`, 0.9761992093209825}, {
      1.9293292096000068`, 0.9118786050765398}, {1.9602476804000037`, 
      0.8420983820222203}, {1.9823323024000017`, 0.7668585401580238}, {
      1.9955830756000004`, 0.6861590794839504}, {2., 0.6}, {2., 
      0.5135802469135802}, {2., 0.43209876543209874`}, {2., 
      0.3555555555555555}, {2., 0.2839506172839506}, {2., 
      0.21728395061728392`}, {2., 0.15555555555555553`}, {2., 
      0.09876543209876541}, {2., 0.04691358024691357}}, {
       {RGBColor[0.5, 0., 0.], PointSize[Medium], 
        Arrowheads[{{0.028937842778793417`, 0.8}}], ArrowBox[{1, 2}], 
        ArrowBox[{1, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
         23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 3}], 
        ArrowBox[{2, 4}], ArrowBox[{5, 4}], ArrowBox[{6, 4}], 
        ArrowBox[{6, 7}], ArrowBox[{6, 3}]}, 
       {RGBColor[0, 0, 0.7], PointSize[Medium], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "9"],
         Annotation[#, 9, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "0"],
         Annotation[#, 0, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[7],
          "8"],
         Annotation[#, 8, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0., 2.}, {0., 1.}, {2., 0.}, {1., 0.}, {1., 
       1.}, {3., 1.}, {3., 0.}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0., 2.}, {0., 1.}, {2., 0.}, {1., 0.}, {1., 1.}, {
      3., 1.}, {3., 0.}, {2., 1.}, {0.09928677930370411, 1.950356610348148}, {
      0.21936933943703868`, 1.8903153302814806`}, {0.3602476804000037, 
      1.8198761597999982`}, {0.5219218021925992, 1.7390390989037003`}, {
      0.7043917048148252, 1.6478041475925873`}, {0.9076573882666816, 
      1.5461713058666593`}, {1.1317188525481685`, 1.4341405737259159`}, {
      1.3765760976592858`, 1.311711951170357}, {1.6422291236000337`, 
      1.1788854381999831`}, {1.7173168384000266`, 1.1364033091950485`}, {
      1.7835707044000204`, 1.0884615613802366`}, {1.840990721600015, 
      1.035060194755548}, {1.8895768900000105`, 0.9761992093209825}, {
      1.9293292096000068`, 0.9118786050765398}, {1.9602476804000037`, 
      0.8420983820222203}, {1.9823323024000017`, 0.7668585401580238}, {
      1.9955830756000004`, 0.6861590794839504}, {2., 0.6}, {2., 
      0.5135802469135802}, {2., 0.43209876543209874`}, {2., 
      0.3555555555555555}, {2., 0.2839506172839506}, {2., 
      0.21728395061728392`}, {2., 0.15555555555555553`}, {2., 
      0.09876543209876541}, {2., 0.04691358024691357}}, {
       {RGBColor[0.5, 0., 0.], Dashing[{Small, Small}], 
        Arrowheads[{{0.028937842778793417`, 0.8}}], ArrowBox[{1, 2}], 
        ArrowBox[{1, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
         23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 3}], 
        ArrowBox[{2, 4}], ArrowBox[{5, 4}], ArrowBox[{6, 4}], 
        ArrowBox[{6, 7}], ArrowBox[{6, 3}]}, 
       {RGBColor[0, 0, 0.7], Dashing[{Small, Small}], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "9"],
         Annotation[#, 9, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "0"],
         Annotation[#, 0, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[7],
          "8"],
         Annotation[#, 8, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0., 2.}, {0., 1.}, {2., 0.}, {1., 0.}, {1., 
       1.}, {3., 1.}, {3., 0.}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0., 2.}, {0., 1.}, {2., 0.}, {1., 0.}, {1., 1.}, {
      3., 1.}, {3., 0.}, {2., 1.}, {0.09928677930370411, 1.950356610348148}, {
      0.21936933943703868`, 1.8903153302814806`}, {0.3602476804000037, 
      1.8198761597999982`}, {0.5219218021925992, 1.7390390989037003`}, {
      0.7043917048148252, 1.6478041475925873`}, {0.9076573882666816, 
      1.5461713058666593`}, {1.1317188525481685`, 1.4341405737259159`}, {
      1.3765760976592858`, 1.311711951170357}, {1.6422291236000337`, 
      1.1788854381999831`}, {1.7173168384000266`, 1.1364033091950485`}, {
      1.7835707044000204`, 1.0884615613802366`}, {1.840990721600015, 
      1.035060194755548}, {1.8895768900000105`, 0.9761992093209825}, {
      1.9293292096000068`, 0.9118786050765398}, {1.9602476804000037`, 
      0.8420983820222203}, {1.9823323024000017`, 0.7668585401580238}, {
      1.9955830756000004`, 0.6861590794839504}, {2., 0.6}, {2., 
      0.5135802469135802}, {2., 0.43209876543209874`}, {2., 
      0.3555555555555555}, {2., 0.2839506172839506}, {2., 
      0.21728395061728392`}, {2., 0.15555555555555553`}, {2., 
      0.09876543209876541}, {2., 0.04691358024691357}}, {
       {RGBColor[1, 0, 0], PointSize[Medium], Dashing[{Small, Small}], 
        Arrowheads[{{0.028937842778793417`, 0.8}}], ArrowBox[{1, 2}], 
        ArrowBox[{1, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
         23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 3}], 
        ArrowBox[{2, 4}], ArrowBox[{5, 4}], ArrowBox[{6, 4}], 
        ArrowBox[{6, 7}], ArrowBox[{6, 3}]}, 
       {RGBColor[1, 0, 0], PointSize[Medium], Dashing[{Small, Small}], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "9"],
         Annotation[#, 9, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "0"],
         Annotation[#, 0, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[7],
          "8"],
         Annotation[#, 8, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0., 2.}, {0., 1.}, {2., 0.}, {1., 0.}, {1., 
       1.}, {3., 1.}, {3., 0.}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]]}], "}"}]], "Output",
 ImageSize->{452, 69},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1119943362]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->297939305],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " can be combined with ",
 Cell[BoxData[
  ButtonBox["VertexRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexRenderingFunction"]], "InlineFormula"],
 " which has higher priority: "
}], "ExampleText",
 CellID->580503372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "9"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"0", "\[Rule]", "5"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}], ",", 
     RowBox[{"3", "\[Rule]", "8"}], ",", 
     RowBox[{"3", "\[Rule]", "9"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red"}], "]"}]}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"p", ",", "l"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Green", ",", 
        RowBox[{"Point", "[", "p", "]"}]}], "}"}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->317015018],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{
     GraphicsComplexBox[{{0., 2.}, {0., 1.}, {2., 0.}, {1., 0.}, {1., 1.}, {
      3., 1.}, {3., 0.}, {2., 1.}, {0.09928677930370411, 1.950356610348148}, {
      0.21936933943703868`, 1.8903153302814806`}, {0.3602476804000037, 
      1.8198761597999982`}, {0.5219218021925992, 1.7390390989037003`}, {
      0.7043917048148252, 1.6478041475925873`}, {0.9076573882666816, 
      1.5461713058666593`}, {1.1317188525481685`, 1.4341405737259159`}, {
      1.3765760976592858`, 1.311711951170357}, {1.6422291236000337`, 
      1.1788854381999831`}, {1.7173168384000266`, 1.1364033091950485`}, {
      1.7835707044000204`, 1.0884615613802366`}, {1.840990721600015, 
      1.035060194755548}, {1.8895768900000105`, 0.9761992093209825}, {
      1.9293292096000068`, 0.9118786050765398}, {1.9602476804000037`, 
      0.8420983820222203}, {1.9823323024000017`, 0.7668585401580238}, {
      1.9955830756000004`, 0.6861590794839504}, {2., 0.6}, {2., 
      0.5135802469135802}, {2., 0.43209876543209874`}, {2., 
      0.3555555555555555}, {2., 0.2839506172839506}, {2., 
      0.21728395061728392`}, {2., 0.15555555555555553`}, {2., 
      0.09876543209876541}, {2., 0.04691358024691357}}, 
      {RGBColor[1, 0, 0], PointSize[Large], 
       Arrowheads[{{0.028937842778793417`, 0.7}}], ArrowBox[{1, 2}], 
       ArrowBox[{1, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
         24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 3}], ArrowBox[{2, 4}], 
       ArrowBox[{5, 4}], ArrowBox[{6, 4}], ArrowBox[{6, 7}], 
       ArrowBox[{6, 3}]}], 
     {RGBColor[1, 0, 0], PointSize[Large], 
      {RGBColor[0, 1, 0], PointBox[{0., 2.}]}, 
      {RGBColor[0, 1, 0], PointBox[{0., 1.}]}, 
      {RGBColor[0, 1, 0], PointBox[{2., 0.}]}, 
      {RGBColor[0, 1, 0], PointBox[{1., 0.}]}, 
      {RGBColor[0, 1, 0], PointBox[{1., 1.}]}, 
      {RGBColor[0, 1, 0], PointBox[{3., 1.}]}, 
      {RGBColor[0, 1, 0], PointBox[{3., 0.}]}}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 2.}, {0., 1.}, {2., 0.}, {1., 0.}, {1., 
     1.}, {3., 1.}, {3., 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->291277963]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->414909817],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " can be combined with ",
 Cell[BoxData[
  ButtonBox["EdgeRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeRenderingFunction"]], "InlineFormula"],
 " which has higher priority: "
}], "ExampleText",
 CellID->88626299],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "9"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"0", "\[Rule]", "5"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}], ",", 
     RowBox[{"3", "\[Rule]", "8"}], ",", 
     RowBox[{"3", "\[Rule]", "9"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Dashed", ",", "Red"}], "]"}]}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"p", ",", "vl", ",", "el"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Green", ",", 
        RowBox[{"Line", "[", "p", "]"}]}], "}"}]}], "]"}]}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->238367270],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{
     {RGBColor[1, 0, 0], Dashing[{Small, Small}], 
      {RGBColor[0, 1, 0], LineBox[{{0., 2.}, {0., 1.}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0., 2.}, {0.09928677930370411, 1.950356610348148}, {
        0.21936933943703868`, 1.8903153302814806`}, {0.3602476804000037, 
        1.8198761597999982`}, {0.5219218021925992, 1.7390390989037003`}, {
        0.7043917048148252, 1.6478041475925873`}, {0.9076573882666816, 
        1.5461713058666593`}, {1.1317188525481685`, 1.4341405737259159`}, {
        1.3765760976592858`, 1.311711951170357}, {1.6422291236000337`, 
        1.1788854381999831`}, {1.7173168384000266`, 1.1364033091950485`}, {
        1.7835707044000204`, 1.0884615613802366`}, {1.840990721600015, 
        1.035060194755548}, {1.8895768900000105`, 0.9761992093209825}, {
        1.9293292096000068`, 0.9118786050765398}, {1.9602476804000037`, 
        0.8420983820222203}, {1.9823323024000017`, 0.7668585401580238}, {
        1.9955830756000004`, 0.6861590794839504}, {2., 0.6}, {2., 
        0.5135802469135802}, {2., 0.43209876543209874`}, {2., 
        0.3555555555555555}, {2., 0.2839506172839506}, {2., 
        0.21728395061728392`}, {2., 0.15555555555555553`}, {2., 
        0.09876543209876541}, {2., 0.04691358024691357}, {2., 0.}}]}, 
      {RGBColor[0, 1, 0], LineBox[{{0., 1.}, {1., 0.}}]}, 
      {RGBColor[0, 1, 0], LineBox[{{1., 1.}, {1., 0.}}]}, 
      {RGBColor[0, 1, 0], LineBox[{{3., 1.}, {1., 0.}}]}, 
      {RGBColor[0, 1, 0], LineBox[{{3., 1.}, {3., 0.}}]}, 
      {RGBColor[0, 1, 0], LineBox[{{3., 1.}, {2., 0.}}]}}, 
     GraphicsComplexBox[{{0., 2.}, {0., 1.}, {2., 0.}, {1., 0.}, {1., 1.}, {
      3., 1.}, {3., 0.}, {2., 1.}, {0.09928677930370411, 1.950356610348148}, {
      0.21936933943703868`, 1.8903153302814806`}, {0.3602476804000037, 
      1.8198761597999982`}, {0.5219218021925992, 1.7390390989037003`}, {
      0.7043917048148252, 1.6478041475925873`}, {0.9076573882666816, 
      1.5461713058666593`}, {1.1317188525481685`, 1.4341405737259159`}, {
      1.3765760976592858`, 1.311711951170357}, {1.6422291236000337`, 
      1.1788854381999831`}, {1.7173168384000266`, 1.1364033091950485`}, {
      1.7835707044000204`, 1.0884615613802366`}, {1.840990721600015, 
      1.035060194755548}, {1.8895768900000105`, 0.9761992093209825}, {
      1.9293292096000068`, 0.9118786050765398}, {1.9602476804000037`, 
      0.8420983820222203}, {1.9823323024000017`, 0.7668585401580238}, {
      1.9955830756000004`, 0.6861590794839504}, {2., 0.6}, {2., 
      0.5135802469135802}, {2., 0.43209876543209874`}, {2., 
      0.3555555555555555}, {2., 0.2839506172839506}, {2., 
      0.21728395061728392`}, {2., 0.15555555555555553`}, {2., 
      0.09876543209876541}, {2., 0.04691358024691357}}, 
      {RGBColor[1, 0, 0], Dashing[{Small, Small}], 
       TagBox[
        TooltipBox[PointBox[1],
         "1"],
        Annotation[#, 1, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[2],
         "4"],
        Annotation[#, 4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[3],
         "9"],
        Annotation[#, 9, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[4],
         "5"],
        Annotation[#, 5, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[5],
         "0"],
        Annotation[#, 0, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[6],
         "3"],
        Annotation[#, 3, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[7],
         "8"],
        Annotation[#, 8, "Tooltip"]& ]}]}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 2.}, {0., 1.}, {2., 0.}, {1., 0.}, {1., 
     1.}, {3., 1.}, {3., 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1260518594]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "SelfLoopStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->91275691],

Cell["Draw self-loops with a specified scaled diameter:", "ExampleText",
 CellID->1053407179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"LayeredGraphPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0", "\[Rule]", "3"}], ",", 
       RowBox[{"0", "\[Rule]", "5"}], ",", 
       RowBox[{"0", "\[Rule]", "8"}], ",", 
       RowBox[{"3", "\[Rule]", "5"}], ",", 
       RowBox[{"3", "\[Rule]", "8"}], ",", 
       RowBox[{"5", "\[Rule]", "9"}], ",", 
       RowBox[{"5", "\[Rule]", "5"}]}], "}"}], ",", 
     RowBox[{"SelfLoopStyle", "\[Rule]", "s"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"0.2", ",", "0.4", ",", "0.6"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->375686493],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    TagBox[GraphicsComplexBox[CompressedData["
1:eJx11AlIVEEYB/Cnq6sJ0mGmdmtSarYZahpE31Roh5ZlrmiapLhp1qagGJqF
kiXVdtAG5npBhx1EiiGWrU3tsmbEqt3lgZkm2l7v7ep6YNvFNuFAw3sM//dm
3pv5fjCeKZnRIluGYaJ/3b/76c0RUQ+smcXWHv7T4+nTSEbTxzFI5hwSfF1x
G79YtjJ7tMIBLa69t6dT2YRLZCmr+nwdUL68zFUtVeHQ1BqBsoaPfIyll7a2
tOGeQnNuuQsfRRakq2sL3uJcNpqfkWWPBtK85p+Z14l5Dx53C5rtkKFnvVuc
+2dc3BowOTzBQ4vWh5y6LOrH4wH1SeXLeejYTuaDyTiIk7XgtHmzLYqTCl3h
0xAODJuzQoptUHuxMDLm9DdsCD9TZQ62QX1eTEHgpAaXcjeyxDUMuiAW3ugO
0mG/MFHl2CwGvU8VqqLW6vGuk1e2+Wks8NCR6ZVY9Niz7Zaz5PZ3CI4XctLz
Bvwiw65k7t4p2BErnErtN+Dw+LsNyh+TpH6yst9tguSOjypNdcg4ySNKL9Hn
YTPJ/IQ6+4S60X+56oh65rkRkkcl++SWPBPJr1cc/3UZSf4z/ApHclzyzhyf
pyxYfYDyAcoHKB+gfIDyAcoHKB+gfIDyAcoHKB+gfIDyAcoHKB+gfIDyAcoH
KB+gfIDyAcoHKB+gfIDygb8+jMd+uwVrWNyenN8if6WHkcYZV9sOsNi7Q+W9
yqCDQ3KD+mwjiyP8vZ8lrtYBT2BfZbOYw198g1wGq7RwqlpReFTK4fuRZR5b
tmghrSjqftAsI251KardKNCCNrOZ5UuM+HK+oCFfqIVtz68VvbQYMedfmJ7U
pIXtebMHxvab8CNT+ZOIWB3MzTPL3e+ZcNb5i195S/TgvWhDzIYuE86JD5fF
OhjASVxeGaUxkfPj7/vwN931MQUsuFrnb10X6nyCZcn3l/Hrl3bGcOT/JcP4
Zcc1jqyvUZF+c9M7jqx/YS749A5xUGzd3534wOzEbo7sf6ZGZJbUcXDYWp+u
YXH17nSO1E/vVik+6MiR+nq0Kyo8S1n4CdGPPrA=
      "], {
       {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028937842778793417`, 0.8}}], 
        ArrowBox[{1, 2}], 
        ArrowBox[{1, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22,
          23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 3}], 
        ArrowBox[{1, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 
         48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 4}], 
        ArrowBox[{2, 3}], ArrowBox[{2, 4}], ArrowBox[{3, 5}], 
        ArrowBox[{3, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 
         74, 75, 76, 77, 78, 79, 80, 81, 82, 3}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "0"],
         Annotation[#, 0, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "8"],
         Annotation[#, 8, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "9"],
         Annotation[#, 9, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0., 3.}, {0., 2.}, {-1., 1.}, {1., 1.}, {-1.,
        0.}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[GraphicsComplexBox[CompressedData["
1:eJx11AtIU1EYB/Cr85VkSmaZkKWFppGZz7LVd0M0DTOZLWZqobgegg9MIm1W
ZEvEZaLSUFMLZakYSWVoWadaRmK+MrR8pFbYptNtd5sv1NJYJzzQ4V4O/3vP
ufec7wfHITaJwzekKIqzdC/3K5sZTTzQZxXS9/CfHq2chjO9chxFF1v4ele8
qUItW3ec190xpe0f1ob3SZ+hrOLYnSMupnR6U5FNW0Ez2hMncZNKTOjtjDgv
6F07Grw6daHE2oQOEZxteyj4hC6oOCbxycb0jzOOdtnr+xDr8fMBtxdGtHKQ
vYFnO4yuv3efk8+y6E1sX2E+/zuacX90ssSJRV8KpXo1zCiKUYC5v78hzSvg
2sAXGfIMWOtcgAzojuvckGM3xpAyMLtsytuAHnGkBJ5z40isrkxOkFB0bgK3
csBrArkG8EunrSi6J47bfNRnEoVlFga7ji9Cgxk1JFqcRA7t9y1EVQvgHcFV
F9xUopZ4o6x1J+bhyHHufNx3JQqMqKmX/prD9SsuWm6zOHd+bh4v953BWSt1
5A/Lp3A2iawzjqzT/ctliW2WOVqcdaLopsU0Dc4fnTOWLgbnP8ML1TjzYkJT
t79Sgd4HCB8gfIDwAcIHCB8gfIDwAcIHCB8gfIDwAcIHCB8gfIDwAcIHCB8g
fIDwAcIHCB8gfIDwAcIHCB/460N5vDLziV3yk2pFaRUTIEuydi9tU6GguznB
J76OQ+/FoRKbJDW6zQu61nhyDIyjzNksNoPehp91+rBfDqtAaKB00qDoIg/P
3FwZtBuWR53bokW3nA1PZUbJoHcofcTCVoe26aLidTUyyM8NYIkXdOhbBNXV
lCqHQsbxvfL1FEr56Zshrh0DF0aRtps3jYbtNreaHlBAkJ+gSvB0Gskeibwe
rJkE6z6ffeU90/j8CNa/F0ka+dUzKjw/LyXZbn5Yjb9/aHXcwSfVDP6/ZfcV
8b0ADV5forDrsLBGAx369e9RXA572aXB++M8Pj3a0KDB+7fvaVVsjNHg+tR3
9x+o6GRw/QZ2+fV/tGJwfXeXCff6u6nhNz6OPtc=
      "], {
       {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028937842778793417`, 0.8}}], 
        ArrowBox[{1, 2}], 
        ArrowBox[{1, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22,
          23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 3}], 
        ArrowBox[{1, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 
         48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 4}], 
        ArrowBox[{2, 3}], ArrowBox[{2, 4}], ArrowBox[{3, 5}], 
        ArrowBox[{3, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 
         74, 75, 76, 77, 78, 79, 80, 81, 82, 3}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "0"],
         Annotation[#, 0, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "8"],
         Annotation[#, 8, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "9"],
         Annotation[#, 9, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0., 3.}, {0., 2.}, {-1., 1.}, {1., 1.}, {-1.,
        0.}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[GraphicsComplexBox[CompressedData["
1:eJx11AtIU1EYB/CrsympWabL3mXYyl5GTi2N75aUVqapLbUXuLSHOh1lkWYU
tRR1SrUetNSCZI2KEqOIpZ1srCdaaT5aasp8Zrn30s1WFrcbHuhwL4f/vefc
e873gzOXlxGTbE8QRMzo/bsf25xI7AGVtYjq4T89GjuNzuTYcQQpcQ3k3Hgm
Q6/mLTpkKnEkZ927E6tSyFGehLekc6EjmV11xbNWrERBSdKlCimTXKC/fDb8
eR1qO2k+cnUyk4zI2V97L+cDOqKNYaYIxpFd+7yn5bNUiHH/cevSagdS0xYy
Jd6rAwlf+ln6hxnkzJDAM+eT1WjIr3L31fkM8lgk0WzQ96DErzA+NNSejBdz
PeFjH1qxzp0tRnbkWyE3YmvuF6RZn19m5tiRnd5EzgrLALqsKxfwpQRZzOeW
t/p/Q77rkku/TyTIpiSuMipgEG05fWGD74ANHjkRn0W2QTS37qarSPYDOAlc
nbhIg16lOOR5bB+Bzdu4I0lqDVqfcOuB4qeFrp/kyu82TOd3LcqBa4FDdDYq
vJM7+s10Zu6oGLejwvQvl6XXuhUa6WwS7aqyZRnoXM8+Pnrp6fxn+AUdneMT
IzMXPNUC5QOYD2A+gPkA5gOYD2A+gPkA5gOYD2A+gPkA5gOYD2A+gPkA5gOY
D2A+gPkA5gOYD2A+gPkA5gOYD/z1ITbNcY0WaxHfJyM24PBXaGXPfJnqr0Np
guj0vNp+WMN5e+D6fD3qFKaFsop7wbHATeWw3YCkx0tWVrZ2Q1F72Km9ciNy
7nkT0djYBRzh4PgyPzOKCz49QVnQBc+iguo9yr+jhxmFswVEN6i4fULeyBBq
yD25cvqyHmhL9b/T621Biz81BKvt+yAkVR2w0cGKomV3K5x3fYG0OPmI/JwV
7XRpqGOwvsGMsPqWwRorfX78fV+fdcnLlqmD1dT85tsydvZ7PbRT309xZ/GK
bQb4RP3/UhXsOdhnpNfnE75K++KEiV4/l/fkaKncBCJqf1YXSYLnRRO9/yU1
y9XSSSZYS9XnbPWGdmOQka7f67Dm8JCpBrq+G/nhTUlKHfwCnPY89g==
      "], {
       {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028937842778793417`, 0.8}}], 
        ArrowBox[{1, 2}], 
        ArrowBox[{1, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22,
          23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 3}], 
        ArrowBox[{1, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 
         48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 4}], 
        ArrowBox[{2, 3}], ArrowBox[{2, 4}], ArrowBox[{3, 5}], 
        ArrowBox[{3, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 
         74, 75, 76, 77, 78, 79, 80, 81, 82, 3}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "0"],
         Annotation[#, 0, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "8"],
         Annotation[#, 8, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "9"],
         Annotation[#, 9, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0., 3.}, {0., 2.}, {-1., 1.}, {1., 1.}, {-1.,
        0.}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]]}], "}"}]], "Output",
 ImageSize->{491, 202},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->253848952]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "VertexLabeling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->24443973],

Cell["Show vertex labels:", "ExampleText",
 CellID->1001631834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "6"}], ",", 
     RowBox[{"2", "\[Rule]", "7"}], ",", 
     RowBox[{"3", "\[Rule]", "7"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1042589918],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 0.7385489458759964}, {1.1078234188139946`, 
    1.4770978917519928`}, {0.7385489458759964, 0.7385489458759964}, {
    1.4770978917519928`, 0.7385489458759964}, {2.215646837627989, 
    0.7385489458759964}, {2.215646837627989, 0.}, {0.7385489458759964, 
    0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {2, 3}, {2, 4}, {2, 5}, {3, 7}, {6, 5}}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["7",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 0.7385489458759964}, {1.1078234188139946`, 
     1.4770978917519928`}, {0.7385489458759964, 0.7385489458759964}, {
     1.4770978917519928`, 0.7385489458759964}, {2.215646837627989, 
     0.7385489458759964}, {2.215646837627989, 0.}, {0.7385489458759964, 
     0.}}]& ],
  AspectRatio->0.816496580927726,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->907922855]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->291462997],

Cell["Show vertex labels as tooltips only:", "ExampleText",
 CellID->73764302],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "6"}], ",", 
     RowBox[{"2", "\[Rule]", "7"}], ",", 
     RowBox[{"3", "\[Rule]", "7"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "Tooltip"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->655204029],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 0.7385489458759964}, {1.1078234188139946`, 
    1.4770978917519928`}, {0.7385489458759964, 0.7385489458759964}, {
    1.4770978917519928`, 0.7385489458759964}, {2.215646837627989, 
    0.7385489458759964}, {2.215646837627989, 0.}, {0.7385489458759964, 
    0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {2, 3}, {2, 4}, {2, 5}, {3, 7}, {6, 5}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 0.7385489458759964}, {1.1078234188139946`, 
     1.4770978917519928`}, {0.7385489458759964, 0.7385489458759964}, {
     1.4770978917519928`, 0.7385489458759964}, {2.215646837627989, 
     0.7385489458759964}, {2.215646837627989, 0.}, {0.7385489458759964, 
     0.}}]& ],
  AspectRatio->0.816496580927726,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1845611119]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->268593998],

Cell["Show vertex labels as tooltips only if the graph is small:", \
"ExampleText",
 CellID->1953868534],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "6"}], ",", 
     RowBox[{"2", "\[Rule]", "7"}], ",", 
     RowBox[{"3", "\[Rule]", "7"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69684929],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 0.7385489458759964}, {1.1078234188139946`, 
    1.4770978917519928`}, {0.7385489458759964, 0.7385489458759964}, {
    1.4770978917519928`, 0.7385489458759964}, {2.215646837627989, 
    0.7385489458759964}, {2.215646837627989, 0.}, {0.7385489458759964, 
    0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {2, 3}, {2, 4}, {2, 5}, {3, 7}, {6, 5}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 0.7385489458759964}, {1.1078234188139946`, 
     1.4770978917519928`}, {0.7385489458759964, 0.7385489458759964}, {
     1.4770978917519928`, 0.7385489458759964}, {2.215646837627989, 
     0.7385489458759964}, {2.215646837627989, 0.}, {0.7385489458759964, 
     0.}}]& ],
  AspectRatio->0.816496580927726,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1873360300]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8973542],

Cell["Show vertex labels both explicitly and as tooltips:", "ExampleText",
 CellID->1197125759],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "6"}], ",", 
     RowBox[{"2", "\[Rule]", "7"}], ",", 
     RowBox[{"3", "\[Rule]", "7"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->406910921],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 0.7385489458759964}, {1.1078234188139946`, 
    1.4770978917519928`}, {0.7385489458759964, 0.7385489458759964}, {
    1.4770978917519928`, 0.7385489458759964}, {2.215646837627989, 
    0.7385489458759964}, {2.215646837627989, 0.}, {0.7385489458759964, 
    0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {2, 3}, {2, 4}, {2, 5}, {3, 7}, {6, 5}}]}, {
      TagBox[
       TooltipBox[InsetBox[
         FrameBox["1",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox["2",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox["4",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 3],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox["6",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 4],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox["7",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 5],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox["3",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 6],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox["5",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 7],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 0.7385489458759964}, {1.1078234188139946`, 
     1.4770978917519928`}, {0.7385489458759964, 0.7385489458759964}, {
     1.4770978917519928`, 0.7385489458759964}, {2.215646837627989, 
     0.7385489458759964}, {2.215646837627989, 0.}, {0.7385489458759964, 
     0.}}]& ],
  AspectRatio->0.816496580927726,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->322450815]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "VertexCoordinateRules",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->74973014],

Cell["Explicitly specify all vertex coordinates: ", "ExampleText",
 CellID->49039736],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "4"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexCoordinateRules", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->930075907],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 2.}, {0., 1.}, {0., 0.}, {2., -1.}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028937842778793417`, 0.7}}], 
      ArrowBox[{1, 2}], ArrowBox[{1, 4}], ArrowBox[{2, 3}], 
      ArrowBox[{3, 4}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 2.}, {0., 1.}, {0., 0.}, {2., -1.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{104, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1586422380]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "VertexRenderingFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->82661052],

Cell["Show no vertices:", "ExampleText",
 CellID->1148726976],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"i", "\[Rule]", 
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{"i", "^", "2"}], ",", "51"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "51"}], "\[IndentingNewLine]", "}"}]}], 
    "]"}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1976145425],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW2mMVVUSvvTbX7/eoLuxQWi2lq1FQUUaEe1xpBmxUSNG0Siio0BcUHBG
oyKyCMgqDTRCiyCCuMDgBAXJsCgupFFHXEZBZVHJSDImTOIPf8yPN9+pOvee
8+re1483mWR0Ykdf7lKn6jtVdarq1Lk0jn9g4h33jH9g0u3juzVMGX/fxEm3
T+02YvIUPAq1c5x2Jfj/nDMcXKcdh/9Xf6X4ny9/vfJf9VG/oVPHjh3bu1dd
nqCnNeo3jqevTZw4Ox5/qlu3dZde+rjjPDNkyEdr135LNL3Ub/irHTuePvfc
91eu/NdPP4XoyXf79796662bb7gBT44TZU+S8emmTRtGjvzp1CknZt2ry2NE
1YOe4v3yPn1+/P57J0H3ux566O25c9XlUY+qYO/06Ul6CxHzSkvxq992d3kA
8RdbtzqFdA8sEKYuj1hUGIUZATlRKZ5HLRx49f1HH6nLZMBbCAVE960TwoSh
FyOBqf508836KVMBFFQqqf7xxRfQoJoDzxiIoHUzY9YelPDGffepS9YewMEY
atQxYw1FBZ3inRMmW0AT+5csge1wcdxYNsFWA4ONo0a9PGYMCIAN/JV1viG6
3uo3Alu+NWtWU69e8A717jvLZ/AI44zP5HgKq8qnH7a0zC8vl0+3jhs3MxyW
Tw+sWLFywACF4bSk/c+fwtDQvHn63163v145zm/VbwQLEasbCxTOD1s479G7
36jfBPwFS3PhGWcgBIACwYRdXcWGd4iuPm3WIBarE3Gt9+LVV2NBOG8TFZk3
BEmgwjsnjvsCcNtnvTVRJp7W8QULTK3Ft4jqEpcz5Ke9mACZQKgu37Sott5y
i/b2pCsZk5BUzzc0IBCpS45zj+uMl3b2WlQ7Jk8G6lxUiAhrhg41uIBbj7Il
Yk7AYXCZ6PympQkzp7iLHnNWseotS+cg0WOjrmZgHKWvfcaCYTYZFIvhBfQE
toIpAQ6kbJ3LSBRsDxMgW+E/zBHxBmSAynYeQTKeHTZM57n3rKcQEPA0mHZp
jx5f79wpn85JpRAnzdPL6SmEI5Ihvjr7raeYCASCiX4qMUxXPzHoDPDxFBbG
XBHVlc9eGjjiMTIbdAQtYxDHamgHNoUXwwnBbHjgyGl0jzGcrrUlEPUxSPn5
xYGjHnU9RufvuOsxOiMNa2MU3EdnTs52WGM6Tl4UOOoRuucYq3gnLYRy1PK+
fT/fssWMUtorKVGjpOcPNaPCS7p2XdixI3AA18O8+saN06utjXFRNiLAc+rE
6IeI+t0FC1ouuMCsJMiHRwqscW+GeG3z+KO7FgDL8DC6tufbXFurtUQrIwJW
b8+ZA19c1rv37ocfdv4gdMkah0vAlSQvJGKkY1II8YIHrRo4EM7HsJypRGVq
FbY5fA6eoy5tm8PpX7/rLm9lR344dMieojPFnZP2MvY61D2ApnhfbK0W0CMS
Yjijjwh1OfeTkuB7eIThiCiHt23jfIAnKKQwINj3k9n5RaEgBJ4n27dff/nl
4ASQwSsvlZ2HRVUfOLY4cOzk0xpbGjj2HqKCgdoc2z5w7F3u6tQ5LHhseeDY
SUQ1Kxp94/77s4+tDBx7p+XvGM5RnzN7mGlnx2Jfbd9eZT2ZFYnA4HcGaorG
R20pSGug6OyuZJ1j7ggcTVaOC4x4xnTEIwweWBzM5veBXMjfIidaWzePHbvA
DS0O7Y5CcHlN24moOLaAYcvgwUd27XJuD+Q4zNXdtgkTMGJFv36njh/Xtcri
M8+Ey3sco160+vHkScSC7ffee1sgz6E+e7zz5JN6d/FEMrlnGiUH0rvKZGCr
1ipFmtAnGzYgpn324ovO+EDeQwJtHXdtjbCCGMt4VRwAb5XdWEPf7NunbXRr
IO/BgbwLBW0n196sC83bM5wzLq1jod7lMe/zA3kX5eAdFrzXE69BgbxKcvCK
CF7PEa9zA3mV5eAVFbzWEa8Bgbw65OAVE7zWEq/aQF4VOXjFBa9niVe/QF4d
c/BKCF5riFdfMsufb7vNW37sxwurqnTuYz4zCgo0n6TLBwVe67JlzjPEp4/r
oVhk7y5cqEehvl1QWan2GnyPSpYBcT4IoeJDBlZoKKHyXjrM1Rj3BDiacZ3M
c6tyOeEhmLHPhXGPjS9PbTXxOou09LfNmzlXMjuHipUISLnuZpb8NLzlxhu5
C/G45hrhQZjr2uHDEaWcVcSZOgPRnVOmoHIGZ9wh+aGeoLitqphNV131TF2d
jgDLzjpL18Fsbah4ee/eb86Yod8bC9HKjDKvNIU6KHP/4sVPk1Tqbqg+xZq6
uhmhEMIaj0eIQ/RUl5RzVNSA8ZCR9UpGCNF1I79HRYgEhJpdv4d8ngTLj3v8
8HfiwAEYftPo0aBoNih0ldXa1KR5QNqqQYOMDChN1+EFrk7AR0WyCtd62Lgp
r+X3MBpgKEukBD9+j8oCFlB+wih6uCh0HRR2vQklpbrs4KLQu6uQiwLTRtrW
KE0vKuRaBigUqpTgJ2PiCkLRXaCICK7tBYqIWKHtBX0kyB+s9zJ6LicU3QSK
qBhVJlBEBYoyQR/NgULG3WWEolqgiIlRpQJFTKAoFfSxHChkxG4iFF0FirgY
VSJQxAWKEkEfz4FCxvqlhKKLQJEQo4oFioRAUSzoEzlQyCzxFKE4U6CQ/dci
gSIpUBQJ+mQOFDK/UMhxOgsUclRKoJDVSUrQy32m5JcUKBZbKLDlsSOd2pNh
m2akIMpkcMU+S+/A+R6RNQO1pDf8Cl0UOvIuIhSK9OfSEfx/uaKKIQrLwBj8
H6wMq/HJS41rB2xvUSmRyahThu0b73i519/LtS82Heqcw9tn41718I4RFec+
DOKWml53yKe642KfQph+n1oX8lREdgdNr9M+78DGAgUA+Gt/YrHq8mub6tFH
eaPlWzs2FXxzURWVTkyFiYGxpAKXuUW08OWp0RFrbmZswuWtexs2lelyeV1e
zFFl16OWzrGgMvIWrnCPeKF1ThYMo5LAWCwmMOXeJi64cQFStiHVeyqHo4yF
ppwCVRwqnYFOSeXTGqpTw9wWRTEA8d95flRA3sGxhH+/NZzj2FDygvfKRFSH
qNS+sWajars+fZ5vaOC6JQYJf3nwwTT9oa5aV1+vkFjepPbpzbW188vL3a5t
rKlXL9SPPAYPn0gknh8xIsMDAWP3I48ov+C6ZEFFRUa1BN0wfHESKOuTsLhn
T+iuqWUdIUd/RdTdNLXM93L0l0RdrallXpajDxN1V00t86ccfYiou6Tt806Z
l8w9BWjKjoo6OH+Y+8+JurOmDsxGkVfGjFlSXQ3vxLpTO/9PvTFkCzalySFY
ZJ6kIlgY5p0ZDuOXT1zgtvBNXEOe4fkB8aRmaZTXyMF160DNWMjuRZAFagzD
CmiL17vEi3bwqoOzqbERi8gLQeD44erV8TY5rhk6FMX8xiuvxO8Phw45e4jj
eYQOG5Omnj2BDndgCtdmr8S+BgU1sbV4gwF2gE8kk1nR7iDe5N6hg+vXY+uz
5aabtKef/Phj7GWM52PfgL2PWmOUHfTRM/5OUzWvkqyB7sqEljeOGuWuTNWv
1pGW71Vvva5OrbNOeen/JZJCnQor3vFq/PL115EZFJVcndV5yeDOyjlChndm
p7ONXNM1ecngPfsAISMqZMhI0D8vGbzHOVvIiAkZMn4MzC4D8RnXnJ7xFgWb
rs5qhYy4kCGjzoUkA+PBBbz4+A3cg2XMIRn9hYyEkCFj1cV5yZhOMvoJGbLC
kBHusrxk0MkNd40sGYVChhdV35k3T13+7rRl/P399/lUgGQUgDnHXKw6zr76
NAIr+7VJkzB+ac+eqs9wFb2yJSAWzGjXbllNDQo9VCgYQF1/fd7NdcKSrl2R
bpE8P2xpwVTgf4rX1TQFiEMe3jR6dMvgwe8tXowKBwsTaD123M3nTngR88P0
URFwq8Krw3BteDfqTOIUc5HBhJwSgB4lp18QdeDZFwpx+/mWLSis5ldUYJX8
cPiwVxVyw5xrAtX2R0ZBMNw5daqyG1kggcjJ9Ygqu665hsGh/vjx5EmON3HG
8Mp116EORFRe1KkT74Koe83d9ThuwQjKXXvJJfABKIdb3BwVMUSfLfKXNXgB
RvPKyjB9PumADGgdcHWVBJXxCTr+QI2I/tc1a3hNxw8+99zq88/36+RmwjPU
siUXiJ+9/DKeIS8AhsoTXCEBH8+bI57yHqQSYxU6RQm9dO21qHZNfN88dqw+
3eT7DQ0NqMf/efw4+2A8m72oGac7+zY2VeVy9cr70yO7duF1gevf4K3OdSgG
hG2nqXd9JsrbS/4DOpSU/CUZ2HiOVNQmtusI2+BAbLLLJftVSR+y4Wm7sjS7
eM5dHiTOxlkxXZP26hEfJtnzkt2rlA/TRWm7fpXdN4OpQ5uYGtNe1eHDJDtg
spdV7MM0JG1XybIXZzBVZsEEFnhNa1ifcEhMsh8mO1ulPkwXpO1aXHbmDKYq
CxMG81cWkM2Y6OxZn5RITLI7Jvtc7X2YBqXtil/26Qwm6m3FcQ9Jfkx8QlUb
iEn2ymTXq9yH6Zy0va+QXTuDqbpNTHxS3y8Qk+ycyX18pQ9TbdrevcgensHU
o01MdWkvl5sdNgB58nW3gSMSXrQ2NWGncmDFiioXEfYOMyMRBF2uCDBeZ2mv
I6a/0NQdteZmMFBz5jMUG9msWGzH5MkXGkxKI7pf59UAHPrY22N4CQEvNDYi
Y8yKRJCxVP4jbHqPhPpgUVXVygEDML3egofkSZ4RBQekb2xaMJQbE/x9J6Y1
v7ISNQWitKr4aSfG59dJxoH1Ore4eGn37sjMwMTfJIEdJZCEVyuBL37X1ddD
dTr7kG8k+MsdCH922DCPTvdGatJuBuBPvJA7sZeCwQCFdl2cCYuxSr/euXPP
tGkb6IO3DSNHrjrvPOxNQYY6gE3DX2vRaWEKvLHBgZw0HXrhF9d4cqK1FZKb
+/f/YNUq8pIUC+UveQKHgBV1JwqFIBSFuDi6ezdcFOWWOvei6pzzY4p1t/GK
K9hUSNlzUin4CPZaWCZI/ajBOEOa78n4DOnkwYMLOnaEM+pverye8CcvvIAX
ToE6sAuB58xQ6JXrr2eLxfibWejm8LZtgkNUcMB4PlvxgDBdoYcEW194BHSE
ScKWGI+pqnVH8ZAlFnveAaH85SOKTSgD1ms++2xQgz38DbE++LwOMODcMAfn
5xRvQRmoKsNCIQajvk6ur2eXIg3H2aNQvsIPgMJjRHxigXz0CYoHScv0MOEP
08XQfbNn4xpWwozZD2mPxhmz0D9nPFH7a5q2Wj88VzjKtgkTVMzzqiDwVt8B
lrsxB3j3PPYYXjAF5qS/gShwKbbffTcvE68z6MVJwhRmPfBqLPgP+HbJgZXn
glUHEd6XH2F7urTv4914KlA3aeqVePRhvd696gdhAUW1PteUPQNzbsn3Jm6E
fBrp69NIKE+enbNg43v+NlVpIeTTAsnmvBwL1EKA5iJpu5qTp5ay6yC/NBEn
xBmaqPFpIpwnz6os2KQmwr5ZUU7hLJdFE37tRdN2DSlPTmVvRH4nI06pMzTR
3aeJSJ48O2bBFhGaiPhmRVbgDnsWTfi1F0vblas8vZUdHPmVjzgpz9BEF58m
5KlELp4VWbBFhSaivllR9uQOfxZN+LUXT9v1sjxBln0m+Y2SOK3P0ESVTxOx
PHl2yIItJjQR882K/JG/a8iiCb/23FO24FNs2Q2TX1iJLwYyNFHh00Q8T55l
WbDFhSbivllVkya6tKEJv/bcf4UVfJIue3by+zDx1UKGJsp8mkjkybMkC7aE
0ETCNyvSAZ+pqG+OhRr8mnP/pVpKSCoUiFMCcVIgFj0PcClyn3haSObJsygL
tqTQQjJzVph2Z6MFtdfSPsBzApOMbyTYX4zlec9n3pt/yeh9g6Hxevz0v8Hj
e8w44+sH8MvQab78Th+fd6/rYjpt+Rl8e/DLuXLa/RuKl26e\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{271, 303},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->107869266]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1647530537],

Cell["Render vertices using a custom graphic:", "ExampleText",
 CellID->2039050761],

Cell[BoxData[
 RowBox[{
  RowBox[{"gr", " ", "=", " ", 
   GraphicsBox[RasterBox[CompressedData["
1:eJzNletb2lgQxksIYLgbuYUgmIBoETwFaiByhCiCchGqou4SCha8UYko0uyK
bO2fvgd3taJut89+2nme8+133rwzczLDNLs7TezNmzfv0Ami8+3/FQTxk9jw
D4KoVH6CHv5WUuiWlSpV499g4otCd3S02IltJZPmyg/JyhfF0eJip9O5u4km
k3KN+NvVa/azh7rFlU5nBYWxvncBkQ+i0lCp5FccER9+XxmRo5NxaAFUmWUI
AQAQqobPUGJYcN6t3EcHwa6LEQe0B9fi1ku4Jk+oTSP0zihJ0lkUXLm8EmZw
X0t7L2Ez1DoQHI5NFLQHoljGLg2zs5PuS4wGQEU8h0HckbmJ10mSTMXoiHt6
EgV/2TR4X8I1COJtiSYnCgUvSfLuyUlrJLLKI/lVAM1PYaKiQukoxXKMRrrb
tMgHI8GFhaVf1y7dhsjFmOeaDMBVVLwuk3SuUC/TB6sLS0tLC2uGaeulm++u
A/kRHsoguj8V4YPidjweLxRoYW1hMhI5VtD8tPW92y0C8GijAaOXQZTNbJBe
jseX53NcqL3aX86mPbvBWfd7Azb1KEyY986qo8R5nu/7Pn78GOB02ZK/WEyH
OQHBmKF5Bh9elLmx2kT3+YXjY6H+7t0vYY2CUhzqdkt06Ja1zkYiBkz5wDb0
ViloRdlM9wXnPetP7+j1qZKHpW/ZY6u7yV/VHsvg4lHik2skVRqxPs6fTbVa
dcrD1ukAy89K1+sPhRjCq7J1ullO+XsK58zbtx7B3/MhE2mP0LZ42M2qu/vY
O9RhEK16T/zpUs53K3D9uWIxq9DupOvsnMUSy4nk2ffWoQKDT7GTXEu/qVNQ
IbZe7CG/jpKDEwStNyRqgfl74xoQXMQ02y39MkVlNZv9XjHcau2WSI5lb8uh
DQAbTx6ECibJz/OHCi4330I3/MUdje601+ZSCOZIAGvfngon6ZPs5xNNDxUg
NfLbo041Ni7WFlhuH8CnP3cFrm/7J/StnN8zkTvspalTXcDhaQdSFm1fIC/g
cJylKSS5W8xSSPEwYEsYM7jthnVZUtzG1ZhuDcp0b1OjuQdNbczJ2O32AT4l
7JBebmNrjG1AOeWn/L3Tw7k2psYRyNxIzEAd5gK+0EuWpiiFz9a+GYF2RrLM
V2fuGEwIsZxX+cyDst2f6p6bEIeHu7j9Q0v/NaFmTDaOCx1ge+M128cSpntF
zPIhkQ/glvOv+SpjT+yEJq4PnvYC6W7Z7PaAAzPa51r699U8blwcfM0ncFw6
E6PjvSBk0DY6bC1LgsHnfTP5vNNuYnQZtZPpiqMBNzYiajA55ZzXu9B3mcWj
TL5qGuCZo4HTgZ0BKD+byWaw1XXO4TPq8wHD6HB1Hs/Yzk0JDHOB5+j9j6/G
cR0+4xzcZuyD7lRXTK6DT16gejnpzWC97axnBkfGsE301q8xbOPVETyKigz2
RLVDCu9j2D6iPpFKNLRrr2+mhgy3yq4roDyQUOoQyqraPy4lNAFlNALhX1yj
8uPNSAzRRlGZG5XhT23QVxfVf4o/ATcZvLs=
     "], {{0, 0}, {44, 48}},
     ColorFunction->(Apply[RGBColor, 
       Part[CompressedData["
1:eJx9l9duXFUUhkeIB6D3It6AKjrrFSD0LiFxDQiJqgCXXKY4idO5QAghLuKE
UJw4TiMkhCQee8b2zNjjqR57WjokEEpW+dfW2Ufmk6yR9dtn9l7lX+vc9cZb
y968IpPJfHb558rLP48IbXpYWKTJPNOkjHCKrhJW0HXCAN0kfO76fUKdbhDm
qVhgFl0/e4ap0dtChV4UCq7r74s0U2I6pJx0fZkwTrcLx+gaYb/r+N7fzzNN
ekqouq7nKdjzS/SyUHJ97yhzkipzTPhefJZnBVq1kqnSu0Ld9Q+EBXpOmLfz
1lx/QGjSrmGmTX9eZEJ8Nm1kjtLqVcy43W+767cIRVq7hslTdkxw/R2hSq8K
szQ1Kbi+cQPTps2bmC69LoR73iqUaDzLVC2eh1wfWM0coDUDzEE7x89R/L+n
G4Uf6Hphp+v3CFXP07NCqC+tqxzdLBRocB3zi+vXCgc877cJu13X8zRpx3am
Rls2M7Ou671/szj+aucMz39c6NHIbqZr5wj50X7IW3yyFq+jruv3HaOtW5jj
dIdwPIrPpOfxFWHG9cK0YHmZo/WDzGHXV65gxqy+Ju18P7k+MS54/eDvk/kv
WhwnUvE9d5ap09VClV4Siq4/LdS9rjesZ0L/4t6oS/QrdNQjzh/rWi95y+sM
3SmMuv6a0Lc+7FGpyLRd19+LqT6BPjsj0N1CxXwk1Me9Qs3zq/52OFW/6g9z
ND0luA5fSPZ/uB/6BvWHfoF+/hzToPuFhtVP2fXnhZblueZ+lIzvvOWtbfEL
/a3+0vH45iYE17WvQt3Aj6Brve+y+thn82Bbqn+RZ/gtdPiCxvVH+/svU/X3
obDo9QwdcUEdwq+gq5/kvU9RZ9Axf/CJeQVd++kIfbGVOWF5Go78p+7+cvoU
U3EdcYEv6d/vcP1BoeU+HOcHOupI4x/up/3aoo+EtvdDsj6m6AVhOuX/qG/0
tz4v1C/mqurZlD/oPM16n+pn8P/lQo/+vsR0CfvEUvU5uocJ51f/KPv5NQ7Z
qL/bfv+HhAXX161lDpkvHfH7QMfeoXVbcZ+Arr5VoaFtTCXVf5qvEz43UM/x
/yO+mMfQ//2H6XvesAck66dqc7Zuz2+5/pjQpY+FDl28wIT7Yx4jb4gD9HyO
aXge4v1Ov3ciym/wT8wr7E+x/6E/4E9zZcH1T4S+xwH7FnTsBZi7qKNk/Eet
LvaZfxx0/UlhzH0DPhA/H32hdRDmI86L+fCMkEvtPzpf91u+hqL9bNjqbsSe
v9d13ct69ITQN58J98feBR+L9zudHzn32Xi+qO90vQ8/FcLzUS/om9j/4Nda
n2WvR+jo9+Qe9U20HzXp0l9Mx/y547r29YLFteH9CB1zB/tLvF/uGWF61pd9
32Pj+z8qdLzOoWNfQx9jzkPHvoU5gHkd50/3vJ73Y/z/OLfeJ+T/faFFZ04z
VZ/Dyf4f8r0/nh/vCeG9CnWUvP+3nhet969c17n7tc9t/X3Q9Z3fMQ268AfT
St0PcUd9xe8veD6+P94P4Ovwjbh+tf/67hPx/VC3qKt4fsbn0z7spd5Pl/J3
zEP0PfZZ6PDPpfKHfQxzG34KHe+z6MvY/9A3eP9FPUPXeTDlczh+/8X7JeYb
3qOg//9nJvMf6hIGPA==
        "], #]]& ),
     ColorFunctionScaling->False],
    Background->None,
    ImageSize->{29., 33.},
    PlotRange->{{0, 44}, {0, 48}}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->876584969],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"1", "\[Rule]", "6"}], ",", 
     RowBox[{"1", "\[Rule]", "9"}], ",", 
     RowBox[{"3", "\[Rule]", "9"}], ",", 
     RowBox[{"7", "\[Rule]", "9"}]}], "}"}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Inset", "[", 
       RowBox[{"gr", ",", "#1"}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->280649582],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{200, 176},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->6963593]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["A food chain:", "ExampleText",
 CellID->375287187],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<John\>\"", "\[Rule]", "\"\<plants\>\""}], ",", 
     RowBox[{"\"\<lion\>\"", "\[Rule]", "\"\<John\>\""}], ",", 
     RowBox[{"\"\<tiger\>\"", "\[Rule]", "\"\<John\>\""}], ",", 
     RowBox[{"\"\<tiger\>\"", "\[Rule]", "\"\<deer\>\""}], ",", 
     RowBox[{"\"\<lion\>\"", "\[Rule]", "\"\<deer\>\""}], ",", 
     RowBox[{"\"\<deer\>\"", "\[Rule]", "\"\<plants\>\""}], ",", 
     RowBox[{"\"\<mosquito\>\"", "\[Rule]", "\"\<lion\>\""}], ",", 
     RowBox[{"\"\<frog\>\"", "\[Rule]", "\"\<mosquito\>\""}], ",", 
     RowBox[{"\"\<mosquito\>\"", "\[Rule]", "\"\<tiger\>\""}], ",", 
     RowBox[{"\"\<John\>\"", "\[Rule]", "\"\<cow\>\""}], ",", 
     RowBox[{"\"\<cow\>\"", "\[Rule]", "\"\<plants\>\""}], ",", 
     RowBox[{"\"\<mosquito\>\"", "\[Rule]", "\"\<deer\>\""}], ",", 
     RowBox[{"\"\<mosquito\>\"", "\[Rule]", "\"\<John\>\""}], ",", 
     RowBox[{"\"\<snake\>\"", "\[Rule]", "\"\<frog\>\""}], ",", 
     RowBox[{"\"\<vulture\>\"", "\[Rule]", "\"\<snake\>\""}]}], "}"}], ",", 
   "Left", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1003312068],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxVVH00lFkYf41mBsOYIn2wbTltSjgtojraW1m7rbWUTGURKhRt2qhTog+F
U6g09pTObh+2NrtZo9pYurl312oUaslnlGmEGJ/jI8YYO+/7Xn/s79w5z/nN
PPe5z9zffX6Ldkb7hnEoijqs+9CRAK+vliyz8WmDhJ+k/gcDrCgKKike7YEc
wtumaPQDUgP3Es5SEak3ROqZ44yysaEB6zE4yuYhLvP9AGJ/n0vqa0i+FZ63
LfTzDe3UY4rksfVewul9pA7gkn5UDJ8CWibwsZDk5Vy7l9oAplCJ3bE6p2YF
3JnhOBAbpUVfFlcMCgIU0KEx0b4xcRK9OZp0XPr8LRTEZLvrJWtQYlTOsQUu
b6E6lN4wgZwuOHdtz5BD9S0feiHF0y3nH+NWaOz2+urHFuPoaJNoecgXb+AK
mzXmIeUfkO03N3KyHrTAcAajaGQxhx9p0AxvM9uHUZVDVR13cxNsW3Vet4bQ
7VVXbt3MaoDWDFQoYcOumLWKOhgqKAgRFAwgsZfDhibbWvhZl0S3+pD91nHR
oZgaCB/RUCJuyD+tIvgvXE2Xa3uPHr1cEORv+BzSu0MEHSiq8w/1xavPoBOD
NmQ54XmlfLkMMtcTLUf3fhOK99aVwirT1MxTd5rRrEv2m1qkGFrs+0u36tHx
nT5m7ocfwXlHilcCuxoULVJzDvY9hL9G9ChGXlSgMfuAaI/yfChhGixFDofb
8+P4ObC1q16Tv7EIubRyxsNPX4Nq28qzQm4Oalq4jFenSYO5RJ/p9xNO9Okj
3JHoM81NiT79hGuJPgOETxF9pvlMos8g4SuJPtM8iuijIhz9IvZ0o0bQuq1i
ze62fuD2w8QR5e0htMxfPChJ7wfvPt2uitmmQr8bUK1p2j7wMD6qoM58EFXs
Fpf5uPSBUGXkuUWwH535TnyrxbkX5K7et9YzvBc1WlPxTmol8Hz3KumTpUok
OyP28kvuBmuVBbse6HWhTRLxbND0Hpz2phqGVB0olo1gsZtr0qWwNjSHjWDk
tduc7XPlqJuNoDfCev5Zi1eohY3AN35PlTS+FnmwETiqLl/c+OQ5WsBGcApm
za6SlKFYNgIbae6WV6XFyIKNINvEdeXPf+egS2wE+kEmds4/mmJQkqMZVv0J
Ik8oRS1LTLHzrIuKhMUVwDXiat6H60Lsm+ZvkUTVg73m87kpfCF2LdqRdyGl
FeilRJqfCzLB7bK7gVKzdjBZktpCZRtjrkG25Xh/NwiGCUHKWgE+LjQ855s7
AJacWHf5q1EjHKavzW5aMgx8+bVnLXlGuFAhbczo/ABCJTeC118wxPfzlAKv
5HFQuaZeb0xkiO9wg63Dn6qBZDL2AEg1wJmdhlby/AlQ2Bx/d46Wj+P8esaK
3DTAta73/sm9fOzvxSsa2qcBZt2y5LgqHl7xYltg+noN+Hq+wIZry8N6r+WK
5OIJIA8rlCw8wcUVh256yRvUoLqSxgycnkVjHETRz99yBi5tLFNedx0Dk8x7
1MfvS63D5F2jINmefsAcrP42nxuQPwJ4PoUdKR4crPlpv27UhkHCE4cdU1AP
K9OCoPboEOhhBkgPl9sk1NgkqMBmOv0ZhTPp9MxBkMcYDIW9Q71jl+IB4PeC
PtgUB9qzc3VvIz2hpthYyc4dO79CbAPYuUxaXX2TchfiNXvYudUl6TaY4BAy
1/E19MEmOJDMPfcafbAxnilifeGy2UdGK94JMCK+4cj4iQBvIb5SzfRthK2Y
RtrRASvZ91YyQ3yQ6bMTiWbSMMRbiU9JdbfCDTDA5b17DgYndSFvxmD5WEZ4
HwMe9iP56Yxh8vB+Us+O8QcutiDnVRJ9vEg/EUSfQtLvONFHQ3wukejjTv6v
PtHHg9xHHNFHS3yui+jTQXzOh+hzqpu971yij4sdq8d/4PrtEg==
    "], {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.019671594508975713`, 0.7}}], 
      ArrowBox[{1, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
        30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 2}], ArrowBox[{1, 8}], 
      ArrowBox[{3, 1}], ArrowBox[{3, 5}], ArrowBox[{4, 1}], ArrowBox[{4, 5}], 
      ArrowBox[{5, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55,
        56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 2}], ArrowBox[{6, 3}], 
      ArrowBox[{6, 4}], 
      ArrowBox[{6, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
        82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 5}], 
      ArrowBox[{6, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 
       106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 1}], 
      ArrowBox[{7, 6}], ArrowBox[{8, 2}], ArrowBox[{9, 7}], 
      ArrowBox[{10, 9}]}, {InsetBox[
       FrameBox["\<\"John\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["\<\"plants\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["\<\"lion\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["\<\"tiger\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["\<\"deer\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["\<\"mosquito\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["\<\"frog\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7], InsetBox[
       FrameBox["\<\"cow\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 8], InsetBox[
       FrameBox["\<\"snake\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 9], InsetBox[
       FrameBox["\<\"vulture\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 10]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{-2., -2.1437508791444563`*^-15}, {0., 
     0.}, {-3., -3.2156263187166847`*^-15}, {-3.000000000000001, 
     0.9999999999999968}, {-2.000000000000001, 
     0.9999999999999979}, {-4., -4.287501758288913*^-15}, {-5., \
-5.3593771978611406`*^-15}, {-0.9999999999999989, -1.000000000000001}, {-6., \
-6.431252637433369*^-15}, {-7., -7.503128077005597*^-15}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{404, 159},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{400, Automatic}},
 CellLabel->"Out[1]=",
 CellID->159527292]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1346376454],

Cell["A  chart showing relationship between shapes:", "ExampleText",
 CellID->1385760061],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<Square\>\"", "\[Rule]", "\"\<Rectangle\>\""}], ",", 
     RowBox[{"\"\<Rectangle\>\"", "\[Rule]", "\"\<Parallelogram\>\""}], ",", 
     RowBox[{
     "\"\<Parallelogram\>\"", "\[Rule]", "\"\<Four-sided Polygon\>\""}], ",", 
     
     RowBox[{"\"\<Trapeoid\>\"", "\[Rule]", "\"\<Four-sided Polygon\>\""}], 
     ",", 
     RowBox[{"\"\<Rectangle\>\"", "\[Rule]", "\"\<Trapeoid\>\""}], ",", 
     RowBox[{"\"\<Four-sided Polygon\>\"", "\[Rule]", "\"\<Polygon\>\""}], 
     ",", 
     RowBox[{"\"\<Polygon\>\"", "\[Rule]", "\"\<Shape\>\""}], ",", 
     RowBox[{"\"\<Circle\>\"", "\[Rule]", "\"\<Ellipsoid\>\""}], ",", 
     RowBox[{"\"\<Ellipsoid\>\"", "\[Rule]", "\"\<Shape\>\""}], ",", 
     RowBox[{"\"\<Triangle\>\"", "\[Rule]", "\"\<Polygon\>\""}], ",", 
     RowBox[{
     "\"\<Equilateral Triangle\>\"", "\[Rule]", 
      "\"\<Isosceles Triangle\>\""}], ",", 
     RowBox[{"\"\<Isosceles Triangle\>\"", "\[Rule]", "\"\<Triangle\>\""}]}], 
    "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "1.5"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1391178397],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 5.}, {0., 4.}, {0., 3.}, {1., 2.}, {1., 
    3.}, {1., 1.}, {1., 0.}, {0., 2.}, {0., 1.}, {2., 2.}, {2., 4.}, {2., 
    3.}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.023064257028112448`, 0.7}}], 
      ArrowBox[{1, 2}], ArrowBox[{2, 3}], ArrowBox[{2, 5}], ArrowBox[{3, 4}], 
      ArrowBox[{4, 6}], ArrowBox[{5, 4}], ArrowBox[{6, 7}], ArrowBox[{8, 9}], 
      ArrowBox[{9, 7}], ArrowBox[{10, 6}], ArrowBox[{11, 12}], 
      ArrowBox[{12, 10}]}, {InsetBox[
       FrameBox["\<\"Square\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["\<\"Rectangle\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["\<\"Parallelogram\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["\<\"Four-sided Polygon\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["\<\"Trapeoid\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["\<\"Polygon\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["\<\"Shape\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7], InsetBox[
       FrameBox["\<\"Circle\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 8], InsetBox[
       FrameBox["\<\"Ellipsoid\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 9], InsetBox[
       FrameBox["\<\"Triangle\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 10], InsetBox[
       FrameBox["\<\"Equilateral Triangle\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 11], InsetBox[
       FrameBox["\<\"Isosceles Triangle\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 12]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 5.}, {0., 4.}, {0., 3.}, {1., 2.}, {1., 
     3.}, {1., 1.}, {1., 0.}, {0., 2.}, {0., 1.}, {2., 2.}, {2., 4.}, {2., 
     3.}}]& ],
  AspectRatio->1.5,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{229, 276},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->370603595]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2067401904],

Cell["A flow chart for a computer program:", "ExampleText",
 CellID->1535971162],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<total\>\"", "\[Rule]", "\"\<TotalDispatch\>\""}], ",", 
     RowBox[{"\"\<TotalList\>\"", "\[Rule]", "\"\<CheckThreading\>\""}], ",", 
     
     RowBox[{"\"\<TotalList\>\"", "\[Rule]", "\"\<TotalDispatch\>\""}], ",", 
     RowBox[{"\"\<TotalSparse\>\"", "\[Rule]", "\"\<TotalDispatch\>\""}], ",",
      
     RowBox[{"\"\<TotalSparse\>\"", "\[Rule]", "\"\<TotalDispatch\>\""}], ",",
      
     RowBox[{"\"\<TotalDispatch\>\"", "\[Rule]", "\"\<TotalDispatch\>\""}], 
     ",", 
     RowBox[{"\"\<TotalDispatch\>\"", "\[Rule]", "\"\<TotalList\>\""}], ",", 
     RowBox[{"\"\<TotalDispatch\>\"", "\[Rule]", "\"\<TotalPacked\>\""}], ",",
      
     RowBox[{"\"\<TotalDispatch\>\"", "\[Rule]", "\"\<TotalSparse\>\""}]}], 
    "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1176460123],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxd1AlMFFcYB/BhqSClrRCsCNJYBEQ5DIcoWOEbBBXBIlosSMRF2JWt4sEh
pqhpCyKLLoeKUqjAcrpAdGkQgdD6lEPAgF0KgoVlOQILK5bC7CLHXi34tNF/
Mnn5Zibz3pt8v2caevoAk0YQRPB/1+L4fpaTH9zA9RTCI7xff5h3z9+NbLs1
+bKmSiSzSrn0YEoJmxPjXNqda5Guv7PnR0wlDDCSHIj5h+iKRWNbjFAByRxH
NT2+Hnn7RU86BCjgfFMH3+BuE0rwOXmG9VwO621LiBx5C5K4F2u6BcgBiqyu
UhFtyGPr6i19wgX4ZGleATq2lAV41raYEbxeGbBP2UU8qB1Fif7M/bkpUuhO
8Na+cE+MCptWcqPXSmF5Zu+goGwM3XVeOFtQRcHPXLGQeW8cpUWK1T5+FBj7
sLMkNRK0N3aDZvo/02DEO8Ne/vQl2s/L7OTcmIaJg8Y6J4cmkHalvjd9+zTU
k+Y2u4Kz4XWda451kAq8thEJk7FcEB70q6kbV8K1HVs0KqEQcnvaGVGxSjgx
HGaszy6Gw6d3nYvWVMKy35Oy9u+7A8eTXZTDaQrYk0RvHM3gwTq3FvvRNQpI
9LBkhweWQnDkoajcO3LgZi2mFOwdF/N/3b70H2QQj9/PTy1JORooAw/8PeHj
rc+MR6Qg/+3NfDdjn9C+OCOFI3g9Bem1bI6Cgp/wekM2OPySkkyBE96PWRl/
t6chBTfxfnU860O7iqfh5m7/wCinO5Acs5HLj9cgE7bvnIqUVoCObUaLZFaD
1GY52EFcLXB5vlR4CI1s+NWZ0X2kHmbTGQ/rHtBIrdS4FZMGrbDJ2jaB9ZpG
tlP7rt9wF4BXtRex1kSTdPIzePLUvAt6MvRZEgtN0or78bFhdQ/kiFNidhpo
klUg8uHk9cH6uW4b61EaKSpP1L/WKQJ/cT9B5NJI46EiAa9mEBINV43FutNI
wrZ5o7psCNoqPc3pXRqk6RUHPcfNw+A2E7yXcViDrDbpHV/39TCoS+b+qB8g
yNDtkyPxsiE4QLrSZhgEaTMkJCc3DcFcw9NntSNqOPvp5flSrUEw/TwoRbRG
DcLyEF/nVf1g6Jba2fK9Cvwv99ip8v6Cbxyq/Ea1VJBdzSypevEc6vUY1Tat
SpAwP9tRTHXARZcmr64GJeiGlfoGebTBpQo9C7NZJXxnbZKx0b4Jfgi3zDoV
ooKpLOEJ96S/0YrnUef3rKAgiC8IFL94hebKm+vk2RQwDfjzA1++Qud6v3K8
aiYFkYkjwaJPoBo+R7+dJ4WCVN2VdRkv0Y/3r6dlWsmgOqYbrX4sQUYPgxSP
eTKgvnUKbhgZR49axlrNzWZArl7MGLq91Gcz8MZdN/amAGpdnuUNThe6UJ59
72iUAgLnjk9rF/6J6Nsm6JxBBUx3eLsdKRMg/+ZlV4K9lVB4kclh7WpHUalG
xH2+Em53irIOmbSiquQexWk9FeTTXUX9PY2oIoBlEx2hggDerT6fuEdoYe9k
FbdB9dYb0sX9h70hC9yf2BsKw/2LvaFi3N/YG8rE/Y+9oQHsA3tDRdgP9oUE
2NfbejP2h72hEOwTe0MW2C/2hiKwb+wN0bF/7A3l4/MBe0MifH5gb2gOny//
Aryezb0=
    "], {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028937842778793417`, 0.7}}], 
      ArrowBox[{1, 2}], ArrowBox[{2, 6}], 
      ArrowBox[{2, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
       22, 3}], 
      ArrowBox[{2, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37,
        38, 5}], 
      ArrowBox[{2, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53,
        54, 55, 56, 57, 58, 59, 60, 61, 2}], ArrowBox[{3, 4}], 
      ArrowBox[{3, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76,
        77, 2}], 
      ArrowBox[{5, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92,
        93, 2}], ArrowBox[{5, 2}]}, {InsetBox[
       FrameBox["\<\"total\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["\<\"TotalDispatch\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["\<\"TotalList\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["\<\"CheckThreading\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["\<\"TotalSparse\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["\<\"TotalPacked\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 3.}, {0., 2.}, {-1., 1.}, {-1., 0.}, {0., 
     1.}, {1., 1.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{246., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{250, 333},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1454110840]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1032973183],

Cell["\<\
A visual representation of straight line program, used for common \
subexpression elimination:\
\>", "ExampleText",
 CellID->807193109],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"e1", ",", "e2", ",", "e3", ",", "e4"}], "}"}], ",", 
    RowBox[{
     RowBox[{"e1", "=", 
      RowBox[{"x", "+", "1"}]}], ";", 
     RowBox[{"e2", "=", 
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{"x", " ", "e1"}], "]"}], "+", "1"}]}], ";", " ", 
     RowBox[{"e3", "=", 
      RowBox[{"e1", "+", 
       RowBox[{"Sin", "[", 
        RowBox[{"x", " ", "e2"}], "]"}]}]}], ";", " ", 
     RowBox[{"x", "+", "e3", "+", "e1"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->319348057],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "f"}], ",", 
     RowBox[{"e3", "\[Rule]", "f"}], ",", 
     RowBox[{"e1", "\[Rule]", "f"}], ",", 
     RowBox[{"e1", "\[Rule]", "e3"}], ",", 
     RowBox[{"x", "\[Rule]", "e3"}], ",", 
     RowBox[{"e2", "\[Rule]", "e3"}], ",", 
     RowBox[{"x", "\[Rule]", "e2"}], ",", 
     RowBox[{"e1", "\[Rule]", "e2"}], ",", 
     RowBox[{"x", "\[Rule]", "e1"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->72889040],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->23123411]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->96937192],

Cell["\<\
The relationships between early versions of the Unix operating system: \
\>", "ExampleText",
 CellID->56559456],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<5th Edition\>\"", "\[Rule]", "\"\<6th Edition\>\""}], ",", 
     RowBox[{"\"\<5th Edition\>\"", "\[Rule]", "\"\<PWB 1.0\>\""}], ",", 
     RowBox[{"\"\<6th Edition\>\"", "\[Rule]", "\"\<1 BSD\>\""}], ",", 
     RowBox[{"\"\<6th Edition\>\"", "\[Rule]", "\"\<Interdata\>\""}], ",", 
     RowBox[{"\"\<6th Edition\>\"", "\[Rule]", "\"\<LSX\>\""}], ",", 
     RowBox[{"\"\<6th Edition\>\"", "\[Rule]", "\"\<Mini Unix\>\""}], ",", 
     RowBox[{"\"\<6th Edition\>\"", "\[Rule]", "\"\<Wollongong\>\""}], ",", 
     RowBox[{"\"\<PWB 1.0\>\"", "\[Rule]", "\"\<PWB 1.2\>\""}], ",", 
     RowBox[{"\"\<PWB 1.0\>\"", "\[Rule]", "\"\<USG 1.0\>\""}], ",", 
     RowBox[{"\"\<1 BSD\>\"", "\[Rule]", "\"\<2 BSD\>\""}], ",", 
     RowBox[{"\"\<Interdata\>\"", "\[Rule]", "\"\<PWB 2.0\>\""}], ",", 
     RowBox[{"\"\<Interdata\>\"", "\[Rule]", "\"\<Unix/TS 3.0\>\""}], ",", 
     RowBox[{"\"\<Interdata\>\"", "\[Rule]", "\"\<7th Edition\>\""}], ",", 
     RowBox[{"\"\<PWB 1.2\>\"", "\[Rule]", "\"\<PWB 2.0\>\""}], ",", 
     RowBox[{"\"\<USG 1.0\>\"", "\[Rule]", "\"\<USG 2.0\>\""}], ",", 
     RowBox[{"\"\<USG 1.0\>\"", "\[Rule]", "\"\<CB Unix 1\>\""}], ",", 
     RowBox[{"\"\<7th Edition\>\"", "\[Rule]", "\"\<2 BSD\>\""}], ",", 
     RowBox[{"\"\<7th Edition\>\"", "\[Rule]", "\"\<32V\>\""}], ",", 
     RowBox[{"\"\<7th Edition\>\"", "\[Rule]", "\"\<Xenix\>\""}], ",", 
     RowBox[{"\"\<7th Edition\>\"", "\[Rule]", "\"\<Ultrix-11\>\""}], ",", 
     RowBox[{"\"\<7th Edition\>\"", "\[Rule]", "\"\<UniPlus+\>\""}], ",", 
     RowBox[{"\"\<7th Edition\>\"", "\[Rule]", "\"\<V7M\>\""}], ",", 
     RowBox[{"\"\<PWB 2.0\>\"", "\[Rule]", "\"\<Unix/TS 3.0\>\""}], ",", 
     RowBox[{"\"\<USG 2.0\>\"", "\[Rule]", "\"\<USG 3.0\>\""}], ",", 
     RowBox[{"\"\<CB Unix 1\>\"", "\[Rule]", "\"\<CB Unix 2\>\""}], ",", 
     RowBox[{"\"\<32V\>\"", "\[Rule]", "\"\<3 BSD\>\""}], ",", 
     RowBox[{"\"\<Unix/TS 1.0\>\"", "\[Rule]", "\"\<Unix/TS 3.0\>\""}], ",", 
     RowBox[{"\"\<USG 3.0\>\"", "\[Rule]", "\"\<Unix/TS 3.0\>\""}], ",", 
     RowBox[{"\"\<CB Unix 2\>\"", "\[Rule]", "\"\<CB Unix 3\>\""}], ",", 
     RowBox[{"\"\<3 BSD\>\"", "\[Rule]", "\"\<4 BSD\>\""}], ",", 
     RowBox[{"\"\<V7M\>\"", "\[Rule]", "\"\<Ultrix-11\>\""}], ",", 
     RowBox[{"\"\<Unix/TS 3.0\>\"", "\[Rule]", "\"\<TS 4.0\>\""}], ",", 
     RowBox[{"\"\<CB Unix 3\>\"", "\[Rule]", "\"\<Unix/TS++\>\""}], ",", 
     RowBox[{"\"\<CB Unix 3\>\"", "\[Rule]", "\"\<PDP-11 Sys V\>\""}], ",", 
     RowBox[{"\"\<4 BSD\>\"", "\[Rule]", "\"\<4.1 BSD\>\""}], ",", 
     RowBox[{"\"\<Unix/TS++\>\"", "\[Rule]", "\"\<TS 4.0\>\""}], ",", 
     RowBox[{"\"\<4.1 BSD\>\"", "\[Rule]", "\"\<8th Edition\>\""}], ",", 
     RowBox[{"\"\<4.1 BSD\>\"", "\[Rule]", "\"\<4.2 BSD\>\""}], ",", 
     RowBox[{"\"\<4.1 BSD\>\"", "\[Rule]", "\"\<2.8 BSD\>\""}], ",", 
     RowBox[{"\"\<2 BSD\>\"", "\[Rule]", "\"\<2.8 BSD\>\""}], ",", 
     RowBox[{"\"\<TS 4.0\>\"", "\[Rule]", "\"\<System V.0\>\""}], ",", 
     RowBox[{"\"\<4.2 BSD\>\"", "\[Rule]", "\"\<4.3 BSD\>\""}], ",", 
     RowBox[{"\"\<4.2 BSD\>\"", "\[Rule]", "\"\<Ultrix-32\>\""}], ",", 
     RowBox[{"\"\<2.8 BSD\>\"", "\[Rule]", "\"\<2.9 BSD\>\""}], ",", 
     RowBox[{"\"\<2.8 BSD\>\"", "\[Rule]", "\"\<Ultrix-11\>\""}], ",", 
     RowBox[{"\"\<System V.0\>\"", "\[Rule]", "\"\<System V.2\>\""}], ",", 
     RowBox[{"\"\<8th Edition\>\"", "\[Rule]", "\"\<9th Edition\>\""}], ",", 
     RowBox[{"\"\<System V.2\>\"", "\[Rule]", "\"\<System V.3\>\""}]}], 
    "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->116427380],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28025563],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxVmAk8VOv/x4exRJrFzDBjN9quuIoW2p6vf5u4JFSKFluptJdKV6kolUSW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    "], {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.01662309542902967, 0.7}}], 
      ArrowBox[{1, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73,
        74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 2}], ArrowBox[{1, 3}], 
      ArrowBox[{2, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99,
        100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 4}], 
      ArrowBox[{2, 5}], ArrowBox[{2, 6}], ArrowBox[{2, 7}], ArrowBox[{2, 8}], 
      ArrowBox[{3, 9}], ArrowBox[{3, 10}], ArrowBox[{4, 11}], 
      ArrowBox[{5, 12}], 
      ArrowBox[{5, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122,
        123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 
       13}], ArrowBox[{5, 14}], 
      ArrowBox[{9, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148,
        149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 
       12}], ArrowBox[{10, 15}], ArrowBox[{10, 16}], 
      ArrowBox[{11, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 
       174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 
       188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 
       202, 203, 204, 205, 206, 34}], ArrowBox[{12, 13}], 
      ArrowBox[{13, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 
       218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 
       232, 28}], ArrowBox[{14, 11}], ArrowBox[{14, 17}], ArrowBox[{14, 18}], 
      ArrowBox[{14, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 
       244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 
       258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 
       272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 
       286, 287, 288, 289, 290, 291, 292, 293, 294, 19}], ArrowBox[{14, 20}], 
      ArrowBox[{14, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 
       306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 
       320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 
       334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 
       21}], ArrowBox[{15, 22}], ArrowBox[{16, 23}], ArrowBox[{17, 24}], 
      ArrowBox[{21, 19}], ArrowBox[{22, 13}], ArrowBox[{23, 26}], 
      ArrowBox[{24, 27}], ArrowBox[{25, 13}], ArrowBox[{26, 29}], 
      ArrowBox[{26, 30}], ArrowBox[{27, 31}], ArrowBox[{28, 35}], 
      ArrowBox[{29, 28}], ArrowBox[{31, 32}], ArrowBox[{31, 33}], 
      ArrowBox[{31, 34}], ArrowBox[{32, 40}], ArrowBox[{33, 36}], 
      ArrowBox[{33, 37}], ArrowBox[{34, 38}], ArrowBox[{34, 19}], 
      ArrowBox[{35, 39}], ArrowBox[{39, 41}]}, {InsetBox[
       FrameBox["\<\"5th Edition\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["\<\"6th Edition\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["\<\"PWB 1.0\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["\<\"1 BSD\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["\<\"Interdata\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["\<\"LSX\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["\<\"Mini Unix\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7], InsetBox[
       FrameBox["\<\"Wollongong\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 8], InsetBox[
       FrameBox["\<\"PWB 1.2\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 9], InsetBox[
       FrameBox["\<\"USG 1.0\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 10], InsetBox[
       FrameBox["\<\"2 BSD\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 11], InsetBox[
       FrameBox["\<\"PWB 2.0\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 12], InsetBox[
       FrameBox["\<\"Unix/TS 3.0\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 13], InsetBox[
       FrameBox["\<\"7th Edition\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 14], InsetBox[
       FrameBox["\<\"USG 2.0\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 15], InsetBox[
       FrameBox["\<\"CB Unix 1\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 16], InsetBox[
       FrameBox["\<\"32V\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 17], InsetBox[
       FrameBox["\<\"Xenix\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 18], InsetBox[
       FrameBox["\<\"Ultrix-11\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 19], InsetBox[
       FrameBox["\<\"UniPlus+\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 20], InsetBox[
       FrameBox["\<\"V7M\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 21], InsetBox[
       FrameBox["\<\"USG 3.0\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 22], InsetBox[
       FrameBox["\<\"CB Unix 2\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 23], InsetBox[
       FrameBox["\<\"3 BSD\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 24], InsetBox[
       FrameBox["\<\"Unix/TS 1.0\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 25], InsetBox[
       FrameBox["\<\"CB Unix 3\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 26], InsetBox[
       FrameBox["\<\"4 BSD\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 27], InsetBox[
       FrameBox["\<\"TS 4.0\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 28], InsetBox[
       FrameBox["\<\"Unix/TS++\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 29], InsetBox[
       FrameBox["\<\"PDP-11 Sys V\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 30], InsetBox[
       FrameBox["\<\"4.1 BSD\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 31], InsetBox[
       FrameBox["\<\"8th Edition\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 32], InsetBox[
       FrameBox["\<\"4.2 BSD\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 33], InsetBox[
       FrameBox["\<\"2.8 BSD\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 34], InsetBox[
       FrameBox["\<\"System V.0\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 35], InsetBox[
       FrameBox["\<\"4.3 BSD\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 36], InsetBox[
       FrameBox["\<\"Ultrix-32\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 37], InsetBox[
       FrameBox["\<\"2.9 BSD\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 38], InsetBox[
       FrameBox["\<\"System V.2\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 39], InsetBox[
       FrameBox["\<\"9th Edition\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 40], InsetBox[
       FrameBox["\<\"System V.3\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 41]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 10.}, {-2.11550304087703, 8.}, {
     1.2239238757143767`, 9.}, {-4.365790178655544, 6.}, {-0.5018286170092665,
      7.}, {-4.501828617616951, 7.}, {-3.5018286176943434`, 
     7.}, {-2.501828617318239, 7.}, {2.4773319044395237`, 8.}, {
     1.2239238759817965`, 8.}, {-5.501828618313482, 5.}, {0.4981713827605745, 
     6.}, {0.49817138273709816`, 5.}, {-2.5018286202122795`, 6.}, {
     0.8535491686529042, 7.}, {1.853549165501704, 7.}, {-0.5018286150231006, 
     5.}, {-4.501828617387702, 5.}, {-2.501828616959898, 
     0.}, {-3.501828618782298, 5.}, {-2.5018286171443833`, 1.}, {
     1.4981713828473744`, 6.}, {2.498171382913057, 6.}, {-0.5018286169561748, 
     4.}, {-1.5018286173945796`, 6.}, {2.498171382933407, 
     5.}, {-0.5018286168771624, 3.}, {2.120652862891916, 3.}, {
     2.4981713836484687`, 4.}, {1.4981713839103747`, 
     4.}, {-0.5018286170389388, 2.}, {0.49817138381010295`, 
     1.}, {-0.50182861659232, 1.}, {-3.5018286169539294`, 1.}, {
     2.120652862717918, 2.}, {-1.5018286170099486`, 0.}, {-0.5018286169880923,
      0.}, {-3.5018286171126363`, 0.}, {2.1206528639829685`, 1.}, {
     0.4981713833414858, 0.}, {2.1206528638132625`, 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{553., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{557, 671},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{400, Automatic}},
 CellLabel->"Out[2]=",
 CellID->186196745]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TreePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreePlot"]], "InlineFormula"],
 " provides a layered layout ignoring the direction of edges: "
}], "ExampleText",
 CellID->247522096],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"TreePlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "4"}], ",", 
       RowBox[{"1", "\[Rule]", "6"}], ",", 
       RowBox[{"1", "\[Rule]", "8"}], ",", 
       RowBox[{"2", "\[Rule]", "6"}], ",", 
       RowBox[{"3", "\[Rule]", "8"}], ",", 
       RowBox[{"4", "\[Rule]", "5"}], ",", 
       RowBox[{"7", "\[Rule]", "8"}], ",", 
       RowBox[{"1", "\[Rule]", "7"}]}], "}"}], ",", 
     RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
     RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"LayeredGraphPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "4"}], ",", 
       RowBox[{"1", "\[Rule]", "6"}], ",", 
       RowBox[{"1", "\[Rule]", "8"}], ",", 
       RowBox[{"2", "\[Rule]", "6"}], ",", 
       RowBox[{"3", "\[Rule]", "8"}], ",", 
       RowBox[{"4", "\[Rule]", "5"}], ",", 
       RowBox[{"7", "\[Rule]", "8"}], ",", 
       RowBox[{"1", "\[Rule]", "7"}]}], "}"}], ",", 
     RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
     RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]}], "}"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->11349158],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->619750719]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1170669461],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["GraphPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot3D"]], "InlineFormula"],
 " for general undirected graph drawing:"
}], "ExampleText",
 CellID->1408649024],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"1", "\[Rule]", "6"}], ",", 
     RowBox[{"1", "\[Rule]", "20"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "17"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "12"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"4", "\[Rule]", "15"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"5", "\[Rule]", "10"}], ",", 
     RowBox[{"6", "\[Rule]", "7"}], ",", 
     RowBox[{"7", "\[Rule]", "8"}], ",", 
     RowBox[{"7", "\[Rule]", "16"}], ",", 
     RowBox[{"8", "\[Rule]", "9"}], ",", 
     RowBox[{"8", "\[Rule]", "19"}], ",", 
     RowBox[{"9", "\[Rule]", "10"}], ",", 
     RowBox[{"9", "\[Rule]", "14"}], ",", 
     RowBox[{"10", "\[Rule]", "11"}], ",", 
     RowBox[{"11", "\[Rule]", "12"}], ",", 
     RowBox[{"11", "\[Rule]", "20"}], ",", 
     RowBox[{"12", "\[Rule]", "13"}], ",", 
     RowBox[{"13", "\[Rule]", "14"}], ",", 
     RowBox[{"13", "\[Rule]", "18"}], ",", 
     RowBox[{"14", "\[Rule]", "15"}], ",", 
     RowBox[{"15", "\[Rule]", "16"}], ",", 
     RowBox[{"16", "\[Rule]", "17"}], ",", 
     RowBox[{"17", "\[Rule]", "18"}], ",", 
     RowBox[{"18", "\[Rule]", "19"}], ",", 
     RowBox[{"19", "\[Rule]", "20"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->219311158],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"GraphPlot", "[", "g", "]"}], ",", 
   RowBox[{"GraphPlot3D", "[", "g", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1935028127],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0., 1.5092286568176039`}, {0.5707039925928266, 
      0.7948833216096945}, {0.570087555488515, 2.2230257303960657`}, {
      0.715967906345673, 1.5101158563601127`}, {1.3256466363227133`, 
      0.0003968020511597725}, {1.3268041766078964`, 1.7134425716242836`}, {
      2.0124707572257083`, 0.649313821184241}, {2.1542681783776865`, 0.}, {
      1.317220310866213, 1.3008998117330444`}, {2.7673667336470724`, 
      1.50377719951935}, {2.156987411142495, 1.3004913768422397`}, {
      1.3298764916862307`, 3.013587999786182}, {2.158430377170293, 
      3.013278774565787}, {2.0189208820395788`, 2.363593163715019}, {
      2.9131803253283746`, 2.218382172519465}, {1.4710539104595433`, 
      2.364890112381402}, {3.4832874250506456`, 1.5037576732825495`}, {
      1.4649096931227734`, 0.6506387181266067}, {2.91353923272862, 
      0.7915185640706556}, {2.1656267491942875`, 1.7136561271663373`}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 3}, {1, 4}, {2, 5}, {2, 6}, {3, 12}, {5, 7}, {5, 
         8}, {6, 20}, {7, 9}, {7, 10}, {8, 19}, {9, 3}, {9, 11}, {10, 14}, {
         11, 18}, {12, 13}, {12, 14}, {13, 15}, {13, 16}, {14, 6}, {15, 11}, {
         15, 17}, {16, 4}, {17, 10}, {18, 8}, {18, 4}, {19, 17}, {19, 20}, {
         20, 16}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "20"],
         Annotation[#, 20, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "17"],
         Annotation[#, 17, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[7],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[8],
          "12"],
         Annotation[#, 12, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[9],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[10],
          "15"],
         Annotation[#, 15, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[11],
          "10"],
         Annotation[#, 10, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[12],
          "7"],
         Annotation[#, 7, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[13],
          "8"],
         Annotation[#, 8, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[14],
          "16"],
         Annotation[#, 16, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[15],
          "9"],
         Annotation[#, 9, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[16],
          "19"],
         Annotation[#, 19, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[17],
          "14"],
         Annotation[#, 14, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[18],
          "11"],
         Annotation[#, 11, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[19],
          "13"],
         Annotation[#, 13, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[20],
          "18"],
         Annotation[#, 18, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0., 1.5092286568176039`}, {
       0.5707039925928266, 0.7948833216096945}, {0.570087555488515, 
       2.2230257303960657`}, {0.715967906345673, 1.5101158563601127`}, {
       1.3256466363227133`, 0.0003968020511597725}, {1.3268041766078964`, 
       1.7134425716242836`}, {2.0124707572257083`, 0.649313821184241}, {
       2.1542681783776865`, 0.}, {1.317220310866213, 1.3008998117330444`}, {
       2.7673667336470724`, 1.50377719951935}, {2.156987411142495, 
       1.3004913768422397`}, {1.3298764916862307`, 3.013587999786182}, {
       2.158430377170293, 3.013278774565787}, {2.0189208820395788`, 
       2.363593163715019}, {2.9131803253283746`, 2.218382172519465}, {
       1.4710539104595433`, 2.364890112381402}, {3.4832874250506456`, 
       1.5037576732825495`}, {1.4649096931227734`, 0.6506387181266067}, {
       2.91353923272862, 0.7915185640706556}, {2.1656267491942875`, 
       1.7136561271663373`}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   Graphics3DBox[
    TagBox[
     GraphicsComplex3DBox[{{1.118932418206827, 0.8614302643777074, 0.}, {
      1.2814051849698087`, 0.9564592510505616, 1.048741645084963}, {
      2.0014647442140188`, 0.8661455296891518, 0.05810526248140002}, {
      0.09439427755448815, 0.863926662718518, 0.03810672446040764}, {
      1.1149246705226328`, 1.9111826126753007`, 1.4902134912823035`}, {
      1.1153203364134634`, 0.09536084969694925, 1.6539472256525416`}, {
      1.9977642627255352`, 1.8587827550864127`, 1.4677969757151699`}, {
      0.09091614877600673, 1.8739446167829552`, 1.4709856545168347`}, {
      1.9105690803331907`, 1.7834384807872268`, 0.4663446950583586}, {
      1.9067116110442013`, 1.046213653789434, 2.057155809555155}, {
      0.8870163642106299, 1.8161307480763926`, 0.44053341978562255`}, {
      1.9100662154614163`, 0.036239322203641566`, 0.6233297089631952}, {
      0.885812869306081, 0., 0.6045561286958885}, {1.9984650113905633`, 
      0.14159245861518754`, 1.6219307272298191`}, {0.7199767897359262, 
      0.9554049272869732, 1.0452198797768009`}, {0.0032569172979363126`, 
      0.05177078200422347, 0.6278777332918799}, {0.8828287774210202, 
      1.0497397414724376`, 2.0947242724140147`}, {0.0034527989948853754`, 
      1.7688609578030023`, 0.4718824350898466}, {0., 1.0448427458263845`, 
      2.036310839181915}, {0.09152513835519915, 0.12788227463465107`, 
      1.6289154686138854`}}, {
       {RGBColor[0.5, 0., 0.], 
        Line3DBox[{{1, 2}, {1, 3}, {1, 4}, {2, 5}, {2, 6}, {3, 12}, {5, 7}, {
         5, 8}, {6, 20}, {7, 9}, {7, 10}, {8, 19}, {9, 3}, {9, 11}, {10, 
         14}, {11, 18}, {12, 13}, {12, 14}, {13, 15}, {13, 16}, {14, 6}, {15, 
         11}, {15, 17}, {16, 4}, {17, 10}, {18, 8}, {18, 4}, {19, 17}, {19, 
         20}, {20, 16}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[Point3DBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[3],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[4],
          "20"],
         Annotation[#, 20, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[5],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[6],
          "17"],
         Annotation[#, 17, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[7],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[8],
          "12"],
         Annotation[#, 12, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[9],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[10],
          "15"],
         Annotation[#, 15, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[11],
          "10"],
         Annotation[#, 10, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[12],
          "7"],
         Annotation[#, 7, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[13],
          "8"],
         Annotation[#, 8, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[14],
          "16"],
         Annotation[#, 16, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[15],
          "9"],
         Annotation[#, 9, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[16],
          "19"],
         Annotation[#, 19, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[17],
          "14"],
         Annotation[#, 14, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[18],
          "11"],
         Annotation[#, 11, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[19],
          "13"],
         Annotation[#, 13, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[20],
          "18"],
         Annotation[#, 18, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{1.118932418206827, 0.8614302643777074, 0.}, {
       1.2814051849698087`, 0.9564592510505616, 1.048741645084963}, {
       2.0014647442140188`, 0.8661455296891518, 0.05810526248140002}, {
       0.09439427755448815, 0.863926662718518, 0.03810672446040764}, {
       1.1149246705226328`, 1.9111826126753007`, 1.4902134912823035`}, {
       1.1153203364134634`, 0.09536084969694925, 1.6539472256525416`}, {
       1.9977642627255352`, 1.8587827550864127`, 1.4677969757151699`}, {
       0.09091614877600673, 1.8739446167829552`, 1.4709856545168347`}, {
       1.9105690803331907`, 1.7834384807872268`, 0.4663446950583586}, {
       1.9067116110442013`, 1.046213653789434, 2.057155809555155}, {
       0.8870163642106299, 1.8161307480763926`, 0.44053341978562255`}, {
       1.9100662154614163`, 0.036239322203641566`, 0.6233297089631952}, {
       0.885812869306081, 0., 0.6045561286958885}, {1.9984650113905633`, 
       0.14159245861518754`, 1.6219307272298191`}, {0.7199767897359262, 
       0.9554049272869732, 1.0452198797768009`}, {0.0032569172979363126`, 
       0.05177078200422347, 0.6278777332918799}, {0.8828287774210202, 
       1.0497397414724376`, 2.0947242724140147`}, {0.0034527989948853754`, 
       1.7688609578030023`, 0.4718824350898466}, {0., 1.0448427458263845`, 
       2.036310839181915}, {0.09152513835519915, 0.12788227463465107`, 
       1.6289154686138854`}}]& ],
    AspectRatio->Automatic,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]]}], "}"}]], "Output",
 ImageSize->{390, 202},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1897544943]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->781685086],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ArrayPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["MatrixPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixPlot"]], "InlineFormula"],
 " to display matrices:"
}], "ExampleText",
 CellID->1865416085],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "=", 
  RowBox[{"ExampleData", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<Matrix\>\"", ",", "\"\<Bai/bfwa62\>\""}], "}"}], ",", 
    "\"\<Matrix\>\""}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1254585860],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "450", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 450, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"62", ",", "62"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1792143536]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArrayPlot", "[", "g", "]"}], ",", 
   RowBox[{"MatrixPlot", "[", "g", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1133133760],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 186},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->231817323]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell["\<\
When vertex coordinates are specified, all edges are shown as straight lines: \
\
\>", "ExampleText",
 CellID->555359139],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "4"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexCoordinateRules", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1519845739],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 2.}, {0., 1.}, {0., 0.}, {2., -1.}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028937842778793417`, 0.7}}], 
      ArrowBox[{1, 2}], ArrowBox[{1, 4}], ArrowBox[{2, 3}], 
      ArrowBox[{3, 4}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 2.}, {0., 1.}, {0., 0.}, {2., -1.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{104, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1276071309]
}, Open  ]],

Cell["\<\
By not specifying explicit vertex coordinates curved edges will be used: \
\>", "ExampleText",
 CellID->115475434],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "4"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->330330998],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmVtMXEUYx2c5XAq7wAILLPflvlwW6I1i0oc+afpg2rf2oQqEGGmaBoIk
JcGkTxVjmtQHY30w1viCiVVqokGthkQf+mAT0vhAL1FiSAQjERDoFptm/eac
3e5+//3OLpjtxcbNYZjZ3++bMztz5pyZ3Rf7RwdfOd0/enKg3/fCSP/w4MmB
13zPD43QW4ZDKXWY/m56FeVDlDP/DodC9D+16XM6NTYWxldvnaBDOSlxrN1+
2bG18k2E3l2a2Fr9KBS6rpyUOKjo2Fr9/nHSdJ0Yug9C1yPlVNlplKSTnJHU
itRJqcpMaBuUpKXI2tmnSd0Y9Jj0fjBoCcrF6AFN04l+fPTo5m/nVm+ecJlX
zq2XHH+vXVOqOxJN/M70tMoyyyvz82/7fDqbaV59+8HaJVr7wMoWrb1g5YjW
HrCcorUbLJdodYGVK1qdYOWJVof57vrS0ruBgLbyRSsQqeuDgwe/HhlRbtFq
hzMWiFYbWIWi1QpWkWi1gOURLT9YxaLVDFaJaDWBVSpajWB5RasBrDLRqger
XLTqwKoQrVqwKkXLB1aVaNWAVS1a1WDViFYVWD7RqgSrVrQqwKoTrXKw6kWr
DKwG0fKC1ShapWA1iVYJWM2iVQyWX7Q8YLWIVhFYraJVCFabaBWA1S5abrAC
opUPVodo0b3r19c3Fs7RoZw6MdZ/GQ1HdNpE0APj/uYVOpRTJ7pMuoYJIsJP
Qaf5VDTLof9yhF5XGOE1wM4iM2BdYDyBGmJXMGLkWx6PHCmtauJrWLpx4w2X
61G1/t/3/dN0La3d6dtYGKNDz7sxXe5NEvFg6yqbdw/uTSeM0Gu3tJmzZw88
U1QZhK+eOaOz3Qmsqd7eySNHkllfnjr1+cBAYuvp7IfHQRdnZ9/r6rKj8zMz
Hx469D/dDp2bmqKnqh398eLFLwYH7ei3Y2M/TEzY0cvHj/80OWlHqUnUMDt6
3utdX1yMp9ZcIESCzmYJNPqJJBpts0SjrbKoMu79OR1c/pQOlU5J2tzl0xm6
YASXPwuZr+ge6k23m1Jrz2ndeYPL79ChnDqJufMGoJ0xETb3aiviSl/f7KVL
O4mgJgVXVrYX0Q5XS/Y2I6LjHB8R+11IbGRbZBxpjus+y4mLNOD7EakGPW7O
uMhkK4GHO1A6N7VAxdeQbCVg1XDtwoWvhod1duc1tEAbXGLPqfRoDfE90AKt
iK/DbjXlh7PnJh1pf7i385Ka1r6G7s/v9/Tokd1uBN3OKUhnYyJs5o+1w6Jp
TJNZZ/PDEXd/P88iNhcnwhHWzu2PuTk6jW6Vm8196zqmiUKUnjvWbgcoTVWa
sDrLaeQ6LGLvWlcITQuaHDrLqTVytDWhSnVrPIz6oQeLGX3YvzRLqcXWvjK6
/vhufDz6eaNWaYw1PTRESxCdbQDLG2N9cuxYeJVSD1YZaw/SckbrgFYwWgu0
klEf0CpGa4BWM1oNtIbRKqA+RiuB1jJaAbSO0XKg9YyWAW1g1Au0kdFSoE2M
lgBtZrQYqJ9RD9AWRouAtjJaCLSN0QKg7Yy6gQYYzQfawWge0E5Gc4F2MeoC
uptRJ9A9jOYA3ctoNtB9jO4Cup/RLKDdjGYCNVdJeq92uy/mdxazHDZ6Qrb3
3fCKIIERMl+PyDDCu2R8nsWbyZ7kz26E3ZP7SY2ZnfHXz6+y64/KzEjtb4vK
8Q8IFQ2/\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{73, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->346218037]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->589267740],

Cell["Plot isotope decay networks: ", "ExampleText",
 CellID->297915225],

Cell[BoxData[
 RowBox[{
  RowBox[{"DaughterNuclides", "[", "s_List", "]"}], ":=", 
  RowBox[{"DeleteCases", "[", 
   RowBox[{
    RowBox[{"Union", "[", 
     RowBox[{"Apply", "[", 
      RowBox[{"Join", ",", 
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"IsotopeData", "[", 
           RowBox[{"#", ",", "\"\<DaughterNuclides\>\""}], "]"}], "&"}], ",", 
         
         RowBox[{"DeleteCases", "[", 
          RowBox[{"s", ",", "_Missing"}], "]"}]}], "]"}]}], "]"}], "]"}], ",",
     "_Missing"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->732056656],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReachableNuclides", "[", "s_List", "]"}], ":=", 
  RowBox[{"FixedPoint", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Union", "[", 
      RowBox[{"Join", "[", 
       RowBox[{"#", ",", 
        RowBox[{"DaughterNuclides", "[", "#", "]"}]}], "]"}], "]"}], "&"}], 
    ",", "s"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->385350738],

Cell[BoxData[
 RowBox[{
  RowBox[{"DecayNetwork", "[", "iso_List", "]"}], ":=", "\[IndentingNewLine]",
   
  RowBox[{"Apply", "[", 
   RowBox[{"Join", ",", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Thread", "[", 
        RowBox[{"#", "\[Rule]", 
         RowBox[{"DaughterNuclides", "[", 
          RowBox[{"{", "#", "}"}], "]"}]}], "]"}], "&"}], ",", 
      RowBox[{"ReachableNuclides", "[", "iso", "]"}]}], "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->114907798],

Cell[BoxData[
 RowBox[{
  RowBox[{"DecayNetworkPlot", "[", "s_", "]"}], ":=", 
  RowBox[{"LayeredGraphPlot", "[", 
   RowBox[{
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"IsotopeData", "[", 
        RowBox[{"#", ",", "\"\<Symbol\>\""}], "]"}], "&"}], ",", 
      RowBox[{"DecayNetwork", "[", 
       RowBox[{"{", "s", "}"}], "]"}], ",", 
      RowBox[{"{", "2", "}"}]}], "]"}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
    RowBox[{"VertexRenderingFunction", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Framed", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"#2", ",", "8"}], "]"}], ",", 
           RowBox[{"Background", "\[Rule]", "LightYellow"}]}], "]"}], ",", 
         "#1"}], "]"}], "&"}], ")"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->387090646],

Cell["Uranium 235: ", "ExampleText",
 CellID->957874961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DecayNetworkPlot", "[", "\"\<Uranium235\>\"", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->60791685],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{243, 444},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->14887979]
}, Open  ]],

Cell["Polonium 189: ", "ExampleText",
 CellID->35874],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DecayNetworkPlot", "[", "\"\<Polonium189\>\"", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->51845701],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztfX10VFWWb5mqSlUllaRS+aBSlUSEoDGihhjpdF4ElCVkPaYN9mNGsEdQ
GTo4ygt+LMNq7CaI8tEoUZRGsBX8DMtBGScg0vCgMe1jxNdL7X5vgHZmyDyn
F6yla/FH/8Efvd7K2+fsc++5d9c599wKH0lrsrS4955z9v7tffb9OOf87r4/
uO+xpUuW3ffYA4vvGz/7kfuWL31g8aPjZ3U9AoeCVwQCV/wd/P//UgHYHgoE
8H/2twT+x82xrdG4lWS/wfLy8gD+1bKfYDweP3fuHCsK8/JDhw4Fg0FWVMPL
p06dOsT/uKSIQ9L48ZnTpw8PDZ0K1LIf3D8tJR058saMGVNZUTUv5/szLEnR
MUkXIKkEfngnBdke/oXh/5BBQ6lox5sF+Zl7im3m+dacYD8xuyWqd/4ynZ4Y
kuwnopQgcP0l4cgTHmXa8uwekJ5lvZJvQGLJyKO9YlshkeW59PhByG0JOe3M
U0QA24wbcCqjJkw8iMjyZS0LevgCEVteQgXW38XBbMt2nE95uWNWynVYAhuJ
4eBVSBhJTMEsCSU5nS+q84QdK/VxnliRkJ+TJ0bjNXz0SKqtTbueCZLJEtcz
wcDA26GQ45lg5syZQ/yPPBNMAD1sbzzv06GhAl4ykcv4bMeOd+++m21ezfdf
bWs7feSIJaPSUfPjjRuhUNZ8fsKEfz1wQFXz/cWLN9fVyZrrE4ljvb2qmtua
mtbG42xzEt8/f+5cTyCwZ9EiXnOco+bTBQVQ8vWJE6LmiT17YP+lxkZHzQns
NwTwoQT+A528bugf770Xdtfk5//5/HmJAGuf+eyzf37uOXDBV8eOYe0v9+/f
OWPG56+99qczZyhe8BYIk5ZBRY23xmp+O2qW8ZJNmzat4n+BIvYT7OzomN/Y
yDbjfH/16tVD/I89U0B9OE0feeQRVlTMy+eOH9+1aBHbLOT7K1eu3LNnD6s6
n9cfHBzs6upiRdW8vLu7e2BggBVFiLwMab/EgbK8vLSra+GqVQ8xKQ/x64W4
8iCq/v6X4GIkyxcturOxsVGi6OpaNH36VFkOO52dnRLFli2rGhuvZUVcSLCj
Y2Z7eztFIa9/1eT6hyj01z+GIg8k1/DjsAG2Su07dqy7994fsqIML+f7945p
H33aE0Pq0UzQgIo9rYQdT330ad9CyeTH7GcVPVoLh1ueCT1/2tGMP+g4jlrA
n3yi2c/Y+EvHBpY9pVnPbXTEETRYyiUonu1Dl8firBErbX/JbM4ajfizOEFQ
Wk+wdGyqtNalM2SwMZQ1MjJFLbcra3QQ9mWXctSriAs68qV2eo186QghprE+
6JShHo1eUP87MeZlednSHvXlN/NY3Bp50pGoyZO5jXMLNL7MGpVppeQ7PGLy
YPZ4UXX2XqgXLduKL4qn6Ig2Nw+V+PFIOEDOF2e/s99i/97wMcofll88Zx4u
gU+UveqUXTSiPjHPfOh8okZUfMFnTokvf3jNupQYfGCadXFeh616UR+2Oa8e
9Irnz6rv8rPvSGivrCxzjftgHOjSfuDAKxMm1LjGfc3NzZZ2NtpcQsd9MBqV
KLZvX3PTTde5xn133HEHRbFs2T0cviXl/vvnDfE/gWJw8DAoluWgtRdnhRDF
wMDbnZ3zZTmYtGvXLolCts+Q9ojCNKbv5vs9uPQ2ZM04yfqPuqW8M2+elPLL
lhaTlF133kmlHH7iiZf5Mp2Q8mw6faq/Xy9lYO3al3A87pTS19HxTColpTwV
jR5ds4ZtPs73cc6MzYxh+e4FCzZWVFApL9bXPxkM/vn8eaHr3OnT0AqMFFh+
39fXw6fMhJRfXH897INsIQVny1AX/AfeQDnQAnY319UJOTjXtmvuXNQTAo1P
hsNw6MSePU5JsPv8xIlg2JFVq+xZuvWJRG9tLSh53PJ6D87xYQ1QCsXQ5tCK
FaS3Lk6fj0kZkzImZdhS8D5w8803T5s2DW5vgSL2E2yur5+cSrHNON+/9tpr
z/N5eHFfOH78eF1dHSsq5uX1iURLYyPbLOT7LS0tCxYsYFXxPgA7cIgVVfNy
aAwipDwQDipkOYABSKyIr60Ep0yZMoP/CXzjAwGxj/quueYaYSXWnzlzZltb
m8Qv7Sm09J89e1bWl/gyBF+E4MsQfOUOL1ZXp/r6euE5IVDNfoKZzDj6RNHU
1CDLe3t/0oarM6ilre0mOCTLeeUjsj08roBIWQ7KqqurpRXwsAfHWVGGlwfs
vsfympoqgS/Ny9PpSoEvSvRniP4I0Z8h+p1eGP5zFWqBQjgky/m+2wsgUpbz
/fEuL4gn8ox8Qnd4QeJLE3xRoj9D9EeI/gzRP+aFMS+MecHsBTaada4ZmOar
2QhWrh3ovVMs6oUNXnLL03vLYoa5ceq9V+qYEWAjbzrPSL1ZPOTFlNF7mc0a
hMj8FrVF7Xk+F6Bd68hxJl0xo0RXf2gPlRglhAx95xeDvle5BC2nSt+7ltdN
veq0EX+DPvq0hFjhjjlf/eqxovMd6tmsWU9Tv5Y44gHPQfXZoOpnOqsaGGZP
S5ymnqarRdkzvSEf/W1aK9KtgOn7XycxrJRmukLTdaIsnB4Y9fHhwqhe3co6
mm+IHu8VrbxhxlaWVMcdwjk3LFez9PFmkmVeCTbFpMdKnOt8pvzS4a0mec/j
Szn6WPWy2joLstc3cr2eqXHSdSmzHtNVL7fVypghns2rJFkrrEq8+tjWaPDU
GTPEeK4yVb1+IbFurecUXpQIV68JX1g8O8/6kEO2ryjOWl11csexIBvvZY1Y
9fqvCyG5OrvsN0SrUjqNUXaswE+cemLFP+v+FvEfkyOyau0rEhUSfF81Sb/h
b8lFia9iP3FlXEOn9zTD1W4om6Uipfi+vlleCTvjmx0oGtF4Ma/om+KF3lty
jJaA+h5bnGO8qP1TlFu8KK4Q1J8+74xZDIVc74OquC30FSmXkuugGkFY9UMK
xEWGWKAcCNreFAVO/VEf/e3FuTD1tAprnt3O+1le325s9nHMC2NeGPOCPy9U
VCRbW6dAW7bmOjUQLC0tPsPfnhJW7N27vby8VJY3NTU0NTVZWvJgt4Yfh0p7
9+6V7c6c+RhEyXagpAK5LYi+sDAGx1lRhpdHoxGX9VVVlQJXmpcXFxcODg5a
5UxvNdEbIXozRK/T6pMnPxRrpLiG+vnn7wvtiB4cdvTom6yohpfjMrEsP3v2
Y1d7qEzbg0jZ/uTJk6I8QvRniH60fnDwiCjHNdpPPnnHVS71Z4j+CNFfTfRz
+42sAWQJwM5OjPgYqZ/m+7ADh2T7HjuCKctALf/c6dPPYUROcKA6vmXLa7fd
Jlu9WF9PUcEhtsnfhhTcK8Z3quL7b7a3f7xxox7Vb7dv3zF9uizf0tAg3oa0
Uf28vJyi+mDZMqgoW0GV3778smz1+76+9YkE2yzk+2/MmvV0LPbp1q0BTgAL
AsT3Fy92ocJ3GkX7g93drjcvn0mlxJuXWP7NyZNrwmGK6tW2tg3JpKwFIlfn
5e178EEhBaTCPuOOcVRh8NK6kpIeTs0CPwb4m3LBjRUV4v1QlPL1iRM9nCgm
pLw1Z4541xP31+Tn71m0SNb/fOdOqA9+c2EDD8HRP505I/sN9kGRkAL9JLRw
0SHkowEwaMJPWMGPAzmiBdY4smqV2O+trRV6UcOZzz5DCaL8/fvvh32IQoEL
+WtoHRZgu0MrVsAumCjawRbsf7h8OXv6s+McfgMcVwgZd/AfKJzksEXy3cCE
HvebrAPr1uERMArbPD9xYg/y7Zzovty/f+/SpXACgBK7JQj+8OGHwVAeICHY
gC6Gg1DEEYYwlBAkD90QbIMQEAUCUQ74Db0HlVHOV8eOQUy+fvvtEKZYBza2
3nADRA0UYR2Ae/Dxx5Ht5+xd/9eOBKlfdgmvHf5RlZL6yVGBKknql44KVGWk
fmJUoCon9UtGBaoKUr94VKCqJPWLRgWqcaR+fFSgSpH6haMCVRWpXzAqUKVJ
/dioQJUh9aOXBJU1kjh5hP8FithP8OXu7qfa29lmnO9//vnnQov1LsSgq/6K
xsa+3l62Wcj3P/nkE1EfUcO+qI/yoDI0kfs4KJL1QZ+on0fwRPg+7MAhqU+O
DLDvDhw44NJ3Lzwy4D7WxzQmUt/Ro0dd9an9cuSE9sO+p/0gz4UH9Ln09/f1
PQQPI7BZwPcP8Ed3VrXC0Sv6US2iuPrq8c3Nk+UoEUaR6HhRDuMtMerFcqh8
9dVXS6vlKDNNRpmI+rHHFk+YUCPL6+pq77vvPtl+x4516XSllD958qRbb73V
KleNblHu3Lm3NzRMZEUpXl5dnVq/fj21Xj+zQWcu1DMHcuYjQ2Y+EL2cWUiT
mQWGkr0The3kO1G21Zp3okwzGmg9NIYmrCjFy/n+jjHrx6wfs95tvZsDq/eC
mtuq94o6L4feS0k5s+lgxWV7rUxZT+9FVbZGVQ4JFVuPcmYpC416nPky35Zt
8rxfBqS+T7yZqfq+8c4kou8jK9eFrm+SrnJ9nzh5l/gb9NEjxcQ7TmajV69k
+zl8OftHwy819I4m54m+b5yxgFHu7NPsvir1rO/ddyo2y3B6T8VGvJi9p+OR
GnpMw+k09Jgmm8vo6jEZf7n1lBdfWdljhOfk74po4CoP4wz04i0Hh5x8MX3v
6mTkDznzpuj72Q832YsfmaeJh+CQkZ1slKqPGm+eMuXd0NwxufCTTTxLU7zl
wlfO9xWHZg4WPw8cOk1xOBwGoz4i/fA3regwRacHI8oHG5IyN63Y9J/LyEuu
Pjr9sY6lL/WR6ZcJHLJ9qY9EjSwlGzZyAZFoxQllDQ0v6tQcotyirdhPlKlZ
wY7n6/gFRVORn5jJOe/T8Pi90hpDtPjg9hb4j5RhcDRzZ+SqOYW5sIIpy9Nw
TRrKuh4FspmrlyBWcs6HdXG4vIariuWNLC7vyMZJ9rUv1+sKvb/mGCWB7CcA
6V1znKj9Es8tThT3IZpN68I5vP7uOqp4jfqKkFw4vF6c3Hwf1woThzduiAET
h1fX+876UR/97MXdNfWwX+6u6rlW1a7QVy9+t2c1x6z/rlmvz6WD1rW2TnHl
qmlunkyt54escqjc2trqsl7kskGepcxlgyjB6kWL7pTlsLNy5UqXF+bMmSHl
d3f/+G78JoMplw7Kv+eeDmjCilK8vL39FoUXbr75+mnTmuVq5rXXThR5mNDK
2bNvEauduJp49dXjBVfWzr8Hh1yc2NmzZ0uU58//DkTK1UpQJvIaIcqXX35q
8uRJsryxsf5nP/uZbD8w8LZL/tSpNyxcuFCWL1jwVy0tN8ryurpakVcJ5a9Y
8WNwjFzVbGiY+Prrr0sv5Lr+j+WXjIWg+eqGjcL1rQ2obELhKQ9Q9NbWUhS/
Xr3apQWquDissCNa2VIPP/GEHsXHGzduu+kmWQ6G/8u777pQrCsqoih2L1jg
0rI2HndxVmHnqWhUlm+uq+vr6JDlfz5/vgf5m4KvuXixK1/i+kTiYHe3rP8f
AwOrr7iCsVmdKH5x/fVr8vNlLeResi+RoBTYcmkBlII/7OSlMpao7StXvkXk
1L7Z3i7KwVc9yFt18jbtbIk2JxQk9jjZqLAl9CDXEtmq0AiaYosPly+HI4xn
ii3wyylME5bjl1PARaL8jVmzepAP60QC9UEouMT5FRXYxa+o1Flo8QgUYR2o
DLvQ8LSVHxLxQiS48D4di9l5HwEvtEHnYpt1xcXgOziTXIigR367fTuo+vrE
CWwJDaAShJgTEezCQUsW4+lCE2gIzZ28ZJvvy+Qe37IFKjnbgIhT/f3nz52z
5f7x+HGwAuoMj010ia8mYyjGUIyhGEMxhuIvDAU+mw8MDCzC70PR70vh96K6
urpErmvrza7Bu+66S9aX35cqsL4ftWLFClbVejZeAYfk96qgMjSR8kGY4704
NsLpFd+jQvkABiDJ+gBWfJ/KejZf4Po+1oxAQOxjfUzgyqpGcrQ3RuyNE3tj
xN4Cgh/rd3d1tScSKvzO9/kUec7nYRZwtBIGV3V1V7KiNMmjjihhkCgylGM5
VBbjNGw/b147iJTyQdn27dtleYB57SFZHrBjS5uHXeCLEXwpgq+A6E8T/U4v
mMbkci4gTeYCEIUcs6fJmB3byzF7hozZTW+0mnLixwi+FMFXQPSnif4xL4x5
YcwLZi+YvqtGvaLmb+q9pM59qvead+5TvTe92+m9rM+Zqvc8WwnID2RzXWkP
FLt8KrEGffWM3+/A0R5yszf1PePOW6rvEa+8pfr+8Gql7w3vbKf6HsnOEUp5
lLRvvDKj5thHxu/W0R7yZgTqe8w7I6l3D+ozknr3ob5dbr2oYiRenF5UcfZy
6D3j1/lGU+9JJq2/XpP1c+stL8avstcID9R0ZaQ65ZcXTX1GuaO6r9rRXvNi
iPrjUOp7Vic7bJAbNPS8klGq+bZnzBAVLozq3KlBKk0fM96sURPT0xRRXkxP
ylagdzkaaUbWqPa9ClMkerB+XEf9RKd/3qgXj1IfoX64fdlSs/2uj1V/LB2m
kvKXaKQqscpesoVJWfo4NbNurKzWEUNM+uWPMtH5hpj0yx+VXNThxaKFR81f
yzX6ii5CjNFcfcooMvJHi4YTQcY8n8rYyZlHqowbXzxS+u1dZdT44JHG/UeM
D37gsGJHwQ/MMW48GYaGa8+QikdafPliJmc+qeFaM6Tmk/qKFx980pGNl+xr
Ya7XGfrskmO0aO5UuV5j1P6huUJzvz9R1qHP+5JDAuVW+rsbqeKW3rn1T+g6
Xqmada/mieb7uHaYeKWFhlgw8UpNUeDUr8oNq3pu9ssvVT0V63mi3k/AqnbU
trFZ0jEvjHlB54WNGx9vbLzWtV7X3t4uUfb3vzR+fMa1njh58mSJYvLkSa71
RKjcj98Pxvbt7be41hNB2UbMWelvPVGPL0bwpQi+AqI/TfQ7vXDu3Kc/+clS
qWXlygcEbxNRggN/+tMHZfm+ffsESizft2+7sAK1QGVX+fHju0GkbA/KML2Q
KN+27UmXF2Df5QU9vhjBV0XwxYj+NNGPXrjUPAO08s/nz++aO/fL/ftF3iop
H8vPfPYZHGL5TTHblpoN8dvt29+aM0dqxQSfLpTiC9VY3nfHHce3bPFE+aYz
ogDljmnTjq5ZI1BI+TEL5QtXX/3NqVMiUxmgFFxOJ8qD3d0uFFDl9319Uuup
/n6RexXLX5469YNly/Qof716tcjKyuOasf3Wl5S88v3v/+nMGczjtqm6WuRp
xcj/37t2PRliuTBFnjfAKTiqTpxvzJrlYqJCExcTFfwAh1x2QBNZjt/oBp9Y
3u7oEHlaMQ/r4NGjUL4mP39g3TrGNMX8fABk34MP2rVCb86eDbVemDQJPI01
MPMoiwUn2t7aWhdjFZmakrEKfQ37Xx07JhmtUP+ZqipRjkxVgCL2X6yv78HM
rZiZte8HP4D9ndOng1kVDvugd7BGGOoy9mgoNLB2LcOBtfZ3dUEtwEzZoD08
E+qJPXsQD+ZGlbxW2OpBXiuyOpGh2+Pgmf4j/1Y545lOsvod2bdgStzSAvDw
xMKsrWglsmCxzofLl//qscfw5ELE+N1yxsB1IgagO2+9FQINgKK+vUuXwjn4
2m23OXOywi4chCKsA5WhCTS07AxhlljAZLNeAdyrbW1br78ejC2ycNsXhHIL
JXQwtIUOZLh5Ol/HVYFfq1me1h3Tp69PJHbPn395WFIl5OpVTuSXkKtXmcfV
69KhTBCUZUR+gqBMjgjKUoIySeSXEpSlI4IySVCWEvlJgjIxIijLCMoEkV9G
UJaMCMpygrKEyC8nKItHBGUFQVlM5FcQlEUjgrKSoCwi8isJyviIoBxHUMaJ
/HEEZeGIoEwRlIVEfoqgLBgRlFUEZQGRX0VQxkYEZZqgjBH5aYIyOiIoMwRl
lMjPEJQRJUq8XtXW1or5rTSf7yooKHCN6Jqbm0V5hpdHIhExYkOpsAOHWFE1
L0cSrCzv6OgQ7bG8jw8eZHkikXDJT/BPMrCiGMGXIvhiRH+G6M9Hq8+dgyas
iMth8kR50uGFC/1yi+md3eHPocQIvhTBR+dQ6BwP4pPvDNfwcvnOcNmYF8a8
MOaFMS/48oKaLaz3ijfrV+8t72yxei/qs8V68/HUbfTedmeY1XvdskPNvdD3
BuUIutnfpl5yM4f1vePFAdb3jVfWWH3PeGeN9eaN69vpe0iXr1TfVwmFplz6
LJsdq2ZqmnrPm4fq3Zt6NrB3f+ozyebWo374r97tLnaPKjmlPnqSnrX++48y
YJ0sxlz604sRS9eK6TsCqvxOKln5RA5la/pivCoY4TT6hst79WKqSun6mPHP
g3XfYfQxlQv3NRTIZn7SWPMrz8IrmdimOPRgKSk4tWrusz46/TNinRZcrIyq
TplRQ8x68IlcDDQ1czlHRpqG/a2WrY9bM2uIaqf3+uHwY3WxQe8ENIb9ypZs
mOHFLpMadp/FQ+q8v76i1ZOzfGExap3VlAOYA5/WlfVXxTQeHkMyzyXNEIGe
bFYsYCIifmLPF8dWMr0N0eaDZ6vmY/qKPB88yvhwIu6y5G8dDbxbw/VsSM3m
K/ATR0beLeXbGa5WlleyeLclIxov2ddUmzf7Aeb5MsULvU/mGC2By8m7zf3+
R/2ZO++Wclf93dX0LFQ/4wId77bIEB2Ud8v7MgzlDySTO2fM+HTrVsb9CCue
VXPP6nr52Leqp3Ud+9bU394sWu/nb1W7hK8+9TUrGMVr/OkjR/YuXfpMKmV3
WB6x4dsxR5jrTCn3QoR4B0GJDKrfNY/w8ziEHkEs300/fJvm0Gtr0+JKZq2z
Rsk662RRbq2z5pN11n+AQ6xIt846U7TXrbMWu+TDvssLEl+K4IsR/bp11k+h
CSvSr7PCkVNs3f9K+Dcm/i0g/zL2QrX4t1bUuwr+xbyyN3JdMgMrrsfLle8r
uUPta8kvW1o+fPjhP+zdC0d2TJt2Da/93j33aNbZ7dV8qPvNyZMB+1u50ER6
gmqHyi72L67L/5/duyX7t/dKDgzX3TmZNnj4iSdevOYadtdG5sPmujohhddi
+WC3TZnSw+5I7Ce4qabmHEYl5yEGX7/99o+R/02tsJkTPy8v/3znTiH/+JYt
O6ZPZ5vIvPj16tXPX3WV1P9ifb3IR2uzh+FQf2enZAdvKCuTVkzhR7c1NSEl
VrBM1icSgrvLUUa+OnZsQzIJ2KBAPqcgP2JLQ8NunqpMWnAeIw6ZwX/Ytw8O
AeivT5xAps0Hy5aJ7LXItn1j1qwng8Ejq1YBWKwBJh9ds0bK+NPZs09Fo+C7
L/fvxxpnv/hidV4esYOxYZGNCjYzDrDNooK6+x58EBHG+pcuhSq/e/PN7Ft5
gJ/wQTAWXMI2nbzeE3v2CF7uO/Pm9XBe7KEVK5DjBDaIXLiFFpJ1JSU9PI0r
Q4K1ngyxptJyzGjbw6mpWON/bdvWg/xltIuDYPlpQdpbc+YIOZiP9tW2Npk5
V+AL8lM527Bqq/eh3tMFBaId+Bz2QXrA5u6uiUQ2VVfDaVNp9YTAg6ypY729
4GHGcMZyZAhD1Avu19YbboAmv3v7bVGOnoJWTnsYaxhgIROmwrIQ6q2Nx2Wu
YIEsX2MRj2fBLe5xZP+FCj2Y/Rd5vaAbrNnJ89sirxe9gLDiFh7YduAJoWcw
lrEOeBfOLAevmTHcseuEbTdb1xUnH1IwjUG8nRkXNn6zYQMchKKYxjruPfbs
AA4cWLvWtg556IzZbbMn0TShDU4yuCT9w113QdMSHZ5XWlvhOgKNih1XOpuj
y7wBYQgXOzAZLZuqkuTBhIprrMJ7qJ4hpbQpi1Osx0GZ0Wrm8/eIFMr5pdaU
aKwpNViTINYkid5SAw7KoFYzpFuUUvXWJDXWFBusKSXWqNHrcVCmtZpJ/X1l
j+utqdBYU2iwJkmsUUeWHgdlZKsZ161ECuUaU2tSGmuiBmvKiDX0zC834KDM
bTUz+78QKZSTTK3JaKwJG6wpJ9YUE70VBhyU4a1mcLcRKZS7TK2p1ViTZ7Cm
glhTRPRWGnBQJria6X0LkUI5ztSaq9gPHa3DbYNlyb+GWFBJLIgTXeMMuilL
XM0Cn0akUP4ztaDO0R9Px2LwxIf9MYmgH0fQFxI9KYNeyh5Xs8OnEymUF63k
Ckeg8sHubvoMOoFYkCIWFBBdVQbdlFmuZo7PIFIoZ1ppQYEd9/CXfW5cSSyp
IpbEiM60AQNln6vZ5bcSKZRXbeJthxyRlf0MLa1JE2uiRG/GgAPP7Pfee+8I
/wvksZ/goQMHftbW9uaGDYEo3+/v63solWKbRVh+6JDQjyNyvI4NDAwIKUH+
83J391Pt7WwzwvdXNDb29fayzUK+L+cVEBXsi/ZxLO/thSZyH1M/yz6RqFEe
KAOVtr58aL/ujjseSCYfv/FG9B5G3eDgYH9/v5R7byAg5MTQ2v5+kVUb64O1
Lu+ANwAX/Aq7pJ2IA3AJnBHil5DBL3HiF7xLnTz5YTxewOYwa9hPsKXlxtJS
/uhS5vB+ff2Exsb6GfZ3dsrLS8Vb54iiv/8lOCTLoXI9fgklRrTw7/BEQEtJ
URG9LqCszs7548dn7Lpsnquzs1N6rLS0WHzzB78ZBIJPnjwpsUisNQQrWmya
B0OLhz/bFyNa+Gxdga1FeR1hZyT7IlYVlyW/iIUW62cmIwRrjWqGdmQsdmjh
1xt6Lwar2eFvr9W8fchp9bfXVrQCbBVZFS61lePkDLljNddktZ5B7c06Ved1
1nvHnddZoioUZ3nCVa73knfeZ733WDsVK5vmXqRerXToCQR0/D3qVW/mszd3
XtXO5F1ddt9sP5dqauo97i+bs97z2dxfE8uZ9oEVO8415fCw+8EP59Y7y/LI
9YOKB+zH/ypGtMnr2baoz7nh9EEuHHd/OZQNfUKYwrqrEH1HRtb1f35Ilq/h
nFCwg3PvE3/vKdA+8eKne/G2h3zcHXSywwa5pn5U8teNOLP7ODjkxVpXs331
ve+Dpa7NgqyPDy9mucV2od88V8WKxWKX578pMobDRL1wTriKO0r73xcXfMiZ
JTi77/192T7PJUXf92aemttP+v72zfDOYlzq+9/4doJLupphO7zoyPWr9aqo
UGenNDGJgw47pY+GGweFfvrfmMWY8gOVfe+LYU39SnvcTxRZLMTo8Pv7EjOh
Ded99jkfyH4z4RL0s5EBTVmOhnN8SM2A9tXHPhj0aga0qX89mMs++9fEXM7h
qj6M81jNWC7IrX8V1/Hi3PpWIaE0t3N3KDdmu+r5LotzbHhmy4VtrHo282Ib
6/rPWT/qo6e8WMamPvJmC+d6VfXPJb/U80yWLy/1/FJubOvLM7v22Y4dl2l2
bWTmEO3VpefGj2d5Ekd6trSlpbG39ycgKJBhPyyTLbWUH7LKoXJLS4vL0qqq
ClaU4uV9fb2ZDFIGuBDbUuRLdncvWbTozkAVrwtb3ZgVFC3OZMZBc1aU5uUg
2GWxxFpDsOZi8bJl97S13SRXcb73vRvFWhVqGRw8DIdkOVRehjlUxTrluU+n
T58qV26mTWueP38+K+IrACGnxZzHF9y1q7e5ebJsATu7du2Sds+fPweEyLUe
EC/YvhGCuIYgDpM+qCF9gHbfZcWcWMHEldPz587tnDGDcQJxhVOunBZn2YFc
jB7CzZUt6Iqvzd0Va6qogXI7pCdriCcRN99kmXlFJl0b98tTp/5h3z6h9Z15
836L33JFzubXJ07sXbr05+Xl791zD9NdSbBjL757992Hn3iCbdrr7rvuvNPR
y6dPb29u/uPx40ILqHStO0P5s+hjXK3m1Nng7gULnkmlmE8xYylgXVdc/P59
98EGrt+/2tYmMuFyH+V/uX8/uAXprhsrKs5+8UWK4MUY2dLQsK2pidmD5R9v
3CgyAWP5NydPPl1QcPDxx4U90HWuzMDQcm08TvCG/3z+fG9tLegCj7G1SWQ2
/tvBg3Do52Vln27diryJ56+6qq+jw0YdBoc/FY1CpTdmzWLpVKtUmMNg9NOx
GNh2aMUKlvkMe2LPwoUiNzCyZz/ZvBkaPj9xos0KBpe5sgX/+6FDq6+4gulB
7JzuHUb2bA+nl7IyxP7WnDmIHYpR35r8/BdxlZZfkcJ2XIOzwGwRmxI7ojrW
2wuHAPuRVatQDrhfZAlGJin0CNTYVF391bFjFVZk9jjzBh/+6U9hH8JG4P4R
Xg3mzoUwYdd+jBHkGL/S2gphg6xV5Cn3cNYqshjIVRSOUxYDsnEgJF677TbG
/kHMEBI9TsYzSP55RcWOadPsTMToRcnYhQ5FlzoxMz4qGI7n9yRLkn0BQT4u
OGpDMvlMVRWIzMu6goxX4WVS4F+8jqAU8BacunAmAIQiq459IcE6UB9CBE80
7HUAB3ZBSP6ypQVxLyRXJHrN41eYKLRD5VDgREu5O8ikk9e7pKUVFUBrNY8X
auBFz2YNwxEkusARRLrID9IwFL6/eLENULx3IBEmVAizmI+Uk0vZNJSDc68B
W6nVzxBAcGWD5mq+qcRF+aaUj6pm8VJc9xlwFbvPdLhFqBhxSYKNskcpu1TN
yaXY7jdg49cX+lyEILIQlhGESi54Fv/VhHCxAWE06+wNEhxqrid5gshirlJm
qwnn3xlwhrNwmjipFaScsjgpy1PNjaU4lxhwZl8NIwaclaSccjUpl1PNeqU4
f6zCmY84f716tY0uZkA3jpRTLiblaqpZrBRdJ5FSZ3kNnlDgWg8PfCY2eIqU
U4YlZWCquakU11IiBTm3zt6UPV1AENhve6wJ89BMk3LKnKTMSjX/lCJ8gEip
zYq3IIlI2sMoF9/yYU9qdERAOZGUM6lmmVKcf0+kZLJw5hOcdJxh30PxxSJ4
8qomNSJEB57RCxYsaG1thSE6GybDT1tLS30iAb/sdXDYh52Wxka2Gef71113
3alTp1xnmuKMp1Kb6+snp1Jss5z9RG0p8KfojfPnGxoaZOtpbW0Ao7W5ORDh
+yAKBLLNAiyfNm3mzJn2+cXeZIKHLXjAhqd0tPLQoUNCYphIyCf40MqpU6c+
+uij/CLA27e2TnGNr5uaGlxzAVAZmsj24L+6KHdgId8H5UhrFd9/WUKk8lF9
PkrNvmrDKDadrpSjfxjFVldXS3uh1+ERE/6Dh1G0d8eOde3tt0i83d0/vhvf
BUV79DMkaM/dd/8VNJEaQZjrW0ZLiBQ+DxOC/YdSKed1XM47pMm8A15xds+f
L8ZiNm7xDSbEJb/B5A+36RtMStxsvx9RRH2hhkdpOL9GAeojzvd5TahhDACB
8peD2s5aL0bzlTmidrLZeHheFCu8OXl667wzrFKrYYwNozyV1d4ZV/XeqHDo
tRdbPLxhZ7Z1rbSpv61OfeSPRaf3lb8Mp9Rn8k5HfeaXSaT3npVH17kGo+bV
SQ9yrVnrczRbn96Dev6bt+eUXCelx9YnEuJNdpXHVDw6k5+y+Y803k1n4YV4
zcXG8vw2vQVT/TXy4fOwZCZN6Wv7GyHiOjaO+NqbVUV7wFq1zL0n/HER/X3x
PnQBveSfdaVnk+l7zN8au046ZRSyvsuDB6sU6TPzGnhoyJlHUt9PJvabk9Vm
Onf8cmL0V5Zh9Z0iP6WKL6fsKZ85JSPKcwpOKJwmzTqn/LGVKKMiZugrv/51
H1Hn6fT1Pfaw80pge8cRIRfzjCvK7cwaUnGTKCvA/oqTuPYZzqMh9VWWftFY
2S9GVhn3V0CX2/dife/c5Hs1a4fyW4d3VYsrvX9oxYqBdet8eF/hr9Lczogh
fzwvf9ctPbfGz3OAk2lj8q6J0UP9ar9/D+N0mZnI39e5c/Sotk+879v6DIMX
e5RGMy9QX5hGaX6ZSpdnzFlO7iu5WjMyI2Vc6zixZ8+uuXPZZvovCLX09eVE
fd11dU1NDZJXUl5euvmBByTqM2c+LioqlOWtrVPK8evBSeJrnA/evPmJdLpS
8jUaGibOnj3bP+rZs2+BJlIfCNu8eTNFferUAZBiz8qFDh589cPly99sb4dR
HMoB4R999JbkJH3xxRdD/E+s0ElvZ6z6/f3bWNVaXh/JM6woTPxkv0t98OBB
iXtw8LATURCEifaI+yle68v9+1+sr2er/djHX584IXgHlB1zPdmvIHbjbCbY
LbTgKoCcFb+Ba32a/TL2AGiBAiuXFssdN3j06JB9J4R2cIhdwXk7B58G678x
e/aeRYuknq033HDamXHim1OnNlVX/+cnn2C+vwC/yQr2w2u33vr7vj58Lt2z
cKH4ljS2g0471tvLNlHvwe7uzXV8Ah/rg5JnUimAJtaHYEfUx6xZON/7ZCh0
bNOmRqmZsUqeu/JKUL6xspJ5G5+S/+Xdd+HQyfffz5pRwyyFfR0dgv/CvR0+
d/o0xDY0AQXQUwLDU9Go8AUyMeAMQH7M9uZmnpsusJ63hhZPRSI7pk3bu3Sp
/b1mJqeHJ9ezMn85IhFRPD9xYg//DLNoARXxk8ngrLgVNT2Y9wy9AJGLax0g
BxFs4Agg2uDfT7duhaoMf7klr8fKRIdRBTUAo40ghByVHv6lZ1aDjfs4J0XM
mjrZL/it53KrHQQZ+AOQ8uxvgWcsvIAAtIi7yj8tWdJ75ZUs2nAf45OtKfHO
CH117Ng78+btmD5dMD5QP2wI/XFLP8QSyALxZVavY/RjVcxAF3jWihSwEWyA
SmUk9nBfzsBPIedemcCg/havPOd4VrhAr3VdBJvY98DtL/aKWEtaVwJxhjUR
bUmhTf19YqmNZ2oLPGd5EGKEuSlJYsrOLAZoWEzdRLSVCm3qbzZLbTyTWoBf
iFkuQdDG+g9ryTnaBPEs1ZYQ2tTfsZbaOHk08AI/Cj4E7IyfVGLZCk+brH/t
r18LzzYTbSVCWwXRVky0fZ9re9GKYQgSPGWxHuyCctlO+pbqKxb6Kom+IqKP
5woL/MI698TZWWTFjbifFhHf0pyDRULbOKItTrTxXF6BreRMjFtxIZ7c48S3
NA9gfMg5/yO1FRJtnD8beCnrnCskkVFIfEv1FQp9VUQfvc/dwvVtJ+dcAYkM
3IfTezdyR2lewAKhjWanjRFtPHNV4GVyzhWQuIharcQ9lebtiwltlPEaJdqm
c22vkHMuSuIC98HR0K1sk2qLCm3VRFuEaJvhsO3FF38WCvEpFswNPGvWrCH+
J/P5CukRIb2GSKer9Lc6pOufbDlvIlhRkRRjRMy8HItFBJcZba2vnyDKMbNx
OBz66KOPWFFbDlqGn+X6269FnVXkUmtVZ93Qa/VamdNjsdYtlW+RGTHqs1Lo
cXqt5Ohx+suAYMLrN5/DpUBPZ9cvBLVpnfIi+lw5f0pXW/S4s9++16M0rXn4
yfzh9RVClUzVag9dwVVb52N9TvF2ud76XFZpss83vQc0crP6NUTk+vOCeV4y
OOR829pgv693wAv9WOzj/WC6suFhoXHNKJFb7w55ffvJd18O6dYgcrAs51UW
n3Hr8eawvwjV9/yFxySdbVddifRz5d5XG1U7utKhv6L4XR/4S36e+vZraWio
E/2Gz+zJZMnZs2ellunTp4pyfGaPRiM4JevSsmtXLzzMswo47li4kL2jw4r4
JKljvIojMzpnLkfP/DW9wIf8KIxCXmltZbOTk/n+3gceEKNQlAI7Hzz0ENus
srRsqqlhWn7IpRywpGxIJv/HypUBPoEZ/MO+fc+m02ysbI9Jny4slG+6vdrW
9k9L+HQ1SvkV+xXvzb0wadKX+/fjmxxgwJOh0MHubjEG762tFe/R4ch+34MP
infK/huXwyedQ+/efXcPn6MbWLfOftsKX+WyvmMQ3H3XXT34ZhfOSOCXDnZO
nx6Y55AEdq4vKdnW1ASI7K8WPDNuHFQFr9lfVoDdtUVF9vtV+HWCHj5HiNI4
qZd9c8BO2ovvHx1asQLGgOyLIygL8GwoK9ve3AwbKAsabK6re37iRICCsg5b
/SCy/3JGdQhnL+Ao1ENZAOdPZ8+uTyTEHCTOFGJCTVYBPXbEkvZmezt7gwYj
FnZwglTMWskRtP1OD4zfmd//hkvh0+UObl0tibhSqzdd83xyhgOlfESkVJO4
pmtBCaKFv6cbGCBSMpanxfo2SpHzuvbXEsQsIJ8ECfzGkiLOBoxb28tydRcd
bM+n8fdCAx/z0g+XLz+Cb6SniL321z6EdJzPkjNMKOV/DjlnsaSdlCtWRKRj
62NDzhk+aR9lJ+Nsk5xz5QTwwD9bZwU4zvKanHOiWbZBupip4+87Bj7hR8Hh
9C01ETX2teSZVIrNbRdY9YU2lHKc6EoQO9PEi1Hixb/lUj4lUoqJNzPEm1Gi
5W/tvmDX4F3d3d2r2InEfzo7OuY3NrLNON//6cqV/7W8vLurK5CP5Z2drtmZ
gYGBrq4uVhTj5XdUVz+8eDHbxPrLfvSjH9bVsc0w34fKmHI68NcOFHfccVtH
x0yW4yHDfth7/Fu2bJFauroWwS2FFaV5OeyAICrF+0tjLK8CHpd5Fb5trb1n
O7Kl2lleFdxLky5/MxbZOvmTnpaD6EerfqbhUmjzmiFQ66MjWH+6hj+Sz0YR
9JCVnReO5sBT47uwcXY2xmwc6vkAVa6iPP+IfY24KafNhdHHSDs+HA8OqcfI
nlh88/OG2ZtZWb389pueteYn7vVjSnVs68euo/nqPJzWF+fOCCOt7u4lUkpn
53xyF3+7q2uhlAI7rrv0v/JadPwlnyiWOmrBoR3T+NIZPhPBSOyFa/jghxON
Av/Gj26srPzNBk5cwKe356+6SmRfcdb61WOPwWiIrSjhE2P/kiWrr7iCPV/9
vazFMkT0cPKHncMCRzDPZjKBBx31kOnwZDgMz8k4FgHJMBaBgzB2w5r/ztvD
g9Vbc+awsZT9XNvf2clGE85a8ESGD1mS2SCe0/jwMjBIvJS0ZImnO2ct+bRW
SmTxREOB/yCy6Nq7s5aURdfQ/zuv9X+JrGIiy1mLPpNLWTzIAl8RWXEiy1lL
yioksvjSZuA/iawCIstZS8qKEVkP81p/JLKiRJazlpQVIbIe4bX+wI+ePXt2
4sSJ7LXWGL7bWl4+dfJk+S7tDdXVTXV1cr+tre3mm2+WEY1STp8+nMmMk0y1
vr7empoaRS3BHsRrg2QPjpZauvf6gr5a89nkiPNeRp/k/Egg70z4bmt8w0f7
/o1Jsp81juw69C0PD9k+35eQ76HkiFj7VEHfcMjFfv1Mt5+e0j8bjL6zwqvW
4ODhZLJkhp1FrrV1SjqdprVAwIkT+9mloZpfH87Ys1t4j2WbS8a2Rs1W4Ir/
D2CFHOc=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{356, 509},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->54012148]
}, Open  ]],

Cell["Plutonium 239:", "ExampleText",
 CellID->88675782],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DecayNetworkPlot", "[", "\"\<Plutonium239\>\"", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->19907642],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{272, 543},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->330160932]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TreePlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TreePlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphPlot3D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphData"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 ButtonBox["Introduction to Graph Drawing in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GraphDrawingIntroduction"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GraphDrawingIntroduction"],
  FontSlant->"Italic"],
 ButtonBox[" ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GraphDrawingIntroduction"]
}], "Tutorials",
 CellID->25850],

Cell[TextData[ButtonBox["Hierarchical Drawing of Directed Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LayeredGraphDrawing"]], "Tutorials",
 CellID->106430589]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with LayeredGraphPlot",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=\
LayeredGraphPlot"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataVisualization"]], "MoreAbout",
 CellID->146504355],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "MoreAbout",
 CellID->403528418],

Cell[TextData[ButtonBox["New in 6.0: Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataVisualization"]], "MoreAbout",
 CellID->24191168],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->144654439]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LayeredGraphPlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 52, 21.1390580}", "context" -> "System`", 
    "keywords" -> {
     "digraph layout", "draw a graph", "flowchart layout", "graph drawing", 
      "graph layout", "graph visualization", "hierarchical graph layout", 
      "hierarchical graph", "network layout", "network visualization", 
      "organizational chart", "org chart", "process flow chart", 
      "process chart", "process diagram", "control flow diagram", 
      "decision diagram", "grafcet", "DAG", "directed acyclic graph", 
      "dependency graph", "call graph", "binary decision diagram"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "LayeredGraphPlot[{v i1 -> v j1, v i2 -> v j2, ...}] generates a layered \
plot of the graph in which vertex v_ik is connected to vertex v_jk. \
LayeredGraphPlot[{{v i1 -> v j1, lbl_1}, ...}] associates labels lbl_k with \
edges in the graph. LayeredGraphPlot[g, pos] places the dominant vertices in \
the plot at position pos. LayeredGraphPlot[m] generates a layered plot of the \
graph represented by the adjacency matrix m.", 
    "synonyms" -> {"layered graph plot"}, "title" -> "LayeredGraphPlot", 
    "type" -> "Symbol", "uri" -> "ref/LayeredGraphPlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[23623, 757, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->333886168]},
 "b:0.1"->{
  Cell[67868, 1927, 706, 22, 70, "Input",
   CellTags->"b:0.1",
   CellID->1209134277],
  Cell[68577, 1951, 20931, 498, 70, "Output",
   CellTags->"b:0.1",
   CellID->1944265731]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 473812, 11250},
 {"b:0.1", 473945, 11254}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2840, 65, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3463, 92, 1581, 37, 70, "ObjectNameGrid"],
Cell[5047, 131, 3523, 109, 70, "Usage",
 CellID->18997]
}, Open  ]],
Cell[CellGroupData[{
Cell[8607, 245, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9085, 262, 300, 8, 70, "Notes",
 CellID->39936999],
Cell[9388, 272, 402, 10, 70, "Notes",
 CellID->222274573],
Cell[9793, 284, 893, 34, 70, "Notes",
 CellID->443019707],
Cell[10689, 320, 321, 13, 70, "Notes",
 CellID->174694386],
Cell[11013, 335, 378, 12, 70, "Notes",
 CellID->77467358],
Cell[11394, 349, 4573, 121, 70, "3ColumnTableMod",
 CellID->353462848],
Cell[15970, 472, 503, 17, 70, "Notes",
 CellID->16670666],
Cell[16476, 491, 778, 28, 70, "Notes",
 CellID->762729751],
Cell[17257, 521, 816, 28, 70, "Notes",
 CellID->442256812],
Cell[18076, 551, 859, 31, 70, "Notes",
 CellID->183388779],
Cell[18938, 584, 1624, 60, 70, "Notes",
 CellID->144575570],
Cell[20565, 646, 778, 23, 70, "Notes",
 CellID->100047542],
Cell[21346, 671, 282, 8, 70, "Notes",
 CellID->106749993],
Cell[21631, 681, 171, 4, 70, "Notes",
 CellID->70117131],
Cell[21805, 687, 172, 4, 70, "Notes",
 CellID->68112695],
Cell[21980, 693, 476, 18, 70, "Notes",
 CellID->3967714],
Cell[22459, 713, 408, 13, 70, "Notes",
 CellID->424434705],
Cell[22870, 728, 716, 24, 70, "Notes",
 CellID->68183324]
}, Closed]],
Cell[CellGroupData[{
Cell[23623, 757, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->333886168],
Cell[CellGroupData[{
Cell[24008, 771, 148, 5, 70, "ExampleSection",
 CellID->222349679],
Cell[24159, 778, 93, 1, 70, "ExampleText",
 CellID->527862779],
Cell[CellGroupData[{
Cell[24277, 783, 385, 11, 28, "Input",
 CellID->166014746],
Cell[24665, 796, 3246, 70, 121, "Output",
 CellID->2037157713]
}, Open  ]],
Cell[27926, 869, 124, 3, 70, "ExampleDelimiter",
 CellID->32707144],
Cell[28053, 874, 65, 1, 70, "ExampleText",
 CellID->367941274],
Cell[CellGroupData[{
Cell[28143, 879, 462, 13, 28, "Input",
 CellID->738297439],
Cell[28608, 894, 1993, 37, 102, "Output",
 Evaluatable->False,
 CellID->143878606]
}, Open  ]],
Cell[30616, 934, 125, 3, 70, "ExampleDelimiter",
 CellID->628343972],
Cell[30744, 939, 60, 1, 70, "ExampleText",
 CellID->270550211],
Cell[CellGroupData[{
Cell[30829, 944, 455, 13, 70, "Input",
 CellID->1965963005],
Cell[31287, 959, 3589, 79, 70, "Output",
 CellID->2114808080]
}, Open  ]],
Cell[34891, 1041, 125, 3, 70, "ExampleDelimiter",
 CellID->997625586],
Cell[35019, 1046, 91, 1, 70, "ExampleText",
 CellID->1321317486],
Cell[35113, 1049, 708, 23, 70, "Input",
 CellID->911830074],
Cell[CellGroupData[{
Cell[35846, 1076, 112, 3, 70, "Input",
 CellID->593166176],
Cell[35961, 1081, 3193, 69, 70, "Output",
 CellID->951272319]
}, Open  ]],
Cell[39169, 1153, 125, 3, 70, "ExampleDelimiter",
 CellID->184183475],
Cell[39297, 1158, 105, 2, 70, "ExampleText",
 CellID->388077390],
Cell[CellGroupData[{
Cell[39427, 1164, 419, 12, 70, "Input",
 CellID->404507675],
Cell[39849, 1178, 4263, 91, 70, "Output",
 CellID->1835022778]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[44161, 1275, 221, 7, 70, "ExampleSection",
 CellID->1470226601],
Cell[CellGroupData[{
Cell[44407, 1286, 240, 7, 70, "ExampleSubsection",
 CellID->369255627],
Cell[44650, 1295, 79, 1, 70, "ExampleText",
 CellID->1096410170],
Cell[CellGroupData[{
Cell[44754, 1300, 342, 10, 70, "Input",
 CellID->430275],
Cell[45099, 1312, 2332, 56, 70, "Output",
 CellID->301061336]
}, Open  ]],
Cell[47446, 1371, 124, 3, 70, "ExampleDelimiter",
 CellID->56963074],
Cell[47573, 1376, 91, 1, 70, "ExampleText",
 CellID->155380432],
Cell[CellGroupData[{
Cell[47689, 1381, 597, 16, 70, "Input",
 CellID->273676337],
Cell[48289, 1399, 2329, 56, 70, "Output",
 CellID->78781227]
}, Open  ]],
Cell[50633, 1458, 126, 3, 70, "ExampleDelimiter",
 CellID->1640804889],
Cell[50762, 1463, 93, 1, 70, "ExampleText",
 CellID->1544973088],
Cell[CellGroupData[{
Cell[50880, 1468, 625, 20, 70, "Input",
 CellID->1430216091],
Cell[51508, 1490, 2330, 56, 70, "Output",
 CellID->833331136]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[53887, 1552, 232, 7, 70, "ExampleSubsection",
 CellID->4212966],
Cell[54122, 1561, 70, 1, 70, "ExampleText",
 CellID->124062807],
Cell[CellGroupData[{
Cell[54217, 1566, 419, 13, 70, "Input",
 CellID->1524298092],
Cell[54639, 1581, 2721, 65, 70, "Output",
 CellID->1941135591]
}, Open  ]],
Cell[57375, 1649, 126, 3, 70, "ExampleDelimiter",
 CellID->1093274895],
Cell[57504, 1654, 62, 1, 70, "ExampleText",
 CellID->250888577],
Cell[CellGroupData[{
Cell[57591, 1659, 506, 14, 70, "Input",
 CellID->1908060239],
Cell[58100, 1675, 3463, 71, 158, "Output",
 CellID->878932605]
}, Open  ]],
Cell[61578, 1749, 126, 3, 70, "ExampleDelimiter",
 CellID->1301177980],
Cell[61707, 1754, 80, 1, 70, "ExampleText",
 CellID->956609091],
Cell[CellGroupData[{
Cell[61812, 1759, 560, 15, 70, "Input",
 CellID->417724249],
Cell[62375, 1776, 2325, 55, 70, "Output",
 CellID->864705255]
}, Open  ]],
Cell[64715, 1834, 125, 3, 70, "ExampleDelimiter",
 CellID->622455388],
Cell[64843, 1839, 64, 1, 70, "ExampleText",
 CellID->1768796684],
Cell[CellGroupData[{
Cell[64932, 1844, 421, 12, 70, "Input",
 CellID->926176801],
Cell[65356, 1858, 2245, 55, 70, "Output",
 CellID->778523393]
}, Open  ]],
Cell[67616, 1916, 125, 3, 70, "ExampleDelimiter",
 CellID->996109397],
Cell[67744, 1921, 99, 2, 70, "ExampleText",
 CellID->2995],
Cell[CellGroupData[{
Cell[67868, 1927, 706, 22, 70, "Input",
 CellTags->"b:0.1",
 CellID->1209134277],
Cell[68577, 1951, 20931, 498, 70, "Output",
 CellTags->"b:0.1",
 CellID->1944265731]
}, Open  ]],
Cell[89523, 2452, 126, 3, 70, "ExampleDelimiter",
 CellID->1529467861],
Cell[89652, 2457, 77, 1, 70, "ExampleText",
 CellID->1551442486],
Cell[CellGroupData[{
Cell[89754, 2462, 685, 20, 70, "Input",
 CellID->1155268122],
Cell[90442, 2484, 20304, 449, 70, "Output",
 CellID->16323902]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[110807, 2940, 223, 7, 70, "ExampleSection",
 CellID->908861633],
Cell[CellGroupData[{
Cell[111055, 2951, 234, 7, 70, "ExampleSubsection",
 CellID->203839123],
Cell[111292, 2960, 80, 1, 70, "ExampleText",
 CellID->675090761],
Cell[CellGroupData[{
Cell[111397, 2965, 345, 10, 70, "Input",
 CellID->1122960432],
Cell[111745, 2977, 3410, 73, 70, "Output",
 CellID->780008646]
}, Open  ]],
Cell[115170, 3053, 125, 3, 70, "ExampleDelimiter",
 CellID->503110463],
Cell[115298, 3058, 79, 1, 70, "ExampleText",
 CellID->2036916947],
Cell[CellGroupData[{
Cell[115402, 3063, 426, 12, 70, "Input",
 CellID->1851389954],
Cell[115831, 3077, 3319, 71, 70, "Output",
 CellID->173098865]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[119199, 3154, 233, 7, 70, "ExampleSubsection",
 CellID->238189510],
Cell[119435, 3163, 76, 1, 70, "ExampleText",
 CellID->825767658],
Cell[CellGroupData[{
Cell[119536, 3168, 376, 12, 70, "Input",
 CellID->612297678],
Cell[119915, 3182, 2572, 61, 70, "Output",
 CellID->599698120]
}, Open  ]],
Cell[122502, 3246, 126, 3, 70, "ExampleDelimiter",
 CellID->1515268568],
Cell[122631, 3251, 80, 1, 70, "ExampleText",
 CellID->384406038],
Cell[CellGroupData[{
Cell[122736, 3256, 462, 14, 70, "Input",
 CellID->349905032],
Cell[123201, 3272, 2281, 54, 70, "Output",
 CellID->662946272]
}, Open  ]],
Cell[125497, 3329, 126, 3, 70, "ExampleDelimiter",
 CellID->2141000564],
Cell[125626, 3334, 103, 2, 70, "ExampleText",
 CellID->2014701195],
Cell[CellGroupData[{
Cell[125754, 3340, 456, 14, 70, "Input",
 CellID->682974758],
Cell[126213, 3356, 2702, 65, 70, "Output",
 CellID->451858819]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[128964, 3427, 241, 7, 70, "ExampleSubsection",
 CellID->65693485],
Cell[129208, 3436, 78, 1, 70, "ExampleText",
 CellID->77945437],
Cell[CellGroupData[{
Cell[129311, 3441, 663, 19, 70, "Input",
 CellID->264703168],
Cell[129977, 3462, 5844, 121, 70, "Output",
 CellID->11066279]
}, Open  ]],
Cell[135836, 3586, 123, 3, 70, "ExampleDelimiter",
 CellID->8083945],
Cell[135962, 3591, 93, 1, 70, "ExampleText",
 CellID->162176399],
Cell[CellGroupData[{
Cell[136080, 3596, 1052, 30, 70, "Input",
 CellID->1956840094],
Cell[137135, 3628, 6014, 124, 70, "Output",
 CellID->421269745]
}, Open  ]],
Cell[143164, 3755, 125, 3, 70, "ExampleDelimiter",
 CellID->420690581],
Cell[143292, 3760, 68, 1, 70, "ExampleText",
 CellID->293080936],
Cell[CellGroupData[{
Cell[143385, 3765, 558, 20, 70, "Input",
 CellID->874236904],
Cell[143946, 3787, 370, 10, 60, "Output",
 CellID->399529566]
}, Open  ]],
Cell[CellGroupData[{
Cell[144353, 3802, 897, 27, 70, "Input",
 CellID->183329943],
Cell[145253, 3831, 7822, 170, 70, "Output",
 CellID->121783570]
}, Open  ]],
Cell[153090, 4004, 125, 3, 70, "ExampleDelimiter",
 CellID->209288608],
Cell[153218, 4009, 62, 1, 70, "ExampleText",
 CellID->26472224],
Cell[CellGroupData[{
Cell[153305, 4014, 316, 9, 70, "Input",
 CellID->1020060192],
Cell[153624, 4025, 3303, 87, 70, "Output",
 CellID->199672138]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[156976, 4118, 235, 7, 70, "ExampleSubsection",
 CellID->100942717],
Cell[157214, 4127, 97, 1, 70, "ExampleText",
 CellID->1029865650],
Cell[CellGroupData[{
Cell[157336, 4132, 778, 23, 70, "Input",
 CellID->40554687],
Cell[158117, 4157, 12362, 253, 70, "Output",
 CellID->392360784]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[170528, 4416, 233, 7, 70, "ExampleSubsection",
 CellID->47225018],
Cell[170764, 4425, 97, 1, 70, "ExampleText",
 CellID->1302252890],
Cell[CellGroupData[{
Cell[170886, 4430, 1102, 29, 70, "Input",
 CellID->47617879],
Cell[171991, 4461, 93569, 2102, 70, "Output",
 CellID->799579235]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[265609, 6569, 236, 7, 70, "ExampleSubsection",
 CellID->44888674],
Cell[265848, 6578, 232, 8, 70, "ExampleText",
 CellID->1808033363],
Cell[CellGroupData[{
Cell[266105, 6590, 866, 25, 70, "Input",
 CellID->500288768],
Cell[266974, 6617, 7959, 188, 70, "Output",
 CellID->448834164]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[274982, 6811, 230, 7, 70, "ExampleSubsection",
 CellID->179618439],
Cell[275215, 6820, 84, 1, 70, "ExampleText",
 CellID->1676190373],
Cell[CellGroupData[{
Cell[275324, 6825, 892, 25, 70, "Input",
 CellID->14566157],
Cell[276219, 6852, 10749, 252, 70, "Output",
 CellID->1119943362]
}, Open  ]],
Cell[286983, 7107, 125, 3, 70, "ExampleDelimiter",
 CellID->297939305],
Cell[287111, 7112, 383, 12, 70, "ExampleText",
 CellID->580503372],
Cell[CellGroupData[{
Cell[287519, 7128, 886, 26, 70, "Input",
 CellID->317015018],
Cell[288408, 7156, 2346, 45, 141, "Output",
 CellID->291277963]
}, Open  ]],
Cell[290769, 7204, 125, 3, 70, "ExampleDelimiter",
 CellID->414909817],
Cell[290897, 7209, 378, 12, 70, "ExampleText",
 CellID->88626299],
Cell[CellGroupData[{
Cell[291300, 7225, 855, 25, 70, "Input",
 CellID->238367270],
Cell[292158, 7252, 3947, 84, 70, "Output",
 CellID->1260518594]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[296154, 7342, 233, 7, 70, "ExampleSubsection",
 CellID->91275691],
Cell[296390, 7351, 93, 1, 70, "ExampleText",
 CellID->1053407179],
Cell[CellGroupData[{
Cell[296508, 7356, 699, 21, 70, "Input",
 CellID->375686493],
Cell[297210, 7379, 7834, 182, 70, "Output",
 CellID->253848952]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[305093, 7567, 234, 7, 70, "ExampleSubsection",
 CellID->24443973],
Cell[305330, 7576, 63, 1, 70, "ExampleText",
 CellID->1001631834],
Cell[CellGroupData[{
Cell[305418, 7581, 455, 13, 70, "Input",
 CellID->1042589918],
Cell[305876, 7596, 2077, 51, 168, "Output",
 CellID->907922855]
}, Open  ]],
Cell[307968, 7650, 125, 3, 70, "ExampleDelimiter",
 CellID->291462997],
Cell[308096, 7655, 78, 1, 70, "ExampleText",
 CellID->73764302],
Cell[CellGroupData[{
Cell[308199, 7660, 457, 13, 70, "Input",
 CellID->655204029],
Cell[308659, 7675, 1720, 52, 70, "Output",
 CellID->1845611119]
}, Open  ]],
Cell[310394, 7730, 125, 3, 70, "ExampleDelimiter",
 CellID->268593998],
Cell[310522, 7735, 104, 2, 70, "ExampleText",
 CellID->1953868534],
Cell[CellGroupData[{
Cell[310651, 7741, 458, 13, 70, "Input",
 CellID->69684929],
Cell[311112, 7756, 1720, 52, 70, "Output",
 CellID->1873360300]
}, Open  ]],
Cell[312847, 7811, 123, 3, 70, "ExampleDelimiter",
 CellID->8973542],
Cell[312973, 7816, 95, 1, 70, "ExampleText",
 CellID->1197125759],
Cell[CellGroupData[{
Cell[313093, 7821, 453, 13, 70, "Input",
 CellID->406910921],
Cell[313549, 7836, 2735, 79, 70, "Output",
 CellID->322450815]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[316333, 7921, 241, 7, 70, "ExampleSubsection",
 CellID->74973014],
Cell[316577, 7930, 85, 1, 70, "ExampleText",
 CellID->49039736],
Cell[CellGroupData[{
Cell[316687, 7935, 753, 23, 70, "Input",
 CellID->930075907],
Cell[317443, 7960, 1268, 33, 171, "Output",
 CellID->1586422380]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[318760, 7999, 243, 7, 70, "ExampleSubsection",
 CellID->82661052],
Cell[319006, 8008, 61, 1, 70, "ExampleText",
 CellID->1148726976],
Cell[CellGroupData[{
Cell[319092, 8013, 465, 14, 70, "Input",
 CellID->1976145425],
Cell[319560, 8029, 6239, 106, 70, "Output",
 Evaluatable->False,
 CellID->107869266]
}, Open  ]],
Cell[325814, 8138, 126, 3, 70, "ExampleDelimiter",
 CellID->1647530537],
Cell[325943, 8143, 83, 1, 70, "ExampleText",
 CellID->2039050761],
Cell[326029, 8146, 3629, 67, 70, "Input",
 CellID->876584969],
Cell[CellGroupData[{
Cell[329683, 8217, 543, 16, 70, "Input",
 CellID->280649582],
Cell[330229, 8235, 14135, 236, 70, "Output",
 Evaluatable->False,
 CellID->6963593]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[344425, 8478, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[344655, 8487, 56, 1, 70, "ExampleText",
 CellID->375287187],
Cell[CellGroupData[{
Cell[344736, 8492, 1220, 23, 70, "Input",
 CellID->1003312068],
Cell[345959, 8517, 5264, 105, 180, "Output",
 CellID->159527292]
}, Open  ]],
Cell[351238, 8625, 126, 3, 70, "ExampleDelimiter",
 CellID->1346376454],
Cell[351367, 8630, 89, 1, 70, "ExampleText",
 CellID->1385760061],
Cell[CellGroupData[{
Cell[351481, 8635, 1233, 27, 70, "Input",
 CellID->1391178397],
Cell[352717, 8664, 3050, 71, 297, "Output",
 CellID->370603595]
}, Open  ]],
Cell[355782, 8738, 126, 3, 70, "ExampleDelimiter",
 CellID->2067401904],
Cell[355911, 8743, 80, 1, 70, "ExampleText",
 CellID->1535971162],
Cell[CellGroupData[{
Cell[356016, 8748, 957, 22, 70, "Input",
 CellID->1176460123],
Cell[356976, 8772, 3831, 80, 354, "Output",
 CellID->1454110840]
}, Open  ]],
Cell[360822, 8855, 126, 3, 70, "ExampleDelimiter",
 CellID->1032973183],
Cell[360951, 8860, 145, 4, 70, "ExampleText",
 CellID->807193109],
Cell[361099, 8866, 640, 20, 70, "Input",
 CellID->319348057],
Cell[CellGroupData[{
Cell[361764, 8890, 598, 16, 70, "Input",
 CellID->72889040],
Cell[362365, 8908, 4205, 73, 70, "Output",
 Evaluatable->False,
 CellID->23123411]
}, Open  ]],
Cell[366585, 8984, 124, 3, 70, "ExampleDelimiter",
 CellID->96937192],
Cell[366712, 8989, 121, 3, 70, "ExampleText",
 CellID->56559456],
Cell[366836, 8994, 3617, 55, 70, "Input",
 CellID->116427380],
Cell[CellGroupData[{
Cell[370478, 9053, 180, 5, 70, "Input",
 CellID->28025563],
Cell[370661, 9060, 16867, 327, 692, "Output",
 CellID->186196745]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[387577, 9393, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[387818, 9402, 237, 7, 70, "ExampleText",
 CellID->247522096],
Cell[CellGroupData[{
Cell[388080, 9413, 1226, 33, 70, "Input",
 CellID->11349158],
Cell[389309, 9448, 5780, 99, 70, "Output",
 Evaluatable->False,
 CellID->619750719]
}, Open  ]],
Cell[395104, 9550, 126, 3, 70, "ExampleDelimiter",
 CellID->1170669461],
Cell[395233, 9555, 361, 13, 70, "ExampleText",
 CellID->1408649024],
Cell[395597, 9570, 1432, 36, 70, "Input",
 CellID->219311158],
Cell[CellGroupData[{
Cell[397054, 9610, 192, 6, 70, "Input",
 CellID->1935028127],
Cell[397249, 9618, 10375, 261, 70, "Output",
 CellID->1897544943]
}, Open  ]],
Cell[407639, 9882, 125, 3, 70, "ExampleDelimiter",
 CellID->781685086],
Cell[407767, 9887, 342, 13, 70, "ExampleText",
 CellID->1865416085],
Cell[CellGroupData[{
Cell[408134, 9904, 254, 8, 70, "Input",
 CellID->1254585860],
Cell[408391, 9914, 486, 17, 36, "Output",
 CellID->1792143536]
}, Open  ]],
Cell[CellGroupData[{
Cell[408914, 9936, 191, 6, 70, "Input",
 CellID->1133133760],
Cell[409108, 9944, 5369, 92, 70, "Output",
 Evaluatable->False,
 CellID->231817323]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[414526, 10042, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[414760, 10051, 131, 4, 70, "ExampleText",
 CellID->555359139],
Cell[CellGroupData[{
Cell[414916, 10059, 754, 23, 70, "Input",
 CellID->1519845739],
Cell[415673, 10084, 1268, 33, 171, "Output",
 CellID->1276071309]
}, Open  ]],
Cell[416956, 10120, 124, 3, 70, "ExampleText",
 CellID->115475434],
Cell[CellGroupData[{
Cell[417105, 10127, 378, 11, 70, "Input",
 CellID->330330998],
Cell[417486, 10140, 1928, 36, 70, "Output",
 Evaluatable->False,
 CellID->346218037]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[419463, 10182, 228, 7, 70, "ExampleSection",
 CellID->589267740],
Cell[419694, 10191, 72, 1, 70, "ExampleText",
 CellID->297915225],
Cell[419769, 10194, 597, 18, 70, "Input",
 CellID->732056656],
Cell[420369, 10214, 375, 12, 70, "Input",
 CellID->385350738],
Cell[420747, 10228, 512, 16, 70, "Input",
 CellID->114907798],
Cell[421262, 10246, 914, 26, 70, "Input",
 CellID->387090646],
Cell[422179, 10274, 56, 1, 70, "ExampleText",
 CellID->957874961],
Cell[CellGroupData[{
Cell[422260, 10279, 128, 3, 70, "Input",
 CellID->60791685],
Cell[422391, 10284, 12729, 213, 70, "Output",
 Evaluatable->False,
 CellID->14887979]
}, Open  ]],
Cell[435135, 10500, 53, 1, 70, "ExampleText",
 CellID->35874],
Cell[CellGroupData[{
Cell[435213, 10505, 129, 3, 70, "Input",
 CellID->51845701],
Cell[435345, 10510, 17666, 294, 70, "Output",
 Evaluatable->False,
 CellID->54012148]
}, Open  ]],
Cell[453026, 10807, 56, 1, 70, "ExampleText",
 CellID->88675782],
Cell[CellGroupData[{
Cell[453107, 10812, 130, 3, 70, "Input",
 CellID->19907642],
Cell[453240, 10817, 14649, 244, 70, "Output",
 Evaluatable->False,
 CellID->330160932]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[467950, 11068, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[468269, 11079, 955, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[469261, 11119, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[469582, 11130, 410, 12, 70, "Tutorials",
 CellID->25850],
Cell[469995, 11144, 173, 3, 70, "Tutorials",
 CellID->106430589]
}, Open  ]],
Cell[CellGroupData[{
Cell[470205, 11152, 305, 8, 70, "RelatedLinksSection"],
Cell[470513, 11162, 374, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[470924, 11179, 299, 8, 70, "MoreAboutSection"],
Cell[471226, 11189, 147, 3, 70, "MoreAbout",
 CellID->146504355],
Cell[471376, 11194, 151, 3, 70, "MoreAbout",
 CellID->403528418],
Cell[471530, 11199, 165, 3, 70, "MoreAbout",
 CellID->24191168],
Cell[471698, 11204, 179, 3, 70, "MoreAbout",
 CellID->144654439]
}, Open  ]],
Cell[471892, 11210, 27, 0, 70, "History"],
Cell[471922, 11212, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

