(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28448,       1104]
NotebookOptionsPosition[     22082,        870]
NotebookOutlinePosition[     23316,        906]
CellTagsIndexPosition[     23231,        901]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Expressions as Trees" :> 
          Documentation`HelpLookup["paclet:tutorial/ExpressionsAsTrees"], 
          "Memory Management" :> 
          Documentation`HelpLookup["paclet:tutorial/MemoryManagement"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Expressions as Trees\"\>", 
       2->"\<\"Memory Management\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ByteCount" :> Documentation`HelpLookup["paclet:ref/ByteCount"],
           "Length" :> Documentation`HelpLookup["paclet:ref/Length"], "Depth" :> 
          Documentation`HelpLookup["paclet:ref/Depth"], "AtomQ" :> 
          Documentation`HelpLookup["paclet:ref/AtomQ"], "Hash" :> 
          Documentation`HelpLookup["paclet:ref/Hash"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ByteCount\"\>", 2->"\<\"Length\"\>", 
       3->"\<\"Depth\"\>", 4->"\<\"AtomQ\"\>", 
       5->"\<\"Hash\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Expression Structure" :> 
          Documentation`HelpLookup["paclet:guide/ExpressionStructure"], 
          "Memory Measurement & Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/MemoryMeasurementAndOptimization"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Expression Structure\"\>", 
       2->"\<\"Memory Measurement & Optimization\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LeafCount", "ObjectName",
 CellID->25777],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LeafCount",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LeafCount"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the total number of indivisible subexpressions in \
",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22044]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LeafCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LeafCount"]], "InlineFormula"],
 " gives a measure of the total \"size\" of an expression. "
}], "Notes",
 CellID->13691],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LeafCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LeafCount"]], "InlineFormula"],
 " counts the number of subexpressions in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " which correspond to \"leaves\" on the expression tree. "
}], "Notes",
 CellID->4460],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LeafCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LeafCount"]], "InlineFormula"],
 " is based on ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " representation of expressions. "
}], "Notes",
 CellID->4254],

Cell[TextData[{
 "Numbers with heads ",
 Cell[BoxData[
  ButtonBox["Rational",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rational"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 " are treated as composite objects, just as in ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5739]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->486225987],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->119523988],

Cell["\<\
Find the number of \[OpenCurlyDoubleQuote]leaves\[CloseCurlyDoubleQuote] in \
an expression tree:\
\>", "ExampleText",
 CellID->3340],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LeafCount", "[", 
  RowBox[{"1", "+", "a", "+", 
   RowBox[{"b", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5427],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32003]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Level", "[", 
  RowBox[{
   RowBox[{"1", "+", "a", "+", 
    RowBox[{"b", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "1"}], "}"}], ",", 
   RowBox[{"Heads", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25721],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Plus", ",", "1", ",", "a", ",", "Power", ",", "b", ",", "2"}], 
  "}"}]], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->12891]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19019],

Cell["\<\
Find leafcount measures of the sizes of successive integrals:\
\>", "ExampleText",
 CellID->169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"LeafCount", "[", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"x", "^", "n"}], "-", "1"}], ")"}]}], ",", "x"}], "]"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28476],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4", ",", "17", ",", "39", ",", "23", ",", "146", ",", "73", ",", "162", 
   ",", "97", ",", "180", ",", "287"}], "}"}]], "Output",
 ImageSize->{280, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21869]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6221],

Cell[TextData[{
 "Make ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " pick expressions with minimum ",
 Cell[BoxData[
  ButtonBox["LeafCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LeafCount"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->3520],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"4", 
   RowBox[{"Log", "[", "10", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22500],

Cell[BoxData[
 RowBox[{"4", " ", 
  RowBox[{"Log", "[", "10", "]"}]}]], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3060]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"4", 
    RowBox[{"Log", "[", "10", "]"}]}], ",", 
   RowBox[{"ComplexityFunction", "->", "LeafCount"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17020],

Cell[BoxData[
 RowBox[{"Log", "[", "10000", "]"}]], "Output",
 ImageSize->{77, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18473]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5895],

Cell[TextData[{
 "Find leafcounts in combinator expressions ",
 ButtonBox["[more info]:",
  BaseStyle->"NKSLink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/page-1122a-text"], None}]
}], "ExampleText",
 CellID->14249],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "/.", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"s", "[", "x_", "]"}], "[", "y_", "]"}], "[", "z_", "]"}], 
      "\[Rule]", 
      RowBox[{
       RowBox[{"x", "[", "z", "]"}], "[", 
       RowBox[{"y", "[", "z", "]"}], "]"}]}]}], "&"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"s", "[", "s", "]"}], "[", "s", "]"}], "[", 
      RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "[", "s", "]"}], 
   ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26430],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWdtuAiEQRddLW61p00t8tD/TPvUjNqaJPjRtrN/b/RQLi1qDKJcZYFjX
RJYFZpgbMMt5L9eLj89yvZyXs7dV+b1Yzn9mr18r3lR0GOv8MsZepozXN7xW
/8Wv4n9ZlbV7XnZ551h5jrbP/vY5MLSr9K58zvWzYif9ht058j/1DpX3nB6H
8j7trXzYOnJ87xneoeNTy2OiL7bWdbUjVE7X/tR2dB3/KAp2xcueJna7SO0m
KbDpqMvty2dATC/oOOp+8qX7X1Wsv2+t25h2jrijbLSOxaWp2vtzFafcsCFW
CUnV1MjB4SJ3oLGOt3KehOw3SRmaPnf9XPmp2TF1fbHH5+5vV3o1L3kQBbvm
pWhUewukdpMW2HTU5bblMyGmB3Qcdb/40rXZ+6XnYH5cbxtijTZrT5u1i/O7
p6EukNpt9k1MOupy2/KZENMDOo66X3zp5CpqERcY/XNk+S4DaaGOtk4d+dFA
V0W1AtdUj9046upqK19k22RT6PyuvoX4VN3vmSwB6xq6j2DvY7GQayi/WHqG
3vdD7/M7PetxR9EKRS5DIao23y+Y8qVGqrHnoWavWHFDFXGvv7e1qy/UvUH6
W5HUtz05I9MxJcrdL/Qin9IdnZtfZE6r4nhDHU/lNDjXrzs9MMdTw4Gp49qh
56du39TxSB23Fzf6x9kKFCcNhd/a3MtC5k2Ng2PPk9o+seKCCn6vX01t7h9K
wlxx7abm/Jj+oBfp+eX6p093CIoaCt0NPW9qlBx7ntT2iRUXVNB9/WrKHQUK
jaanRn9M+mH7JzbqI6NSHRUaIbZF47EQ4amjPlAEuLZybczKosY6f4lvjIQ=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{478, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->58520352]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LeafCount", "/@", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10083],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7", ",", "8", ",", "8", ",", "11", ",", "11"}], "}"}]], "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27303]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2386],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LeafCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LeafCount"]], "InlineFormula"],
 " includes the head, and all elements inside it:"
}], "ExampleText",
 CellID->27484],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LeafCount", "[", 
  RowBox[{"f", "[", 
   RowBox[{"x", ",", "y"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25805],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19642]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LeafCount", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b"}], "]"}], "[", 
   RowBox[{"x", ",", "y"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16228],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->12935]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22635],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LeafCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LeafCount"]], "InlineFormula"],
 " is based on the ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " of expressions:"
}], "ExampleText",
 CellID->1732],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", "x", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->478],

Cell[BoxData[
 SqrtBox["x"]], "Output",
 ImageSize->{28, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2961]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LeafCount", "[", 
  RowBox[{"Sqrt", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5411],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->32095]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"Sqrt", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2818],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Power", "[", 
    RowBox[{"x", ",", 
     RowBox[{"Rational", "[", 
      RowBox[{"1", ",", "2"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//FullForm=",
 CellID->20361]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14419],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LeafCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LeafCount"]], "InlineFormula"],
 " counts elements in rational and complex numbers just as in ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->7875],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LeafCount", "[", 
  RowBox[{"10", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32054],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4104]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"10", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25283],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Complex", "[", 
    RowBox[{"10", ",", "1"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->18411]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17310],

Cell["\<\
Integers of any size are still treated as single expression leaves:\
\>", "ExampleText",
 CellID->17779],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LeafCount", "[", 
  RowBox[{"1000", "!"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15832],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1267]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24816],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LeafCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LeafCount"]], "InlineFormula"],
 " treats ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects as single expression leaves:"
}], "ExampleText",
 CellID->12922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24842],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "4", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 4, ">"],
     Editable->False], ",", 
    RowBox[{"{", "4", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12485]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LeafCount", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8324],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->8420]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26353],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ByteCount",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ByteCount"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Length",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Length"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Depth",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Depth"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AtomQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AtomQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hash",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hash"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->32604]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1418],

Cell[TextData[ButtonBox["Expressions as Trees",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExpressionsAsTrees"]], "Tutorials",
 CellID->15179],

Cell[TextData[ButtonBox["Memory Management",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MemoryManagement"]], "Tutorials",
 CellID->22153]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->17310338],

Cell[TextData[ButtonBox["Expression Structure",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExpressionStructure"]], "MoreAbout",
 CellID->88623918],

Cell[TextData[ButtonBox["Memory Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MemoryMeasurementAndOptimization"]], "MoreAbout",
 CellID->360799355]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
LeafCount"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LeafCount - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 52, 25.4672938}", "context" -> "System`", 
    "keywords" -> {"atoms", "trees"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LeafCount[expr] gives the total number of indivisible subexpressions in \
expr. ", "synonyms" -> {"leaf count"}, "title" -> "LeafCount", "type" -> 
    "Symbol", "uri" -> "ref/LeafCount"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5628, 185, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->486225987]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 23088, 894}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2429, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3052, 83, 47, 1, 70, "ObjectName",
 CellID->25777],
Cell[3102, 86, 584, 19, 70, "Usage",
 CellID->22044]
}, Open  ]],
Cell[CellGroupData[{
Cell[3723, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4201, 127, 226, 7, 70, "Notes",
 CellID->13691],
Cell[4430, 136, 329, 10, 70, "Notes",
 CellID->4460],
Cell[4762, 148, 337, 12, 70, "Notes",
 CellID->4254],
Cell[5102, 162, 489, 18, 70, "Notes",
 CellID->5739]
}, Closed]],
Cell[CellGroupData[{
Cell[5628, 185, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->486225987],
Cell[CellGroupData[{
Cell[6013, 199, 148, 5, 70, "ExampleSection",
 CellID->119523988],
Cell[6164, 206, 143, 4, 70, "ExampleText",
 CellID->3340],
Cell[CellGroupData[{
Cell[6332, 214, 157, 5, 28, "Input",
 CellID->5427],
Cell[6492, 221, 154, 5, 36, "Output",
 CellID->32003]
}, Open  ]],
Cell[CellGroupData[{
Cell[6683, 231, 265, 9, 28, "Input",
 CellID->25721],
Cell[6951, 242, 250, 8, 36, "Output",
 CellID->12891]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7250, 256, 223, 7, 70, "ExampleSection",
 CellID->19019],
Cell[7476, 265, 106, 3, 70, "ExampleText",
 CellID->169],
Cell[CellGroupData[{
Cell[7607, 272, 390, 14, 70, "Input",
 CellID->28476],
Cell[8000, 288, 300, 9, 36, "Output",
 CellID->21869]
}, Open  ]],
Cell[8315, 300, 120, 3, 70, "ExampleDelimiter",
 CellID->6221],
Cell[8438, 305, 340, 13, 70, "ExampleText",
 CellID->3520],
Cell[CellGroupData[{
Cell[8803, 322, 150, 5, 70, "Input",
 CellID->22500],
Cell[8956, 329, 206, 7, 36, "Output",
 CellID->3060]
}, Open  ]],
Cell[CellGroupData[{
Cell[9199, 341, 225, 7, 70, "Input",
 CellID->17020],
Cell[9427, 350, 187, 6, 36, "Output",
 CellID->18473]
}, Open  ]],
Cell[9629, 359, 120, 3, 70, "ExampleDelimiter",
 CellID->5895],
Cell[9752, 364, 239, 7, 70, "ExampleText",
 CellID->14249],
Cell[CellGroupData[{
Cell[10016, 375, 608, 21, 70, "Input",
 CellID->26430],
Cell[10627, 398, 1065, 22, 70, "Output",
 Evaluatable->False,
 CellID->58520352]
}, Open  ]],
Cell[CellGroupData[{
Cell[11729, 425, 97, 3, 70, "Input",
 CellID->10083],
Cell[11829, 430, 232, 7, 36, "Output",
 CellID->27303]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12110, 443, 232, 7, 70, "ExampleSection",
 CellID->2386],
Cell[12345, 452, 222, 7, 70, "ExampleText",
 CellID->27484],
Cell[CellGroupData[{
Cell[12592, 463, 153, 5, 70, "Input",
 CellID->25805],
Cell[12748, 470, 154, 5, 36, "Output",
 CellID->19642]
}, Open  ]],
Cell[CellGroupData[{
Cell[12939, 480, 207, 7, 70, "Input",
 CellID->16228],
Cell[13149, 489, 154, 5, 36, "Output",
 CellID->12935]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13352, 500, 226, 7, 70, "ExampleSection",
 CellID->22635],
Cell[13581, 509, 331, 12, 70, "ExampleText",
 CellID->1732],
Cell[CellGroupData[{
Cell[13937, 525, 94, 3, 70, "Input",
 CellID->478],
Cell[14034, 530, 164, 6, 38, "Output",
 CellID->2961]
}, Open  ]],
Cell[CellGroupData[{
Cell[14235, 541, 131, 4, 70, "Input",
 CellID->5411],
Cell[14369, 547, 154, 5, 36, "Output",
 CellID->32095]
}, Open  ]],
Cell[CellGroupData[{
Cell[14560, 557, 130, 4, 70, "Input",
 CellID->2818],
Cell[14693, 563, 409, 15, 50, "Output",
 CellID->20361]
}, Open  ]],
Cell[15117, 581, 121, 3, 70, "ExampleDelimiter",
 CellID->14419],
Cell[15241, 586, 359, 12, 70, "ExampleText",
 CellID->7875],
Cell[CellGroupData[{
Cell[15625, 602, 125, 4, 70, "Input",
 CellID->32054],
Cell[15753, 608, 153, 5, 36, "Output",
 CellID->4104]
}, Open  ]],
Cell[CellGroupData[{
Cell[15943, 618, 124, 4, 70, "Input",
 CellID->25283],
Cell[16070, 624, 347, 13, 50, "Output",
 CellID->18411]
}, Open  ]],
Cell[16432, 640, 121, 3, 70, "ExampleDelimiter",
 CellID->17310],
Cell[16556, 645, 114, 3, 70, "ExampleText",
 CellID->17779],
Cell[CellGroupData[{
Cell[16695, 652, 122, 4, 70, "Input",
 CellID->15832],
Cell[16820, 658, 153, 5, 36, "Output",
 CellID->1267]
}, Open  ]],
Cell[16988, 666, 121, 3, 70, "ExampleDelimiter",
 CellID->24816],
Cell[17112, 671, 350, 12, 70, "ExampleText",
 CellID->12922],
Cell[CellGroupData[{
Cell[17487, 687, 170, 5, 70, "Input",
 CellID->24842],
Cell[17660, 694, 449, 16, 36, "Output",
 CellID->12485]
}, Open  ]],
Cell[CellGroupData[{
Cell[18146, 715, 100, 3, 70, "Input",
 CellID->8324],
Cell[18249, 720, 153, 5, 36, "Output",
 CellID->8420]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18463, 732, 311, 9, 70, "SeeAlsoSection",
 CellID->26353],
Cell[18777, 743, 1164, 44, 70, "SeeAlso",
 CellID->32604]
}, Open  ]],
Cell[CellGroupData[{
Cell[19978, 792, 313, 9, 70, "TutorialsSection",
 CellID->1418],
Cell[20294, 803, 149, 3, 70, "Tutorials",
 CellID->15179],
Cell[20446, 808, 144, 3, 70, "Tutorials",
 CellID->22153]
}, Open  ]],
Cell[CellGroupData[{
Cell[20627, 816, 318, 9, 70, "MoreAboutSection",
 CellID->17310338],
Cell[20948, 827, 150, 3, 70, "MoreAbout",
 CellID->88623918],
Cell[21101, 832, 177, 3, 70, "MoreAbout",
 CellID->360799355]
}, Open  ]],
Cell[CellGroupData[{
Cell[21315, 840, 305, 8, 70, "RelatedLinksSection"],
Cell[21623, 850, 387, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[22025, 866, 27, 0, 70, "History"],
Cell[22055, 868, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

