(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     83475,       2303]
NotebookOptionsPosition[     75373,       2022]
NotebookOutlinePosition[     76829,       2061]
CellTagsIndexPosition[     76743,       2056]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LegendreP" :> Documentation`HelpLookup["paclet:ref/LegendreP"],
           "SpheroidalQS" :> 
          Documentation`HelpLookup["paclet:ref/SpheroidalQS"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"LegendreP\"\>", 
       2->"\<\"SpheroidalQS\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functions for Separable Coordinate Systems" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsForSeparableCoordinateSystems"], 
          "Functions Used in Quantum Mechanics" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsUsedInQuantumMechanics"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Functions for Separable Coordinate Systems\"\>", 
       2->"\<\"Functions Used in Quantum Mechanics\"\>", 
       3->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LegendreQ", "ObjectName",
 CellID->23679],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LegendreQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LegendreQ"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Legendre function of the second kind ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["Q", "n"], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LegendreQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LegendreQ"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["m", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the associated Legendre function of the second \
kind ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["Q", "n", "m"], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->10366]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "For integers ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ", explicit formulas are generated. "
}], "Notes",
 CellID->27412],

Cell[TextData[{
 "The Legendre functions satisfy the differential equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["z", "2"]}], ")"}], 
      SuperscriptBox["y", "\[Prime]\[Prime]"]}], "-", 
     RowBox[{"2", "z", "\[InvisibleSpace]", 
      SuperscriptBox["y", "\[Prime]"]}], "+", 
     RowBox[{
      RowBox[{"[", 
       RowBox[{"n", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "-", 
        SuperscriptBox["m", "2"], "/", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["z", "2"]}], ")"}]}], "]"}], "y"}]}], "=", "0"}], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->16312],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["LegendreQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LegendreQ"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["a", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula", "TemplateInclusion"],
 " gives Legendre functions of type ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 ". The default is type 1. "
}], "Notes",
 CellID->38],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LegendreQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LegendreQ"]], "InlineFormula"],
 " of types 1, 2 and 3 are defined in terms of ",
 Cell[BoxData[
  ButtonBox["LegendreP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LegendreP"]], "InlineFormula"],
 " of these types, and have the same branch cut structure. "
}], "Notes",
 CellID->24954],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["LegendreQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LegendreQ"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->62521461],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LegendreQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LegendreQ"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LegendreQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LegendreQ"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->472798214],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->135309929],

Cell[TextData[{
 "Compute the 5",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " Legendre function of the second kind:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->640762226],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LegendreQ", "[", 
  RowBox[{"5", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->43557986],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["8", "15"]}], "+", 
  FractionBox[
   RowBox[{"49", " ", 
    SuperscriptBox["x", "2"]}], "8"], "-", 
  FractionBox[
   RowBox[{"63", " ", 
    SuperscriptBox["x", "4"]}], "8"], "+", 
  RowBox[{
   FractionBox["1", "8"], " ", "x", " ", 
   RowBox[{"(", 
    RowBox[{"15", "-", 
     RowBox[{"70", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"63", " ", 
      SuperscriptBox["x", "4"]}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "-", "x"}], "]"}]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", "x"}], "]"}]}]}], ")"}]}]}]], "Output",
 ImageSize->{461, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->391920536]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->523117434],

Cell["Plot:", "ExampleText",
 CellID->716327516],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", " ", 
  RowBox[{
   RowBox[{"LegendreQ", "[", 
    RowBox[{"5", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->190341909],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->76368745]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5008],

Cell["Compute the associated Legendre function of the second kind:", \
"ExampleText",
 CellID->52041266],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LegendreQ", "[", 
  RowBox[{"3", ",", "1", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15744172],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"]}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "13"}], " ", "x"}], "+", 
      RowBox[{"15", " ", 
       SuperscriptBox["x", "3"]}]}], ")"}]}], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["x", "2"]}], ")"}]}]], "-", 
  RowBox[{
   FractionBox["3", "2"], " ", 
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox["x", "2"]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"5", " ", 
      SuperscriptBox["x", "2"]}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "-", "x"}], "]"}]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", "x"}], "]"}]}]}], ")"}]}]}]], "Output",
 ImageSize->{484, 48},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->208307525]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->585566706],

Cell["Evaluate for fractional orders:", "ExampleText",
 CellID->450426914],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LegendreQ", "[", 
  RowBox[{
   RowBox[{"1", "/", "2"}], ",", "0.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->145446116],

Cell[BoxData[
 RowBox[{"-", "0.2655964076372755`"}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->396256602]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->244111042],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->50985404],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LegendreQ", "[", 
  RowBox[{
   RowBox[{"1", "-", "I"}], ",", 
   RowBox[{"2", "+", "I"}], ",", "0.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18017102],

Cell[BoxData[
 RowBox[{"9.486593283969214`", "\[InvisibleSpace]", "+", 
  RowBox[{"5.441832617637276`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->135429283]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->103785716],

Cell["Evaluate to high precision:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->113336957],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"LegendreQ", "[", 
    RowBox[{
     RowBox[{"3", "/", "2"}], ",", 
     RowBox[{"1", "/", "2"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->186586230],

Cell[BoxData[
 RowBox[{"-", 
  "0.895902820924731621258525533131864225704282994150159412414044392438`50."}]\
], "Output",
 ImageSize->{376, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->186992831]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->82858706],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->493308527],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LegendreQ", "[", 
  RowBox[{
   RowBox[{"3", "/", "2"}], ",", "0.5000000000000000000000000000"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70173555],

Cell[BoxData[
 RowBox[{"-", 
  "0.89590282092473162125852553314092913718`27.69897000433602"}]], "Output",
 ImageSize->{215, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->75504422]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20532249],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LegendreQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LegendreQ"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->588992016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LegendreQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->63244004],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", "x"}], "]"}]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", "x"}], "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"x", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], " ", 
        RowBox[{"Log", "[", 
         RowBox[{"1", "-", "x"}], "]"}]}], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"Log", "[", 
         RowBox[{"1", "+", "x"}], "]"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"3", " ", "x"}], "2"]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], " ", 
        RowBox[{"Log", "[", 
         RowBox[{"1", "-", "x"}], "]"}]}], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"Log", "[", 
         RowBox[{"1", "+", "x"}], "]"}]}]}], ")"}]}]}]}], "}"}]], "Output",
 ImageSize->{425, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->299107698]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->221206573],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->195066382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LegendreQ", "[", 
   RowBox[{"n", ",", "m", ",", "x"}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->763553971],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubsuperscriptBox[
    TagBox["Q",
     LegendreQ], "n", "m"], "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{34, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->115518516]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27563],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LegendreQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LegendreQ"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellID->184078806],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LegendreQ", "[", 
  RowBox[{"0", ",", 
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "+", 
    RowBox[{
     RowBox[{"O", "[", "x", "]"}], "^", "6"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->204986240],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Log", "[", "2", "]"}], "-", 
     RowBox[{"Log", "[", "x", "]"}]}], ")"}], "-", 
   FractionBox[
    SuperscriptBox["x", "2"], "12"], "-", 
   FractionBox[
    SuperscriptBox["x", "4"], "288"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {Log[2] - Log[$CellContext`x], 0, 
    Rational[-1, 12], 0, 
    Rational[-1, 288]}, 0, 6, 1],
  Editable->False]], "Output",
 ImageSize->{230, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->52321073]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->319796208],

Cell[TextData[{
 "Different ",
 Cell[BoxData[
  ButtonBox["LegendreQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LegendreQ"]], "InlineFormula"],
 " types give different symbolic forms:"
}], "ExampleText",
 CellID->868316270],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LegendreQ", "[", 
  RowBox[{"1", ",", "1", ",", "1", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->85865882],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"z", " ", 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox["z", "2"]}]]}], 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["z", "2"]}]], "+", 
  RowBox[{
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox["z", "2"]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "-", "z"}], "]"}]}], "-", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", "z"}], "]"}]}]}], ")"}]}]}]], "Output",
 ImageSize->{314, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->652043713]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LegendreQ", "[", 
   RowBox[{"1", ",", "1", ",", "2", ",", "z"}], "]"}], "//", 
  "FunctionExpand"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->205513051],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "2"]}], " ", 
  SqrtBox[
   RowBox[{"1", "-", "z"}]], " ", 
  SqrtBox[
   RowBox[{"1", "+", "z"}]], " ", 
  RowBox[{"(", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", "z"}], 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "z"}], ")"}]}]], "-", 
    FractionBox[
     RowBox[{"1", "+", "z"}], 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "z"}], ")"}]}]], "-", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "z"}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "z"}], "]"}]}], ")"}]}]], "Output",
 ImageSize->{412, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->176054303]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LegendreQ", "[", 
   RowBox[{"1", ",", "1", ",", "3", ",", "z"}], "]"}], "//", 
  "FunctionExpand"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->6083004],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SqrtBox[
   RowBox[{
    RowBox[{"-", "1"}], "+", "z"}]], " ", 
  SqrtBox[
   RowBox[{"1", "+", "z"}]], " ", 
  RowBox[{"(", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", "z"}], 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "z"}], ")"}]}]], "-", 
    FractionBox[
     RowBox[{"1", "+", "z"}], 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "z"}], ")"}]}]], "-", 
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "z"}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "z"}], "]"}]}], ")"}]}]], "Output",
 ImageSize->{419, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->270831996]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->211830054],

Cell["Types 2 and 3 have different branch cut structures:", "ExampleText",
 CellID->415200853],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"LegendreQ", "[", 
     RowBox[{"1", ",", "1", ",", "2", ",", 
      RowBox[{"x", "-", 
       RowBox[{"I", " ", "y"}]}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"y", "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"Abs", "[", "x", "]"}], ">", "1"}]}], "}"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->215596748],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->159973910]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"LegendreQ", "[", 
     RowBox[{"1", ",", "1", ",", "3", ",", 
      RowBox[{"x", "-", 
       RowBox[{"I", " ", "y"}]}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"y", "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"Abs", "[", "x", "]"}], "<", "1"}]}], "}"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->192489196],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->66045806]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8702],

Cell["Angular momentum eigenfunctions:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->333193916],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
         RowBox[{
          RowBox[{"f", "'"}], "[", "\[Theta]", "]"}]}], ",", "\[Theta]"}], 
       "]"}]}], "-", 
     RowBox[{
      SuperscriptBox["m", "2"], 
      RowBox[{"f", "[", "\[Theta]", "]"}]}]}], "==", 
    RowBox[{
     RowBox[{"-", "\[Lambda]"}], 
     RowBox[{"(", 
      RowBox[{"\[Lambda]", "+", "1"}], ")"}], 
     SuperscriptBox[
      RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"], 
     RowBox[{"f", "[", "\[Theta]", "]"}]}]}], ",", 
   RowBox[{"f", "[", "\[Theta]", "]"}], ",", "\[Theta]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->71240200],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", "\[Theta]", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"LegendreP", "[", 
       RowBox[{"\[Lambda]", ",", "m", ",", 
        RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"LegendreQ", "[", 
       RowBox[{"\[Lambda]", ",", "m", ",", 
        RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "]"}]}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{462, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->234787414]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6263641],

Cell["Solve a recurrence equation:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->254665169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"n", "+", "m"}], ")"}], 
      RowBox[{"f", "[", 
       RowBox[{"n", "-", "1"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"n", "-", "m", "+", "1"}], ")"}], 
      RowBox[{"f", "[", 
       RowBox[{"n", "+", "1"}], "]"}]}]}], "==", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", 
       RowBox[{"1", "/", "2"}]}], ")"}], 
     RowBox[{"f", "[", "n", "]"}]}]}], ",", 
   RowBox[{"f", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->314672276],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"LegendreP", "[", 
       RowBox[{"n", ",", "m", ",", "2", ",", 
        FractionBox["1", "2"]}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"LegendreQ", "[", 
       RowBox[{"n", ",", "m", ",", "2", ",", 
        FractionBox["1", "2"]}], "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{436, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->434410431]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3611],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " to expand ",
 Cell[BoxData[
  ButtonBox["LegendreQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LegendreQ"]], "InlineFormula"],
 " of integer or half-integer parameters into simpler functions:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->75718060],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"LegendreQ", "[", 
   RowBox[{"3", ",", "1", ",", "3", ",", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69191339],

Cell[BoxData[
 RowBox[{"9", " ", 
  SqrtBox[
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}]], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], 
   RowBox[{"5", "/", "2"}]], " ", 
  RowBox[{"(", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}], ")"}], "3"], 
     RowBox[{"144", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", "x"}], ")"}], "3"]}]], "-", 
    FractionBox[
     RowBox[{"1", "+", "x"}], 
     RowBox[{"144", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}], ")"}]}]], "+", 
    RowBox[{
     FractionBox["1", "12"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["7", "3"]}], "-", 
       RowBox[{"Log", "[", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "x"}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"1", "+", "x"}], "]"}]}], ")"}]}], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Log", "[", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "x"}], "]"}]}], "+", 
        RowBox[{"Log", "[", 
         RowBox[{"1", "+", "x"}], "]"}]}], ")"}]}], 
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "x"}], ")"}]}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "x"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        FractionBox["7", "3"], "-", 
        RowBox[{"Log", "[", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "x"}], "]"}], "+", 
        RowBox[{"Log", "[", 
         RowBox[{"1", "+", "x"}], "]"}]}], ")"}]}], 
     RowBox[{"12", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", "x"}], ")"}], "2"]}]]}], ")"}]}]], "Output",
 ImageSize->{531, 86},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->46107954]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"LegendreQ", "[", 
   RowBox[{
    RowBox[{"3", "/", "2"}], ",", 
    RowBox[{"1", "/", "2"}], ",", "3", ",", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->912382834],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SqrtBox[
        RowBox[{"1", "+", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "x"}], ")"}]}]}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "x"}], ")"}], 
        RowBox[{"1", "/", "4"}]], " ", "x"}], 
      RowBox[{
       SqrtBox["\[Pi]"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "x"}], ")"}], 
        RowBox[{"1", "/", "4"}]]}]]}], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", "x"}], ")"}], 
       RowBox[{"1", "/", "4"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}], 
     RowBox[{
      SqrtBox["\[Pi]"], " ", 
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "x"}], ")"}]}]}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "x"}], ")"}], 
       RowBox[{"1", "/", "4"}]]}]]}], ")"}]}]], "Output",
 ImageSize->{467, 81},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->44792354]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25768],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LegendreP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LegendreP"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpheroidalQS",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SpheroidalQS"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2294]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31895],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->14629]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->4109614],

Cell[TextData[ButtonBox["Functions for Separable Coordinate Systems",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/FunctionsForSeparableCoordinateSystems"]], "MoreAbout",
 CellID->411476194],

Cell[TextData[ButtonBox["Functions Used in Quantum Mechanics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInQuantumMechanics"]], "MoreAbout",
 CellID->170239295],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->22382156]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LegendreQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 52, 45.1240470}", "context" -> "System`", 
    "keywords" -> {
     "Legendre function of second kind", "Legendre functions", 
      "Legendre polynomials", "ring functions", "toroidal functions"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "LegendreQ[n, z] gives the Legendre function of the second kind Q_n (z). \
LegendreQ[n, m, z] gives the associated Legendre function of the second kind \
SubsuperscriptBox[Q, n, m](z). ", "synonyms" -> {"Legendre q"}, "title" -> 
    "LegendreQ", "type" -> "Symbol", "uri" -> "ref/LegendreQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7398, 256, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->472798214]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 76600, 2049}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2264, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2887, 82, 47, 1, 70, "ObjectName",
 CellID->23679],
Cell[2937, 85, 1266, 42, 70, "Usage",
 CellID->10366]
}, Open  ]],
Cell[CellGroupData[{
Cell[4240, 132, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4718, 149, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4841, 155, 225, 9, 70, "Notes",
 CellID->27412],
Cell[5069, 166, 741, 25, 70, "Notes",
 CellID->16312],
Cell[5813, 193, 467, 16, 70, "Notes",
 CellID->38],
Cell[6283, 211, 397, 12, 70, "Notes",
 CellID->24954],
Cell[6683, 225, 249, 8, 70, "Notes",
 CellID->62521461],
Cell[6935, 235, 220, 7, 70, "Notes",
 CellID->31226],
Cell[7158, 244, 203, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[7398, 256, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->472798214],
Cell[CellGroupData[{
Cell[7783, 270, 148, 5, 70, "ExampleSection",
 CellID->135309929],
Cell[7934, 277, 333, 11, 70, "ExampleText",
 CellID->640762226],
Cell[CellGroupData[{
Cell[8292, 292, 127, 4, 28, "Input",
 CellID->43557986],
Cell[8422, 298, 919, 33, 54, "Output",
 CellID->391920536]
}, Open  ]],
Cell[9356, 334, 125, 3, 70, "ExampleDelimiter",
 CellID->523117434],
Cell[9484, 339, 48, 1, 70, "ExampleText",
 CellID->716327516],
Cell[CellGroupData[{
Cell[9557, 344, 270, 9, 28, "Input",
 CellID->190341909],
Cell[9830, 355, 3522, 62, 159, "Output",
 Evaluatable->False,
 CellID->76368745]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13401, 423, 215, 7, 70, "ExampleSection",
 CellID->5008],
Cell[13619, 432, 104, 2, 70, "ExampleText",
 CellID->52041266],
Cell[CellGroupData[{
Cell[13748, 438, 137, 4, 70, "Input",
 CellID->15744172],
Cell[13888, 444, 1130, 43, 69, "Output",
 CellID->208307525]
}, Open  ]],
Cell[15033, 490, 125, 3, 70, "ExampleDelimiter",
 CellID->585566706],
Cell[15161, 495, 74, 1, 70, "ExampleText",
 CellID->450426914],
Cell[CellGroupData[{
Cell[15260, 500, 154, 5, 70, "Input",
 CellID->145446116],
Cell[15417, 507, 193, 6, 36, "Output",
 CellID->396256602]
}, Open  ]],
Cell[15625, 516, 125, 3, 70, "ExampleDelimiter",
 CellID->244111042],
Cell[15753, 521, 210, 5, 70, "ExampleText",
 CellID->50985404],
Cell[CellGroupData[{
Cell[15988, 530, 187, 6, 70, "Input",
 CellID->18017102],
Cell[16178, 538, 271, 7, 36, "Output",
 CellID->135429283]
}, Open  ]],
Cell[16464, 548, 125, 3, 70, "ExampleDelimiter",
 CellID->103785716],
Cell[16592, 553, 207, 5, 70, "ExampleText",
 CellID->113336957],
Cell[CellGroupData[{
Cell[16824, 562, 235, 8, 70, "Input",
 CellID->186586230],
Cell[17062, 572, 252, 8, 36, "Output",
 CellID->186992831]
}, Open  ]],
Cell[17329, 583, 124, 3, 70, "ExampleDelimiter",
 CellID->82858706],
Cell[17456, 588, 113, 3, 70, "ExampleText",
 CellID->493308527],
Cell[CellGroupData[{
Cell[17594, 595, 183, 6, 70, "Input",
 CellID->70173555],
Cell[17780, 603, 235, 7, 36, "Output",
 CellID->75504422]
}, Open  ]],
Cell[18030, 613, 124, 3, 70, "ExampleDelimiter",
 CellID->20532249],
Cell[18157, 618, 212, 7, 70, "ExampleText",
 CellID->588992016],
Cell[CellGroupData[{
Cell[18394, 629, 186, 6, 70, "Input",
 CellID->63244004],
Cell[18583, 637, 1475, 53, 81, "Output",
 CellID->299107698]
}, Open  ]],
Cell[20073, 693, 125, 3, 70, "ExampleDelimiter",
 CellID->221206573],
Cell[20201, 698, 203, 7, 70, "ExampleText",
 CellID->195066382],
Cell[CellGroupData[{
Cell[20429, 709, 180, 6, 70, "Input",
 CellID->763553971],
Cell[20612, 717, 293, 10, 52, "Output",
 CellID->115518516]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20954, 733, 239, 7, 70, "ExampleSection",
 CellID->27563],
Cell[21196, 742, 213, 7, 70, "ExampleText",
 CellID->184078806],
Cell[CellGroupData[{
Cell[21434, 753, 240, 8, 70, "Input",
 CellID->204986240],
Cell[21677, 763, 731, 24, 54, "Output",
 CellID->52321073]
}, Open  ]],
Cell[22423, 790, 125, 3, 70, "ExampleDelimiter",
 CellID->319796208],
Cell[22551, 795, 231, 8, 70, "ExampleText",
 CellID->868316270],
Cell[CellGroupData[{
Cell[22807, 807, 147, 4, 70, "Input",
 CellID->85865882],
Cell[22957, 813, 727, 28, 62, "Output",
 CellID->652043713]
}, Open  ]],
Cell[CellGroupData[{
Cell[23721, 846, 189, 6, 70, "Input",
 CellID->205513051],
Cell[23913, 854, 802, 30, 53, "Output",
 CellID->176054303]
}, Open  ]],
Cell[CellGroupData[{
Cell[24752, 889, 187, 6, 70, "Input",
 CellID->6083004],
Cell[24942, 897, 825, 31, 53, "Output",
 CellID->270831996]
}, Open  ]],
Cell[25782, 931, 125, 3, 70, "ExampleDelimiter",
 CellID->211830054],
Cell[25910, 936, 94, 1, 70, "ExampleText",
 CellID->415200853],
Cell[CellGroupData[{
Cell[26029, 941, 701, 23, 70, "Input",
 CellID->215596748],
Cell[26733, 966, 16353, 272, 70, "Output",
 Evaluatable->False,
 CellID->159973910]
}, Open  ]],
Cell[CellGroupData[{
Cell[43123, 1243, 701, 23, 70, "Input",
 CellID->192489196],
Cell[43827, 1268, 20586, 342, 70, "Output",
 Evaluatable->False,
 CellID->66045806]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[64462, 1616, 222, 7, 70, "ExampleSection",
 CellID->8702],
Cell[64687, 1625, 212, 5, 70, "ExampleText",
 CellID->333193916],
Cell[CellGroupData[{
Cell[64924, 1634, 829, 26, 70, "Input",
 CellID->71240200],
Cell[65756, 1662, 673, 21, 36, "Output",
 CellID->234787414]
}, Open  ]],
Cell[66444, 1686, 123, 3, 70, "ExampleDelimiter",
 CellID->6263641],
Cell[66570, 1691, 208, 5, 70, "ExampleText",
 CellID->254665169],
Cell[CellGroupData[{
Cell[66803, 1700, 633, 22, 70, "Input",
 CellID->314672276],
Cell[67439, 1724, 635, 20, 51, "Output",
 CellID->434410431]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[68123, 1750, 232, 7, 70, "ExampleSection",
 CellID->3611],
Cell[68358, 1759, 533, 17, 70, "ExampleText",
 CellID->75718060],
Cell[CellGroupData[{
Cell[68916, 1780, 189, 5, 70, "Input",
 CellID->69191339],
Cell[69108, 1787, 2114, 75, 107, "Output",
 CellID->46107954]
}, Open  ]],
Cell[CellGroupData[{
Cell[71259, 1867, 240, 7, 70, "Input",
 CellID->912382834],
Cell[71502, 1876, 1563, 55, 102, "Output",
 CellID->44792354]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[73126, 1938, 311, 9, 70, "SeeAlsoSection",
 CellID->25768],
Cell[73440, 1949, 460, 17, 70, "SeeAlso",
 CellID->2294]
}, Open  ]],
Cell[CellGroupData[{
Cell[73937, 1971, 314, 9, 70, "TutorialsSection",
 CellID->31895],
Cell[74254, 1982, 144, 3, 70, "Tutorials",
 CellID->14629]
}, Open  ]],
Cell[CellGroupData[{
Cell[74435, 1990, 317, 9, 70, "MoreAboutSection",
 CellID->4109614],
Cell[74755, 2001, 195, 4, 70, "MoreAbout",
 CellID->411476194],
Cell[74953, 2007, 178, 3, 70, "MoreAbout",
 CellID->170239295],
Cell[75134, 2012, 144, 3, 70, "MoreAbout",
 CellID->22382156]
}, Open  ]],
Cell[75293, 2018, 50, 0, 70, "History"],
Cell[75346, 2020, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

