(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     48672,       1774]
NotebookOptionsPosition[     38536,       1402]
NotebookOutlinePosition[     39800,       1439]
CellTagsIndexPosition[     39714,       1434]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Controlling the Display of Large Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ControllingTheDisplayOfLargeExpressions"], 
          "Vectors and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/VectorsAndMatrices"], 
          "Manipulating Expressions like Lists" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingExpressionsLikeLists"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Controlling the Display of Large Expressions\"\>", 
       2->"\<\"Vectors and Matrices\"\>", 
       3->"\<\"Manipulating Expressions like Lists\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LeafCount" :> Documentation`HelpLookup["paclet:ref/LeafCount"],
           "ByteCount" :> Documentation`HelpLookup["paclet:ref/ByteCount"], 
          "Depth" :> Documentation`HelpLookup["paclet:ref/Depth"], 
          "StringLength" :> 
          Documentation`HelpLookup["paclet:ref/StringLength"], "AtomQ" :> 
          Documentation`HelpLookup["paclet:ref/AtomQ"], "ComplexityFunction" :> 
          Documentation`HelpLookup["paclet:ref/ComplexityFunction"], 
          "LengthWhile" :> 
          Documentation`HelpLookup["paclet:ref/LengthWhile"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"LeafCount\"\>", 
       2->"\<\"ByteCount\"\>", 3->"\<\"Depth\"\>", 4->"\<\"StringLength\"\>", 
       5->"\<\"AtomQ\"\>", 6->"\<\"ComplexityFunction\"\>", 
       7->"\<\"LengthWhile\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elements of Lists" :> 
          Documentation`HelpLookup["paclet:guide/ElementsOfLists"], 
          "Expressions" :> 
          Documentation`HelpLookup["paclet:guide/Expressions"], 
          "Expression Structure" :> 
          Documentation`HelpLookup["paclet:guide/ExpressionStructure"], 
          "Handling Arrays of Data" :> 
          Documentation`HelpLookup["paclet:guide/HandlingArraysOfData"], 
          "Language Overview" :> 
          Documentation`HelpLookup["paclet:guide/LanguageOverview"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Math & Counting Operations on Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicalAndCountingOperationsOnLists"], 
          "Memory Measurement & Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/MemoryMeasurementAndOptimization"], 
          "Operations on Vectors" :> 
          Documentation`HelpLookup["paclet:guide/OperationsOnVectors"], 
          "Parts of Expressions" :> 
          Documentation`HelpLookup["paclet:guide/PartsOfExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Elements of Lists\"\>", 
       2->"\<\"Expressions\"\>", 3->"\<\"Expression Structure\"\>", 
       4->"\<\"Handling Arrays of Data\"\>", 5->"\<\"Language Overview\"\>", 
       6->"\<\"List Manipulation\"\>", 
       7->"\<\"Math & Counting Operations on Lists\"\>", 
       8->"\<\"Memory Measurement & Optimization\"\>", 
       9->"\<\"Operations on Vectors\"\>", 
       10->"\<\"Parts of Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Length", "ObjectName",
 CellID->22794],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Length",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Length"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the number of elements in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17373]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " object, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Length",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Length"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " returns the length of the corresponding ordinary list. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->4287,
  ButtonNote->"4287"]
}], "Notes",
 CellID->9339],

Cell[TextData[{
 "Otherwise, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Length",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Length"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " returns ",
 Cell[BoxData["0"], "InlineFormula"],
 " whenever ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AtomQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AtomQ"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4492]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->423591918],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->247076017],

Cell["Find the length of a list:", "ExampleText",
 CellID->2255],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31581],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19620]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10990],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Length",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Length"]], "InlineFormula"],
 " works with any head:"
}], "ExampleText",
 CellID->9426],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"a", "+", "b", "+", "c", "+", "d"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17027],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15826]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1632],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Length",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Length"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " gives the number of elements in the top level of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->9208],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"g", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", "z"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12633],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13033]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23692],

Cell["The length of a symbol is 0:", "ExampleText",
 CellID->4697],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "x", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24516],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22079]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5385],

Cell["The length of a string is 0:", "ExampleText",
 CellID->30383],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "\"\<string\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10657],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13132]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringLength",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringLength"]], "InlineFormula"],
 " gives the number of characters:"
}], "ExampleText",
 CellID->28726],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringLength", "[", "\"\<string\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10088],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1269]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15377],

Cell["Explicit numbers have length 0:", "ExampleText",
 CellID->23527],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "123456", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20377],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21204]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"1", "/", "10"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26211],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27496]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"3", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->5872],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->14209]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13190],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Length",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Length"]], "InlineFormula"],
 " works on ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->4287],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1514],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "5", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 5, ">"],
     Editable->False], ",", 
    RowBox[{"{", "5", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15830]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22013],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31538]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18918],

Cell["Find the number of rows in a matrix:", "ExampleText",
 CellID->27041],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "e", ",", "f"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16137],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16313]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7906],

Cell["Find the length of each sublist:", "ExampleText",
 CellID->29169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"Length", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", "x", "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10901],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3", ",", "1"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8419]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31801],

Cell["Find the number of terms in a polynomial:", "ExampleText",
 CellID->4777],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"1", "+", "x", "+", 
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{"x", "^", "9"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27761],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1154]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5635],

Cell["Find the number of digits in 1000!:", "ExampleText",
 CellID->13974],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"IntegerDigits", "[", 
   RowBox[{"1000", "!"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28424],

Cell[BoxData["2568"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27365]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->156154491],

Cell["Get the number of points used to plot a curve:", "ExampleText",
 CellID->1018400217],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "20"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->636035672],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->139081293]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{"Cases", "[", 
   RowBox[{"p", ",", 
    RowBox[{"x_Line", "\[RuleDelayed]", 
     RowBox[{"Length", "[", 
      RowBox[{"x", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", "Infinity"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->513796557],

Cell[BoxData["926"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->15139043]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27808],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Length",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Length"]], "InlineFormula"],
 " gives the maximum index that can be used:"
}], "ExampleText",
 CellID->6312],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3415],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24484]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "[", 
  RowBox[{"[", "4", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18332],

Cell[BoxData["d"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->25417]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13199],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Length",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Length"]], "InlineFormula"],
 " operates on the ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " of expressions, not their displayed form:"
}], "ExampleText",
 CellID->22486],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", "x", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23021],

Cell[BoxData[
 SqrtBox["x"]], "Output",
 ImageSize->{28, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18768]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4836],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->17634]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"Sqrt", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->16618],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Power", "[", 
    RowBox[{"x", ",", 
     RowBox[{"Rational", "[", 
      RowBox[{"1", ",", "2"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//FullForm=",
 CellID->7225]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19397],

Cell["Rational and complex numbers are atoms, so have length 0:", \
"ExampleText",
 CellID->10667],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"1", "/", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30603],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4003]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"1", "/", "3"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22760],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Rational", "[", 
    RowBox[{"1", ",", "3"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->17501]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"2", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->30815],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->21671]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"2", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1169],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Complex", "[", 
    RowBox[{"2", ",", "1"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//FullForm=",
 CellID->23938]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13271],

Cell["\<\
Numeric expressions are treated like other expressions, not like explicit \
numbers:\
\>", "ExampleText",
 CellID->31692],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"Sqrt", "[", "7", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14269],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10859]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "7", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30992],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2694]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18848],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Length",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Length"]], "InlineFormula"],
 " counts only \[OpenCurlyDoubleQuote]arguments",
 "\[CloseCurlyDoubleQuote]",
 ", not parts of heads:"
}], "ExampleText",
 CellID->11985],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{
   RowBox[{"h", "[", 
    RowBox[{"a", ",", "b"}], "]"}], "[", 
   RowBox[{"x", ",", "y", ",", "z"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24814],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2556]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->228100113],

Cell[TextData[{
 "For nonatomic ",
 Cell[BoxData[
  StyleBox["e", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Length",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Length"], "[", 
   StyleBox["e", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to",
 Cell[BoxData[
  RowBox[{" ", 
   RowBox[{
    ButtonBox["First",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/First"], "[", 
    RowBox[{
     ButtonBox["Dimensions",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dimensions"], "[", 
     StyleBox["e", "TI"], "]"}], "]"}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->106513751],

Cell[BoxData[
 RowBox[{
  RowBox[{"exprs", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "6"}], "}"}]}], "}"}], ",", 
     RowBox[{"SparseArray", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", "7", "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "9"}], "}"}]}], "]"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->723291876],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"e", ",", 
       RowBox[{"Length", "[", "e", "]"}], ",", 
       RowBox[{"Dimensions", "[", "e", "]"}], ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Dimensions", "[", "e", "]"}], "===", 
          RowBox[{"{", "}"}]}], ",", "0", ",", 
         RowBox[{"First", "[", 
          RowBox[{"Dimensions", "[", "e", "]"}], "]"}]}], "]"}]}], "}"}], ",",
      
     RowBox[{"{", 
      RowBox[{"e", ",", "exprs"}], "}"}]}], "]"}], ",", 
   RowBox[{"TableDepth", "\[Rule]", "2"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<e\>\"", ",", "\"\<Length[e]\>\"", ",", "\"\<Dimensions[e]\>\"", 
        ",", "\"\<\\\"First\\\" dimension\>\""}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->114400410],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW0uPWzUUdnJzM68+KJVoWTFCQvwEVp2WV1uQELSqKF2OKqR2gVqm/QGI
P4C6AxY8NkAXsIJfgFRWsKN7xAbxA2Bp4lyfxPnuZx/7JpkEmEiTm2P7PH3O
sY+v5439+7fefW///u2b+7uXDvbv3rp9897uxTsHo6aqZ0zvV2PMjbNm9NuO
fo3/3Ofx6K/52fyq3XclvdZsjr4ceG70HJimvz96Pg3jtgHeAvgkwANP53oh
3g9USsTaI9xC+KznjlJv+/ZTCv61TLzvqbT9MckGNuNP5a3r+NTSYHzf6K8f
9LtnQ1I+Qp5h1b5ZnimthgDXnkZqzCbAjkdl2joPfTviowzH/LhX56R73rcf
RGegL9oNpu3eRu2WetLiTVzTVrTWgI7S5oFzlIhBXWLtlW8f+ifGSD/JBSND
k3mHUntloTz3KPb7ls3w2B86zexWa5yjlRM/nF6INfEc4osb0C6Z9kQWF8w8
KCvCfL5eXgivcxSr4zzZJuMx21eR3CY+lZqrQUh3hj8bmYovtAb38RN2msGX
FUcxHiVxI3lWtFMzpB/HMx2Xk82VWLiUlraGYUZGmPlyJVGncitdvfKonrfa
2sX8MFz9w+jAPtlriEwhdxPB6UfoyC6jmqhhgt6WXwfwU0yrlmWOd5qFeWIo
j2NJRLU8cPTzeWjbPbKW70Dvc9/P+bZn/XPH8hpEPPGkbXu2aC4rqmu+WIh/
wabi0n39stIetjMsrcnmrelC+EEhPq/tNP+N1V7iSV1rvI8y8XiNp0kdq2e2
7DRzp/Bz666NSDvSc7FQR+K+JrEwjLTv+XYe3ZpV0vUBZkVWbZVXOhvRXs1e
89Y7eZxLs2dKaqwxnEWHhOfxDLxITazZLIDRWjge8wPu7fCUh+dlbSaRKtet
VLY8KghfntNCbMUK4W5RKf465paslVCecN8rp4cpTq8BjPUo4jN+IfwiwHc7
6Y9zG0ZHjm+gVFjRa2dirwP8koKP/DFPIv6dTlbhuS3k3cU22J+VU9Zm96pJ
KztMt4dwEYXas7OEgZnuSLX8ftn+P3a2uML/rvT/RKnSSiiAf1P6H2VRje2g
PrZlO663bMnOKu+05FOAtfUG4asAd9uVYP76BGBtFUD4SpZUOave4dsKsTRb
rkYq7ZRtNVKtk8+zUyCWeZ00biW4RMazU+ervv0e5eq+1itTo2f8CXC3TI3w
HwB3y9QIf2HL3kVesalVVOP2uWXem19R4lrRtWbE2P6M0sp7U4S83iyQa13t
dSTXf0MuLVN9adN7abYuxKPffa02M/+t6Mux/gIYtf6ZYske9mvLMyhSeSdp
Oxz9lc3xGMS6TrHyfJZzxByImfPthXM8fB2POJZxlLcOD208e4TwDTtv1nDC
PHYCLTl//OglPW1n38JdA/hDiv0I4CcAxh0b7rKx/4Oo9d15iZtnuRUSvy8X
3qqroqPYTRp2y2LLxu/w1QE3/e6enAyJBiIrl5Gdq8ZkPGWna5fIFMpW2+n5
FLuHuCSdgnE9MyGXiJqHoriHc2/eJe6jbEBr2JeQRLsfud2SlOpWTziGknbU
J68uLmmlFBNaPwmwVnMkbs7xE+YinVdv1Z5l2eoQvFq1cenMbi/d+lk3uDJt
UHobbF4/5m90T/+rbBb3VdnRowXqKK1FeyY7F5/XI+PSx855SnWN0WDahB5n
CF7sHixb6dfXKol82BrLPI7z4fdVpYd53QSjOHYW7YUlGmXtSZZOj3ku8wux
M89c6hvQNbZiL+rJEiPfQLtEK7tPK7csGnXHHxvE4cz/C8X4YTv3Stl3C1Z4
17JSJBwE+HXGWJy7pKTRuyUmkHZAuFWBZGixZpRUp2LdpmPZVuhT7/gOYLzH
qp3IYy3cth2eaOgYPDrPMMlm8PAuywtU42+9jZ7xNtq0s2cGO96mqOkusVSI
dyxi86Fpx/cZMlbw0UuR77jmGAPNf0ma3j+f9258\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{469, 89},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TableForm=",
 CellID->210672854]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15769],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LeafCount",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LeafCount"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ByteCount",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ByteCount"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Depth",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Depth"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringLength",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringLength"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AtomQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AtomQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ComplexityFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ComplexityFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LengthWhile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LengthWhile"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10768]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1798],

Cell[TextData[ButtonBox["Controlling the Display of Large Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ControllingTheDisplayOfLargeExpressions"]], "Tutorials",
 CellID->29761],

Cell[TextData[ButtonBox["Vectors and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/VectorsAndMatrices"]], "Tutorials",
 CellID->30856],

Cell[TextData[ButtonBox["Manipulating Expressions like Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingExpressionsLikeLists"]], "Tutorials",\

 CellID->10496]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->152578440],

Cell[TextData[ButtonBox["Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "MoreAbout",
 CellID->101647944],

Cell[TextData[ButtonBox["Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Expressions"]], "MoreAbout",
 CellID->380036714],

Cell[TextData[ButtonBox["Expression Structure",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExpressionStructure"]], "MoreAbout",
 CellID->343080092],

Cell[TextData[ButtonBox["Handling Arrays of Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HandlingArraysOfData"]], "MoreAbout",
 CellID->329080380],

Cell[TextData[ButtonBox["Language Overview",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LanguageOverview"]], "MoreAbout",
 CellID->417326281],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->159197537],

Cell[TextData[ButtonBox["Math & Counting Operations on Lists",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathematicalAndCountingOperationsOnLists"]], "MoreAbout",
 CellID->613647062],

Cell[TextData[ButtonBox["Memory Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MemoryMeasurementAndOptimization"]], "MoreAbout",
 CellID->248610950],

Cell[TextData[ButtonBox["Operations on Vectors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/OperationsOnVectors"]], "MoreAbout",
 CellID->83084061],

Cell[TextData[ButtonBox["Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PartsOfExpressions"]], "MoreAbout",
 CellID->135964611]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Length"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Length - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 52, 46.3272028}", "context" -> "System`", 
    "keywords" -> {
     "length of list", "nops", "number of elements", "number of terms", 
      "size of array"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Length[expr] gives the number of elements in expr. ", "synonyms" -> {}, 
    "title" -> "Length", "type" -> "Symbol", "uri" -> "ref/Length"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7220, 213, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->423591918]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 39571, 1427}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4259, 90, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4882, 117, 44, 1, 70, "ObjectName",
 CellID->22794],
Cell[4929, 120, 552, 18, 70, "Usage",
 CellID->17373]
}, Open  ]],
Cell[CellGroupData[{
Cell[5518, 143, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5996, 160, 596, 22, 70, "Notes",
 CellID->9339],
Cell[6595, 184, 588, 24, 70, "Notes",
 CellID->4492]
}, Closed]],
Cell[CellGroupData[{
Cell[7220, 213, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->423591918],
Cell[CellGroupData[{
Cell[7605, 227, 148, 5, 70, "ExampleSection",
 CellID->247076017],
Cell[7756, 234, 64, 1, 70, "ExampleText",
 CellID->2255],
Cell[CellGroupData[{
Cell[7845, 239, 165, 5, 28, "Input",
 CellID->31581],
Cell[8013, 246, 154, 5, 36, "Output",
 CellID->19620]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8216, 257, 216, 7, 70, "ExampleSection",
 CellID->10990],
Cell[8435, 266, 189, 7, 70, "ExampleText",
 CellID->9426],
Cell[CellGroupData[{
Cell[8649, 277, 141, 4, 70, "Input",
 CellID->17027],
Cell[8793, 283, 154, 5, 36, "Output",
 CellID->15826]
}, Open  ]],
Cell[8962, 291, 120, 3, 70, "ExampleDelimiter",
 CellID->1632],
Cell[9085, 296, 338, 12, 70, "ExampleText",
 CellID->9208],
Cell[CellGroupData[{
Cell[9448, 312, 206, 7, 70, "Input",
 CellID->12633],
Cell[9657, 321, 154, 5, 36, "Output",
 CellID->13033]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9860, 332, 239, 7, 70, "ExampleSection",
 CellID->23692],
Cell[10102, 341, 66, 1, 70, "ExampleText",
 CellID->4697],
Cell[CellGroupData[{
Cell[10193, 346, 98, 3, 70, "Input",
 CellID->24516],
Cell[10294, 351, 154, 5, 36, "Output",
 CellID->22079]
}, Open  ]],
Cell[10463, 359, 120, 3, 70, "ExampleDelimiter",
 CellID->5385],
Cell[10586, 364, 67, 1, 70, "ExampleText",
 CellID->30383],
Cell[CellGroupData[{
Cell[10678, 369, 111, 3, 70, "Input",
 CellID->10657],
Cell[10792, 374, 154, 5, 36, "Output",
 CellID->13132]
}, Open  ]],
Cell[10961, 382, 213, 7, 70, "ExampleText",
 CellID->28726],
Cell[CellGroupData[{
Cell[11199, 393, 117, 3, 70, "Input",
 CellID->10088],
Cell[11319, 398, 153, 5, 36, "Output",
 CellID->1269]
}, Open  ]],
Cell[11487, 406, 121, 3, 70, "ExampleDelimiter",
 CellID->15377],
Cell[11611, 411, 70, 1, 70, "ExampleText",
 CellID->23527],
Cell[CellGroupData[{
Cell[11706, 416, 103, 3, 70, "Input",
 CellID->20377],
Cell[11812, 421, 154, 5, 36, "Output",
 CellID->21204]
}, Open  ]],
Cell[CellGroupData[{
Cell[12003, 431, 122, 4, 70, "Input",
 CellID->26211],
Cell[12128, 437, 154, 5, 36, "Output",
 CellID->27496]
}, Open  ]],
Cell[CellGroupData[{
Cell[12319, 447, 120, 4, 70, "Input",
 CellID->5872],
Cell[12442, 453, 154, 5, 36, "Output",
 CellID->14209]
}, Open  ]],
Cell[12611, 461, 121, 3, 70, "ExampleDelimiter",
 CellID->13190],
Cell[12735, 466, 365, 13, 70, "ExampleText",
 CellID->4287],
Cell[CellGroupData[{
Cell[13125, 483, 182, 6, 70, "Input",
 CellID->1514],
Cell[13310, 491, 449, 16, 36, "Output",
 CellID->15830]
}, Open  ]],
Cell[CellGroupData[{
Cell[13796, 512, 98, 3, 70, "Input",
 CellID->22013],
Cell[13897, 517, 154, 5, 36, "Output",
 CellID->31538]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14100, 528, 223, 7, 70, "ExampleSection",
 CellID->18918],
Cell[14326, 537, 75, 1, 70, "ExampleText",
 CellID->27041],
Cell[CellGroupData[{
Cell[14426, 542, 267, 9, 70, "Input",
 CellID->16137],
Cell[14696, 553, 154, 5, 36, "Output",
 CellID->16313]
}, Open  ]],
Cell[14865, 561, 120, 3, 70, "ExampleDelimiter",
 CellID->7906],
Cell[14988, 566, 71, 1, 70, "ExampleText",
 CellID->29169],
Cell[CellGroupData[{
Cell[15084, 571, 324, 11, 70, "Input",
 CellID->10901],
Cell[15411, 584, 208, 7, 36, "Output",
 CellID->8419]
}, Open  ]],
Cell[15634, 594, 121, 3, 70, "ExampleDelimiter",
 CellID->31801],
Cell[15758, 599, 79, 1, 70, "ExampleText",
 CellID->4777],
Cell[CellGroupData[{
Cell[15862, 604, 189, 6, 70, "Input",
 CellID->27761],
Cell[16054, 612, 153, 5, 36, "Output",
 CellID->1154]
}, Open  ]],
Cell[16222, 620, 120, 3, 70, "ExampleDelimiter",
 CellID->5635],
Cell[16345, 625, 74, 1, 70, "ExampleText",
 CellID->13974],
Cell[CellGroupData[{
Cell[16444, 630, 160, 5, 70, "Input",
 CellID->28424],
Cell[16607, 637, 157, 5, 36, "Output",
 CellID->27365]
}, Open  ]],
Cell[16779, 645, 125, 3, 70, "ExampleDelimiter",
 CellID->156154491],
Cell[16907, 650, 90, 1, 70, "ExampleText",
 CellID->1018400217],
Cell[CellGroupData[{
Cell[17022, 655, 241, 8, 70, "Input",
 CellID->636035672],
Cell[17266, 665, 3873, 68, 70, "Output",
 Evaluatable->False,
 CellID->139081293]
}, Open  ]],
Cell[CellGroupData[{
Cell[21176, 738, 316, 10, 70, "Input",
 CellID->513796557],
Cell[21495, 750, 159, 5, 36, "Output",
 CellID->15139043]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21703, 761, 233, 7, 70, "ExampleSection",
 CellID->27808],
Cell[21939, 770, 210, 7, 70, "ExampleText",
 CellID->6312],
Cell[CellGroupData[{
Cell[22174, 781, 164, 5, 70, "Input",
 CellID->3415],
Cell[22341, 788, 154, 5, 36, "Output",
 CellID->24484]
}, Open  ]],
Cell[CellGroupData[{
Cell[22532, 798, 183, 6, 70, "Input",
 CellID->18332],
Cell[22718, 806, 154, 5, 36, "Output",
 CellID->25417]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22921, 817, 226, 7, 70, "ExampleSection",
 CellID->13199],
Cell[23150, 826, 352, 12, 70, "ExampleText",
 CellID->22486],
Cell[CellGroupData[{
Cell[23527, 842, 96, 3, 70, "Input",
 CellID->23021],
Cell[23626, 847, 165, 6, 38, "Output",
 CellID->18768]
}, Open  ]],
Cell[CellGroupData[{
Cell[23828, 858, 97, 3, 70, "Input",
 CellID->4836],
Cell[23928, 863, 154, 5, 36, "Output",
 CellID->17634]
}, Open  ]],
Cell[CellGroupData[{
Cell[24119, 873, 131, 4, 70, "Input",
 CellID->16618],
Cell[24253, 879, 408, 15, 50, "Output",
 CellID->7225]
}, Open  ]],
Cell[24676, 897, 121, 3, 70, "ExampleDelimiter",
 CellID->19397],
Cell[24800, 902, 98, 2, 70, "ExampleText",
 CellID->10667],
Cell[CellGroupData[{
Cell[24923, 908, 121, 4, 70, "Input",
 CellID->30603],
Cell[25047, 914, 153, 5, 36, "Output",
 CellID->4003]
}, Open  ]],
Cell[CellGroupData[{
Cell[25237, 924, 123, 4, 70, "Input",
 CellID->22760],
Cell[25363, 930, 347, 13, 50, "Output",
 CellID->17501]
}, Open  ]],
Cell[CellGroupData[{
Cell[25747, 948, 121, 4, 70, "Input",
 CellID->30815],
Cell[25871, 954, 154, 5, 36, "Output",
 CellID->21671]
}, Open  ]],
Cell[CellGroupData[{
Cell[26062, 964, 122, 4, 70, "Input",
 CellID->1169],
Cell[26187, 970, 345, 13, 50, "Output",
 CellID->23938]
}, Open  ]],
Cell[26547, 986, 121, 3, 70, "ExampleDelimiter",
 CellID->13271],
Cell[26671, 991, 131, 4, 70, "ExampleText",
 CellID->31692],
Cell[CellGroupData[{
Cell[26827, 999, 129, 4, 70, "Input",
 CellID->14269],
Cell[26959, 1005, 154, 5, 36, "Output",
 CellID->10859]
}, Open  ]],
Cell[CellGroupData[{
Cell[27150, 1015, 98, 3, 70, "Input",
 CellID->30992],
Cell[27251, 1020, 153, 5, 36, "Output",
 CellID->2694]
}, Open  ]],
Cell[27419, 1028, 121, 3, 70, "ExampleDelimiter",
 CellID->18848],
Cell[27543, 1033, 269, 9, 70, "ExampleText",
 CellID->11985],
Cell[CellGroupData[{
Cell[27837, 1046, 214, 7, 70, "Input",
 CellID->24814],
Cell[28054, 1055, 153, 5, 36, "Output",
 CellID->2556]
}, Open  ]],
Cell[28222, 1063, 125, 3, 70, "ExampleDelimiter",
 CellID->228100113],
Cell[28350, 1068, 642, 25, 70, "ExampleText",
 CellID->106513751],
Cell[28995, 1095, 589, 20, 70, "Input",
 CellID->723291876],
Cell[CellGroupData[{
Cell[29609, 1119, 995, 30, 70, "Input",
 CellID->114400410],
Cell[30607, 1151, 2215, 40, 70, "Output",
 Evaluatable->False,
 CellID->210672854]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[32883, 1198, 311, 9, 70, "SeeAlsoSection",
 CellID->15769],
Cell[33197, 1209, 1702, 62, 70, "SeeAlso",
 CellID->10768]
}, Open  ]],
Cell[CellGroupData[{
Cell[34936, 1276, 313, 9, 70, "TutorialsSection",
 CellID->1798],
Cell[35252, 1287, 197, 4, 70, "Tutorials",
 CellID->29761],
Cell[35452, 1293, 149, 3, 70, "Tutorials",
 CellID->30856],
Cell[35604, 1298, 180, 4, 70, "Tutorials",
 CellID->10496]
}, Open  ]],
Cell[CellGroupData[{
Cell[35821, 1307, 319, 9, 70, "MoreAboutSection",
 CellID->152578440],
Cell[36143, 1318, 144, 3, 70, "MoreAbout",
 CellID->101647944],
Cell[36290, 1323, 134, 3, 70, "MoreAbout",
 CellID->380036714],
Cell[36427, 1328, 151, 3, 70, "MoreAbout",
 CellID->343080092],
Cell[36581, 1333, 155, 3, 70, "MoreAbout",
 CellID->329080380],
Cell[36739, 1338, 145, 3, 70, "MoreAbout",
 CellID->417326281],
Cell[36887, 1343, 145, 3, 70, "MoreAbout",
 CellID->159197537],
Cell[37035, 1348, 190, 4, 70, "MoreAbout",
 CellID->613647062],
Cell[37228, 1354, 177, 3, 70, "MoreAbout",
 CellID->248610950],
Cell[37408, 1359, 151, 3, 70, "MoreAbout",
 CellID->83084061],
Cell[37562, 1364, 150, 3, 70, "MoreAbout",
 CellID->135964611]
}, Open  ]],
Cell[CellGroupData[{
Cell[37749, 1372, 305, 8, 70, "RelatedLinksSection"],
Cell[38057, 1382, 384, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[38456, 1398, 50, 0, 70, "History"],
Cell[38509, 1400, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

