(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     64223,       2402]
NotebookOptionsPosition[     50924,       1918]
NotebookOutlinePosition[     52346,       1957]
CellTagsIndexPosition[     52260,       1952]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Zeta" :> Documentation`HelpLookup["paclet:ref/Zeta"], 
          "PolyLog" :> Documentation`HelpLookup["paclet:ref/PolyLog"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Zeta\"\>", 
       2->"\<\"PolyLog\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Number Theoretic Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheoreticFunctions"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"], 
          "Recurrence and Sum Functions" :> 
          Documentation`HelpLookup["paclet:guide/RecurrenceAndSumFunctions"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"], 
          "Zeta Functions & Polylogarithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/ZetaFunctionsAndPolylogarithms"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Number Theoretic Functions\"\>", 
       2->"\<\"Number Theory\"\>", 3->"\<\"Recurrence and Sum Functions\"\>", 
       4->"\<\"Special Functions\"\>", 
       5->"\<\"Zeta Functions & Polylogarithms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LerchPhi", "ObjectName",
 CellID->16221],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LerchPhi",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LerchPhi"], "[", 
       RowBox[{
        StyleBox["z", "TI"], ",", 
        StyleBox["s", "TI"], ",", 
        StyleBox["a", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Lerch transcendent ",
     Cell[BoxData[
      RowBox[{
       StyleBox["\[CapitalPhi]", "TR"], 
       RowBox[{"(", 
        RowBox[{
         StyleBox["z", "TI"], ",", 
         StyleBox["s", "TI"], ",", 
         StyleBox["a", "TI"]}], ")"}]}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12812]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[CapitalPhi]", 
     RowBox[{"(", 
      RowBox[{"z", ",", "s", ",", "a"}], ")"}]}], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "0"}], "\[Infinity]",
      LimitsPositioning->True], 
     RowBox[{
      SuperscriptBox["z", "k"], "/", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"k", "+", "a"}], ")"}], "s"]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->23919],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Re", "(", "a", ")"}], "<", "0"}], TraditionalForm]], 
  "InlineMath"],
 ", the definition used is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[CapitalPhi]", 
     RowBox[{"(", 
      RowBox[{"z", ",", "s", ",", "a"}], ")"}]}], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "0"}], "\[Infinity]",
      LimitsPositioning->True], 
     RowBox[{
      SuperscriptBox["z", "k"], 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"k", "+", "a"}], ")"}], "2"], ")"}], 
       RowBox[{
        RowBox[{"-", "s"}], "/", "2"}]]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ", where any term with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"k", "+", "a"}], "=", "0"}], TraditionalForm]], "InlineMath"],
 " is excluded."
}], "Notes",
 CellID->23998],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["LerchPhi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LerchPhi"], "[", 
   RowBox[{
    StyleBox["z", "TI"], ",", 
    StyleBox["s", "TI"], ",", 
    StyleBox["a", "TI"], ",", 
    RowBox[{"DoublyInfinite", "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}]}], "]"}]], "InlineFormula"],
 " gives the sum ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"k", "=", "-", "\[Infinity]"}], "\[Infinity]",
     LimitsPositioning->True], 
    RowBox[{
     SuperscriptBox["z", "k"], "/", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"k", "+", "a"}], ")"}], "s"]}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->1917],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LerchPhi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LerchPhi"]], "InlineFormula"],
 " is a generalization of ",
 Cell[BoxData[
  ButtonBox["Zeta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Zeta"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PolyLog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolyLog"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9521],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["LerchPhi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LerchPhi"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->451505744],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LerchPhi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LerchPhi"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LerchPhi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LerchPhi"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->130338685],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->593185602],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LerchPhi", "[", 
  RowBox[{"1", ",", "2", ",", 
   RowBox[{"1", "/", "4"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31431],

Cell[BoxData[
 RowBox[{
  RowBox[{"8", " ", "Catalan"}], "+", 
  SuperscriptBox["\[Pi]", "2"]}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15725804]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19020],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LerchPhi", "[", 
  RowBox[{"2", ",", "3", ",", "1.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8724],

Cell[BoxData[
 RowBox[{"0.46069570328030096`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.2668245622654932`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->215314296]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"LerchPhi", "[", 
    RowBox[{"z", ",", "1", ",", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31662],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->208297110]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11280],

Cell["Evaluate for complex arguments and parameters:", "ExampleText",
 CellID->2842118],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LerchPhi", "[", 
  RowBox[{
   RowBox[{"1", "-", "I"}], ",", 
   RowBox[{
    RowBox[{"1", "/", "2"}], "+", "I"}], ",", "0.56"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->65576865],

Cell[BoxData[
 RowBox[{"0.6772721454954717`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.13567341403035404`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12311118]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->179588467],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->29287],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"LerchPhi", "[", 
    RowBox[{"1", ",", "2", ",", "3"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17979],

Cell[BoxData["0.\
3949340668482264364724151666460251892189499012067984377355582293701`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87753113]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->172132232],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->14449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LerchPhi", "[", 
  RowBox[{"1.0000000000000000000", ",", "2", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9188],

Cell[BoxData["0.39493406684822643647241516664595323411`19."], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->135829124]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20227],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LerchPhi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LerchPhi"]], "InlineFormula"],
 " threads element-wise over lists and matrices:"
}], "ExampleText",
 CellID->1848],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LerchPhi", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.2", ",", "1.5", ",", "1.8"}], "}"}], ",", " ", "2", ",", "2"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16672],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.6452565488777444`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.39776393292704304`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.3886201205459656`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.566136091075378`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.20166015625`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.5699340334365872`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{434, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->782298698]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2918],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->15747],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LerchPhi", "[", 
  RowBox[{"z", ",", 
   RowBox[{"-", "2"}], ",", "a"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12579],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "2"], "+", 
  FractionBox[
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "a"}], "+", 
       SuperscriptBox["a", "2"]}], ")"}], " ", "z"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"2", " ", "a"}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"]}]}], ")"}], " ", 
     SuperscriptBox["z", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["z", "3"]}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", "z"}], ")"}], "3"]]}]], "Output",
 ImageSize->{274, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->137228473]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LerchPhi", "[", 
  RowBox[{"z", ",", "s", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8923],

Cell[BoxData[
 FractionBox[
  RowBox[{"PolyLog", "[", 
   RowBox[{"s", ",", "z"}], "]"}], "z"]], "Output",
 ImageSize->{97, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->351057640]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LerchPhi", "[", 
  RowBox[{
   RowBox[{"-", "1"}], ",", " ", "s", ",", " ", 
   RowBox[{"1", "/", "2"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->19341],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["2", 
    RowBox[{"-", "s"}]], " ", 
   RowBox[{"Zeta", "[", 
    RowBox[{"s", ",", 
     FractionBox["1", "4"]}], "]"}]}], "-", 
  RowBox[{
   SuperscriptBox["2", 
    RowBox[{"-", "s"}]], " ", 
   RowBox[{"Zeta", "[", 
    RowBox[{"s", ",", 
     FractionBox["3", "4"]}], "]"}]}]}]], "Output",
 ImageSize->{201, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->156256498]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"LerchPhi", "[", 
    RowBox[{"1", ",", "2", ",", "1"}], "]"}], ",", 
   RowBox[{"LerchPhi", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "2", ",", 
     RowBox[{"1", "/", "2"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->6995],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    SuperscriptBox["\[Pi]", "2"], "6"], ",", 
   RowBox[{"4", " ", "Catalan"}]}], "}"}]], "Output",
 ImageSize->{106, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->186559013]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30874],

Cell["Evaluate derivatives numerically:", "ExampleText",
 CellID->20851],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Derivative", "[", 
    RowBox[{"2", ",", " ", "0", ",", " ", "0"}], "]"}], "[", "LerchPhi", 
   "]"}], "[", 
  RowBox[{"2.", ",", "Pi", ",", "Pi"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3466],

Cell[BoxData[
 RowBox[{"0.06552142869908323`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.07811906211507263`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->936445858]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Derivative", "[", 
      RowBox[{"0", ",", " ", "0", ",", "2"}], "]"}], "[", "LerchPhi", "]"}], 
    "[", 
    RowBox[{"2", ",", "Pi", ",", "Pi"}], "]"}], ",", " ", "50"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7189],

Cell[BoxData[
 RowBox[{"0.\
072714700575973993292813066920379730911478560268873763364307658741`50.\
107352500081895", "-", 
  RowBox[{
  "0.0340986318873053803486046256036602742892060918213624920796699519116`49.\
77846723444182", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{393, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->640994545]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->790540937],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->49105624],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LerchPhi", "[", 
   RowBox[{"z", ",", "s", ",", "a"}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->415201804],

Cell[GraphicsData["CompressedBitmap", "\<\
eJyVUlEOgjAM7dhQwRh//TCGE+wY+uUhFmICH0YD3H+2bDOjI4JLNvq619fS
9W6G5vE0Q1ub6taZd9PWfXV9deiSAgA07uMJ0LZojVtbi989nZLwuEAyXDBc
MixGFe7NV6hQWRTtFDI8iaAYU6HpinIr9zziZx5njCMjdUj+SAZZj51WzNgk
jF3kcTnUJMcke4D5V8FfHhbzMNW0yoT9q8vb2SrkXzni7lE0z1HMRix0RsU1
kbf0r1h6vOIFI1xN2GGS+AxeLJ85Pvtnhh1LJyeID6pYmsk=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->177723168]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22625],

Cell["Series expansion at special points:", "ExampleText",
 CellID->12956],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"LerchPhi", "[", 
     RowBox[{"z", ",", "s", ",", "a"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "0", ",", "4"}], "}"}]}], "]"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14023],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWltv0zAUdpM0WxdadoUxQOrLhCYQ2zSuEgh4AQmJRxCvVYXoHhBo7P8H
O7W37MvxznHiIMGkNj2Oz3cuPv5sJ/s0O198+zE7P53Pph/OZr8Wp/Pf0/c/
z3RTOlAqKZRS27tK/y71r+rj/sb6o9TQfKcX7eoGyAcgPwb5BORDkF8w+i+Z
+18qLzNonYD8AOQjkI8Z+Rmj/5y5//k/9hIr5C7Ia4zXnH7BRBlqH7MQqv9a
fyVaLOx1VGUthV7rIO8zVu8zVnHecPqYtScd7T/tqP+K8W+FzKKRh1pcZcZo
BWSs4cTiYL/ctqPdEch71+jHtItZu2P7Iety8RrclMhbaLyhdofWLualq93c
4mLVufyiH3Q1JZWL9TVOufnbobZI2zhTGlZRi8pEU6tN/fEoMg+p2mxqhVZM
TA9lOQz1EHOMNdinbzJsOocx54TjodC5MLR67XKEM9GxCFf1GKPTa1fneyAX
wlygl24ti5MLqRdmfHOLH9+6DA3HA2eQf+3P/gI/59YOl4N7Apw+/MB6xPhj
81nbfPTD/LG8kVWqaMz+/X1FdinTe0SO09l6arebuOLXuEW+EiKeWHkK9Sdt
IPQ1guhZwK7hCo6cl42II4gnXK6e10t6T+87E+CJmuO1iQffd8a6FQnf5z+H
X5eVjTcEf7uUjrr8xDSyPmBvZFeMDX1G3NvEfYmdKWWnETNa2/FY455tbth+
G1GtcjFulkse2wzIqbHfNqdbtt+EjAq18bkNRj2o9FALORm1Vm3M1Mqa+nKR
1X012rvQi9uHclZxT9G0mhJ553iPs0rVQ3cvQmO/Ce3IvlQ1JgKW6+pHnXXr
T2GRPavVjV1LE8K7zHnDznAcmYdR0bH6EN13XpKh454BOS5uLPgOoV9rY9v7
kb4O9NVwEs1LXD1w91EOjSsUH88QXE2E4lMrYJ/xYF0gy8S2V4/PVI7Bv2Af
ev+LnFK7v1b6ues6njiIhIsMgbjU2wUJbgE4Wz35j6PRl52x7UdWU6Pmqn10
fik782+F/T5Cvx1PP2TgN0J8nDNSPVxJTXZTl9XlW90Gs34lW+dk63eydUG2
vquurmX5nwZq8Aent63L\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{523, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->341523220]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"LerchPhi", "[", 
     RowBox[{"0", ",", "s", ",", "2"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"s", ",", "1", ",", "3"}], "}"}]}], "]"}], " "}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27496],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", "2"], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Log", "[", "2", "]"}], " ", 
    RowBox[{"(", 
     RowBox[{"s", "-", "1"}], ")"}]}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", "2", "]"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"s", "-", "1"}], ")"}], "2"]}], "-", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", "2", "]"}], "3"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"s", "-", "1"}], ")"}], "3"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"s", "-", "1"}], "]"}], "4"],
    SeriesData[$CellContext`s, 1, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`s, 1, {
    Rational[1, 2], Rational[-1, 2] Log[2], Rational[1, 4] Log[2]^2, 
    Rational[-1, 12] Log[2]^3}, 0, 4, 1],
  Editable->False]], "Output",
 ImageSize->{447, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->201324391]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14678],

Cell["Infinite arguments give symbolic results:", "ExampleText",
 CellID->4455],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LerchPhi", "[", 
  RowBox[{"Infinity", ",", "2", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3700],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Infinity]", "::", "\<\"indet\"\>"}], ":", 
  " ", "\<\"Indeterminate expression \\!\\(0\\\\ \
\\(\\((\\(-\[Infinity]\\))\\)\\)\\) encountered. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/indet\\\", ButtonNote -> \
\\\"Infinity::indet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->600000836],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22023108]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LerchPhi", "[", 
  RowBox[{"1", ",", "0", ",", "Infinity"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15812],

Cell[BoxData[
 RowBox[{
  RowBox[{"Divide", "::", "\<\"infy\"\>"}], ":", 
  " ", "\<\"Infinite expression \\!\\(1\\/0\\) encountered. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/infy\\\", \
ButtonNote -> \\\"Divide::infy\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->217785401],

Cell[BoxData["ComplexInfinity"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->540011135]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7852],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LerchPhi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LerchPhi"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->912],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LerchPhi", "[", 
  RowBox[{
   RowBox[{"x", "-", 
    FractionBox[
     SuperscriptBox["x", "2"], "2"], "+", 
    FractionBox[
     SuperscriptBox["x", "3"], "9"], "+", 
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"]}], ",", "2", ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23042],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", "4"], "+", 
   FractionBox["x", "9"], "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "144"], "-", 
   FractionBox[
    RowBox[{"329", " ", 
     SuperscriptBox["x", "3"]}], "32400"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
    Rational[1, 4], 
    Rational[1, 9], 
    Rational[1, 144], 
    Rational[-329, 32400]}, 0, 4, 1],
  Editable->False]], "Output",
 ImageSize->{177, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->519709073]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10233],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "DoublyInfinite",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->8294],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["LerchPhi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LerchPhi"]], "InlineFormula"],
 " includes only terms with positive ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->27519],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"LerchPhi", "[", 
    RowBox[{"z", ",", "s", ",", "a"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31942],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdmN9vEkEQx5fjQJBKW1MUaU14MaahqVoe64O+aGLSxxpfCTGBB2OD/P94
e+xZ+tlZZu+KjZGEH9+9me/MzXdnd4+ryXL2/cdkOZ9Ohp8Xk5vZfPpr+Onn
Ihuq14ypXRhjjvom+73KfuVv+xpnb2Ma9rNejK3MHvAp8DnwGPgN8Nc8SorR
LvBr4LfA7xR8/Q9HYYWPgR8rUTX/DvD77CPJYMd95/ymDqsD4FdK1JdK1tRd
82fWl8r1lngXFjcy2FJq9AiYGiaOh3ZNN864beDBFv9dxmXVXzg7dq31t5Aq
FPGYh1zdJBfyD85tjHfvZWtNTPuGGJVekgK+VxU9dJa4DCWtfC8qF8ct57lL
VYuZVVbNhvOrpiLnUtEHmm68x8KvmlID4E4pNubCHgyvZOkDdFfTxdGUOIng
+Rt5UAvef7V+0fB/sv6lt9jfEzXFOE9pf49V705eTyrxJh5PfF9ZyLx43tFU
OljJO2roJMDzFflY3W6AP7TjH0VXLX6/b7scaM2eewbMnMn7PKCJFmcoxfHu
mdF6gWjak86hs9uPqizPp7bSSWEn13tLhVrOW1qBLHwqVSLdzNF692Gl7Uxa
VO4BflR7kerGrLXbolKXzc7bfK5hB9XEyrM/E6EmaZGNOreow2in7Kw32UNn
hjh2rrti7qXrp10nPixZwbL83I21Gpbl5+w8A17PQq41m3u81YasdpUP9cS2
+Xe6I17OPPJKz6ExvB3wjCReb6/M97bmLS7MP0TafYFdL2AX1xH5/zled30T
R6fi6Mf826L1f26m9htWwqeQ\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{306, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->588462641]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21339],

Cell[TextData[{
 "In a symmetric case, setting ",
 Cell[BoxData[
  RowBox[{"DoublyInfinite", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " just doubles the result:"
}], "ExampleText",
 CellID->21516],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LerchPhi", "[", 
  RowBox[{"1", ",", "2", ",", "0.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27678],

Cell[BoxData["4.934802200544679`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37021024]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LerchPhi", "[", 
  RowBox[{"1", ",", "2", ",", "0.5", ",", 
   RowBox[{"DoublyInfinite", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25926],

Cell[BoxData[
 RowBox[{"9.869604401089358`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27279806]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14545],

Cell[TextData[{
 "In a more general case, negative ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " terms have a more complicated effect:"
}], "ExampleText",
 CellID->7306],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LerchPhi", "[", 
  RowBox[{"2", ",", "3", ",", "0.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2911],

Cell[BoxData[
 RowBox[{"8.921391406560602`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.5336491245309865`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->173192293]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LerchPhi", "[", 
  RowBox[{"2", ",", "3", ",", "0.5", ",", 
   RowBox[{"DoublyInfinite", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30439],

Cell[BoxData[
 RowBox[{"13.00540276963078`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.5336491245309853`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26131013]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "IncludeSingularTerm",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->22540],

Cell[TextData[{
 "For negative integer ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"IncludeSingularTerm", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " gives an infinite result:"
}], "ExampleText",
 CellID->32718],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LerchPhi", "[", 
  RowBox[{"2", ",", "3", ",", 
   RowBox[{"-", "4"}], ",", 
   RowBox[{"IncludeSingularTerm", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6938],

Cell[BoxData["ComplexInfinity"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->730546855]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LerchPhi", "[", 
  RowBox[{"2", ",", "3", ",", 
   RowBox[{"-", "4"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11767],

Cell[BoxData[
 RowBox[{
  FractionBox["14843", "1728"], "+", 
  RowBox[{"16", " ", 
   RowBox[{"PolyLog", "[", 
    RowBox[{"3", ",", "2"}], "]"}]}]}]], "Output",
 ImageSize->{164, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->116516965]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9866],

Cell[TextData[{
 "Find a zero of ",
 Cell[BoxData[
  ButtonBox["LerchPhi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LerchPhi"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->12095],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"LerchPhi", "[", 
     RowBox[{
      RowBox[{"-", "1"}], ",", " ", "s", ",", "2"}], "]"}], "==", "0"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"20", "I"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26980],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"s", "\[Rule]", 
   RowBox[{"0.9489622143456246`", "\[InvisibleSpace]", "+", 
    RowBox[{"20.37781243683129`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",\

 ImageSize->{170, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->372020337]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15026],

Cell["Central moments of a geometric probability distribution:", "ExampleText",
 CellID->16680],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"n", "-", 
        FractionBox[
         RowBox[{"1", "-", "p"}], "p"]}], ")"}], "k"], " ", "p", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", "p"}], ")"}], "n"]}], ")"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13250],

Cell[BoxData[
 RowBox[{"p", " ", 
  RowBox[{"LerchPhi", "[", 
   RowBox[{
    RowBox[{"1", "-", "p"}], ",", 
    RowBox[{"-", "k"}], ",", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"1", "-", "p"}], "p"]}]}], "]"}]}]], "Output",
 ImageSize->{187, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->303263782]
}, Open  ]],

Cell[TextData[{
 "Explicit forms for small ",
 Cell[BoxData["k"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->10651],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{"%", ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "4"}], "}"}]}], "]"}], "//", "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->609],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   FractionBox[
    RowBox[{"1", "-", "p"}], 
    SuperscriptBox["p", "2"]], ",", 
   FractionBox[
    RowBox[{"2", "-", 
     RowBox[{"3", " ", "p"}], "+", 
     SuperscriptBox["p", "2"]}], 
    SuperscriptBox["p", "3"]], ",", 
   FractionBox[
    RowBox[{"9", "-", 
     RowBox[{"18", " ", "p"}], "+", 
     RowBox[{"10", " ", 
      SuperscriptBox["p", "2"]}], "-", 
     SuperscriptBox["p", "3"]}], 
    SuperscriptBox["p", "4"]]}], "}"}]], "Output",
 ImageSize->{271, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->654426847]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8514],

Cell[TextData[{
 "Obtain ",
 Cell[BoxData[
  ButtonBox["LerchPhi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LerchPhi"]], "InlineFormula"],
 " ",
 "from sums:"
}], "ExampleText",
 CellID->22095],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"z", "^", "k"}], "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "k"}], "+", "\[Alpha]"}], ")"}], "^", "s"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30487],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["2", 
   RowBox[{"-", "s"}]], " ", "z", " ", 
  RowBox[{"LerchPhi", "[", 
   RowBox[{"z", ",", "s", ",", 
    FractionBox[
     RowBox[{"2", "+", "\[Alpha]"}], "2"]}], "]"}]}]], "Output",
 ImageSize->{172, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->357535755]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4431],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LerchPhi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LerchPhi"]], "InlineFormula"],
 " is a numeric function:"
}], "ExampleText",
 CellID->31121],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "LerchPhi", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19287],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Listable", ",", "NumericFunction", ",", "Protected", ",", 
   "ReadProtected"}], "}"}]], "Output",
 ImageSize->{367, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->152347940]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericQ", "[", 
  RowBox[{"LerchPhi", "[", 
   RowBox[{
    RowBox[{"2", "+", "E"}], ",", "Pi", ",", " ", "E"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29350],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->177215815]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11310],

Cell[TextData[{
 "A larger setting for ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " can be needed:"
}], "ExampleText",
 CellID->444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"LerchPhi", "[", 
     RowBox[{"2", ",", 
      RowBox[{"50", "+", 
       RowBox[{"10", " ", "I"}]}], ",", "Pi"}], "]"}], "]"}], ",", "20"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11869],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(LerchPhi[\\(\\(2, \\(\\(50 + \\(\\(10\\\\ \
\[ImaginaryI]\\)\\)\\)\\), \[Pi]\\)\\)]\\). \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/meprec\\\", ButtonNote -> \
\\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->196154895],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(Im[\\(\\(LerchPhi[\\(\\(2, \\(\\(50 + \\(\\(10\
\\\\ \[ImaginaryI]\\)\\)\\)\\), \[Pi]\\)\\)]\\)\\)]\\). \\!\\(\\*ButtonBox[\\\
\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/meprec\\\", ButtonNote -> \
\\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->97084309],

Cell[BoxData["0``24.528466917055464"], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->590560943]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "200"}], "}"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"Im", "[", 
      RowBox[{"LerchPhi", "[", 
       RowBox[{"2", ",", 
        RowBox[{"50", "+", 
         RowBox[{"10", " ", "I"}]}], ",", "Pi"}], "]"}], "]"}], ",", "20"}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28700],

Cell[BoxData["1.249110956560294031903290642964808`20.*^-25"], "Output",
 ImageSize->{192, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29538389]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9844],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LerchPhi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LerchPhi"]], "InlineFormula"],
 " ",
 "uses numerical comparisons when singular terms are included:"
}], "ExampleText",
 CellID->23806],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LerchPhi", "[", 
  RowBox[{"3", ",", "2", ",", 
   RowBox[{"-", "2.99999999999999"}], ",", 
   RowBox[{"IncludeSingularTerm", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30429],

Cell[BoxData[
 RowBox[{"2.588020129010374`*^29", "-", 
  RowBox[{"93.18759197102538`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{162, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->163226473]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LerchPhi", "[", 
  RowBox[{"3", ",", "2", ",", 
   RowBox[{"-", "2.999999999999999"}], ",", 
   RowBox[{"IncludeSingularTerm", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5832],

Cell[BoxData["ComplexInfinity"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->434922068]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25327],

Cell["\<\
Machine-number inputs can give high\[Hyphen]precision results:\
\>", "ExampleText",
 CellID->25465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LerchPhi", "[", 
  RowBox[{
   RowBox[{"11", "/", "10"}], ",", 
   RowBox[{
    RowBox[{"10.", "^", "4"}], "I"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5765],

Cell[BoxData[
 RowBox[{"2.1409616114085635072397429809360585`15.954589770191005*^3396", "+",
   
  RowBox[{
  "5.4278160803020081782751674244095043`15.954589770191005*^3396", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{358, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->151800262]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MachineNumberQ", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9537],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->459948786]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22514],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  RowBox[{
   StyleBox["z", "TI"], "=", 
   RowBox[{
    StyleBox["a", "TI"], "=", "1"}]}]], "InlineFormula"],
 ",  ",
 Cell[BoxData[
  ButtonBox["LerchPhi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LerchPhi"]], "InlineFormula"],
 " cannot always be evaluated in terms of ",
 Cell[BoxData[
  ButtonBox["Zeta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Zeta"]], "InlineFormula"],
 " for symbolic ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->26547],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LerchPhi", "[", 
  RowBox[{"1", ",", "s", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16611],

Cell[BoxData[
 RowBox[{"PolyLog", "[", 
  RowBox[{"s", ",", "1"}], "]"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->688485875]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"s", "=", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"LerchPhi", "[", 
      RowBox[{"1", ",", "s", ",", "1"}], "]"}], ",", " ", 
     RowBox[{"Zeta", "[", "s", "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14135],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Zeta", "[", "3", "]"}], ",", 
   RowBox[{"Zeta", "[", "3", "]"}]}], "}"}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->334107747]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"s", "=", 
     RowBox[{"-", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"LerchPhi", "[", 
      RowBox[{"1", ",", "s", ",", "1"}], "]"}], ",", " ", 
     RowBox[{"Zeta", "[", "s", "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->31066],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"ComplexInfinity", ",", 
   FractionBox["1", "120"]}], "}"}]], "Output",
 ImageSize->{160, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->411843273]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{
   RowBox[{"LerchPhi", "[", 
    RowBox[{"1", ",", "s", ",", "1"}], "]"}], ",", 
   RowBox[{"s", ">", "1"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->30670],

Cell[BoxData[
 RowBox[{"Zeta", "[", "s", "]"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->388134366]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22781],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Zeta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Zeta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolyLog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolyLog"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13917]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27245],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->12828]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->32151],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/LerchTranscendent.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/ZetaFunctionsandPolylogarithms/LerchPhi/\
"], None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->469742484],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->465257605],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->231726016],

Cell[TextData[ButtonBox["Recurrence and Sum Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RecurrenceAndSumFunctions"]], "MoreAbout",
 CellID->83460179],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->60518131],

Cell[TextData[ButtonBox["Zeta Functions & Polylogarithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ZetaFunctionsAndPolylogarithms"]], "MoreAbout",
 CellID->348021605]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LerchPhi - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 52, 47.1865998}", "context" -> "System`", 
    "keywords" -> {
     "Catalan beta function", "Dirichlet L series", "Fermi-Dirac integrals", 
      "Lerch function Phi", "Lerch phi", "Lerch transcendent", 
      "L-series in number theory", "phi", "sums of reciprocal powers"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "LerchPhi[z, s, a] gives the Lerch transcendent \\[CapitalPhi] (z, s, a). \
", "synonyms" -> {"lerch phi"}, "title" -> "LerchPhi", "type" -> "Symbol", 
    "uri" -> "ref/LerchPhi"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7948, 281, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->130338685]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 52117, 1945}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2448, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3071, 84, 46, 1, 70, "ObjectName",
 CellID->16221],
Cell[3120, 87, 816, 27, 70, "Usage",
 CellID->12812]
}, Open  ]],
Cell[CellGroupData[{
Cell[3973, 119, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4451, 136, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4574, 142, 504, 19, 70, "Notes",
 CellID->23919],
Cell[5081, 163, 925, 35, 70, "Notes",
 CellID->23998],
Cell[6009, 200, 788, 29, 70, "Notes",
 CellID->1917],
Cell[6800, 231, 435, 17, 70, "Notes",
 CellID->9521],
Cell[7238, 250, 248, 8, 70, "Notes",
 CellID->451505744],
Cell[7489, 260, 218, 7, 70, "Notes",
 CellID->31226],
Cell[7710, 269, 201, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[7948, 281, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->130338685],
Cell[CellGroupData[{
Cell[8333, 295, 148, 5, 70, "ExampleSection",
 CellID->593185602],
Cell[CellGroupData[{
Cell[8506, 304, 157, 5, 28, "Input",
 CellID->31431],
Cell[8666, 311, 236, 8, 36, "Output",
 CellID->15725804]
}, Open  ]],
Cell[8917, 322, 121, 3, 70, "ExampleDelimiter",
 CellID->19020],
Cell[CellGroupData[{
Cell[9063, 329, 134, 4, 28, "Input",
 CellID->8724],
Cell[9200, 335, 274, 7, 36, "Output",
 CellID->215314296]
}, Open  ]],
Cell[9489, 345, 121, 3, 70, "ExampleDelimiter",
 CellID->18169],
Cell[CellGroupData[{
Cell[9635, 352, 270, 9, 28, "Input",
 CellID->31662],
Cell[9908, 363, 2714, 49, 159, "Output",
 Evaluatable->False,
 CellID->208297110]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12671, 418, 216, 7, 70, "ExampleSection",
 CellID->11280],
Cell[12890, 427, 87, 1, 70, "ExampleText",
 CellID->2842118],
Cell[CellGroupData[{
Cell[13002, 432, 212, 7, 70, "Input",
 CellID->65576865],
Cell[13217, 441, 273, 7, 36, "Output",
 CellID->12311118]
}, Open  ]],
Cell[13505, 451, 125, 3, 70, "ExampleDelimiter",
 CellID->179588467],
Cell[13633, 456, 66, 1, 70, "ExampleText",
 CellID->29287],
Cell[CellGroupData[{
Cell[13724, 461, 188, 6, 70, "Input",
 CellID->17979],
Cell[13915, 469, 234, 7, 36, "Output",
 CellID->87753113]
}, Open  ]],
Cell[14164, 479, 125, 3, 70, "ExampleDelimiter",
 CellID->172132232],
Cell[14292, 484, 109, 3, 70, "ExampleText",
 CellID->14449],
Cell[CellGroupData[{
Cell[14426, 491, 152, 4, 70, "Input",
 CellID->9188],
Cell[14581, 497, 202, 5, 36, "Output",
 CellID->135829124]
}, Open  ]],
Cell[14798, 505, 121, 3, 70, "ExampleDelimiter",
 CellID->20227],
Cell[14922, 510, 218, 7, 70, "ExampleText",
 CellID->1848],
Cell[CellGroupData[{
Cell[15165, 521, 206, 7, 70, "Input",
 CellID->16672],
Cell[15374, 530, 566, 14, 36, "Output",
 CellID->782298698]
}, Open  ]],
Cell[15955, 547, 120, 3, 70, "ExampleDelimiter",
 CellID->2918],
Cell[16078, 552, 87, 1, 70, "ExampleText",
 CellID->15747],
Cell[CellGroupData[{
Cell[16190, 557, 152, 5, 70, "Input",
 CellID->12579],
Cell[16345, 564, 761, 27, 59, "Output",
 CellID->137228473]
}, Open  ]],
Cell[CellGroupData[{
Cell[17143, 596, 132, 4, 70, "Input",
 CellID->8923],
Cell[17278, 602, 236, 8, 51, "Output",
 CellID->351057640]
}, Open  ]],
Cell[CellGroupData[{
Cell[17551, 615, 186, 6, 70, "Input",
 CellID->19341],
Cell[17740, 623, 479, 18, 51, "Output",
 CellID->156256498]
}, Open  ]],
Cell[CellGroupData[{
Cell[18256, 646, 299, 10, 70, "Input",
 CellID->6995],
Cell[18558, 658, 286, 10, 54, "Output",
 CellID->186559013]
}, Open  ]],
Cell[18859, 671, 121, 3, 70, "ExampleDelimiter",
 CellID->30874],
Cell[18983, 676, 72, 1, 70, "ExampleText",
 CellID->20851],
Cell[CellGroupData[{
Cell[19080, 681, 250, 8, 70, "Input",
 CellID->3466],
Cell[19333, 691, 275, 7, 36, "Output",
 CellID->936445858]
}, Open  ]],
Cell[CellGroupData[{
Cell[19645, 703, 314, 11, 70, "Input",
 CellID->7189],
Cell[19962, 716, 397, 11, 54, "Output",
 CellID->640994545]
}, Open  ]],
Cell[20374, 730, 125, 3, 70, "ExampleDelimiter",
 CellID->790540937],
Cell[20502, 735, 202, 7, 70, "ExampleText",
 CellID->49105624],
Cell[CellGroupData[{
Cell[20729, 746, 179, 6, 70, "Input",
 CellID->415201804],
Cell[20911, 754, 520, 12, 70, "Output",
 Evaluatable->False,
 CellID->177723168]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21480, 772, 239, 7, 70, "ExampleSection",
 CellID->22625],
Cell[21722, 781, 74, 1, 70, "ExampleText",
 CellID->12956],
Cell[CellGroupData[{
Cell[21821, 786, 274, 9, 70, "Input",
 CellID->14023],
Cell[22098, 797, 1330, 26, 70, "Output",
 Evaluatable->False,
 CellID->341523220]
}, Open  ]],
Cell[CellGroupData[{
Cell[23465, 828, 274, 9, 70, "Input",
 CellID->27496],
Cell[23742, 839, 1127, 37, 51, "Output",
 CellID->201324391]
}, Open  ]],
Cell[24884, 879, 121, 3, 70, "ExampleDelimiter",
 CellID->14678],
Cell[25008, 884, 79, 1, 70, "ExampleText",
 CellID->4455],
Cell[CellGroupData[{
Cell[25112, 889, 139, 4, 70, "Input",
 CellID->3700],
Cell[25254, 895, 419, 8, 70, "Message",
 CellID->600000836],
Cell[25676, 905, 169, 5, 36, "Output",
 CellID->22023108]
}, Open  ]],
Cell[CellGroupData[{
Cell[25882, 915, 140, 4, 70, "Input",
 CellID->15812],
Cell[26025, 921, 369, 7, 70, "Message",
 CellID->217785401],
Cell[26397, 930, 173, 5, 36, "Output",
 CellID->540011135]
}, Open  ]],
Cell[26585, 938, 120, 3, 70, "ExampleDelimiter",
 CellID->7852],
Cell[26708, 943, 203, 7, 70, "ExampleText",
 CellID->912],
Cell[CellGroupData[{
Cell[26936, 954, 337, 12, 70, "Input",
 CellID->23042],
Cell[27276, 968, 712, 25, 54, "Output",
 CellID->519709073]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28037, 999, 218, 7, 70, "ExampleSection",
 CellID->10233],
Cell[CellGroupData[{
Cell[28280, 1010, 230, 7, 70, "ExampleSubsection",
 CellID->8294],
Cell[28513, 1019, 288, 11, 70, "ExampleText",
 CellID->27519],
Cell[CellGroupData[{
Cell[28826, 1034, 251, 8, 70, "Input",
 CellID->31942],
Cell[29080, 1044, 1029, 21, 70, "Output",
 Evaluatable->False,
 CellID->588462641]
}, Open  ]],
Cell[30124, 1068, 121, 3, 70, "ExampleDelimiter",
 CellID->21339],
Cell[30248, 1073, 264, 9, 70, "ExampleText",
 CellID->21516],
Cell[CellGroupData[{
Cell[30537, 1086, 135, 4, 70, "Input",
 CellID->27678],
Cell[30675, 1092, 174, 5, 36, "Output",
 CellID->37021024]
}, Open  ]],
Cell[CellGroupData[{
Cell[30886, 1102, 186, 5, 70, "Input",
 CellID->25926],
Cell[31075, 1109, 254, 7, 36, "Output",
 CellID->27279806]
}, Open  ]],
Cell[31344, 1119, 121, 3, 70, "ExampleDelimiter",
 CellID->14545],
Cell[31468, 1124, 193, 6, 70, "ExampleText",
 CellID->7306],
Cell[CellGroupData[{
Cell[31686, 1134, 134, 4, 70, "Input",
 CellID->2911],
Cell[31823, 1140, 272, 7, 36, "Output",
 CellID->173192293]
}, Open  ]],
Cell[CellGroupData[{
Cell[32132, 1152, 186, 5, 70, "Input",
 CellID->30439],
Cell[32321, 1159, 271, 7, 36, "Output",
 CellID->26131013]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[32641, 1172, 236, 7, 70, "ExampleSubsection",
 CellID->22540],
Cell[32880, 1181, 326, 12, 70, "ExampleText",
 CellID->32718],
Cell[CellGroupData[{
Cell[33231, 1197, 207, 6, 70, "Input",
 CellID->6938],
Cell[33441, 1205, 173, 5, 36, "Output",
 CellID->730546855]
}, Open  ]],
Cell[CellGroupData[{
Cell[33651, 1215, 152, 5, 70, "Input",
 CellID->11767],
Cell[33806, 1222, 293, 10, 51, "Output",
 CellID->116516965]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[34160, 1239, 222, 7, 70, "ExampleSection",
 CellID->9866],
Cell[34385, 1248, 194, 8, 70, "ExampleText",
 CellID->12095],
Cell[CellGroupData[{
Cell[34604, 1260, 323, 12, 70, "Input",
 CellID->26980],
Cell[34930, 1274, 329, 10, 36, "Output",
 CellID->372020337]
}, Open  ]],
Cell[35274, 1287, 121, 3, 70, "ExampleDelimiter",
 CellID->15026],
Cell[35398, 1292, 95, 1, 70, "ExampleText",
 CellID->16680],
Cell[CellGroupData[{
Cell[35518, 1297, 464, 16, 70, "Input",
 CellID->13250],
Cell[35985, 1315, 366, 13, 53, "Output",
 CellID->303263782]
}, Open  ]],
Cell[36366, 1331, 123, 5, 70, "ExampleText",
 CellID->10651],
Cell[CellGroupData[{
Cell[36514, 1340, 201, 7, 70, "Input",
 CellID->609],
Cell[36718, 1349, 635, 22, 57, "Output",
 CellID->654426847]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[37402, 1377, 232, 7, 70, "ExampleSection",
 CellID->8514],
Cell[37637, 1386, 201, 9, 70, "ExampleText",
 CellID->22095],
Cell[CellGroupData[{
Cell[37863, 1399, 331, 12, 70, "Input",
 CellID->30487],
Cell[38197, 1413, 359, 12, 51, "Output",
 CellID->357535755]
}, Open  ]],
Cell[38571, 1428, 120, 3, 70, "ExampleDelimiter",
 CellID->4431],
Cell[38694, 1433, 196, 7, 70, "ExampleText",
 CellID->31121],
Cell[CellGroupData[{
Cell[38915, 1444, 109, 3, 70, "Input",
 CellID->19287],
Cell[39027, 1449, 272, 9, 36, "Output",
 CellID->152347940]
}, Open  ]],
Cell[CellGroupData[{
Cell[39336, 1463, 203, 7, 70, "Input",
 CellID->29350],
Cell[39542, 1472, 161, 5, 36, "Output",
 CellID->177215815]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39752, 1483, 226, 7, 70, "ExampleSection",
 CellID->11310],
Cell[39981, 1492, 232, 8, 70, "ExampleText",
 CellID->444],
Cell[CellGroupData[{
Cell[40238, 1504, 281, 10, 70, "Input",
 CellID->11869],
Cell[40522, 1516, 498, 9, 70, "Message",
 CellID->196154895],
Cell[41023, 1527, 513, 9, 70, "Message",
 CellID->97084309],
Cell[41539, 1538, 178, 5, 36, "Output",
 CellID->590560943]
}, Open  ]],
Cell[CellGroupData[{
Cell[41754, 1548, 419, 14, 70, "Input",
 CellID->28700],
Cell[42176, 1564, 201, 5, 36, "Output",
 CellID->29538389]
}, Open  ]],
Cell[42392, 1572, 120, 3, 70, "ExampleDelimiter",
 CellID->9844],
Cell[42515, 1577, 239, 8, 70, "ExampleText",
 CellID->23806],
Cell[CellGroupData[{
Cell[42779, 1589, 228, 6, 70, "Input",
 CellID->30429],
Cell[43010, 1597, 254, 7, 36, "Output",
 CellID->163226473]
}, Open  ]],
Cell[CellGroupData[{
Cell[43301, 1609, 228, 6, 70, "Input",
 CellID->5832],
Cell[43532, 1617, 173, 5, 36, "Output",
 CellID->434922068]
}, Open  ]],
Cell[43720, 1625, 121, 3, 70, "ExampleDelimiter",
 CellID->25327],
Cell[43844, 1630, 109, 3, 70, "ExampleText",
 CellID->25465],
Cell[CellGroupData[{
Cell[43978, 1637, 204, 7, 70, "Input",
 CellID->5765],
Cell[44185, 1646, 346, 10, 36, "Output",
 CellID->151800262]
}, Open  ]],
Cell[CellGroupData[{
Cell[44568, 1661, 105, 3, 70, "Input",
 CellID->9537],
Cell[44676, 1666, 162, 5, 36, "Output",
 CellID->459948786]
}, Open  ]],
Cell[44853, 1674, 121, 3, 70, "ExampleDelimiter",
 CellID->22514],
Cell[44977, 1679, 549, 22, 70, "ExampleText",
 CellID->26547],
Cell[CellGroupData[{
Cell[45551, 1705, 133, 4, 70, "Input",
 CellID->16611],
Cell[45687, 1711, 214, 7, 36, "Output",
 CellID->688485875]
}, Open  ]],
Cell[CellGroupData[{
Cell[45938, 1723, 331, 11, 70, "Input",
 CellID->14135],
Cell[46272, 1736, 268, 9, 36, "Output",
 CellID->334107747]
}, Open  ]],
Cell[CellGroupData[{
Cell[46577, 1750, 352, 12, 70, "Input",
 CellID->31066],
Cell[46932, 1764, 242, 8, 51, "Output",
 CellID->411843273]
}, Open  ]],
Cell[CellGroupData[{
Cell[47211, 1777, 224, 7, 70, "Input",
 CellID->30670],
Cell[47438, 1786, 188, 6, 36, "Output",
 CellID->388134366]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[47687, 1799, 311, 9, 70, "SeeAlsoSection",
 CellID->22781],
Cell[48001, 1810, 441, 17, 70, "SeeAlso",
 CellID->13917]
}, Open  ]],
Cell[CellGroupData[{
Cell[48479, 1832, 314, 9, 70, "TutorialsSection",
 CellID->27245],
Cell[48796, 1843, 144, 3, 70, "Tutorials",
 CellID->12828]
}, Open  ]],
Cell[CellGroupData[{
Cell[48977, 1851, 321, 9, 70, "RelatedLinksSection",
 CellID->32151],
Cell[49301, 1862, 188, 4, 70, "RelatedLinks"],
Cell[49492, 1868, 209, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49738, 1877, 319, 9, 70, "MoreAboutSection",
 CellID->469742484],
Cell[50060, 1888, 162, 3, 70, "MoreAbout",
 CellID->465257605],
Cell[50225, 1893, 137, 3, 70, "MoreAbout",
 CellID->231726016],
Cell[50365, 1898, 164, 3, 70, "MoreAbout",
 CellID->83460179],
Cell[50532, 1903, 144, 3, 70, "MoreAbout",
 CellID->60518131],
Cell[50679, 1908, 173, 3, 70, "MoreAbout",
 CellID->348021605]
}, Open  ]],
Cell[50867, 1914, 27, 0, 70, "History"],
Cell[50897, 1916, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

