(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15809,        578]
NotebookOptionsPosition[     12081,        451]
NotebookOutlinePosition[     13409,        489]
CellTagsIndexPosition[     13324,        484]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/StringPatterns"], 
          "Working with String Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/WorkingWithStringPatternsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"String Patterns\"\>", 
       2->"\<\"Working with String Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"WordCharacter" :> 
          Documentation`HelpLookup["paclet:ref/WordCharacter"], "LetterQ" :> 
          Documentation`HelpLookup["paclet:ref/LetterQ"], "CharacterRange" :> 
          Documentation`HelpLookup["paclet:ref/CharacterRange"], 
          "StringExpression" :> 
          Documentation`HelpLookup["paclet:ref/StringExpression"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"WordCharacter\"\>", 
       2->"\<\"LetterQ\"\>", 3->"\<\"CharacterRange\"\>", 
       4->"\<\"StringExpression\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String Patterns" :> 
          Documentation`HelpLookup["paclet:guide/StringPatterns"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"String Patterns\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LetterCharacter", "ObjectName",
 CellID->28726],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["LetterCharacter",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LetterCharacter"]], "InlineFormula"],
     " \[LineSeparator]represents a letter character in ",
     Cell[BoxData[
      ButtonBox["StringExpression",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14821]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LetterCharacter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LetterCharacter"]], "InlineFormula"],
 " can correspond to any upper- or lower-case letter."
}], "Notes",
 CellID->16979],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LetterCharacter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LetterCharacter"]], "InlineFormula"],
 " matches any character for which ",
 Cell[BoxData[
  ButtonBox["LetterQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LetterQ"]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->448938980]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->29023222],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->335225530],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"StringMatchQ", "[", 
    RowBox[{"#", ",", "LetterCharacter"}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{
   "\"\<a\>\"", ",", "\"\<1\>\"", ",", "\"\<B\>\"", ",", "\"\<.\>\"", ",", 
    "\"\< \>\""}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->91217813],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "False", ",", "True", ",", "False", ",", "False"}], 
  "}"}]], "Output",
 ImageSize->{224, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->342863679]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->227872515],

Cell["Test whether a string contains only letters:", "ExampleText",
 CellID->241028784],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<abcdefg\>\"", ",", " ", 
   RowBox[{"LetterCharacter", " ", ".."}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2131585975],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23363484]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<abdc12\>\"", ",", " ", 
   RowBox[{"LetterCharacter", " ", ".."}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1448196690],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->792750559]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->174917470],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LetterCharacter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LetterCharacter"]], "InlineFormula"],
 " matches any character for which ",
 Cell[BoxData[
  ButtonBox["LetterQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LetterQ"]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->253618358],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"StringMatchQ", "[", 
    RowBox[{"#", ",", "LetterCharacter"}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{
   "\"\<a\>\"", ",", "\"\<1\>\"", ",", "\"\<B\>\"", ",", "\"\< \>\""}], 
   "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->210338754],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "False", ",", "True", ",", "False"}], "}"}]], "Output",\

 ImageSize->{178, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->277374396]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LetterQ", "[", "#", "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{
   "\"\<a\>\"", ",", "\"\<1\>\"", ",", "\"\<B\>\"", ",", "\"\< \>\""}], 
   "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->333872666],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "False", ",", "True", ",", "False"}], "}"}]], "Output",\

 ImageSize->{178, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->326036700]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32540],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["WordCharacter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WordCharacter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LetterQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LetterQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CharacterRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CharacterRange"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringExpression"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11887]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24716],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "Tutorials",
 CellID->8153],

Cell[TextData[ButtonBox["Working with String Patterns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/WorkingWithStringPatternsOverview"]], "Tutorials",
 CellID->22514736]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with LetterCharacter",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=\
LetterCharacter"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->58400609],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringPatterns"]], "MoreAbout",
 CellID->74496662]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LetterCharacter - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 52, 54.4524108}", "context" -> "System`", 
    "keywords" -> {
     "character class", "Perl \\w", "POSIX [[:alpha:]]", 
      "test for alphabetic character"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LetterCharacter represents a letter character in StringExpression.", 
    "synonyms" -> {"letter character"}, "title" -> "LetterCharacter", "type" -> 
    "Symbol", "uri" -> "ref/LetterCharacter"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4780, 155, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->29023222]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13182, 477}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2258, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2881, 81, 53, 1, 70, "ObjectName",
 CellID->28726],
Cell[2937, 84, 592, 18, 70, "Usage",
 CellID->14821]
}, Open  ]],
Cell[CellGroupData[{
Cell[3566, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4044, 124, 232, 7, 70, "Notes",
 CellID->16979],
Cell[4279, 133, 464, 17, 70, "Notes",
 CellID->448938980]
}, Closed]],
Cell[CellGroupData[{
Cell[4780, 155, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->29023222],
Cell[CellGroupData[{
Cell[5164, 169, 148, 5, 70, "ExampleSection",
 CellID->335225530],
Cell[CellGroupData[{
Cell[5337, 178, 315, 10, 28, "Input",
 CellID->91217813],
Cell[5655, 190, 255, 8, 36, "Output",
 CellID->342863679]
}, Open  ]],
Cell[5925, 201, 125, 3, 70, "ExampleDelimiter",
 CellID->227872515],
Cell[6053, 206, 87, 1, 70, "ExampleText",
 CellID->241028784],
Cell[CellGroupData[{
Cell[6165, 211, 190, 5, 28, "Input",
 CellID->2131585975],
Cell[6358, 218, 160, 5, 36, "Output",
 CellID->23363484]
}, Open  ]],
Cell[CellGroupData[{
Cell[6555, 228, 189, 5, 70, "Input",
 CellID->1448196690],
Cell[6747, 235, 162, 5, 36, "Output",
 CellID->792750559]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6958, 246, 237, 7, 70, "ExampleSection",
 CellID->174917470],
Cell[7198, 255, 470, 17, 70, "ExampleText",
 CellID->253618358],
Cell[CellGroupData[{
Cell[7693, 276, 297, 10, 70, "Input",
 CellID->210338754],
Cell[7993, 288, 240, 8, 36, "Output",
 CellID->277374396]
}, Open  ]],
Cell[CellGroupData[{
Cell[8270, 301, 253, 9, 70, "Input",
 CellID->333872666],
Cell[8526, 312, 240, 8, 36, "Output",
 CellID->326036700]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8827, 327, 311, 9, 70, "SeeAlsoSection",
 CellID->32540],
Cell[9141, 338, 977, 35, 70, "SeeAlso",
 CellID->11887]
}, Open  ]],
Cell[CellGroupData[{
Cell[10155, 378, 314, 9, 70, "TutorialsSection",
 CellID->24716],
Cell[10472, 389, 139, 3, 70, "Tutorials",
 CellID->8153],
Cell[10614, 394, 178, 4, 70, "Tutorials",
 CellID->22514736]
}, Open  ]],
Cell[CellGroupData[{
Cell[10829, 403, 305, 8, 70, "RelatedLinksSection"],
Cell[11137, 413, 372, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11546, 430, 318, 9, 70, "MoreAboutSection",
 CellID->58400609],
Cell[11867, 441, 140, 3, 70, "MoreAbout",
 CellID->74496662]
}, Open  ]],
Cell[12022, 447, 29, 0, 70, "History"],
Cell[12054, 449, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

