(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     36578,       1201]
NotebookOptionsPosition[     30016,        964]
NotebookOutlinePosition[     31380,       1002]
CellTagsIndexPosition[     31295,        997]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Characters in Strings" :> 
          Documentation`HelpLookup["paclet:tutorial/CharactersInStrings"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Characters in Strings\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DigitQ" :> Documentation`HelpLookup["paclet:ref/DigitQ"], 
          "UpperCaseQ" :> Documentation`HelpLookup["paclet:ref/UpperCaseQ"], 
          "LowerCaseQ" :> Documentation`HelpLookup["paclet:ref/LowerCaseQ"], 
          "CharacterRange" :> 
          Documentation`HelpLookup["paclet:ref/CharacterRange"], 
          "LetterCharacter" :> 
          Documentation`HelpLookup["paclet:ref/LetterCharacter"], 
          "StringExpression" :> 
          Documentation`HelpLookup["paclet:ref/StringExpression"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DigitQ\"\>", 
       2->"\<\"UpperCaseQ\"\>", 3->"\<\"LowerCaseQ\"\>", 
       4->"\<\"CharacterRange\"\>", 5->"\<\"LetterCharacter\"\>", 
       6->"\<\"StringExpression\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Character Operations" :> 
          Documentation`HelpLookup["paclet:guide/CharacterOperations"], 
          "String Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/StringManipulation"], 
          "Testing Expressions" :> 
          Documentation`HelpLookup["paclet:guide/TestingExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Character Operations\"\>", 
       2->"\<\"String Manipulation\"\>", 
       3->"\<\"Testing Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LetterQ", "ObjectName",
 CellID->20350],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LetterQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LetterQ"], "[", 
       StyleBox["string", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if all the characters in the string are letters, and yields ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16043]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["LetterQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LetterQ"], "[", 
   StyleBox["string", "TI"], "]"}]], "InlineFormula"],
 " by default gives ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " if ",
 Cell[BoxData[
  StyleBox["string", "TI"]], "InlineFormula"],
 " contains any space or punctuation characters. "
}], "Notes",
 CellID->13415],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LetterQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LetterQ"]], "InlineFormula"],
 " handles both ordinary and special characters. "
}], "Notes",
 CellID->20565],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LetterQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LetterQ"]], "InlineFormula"],
 " treats as letters all special characters explicitly listed as letters in \
the table in \"",
 ButtonBox["Named Characters\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/Introduction-ListingOfNamedCharacters"],
 ". "
}], "Notes",
 CellID->28761],

Cell[TextData[{
 "In general, ",
 Cell[BoxData[
  ButtonBox["LetterQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LetterQ"]], "InlineFormula"],
 " treats as letters all characters that appear as ordinary text in any \
language. "
}], "Notes",
 CellID->13141],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LetterQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LetterQ"]], "InlineFormula"],
 " treats as letters such special characters as ",
 Cell[BoxData["\[Alpha]"], "InlineFormula"],
 ", ",
 Cell[BoxData["\[DoubleStruckCapitalZ]"], "InlineFormula"],
 ", ",
 Cell[BoxData["\[ScriptCapitalL]"], "InlineFormula"],
 " and ",
 Cell[BoxData["\[AE]"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17909],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LetterQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LetterQ"]], "InlineFormula"],
 " does not treat as letters ",
 Cell[BoxData["\[EmptySet]"], "InlineFormula"],
 " (",
 Cell[TextData[ButtonBox["\\[EmptySet]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/EmptySet"]], "InlineCharacterName"],
 "), ",
 Cell[BoxData["\[HBar]"], "InlineFormula"],
 " (",
 Cell[TextData[ButtonBox["\\[HBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/HBar"]], "InlineCharacterName"],
 "), ",
 Cell[BoxData["\[Angstrom]"], "InlineFormula"],
 " (",
 Cell[TextData[ButtonBox["\\[Angstrom]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Angstrom"]], "InlineCharacterName"],
 ") or ",
 Cell[BoxData["\[Sum]"], "InlineFormula"],
 " (",
 Cell[TextData[ButtonBox["\\[Sum]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Sum"]], "InlineCharacterName"],
 "). "
}], "Notes",
 CellID->27978]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->589928709],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->463539160],

Cell["Test whether a character is a letter:", "ExampleText",
 CellID->24623],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LetterQ", "[", "\"\<a\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20487],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30199]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LetterQ", "[", "\"\<2\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10991],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->16927]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13105],

Cell["Test whether all characters in a string are letters:", "ExampleText",
 CellID->18552],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LetterQ", "[", "\"\<abcdABCD\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23583],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7787]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14513],

Cell["Punctuation is not a letter:", "ExampleText",
 CellID->31627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LetterQ", "[", "\"\<two words\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7781],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21072]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1304],

Cell["Accented letters are still treated as letters:", "ExampleText",
 CellID->21850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LetterQ", "[", "\"\<\[ADoubleDot]\[EAcute]\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28212],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31859]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9797],

Cell["Gothic letters are treated as letters:", "ExampleText",
 CellID->20049],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LetterQ", "[", 
  "\"\<\[GothicCapitalA]\[GothicCapitalB]\[GothicCapitalC]\[GothicCapitalD]\
\[GothicCapitalE]\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15381],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32193]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8640],

Cell["Greek letters are treated as letters:", "ExampleText",
 CellID->7403],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LetterQ", "[", 
  "\"\<\[Alpha]\[Beta]\[Gamma]\[Delta]\[Epsilon]\[Zeta]\[Eta]\[Theta]\>\"", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20325],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32700]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15449],

Cell["\<\
Characters that are not letters in ordinary natural language are not treated \
as letters:\
\>", "ExampleText",
 CellID->28361],

Cell[CellGroupData[{

Cell[BoxData["\"\<\[Sum]\>\""], "Input",
 CellLabel->"In[1]:=",
 CellID->27407],

Cell[BoxData["\<\"\[Sum]\"\>"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5672]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LetterQ", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25868],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->14341]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12187]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24168],

Cell["All characters treated as letters:", "ExampleText",
 CellID->15048],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{"Select", "[", 
     RowBox[{
      RowBox[{"Characters", "[", 
       RowBox[{"FromCharacterCode", "[", 
        RowBox[{"Range", "[", 
         RowBox[{"2", "^", "16"}], "]"}], "]"}], "]"}], ",", "LetterQ"}], 
     "]"}], "]"}], ",", "14"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18353],

Cell[BoxData[
 StyleBox[
  StyleBox[
   StyleBox[
    StyleBox[
     StyleBox[
      StyleBox[
       StyleBox[
        StyleBox[
         StyleBox[
          StyleBox[
           StyleBox[
            StyleBox[
             StyleBox[
              StyleBox[
               StyleBox[
                
                StyleBox["\<\"\
ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz\[CapitalAGrave]\
\[CapitalAAcute]\[CapitalAHat]\[CapitalATilde]\[CapitalADoubleDot]\
\[CapitalARing]\[CapitalAE]\[CapitalCCedilla]\[CapitalEGrave]\[CapitalEAcute]\
\[CapitalEHat]\[CapitalEDoubleDot]\[CapitalIGrave]\[CapitalIAcute]\
\[CapitalIHat]\[CapitalIDoubleDot]\[CapitalEth]\[CapitalNTilde]\
\[CapitalOGrave]\[CapitalOAcute]\[CapitalOHat]\[CapitalOTilde]\
\[CapitalODoubleDot]\[CapitalOSlash]\[CapitalUGrave]\[CapitalUAcute]\
\[CapitalUHat]\[CapitalUDoubleDot]\[CapitalYAcute]\[CapitalThorn]\[SZ]\
\[AGrave]\[AAcute]\[AHat]\[ATilde]\[ADoubleDot]\[ARing]\[AE]\[CCedilla]\
\[EGrave]\[EAcute]\[EHat]\[EDoubleDot]\[IGrave]\[IAcute]\[IHat]\[IDoubleDot]\
\[Eth]\[NTilde]\[OGrave]\[OAcute]\[OHat]\[OTilde]\[ODoubleDot]\[OSlash]\
\[UGrave]\[UAcute]\[UHat]\[UDoubleDot]\[YAcute]\[Thorn]\[YDoubleDot]\
\[CapitalABar]\[ABar]\[CapitalACup]\[ACup]\[CapitalCAcute]\[CAcute]\
\[CapitalCHacek]\[CHacek]\[CapitalEBar]\[EBar]\[CapitalECup]\[ECup]\
\[CapitalICup]\[ICup]\[DotlessI]\[CapitalLSlash]\[LSlash]\
\[CapitalODoubleAcute]\[ODoubleAcute]\[CapitalSHacek]\[SHacek]\
\[CapitalUDoubleAcute]\[UDoubleAcute]\[CapitalAlpha]\[CapitalBeta]\
\[CapitalGamma]\[CapitalDelta]\[CapitalEpsilon]\[CapitalZeta]\[CapitalEta]\
\[CapitalTheta]\[CapitalIota]\[CapitalKappa]\[CapitalLambda]\[CapitalMu]\
\[CapitalNu]\[CapitalXi]\[CapitalOmicron]\[CapitalPi]\[CapitalRho]\
\[CapitalSigma]\[CapitalTau]\[CapitalUpsilon]\[CapitalPhi]\[CapitalChi]\
\[CapitalPsi]\[CapitalOmega]\[Alpha]\[Beta]\[Gamma]\[Delta]\[CurlyEpsilon]\
\[Zeta]\[Eta]\[Theta]\[Iota]\[Kappa]\[Lambda]\[Mu]\[Nu]\[Xi]\[Omicron]\[Pi]\
\[Rho]\[FinalSigma]\[Sigma]\[Tau]\[Upsilon]\[CurlyPhi]\[Chi]\[Psi]\[Omega]\
\[CurlyTheta]\[CurlyCapitalUpsilon]\[Phi]\[CurlyPi]\[CapitalStigma]\[Stigma]\
\[CapitalDigamma]\[Digamma]\[CapitalKoppa]\[Koppa]\[CapitalSampi]\[Sampi]\
\[CurlyKappa]\[CurlyRho]\[Epsilon]\[ScriptG]\[ScriptCapitalH]\[GothicCapitalH]\
\[ScriptCapitalI]\[GothicCapitalI]\[ScriptCapitalL]\[ScriptL]\[ScriptCapitalR]\
\[GothicCapitalR]\[GothicCapitalZ]\[ScriptCapitalB]\[GothicCapitalC]\[ScriptE]\
\[ScriptCapitalE]\[ScriptCapitalF]\[ScriptCapitalM]\[ScriptO]\[Aleph]\[Bet]\
\[Gimel]\[Dalet]\[ScriptA]\[ScriptB]\[ScriptC]\[ScriptD]\[ScriptF]\[ScriptH]\
\[ScriptI]\[ScriptJ]\[ScriptK]\[ScriptM]\[ScriptN]\[ScriptP]\[ScriptQ]\
\[ScriptR]\[ScriptS]\[ScriptT]\[ScriptU]\[ScriptV]\[ScriptW]\[ScriptX]\
\[ScriptY]\[ScriptZ]\[GothicA]\[GothicB]\[GothicC]\[GothicD]\[GothicE]\
\[GothicF]\[GothicG]\[GothicH]\[GothicI]\[GothicJ]\[GothicK]\[GothicL]\
\[GothicM]\[GothicN]\[GothicO]\[GothicP]\[GothicQ]\[GothicR]\[GothicS]\
\[GothicT]\[GothicU]\[GothicV]\[GothicW]\[GothicX]\[GothicY]\[GothicZ]\
\[DoubleStruckA]\[DoubleStruckB]\[DoubleStruckC]\[DoubleStruckD]\
\[DoubleStruckE]\[DoubleStruckF]\[DoubleStruckG]\[DoubleStruckH]\
\[DoubleStruckI]\[DoubleStruckJ]\[DoubleStruckK]\[DoubleStruckL]\
\[DoubleStruckM]\[DoubleStruckN]\[DoubleStruckO]\[DoubleStruckP]\
\[DoubleStruckQ]\[DoubleStruckR]\[DoubleStruckS]\[DoubleStruckT]\
\[DoubleStruckU]\[DoubleStruckV]\[DoubleStruckW]\[DoubleStruckX]\
\[DoubleStruckY]\[DoubleStruckZ]\[DotlessJ]\[ScriptDotlessI]\[ScriptDotlessJ]\
\[ScriptCapitalA]\[ScriptCapitalC]\[ScriptCapitalD]\[ScriptCapitalG]\
\[ScriptCapitalJ]\[ScriptCapitalK]\[ScriptCapitalN]\[ScriptCapitalO]\
\[ScriptCapitalP]\[ScriptCapitalQ]\[ScriptCapitalS]\[ScriptCapitalT]\
\[ScriptCapitalU]\[ScriptCapitalV]\[ScriptCapitalW]\[ScriptCapitalX]\
\[ScriptCapitalY]\[ScriptCapitalZ]\[GothicCapitalA]\[GothicCapitalB]\
\[GothicCapitalD]\[GothicCapitalE]\[GothicCapitalF]\[GothicCapitalG]\
\[GothicCapitalJ]\[GothicCapitalK]\[GothicCapitalL]\[GothicCapitalM]\
\[GothicCapitalN]\[GothicCapitalO]\[GothicCapitalP]\[GothicCapitalQ]\
\[GothicCapitalS]\[GothicCapitalT]\[GothicCapitalU]\[GothicCapitalV]\
\[GothicCapitalW]\[GothicCapitalX]\[GothicCapitalY]\[DoubleStruckCapitalA]\
\[DoubleStruckCapitalB]\[DoubleStruckCapitalC]\[DoubleStruckCapitalD]\
\[DoubleStruckCapitalE]\[DoubleStruckCapitalF]\[DoubleStruckCapitalG]\
\[DoubleStruckCapitalH]\[DoubleStruckCapitalI]\[DoubleStruckCapitalJ]\
\[DoubleStruckCapitalK]\[DoubleStruckCapitalL]\[DoubleStruckCapitalM]\
\[DoubleStruckCapitalN]\[DoubleStruckCapitalO]\[DoubleStruckCapitalP]\
\[DoubleStruckCapitalQ]\[DoubleStruckCapitalR]\[DoubleStruckCapitalS]\
\[DoubleStruckCapitalT]\[DoubleStruckCapitalU]\[DoubleStruckCapitalV]\
\[DoubleStruckCapitalW]\[DoubleStruckCapitalX]\[DoubleStruckCapitalY]\
\[DoubleStruckCapitalZ]\[FiLigature]\[FlLigature]\"\>",
                 StripOnInput->False,
                 FontSize->14],
                StripOnInput->False,
                FontSize->14],
               StripOnInput->False,
               FontSize->14],
              StripOnInput->False,
              FontSize->14],
             StripOnInput->False,
             FontSize->14],
            StripOnInput->False,
            FontSize->14],
           StripOnInput->False,
           FontSize->14],
          StripOnInput->False,
          FontSize->14],
         StripOnInput->False,
         FontSize->14],
        StripOnInput->False,
        FontSize->14],
       StripOnInput->False,
       FontSize->14],
      StripOnInput->False,
      FontSize->14],
     StripOnInput->False,
     FontSize->14],
    StripOnInput->False,
    FontSize->14],
   StripOnInput->False,
   FontSize->14],
  StripOnInput->False,
  FontSize->14]], "Output",
 ImageSize->{584, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14602]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25141],

Cell["\<\
Contiguous characters in character space may not all be letters:\
\>", "ExampleText",
 CellID->24252],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacterRange", "[", 
  RowBox[{"\"\<\[ScriptCapitalA]\>\"", ",", "\"\<\[ScriptCapitalG]\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29186],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"\[ScriptCapitalA]\"\>", ",", "\<\"\:f771\"\>", 
   ",", "\<\"\[ScriptCapitalC]\"\>", ",", "\<\"\[ScriptCapitalD]\"\>", 
   ",", "\<\"\:f774\"\>", ",", "\<\"\:f775\"\>", 
   ",", "\<\"\[ScriptCapitalG]\"\>"}], "}"}]], "Output",
 ImageSize->{136, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2771]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LetterQ", "/@", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16614],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "False", ",", "True", ",", "True", ",", "False", ",", "False", 
   ",", "True"}], "}"}]], "Output",
 ImageSize->{303, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29641]
}, Open  ]],

Cell["An actual script-B character is nevertheless a letter:", "ExampleText",
 CellID->6070],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LetterQ", "[", "\"\<\[ScriptCapitalB]\>\"", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->607],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->23173]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10185],

Cell["Plot the character codes of letters:", "ExampleText",
 CellID->23757],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Flatten", "[", 
   RowBox[{"ToCharacterCode", "[", 
    RowBox[{"Select", "[", 
     RowBox[{
      RowBox[{"Characters", "[", 
       RowBox[{"FromCharacterCode", "[", 
        RowBox[{"Range", "[", 
         RowBox[{"2", "^", "16"}], "]"}], "]"}], "]"}], ",", "LetterQ"}], 
     "]"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6536],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlGD2P0zDUsXNpQgfoRnUCXZeqRNDbOCEmFjodTLAgVaoqpJwQAh33DzJ0
YjoWpvyJk/Lzgv1sJ47jNG1T53rUUu28b7/n92zXl4ub6Ov3xc3VcnE2u178
jK6Wv87e/7imKOIghO7o79tTRL8z+gW/uyyjo9q/pD2hJEJHTMe+gLGAJd4X
eOSCmGiS2qOja5CS+Hop1baOxxr9BJScs56hhUqswOwzYJ1bwGUOk4SnwaSB
H+ZxktMNXLVSCt1t4O+toTfxs88mfnwg0fSsWziWSNr2k2UwlnhP9aTqj8qv
Z745fq9U7aU49XeLXCFRqzloGzGjVt/afN08UnL/yUn7yreKXlLRA3wN62/S
75pn1OjJTnldslP1gUdyqkRann7qSaSeflhIqfz+lvxNJ57Oz0889bx+Lih/
ckj1/BawzwC7Wq0Qb69hGaMoElxfgOuU9n+BDvxemqZsBq7rOA7GMDv6Bavj
yIZULGUyYEu8jAERro194vUaq1giBGk7rc0XYhNbzaMtpNnEHTYaV2vQAMO+
14vjOAgCHmzeM+19iFm+BGLN8pgtl0uTxvONc2hTnv1IXkIEx+Mxki0MQ/Qu
U0pVNFkZslL0SvLE+AEsiGCxCtNq4A0ore6wNZgtdh+SGXwj8/mcl4GYie/7
nc/kI8C0zkejEa1zkS20DYfDJEnQW6szYeBtZ77atVTkNzfMm6Ssy02bVdRW
Uv0H11RfwnuPD2r/0NayyEvj/dqCJ13Zqb2jHX3+kw1nW+j573JDWbcaGzvc
8O9rn+9sdbbOGxs7927atZhs5UV3KwmvhfxvT6G6VT6acr8xU1rnvr366rKW
95tFh3PTObb9v/s7zn3kP+v3a6u8A6ovM4d/xynztL+n2btNdmlL2aE79Ic8
+Cr4DMBsNhM59AQSaTAYCL5J1qZKPgHM3iR4uwDtYRgKuvn9jEvFcex5HnvK
8OVro3hEZC+ZLyi7E0VR+RWOzSHSpF1N+rEGP6IdM+74vl//pvcbIp+m6XQ6
nUwmSZLgktV1FYucfwmlgy0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->167223269]
}, Open  ]],

Cell["Include the actual names of characters:", "ExampleText",
 CellID->251],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u", "=", 
     RowBox[{"Select", "[", 
      RowBox[{
       RowBox[{"Characters", "[", 
        RowBox[{"FromCharacterCode", "[", 
         RowBox[{"Range", "[", 
          RowBox[{"1", ",", "2000", ",", "5"}], "]"}], "]"}], "]"}], ",", 
       "LetterQ"}], "]"}]}], "}"}], ",", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"MapIndexed", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"First", "[", "#2", "]"}], ",", 
           RowBox[{"First", "[", 
            RowBox[{"ToCharacterCode", "[", "#1", "]"}], "]"}]}], "}"}], 
         "}"}], "&"}], ",", "u"}], "]"}], ",", 
     RowBox[{"PlotMarkers", "->", "u"}], ",", 
     RowBox[{"Frame", "->", "True"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11499],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{381, 238},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{381., Automatic}},
 CellLabel->"Out[2]=",
 CellID->60595946]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14004],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DigitQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DigitQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UpperCaseQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UpperCaseQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LowerCaseQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LowerCaseQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CharacterRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CharacterRange"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LetterCharacter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LetterCharacter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringExpression"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30231]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17372],

Cell[TextData[ButtonBox["Characters in Strings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CharactersInStrings"]], "Tutorials",
 CellID->23523]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->178593515],

Cell[TextData[ButtonBox["Character Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CharacterOperations"]], "MoreAbout",
 CellID->17794656],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout",
 CellID->271856272],

Cell[TextData[ButtonBox["Testing Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TestingExpressions"]], "MoreAbout",
 CellID->420611647]
}, Open  ]],

Cell["New in 2  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LetterQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 52, 54.7492934}", "context" -> "System`", 
    "keywords" -> {
     "alphabetic characters", "alphanumeric", "character class", 
      "test for alphabetic characters", "test for character"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "LetterQ[string] yields True if all the characters in the string are \
letters, and yields False otherwise. ", "synonyms" -> {"letter q"}, "title" -> 
    "LetterQ", "type" -> "Symbol", "uri" -> "ref/LetterQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7401, 243, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->589928709]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 31152, 990}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2622, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3245, 87, 45, 1, 70, "ObjectName",
 CellID->20350],
Cell[3293, 90, 799, 25, 70, "Usage",
 CellID->16043]
}, Open  ]],
Cell[CellGroupData[{
Cell[4129, 120, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4607, 137, 475, 17, 70, "Notes",
 CellID->13415],
Cell[5085, 156, 212, 7, 70, "Notes",
 CellID->20565],
Cell[5300, 165, 389, 12, 70, "Notes",
 CellID->28761],
Cell[5692, 179, 264, 9, 70, "Notes",
 CellID->13141],
Cell[5959, 190, 443, 15, 70, "Notes",
 CellID->17909],
Cell[6405, 207, 959, 31, 70, "Notes",
 CellID->27978]
}, Closed]],
Cell[CellGroupData[{
Cell[7401, 243, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->589928709],
Cell[CellGroupData[{
Cell[7786, 257, 148, 5, 70, "ExampleSection",
 CellID->463539160],
Cell[7937, 264, 76, 1, 70, "ExampleText",
 CellID->24623],
Cell[CellGroupData[{
Cell[8038, 269, 107, 3, 28, "Input",
 CellID->20487],
Cell[8148, 274, 157, 5, 36, "Output",
 CellID->30199]
}, Open  ]],
Cell[CellGroupData[{
Cell[8342, 284, 107, 3, 28, "Input",
 CellID->10991],
Cell[8452, 289, 158, 5, 36, "Output",
 CellID->16927]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8659, 300, 216, 7, 70, "ExampleSection",
 CellID->13105],
Cell[8878, 309, 91, 1, 70, "ExampleText",
 CellID->18552],
Cell[CellGroupData[{
Cell[8994, 314, 114, 3, 70, "Input",
 CellID->23583],
Cell[9111, 319, 156, 5, 36, "Output",
 CellID->7787]
}, Open  ]],
Cell[9282, 327, 121, 3, 70, "ExampleDelimiter",
 CellID->14513],
Cell[9406, 332, 67, 1, 70, "ExampleText",
 CellID->31627],
Cell[CellGroupData[{
Cell[9498, 337, 114, 3, 70, "Input",
 CellID->7781],
Cell[9615, 342, 158, 5, 36, "Output",
 CellID->21072]
}, Open  ]],
Cell[9788, 350, 120, 3, 70, "ExampleDelimiter",
 CellID->1304],
Cell[9911, 355, 85, 1, 70, "ExampleText",
 CellID->21850],
Cell[CellGroupData[{
Cell[10021, 360, 128, 3, 70, "Input",
 CellID->28212],
Cell[10152, 365, 157, 5, 36, "Output",
 CellID->31859]
}, Open  ]],
Cell[10324, 373, 120, 3, 70, "ExampleDelimiter",
 CellID->9797],
Cell[10447, 378, 77, 1, 70, "ExampleText",
 CellID->20049],
Cell[CellGroupData[{
Cell[10549, 383, 196, 5, 70, "Input",
 CellID->15381],
Cell[10748, 390, 157, 5, 36, "Output",
 CellID->32193]
}, Open  ]],
Cell[10920, 398, 120, 3, 70, "ExampleDelimiter",
 CellID->8640],
Cell[11043, 403, 75, 1, 70, "ExampleText",
 CellID->7403],
Cell[CellGroupData[{
Cell[11143, 408, 174, 5, 70, "Input",
 CellID->20325],
Cell[11320, 415, 157, 5, 36, "Output",
 CellID->32700]
}, Open  ]],
Cell[11492, 423, 121, 3, 70, "ExampleDelimiter",
 CellID->15449],
Cell[11616, 428, 137, 4, 70, "ExampleText",
 CellID->28361],
Cell[CellGroupData[{
Cell[11778, 436, 79, 2, 70, "Input",
 CellID->27407],
Cell[11860, 440, 166, 5, 36, "Output",
 CellID->5672]
}, Open  ]],
Cell[CellGroupData[{
Cell[12063, 450, 99, 3, 70, "Input",
 CellID->25868],
Cell[12165, 455, 158, 5, 36, "Output",
 CellID->14341]
}, Open  ]],
Cell[12338, 463, 121, 3, 70, "ExampleDelimiter",
 CellID->12187]
}, Closed]],
Cell[CellGroupData[{
Cell[12496, 471, 233, 7, 70, "ExampleSection",
 CellID->24168],
Cell[12732, 480, 73, 1, 70, "ExampleText",
 CellID->15048],
Cell[CellGroupData[{
Cell[12830, 485, 391, 12, 70, "Input",
 CellID->18353],
Cell[13224, 499, 5835, 117, 134, "Output",
 CellID->14602]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19108, 622, 226, 7, 70, "ExampleSection",
 CellID->25141],
Cell[19337, 631, 111, 3, 70, "ExampleText",
 CellID->24252],
Cell[CellGroupData[{
Cell[19473, 638, 180, 5, 70, "Input",
 CellID->29186],
Cell[19656, 645, 396, 10, 36, "Output",
 CellID->2771]
}, Open  ]],
Cell[CellGroupData[{
Cell[20089, 660, 95, 3, 70, "Input",
 CellID->16614],
Cell[20187, 665, 281, 9, 36, "Output",
 CellID->29641]
}, Open  ]],
Cell[20483, 677, 92, 1, 70, "ExampleText",
 CellID->6070],
Cell[CellGroupData[{
Cell[20600, 682, 121, 3, 70, "Input",
 CellID->607],
Cell[20724, 687, 157, 5, 36, "Output",
 CellID->23173]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20930, 698, 224, 7, 70, "ExampleSection",
 CellID->10185],
Cell[21157, 707, 75, 1, 70, "ExampleText",
 CellID->23757],
Cell[CellGroupData[{
Cell[21257, 712, 408, 12, 70, "Input",
 CellID->6536],
Cell[21668, 726, 1274, 25, 70, "Output",
 Evaluatable->False,
 CellID->167223269]
}, Open  ]],
Cell[22957, 754, 76, 1, 70, "ExampleText",
 CellID->251],
Cell[CellGroupData[{
Cell[23058, 759, 888, 27, 70, "Input",
 CellID->11499],
Cell[23949, 788, 2802, 50, 70, "Output",
 Evaluatable->False,
 CellID->60595946]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26812, 845, 311, 9, 70, "SeeAlsoSection",
 CellID->14004],
Cell[27126, 856, 1477, 53, 70, "SeeAlso",
 CellID->30231]
}, Open  ]],
Cell[CellGroupData[{
Cell[28640, 914, 314, 9, 70, "TutorialsSection",
 CellID->17372],
Cell[28957, 925, 151, 3, 70, "Tutorials",
 CellID->23523]
}, Open  ]],
Cell[CellGroupData[{
Cell[29145, 933, 319, 9, 70, "MoreAboutSection",
 CellID->178593515],
Cell[29467, 944, 150, 3, 70, "MoreAbout",
 CellID->17794656],
Cell[29620, 949, 149, 3, 70, "MoreAbout",
 CellID->271856272],
Cell[29772, 954, 149, 3, 70, "MoreAbout",
 CellID->420611647]
}, Open  ]],
Cell[29936, 960, 50, 0, 70, "History"],
Cell[29989, 962, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

