(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     42187,       1627]
NotebookOptionsPosition[     33942,       1322]
NotebookOutlinePosition[     35298,       1360]
CellTagsIndexPosition[     35212,       1355]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Expressions as Trees" :> 
          Documentation`HelpLookup["paclet:tutorial/ExpressionsAsTrees"], 
          "Levels in Expressions" :> 
          Documentation`HelpLookup["paclet:tutorial/LevelsInExpressions"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Expressions as Trees\"\>", 
       2->"\<\"Levels in Expressions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Apply" :> Documentation`HelpLookup["paclet:ref/Apply"], "Map" :> 
          Documentation`HelpLookup["paclet:ref/Map"], "Scan" :> 
          Documentation`HelpLookup["paclet:ref/Scan"], "Depth" :> 
          Documentation`HelpLookup["paclet:ref/Depth"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Apply\"\>", 2->"\<\"Map\"\>", 3->"\<\"Scan\"\>", 
       4->"\<\"Depth\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Expression Structure" :> 
          Documentation`HelpLookup["paclet:guide/ExpressionStructure"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Expression Structure\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Level", "ObjectName",
 CellID->32706],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Level",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Level"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["levelspec", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of all subexpressions of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " on levels specified by ",
     Cell[BoxData[
      StyleBox["levelspec", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Level",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Level"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["levelspec", "TI"], ",", 
        StyleBox["f", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]applies ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to the sequence of subexpressions. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->13701]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Level",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Level"]], "InlineFormula"],
 " uses standard level specifications:"
}], "Notes",
 CellID->12722],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["n", "TI"], Cell[TextData[{
     "levels ",
     Cell[BoxData["1"], "InlineFormula"],
     " through ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[TextData[{
     "levels ",
     Cell[BoxData["1"], "InlineFormula"],
     " through ",
     Cell[BoxData[
      ButtonBox["Infinity",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Infinity"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     StyleBox["n", "TI"], "}"}], Cell[TextData[{
     "level ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " only"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]}], "}"}], Cell[TextData[{
     "levels ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->2171],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Level",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Level"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{"-", "1"}], "}"}]}], "]"}]], "InlineFormula"],
 " gives a list of all \[OpenCurlyDoubleQuote]atomic\[CloseCurlyDoubleQuote] \
objects in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->30495],

Cell[TextData[{
 "A positive level ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " consists of all parts of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " specified by ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " indices."
}], "Notes",
 CellID->4967],

Cell[TextData[{
 "A negative level ",
 Cell[BoxData[
  RowBox[{"-", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " consists of all parts of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with depth ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->612],

Cell[TextData[{
 "Level ",
 Cell[BoxData["0"], "InlineFormula"],
 " corresponds to the whole expression."
}], "Notes",
 CellID->13475],

Cell[TextData[{
 "With the option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Heads",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Heads"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Level",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Level"]], "InlineFormula"],
 " ",
 "includes heads of expressions, and their parts. "
}], "Notes",
 CellID->49],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Level",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Level"]], "InlineFormula"],
 " traverses expressions in depth\[Hyphen]first order, so that the \
subexpressions in the final list are ordered lexicographically by their \
indices. "
}], "Notes",
 CellID->5847]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->20189739],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->81181798],

Cell["Give all parts at level -1:", "ExampleText",
 CellID->3099],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Level", "[", 
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"f", "[", 
     RowBox[{"x", ",", 
      RowBox[{"y", "^", "n"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29480],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "x", ",", "y", ",", "n"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16273]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32282],

Cell["Give all parts down to level 2:", "ExampleText",
 CellID->7657],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Level", "[", 
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"f", "[", 
     RowBox[{"x", ",", 
      RowBox[{"y", "^", "n"}]}], "]"}]}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6188],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "x", ",", 
   SuperscriptBox["y", "n"], ",", 
   RowBox[{"f", "[", 
    RowBox[{"x", ",", 
     SuperscriptBox["y", "n"]}], "]"}]}], "}"}]], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6270]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5541],

Cell["Give all parts at levels 0 through infinity:", "ExampleText",
 CellID->397],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Level", "[", 
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"f", "[", 
     RowBox[{"x", ",", 
      RowBox[{"y", "^", "n"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15021],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "x", ",", "y", ",", "n", ",", 
   SuperscriptBox["y", "n"], ",", 
   RowBox[{"f", "[", 
    RowBox[{"x", ",", 
     SuperscriptBox["y", "n"]}], "]"}], ",", 
   RowBox[{"a", "+", 
    RowBox[{"f", "[", 
     RowBox[{"x", ",", 
      SuperscriptBox["y", "n"]}], "]"}]}]}], "}"}]], "Output",
 ImageSize->{249, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25586]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26335],

Cell["Down successive numbers of levels:", "ExampleText",
 CellID->31841],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Level", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19086],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20380]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Level", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24223],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", "a", "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", "a", "}"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->20543]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Level", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->29649],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "a", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", "a", "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", "a", "}"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->25209]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Level", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], ",", "4"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->602],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{"{", "a", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", "a", "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", "a", "}"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->14173]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Level", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], ",", "5"}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->4559],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{"{", "a", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", "a", "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", "a", "}"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->12217]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16683],

Cell["Negative levels:", "ExampleText",
 CellID->12917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Level", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30758],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{"{", "a", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", "a", "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", "a", "}"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31506]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Level", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], ",", 
   RowBox[{"-", "2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21571],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "a", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", "a", "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", "a", "}"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18692]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Level", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], ",", 
   RowBox[{"-", "3"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->14133],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", "a", "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", "a", "}"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->24314]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Level", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], ",", 
   RowBox[{"-", "4"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->18830],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->31063]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Level", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], ",", 
   RowBox[{"-", "5"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->7132],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->23903]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8596],

Cell["Ranges of levels:", "ExampleText",
 CellID->28393],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Level", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23682],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "a", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", "a", "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26777]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Level", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1181],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{"{", "a", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", "a", "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", "a", "}"}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{238, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29420]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5981],

Cell["Use different heads at each level:", "ExampleText",
 CellID->30877],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Level", "[", 
  RowBox[{
   RowBox[{"h0", "[", 
    RowBox[{"h1", "[", 
     RowBox[{"h2", "[", 
      RowBox[{"h3", "[", "a", "]"}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21272],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{"h3", "[", "a", "]"}], ",", 
   RowBox[{"h2", "[", 
    RowBox[{"h3", "[", "a", "]"}], "]"}], ",", 
   RowBox[{"h1", "[", 
    RowBox[{"h2", "[", 
     RowBox[{"h3", "[", "a", "]"}], "]"}], "]"}], ",", 
   RowBox[{"h0", "[", 
    RowBox[{"h1", "[", 
     RowBox[{"h2", "[", 
      RowBox[{"h3", "[", "a", "]"}], "]"}], "]"}], "]"}]}], "}"}]], "Output",
 ImageSize->{378, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19238]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1517],

Cell["Including heads:", "ExampleText",
 CellID->115],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Level", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], ",", "3", ",", 
   RowBox[{"Heads", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5437],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"List", ",", "List", ",", "List", ",", 
   RowBox[{"{", "a", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", "a", "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", "a", "}"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{263, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31486]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Level", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "3"}]}], ",", "3", ",", 
   RowBox[{"Heads", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2506],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Plus", ",", "Power", ",", "x", ",", "2", ",", 
   SuperscriptBox["x", "2"], ",", "Power", ",", "y", ",", "3", ",", 
   SuperscriptBox["y", "3"]}], "}"}]], "Output",
 ImageSize->{259, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->22506]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30368],

Cell["Find the leaf elements in an expression:", "ExampleText",
 CellID->28042],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"Tan", "[", "x", "]"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29931],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"4", " ", "\[ExponentialE]"}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", "2"]}], ")"}], " ", 
     RowBox[{"CosIntegral", "[", 
      RowBox[{"\[ImaginaryI]", "-", 
       RowBox[{"Tan", "[", "x", "]"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", "2"]}], ")"}], " ", 
     RowBox[{"CosIntegral", "[", 
      RowBox[{"\[ImaginaryI]", "+", 
       RowBox[{"Tan", "[", "x", "]"}]}], "]"}]}], "+", 
    RowBox[{"\[ImaginaryI]", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", "2"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"SinIntegral", "[", 
        RowBox[{"\[ImaginaryI]", "-", 
         RowBox[{"Tan", "[", "x", "]"}]}], "]"}], "+", 
       RowBox[{"SinIntegral", "[", 
        RowBox[{"\[ImaginaryI]", "+", 
         RowBox[{"Tan", "[", "x", "]"}]}], "]"}]}], ")"}]}]}], 
   ")"}]}]], "Output",
 ImageSize->{479, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14748]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Level", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"-", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15736],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "4"], ",", "\[ExponentialE]", ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}], ",", "\[ExponentialE]", ",", "2", ",", "\[ImaginaryI]",
    ",", 
   RowBox[{"-", "1"}], ",", "x", ",", 
   RowBox[{"-", "1"}], ",", "\[ExponentialE]", ",", "2", ",", "\[ImaginaryI]",
    ",", "x", ",", "\[ImaginaryI]", ",", "1", ",", "\[ExponentialE]", ",", 
   "2", ",", "\[ImaginaryI]", ",", 
   RowBox[{"-", "1"}], ",", "x", ",", "\[ImaginaryI]", ",", "x"}], 
  "}"}]], "Output",
 ImageSize->{473, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21706]
}, Open  ]],

Cell["Include heads:", "ExampleText",
 CellID->7190],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Level", "[", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"Tan", "[", "x", "]"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "1"}], "}"}], ",", 
   RowBox[{"Heads", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->31900],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Times", ",", 
   FractionBox["1", "4"], ",", "Power", ",", "\[ExponentialE]", ",", 
   RowBox[{"-", "1"}], ",", "Plus", ",", "Times", ",", "Plus", ",", 
   RowBox[{"-", "1"}], ",", "Power", ",", "\[ExponentialE]", ",", "2", ",", 
   "CosIntegral", ",", "Plus", ",", "\[ImaginaryI]", ",", "Times", ",", 
   RowBox[{"-", "1"}], ",", "Tan", ",", "x", ",", "Times", ",", "Plus", ",", 
   RowBox[{"-", "1"}], ",", "Power", ",", "\[ExponentialE]", ",", "2", ",", 
   "CosIntegral", ",", "Plus", ",", "\[ImaginaryI]", ",", "Tan", ",", "x", 
   ",", "Times", ",", "\[ImaginaryI]", ",", "Plus", ",", "1", ",", "Power", 
   ",", "\[ExponentialE]", ",", "2", ",", "Plus", ",", "SinIntegral", ",", 
   "Plus", ",", "\[ImaginaryI]", ",", "Times", ",", 
   RowBox[{"-", "1"}], ",", "Tan", ",", "x", ",", "SinIntegral", ",", "Plus", 
   ",", "\[ImaginaryI]", ",", "Tan", ",", "x"}], "}"}]], "Output",
 ImageSize->{473, 86},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->23865]
}, Open  ]],

Cell["Find unique leaf expressions:", "ExampleText",
 CellID->1155],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{"Level", "[", 
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"Tan", "[", "x", "]"}], "]"}], ",", "x"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"-", "1"}], "}"}], ",", 
    RowBox[{"Heads", "->", "True"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1078],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "\[ImaginaryI]", ",", 
   FractionBox["1", "4"], ",", "1", ",", "2", ",", "CosIntegral", ",", 
   "\[ExponentialE]", ",", "Plus", ",", "Power", ",", "SinIntegral", ",", 
   "Tan", ",", "Times", ",", "x"}], "}"}]], "Output",
 ImageSize->{488, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->29081]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15470],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Level",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Level"]], "InlineFormula"],
 " always lists parts in the lexicographic order of their indices:"
}], "ExampleText",
 CellID->22949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{"a", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9421],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWMFOAjEQ7VIWFCOiB8MRf0ZP/oEeNsQEDkaD/D9uC+jymO1Mu92CZkkW
OmU6M2863bbvuVgv3t6L9XJezJ5WxediOf+aPX6syi6dKZW9KKUepqpsb8qW
fczntXy2zW3rynzr/b8b1Qd5VH711LHeDSEbvRz6Jw3HYzxoJ1V8k5rxGB/K
2mZ5FIhq7/WWsEr1c+Oo6Cj0bcVz55k9lHuibJpo8lLUxGjTj/oDz36Uh4n9
oXz5T/APhf7iVInVyn9kO+bYd72WqWfMvKuf0hu2GIPMdl1kmL0Y2aqPKHXO
3JFcBGeOr0oOpRb5xpU2ARl3Lxx/HcXLGGTcG1FG/TCs1M4cHyvnhcPKVUO2
kbyjTFR9Qe1Rpx2X/rgluyhj1s4ND1c7p9x5uNUTZ41zXqgZ9JnxMKyIDaOK
g5WrBg5rvNOqETG6AYXRc02E2MUzfI/xQ2VN4hfjxzhC8XCzyuGJM6t4g6LX
ge977j7Iqmx1cPMqQ0T7ioOLtj0OQiebZSk7Yvr1Dmf1vpvvfqcOPa1+T55Y
23hfpvxV7bn8aYE/GZthmsgj+bd8Z6Rjog71wubOd0/rmCl3fP2grP5VhqZj
qGIyVL5VIztL1/EmabgqX++nYKn8EabLUypmqrdfDd7nYRlr0/RGH3Zm5e6N
7TBU1E3FdZKOg5Xz4stQ2doK2snOidHpGKpD2b61Eu00p1njaRgqzkochorz
0pShCquGOkYnxpoIsdsWQ4Xj0E8oQ8XZbcpQhc0qx2005aY4e+2wUrJ11xRL
m0zUdjZ9R1WZoeq91sVEoZ6u9PswUdXxLiaqqufLRNmTvhUk3JLKvgH2GvYA
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{348, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->363619603]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Level", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", "3", "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20553],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "[", 
    RowBox[{"1", ",", "1", ",", "1"}], "]"}], ",", 
   RowBox[{"a", "[", 
    RowBox[{"1", ",", "1", ",", "2"}], "]"}], ",", 
   RowBox[{"a", "[", 
    RowBox[{"1", ",", "2", ",", "1"}], "]"}], ",", 
   RowBox[{"a", "[", 
    RowBox[{"1", ",", "2", ",", "2"}], "]"}], ",", 
   RowBox[{"a", "[", 
    RowBox[{"2", ",", "1", ",", "1"}], "]"}], ",", 
   RowBox[{"a", "[", 
    RowBox[{"2", ",", "1", ",", "2"}], "]"}], ",", 
   RowBox[{"a", "[", 
    RowBox[{"2", ",", "2", ",", "1"}], "]"}], ",", 
   RowBox[{"a", "[", 
    RowBox[{"2", ",", "2", ",", "2"}], "]"}]}], "}"}]], "Output",
 ImageSize->{385, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->12841]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27456],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Level",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Level"]], "InlineFormula"],
 " by default starts at level 1, so does not include the whole expression:"
}], "ExampleText",
 CellID->24330],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Level", "[", 
  RowBox[{
   RowBox[{"h1", "[", 
    RowBox[{"h2", "[", 
     RowBox[{"h3", "[", "x", "]"}], "]"}], "]"}], ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13544],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"h3", "[", "x", "]"}], ",", 
   RowBox[{"h2", "[", 
    RowBox[{"h3", "[", "x", "]"}], "]"}]}], "}"}]], "Output",
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13382]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Level", "[", 
  RowBox[{
   RowBox[{"h1", "[", 
    RowBox[{"h2", "[", 
     RowBox[{"h3", "[", "x", "]"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13622],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"h3", "[", "x", "]"}], ",", 
   RowBox[{"h2", "[", 
    RowBox[{"h3", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"h1", "[", 
    RowBox[{"h2", "[", 
     RowBox[{"h3", "[", "x", "]"}], "]"}], "]"}]}], "}"}]], "Output",
 ImageSize->{248, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28540]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5347],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Apply",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Apply"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Map",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Map"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Scan",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scan"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Depth",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Depth"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14447]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18019],

Cell[TextData[ButtonBox["Expressions as Trees",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExpressionsAsTrees"]], "Tutorials",
 CellID->15179],

Cell[TextData[ButtonBox["Levels in Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LevelsInExpressions"]], "Tutorials",
 CellID->32504]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Expression Structure",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExpressionStructure"]], "MoreAbout",
 CellID->551406940]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Level - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 52, 55.2024300}", "context" -> "System`", 
    "keywords" -> {
     "level of expression", "part of expression", "parts at level"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Level[expr, levelspec] gives a list of all subexpressions of expr on \
levels specified by levelspec. Level[expr, levelspec, f] applies f to the \
sequence of subexpressions. ", "synonyms" -> {}, "title" -> "Level", "type" -> 
    "Symbol", "uri" -> "ref/Level"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8377, 294, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->20189739]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 35070, 1348}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2120, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2743, 77, 43, 1, 70, "ObjectName",
 CellID->32706],
Cell[2789, 80, 1194, 38, 70, "Usage",
 CellID->13701]
}, Open  ]],
Cell[CellGroupData[{
Cell[4020, 123, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4498, 140, 197, 7, 70, "Notes",
 CellID->12722],
Cell[4698, 149, 1663, 55, 70, "2ColumnTableMod",
 CellID->2171],
Cell[6364, 206, 441, 16, 70, "Notes",
 CellID->30495],
Cell[6808, 224, 302, 12, 70, "Notes",
 CellID->4967],
Cell[7113, 238, 310, 13, 70, "Notes",
 CellID->612],
Cell[7426, 253, 134, 5, 70, "Notes",
 CellID->13475],
Cell[7563, 260, 464, 18, 70, "Notes",
 CellID->49],
Cell[8030, 280, 310, 9, 70, "Notes",
 CellID->5847]
}, Closed]],
Cell[CellGroupData[{
Cell[8377, 294, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->20189739],
Cell[CellGroupData[{
Cell[8761, 308, 147, 5, 70, "ExampleSection",
 CellID->81181798],
Cell[8911, 315, 65, 1, 70, "ExampleText",
 CellID->3099],
Cell[CellGroupData[{
Cell[9001, 320, 271, 10, 28, "Input",
 CellID->29480],
Cell[9275, 332, 219, 7, 36, "Output",
 CellID->16273]
}, Open  ]],
Cell[9509, 342, 121, 3, 70, "ExampleDelimiter",
 CellID->32282],
Cell[9633, 347, 69, 1, 70, "ExampleText",
 CellID->7657],
Cell[CellGroupData[{
Cell[9727, 352, 226, 8, 70, "Input",
 CellID->6188],
Cell[9956, 362, 325, 11, 36, "Output",
 CellID->6270]
}, Open  ]],
Cell[10296, 376, 120, 3, 70, "ExampleDelimiter",
 CellID->5541],
Cell[10419, 381, 81, 1, 70, "ExampleText",
 CellID->397],
Cell[CellGroupData[{
Cell[10525, 386, 283, 10, 70, "Input",
 CellID->15021],
Cell[10811, 398, 464, 15, 36, "Output",
 CellID->25586]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11324, 419, 239, 7, 70, "ExampleSection",
 CellID->26335],
Cell[11566, 428, 73, 1, 70, "ExampleText",
 CellID->31841],
Cell[CellGroupData[{
Cell[11664, 433, 225, 9, 70, "Input",
 CellID->19086],
Cell[11892, 444, 248, 9, 36, "Output",
 CellID->20380]
}, Open  ]],
Cell[CellGroupData[{
Cell[12177, 458, 225, 9, 70, "Input",
 CellID->24223],
Cell[12405, 469, 324, 12, 36, "Output",
 CellID->20543]
}, Open  ]],
Cell[CellGroupData[{
Cell[12766, 486, 225, 9, 70, "Input",
 CellID->29649],
Cell[12994, 497, 358, 13, 36, "Output",
 CellID->25209]
}, Open  ]],
Cell[CellGroupData[{
Cell[13389, 515, 223, 9, 70, "Input",
 CellID->602],
Cell[13615, 526, 368, 13, 36, "Output",
 CellID->14173]
}, Open  ]],
Cell[CellGroupData[{
Cell[14020, 544, 224, 9, 70, "Input",
 CellID->4559],
Cell[14247, 555, 368, 13, 36, "Output",
 CellID->12217]
}, Open  ]],
Cell[14630, 571, 121, 3, 70, "ExampleDelimiter",
 CellID->16683],
Cell[14754, 576, 55, 1, 70, "ExampleText",
 CellID->12917],
Cell[CellGroupData[{
Cell[14834, 581, 241, 9, 70, "Input",
 CellID->30758],
Cell[15078, 592, 368, 13, 36, "Output",
 CellID->31506]
}, Open  ]],
Cell[CellGroupData[{
Cell[15483, 610, 241, 9, 70, "Input",
 CellID->21571],
Cell[15727, 621, 358, 13, 36, "Output",
 CellID->18692]
}, Open  ]],
Cell[CellGroupData[{
Cell[16122, 639, 241, 9, 70, "Input",
 CellID->14133],
Cell[16366, 650, 324, 12, 36, "Output",
 CellID->24314]
}, Open  ]],
Cell[CellGroupData[{
Cell[16727, 667, 241, 9, 70, "Input",
 CellID->18830],
Cell[16971, 678, 248, 9, 36, "Output",
 CellID->31063]
}, Open  ]],
Cell[CellGroupData[{
Cell[17256, 692, 240, 9, 70, "Input",
 CellID->7132],
Cell[17499, 703, 171, 6, 36, "Output",
 CellID->23903]
}, Open  ]],
Cell[17685, 712, 120, 3, 70, "ExampleDelimiter",
 CellID->8596],
Cell[17808, 717, 56, 1, 70, "ExampleText",
 CellID->28393],
Cell[CellGroupData[{
Cell[17889, 722, 271, 10, 70, "Input",
 CellID->23682],
Cell[18163, 734, 272, 10, 36, "Output",
 CellID->26777]
}, Open  ]],
Cell[CellGroupData[{
Cell[18472, 749, 291, 11, 70, "Input",
 CellID->1181],
Cell[18766, 762, 480, 17, 36, "Output",
 CellID->29420]
}, Open  ]],
Cell[19261, 782, 120, 3, 70, "ExampleDelimiter",
 CellID->5981],
Cell[19384, 787, 73, 1, 70, "ExampleText",
 CellID->30877],
Cell[CellGroupData[{
Cell[19482, 792, 316, 11, 70, "Input",
 CellID->21272],
Cell[19801, 805, 540, 17, 36, "Output",
 CellID->19238]
}, Open  ]],
Cell[20356, 825, 120, 3, 70, "ExampleDelimiter",
 CellID->1517],
Cell[20479, 830, 53, 1, 70, "ExampleText",
 CellID->115],
Cell[CellGroupData[{
Cell[20557, 835, 263, 9, 70, "Input",
 CellID->5437],
Cell[20823, 846, 397, 13, 36, "Output",
 CellID->31486]
}, Open  ]],
Cell[CellGroupData[{
Cell[21257, 864, 235, 8, 70, "Input",
 CellID->2506],
Cell[21495, 874, 331, 9, 39, "Output",
 CellID->22506]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21875, 889, 223, 7, 70, "ExampleSection",
 CellID->30368],
Cell[22101, 898, 79, 1, 70, "ExampleText",
 CellID->28042],
Cell[CellGroupData[{
Cell[22205, 903, 187, 6, 70, "Input",
 CellID->29931],
Cell[22395, 911, 1248, 39, 71, "Output",
 CellID->14748]
}, Open  ]],
Cell[CellGroupData[{
Cell[23680, 955, 164, 6, 70, "Input",
 CellID->15736],
Cell[23847, 963, 658, 17, 51, "Output",
 CellID->21706]
}, Open  ]],
Cell[24520, 983, 52, 1, 70, "ExampleText",
 CellID->7190],
Cell[CellGroupData[{
Cell[24597, 988, 335, 11, 70, "Input",
 CellID->31900],
Cell[24935, 1001, 1052, 19, 107, "Output",
 CellID->23865]
}, Open  ]],
Cell[26002, 1023, 67, 1, 70, "ExampleText",
 CellID->1155],
Cell[CellGroupData[{
Cell[26094, 1028, 374, 12, 70, "Input",
 CellID->1078],
Cell[26471, 1042, 418, 11, 51, "Output",
 CellID->29081]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26938, 1059, 233, 7, 70, "ExampleSection",
 CellID->15470],
Cell[27174, 1068, 231, 7, 70, "ExampleText",
 CellID->22949],
Cell[CellGroupData[{
Cell[27430, 1079, 178, 6, 70, "Input",
 CellID->9421],
Cell[27611, 1087, 1066, 22, 70, "Output",
 Evaluatable->False,
 CellID->363619603]
}, Open  ]],
Cell[CellGroupData[{
Cell[28714, 1114, 144, 5, 70, "Input",
 CellID->20553],
Cell[28861, 1121, 772, 23, 54, "Output",
 CellID->12841]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29682, 1150, 226, 7, 70, "ExampleSection",
 CellID->27456],
Cell[29911, 1159, 239, 7, 70, "ExampleText",
 CellID->24330],
Cell[CellGroupData[{
Cell[30175, 1170, 232, 8, 70, "Input",
 CellID->13544],
Cell[30410, 1180, 301, 10, 36, "Output",
 CellID->13382]
}, Open  ]],
Cell[CellGroupData[{
Cell[30748, 1195, 283, 10, 70, "Input",
 CellID->13622],
Cell[31034, 1207, 404, 13, 36, "Output",
 CellID->28540]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31499, 1227, 310, 9, 70, "SeeAlsoSection",
 CellID->5347],
Cell[31812, 1238, 911, 35, 70, "SeeAlso",
 CellID->14447]
}, Open  ]],
Cell[CellGroupData[{
Cell[32760, 1278, 314, 9, 70, "TutorialsSection",
 CellID->18019],
Cell[33077, 1289, 149, 3, 70, "Tutorials",
 CellID->15179],
Cell[33229, 1294, 151, 3, 70, "Tutorials",
 CellID->32504]
}, Open  ]],
Cell[CellGroupData[{
Cell[33417, 1302, 299, 8, 70, "MoreAboutSection"],
Cell[33719, 1312, 151, 3, 70, "MoreAbout",
 CellID->551406940]
}, Open  ]],
Cell[33885, 1318, 27, 0, 70, "History"],
Cell[33915, 1320, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

