(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     38775,        928]
NotebookOptionsPosition[     35528,        818]
NotebookOutlinePosition[     36749,        854]
CellTagsIndexPosition[     36664,        849]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Brown" :> Documentation`HelpLookup["paclet:ref/Brown"], 
          "ColorData" :> Documentation`HelpLookup["paclet:ref/ColorData"], 
          "Lighter" :> Documentation`HelpLookup["paclet:ref/Lighter"], 
          "Darker" :> Documentation`HelpLookup["paclet:ref/Darker"], "Blend" :> 
          Documentation`HelpLookup["paclet:ref/Blend"], "RGBColor" :> 
          Documentation`HelpLookup["paclet:ref/RGBColor"], "Style" :> 
          Documentation`HelpLookup["paclet:ref/Style"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Brown\"\>", 2->"\<\"ColorData\"\>", 
       3->"\<\"Lighter\"\>", 4->"\<\"Darker\"\>", 5->"\<\"Blend\"\>", 
       6->"\<\"RGBColor\"\>", 7->"\<\"Style\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Colors" :> Documentation`HelpLookup["paclet:guide/Colors"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Colors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["LightBrown", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["LightBrown",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LightBrown"]], "InlineFormula"],
     " \[LineSeparator]represents a light brown color in graphics or style \
specifications."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LightBrown",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LightBrown"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"], "[", 
   RowBox[{
    ButtonBox["Brown",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Brown"], ",", "0.85"}], "]"}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->5162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->269110531],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->535250402],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"LightBrown", ",", 
    RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
    RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->511908593],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[0.94, 0.91, 0.88], EdgeForm[GrayLevel[0]], 
   DiskBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->488995990]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightBrown"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->310096450],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WNtrnEUUn+y318Rks4k11VpNbbXe6g1ttRqkaZK2SRPT1lhLQQxBSRFv
bREf4kNR0Qd9USgVCUgVqYiltEgpUsUbXhCLWKQUShERik/ff6C/c2bmm5mz
s9tuCobN7jnznftlvjMzPr139qlnp/fumpnu37B7+oXZXTN7+kee342lpE0p
tR//OxYrwP8C4v/96YU/8cD7LuE7waMcYQTgl8AcwNeZoiyeJPSVd7hSBUEx
p5cT/UN/OYu2JGc743+fO/fdyVP4qBx9Jf/8dd48X9qCfUQwxY9PHP35pT1H
RjfOq/wzs5+qZHjwfeCHD33fkjyfYhtTwLgnn/gYoqCgyCsA9r3y+dTWg18e
/2XJAmVvYQr4/M7bX8DcUz+cbueVs7+fefG5wxCPR1dnmaQ4F71fX9KkjSb4
5g98pboYh99Pz3wCaWoxS+kz3Joa6/CJwt7NONTDCKLuy6h9HROWy1D1WBw6
wKuuinKNe7qI60ohZVFgmaaG277M5PSvfwCHd5q7TsdmxnV2CNTPkRhEg8De
KNcY6Tzw7slreB1RQxYI7IlSjzL+0ze/wRIClwidtcCPUZsP4/W1Aq9FdWwS
MpcKnd1Rro021ygYAq9nHM7AJQKrUa4NjJ8/c3bn9o8osv028rAQ8fa4yB+t
A+FEUAlcJizrCqrU3w3sDiErdoTxY5/9OPfyUQKXM/7Wmyc+nP+awE7mLdb1
UCnWZR4+bCMNv+CdWmH9QqsSruXK/Uu3pqfmEvU4e28U/lzRgv2EDtkeRERh
rVopIt7RQF4hje8IWh6aDA1O4ErbScgvyW8mz5cj8fWM632WwFtEHNqDSrC/
UsqgzQqyRP1wq8hSe1B9WicUQA2BtzF+6OC3b7x6nMBKtMLXiUpYxTjcR5AJ
LDfhcv6sEv6WA8u6TfaoW/IeXrbdBX8o2vLd0GXoeowc7iXzrBi1q1vgVdFj
vdG8oRhRkpnd3vNaxCJbCbTzqgbxkXZIvEfgeVvXCDyBJRMpScf6C34lIua6
Wy5qg/Sl6lWfv5/6vReLWb0NMNqzgWRKXRKXtkn/K54c+5sosyPpdF1iBfgZ
09ZKfxJR8ZVmPhQzPCvbQtSOagMPCqJTOiL254KaB6AbTcU1DQj770vDrsoH
mRkQ+tekYScnUR0PCR1rhI4414NpuCM9IHTlolxr03CXWyt0aS6aiPbxm6nP
1qP2yFRtElbpxVeDGmmZO75aEavOqf/floXFAp82F+VENzvtfCti3UG4Tnfj
52l0/9YFqe4XuV8X1K7/pl8tastRevszbF0tJA46Oue73vxM5ziZUVotVt1r
q9JMhusDS/VZ0r1X7hGV76hVyY+1q/K7RdUPRXslJ+TeJfChwKpEyLwzvRBM
U8NRHZrLTf53MO7eF824XNz1hOBm4ZEoV15k4PY03HdGAn+K4qmej9x0ydM7
v6EbzdvxOU7Obc4LnvD1u67pvCrvEooiZjcz7k4flyfXvTf1/IpZEVVJGd3U
gtwkW3f1c5Owu5E8O1/LeJZE/PT8786co03k1deFw8siT8utHnMuGwsyb+dr
KYUnYm9PuUFkZSyotnbbPabjl4nYb45WtOaS5053dh+PcnUIy65L9Sl8ogm1
s0yfiHGkwcGGwInAj04RO31GdyeAR6I6Oo0F8kQfp9Y3K+5cxTcrXl9PBhZV
bdWaexh5M7ElqiPjQvzJ60UWR6QJ3xrl8m9xiKpX4NuiXDVrESykGNUE16OB
P5lMk2NtKfYlcz8zlVVno3tHWf+9nq90c8Xn5jxkwVdsdiinx1hmRfDVTxOy
B/iuyNyuQTiyWrYrSBdKAqX7+AJl871UJ/Z8lAskQQMiiPbEMhYRD1g/Of4B
zqcU0x0taCECrqkKxCEgKBQoeHjgPUQY8YDNFOedC7R77rL47K5jbyFf49X6
e2fV9h/AQbnf\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 89},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->396495216]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightBrown"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->397844072],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2"},
    {"3", "4"}
   },
   GridBoxBackground->{"Columns" -> {{
        RGBColor[0.94, 0.91, 0.88]}}},
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{37, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->950480742]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell["\<\
Light brown can be affected by the colors of light sources in 3D:\
\>", "ExampleText",
 CellID->116670670],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"LightBrown", ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->165065652],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[0.94, 0.91, 0.88], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->542624402,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["Neutral lighting can be used to avoid this:", "ExampleText",
 CellID->278547368],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"LightBrown", ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->280509553],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[0.94, 0.91, 0.88], SphereBox[{0, 0, 0}]},
  Lighting->"Neutral"]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->139059441,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Brown",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Brown"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Darker",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Darker"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Blend",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Blend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->251671369]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LightBrown - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 53, 0.3588120}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LightBrown represents a light brown color in graphics or style \
specifications.", "synonyms" -> {"light brown"}, "title" -> "LightBrown", 
    "type" -> "Symbol", "uri" -> "ref/LightBrown"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5322, 161, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->269110531]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 36521, 842}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1654, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2277, 63, 1575, 37, 70, "ObjectNameGrid"],
Cell[3855, 102, 461, 14, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4353, 121, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4831, 138, 454, 18, 70, "Notes",
 CellID->5162]
}, Closed]],
Cell[CellGroupData[{
Cell[5322, 161, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->269110531],
Cell[CellGroupData[{
Cell[5707, 175, 148, 5, 70, "ExampleSection",
 CellID->535250402],
Cell[CellGroupData[{
Cell[5880, 184, 239, 7, 28, "Input",
 CellID->511908593],
Cell[6122, 193, 300, 9, 121, "Output",
 CellID->488995990]
}, Open  ]],
Cell[CellGroupData[{
Cell[6459, 207, 293, 9, 28, "Input",
 CellID->310096450],
Cell[6755, 218, 2228, 41, 110, "Output",
 Evaluatable->False,
 CellID->396495216]
}, Open  ]],
Cell[CellGroupData[{
Cell[9020, 264, 372, 12, 70, "Input",
 CellID->397844072],
Cell[9395, 278, 361, 13, 56, "Output",
 CellID->950480742]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9805, 297, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[10039, 306, 116, 3, 70, "ExampleText",
 CellID->116670670],
Cell[CellGroupData[{
Cell[10180, 313, 192, 6, 70, "Input",
 CellID->165065652],
Cell[10375, 321, 13991, 234, 129, 95, 2, "CachedBoxData", "BoxData", "Output",
 
 CellID->542624402]
}, Open  ]],
Cell[24381, 558, 86, 1, 70, "ExampleText",
 CellID->278547368],
Cell[CellGroupData[{
Cell[24492, 563, 269, 8, 70, "Input",
 CellID->280509553],
Cell[24764, 573, 8191, 140, 129, 118, 3, "CachedBoxData", "BoxData", "Output",
 
 CellID->139059441]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[33016, 720, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[33335, 731, 1658, 62, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[35030, 798, 299, 8, 70, "MoreAboutSection"],
Cell[35332, 808, 124, 3, 70, "MoreAbout",
 CellID->251671369]
}, Open  ]],
Cell[35471, 814, 27, 0, 70, "History"],
Cell[35501, 816, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

