(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     37158,        900]
NotebookOptionsPosition[     33872,        790]
NotebookOutlinePosition[     35130,        826]
CellTagsIndexPosition[     35045,        821]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Gray" :> Documentation`HelpLookup["paclet:ref/Gray"], 
          "ColorData" :> Documentation`HelpLookup["paclet:ref/ColorData"], 
          "Lighter" :> Documentation`HelpLookup["paclet:ref/Lighter"], 
          "Darker" :> Documentation`HelpLookup["paclet:ref/Darker"], "Blend" :> 
          Documentation`HelpLookup["paclet:ref/Blend"], "RGBColor" :> 
          Documentation`HelpLookup["paclet:ref/RGBColor"], "Style" :> 
          Documentation`HelpLookup["paclet:ref/Style"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Gray\"\>", 2->"\<\"ColorData\"\>", 
       3->"\<\"Lighter\"\>", 4->"\<\"Darker\"\>", 5->"\<\"Blend\"\>", 
       6->"\<\"RGBColor\"\>", 7->"\<\"Style\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Colors" :> Documentation`HelpLookup["paclet:guide/Colors"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Colors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["LightGray", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["LightGray",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LightGray"]], "InlineFormula"],
     " \[LineSeparator]represents a light gray color in graphics or style \
specifications."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LightGray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LightGray"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"], "[", 
   RowBox[{
    ButtonBox["Gray",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Gray"], ",", "0.7"}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->25861844]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->378677228],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->35039578],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"LightGray", ",", 
    RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
    RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->715944138],

Cell[BoxData[
 GraphicsBox[
  {GrayLevel[0.85], EdgeForm[GrayLevel[0]], DiskBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->561331450]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightGray"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->102808531],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WNtvlEUUn+633W5be9lWLIpoEbyLtygo2hhKaW1LawErEnxwgyTURDHQ
B03QBOPlQR/0wSZolBA0gRggwQsxqJEYMUpMY8SY+Wv0d+bMfDNzdnZhS+Km
3T1nvnO/zHdmpqrze/e8VJ2f210dHNtffWXv3O4Dg6P79mMpa1FKLeB/53IF
+F9A5n9Ba40HwXcbvjM8KhBGgDYfVQD4tqEoiycZfRU9rlSroDjIyxn/0Kfg
0Kbk7DD44uLfX535DX+qQF/ZpUv/2Ocrm7CPCGbN4xPHf9n38snxsU9Vcc8L
J1Q2MvwJ8COf/dSUvJBiu6GAcc/t+gKioKBkVgC89uqZbTNHT538dcUSZW81
FPD53XfOwtzvz/3RYVYuXPjzxbkvIR6Prs8zSXEuBb+hpBkXTfB9+ME51W1w
+F19/jikqeVGyoDlZmqswycKe6/BoR5GEPVATh3qmHZclqrP4dABXnVdkmsq
0EVc1wopyyLLmBpuhzKz8+cXgcM75q7RscXgnB0C+TkSg2gQ2J/kmiSd77/3
3Q1mHVFDFgjsS1JPGPzst7/DEgJXCJ2VyI8Jlw/r9Y0CryR1jAuZK4XO3iTX
ky7XKBgCbzY4nIFLBPYkucYMfvHiXztmj1FkB13kYSHiHXCRP6wD4URQCVwl
LOuOqjTcDdwOISt21OCfH/t5/sBpAlcb/M1D3yx89AOBXYa3VNNDbUKO3Hk2
u0jDL3in1ji/0KqEs1y5f3FrBmquUI+391bhzzVN2E/oiLY9iIjCWnW7iHhn
HXmtOr0jsDw0GRqcQJaHzCK/JL+RvFCOxDcZnPdZAu8UceiIKsH9SinDLivI
EvXDXSJLHVH1sU4ogBoC7zb4x4d/fOP1rwlsz6lDHRtFJaw1ONxHkAksN+Dy
/qwV/pYjy3pt9qhbigHO7wJohT8Ubflu6LZ0fVaO6SX7rJS0q1fgPQFOAvqT
eUMxoiRzu4PnlYRFrhJo51V14iPtkHifwIva1jUCT2CbjZSkM/pbw0pEzLlb
LmuD9KVH++oL99Ow91Ixq7UBRgc2kEypS+LSNul/eyDH/WbK7kicriusgDBj
bK30h/csX/Gh7hofSjmel21r0o4enfaAK853SmfC/kJU8wC40VRa05Cw/2Ed
d1UxysyQ0L9ex52cJXU8LnSsFzrSXI/peEd6VOgqJLk26HiX2yB0MRdNRIfM
m2nA1SN7xElmi3yVXn41qpGmudOr7WLVO/X/27K0WODT4qOccbPTzrfG4ZY1
7xZOd/3nFhfdywWpHtFx7jfmVNwL/k2/Tse15SmD/Rm2rhMShz2d9503P9s5
XmaSlsWqh7SOJsNNkaV8lvTvlQd1XPmeWrWFsfZV/oCTb/GROF42igUh936B
j0RWZULmfVpH09TmpA7m8pP/vQb374tGXD7uPCH4WXg0yVUUGbhHx/uO5/LT
nH/K85GfLs30bt7Q9ebt9Bwn5zbvhZnw+V3XcF6VdwklEbM7DO5PH1cn1783
eX7FrIiqpIyONyE3y9d9/dwm7K4nz83XMp5tIn48//sz50QDebV14fGyyNNq
p8eeyyajzLv5WkoxE3Gwp9wisjIZVZuZtoOOXyVivyWnDnUwlzx3+rP7VJKr
U1h2k+ZT+HQDam8Zn4hxpMHBhsDpyI8uETs+o/sTwFNJHV3WAnmiT1PzzYo/
V5mblaCvZyKLelzV2nsYeTOxNakj50L8yetlDkekCd+W5ApvcYiqX+Dbk1wV
ZxEspBhVBNfTkT+5TJtjthT7kr2fmc2rs969o6z//sBXurky5+YiZMFXbHYo
p2eMzHbBVztNyB4wd0X2dg3CkdWyW0G6UBIo3WeXKNvcS3Vhz0e5QBI0IIJo
TyxjEfGA9VOTR3A+pZjubEILEZiaaoc4BASFAgVPDB1GhBEP2Exx3rVEuw9e
FZ/bddwt5FtmtfbeWbX8BzUbBAI=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 89},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->286741203]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightGray"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->394069010],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2"},
    {"3", "4"}
   },
   GridBoxBackground->{"Columns" -> {{
        GrayLevel[0.85]}}},
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{37, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->359645876]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell["\<\
Light gray can be affected by the colors of light sources in 3D:\
\>", "ExampleText",
 CellID->116670670],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"LightGray", ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->165065652],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0.85], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->320458845,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["Neutral lighting can be used to avoid this:", "ExampleText",
 CellID->278547368],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"LightGray", ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->280509553],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0.85], SphereBox[{0, 0, 0}]},
  Lighting->"Neutral"]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->233423479,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Gray"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Darker",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Darker"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Blend",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Blend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->43195981]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LightGray - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 53, 5.2651876}", "context" -> "System`", 
    "keywords" -> {"color", "gray", "light gray", "background"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "LightGray represents a light gray color in graphics or style \
specifications.", "synonyms" -> {"light gray"}, "title" -> "LightGray", 
    "type" -> "Symbol", "uri" -> "ref/LightGray"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5310, 160, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->378677228]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 34902, 814}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1651, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2274, 63, 1574, 37, 70, "ObjectNameGrid"],
Cell[3851, 102, 458, 14, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4346, 121, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4824, 138, 449, 17, 70, "Notes",
 CellID->25861844]
}, Closed]],
Cell[CellGroupData[{
Cell[5310, 160, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->378677228],
Cell[CellGroupData[{
Cell[5695, 174, 147, 5, 70, "ExampleSection",
 CellID->35039578],
Cell[CellGroupData[{
Cell[5867, 183, 238, 7, 28, "Input",
 CellID->715944138],
Cell[6108, 192, 285, 8, 121, "Output",
 CellID->561331450]
}, Open  ]],
Cell[CellGroupData[{
Cell[6430, 205, 292, 9, 28, "Input",
 CellID->102808531],
Cell[6725, 216, 2244, 41, 110, "Output",
 Evaluatable->False,
 CellID->286741203]
}, Open  ]],
Cell[CellGroupData[{
Cell[9006, 262, 371, 12, 70, "Input",
 CellID->394069010],
Cell[9380, 276, 350, 13, 56, "Output",
 CellID->359645876]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9779, 295, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[10013, 304, 115, 3, 70, "ExampleText",
 CellID->116670670],
Cell[CellGroupData[{
Cell[10153, 311, 191, 6, 70, "Input",
 CellID->165065652],
Cell[10347, 319, 14204, 238, 129, 84, 2, "CachedBoxData", "BoxData", "Output",
 
 CellID->320458845]
}, Open  ]],
Cell[24566, 560, 86, 1, 70, "ExampleText",
 CellID->278547368],
Cell[CellGroupData[{
Cell[24677, 565, 268, 8, 70, "Input",
 CellID->280509553],
Cell[24948, 575, 6354, 110, 129, 107, 3, "CachedBoxData", "BoxData", "Output",
 
 CellID->233423479]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31363, 692, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[31682, 703, 1656, 62, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[33375, 770, 299, 8, 70, "MoreAboutSection"],
Cell[33677, 780, 123, 3, 70, "MoreAbout",
 CellID->43195981]
}, Open  ]],
Cell[33815, 786, 27, 0, 70, "History"],
Cell[33845, 788, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

