(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     38145,        917]
NotebookOptionsPosition[     34886,        807]
NotebookOutlinePosition[     36121,        843]
CellTagsIndexPosition[     36036,        838]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Purple" :> Documentation`HelpLookup["paclet:ref/Purple"], 
          "ColorData" :> Documentation`HelpLookup["paclet:ref/ColorData"], 
          "Lighter" :> Documentation`HelpLookup["paclet:ref/Lighter"], 
          "Darker" :> Documentation`HelpLookup["paclet:ref/Darker"], "Blend" :> 
          Documentation`HelpLookup["paclet:ref/Blend"], "RGBColor" :> 
          Documentation`HelpLookup["paclet:ref/RGBColor"], "Style" :> 
          Documentation`HelpLookup["paclet:ref/Style"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Purple\"\>", 2->"\<\"ColorData\"\>", 
       3->"\<\"Lighter\"\>", 4->"\<\"Darker\"\>", 5->"\<\"Blend\"\>", 
       6->"\<\"RGBColor\"\>", 7->"\<\"Style\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Colors" :> Documentation`HelpLookup["paclet:guide/Colors"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Colors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["LightPurple", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["LightPurple",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LightPurple"]], "InlineFormula"],
     " \[LineSeparator]represents a light purple color in graphics or style \
specifications."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LightPurple",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LightPurple"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"], "[", 
   RowBox[{
    ButtonBox["Purple",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Purple"], ",", "0.88"}], "]"}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->5162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->684691899],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->562168183],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"LightPurple", ",", 
    RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
    RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->511908593],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[0.94, 0.88, 0.94], EdgeForm[GrayLevel[0]], 
   DiskBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->422256070]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightPurple"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->310096450],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WPuL1FUUvzvfee62OzO72VpmrWnZy16UlrWE6z5yX+1ma4n90CCJUlGa
+Ev7Q0ISRBBESEL5QwbaDxZYUAoWSNGDQpBCEKEMJCiC739Qn3PuvXPvPXNn
dFZomZ05537P+3G/596p2u7tz71Y271ja21gbFft5e07tr4yMPrSLiwlHUqp
/fjfvFgB/hcQ/+9PL6R44H0X8J3gUYYwAvBLYAbgPqYoiicJfWUdrlROUMzr
5UT/0F/Gom3JeYrxi2f//ubLc/ioDH0lf53/xzxf2oZ9RDDHj48f/XXPzs/H
xw6q7PPbPlXJyND7wD85dLoteT7FRqaAcc8+8zFEQUGeVwDsffXE3OxHXx07
u2SBsmeZAj6/8+YpmHv61O+dvHLu54s7XzgG8Xh0bT2TFOe89+tLmrHRBN8H
736nehiH39tqRyFNLWYp/YZbU2MdPlHYK4xDPYwg6v46ta9j2nIZql6LQwd4
1TVRrilPF3FdLaQsCizT1HDbl5n88v0fwOGd5m7QMcm4zg6B+jkSg2gQ2Bfl
miCd77397XW8jqghCwT2RqnHGf/h5HlYQuASobMa+DFu82G8vl7g1aiODULm
UqGzEuV6zOYaBUPgjYzDGbhEYDnKNcb4b2f+3LLpMEV2wEYeFiLeHhf5o3Ug
nAgqgcuEZT1Blfq7gd0hZMWOMv7ZkTPze74gcDnjb+37+tCBHwnsZt58Qw8V
Yl3m4SM20vAL3qkV1i+0KuFarty/dGt6ai5Tj7P3ZuHPVW3YT+iw7UFEFNaq
lSLiXU3k5dL4jqDlocnQ4ASutJ2E/JL8VvJ8ORJfz7jeZwm8TcShM6gE+yul
DNmsIEvUD7eLLHUG1ad1QgHUEHgH40cO/vTGaycJLEUrfJ2ohFWMw30EmcBi
Cy7nzyrhbzGwrGKyR92S9fCi7S74Q9GW74YeQ9dr5HAvmWf5qF0VgZdFj/VF
84ZiREnW7faeVyMW2UqgnVc1iY+0Q+K9As/aukbgCSyYSEk61p/zKxEx191y
SRukL2Wv+vz91O+9WMwabYDRng0kU+qSuLRN+l/y5NjfRJkdSafrMivAz5i2
VvqTiIovtfIhX8frZZuL2lFu4kFOdEpXxP5MUPMAdKOpuKZBYf8DadhV2SAz
g0L/mjTs5CSq4xGhY43QEed6OA13pIeErkyUa20a7nJrhS7NRRPRXn4z9dt6
1B6Zqk3CKr30alAjbXPHV0ti1Tn1/9uysFjg0+GinOhmp51vRaw7CNfpbv48
je7fuiDVgyL364La9d/0q0VtOUpvf4atq4XEIUfnfNebn+kcJzNKq8Wq+21V
mslwfWCpPku698p9ovIdtSr4sXZVfq+o+uFor2SE3HsEPhxYlQiZd6cXgmlq
JKpDc7nJ/y7G3fuiFZeLu54Q3Cw8GuXKigzcmYb7zmjgT1481fORmy55euc3
dLN5Oz7HybnNecETvn7XtZxX5V1CXsTsVsbd6ePK5Lr3pp5fMSuiKimjG9qQ
m9TXXf3cIuxuJs/O1zKeBRE/Pf+7M+d4C3mNdeHwosjTcqvHnMsmgszb+VpK
4YnY21NuElmZCKqt03aP6fhlIvaT0YrWXPLc6c7uU1GuLmHZDak+hU+3oHaW
6RMxjjQ42BA4HfjRLWKnz+juBPB4VEe3sUCe6OPU+mbFnav4ZsXr65nAorKt
WnMPI28mZqM66lyIP3m9yOKINOFPRLkqNmswjqj6BL4xylW1FsFCilFVcD0Z
+FOXaXKsLcW+ZO5n5urV2ezeUdZ/n+cr3VzxuTkLWfAVmx3KaRPLLAm+xmlC
9gDfFZnbNQhHVot2BelCSaB0n16gbL6X6saej3KBJGhABNGeWMYi4gHrZyY/
xPmUYrq5DS1EwDVVgjgEBIUCBY8OHkCEEQ/YTHHeskC756+Iz+469hbydV5t
vHdWHf8BHuDZdw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 89},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->104827601]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightPurple"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->45569600],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2"},
    {"3", "4"}
   },
   GridBoxBackground->{"Columns" -> {{
        RGBColor[0.94, 0.88, 0.94]}}},
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{37, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->127603462]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell["\<\
Light purple can be affected by the colors of light sources in 3D:\
\>", "ExampleText",
 CellID->116670670],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"LightPurple", ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->165065652],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[0.94, 0.88, 0.94], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->84831827,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["Neutral lighting can be used to avoid this:", "ExampleText",
 CellID->278547368],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"LightPurple", ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->280509553],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[0.94, 0.88, 0.94], SphereBox[{0, 0, 0}]},
  Lighting->"Neutral"]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->197427608,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Purple",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Purple"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Darker",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Darker"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Blend",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Blend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->608087759]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LightPurple - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 53, 20.7343336}", "context" -> "System`", 
    "keywords" -> {"color"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LightPurple represents a light purple color in graphics or style \
specifications.", "synonyms" -> {"light purple"}, "title" -> "LightPurple", 
    "type" -> "Symbol", "uri" -> "ref/LightPurple"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5333, 161, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->684691899]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 35893, 831}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1657, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2280, 63, 1576, 37, 70, "ObjectNameGrid"],
Cell[3859, 102, 464, 14, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4360, 121, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4838, 138, 458, 18, 70, "Notes",
 CellID->5162]
}, Closed]],
Cell[CellGroupData[{
Cell[5333, 161, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->684691899],
Cell[CellGroupData[{
Cell[5718, 175, 148, 5, 70, "ExampleSection",
 CellID->562168183],
Cell[CellGroupData[{
Cell[5891, 184, 240, 7, 28, "Input",
 CellID->511908593],
Cell[6134, 193, 300, 9, 121, "Output",
 CellID->422256070]
}, Open  ]],
Cell[CellGroupData[{
Cell[6471, 207, 294, 9, 28, "Input",
 CellID->310096450],
Cell[6768, 218, 2232, 41, 110, "Output",
 Evaluatable->False,
 CellID->104827601]
}, Open  ]],
Cell[CellGroupData[{
Cell[9037, 264, 372, 12, 70, "Input",
 CellID->45569600],
Cell[9412, 278, 361, 13, 56, "Output",
 CellID->127603462]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9822, 297, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[10056, 306, 117, 3, 70, "ExampleText",
 CellID->116670670],
Cell[CellGroupData[{
Cell[10198, 313, 193, 6, 70, "Input",
 CellID->165065652],
Cell[10394, 321, 13754, 230, 129, 95, 2, "CachedBoxData", "BoxData", "Output",
 
 CellID->84831827]
}, Open  ]],
Cell[24163, 554, 86, 1, 70, "ExampleText",
 CellID->278547368],
Cell[CellGroupData[{
Cell[24274, 559, 270, 8, 70, "Input",
 CellID->280509553],
Cell[24547, 569, 7764, 133, 129, 118, 3, "CachedBoxData", "BoxData", "Output",
 
 CellID->197427608]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[32372, 709, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[32691, 720, 1660, 62, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[34388, 787, 299, 8, 70, "MoreAboutSection"],
Cell[34690, 797, 124, 3, 70, "MoreAbout",
 CellID->608087759]
}, Open  ]],
Cell[34829, 803, 27, 0, 70, "History"],
Cell[34859, 805, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

