(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     38230,        919]
NotebookOptionsPosition[     34989,        809]
NotebookOutlinePosition[     36206,        845]
CellTagsIndexPosition[     36121,        840]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Red" :> Documentation`HelpLookup["paclet:ref/Red"], 
          "ColorData" :> Documentation`HelpLookup["paclet:ref/ColorData"], 
          "Lighter" :> Documentation`HelpLookup["paclet:ref/Lighter"], 
          "Darker" :> Documentation`HelpLookup["paclet:ref/Darker"], "Blend" :> 
          Documentation`HelpLookup["paclet:ref/Blend"], "RGBColor" :> 
          Documentation`HelpLookup["paclet:ref/RGBColor"], "Style" :> 
          Documentation`HelpLookup["paclet:ref/Style"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Red\"\>", 2->"\<\"ColorData\"\>", 
       3->"\<\"Lighter\"\>", 4->"\<\"Darker\"\>", 5->"\<\"Blend\"\>", 
       6->"\<\"RGBColor\"\>", 7->"\<\"Style\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Colors" :> Documentation`HelpLookup["paclet:guide/Colors"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Colors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["LightRed", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["LightRed",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LightRed"]], "InlineFormula"],
     " \[LineSeparator]represents a light red color in graphics or style \
specifications."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LightRed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LightRed"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"], "[", 
   RowBox[{
    ButtonBox["Red",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Red"], ",", "0.85"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->745270053],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->57359694],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"LightRed", ",", 
    RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
    RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->511908593],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.85, 0.85], EdgeForm[GrayLevel[0]], 
   DiskBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->206773281]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightRed"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->310096450],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WFtonEUUnuy/18Rks4k11VpNbbXe6g1ttRqkaS4228TEGmspgiEKzYNW
2gqC9SHg5UEEQSwE0SKlUCmltGhLKRWlqFSRIFok+OSTTz755NPvd87M7Myc
nd12UzBsds+Z/9wv85+Z8ZkDe15+ZebA3OxM/+i+mdf2zM3u7x/Zuw9LSZtS
6hD+d61UgFNA/H8oXVrCA++7gO8EjzKEEYBfAjMA32GKoniS0FfW4UrlBMVB
vZzoH/rLWLQlOTsZ/2fx8uLpS/ioDH0l//72u3m+ugX7iGCaH1889t2br56o
jn6qsntf+kIlw4OfAD/72TctyfMpdjAFjJvdfRSioCDPKwDee+P0zsnPL534
YdUyZU8xBXxeePcszP3j/M/tvPLX97+8Pncc4vHoxlomKc5579eXNGmjCb6j
H55XXYzD77kXj0GaWslS+gy3psY6fKKwdzMO9TCCqPtq1L6OCctlqHosDh3g
VTdEucY9XcR1vZCyIrBMU8NtX2by57eLwOGd5q7TsZ1xnR0C9XMkBtEgsDfK
VSWdh98/dxOvI2rIAoE9Ueoxxi+f+RGWELhK6KwEfozZfBivbxZ4Japjm5C5
WujsjnI9ZXONgiHwVsbhDFwisBzlGmX8759+fWH6CEW230YeFiLeHhf5o3Ug
nAgqgWuEZV1Blfq7gd0hZMWOMH7hyMX5/ScJXMv4R/NfHf/4AoGdzJuv66FC
rMs8fNhGGn7BO7XO+oVWJVzLlfuXbk1PzVXqcfbeLvy5rgX7CR2yPYiIwlq1
XkS8o4G8XBrfEbQ8NBkanMD1tpOQX5LfTJ4vR+JbGdf7LIF3iTi0B5Vgf6WU
QZsVZIn64W6Rpfag+rROKIAaAu9h/NTC1x+89SWBpWiFbxGVsIFxuI8gE1hs
wuX82SD8LQaWdZvsUbdkPbxouwv+ULTlu6HL0PUYOdxL5lk+ale3wMuix3qj
eUMxoiRrdnvPKxGLbCXQzqsaxEfaIfEegWdtXSPwBBZMpCQd68/5lYiY6265
og3Sl7JXff5+6vdeLGb1NsBozwaSKXVJXNom/S95cuxvosyOpNN1lRXgZ0xb
K/1JRMWXmvmQr+G1ss1F7Sg38CAnOqUjYn8mqHkAutFUXNOAsP+RNOyqbJCZ
AaF/Uxp2chLV8YTQsUnoiHM9noY70mNCVybKtTkNd7nNQpfmoolont9MfbYe
tUemapOwSq+8GtRIy9zx1ZJYdU79/7YsLxb4tLkoJ7rZaedbF+sOwnW6Gz9P
o/u3Lkj1qMj9lqB2/Tf9RlFbjtLbn2HrRiFx0NE53/XmZzrHyYzSarHqYVuV
ZjLcGliqz5LuvfKQqHxHrQp+rF2VPyiqfijaKxkh9wGBDwVWJULm/elSME0N
R3VoLjf538e4e18043Jx1xOCm4VHolxZkYF703DfGQn8yYunej5y0yVP7/yG
bjRvx+c4Obc5L3jC1++6pvOqvEvIi5jdybg7fVybXPfe1PMrZkVUJWV0Wwty
k9q6q587hN2N5Nn5WsazIOKn53935hxrIq++LhxeFHlaa/WYc1k1yLydr6UU
noi9PeU2kZVqUG3ttntMx68Rsd8erWjNJc+d7uw+HuXqEJbdkupT+EQTameZ
PhHjSIODDYETgR+dInb6jO5OAE9HdXQaC+SJPk6tb1bcuYpvVry+ngwsKtuq
Nfcw8mZiKqqjxoX4k9crLI5IE/5MlMu/xSGqXoHviHJVrEWwkGJUEVzPBv7U
ZJoca0uxL5n7meladTa6d5T13+v5SjdXfG7OQhZ8xWaHcnqOZZYEX/00IXuA
74rM7RqEI6tFu4J0oSRQus8vUzbfS3Viz0e5QBI0IIJoTyxjEfGA9VPVwzif
Ukx3taCFCLimShCHgKBQoODJgQVEGPGAzRTn3cu0++A18dldx95Cvs2r9ffO
qu0/gX+aTw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 89},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->376124596]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightRed"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->285368151],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2"},
    {"3", "4"}
   },
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 0.85, 0.85]}}},
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{37, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->33334616]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell["\<\
Light red can be affected by the colors of light sources in 3D:\
\>", "ExampleText",
 CellID->454548785],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"LightRed", ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->165065652],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 0.85, 0.85], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->315102646,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["Neutral lighting can be used to avoid this:", "ExampleText",
 CellID->278547368],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"LightRed", ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->280509553],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 0.85, 0.85], SphereBox[{0, 0, 0}]},
  Lighting->"Neutral"]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->292438465,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Red",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Red"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Darker",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Darker"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Blend",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Blend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->289910539]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LightRed - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 53, 21.2187210}", "context" -> "System`", 
    "keywords" -> {"color"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LightRed represents a light red color in graphics or style \
specifications.", "synonyms" -> {"light red"}, "title" -> "LightRed", "type" -> 
    "Symbol", "uri" -> "ref/LightRed"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5297, 160, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->745270053]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 35978, 833}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1648, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2271, 63, 1573, 37, 70, "ObjectNameGrid"],
Cell[3847, 102, 455, 14, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4339, 121, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4817, 138, 443, 17, 70, "Notes",
 CellID->5162]
}, Closed]],
Cell[CellGroupData[{
Cell[5297, 160, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->745270053],
Cell[CellGroupData[{
Cell[5682, 174, 147, 5, 70, "ExampleSection",
 CellID->57359694],
Cell[CellGroupData[{
Cell[5854, 183, 237, 7, 28, "Input",
 CellID->511908593],
Cell[6094, 192, 297, 9, 121, "Output",
 CellID->206773281]
}, Open  ]],
Cell[CellGroupData[{
Cell[6428, 206, 291, 9, 28, "Input",
 CellID->310096450],
Cell[6722, 217, 2228, 41, 110, "Output",
 Evaluatable->False,
 CellID->376124596]
}, Open  ]],
Cell[CellGroupData[{
Cell[8987, 263, 370, 12, 70, "Input",
 CellID->285368151],
Cell[9360, 277, 357, 13, 56, "Output",
 CellID->33334616]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9766, 296, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[10000, 305, 114, 3, 70, "ExampleText",
 CellID->454548785],
Cell[CellGroupData[{
Cell[10139, 312, 190, 6, 70, "Input",
 CellID->165065652],
Cell[10332, 320, 13931, 233, 129, 92, 2, "CachedBoxData", "BoxData", "Output",
 
 CellID->315102646]
}, Open  ]],
Cell[24278, 556, 86, 1, 70, "ExampleText",
 CellID->278547368],
Cell[CellGroupData[{
Cell[24389, 561, 267, 8, 70, "Input",
 CellID->280509553],
Cell[24659, 571, 7761, 133, 129, 115, 3, "CachedBoxData", "BoxData", "Output",
 
 CellID->292438465]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[32481, 711, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[32800, 722, 1654, 62, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[34491, 789, 299, 8, 70, "MoreAboutSection"],
Cell[34793, 799, 124, 3, 70, "MoreAbout",
 CellID->289910539]
}, Open  ]],
Cell[34932, 805, 27, 0, 70, "History"],
Cell[34962, 807, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

