(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8242,        297]
NotebookOptionsPosition[      6264,        235]
NotebookOutlinePosition[      7381,        265]
CellTagsIndexPosition[      7338,        262]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["OBSOLETE MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Lighting" :> 
         Documentation`HelpLookup["paclet:ref/Lighting"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Lighting\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LightSources", "ObjectName",
 CellID->21548],

Cell[TextData[{
 "As of Version 6, ",
 Cell[BoxData["LightSources"], "InlineFormula"],
 " has been superseded by settings for ",
 Cell[BoxData[
  ButtonBox["Lighting",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Lighting"]], "InlineFormula"],
 ". "
}], "ObsolescenceNote",
 CellID->6483],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["LightSources"], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Graphics3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
     " and related functions that specifies the properties of point light \
sources for simulated illumination. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27595]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The basic form is ",
 Cell[BoxData[
  RowBox[{"LightSources", "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 ", where the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["s", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are the specifications for each light source. "
}], "Notes",
 CellID->4041],

Cell[TextData[{
 "Each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["s", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " has the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["direction", "TI"], ",", 
    StyleBox["color", "TI"]}], "}"}]], "InlineFormula"],
 ". The direction is specified as ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["z", "TI"]}], "}"}]], "InlineFormula"],
 ", where the components are taken with respect to the final display area. \
The ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " are horizontal and vertical in the plane of the display; ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " is orthogonal to the display. Positive ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " is in front. Only the relative magnitude of the components is relevant; \
the overall normalization of the vector is ignored. The color can be \
specified by ",
 Cell[BoxData[
  ButtonBox["GrayLevel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GrayLevel"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Hue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hue"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3602],

Cell["\<\
Simulated illumination determines the shading of surfaces in \
three\[Hyphen]dimensional pictures. \
\>", "Notes",
 CellID->24350],

Cell["\<\
The shading of a particular surface element is computed as a sum of \
contributions from point light sources, plus a contribution from ambient \
light. \
\>", "Notes",
 CellID->10291],

Cell[TextData[{
 "Surface properties are specified by ",
 Cell[BoxData[
  ButtonBox["Specularity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Specularity",
   ButtonNote->"ObsLink: SurfaceColor -> Specularity (Glow)"]], 
  "InlineFormula"],
 " directives. "
}], "Notes",
 CellID->30836],

Cell[TextData[{
 "Light reflection properties assumed for surfaces are described in the notes \
for ",
 Cell[BoxData[
  ButtonBox["Specularity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Specularity",
   ButtonNote->"ObsLink: SurfaceColor -> Specularity (Glow)"]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->9374]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23199],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Lighting",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Lighting",
   ButtonNote->"ObsLink: AmbientLight -> Lighting"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->19668]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LightSources - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 53, 21.6874830}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Obsolete Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "ObsoleteFlag", "summary" -> 
    "LightSources is an option for Graphics3D and related functions that \
specifies the properties of point light sources for simulated illumination. ",
     "synonyms" -> {"light sources"}, "title" -> "LightSources", "type" -> 
    "Symbol", "uri" -> "ref/LightSources"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 558, 14, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1181, 41, 50, 1, 70, "ObjectName",
 CellID->21548],
Cell[1234, 44, 292, 10, 70, "ObsolescenceNote",
 CellID->6483],
Cell[1529, 56, 572, 16, 70, "Usage",
 CellID->27595]
}, Open  ]],
Cell[CellGroupData[{
Cell[2138, 77, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2616, 94, 540, 20, 70, "Notes",
 CellID->4041],
Cell[3159, 116, 1471, 51, 70, "Notes",
 CellID->3602],
Cell[4633, 169, 140, 4, 70, "Notes",
 CellID->24350],
Cell[4776, 175, 193, 5, 70, "Notes",
 CellID->10291],
Cell[4972, 182, 292, 10, 70, "Notes",
 CellID->30836],
Cell[5267, 194, 326, 11, 70, "Notes",
 CellID->9374]
}, Closed]],
Cell[CellGroupData[{
Cell[5630, 210, 311, 9, 70, "SeeAlsoSection",
 CellID->23199],
Cell[5944, 221, 248, 7, 70, "SeeAlso",
 CellID->19668]
}, Open  ]],
Cell[6207, 231, 27, 0, 70, "History"],
Cell[6237, 233, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

