(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     38134,        917]
NotebookOptionsPosition[     34874,        807]
NotebookOutlinePosition[     36109,        843]
CellTagsIndexPosition[     36024,        838]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Yellow" :> Documentation`HelpLookup["paclet:ref/Yellow"], 
          "ColorData" :> Documentation`HelpLookup["paclet:ref/ColorData"], 
          "Lighter" :> Documentation`HelpLookup["paclet:ref/Lighter"], 
          "Darker" :> Documentation`HelpLookup["paclet:ref/Darker"], "Blend" :> 
          Documentation`HelpLookup["paclet:ref/Blend"], "RGBColor" :> 
          Documentation`HelpLookup["paclet:ref/RGBColor"], "Style" :> 
          Documentation`HelpLookup["paclet:ref/Style"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Yellow\"\>", 2->"\<\"ColorData\"\>", 
       3->"\<\"Lighter\"\>", 4->"\<\"Darker\"\>", 5->"\<\"Blend\"\>", 
       6->"\<\"RGBColor\"\>", 7->"\<\"Style\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Colors" :> Documentation`HelpLookup["paclet:guide/Colors"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Colors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["LightYellow", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["LightYellow",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LightYellow"]], "InlineFormula"],
     " \[LineSeparator]represents a light yellow color in graphics or style \
specifications."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LightYellow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LightYellow"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"], "[", 
   RowBox[{
    ButtonBox["Yellow",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Yellow"], ",", "0.85"}], "]"}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->5162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->256519740],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->552836037],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"LightYellow", ",", 
    RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
    RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->511908593],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 1, 0.85], EdgeForm[GrayLevel[0]], DiskBox[{0, 0}]}]], "Output",\

 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->343414480]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightYellow"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->476458664],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WEtslUUUnt7/Plvb29uKRREtgoIPfEVB0cZAH9iWFioWJMRFbUzahWKw
bpSFJD42utGESIwSoyQoMT6iEqMYIzGKiRKjxKgrVqxYsWL1+50zM//MnDv3
wi2Jze2958x/3o/5z8zEzMLck0/NLMzPzvRv3jvzzNz87LP9I3v2YilpU0od
wP+upQpwCoj/D6Tp33jgfZfwneBRjjAC8EtgDuDLTFEWTxL6yjtcqYKg2KeX
E/1DfzmLtiRnJ+Pnz58+9dtJfFSOvpILF/4yz5e3YB8RTPPjEz/8+MLzH4+P
vqPye57+UCXDg28DP/bV9y3J8ym2MwWMm33iMERBQZFXALz6yuc7p987+fNP
yxYpe4op4PPBt47B3H//+bWdV86e/f25haMQj0dXZ5mkOBe9X1/SNhtN8B3+
4BvVxTj8np87AmlqKUvpM9yaGuvwicLezTjUwwii7suofR2TlstQ9VgcOsCr
ropyTXi6iOtKIWVJYJmmhtu+zOTMmVPA4Z3mrtOxhXGdHQL1cyQG0SCwN8o1
TjoPvfv1NbyOqCELBPZEqccYP/3nL7CEwGVCZy3wY8zmw3h9rcBrUR2jQuZy
obM7yvWwzTUKhsDrGYczcInAapRrM+Pnzv3x+O73KbL9NvKwEPH2uMgfrQPh
RFAJXCEs6wqq1N8N7A4hK3aE8ePfntj/4icErmT8zTe+PPrRcQI7mbdY10Ol
WJd5+LCNNPyCd2qV9QutSriWK/cv3ZqemkvU4+y9UfhzRQv2EzpkexARhbVq
tYh4RwN5hTS+I2h5aDI0OIGrbSchvyS/mTxfjsQHGdf7LIE3izi0B5Vgf6WU
TTYryBL1wy0iS+1B9WmdUAA1BN7K+Geffvf6a18QWIlW+EZRCWsZh/sIMoHl
JlzOn7XC33JgWbfJHnVL3sPLtrvgD0Vbvhu6DF2PkcO9ZJ4Vo3Z1C7wqeqw3
mjcUI0oys9t7XotYZCuBdl7VID7SDon3CDxv6xqBJ7BkIiXpWH/Br0TEXHfL
RW2QvlS96vP3U7/3YjGrtwFGezaQTKlL4tI26X/Fk2N/E2V2JJ2uS6wAP2Pa
WulPIiq+0syHYoZnZVuI2lFt4EFBdEpHxP5cUPMAdKOpuKYBYf+9adhV+SAz
A0L/+jTs5CSq40GhY73QEed6IA13pPuFrlyUa0Ma7nIbhC7NRRPRfn4z9dl6
1B6Zqk3CKr34alAjLXPHVyti1Tn1/9uyuFjg0+ainOhmp51vVaw7CNfpbvw8
je7fuiDVfSL3G4Pa9d/060RtOUpvf4at64TETY7O+a43P9M5TmaUVotV99iq
NJPhYGCpPku698rdovIdtSr5sXZVfpeo+qFor+SE3DsFPhRYlQiZd6RpME0N
R3VoLjf53864e18043Jx1xOCm4VHolx5kYHb0nDfGQn8KYqnej5y0yVP7/yG
bjRvx+c4Obc5L3jC1++6pvOqvEsoipitYdydPi5Prntv6vkVsyKqkjI62oLc
JFt39XOTsLuRPDtfy3iWRPz0/O/OnGNN5NXXhcPLIk8rrR5zLhsPMm/naymF
J2JvT7lBZGU8qLZ22z2m41eI2G+JVrTmkudOd3afiHJ1CMuuS/UpfLIJtbNM
n4hxpMHBhsDJwI9OETt9RncngK1RHZ3GAnmij1PrmxV3ruKbFa+vtwUWVW3V
mnsYeTMxFdWRcSH+5PUSiyPShD8S5fJvcYiqV+Dbo1w1axEspBjVBNejgT+Z
TJNjbSn2JXM/M51VZ6N7R1n/vZ6vdHPF5+Y8ZMFXbHYopx0ssyL46qcJ2QN8
V2Ru1yAcWS3bFaQLJYHSfWyRsvleqhN7PsoFkqABEUR7YhmLiAesn9p6COdT
iumuFrQQAddUBeIQEBQKFDw0cBARRjxgM8V59yLt3ndZfHbXsbeQL/Fq/b2z
avsPN5Ywqw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 89},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->267243067]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightYellow"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->443157008],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2"},
    {"3", "4"}
   },
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 0.85]}}},
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{37, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->602524850]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell["\<\
Light yellow can be affected by the colors of light sources in 3D:\
\>", "ExampleText",
 CellID->116670670],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"LightYellow", ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->165065652],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 1, 0.85], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->70942007,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["To avoid this, neutral lighting can be used:", "ExampleText",
 CellID->278547368],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"LightYellow", ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->280509553],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 1, 0.85], SphereBox[{0, 0, 0}]},
  Lighting->"Neutral"]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->635835664,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Yellow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Yellow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Darker",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Darker"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Blend",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Blend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->560948517]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LightYellow - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 53, 21.8593624}", "context" -> "System`", 
    "keywords" -> {"color"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LightYellow represents a light yellow color in graphics or style \
specifications.", "synonyms" -> {"light yellow"}, "title" -> "LightYellow", 
    "type" -> "Symbol", "uri" -> "ref/LightYellow"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5333, 161, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->256519740]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 35881, 831}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1657, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2280, 63, 1576, 37, 70, "ObjectNameGrid"],
Cell[3859, 102, 464, 14, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4360, 121, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4838, 138, 458, 18, 70, "Notes",
 CellID->5162]
}, Closed]],
Cell[CellGroupData[{
Cell[5333, 161, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->256519740],
Cell[CellGroupData[{
Cell[5718, 175, 148, 5, 70, "ExampleSection",
 CellID->552836037],
Cell[CellGroupData[{
Cell[5891, 184, 240, 7, 28, "Input",
 CellID->511908593],
Cell[6134, 193, 292, 9, 121, "Output",
 CellID->343414480]
}, Open  ]],
Cell[CellGroupData[{
Cell[6463, 207, 294, 9, 28, "Input",
 CellID->476458664],
Cell[6760, 218, 2228, 41, 110, "Output",
 Evaluatable->False,
 CellID->267243067]
}, Open  ]],
Cell[CellGroupData[{
Cell[9025, 264, 373, 12, 70, "Input",
 CellID->443157008],
Cell[9401, 278, 355, 13, 56, "Output",
 CellID->602524850]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9805, 297, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[10039, 306, 117, 3, 70, "ExampleText",
 CellID->116670670],
Cell[CellGroupData[{
Cell[10181, 313, 193, 6, 70, "Input",
 CellID->165065652],
Cell[10377, 321, 13862, 232, 129, 89, 2, "CachedBoxData", "BoxData", "Output",
 
 CellID->70942007]
}, Open  ]],
Cell[24254, 556, 87, 1, 70, "ExampleText",
 CellID->278547368],
Cell[CellGroupData[{
Cell[24366, 561, 270, 8, 70, "Input",
 CellID->280509553],
Cell[24639, 571, 7660, 131, 129, 112, 3, "CachedBoxData", "BoxData", "Output",
 
 CellID->635835664]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[32360, 709, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[32679, 720, 1660, 62, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[34376, 787, 299, 8, 70, "MoreAboutSection"],
Cell[34678, 797, 124, 3, 70, "MoreAbout",
 CellID->560948517]
}, Open  ]],
Cell[34817, 803, 27, 0, 70, "History"],
Cell[34847, 805, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

