(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    382650,       7128]
NotebookOptionsPosition[    374832,       6857]
NotebookOutlinePosition[    376152,       6894]
CellTagsIndexPosition[    376065,       6889]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Darker" :> Documentation`HelpLookup["paclet:ref/Darker"], 
          "Blend" :> Documentation`HelpLookup["paclet:ref/Blend"], 
          "GrayLevel" :> Documentation`HelpLookup["paclet:ref/GrayLevel"], 
          "ColorSlider" :> 
          Documentation`HelpLookup["paclet:ref/ColorSlider"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Darker\"\>", 2->"\<\"Blend\"\>", 
       3->"\<\"GrayLevel\"\>", 4->"\<\"ColorSlider\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Colors" :> Documentation`HelpLookup["paclet:guide/Colors"], 
          "Graphics Options & Styling" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsOptionsAndStyling"], 
          "New in 6.0: Graphics Primitives & Directives" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Colors\"\>", 
       2->"\<\"Graphics Options & Styling\"\>", 
       3->"\<\"New in 6.0: Graphics Primitives & Directives\"\>", 
       4->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Lighter", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Lighter",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Lighter"], "[", 
       StyleBox["color", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a lighter version of the specified color. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Lighter",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Lighter"], "[", 
       RowBox[{
        StyleBox["color", "TI"], ",", 
        StyleBox["f", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a version of the specified color lightened \
by a fraction ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->11980]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"], "[", 
   RowBox[{
    StyleBox["color", "TI"], ",", "1"}], "]"}]], "InlineFormula"],
 " gives white. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->119480312]
}], "Notes",
 CellID->27452],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"], "[", 
   RowBox[{
    StyleBox["color", "TI"], ",", "0"}], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  StyleBox["color", "TI"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->605430022]
}], "Notes",
 CellID->29936],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"], "[", 
   StyleBox["color", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"], "[", 
   RowBox[{
    StyleBox["color", "TI"], ",", 
    RowBox[{"1", "/", "3"}]}], "]"}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->147092355]
}], "Notes",
 CellID->39054001],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"], "[", 
   RowBox[{
    StyleBox["color", "TI"], ",", 
    StyleBox["f", "TI"]}], "]"}]], "InlineFormula"],
 " for values of ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " outside the range ",
 Cell[BoxData["0"], "InlineFormula"],
 " to ",
 Cell[BoxData["1"], "InlineFormula"],
 " are clipped. "
}], "Notes",
 CellID->741047295],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["col", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["col", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " gives lighter versions of each of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["col", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->69210275]
}], "Notes",
 CellID->142410365]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->280035682],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->762780864],

Cell["Lighter version of colors:", "ExampleText",
 CellID->767779510],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Lighter", "[", "Red", "]"}], ",", 
    RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->436072821],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 
    NCache[
     Rational[1, 3], 0.3333333333333333], 
    NCache[
     Rational[1, 3], 0.3333333333333333]], DiskBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->41773818]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Lighter", "[", "Green", "]"}], ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->242052465],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[
    NCache[
     Rational[1, 3], 0.3333333333333333], 1, 
    NCache[
     Rational[1, 3], 0.3333333333333333]], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->487860516,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->903623061],

Cell["\<\
Specify how much the color should be lightened by using a fraction:\
\>", "ExampleText",
 CellID->97439614],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Lighter", "[", 
       RowBox[{"Blue", ",", "#"}], "]"}], ",", 
      RowBox[{"Rectangle", "[", "]"}]}], "}"}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{".1", ",", ".5", ",", ".8"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->814434644],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[0.1, 0.1, 1.], RectangleBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[0.5, 0.5, 1.], RectangleBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[0.8, 0.8, 1.], RectangleBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{341, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->86200806]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->461483603],

Cell["With a lightening fraction of zero the color is unchanged:", \
"ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->605430022],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Lighter", "[", 
   RowBox[{"Blue", ",", "0"}], "]"}], "\[Equal]", "Blue"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->120341336],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->69847403]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Lighter", "[", 
       RowBox[{"Blue", ",", "0"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2465115],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[0, 0, 1], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[0, 0, 1], DiskBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{230, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->65841739]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->99167612],

Cell["With a lightening fraction of one the color becomes white:", \
"ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->119480312],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Lighter", "[", 
   RowBox[{
    RowBox[{"RGBColor", "[", 
     RowBox[{"0", ",", "0", ",", "1"}], "]"}], ",", "1"}], "]"}], "\[Equal]", 
  
  RowBox[{"RGBColor", "[", 
   RowBox[{"1", ",", "1", ",", "1"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->212616857],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->311047381]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Lighter", "[", 
        RowBox[{"Blue", ",", "1"}], "]"}], ",", 
       RowBox[{"Disk", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Background", "\[Rule]", "Black"}]}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"White", ",", 
       RowBox[{"Disk", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Background", "\[Rule]", "Black"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->144742854],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[1, 1, 1], DiskBox[{0, 0}]},
    Background->GrayLevel[0]], ",", 
   GraphicsBox[
    {GrayLevel[1], DiskBox[{0, 0}]},
    Background->GrayLevel[0]]}], "}"}]], "Output",
 ImageSize->{230, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->108477867]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->392984429],

Cell[TextData[{
 "The default lightening fraction is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "3"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->147092355],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Lighter", "[", "Red", "]"}], "==", 
  RowBox[{"Lighter", "[", 
   RowBox[{"Red", ",", 
    RowBox[{"1", "/", "3"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->72536915],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->46677077]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Lighter", "[", "Red", "]"}], ",", 
      RowBox[{"Rectangle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Lighter", "[", 
       RowBox[{"Red", ",", 
        RowBox[{"1", "/", "3"}]}], "]"}], ",", 
      RowBox[{"Rectangle", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->402151439],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwPALiNAkGIPs/kAXG
j/7/B9KYJCeQjP8fGioIpblGRUdFR0VJEmUBkkzATMaMJssMFWcFqwLxGJhB
eREMMFSzoskzDXFd6Ko5yTYFFIZcZOlmQxPnwGsKE5ooC5IpIDdw4jCVEawb
4giwIAMbWsixA2lQwQxSyYjXLkG8dgyGeB3VRbwu4kqGwVCGjYqOig4NUcw2
LAMjABq5baU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{226, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->4958311]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->221324128],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Lighter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Lighter"]], "InlineFormula"],
 " automatically threads over colors:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->69210275],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Lighter", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}], ",", 
   RowBox[{"1", "/", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->917995613],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"RGBColor", "[", 
    RowBox[{"1", ",", 
     FractionBox["1", "2"], ",", 
     FractionBox["1", "2"]}], "]"}], ",", 
   RowBox[{"RGBColor", "[", 
    RowBox[{
     FractionBox["1", "2"], ",", "1", ",", 
     FractionBox["1", "2"]}], "]"}], ",", 
   RowBox[{"RGBColor", "[", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     FractionBox["1", "2"], ",", "1"}], "]"}]}], "}"}]], "Output",
 ImageSize->{406, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->424864]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->142022708],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Lighter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Lighter"]], "InlineFormula"],
 " to construct ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " for plots:"
}], "ExampleText",
 CellID->659069737],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"y", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"x", " ", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Lighter", "[", 
       RowBox[{"Orange", ",", "#3"}], "]"}], "&"}], ")"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "40"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->138856842],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->339915852]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], 
    RowBox[{"Sin", "[", "y", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Lighter", "[", 
       RowBox[{"Orange", ",", "#"}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->275027965],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyF28+qZcUVx/GrdkxMVPoRktAJvsXtQYj4Z5RHCGTiv4Z+hAwdqHRCBhlm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   "], {{
     {GrayLevel[0.8], EdgeForm[None], 
      GraphicsGroupBox[PolygonBox[CompressedData["
1:eJxNnHf8l1Mbx+/7/pItZbSElmRWEhJSRHYhK6NskdRTxmOkjITsHZqa9pZR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        "]]]}, {}, {}, {}}, {}},
   VertexColors->CompressedData["
1:eJy1fAlUzd33vlKmkrE0kQrNpiK96Ih4Gwy9pAghQjRJpMxTMiQqIRmi0iBj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    "]],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-4, 4}, {-4, 4}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->331098664,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->412805249],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Darker",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Darker"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Lighter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Lighter"]], "InlineFormula"],
 " values of a particular hue as a color function: "
}], "ExampleText",
 CellID->367264277],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], 
    RowBox[{"Sin", "[", "y", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"#", "<", "0"}], ",", 
        RowBox[{"Darker", "[", 
         RowBox[{"Blue", ",", 
          RowBox[{"Abs", "[", "#", "]"}]}], "]"}], ",", 
        RowBox[{"Lighter", "[", 
         RowBox[{"Red", ",", "#"}], "]"}]}], "]"}], "&"}], ")"}]}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37057173],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJzEnXd8V8Xy9xOSEAIBEtKIigXFgmLvouegFOFiReVaUGx4LYCKqChe5IoK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   "], {{{}, 
     {RGBColor[0., 0., 0.09999999999999998], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHtw1FcVx++mYbMLu78NC9kl2Veo2lL/kMyIj1oVtY4BCY90WgkFEgqF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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllllslWUQhj+gyznQnlbacmrP+f/TsutNm1g1xgUVY6u4Ek2wBFoqi21i
UVFA40YVpIJQtoCISmI06oXLha3FBfcrCyRiAgqJRi9QKJYKshTU5817Mck3
/8w3M9/MOzN/TevimR0jQwiboTxo2cUhLIc2JkNoGRFCZxzC09Db+SE0lISw
pSKE4SiE3akQ3uPbec7noBn5/rZ1XAhzoTLuP1gYQn0uhEb4HwpCKOTbPGzN
gbrRz2Evh3wK8k3Ib4avhm8vD+H2YvzAv58OoQN5jrubEyG04j8qI0Zsz8fG
WXyfgm7h/Bn+/8R2C/cbuP819zPYm8z9ddiP4a/IhnAlVIJ8G+97DVkzVJ60
zVXYeh46QTKmY68Of6VlfksJPp4kN09Bb6Hfx/1vx4awMrLuFHxk8Xcn/uux
fxp/F4hnGHoY2X74y5HPwt8R+BQ2kvCF0DPwvyLvwt96vUe5xN8g9k/A98FP
Q6cJ+YrYtXgCvg/Zp9BDyIvRn4S8JXZu25APIRuEGvNto5vzOuhknn0cRPdo
lWPvVb4z1BV6pyiEd6GfkDfynkt5z8fIt3F3O3Q3d89jI4W8FPoefpZqSm6r
oVHoTyM/O7DVxv3b4Ldi71HevgQqKDAmdB5TiX7S32q5Wwc9ju4c4Q/5Cqiw
wDnTuQj9vKS/6W0noV0pv1FY/Bf6ImVMLsH/Hfi/DP/3Fxkrp5WzlDGzGNkk
4v8FfvZoMEItanLGnjCZ43411AP2boBvx/++KteuHkxcQFaCjTHYHw3tRdY2
zrLEGPICvwi+Dn4Q+x+A56Fyn7dgc2zsHCp3/cRwL7LPiW8J56vQeYC7/VXu
HdkYQDfOOJZviPE4sr+q3BuX8O00slHYyCOWkdAubNVWGBuqWQ3358G35rtm
fyO/D/6jhHP4j7AP5q4vcI7Go1+HvUpsHYY/RG0OQ9vI5RvUZ0WlY1asG4ix
Gv0JsXXlowHdxqyx1DPC2NsI3ZoyBrsrXQPl/k3uX4iMcWFbNXwBfiL8JuK7
Cf4Uuq/wbSbnFr5tiIx5YV02p5Hf69LuTfXUtZyvSXuWqQc/Qb8UG0XF7hn1
+urIttXzK8nfPcivRr6cmPuJfQ80n/MMbATOE5CXIk9BL3L3O/I1VfMLG13w
ayKfh7CXR2wXxa7tIwm/ZS3yhpTfpF7rwF5TsXvuMLoDVa5lH/WtAotRzrNE
M6yXWZQgZ4Fc9WoGpZ0T5WInVIjsfOxZ81/Cs7Y59uzTzN0RuYfVu8rhubRt
ytbxhLFwJvIsFSZ+572/ZV3r7cR3I3g8y52BhHtWsSRynl2K6UDab9Zbv4T2
wocK90Iv/Bn4Hvz1JG3jR2zvzzq3CzUfMu5Z9apyrlwfi4115VxYLEB/XLEx
+WrGM0azRZgcX+4aqTaa8aq1elS9qZqPLHePqDc0o9Qrh2LnWj3TWWlMC8va
gdN573DaudHMWZUxRoQNzSjtxmdj7y7tyA2VxrSwrB2hXbQR/TVF3kmahUfQ
/6rEM/E5Yu3MujfSwhOy1bF3613oTOY8Mfau04x6HVs7M67Fy9AfyLIZ7wbZ
XMp5Wca5XAAtQr4g9i6Ziny3aht5l2nGKJe15fatnEbcPRp7d2oGHAOLP8ee
/cK43rIJWlvkN7Vxbodmc26C9pCrxeSsOumZqVoLk8Kiai6sd8V+mzCvXamY
Fat2pnpvYexY1YP6F9Cb9Vb9E2gXyad8aSdpth+Ivbs04+V7X9pYUwza7QfT
xqJ2fDvvbct6t2hmN3Oem/Wu0hv0r/Fh2rNZ/xz6l9mVdm/pn2Ypuo9l/e+g
HLwUuefV6+rp/wFqPkAz
         "],
         VertexColors->None]}]}, 
     {RGBColor[0., 0., 0.30000000000000004`], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgeUldW1xz9ncIa5M3eGO3eYdstgN2qsT33PZzRqVCDrCSpiRcVEDYQS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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHd01FUWxx8JEFIGQmacSTK/mQCKurALnuO69r5AcM+uylGxIG1dFUVQ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         "],
         VertexColors->None]}]}, 
     {RGBColor[0., 0., 0.5], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgeUldW1xz+YdqeXO9y5d+YyExvmoaJ5GgsIPgsaiATFLiBq1OQ9morB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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHucz2UWx7+YMdffhN/4ze86ttJNUqIUYSuXKCmU1mWRaLfMEF5CKLW6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         "],
         VertexColors->None]}]}, 
     {RGBColor[0., 0., 0.7], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFm3eYldW1xj+mcM7MwLTTz8w5Az5BxCAIIiAQUGzhUmJBUIkJiWLQiAXF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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHeQ1dUVx3/sLmx5sAu7r/3e7nuwJAioVGEBQRYQUERQehMlUZGodMWo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         "],
         VertexColors->None]}]}, 
     {RGBColor[0., 0., 0.9], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNm3mYlMW1xr8Zpmemp4ee7p7pnukeehDFCCog4IYsouCuWSDuRnAXZFPQ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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXucz2UWx7+Y+zAzZn7f7+8yvjPG0hqFKJL7pZXCVkJJIlK6ao3uiqh0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         "],
         VertexColors->None], 
        PolygonBox[{{6216, 6379, 2555, 5127, 6215}, {6381, 6216, 6215, 5128, 
         2556}, {6234, 6391, 2564, 5145, 6233}, {6388, 6234, 6233, 5144, 
         2563}},
         VertexColors->None]}]}, 
     {RGBColor[1., 0.1, 0.1], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFm3mUVNW1xm+39AzdVdVV1QNUN4ggMqOIgCgqDqgQfQaNiUqiIIhoAjjh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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHm4j2Uax1/5nd05znF+7287fufU2Pfsa2VJyRpFui7pSiJL1ExCqKxR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         "],
         VertexColors->None], 
        PolygonBox[{{6242, 5164, 2581, 6414, 6241}, {5149, 6237, 6236, 6396, 
         2566}, {6237, 5148, 2565, 6393, 6236}, {5163, 6242, 6241, 6412, 
         2580}},
         VertexColors->None]}]}, 
     {RGBColor[1., 0.30000000000000004`, 0.30000000000000004`], EdgeForm[
      None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFm3u41VWZx3+c6z7sc84+l30/Z++NgJlAilwF1FABDZXDJRQftRJU1OaJ
cgQBdaYSy7Esi6lM07jVM02gaDaNFqamVCJpXsDCtIyLBOgImGZe5vvh+/Lw
x+/5rb1+a71rrXe9l+/7rrWPmrtg5mfqkiQ5vSFJ6vVOMknyQXuSXNeYJHdW
kuT7ej6u3yv0XqVnjso3qsOP1P58vbeq/RY956jruv5JcrfqZ6r8z2yS/K2U
JN/Q77ebk+RKvWsaYFg1SY7Ts0N0erqSpCmdJJMZK58k/1VLkmvU9nh9P0HP
brXZ0JokD+n5SlOSrG1JksvU9jf9NNeOJLlPND+lsfp6kmRaj39P0bt/b5IM
1literfpqbSprPa/1ven1f7E7iSZUfPvRs3zHfU5qLW8p/qDKr+mciWXJGeo
/Ce1WaFxB4nG6EbP6VU9V6p8UHMfqPqRGuuWYpKUSm57QpPHHF7vPrS5UeOO
1Rzq1Wd5g+kNjr5bxLfHVfdo4raDon6AnqdUf6zWu1jzmSieLBW9yXqfoadB
fB/V6DGg39ffvynf0Oq58G2o2g3S+3rR+YrmeYvWdZe+rdQ6Rqr+VtWvSyXJ
+JR/IxDs2xdFp6R3scH7++F6/6aMTMxq97eVkotjxLsDql+qvjerrk/vo7TW
US0ee4Lm/7jaFVQeIjqdei/QuCs1ZleUr1GbNXmvcaHKP9YeLVH5tynXPa82
7ze7LzRGaMzr1K6g+on1bkubEapbXXO7M9T3dL1XqH6G6v+oOYzV739R376c
1/6o6h7Ts6Td6xiX81qKmsuNyKT2c6G+Xa2nu9F7A43l6ltNWUbGqbxc7Veq
/RWa43Kt+33VX6z6T4vmowWP9Zz4/6Z+7xB/Vove3Snv2Zgu61I/lf9V/e9T
faPGuU00f66+H9SZd6tVf5Xo3CU6L+rZkxzhEWtPJIOPqz6j8s0aZ1vB+jJO
5dtV/pDKz+j7Af3eLppXa62nVt1/ZVn7rjavqM1NovkhydPRIpnWt1l6PqX1
vKa5TVN5tsqTRWOR2k9Q+90qz9HY20Rztvqdq+db6vvDRv+m/En1uVDlDSrv
E50NopPVGjc3WNY1lWSB6H1Wz8yUbczslO3MJ8Sb81T+rOr+nrasI+d7Ol1+
us7zox/j7Bf96fRV+T81r/2xXuZ+f8o2Z5PGebLg38g2dgw5rGlfNjWYV9eI
Nx9R3w6Vh1ctc8jbFPV7XOUHRXOAxn+ywfO/Wrw9UTalKno3im4uZVpLVX+h
9O7LkotO7fVu9Xm5wfb0vHbve14ELqlZ56G3OWj+XmtplE1o0+/xGjOb89z+
T/u1S/KRU/1c0R+aNT/b9P6Z5veO5nasxv9qymNdIjo3pyx7DxctK8jJRSpX
spa3OSp3qfy+2vxANH5YcP/zNe79BcvzUZrvl1Ke41OisbBo246+oc/wkDl/
O2W7yvdxWbf5Zaf5Bd/uSbvMGn8l/RuTs35drrbnlSxDm0vmKfw8LnQqq+cD
rbuf+DlO5U0a52bp6Asa93iVzw27dLfor0+b/n1635u2PI/uMs+ZJ36CevR3
tt4H9NyqNlOL5i+8Hac232yyDOOLnkzZH32tw29o1kffyZrjaexDr9dXLz40
6DmoNo1Rnqa1bxIfnuj0PPhNO/zmurTnzZzRiXVR3ilerFV5sOgnDa7HL9yb
cXvqWAfrrGvwuu+Jvs9qLc9pLW+I3vQmz4Mx5+hpbbbfeU109mWsm8yRNtjy
dr3bmt12StpzGABeEK3PN5rnP4lx4cPL2Kgmt/+uxrxdz+fTruN9gd6n1Hss
7NUG8WqZ2gxtsJ9YkLafapK8fSNvmd2g7w/p+Za+zVD/vmb7mIvFvzvS9ukb
9f3XZf9+uNNyhh7P6XQ/cMIuye+1ovmE5rZCdC5Pmx/YIXAHuvMx6fggjb1X
7a8RvcVlt1tXsi3GDuOXFuVsd1lPe/MRXsKroua/pdFjwOec6NVLVq/St2P6
m1/wCtmlrkHj5tXmjrxtPzSgCc6aqTYLVc6ozYQGf0dPW1We32ysgp7hc9A1
9P7beev+v2mOV9S8T4NVd1PNeoLvx89Dr6y+74nevDrL0bqQpRXal3E1fztd
dbdr3vvrLUfPFy1Ll0pnr9AzTHxeq/avFG2jZqjNrLLlBR19p+i1Jvr9QX9j
i6rmdmXFvrNFspDKWG6x29jsHrBii+0INJ8XvULRc7hdY43V3N6Ebym/0YUW
zWNsi3HgQ2qzVns2DP1Nmc/M4Weqv190Bqv8or6/pOeA5jRa/V5sdvtBHda3
RQ3GL39stnyerLohel+U2K4jmwfqbWOxrxk9z4req0WX12usXUXbq4e03jsl
W1vF9/miOabFc8Cvzgzf+p76fqCnI20doQ59BJex7+zXAb6X7H8nqP7kBuOQ
01Q+Q+UF2sf96v9uo3/Xif8naA7jVf6L6puiz5tp49ep+CDNbX7NOOky5L1s
W7hF82+WPM1Sm6kt9tmUp4X/ZA6naN9O1nO2ynu0n6/r+an24SNq82yz7ecL
opPRnOc02Ce/Hns8VO0G1lvXjtE8O0uuJzbY3m4//hf1fbro+AF+fDJ4slTz
Oa/F9WdHXAD9mZr3o/293rngG71l7pPL+xs7bFZ5ttr/XXP4HL+19mu09j+r
/y6N9TvN4SrVv6ryhTX3P7fFMQz1T4nY9XnboCEhE9gT1nohslhnefxHs9cG
r+H5WHCOdPws8fNXxE3N5hH8eabZMoTMgDXBuODbqyJ2wm+u0nw+XTHeBE8g
f8jeZuxWyvqIbreljIUX6/1Ws/3mAI3525JpwQN48YrmMDbtMjx5WXObVzCO
ek3jbM5aNrCzI1LG88cRb6S87l3N1it06gG1vavqdstEoydrmwZGRkaRz1qT
546fJYbAT+OjsUPIN7L9quZwecEY8iHZ7fUdjpVOaTKOB8OzZ3+PdR1stNwj
87PU7+MF093e3/bq0L5rLSuztmk7G23vsHV8x67RZn7YGGzpPyVrx5Q9H95D
otwpOemrOU6j36TouzxjXQEzPK5xLilb9nrE742BD9nz33V7398QnWll9/+r
6p9V/cY64wboYO/PF52hwg+1tDFPOW3c065+mbJ/L2r3d2wR+/ZSt/fus+r7
SY19kdb3U73LsRcLtK6NJdtV8CV2E5vZL2M5QAaYL7iWOS9Vv75efxutMcfo
GYFNEJ2GsmVveslyw7joIN/Rw6n6vjvn/Zkrnr2f9T7uaLQ+oZe9GmdtzXs5
WN8fKNnHYavgIzzcGvYDX1bRPs5T+3eEgw802ocQp34nY5yCfGLj6cd6b6nz
d/At9vDrGdtE7O99EZ8O1wYer2etvk2ON7HGj0vGwWBg7AJ5AurxD9hsMMC8
ZvsiYoqb6rwmYrG9kttV7Y7p9mkdn6jZj2AT7293HIEtoIxe8Obb1MB0A8KX
ga83Rxzwrnj5pPSr1GR9IW6H59hP5Jr2/1CbDWrTv8njr445LCk67kUXD3Y7
/gT/EwfPjHr4sC5j3PIHzf8FPYvbnb8g5iTePFl7elfN8rC2v3M94NXX8va1
+E381vP9jSfvKdvuY5PTJfsSfMeLej+m33MbHJMRi8JDvu0LDAaNLUGHOHhX
YJ52yUym4HbsM3aevQZTUCZf8aWC5QlZ2gTuzVqn5oNbovyW1j0PjKL5vlE0
BsW/z1Tdj7PGVp9LOdbNiU6XaHYX7Ld+ou8r0aMG46zVJcsnGGJt8AQf9nr0
BWv8b9Zy84OyMQF44F2t/baSbc7davPfMS65qIassVxfh/EQOkteij60Bwfd
lrX8HcJD/c1D7AH+CJuAH2R98ATezIwysg9GAg/jR4hHiSWZH5gE2Ube57QY
V29rNjZif8HI6PmcwKRgglmhh1NarGtTNLePFe0HwfPgJ3jLnp9U9L4TJ82O
WKlNsteqp17yt6zRvhkbj1/Hv+P78GP4YPzhmR2eP3MlJtuaco5hoOofbHFs
AhaGx/BwL/JScDtwMLEiMctHqs6PkBthPwcWvafkP27tdg7kdb3fLNhXzuow
T5jTGJWfa7HNx2aA07EP5FeIz+HnTZKNN7DLqt+ucXembCNeUt3LBceQxC/Q
BcuAAfD/8A3ZQf6QH/zDiJJ9BDh0bsp2CbuJj8cPptR/Xsq+ulPlJZE7wecM
KtnvkMs5JvI5I/Qe2d95vCwxjXjxgtYxXTJ1Qsnf8M0jos0U1Q8suf8XJcNf
KDhGOzprfUPXlmisL6u8qp99DjgA3XyaGC7v2OgJjTOy23amKHqLi86lsV/4
Ofbs52rz4W7Hy8SaUyLm/UzRPgxduFTvy4rmD/EdMgGmBnOBM8Bd5NJeiHza
FNFcknNOmz04usW2Gr9PjIHvx2ZiV8nRkTP7j5AN4nv2inzY892OIcF7Wc1/
Z9ayik/bHnhjn9b6o5J9Bbj1laxlGf2hDv3KlYw1kefWinMoyHmx1XYEG3Jl
yfKH7A2uGPeDt+HfU3nzELyJ3CAzL6nu5bxxKGPWlT0uPCSWQS+IUcg7IWf4
1WejL/x+OG+e35oxz2kP3yljlyaUvH7Wju3pK9v2gAUaAw8c02ofgN0Gx5ET
BMuh/8gucntah/06NvP+8Hv4wd0af03tiIxvi/ZdFcdUzJk8aHfWPJwkOqd3
mF8z9J7e4bHRuT3d1ru5zdYHdGFa1flKcpVgd3QGfXlE416cd/7lrorzXOS4
Vquuoeg4DJ9LzIxskAObE23AZMtDbsnFro587MK8sR06Cx5aGzZziATk2C5j
lv2q/1vKtvOjUQcmIde4t2KcsEMye2/V7dC5i7utd+QCfx/xPr7llZLtNzEZ
5ynIyR81h215tyPnR5ywI/L6H4SvvK5qvUVnmdttGcsA/PtUyTwcHOcRnCWQ
wyZvDh++WvSZB/XEH+AhYhDyuxdFjhc7Xx/YGDv6tbzlGVm5JOZzYZP3iT1q
FL3RBeeb2U/2dW74Iuwk/mhAu/M75HaWRj02GSw0LPAQuYGfdTkOwyfgG8D8
o7O2I9gQcndf7bR+c8ZEmVwgOHBKl7HWYVxI+a2I/7C3nCVRj80nz8R8wGmn
kf+oeD77Ko6HD8XCWdss7FWn1tdRMLZgvsyb+BebRRkst1Dfry44301+9JdB
n3OnCV0+eyJ/Rpkc2ubgPfyEL7QHw5PTO6nrSNuToi9nZ8gc8lbTONWC18cZ
C/IOTXIg8A07QJ6G8zByNcOyzjUfyttzblA1dnxK7/dyzkc2qF9jh7EoWAJ+
wSvyapdVvN5TyeF0O4/Yy54UbZfJh5KfxW6Tj6dMnraqNY3qsrwMaXWZ3Btz
ZK5gbHSIdTHuWNF7pGhcAuZhzay3Te/2Du8p8SVxJnEKckVeGz5DY2LQYS2U
6Y9ctEVf/AtnNsxxkMbZmbddIxcCvidWpV9D8IE9gLfoxXFa9zk155X/mfb7
W5GXHhNrJ44nv0gsf6qw38Qe29c1srUr9CxTv7J0tLdkGRkPvioZ//1Jc3kx
b9+A38d3gQHI0TA/5rZX3/fkbWdPEO3hPfY/zId2tBkpesNLxgEnaF49nc6X
wnv2A/6zVmhir1aID6uK1rms6O3pcuw1WDSOKnkuIwJbYBtb1GZHl/NS2A1y
O9icCzM+7yFXcUHGvyk3lX2OAmblTAnch38Br32zasw2LOM8BTmKSXqflnG7
SyWbI6qW//M5WyiZBj58ddl+nHanZkxzjb6vKhnTs75TYo0fFc9G1CxDzJc8
1Uth5ymDGS4VvbllY+4bwUtl57U5L+XcFN+BLv+j0/tL/m9X5LsmiyeTeizj
6P+0Jq8dXzMr+l6seX2iZJ4xJmMzh3SX26NT2zTm8prPAOAXWB+7C85mXM6w
dokfO/U8gp5pzFF6yq2ey472I+vbEesiXwhew1+Tn0YGwL69XT7Lh3fY71Fh
w58Sb5dULU//o/f+nPEFObGxQeedTs8HflDmfJ25Ya+owxbtjm+HefZOzP8B
0Xw75xwMeaC9bc550oZ1wlv0tTV8B3ZqeMT5TVnHKuAf1ox8I9vw+P2QT2JB
YjPwDzl5cgXgLvaS2AZcA0ZqjdwR/nNI+HLy2dh08l0jq77TwDrwpQPjLsGJ
RdspbBR9wAbkMrDT2G5klbMY6vHL72rcfW3mJzHI2MiPoZfMn7MRcOhLbY4J
8b20wf+CzQdW7OuJ3RvafVfjeNUNr/h3MWSMtWO3sHnEiZM092vF57qM4x7G
JufGvIbE3JarzTeq1tUnIn9ADvNgr3jc6znBv+HBw9aM8Sh2CRvK+SuxBrZj
XuRS7hG9u/UsyxgrIjPo4IfFs7tLjgG3Rc4erLhUbRdVrasfItdaM118PWdj
+HdysaeE3XpE6z6R/K9oj9den1lz/mWHaLRKzx/O+M4F9xLwjfi/wbGn0IMu
8RS+6/vhv76n9g/mfPYDpqANfbZ2+l4IORXkD16gOwM4v9W4r6vuMXLDBd/F
uFJ0Lq/annE/gnXgB88LvlJGNurjLA95eT1k5mz1O7PqcxUwMpgbO/YQc6ta
TvF3YAViVeSEvBqylJcNuKPmM3Zyt7vbrK/N4lWqYh0j/j4zZAM/RNyO/fxT
yfkR4mjuX4zM+UwYXP+3vLE9d3x6u51LqBO9+orH4N5EW7djwdMC20OHexdX
dPnuBTykTH6DewcdFeN58Oyrbc5zoKetcR73fsn5prmRmwJTklvaGmNAH+w2
IPw++QjyQ8SzYzTfYTXjmPmxXuSNM7RBeefa14j225LtP2vsp1VuqVg/7yz5
PIy4kvsjhbzz+tytWtTl+1XYasrkXdkb5nM4j3R67Bf2m7NkbPh3as4L10Kn
x4ReY9fZR/Aeuca9WWMh1kn+CKzLOcburONUzgP/PedcCLmlvsDYhbLHgH5f
xFPUcx+hkHPOmDOi83I+J+LM5Mmc86OLVN6U89kvseagwI2cCcMbzvXGkwfO
OT7nXPGBLp8tLlH52ZxzJEtVfi7nPPG1Km/NOWdP3pF8NLlHZPOSrOUTPk2K
fZwquf15zueuYKtTssZV3PPqzhmHot9HdVvH2wLP4RuwEydnrWO9Feea0YdE
734Vyxa5/1Hdzv9/T/ub7nb+gNjxmogf75Bu/SLmgI5iA6+KnOqSuDvEm3ru
F2FLF0SOmtwk+crD572zQg45zyZPRKzTqbk8U3IM/3XiqYJzPef0+H4VuVrO
Zx7M2NZw3+qkqN8o2o8WPeZZ2utXIz/PXo4LvMqdhDkxt5PVNl+wjOyKs1Ny
sNDmbhv0f5Ox78RvbsoYs4AJiQk2RVwADqMtOotNnB5n4vgr+uKzOAeoFJzT
Qq7Xh3/BRmOrmRsYCGyDvswv+ryQPOux3PWqGDPjB6GHD71e9K4rOC/G+T1z
Zex6sF7R/ExLd3/Z4/iP8W6JvaDuoajnzIBYnW/4LO7uHM6jUMb+kL8kj0l+
iTmmQ6/Rb3SeMjrfGm24t9cWOU9odAUd7lywBuaP3eOM59D5Tpwx4BPXg9ly
PgMhhiTWJ64kZ391yNsg8WN/ybkA7lywN+wL+GxyYOa2jMdlTWO5e1Px+Tn2
dWvQwgb0hc3ERy4MGabNwpgbdpzcBvEg+GxixI9XaPxPl3y++Isu6z+6z573
xL6Djw7Zg34+n7khzmiQTc6QkE98FdiIGAps927sBX7sF+HLsCNvN5pHyA79
2M/nc7Yp2BPWy1qJhc5Rv76q64j/qcOPo9vYMHwH986wbcSt4IA346wcvzo1
fCt5GfaBHM4zOdsy7FhCjiTvvAZYD9zMXTVidPIk5OrxmfhOYpZGtd9S9jfG
oP3ywNtvRt8tOdvEnbHO7ZHLRBb2lDwPcsw7oh4fQFtkZ1fOcnMgeLc/5vxE
zrabNV8Q+XfmMy7tPPyyxiMxKjoI/qRMrMr73YgVudtzQdz5eS/qafNW2naa
+WOzR/X6N2t6K+qxGUNbHdcjF+TmZkSMOSTqXyMHwz2SuL/AG7tA/MF3cBQx
1g0RZ0EP3vONO2TvxXw4n+b8jzzAteLH9VXHhzynRpzImQJv2oMlFwee3CBe
Te9xf3S6X+g1GBp7j03jLif3bsH23NPE56OPxOurImY/UzQ+1uN+Z+l9do8x
IbYSXEhuAT+GL4EuayA3xhqR8e2x/4cxBLEe8QP7SU4PnEJOHGzGvSfK4Bfu
SHJXkjPB9YEfwHtgVuQFU4U/nBw+cWjZd4XJe54bcSvxAbrG+MjVstCB/XH+
gsxRv5G7kQXzAzuHvbsu7qMgf4djh4a4Y4YdQhexgd/lbKvonGlZcyiVfY94
o+zT+Jz5uqbi++j4KrAFsRY2BJ6yD+TP6zR+v4J9F/Q7w9Zhc7HDnAFlMh4X
/cePzo5zE+wSNMlTkfvPRJs1Rec4iFHI7Xw08kKcG8BbzmR57w0+k6+9ouqc
7YPEK0VjzPPJIRfsq/epfm/Jd6PgF7JD37+Soyh67zZwjt9tXABtxmBM4m5k
l5huWegw+VXuGSGvyCpnLzfH+Qu284bIPa/FP1f9+964MwgPf8394ZJtPr4I
nzQ9ztkmhY4Q4x0ai3E1xx+WnQcndzU6cmJ3aX13FnyO/Qx56LzzlGer7ZNZ
x+tgme6Kfel3WWPR8TR6c+j+Sz9jlscCt/SpzYySZXm66JxT9l2M0VrrqJzj
pKGBOTin4Exnb/Dq6jjPhub8iu+ukX8Fm+Dv8GWrNa+zqubFNn3fmHUMRAwG
Xfbxe1rTHQXf7UVO15ctq+m4w0WOD8wxIs7j0FN09IXACfymzL71Rs6EeH9C
5GmJGTfE/x2IMSZG30GxNtbFe1isk9zNGRHTElO2xb1B6JKTmRx4A7k/fE+e
MjSJ55PQTXRpU9xHBTfQF7ni3RtlMMXRFX+/sei9Z99PFQ8mlu03wDzpWOcF
kbdDJnuzvmcMhiQvPzDuOZArYFwwJ3sEjgFjLI4y+0WOHwxMDge9bAndBEv/
ofNI2z9EX3QVXSe3gI8gV4V/wr/jox5NjsSTyAT+hr3CFrF+5oT8oZ/IB3xe
HPXM8/8BVvyG2g==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmAeQldUVxz+2sG8by+6r39t9CwhiAZVehUgPCCxFihliQaWZRDFShcQo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         "],
         VertexColors->None]}]}, 
     {RGBColor[1., 0.5, 0.5], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgmUlcWVxz+6obtfN03TvO7X/d776FacgzrGEUlcJqMBFCUCChKDSk4w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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHu8jWUWx1+H49gOR9nbOXu/+6KYQVNNhxpdJqFcCuWSSH1S5JruKeVS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         "],
         VertexColors->None]}]}, 
     {RGBColor[1., 0.7, 0.7], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgmUVNW1hi/d0EVXd1HdXT1XdbVMDsnSmJiYAD4xxqdGIQqIGmdFFAVR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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHmYlMURxpsdZGB2lyXsMjuz881s5ApqkidCNB6ooJjHKCKHHCEmhEPA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         "],
         VertexColors->None]}]}, 
     {RGBColor[1., 0.9, 0.9], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmH2Q1WUVx3934d69u9yXYZe9y+5e7oZAluEfZhphODC8OAg4LcuKsiSw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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlllslGUUhr8WZjptZzqxU/7pMvMTKIgiXgGKJRAI6AUKkUWiFCgWQZO2
lCVuoK1QlbigCEWiUSFRAUEvXEqqiUsgoHgjAuqN3qJAFQQEjQo+b14vTuY7
/znf+539zLDWzjkrSkMIvdBg6Of6EL6LQ+jLhjAiGUKa88IhIazjfKQqhI6G
ENqhRekQFkPltSFkhoZwEv2S8hBmFkKYBX2I7NMScHIhJNG5kuKM/EB1CA8V
Q2gCqxHMRVEI+/MhvIa8Gvl9vNcK9SZ4H8wLnBt571Z0v4TfBP8c9D7yefBn
OQ9DPg35Ifg/OF/lzZIMv9iwEvwT4H8C/jDwe7FlK7Sb855y23YZjG+ytnEj
vj6BfVOqbEMtvtRBAbwJ+LMV2TZoJvK/CNhU8C+DP8DdUvA64N+D3wIfw2+L
7KN8aysLYRf27YZ2YtsOaDqyf9E/i34CnbuxZQFUjz0v8H4nuiuhJei2QK9w
fhXaxrkXaq8xprDmYWMb/G+xYzEX/i1kb0KvI38D2o5/Fci/qnIMu5DN5k4T
up3IU/g6Fr4evg46h+4y+BmcD4N5An4a/KiMa2Q151v4dh68lgryRX4D/IEq
52Q+eHcVHLs54C/B35/w9xD+DsHfBLoXuTNd+ePOJHQnQ9Xg7+BOKfJmbO5H
/yDyGzhnc45lAvvX14Wwoc65/AL94+ifrHdtfYR9fbx1ERtbUq6xUrBHwefA
vybj2n6aO7dnXeOqne/h92ddQ9uLzrlyPYv3H+T8KDSR8ym+XQDvPLSvxDnd
GdlH+bYWG9ehe7DavTSpyr1zB++PybiHNiBvxIYHkE9FfiX3fw2nXXOSNWNP
Q9Y698PHOWOvwP/+nHtQvdcPDUf+OJiTwdqMv2ewbaDg3MvGVdhWUetaTYCX
QD8C/1v016C/lruPFW3rafzrQT9T69pMob86MobuHoX+5O4lqCPpHnoy8h3p
nkk69i8XHTvlYDW5WgNtBu8e7Gni7oTYvqiGnsXWZwqeHarBWmbLTDBu5HwB
/Ai+bqjPm8BPcXcwNJv7h7lfwvkq792ZcA3ehO6CyLZkFR/4kdBV7vfyrZu3
ugquNfXUPu6+U3Rt3cv9H8D7hXoamXRNDCc3v8fuBdXspbxnnGabZkAlsnJo
bsI9thusNPaXY/9i+F3wo4n5oIRnyEZ0e6C9CdfgP3nnVLnUTBiLrbdFjnWS
b93c7ym6VgbIz7G8Z5xm28fojxjqmaBZIB8b4a+L7OuMrHtZM0SzQz39LvfP
8e3XCs+sKvTTUE/SM31cjWeCZkFDxrFOxu5VxVy9dD72bFZPnSJWp6GXUo7Z
RPCb8s61auTaGvegek893t3gGaTZszLt3A2K3evK4SNF17RqWT3Xji/H653L
CWWO7d/cL8s4xnPg9xadu/H49DbnPUXHXjEfD/Zy8No5H1V9xPZRvp2Fvx7b
Rhdsy3xs7qb2u6AXy12zh5EdgqaVeCbv5+0+6IO0d94qsJ6PvZuawWxFtrTB
s2922liyUbYJcxy6N8d+WzblVZ+Ra1s7YDnnr+ud+zFlfktvCFtvPlz0TNIs
0k5dim2tBdueQqer6J5WL2smHCcXpfhfWemdqNhV1lhXMTzCW8siv6Wa0K7U
jNds1848hrwtcuyF8WPeM0SzQzNds+1Y7NmrGaddoRjId+0MzfKy2L2qma7e
1o7TblOPTwVvSt6zXDWYRzenHZDwjBqB7sgG17r+EyyMvTO1KzUj1UtPxa51
9ZR2n3aidqF24Pqie0i9ox2v3bc09n8N7UD1bib2fx318L68d7p2uWpatgyJ
XTuy6TNi/XnB/4VUE/8Bu5c1Pg==
         "],
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{7020, 5196, 7890, 7891, 6886, 4802, 7542, 7543, 7541, 7545, 
         7544, 5410, 7549, 7550, 7546, 7548, 7547, 4803, 6887, 7893, 7892, 
         5187, 7010, 7011, 7012, 7254, 7253, 4931, 7192, 7193, 7158, 5118, 
         7157, 5119, 7894, 7895, 6888, 6889, 6890, 6058, 6059, 5741, 6061, 
         6060, 5360, 6857, 5733, 6856, 5734, 6858, 5701, 7987, 5702, 6956, 
         6957, 5746, 5745, 6154, 5697, 6135, 6134, 5045, 6150, 7927, 7928, 
         7926, 5649, 5947, 5946, 6544, 6514, 6515, 6272, 6271, 6270, 5202, 
         7594, 7595, 7593, 5419, 4879, 5781, 5725, 6070, 6069, 5364, 7574, 
         7575, 7571, 7573, 7572, 7590, 5418, 7589, 7592, 7591, 5132, 7163, 
         5131, 7164, 7267, 7266, 4947, 7209, 7210, 7040, 7039, 7038, 5201, 
         7779, 7780, 7778, 5511, 7552, 7553, 7551, 7555, 7554, 5411, 7771, 
         7772, 7768, 7770, 7769, 7959, 5669, 7958, 7961, 7960, 5197, 7023, 
         7024, 7025, 7366, 7365, 4940, 7358, 7359, 7022, 7021, 7020}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7075, 5227, 7918, 7919, 6945, 4851, 7680, 7681, 7679, 7683, 
         7682, 5467, 7687, 7688, 7684, 7686, 7685, 4852, 6946, 7921, 7920, 
         5221, 7065, 7066, 7067, 7295, 7294, 4983, 7229, 7230, 7171, 5158, 
         7170, 5159, 7922, 7923, 6947, 6948, 6949, 6097, 6098, 5744, 6100, 
         6099, 5378, 6866, 5739, 6865, 5740, 6867, 5721, 7990, 5722, 6972, 
         6973, 5764, 5763, 6157, 5700, 6141, 6140, 5048, 6153, 7949, 7950, 
         7948, 5660, 5953, 5952, 6547, 6529, 6530, 6293, 6292, 6291, 5234, 
         7737, 7738, 7736, 5479, 4894, 5792, 5728, 6109, 6108, 5381, 7702, 
         7703, 7699, 7701, 7700, 7733, 5478, 7732, 7735, 7734, 5172, 7176, 
         5171, 7177, 7306, 7305, 4997, 7245, 7246, 7095, 7094, 7093, 5233, 
         7820, 7821, 7819, 5527, 7690, 7691, 7689, 7693, 7692, 5468, 7814, 
         7815, 7811, 7813, 7812, 7971, 5672, 7970, 7973, 7972, 5228, 7078, 
         7079, 7080, 7411, 7410, 4988, 7403, 7404, 7077, 7076, 7075}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{6166, 5065, 6309, 6366, 6365, 7354, 7355, 7353, 7357, 7356, 
         5256, 6532, 5255, 7352, 5819, 4873, 4795, 6534, 5257, 6533, 5258, 
         7363, 7364, 7360, 7362, 7361, 6371, 6372, 6320, 5068, 6319, 5067, 
         7924, 7925, 7034, 7035, 4944, 6066, 4945, 7037, 7036, 7111, 7110, 
         5015, 6114, 5016, 7113, 7112, 5510, 5801, 4946, 5206, 7206, 7208, 
         7207, 5130, 6222, 6223, 6224, 6898, 4809, 5925, 4813, 6900, 6457, 
         5207, 6456, 5208, 7271, 7272, 7268, 7270, 7269, 4954, 5803, 5514, 
         7120, 7121, 5020, 6118, 5019, 7118, 7119, 7048, 7049, 4958, 6011, 
         6770, 6771, 6769, 6773, 6772, 5078, 7152, 5079, 6325, 6516, 8018, 
         5038, 7318, 7319, 7317, 7321, 7320, 5051, 6142, 5050, 8022, 5687, 
         6182, 4814, 5927, 5823, 6513, 5247, 6512, 5248, 7315, 7316, 7312, 
         7314, 7313, 5037, 6298, 6837, 6836, 5633, 6158, 6159, 5813, 5049, 
         6844, 6763, 6615, 6616, 6614, 7449, 7448, 6009, 4941, 7026, 6268, 
         6667, 6666, 6761, 5964, 5013, 7107, 7106, 5508, 5798, 4932, 7195, 
         7196, 7194, 7198, 7197, 5189, 7189, 5188, 8084, 6508, 7256, 7255, 
         5922, 6431, 6432, 6430, 6429, 6212, 5114, 7251, 7252, 7248, 7250, 
         7249, 4930, 5797, 5504, 7100, 7101, 5009, 5959, 7886, 7523, 7524, 
         7008, 7009, 4929, 6052, 4928, 7007, 7006, 7522, 7521, 6173, 6166}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6192, 5089, 6343, 6402, 6401, 7399, 7400, 7398, 7402, 7401, 
         5268, 6541, 5267, 7397, 5832, 4888, 4845, 6543, 5269, 6542, 5270, 
         7408, 7409, 7405, 7407, 7406, 6406, 6407, 6349, 5095, 6348, 5094, 
         7946, 7947, 7089, 7090, 4994, 6102, 4995, 7092, 7091, 7141, 7140, 
         5031, 6128, 5032, 7143, 7142, 5526, 5810, 4996, 5239, 7242, 7244, 
         7243, 5170, 6251, 6252, 6253, 6953, 4857, 5942, 4862, 6955, 6504, 
         5240, 6503, 5241, 7310, 7311, 7307, 7309, 7308, 5003, 5812, 5529, 
         7150, 7151, 5036, 6132, 5035, 7148, 7149, 7098, 7099, 5005, 6029, 
         6804, 6805, 6803, 6807, 6806, 5104, 7155, 5105, 6353, 6531, 8021, 
         5044, 7348, 7349, 7347, 7351, 7350, 5060, 6145, 5059, 8025, 5696, 
         6207, 4863, 5944, 5838, 6528, 5253, 6527, 5254, 7345, 7346, 7342, 
         7344, 7343, 5043, 6301, 6843, 6842, 5646, 6164, 6165, 5816, 5058, 
         6853, 6768, 6648, 6649, 6647, 7465, 7464, 6025, 4989, 7081, 6287, 
         6706, 6705, 6766, 5993, 5028, 7135, 7134, 5523, 5808, 4984, 7232, 
         7233, 7231, 7235, 7234, 5223, 7221, 5222, 8092, 6511, 7297, 7296, 
         5936, 6484, 6485, 6483, 6482, 6239, 5151, 7292, 7293, 7289, 7291, 
         7290, 4982, 5807, 5520, 7130, 7131, 5025, 5988, 7908, 7657, 7658, 
         7063, 7064, 4981, 6090, 4980, 7062, 7061, 7656, 7655, 6201, 6192}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{6303, 6171, 6172, 4794, 6734, 5617, 6733, 6736, 6735, 5272, 
         6167, 6869, 6870, 4869, 5954, 5841, 5842, 5404, 5777, 4870, 5955, 
         6043, 6044, 5817, 5061, 5958, 5062, 6427, 6428, 6426, 7188, 5186, 
         8083, 6875, 6876, 6874, 5629, 7887, 5281, 7528, 7529, 7525, 7527, 
         7526, 4899, 7753, 7754, 7752, 7756, 7755, 5283, 7416, 5284, 6877, 
         6878, 6434, 5190, 6433, 6436, 6435, 5070, 5963, 5069, 5821, 6054, 
         6053, 5965, 5852, 5853, 5361, 5855, 5854, 5969, 5862, 6179, 6178, 
         6561, 5299, 6621, 8004, 6622, 6620, 6960, 6961, 4810, 5751, 5729, 
         5825, 5824, 4904, 7867, 7868, 7866, 7870, 7869, 5625, 7980, 5686, 
         7979, 5685, 6846, 6845, 6230, 6627, 6626, 5304, 6324, 5303, 6569, 
         5869, 4820, 5867, 5868, 5366, 5866, 8100, 5865, 4819, 6681, 6682, 
         5756, 5755, 6119, 5077, 6459, 6460, 6458, 7211, 5209, 8087, 6679, 
         5431, 7616, 5432, 7617, 5430, 7619, 7620, 7618, 5433, 4903, 7585, 
         7586, 7584, 7588, 7587, 5417, 7935, 5652, 7934, 5651, 6449, 5200, 
         6448, 6451, 6450, 5075, 6115, 5749, 5750, 6671, 6670, 4807, 4877, 
         8097, 5779, 5414, 5851, 5850, 4801, 4875, 6556, 5290, 6318, 5291, 
         6738, 6739, 6737, 5618, 7862, 6305, 6306, 6304, 6308, 6307, 6364, 
         6302, 6303}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6337, 6199, 6200, 4844, 6755, 5623, 6754, 6757, 6756, 5317, 
         6193, 6914, 6915, 4885, 5982, 5889, 5890, 5462, 5787, 4886, 5983, 
         6083, 6084, 5830, 5086, 5987, 5087, 6480, 6481, 6479, 7220, 5220, 
         8091, 6934, 6935, 6933, 5644, 7909, 5325, 7662, 7663, 7659, 7661, 
         7660, 4909, 7799, 7800, 7798, 7802, 7801, 5327, 7433, 5328, 6938, 
         6939, 6487, 5224, 6486, 6489, 6488, 5097, 5992, 5096, 5834, 6092, 
         6091, 5994, 5904, 5905, 5379, 5907, 5906, 5996, 5910, 6205, 6204, 
         6596, 5340, 6654, 8007, 6655, 6653, 6976, 6977, 4858, 5770, 5732, 
         5840, 5839, 4915, 7882, 7883, 7881, 7885, 7884, 5628, 7986, 5695, 
         7985, 5694, 6855, 6854, 6257, 6659, 6658, 5346, 6352, 5345, 6601, 
         5920, 4868, 5918, 5919, 5383, 5917, 8108, 5916, 4867, 6720, 6721, 
         5775, 5774, 6133, 5103, 6506, 6507, 6505, 7247, 5242, 8094, 6717, 
         5498, 7747, 5499, 7748, 5497, 7750, 7751, 7749, 5500, 4914, 7728, 
         7729, 7727, 7731, 7730, 5477, 7957, 5664, 7956, 5663, 6495, 5232, 
         6494, 6497, 6496, 5099, 6129, 5768, 5769, 6710, 6709, 4854, 4892, 
         8104, 5789, 5470, 5903, 5902, 4850, 4890, 6589, 5332, 6347, 5333, 
         6759, 6760, 6758, 5624, 7865, 6339, 6340, 6338, 6342, 6341, 6400, 
         6336, 6337}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{6355, 5107, 6354, 5106, 6548, 6549, 7413, 7412, 5271, 5353, 
         8028, 5352, 5588, 8058, 5589, 5585, 5587, 8057, 5586, 5615, 4793, 
         7993, 5280, 5279, 5591, 8059, 5590, 5356, 8030, 5357, 6608, 6170, 
         6553, 6552, 5116, 7156, 5117, 6370, 5292, 6557, 7161, 5124, 7162, 
         5125, 6375, 5296, 6821, 6822, 6276, 6277, 4952, 6068, 4953, 7582, 
         7583, 7581, 5416, 5972, 5971, 5298, 5181, 8011, 4902, 5428, 5429, 
         5425, 5427, 8099, 5426, 5926, 5655, 8069, 5656, 5434, 7622, 5436, 
         7621, 5435, 6989, 6988, 6987, 7181, 7180, 7902, 5976, 5977, 5516, 
         7784, 7786, 7785, 4961, 6017, 6786, 6787, 6785, 6789, 6788, 5309, 
         6385, 5138, 6232, 6571, 6572, 5310, 5870, 5139, 6075, 5784, 6573, 
         6574, 6184, 6185, 7478, 7479, 6990, 6991, 6992, 5565, 7837, 5566, 
         7838, 5305, 6012, 6013, 5705, 5757, 4815, 4881, 6964, 6965, 6774, 
         6776, 6775, 5562, 7836, 5564, 7835, 5563, 6986, 6985, 6984, 7472, 
         7471, 5300, 6562, 6564, 6563, 5782, 6071, 5133, 5863, 6896, 6218, 
         6217, 6214, 5126, 6376, 6611, 7442, 7443, 6610, 7441, 7440, 6006, 
         4933, 7758, 7759, 7757, 5505, 6111, 6110, 5010, 7102, 7103, 7179, 
         7178, 6982, 6983, 5405, 7530, 5406, 7531, 5282, 5630, 7994, 4796, 
         5921, 4791, 7991, 5274, 5273, 5399, 8036, 5398, 4897, 8008, 5178, 
         4923, 6045, 6046, 5397, 7514, 5396, 4922, 6042, 4921, 7004, 6266, 
         6662, 6661, 6660, 6358, 5109, 6356, 5108, 6357, 6868, 6355}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5887, 5147, 6020, 5146, 6581, 6582, 7425, 7424, 5316, 6636, 
         6637, 6634, 5371, 6635, 5606, 7856, 5607, 7857, 5605, 7854, 7855, 
         7851, 7853, 7852, 7861, 4843, 6932, 6931, 7432, 7431, 5324, 6732, 
         5609, 6730, 5608, 6731, 8096, 5374, 8034, 8035, 7453, 7452, 6639, 
         6198, 6586, 6585, 5156, 6022, 5157, 5895, 5334, 6411, 5163, 6242, 
         5164, 6415, 5336, 6831, 6832, 6296, 6297, 5001, 6107, 5002, 7725, 
         7726, 7724, 5476, 6000, 5999, 6001, 5940, 5941, 6149, 6148, 5795, 
         5796, 5495, 7744, 5496, 7745, 5492, 5494, 8107, 5493, 5943, 5667, 
         8072, 5668, 5501, 5503, 8041, 5502, 4919, 5185, 5648, 6004, 6005, 
         5531, 7825, 7827, 7826, 5008, 6033, 6817, 6818, 6816, 6820, 6819, 
         5350, 6420, 5176, 6260, 6605, 6606, 5351, 6421, 5177, 6261, 6607, 
         7436, 7437, 6210, 6211, 5395, 8017, 4920, 5580, 8055, 5581, 5347, 
         6030, 6031, 5724, 5776, 4864, 4896, 6980, 6981, 6808, 6810, 6809, 
         5577, 5579, 8054, 5578, 4916, 8015, 5393, 5341, 6597, 6599, 6598, 
         6255, 6254, 5173, 6417, 6951, 6247, 6246, 6245, 5165, 6416, 6643, 
         7460, 7461, 6642, 7459, 7458, 6023, 4985, 7804, 7805, 7803, 5521, 
         6125, 6124, 5026, 5182, 8013, 4910, 5463, 8039, 5464, 5326, 7910, 
         7911, 6936, 6937, 4846, 5935, 4837, 6921, 6920, 7427, 7426, 5318, 
         7643, 5458, 7642, 5457, 6265, 6264, 6424, 7185, 6425, 6285, 6284, 
         4973, 6085, 6086, 5456, 7641, 5455, 4972, 6082, 4971, 7053, 6283, 
         6699, 6698, 6695, 6395, 5149, 6237, 5148, 6394, 6913, 5887}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{8, 7843, 5582, 5584, 8056, 5583, 4924, 5533, 8042, 5534, 
         5532, 5674, 8073, 5673, 7828, 7516, 7517, 7515, 7519, 7518, 5384, 
         7469, 7470, 7466, 7468, 7467, 5960, 5845, 5846, 5359, 5848, 7996, 
         5847, 6559, 6377, 7997, 6379, 6216, 6381, 6380, 6560, 7936, 7937, 
         6823, 6827, 6826, 5420, 6677, 6678, 6674, 6676, 6675, 7938, 7597, 
         7598, 7596, 7600, 7599, 5385, 7476, 7477, 7473, 7475, 7474, 7625, 
         5675, 8074, 5676, 5535, 5537, 8043, 5536, 4962, 5539, 8044, 5540, 
         5538, 7832, 7833, 7829, 7831, 7830, 6466, 6911, 6467, 6190, 5214, 
         5244, 8026, 5243, 4964, 5551, 8048, 5552, 5550, 5640, 8067, 5639, 
         4831, 5714, 8081, 5715, 5713, 6039, 6038, 5389, 7495, 7496, 7492, 
         7494, 7493, 4832, 5884, 5885, 5369, 5888, 5886, 4833, 6392, 6393, 
         6236, 6396, 6969, 8001, 8000, 4834, 6916, 6917, 6694, 6697, 6696, 
         5454, 6701, 6702, 6700, 6919, 6918, 4835, 7498, 7499, 7497, 7501, 
         7500, 5390, 6040, 6041, 5716, 5718, 8082, 5717, 4836, 5641, 8068, 
         5642, 5556, 5558, 8050, 5557, 4966, 5598, 8061, 5599, 5597, 5682, 
         8077, 5681, 4838}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{106, 7859, 5616, 5684, 8078, 5683, 4960, 5542, 8045, 5543, 
         5541, 5636, 8065, 5635, 4823, 5708, 8079, 5709, 5707, 6035, 6034, 
         5387, 7485, 7486, 7482, 7484, 7483, 4824, 5877, 5878, 5368, 5881, 
         5879, 4825, 6387, 6388, 6234, 6391, 6968, 7999, 7998, 4826, 6905, 
         6906, 6685, 6688, 6687, 5449, 6692, 6693, 6691, 6908, 6907, 4827, 
         7488, 7489, 7487, 7491, 7490, 5388, 6036, 6037, 5710, 5712, 8080, 
         5711, 4828, 5637, 8066, 5638, 5544, 5546, 8046, 5545, 4963, 5548, 
         8047, 5549, 5547, 7977, 7978, 7974, 7976, 7975, 4830, 6912, 6835, 
         6191, 5085, 5246, 8027, 5245, 4970, 5554, 8049, 5555, 5553, 5678, 
         8075, 5677, 7834, 7637, 7638, 7636, 7640, 7639, 5391, 7505, 7506, 
         7502, 7504, 7503, 5986, 5891, 5892, 5375, 5894, 8002, 5893, 6590, 
         6410, 8003, 6412, 6241, 6414, 6413, 6591, 7953, 7954, 6830, 6834, 
         6833, 5475, 6714, 6715, 6711, 6713, 6712, 7955, 7720, 7721, 7719, 
         7723, 7722, 5392, 7512, 7513, 7509, 7511, 7510, 7746, 5679, 8076, 
         5680, 5559, 5561, 8051, 5560, 5007, 5613, 8064, 5614, 5610, 5612, 
         8063, 5611, 5945}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{6360, 5111, 6359, 5110, 6550, 6551, 7415, 7414, 5275, 5355, 
         8029, 5354, 5593, 8060, 5594, 5592, 7847, 7848, 7844, 7846, 7845, 
         7858, 4797, 6880, 6879, 7418, 7417, 5285, 6724, 5596, 6722, 5595, 
         6723, 8095, 5358, 8031, 8032, 7439, 7438, 6609, 6174, 6555, 6554, 
         5120, 6007, 5121, 5849, 5295, 6378, 5127, 6215, 5128, 6382, 5297, 
         6824, 6825, 6278, 6279, 4955, 6072, 4956, 7602, 7603, 7601, 5421, 
         5974, 5973, 5975, 5928, 5929, 6147, 6146, 5793, 5794, 5440, 7623, 
         5441, 7624, 5437, 5439, 8101, 5438, 5931, 5657, 8070, 5658, 5446, 
         7632, 5448, 7631, 5447, 6995, 6994, 6993, 7183, 7182, 7903, 5978, 
         5979, 5517, 7787, 7789, 7788, 4965, 6019, 6791, 6792, 6790, 6794, 
         6793, 5311, 6386, 5140, 6235, 6575, 6576, 5312, 5876, 5141, 6081, 
         5785, 6577, 6578, 6186, 6187, 7480, 7481, 6996, 6997, 6998, 5570, 
         7839, 5571, 7840, 5308, 6015, 6016, 5706, 5760, 4818, 4882, 6966, 
         6967, 6782, 6784, 6783, 5567, 5569, 8052, 5568, 4907, 8012, 5386, 
         5302, 6566, 6568, 6567, 6229, 6228, 5137, 6384, 6897, 6221, 6220, 
         6219, 5129, 6383, 6613, 7446, 7447, 6612, 7445, 7444, 6008, 4939, 
         7766, 7767, 7765, 5507, 6113, 6112, 5012, 5180, 8010, 4901, 5408, 
         8038, 5409, 5287, 5632, 7995, 4800, 5923, 4792, 7992, 5278, 5277, 
         5403, 8037, 5402, 4898, 8009, 5179, 4927, 6050, 6051, 5401, 7520, 
         5400, 4926, 6047, 4925, 7005, 6267, 6665, 6664, 6663, 6363, 5113, 
         6361, 5112, 6362, 6871, 6360}],
        RowBox[{"-", "0.2`"}]],
       Annotation[#, -0.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5880, 5143, 6018, 5142, 6579, 6580, 7421, 7420, 5313, 6632, 
         6633, 6630, 5370, 6631, 5601, 7849, 5602, 7850, 5600, 6728, 6729, 
         6725, 6727, 6726, 7860, 4839, 6923, 6922, 7429, 7428, 5319, 5604, 
         8062, 5603, 5372, 8033, 5373, 6638, 6194, 6584, 6583, 5152, 7167, 
         5153, 6403, 5331, 6588, 7172, 5160, 7173, 5161, 6408, 5335, 6828, 
         6829, 6294, 6295, 4998, 6103, 4999, 7705, 7706, 7704, 5471, 5998, 
         5997, 5337, 5183, 8014, 4911, 5483, 5484, 5480, 5482, 8105, 5481, 
         5938, 5665, 8071, 5666, 5489, 5491, 8040, 5490, 4917, 5184, 5647, 
         6002, 6003, 5530, 7822, 7824, 7823, 5006, 6032, 6812, 6813, 6811, 
         6815, 6814, 5348, 6418, 5174, 6258, 6602, 6603, 5349, 6419, 5175, 
         6259, 6604, 7434, 7435, 6208, 6209, 5394, 8016, 4918, 5575, 8053, 
         5576, 5344, 6027, 6028, 5723, 5773, 4861, 4895, 6978, 6979, 6800, 
         6802, 6801, 5572, 7842, 5574, 7841, 5573, 7003, 7002, 7001, 7508, 
         7507, 5339, 6593, 6595, 6594, 5791, 6106, 5169, 5909, 6950, 6244, 
         6243, 6240, 5162, 6409, 6641, 7456, 7457, 6640, 7455, 7454, 6021, 
         4979, 7796, 7797, 7795, 5519, 6123, 6122, 5024, 7128, 7129, 7187, 
         7186, 6999, 7000, 5460, 7653, 5461, 7654, 5321, 7906, 7907, 6927, 
         6928, 4842, 5933, 4829, 6910, 6909, 7423, 7422, 5315, 7635, 5453, 
         7634, 5452, 6263, 6262, 6422, 7184, 6423, 6282, 6281, 4969, 6079, 
         6080, 5451, 7633, 5450, 4968, 6076, 4967, 7052, 6280, 6690, 6689, 
         6686, 6390, 5145, 6233, 5144, 6389, 6902, 5880}],
        RowBox[{"-", "0.2`"}]],
       Annotation[#, -0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{6311, 6175, 6176, 4798, 6741, 5619, 6740, 6743, 6742, 5276, 
         6169, 6872, 6873, 4871, 5956, 5843, 5844, 5407, 5778, 4872, 5957, 
         6048, 6049, 5818, 5063, 5961, 5064, 6438, 6439, 6437, 7190, 5191, 
         8085, 6882, 6883, 6881, 5631, 7889, 5286, 7539, 7540, 7536, 7538, 
         7537, 4900, 7761, 7762, 7760, 7764, 7763, 5288, 7419, 5289, 6884, 
         6885, 6445, 5195, 6444, 6447, 6446, 5074, 5966, 5073, 5822, 6057, 
         6056, 5968, 5858, 5859, 5363, 5861, 5860, 5970, 5864, 6181, 6180, 
         6565, 5301, 6624, 8005, 6625, 6623, 6962, 6963, 4812, 5754, 5730, 
         5828, 5827, 4906, 7872, 7873, 7871, 7875, 7874, 5626, 7982, 5689, 
         7981, 5688, 6849, 6848, 6231, 6629, 6628, 5307, 6326, 5306, 6570, 
         5875, 4822, 5873, 5874, 5367, 5872, 8102, 5871, 4821, 6683, 6684, 
         5759, 5758, 6121, 5080, 6464, 6465, 6463, 7217, 5213, 8088, 6680, 
         5443, 7626, 5444, 7627, 5442, 7629, 7630, 7628, 5445, 4905, 7605, 
         7606, 7604, 7608, 7607, 5422, 7940, 5654, 7939, 5653, 6453, 5203, 
         6452, 6455, 6454, 5076, 6117, 5752, 5753, 6673, 6672, 4808, 4878, 
         8098, 5780, 5415, 5857, 5856, 4804, 4876, 6558, 5293, 6321, 5294, 
         6745, 6746, 6744, 5620, 7863, 6313, 6314, 6312, 6316, 6315, 6367, 
         6310, 6311}],
        RowBox[{"-", "0.4`"}]],
       Annotation[#, -0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6329, 6195, 6196, 4840, 6748, 5621, 6747, 6750, 6749, 5314, 
         6189, 6903, 6904, 4883, 5980, 5882, 5883, 5459, 5786, 4884, 5981, 
         6077, 6078, 5829, 5083, 5984, 5084, 6469, 6470, 6468, 7218, 5215, 
         8089, 6925, 6926, 6924, 5643, 7905, 5320, 7651, 7652, 7648, 7650, 
         7649, 4908, 7791, 7792, 7790, 7794, 7793, 5322, 7430, 5323, 6929, 
         6930, 6476, 5219, 6475, 6478, 6477, 5093, 5989, 5092, 5833, 6089, 
         6088, 5991, 5898, 5899, 5377, 5901, 5900, 5995, 5908, 6203, 6202, 
         6592, 5338, 6651, 8006, 6652, 6650, 6974, 6975, 4856, 5767, 5731, 
         5837, 5836, 4913, 7877, 7878, 7876, 7880, 7879, 5627, 7984, 5692, 
         7983, 5691, 6852, 6851, 6256, 6657, 6656, 5343, 6350, 5342, 6600, 
         5915, 4866, 5913, 5914, 5382, 5912, 8106, 5911, 4865, 6718, 6719, 
         5772, 5771, 6131, 5100, 6501, 6502, 6500, 7241, 5238, 8093, 6716, 
         5486, 7739, 5487, 7740, 5485, 7742, 7743, 7741, 5488, 4912, 7708, 
         7709, 7707, 7711, 7710, 5472, 7952, 5662, 7951, 5661, 6491, 5229, 
         6490, 6493, 6492, 5098, 6127, 5765, 5766, 6708, 6707, 4853, 4891, 
         8103, 5788, 5469, 5897, 5896, 4847, 4889, 6587, 5329, 6344, 5330, 
         6752, 6753, 6751, 5622, 7864, 6331, 6332, 6330, 6334, 6333, 6397, 
         6328, 6329}],
        RowBox[{"-", "0.4`"}]],
       Annotation[#, -0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{6168, 5066, 6317, 6369, 6368, 7369, 7370, 7368, 7372, 7371, 
         5260, 6535, 5259, 7367, 5820, 4874, 4799, 6537, 5261, 6536, 5262, 
         7378, 7379, 7375, 7377, 7376, 6373, 6374, 6323, 5072, 6322, 5071, 
         7929, 7930, 7041, 7042, 4948, 6067, 4949, 7044, 7043, 7115, 7114, 
         5017, 6116, 5018, 7117, 7116, 5512, 5802, 4950, 5210, 7212, 7214, 
         7213, 5134, 6225, 6226, 6227, 6899, 4811, 5930, 4816, 6901, 6462, 
         5211, 6461, 5212, 7278, 7279, 7275, 7277, 7276, 4957, 5804, 5515, 
         7124, 7125, 5022, 6120, 5021, 7122, 7123, 7050, 7051, 4959, 6014, 
         6778, 6779, 6777, 6781, 6780, 5081, 7153, 5082, 6327, 6521, 8019, 
         5040, 7328, 7329, 7327, 7331, 7330, 5054, 6143, 5053, 8023, 5690, 
         6183, 4817, 5932, 5826, 6518, 5249, 6517, 5250, 7325, 7326, 7322, 
         7324, 7323, 5039, 6299, 6839, 6838, 5634, 6160, 6161, 5814, 5052, 
         6847, 6764, 6618, 6619, 6617, 7451, 7450, 6010, 4943, 7033, 6269, 
         6669, 6668, 6762, 5967, 5014, 7109, 7108, 5509, 5800, 4938, 7202, 
         7203, 7201, 7205, 7204, 5194, 7191, 5193, 8086, 6509, 7265, 7264, 
         5924, 6442, 6443, 6441, 6440, 6213, 5115, 7260, 7261, 7257, 7259, 
         7258, 4936, 5799, 5506, 7104, 7105, 5011, 5962, 7888, 7534, 7535, 
         7015, 7016, 4935, 6055, 4934, 7014, 7013, 7533, 7532, 6177, 6168}],
        RowBox[{"-", "0.6`"}]],
       Annotation[#, -0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6188, 5088, 6335, 6399, 6398, 7384, 7385, 7383, 7387, 7386, 
         5264, 6538, 5263, 7382, 5831, 4887, 4841, 6540, 5265, 6539, 5266, 
         7393, 7394, 7390, 7392, 7391, 6404, 6405, 6346, 5091, 6345, 5090, 
         7941, 7942, 7082, 7083, 4990, 6101, 4991, 7085, 7084, 7137, 7136, 
         5029, 6126, 5030, 7139, 7138, 5524, 5809, 4992, 5235, 7236, 7238, 
         7237, 5166, 6248, 6249, 6250, 6952, 4855, 5937, 4859, 6954, 6499, 
         5236, 6498, 5237, 7303, 7304, 7300, 7302, 7301, 5000, 5811, 5528, 
         7146, 7147, 5034, 6130, 5033, 7144, 7145, 7096, 7097, 5004, 6026, 
         6796, 6797, 6795, 6799, 6798, 5101, 7154, 5102, 6351, 6526, 8020, 
         5042, 7338, 7339, 7337, 7341, 7340, 5057, 6144, 5056, 8024, 5693, 
         6206, 4860, 5939, 5835, 6523, 5251, 6522, 5252, 7335, 7336, 7332, 
         7334, 7333, 5041, 6300, 6841, 6840, 5645, 6162, 6163, 5815, 5055, 
         6850, 6767, 6645, 6646, 6644, 7463, 7462, 6024, 4987, 7074, 6286, 
         6704, 6703, 6765, 5990, 5027, 7133, 7132, 5522, 5806, 4978, 7225, 
         7226, 7224, 7228, 7227, 5218, 7219, 5217, 8090, 6510, 7288, 7287, 
         5934, 6473, 6474, 6472, 6471, 6238, 5150, 7283, 7284, 7280, 7282, 
         7281, 4976, 5805, 5518, 7126, 7127, 5023, 5985, 7904, 7646, 7647, 
         7056, 7057, 4975, 6087, 4974, 7055, 7054, 7645, 7644, 6197, 6188}],
        RowBox[{"-", "0.6`"}]],
       Annotation[#, -0.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{7027, 5198, 7896, 7897, 6891, 4805, 7557, 7558, 7556, 7560, 
         7559, 5412, 7564, 7565, 7561, 7563, 7562, 4806, 6892, 7899, 7898, 
         5192, 7017, 7018, 7019, 7263, 7262, 4937, 7199, 7200, 7160, 5122, 
         7159, 5123, 7900, 7901, 6893, 6894, 6895, 6062, 6063, 5742, 6065, 
         6064, 5362, 6860, 5735, 6859, 5736, 6861, 5703, 7988, 5704, 6958, 
         6959, 5748, 5747, 6155, 5698, 6137, 6136, 5046, 6151, 7932, 7933, 
         7931, 5650, 5949, 5948, 6545, 6519, 6520, 6275, 6274, 6273, 5205, 
         7614, 7615, 7613, 5424, 4880, 5783, 5726, 6074, 6073, 5365, 7579, 
         7580, 7576, 7578, 7577, 7610, 5423, 7609, 7612, 7611, 5136, 7165, 
         5135, 7166, 7274, 7273, 4951, 7215, 7216, 7047, 7046, 7045, 5204, 
         7782, 7783, 7781, 5513, 7567, 7568, 7566, 7570, 7569, 5413, 7776, 
         7777, 7773, 7775, 7774, 7963, 5670, 7962, 7965, 7964, 5199, 7030, 
         7031, 7032, 7381, 7380, 4942, 7373, 7374, 7029, 7028, 7027}],
        RowBox[{"-", "0.8`"}]],
       Annotation[#, -0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7068, 5225, 7912, 7913, 6940, 4848, 7665, 7666, 7664, 7668, 
         7667, 5465, 7672, 7673, 7669, 7671, 7670, 4849, 6941, 7915, 7914, 
         5216, 7058, 7059, 7060, 7286, 7285, 4977, 7222, 7223, 7169, 5154, 
         7168, 5155, 7916, 7917, 6942, 6943, 6944, 6093, 6094, 5743, 6096, 
         6095, 5376, 6863, 5737, 6862, 5738, 6864, 5719, 7989, 5720, 6970, 
         6971, 5762, 5761, 6156, 5699, 6139, 6138, 5047, 6152, 7944, 7945, 
         7943, 5659, 5951, 5950, 6546, 6524, 6525, 6290, 6289, 6288, 5231, 
         7717, 7718, 7716, 5474, 4893, 5790, 5727, 6105, 6104, 5380, 7697, 
         7698, 7694, 7696, 7695, 7713, 5473, 7712, 7715, 7714, 5168, 7174, 
         5167, 7175, 7299, 7298, 4993, 7239, 7240, 7088, 7087, 7086, 5230, 
         7817, 7818, 7816, 5525, 7675, 7676, 7674, 7678, 7677, 5466, 7809, 
         7810, 7806, 7808, 7807, 7967, 5671, 7966, 7969, 7968, 5226, 7071, 
         7072, 7073, 7396, 7395, 4986, 7388, 7389, 7070, 7069, 7068}],
        RowBox[{"-", "0.8`"}]],
       Annotation[#, -0.8, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->
   NCache[{{0, 2 Pi}, {0, 2 Pi}}, {{0, 6.283185307179586}, {
     0, 6.283185307179586}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 187},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->411739434]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->623443467],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Lighter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Lighter"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["Blend",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Blend"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->10318589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Lighter", "[", 
    RowBox[{"Blue", ",", 
     RowBox[{"1", "/", "3"}]}], "]"}], ",", 
   RowBox[{"Blend", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Blue", ",", "White"}], "}"}], ",", 
     RowBox[{"1", "/", "3"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->402042092],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"RGBColor", "[", 
    RowBox[{
     FractionBox["1", "3"], ",", 
     FractionBox["1", "3"], ",", "1"}], "]"}], ",", 
   RowBox[{"RGBColor", "[", 
    RowBox[{
     FractionBox["1", "3"], ",", 
     FractionBox["1", "3"], ",", "1"}], "]"}]}], "}"}]], "Output",
 ImageSize->{273, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->115457506]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Lighter", "[", 
       RowBox[{"Blue", ",", 
        RowBox[{"1", "/", "3"}]}], "]"}], ",", 
      RowBox[{"Rectangle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Blend", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Blue", ",", "White"}], "}"}], ",", 
        RowBox[{"1", "/", "3"}]}], "]"}], ",", 
      RowBox[{"Rectangle", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->46634163],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwPALiNAkGIPs/kAXG
j/7/B9KYJCeQjA8N/S8IpblGRUdFR0VJEmUBkkzATMaMJssMFWcFqwLxGJhB
eREMMFSzoskzDXFd6Ko5yTYFFIZcZOlmQxPnwGsKE5ooC5IpIDdw4jCVEawb
4giwIAMbWsixA2lQwQxSyYjXLkG8dgyGeB3VRbwu4kqGwVCGjYqOig4NUcw2
LAMjAB5SbaU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{226, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->8193653]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5872900],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Lighter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Lighter"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Darker",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Darker"]], "InlineFormula"],
 " are not commutative:"
}], "ExampleText",
 CellID->81595963],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Darker", "[", 
  RowBox[{
   RowBox[{"Lighter", "[", 
    RowBox[{"Red", ",", ".5"}], "]"}], ",", ".5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->90728669],

Cell[BoxData[
 RowBox[{"RGBColor", "[", 
  RowBox[{"0.5`", ",", "0.25`", ",", "0.25`"}], "]"}]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->46409775]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Lighter", "[", 
  RowBox[{
   RowBox[{"Darker", "[", 
    RowBox[{"Red", ",", ".5"}], "]"}], ",", ".5"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->794083643],

Cell[BoxData[
 RowBox[{"RGBColor", "[", 
  RowBox[{"0.75`", ",", "0.5`", ",", "0.5`"}], "]"}]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->246914727]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->201773813],

Cell["Values outside of the 0, 1 range will be clipped: ", "ExampleText",
 CellID->318150803],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Lighter", "[", 
       RowBox[{"Blue", ",", "i"}], "]"}], ",", 
      RowBox[{"EdgeForm", "[", 
       RowBox[{"Opacity", "[", ".1", "]"}], "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"5", "i"}], ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"0", "-", 
       RowBox[{"1", "/", "4"}]}], ",", 
      RowBox[{"1", "+", 
       RowBox[{"1", "/", "4"}]}], ",", 
      RowBox[{"1", "/", "4"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->375505139],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0, 0, 1], EdgeForm[Opacity[0.1]], 
    DiskBox[NCache[{Rational[-5, 4], 0}, {-1.25, 0}]]}, 
   {RGBColor[0, 0, 1], EdgeForm[Opacity[0.1]], DiskBox[{0, 0}]}, 
   {RGBColor[
     NCache[
      Rational[1, 4], 0.25], 
     NCache[
      Rational[1, 4], 0.25], 1], EdgeForm[Opacity[0.1]], 
    DiskBox[NCache[{Rational[5, 4], 0}, {1.25, 0}]]}, 
   {RGBColor[
     NCache[
      Rational[1, 2], 0.5], 
     NCache[
      Rational[1, 2], 0.5], 1], EdgeForm[Opacity[0.1]], 
    DiskBox[NCache[{Rational[5, 2], 0}, {2.5, 0}]]}, 
   {RGBColor[
     NCache[
      Rational[3, 4], 0.75], 
     NCache[
      Rational[3, 4], 0.75], 1], EdgeForm[Opacity[0.1]], 
    DiskBox[NCache[{Rational[15, 4], 0}, {3.75, 0}]]}, 
   {RGBColor[1, 1, 1], EdgeForm[Opacity[0.1]], DiskBox[{5, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[Opacity[0.1]], 
    DiskBox[NCache[{Rational[25, 4], 0}, {6.25, 0}]]}}]], "Output",
 ImageSize->{184, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->151048759]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->104895969],

Cell["Some colors may look faded during the lightening:", "ExampleText",
 CellID->160395668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Lighter", "[", 
       RowBox[{"Brown", ",", "i"}], "]"}], ",", 
      RowBox[{"EdgeForm", "[", 
       RowBox[{"Opacity", "[", ".1", "]"}], "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"7", "i"}], ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "1", ",", 
      RowBox[{"1", "/", "6"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->313158877],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0.6, 0.4, 0.2], EdgeForm[Opacity[0.1]], DiskBox[{0, 0}]}, 
   {RGBColor[0.6666666666666666, 0.5, 0.33333333333333337`], EdgeForm[Opacity[
    0.1]], DiskBox[NCache[{Rational[7, 6], 0}, {1.1666666666666667`, 0}]]}, 
   {RGBColor[0.7333333333333333, 0.6, 0.4666666666666667], EdgeForm[Opacity[
    0.1]], DiskBox[NCache[{Rational[7, 3], 0}, {2.3333333333333335`, 0}]]}, 
   {RGBColor[0.8, 0.7, 0.6000000000000001], EdgeForm[Opacity[0.1]], 
    DiskBox[NCache[{Rational[7, 2], 0}, {3.5, 0}]]}, 
   {RGBColor[0.8666666666666667, 0.8, 0.7333333333333334], EdgeForm[Opacity[
    0.1]], DiskBox[NCache[{Rational[14, 3], 0}, {4.666666666666667, 0}]]}, 
   {RGBColor[0.9333333333333333, 0.9, 0.8666666666666667], EdgeForm[Opacity[
    0.1]], DiskBox[NCache[{Rational[35, 6], 0}, {5.833333333333333, 0}]]}, 
   {RGBColor[1, 1, 1], EdgeForm[Opacity[0.1]], DiskBox[{7, 0}]}}]], "Output",
 ImageSize->{184, 46},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37885963]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->717322865],

Cell["Tilted bumpy texture:", "ExampleText",
 CellID->429721330],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{
          RowBox[{"RandomReal", "[", 
           RowBox[{"7", ",", "2"}], "]"}], ".", 
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", 
        RowBox[{"{", "10", "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10", ",", ".05"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "10", ",", ".05"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Lighter", "[", 
       RowBox[{"Blue", ",", "#"}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->100776691],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->380908473]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28617],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Darker",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Darker"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Blend",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Blend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GrayLevel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GrayLevel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorSlider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorSlider"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20489]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->19904695],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->463090626],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "MoreAbout",
 CellID->243835584],

Cell[TextData[ButtonBox["New in 6.0: Graphics Primitives & Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]], "MoreAbout",
 CellID->652025529],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->140539476]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Lighter - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 53, 1.5932186}", "context" -> "System`", 
    "keywords" -> {"blending colors", "lightening colors"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Lighter[color] represents a lighter version of the specified color. \
Lighter[color, f] represents a version of the specified color lightened by a \
fraction f. ", "synonyms" -> {}, "title" -> "Lighter", "type" -> "Symbol", 
    "uri" -> "ref/Lighter"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8243, 271, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->280035682]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 375922, 6882}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2009, 45, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2632, 72, 1572, 37, 70, "ObjectNameGrid"],
Cell[4207, 111, 957, 30, 70, "Usage",
 CellID->11980]
}, Open  ]],
Cell[CellGroupData[{
Cell[5201, 146, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5679, 163, 346, 13, 70, "Notes",
 CellID->27452],
Cell[6028, 178, 407, 16, 70, "Notes",
 CellID->29936],
Cell[6438, 196, 557, 21, 70, "Notes",
 CellID->39054001],
Cell[6998, 219, 470, 18, 70, "Notes",
 CellID->741047295],
Cell[7471, 239, 735, 27, 70, "Notes",
 CellID->142410365]
}, Closed]],
Cell[CellGroupData[{
Cell[8243, 271, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->280035682],
Cell[CellGroupData[{
Cell[8628, 285, 148, 5, 70, "ExampleSection",
 CellID->762780864],
Cell[8779, 292, 69, 1, 70, "ExampleText",
 CellID->767779510],
Cell[CellGroupData[{
Cell[8873, 297, 217, 7, 28, "Input",
 CellID->436072821],
Cell[9093, 306, 366, 12, 121, "Output",
 CellID->41773818]
}, Open  ]],
Cell[CellGroupData[{
Cell[9496, 323, 223, 7, 28, "Input",
 CellID->242052465],
Cell[9722, 332, 13387, 227, 129, 190, 6, "CachedBoxData", "BoxData", "Output",
 
 CellID->487860516]
}, Open  ]],
Cell[23124, 562, 125, 3, 70, "ExampleDelimiter",
 CellID->903623061],
Cell[23252, 567, 117, 3, 70, "ExampleText",
 CellID->97439614],
Cell[CellGroupData[{
Cell[23394, 574, 362, 12, 70, "Input",
 CellID->814434644],
Cell[23759, 588, 461, 14, 123, "Output",
 CellID->86200806]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24269, 608, 220, 7, 70, "ExampleSection",
 CellID->461483603],
Cell[24492, 617, 151, 3, 70, "ExampleText",
 CellID->605430022],
Cell[CellGroupData[{
Cell[24668, 624, 163, 5, 70, "Input",
 CellID->120341336],
Cell[24834, 631, 160, 5, 36, "Output",
 CellID->69847403]
}, Open  ]],
Cell[CellGroupData[{
Cell[25031, 641, 419, 14, 70, "Input",
 CellID->2465115],
Cell[25453, 657, 366, 12, 123, "Output",
 CellID->65841739]
}, Open  ]],
Cell[25834, 672, 124, 3, 70, "ExampleDelimiter",
 CellID->99167612],
Cell[25961, 677, 151, 3, 70, "ExampleText",
 CellID->119480312],
Cell[CellGroupData[{
Cell[26137, 684, 302, 10, 70, "Input",
 CellID->212616857],
Cell[26442, 696, 161, 5, 36, "Output",
 CellID->311047381]
}, Open  ]],
Cell[CellGroupData[{
Cell[26640, 706, 570, 18, 70, "Input",
 CellID->144742854],
Cell[27213, 726, 422, 14, 123, "Output",
 CellID->108477867]
}, Open  ]],
Cell[27650, 743, 125, 3, 70, "ExampleDelimiter",
 CellID->392984429],
Cell[27778, 748, 235, 8, 70, "ExampleText",
 CellID->147092355],
Cell[CellGroupData[{
Cell[28038, 760, 213, 7, 70, "Input",
 CellID->72536915],
Cell[28254, 769, 160, 5, 36, "Output",
 CellID->46677077]
}, Open  ]],
Cell[CellGroupData[{
Cell[28451, 779, 496, 16, 70, "Input",
 CellID->402151439],
Cell[28950, 797, 519, 13, 70, "Output",
 Evaluatable->False,
 CellID->4958311]
}, Open  ]],
Cell[29484, 813, 125, 3, 70, "ExampleDelimiter",
 CellID->221324128],
Cell[29612, 818, 257, 8, 70, "ExampleText",
 CellID->69210275],
Cell[CellGroupData[{
Cell[29894, 830, 218, 7, 70, "Input",
 CellID->917995613],
Cell[30115, 839, 568, 19, 51, "Output",
 CellID->424864]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30732, 864, 227, 7, 70, "ExampleSection",
 CellID->142022708],
Cell[30962, 873, 343, 13, 70, "ExampleText",
 CellID->659069737],
Cell[CellGroupData[{
Cell[31330, 890, 702, 22, 70, "Input",
 CellID->138856842],
Cell[32035, 914, 39903, 658, 70, "Output",
 Evaluatable->False,
 CellID->339915852]
}, Open  ]],
Cell[CellGroupData[{
Cell[71975, 1577, 554, 19, 70, "Input",
 CellID->275027965],
Cell[72532, 1598, 52973, 883, 204, 25263, 424, "CachedBoxData", "BoxData", \
"Output",
 CellID->331098664]
}, Open  ]],
Cell[125520, 2484, 125, 3, 70, "ExampleDelimiter",
 CellID->412805249],
Cell[125648, 2489, 358, 13, 70, "ExampleText",
 CellID->367264277],
Cell[CellGroupData[{
Cell[126031, 2506, 827, 25, 70, "Input",
 CellID->37057173],
Cell[126861, 2533, 191541, 3160, 70, "Output",
 CellID->411739434]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[318451, 5699, 237, 7, 70, "ExampleSection",
 CellID->623443467],
Cell[318691, 5708, 316, 12, 70, "ExampleText",
 CellID->10318589],
Cell[CellGroupData[{
Cell[319032, 5724, 348, 12, 70, "Input",
 CellID->402042092],
Cell[319383, 5738, 442, 15, 51, "Output",
 CellID->115457506]
}, Open  ]],
Cell[CellGroupData[{
Cell[319862, 5758, 615, 20, 70, "Input",
 CellID->46634163],
Cell[320480, 5780, 519, 13, 70, "Output",
 Evaluatable->False,
 CellID->8193653]
}, Open  ]],
Cell[321014, 5796, 123, 3, 70, "ExampleDelimiter",
 CellID->5872900],
Cell[321140, 5801, 320, 12, 70, "ExampleText",
 CellID->81595963],
Cell[CellGroupData[{
Cell[321485, 5817, 188, 6, 70, "Input",
 CellID->90728669],
Cell[321676, 5825, 236, 7, 36, "Output",
 CellID->46409775]
}, Open  ]],
Cell[CellGroupData[{
Cell[321949, 5837, 189, 6, 70, "Input",
 CellID->794083643],
Cell[322141, 5845, 236, 7, 36, "Output",
 CellID->246914727]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[322426, 5858, 230, 7, 70, "ExampleSection",
 CellID->201773813],
Cell[322659, 5867, 93, 1, 70, "ExampleText",
 CellID->318150803],
Cell[CellGroupData[{
Cell[322777, 5872, 694, 22, 70, "Input",
 CellID->375505139],
Cell[323474, 5896, 1059, 30, 65, "Output",
 CellID->151048759]
}, Open  ]],
Cell[324548, 5929, 125, 3, 70, "ExampleDelimiter",
 CellID->104895969],
Cell[324676, 5934, 92, 1, 70, "ExampleText",
 CellID->160395668],
Cell[CellGroupData[{
Cell[324793, 5939, 585, 18, 70, "Input",
 CellID->313158877],
Cell[325381, 5959, 1047, 18, 67, "Output",
 CellID->37885963]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[326477, 5983, 228, 7, 70, "ExampleSection",
 CellID->717322865],
Cell[326708, 5992, 64, 1, 70, "ExampleText",
 CellID->429721330],
Cell[CellGroupData[{
Cell[326797, 5997, 841, 25, 70, "Input",
 CellID->100776691],
Cell[327641, 6024, 44775, 738, 70, "Output",
 Evaluatable->False,
 CellID->380908473]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[372477, 6769, 311, 9, 70, "SeeAlsoSection",
 CellID->28617],
Cell[372791, 6780, 939, 35, 70, "SeeAlso",
 CellID->20489]
}, Open  ]],
Cell[CellGroupData[{
Cell[373767, 6820, 318, 9, 70, "MoreAboutSection",
 CellID->19904695],
Cell[374088, 6831, 124, 3, 70, "MoreAbout",
 CellID->463090626],
Cell[374215, 6836, 163, 3, 70, "MoreAbout",
 CellID->243835584],
Cell[374381, 6841, 197, 4, 70, "MoreAbout",
 CellID->652025529],
Cell[374581, 6847, 179, 3, 70, "MoreAbout",
 CellID->140539476]
}, Open  ]],
Cell[374775, 6853, 27, 0, 70, "History"],
Cell[374805, 6855, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

