(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   1242980,      23894]
NotebookOptionsPosition[   1215963,      22996]
NotebookOutlinePosition[   1217491,      23037]
CellTagsIndexPosition[   1217402,      23032]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Three\[Hyphen]Dimensional Graphics Directives" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ThreeDimensionalGraphicsDirectives"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Three\[Hyphen]Dimensional Graphics Directives\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RGBColor" :> Documentation`HelpLookup["paclet:ref/RGBColor"], 
          "Specularity" :> Documentation`HelpLookup["paclet:ref/Specularity"],
           "Glow" :> Documentation`HelpLookup["paclet:ref/Glow"], 
          "ColorFunction" :> 
          Documentation`HelpLookup["paclet:ref/ColorFunction"], 
          "NormalsFunction" :> 
          Documentation`HelpLookup["paclet:ref/NormalsFunction"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"RGBColor\"\>", 
       2->"\<\"Specularity\"\>", 3->"\<\"Glow\"\>", 
       4->"\<\"ColorFunction\"\>", 
       5->"\<\"NormalsFunction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Graphics Options" :> 
          Documentation`HelpLookup["paclet:guide/3DGraphicsOptions"], 
          "Graphics Directives" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsDirectives"], 
          "Graphics Options & Styling" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsOptionsAndStyling"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"3D Graphics Options\"\>", 
       2->"\<\"Graphics Directives\"\>", 
       3->"\<\"Graphics Options & Styling\"\>", 
       4->"\<\"New in 6.0: Graphics & Visualization Options\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Lighting", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Lighting",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Lighting"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Graphics3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
     " and related functions that specifies what simulated lighting to use in \
coloring 3D surfaces. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29886]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following settings can be given: ", "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->11078],

Cell[BoxData[GridBox[{
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "default lighting schemes", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["no lighting ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[TextData[{
     "light sources ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", ",
     StyleBox["\[Ellipsis]", "TR"],
     "  "
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", Cell[
    "named lighting configuration", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {
      Dynamic[
       If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
        RGBColor[0.92, 1, 0.59], None]]}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->3443],

Cell["Each light source can be of the following forms: ", "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->3280],

Cell[BoxData[GridBox[{
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{"\"\<Ambient\>\"", ",", 
      StyleBox["col", "TI"]}], "}"}], Cell[TextData[{
     "uniform ambient light of color ",
     Cell[BoxData[
      StyleBox["col", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{"\"\<Directional\>\"", ",", 
      StyleBox["col", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["pt", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["pt", "TI"], 
         StyleBox["2", "TR"]]}], "}"}]}], "}"}], Cell[TextData[{
     "directional light along the vector from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{"\"\<Point\>\"", ",", 
      StyleBox["col", "TI"], ",", 
      StyleBox["pt", "TI"]}], "}"}], Cell[TextData[{
     "spherical point light source at position ",
     Cell[BoxData[
      StyleBox["pt", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{"\"\<Point\>\"", ",", 
      StyleBox["col", "TI"], ",", 
      StyleBox["pt", "TI"], ",", 
      StyleBox["att", "TI"]}], "}"}], Cell[TextData[{
     "point light with geometric attenuation ",
     Cell[BoxData[
      StyleBox["att", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{"\"\<Spot\>\"", ",", 
      StyleBox["col", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["pt", "TI"], ",", 
        StyleBox["tar", "TI"]}], "}"}], ",", 
      StyleBox["\[Alpha]", "TR"]}], "}"}], Cell[TextData[{
     "spotlight at ",
     Cell[BoxData[
      StyleBox["pt", "TI"]], "InlineFormula"],
     " aimed at ",
     Cell[BoxData[
      StyleBox["tar", "TI"]], "InlineFormula"],
     " with half-angle ",
     Cell[BoxData[
      StyleBox["\[Alpha]", "TR"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{"\"\<Spot\>\"", ",", 
      StyleBox["col", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["pt", "TI"], ",", 
        StyleBox["tar", "TI"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["\[Alpha]", "TR"], ",", 
        StyleBox["s", "TI"]}], "}"}], ",", 
      StyleBox["att", "TI"]}], "}"}], Cell[TextData[{
     "spotlight with spot exponent ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " and attenuation ",
     Cell[BoxData[
      StyleBox["att", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {
      Dynamic[
       If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
        RGBColor[0.92, 1, 0.59], None]]}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->186870567],

Cell["\<\
Light source positions and aiming points can be specified as follows: \
\>", "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->345083096],

Cell[BoxData[GridBox[{
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"], ",", 
      StyleBox["z", "TI"]}], "}"}], Cell[
    "explicit coordinates that move with the graphic ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["Scaled",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Scaled"], "[", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["x", "TI"], ",", 
       StyleBox["y", "TI"], ",", 
       StyleBox["z", "TI"]}], "}"}], "]"}], Cell[
    "scaled coordinates that move with the graphic ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["ImageScaled",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ImageScaled"], "[", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["x", "TI"], ",", 
       StyleBox["y", "TI"], ",", 
       StyleBox["z", "TI"]}], "}"}], "]"}], Cell[
    "coordinates fixed relative to the final displayed image ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {
      Dynamic[
       If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
        RGBColor[0.92, 1, 0.59], None]]}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->69135887],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ImageScaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageScaled"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["z", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 ", the ",
 Cell[BoxData[
  FormBox[Cell[TextData[Cell[BoxData[
    StyleBox["x", "TI"]], "InlineFormula"]], "InlineFormula"], 
   TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[Cell[TextData[Cell[BoxData[
    StyleBox["y", "TI"]], "InlineFormula"]], "InlineFormula"], 
   TraditionalForm]], "InlineMath"],
 " run from 0 to 1 across the width and height of the bounding box of the \
final displayed image. The ",
 Cell[BoxData[
  FormBox[Cell[TextData[Cell[BoxData[
    StyleBox["z", "TI"]], "InlineFormula"]], "InlineFormula"], 
   TraditionalForm]], "InlineMath"],
 " coordinate runs orthogonal to the plane of the display, and is 0 at the \
back of the 3D region, and 1 at the front. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->24966],

Cell[TextData[{
 "Coordinates specified in ",
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ImageScaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageScaled"]], "InlineFormula"],
 " will often not be between 0 and 1. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->8470],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Lighting", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " uses ambient light together with four light sources fixed relative to the \
final displayed image. With the typical default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ColorFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorFunction"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", colored light sources are used; if an explicit setting for ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " is given, the light sources are taken to be white."
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->28762],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Lighting", "->", "\"\<Neutral\>\""}]], "InlineFormula"],
 " always uses white light sources in the default positions."
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->26976598],

Cell[TextData[{
 "Lighting can be specified globally for a 3D graphic by giving a ",
 Cell[BoxData[
  ButtonBox["Lighting",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Lighting"]], "InlineFormula"],
 " option for ",
 Cell[BoxData[
  ButtonBox["Plot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot3D"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 ", etc. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->27810],

Cell[TextData[{
 "Lighting can be specified separately for particular objects in ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " by giving a style option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"], "[", 
   RowBox[{
    StyleBox["obj", "TI"], ",", 
    RowBox[{"Lighting", "->", 
     StyleBox["spec", "TI"]}]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->15809],

Cell[TextData[{
 "In a list of graphics primitives and directives, the alternative form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["\[Ellipsis]", "TR"], ",", 
    StyleBox["g", "TI"], ",", 
    RowBox[{"Lighting", "->", 
     StyleBox["spec", "TI"]}], ",", 
    StyleBox["g", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 " defines lighting for objects that follow the lighting specification in the \
list. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->11248],

Cell["\<\
The final colors of 3D surfaces are determined by linearly adding RGB colors \
from three sources: \
\>", "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->25196],

Cell[BoxData[GridBox[{
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    StyleBox[Cell[TextData[{
      "diffuse reflection defined by ",
      Cell[BoxData[
       ButtonBox["RGBColor",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
      ", etc. directives "
     }], "TableText"],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]"},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    StyleBox[Cell[TextData[{
      "specular reflection defined by ",
      Cell[BoxData[
       ButtonBox["Specularity",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Specularity"]], "InlineFormula"],
      " directives "
     }], "TableText"],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]"},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    StyleBox[Cell[TextData[{
      "glow defined by ",
      Cell[BoxData[
       ButtonBox["Glow",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Glow"]], "InlineFormula"],
      " directives "
     }], "TableText"],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]"}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {
      Dynamic[
       If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
        RGBColor[0.92, 1, 0.59], None]]}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, False, False, False}}}},
 CellID->2770],

Cell[TextData[{
 "The setting for ",
 Cell[BoxData[
  ButtonBox["Lighting",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Lighting"]], "InlineFormula"],
 " affects only colors associated with diffuse and specular reflection. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->318],

Cell["\<\
Diffuse reflection is taken to follow Lambert's law, with light effectively \
scattered equally in all directions from a surface. \
\>", "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->5517],

Cell[TextData[{
 "Specular reflection effectively takes light to be scattered only close to \
the mirror\[Hyphen]reflection direction, as specified in the notes for ",
 Cell[BoxData[
  ButtonBox["Specularity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Specularity"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->24214],

Cell[TextData[{
 "Colors of light sources can be defined by ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Hue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hue"]], "InlineFormula"],
 " or any other color specification. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->27532],

Cell[TextData[{
 "Light sources with color specifications of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["dcol", "TI"], ",", 
    RowBox[{
     ButtonBox["Specularity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Specularity"], "[", 
     StyleBox["scol", "TI"], "]"}]}], "}"}]], "InlineFormula"],
 " are effectively taken to have colors ",
 Cell[BoxData[
  StyleBox["dcol", "TI"]], "InlineFormula"],
 " for purposes of diffuse reflection, and ",
 Cell[BoxData[
  StyleBox["scol", "TI"]], "InlineFormula"],
 " for purposes of specular reflection. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->24237],

Cell[TextData[{
 "Directional light sources specified by ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"\"\<Directional\>\"", ",", 
    StyleBox["col", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["2", "TR"]]}], "}"}]}], "}"}]], "InlineFormula"],
 " are taken to yield parallel simulated light rays, so only the direction \
vector defined by ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["pt", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["pt", "TI"], 
     StyleBox["2", "TR"]]}], "}"}]], "InlineFormula"],
 " is relevant, not its magnitude."
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->784051116],

Cell[TextData[{
 "Point light sources specified by ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"\"\<Point\>\"", ",", 
    StyleBox["col", "TI"], ",", 
    StyleBox["pt", "TI"]}], "}"}]], "InlineFormula"],
 " effectively yield light that emanates from the point ",
 Cell[BoxData[
  StyleBox["pt", "TI"]], "InlineFormula"],
 ", but does not attenuate with distance."
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->788340243],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"\"\<Point\>\"", ",", 
    StyleBox["col", "TI"], ",", 
    StyleBox["pt", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"], ",", 
      StyleBox["c", "TI"]}], "}"}]}], "}"}]], "InlineFormula"],
 " yields light that attenuates like ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"1", "/", "c"}], " ", 
     SuperscriptBox["r", "2"]}], "+", 
    RowBox[{"b", " ", "r"}], "+", "a"}], TraditionalForm]], "InlineMath"],
 " with distance ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->214237085],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"\"\<Spot\>\"", ",", 
    StyleBox["col", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["pt", "TI"], ",", 
      StyleBox["tar", "TI"]}], "}"}], ",", 
    StyleBox["\[Alpha]", "TR"]}], "}"}]], "InlineFormula"],
 " yields the same light distribution as a point light source, except that it \
is restricted to a cone with direction from ",
 Cell[BoxData[
  StyleBox["pt", "TI"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  StyleBox["tar", "TI"]], "InlineFormula"],
 ", and with half-angle ",
 Cell[BoxData[
  FormBox[Cell[TextData[Cell[BoxData[
    StyleBox["\[Alpha]", "TR"]], "InlineFormula"]], "InlineFormula"], 
   TraditionalForm]], "InlineMath"],
 " in radians. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->3174814],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"\"\<Spot\>\"", ",", 
    StyleBox["col", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["pt", "TI"], ",", 
      StyleBox["tar", "TI"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["\[Alpha]", "TR"], ",", 
      StyleBox["s", "TI"]}], "}"}]}], "}"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["cos", "s"], "\[Theta]"}], TraditionalForm]], 
  "InlineMath"],
 " fall-off away from the center of the cone."
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->496911707],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"\"\<Spot\>\"", ",", 
    StyleBox["col", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["pt", "TI"], ",", 
      StyleBox["tar", "TI"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["\[Alpha]", "TR"], ",", 
      StyleBox["s", "TI"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"], ",", 
      StyleBox["c", "TI"]}], "}"}]}], "}"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"1", "/", "c"}], " ", 
     SuperscriptBox["r", "2"]}], "+", 
    RowBox[{"b", " ", "r"}], "+", "a"}], TraditionalForm]], "InlineMath"],
 " attenuation with distance ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 "."
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->272442434]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->138389441],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->157190817],

Cell["Default lighting on gray specular sphere:", "ExampleText",
 CellID->277599385],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"GrayLevel", "[", ".25", "]"}], ",", 
     RowBox[{"Specularity", "[", 
      RowBox[{"White", ",", "10"}], "]"}], ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->267039481],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0.25], Specularity[
    GrayLevel[1], 10], SphereBox[{0, 0, 0}]},
  Lighting->Automatic]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->455394567,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->436050271],

Cell["Neutral lighting on gray specular sphere:", "ExampleText",
 CellID->19851033],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"GrayLevel", "[", ".25", "]"}], ",", 
     RowBox[{"Specularity", "[", 
      RowBox[{"White", ",", "10"}], "]"}], ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->640566825],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0.25], Specularity[
    GrayLevel[1], 10], SphereBox[{0, 0, 0}]},
  Lighting->"Neutral"]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->171842464,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2860734],

Cell["Directional light from the top of the specular surface:", "ExampleText",
 CellID->59354230],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "9"}], "}"}]}], "]"}], ",", 
   RowBox[{"InterpolationOrder", "\[Rule]", "2"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"Specularity", "[", 
     RowBox[{"White", ",", "40"}], "]"}]}], ",", 
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"\"\<Directional\>\"", ",", 
       RowBox[{"RGBColor", "[", 
        RowBox[{"1", ",", ".7", ",", ".1"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"5", ",", "5", ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "5", ",", "0"}], "}"}]}], "}"}]}], "}"}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->794313532],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylnQeYVdW1+E/uFIYy9dbpiKBJTMxLU+NL7CIWBAtWUBFBUNGhBBAURamK
ICIIgiBVQBCQYsSuoAIqooAYEQQRqSK9zf3+/99aa58zw2XIy8vzw5k79567
z16979O0ddf2bTu27tqhTev6l3VuXdG+Q5su9Rs/0Jm30n7hed58/h+S8Hj9
/3il/89PJpN8cMLPe/gZ4oIm+lcH+ZnOn0n9jxeX/cv3/9Nv5/FL3vjjcavk
8juN3yF5N63q+t/rVT3cpxn6adu2be0C92k3t0aW/6ndyH3axd2vdo2fVriV
s3Wf9qldkOm+d5r+2czdo9T9Fii8jOB6t2Zmtd17wXevPgEHhSeBNrvaHuWl
3KlWyjWNTrJm3O0s439aM+Xz1OsbnmT9iNtzPGW9tJTvp590PXkz7HZZVNMq
GcG3HP5S99owoEX1d33eKUlZM/14GNydT9c1mru/st1v24ARTtdJr07btJQr
fq0vW7pPTkm5bypGf6VX3+yubphydWbK1b/Uq290+0rFQIOUb6dyh0F3Vsq7
xe7ev/qPvu1z6xn/YueCINv5n5ImN3H3rVT+SN1DVsrnjYJVqq8dc/io71bN
/bdW+bP7VrgGGpYGlF82uODNx/Pf7pvvZaboCXlZO2XlhsetnO9+13VQF/ir
Zi0ZlP+PR/Nm9sh9r3/+N6MjO6fHDsyJH5ufSE/RVP7u5RaNasR/Pfep/FYZ
+fb5yFcjw8ufKnhvQL7na0+vHi/e6utuOqVLzvzeecuGFGycFD34euHBBYk9
s+LbJkfTA41Sdfc6Kfc7VXdxkbtrjiKBF4sH5q94uuCLZ8KfDi3gNSib2T3X
83WnvOKtBb3zpnfLndQpZ1aP3Dcey/v4yYJ1U2K7lpZVbmu499OyzS/Fvxwe
frtfvt4uM2UfdVP2obzuXZCsshCK2TqvPJgLkO8PyAcD3GDxoPx3++W/9kge
MDtKePm8gKALH8l7uXvuxE450/6eO+/hvHf75382tGDDpNjupWX7vjt1y9oG
q6YnPnyi4PU+cpl3nIWphvt/pS0LdY/FjvplNfBZjk+b5+/NZifQBhyxtw8G
5gMCW4Jm8x/OA2WBDQvzAsC4aE6v3KldZPdzeuYCIaCuGRHeOjG6eXJs3azE
l3OKPhgXe/Uh2f34B3LGdszWraX/RzCUpEhcSTXZUeo+dWe94e3qjb0v2/DJ
1tjRosfy3npceIEXc3vl8j77VZ5M83ERWfVseOnggjceE2iAA/DhjHf65YN5
oNn0QuTHCdFVw8PIybyH8vj6uPtznuuQzb2GtKlXpUGO5xMfznTflqg8V4cq
4T7V/Rfw4rFb6g64re5ghWL0PdkgDIaBhcEf7AQVDBD+hHfhFvaj+y/cPD66
5cXo+jEReJc9c6VBDQgQ8aMnCpY9VcD+140WQBBMLoAgLz6QM7J99rC29cDb
oNvl1o/fWter0ulV8GSn7DyUQoli/V2WclXU0SdVv+brkvzd+8Y63JH7Ptm6
3tN31WMzMAhsNqN77lylHSB4IVF72dADFADMZ08XfDMqsmGMQPL9uAh6C3lf
PkTE7KMnC7wQv70o4KIC+Gz75Oi+GTEIyJ98H4hH3ZMNuE/cUa9vy7r9WtYF
5X1uqfvITXUevL6O7VB8t7wa4A2dFM4CR+2Ez4c9rqvTs0UdFmX1fq3qcjP4
5Nm7s8cgXxU5aB+gYzdQxwshYV46cLHl1SPC6M0QgHlCTnYNBFALon4+LIxm
4+fKZ8Lrn4/smhqrnBPfPin6xfAwDAEtDSwAevTmug/fWMcLPXRDHS8TBPO7
VwsHHaAp7k/wOIoDHXG8R+XbCuXfs3jRtXntv19Tu9u1siArAyJoHHh73ad8
njX9AekAbsmgAqQKfbZymGO9HZOje6fHdr8UY+vw7IaxDkIgNzn7+aXY0Vfi
kIwrIRl69IWO2cPuqjfwtrp9bq7LHblv9+vqsIHuuodeN9Tpeb28MI/b18Cp
Hl6V/vA948Abi/Gic7PaXZrXNtigHfgCcSaMAAbh2MRLXXOgGgyJfMFuIP6f
oyIw4E9TY6GDL8e86MGZsT3TZN8GGJSETze+ENk1JXpoQeLoR8W75yc2TxCo
ZvfMHa3kgvmhFXfkvl6ILXhZtglANAQDFpvwLdhxtCnXX2c4HaK65Xe86HR1
7YqrawMRLzo1E6DAFDjiRjA6pBp6Vz2YBT5EsSBVwPL1c2H2+ePEKGy1d2bs
4KvxYwsSh+fGD7wcAzp0OWB+NzYCSwLdzwsSB1aUHNtef9+m8m/nJhA3dCYo
gslBGrvuore+/yogeqApELEVg6iXgtO/Vd2hbeo5KlSnkVJDfa+Q77EKYADD
MvwLyZK/4s8uiiLu1Fu5D90B60EhNDuygIygHHaC9JmxY/MSyUWFyTcLkx8U
HX2n8OBriZ+nCevBiT+8GN02Mbp7UeLgV6XH9pxy5Kf6u9eWrVyQeKNf/vS/
57IgogQfgD5ufd+Vte+5IssL3csP+Rv4uilSjTwIN9bAC3y+VJhOc/zWwIdJ
aNRUUBRiZe/XLNvxSl23mazLbYVStwmesMiYAOzRJ0MKvh8f3bUgcejj4qNr
yiu/OyX5/SnJ7+pXflJ86O3CvXPiQAxkAtOs+MHlxcmt5Uf3NNi3ouSntwpX
jY/OfzQPm8WCsByYgyYdr6p9z+VZ7Ztkhe6+LMurw2v200W5Baj6KZXgE75V
A1ymLxo6Wqm/eR4v+LqBBjgAxZodLpef9yl0fAqrwySgFuYHZSgLJBzzBHf9
tKjwwIbyyv24duDrl8ltpyZXlR17v+jAa4mfXo7thDNnx4+8nkh+VJxcXz95
4LSDGxvs+EcRrItrxCYxH4CG1gW0+33Q7m4iP9kDm2EDcA2gwTKAhgBiaMwf
q27dfL/COFDePK06dM0cO3Tw1wd5vAZe4wl4nG3AkkgE5hvFjPuE7tszO35o
VWnlQaBrJNAdOL1y3SnH3is6NCcuClHl7tD7RccAbU/DysOnH9jccP1bJahO
LDXQYaNRR70Muqa1DbHc2qBjP+C86zW1jSOHKHSTO4siroF25ouUJ2uO3tSz
zuJvkAXAhk3QB6jtLssKtW2c5Z3Fa0Mo0sGe2BnC/0xbcbzQkuh+LDKMuO/9
oqM/cJ+GySONkjsaVq4uP/pG4f4ZMXT8TszyzNjhpSWVPzaoPNSoch18XLpp
buH7wyMo2QkVOUNPIGd1gOFd7t5dRQWAB7cWgKEl313YO68GmKv0v7ypsfHv
eQHBwFonu8UVsj7w3XVpVptLBVi7EUhgGxgfPCSYbPS9gtnZD+Zistc+F976
SvznlSXHtpYnN5YlV5VULina/1pix/QYNmDXtNjBufHkO0XJr09J7ju98seG
x5aUok9RuBgAmAOiwosGY0fdgJcGfF72PcpQaDqU5sOqNGHYMfc5CNFx8FRN
2kb9jyAWru7ha0R7EX+Y+fy7Am0aAEAF4ksEaKBnA9wboLkSV2KAaiETVZgZ
WSOiwbRtI1Z8Q9XqPxK758Z/mBrDK+H9TeOjO5HTZcXJjQjp6Yd3nLb1w7IN
46J4AJgJFoFNsEEYI6iHyBjcJk33+HLERzgWgI0aHn+/3Pc1df1wJlxs6GeR
At8kyC2dmXSxIKyBOPS4XoG9ugpYL3TnJVnemQAM2HcbtM2qoEV4cEMROTgZ
P/sDjSgRYHTrvuliOzDtOCx4K6ufDfNi86vxPSuKk1vKk9+WJb8u3/5OyYoX
YgR7xsZmFwEGvdDVpEn1vjEw24L9NFmYxZU4pzAG5CXax+VbOzLsR3tiMwik
CWk974RsjGa71NeWN3/ne2oPq+sHCmByYzCwDIGBvvXFte5Uehv4nY8Hf0R7
cXfgtVkP5hKdwmvYHgKktQo1KgkOgBL8xBf95/jo1rcLD31bmlxfllxRvO+N
wjUvRPAqAARig0lUYeDl2E5MjSrUdbHgiBUcxl8zuuW+8Xj+R4NlWSIZfA7P
9+Qk6UFIzlbADrxQAxbSq/l2lgnUT10yVbEiHjBQ8o/bwh6wWRcVfRDTrnFW
mvBFHlgREbgqlSlG3J2NekP04UYiL/YBaywZlB/CHfSivGZzFjIvVQi+mxXf
/Unx4W/Ldi0u+v7l2OoXIm/2ywcrGB1UCOYPP+iRm0SlgxhLGOeKP9tCbhlY
X95G5JYNKVg/LvLj5ChW8AB2Ylbcc5pbsw2ZxHoQCm7Fo5vaNcc7McOadoL3
mBvgKeCaEl5AK/4Zw6IooFWAH8RFuOYSpyXur6YaB/qMY6E3AY6F3jBCSIIc
iTd5DSgQj8CHuBX2+WpsZPPc+J73Cn9YkPhiXGTJkwV8askQ1Dm6FtExzBSY
MPMTlgY/5vWZiYVLuYQAYjsx0cLEsXnxY3Pih1+JY2hUC9bCeSKkZ13idkQM
PepV0x7pJ8FMZrLm2LWG73D73/reN1SFX/iJUTR32DzIey531sX0jlkXUIj8
mwUdpI75SJW9SZ1zEAY2Pb+3YMth7pG8+Q/nzXtI6Ixy4R14jWACD0ii/4lR
jC64BtoZmt0yzNVnK7hb+JOQlZ+P3SrIC+KacV1zZrL6kIKlE2JcvnVOYt/s
OFg8+mr8p5dieGVwOHdlK5Iy6yx5DzxSdokaNy9e5fB/zIqrh1Wly4ILT8R+
CqcKFdiYWuxS3oUloDz/MCIGF+hDw2MscUk6NHHmDETfrQYF1KN1HlKvjO8S
SWLLgAJBntHdpXq8NJDspeE5gFosuxfCKfVq8yGCBQKIKEAyNoAXb2gOyQup
zoaVQIUlT4zwCAI/Q+zPK8R4IRGWwHl/YvTL1xPrl5Zs+/YUvnpsTTluwrYp
URTqy5rrYDNTFL2jNK0E81uSYqAGf4bl47CSFui6fxerVXFxVV7ndB+viC/3
5KehFmyBMzDXyff/2itqzUrfZ1ba9+UHawAGX2DwsJqzeki+CnZ1eDX+kURs
mqQwM9CeKEqc/sWD8iVjo3zaCIIgzGOUuWwnQmqlNq+hGwrYboFXSxT+KTy/
suTw3lOO/tSABX5+txiP02Jr4da/i/VFi7AxEDlQ6cNW4X1JcTkv4kS+zf/f
8ekJNaUqzDbyP8fLY+teSCLEQkRuiFP9ovfRDRXqmliwdI8fB1Z3v8whQSuY
7QG16PpFffK8kCTH0tEDxrigPYSQemmIv1luw+yp4N+y7ehVGAymhceeaSfy
y9ogiNfcAWShvcHadE1Eo41Xj4psmZ84srb08CfF++YnWGzZU4JfpAMyj9fk
ISsM1LQhm/VCQOWl84rf8rIq/+nzX+6/jd9UDZKaic9J+bxA2Zm/QTEGFnwB
64vKUcAHLwVeCMit8J0wQ7dlKHw9LJHMaOW06d1cUtsyqZYLx/LD1mAINHAB
2DI8/wpNAlnm+x9MrMgZr9hmByB8lPIiW7H9sTPLlIHPD54oWDa04ItXE5uW
FO9aUnzgrcIj/0hsmhTFkWDhWYptgBnRvirD10sTYT00S8S+Ldv3L/LnBf8x
3lMrMXWTfk3KOWj8J9WZWvLCUlLeGD8Bj9DDlhgjmN84BQyzVWF9P7zspAkd
yyjilyEbQ+50StpSbjgFoF18/zQcUS/t4ycL8B/ge8N7NkLBfUA6qMdg8oI7
T+rkbBV4ZzEIYBJYyluSWVcLwN74ApT97JnwlqmxXW8UHviu/Oj+Bj+tLN34
Spw74sVwDXcx9A++UwI2iV10/+bLWsrQC+EJncivVX+bZvG9iurehfxOrehl
ufdDRBheGs43HiX2XYsEXpmFgpb/xwl4S6tIiD2cBpYHtJJUKbsMIiC267Ka
NzlXAz4co96sFapYxHz80NejI17tr0dF2vr/wdLcCCYEEfz00sQ2noG5AsMI
GbhEC4AbdBz45U8QHOiRWQ+6NLeVH7ZOjuJbHJoT37cgsWNaDP0P97Mu9OJO
fP0pRbBZHsv73e8HSobmHte7TPYJ1VSzheGUd1PxqlSR6BDMYdkXa4EL6Nkc
7EyA5+UpHxvzwRxctHp0ZM2E+GfPRjBWcB3vw00oTyuXgE9TeNjCh9U5tYqG
+e+W4AIHrAP98CG2TIka32bumBrb9GJ01YgwDM0uWDoEB3uN0OV8B3JyJ9SE
YRiCifpoK5oaRPH+ixUqYT0c/YhScVJ+eDG6a0oU1/fo7DgxFASe28thmK/w
RUvAWvgNhiX9GJLEQ/q9VwquO2sCMqQhyfHaRLixoEYc10nBseoUsbEoTvYG
a8JA+E2wMg7l1onRnVOi2yZFtVDilaApEXC4b92LsS3vlO3ZcPr21Q3Xzy7C
lIMNCwVQmbgEuBkDb6uy4/21rsL7MJ9LEmj1ETQrfs9KvluY/Lgo+X5R8s3C
/fPiIH7tqAjhK9eIR+3vDFzjecHKz5lVVN+DZXk9SrUQYYNFM9CQXa19Tlhl
+yTB8o8Tov8cFcFGmKKAYOZ1YPMRMnYBIjtdXeU+SbKwiabrlKFT8Zza65Ab
4FuwXy8Fz6qpJZYxyYRhIDcbxKdkUzDDN6MiMNw3sO+IsF7oFXERgCwfIiW0
nZOjhz4oPfzVqUc2nb5/ef2tk6Lw0IJHhMEn+tpzhHr6eF/iLNypONGUMLKN
uVM8/w1JPjwvnnyvMPlFSXJTWfL7suSGssp1pbs/K975VuHWV+Lrp8bWjI6w
+MeDC1AnM9UioH4gK8tCVujIz6FaInOZF9VtEGu91vl+mhrbOz0GVDA6hJun
3o5h+3nfviOIbAeFDHrx/e/STAc/wXmQrOyhNhPWr0mDGLYLUt7VyCU/pYsK
cQJFXw6XsgmcsHeacAJYXja4wGrmbF4L6l6hFdN5a0R7Z3jA/qYXIrvnJPbM
TRx4ObZ7RuybCdGlI8OLBuTPVKgM+yhRM19mTcV11qjjAstH4e3unRE79Eqc
gFc4/dPi5D81CbO1PLmzfnJdKe8cfadw79z4jslRqM0OLCczStkTt9oqvhZQ
We0OUYA7Vk6Jfjst9v2LAtZOrWYRq2NjAKM61vnK4Grqmq3B49XzS7x2Ma4i
3jKPga2rwnBOjXjPqYZ33oW1uacUdiZHD8yJH3mzcO+sOKoOxY1zMFer9gih
ZLzVvZeWA4LDvreKtnCZW82Jw3qsAk52w7aLEj8tSqx/ObZyUvTDMZG3hoXn
98+foT4dFFbuvojVkSkiv8+eLljxtNRnTfQPvxI/ujBx7J3C5PLi5PflyUMN
kvsaJHc1rPyh0ZHVpxx6v3jL9BhWDwWD/kC1WDoDhPfTQNG2BC24F9HQF+Mi
uxYXHVlefHBRAqhQlR8+UYB+ChAOE4xQb5vvYmOshANfs8c2l2bdcXGtOy6q
xU9C3w4a9HbVAllQ+K3O617gh/vVXbWdklrERqx+VspnaOl9S4px/ZObyo98
XrJtdhx9AirYDM4rm8H7l8qQmFIv8qAvVlJp1Lq3RIVW4anIQY2vHBbeNC6y
c2bsIFri85LDX5TsWF688b3CFZOiiuVzYTvsHzcg4rZmBy0fS5YI1CNZOGNb
JkR/fkmSX8mFieTHxcmvS5Pfn5rc88vkgV8e+77Bwc+K/zk3/no/2SJoRZkM
0gwB1hgmwCdCw+CjIAAo/5XDw5tnxSs/Ld77euL7SdItwN3h/qk+ri0IZYXH
/ATD/U1rG3+z39DtF9XyaoNxQ3dFU1ePxKz2NO8ktV/Jt6CZJ+d1SfaO7Zi9
dmR43fMR1N7m+Yldq0qPbK9fiThvKd+7vPibSVEwxB4lPr5T4tqnVTFretQL
m1Nq8SRSZ0VgKyfCMTAfQMGLQAoyMWE/L0oc+7wErWH+yCm4mHgi8N2SQdJs
hkUEF5hGOBTNsVBbYt5Vt8mK+kYY4ZSZsUPzE8cg7ddlyZ8aJH8sP/x16aa3
C98dFkaMnr/Xd/2ltwTP1CuCLGxneDvhIjQlen3rtNjB1xO75sVXjoqwQe43
RZN1KEEzy4M1au6tUbNxPnpdKhaOGnVg/jZKDewt11hvAszYTZV9Kj1OzIdm
nFz7R/kb5YHoIxnfafr/c3y5l2I7FiQOvVN45MOiyq9KNy2QUjjKAz7DD7Tm
kr6ac9MbeekBcdik1lzrWmGyo7pdiA5UgqwgHQx8NjKMRjPKNKx8r7Dy9QTq
GF2Mkw6JoDqOirmDIBhRtNwL+g9duEDThlIn0qAV54qfbBzHa9+r8QMfFu35
tHj7O4XrZ8UXj3QkkiSJ+rMhON47zZwrK6sjkoC+d2YcSVn5XJiVxWXyyTPq
HmfHTVjAO7KAArJyneimi2oBBD9bK4UAGBvNZX0sE68huaNQzfnYKsoIYYL4
s4DdbZ0a2zY9tmli9DPt94NBYSf4GLO8Z3b82PtFu98o/GJUBI2CpIgBwreV
5piwxc9S/mvumhVwgtvpfttcUpXmBgLe79KsNtejeEG2UaTZseXF+JlmCdDX
uN1Ig6l4cVBbVfU0PatxkWlMzA/YnqFBsZHpdY0M2PG346QHTbowJkW/Gycs
hiPBZfgLcD9LBX6vrOyTBsAwSygL9OSJdEHdwSHwY79WrsHJvKOANK3VbAAQ
ALdrLLmnblp5s7Cmj1LTczhPlZ4qbeb/VT0jJt+qqdPbp7JXBqYOvZ44srho
95uFX7wQwe8EL5YERPoxiZ8ND3/7UqxydekPM2JwPCyOgrNkDbuEyYx0Vo43
1Qw86IL02y6s5UkxhzelAUUpVg8txiqoGtzVA3PjP4yPfvREAU6VNeL01ayK
5q8ugTFRVf39tq1nNH83SrNjbA45m6w6EWRj3K1HEPF6U/PEKMQvVI1CWy4z
Q2R2nwWRMKjBgtasgtP+nlo8AEYxW7ZotOYrLOKBztC8t+YbOl1dRTqrxDgv
q23bDgonuo5bWNbYQjyvWj9ude/1hByPFYpDJ0hezTlSoaFqtPrH3i08urS4
clXJT4uLVk2K/mNAvoQ/97q+yJEdpMMC2D6dEd+5tmzv2rJvpsZwBkD0XZc6
xWcR/r1XaInpMpE69Dj0a3lBrVvOqxW6+bxaXqNbz68VZCNgYABD1YAp3CNj
fqQGxxtamh6zmoA4JH56jK9YL54RFVsytBpdWQqRmdTZ6U8vNFsUL39AQAnI
Q0iol4FOhugQToC7s56Xxia8+FBNzgI13IAwQnXkmpCWd8ZqcoQQ0hpFjQ8k
CWnZjaau9C2GQLoqQuDEkwgGKsPcAAEoozT2twqyGbLAkzgxl/d/o6p45RkW
Fi0pSn5ZsnVp8YrpsQUDxQ+AG+HbENjznB8BahY9Hf56SfHRI6ftXlGKWEFq
qxF6IelhqANcVoppfbGYgFYX1oKON/+t1o1/zWzx35kayeRD6Da+BwWlWB8f
FzpaWmuhVrK4PajDkPa6wbrkOjWr7Z1lGUNrs0RJ9fY7LcWzvsN5Ruwa7JvU
QmDzWMfc5zKxmE9Iio00X8OyDLzJFwmPRmmkhoxCVELWBb2dd2j1w1E+XU1M
Jfj09xdopBBgeTnWIwQi7rlcJJWtDlQzwh3FL7pTolazfz5d/Z7k43XsSah4
Qh9nLSeben0ZLzbOjC2dEJ3TPx8ArfUCVkIeeqtIoGCABbg+fKnwx28aHtpx
+vY3SnAX2BISaHU0aw4x1drqAqHiTX+rpTq1zg3/nYmE8iafQm8kmS/C4uAE
AEPgzsuapkIDSoO0U+dmNXTzOVlVUlqxMuibtfLEKE0umkCw2mAt6vTV/l3k
UkIlNX7jlUDPa4xiGTKiwkUaWrym4RTXIJxsyQtJJbgO6so8zCdVOi2Y7aJ1
GenPwyZ6OfdpN5tlEdgosPN91oJ73hsgAgJsZir9LgQvje87U5jai5p1Eooe
V5FOySQHPebFvHh3cMH0Hrmmh2AnKyVZjhccghDwj/Z59cnIl2+X79992uEN
DfYsLMIoQVNEzkwHMml61uxj7Nq/ZF5zTiY/kU4I3PJ8dQ0aZxH3GFGhxCi/
dArmYCbIgy53FZWrjaJ/BmH3aSpR8vrNXLNwDyOtdqBaPM7WoaJlNYNip1lh
LrOuXuiCDzz7Qdeyz30h3nSl6Ot98wPLC12na+5rglZcIAcyzw4lQdFa1mTB
ntbt0by2ly6Eye50tcvecz/AR7iXaoaasIhFYTEpZ1X3Riu0hO+d2HdS619Q
8wRtnBIRBtMc0s8x5M6qKpU5prbDbhpTo9iAB+y/PT664fOSyqMNjn5VStQF
kW5REVSnRyhZeONfa0HD6/6S2fxsR9Lrz81E7d5yvogwcvqAT1Ir3IJmy/QN
8dM5psegvKc0LcRSWQes9XFWXF21tQf9xmJE4Mk7XOrUsnqWH3/EWm2050zw
H2JlT+yq5Gx6OS8K33Xx2MjK2fEvp8dWPh9BA70jHVRC1zSI79W2rNiYe0X0
B2gVqbe/rpcmCjQ34H+ojbsMv4CM3TNj+16Jb54QXf1smHekpdc82qB3Jg2p
xm55J6Wsr4f9rrOa6r7BpJCUZ/r6XQlGwQeaumYvKzKa0oXBpj+at3RO4se3
Co++Uxg6OjuutCuGloGNNAo2P6eKiDdAxPNE2WJWKjTM7aPVHCkxt3dtA0HO
QsJN8X59ClpLbhBy3u/TkU1ZzqbvrS62sIysqFclnwXRnf3OV+uCFp34mram
vPV4/vIhBatGhtfNjv+4pmT3t6Vb3i9aO1ZCEmtHUTtQOu8hcXNt8Gq00tG4
XSonWi12VZSbXACCgkeXwxhdtWn3wycLVj8nkS8Lmt5x2tU6HeFq6d5KkTvP
z3yd0Gvu62n9VDJfVpQEyArfgAdty7xp4mI9y0Cz4mnXtVCrxbmZ0OsmJRnW
EBpBKS8dinmRa8/JvO5ceRcly+ZYD9cFtea68H1Jschbaro+niGbds7/8n7l
Hef2+33MrkOgmTaH3ljnMU1uWa8E67jysC4VdD0GncrSPdskC3MIIolWiDUP
vpaQvPHhBnu+Kt38apy489OhBSG8L68e13wyRoRy8bjIwkH5kzq7nP1g7XcZ
qNnjkPSn5PGnlWK4AAbFXYDpTLPCl8g34ssLLLpRQGmWjmOI0uJ678QJ4owa
qXZctVTa3Lpe4+TLrE7Qb+7aKzVuRzFZJxRgYwPRLSuHhaFYIGcQDVGDbtea
qKm08Q7XsD9MoKUswKn1EAU67gkNz2wsBQsXEg/9T2YLLa6xLd0ddM6o4FVc
7TqSTGlK05CiEqkN/CMjW/V2ZGsb408kQiYcxkYOzIpXLitObq9/aOcpu5YV
/zAt9s1omTjh58ZpsR0fFR3YUr59TcnaefHFw8Mze4kXloae99LMh5JchlbE
JRgFbPgU146NWi4f7wYtiu6FpHCoRgYSWHMNWPuXFKte167rxxr3qvGwVl/r
ck6zbhchjUYDwr3DtId8pnZE4Z1DMYhgOvEGixsglhdx5FIqtdB9Bw4o2uwh
zb4FcZ65FoZgVEuI+MvL6qVDUUGVuaNuTWYhpL893L5J1cCADWNY8G49Z6YS
jfUsD2nxOJGrlya5yJilU1jx6+ckR3RkfuLo4qJjX5QeeLvwp6lSU9kxKbr7
JWnlrFxcVLmypPKb0mPflm5blFg5Ifrm8Micx/JDUu4pQFvim+P0iN/TLffq
s8QggAGQgvCwaat5wdKo7InabQy0lm20aEvQVWW7Mquk6oT4TzOdokFNgtr7
+sIUh1KowMTKzI4007WVpi9LarFfR6rzqtShCVcIKnl5tu1WF1ZlaYMOp8F+
i5c5gtasFZI+rTJLo/bRXkqoZcJu5VQTDQutjFQQ3ma2RD3dVtc8P9PqknWt
liLCXwrh4XpnwNG8I5UqbWi1PCxO4KYXJNG7bnQE8C0hiFjxzp5pscoFico3
CiuXFB37uvzHT+uveafss5lFHzwVfruvtAYt1C7NK/6YcdWfMpqdLTwKKrgj
G0b1W6MzfqZN9qATXW4Y1IAvsR1GLdFYNevAXJ96Rh4pKoswCX1ybBYF9Ij7
3cxprCeVUOa64yFjfuGLkKjdPEeoQAuqm9hSpYl1kdeumqllEWvSDuH0e9ew
2lAllHXnIWVDtDgcZKukWlKtZ9D0VgefSg/7k3WWp2LxIMF1r+ZgQTYIswwQ
PqsFLVbbau8Xz83zlOq6VcEau2wY68/skfvNjMKdH5VvGhc5MlsqhcfWNag8
dsbutadufLUIA4f1RolCnyv/lHH5HzOa/jkDH6uFmmnWQX+zK7QQGCWysMZG
o1KGOGXnigzyHd+LlEMYUqdl005OOfm7nRaRTOvld/Blzbqqzeu4XzEFXvq2
dBlDyyGjqpEgL4Rwe/mmFwNh48Wt6uGDJ1YJmvr7a+nL70IUtS/TesPbucw0
geKLD7h6rrWX2ZRRQD7NTnl5Hfxe2ke0RwvCW9+rNUSZbN6jAwaQClSmyR6z
A+LJsMFlrnHUimUWZPAVzRlBPk+SMGjMXVOi3z4f+ejp8KuDZMBi99TYoYWF
B96Q/s41I8LwabOzMtOQMC8bAqITececDnYAygALxBL7A/sIHSg2HzHDnDOE
kq8p9bgstauwinLBiS/aq2P9xDZ8ZEox1K6qgmPRLtxo6LauSumGgnO0OtWk
pSZOTD3erIRyaLkkywIy1A6ub79WbpAWcR2jfVT2E7oT/szoljtPe78JmqAZ
gCJy6EaQ31FT4GwJ3rLe8iA+MEM4RA1hP83BBNVMSbf6aYCWKmmtjqeXFe8t
N2MOJSvzETCxONRI2/hCxMteMkiq5qwP69iwFisDLFwJfUTM/iD60AuJ3NTF
wYJjuQeYs6Q1/AmW2RZLSz3T6HWdZiRYQGjtnXgihdEqdQaqnk8zG+Lz7rrU
jehZf20wSObETV0y48nAb0BWnvW72Ux/GZZuv7BWSIx8STAD0VEb+OWLt7ox
1Oe19RTuw12e0ll6h8CMhLcDpZa9TGMiiEhog7GDHGCMu7d3/FRgnkdn1d02
p2iCygspfyrtuGnQaXG7biwE2bx6rXSHd6g5A66Kpi514BSlqleV5bT9M2Ib
xkiiwwtJG2UxIQ2gQgVMFBdBBXPMr1dlB/GaQL8/i6whPZDlBjVpIBHmsOF5
m1QGTXwkVkxj6wwTN4jOEv8+BWtXt3/yviHF01nZNOuUFgdSa6jZ5u138p3q
x3wXXbrv7xYv12yGZaXLzWjav8DFMxM3WAdKEDYsJPHKy1qlI2SFWh89IWWG
LRNkbhjV9OXw8HvaTYMnjQZEbq2uZjsqkEnaphbry15sUUs629XmdtpMpSbI
RWunSQJH0NrmkqrpGokqpK+0oY1VW6HrwMuxQzNjh2fFiQOkgHWv6Dire5hC
hS9M2SB/6EqQjwSZrkSgWqgjZi4J+8QTtoZWMM4WMHFpEr1mXHuOk90mv/8f
aOdnP+RDvUqMpdmxjn4G1Q0Dq6EzinXWANYmuCUf2EbEDhSFwJeXAX5sfN38
c0unnomSfFhtokXi6MBg3GB+b5k4INSEYYEfW4nDdmRWHH8bX+6LZ8JvPZ6P
pwqR0dGsY2X4QNxAMsIoedP7shFYOxjDBvQDXz+oEEMw9fMz3azYlQ4Y+Egr
iL/tqckf04SfDZVeux/GS18mwmZr4p1CUav+sBJGAbkRy3Z25lWmLVXaLBt7
i6ZirZhp7Ryghp2Abj6FWIBsoasj2B8yGv+X0iy1d9sNhKY7l9/zfZga55tS
4m5ZRqM5SWubi1Kho94P+EkKlVFJktZ2o2HXu9EwG+GQwspd9bwQZPbaWtLJ
Tm4I2nr76GDXwNsceXFWZdZOCzDiWffOu/jM9Et+Jw4bxgo0QO2NU2NHXkvs
mhVfN0Z6AyEd7GM1FSuYmnXmdpCdZdHNrPmmtvNjRW08s4/2U7Hjjle6GUkj
cvUpYNdKc0NVeZw4srvW8ZA+lsL9Rx7htY+fLMDtsGxnhZpZy9He7Lv4EAoi
i0j+MaOZEtlyRNyxg+b1umtlC7yyEyt+eiGRyVpG5Wb/FpVrrAb+G5NWwVyF
OTV2KkVaJz+l4aWBDC/L+ldNGMGgtaNIhACOvXyJCnTs0yo5Uni93Y2IW7K5
em0NVfqmnPJy0W/TPUdhYEMeuBGI/GhkeNe7hXveLlw3KQpq0bpIJnc1imme
LN8EmJCC1SHvh09JrpDg7a2+UpC2lDGaxiaO/bMcJBFRHuS0u/gSbHVEifRb
yfZ7quLF9rK0HFj1sKTOiCBYVxIljV2HKYbXJW3PdRKJLHohsXs5Fl3wcasg
D6hzv919GsMcXADuTfOKEviz8EfjmjVv6H9L36B6nufH+BX+zIW1UdiJHSHR
sSVVszC3Or1sFdEgpw8uTEptvm1Cr9wZ/fNn9Mmb1Nl1/ENW6eXrl794UD7x
FSQ12l50Zvqlv5OICyiBGpcJWq1ZmKjcXX/LZyUfj4kQuYFlUG8dd8p5v0QS
rKIF9pcOD+95LbF/QWLXjNiXz4bnalKLHUrYeZOr8Qg4OmCcUqLo6zsGKZEq
X4HMz7SrZ636sCJKBI2gU+J5kOxmtaOSjD/HkVYcGjWovBb9fJ6LusS/4q5e
jo183lWNskF20b6O5F+mxP0/0bba97RvTZIHBq9pVV6nsRWvxA5KsFwAmLRB
gmH+kF3fls6D4xrYek7P3IX98lfMin85N/7JhOh7T0hLsx2uhJ+PXLJ/6Bi6
EJr+TWj6X8KrIAfvgZtCQSR628fFO1eWfDIpah02QZXStsdr7ouRfbt//qbJ
0pOWXJRIvpb4eUZs2ZAC2MCimyFtqmpID+v2ILHNAJu/Zi1wVvoYpsVtcX39
nmPg4v0X9RAO/ASWgqSIoQSmIcjilZqPg7wZVZC6gKgmq3er72hsZO17GAQ+
slQ/6LesCdRlHbPc/xeJTZ0h1JkhOZ+op9ZP3UR/i+NGv+y0EWvMB/cj2rtR
if46BdTTJEm48hqikKWDCzbOT1R+V/bzh0Xfz5SG+uVDpGcR44V5Ml8f/Qtp
kVhH2LMFYbAzFBN5fS58bEnRP5+P4HBxR25tTX899cgkcMybc3rloiExhTun
xiDp/lfie2bEtk2WIXn0pzUEsFWoF/S1WcOVDciN0ekhxJEgabyes8ZlSJhk
VdUcQwwuDpx1TA6mQiITTeSbhYQeTUUDixrOgbCQlyugm/WcIKoVfiKiu2YI
sdPcIwR/e7VhEohgCUyWa1pdG6da23+Xtqmn9gXZIWtf8UJS0spyc0Q3ylvG
41g7EBKShoULQYVNlgSNChV+V5gZslXPholS9s5PgHykwQ5FWfiIuMZgBjhw
5qFvQFxQgivFF2EVzDKCu2VS9NuxkdcfE+IOudPVN+REgpaig/Ggkz82SB5u
lPy+fuWXpfveKNw6Lbb2OSlHrB0pPdqoT7SyTIfe7waXRmniSsbVHpLhf0+r
gdHZOhBMdMxnkqk+TzwkSIMWhZbAj6Z6RmcSQAFkQs7MHzY5s0xCPnRtpjlx
I3BQsLFTW3pofczyv0FU5KXB6J74VDf6HrelAU9OW99t9mvEQTW4rTtNTb77
uM7VW8uvp7nrPDvlCBBe1M5Pm0i04aCBt1W1MovTaWfrSCKsJPA4YUvrFbIE
+8SKHOBrrr4jVIR+ZkyBHoUEP7OglJW7yYFDGEcwbAc+wS4htuJJ/geBOfx5
efL7Bsl9jY7tPHX/xyU7psW2vCgzHsgnSj5EbOvlQkhpTNTJP6vRY9Df7icO
LuHvau1Ats5F7ZcTXZptwnfz3xwVcSms6dxy+ogZHq4QTSUyYt4vmAeapkpF
ScOebZUNF+t0V3/bhl0l7XGl+Eoio0JG0cLg36oN3NhWOCkNIynvBl6uzex7
Ienmy7DpfczOGD11y9MqTN1pOks+Sk+ksEYfCRX8UzHaXOpOlMm+y0+ZoQsB
fLSepTlVGxdgbtujpB5Dks/6zZVKOpCC5MKmqD5utkCnUZEUbji8nRvSAX0j
7s7eubx8/6bTkkd/c/SHRoeWlvysR+hBuu1aSpI5oPeLDiwrhjhfPxdeNVyy
3MueEqO9Qs9L3DYpuufl2PYpckbkymekWMGG1N+s11w1J5gkTkEV9NTM00DN
z4N5oCLOCMnG09kzBoJ//CV01KgkBgHuuFi+aakw6bRUz79nC5cwtARaa812
Wsu+VREtvXRSmkVroplYw8E6+8BPGxpDcUEi1I4lR2d0d1NOQ7Rt0HZxj9FK
O580h1fPrAn6EwbDEtlRm9ZvCJ3ZIMpGYURDeKeALN4CFgBEfqdpxxlalfu9
WCHzoGJ0tdy48d2Sg7tPS/58WvKrBkffLN4/w503t/EFmR6YqsMp34yWAY+V
I8OL+udP65b7xTOS5/ZCRCzeOejv3dNj+1+NH1qY2PJS7JOhBdYEwjaaneXS
aWzL6hVAAC9aSGqZexQBl0Ex81CvUEfzij86IbvmHNfeBRruVxUjpZhWrg7N
OpZetAypdRzYoUlQoaU2/rU4VxzZGmj2C6VZLOXd4GS1YW0t+gdPmhssJZy3
s2BsmG+izohD0D4avD9QLT9NbCXJV3UAeJMtsl2Ibgc0TdVxXHi11YWyPy9N
0o+/us6vCSBdkIy7osTe0rN/eYFGRTpxINjVxvHRYx+WHF1WenhxyeFZcWQJ
oUKKIC5Lv6AHVlkJmTgflThHz24EVeAPRoKNQSqUhaaizv7s26arVSHZP+Tm
Cg17bvZFxc7Be1QdNBDOKphlL038x4ImvohZsbeFVuVQfUGPtx3cMETT+aaN
Klw/pevO4iUkQOwsfBH9fFKKxZNVcb/fOaoUqvf6o1LKtGNiR1TrQmZ1WANi
SOZZGgj/YlVUU2RYbSJB8IyATOmcYwcpov5vV/KwFWka9bU8XjqQ4CtgTZAI
pAAXBK9grE67LXgkb8O4yI6psW2q6b4bK7kVOxkAY2pCBwps5BpGRl1ahxj7
BBGwjlFHXPs/OXvjpfFStVkOJLlcFRqft1DHEHbvqompXurQsgZv4gyHIIlX
htW1VKo5TkIa4gSsXWPJIHJP8dbUA7fYxQRSpuI0sWBNtz11cM+ok9L9kkqZ
wpR3de76Ui43D2ucToZIZsOvuLZv4koCkN0Kb3ANH4EX8GUTQfxE2tjjY1o3
siqCscltCgrMaUU0DP9nQwtEHiZE3x+Qb60g3JS7Yz2IGzAsnw6VVmGZdtcx
bOs/sIquNecFMYqpFzZ5m/KBUcW3hkqPuhZ+XaEkAeGmt65VxWvc7+m89Kks
C4+DPyhpyaLLfMpYkhtlbd4kCEH3D9ByLqoCiMbrELw5tmBAzpGq1mPscMJ/
WsX0gp6JE2iT+mwApY10N1l3GxJqstnVJ4wNQlk1MNcapLg5nI+e+XxSfOPH
ZV8tKkY1gUWrJwSFKquNlhgs7JD943gRun01Qg4GRomip7ghpJmpB/S9rcdE
805XbTcc5J99Y4nv4IhO2DDEFZ5cA0q5H3urThpxU0LiGWdbO4MlLZEC0N1Y
f6KgEGUYCKsjS2kHVAPRPo2zEI/zz0g3yphGg77WydhSCQpo3TWQQ50SGaJy
Fw+S4c3n73Wd+FZNm6rMDs8CH06JFSqkI+WktClOeVdzI2dwOSsYhwZdrvef
cCgeaOYjbDR4Xf1C9KelpQc3n/r10vJZj+ezH3gZzGEPO/lTlnZiK8riyXbZ
L1TkvD0gf+OE6NdjIiuGh1FfNlyktsrNlcRRW/ACq1hj0aNB7tlv+bLyiJ17
YR2aViRAl1mawuiCRsq8XHVRQBqQHZKccCYvuI4viFbWVoCQjE5kWKUR2bjg
N+lyoXqiJaYBm2tlCFlDsLg5GtDS5e8OLNg+Lf6NJlMhBPxt59a8PjD/i9cT
a94s/GxiFG2PhMFiIN3VGWuIeI06qU/AUOpITWHoXa4j1CJbayfQ/gOJi84x
VweNjyCvei68f0780KvxDS/FPp0cf7m/9D+BRkIEq10G47igV8LWfuG3phSu
nJH4cWZ8z9z4J8+EsUx8xLdG2VB4Z+EMmL/NpW6Kga8HVRxz9IOhQIu27dhV
0GlFs4A0Rpkr/ODmKs0VigdNxOadAWV4k+tRBtYFZUlYa7hgKb6ITjP7L7TV
qMgoiXLmYngX9YVVfnt4dP0HZTs/qb9iTvEb/aUvFgrh769/NX5wQ9mhH8o3
vVVo5zWhMdBGNj1V4+n7RplS5wkoRYo8PU1f2qhudSfeWO48OMgCxPApyxNs
4OIeeDl28GXxnbAVeNJoHbAITK21G0Qj4tOsNwJ3Yu7j+WuWlP+8qeHPK8pX
T4qziFVoIIgVCKAGtzO4bSDK8GSDpVUVeT+sCJqhrJ5qsgLytE/kjxZk2j+T
E2Jn6NFYTQyaymyFtUxY7z0iyFIoq/N/k27ENL/bYlRz4qy5FM5HO4H4TR+U
VR759dZP6n/5QuyTIXKCJ9jAM7TDOHhNGGadEgFBNEUk1PgFfwgVjBLlKfQJ
np3xpN8yFYxz3t/UVbnMbqvndk6Qr8CnImaHLyZW5HBH9C3Ys3IUPGglcrA9
Q5MG/3y1aPvy8g1zCrEhMHjQrD5M8/9Qp5mGHeDcaqZ26h5X3qUNIbecX9Ww
JWXsS6uqpa20OnKd1Tf/7MQCfIZY0asbVC1hfOhidh8bDlFYXGtQ0uYfN6UA
pbnNRb9NN1Fq5s84CFUuqoU6tmoBEo3/Cg02jZNnAOyeGbezWszXyvxAHw6C
T/Ocxg6g2j+l7HhK1K+JEmLnjQzVu7atPiZ61td9v+YFeJ2jJSu0I+RCj9ym
yLDWCAy+zCwPkENrcG83j5cSsdlTQ7+F4dgJwAZnYOV2Y1U9E0lOOlHbYPQ0
j1Ra+C4QXISQC+0ocM0Af5XIjZtqBuY0S5w1P9tlTizxi0yAVqhh6LfG58Af
xsRzR3gfvKPRTBqu1XYQPEjehx3YKvaBuGHp4ALc+UMz5bTnbROjCIR2bWcQ
7s17WEYpcZNEAjJczHE83lOfVxQ84cWqT/aMAzs3344Qs5y7zHZwexibKyBI
G835WRbXh7yRHL7ykozSB41j5r7YECFUZdEmf3BYuF2jAmtH6KB9TYBqcfB1
f6lqFDf4zfu2Lq8b/1rLTQNolqVhUP6xhibwB7KbKA/LbTT10u1aN0wTBAqI
EPS86Mz0pkp8C2ut98byNBMqct7pl//t83J2FZjGTntu6jdd0NxNPF6pLNbI
3Q2cxleulrqgzdMF81JSPHLd9rVN+/S5uS6sh1S3vMBVsyWDkyZ4LTWOsoYF
h1Ttmrf2QNQAMINUsGIq5H4dQumgmVmWs4SQJfClr/tc14Bv/u8ZoNRGDy0t
b+lGfloFxuh7laoRwesfNEdybqblOey0gQG3uYEW+IY32UQT9XyMg2/VLgtL
PqMVZz8d/nxuYv3sxI8gdVREHFvlwXR3RKhWVUM1YjX16VlKjVrGu9aD7gaX
PNcfn2UNC3gvFrIHiA3wKv35usXgAIVuGlZK3eOszEt9vMKCNh1iTkt1vF57
/BiR1sAEr1mWirvl+K5tfmol5JTrz63qwbOkEmi+8W/iJHbSDK+1b1srL3yD
GKGdIAj6xHJm1tHEniAClv8fTxZ8u6zk6J5TV88rtEcLuP6vOXoegvY61IjV
RjVg1Sa43Kie5/ewd9d2SBw1Q6WNUYEmlf6Gzc+uElnjUiuGd1SOsP4DgIV3
7rzEdWEFXVXC9H91LGpNN9f5Q1mtLnTSb+kNQhxg1/n1hq7r8zxnA5v7PT6W
EuIyhBmV0/fWusFxnHY8NJxoaQx0cgt/jKhDE7G9oFqyJgPyl4+JfvJilJjc
xsPz/XybIaoGPJ6WgsfUJ/sol9dHGbXxuSdAoFP4GijcbL38l7gOSskJXZbF
lVI6PFM8JvBgUbuV14IFjblDojbqNj/Hdb8YAk2D2miO5P0IlbUr7lTLZ1gh
PugpdKrkQvXENOM+tqM7C8VOSsLiokSRA1Mr5pNAS9Bqjr+d7vtef4ns5D5e
tfNfHP5OtEynO52pzwDK7KAdfC3P92l7jkGWqD6vZyO31mx6dxPhSvQOsfHF
Z4obxAW8ae2/FpGCtgDxulqkmWG92rS1uVysb6m3Nv7R3DaGEqT9fEwXcSVf
gQ4YF7QbDt9MPRQwOFbUzB7f5V6Q4m6NtuAye/ANwTChxMzuuWgqGFYz8xkB
DyXtmUmGn9Rn59mTCi0ss02FxCiefp2PoaBvXTxG7aoFCC6DkwhT0W3siO8K
02ue+xFNjwRtVSbh1l8RmA2r3kuffeMsm7+ws/6tQ7NBu8v89tkLhdfMdbIB
KAQdxxpmAjMYUNwxFD4YGKvzxJYDhamtg7JCh1jYExcvfEQ6g7DFuNqm3P8V
ln6dgiXNWWRYFqLlBc7MWWWtEACsZdxID5ps3og/4R8YCUzhSAA8QGG4B7d2
UzSSW/ZtiuVePZ2fqmteIshr6Xc5BNbCEhDWa5th86I2AiMtxqrPaluOANgB
nDhtapecxUML1r8UW/JUgXVu5+J/YxcQSjjeGdUbZPZlcs/cD4YWvDe4YO4j
ebjENlBtNYOqZ1k6aTvxWY6ac8sw0ppXK9sJSdI/3byDVhp5qN97iuWngRSz
BR9drEqJawEM7MzRUzqQBPwC4yYw6/wLNYKC9PPcFHzwSACQAdLu1ROBdJZZ
vP30IC4GKyHRI/KFjle6FApqGg76YmzEqz4X5zmBa6fN/49q9X3mw3krZ8Q2
zk8smxB9Vh8nlKiGgSre+Y3TQPa0LuMZ6+HXyuhZlvq93T9wyYpefIIiAAsw
C0EWqpwLxCRX5Cx9JryICLFTjkuiqAa6zT+vQ9TxeW5goY3WzILTFK2B1hqo
rWWhZ7Wz2FmknaaTTTmPuU+6JN/TB5f482ieBLGgTzJND+Qs7J23dnrs4Iri
xSPD0kZoGfBQwA9npvCDYifdFMcd2kOt2E+74yL3dAsvTTJH4Ts0rYmoWFsL
/ICosEFCvw+fKtjwanzviuIPRkeIRx67ta6BZczj6QxLpold9RGmkJwgmc9F
GN3Hb3XVs2DcrEtz54KZIhmrR0UQ5inAvi/dR8sVk7vmLB0W/nRYeMkT0joh
VxQdB/PvaoBZ82EZTuVf6obg0GxuevFMMwxwO8BerJEDCp2tocs2jJXTNDe/
El8zO46eko7/FlX1nNu11hYwjh2cKdPP17tilc0lWL+nHZxjT12yp8zBAnxk
/C6P7HNxiMg42nN2z9wVI8N758W/Ghd5SZ9RUVzNtnref6VAqk81CRvWOwTD
y36ji43VmhVE5WNQgRSfCvXGp/IMjOC0DEL9eX3zRdRvEYmzmDk45+uuxq4J
3A7x63WDay+HOPiygIfP+po+BAXvVA4MsU6BYXdJSeU1Pb1LqKZek1TZFvWR
Q4nWjZZn4ThqpgUw/t7RVmEraK0TMPfp5LIN5AfVu/uudDKIXWus4YwZQe7t
nxLiZcJY0it5Q9W0ls6QRILRBqtl9bnZzbTICTB6MJPI4QB54OvKYWFo9bye
T44zgPHyT4P0n44ratnaxf+YQh+zbsHRBp31SXOmEWtb/2M79WPQOlZ+RqNW
+HG6YArc4k1YC7WclyPWIGKN5cGDwga0qjq4087lnP+wDHGvGSHpksWD8u0U
teVD5OCFX7n92sT/n1L2qx0g6dykq98Uqmem17auQmkRukJsnHWPoSDEiKi0
FlmXSPVnwXX0Dzixdnx7/pU9wAdRtydzvD8g37J+m8fLkzmWDZYuDM/8b9ml
yoY+o/eEXWbb4J6V5gfc5maOe2i4B9NY6kFHfnxeCPe43qkdY6EuzV03c/As
sgkVUrhD/bIXO99z+6TozslRz39+W7rfH+ye7ZtS28rm9tbrbQ2kQ7TCBYm4
m7VVQmsd9QgsnB3vbolC68WyKakRd7sDs0CRZH9OdTKisHtnOxnRu9Zjdes0
tjy9Hb8FR0MKaw6AoBLz1KsGhT0P6S8pUGhkJAbZ7o2CerefpOYAh/3ZI9zO
cyvY0+3OTVlBsSNWzp4zCCI3jZNHHeHJWOcEduBct4IdhP/fNa2QNaVLzseD
C+yBnqgLxNgGbM9237VnG/81Wa3DLHPZ0wVbp8a+GRt5p3++HZL3J3e1PQ/7
vJQ7qT4S5K5+NrxrWgxBl967PzhMq2flnV/Td8SBk5kwz2yP3EHtrj7juMa4
0bIh9hxKPv6DXn2h233wZHcLMDV6kquUx7yLU9ZMPUn8VHe1UsK7JOXT1LPd
6zvoFBfepSmfpvbklri1L9SrG7v9pl6VcFfpal6TlE9TK1wRd/XlevXlKZ+m
Vl3y3NVN9eorUj5N7fCu566+Rq++MuXT1Alkf4auhV59lYMu9aoMt+ZNetXV
1T4ViqW5T1vqp/JEewlm7tC/vF/8f9sz64U=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1287682]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10798961],

Cell["Specify lighting for each object:", "ExampleText",
 CellID->22049243],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Specularity", "[", 
     RowBox[{"White", ",", "50"}], "]"}], ",", 
    RowBox[{"Lighting", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"\"\<Point\>\"", ",", "Red", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "5"}], "}"}]}], "}"}], "}"}]}], ",", 
    RowBox[{"Sphere", "[", "]"}], ",", 
    RowBox[{"Lighting", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"\"\<Point\>\"", ",", "White", ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", "0", ",", "5"}], "}"}]}], "}"}], "}"}]}], ",", 
    RowBox[{"Sphere", "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
    RowBox[{"Lighting", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"\"\<Point\>\"", ",", "Blue", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "3", ",", "5"}], "}"}]}], "}"}], "}"}]}], ",", 
    RowBox[{"Sphere", "[", 
     RowBox[{"{", 
      RowBox[{"0", ",", "3", ",", "0"}], "}"}], "]"}], ",", 
    RowBox[{"Lighting", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"\"\<Point\>\"", ",", "Yellow", ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", "3", ",", "5"}], "}"}]}], "}"}], "}"}]}], ",", 
    RowBox[{"Sphere", "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3", ",", "0"}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->126729877],

Cell[BoxData[
 Graphics3DBox[
  {Specularity[
    GrayLevel[1], 50], 
   StyleBox[{SphereBox[{0, 0, 0}], 
     StyleBox[SphereBox[{3, 0, 0}],
      Lighting->{{"Point", 
         GrayLevel[1], {3, 0, 5}}}], 
     StyleBox[SphereBox[{0, 3, 0}],
      Lighting->{{"Point", 
         RGBColor[0, 0, 1], {0, 3, 5}}}], 
     StyleBox[SphereBox[{3, 3, 0}],
      Lighting->{{"Point", 
         RGBColor[1, 1, 0], {3, 3, 5}}}]},
    Lighting->{{"Point", 
       RGBColor[1, 0, 0], {0, 0, 5}}}]}]], "Output",
 ImageSize->{184, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->585677848,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(22)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->267091094],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Lighting Specification",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(18)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->68345321],

Cell[TextData[{
 "Default lighting: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->28762]
}], "ExampleText",
 CellID->77052657],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->282029067],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 137},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28201808]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->113248261],

Cell[TextData[{
 "Default lighting when ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " is specified:"
}], "ExampleText",
 CellID->33769779],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<TemperatureMap\>\""}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->370499455],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 137},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102425811]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->555036240],

Cell["\<\
No lighting means diffuse or specular colors will not be visible: \
\>", "ExampleText",
 CellID->3823455],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<TemperatureMap\>\""}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->168379534],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 137},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->107928332]
}, Open  ]],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["Glow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Glow"]], "InlineFormula"],
 " specifies pure color without interaction with lights: "
}], "ExampleText",
 CellID->413303526],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"Glow", "[", 
       RowBox[{"ColorData", "[", 
        RowBox[{"\"\<TemperatureMap\>\"", ",", "z"}], "]"}], "]"}]}], "]"}]}],
    ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->54067388],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1fQd0FEfW7jzA9u7v9a733/h21/vbG2xyzggJkEQUIoicc85Z5GzABBsw
BhtMMNnknEECgSSU0wRJk3Pq3D3dOj7v3aruHo1Gg9c+7zyODTOjmeqq+937
3e/eqh4NnLxs1vT5k5fNnjr5wz5LJi+aNXvq0g97L1wCLzX8XxqN5hb8v/PP
Gnj8f+AR/v/WDz/8AD+I+HsZ+rsh/OwH/EfT/UdeXQJ/N4IX48PP1PfA35oE
/O9S+LvBG55Fj/qO8tOGUa+j15rjT6xDfzeq/YlG06jeK83+v70zXZlfg5/8
iVHwN1rI35RPat6Sfxp+mzxW5FrfMNLYqPf9URlZNpb8R50b+vdt5d/mMT/9
e+WneN5vya9Pnz5dGaoT/ne08p7fR10JfwSPF/2JMVFXeV8Z4V28Jvnd8gc6
xpzVr2Jc6b+iroTG61DHtuqn3scTC19Feb/83umq/SNGfj9i5LDlI2bTFr91
ijL6H6LeHe2jbfC7kV8j8D6Icb3oEVSk2uG39IgYD33wL8p1/xL1qUZR122N
398z6tU/xbh+9EhvRX2mFX5rr6hXf6fMI/q6f44xL3TFNjFH+W2M+Xz4H+bT
8If6bKB6wEdha9eNlfeV2f77P4xdP8reiXrH38OooOv9+of6nhl9jbd/qI2l
8LD1vCp6JvJ1UpXrNIsx74YxGSf2fAco728RNc479T4fPS/V2rJlmyjjfKC8
2jpqvF9EYxJjtMjnGGtN06hX/7dylbYxRo/0Fo2yXvRa7JFUf0fe1wh/si4u
0b7XLOYoKtNFr6a5OsJbIdEhqv/BFTD3RL6zScxx/1sZt7Xyr6YRHsEu/9dA
FG2R83036tONY475m+gxG4bH1KAR4X8ruo5FlMxopjILo1U0DSOsejayWCt1
nMg12tHU8Ejv4JHQYKJkFKVqeUjNe1Gz+gSP3SkCDZyTYLCG6krfheHkaYmS
CUYSpSpRqhQlAwwpStpYo36MR23/Q/0YbBGxejRZZb7y6t+LuIxRvYxelHRw
GVGqgOtJUolGySBonrKlf6c8i/T9hsoqlOtYwRRgXMms+Y06erW8iPDoklQm
SaWSVIwvky9Jr2OtDHMI9o+60alGRquIazdA0DbCi7RiKEwwg2o0gyp8YXll
cOFyfOESSSqSpAJJysMzyJakLI2Cd+QM/vWGGfwpYvUqho1q/aoWvcqGcHXN
++rCy8MLl6RCeeH44i9hFjVSZo30tEZ6HGHzj99w/TfFYtP6aIBBLJq3EBqN
IqDQN0De9E5Mi2gawIQ0vwCTSNLzGulZjfQET+9+jXQ3ho0avmEuaP5/fMP8
1ZhvGYWgHO2qZxrhYRjDSO+MacYcmLUkPUWzf6R5p0Z6VCM9rJHu4anfrJGu
I3x/E2Pu9Z7Xmekf3rAClWFaRXhA2P/BCRpGMIwcYNgTfhPLEwtlu0tSruwM
NdILWIgk3UdrudmwRrqBlVuNdLFGOlsjnYzlqT91JWr8vheDL5pHx1NDNZjM
8Jpkhv9NyIuq1aDSRXhRFCDZaO5Zml9K0gvs2MiLAA1JuiFJ30vShRrpgqZB
jXReWdnxGumbGulQNAvgdPATV/ahsrIwV9fl/Fjs8GuVlvQqLZWrqyiqi0km
8iqY7yPN27JbASg1aCGnJekEvH4cedwxvJSDNdLnNdJnNdKnYY+rp3veesMa
PoiKi4aKV9nqehVegYxDXX6RcSjBK8jH05cD4xVgATDAGiTpDvgUzPgmWgms
4Roso0Y6XSN9K0lfNUAYwEr245XsrJG21Ygba8S1P38lf41YSQNlJapPyShg
QjIhDMLppzZBiNFIwDpeAgYv0Oyeqx4FQNyWpKuSdBH50kW0ogtyiAAYNdJX
gAS8vht9ZgdakbihRlxdI66oERernhatfSKrQ5m9/hyFSbRfqZxllWlf5qzf
1l+SCk1RXc4Ckn2GcXmI1vBQ81aN9ACWVSNdhcVI0nfo1ZNoZSdwiMCa9tdI
e2ukXahk1LwthZZL/BKRXSTS80Pk3Bgc9z94FX9SZt88yrPUDNFI/itCdzRA
nvVOXdaV+aoAxfZrzW/qEdYDCeFxE/MtuNb1GukShHiN9B3AgdZxWANk9mWN
9EWNtAeLOs1/1YhrpNAqiV8hskvhhRC5MBSYJ/jm8J6ZGqVqrafjf/EjGSd2
zd4kwgsb1nohZraGCLTfqLmxqh4lhANKRi0HOSGs/7nmtxJywwyctCE33sKe
+D0OJyDqc3jZCq9hStgHrKBpgFb9Xo24XhLWSly6yK4Q6WUhYokQWCT45sMP
edcszjGDs01VPTSapWUb/PI/sqJas+AHiik+/iGWPsDuG5F3FR/+c6y8WxKL
HWX0kQ/jmAT/vYt94AqOx+8A+VPIr7+tkb7GxqjF/31J2CBxa0VmtUitDBHL
QsElgn8h75nPO+dx9tnwFtY8jTFOYaom0YbxGqVb0rDXtIBG/hPtAx/gxaNX
G2nq98rebCV5nNo646OIOGkQ6TEQJg2QwP11hHiO8htd3YSYD96Sq/kddp1s
LFKeS9ITNVpuqdFyFXuO7DaypY7IyUS21O8kfrPEbRDpdSFyTYhYJQSWC74l
vGcR75rPOedwtlmseSZTPZ2pnApvp7QTqPJxZOloZCPsK293Hu1PXRAcv46A
V9ql+WPY7m8/w7Pq9QsibKdmMU3DkOiUyRLxS/2o+1M960XquzBX5qlECXaD
HJaBuf+xHHSQwBCzXEIcL8ujU2rUIaqUbfdHid8usltEZqNIgflWhwIrBd8K
3rOUdy3mHAs421zWAuabwRin0pVTaN0kqnwiWTIePkoUjCLyRmhkztG82292
YMTy4KztxLJ9JLzYZYw/rFMUpvngZ0Znoyjb/eWH2mraKUYUm7hyq6sqkfM1
QJH6Qd1IlXVM2HxRkQrZ5rGkqGOI1Duq88nWO40NqESqbL2/SPxOkd0u0ltC
1MYQsS4UXC34wYDLeM9izrmIsy1gLfNY02ymeiZTOY02TKZ14HzjyZKxROEY
Im9UMGckDBPIGup/PkhVDL/sPSMwalVw+hZi6T5yw2EKXu861h8/KaCJ4V9/
/Zk2fSvKpmo3uFE9DaLE8kdvjmVt3ViWlYhsy1dqLAP3PZQQ5d3GDhmO5fPY
nCewFjki2/IDid8tsjtFZptIbw4RG4XAesG/RvCu4t3LedcSzrGQs89jLXMY
4yymagath0CegpyxDMw5higaReSPCOYOD7xK878YCuP5nqZ6Hw0Iq+R3hy4O
TtlILNlLrj9M7TxJf3mRgR8lTg30mRkYMC+mbRv9UD+XYl7VyFWoJtxvUlVR
tB6PtrZa29VGvwPqz7pWx9H/91jRH1WPhqP/Jfbd55Ki/B7X9d0rKncq9sa2
/lDi9onsbpHZKdLbQiSYe0MouFbwp/OelbxzOedYwtkWstZ5rHk2Y5rBVIPr
TqG0k6iyiWTxeKJwLMR+MG94MDct8GqI/8Vgf0aq70mK9+EAGNtzp69qs/dS
FwUnrCPm70Q233WKPniROX6TvfyYgzekzAsOWhgctiwYnak0ij0j7Rj9HPs7
VtPoxXeirPwblScirFw3q0fXoGG2+GusnkgUW8htiSzMt09x6fZIzeu3cM1w
WRU5yOKyb7eV+P0St1dkPxOpnSFye4jYLAQ2CP61gi+d9y7n3eDei1hgC/N8
xjgH2IIGttBPpnQ4VSG2GE3kj5TdO/ASTJ7qz0jxPenvfdjPc7+P+05v980k
uI7zck9Y9uj04OxPyfSDJLj5oUvMiZvsxYfcnRf8y2IBfjpyeXDUyuC4tcEY
/hr9PLbdY+22qXERPcIvorB5V8HsrWi+UbVDwzAgGhWR2O0xNQBeq+LhFa6n
MzAichkqI3Idx4AqO8UTss7sIPFfStwXIrtXZHaJ9KchakuI2CT4Nwjetbwn
HTiHC3OOdQ5jwpxjmEZpJ1MVE6gypB+IohFEwfDg67RA9hB/1iB/ZqrvGYDS
z/uoj+d+svtOkvtmL9e1ns7LCY6L8XLfc9k+ausx+svvmW+u+S895u5k8c/y
hQJdqNKGoJm8npi6kZi+ldCEmTqK0/8jNm/XY/6oDr6CXeTuGHr4jspMjSJz
K0KoUbiGE9Vuhwll1RjqJIKfZCEc2X2CIvuF2sd7hAXKHbn5pFIU0idytHSW
uC9F9guR2SvSu0LU9hAJ2GwQZILyruRdmKDsmKAss1nzdCxOJtP6iVTFeLJ0
LFk8migEbNKCeYMDOYMCLwf6nw/wPevvfdLX+7C3516S+04v980ermsJzsvd
HRfj7Ge72b/rBle2Hu0CJjhxiz17nzx3z/Ioh8yrCFWYRKubt7g88KO520lg
M0giK/eTMSIgVjzVZovoHdf6e7oYq3p9BNzxhNmF8xFA1Kh+lWLVfKjyWf2M
HVWpFqt8lq8KILkN8lwt2h6rlHYb5xE5gM5gdLph6b1P4iFy9oi0TGdbhOAG
IbBG8K9C4se7mHct5BzzIXJY8yzGOJ2pnkJXTaQN4yjdGKp8FFkygigaFswf
GswdHMhODbwa4H/Rz5fRx/c02fsoyXO/l/tOD/fNeNe17s5L3R0X4uxnutlO
dbN929X6dRfLV53lWLqeQV575rjxTPuqxFFlY9wB3u13u/wGFGZ7yVX7yXVf
oWCLFUvR6j4at3d/Vizhrlyj2opaTjxK31vugXykxk94LyQSn6jeTllkxxmD
IxNcFD4yx8n4XEY9Q4xOPBb3B+Q+SI24XeJATm0NkZuEIJJTvG8V712GSiP3
fM41m3PMZK3TGfMUxjiJrpxA6wGgUVTFcLIsjSgeQhQOCuYNDOQMCLzq53/R
x5eZ7Hua6H3c0/MgwX0nAQF0tbvz+zjH+Tj76W62E12tx7paj3SxfNnZvL+z
aW8n466OMKNHud67L0qfZOeVGgxunydAOoKUIUDmgZnWfkVtPorE2BfnGAWl
yJMIap55Exrq+2Ohp8ZJwwgWwzsQf39DjNQvT0vqb0W8GQNI+5ew/XvWSEel
0BGUXUKf14i7aqStNeJGSVgnsmuhOhWC6YJ/Be9dChBwqDoFCKaz9imsdSJj
Hs8Yx9CVoyj9CKpiGFk2lCwZRBSlBAv6B1/3DWT39r9M8j/v5XvW0/u4h+d+
gvt2vOt6vPNKd+fFOMfZOGAw2/Gu1m+6WA53MR/sbP68k2lPJ+POjtXbO1Rt
7iCHzJPszJyiDKO1KEBoSbqY4XLhxfVHqO3HqT1nkCQ+eo0N81i9XZ03YRAd
WWp+iaF063PWB/XwiGoXaOt1nvPrtm7rcxaufDEaSbUFr3hAEj4XuT0StwO1
C0Jra8SVEr9cZJaiFpN/Me9dwLvncqjFNI21TWatExjLGMY8kjEOpyuHUvrB
VEUqWZZCFPcnCvsG85MDuYmBV738z3v6nvbwPurhuZfgvgWMFY9SCmYs+0mV
sQ51MR/obNrXyfRZR+OOjtVbO1Rtal+5rr0hvZ1heVuYZlbetXL9Xa83iyQz
GeYRz98Bw+08SX1+DvQb9e1N+vwDVlN/517uJqtRov6rIlC7F16LQKMITsLR
8LeI3dmfzkivI7ubqvXlnI7oCFu+b414ukY8XiN+UyMekhuzUmiXxH8qsttE
ZpPIrpG45RK/SGTnh6g5QnA275vFu2dwzqmcYxJrG8daRjPmEYwxja4eRFcO
pPQDyIq+ZFlvojgpmJ8Ixve/7OXL7Ol70sP7sIfnrspGkC5UNrLVY6PqTztW
b+lQtaF95dr2hlXt9Mva6he11c1rA0aCKZstl8jgLYa6wrPnRQHtJB24QH9z
FUoW8sQt5+UngfvZrCa6A/77GAog2u8RB72tZoK/RWSCN6VpueyIuY0XNnqk
kLqNLT5A7ZCdAKNLoa+k0P6a0N4acWeNuE0ScIOMWRui0kP0MpFZINKzQ+RM
IThN8E/mPRM55wTOPpa1jWQtwxjTEMaYSlcNoA19KV0yWZZMFGGj5/TyZ/Xy
ZSD+8d7v4YEUcCPedQWngHMq/xztCvxjieSfbYh/Kte3r1zdzrCinX5JW92C
NrrZbbTTW1dMalUxtpVsfYY4wdNHRO6A4PscXvn2OnPmHnP+AXHqdvWVp9aH
OUh91Tk9gh7+LsxKbzr91ygiKhoq8raR0ulu9J/xiNnsjurwvoyoOxRhiyuM
VNzlOFPbdRMxCYX2SsIuSdgmhTZJoXUSL/e5l4bIRSFiXoicESKmCoFJvG88
7xnDuUZxjuGsNY2xDGJMKQAJpe9HVfQhS3sjSPISA9m9/C96ypDglJDgvh7v
uqymBFkzQUr4SmWg3SoDbVSCwCAHwdw2upmttVNbV0xsVTG6VfmwlmWDWsjA
8NRnELKcYwutXwevnH/AXH3GXssIXnpsvPZM+yjX+EZc6u9/1c8rdTrxijZ+
W8nbiKka1u4g1VYfDcN5Aj3X1zlDELldXz9RPMMp4h6Ol8FYNp3DO2JHcUf5
EBJO4j7EU8J2Sdgk8eskYZXELxPZxRAyIWpuiJgpBKYLwYmCfzzvHcO5R3LO
YaxtKGMezFSn0oaBlHYAWdaPKOpL5PcO5iYFXiUifCBlyxlCTtmAz/k4x+k4
lCGOyRlCJanPIkhqTXuIF8PStvqFbXVz2uimt9ZObl0xrlX5qJYIn9QWpf1a
lCY3L+nZTAaKNS8ni5YGX6PNoRuZ7INs7n524PYL8/WMvCevSzV1s7ds6d//
LJxiKmjACv4L1yQNI7PLL9Xd2Bgsh5Cr0PyqLs0VqC2tOpkdo5WGi5BLai/2
BO7Cyvtle5HMAqUb2gwyCwJK4pbhxDJPZGaHKBxQCLBxvHc05xrJ2YcjjjMO
pSsHU7pUqjyFLBlAKBqrTyAr2Z+Z6HvaKyKl12YV+4lutqNdrYdxVvmic5jg
qjd1qFpXS3D6eW10s1SCG9OqfETLsiEtywa2KO3bvDSpeUlCs+JuzYo7NgXr
0YZZsDh/xgTv4yHw9HEu96KIyyz0P82z3nuZ+zQvu7aqbD7Qnzg1Zp/ytz8Z
RVUbhN8ro6dgF96xfasuJyqdmPdjJanSWLVKltyKxLiNxHX+NbUBc0bdwzmi
Fik78E76ZsSFQrokYE3AzRPZWSIzLURNDsmx5hnLOUej9GQazlQNo/VDKe1g
siyVLE5B0OX2C7zs63/ex/cs2fcoyXu/lwfVjwlIjUUIAqsM3QHITZ1Nuzsp
RLihQ9Wa9pUrIdDaISKcj3PTlNYV4zF0w1uWDW5RNqBFaZ/mJb2al3RvVtyl
WXGHpkVtmha1bAIGDGSN8twZIavrzALuVQlXqOdfV/iySy2ZBa8z8h8VaJ9r
FMtr3uo2zp+Ce83dxwfCr0b1eBrFeD2c3X4yyjFPjiqx2jAS6z/Uy38xd+zK
Y4kRFKWyzpaPQN3DWF/H3ZwzOEa/Vfd4IUx310if1oibasR1NWK6FFomCYsk
fp7IAdDTQ+QUSHqCdwLvHsc5xrDWUYxpBAY6jSofQpYMJgpTg3kpwZz+CtBP
e3sfJnvuJnlu9XJf7+m6kuD8Pj4CaFwEAdBIc3cyyoy6sQMwaiUw6pJ2+vlt
AWXEqAD0hFblkPHSUMYr7Y8ZtUezkrhmxZ2bFrfHQLdqUti0SeHHjQv+2RiM
6DjfQ4a7QMeXVPI6M1dW7Ss2mF+X52cV3S7U3YMfdRju7z0zkLYUdb/hae8Z
gTDrKtwbWTfFrrga/OyoDtcHtT3vWi7+71gi503bsoVhedNQUTKPVXUv78nK
e2JnVB4Odxx24nJ3PQBcIwLAi0VugcjMDVGzQsR0ITBF8E3kXeM5pO7HMMZR
dOUIWicDPIgoSA2+Hhh4lRJ40d+f0df3pA8C+F6iGwC+1st1qafzfA/HmXj7
qTjb8W7Wb7rKVa7pcxXgzR2q1iOADRDJwMAA8Kw2ummttRNbg8QsH9myfGg9
Bu7UFEVy6yaFzTHATZoU/rtxw4J/NMZ65LewcINVqLYJZhdbbfcaLKby6sIC
7Z1i/WX4ccqc4Jj04NTNwcV7UCNw4PxALVPXjecf35eTUVYV7JuUbLgvWP98
7fsRuJrfUEzUOVyDEZ2pJtcn6pEauQ17GZ9KOI0Fq5xf9+HzWtsRQyvJdTk6
UUMtCBFzhcAswTed90zhnBM5+zjWOhqBahhJaYdTZWlkuIGUPcAPoD7r53vU
13u/j+dOsvtmoutaT9elHs4LCQjUk/G2Y92tX3cDnWrBOtUo61RZB63GOghA
XYCiVhsGVU6rKRjUxOYl8ThqOzUtaotCFugZgfrvxgX/agyYFnz0ScFHjSGI
AezHudrXFeYKoxss4Q4IniDj9HmsbqPRXqwz3SsxnAJDT1pHTNvsWraP2HwU
bcCOXBlUM6+K04/fFSDjqp4oxL3530XhF6vwiA2czLFzw2fV1CODD9VtvvD+
xim8oXoY6gxFx/LbJW6zyK4XmXSRXh6iFofIeaHgLME7k3dN53DfiTWPY4yj
maoRtH4YVQ6wDSXyBwdfpwayUwJZ/f2ZOBYf9Eaw3UhyXU10QiwqsHW3HYuz
HulmOdTVvL+raW/nCLLF5cVKrIbqlnsYthYItj44FuNxSu3YtKidyrSNG8tk
C4AVfPgJgFfUoglk3qd5nrtZRU9e5+dry3VmdJDcS/gJOkDQbh9R7faXWpwP
Ki0IvKX7yAU7TduOEgcuIPCmbSJmbyd+Snz+Jxz/S/lX8+t6KNYea47aDsG1
4OCILmIUgncjCBUfzxOPouJdOCAJeyV+p8RtFbmN6GgLsToUXC4EFgv++YJv
Fu+dxrsmc7ZJjGkiUzWONoymdSOoijSybAhRBFEH8A30v0jxZ/T3ybsed5NQ
1F3t5fy+J6Qwx+kEBN+3cSjqEHxdAD7jrk7G7eHqox2Cb1lb3cI2UH0g+Ca2
qhN1oIh6YkXUFcPXugnAJMMHIdcAwNP8DUBErzRrAm/I14Zel5M5ZZ7MgrKn
eZkFutxKa4ndg07vE6SZ4apZvopiSnzBR3b3d1bnfrDyqi+0X14kz9xFPfzF
u8nlX5A/Se+8CUW1X/xT9i1xz/ldHLFvQhlXMTgyF0UdtVZLzUiAr9Qyq/i1
FDokcftFbo/I7hCZrSKzQaRXh6gVQmAp2jvxzOddsznnNM4xCdGqeSxTNRr1
5ctGkCVpRNFgomBgMDcl8BKCsx9C90Efz91k961E1/Wezss9HNHB2UVB97NO
EbVl3V7MNIQukkHD1eDs27wEc6oig2R0m0RE5r/wg380ltHNKQMxJFaYhLJq
sqTSna/Vvih8WKR/Wm175fQVErQWtXi4fF4oEMVClnsSJM+4vHvAvjuP687e
pe5kMY9eeuHp5m8oBSH15EW9vBjDA6I7o+r9KZp36iCowiejNkjtF4RP0SJJ
WxO9iSyf1DxXW7eIB1EPh/9MZPCmMbU+RKaHiOUhYhFEJu+ZwzlnsrbprHUS
axnHmEcx1cMxsQ4liocEgVhzIR/292f19WX08T5O9txPct8G4HoBcEjCnutu
/05VOGrTRmkKIIWDa8zl7fSLcY05sw3q2EzAhYrcEQD92juiUGmPKbUZiklN
A8iFmn+EwQO5U9S8SWahkFFAZBb6CnSUwSKYnYLRTlbZ3DpTZaHuabH+lsnx
yON/QbN5hC8bNYOEx6L4RBQeCsI5kt4L1j1ySXcni3pVyjx8inbe9p6lFdzQ
4fVf/xhe9e6/U7SrXb2tSZOmxpk24hxGmEejcLqltnNO4XbOYSRJQ3skYYfE
b4EAC1Fr8cnAZUJgoeCfw/tm8O6pnH0ya5nAGMfSVSBGodoYTJVDTTmQyE8J
5PT3v+znz4SaMsn7KNFzr5f7Ft4xvgR1Rnf76bjaOuOgApIiQ9e1r0xvZ1iG
qkkFJLmaHBVRZCThIgNrUJT3WmKQmihFBgSVpiFC60MgTwDzeSE6IpBTFnhV
4iit8hkdlNVOuPyEw+u2uY0G8/MSw0WL84Yv+IBhM0jvIzCdIFySxMsh+orI
npRE1FC9+ED/qoQuNRBPnuTD06+vYpyUXeXIkwC/+hkxhu/0QEitRhGm3s2B
E6AWq5fIWuIl7gqEOfGWfIxbxQsf3hZ3S6FPceNtrciuClHLQsRiITCf987m
PaAzJ3HO8awNbcrQEFSGoZR2EFk+gCzpRxT0Deb29r9M9mUmep/08jzo4b6b
4LqJNsfk7X3bSbQ5aTmi1gxy9S9TYXp7AMuwsK1+ThvdjLpgyT02DJbcspG1
pRxRgBDSk//GAfUP9ABwvPWCeZTLZxTwryuECpNYUunPqzBrTU6bx293Wdxu
B6iVAGm2e15WWi7aXOcC5FWWvUV5r1Les+h2K/FoiP5GCHwVotEtEg9e6XVm
uqTU9DzjGTw9fY/65qolXD3+Z8xiZTw1u6GP47y4Ro06a0Ry0+GIK45gxiyc
0mp3edR7I46pB+9314ifoqa2sAYfWV8coueHiNlCYAbvncK7J3DOMZxjBGtF
2wt0ZSqlG0CW9yNKehOFScpujtzFlptuV9VdhfC2P+q44S2FcP8aF3u1VKg0
R+sCp/baFHUpRxlWKDJqSKEAcG2bXnyETuM8zKWeF9J5WkhjIaMjZLB6Syqr
qmwWt9/p9GjtJl3QX8WHzASd6/ResbuPkvRpjjlPeb4j7UcFbg8+pb+Ldezh
vetC5HwwLBQXxXmF2c/RVyhcfUaevWfW/Ez8Yu2u/lLBD9chqSp+FjX89Opx
dDn2ZK58qh4LlNXmOVy7H6mH3HKRWySyc0R6Bu7JTOB9Y3n3SM4xjLUOYYx4
K047gCztRxT2Cb5ORvsPz/Em3IMentsJqLktN9zCm9FIfajbb9s6VG3qoOy9
LVXrgqlqB2ZYHdjq1HItMGxIVf6zsaYpKgpwLQeqpGxAi0uPudsv0Dmq54XE
s9eW0iqm2i7aPbzF5TZYDBZXpZ80e7wFNkOu11bAEqWimEcx192+QzRzhGe+
oT2HCNMXPLFZCq1BXXT7Gta6lHdPQeC57EVZT/NfnofH97PJ6xmmN2KnRlr0
LuzbClL4vFV6XaQMuMarhammFqbbahtNDrBDuLmCumfo1ggcXbitAhhNFvwT
cdNsNGsdwZjS6KrBlG4gWZpCFPYP5uFjAy+SfM9wP/uuumF3Ic5xJk5uZtdR
GduVrTq0M63uC2lnqG3s4REtsp5KXMnaUCHEulUbEoadmh65TFx4yF5/xt/L
4p/mCbnlodzyQGaetlhntXtYb5B1+Z02t97prSAorc+X5TQ+dhkySFdWiH0q
hm4w7BGO2yvQ+xj3LsK4jfWuErl5CCbbbLpyFsgrMKnbXFb45Gpp9jfw+EUR
8SjH+OYYU79PAOOlKBRc0a3AqAD56XHiKooFSThsDuOG5q4aaYskrMfSHeTf
QiE4R/BPQz0u9zjWOoYxjaRRB3MI0hR4iyGQjY/RZCR7Hyd67vd038Yd6u+7
K1t18n71QbU9LWv1sOQLgzFZbX4MxkK9t9qv7BJJcjgv/UNNTZ80BnggO8H7
D5z3Hrvuu/KUfJjLPy8QcspC5Uax2OB9XaotKCuyOGwEFQxSdl9Q6wsWUXRB
IPDQY7tmK74ZMN7lfHdDzBmoTgV+q0BvZt3rSOMqxj4fNYFcE9CtFRVjISeD
NV36FwV3j+te78N90uDLYuOPIhKxK6XEC76rdAWKF6QqKrGeKMXZKAffeSv3
rW7huuoMFhAHa6Q9uFG1QeJXizRUyksE7wLeM4t3TQXdwNlRS5nWD0ctDtRP
HhjMA0D6+p/39j1J9t5P8tzu5b7Rw3UlHu2dQnQc72b7uqv1UBeLvM8TmXVU
NNCWqZx1RrYsG9pSQUNW350i0ADzy02ofykBgrirZRMIqP0XmGPX2VO3iVO3
XDcy/RkFdL4uVFYtVtl4ndldWql7XfTUaCkOEmaaNVFMOUG/ZpgXZPCG33XK
UXLWU36RsV7hg4dD9C5JWAcVJOtaTFXPo41TWct4Wj+O1g8CYwbz0ZFsZ+mt
/Ov7qvM3w2OdOVhkqH4jJj9233J4Rx0+9MdalEyYz8px5LzGauGpehfKJVw7
fY1jZifisNAakVsh0ouEIK6X7DNZ62RULKGWfxqlHUIWDw7mDQrkpASyQIED
PkmoEXyzl+tKT+fFBFwjYVUgR8u+zqZdnYzbOqJNOHlLe0mEJBiP9kvL1Oav
Ao5c07aq5a1wtCBR9wlqWkD1u+Mk/cV5+ug16vwD7kYGe+6e9e5L98uSYGk1
a3JKNg9rcjgrrdqisgeVVc+CgRKaLuaFIpZ7yXMPaeIC4T3krjjszDtK6E9y
rj1CYF2IXsR7FnKu6XTVJFI/itYNIwpGBPMGoi3AzJ7em/3AkiU3t1iLkEnN
Dk+ltaq0Mi8GSu/W6oX/fNcHfAx9K4AmXo0mAw6lfFzsZsh3iuJccxIT2z4c
ROslYZXILglR84TgTN4zDSolxjSBrhpDG6CcHUSWDSQKoEYa4H/e3/e0Dzq0
CQXSzZ6uK6ilaz8dbzsep5Sw+9XwkcksXQ2fObjrMAEfN1AUm9LGVbbYWqMC
FSH0sZz3Oyii7Z+odoXsk36Q3HWSPnCR+eYa/fVV263nKL/ceeF6lGN/XeHR
W0inT/AGaafPZnWV6ysf6nRX/Z4MmnzOc5mSmBHib7Dkccq3x2f4zJ61z190
gDZu49yA0Aymai5TNREKQqI0FS3zRarvyQDvw0SwpOtCLzCj9vZKV8kceGCy
Ghzeqmrb61gZ56eiFP05fNauu4qWHsvwXNxTeowF3CUM1SHMd1ulEBYEzMIQ
OUsITEVHeewQSaPpSrkbmEoU90M64CUUsmjPDHUbbvRwXklwXIi3f4c7gEe6
WQ52Mcs7KduVMKrE2yi6+W20s/Am2Tgl44R3yGpltdxo/0RJ/xrc+eugdG3j
ms3dQa4+SG05Sh24wHx7Ax3qOX3XefO5G4RAVrE/I99cZHAYHX4fwfi8vgBp
8QRKLbaHFWXHPI5rdPA2z9yShJsi871AH2L8W4PG9a6cTZ5X28jydax1Kmse
TxXNINH9KIODBUn+rCTvw97u631dsLzzcfI2XdW9Of4ydHukUV/q8hS5fP9P
WL0dC6ulGCsjTlKFWDU8U4E6hauj3Xj7ZLXILcNF0UzBPwmd7nGMZMzD6Moh
VAWg1D9Y0CeQk+R/jivYez0RSpfjFS39rVq77sUnDrbK+yLtakMJd9fL5T7Q
QHW3GomCZgpEzRUJrYiCDz+Bx0gUtGoCeE7fQiz/nNx6lP78LPAdc+4Be/UZ
c+s5cSOjMq8iWF5N5paZKowWm8dF0H6fp5okq0i6yOt7ZKz61mn5lvaf56lz
IfocZ70UIvbxgdWUdZE3f5njyarg6xWUYQylGxZ8Ocn/fKQ/cwA6DHMPVQqO
cz3sJ+NQjbAfnei2PJgA1I9iqiLf5XxGUC81agaqRQDe995PRCr6riCMVCc5
V2GJl4+z1APcNjqFqW8PgolPR32HIIiaGbjjMBqVrNVDKF0qWTqAKOwbyE1C
p+Ce4vNWcovhPJJvqL+AN50RRjLdrcNhFFWgyv3zATiMEtQuXZumiOsaK3lI
jqEusnIDHgQgRywPTtpALPwM3Um19zT9zVX23H32egZ7P5t9ls9ce5afW242
OoJ6s91gqXYHbBRjDQbz/fZins+n6cdO27e26j2092ueOCL4v2aqj7PVXwi+
paxzaqBkpvPxHF/mAqI4jSgc4H880nt3qOdOH1QqXOzu+A4VCeaDXdCqtneU
Q8qfge6rs2pfOW3Xg4E7/284/ULJUX+ujSQLLoyyscq7iXdFEDhSaIvErwpR
qD/OOWdy9knojKgpjdINJktSifwBgZy+qNZ52tOLkXFd7i43ENCZRLkM3Y06
4KjEWYe2FNG5qsgCNC0idGQFB7C0UPtycuhAZfMvRU9DjgJIBy8KjluDbntN
P0DtOEF/dYk5e4+9kck9zOEyC9nccubJ69Kc0hKz0+ryu0wOfZAy0YyWDD53
617S3kxJekz4jtuqNtHu3XzgM865h9YeIPMOMPrlnHMUWTHakzHe/WByIHtA
ICvJcyvV9X2q82IiOjv2dTfrl13MGBUgA6jY9AvQWWLXpWSk9XQZjsoLQe85
nr2sqf32hsj73WuVXmSH/d1YUdMWfoBDJgt37i7hRvgXkrBF5NJFZoHgm8PZ
ZjCmyQySB2lUBdYGrwbgrcMkVOjcwmcSz+IDb6AKYN5Q4sj15qb2lWvbKWDM
wt23scqpG6VPivSAItdqY+Sf8h4ThEp3WUtDQCVMDPSbExi2LDgZ3+a55Rt6
/3nm5C322jMOouRlCdSeTFk1m6+tflXywurSegJVAbKK4Qwsm08R931Vd4LG
uwJxU2BO+G2bSMda3reOtWwiS7YHMz8jXq2ky8eQpYP9WYMc19N8TxMRRV9K
th/vZzsWj8qEzzqbtneq3tChclV7wwK0lopJrTX4YB7qJBge2kpPBVyHeerY
j+Lxv2PZvyW2fzEufG7geudLlPm59BC9MBScwTmnMMaJlHYMVT6MLMF1TVZf
3+M+6EYnJMlwEsGWt0KeB7m8s1M4g+iXow0+SPKorIxMHz1x+pAzvBwDnyDL
Y2aKl2sZQAToq0Wqv+NIf4/JgdSFwdHpwTmfEmsOUbu/o6Gu+f4x9yCHzyhg
ig2hIgNZbWerbM7skntmZw4UlzRbHhIreDaTIa4EzOe8JZcY+3khcIT1bQ5a
5oJQpiuXEXnp/sfrfXfSg8/HBV4O9D3r67rV230zARXNp+IsB5LNX3Q17ehk
XNexakV7xLSz2+gmt6kY0Uo+vmrc1gndXl1525L7TcC+gwvule+7sltzIqlK
sX309xxi28/Hti/A5czVGvHrGnFHjbhSZBcIwem8ZwJrGUPrR5LFacH8gcHc
PlBNeh/ijdbLPR3n41HqPoaKSGR1mOaWjignrEKHOnUL2mhnQtJurTBPiqqr
ujar3W9rjAvHcE/lnzgftG0K4DQf6G812N9tnD9xemDoEpQblu4jtx2jD33P
nLuPOpmZBVx2GV1axVRaaZuH8hGE1phhsj8MkFkslyMKeQJ3jyVPk46vXLkn
CN0xzv45715L2adxjilUxczAq/neu0vc51d6b0zw3u/nvpnkvJyAGunfovA1
7Uio3taxanX7yoXtDDPbylFbkdaqrE8LFK+dmsqOT1ZdNWcc9BvXc771yh1v
DtO9GJb/ayzLN5G9HleRp9FxBnT+ZH6Imib4x3L2EXQVqNtBwbwUP0jbjER0
09h1VB7aT8XbjnVDqfgLXBiCzdfiY1+L0VF/1ECZgI/QDsVJOEmpB2uFbISK
7Vbw0SfI4i2aANdXTGzVfpi/eYq/zVB/t/H+vrMDw1cEZ28n1x6i9p1BN9le
z+Ce5QuvSukCLUgmv8vPeoIExXidvtxq22WCesALT0LM0xB7haeO0J4d3oLP
fXn7acNOxrSMtU5iTMOJorH+jEnuG9Od381xnpjkvtjbcban7USc9Sskz5Go
AHpZ2U4/ty04uXZka8VvYA1dm8mb77KV0b1otsy93vKVrHuhYveq8zHs/rfI
3Psxtnc+bqkckULbJG6JyEwX/ONY23CgdbI0FZjFn5UMCdZzN8F1Fe2D2U50
sx7uikTPblSCowIPFE9Ykk7AcmcQ7uomqoQiax28lYwZ/B25LYJ4HCqGhGbD
lwfjJgSwSNDE9Z8bGLeWWLIH+fbhy8zFh5BY+ewyPl8bzC7QV9l8PoIk6ADN
mBiuyOI8SzFXQqGbAnmDtd4QqH2sf42/dJPr2XayeBNVMRedTaoYGHyd6n2U
5ro02n5sgnXvZMfRJOuRePOBLogXwcDp7dG+OAiD8a3AScr7tkB6QK52WmAW
bNJEFPaHqF2MFX1zkjtvEeuYSOtmo7Rr+CrcNan1Ztz7lb+bJuqbFzStsM1z
8OGPPahCYKE2GM/ZweDo8BQ6OZXR2/ugFxKal7rbT2OV+WVnWYyhE43puEyb
q9TSirX7IvpGBVoH1dqYu5GdcescWRv0S+empb2bA22kLQ0qiQqrszh4Anyy
4gsShCbkz5vP+RfFQoGOKan0FVUYjFZLkPLxgpehy1g2g6SvMux3knSO95+h
Dec5G8j/RYR2sfNReuDlymD+VKJ4UDC7vz+jD2hKx7kU2+Eh5h0jLLt6mz/r
Vg1rWNOhclE7vZz5xyHaRo4C7ty2qXx8q/juF+6KfZR7q8hsDZFrWPtSb9Zm
dJjAnEaWjEGtRu2nb7T5/8Sy+T+xzbMwqWwRmSWCfwpnH0lXDSKLBgZeDECJ
804idm+0x4uJBO1eINmY3h71liKtjWUKOIhi7Va40PpE3cXFLPIL1F9q2gTM
Das7dYudv4tMXRS++x5Ze/Z2Yt1hCqgb3Pvxa/51OZdf5taZ3ZUWo1afRzIO
QTCxdA7L3BKEiwx7SOK/5tyHKd1hsng/55hHVU3xZMzxPJjnfz42kN3b96i3
53aS8xJUVwmW/UmmLf2qV/WtXtcZ+cr8tnpIj6NaoRJkcIuSxObIq3GXBXy7
6OGu15c3OQt2kPYVQmAla1zP2qf4Xy3Fjd2UYD4S/R7tqjda+8NYLP4/kpRX
Ix4VuVWCbz5nn0BXDSZL+wde9fU+hBIjyfl9AvJqVGJgeb4Nbz+swCd0ZSOP
VF26l0ogkedxG8oWxoUsBGnF+FaF+tDBi9TcnYRarXeDB58ep4/fQLIcZGCB
jqoweqvtDqvLWFx0NxAoF4Qyjn7CkucF/htJPCAyezjHLqpip//ZQap0IVM9
3P9yjOPKZO+DYd7HPdxXeznPASt3t3zVxbSnc/W67oYFPQ0L2yP1OrE1SoL9
MGP0RKkcuAJmyTLHJfacMfezrO8WO15uJM2zOcdcqmA16OVA7gTbjbGoAfi4
D6qsdHM0b7TvR5Fs/Xf0/ROh3SFqAcg/umoUWdY/mJsMett9IxEqa5Q1jihZ
o2pje8NqfNhnDhKlyKKDVZLoqh4Saaq67Udyt+2XCh/HNQNZWG3LyigQDl5k
Fu1GR7Dk2vqT3afp03dZ4OOcMuAGv8HiMFRVuHwGvfauy/40xGfz9E0meEzg
dkuhrSFiI2tZR5au9j3Z6n+2lCwaEsxOcV5Nc11LcV2DMjPedjjecqAr2iZc
36FyOVBCB+0k5Krlg1qWJbdAlNAObQdqGoA20vzW59jJ0fsE9wm/fnfhpYW2
x+lBHfomrOCzZcGcCcH8fvYrw0GJyeqb0I9/s1X/GYsjPkHfx8ivEwLTWMsI
SpsSzEv0PYM6pgeIOtvR7oiC92BnXdu+ln/HoLCKpgPsqYVy5/IjvC0Gdm3X
FPIcfETi9llczjtZ1Bfn8X3q+D6qrvDg0hP2yWs6T0tUGN1Gu6W08EWA1Nqt
jyyGiwL9SKDPs4H9ArtB4lfw1nVM9SKiaL7v0TL35RWBzMG+R/3ctxIdZ5NB
fVoPdbXs7Gbc3gnpTuDZ6W2045DcROjHo2BS6OpfjSnnFZf2gNe8kac2cJb9
TPWu6ocLjbfm+ovGUmXD/Hdnee9M8T1Lcl3r57qiHICndIM06tmCWvvJ30Px
r1hW/Ri0hcgt4D1j6OoBwYJkZFLQ8hfiQFVC/kUku6kD2hxeiIN/PC5HZJEW
p7SE5X6wIok/Uopx1CKJbwZkgfY2vedsntCNDFI26S9Uxr/6jH6c7S7Ueyut
dqururrypdv5Khh4Vln8JR+8JpBHucCnArU0RMxjKpfRFTODeZO8D6Y7Ty/0
XE1zX0uGkLIei7McwpJybafKle3RJKfgUiMF56zuzbB3AhVhP/stimb9Xm/l
CoFayBq2kcVbfbmLdBfG+l6lEa/7ea+Oc52d4L7R03GxO1Z4uFvZ4I32jP7O
cGzPf9dI34XoKaw5jSgCDYxVwtk4qPNA+iJ9sK69YTkWvVNao02QVFxiYH2O
LNm0XlujCaqkgRXgzcbPOor0Jm8wR2umoYY7iL8tSZ4LsmZOGVlS6TQ5LU6v
zuXMsehvi6Esm+5LynGM94MCWCMQM3n3FKp0LvF8biA7zXNvuOPUJPuxkY7v
elm/6W7e39m4E6vFhe0Qb05qXTGsVRkorThMR7jyweyOrofOTROG7d6K+QIx
mS5bGXyxPpA1r+rSMM/TFN/TZPfZIfavRtlPwrh43SDiVneSHfQNtvxY4VGc
n34vcXs5x3iybIj/eZL7NjYgKNq9naFwQFIQSvkZ2BUhaIDYgTK7IKDlOWKm
fC+8c4T4Mr4ZOC3U1mTxdJLe5w3oCnXBe694NBvMN3+HByBeS/RVdo/RGyyn
6DxD/imevBewHfFV7eDcW3jvQiS6TaOJvMn++9N9d4e7byfbjw827xpjPZRg
2tfFuLVjFfgf1DNTW1eMboVw7Y00UwN0S1JDIB1ltVhf/Ddcz1syjXOOIfNn
++6s8t6f6X0w3H03GXzP+W2ydUeaeW8y2qGB5a5pb1jQTpaCsS3XOOpVfAf6
P0JkOq0bFXiV6rnTA4mmr7uad3c2buwIRReUKtrJqvPJYdweF1r4ZgulrP0I
x3DLJsVdmgKBAp/CILwrnaTOE7TTYKGBH9XO1P/Ag+ycLEgyBFXM8TnWilOE
/QzvP+ooXcraVnLOqaxtGFUxJPBipPf6OPeZUa7voRrsYfp0gGlnt+rNaEqG
2W0hT5cPx0wdj2mleROl7/pO2GL5Y6HkIV6O9VxY7Lo82XVlkPNKvON0d9vB
7qb01Or1vVD3ZHl7/Yy2FZNb/ZjFmsSy2G957zTidZr3QT/HxXgUrns6G6Hw
WIpjYUJrxdV64Lq0tXIbgwbdmaL5FQrTZk3AiMCLkEBM+zoRRclSKD3gux2k
/Can9Cyfw7XdBzCr8opCb6CC4QpA7votZ9zaA5xzv1+/hDbNY1BaGxLM7+97
PNB1Ic1xaKT9SC8LcPC2blXp3QzL26ECaGzr8tSWAJu81wOYwUVlL0Y2IgoH
Bp4Mdp2Y4Tgx1n6yn+14V3SQfEeX6sW9DAvj0OnHGW20o1qDeoOokW0UnYFl
GzWNZaP3WVua/0mq63ISlDzmfZ2qNyEDQQKrGNuqbHBL5PHdVbJogmhMtg9S
gm2bQgaGtwH/QdFEV47nqG0c/8JP2A1W9NVjuDP9V6fbZDY+CYVeS+JdPnDe
mruRMX/KmJZQhkl0dX8iLwVKFvetJMfJ/rZ9qZbtySaIujXt9fM7oRbC6Fbl
A1uW9mhex3uwh/4B8f7z3p6b/RxHRlkPDLd8mWT+vLPx045VaztUzuqkm9QJ
naYBWZPSEvQq0jIR38eKaEveiWqmcBTm+b9T2lTPjX72Ewkg6JAhlrXTzcAy
HkcViLiiNmpmDIfUx7g/1xmFFKQAYEbfkzTePY3yfsFRhS6fTmcmVFv8CR5U
FJ4ThRci/z3vPeYuXk9XrqX0s4iyIURxH39mH8+t3s7v46xf9zR/mmxc1hc1
2+ahtg+UQKVA2wnNinHua9oEn/j9DSqFzyfa9vc3bUs17oyv3tihaml7tFM1
vk35kLbKLTsJzSHmwyzfsNYCsi6L/k0U+F7lvwVz+jnOJpkPdK3e0sGwFJmh
HMwwoAWS250UZimIVFuNkdqCvAfqAPzBfrIb6A4hOFUKneT5bIK2W1wMnvOf
Yc6VpWdDzD3efzZEb6WrNpHli8nS8URJX//LRM/dRLSi411R6toQVzUvwTCz
nXZ8a0VLxTVDWg8yQJum+CTzr2A0y66E6pV9K9d1Nixup5+KhBeS3b0wXPho
yFsx190y1rr/6rmXZD2SUL29A4SmdjpiVJm+lPbsJxGHfWTgMZdCEEOedV2L
J0uGsZ75jPP7kJjLcG6UjfB3If8eHgTtJznnUZFdSOlWerJBO6cFstERWijN
bEcTzF90gauirtP0jtrhHYEQUNWIFQQ6UY5P7/wXarVu6GKY0xNEEdrmktsm
CSg+gTvUHR55fa2i1oe/K+BdEDCOcwmmPV2gSgUWRBkDQO2O19ccObbMf++B
iyH1nNi8fEwrMAWg4bmXQOmG8p41XPAYyz2haEud1dnLd7LWz1nrcrJ0fjBv
TCC7r/dRD9fleNvxbpbPu1Vv61QJehNSwthW5f1bl/RoLh/yhZVhu/8CRtBN
6CJLUaTrOzWTu+HR35+Gdab8Ow/gRfzZv3gf9QRGBJUD9QF4aSn2Upg9rKGO
gG2G2ouwXCCGqrXtbce6eh8m0lVDKMP2EHNEFF84HWgr9H2VdxnjVrJ8Ka1P
C7wajBT01XjHiW7mA6D4OiHBArXIuNbATmB+tBAspDCLvA2fLQOn6YG6WXBR
RR03CiMT/dtU8BmsP0Myrt7eUb+gTcW4VsjVMSbysArT/Fu5QQvcWzezDUh4
28luIMwo3XDGmi4JX/PMQ41yzgupYrpqJVE8iyhO8WUmg2JF5T/KOx0R8vMQ
vUPFh8ihTVN51wF/y3gjZc++UfiugnaxZvsn0+edwC0qJqJOEopKGCQyNuQ+
QXyzsqEt9fPaVH/aEWok39M+ROEUIThLpI5Svksada7voxJHPzeYPy6Q3Ru8
DAxhOdzFBLXUKoQoukYKsiZQn9wk/rsyPzwT/FtHIueHx/yT+1Z81cYOUN2U
DUEZHqX3T9TG3D+xAsdsBbwKoWTaJc8viawYxnvnhah9HuuXaH74Cr+GB4Gc
wb6nPZyXu1uPdoXKpGo14N8WvBUlhsTmaPR/oxH/qsxM/s6aDrFm9gfLV50N
C9siN++JHQd49B/qSc7GjSEsYEDIeyA7jWha3b1PelLlQxnTMt63Hc0Jx/F7
aE6vEmGV9lPdzPs6Qy0PChp4EsGRgD0HtyJlTGEKeM8F/1avBqrlfl+1sT2w
NUpsndRYka0jcznEvjyNHR3hIp4HvciyFFq/hLKjzhSOPHTfluNCnPVgF1C1
kCWAklC3qydWMXhPRf7eW7ii/I3hnaMsIv9GMN2CNmUDWyC936KJvCeAFUYT
JL+QMca2AoyAHO3Hu3luJxMlyXTlVMa1QJ0FYkUbhgUoRje9DUoViah8QMHz
UePfKRaQf29Sl6gZyL9RAOgNrgLyCSW2xsoM3kUc2LZpaR/sJfPaVm/tYP26
i/tmT3/mULp6OMLijyp3gUzVz2lbMbIV0ktxzeSwfV+5svw7ZLrGunIjw7J2
EOwIryZNlKvKfQuoDtNa6ua0gZxu+bIzFNy+zD50ZUqdq1YuagcyFnFNQjO5
waCRv8UQXVX+TUfdFMSxpd9Hi+zVHGEdLqVaotYTeA0kO6hLQPc4zsV5HycS
Rei4+59UPisfgnkOn+SD2f1SuQbWDvLvGoxYGeaNX4O0hriQG7RoE7NNUySS
UlpAPMOiwbchyXvuJGqUvVhEPHKLTOl7oQHl31UWHzU+1lK/Bg5GeblNE7R5
9G/lFDRcFMXOwrbgkEAirisJGk34+6wbKbPGjCH/brLoE5m/hufAvzBZWdwA
GDApWDrEq3Z2a4h78+ddHGdQq/NvymjYp+XfQwbP8CjvyaNC9kT+hNt9aHpd
msHyATDDknamHeiEDF45GiMOj9Eraka/jBgL/qCgks8StWgia28oroAgIYzR
WH9QxuqBx0qMGgvnzV+Fn8MfpGPxXgUaC1wgtQXoTIVf0AeT8DhJUeO8U28c
+CAyvzytdii/lo9sqSgDNJ8+eJxkxT7Rp4VwpfI2hD+iv39hY3dvFuHFA/Cn
+0R9KvpeKqxs34LsrhzladtU7fKhMQbhMfrG+kzU88jsl4Y/1S/WfKPsit49
Er+7v7LK6He9pdgU/z5FTUrET9XdIDTGBPzTgT/I9/RNwc80/+v/AoZD4r4=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 137},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->166720397]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->33514961],

Cell["\<\
Ambient light is uniformly applied to all the surfaces in the scene:\
\>", "ExampleText",
 CellID->88941452],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sphere", "[", "]"}], ",", 
     RowBox[{"Cuboid", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3", ",", "1"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cylinder", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"3", ",", 
          RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", 
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], ",",
    
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"\"\<Ambient\>\"", ",", "Orange"}], "}"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->392976626],

Cell[BoxData[
 Graphics3DBox[{SphereBox[{0, 0, 0}], CuboidBox[{1, 2, -1}, {2, 3, 1}], 
   CylinderBox[{{3, -1, 0}, {3, -1, 1}}]},
  Lighting->{{"Ambient", 
     RGBColor[1, 0.5, 0]}}]], "Output",
 ImageSize->{184, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->346466036,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->342706330],

Cell["Ambient light gives overall lighting on the scene:", "ExampleText",
 CellID->461333925],

Cell[BoxData[{
 RowBox[{
  RowBox[{"l1", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<Ambient\>\"", ",", 
     RowBox[{"GrayLevel", "[", ".3", "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"l2", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<Directional\>\"", ",", "Orange", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}]}], 
  ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->891577322],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"EdgeForm", "[", "]"}], ",", 
       RowBox[{"Sphere", "[", "]"}], ",", 
       RowBox[{"Cuboid", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "2", ",", 
           RowBox[{"-", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "3", ",", "1"}], "}"}]}], "]"}], ",", 
       RowBox[{"Cylinder", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"3", ",", 
            RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"3", ",", 
            RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
     ",", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", "l2", "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"EdgeForm", "[", "]"}], ",", 
       RowBox[{"Sphere", "[", "]"}], ",", 
       RowBox[{"Cuboid", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "2", ",", 
           RowBox[{"-", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "3", ",", "1"}], "}"}]}], "]"}], ",", 
       RowBox[{"Cylinder", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"3", ",", 
            RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"3", ",", 
            RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
     ",", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"l1", ",", "l2"}], "}"}]}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->351628153],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {EdgeForm[None], SphereBox[{0, 0, 0}], CuboidBox[{1, 2, -1}, {2, 3, 1}], 
     CylinderBox[{{3, -1, 0}, {3, -1, 1}}]},
    Lighting->{{"Directional", 
       RGBColor[1, 0.5, 0], {{1, 1, 1}, {0, 0, 0}}}},
    RotationAction->"Fit",
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {EdgeForm[None], SphereBox[{0, 0, 0}], CuboidBox[{1, 2, -1}, {2, 3, 1}], 
     CylinderBox[{{3, -1, 0}, {3, -1, 1}}]},
    Lighting->{{"Ambient", 
       GrayLevel[0.3]}, {"Directional", 
       RGBColor[1, 0.5, 0], {{1, 1, 1}, {0, 0, 0}}}},
    RotationAction->"Fit",
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJylWgl0VdUV/SQ/IxkhJGEIpiig4lRbq3apXa6uWtcJiQkzDmDAT4jM8zzP
qMyDEBEChKioCDiLIypqW4dqtdZqHVpt1WqdMeStdp9z7315Of8RwmoW/P/u
v/ees9+9Z9jnvldaOXlkbEzl5OrhlcW/nVg5fmT18EnFV4ybiJ8S20Qikc34
P7Mwguv/4kr+b/Y8LxKJ4TMxFoudK61hthVJxEVM/iKmZ6jtiXKLL8yAyDnS
ex0+E9BMVb1nS+/Vdm56aO8gOzeTW1HTawacJf397ezs4/T3tfPbcSvJ77c6
esmYcisjL4CALxNU+3QZXWYlFrRqdImV3VH1Jqp2Txl9pR3dRfVGVbuHjL7C
IjmlVaN/bWX/RPUmqXZ3GX25lX2a6k1WbemPXGZl92jV6Eus7DNUb4pqnyqj
L7aye6neVNXuJqMvtLLPadXon1vZ56neNNWWNYucb2X/TPWmq3axjD7Xyv7F
CWSb0WfZ0RefQLbsdeRMi+QS1dtWtbvK6J5W9mWtGt3dyr5c9WaodpGM7mZl
89pkEJG2pkzVFsuWe2YdP8V3DmZFkktKqH85De1H1YPJE+fMDp1ZFNix9mYm
Uf+raEg/GjmYJg4h9OWomZ1lZueAznyemdKv+bRlI2ndWIpkhc4utHp5diHP
TsPs6/pR1WCaILOXjqS1Y2nbZLpzBsXddSeR0cHKYPvpyDLS+0JGX6oaRBOu
czLG0G2T6I4Z9MB80lIkhkTa2/u4AN+dWErbvmV0bV8aMYjGi5QlI2mNSKmf
QffPo6eXUtzeGUk5AQvtzJIy+oikmJO0uIpWj6GaibRnOh2cR08toVduIS2r
UGRlWVQX4bsLy8qErGsgayCNu9bJGk1bRdaBufTkEnr5ZnpvQzw2iatim84f
ikReBeT1oRsG0liRt6iKVo2mLROpbprIW0x/uIn+uv548tICHiPysipK6eqg
vBF0C+RNoN3TaP8cemIx/f4memc9fbkt7o7zRWKyRXgpvruKxPJSirm/6ZV8
ffMounUC7ZpG982hxxfR71bSX9bRF7fF7WwHkZhkMf7KrqHk2szBfWj4QBpz
DU27nhaMYKmbIXIq7ZtNhxbRSyvp7XX0eU28zTXJDGbVy6zt8U8JgvqqUhpc
QcMG0OhraCpUxFjFpvG0cyrdO5seW0gvrKA/r6VPt5L2jLwmDc0yL69IAWTz
vSQZHb2tjlGiY36MVt7Iamqn0j2z6dGFdGQFvbWG/rWFtNe3b9IRl715L/Ps
vaSwnmzoGVRBldBzNU1xejaOZ1V3z6JHFtLzy+nNNfTJFmrcE+/pAV0t5HW2
yFyrNV20lhmt/elGaB1K826gFTfShnG0YworfngBPbec3lhNH99KDXUYruQJ
M4nL2brNfpVltWY6rQMr6HrROnkozYXWata6fTJrfWgBPbuMXl9Nf99MP+6m
iI6JuaFa9b1zNm1rtSbiO+NdOCwH7FIoL2fl1U758mpaP45un0x3zWT9h5fR
H1fRR5voh53UOt2aK3B8SwtYah7rzkB6mDSE5txAy6o5Wpt4++B8VvnaKvpg
E31XS7lKUk6oPs02mAskB/R1Yn1pJilsMyFZgim6399I324ns3MBCdmhejTz
4OifGFjTrqwnxQ/XCLLoQGD8+vbWatCM4nxpQ7QJRZEoLruxlqSDc1k+Ai9+
/mobGYsPzBSPiOOmmic4ZsO+fRrLjfrRNxbPojNDZXJM5fjgeA97GePsyfIS
OfSuY2GR1knTnpxvpWU4pHbNzxDpJmCGSc8Ila49lu2LfTBqpada6WeK9M+2
WgITJ71tqHTtHXyHLr7wDLbFsyBZxyFt5eHS9SjmkzkB62vrbAUaGH4vuQdE
x+Pcg/DRuJio7YhXJCugJRLtXcIxAzkX/9LDdEYRG81szNHywrVqbMl2XxKs
1gQojbBLIzEPKLcsERQzTenn1T3RuqWFIuig2mwRLl5K5ksvLSEkJQMAVA9J
AmwPyRwEC7yDY9C50K49WmtPDdWer9rc7yJmqmiHXuQIJCewOjAdZHhQXVAT
xOuFI/5P7br+TQlqzsJ9I0HhEzQZNAuZAvwUd4ysPHs4gbwhRYK/IbYmWxQ6
92gUKaEoCl2b5C/iIqtk5hzUBkABhgPyaAgI8geWHkswL0ag26B8SJlgkUhc
tVMEwznAonODxpIcioVZdUIwR+eiqgE5xxYMlkxdLcXCjGFMspAvwdI3j2fN
oJzImmBCe2eR5OCzW43BncVwg6sMpzsRqiO5uHmsP2hzpWRqKJ85jHcerAgr
D7ILioK0A56HzAOiArYn+tkjdFbR+pPi9BdY/VLRdSgpsWtvCoHhAxjBREEA
rn2TIEA5AJp550zmxw/Np8cX0zNL6chy/hT5HBl0BaxxRONwsFcm2JySK1jK
xAX7lFnG5ANZKEDWj+UaB5Qam4BSAjQRSRJMEVkInAIcSrBwdNeVQJa94/i9
aOc1nYgZDFcJZYIvDO3PNScqviYA46hmEpcJ2H+kaPBhLABoN6qtP63hTMh1
Eus4HRg0z+f1idq7bXldsi0mtizZo4ISiY1YFGCqEs+Y4eyDF8XHNI8t4/BS
rjZeu4WrAQACsQSP/uRWg6wHkOk8mRxcnRaRuTzNNpfNyDoicgCZiZtDJWiO
E7ddELPGyzvmg1vE4FBdgXIiuYOegWt/VkOgOMyi+H6Zp2jLSfDiTx7l0uJr
Hv25meHjQ2pBJkNKuVZqXES2aVJvgIOvdXa9d6YDt4zBvb6Kqz9QVCwbasCv
tzM3/mEXifRi4MuzO6l3OB6PW1lecYk0nbGTJbJksDHjbQj2CLZzhSkj0sDZ
dzoLN5vpQ/pwE1deX2yj73bQ97uoYQ811JPwiS5A1d6i0jwlHlWiRdXOR2Wz
fhmbPSCZSmXOcI68q0dzaYz4A/5+wNn8S7KFFtJW+g/2r5aO7aYf68m7ixr3
miq3o91L518tnTeFoMRlBx+hsTNz9GROgmYNo8VVnBhQA2+fwrwfwemRBUz9
FTyY17e19AN4yx3k7SXvXmrcZyqtfOun0VjzU29n6/EI+QfOZcweEkoYGaKV
SdwjxPZnVEqwGMX5ClXPnul8AICQjVD14gr2yrfX0gcb6Z9beNWO1tLROmoA
rLvJ20fefvIOGmScnRM4u+A72UZ5Z9knRqkzL6ONFAGucYfgUQX7gjgqKpu6
aZzcUKWhTkCl/6qEkPcFLFsdtriOjt1BjQbsAfIeIO9Bg5djZ4plB4khVqhr
E4fT859QNOEsE1McUN5UNHMdKadlW4zDzuI8iCyE4I8i6a019LcN4q2y0Q27
qdEHeZAReg+T92gTzlTmUiEVkMaYYHZc/co2yewtcgocubeYJfbfP2I0ZgnK
tNl4jXHkRVzlo/RCmkBIRtRDYPlmBx3dzTYJqI0+1EfIe4y8Q+4kAFAtY8q2
K6yfUOioaFBrf/NRdzWe5B+pcayW5LZBTgXqp4sbiZdz4FnN1SJSyL9r6Jvt
HAUb68WHgngPkfckeU+Ir+eeFErNJfOs5Ue6Ym0rxLGCByfL5SwB6Q5EDFwI
TMR6lTj7R5sINZ1B2eCjPNAc5TPULoCyk9KvuZRBqfMiR9oUZwFwJ3M+bU6H
sf1LZPsRNGsltfiW+opzJw5Jt3NSQQRHuEQ8sr5kUD7FKL1nzamCQ9pZYdDR
yiDlDJpgLVvqmmL4fKmzUdBq/3gSG75RNhxxc7+E9aCBgi18KdEJxV7jneTd
I6HpgWbr6D1H3uFmq6mfhmlmbDCG8dVkt+d95bB+ZODwaK1QCLvhiO5LOLoj
H1qzvI2+32E9nmPofeTdL+4eRHlEcuPJoQxjs7KiReUufsJ5EOzNeTScHWWJ
v9ugxq9KpP/Q2WSD8pyHxM2faIIotu8wFint2gINRh2vOGJEnY8jVQ6RpzT+
meN6OR8zDo79Piz7/abETpONftxJx4IW+SBHTcb4NJsjMHovyn6zhTmkXU+A
tI0gdadIwgb8VaxgrmFWcbHzGUT3u2dxCmLPljSOjf6H22hQDE+Z4+PiMA6e
cGfHsk8Ooz6bYkly8t7FPG2pEqO0S+lcB7H90CI+N37lZnZukMZPZbuP7SKv
vrlFPiYWeZi858l7QViH49wOp34+rKOjwanZu7S7IBEBJsjRKHi4UBCznqiW
7pnFkRKOg3j+xmo+SfnYuXdj6HYbk3yB3LOdNK8pb57oGbbBqLO/YOyEErtS
NhxB0j+vrXeLaCKk8ZnPa+i77bLbxq33Nw+PsoipdqczAuiKlV6duw26XGuN
grIQJTfqKewr6hVQSbixb4AvyYK9J9yC2dpO8syCxfvws+S4fs5J4wk93S1E
qAYo82QK4W/fHBukXxZL48BSw6fbR0MX6UlxWuFWrnpqH8Cl3y3QNanBpfmR
7GI7sEXUKHXTOW1g245I+n0HTgqjgpPCqOqaG5Ugito1zw+g6BaCog2arN0g
0Od2Uhlmmod0qLuRBt6VzflKghdbs5/076c4P+8Q0C3vLCT5fWapbFzNt1hF
exSL/ZHwH1RdOuK2VmKhmqfXPyhH3r1o9pzOyNCMSttWUEb3QF8TCs12tC8H
JfTwms5mmp7Jt35GkRqps25wZk870+y5jtaa+fBMPhVJszoT/Zkanb5fV01m
WNuLuro0bi31Wjv2nGMjYKKrF2UnGXvYjCT7NKyz1WVO/k9VI/XpsJyKYWYB
ZhbYmeZ5kn7HR3sHt/lpWDs7yzwn7a5Gaa9m/VypZ9lZ5jm82009mnsLMdrl
BvPWxelqlD7BYfsvsGelrMO8waLfK9KZjfcvz9aUPMu8C3SmGhX2Hkh2YJZ5
q6qXvR89mu0yPTBapJt32lqoDIvwkWxP5HmWeX9Ov8ukOaSxbEyzbXcOI88B
zRt6LdQixVbXBTL6PHs/elQXO0reT7JPGI/PfArt6EtltH5fKqw649HyxpE8
h22JCbiTn9/I6Ass3rBzIJZ5pYy60AuLoW3tmN4y5iJPx0dnVeXSH3wzK2Zf
guTeftL7S3yygkHSirT5H2q6Q9Q=\
\>"]]}], "}"}]], "Output",
 ImageSize->{330, 124},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->76686648]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->167781412],

Cell[TextData[{
 "Directional light is specified by a color and a vector defined by two \
points: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->784051116]
}], "ExampleText",
 CellID->630744411],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"White", ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"\"\<Directional\>\"", ",", "Green", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->300674590],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[1], SphereBox[{0, 0, 0}]},
  Lighting->{{"Directional", 
     RGBColor[0, 1, 0], {{0, 0, 1}, {0, 0, 0}}}}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->57403227,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23766926],

Cell["Directional lights with different colors:", "ExampleText",
 CellID->51534522],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"White", ",", 
       RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"\"\<Directional\>\"", ",", "c", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], 
       "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Yellow", ",", "Blue"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->437410544],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {GrayLevel[1], SphereBox[{0, 0, 0}]},
    Lighting->{{"Directional", 
       RGBColor[1, 0, 0], {{0, 0, 1}, {0, 0, 0}}}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {GrayLevel[1], SphereBox[{0, 0, 0}]},
    Lighting->{{"Directional", 
       RGBColor[1, 1, 0], {{0, 0, 1}, {0, 0, 0}}}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {GrayLevel[1], SphereBox[{0, 0, 0}]},
    Lighting->{{"Directional", 
       RGBColor[0, 0, 1], {{0, 0, 1}, {0, 0, 0}}}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->266370581]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->164604977],

Cell["Directional lights with different directions:", "ExampleText",
 CellID->208148506],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Sphere", "[", "]"}], ",", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"\"\<Directional\>\"", ",", "Orange", ",", 
         RowBox[{"{", 
          RowBox[{"p", ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], 
       "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18918963],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[SphereBox[{0, 0, 0}],
    Lighting->{{"Directional", 
       RGBColor[1, 0.5, 0], {{1, 0, 0}, {0, 0, 0}}}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[SphereBox[{0, 0, 0}],
    Lighting->{{"Directional", 
       RGBColor[1, 0.5, 0], {{0, -1, 0}, {0, 0, 0}}}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[SphereBox[{0, 0, 0}],
    Lighting->{{"Directional", 
       RGBColor[1, 0.5, 0], {{1, -1, 0}, {0, 0, 0}}}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[SphereBox[{0, 0, 0}],
    Lighting->{{"Directional", 
       RGBColor[1, 0.5, 0], {{0, 0, 1}, {0, 0, 0}}}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyVmwmcFMUVxh/VM7Ozu+y9y16A3KcIeICIqKDiDQp4KwqIAiIgIl6QeB+J
ifcRo0k8YjQazyRqTNTEM9FEo1HjGY8kajwTk2gOfsm/3utue2sG2OXXsz1d
9frV933vq+qemWaveasWLTxm3qrFC+YN2GXlvBWLFi84bsD05StpinqJyEJe
S9uE9//jnb6mrVu3zi1cuHAge5Ed4iOJeMPeNw7Qnin8jWiJ4ghrnRwfFbq0
ToqPiv4osjQ+6SbaOyHOVOWPctZrAf21f8v47Jr19I+Pz6/zR/m0Px6jn8aM
jXM0ZhD4ty447tDoMXF0c7eiR8Xj9wl6o+C4XaNHxLnbuxU9LI7uDHpzwXGb
Rg+OkfQLevPBcatGD8zWaKPR/ePcg4LeQnCsKkjfOPewjeS26I44esRGcrdo
dGuMZFTQWxEca/X0HJ97TLeim+LosUFvMThu0uj6GMn4bkXXxrm3DHorg2P1
qFTHuScEvVXBcYNGV8a5J3U7Otu6dXBcHRzXdxljKPsqloowd+/gWOejadFl
1vpZ38T5YXU3cH7JrPbzoZ0c4aypCY5rv8ixgXnsXdhP4nTxKlfbrUzh+L7S
AzRTcGaIsSRTOKN9pQYmmcT+1ZVTrCRTOMf8+IP96bkvMkkJKssVzorw2EcN
3Wiu6rK5QpzeP8MCho5XWMPy2UIP++zDg2xRmWxVZbOFXvbebPQZuErmne2r
g+y5Mtkry2YP55OvdY1Pke+llCPdcv6AlqjgxFU4ybOXAg053SIN9XgCHP44
nDvlcYRRfh4YKwOhcPyoEcMXI6n0wKpyUqzOiWMv1bQUdSOAQANnsPztBJiK
ZdBo5Uvmu7rmi5WBf/5cqXYqBalTEAwNgpq81BakvgKMDfyJGovSpJu45krJ
+Tc1tNFHTF3Bx/fO+xM9gwQxmT3KyjIoK8qizM45D6+gE9HEImWKzqAxPlha
KqW1Stqqpb1aOnqDr7O35PvWSMRe6miki4A+VT6ySSGD18CSkMHyWm+vaoVI
iX/KI/WrdIAOaGQlNyOAiwEZHBBg6V8rm9TKwDrQDapHzcH1MqTBb+KGNkjE
G0eTNNBJ0IA6f0K/Gn9yu4I35FD2d24qsKnbK3akx5ze85XF6uePNDjFWlQZ
qRhATb0ORWkQAQKmYY0yoklGculwo5pBPLpZNm3xm7gxLRLxxtEkjXQSROjw
Rn8OTOAAgRS9vw8selVMbnBHhtnrqhMrcx1YvysUf2MuERoDkNUkZigGHKSw
QQEikAFysz4yto+MbxW3eZu4Ldokv2W7ROylmQbax7X6mDFKi7MgYQwQwd8F
9vbKUEjDjmh5Fdyvc7kYe3gdKawXv19rpYXTC2pjjAJ+8jMKtQa8CW7IDTZI
ATyhQyZ2yNadMqkT7bfpK25yX4m27ScRe+lDAx10E0ToVu3+NOgZN4hRHZAM
1qJQYyYDTkI+RPRLn/HxYMP1qzyX2oALytSri7AQ/mEcKwEsgLC5UgAaGIEL
6in9ZPv+ssMmcJm6ibhpA6Sw4wDdSx8a6KB7u/4+brJSm5iQQhFgjNY6DdUi
QQcF0RE1KY+t2WWvLlJyndaVptUughVKA1kQp79ysEogIAQYHXm3UfQAAyRg
wbzzQJk+SHYZRIpdB4vbbbAUdh+ie2mlgQ66CdppoI+eqsRSVgDZQos0RiuE
6SgPXkBIalOpZMqyyZdlk1alD1xQA9ciDhLhKoiMUzNN0DJYAaCwk+IHKYgB
vudQ2WuozBgmbiavvYdLYZ/hupd2Gminl5g9hvhgzuJcY0bJAII+qIRWlAnX
jVBOzEymKP6AkLPrZ/f5SJtds1mnUIVUJEQqigIXXIGQVg5gIDYswAZI0IIa
8LNHyJyRsu9IcfuNErf/KCkcMFr30k4D7fQSM2uED56pBI0d2YCCRAhF0eGF
iccpL/TE5fgEUsWox4xYv3AammAzUpEQuagL6llR8MuuSmSGsRjhEQIV1IA/
aFM5eFM5ZIy4Q3nN3Uzyh20mEXvpoIF2eok5cLSPhyMEjR3ZgLJbUjVKBi80
REn0pFhYhZWUla6gdQrv98pz0vuxDh8e+dmDMMx9DI1aZjQITdfK7KllmdWV
CniBDoPDx8q8sTJ/nCwYJ+6I8VJcOF6kkzccz9eNboKIPlQ5QpAU+yo74FA4
q9qOWjKMgQ9ZQ0cqL5YILNSrZ6zakYGrI5MISkhEQtKiGwWCDyPurQZDZMDA
BGAwASeYQQ6DozaXRVvI4i2Yx0u2lOhoXku3khx76aCBDroJOnJzH21UjSTp
SAoi6mfFgx5CIucULRumgRsrBhPD3xaV5RVem9SBHZSKlZr1E30w3rZaJKTD
clQIRpSH2hid+Rku4AU6DI7ZSpZNkOUTZMVEiY6dKIWVW4tjLx000LxMNwKP
TkjCkDRGDzwUkOoZN4RETizJVMYzRozJ4RfBHrBiNrJqYz0oIRE+IOsMddx+
ymeuugyRIQOiJcrEaAAdBsdtLasmyfGTZPU24k7YRoonThbpy5vVutFBN0FE
Q5Mzj1GCxg44sGOMlNpMrdnOOtVYP1g88FGr/yBf/hPkengxJ1m+mU+QQqTd
tUj4HntQIRgdkdTG6KxQLquUBdjhcNJkOXlbOWVbWTNF3NopUvzSdvDizRrd
6KCboBMSmsZxuRIEDgSRbN7YmB1qUjWmM5ZhquFFJgdGLOPC3AZ4cb9DqZlR
kMJ5zCUSkx7PUSMUpUCMDwqjY1yMCNjh8OXt5NTt5bTt5fQdJDpjBymcOVUc
e+mk4TTtoZ+otQlPI2kMwYNaVr8jlB5yUjn8jyOnKzemPAuj/wTUE2bc+lBv
5hS1mqWzidlMfkS0KlEiAKxOCK1RNkYF+LA4a6qcPU3OmSbn7ijReTtK4Ss7
iWMvnTScoz30E0g4XFOWRhE86HWsWhQRMYc580AlR+HwJLoz+7mIdZNZTTLH
sDHCcIGiYAeoBUnOEEu1VEYLDCAxTqcnhMAMA4h8dSc5f2f52s7ivj5dogt4
XbiL5NhLJw20n68bkcTDF6ZnKVPkISeY0IwyGkcsYgVkJjDJjSDaswr4z1rl
2YXfImndWlEDMyMOEwwvzlUjkpwhsCCuOVF5IbUVClTnJoyADXiIiLuIP7mL
d5VLdpVLd/Nb8bLd+PDLm0u0kS5CCL0gYUsK46nf/NcyAJYwkghqVcQ8h2kJ
cRTqsxjgzO6x0/vcdlZX/MjCgRnhhROXab0YxIoFqTOTMhkjAIL0YuUBh8t3
lyt2lyv3gOM39pDoqj0l+uaeuvfHUkEP/URdprSNqn1xUm8UeYsfjB9iUkGm
wtEJOSYK6zULN+tJD5h1cAYVo/jztVzYcJXWikFO1UKdrZzO1xJBCGApG4CD
HxpX7yXX7CXfmiHu2zOk+J2Z3BTwhuNrtINu+wqu6TJldlFSPojRjBWQb61W
jQkAK0qGKZkeOJKF0n/k7AGnNtYfLiGIwtTCfxBiUpGfURjL2PjyaG0u16oY
DyMB/mtnynV7i7ue1w37SPG7++heq9FKt5GDFqdZ4SBGvfAlIbBCtDO0Vqdk
KKEwFmS55kNRyV1vtAE+XIspEL5jncB0kMFxeAG74TWrizGhIkYDhMYB2KC/
cZZ8b5a4m2YzxM2z5ftz/CbO/8ndMic+ZlOGHYQRzTmcyfmocG1XzilhwtES
c2J+2FJAZjpTgysQKwDG4irVE6ZcPDgPH7I4nag1Q8Zzk4JhnZSj1ckIGrub
lBdsbt1X3A/25dP1bfvJ7em2v9yxv/Hry+FtuhFFsAmALGQw0injlC7yciqW
PS/DlVow/7g44bbwW68NsWT15ySKiVjMM6skuS/UMl6Z4QcQ4EAOdMYMyMCH
yp37i7vrAIa4+wD54YH6PaF+o8J7R5O003mnkr494XpLhiWypRRR9DLlh5WM
H/5CfmzL4sKFaj3swl8m9JeXdgyOVSkgPmUJgRrVw6EMwUAMl/KyiqWkQAtm
sP/oQPnxQXLPQbb+Fe87WNy9B8OIFtrphePdCTujRp4sr2uSuqWkEBmpWQow
l/8I2z1G+gtUC27mRMyIMky4C5XLVTrPGOsGLZARuU1Lc5dWxCh44Oq63E8P
lZ8lW+GBueLYOxql7f5D5CeHCDQJNoLG7vakalBDLsxOvfAG6Zh7GAZtUZiL
EDaEVA84NbI0sjCxIjK7mFqXanEw3XVJZYwNKKwgUAGgMskD/sG58tBhfvv5
YfD7xeESPXy47p1vaKODCOLgCMX7M+xQxqjdqlVDuuszvPAJCjPpmV4s3eG3
3htgVMcVA89yKnZDHqYR9YEOprh5jhfyjgwXY1JhNIAMcgg8Mk8enUf+x+ZL
xePzde98QysddBOUEoMVNctSQq1bMnyuUj5Iy7UA50Gm5PcXV5aN/qJaxeTh
WsXpWO1q9dmNajKriV5NKx9I0Bt00AL6iQXyywVk/dUREj3J66mFuvfH0kYP
/UQR+2iGU5YQAmHg2zNs0BE1GZJ5xCxg4eoBkwqKgk8pLAZDF9x18+xY/xqG
wxuY5CEtQUoCnOAFNuh/vZDMvzlS3NNHSv6Zo3Tvj6WVHvqJItaYcTY5spzu
0wrdnRBCRKTEa5foxQs2Jb8HGpfst+r6a3uO21h44Cx/36b3ZRQCsRiBcRiN
QhiBJxL0AAQoeIH9W5A/u4i8zy2S5xbL7xZzk8Qfx6G00UH/M7pxhhEzVo8n
lB7U2USNjA9GQEcWH6rDVRHTg2njXPwTBoq+mULgJ2SBw73KgREYB18YAdPe
0AMQoOB9frG8sETci0uk4vdH617aaHhee+hPmUDDimNleVhrkhJAOuY/1eBi
cEX30fuZrt7vQ+UoIX4iB3MbxzKrUw6PqYWsAhAAkaEHKYgB/hLYX15K7leW
yqvH+E3y/HEcSjsdL2kIscaNsyGWskIcK4tRwgEsASjJsnmt8sEoBno9MyX8
7d4H6PcYLcwTVmES3aaFQa0HMoyeUkMZHWClXIzFa7Bwry+T6A/LJPfGcnHs
/bG0vKYUiTJqLy6Jq0Wmp9VuxsiKxIy8RyuEPVg/MVfJfUx4T1fKKnkiRO/b
W/AoSwkLsBWJmYLLjA/jP5vUBjIvJ0zADXxYvLkcVm+tkOjtFYzwx2OFvX/r
/J9WOt7UGCKJT4mmLK1uRhERkRJBqRhTyPjpR86AT/hpo5RfMeanV6hmNDJ+
TCQMgY6oif1ScmCxMgHQaL2lLKDj/sTrzyul8M5K3UsLDUbTyBGPGNBCGxQy
O8IJ8ZAQF+J5fGKEULrkN6eQTa+YTddPU35e6R1cM0s+ZoYKiR/ROiEfVjEe
VqHXMyTAC27gv3ucuPeOk4q/rNK9tNBAM50ppTeTMr2SkEEgZHpSq4MxjAlq
cn/TXSZdfpf33frsVRPrvZF4LCkGwqUMgAGYFD5QgQzy91fhrQ+Ol+jD49Ho
o9XC3r91/k8LHQQQRrCxM2ookeWFVFahxxNSmMPXJvz2Mjw2Rp6QPiXXxMWG
tQXLMmHg8IxWAStZCTyBRHxD/4GCBbW4j1dL8ZMTRJp5YzQMvCHnpCxsNGEC
UgtKzYrNMoB0LEPhTA9/5TS86VN/9RQOso8kYF9Qtcn/hkptOpvIBtN5hNFf
T5C/neg3KXzKn2be0cRG78cJdE5LcUMc+mj9YgIaoVEJlcN7xtBDMeKgVZ9g
bGACwRzDp9AZ5S21CAqbvIAGkiH2YN3fTxL3j5Mk+ufJErGXRho+VTZGgBOy
6N9WyakfNgE6HmG5YF0Mr37h7yqGO3mC1dRGZ64HOCJFagqbvClMAAEMfO6z
kyX/+Sm6lwYaaDa0Wajvqa9RmaKBE4mRA1NQ2JKnusqjDFtV3VpSsIpgXvxg
UBnJFM3iBJvzGP91ikT/XqN7fyx1dAA5xWvGQNd3ElFRAS1QlEuYfSoIkPbi
0CM0lKEzDCXVJwnWgj11N4gmJeMaPuB4VKAr/GcNyHjDMa2fJZLCBj0NH0Sh
+5oq6e9mwyd1cyXIKrJVrgXOq6oYRKnsR+WwgAAk+f+uFecR1RiiVDHgfKy1
xRyQwiu4jykq5Z4D7oolXHNVpWoWUzAh+7uqzydJ/VJAiiPFUw2eVJ5PE23e
S8BwGZDwGWNXgqQqq0o151Ahk8SGD/SwkWuB8J+1Xhy29aGAB94Jn1suRRCu
LYq5yo7fUi0+VC2yxcl7MSo/T4ph3qWGGAPyzAZ9Wlny2WuYv3O0e46adeWf
wNbeArjfS8a05SiiBlKRLj8U/X01oB9Hn4bu8nSrjRHO6dATW5WcZ2rUB3Et
wXH2aWDPyM5qiBmF0RPjdotqCnrDZ+G7RjevK//EfPK0vkWFvELe/sloXwb7
brk1zhlG+Wezc8mdbYlrQ4eMjKPtOdqOoDf8xmZIjMCefO6MEYRRA+Kc9jx6
v6A3vKPoG0fb8//915X+7wb/tjUe2f6Xwsaesm+Kcw7W6OTZ/DCqLo4arlGD
g97wClwVIxit0UPWlZsTxTjjOI0Zuq70/3tEcYQ+ty5+5AJH+sy4SK//A875
T68=\
\>"]]}], "}"}]], "Output",
 ImageSize->{452, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->228491585]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->192724024],

Cell["Directional lights on specular surface:", "ExampleText",
 CellID->160120],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Specularity", "[", 
        RowBox[{"White", ",", "50"}], "]"}], ",", 
       RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"\"\<Directional\>\"", ",", "Orange", ",", 
         RowBox[{"{", 
          RowBox[{"p", ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], 
       "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->54123890],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {Specularity[
      GrayLevel[1], 50], SphereBox[{0, 0, 0}]},
    Lighting->{{"Directional", 
       RGBColor[1, 0.5, 0], {{1, 0, 0}, {0, 0, 0}}}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {Specularity[
      GrayLevel[1], 50], SphereBox[{0, 0, 0}]},
    Lighting->{{"Directional", 
       RGBColor[1, 0.5, 0], {{0, -1, 0}, {0, 0, 0}}}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {Specularity[
      GrayLevel[1], 50], SphereBox[{0, 0, 0}]},
    Lighting->{{"Directional", 
       RGBColor[1, 0.5, 0], {{1, -1, 0}, {0, 0, 0}}}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {Specularity[
      GrayLevel[1], 50], SphereBox[{0, 0, 0}]},
    Lighting->{{"Directional", 
       RGBColor[1, 0.5, 0], {{0, 0, 1}, {0, 0, 0}}}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{452, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->148564797]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->805311572],

Cell[TextData[{
 "Specify a spherical point light source by a color and a position: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->788340243]
}], "ExampleText",
 CellID->23014193],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sphere", "[", "]"}], ",", 
     RowBox[{"Sphere", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
     RowBox[{"Sphere", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "3", ",", "0"}], "}"}], "]"}], ",", 
     RowBox[{"Sphere", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "3", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"\"\<Point\>\"", ",", "Green", ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2", ",", "2"}], "}"}]}], "}"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49721791],

Cell[BoxData[
 Graphics3DBox[{SphereBox[{0, 0, 0}], SphereBox[{3, 0, 0}], 
   SphereBox[{0, 3, 0}], SphereBox[{3, 3, 0}]},
  Lighting->{{"Point", 
     RGBColor[0, 1, 0], {2, 2, 2}}}]], "Output",
 ImageSize->{184, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->253479887,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->190561512],

Cell["Point lights with different colors:", "ExampleText",
 CellID->405169220],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"White", ",", 
       RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"\"\<Point\>\"", ",", "c", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "2"}], "}"}]}], "}"}], "}"}]}]}], "]"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Yellow", ",", "Blue"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->159693515],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {GrayLevel[1], SphereBox[{0, 0, 0}]},
    Lighting->{{"Point", 
       RGBColor[1, 0, 0], {0, 0, 2}}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzFmgeUVcUZx//73vYFtrHLssCylBVpwgoCgoBIKAEJIkYBC1LWICISIKjY
C1hCQGzYMKJBBU9MoqIxiqKJXWMvkaCxJhhLyknUJJzkm9/cuyzzLrh4jid7
3t73Zuabb/7/r828++6EGYvnNJw8Y/GJs2bUjlk4Y8GcE2ctqh19ykLrSmdJ
mm3/86pkn/9rn/g/ZMeOHUo3NDTs4E8d3UXD7ZpjnbW0hto1Za109O57B9vV
TcxposGukYZBkWx+4uiAaLTQtbIbV7cPNYz3i3S3cK2cxvFIRwdk6iMdxXuQ
6RPJlCXKtEemV7RW68ASqaDdFukekcY2zZLuFuluG4ymg3YV0nWR7vbNku4S
SdcEo9lBG6SqjZDUBqM5QbsS6ZpId5dmSbeLdNcFo7lBuwLptpHufZsl3SaS
7hGM5gVtvMfVdfYKRvODdjnSZZHuPs2SLomk64PRgqBNrKllhKRfMFoYtEuR
Lop0D2iWdEEkPSgYLQraJUjnR9KDv0L3Tumm+drV3gulDN1hu3jn7F3y2eV7
mc0P/dUiaLfaOT8jT118VZmOMLL3oGMPmelitoNpI618t5/ZRKYlmkLM4fou
LmrRFMz8Sk1hHjnbd4412VsSphaJmsKscbO6NNHk/oqTfJehKclDXQNNKSmD
YbK20AsuZvcJtKUTtBUmagtzzI13C7RlJ2hjXoaNwth13tg30JZj/2F8JWsL
pbITtOUmaMtP1BYycNHb/WtrC2OoR6ApL0FTXqKmxhiKZoaY8hM05SZqcrHe
M5hdkFBh/OykTOmdsLbj7wpPfrNnFUQVxXWFmZ2TqMXZYL8kLdZMzPBmaXDV
NazFybOdN/v8n2a7uOwbzC6SMjLTzw7t2eobmR0iz/4GZjve9cHsFgnIv6nZ
lSadcmf3dIqC6apc2i45Of5d2WnKsr2yfD43b63wTOmsVMbsLJS52pxyRTA7
F7X5vLIt3FOF0btLu7w8ylEuBTMdw2D218dRTFJnxXxzYgAFBGzKOS9tGlvy
Un4r67MPKbdIYREyBch7bNnoMW22SKu9wtGSBPfG8CA8giIWdrpSDmq6RCq1
06Rrl9t/a9dXYYdRXlG7HIFS1y5xOItR0BLTFKHYozUEKc+r+TidQVScBdVc
mBei17TYMiWsbCAMkkVTGzuBOxTV9t/OprQ3ne1cSlQzUIWER1/GZI/UGded
IpXOY53UbrIovVuUrlKqzHvVo2y0o61SzqIenMExVDVSR/veInWy1exwlNvF
vyu/E90dEemAuAdOwOUVo9U+eptm+4gs2CusLrRVnsLt3pzelt6QhrI6hmhA
DJOdk+okO9/YocTt/SnbHlO22aZso0u7TTe3OwPdEKpjAmiLOqCrCvZlrGHd
Raya662cv1vk4cnW7S5UgNbexAW4rZiwq4gtW4NBu4CiG/u4Yewl2fZou4MV
ypQVrNz9/bvSfel2UPF+seexDww64YT2aK4Evom0xFze8NSj5mN35xpVppnm
TV6KvatYxFu6jvV7gHc/8BrU/tIB0gBpoDTIdB9ojhvs92WVD2C8n1QPld4Q
9hy6oLVDTMAXCG98hz53r9C7Yqk2KdAXEdZlhEo7rNSFBbtj6j4x6AHANaQH
SUOlYdJw6WAXPyPs/5AoRqpG0DkcgaEID2biQGjvH9PqgUM9p/awKcf7RUDy
NayZfNx5iRreNgszFKKoHFd0wA+eTG+s2g8mB4JsGFgN+khplDRaGiONlb4d
bQipcbaaa1SNZWg0Yt9iysFMPwhVAzFQPU72xDoTu6aiogmrlPfUXrKqzIZS
KyhVo7cLMdGLiOqPdYfEZDyTMXAYLx0qfSfyTHqSdDgvpeySmuR4HSZNRGQC
4uOgPxo1I2KCg/BcPQbsTi7VQq011Arj3TTjRJ3aLa8UFcsfAVoSem2JuzrM
tx9OGgip4dh6FLDGg3KiolxJHyVNkaY6PtPsUnO0NC1+TWXMJI6UvitNhvdh
Mc1GjsNjgv2Jy56ESiO7ViSXP6/sLbuSNKYpIQproNYTfx1AQgyD12jcdCik
8FGu4TYax0rHScdLM6x/pv3PspVmugifQfd0RI6B6ZSYoGc3rgm1IYR6PZHS
yKuUOuvicPesmt5t4H6SOz7k4KvWpGtXHFWP/iHE3SioTIh4FEwD4XQYGHg7
Wn1PmiOd6Nada8pOsg/Vc+mYw2ADd3xnwu9YrOCZTSI8Pa0RlJSBlJFe2LQm
LoR5e8WnyBfMYrzTibDuC5mD8MuY+EDYYgpmng4wT8IAz5PmS6dIC6SFtu4i
s+di/65q6/g+I/MRnAu/BqxwPMqmxrQOJRBHwmkQnHqQ2rZwiT8DZN4j2A2f
fL99leKcOjLVk4FF8eGkgicyCxYG6+QYv0FfIp0mnS4tdf450/ic5d9VfQad
pyHzA2kRs2zuSeiZHftrCjE4kSgYSXwPJKX2jX3UXD7+znYu1a4mzvWysUTB
EVjvuJjESRh5IbgMoCE11OdI50nnSxcYg2U2f7l/V9sL6TsPkbMQ96wW4ct5
OGo2NpqGixrJDKE+9CRS/M6bca8imQfWr+yFM4YRwZ7ENKzWgBs8gyVY2VCd
C0jDe5F0ifRDaYXhX2k8Vvl3Va+g+1LpYml5zOlsCJ0aszHTnEDyHR1TGUua
DqK8doWHP8CHTLIymJTGTKrtQyl7Wx+2vZEU08kxnxMw4gLcsRRE58PkYvAa
9Muky6UrpaukNcbmGlunw7XSNfHLOq9G4ApptbQK8pfELM+B4hLsdTIB4Pkd
Qd0ZhZ/qY3IZlTm8YxPz3PUs3Xh/pW0BBbMvWTQaCx5FbHiWC7H1mZh+Oc5Y
CeQrIWGcrpfWSj+WbnJY1tlCNzvfraPDum+UbpCuQ/xK7LISM12E1c4mGRfF
PI8n7ifhxGFUijqK195zdGePxjtPbdvhyaHE+WQKxCxCZyGpYSAuxPw/At9V
8LoB9MblJ9Kt0u3SBmmj2x7ucOeJjXTdJq2XboHrWlhejU9XYqlluPJ0Cs88
0uA4nDieCO2H3cO7C+GZKZNZXuQ9KkybXvhtPME/ncxegMc8p0uJxatAZvjW
AddwG4WfSj+XfiHd7fx2jy2xydWOe+i4i8E7EdwA/5sxhye4GgcuJ4dPx4hz
CdEpxOfBBJP73h3erQq/O2dyi+/88atHVQ0niHEE5Az8tZhQvCAmtgY3rQPg
BigZH2Nwr3S/9ID0oLTZbPyQ89hmmg8wdB9id0FxY8xvLal5Obm4DAsuIS5n
E5QTiJ9uX31PPWK18/eWHU1+yazcn033SAJwPp46l8Lh2awlmG6PqWwCrKF+
WHpU+o30mPnqCTPZk+5bjX14nF4b2wLTX8Hd89pA6N4IqdVY7HzctYBInIph
ByjzjkbIz/NxdPiFs3IYKTST6rsUZ6wgs68Hu636M4x7P4AeAbKhfUZ6Tnpe
esF0vehO+y/QfI6hJxEzGg/BYRPhtxECawm5lbjkDI4cDdhvZOb3i2TkTXtc
YVfFODby+VhjGdV3DRl8G3bbBIQtGPYpABrSl6VXpdelN5xr37RLxe9ov8aY
Efqt9DQsHiHI7oXCBqLzWhxwEbG7gFCemHCCc+izrOlQ77o3NUS/tqliMhl+
Krl9Gel4Czl6N/beQjw8A+BXQLdV2ia9Lb0jvevy/D2H/F3af5DeQuINuBmF
Z6UnYvz3EIPrSbDLAb+UZLAczzgT5GYgD+/e8Et7+TTcdx4Wvw7n3omhNmPr
Z8Bg9nwTYAbyA+mP0nZn8Y/c9yj79CfpQ+k9OG2F4kvgfpwcuY/guxXQqzHS
Ysztf0UN7mjvithVHncvhQgpPwYjX0Jg3ALM+1jgCWL2VTCa/d4H0J+lT6TP
pL84l/3VLmXW+JSB7bB4B7Cv4ZinsPD9hMd67LCCwJjtf/kOq+GuKMNfbcjI
0olkxipy5Q4C+GFS6gUMtA17Gc6PAfk36R/Oop/bpdQ+/R3cn8RQ3yYeXiKY
DecvCYOb2NTOpWj5c/geUYZ5iPdLziCQbob4A3jsefC9xbofYTED90/pC+lL
i9V/Ocd9SfNzcH6GST+MQb4Iyc1E/3p2OUNYGaydzkAX//JORnVcBaS7qDxP
k8tbsdf2GM/nADAs/5b+w4cvm+D5iCDYRkw8i8U2EYBXUB69f4LT865owhpG
/BVdTyA/SLQkQlL2F66ENMXxQRMcD0PpRuKi3R4w7HzGAaki+3AtU7dQ+F5F
5fss/TGrK+WCvPBT2ttjZ7yOL38NeVuUp4lymu5/roL59cLvRVXxuo2ya1Dz
KBX1ZRy91a27zX3z+z3tV1juMaLTHTZ5HmaX5xv8WmGdCp8O6r+becU7kp8m
OqBJeyej0kAqfGIpfqrKS8dPt4RSA3fxSjgaruGQpBulKyKdoZR7JiY7Pudn
sA+t03tH099qw8gNd6vuO/yzaP75h/jpoVCqLtLpn5AJIzE8edRGOv0zRu0j
naFU+0gnmaLwOaukCumk/RNsHSOdoVR5tHJnpDoFo+FuVhzp7IZ052A06buK
k+6JdPx8WCiVGyHgqSfs1jTSsiMdRKz2sWtuQ/SkkZT1P3EWW3s=\
\>"]], ",", 
   Graphics3DBox[
    {GrayLevel[1], SphereBox[{0, 0, 0}]},
    Lighting->{{"Point", 
       RGBColor[1, 1, 0], {0, 0, 2}}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {GrayLevel[1], SphereBox[{0, 0, 0}]},
    Lighting->{{"Point", 
       RGBColor[0, 0, 1], {0, 0, 2}}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->277173877]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->421043655],

Cell["Point lights at various positions:", "ExampleText",
 CellID->87114654],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Sphere", "[", "]"}], ",", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"\"\<Point\>\"", ",", "Orange", ",", "p"}], "}"}], "}"}]}]}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "2"}], "}"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->502875113],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[SphereBox[{0, 0, 0}],
    Lighting->{{"Point", 
       RGBColor[1, 0.5, 0], {2, 0, 0}}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[SphereBox[{0, 0, 0}],
    Lighting->{{"Point", 
       RGBColor[1, 0.5, 0], {0, -2, 0}}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[SphereBox[{0, 0, 0}],
    Lighting->{{"Point", 
       RGBColor[1, 0.5, 0], {2, -2, 0}}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[SphereBox[{0, 0, 0}],
    Lighting->{{"Point", 
       RGBColor[1, 0.5, 0], {0, 0, 2}}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{452, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->6775671]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19530526],

Cell["Point lights on specular surfaces:", "ExampleText",
 CellID->303147012],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Specularity", "[", 
        RowBox[{"White", ",", "50"}], "]"}], ",", 
       RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"\"\<Point\>\"", ",", "Orange", ",", "p"}], "}"}], "}"}]}]}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "2"}], "}"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42920961],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {Specularity[
      GrayLevel[1], 50], SphereBox[{0, 0, 0}]},
    Lighting->{{"Point", 
       RGBColor[1, 0.5, 0], {2, 0, 0}}},
    RotationAction->"Fit",
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {Specularity[
      GrayLevel[1], 50], SphereBox[{0, 0, 0}]},
    Lighting->{{"Point", 
       RGBColor[1, 0.5, 0], {0, -2, 0}}},
    RotationAction->"Fit",
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {Specularity[
      GrayLevel[1], 50], SphereBox[{0, 0, 0}]},
    Lighting->{{"Point", 
       RGBColor[1, 0.5, 0], {2, -2, 0}}},
    RotationAction->"Fit",
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {Specularity[
      GrayLevel[1], 50], SphereBox[{0, 0, 0}]},
    Lighting->{{"Point", 
       RGBColor[1, 0.5, 0], {0, 0, 2}}},
    RotationAction->"Fit",
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{452, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->71624431]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->383196132],

Cell[TextData[{
 "Specify spotlight by position, target position and half-angle: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->3174814]
}], "ExampleText",
 CellID->125420044],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Sphere", "[", "]"}], ",", 
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"\"\<Spot\>\"", ",", "Green", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1.5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"Pi", "/", "3"}]}], "}"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->248436733],

Cell[BoxData[
 Graphics3DBox[SphereBox[{0, 0, 0}],
  Lighting->NCache[{{"Spot", 
      RGBColor[0, 1, 0], {{0, 0, 1.5}, {0, 0, 0}}, Rational[1, 3] Pi}}, {{
     "Spot", 
      RGBColor[0, 1, 0], {{0, 0, 1.5}, {0, 0, 0}}, 
      1.0471975511965976`}}]]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->474885135,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->60933695],

Cell["Spotlights with different colors:", "ExampleText",
 CellID->1020162722],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"White", ",", 
       RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"\"\<Spot\>\"", ",", "c", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "1.5"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
         RowBox[{"Pi", "/", "6"}]}], "}"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Yellow", ",", "Blue"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42457521],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {GrayLevel[1], SphereBox[{0, 0, 0}]},
    Lighting->NCache[{{"Spot", 
        RGBColor[1, 0, 0], {{0, 0, 1.5}, {0, 0, 0}}, Rational[1, 6] Pi}}, {{
       "Spot", 
        RGBColor[1, 0, 0], {{0, 0, 1.5}, {0, 0, 0}}, 0.5235987755982988}}],
    RotationAction->"Fit",
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {GrayLevel[1], SphereBox[{0, 0, 0}]},
    Lighting->NCache[{{"Spot", 
        RGBColor[1, 1, 0], {{0, 0, 1.5}, {0, 0, 0}}, Rational[1, 6] Pi}}, {{
       "Spot", 
        RGBColor[1, 1, 0], {{0, 0, 1.5}, {0, 0, 0}}, 0.5235987755982988}}],
    RotationAction->"Fit",
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {GrayLevel[1], SphereBox[{0, 0, 0}]},
    Lighting->NCache[{{"Spot", 
        RGBColor[0, 0, 1], {{0, 0, 1.5}, {0, 0, 0}}, Rational[1, 6] Pi}}, {{
       "Spot", 
        RGBColor[0, 0, 1], {{0, 0, 1.5}, {0, 0, 0}}, 0.5235987755982988}}],
    RotationAction->"Fit",
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->797765129]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->424724601],

Cell["Spotlights from different positions:", "ExampleText",
 CellID->194385716],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Sphere", "[", "]"}], "}"}], ",", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"\"\<Spot\>\"", ",", "Orange", ",", 
         RowBox[{"{", 
          RowBox[{"p", ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
         RowBox[{"\[Pi]", "/", "6"}]}], "}"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "2"}], "}"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->763250457],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[SphereBox[{0, 0, 0}],
    Lighting->NCache[{{"Spot", 
        RGBColor[1, 0.5, 0], {{2, 0, 2}, {0, 0, 0}}, Rational[1, 6] Pi}}, {{
       "Spot", 
        RGBColor[1, 0.5, 0], {{2, 0, 2}, {0, 0, 0}}, 0.5235987755982988}}],
    RotationAction->"Fit",
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[SphereBox[{0, 0, 0}],
    Lighting->NCache[{{"Spot", 
        RGBColor[1, 0.5, 0], {{0, -2, 0}, {0, 0, 0}}, Rational[1, 6] Pi}}, {{
       "Spot", 
        RGBColor[1, 0.5, 0], {{0, -2, 0}, {0, 0, 0}}, 0.5235987755982988}}],
    RotationAction->"Fit",
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[SphereBox[{0, 0, 0}],
    Lighting->NCache[{{"Spot", 
        RGBColor[1, 0.5, 0], {{2, -2, 0}, {0, 0, 0}}, Rational[1, 6] Pi}}, {{
       "Spot", 
        RGBColor[1, 0.5, 0], {{2, -2, 0}, {0, 0, 0}}, 0.5235987755982988}}],
    RotationAction->"Fit",
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[SphereBox[{0, 0, 0}],
    Lighting->NCache[{{"Spot", 
        RGBColor[1, 0.5, 0], {{0, 0, 2}, {0, 0, 0}}, Rational[1, 6] Pi}}, {{
       "Spot", 
        RGBColor[1, 0.5, 0], {{0, 0, 2}, {0, 0, 0}}, 0.5235987755982988}}],
    RotationAction->"Fit",
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{452, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->26719282]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->236925353],

Cell["Spotlights with different half-angles:", "ExampleText",
 CellID->40655653],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Sphere", "[", "]"}], ",", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"\"\<Spot\>\"", ",", "Orange", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "1.5"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", "a"}], 
        "}"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Pi", "/", "12"}], ",", 
       RowBox[{"Pi", "/", "8"}], ",", 
       RowBox[{"Pi", "/", "6"}], ",", 
       RowBox[{"Pi", "/", "4"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->799186250],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[SphereBox[{0, 0, 0}],
    Lighting->NCache[{{"Spot", 
        RGBColor[1, 0.5, 0], {{0, 0, 1.5}, {0, 0, 0}}, Rational[1, 12] 
        Pi}}, {{"Spot", 
        RGBColor[1, 0.5, 0], {{0, 0, 1.5}, {0, 0, 0}}, 0.2617993877991494}}],
    RotationAction->"Fit",
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzVWEtvW0UUPrGv346fTRqnTmLyfjYNTdw0NKoapFZUAhYgChJEioqlFiig
kqppyIYFjx0bJJbwCxCwRAh+Bit+ASygPEVlwZxzz7WvvzuObyJVFZZ87Zn5
vm9e55yZe57e2b3RuLWze/P6Tu3K7Z23b9y8/k7t8lu3TVW0j4heNd83hsj8
/9f8k+9Ws9mkaKPRaMqHxvhBF80zZiprUto0z4gpRfXXrd0wTybGfArmqQrr
ik1aW+vamuaS0+rd/BmV9rOqneVSrNWuGiOCWVGN/CGYZcWUrJiqYBa1rxOw
EhEoVwQ9r4onQ6FnVLsCrVEoDwl6SrWrodATih6FVgfKMlKq6Uhq0BqD8qCg
R1V7IhT6lGpPQWscygOCrqj2bCj0SUXPQ2sCyrJ78uTKRWhNQrks6JJqL4dC
FxS9Aq0pKIutUb+O5Cy0pqFcFHRGteuh0ClFr0NrBsoFQScVvdFDu432++uk
+U0TBbSxnG+zO/yZ/b1k+LhfWSjn2vyAn7J9DRkNtOxDNA7xTLbZEaMmbuVW
u0wfpl+UcMzYP9tFTZSA2VMJ/YjXftxTMj+2MWWtSug1zJrwKfEnb9u7gJJt
hyZBKUIUmKFdDXeBbXYa1KIWtbRVDX2M22dAzbGoCS+wRmi7vBuzoBYzX7Qv
uxqiHIta3KKWtKrhDNh6546thjY0D0oJi1LCqtSyIWXimJIWpbhViW19Adgp
S4Rx2TZPWbL0zfPnwJMMzUppROEq9OyYVYXX4LRNxRStHh5KgaMrxmI7m3dz
+RGx2S7PADtDFPBMl43rmXsobBy58xDYPO8VYGctI3/0bLwl5v7XbN4xvrXk
LDsV7cpa0i4jIfa7u8q8kuMhvMVVwTsG+/mMktOgkjqSCp/ljq4DxrzwKjUl
l46twhG0quRBUEkcSaWi5GFQsZ24ka4qA7ouo6DiHEmlpGS8MUW7qvhvjXz/
yykRbyOR0AoZJcrZ7LQVgrcZOz+pfDxXerPlbUk7fdxjK7r32L13rXM9mH0B
ZlGZaiTyqVNwh/BG4Cl1eqt3fq8fS4Ht1rs38BgwBqNdBxUSOgZe7zUKnpwY
84IK3i2ELXKVet+lVaH9ntVsZzB4H2235SCf6ZxJOGPxXjvDXzPcdG8ytttj
nykyo3PnG/omt2iq8F4aD7AwLnPWoCghKxenySKtVujCCG2OUH2YZstUThK3
FoAVC+jyWvO5wuOXmJodytClMWqs0HsX6ZOn6LNn6PNn6dOr9MEWvb5KVydp
vECMLIG2E9DGmy6vLp96FK/20/Nz9P4l+vpF+uE1+uUuRX69a+rNnx9v0Tcv
08eXafs0T4Tx5Z494f7w6sg5Ezfrcuc8fXWNftql+3v0xz2K/LVvCH/u0297
3PF32zzRrZpEKD6LBkErGujNyyDw7nG0odx0idfmy2ssaGRND/8c0IMD+vtd
+v0emal9v037F2itIj0MQQ+RQA9of7w7CTkUFk7Qm3X64gX6+Q7PhyKmO4rd
l6l8+wodbNJG1T3HTh3SSzvD0kL5Th1Kmvk8N0u75+nDLfroSdp7gl5aoOVB
OdkkYxnz+xqzXVWMsTLTDr8skJup68yKuGz0Aswprnbh5Zv2HOSar9weYxFQ
mOf0crEu2suJIepcx2piK/bBI4m20AOqiSjOpDkavSkwe1ydpab/DQ9tCuPQ
XNPNYLtZEy/niKgp1XTzamhBGEdrqulmJquqiaiqag4LCrOzthgh9xhBj6km
osra87igHoNWjJV51ZwR9Di02s5IRi8I2ssqIyquI5Bcqayb39Ic1RCLpWnz
jDc0P0nU9x8TL15l\
\>"]], ",", 
   Graphics3DBox[SphereBox[{0, 0, 0}],
    Lighting->NCache[{{"Spot", 
        RGBColor[1, 0.5, 0], {{0, 0, 1.5}, {0, 0, 0}}, Rational[1, 8] Pi}}, {{
       "Spot", 
        RGBColor[1, 0.5, 0], {{0, 0, 1.5}, {0, 0, 0}}, 
        0.39269908169872414`}}],
    RotationAction->"Fit",
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzNWVtslFUQ/rrX7rbdbXd7h7ZLL7TU0lIKVLlIJAE0oQkBUQRjqLjQcgcr
tIDRJ580mvjm5clEo9HEqNEY33z3fjfiXR/QqIjXmI3OnDPb/Zn/tP2boHGT
/fef/8x8M2fOzJzzz46MTozlD49OjO8dzW0+MXpsbHzv7blNR0/Qo3AZgDx9
DzWC7v+mO/PdUCgUEM7n8wXzQY4vWE/XKD1cZKh1dA0RFZZf+3SNUFEPAl0F
4Uq68sM4U5FpfLppM+OrRLpCSdvRIZGu8km3mvFBka5mKjo9LhgthmdAeDKz
8PSJnlrlhZCimw13ryA2BOLuEe4mNRpWtBlHl1iyQI1GFN1ouDsEuzUQd06w
c2o0qmgzL7QKdkcg7oXC3aVGY4quN9xNYkm3Go0rus5wNwh2byDuOuHuU6Pl
ijZrjYxY0q9GE4rOGu5qwR4MxF0l2Cvm4DaRiQrBHg7EnRDuq9RoUtE1hrtc
uFer0QpFV09ze3Oxk36TgI97FmlfpmdJXsdCpaLTJXlfnnI+NBGGzppZMGbJ
TI7CFgicfYyU4kk5kbR+XumcQVKSHtpUL1+06jxi77UXkegnOJL2K0t1MFLE
ItmPxqp0YmmauTo9VvEnBBvbc6Np73F0dim0sAOtwommM4HRFyu0iAMt6UTT
mcJe7FZoUfrqCLNoc8UyV+AehRZzoCWcaHoGHL9LFFrcgVbuRNMrf0UAu9xI
6SItkr0BbIo7kTja+5R0uaPGuKXZjqUOabbaPPLktUVwZZtGSHD8CILeQWNO
FLaj34FiYPLFjzNfA2Fx1XXFqV+a13jgskpXAL6M+zekOdaXOaS15UbOd7JJ
XXbpSofl/z9p9trgfySt9zy2fHkAn0f+JWm2nE8zVfOS4mw3GyJvOKK6cl4I
vWJ0LECezYzSLcJJhZKYEUWfXrhSdIpwSqGUB0bhCtgmPskolPi8UBaKcL0D
Rdfz8IwoTSLcrFBi80KpF+FWhcLnAr0zzYySEb+0K5RwYBQ+d6dEWJ8qQjOi
ePctPllWiKDesfX5wC/NbzdxEdK7SjDpsPjAm6uFgvts4pCm++GipHDqOfsl
awqe/VustSglnrlRUoLC1WsY/izUkV1EKD2pEAQ+T6yCv37OjcB7PnuPrV0J
/66nK60foXgSYZ8MYe6ztSCU3rwKpZ4Gr6Hr9Oyly4w8i3O3oNYUk3gINXE0
V6I1hbYUWqrQkEQqhlpHTmr7ynwz4n5INeOmCbQni3UtGOnCrj7cNojxIRxY
gbEh7BnADb3Y3I4VTawyWkZv3fPQViieu8wbI+8QyFRFMVDPqkjD3evx4LV4
bCue2YHnd+KFm/DcTjx1PR4dwb0bMbkGt/RjQw6L0kg5MkWfQ61WVyeHMxe1
2XKsbeHp3bMBj2/Dq3vw1n68O473D+CDA/jwIF/fG8c7Y3hjH17ahYe2YGoN
tvegr87sidUKWUeRrFnBvt2zf82ukiDf3boMD2zGy7vx9hhr+eQwPj+Kr45R
9fnmOBX3r4/jy2P47Ag+PsQWkPont+POddjazWvNe1FG6dI5YHVrj/Dcue4g
WRnFpnacWYtnb2QbPjrIBnx7At/fgZ9OIXThFPHQzQ8ncX4CZM65w+yW1/J4
eAv2LUd/vdnLdEdO+9paEfd4wOzOSaqx17Txar9yM8/v0yOsmnT9PIlfpxD6
/TTx/HYav0yBDPlugj1DnqDVodAg7UuyZt+pD6RdZxb7gN8cUUdhRIv/xDZe
YVoB8vyPJ3FxEqT5z7P46yz+OMPmWBNoPSgiXt+H+zbiug4T+YzS6LChjEjW
bfXrasRe4P0O2VyaJ/P0Do65c0Y/ueDCJJtwcYqvpPm80UzL8+Z+3L+JNYdl
v9Q9yJBPc7FnNc3p2eGQHm7GydV4cRfPnpxLa/DFUdZFcUDOoKAkdz8ygt19
XGGMVtP1jXorGGPayqZz0fjlkmpn5pxYnOEgPrQSd13NaUf5NDrAsUC5aHR0
XCpHNxY/JXPR/l7poUvW6MysCyRVo7h0dBe74ZY7I5TmGpbndg30qNbBlkSm
uYvdUc01KFz2xK8727qDsFS4bfeiUTA1F3e+eTFt16pZjeqK3imYtr+pY0/H
eE64bT+52H3WXAvEAtuJ111yvYc0CKb976FNMDVXVrhMHGGRGtUVIi0WmE43
2gulf1C0LxjT9KyNJy6N0ISMLzPjXR5pjq2I6DB9ZiymaywvnWGg7B8tH9O4
\
\>"]], ",", 
   Graphics3DBox[SphereBox[{0, 0, 0}],
    Lighting->NCache[{{"Spot", 
        RGBColor[1, 0.5, 0], {{0, 0, 1.5}, {0, 0, 0}}, Rational[1, 6] Pi}}, {{
       "Spot", 
        RGBColor[1, 0.5, 0], {{0, 0, 1.5}, {0, 0, 0}}, 0.5235987755982988}}],
    RotationAction->"Fit",
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[SphereBox[{0, 0, 0}],
    Lighting->NCache[{{"Spot", 
        RGBColor[1, 0.5, 0], {{0, 0, 1.5}, {0, 0, 0}}, Rational[1, 4] Pi}}, {{
       "Spot", 
        RGBColor[1, 0.5, 0], {{0, 0, 1.5}, {0, 0, 0}}, 0.7853981633974483}}],
    RotationAction->"Fit",
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{452, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->253352906]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->171579806],

Cell["Spotlights on specular surfaces:", "ExampleText",
 CellID->89578498],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Specularity", "[", 
        RowBox[{"White", ",", "50"}], "]"}], ",", 
       RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"\"\<Spot\>\"", ",", "Orange", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "1.5"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", "a"}], 
        "}"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Pi", "/", "12"}], ",", 
       RowBox[{"Pi", "/", "8"}], ",", 
       RowBox[{"Pi", "/", "6"}], ",", 
       RowBox[{"Pi", "/", "4"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->240373481],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {Specularity[
      GrayLevel[1], 50], SphereBox[{0, 0, 0}]},
    Lighting->NCache[{{"Spot", 
        RGBColor[1, 0.5, 0], {{0, 0, 1.5}, {0, 0, 0}}, Rational[1, 12] 
        Pi}}, {{"Spot", 
        RGBColor[1, 0.5, 0], {{0, 0, 1.5}, {0, 0, 0}}, 0.2617993877991494}}],
    RotationAction->"Fit",
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzVWEtvG1UUPrHHrzixHefROHGTIe9n07R5QxWUirJAICSgVRdEiopFKyhU
JVXTkiK6ARZI/AEW7GCFQGKJ4I+wY0kXQJFAlBHcc+aMPf7mJp5Eqioseewz
9/u+e+fec869c17c2b1au76ze+3Kjvv8zZ0bV69dec+98O5NcyvZRkRvmO/b
/WT+/2v+yXfL8zxK1mo1Tz40zBfaNNeUuemKdc5cE8ZK6q9/d8NcmZgKKZir
KqwpNmttXdHWdraceu/mz5C0n1XtDrZS9XbVOCmYRdUoHoJZUEzZiqkKZk77
6oGZSIBdEfSMKp6IhZ5U7Qq0JsHuF/S4aldjoUcVPQStDtgyUnJ1JC60psDu
E/SQao/GQg+q9ji0psHuFXRFtadioU8oegZaM2DL6smVb85BaxbsbkGXVXsh
Frqk6EVozYEtvkadOpKz0NoOdpeg86q9EgudU/QatObBLgk6q+iNFtoNdDhe
x8xvO1FEG+1ig90UzxzvZcPH9eoAu9DgR+KU/avfaKBnH6JxSGSyz540ahJW
/m2fGcJ0ihKOGftnv3BFCZgtlTCOeO5HAiXzYxtTh1UJo4ZZoyEl/hRtaxdR
sq3QGCgliCJPaFfDVWCfnQC1pEWt3aqGMcbtk6DmWNSEF5kj9F1ejSlQS5kv
+pddDVGORS1tUcta1fAJ2Hunj62GPjQDShmLUsaqVPchZeKYshaltFWJfX0W
2DlLhvHZtkiZt/TNz8+JJxubldOMwrcwslNWFZ6DUzYVY1ojPJYCZ1fMxXY2
r+bCE2KzX54Gdp4oEpk+G+ez8FjYOHLnMbD5uReB3WEZ+ZNn4ymx8L9m84rx
qaVgWankgax57TIRY70PVplRcjpGtPgqeMbgOJ9Ucjuo5I6kwnu5o/OAOS++
iqvk8rFVOINWldwHKpkjqVSUPAAqth03caBKr87LEKg4R1IpKxlPTMkDVcKn
Rj7/FZSIp5FEbIW8EmVvdhoK0dOMnZ9VPu4rrdnytqSdngnYim499uBda7UF
sy3C7FKmOol8Vii6QngiCJSaozXYv9eOpcB+G5wbeAyYg9GvowoZHQPP9zJF
d07MeVGF4BTCHrlErc/SqtB4z/IaFQxeR9tpOcpnOlcSTlui184I3xnw/JOM
7fTYZkxmNK98Td/k5swtPJemIyzMy1w16JKUVUzTRJlWB2lzmJ51ab1KMz3U
kyNuLQErFdHlueZ9hccvObWjkqfzLr15hj7aos9foi9fo68u0hcv06fP0Tsr
9MIYjZSIkWXQdiLaeNLl2eVdjwrVTnp1mjv47jL9dJ3+3ifvQ/Lu06N79PMN
+v51+uwCbZ+iqW7ZJbtb9oTrw7Mj+0xxqUK31unbS/TLLj3coz/v0j/3yPuA
/nqf/rhDv96mH7bp/iZtuZKheC/qA61kpLeggsCrl5XnMQvw1hJ9c4kFH97h
XswjPdrXXn67TT9u091naLkiPfRDD4lID+h/vDoZ2RRme3gVvr5ID27R73sm
ws1DUcr8Mz2beds/RxtVfx8bPKSXRoWljgrtOpQ1z/PKFO2u08db9Ml52nua
Ls/SQp/sbFKxTIVjjdm+KuZYedKmuCyRX6lrror4bIwCrCkuHcArevYa5HLI
boyxC1BY5wxqsT46qIkharVpNrEV++CRJOvoXtVEFFfSHM3eFHl6nJ15L/yG
hz6FeWja8yvYftUkqDkialw1/boaehDmUVc1/cpkVTURVVXNAUFhddaWI+Qc
I+hh1URUt/Y8IqinoBVzZVE1JwU9Aq22PZLRs4IOqsqISusIpFYq8xb2NEc1
xGNpwlzTNa1PErX9B2DmYjQ=\
\>"]], ",", 
   Graphics3DBox[
    {Specularity[
      GrayLevel[1], 50], SphereBox[{0, 0, 0}]},
    Lighting->NCache[{{"Spot", 
        RGBColor[1, 0.5, 0], {{0, 0, 1.5}, {0, 0, 0}}, Rational[1, 8] Pi}}, {{
       "Spot", 
        RGBColor[1, 0.5, 0], {{0, 0, 1.5}, {0, 0, 0}}, 
        0.39269908169872414`}}],
    RotationAction->"Fit",
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {Specularity[
      GrayLevel[1], 50], SphereBox[{0, 0, 0}]},
    Lighting->NCache[{{"Spot", 
        RGBColor[1, 0.5, 0], {{0, 0, 1.5}, {0, 0, 0}}, Rational[1, 6] Pi}}, {{
       "Spot", 
        RGBColor[1, 0.5, 0], {{0, 0, 1.5}, {0, 0, 0}}, 0.5235987755982988}}],
    RotationAction->"Fit",
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {Specularity[
      GrayLevel[1], 50], SphereBox[{0, 0, 0}]},
    Lighting->NCache[{{"Spot", 
        RGBColor[1, 0.5, 0], {{0, 0, 1.5}, {0, 0, 0}}, Rational[1, 4] Pi}}, {{
       "Spot", 
        RGBColor[1, 0.5, 0], {{0, 0, 1.5}, {0, 0, 0}}, 0.7853981633974483}}],
    RotationAction->"Fit",
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{452, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->557921946]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Lighting Positions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->232920995],

Cell["\<\
Specify the light source position in the graphics coordinate system by \
default:\
\>", "ExampleText",
 CellID->337697905],

Cell[BoxData[
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<Point\>\"", ",", "Red", ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Point\>\"", ",", "Green", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "2"}], ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Point\>\"", ",", "Blue", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "2"}], "}"}]}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->38196049],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Sphere", "[", "]"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "l"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->640431554],

Cell[BoxData[
 Graphics3DBox[SphereBox[{0, 0, 0}],
  Lighting->{{"Point", 
     RGBColor[1, 0, 0], {2, 0, 0}}, {"Point", 
     RGBColor[0, 1, 0], {0, -2, 0}}, {"Point", 
     RGBColor[0, 0, 1], {0, 0, 2}}},
  RotationAction->"Fit"]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->154733362,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
The light source moves with the graphic when the view point changes:\
\>", "ExampleText",
 CellID->20633434],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Sphere", "[", "]"}], ",", 
     RowBox[{"Lighting", "\[Rule]", "l"}], ",", 
     RowBox[{"ViewPoint", "\[Rule]", "v"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"-", "2"}], ",", "0"}], "}"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->577250835],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[SphereBox[{0, 0, 0}],
    Lighting->{{"Point", 
       RGBColor[1, 0, 0], {2, 0, 0}}, {"Point", 
       RGBColor[0, 1, 0], {0, -2, 0}}, {"Point", 
       RGBColor[0, 0, 1], {0, 0, 2}}},
    RotationAction->"Fit",
    ViewPoint->{0, -2, 2},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[SphereBox[{0, 0, 0}],
    Lighting->{{"Point", 
       RGBColor[1, 0, 0], {2, 0, 0}}, {"Point", 
       RGBColor[0, 1, 0], {0, -2, 0}}, {"Point", 
       RGBColor[0, 0, 1], {0, 0, 2}}},
    RotationAction->"Fit",
    ViewPoint->{2, 0, 2},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[SphereBox[{0, 0, 0}],
    Lighting->{{"Point", 
       RGBColor[1, 0, 0], {2, 0, 0}}, {"Point", 
       RGBColor[0, 1, 0], {0, -2, 0}}, {"Point", 
       RGBColor[0, 0, 1], {0, 0, 2}}},
    RotationAction->"Fit",
    ViewPoint->{2, -2, 0},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->216969592]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->851612329],

Cell[TextData[{
 "Specify the light position by a fraction of the graphics coordinates using \
",
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->398728664],

Cell[BoxData[
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<Point\>\"", ",", "Red", ",", 
       RowBox[{"Scaled", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Point\>\"", ",", "Green", ",", 
       RowBox[{"Scaled", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "2"}], ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Point\>\"", ",", "Blue", ",", 
       RowBox[{"Scaled", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "2"}], "}"}], "]"}]}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->34821322],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Sphere", "[", "]"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "l"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->637061817],

Cell[BoxData[
 Graphics3DBox[SphereBox[{0, 0, 0}],
  ImageSize->{100., 108.46406888490104`},
  Lighting->{{"Point", 
     RGBColor[1, 0, 0], 
     Scaled[{2, 0, 0}]}, {"Point", 
     RGBColor[0, 1, 0], 
     Scaled[{0, -2, 0}]}, {"Point", 
     RGBColor[0, 0, 1], 
     Scaled[{0, 0, 2}]}},
  RotationAction->"Fit",
  ViewPoint->{1.2157514191396648`, -2.5721924925827744`, 1.8318772524273312`},
  
  ViewVertical->{0.013023104225624789`, -0.06057456806554722, 
   0.9980787145611316}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->229437637,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
The light source moves with the graphic when the view point changes:\
\>", "ExampleText",
 CellID->59905348],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Sphere", "[", "]"}], ",", 
     RowBox[{"Lighting", "\[Rule]", "l"}], ",", 
     RowBox[{"ViewPoint", "\[Rule]", "v"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"-", "2"}], ",", "0"}], "}"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->52272807],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[SphereBox[{0, 0, 0}],
    Lighting->{{"Point", 
       RGBColor[1, 0, 0], 
       Scaled[{2, 0, 0}]}, {"Point", 
       RGBColor[0, 1, 0], 
       Scaled[{0, -2, 0}]}, {"Point", 
       RGBColor[0, 0, 1], 
       Scaled[{0, 0, 2}]}},
    RotationAction->"Fit",
    ViewPoint->{0, -2, 2},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[SphereBox[{0, 0, 0}],
    Lighting->{{"Point", 
       RGBColor[1, 0, 0], 
       Scaled[{2, 0, 0}]}, {"Point", 
       RGBColor[0, 1, 0], 
       Scaled[{0, -2, 0}]}, {"Point", 
       RGBColor[0, 0, 1], 
       Scaled[{0, 0, 2}]}},
    RotationAction->"Fit",
    ViewPoint->{2, 0, 2},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[SphereBox[{0, 0, 0}],
    Lighting->{{"Point", 
       RGBColor[1, 0, 0], 
       Scaled[{2, 0, 0}]}, {"Point", 
       RGBColor[0, 1, 0], 
       Scaled[{0, -2, 0}]}, {"Point", 
       RGBColor[0, 0, 1], 
       Scaled[{0, 0, 2}]}},
    RotationAction->"Fit",
    ViewPoint->{2, -2, 0},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->246604841]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->523087321],

Cell[TextData[{
 "Specify the light position in the view coordinate system using ",
 Cell[BoxData[
  ButtonBox["ImageScaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageScaled"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->786553906],

Cell[BoxData[
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<Directional\>\"", ",", "Red", ",", 
       RowBox[{"ImageScaled", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2", ",", "2"}], "}"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"\"\<Directional\>\"", ",", "Green", ",", 
       RowBox[{"ImageScaled", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "2", ",", "2"}], "}"}], "]"}]}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"\"\<Directional\>\"", ",", "Blue", ",", 
       RowBox[{"ImageScaled", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", 
          RowBox[{"-", "2"}], ",", "2"}], "}"}], "]"}]}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36029668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Sphere", "[", "]"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "l"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6294624],

Cell[BoxData[
 Graphics3DBox[SphereBox[{0, 0, 0}],
  ImageSize->{100., 108.46406888490104`},
  Lighting->{{"Directional", 
     RGBColor[1, 0, 0], 
     ImageScaled[{2, 2, 2}]}, {"Directional", 
     RGBColor[0, 1, 0], 
     ImageScaled[{-2, 2, 2}]}, {"Directional", 
     RGBColor[0, 0, 1], 
     ImageScaled[{-2, -2, 2}]}},
  RotationAction->"Fit",
  ViewPoint->{1.5200462943115898`, -2.4006827974847664`, 1.8374388068750258`},
  
  ViewVertical->{0.04738453664307964, -0.03915944521454713, 
   0.9981088335134649}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->334214045,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
The light source position is always fixed relative to the view point:\
\>", "ExampleText",
 CellID->10566005],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Sphere", "[", "]"}], ",", 
     RowBox[{"Lighting", "\[Rule]", "l"}], ",", 
     RowBox[{"ViewPoint", "\[Rule]", "v"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"-", "2"}], ",", "0"}], "}"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->596178556],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[SphereBox[{0, 0, 0}],
    Lighting->{{"Directional", 
       RGBColor[1, 0, 0], 
       ImageScaled[{2, 2, 2}]}, {"Directional", 
       RGBColor[0, 1, 0], 
       ImageScaled[{-2, 2, 2}]}, {"Directional", 
       RGBColor[0, 0, 1], 
       ImageScaled[{-2, -2, 2}]}},
    RotationAction->"Fit",
    ViewPoint->{0, -2, 2},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[SphereBox[{0, 0, 0}],
    Lighting->{{"Directional", 
       RGBColor[1, 0, 0], 
       ImageScaled[{2, 2, 2}]}, {"Directional", 
       RGBColor[0, 1, 0], 
       ImageScaled[{-2, 2, 2}]}, {"Directional", 
       RGBColor[0, 0, 1], 
       ImageScaled[{-2, -2, 2}]}},
    RotationAction->"Fit",
    ViewPoint->{2, 0, 2},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[SphereBox[{0, 0, 0}],
    Lighting->{{"Directional", 
       RGBColor[1, 0, 0], 
       ImageScaled[{2, 2, 2}]}, {"Directional", 
       RGBColor[0, 1, 0], 
       ImageScaled[{-2, 2, 2}]}, {"Directional", 
       RGBColor[0, 0, 1], 
       ImageScaled[{-2, -2, 2}]}},
    RotationAction->"Fit",
    ViewPoint->{2, -2, 0},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->836391543]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Lighting Attenuation",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->269630291],

Cell[TextData[{
 "By default, point lights are not affected by the distance from an object: \
",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->214237085]
}], "ExampleText",
 CellID->119367541],

Cell[BoxData[
 RowBox[{
  RowBox[{"obj", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sphere", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"3", "i"}], ",", "0", ",", "0"}], "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "4"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->77590625],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"obj", ",", 
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"\"\<Point\>\"", ",", "White", ",", 
       RowBox[{"{", 
        RowBox[{"24", ",", "0", ",", "0"}], "}"}]}], "}"}], "}"}]}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
   RowBox[{"Background", "\[Rule]", "Gray"}], ",", 
   RowBox[{"ViewPoint", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1.5", ",", 
      RowBox[{"-", "1"}], ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->94177601],

Cell[BoxData[
 Graphics3DBox[{SphereBox[{0, 0, 0}], SphereBox[{3, 0, 0}], 
   SphereBox[{6, 0, 0}], SphereBox[{9, 0, 0}], SphereBox[{12, 0, 0}]},
  Background->GrayLevel[0.5],
  Boxed->False,
  Lighting->{{"Point", 
     GrayLevel[1], {24, 0, 0}}},
  RotationAction->"Fit",
  ViewPoint->{1.5, -1, 0}]], "Output",
 ImageSize->{184, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->180563872,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
Specify a point light that attenuates with respect to the distance:\
\>", "ExampleText",
 CellID->354574764],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"obj", ",", 
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"\"\<Point\>\"", ",", "White", ",", 
       RowBox[{"{", 
        RowBox[{"24", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}], "}"}]}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
   RowBox[{"Background", "\[Rule]", "Gray"}], ",", 
   RowBox[{"ViewPoint", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1.5", ",", 
      RowBox[{"-", "1"}], ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->6678542],

Cell[BoxData[
 Graphics3DBox[{SphereBox[{0, 0, 0}], SphereBox[{3, 0, 0}], 
   SphereBox[{6, 0, 0}], SphereBox[{9, 0, 0}], SphereBox[{12, 0, 0}]},
  Background->GrayLevel[0.5],
  Boxed->False,
  Lighting->{{"Point", 
     GrayLevel[1], {24, 0, 0}, {0, 1, 0}}},
  RotationAction->"Fit",
  ViewPoint->{1.5, -1, 0}]], "Output",
 ImageSize->{184, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->22266429,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzt24W7ZVXdB/DNOffOMMl0McAwSI0gKSkOXdKhgqgMJd0h6ojSXQoKKN1l
gIVJGoBKh3R3SCrwvO9n7+89aw530D/gfd55ntnPvueevfZav2/8fivuhjP2
33nHPWbsv8v2M6ass++MvXfeZfv9pqy9174+as9RVdW1/i89oXL/P+6a/9fO
nDnTL2a7Hufa8oWqPWTIkPHjx88333xVa8EFF5za/PYo13b926GDBw+eOHHi
wgsvvMwyy3z6059ed911N9lkk89+9rNf+MIXvvjFL7puttlm8zbP7FRf23PM
Mcecc85Z307utDHCB+PGjVtooYWWXXbZ1VZbbcMNN/z85z+/3Xbb7bbbbvvt
t9/BBx/8zW9+89vf/vahhx56yCGHHHjggZOb9mbU16Geb7VaI0aMmGeeeRZd
dNGll156pZVW0sjaa6+tL+uss86qq646zjd76jeNNpbJkycvtthivuTXW265
5YwZM3bffXeNavroo48+6aSTTjvttDPPPPOHP/zh2Wef7fq9733vmGOOqSY1
71yzvvZqSZdHjhwpLgZfje2MZC7/5p13Xu2vsMIKq6+++gYbbLDFFlsIgrfs
uOOOO++88y677PKVr3zly1/+8pprrlmN7PRrvKgMGzbMo5/4xCdE8TOf+cxW
W22100477bvvvr5z1FFHnXLKKWecccZ555136aWXXn311T/96U9/9rOf/eIX
v3D9yU9+cvHFFx977LHVhKaPq3aQM9ghuvexj31Mq8stt9wqq6yiT2uttZbY
eP2nPvWpakTnu6N6e3thAGA4Tp8+XQ8ERz/1ds899zzggAO+9rWvFRi+9a1v
ff3rX99rr73m6oxgIhCGDh0KBO/yIiPfeuutDXj//ff37eOOO+70008/99xz
dV9/f/nLX/7+97+/6aab/vSnP91666233XbbX/7yl5tvvvk3v/nNBRdcUI1v
xrFIfR2UqE6aNGnq1KnwXXzxxZdYYgnvwLhqWKf3cw0cOBAWer/UUkutvPLK
RqcDm2++uShi4bbbbgsA12222QYdq6EdvMaCccKECYsssojwrLHGGhtvvLFe
Q8qQDzroIOM94ogj9P3kk0/+zne+gxgG8d3vfhdJfG74TUvN+Oc2fo3p58c/
/nE9WH/99XEYghn/8ccfj0fnn3/+lVdeCbLf/e53RmvYd91113333fePf/zj
4YcffuSRR9zce++9Pr/22murcU0URtXXOb1hwIABGAdPLJl//vnpcdSoUUPq
3w6OBvzow2nTpkFQD6IB/WjBsmpju0+akNaX4Z4J6ehBl5dffvnwFeoitsMO
O2CqKCBgC/hVj3HsvffePjSsQZ34jSzx87ygb7rpph5GGY8hyOGHH27gIoe6
55xzjuEjatW65JJLqp6LLroIHQQFnQZ36wCUY8eOZQaaNABWojPao09IJIpX
XXUVCl1//fVoc+eddz7wwAOPPfbYU0899fzzz7/44otV6+WXX6563D399NN+
h2pjm1iO6MRy+PDhc889N7ogEs9ZccUVUbaF9lWbKj75yU/WXxxQdMTjAItx
3MXvwy5EEgqMIpKqhVxV29g/97nP1eEuz44FjLfFFLyH+pAMLdnbrrvuus8+
++DZN77xDRwRLaw68sgj3fjxq1/9qmhXAzuxnpjA6LQe4yqb9XIKY5G+4zm0
FB6BFtsrrrjiRz/60TXXXINtP//5z13dC5vgnXDCCVVtwLWNVePQSv8Qh3IQ
RKvGs8cee4CPHaI8z0FaVnPDDTfQ6t133/3QQw+JtfC++uqrr7/+euutt95q
vf3221XPm2++6aPHH38cMmOaiA+vryPilwQaK+KNQi0SIiUYAkmprt6Nrn7V
U1wJP1kKTtMnI/dr3yNR4aZSAdRTOsRMVz6Oety2PF/ziSuF4om+l/gGSnkS
sYX+sMMOM1JRofJTTz2VvjHWjU8ggfdVbweDubmkVDNlypQll1xSR2UqnaFy
OGoJBtooPg0Acb/uuuvIXURuvPFGjieKfsReCDH1Bt+G+xPa7TaikRObk56M
FU3gKzfph+9KRpdffrkm//CHPwQJrvHMM89A4p///Oe77777r3/96/333+/5
4IMPqp733nvvnXfeefbZZ4E+usGidstqVJ2zhw7FfqJlFOgsKDHLQmdmiZ6u
X/rSl/Rho402anUiOjwmD5F+jgEO6RoQgipji0arEZEbTKZfUeJBnUhOGDRo
EC/7T85L7IIJATjgtHwsGWM2y3D9wQ9+4EO/1Xi70+I8lCbhxYHFb7311uMd
22+/PWbIXaRFH7ChAFGUQGEAiSQhlvvXv/71b3/7m+vtt9/+xz/+kWn8+Mc/
rrNqb0crYylQLoI+HzB2VBQjQ5Yn+Nz3v/99wpPdZDEN8CVC4UCvvPIKeN54
442q9e9//7tqQ+aD5l/VINUGHDk14DQ4DenEepjhAAodKB7bUltxGOE2LlyP
AKqWoFU97hiGX/hG2B/fSoxpG1YiUnI6ZouLSBOAYNOAOsfVPU/2Kw0KYtW0
NZpPjB49moCNnRK1hS5e5kspnhQpJ554IsM466yzwHThhRfy+csuu6xqCXfV
Sw8+QmGIartqFdxEVepaYIEF0FFUDdH4jEyzqg0op3LQlNj+6le/wv5bbrkF
Yn//+99pQP68//772bwbP0KPxJRIVU8Ht/GUlSJWKLiAQWG1WCEaWlA7TvE4
hMAGJHjwwQefeOIJsmJo0IEaWVWDGrRoDKw1UCMLWtWYOBztylulEJYNvYdV
oX60IeRGRQ8U4koqjKOJ70jxHTNmTOILa+pXOdIfrBDYU7gOFlGWBQW69o6W
WFY97gQJcEBo2hpTXK8UutrSD0HVgySLYEVJ9ACo5AuqaMkT1QA3fgQcJ/MS
ztpgNV+qPKRMlSOSWMBMDUOz+iCYMNYg8YgnrEgBJgodKImcRC1BPPnkk66P
PvqoUBOKYgg/qnYHsTHJSqkmsY07oC3OCoLhR2n6SL9//vOf77nnHq2yOmlf
Huqvsjkb3EA5s/mXKqAa3EDoXT09PYiNfiydG5oxYGBwE3v0ll8RRT4kc3m5
amFlNcmdzlTNv2SpBFvJAncphpclxXgRhdGWkIulqOs/I2JqroxMzJJdKAEH
kuEpwai1gzyYU6qpgKZKLhMB6Z0qpBm+8+tf/9q96tGv6kq6ySzziaaspWjE
LT6g3SjMsPRMt/TDt0lAW2JKXoGMqlSltCDLPPfccy+88IIKS6DBJ/Xccccd
v/3tbxslD2hQ4+lRsgpKVpEYBAHj8FZe5OBYppAoImOOIOOMRDW8QcknfSjN
1aA0qOOFI0oaVz3IFzJvPy/LNNGrSJpKWshYTXITiErxRJ2xQi7JvTPFFF0P
gkiKkP/hI8ZJNwSQpMPWMmcoAoA2tkRa2qFRpNAIkGFb5moERQnAkVKUAVWL
P1U9lOEj0ZCfG5Tm59ZmYKpMI8Qi0UvyQrMISwAzfYKyYkIJEIjISAKBz0sv
vaT+eu2111RlbvwIN0BJavrRmbpWY/mhQXhZ/JDXyL38kCVxBgHgCeSvf1Kj
d3gB6LWbMqMKVqQ2G1bV2KIoVqakVFezH5lSZcEnGEmZ0aMeeGRY7oWDQl9X
psk2xb50Tyw8j7FRgk4Kc7KNrqKuuAi27FJmF1PYgzEEet0J+3UnNRt1I6a2
UhckxWjFU9AIXpgNLFQlBhYmEG78SB5E0jBhKjckfWTQUdaRWTtCGuLscz7o
awfx5SmYkBAtoT+seJMaWrnmSg0+hBu71IFSe6g8M2vxLulFTSY5xBGFUBQM
Xs/RSmb0rPYVHlrWbG2IwUwe+xBmc3b0NTq1glpDrcB7RIlAEFsBKlCcIjYm
7sYFK1kHJQEQxOoca3oqymxU/3CKPgksOUcv2Rfrpg3qkiLERbjxWZJhC2JU
lwnxQak0YuUjtJ5ZJX5qCG+IwcspTBOKAokGILgqWvJIWVHgYG5MEIEWH5y/
u3pPVik+qHcGRePCqEUmWhRmUi5XJb0AC0apCWQYV/eC7Fe+Q2fVgE6l6E1m
fd7EboxAKCRJKRptmYuO67V3IIQXwFvTFJWmq7katLTah9bwfmgpQ03ZFl98
cUm4ZJzoK2WdHEXKAm5USTq4KPJ9aOlfWXGDNjZhrudL9S3I3dUcqPQYSHyE
M4iQax9aWWXCnPhW/FBHNKQXuoAkANeE51FUpiqLP6m7FXJySapv+TxoTeiu
C7GAB2hXSjU6LDQojeKPDAh8yHv43nvvla+YYewq7K/rgVZdwPVCTHyZGDB9
NViNStbCXO8xtdd/gShZK6UhPpC/SkXzZKvhtlaDklZnQ6nxQZLQ8NSpUyMJ
xZK2sz6Skq5UBpnodFcGVangE1uzLRkVznw0PigMekj7xABb9pWigJiAJEsI
jGi7pq3JZbmHg6R2o/CkGIZMAADP+kHmrlGVZMW2KEF4gUQPimxX9xTW05nL
dS/ZGKVmddH4DM6wMEi3svAFdXhzqFKzsTzMF8/ezszVjz6Xdno79axAJKew
BEmXt4hCZsYix/6NWVrUuO55UPGuEU3VyM/Vz/uC08COmupqsxQHfIGPp7Zg
OTQr4RBEFgJTH2RGSsUYGJxSEyRf6Z7JNHdmnR+5DiZTEZNMQ0YQUq2JTL3i
F5xklSwjZyVVb1JjpwrMPBZPjDnul3ksKyEdkAhuQMJwlbF7nwQnQTQJSoWR
IKZ0Z6pZoM1aD+ClEa3he6ZCagvJJDmq4CSe1ERmUk2D0+jMwFPCooLEr+ei
wAlKXaHDWKVx3cOA4NQ0VqM04sPIjM66rh5nZ6CUbUxbaNFWntW06FJB9MOw
wBJvGpfKPD6ZaRBYPZw1s+R+/Uq5xvojHpoJKMqzdmdtpmQOUs7qdtbnpbay
Pl/WFvgFj2NK8k+EAwojbkn+Vdu90NYNp3XsKcs+emmIypMseZYiQrf0Ro4r
SSkVhPiXtFFwUU8TlWK64OIVKB7oy/xX/HRd2DgHw8Ai3dVDiKsdYV2N/ghM
ypovKaZSgHLBJLknZYKgIJW4RCp9mGQ5FLljQv2mpgUTOBZMMjXNUmYHk8mp
62Zfi+vGBLDGpoXZMYFAMGFFxhxMembDIzapWZQpeGjzI/FI2oEHAHhPPzwk
+f/H4/8+HrJJ925mPEtIk020mcXNbCt1Z5PgMb4k6cwv5ZKkIgNOGZ1c4pkU
ZhwnCT+eldX+5JLat1IqLrHEEvGtzH10RC4p69XxrWzMZU00uYRvSSSgaNXl
Utu9XDLLt7oX1fiWfFJ8K/kkWzXJJ9mqST7hW+an8kk3LqnOlMHqt+T9kk9S
WmS1ST4p81S4yCemahrXw4ILiEd+ZM4vtRmy9ltuM99OzlYPZe9PqJVXqiLR
jm7EnAz6arMsNk+bNi11b+aoarvEVmFXpjsl50uukU7Sfr3UVmqzrHdJVWaS
uoMzyfll7VpD2UA1ZFQ3arVZamils9gGKlf3BFVyftiY2iyrCqnNDK67NiNG
qIP8gQceyISnewLZXZv53BeindRmiaWpI8LquSiozbK2yjSMObVZVupgVOf8
ujIb8d9R0ngsBX2zNkcNKuCytlYWReNuASpFdB9K2Xgi7Mwls6bmeShnJSGb
/h6jwBgcKWBtpjk04do302ESQbz79ICOaEgvsjinDteE50XUoLNYXSoz0QVO
JjuMqm+mo4+luDUDMUbtmoplDy4rP9iDLkAviwiqXBk+mz+RUh3IFoiqHkJi
cGRGb80sZ3RZm+NK4YEgiCCeChwS6LKZmdbLgo9G68ZmVdAfNdPpXq/J6pwR
dG9x8oNU0OSUqU5208lXuPpQMjPPImzZXcAiz5tGZgU1u0EpoTPVueSSSwBF
UTrO/9z0oWSkQTxzJrqk6912201D4EZ6rVAxRSYPZbFH/QwoPgKobAW5IS0B
6Vs9yAZ8WUXNTqkOGh2mGxQC6RTGiCML9XA2S1NAMzyQEFM8T1Cpyr0o+xXP
w4rMSOuq15vQfqmllsrMVyjEUfdRNduAWUf1jBeQKg5oqwsrL/oPWJW5f/dJ
DyGSU3PSA+28yZjAlcUeg2v2Gzqzse6SgRC6pzuZlmYplag4JvcDF1Gwrla9
ITSlXuvv/IN8eBnkN9poI1VDThBkR7U4n9jCmW1mAYH5AYypEBfYskAn/ysr
sjon95U9hOQ+ytdJI9RDbEIlJECfFA7F/IqwAhmvCmpZoFNQ0JWoY0ZZncMN
ebbsV4QbLCY7g4JgyHruLbjlFeDWeAr3WmPBjKg/hNmgzo6tkJcVH95TDhGw
CYUBN8/+UA4RZFG1JftUk+r9y+YfUXQfdEmYs30XgWV5LhUidWRNVf4WIei5
8UmD/7icaMhYk6skfgRFnhhhlnyyS4Gp/LPfNnirWZJzwx15JMVEYTJq6rzU
E0mBmZ+WdYTigwpHCqWwrM8p5liWzKSAyHZrFsFhJeXwNDLvvwLuZcwch8MN
HoG9HFcIDLtUFslaZTuwxiurqdjwodXUsqeUaWvZC1S40LA3CDhHDF7lPBUH
rlrCX02q75p/ZTFV3ltllVVSlUdiWQFPCYlalNk97QWSuLs3hH5uCPhyQmf2
UyNZ/WaIQSsbFoYPM1f3PuGVzdGdzupcclZOoxhf3FB9GzfUCS1SbLYB6ZOn
KtIoB1wElsM6LdVANdANE/O5LyAHcc7CqlQYWVXorjCy+oMVZYmuGGLqy1lY
ec1sWOXsWNYIyhkofijYigxgERcRZwMQXoyxatW7fnP7wev7SavMv/qtUWT1
KKUkgSXx5SRZ9m5r8FMHpl5PwZO1n+RBMtWFbC95JjVlqf2752Ku9OFDhsvg
vDs7t91uWM7niaJZnu/onA5pk7y0RqzsFfWVLBChMJ5oPsW2AOfq/pFHHuFX
vlNXsWXndtYZCbmrnJHIyreRIgUKxQnlxzKXysZSvUg7pFNpyI79dtkXrppz
bkmNhsElMK/7jKXxEDHIvFDsAefqRzjWB7QaI/3vp7Foy6uYGGWIdW2iLTKr
etz5CAIC1u5UVJn9RFk5j5W1WaCXtVlYdRcs0k3Vqo8nDHAn2owGTExnZt85
oHm0m/ysXR3MfBwBskibQyzZrRVHyszKH3HxQnNnYFHAww8/7Eam4Xx+S4Oz
zkOMM/nhfhMnTkR6Dl7cr8x3s97Emoui2GsSVg5DDO6chciGbR9K9WnIasGq
swPIv3LaCw9kCdaTsyuA4uuwYkOu6lCfmNlRdtNM/XgWzqmAO5ct+aQ7eOaM
kS83+/FCXQ1gpOzUp8IPh466J2bVu2zPdy/OgrtUK/HRJD6jF98kPkmQoVIq
BVflrFEdwZzXjU4zry7ndaHJljyXDUXazEJ69qYyWWsBpurNKroocy82Nuus
0ThzAjHInCB76WKG0MaZjapUFAqhZCgCVWTSUakwB3aU5EefV/1OgUVJagok
8A5pKifywORl4DAiFuEGAw2QXNqNfaZo48flzIT5BBkBVwrIsTwYCUV9cLRV
+2R9etRHwNZ0u4PNSFHUhWyQJM3lzHFZKclGb+Z22ZevWvXUrjenJvzCN2i3
4fbsZyjK3qEedVf/EiV0sxsl8HJcikkVHa24Zp/Xbzlic5Yz54j0N0eylGH6
y+m1XXSjg5lGERtNKvTYm8JBWaIUKbBU3avnrI/FBpkmL9XnnbPpU45tC7Dp
BnCqlqKoaqOwgZFV07NqWD+9wSlZLAdUUV2AoFK1hL/qQVI/AxZovR0kxnWf
Psru7eynj7KlGFMUeVc8px6JieDKGcm+3Zqcw8t2iLZyzL57SxCF6YsDmmgj
sqDxmxahVD3SD83Ax3fKSdXx2Q8sisguUzJLOX2neolrERkvVFBk5pWti2aG
VO8G1jf1iSBlRy3DnFVtPGxw4s+AKYMHGwOJ4yfIvbqcRxkkjZjxcn8R41EQ
QV9ldX2+vIXGVVsH2VaNW5l7DS/CkR2zoIGgwABJnI1QpCCFRlNntDHLJ7yq
aSOrbjl1wHuyVhTVlD9jSI3AzrrzjrquzJL5Rg51zTp1rcUcxyxn13N2P8sD
ZV88RxvLTqsUk51WRbdJUdXC8qpHsEU109mcul6oM/p6iiRmolqOXbfqP0Jo
82VRrL88pMPo/E0HDMrfUmA059YxBpH0UbXqA9Jtd0Zfx72cnOybo3g8c5TE
KMvaZRm1THfKXp4rdxEao551sj9er63uUwNUn3m/Jrrn/Tk1wN+xT4By1E2S
dGUFDAE3+072T6uv9SuIzwsEZ2RhV+boeJIE6rWowoQRqmrVQ22jGmo14Sr7
mKW6yTTRIzl4k5l9OUNIxXzQ8F35Fv2oLoZ3xjsm2bfsuyNoToTPXtkrN7Na
XFbwm6zWZmlSXV1z5C85Vu84W3IODpBSt7Ka3JRzXoiYM6tUnr3YbJqDPHkF
fiTh6p6tlb+hGaXCLc6fmY5+B6fM98vmtq7zlzh/Swat2njNgySFvr+h2bbT
n6GZ1psm6s/06dPFVOQR0ZxXwnOVBcZ0+jDCAMusKGdZyxl91YlgC1/ZrEea
Zj2kTVvYV1cYE5u3bz+z7+8UsjiSeOkCLQjMxPK2st0iGZUDN0acnZtytICA
zTyAnb+bOrLjJMOzNlpWguL6OahFWSDHGq7CnOZpnjym8LPfn5sgm+dlKe5R
TZn50X9RVs3xvz4c7HE=\
\>"]]
}, Open  ]],

Cell["\<\
Specify a point light that attenuates by the square of the distance:\
\>", "ExampleText",
 CellID->79961340],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"obj", ",", 
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"\"\<Point\>\"", ",", "White", ",", 
       RowBox[{"{", 
        RowBox[{"24", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], "}"}]}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
   RowBox[{"Background", "\[Rule]", "Gray"}], ",", 
   RowBox[{"ViewPoint", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1.5", ",", 
      RowBox[{"-", "1"}], ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->652642728],

Cell[BoxData[
 Graphics3DBox[{SphereBox[{0, 0, 0}], SphereBox[{3, 0, 0}], 
   SphereBox[{6, 0, 0}], SphereBox[{9, 0, 0}], SphereBox[{12, 0, 0}]},
  Background->GrayLevel[0.5],
  Boxed->False,
  Lighting->{{"Point", 
     GrayLevel[1], {24, 0, 0}, {0, 0, 1}}},
  RotationAction->"Fit",
  ViewPoint->{1.5, -1, 0}]], "Output",
 ImageSize->{184, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->202490297,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->900057609],

Cell[TextData[{
 "By default, spotlights fall off sharply outside the cone: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->496911707]
}], "ExampleText",
 CellID->293028337],

Cell[BoxData[
 RowBox[{
  RowBox[{"plane", "=", 
   RowBox[{"ParametricPlot3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"v", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"PlotPoints", "\[Rule]", "40"}], ",", 
     RowBox[{"MaxRecursion", "\[Rule]", "0"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->78257798],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"plane", ",", 
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"\"\<Spot\>\"", ",", "White", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"Pi", "/", "10"}]}], "}"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->365679283],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->21078521]
}, Open  ]],

Cell[TextData[{
 "Spotlights with different spot exponent ",
 Cell[BoxData[
  FormBox["s", TraditionalForm]], "InlineMath"],
 " has intensity ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["cos", "s"], " ", "\[Theta]"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->370734673],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{"plane", ",", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"\"\<Spot\>\"", ",", "White", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Pi", "/", "2"}], ",", "s"}], "}"}]}], "}"}], "}"}]}]}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "5", ",", "10", ",", "30"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->334888690],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{448, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->35106966]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->685601639],

Cell[TextData[{
 "Spotlight without attenuation: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->272442434]
}], "ExampleText",
 CellID->530591953],

Cell[BoxData[
 RowBox[{
  RowBox[{"obj", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sphere", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"3", "i"}], ",", "0", ",", "0"}], "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "4"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->367920287],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"obj", ",", 
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"\"\<Spot\>\"", ",", "White", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"25", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"Pi", "/", "4"}]}], "}"}], "}"}]}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
   RowBox[{"Background", "\[Rule]", "Gray"}], ",", 
   RowBox[{"ViewPoint", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1.5", ",", 
      RowBox[{"-", "1"}], ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->143460150],

Cell[BoxData[
 Graphics3DBox[{SphereBox[{0, 0, 0}], SphereBox[{3, 0, 0}], 
   SphereBox[{6, 0, 0}], SphereBox[{9, 0, 0}], SphereBox[{12, 0, 0}]},
  Background->GrayLevel[0.5],
  Boxed->False,
  Lighting->NCache[{{"Spot", 
      GrayLevel[1], {{25, 0, 0}, {0, 0, 0}}, Rational[1, 4] Pi}}, {{"Spot", 
      GrayLevel[1], {{25, 0, 0}, {0, 0, 0}}, 0.7853981633974483}}],
  RotationAction->"Fit",
  ViewPoint->{1.5, -1, 0}]], "Output",
 ImageSize->{184, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->645742044,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["Spotlight with linear attenuation:", "ExampleText",
 CellID->606375832],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"obj", ",", 
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"\"\<Spot\>\"", ",", "White", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"25", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"Pi", "/", "4"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}], "}"}]}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
   RowBox[{"Background", "\[Rule]", "Gray"}], ",", 
   RowBox[{"ViewPoint", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1.5", ",", 
      RowBox[{"-", "1"}], ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->692091559],

Cell[BoxData[
 Graphics3DBox[{SphereBox[{0, 0, 0}], SphereBox[{3, 0, 0}], 
   SphereBox[{6, 0, 0}], SphereBox[{9, 0, 0}], SphereBox[{12, 0, 0}]},
  Background->GrayLevel[0.5],
  Boxed->False,
  Lighting->NCache[{{"Spot", 
      GrayLevel[1], {{25, 0, 0}, {0, 0, 0}}, Rational[1, 4] Pi, {0, 1, 
      0}}}, {{"Spot", 
      GrayLevel[1], {{25, 0, 0}, {0, 0, 0}}, 0.7853981633974483, {0, 1, 0}}}],
  
  RotationAction->"Fit",
  ViewPoint->{1.5, -1, 0}]], "Output",
 ImageSize->{184, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->658601287,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["Spotlight with quadratic attenuation:", "ExampleText",
 CellID->3315617],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"obj", ",", 
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"\"\<Spot\>\"", ",", "White", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"25", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"Pi", "/", "4"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], "}"}]}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
   RowBox[{"Background", "\[Rule]", "Gray"}], ",", 
   RowBox[{"ViewPoint", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1.5", ",", 
      RowBox[{"-", "1"}], ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->999649206],

Cell[BoxData[
 Graphics3DBox[{SphereBox[{0, 0, 0}], SphereBox[{3, 0, 0}], 
   SphereBox[{6, 0, 0}], SphereBox[{9, 0, 0}], SphereBox[{12, 0, 0}]},
  Background->GrayLevel[0.5],
  Boxed->False,
  Lighting->NCache[{{"Spot", 
      GrayLevel[1], {{25, 0, 0}, {0, 0, 0}}, Rational[1, 4] Pi, {0, 0, 
      1}}}, {{"Spot", 
      GrayLevel[1], {{25, 0, 0}, {0, 0, 0}}, 0.7853981633974483, {0, 0, 1}}}],
  
  RotationAction->"Fit",
  ViewPoint->{1.5, -1, 0}]], "Output",
 ImageSize->{184, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->139799661,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25236],

Cell["Pre-defined colored lighting:", "ExampleText",
 CellID->60610952],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Sphere", "[", "]"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->131552640],

Cell[BoxData[
 Graphics3DBox[SphereBox[{0, 0, 0}],
  Lighting->Automatic]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->162042272,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->124438933],

Cell[TextData[{
 "Pre-defined neutral lighting: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->26976598]
}], "ExampleText",
 CellID->3843248],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Sphere", "[", "]"}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->75719788],

Cell[BoxData[
 Graphics3DBox[SphereBox[{0, 0, 0}],
  Lighting->"Neutral"]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->63041951,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->508434015],

Cell[TextData[{
 "Specify lighting for each object: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->15809]
}], "ExampleText",
 CellID->357488112],

Cell[BoxData[{
 RowBox[{
  RowBox[{"o1", "=", 
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"Sphere", "[", "]"}], ",", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"\"\<Point\>\"", ",", "Red", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "2"}], "}"}]}], "}"}], "}"}]}]}], 
    "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"o2", "=", 
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"Sphere", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"\"\<Spot\>\"", ",", "Yellow", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"3", ",", "0", ",", "2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
         RowBox[{"Pi", "/", "8"}]}], "}"}], "}"}]}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"o3", "=", 
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"Sphere", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "3", ",", "0"}], "}"}], "]"}], ",", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"\"\<Directional\>\"", ",", "Blue", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "3", ",", "2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "3", ",", "0"}], "}"}]}], "}"}]}], "}"}], 
       "}"}]}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"o4", "=", 
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"Sphere", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "3", ",", "0"}], "}"}], "]"}], ",", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"\"\<Point\>\"", ",", "White", ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "3", ",", "2"}], "}"}]}], "}"}], "}"}]}]}], 
    "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->725844390],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"o1", ",", "o2", ",", "o3", ",", "o4"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->332992661],

Cell[BoxData[
 Graphics3DBox[{
   StyleBox[SphereBox[{0, 0, 0}],
    StripOnInput->False,
    Lighting->{{"Point", 
       RGBColor[1, 0, 0], {0, 0, 2}}}], 
   StyleBox[SphereBox[{3, 0, 0}],
    StripOnInput->False,
    Lighting->{{"Spot", 
       RGBColor[1, 1, 0], {{3, 0, 2}, {3, 0, 0}}, Rational[1, 8] Pi}}], 
   StyleBox[SphereBox[{0, 3, 0}],
    StripOnInput->False,
    Lighting->{{"Directional", 
       RGBColor[0, 0, 1], {{0, 3, 2}, {0, 3, 0}}}}], 
   StyleBox[SphereBox[{3, 3, 0}],
    StripOnInput->False,
    Lighting->{{"Point", 
       GrayLevel[1], {3, 3, 2}}}]},
  RotationAction->"Fit"]], "Output",
 ImageSize->{184, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->289439865,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->153858149],

Cell[TextData[{
 "Specify lighting within the graphics: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->11248]
}], "ExampleText",
 CellID->5063482],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Lighting", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"\"\<Point\>\"", ",", "Red", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "2"}], "}"}]}], "}"}], "}"}]}], ",", 
    RowBox[{"Sphere", "[", "]"}], ",", 
    RowBox[{"Lighting", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"\"\<Spot\>\"", ",", "Yellow", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"3", ",", "0", ",", "2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"3", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
        RowBox[{"Pi", "/", "8"}]}], "}"}], "}"}]}], ",", 
    RowBox[{"Sphere", "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
    RowBox[{"Lighting", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"\"\<Directional\>\"", ",", "Blue", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "3", ",", "2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "3", ",", "0"}], "}"}]}], "}"}]}], "}"}], 
      "}"}]}], ",", 
    RowBox[{"Sphere", "[", 
     RowBox[{"{", 
      RowBox[{"0", ",", "3", ",", "0"}], "}"}], "]"}], ",", 
    RowBox[{"Lighting", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"\"\<Point\>\"", ",", "White", ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", "3", ",", "2"}], "}"}]}], "}"}], "}"}]}], ",", 
    RowBox[{"Sphere", "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3", ",", "0"}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->372618166],

Cell[BoxData[
 Graphics3DBox[{
   StyleBox[SphereBox[{0, 0, 0}],
    Lighting->{{"Point", 
       RGBColor[1, 0, 0], {0, 0, 2}}}], 
   StyleBox[SphereBox[{3, 0, 0}],
    Lighting->{{"Spot", 
       RGBColor[1, 1, 0], {{3, 0, 2}, {3, 0, 0}}, Rational[1, 8] Pi}}], 
   StyleBox[SphereBox[{0, 3, 0}],
    Lighting->{{"Directional", 
       RGBColor[0, 0, 1], {{0, 3, 2}, {0, 3, 0}}}}], 
   StyleBox[SphereBox[{3, 3, 0}],
    Lighting->{{"Point", 
       GrayLevel[1], {3, 3, 2}}}]},
  RotationAction->"Fit"]], "Output",
 ImageSize->{184, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->105362727,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->502428332],

Cell["\<\
If not specified, the target direction is given toward the center of the \
objects:\
\>", "ExampleText",
 CellID->128749648],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Specularity", "[", 
      RowBox[{"White", ",", "50"}], "]"}], ",", 
     RowBox[{"Sphere", "[", "]"}], ",", 
     RowBox[{"Sphere", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
     RowBox[{"Sphere", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "3", ",", "0"}], "}"}], "]"}], ",", 
     RowBox[{"Sphere", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "3", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"\"\<Directional\>\"", ",", "LightRed", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "4"}], "}"}]}], "}"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35037907],

Cell[BoxData[
 Graphics3DBox[
  {Specularity[
    GrayLevel[1], 50], SphereBox[{0, 0, 0}], SphereBox[{3, 0, 0}], 
   SphereBox[{0, 3, 0}], SphereBox[{3, 3, 0}]},
  Lighting->{{"Directional", 
     RGBColor[1, 0.85, 0.85], {0, 0, 4}}},
  RotationAction->"Fit"]], "Output",
 ImageSize->{154, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->142583419,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->141984501],

Cell[TextData[{
 "Specify diffuse and specular colors separately for both objects and lights: \
",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->24237]
}], "ExampleText",
 CellID->5395134],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Specularity", "[", 
      RowBox[{"White", ",", "20"}], "]"}], ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"\"\<Directional\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"Red", ",", 
         RowBox[{"Specularity", "[", "Yellow", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->921783432],

Cell[BoxData[
 Graphics3DBox[
  {Specularity[
    GrayLevel[1], 20], SphereBox[{0, 0, 0}]},
  Lighting->{{"Directional", {
      RGBColor[1, 0, 0], 
      Specularity[
       RGBColor[1, 1, 0]]}, {0, 0, 3}}},
  RotationAction->"Fit"]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->459079383,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->39958785],

Cell["Set up four white spheres on a plane: ", "ExampleText",
 CellID->416932894],

Cell[BoxData[{
 RowBox[{
  RowBox[{"obj", "=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Specularity", "[", 
       RowBox[{"White", ",", "50"}], "]"}], ",", 
      RowBox[{"Sphere", "[", "]"}], ",", 
      RowBox[{"Sphere", "[", 
       RowBox[{"{", 
        RowBox[{"4", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
      RowBox[{"Sphere", "[", 
       RowBox[{"{", 
        RowBox[{"0", ",", "4", ",", "0"}], "}"}], "]"}], ",", 
      RowBox[{"Sphere", "[", 
       RowBox[{"{", 
        RowBox[{"4", ",", "4", ",", "0"}], "}"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plane", "=", 
   RowBox[{"ParametricPlot3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", 
       RowBox[{"-", "2"}], ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"v", ",", 
       RowBox[{"-", "2"}], ",", "6"}], "}"}], ",", 
     RowBox[{"PlotPoints", "\[Rule]", "40"}], ",", 
     RowBox[{"MaxRecursion", "\[Rule]", "0"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->342222134],

Cell["Directional light: ", "ExampleText",
 CellID->822725943],

Cell[BoxData[
 RowBox[{
  RowBox[{"light", "=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Glow", "[", "Yellow", "]"}], ",", 
       RowBox[{"EdgeForm", "[", "Gray", "]"}], ",", 
       RowBox[{"Opacity", "[", ".2", "]"}], ",", 
       RowBox[{"Cuboid", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "2"}], ",", 
            RowBox[{"-", "2"}], ",", 
            RowBox[{"-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"6", ",", "6", ",", "3"}], "}"}]}], "}"}], "]"}]}], "}"}], 
     ",", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"\"\<Directional\>\"", ",", "Yellow", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2", ",", "10"}], "}"}]}], "}"}], "}"}]}]}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->50141285],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"light", ",", "obj", ",", "plane", ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->330535457],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->204390549]
}, Open  ]],

Cell["Point light: ", "ExampleText",
 CellID->387432558],

Cell[BoxData[
 RowBox[{
  RowBox[{"light", "=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"PointSize", "\[Rule]", ".05"}], ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2", ",", "2"}], "}"}], "]"}], ",", 
       RowBox[{"Glow", "[", "Yellow", "]"}], ",", 
       RowBox[{"Opacity", "[", ".3", "]"}], ",", 
       RowBox[{"Sphere", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2", ",", "2", ",", "2"}], "}"}], ",", "3"}], "]"}]}], 
      "}"}], ",", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"\"\<Point\>\"", ",", "Yellow", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2", ",", "2"}], "}"}]}], "}"}], "}"}]}]}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->331856549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"light", ",", "obj", ",", "plane", ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->667003792],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 176},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->324951543]
}, Open  ]],

Cell["Spotlight: ", "ExampleText",
 CellID->80517654],

Cell[BoxData[{
 RowBox[{
  RowBox[{"cone", "=", 
   RowBox[{"ParametricPlot3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"d", "/", 
          RowBox[{"Tan", "[", 
           RowBox[{"Pi", "/", "3"}], "]"}]}], 
         RowBox[{"Cos", "[", "t", "]"}]}], "+", "2"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"d", "/", " ", 
          RowBox[{"Tan", "[", 
           RowBox[{"Pi", "/", "3"}], "]"}]}], 
         RowBox[{"Sin", "[", "t", "]"}]}], "+", "2"}], ",", 
       RowBox[{"6", "-", "d"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "0", ",", "7"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"Glow", "[", "Yellow", "]"}], ",", 
        RowBox[{"Opacity", "[", ".3", "]"}]}], "]"}]}], ",", 
     RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"light", "=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"PointSize", "\[Rule]", "0.05"}], ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2", ",", "6"}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"\"\<Spot\>\"", ",", "Yellow", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"2", ",", "2", ",", "6"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", "2", ",", "0"}], "}"}]}], "}"}], ",", 
         RowBox[{"Pi", "/", "6"}]}], "}"}], "}"}]}]}], "]"}]}], 
  ";"}]}], "Input",
 CellLabel->"In[6]:=",
 CellID->384749257],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"light", ",", "cone", ",", "obj", ",", "plane", ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->319180139],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 185},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->121373633]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->577625350],

Cell["Different light instruments at the corner points: ", "ExampleText",
 CellID->138522091],

Cell[BoxData[
 RowBox[{
  RowBox[{"lights", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PointSize", "[", "Large", "]"}], ",", "Yellow", ",", 
     RowBox[{"Point", "[", 
      RowBox[{"Tuples", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "3"}], "]"}], "]"}]}], 
    "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->50473755],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"lights", ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\"\<Directional\>\"", ",", 
         RowBox[{"Hue", "[", 
          RowBox[{"RandomReal", "[", "]"}], "]"}], ",", "#"}], "}"}], "&"}], "/@",
       
      RowBox[{"Tuples", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "3"}], "]"}]}], 
     ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->111872418],

Cell[BoxData[
 Graphics3DBox[{
   {RGBColor[1, 1, 0], PointSize[Large], 
    Point3DBox[{{-1, -1, -1}, {-1, -1, 1}, {-1, 1, -1}, {-1, 1, 1}, {
     1, -1, -1}, {1, -1, 1}, {1, 1, -1}, {1, 1, 1}}]}, SphereBox[{0, 0, 0}]},
  Lighting->{{"Directional", 
     Hue[0.9643737027089088], {-1, -1, -1}}, {"Directional", 
     Hue[0.49020205074290235`], {-1, -1, 1}}, {"Directional", 
     Hue[0.5207402733791318], {-1, 1, -1}}, {"Directional", 
     Hue[0.7905930140471087], {-1, 1, 1}}, {"Directional", 
     Hue[0.13858617571822096`], {1, -1, -1}}, {"Directional", 
     Hue[0.7799335863473347], {1, -1, 1}}, {"Directional", 
     Hue[0.7252729435935927], {1, 1, -1}}, {"Directional", 
     Hue[0.8831375706672042], {1, 1, 1}}}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->483725962,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"lights", ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\"\<Point\>\"", ",", 
         RowBox[{"Hue", "[", 
          RowBox[{"RandomReal", "[", "]"}], "]"}], ",", "#"}], "}"}], "&"}], "/@",
       
      RowBox[{"Tuples", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "3"}], "]"}]}], 
     ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->14879176],

Cell[BoxData[
 Graphics3DBox[{
   {RGBColor[1, 1, 0], PointSize[Large], 
    Point3DBox[{{-1, -1, -1}, {-1, -1, 1}, {-1, 1, -1}, {-1, 1, 1}, {
     1, -1, -1}, {1, -1, 1}, {1, 1, -1}, {1, 1, 1}}]}, SphereBox[{0, 0, 0}]},
  Lighting->{{"Point", 
     Hue[0.7089004429674661], {-1, -1, -1}}, {"Point", 
     Hue[0.8509633146526825], {-1, -1, 1}}, {"Point", 
     Hue[0.03449402702197246], {-1, 1, -1}}, {"Point", 
     Hue[0.437965858846032], {-1, 1, 1}}, {"Point", 
     Hue[0.2806831302151531], {1, -1, -1}}, {"Point", 
     Hue[0.19769509046033207`], {1, -1, 1}}, {"Point", 
     Hue[0.5923043842270264], {1, 1, -1}}, {"Point", 
     Hue[0.8291521139920488], {1, 1, 1}}}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->392036475,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"lights", ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\"\<Spot\>\"", ",", 
         RowBox[{"Hue", "[", 
          RowBox[{"RandomReal", "[", "]"}], "]"}], ",", "#", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Pi", "/", "3"}], ",", "8"}], "}"}]}], "}"}], "&"}], "/@", 
      
      RowBox[{"Tuples", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "3"}], "]"}]}], 
     ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->3156017],

Cell[BoxData[
 Graphics3DBox[{
   {RGBColor[1, 1, 0], PointSize[Large], 
    Point3DBox[{{-1, -1, -1}, {-1, -1, 1}, {-1, 1, -1}, {-1, 1, 1}, {
     1, -1, -1}, {1, -1, 1}, {1, 1, -1}, {1, 1, 1}}]}, SphereBox[{0, 0, 0}]},
  Lighting->NCache[{{"Spot", 
      Hue[0.8880998101458653], {-1, -1, -1}, {Rational[1, 3] Pi, 8}}, {
     "Spot", 
      Hue[0.17094577784649645`], {-1, -1, 1}, {Rational[1, 3] Pi, 8}}, {
     "Spot", 
      Hue[0.7673940040158278], {-1, 1, -1}, {Rational[1, 3] Pi, 8}}, {
     "Spot", 
      Hue[0.8988621403336212], {-1, 1, 1}, {Rational[1, 3] Pi, 8}}, {"Spot", 
      Hue[0.40799250724703895`], {1, -1, -1}, {Rational[1, 3] Pi, 8}}, {
     "Spot", 
      Hue[0.7666010880217373], {1, -1, 1}, {Rational[1, 3] Pi, 8}}, {"Spot", 
      Hue[0.5545376432526052], {1, 1, -1}, {Rational[1, 3] Pi, 8}}, {"Spot", 
      Hue[0.546563238997289], {1, 1, 1}, {Rational[1, 3] Pi, 8}}}, {{"Spot", 
      Hue[0.8880998101458653], {-1, -1, -1}, {1.0471975511965976`, 8}}, {
     "Spot", 
      Hue[0.17094577784649645`], {-1, -1, 1}, {1.0471975511965976`, 8}}, {
     "Spot", 
      Hue[0.7673940040158278], {-1, 1, -1}, {1.0471975511965976`, 8}}, {
     "Spot", 
      Hue[0.8988621403336212], {-1, 1, 1}, {1.0471975511965976`, 8}}, {
     "Spot", 
      Hue[0.40799250724703895`], {1, -1, -1}, {1.0471975511965976`, 8}}, {
     "Spot", 
      Hue[0.7666010880217373], {1, -1, 1}, {1.0471975511965976`, 8}}, {
     "Spot", 
      Hue[0.5545376432526052], {1, 1, -1}, {1.0471975511965976`, 8}}, {
     "Spot", 
      Hue[0.546563238997289], {1, 1, 1}, {
      1.0471975511965976`, 8}}}]]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[4]=",
 CellID->783025540,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->274108943],

Cell["Build a scene with multiple objects and light sources:", "ExampleText",
 CellID->221086847],

Cell[BoxData[{
 RowBox[{
  RowBox[{"col", "=", 
   RowBox[{"{", 
    RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"objs", "=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Specularity", "[", 
       RowBox[{"White", ",", "2"}], "]"}], ",", 
      RowBox[{"EdgeForm", "[", "]"}], ",", 
      RowBox[{"Cylinder", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2", ",", "2", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2", ",", "4"}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"Cylinder", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"6", ",", "2", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6", ",", "2", ",", "4"}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"Cylinder", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"10", ",", "2", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"10", ",", "2", ",", "4"}], "}"}]}], "}"}], "]"}]}], "}"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"walls", "=", 
   RowBox[{"ParametricPlot3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"u", ",", 
         RowBox[{"v", "-", "2"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "4", ",", 
         RowBox[{"2", "v"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", 
       RowBox[{"-", "2"}], ",", "14"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"v", ",", "0", ",", "6"}], "}"}], ",", 
     RowBox[{"PlotPoints", "\[Rule]", "15"}], ",", 
     RowBox[{"MaxRecursion", "\[Rule]", "0"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Specularity", "[", 
       RowBox[{"White", ",", "2"}], "]"}]}], ",", 
     RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"srcs", "[", "pos_", "]"}], ":=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"MapThread", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Lighting", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"\"\<Directional\>\"", ",", "#1", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", 
                 RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], 
           "}"}]}], ",", 
         RowBox[{"Sphere", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"#2", ",", "0", ",", "8"}], "}"}], ",", ".3"}], "]"}]}], 
        "}"}], "&"}], ",", 
      RowBox[{"{", 
       RowBox[{"col", ",", "pos"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lights", "[", "pos_", "]"}], ":=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<Ambient\>\"", ",", 
       RowBox[{"GrayLevel", "[", ".1", "]"}]}], "}"}], ",", 
     RowBox[{"MapThread", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"\"\<Spot\>\"", ",", "#1", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"#2", ",", "0", ",", "8"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"#2", ",", "3", ",", "0"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Pi", "/", "2"}], ",", "20"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"\"\<Point\>\"", ",", "#1", ",", 
            RowBox[{"{", 
             RowBox[{"#2", ",", "0", ",", "8"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "8", ",", "0"}], "}"}]}], "}"}]}], "}"}], 
        "&"}], ",", 
       RowBox[{"{", 
        RowBox[{"col", ",", "pos"}], "}"}]}], "]"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->28388859],

Cell["Animate the spotlights:", "ExampleText",
 CellID->143472439],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"rx", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "6"}], 
          RowBox[{"Cos", "[", "t", "]"}]}], "+", "6"}]}], ",", 
       RowBox[{"gx", "=", 
        RowBox[{
         RowBox[{"6", 
          RowBox[{"Sin", "[", "t", "]"}]}], "+", "6"}]}], ",", 
       RowBox[{"bx", "=", 
        RowBox[{
         RowBox[{"6", 
          RowBox[{"Cos", "[", "t", "]"}]}], "+", "6"}]}]}], "}"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{"objs", ",", "walls", ",", 
       RowBox[{"srcs", "[", 
        RowBox[{"rx", ",", "gx", ",", "bx"}], "]"}], ",", 
       RowBox[{"Lighting", "\[Rule]", 
        RowBox[{"lights", "[", 
         RowBox[{"rx", ",", "gx", ",", "bx"}], "]"}]}], ",", 
       RowBox[{"Background", "\[Rule]", "Black"}], ",", 
       RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "300"}]}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"SaveDefinitions", "\[Rule]", "True"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->752895372],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`t$$], 0, 2 Pi}}, Typeset`size$$ = {
    300., {141., 146.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = False, $CellContext`t$439$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$439$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      With[{$CellContext`rx = (-6) Cos[$CellContext`t$$] + 6, $CellContext`gx = 
         6 Sin[$CellContext`t$$] + 6, $CellContext`bx = 
         6 Cos[$CellContext`t$$] + 6}, 
        Show[$CellContext`objs, $CellContext`walls, 
         $CellContext`srcs[$CellContext`rx, $CellContext`gx, $CellContext`bx],
          Lighting -> $CellContext`lights[$CellContext`rx, $CellContext`gx, \
$CellContext`bx], Background -> Black, Boxed -> False, ImageSize -> 300]], 
      "Specifications" :> {{$CellContext`t$$, 0, 2 Pi, AnimationRunning -> 
         False, AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{346., {178., 183.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`objs = Graphics3D[{
          Specularity[
           GrayLevel[1], 2], 
          EdgeForm[None], 
          Cylinder[{{2, 2, 0}, {2, 2, 4}}], 
          Cylinder[{{6, 2, 0}, {6, 2, 4}}], 
          Cylinder[{{10, 2, 0}, {10, 2, 4}}]}], $CellContext`walls = 
       Graphics3D[
         GraphicsComplex[CompressedData["
1:eJx12D2IXFUYgOE1ahHWv+AFVzPKZL1xd8lgYRQhhbuFyo4Igo1VIAQTLDLa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          "], {{{
             EdgeForm[], 
             Specularity[
              GrayLevel[1], 2], 
             GraphicsGroup[{
               Polygon[CompressedData["
1:eJwBqQRW+yFib1JiAgAAAIgBAAADAAAAEQEC4dHSEgIDEwMEGgoLFAQFFgYH
FQUGGAgJGQkKFwcIGwsMJRUWHg4PIBARIRESHAwNHQ0OJBQVIhITJhYXIxMU
JxcYd2doKBgZKxscLBwdLR0eNSUmLx8gMSEiMCAhMyMkNCQlNiYnNycoQDAx
OiorOyssKhobOSkqOCgpPCwtQTEyPi4vPy8wQjIzMiIjQzM0RTU2Rzc4SDg5
STk6UEBBUUFCTT0+Sjo7Tz9ASzs8Tj4/UkJDWkpLVERFVUVGVkZHXU1OU0NE
WUlKV0dIXExNWEhJXk5PX09QYFBRZFRVYVFSYlJTY1NUZVVWaVlaZlZXZ1dY
aFhZa1tcbFxdbV1eb19gcGBhcWFibl5fcmJjdGRldWVmdmZnc2NkRDQ14NDR
KRkaRjY3rJydfW1uhHR1hXV2e2tsf29wfm5vg3N0gHBxgnJzhnZ3kICBinp7
i3t8q5ucj3+AiXl6jHx9h3d4jX1+jn5/gXFykYGCkoKDloaHn4+Qno6Pqpqb
lYWGmIiJmYmKnIyNm4uMoJCRqZmak4OEpJSVlISFfGxto5OUopKToZGSp5eY
qJiZpZWWxbW2eGhprZ2e0MDBsKChsaGiuKipuqqrr5+gsqKjuamqs6OktKSl
t6eoxra3w7O0va2uvq6v38/QwrKzvKytv6+wu6uswLCxwbGytqanx7e4yLi5
yrq7y7u8zLy91MTFzb2+z7/Azr6/0cHC0sLD1cXG1sbH3s7P2cnK2srLybm6
2MjJ18fI28vMempr3MzN3c3Orp6faHh3AREQhZWUAxMSBBQTBRUUCxsaDBwb
CBgXBhYVChoZBxcWCRkYDR0cFiYlECAfESEgEiIhGCgnDh4dFSUkEyMiFycm
FCQjGSkoGiopGysqIDAvHCwrHS0sHy8uITEwJTU0IjIxIzMyJDQzJjY1Jzc2
KDg3Kjo5Kzs6LDw7KTk4Lj49MEA/MUFAMkJBLz8+M0NCNERDNUVENkZFN0dG
OEhHOUlIQFBPQVFQPU1MOkpJP09OO0tKPk5NQlJRSlpZRFRTRVVURlZVTV1c
Q1NSSVlYR1dWTFxbSFhXTl5dT19eUGBfVGRjUWFgUmJhU2NiVWVkWWloVmZl
V2dmWGhnW2tqXGxrXW1sX29uYHBvYXFwXm5tYnJxZHRzZXV0ZnZ1Y3NyZ3d2
anp5a3t6bHx7cIB/bX18bn59b39+cYGAdYWEcoKBc4OCdISDg5OSdoaFeYmI
eoqJe4uKfIyLd4eGfo6Nf4+OgJCPgZGQgpKRAhIRhJSThpaVi5uaiJiXiZmY
ipqZjJybkKCfjZ2cjp6dj5+ekaGgkqKhk6OilaWkl6emmKinlKSjmamom6uq
nKyrna2smqqpfY2Mnq6tn6+uoLCvrLy7orKxo7OypLSzpra1p7e2qLi3qbm4
qrq5q7u6rb28uMjHr7++sMC/scHArr69ssLBtcXEtsbFt8fGs8PCucnInY2O
usrJzNzbwNDPv8/OvMzLvc3MwdHQxNTTxdXUobGwwtLRvs7NxtbVx9fWydnY
ytrZy9vazd3cz9/ezt7dyNjX0ODf0eHgu8vKmoqLJo8Jaw==
                "]]}]}, {
             EdgeForm[], 
             Specularity[
              GrayLevel[1], 2], 
             GraphicsGroup[{
               Polygon[CompressedData["
1:eJxNl/17j2UYxp97hlqrsEW0sgljUiI2IjLTFpNGJTWtoVXLJi+rleVlIgs1
K2bJLHmJtaE3lVId/SWlVCqlZV5SnefxfH7ww4fruO7r5Tzv5+v7fGWUVhZV
JERR9K1IFC+GKFohXhV14rA4Ir4WX4nvVXNC/CXOiFPiV3FRXCD+TfxD7gfx
o/hbdBCfFGfJnaCmg5k/i1/EeXGO+BSznfuJGp91sut3cYmdZ8l3k9au4rTi
P8R/4l/xJ7pD8B9R1EukiAEiI8SaPMO9iSGefZreS2i01i46SwjxLOcce2Yn
2rqHWEMHPj3LPSfx0Mmec/i6IsQ95/F6ZYhzEXN7iGtD7NE6khVfFeLY2q4O
ce4i9+CzpBCf2fs1Ia7piq7rRCqzrb0nO7rgO4W7SaQnlVw3dPZmhjVa6/Wi
Dxo9p7+4iTPr6EtNErr7kbvA5ySJ2mR0pokbqE0m7seZvdxITQ+0p7OzJ7oz
yHVHYx80p+DlZp55Ap570ZuKr4HUjBHZYqrIQ7N1DBVDmOnZg8UgYvvMJJeO
lhHiNs760puJ5nTObmW2vWaxIw2vt4hh3Gl/aodTm8ZZFrvs63Z2DiU/VuTg
yd5GiZHE1n0HuUHoHk1uAD0jmTkY3WOoGcKOHO4pk1w2NVloG4eGYXi5k9xw
vEwQ47kH654o7hL5okDMEQ+hyXuniFw0WdvdYhKxfUwmN45d9zJnFDNyqRlL
TQG7RqM7jx3ZeLsnxJ+BHHryyY1H+3Qxjdi6C8lNYdZsMQtf1nmfmEFsnTPJ
jcDTpMvuYCK1hdRa9/30TMZLEbk8dD7AzqnofJBcLppm0ePPem+e+0Bq87lr
93wXxd/5Z/juLOAuH+aZ+F1RIzaG+J0xHZ2PikfQ4L0LxHxiz11Ibga+54li
Yvt6jFwhNcXMLEJ7qXiceDazS7mDIs5K2GUvT7CzhLPFolLMRefT4ili7ykn
Nx+dS8USdJXQW8Fs30MZO4rRvUg8w6xi4nJ2W+ezaJjHzAp6ZuKhhHwpGpbQ
M4e7f5KdZcTPiSo8WHe1eJ6d3u33+gvo9t6V4iX2VhLX4KGMWcuZVU5vNRor
qF3B7EXE3rGMvrWiFs3WvlqsYoZnbRCvcOa7XUPNUmbUklvAc1vGWRVe14mX
2VVFvBbP1cxezy7rqmPnQjwuZ+ZiNK7iTmq4i00h/kwfCvFvIP/2OU6Na18T
m8Uu0UJdO7qto0Fsoda+XqdnNb7qyVmX/900ie2c1dJbj+Y6zhqZba9vsGM9
XreJrcQbqN3GbPt4ix0b8baDXAOzdot38GSdO8XbxNbZTK4RLfvFPmZtpnYH
tfXcSzPxFu5oF7veFO+ycys694o91DagpQWv6+hxr98Vfkf4e3ECvY1o2cuz
W4mmTWi2jjbxPp6t86A4QGztreT2MOcj8SFnO+ltRbO1fxDi38XN+GpnRwva
/Zk5RLyb2sPMttaP2bGPu/yEXBuzvhRfiPfQ+ak4Smydn5FrwtMBavfz91Fm
HkT35/S04uUYuXZ0Hmen32H+Dvf34Fxq29ByjGffdNmuI9zFNyH+P8L/v41U
aA==
                "]]}]}, {}, {}, {}}, {{}, {}}}, 
          VertexNormals -> CompressedData["
1:eJztylENgCAARdEnJiGJHYjg5rcR2UxEBBJQQM79PLv1fttTknxHcmbVuDjn
nHPOOeecc84553wPH33xcc4555xzzjnnnHPO+W98AlQoh64=
           "]], {
         PlotRange -> {{-2., 14.}, {-1.9999995714285714`, 4.}, {0., 12.}}, 
          PlotRangePadding -> {
            Scaled[0.02], 
            Scaled[0.02], 
            Scaled[0.02]}}], $CellContext`srcs[
         Pattern[$CellContext`rx, 
          Blank[]], 
         Pattern[$CellContext`gx, 
          Blank[]], 
         Pattern[$CellContext`bx, 
          Blank[]]] := Graphics3D[{
          PointSize[0.02], 
          Lighting -> {{"Directional", Red, {{0, -1, 0}, {0, 0, 0}}}}, 
          Sphere[{$CellContext`rx, 0, 8}, 0.3], 
          Lighting -> {{"Directional", Green, {{0, -1, 0}, {0, 0, 0}}}}, 
          Sphere[{$CellContext`gx, 0, 8}, 0.3], 
          Lighting -> {{"Directional", Blue, {{0, -1, 0}, {0, 0, 0}}}}, 
          Sphere[{$CellContext`bx, 0, 8}, 0.3]}], $CellContext`srcs[
         Pattern[$CellContext`pos, 
          Blank[]]] := Graphics3D[
         MapThread[{
          Lighting -> {{"Directional", #, {{0, -1, 0}, {0, 0, 0}}}}, 
           
           Sphere[{#2, 0, 8}, 
            0.3]}& , {$CellContext`col, $CellContext`pos}]], $CellContext`col = \
{
         RGBColor[1, 0, 0], 
         RGBColor[0, 1, 0], 
         RGBColor[0, 0, 1]}, $CellContext`lights[
         Pattern[$CellContext`rx, 
          Blank[]], 
         Pattern[$CellContext`gx, 
          Blank[]], 
         Pattern[$CellContext`bx, 
          Blank[]]] := {{"Ambient", 
          GrayLevel[0.1]}, {
         "Spot", Red, {{$CellContext`rx, 0, 8}, {$CellContext`rx, 3, 0}}, {
          Pi/2, 20}}, {
         "Spot", Green, {{$CellContext`gx, 0, 8}, {$CellContext`gx, 3, 0}}, {
          Pi/2, 20}}, {
         "Spot", Blue, {{$CellContext`bx, 0, 8}, {$CellContext`bx, 3, 0}}, {
          Pi/2, 20}}, {"Point", Red, {$CellContext`rx, 0, 8}, {0, 8, 0}}, {
         "Point", Green, {$CellContext`gx, 0, 8}, {0, 8, 0}}, {
         "Point", Blue, {$CellContext`bx, 0, 8}, {0, 8, 
          0}}}, $CellContext`lights[
         Pattern[$CellContext`pos, 
          Blank[]]] := Join[{"Ambient", 
          GrayLevel[0.1]}, 
         MapThread[{{"Spot", #, {{#2, 0, 8}, {#2, 3, 0}}, {Pi/2, 20}}, {
           "Point", #, {#2, 0, 8}, {0, 8, 
            0}}}& , {$CellContext`col, $CellContext`pos}]]}; 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{350, 363},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->125524571]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6441],

Cell["Surface color and lighting interact with each other:", "ExampleText",
 CellID->389573586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Yellow", ",", 
       RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"\"\<Point\>\"", ",", "White", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], "}"}]}]}], "]"}],
    ",", "\[IndentingNewLine]", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"White", ",", 
       RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"\"\<Point\>\"", ",", "Cyan", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], "}"}]}]}], "]"}],
    ",", "\[IndentingNewLine]", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Yellow", ",", 
       RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"\"\<Point\>\"", ",", "Cyan", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], "}"}]}]}], 
    "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->258495820],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {RGBColor[1, 1, 0], SphereBox[{0, 0, 0}]},
    Lighting->{{"Point", 
       GrayLevel[1], {0, 0, 3}}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {GrayLevel[1], SphereBox[{0, 0, 0}]},
    Lighting->{{"Point", 
       RGBColor[0, 1, 1], {0, 0, 3}}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 1, 0], SphereBox[{0, 0, 0}]},
    Lighting->{{"Point", 
       RGBColor[0, 1, 1], {0, 0, 3}}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->230779169]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->126218712],

Cell["\<\
Diffuse object and lighting colors can be exchanged and produce the same \
effect: \
\>", "ExampleText",
 CellID->23327009],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"White", ",", 
       RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"\"\<Point\>\"", ",", "Red", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], "}"}]}]}], "]"}],
    ",", "\[IndentingNewLine]", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"\"\<Point\>\"", ",", "White", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], "}"}]}]}], 
    "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->183827371],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {GrayLevel[1], SphereBox[{0, 0, 0}]},
    Lighting->{{"Point", 
       RGBColor[1, 0, 0], {0, 0, 3}}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0, 0], SphereBox[{0, 0, 0}]},
    Lighting->{{"Point", 
       GrayLevel[1], {0, 0, 3}}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{230, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1952459]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15187708],

Cell["\<\
Specular object and lighting colors can be exchanged and produce the same \
effect: \
\>", "ExampleText",
 CellID->199005357],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"White", ",", 
       RowBox[{"Specularity", "[", 
        RowBox[{"White", ",", "20"}], "]"}], ",", 
       RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"\"\<Point\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"White", ",", 
           RowBox[{"Specularity", "[", "Red", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], "}"}]}]}], "]"}],
    ",", "\[IndentingNewLine]", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"White", ",", 
       RowBox[{"Specularity", "[", 
        RowBox[{"Red", ",", "20"}], "]"}], ",", 
       RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"\"\<Point\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"White", ",", 
           RowBox[{"Specularity", "[", "White", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], "}"}]}]}], 
    "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->610093354],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {GrayLevel[1], Specularity[
      GrayLevel[1], 20], SphereBox[{0, 0, 0}]},
    Lighting->{{"Point", {
        GrayLevel[1], 
        Specularity[
         RGBColor[1, 0, 0]]}, {0, 0, 3}}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {GrayLevel[1], Specularity[
      RGBColor[1, 0, 0], 20], SphereBox[{0, 0, 0}]},
    Lighting->{{"Point", {
        GrayLevel[1], 
        Specularity[
         GrayLevel[1]]}, {0, 0, 3}}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{230, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->60168771]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->418592296],

Cell["Specularity gives a mirror-like reflection:", "ExampleText",
 CellID->223786153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Sphere", "[", "]"}], ",", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"\"\<Point\>\"", ",", "Yellow", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], "}"}]}]}], "]"}],
    ",", "\[IndentingNewLine]", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Specularity", "[", 
        RowBox[{"White", ",", "40"}], "]"}], ",", 
       RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"\"\<Point\>\"", ",", "Yellow", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], "}"}]}]}], 
    "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->80548928],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[SphereBox[{0, 0, 0}],
    Lighting->{{"Point", 
       RGBColor[1, 1, 0], {0, 0, 3}}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {Specularity[
      GrayLevel[1], 40], SphereBox[{0, 0, 0}]},
    Lighting->{{"Point", 
       RGBColor[1, 1, 0], {0, 0, 3}}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{230, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->144186445]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->201398601],

Cell["\<\
The final color is a linear combination of all the surface colors as well as \
lighting:\
\>", "ExampleText",
 CellID->165304600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Lighter", "[", 
      RowBox[{"Red", ",", ".5"}], "]"}], ",", 
     RowBox[{"Glow", "[", 
      RowBox[{"Darker", "[", 
       RowBox[{"Blue", ",", ".8"}], "]"}], "]"}], ",", 
     RowBox[{"Specularity", "[", 
      RowBox[{"Yellow", ",", "30"}], "]"}], ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"\"\<Point\>\"", ",", "LightGreen", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->192569090],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1., 0.5, 0.5], Glow[
    RGBColor[0., 0., 0.19999999999999996`]], Specularity[
    RGBColor[1, 1, 0], 30], SphereBox[{0, 0, 0}]},
  Lighting->{{"Point", 
     RGBColor[0.88, 1, 0.88], {0, 0, 3}}}]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->7174037,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->517338662],

Cell["Lighting follows the additive color model:", "ExampleText",
 CellID->278655013],

Cell[BoxData[{
 RowBox[{
  RowBox[{"lights", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<Spot\>\"", ",", "Red", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"3", ",", "3", ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "3", ",", "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"Pi", "/", "8"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Spot\>\"", ",", "Green", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"7", ",", "3", ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"7", ",", "3", ",", "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"Pi", "/", "8"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Spot\>\"", ",", "Blue", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"5", ",", "6", ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "6", ",", "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"Pi", "/", "8"}]}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plane", "=", 
   RowBox[{"ParametricPlot3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"v", ",", "0", ",", "9"}], "}"}], ",", 
     RowBox[{"PlotPoints", "\[Rule]", "100"}], ",", 
     RowBox[{"MaxRecursion", "\[Rule]", "0"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->2484360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"plane", ",", 
   RowBox[{"Lighting", "\[Rule]", "lights"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->121235019],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->476536335]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->401732651],

Cell["\<\
Directional light yields rays parallel to the specified direction:\
\>", "ExampleText",
 CellID->521202639],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sphere", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"3", "i"}], ",", "0", ",", "0"}], "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "4"}], "}"}]}], "]"}], ",", 
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"\"\<Directional\>\"", ",", "White", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "5", ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], "}"}]}],
    ",", 
   RowBox[{"ViewPoint", "\[Rule]", "Top"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->193211893],

Cell[BoxData[
 Graphics3DBox[{SphereBox[{0, 0, 0}], SphereBox[{3, 0, 0}], 
   SphereBox[{6, 0, 0}], SphereBox[{9, 0, 0}], SphereBox[{12, 0, 0}]},
  Lighting->{{"Directional", 
     GrayLevel[1], {{0, 5, 4}, {0, 0, 0}}}},
  ViewPoint->Top]], "Output",
 ImageSize->{304, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[1]=",
 CellID->81225138,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30308250],

Cell["\<\
Point light yields rays toward all the directions from the position:\
\>", "ExampleText",
 CellID->306333793],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sphere", "[", "]"}], ",", 
     RowBox[{"Sphere", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
     RowBox[{"Sphere", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "3", ",", "0"}], "}"}], "]"}], ",", 
     RowBox[{"Sphere", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "3", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"\"\<Point\>\"", ",", "White", ",", 
       RowBox[{"{", 
        RowBox[{"1.5", ",", "1.5", ",", "1"}], "}"}]}], "}"}], "}"}]}], ",", 
   RowBox[{"ViewPoint", "\[Rule]", "Top"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->105561099],

Cell[BoxData[
 Graphics3DBox[{SphereBox[{0, 0, 0}], SphereBox[{3, 0, 0}], 
   SphereBox[{0, 3, 0}], SphereBox[{3, 3, 0}]},
  Lighting->{{"Point", 
     GrayLevel[1], {1.5, 1.5, 1}}},
  ViewPoint->Top]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->94260591,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20260061],

Cell["A spotlight emits conic rays toward the specified direction:", \
"ExampleText",
 CellID->2659772],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sphere", "[", "]"}], ",", 
     RowBox[{"Sphere", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
     RowBox[{"Sphere", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "3", ",", "0"}], "}"}], "]"}], ",", 
     RowBox[{"Sphere", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "3", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"\"\<Spot\>\"", ",", "White", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1.5", ",", "1.5", ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.5", ",", "1.5", ",", "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"Pi", "/", "6"}]}], "}"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->532488710],

Cell[BoxData[
 Graphics3DBox[{SphereBox[{0, 0, 0}], SphereBox[{3, 0, 0}], 
   SphereBox[{0, 3, 0}], SphereBox[{3, 3, 0}]},
  Lighting->NCache[{{"Spot", 
      GrayLevel[1], {{1.5, 1.5, 5}, {1.5, 1.5, 0}}, Rational[1, 6] Pi}}, {{
     "Spot", 
      GrayLevel[1], {{1.5, 1.5, 5}, {1.5, 1.5, 0}}, 
      0.5235987755982988}}]]], "Output",
 ImageSize->{184, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->649398670,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22636],

Cell["\<\
The default lighting may not be suitable for light surface colors:\
\>", "ExampleText",
 CellID->535908886],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"LightRed", ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->423603360],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 0.85, 0.85], SphereBox[{0, 0, 0}]},
  RotationAction->"Fit"]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->418230084,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
The neutral lighting can be used to reflect surface colors more naturally:\
\>", "ExampleText",
 CellID->70652144],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"LightRed", ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->528479615],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 0.85, 0.85], SphereBox[{