(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    172042,       4391]
NotebookOptionsPosition[    159097,       3943]
NotebookOutlinePosition[    160452,       3980]
CellTagsIndexPosition[    160365,       3975]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Three\[Hyphen]Dimensional Graphics Primitives" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ThreeDimensionalGraphicsPrimitives"], 
          "Three\[Hyphen]Dimensional Graphics Directives" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ThreeDimensionalGraphicsDirectives"], 
          "The Structure of Graphics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheStructureOfGraphics"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Three\[Hyphen]Dimensional Graphics Primitives\"\>", 
       2->"\<\"Three\[Hyphen]Dimensional Graphics Directives\"\>", 
       3->"\<\"The Structure of Graphics\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Arrow" :> Documentation`HelpLookup["paclet:ref/Arrow"], 
          "Polygon" :> Documentation`HelpLookup["paclet:ref/Polygon"], 
          "EdgeForm" :> Documentation`HelpLookup["paclet:ref/EdgeForm"], 
          "Thick" :> Documentation`HelpLookup["paclet:ref/Thick"], "Thin" :> 
          Documentation`HelpLookup["paclet:ref/Thin"], "ListLinePlot" :> 
          Documentation`HelpLookup["paclet:ref/ListLinePlot"], "Point" :> 
          Documentation`HelpLookup["paclet:ref/Point"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Arrow\"\>", 2->"\<\"Polygon\"\>", 
       3->"\<\"EdgeForm\"\>", 4->"\<\"Thick\"\>", 5->"\<\"Thin\"\>", 
       6->"\<\"ListLinePlot\"\>", 7->"\<\"Point\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Objects" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsObjects"], 
          "Precollege Education" :> 
          Documentation`HelpLookup["paclet:guide/PrecollegeEducation"], 
          "Symbolic Graphics Language" :> 
          Documentation`HelpLookup["paclet:guide/SymbolicGraphicsLanguage"], 
          "New in 6.0: Graphics Primitives & Directives" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Graphics Objects\"\>", 
       2->"\<\"Precollege Education\"\>", 
       3->"\<\"Symbolic Graphics Language\"\>", 
       4->"\<\"New in 6.0: Graphics Primitives & Directives\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Line", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Line",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Line"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["pt", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["pt", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a graphics primitive which represents a line joining \
a sequence of points. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Line",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Line"], "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["pt", "TI"], 
            StyleBox["11", "TR"]], ",", 
           SubscriptBox[
            StyleBox["pt", "TI"], 
            StyleBox["12", "TR"]], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["pt", "TI"], 
            StyleBox["21", "TR"]], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a collection of lines. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->28451]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Line",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Line"]], "InlineFormula"],
 " can be used in both ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " (two\[Hyphen] and three\[Hyphen]dimensional graphics). "
}], "Notes",
 CellID->25432],

Cell[TextData[{
 "The positions of points can be specified either in ordinary coordinates, as \
",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "}"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["z", "TI"]}], "}"}]], "InlineFormula"],
 ", or in scaled coordinates as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scaled"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scaled"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["z", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->25881],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Offset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Offset"]], "InlineFormula"],
 " can be used to specify coordinates in two dimensions. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->9575],

Cell["\<\
The line consists of a sequence of straight segments joining the specified \
points. \
\>", "Notes",
 CellID->12736],

Cell[TextData[{
 "Line thickness can be specified using ",
 Cell[BoxData[
  ButtonBox["Thickness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thickness"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["AbsoluteThickness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteThickness"]], "InlineFormula"],
 ", as well as ",
 Cell[BoxData[
  ButtonBox["Thick",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thick"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Thin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thin"]], "InlineFormula"],
 "."
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->2840],

Cell[TextData[{
 "Line dashing can be specified using ",
 Cell[BoxData[
  ButtonBox["Dashing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashing"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["AbsoluteDashing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteDashing"]], "InlineFormula"],
 ", as well as ",
 Cell[BoxData[
  ButtonBox["Dashed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashed"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Dotted",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dotted"]], "InlineFormula"],
 ", etc. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->4436],

Cell[TextData[{
 "Line shading or coloring can be specified using ",
 Cell[BoxData[
  ButtonBox["CMYKColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CMYKColor"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["GrayLevel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GrayLevel"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Hue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hue"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Opacity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opacity"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 ". "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->24458],

Cell[TextData[{
 "Individual coordinates and lists of coordinates in lines can be ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " objects. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->19227]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->516344809],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->131769752],

Cell["A line primitive:", "ExampleText",
 CellID->552131808],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Line", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "1"}], "}"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1973840],

Cell[BoxData[
 GraphicsBox[LineBox[{{1, 0}, {2, 1}, {3, 0}, {4, 1}}]]], "Output",
 ImageSize->{154, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->484197155]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Line", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "4", ",", "1"}], "}"}]}], "}"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->320913855],

Cell[BoxData[
 Graphics3DBox[
  Line3DBox[{{1, 1, -1}, {2, 2, 1}, {3, 3, -1}, {4, 4, 1}}]]], "Output",
 ImageSize->{104, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->16143279,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJylmNtuFDkQhp0+zGQOOQ2QhJAMgYUohE1gs4RwFOIGrvYVVopgJLhY7Yrl
9Vu77epyt/uzh+6ISJmZcv31l112uWz/cfX9y+Kvq+9fP10dfvx29c+Xr5/+
Pfzw97eyKV0xxnwu///cNeXv/8pf8v+5KApj3pef6WKxOBTpXfmZlFKi33el
9Y1islbrK5WGVrLq8rv8NHPRXqrNyEpZpa0AB6K/UOvpEv252q9bKa/16mNf
ME+VY8vrgf2ZQL4t6DNF3+iFfqz+b0GbQt4V9CPlvt2B3hH0kXLf6YV+oNxz
aDPI24K+589nJ/qucv8CbQ5ZoiBRt40PoR1AvinoPeU+7oXeUe4TaIeQZfak
P5b7FNpVyDNBz5T7SS/0pnKfQzuCLKvOrCn3M2jHkDcFPVHuy17oVeV+Ce0E
8oagB8r9phc6V/RbaKeQ12u0y1Kbf8a8Bm4tJrfspMGwd/Tn2bWy3vTwOW1s
g/wuzVV+ERsh47WcpWrqycKsy8DCdbABeRxlycHy/OdYdE7Jsgl5FGUZgOUC
eu7Nq1GWIViYTddgyeqZLhW/AzGLWQQ8qwGP1I6ygbWCtUSiEezj44DvV2+8
5ud485pXYyc76NBvbeK6DYY8yjuJ8h63R1FUe5MY6zpkrcyi7NMo+5EXESvb
vSlF2zX4vXxnbO9rz7lybcztVhWPyVoH61xZx2Dd0HbyiRywbES8JHpSqKOt
y2YCT5PWuK7riTlwq9XvBjeF12HhnfM6vW52eN1Sthy4dSfrSkt0rlg94l63
Ory6Gj4Ezo+RW5PcFeMeZx0eR62otT0mMs+NV+59/TyyfuXqcQKcGztzLXqm
NmG2w2NT65WXeeNWaR1rZWNcQ3/bEX/WgCvZ7t6ZP1K1Z1Xs9pAU4R63Dswg
0guX9z/2Jqf7rOpf9cc541xl6usGfPHsEZ+r1FtXrufh+TYc/Q7iyFNX6M2d
t7l38CzPfEsX7k7UeGOGh97cDks2esuDeM8RR45sRX21a0ssi6qTh7/2E0T7
HnxxXKEvt0dwxblbgV8LHiBqPPOH7G7dct+QkeT+SOz55Aj8vK+E/KnyM6cG
7UiVimNws5JEuBfuph1fzbbHjxDvOKttOABTnYUa2xMw8dYY9m8OxgzyY4yY
K9UxVg4X7k3FzxQwnEYYV8rflklHCh/ygrLklHiGEYdsrGf7nkXsPHsKxkHA
aKNuc8YyJSbsb90nHWEeMDCKfC95AoYsYODMHkB+CoY0YBjpKJZa6vhDS2bs
HuTffuDbBLsJ36HOYZ20rNeK+OuV3J7y2kr7XtmwvvFmITe4rLatfbHO80y/
zG5L+0j8hTeypne8P/Hed9ka/01oefaxPtIazR4wEjbWdoOrbifb2m+izhRV
3WR3oeV8nhTeeTeYXa6dI0VXr0juHY6o+4qq3t/2oWUuzBVdvXceQMvc21N0
9U47L8KX4kLXjEVVb89dL5YzRUut03rarjd8j7FoqS4y1uZG2aDGipL7eFVF
W2/R7iwp+WseetZ2rWWqlTUrUR+UkrwMGbPyP3GLXSo=\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->84855261],

Cell["Differently styled 2D lines:", "ExampleText",
 CellID->272687774],

Cell[BoxData[
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"Line", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"6", ",", "1"}], "}"}]}], "}"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->448259495],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Dashed", ",", "l"}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Pink", ",", "l"}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", "l"}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", "Dashed", ",", "Pink", ",", "l"}], "}"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->297059210],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Dashing[{Small, Small}], 
     LineBox[{{1, 0}, {2, 1}, {3, 0}, {4, 1}, {5, 0}, {6, 1}}]}], ",", 
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], 
     LineBox[{{1, 0}, {2, 1}, {3, 0}, {4, 1}, {5, 0}, {6, 1}}]}], ",", 
   GraphicsBox[
    {Thickness[Large], 
     LineBox[{{1, 0}, {2, 1}, {3, 0}, {4, 1}, {5, 0}, {6, 1}}]}], ",", 
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], Thickness[Large], Dashing[{Small, Small}], 
     LineBox[{{1, 0}, {2, 1}, {3, 0}, {4, 1}, {5, 0}, {6, 1}}]}]}], 
  "}"}]], "Output",
 ImageSize->{452, 26},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->175696362]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7987048],

Cell["Differently styled 3D lines: ", "ExampleText",
 CellID->95422291],

Cell[BoxData[
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"Line", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", 
        RowBox[{"-", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "3", ",", 
        RowBox[{"-", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "4", ",", "1"}], "}"}]}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->303391499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Dashed", ",", "l"}], "}"}], "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Pink", ",", "l"}], "}"}], "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", "l"}], "}"}], "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", "Dashed", ",", "Pink", ",", "l"}], "}"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->476177038],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {Dashing[{Small, Small}], 
     Line3DBox[{{1, 1, -1}, {2, 2, 1}, {3, 3, -1}, {4, 4, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJylmNtSE0EQhodNNiEGQghyFAIqKHJS8YDHsrzRK1/BKkqp0gtLC339Ld3u
6U12vxnctaSKJD39zz89Pd09hw/nv75cfDv/9fXT+c77y/MfX75++rnz7vtl
3tSacc59zv8/rrn89+/8l/5/zrLMubf5Z+vi4mJHpTf5Z5JLiX1va+srw7Qr
rS9M6ook6vw7/3Rj1Z5Zn55Iba/1gC3VP7Hec1foT63/QKR0orcxNhXzwDgW
SxbIzwTyuqJPDL3UCH1o4y9D24K8puh7xr1eg15V9B3jvtEIvWvcY2jbkFcU
fbO8nrXobeO+DW0KWb2gXpfGPWg7kK8resO49xuhV437ANouZF09tUe4j6Gd
hTxS9Mi47zdCD437FNoeZI06N2/cj6G9Bnmo6L5xnzVCzxr3c2j7kBcU3THu
V43QqaFfQzsHeTBBF1kq+efcS+DmY3KlnzY4WsfxSv0qWe8ajDk37fuX/H4W
myH9FbAwN7mCcRZmHVmfxtaGcXEFS+4Q3/S/LJlfU7IMIfeiLB2wPIGetXk2
ytIFC7OpGQuz6CHkUWzUgIX58gAy9w/1QBAfjM2D0gyzSFQ2Y9UZphMW85Zy
d8utU0+ugCGN8vajvFq52+VW6aKdLfK4O7aj7HNXsguoVfKMtP8D51/8ecvY
GZ/iZylIcT8wQsbGEqtSU9tRJQJbZIdLbL+feNCbFMRJr2J3HTNXdzniU3pL
DOhmpdNZ7ShDsDFjFo0tBW5QyBYtifme3oyPulgzarEG65ibeJq1Kz7CqGaE
Yi1u2PqVR2FFio+wATk1xj5GLubC/YGVXPldOQO31PDyTinwefD3rZ0nnnr+
IgMWwDh7xVpyHwwZV8CUZGFdWY2MKpB6e/XM3PYx5//o0+I0uATuesuXJ5ZO
rWeeDgyzWrBbX+Z5yF7YxdzlCbgLvag2geEeFo62YKMxjtPAf7xJkHvGuKu1
WUSt5JXYTOA93ju4g4fcRU6u2/dd+Lneuo71ZPbTz/tgrretZcyMcMbIPTCz
CkeYUefIKqfjQ7BwPp5VGvYKje1BR0DS3tCePdjSlCHT+JOR94A4gk/E+pn8
t/Q0y9FjEzZQf1TSF3telZH1noys5sdg7ASMkj2J5WPiQptPMMs0YOCq8dbP
02grYGCN34LMU3ESMPRsFuypN+K0nM/iBV9bmHfc+R5i5mW7XXAL5DvKKXon
ld7zWfz15ZHaO+ll9vo+3El4kirfY6a9eK7gWTXea9HsI/qptXsUbwA8i55V
5nwdWtZxsaQ1QXNkzl78K4Xan7VXzC6iTgzlb19r0HIND7LSCSFYUcbLHUP7
l4/i7YioW4byb0bc9Rj5Y0P7N7otaJlpG4b2b4vjLHzdzCxO2sWu6Ope2UaG
3lX0TWhZHQaG1p1H5yoWxO6AgtL6pq+D1ffT4mSmlaJSZyUi26bVG7Z6vZNL
+ibi3Mwfsu3uOQ==\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0.5], 
     Line3DBox[{{1, 1, -1}, {2, 2, 1}, {3, 3, -1}, {4, 4, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJylmG9PFEkQxofZ2WUXWJZlBfm3sJxiBMKJIuqdGuMbfeVXMCFmEn1x0aiv
+eaTu+nq6tmeXzfMXCABprqefqq6u7qquz9d/f6a/3P1+9uXq9nHn1c/vn77
8mv24fvPsqmzkCRJXv5+3krK73/LL/nNi6JIkvfl306e54civSv/pqWU6v+Z
tL5VKTOSAZf/y7/JgWj/VoZeVPtK+w6MlFmtBeyL/lJ7LxupW+mVYyqYC+VY
vQVzrjzjKGZPMH8qz71bMKfKs+mNxnymkLcFfayM29B2IG8J+pFy77ZCP1Tu
fWgzyPcFfajcM2i7kGVcsjaG+0Er9J5yH0Hbg7wh6B3lfgztImRZBfHeNJ60
Qm8o9xm0fcgTQU8U/aQVek09eQrtAPK6oFeV+zm0S5AlHpNl5X7RCj1Q7r+g
XYa8Juiecr9pQI8qtN/arpfERVbt7eL6mv1WIK8G/czP/+pX26Fl1+Q1sMOY
HMSw3bllf5VfxSzSo4ClA5aXd2OxTQHLKLYaAUsGFkbVGmSJsiBv9MByeTeW
wmZRsowhD6Isi2DhrlqH3I+y9MFycWcW8+nyTVo2sQpMYuMIGGXM3YpRvTu1
01e1Orc3opysEctRzmPbwWudzwYrWu9mXn/00EsNyHwLRik0Gkf0vxu1s9Jg
54GnNwbMKnTQ1s7SsMGSq5xVDOo4TLSY1BWfJ7JSP1XWJfg80nbis6iV1QYr
2/78W1htBY3K1R5mfmuRs7HWYHFD2TLgaHVRcaye7axyB41rY5jjhrDaURyr
StzquMHqUNmYEUZOzuVHYpOZO25xvcHioAijptA4SO0Aq7Eym3VaWWQt6dZm
bI5bKfw4nVtlPo9bncSseucAy83oXiqwE9UmK5G16eeczYg904Fx1S+824a3
17l6zRbSIsx8o4gXGcbpcsDt1uRMn1URVv5w3bheLvInsMVzSWjL7Wifjbli
yflTW7/7sMXzWGhrvQijynzytM9KbmJ/F2tGa2lgzeXaxQZr/kkodzdXzxKz
SWjJ7RZWT7EUxL2PmGGkN9kKcwR3j4ttnnf/gAWe8EML7kbB3CGj6fqjMafy
R5gt3mlCfher3FM9zNb19WNws5pEuMvPHfDW9k7p8QlYeR+0rKZheiOTrbUn
nt7MLf1bECYTvQdgYv08bfBJmdBK/1KwnEFm5FtW1vg9C42eIp+AkZnCMprR
pZy/cubp/5mnN+xxNrbu2qXA2fccXMyYloszwNcVjo8V2rL0i/jbzDl6c2Zt
b+4Qvgc9jbAslN+mt2XgHt65iaGYn4vqDMwzfMF6Bh/SgGFYxN++LtzqVE2S
waUPKx/vJM/tlLu+LpsFJwCe/Kt+tlPVb6w+En/pjW7uHW9zPGG9VDY7/nvQ
8mTkXjYtt3u5IsqsVObqu637wfm/vl8M2t6it6BlRTxWtH0X2VYPiDpSlH17
YiwyVg8Vbd/69qBl1tpXtH0tnaoHRO0oaiqoA2i5jzcVbV+s+d7J/epucUeC
PoQ2dt8yaLlHS+Wc3zvrc2JQkr3knbb+st1XvexCe2PuVAEtHhqtxKBUz16u
b31JsvAf4V1cJg==\
\>"]], ",", 
   Graphics3DBox[
    {Thickness[Large], 
     Line3DBox[{{1, 1, -1}, {2, 2, 1}, {3, 3, -1}, {4, 4, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydWNtO20AQ3cTOlZArFJKSkgCBci8FeqGtKvWhfeovVIqQJXioWlF+32q9
M7O2czxu3FoKeHbOnJndnZ1d79f5413wff54fzuffHmY/7y7v/01+fzjIWry
SsaYIPp92zTR++/ojX5BGIbGfIr+ekEQTEj6KJLxopeAHsOaD9HfciT6VrIQ
Bpht0t6IXU1Q3PpGpCbYPCPttdi0rOSzlgFj0l+KdSdH/0Lse1aqxHrxsUWY
M+FYS0VgX8sgDwl9LIxPCqEPhXsIWg/kTULvC/dT0PogbxB6T7ifFULvCHoC
2grI1C+aMdu4Uwg9Fu4ZaKsgrxN6JNwHoK2BTPNBI2O5jwqh14X7BLR1kAeE
Hgj3OWgbIPcJ3RXui0LotnBfL0FTZpoV4X4N2ibIXUI3hPumELoq3O9BuwJy
J0ZTq+HnH6z8xMqYd4BrgdwmO8ynsmK5qslsmax4OyKGa8z/2HqR7VstQuxB
NmLxnG57pY0RjmGGyVOYMHuKM3nAdAWYLshNlcmPYwqpZBZnwipUVZguAdMD
uZHL5AHTS8D0Qa6rTDWJCWv3KXU9UrCs7A06Xz2H71iJGBlruYyewmj3lcoS
xqrK2MhhPHAxUgrQw9RctTO8uIOtSN+xfZby5yv7ZiWXzVPYdl27DSyJ1B5e
ogbk9lXuVg73VCKshNnV0xWd3vdV6TuO9Tjkymt1LjfQzorIp8e9KnGhl6Gw
iJk8TcVfQ5C4L+v+2jn+3B7rqoybK5xVK+Jux54w97oSK1afnrC4GXEjALU7
ErDOe6qfXo4fNw814e+4+YzasLrlM3sKsxvxRppZMuJvNVT30pe4cP7caLuZ
SOcVesIdRPc0SHtSRzueecknzADcPfP9eCY5o3REduPWVJiLzfVamNQjWh2p
Sukyuya6tjJOupc0C52rfS49/ODsu/mwWW8Hsa/4wXNR1o9bb2WJOK+ae1Jd
cbzQQznjoQ/5gqdlty5s00jxgGfCrIdOmPr2UzxoNXdLGa3lnlqQOeiJLBZO
qlPFD56ks35chrrcacgcW5+7CiNWQse4uK96qSxJW1gy27anjJPaQ4M5ZcX1
9JgsjMG+EnEB3oC/bOPMXOB8XoCzRJy2YRwmFcfGeKRYY/aXMrMyDpMVZ/+f
KCxYPZkF64fLPrfLnRZmwn00zuPMeeVM4cQawpx0Do8aLRee+zQW3LOZBeN1
axn7rjFir5gRZ2REXTDu5MxB0i2MFmEpEi0Pc9VD/T7jPCeaRWtcsXiHosVQ
zrBgfRmBfBHPZXpPtH3k1dGSPqAdf5/wtOuecb/cUBjI88ItF3vFPR3PwZfQ
9yTersSLFldiUY594BfVAOTrlAX3CBHIkLVYk2g0pB+jMFbs/UWYnONNZhxx
nE8Fzd+am6DFU8ChoPkeYSjxImomKL7bwUzETHXfHXw7tgVa3DfGgub7xbFE
gKihoMaE2gatdi9n0VNCL7sh7Al6RuipRKCdqS3qkFC7RIRrpiUY+t6mvW0x
u+uipxs3/pIM+HbZttLdCH23WmK6vTGm9AdUkK1k\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0.5], Thickness[Large], Dashing[{Small, Small}], 
     Line3DBox[{{1, 1, -1}, {2, 2, 1}, {3, 3, -1}, {4, 4, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyVmFFvEzkQx7fZpKFp2qYpLaVt2sAR9SpKBRSOA+6ExAM83Vc4qUKR4AFx
Al7z0VecZzzeuD87zTZSkh37P/+xxzMer/+5+vl5+vXq55dPV+OP36/++/zl
04/xh2/fXVO5UhTF1H3/3S/c8y/3pN9pVVVF8d79ltPpdKzSO5NaIslDpZ/i
WHv/dr8t19ix/xNtfWM63UjH/ZrOn4btZXtfmm5fpHZtzz2MtP/StLdE6tT9
xnGkmGeG2b4Bc2F2djAvzvO+os+Nca8R+sy499FbQtb+4tS4D9HbhnxP0Y+M
e9QI/dC4x+jtQNZ5FSfG/RC9q5B3FT0y7kkj9IFxn6K3C/muoveN+/EStK6e
WpDGJ43QO8b9FL13IA8VPTDu543Qm8b9Er1rkDUyi76hX6G3B3mg6DUbyetG
6K5x/4XedciaR7pmgnYhOptZzxsg+5A3a806T53ubPa2uV5Z67lMms1ocSMn
J/GV09zMjSGJeuYj16EZCzPvj5yHuQIJC2VG0G1YnEN8U8IygNxbOCMhidsu
gdmGvLZwPC1lqnTzlbYXS8bkmejVboZp2ZjuZJmYAc8gDzOWUxZGNXeTZiyM
8DObJXGsUqtZtp5psyrJnlvW7T7DJdl3b8XKbJlErO1MbdRYSHKsfwObU9HI
9Z8w2KQ6MPcW2uBMpK6JmIvKofWtZhnp/+MqOqXAsviCK5AfJ2cTaqTMmsxh
9+ful2ceRCstjxzPXjU/1QmMO13H+llbyqy1LfMnsz/4NPh7w6xF5zpDMA/y
dgYL7GxW8/OW8MszdxXPSD9smwYZe8aoZzIdrZY298C8zvMO4X/yr0b+bZn/
xQwjlrt+3tp8lOHTttiUIaybLZ5BuOZ57iPT3jK2EIfZ2ryUbbea71DSHGcg
Y7YTWY5rGn3SWmjJJUe0n3ANdox/WIXdYPFsvI14tOHMKZo8Z4bV3MswM69T
5pA1pWnzpFlXwrbX8Z+DMF+PyqxQamnLLLFudqq0/p8Aw50hZe8bO6uMIFvm
ud9uzRri7775+BTRsZwh5F5Yd+bFaWbVuAaB9Xq8l9GazzV0SeoafBPrSspq
My0tyuT/9wbj80zSMAr+wdqeQ4MxHMYy99vE7F4AyYrkNZmPjyCfY93yLJoD
rpHajzM+YH57BrYeVvFZaN7+JMPI3dgzcqQHCxgvFjCuOFGYPFt4Tzv0Uwjr
5N2enHDLRJ/RewSZp9uUgRnDewi++bYShvV4DrCtHujEtUnm5fOHOxTvS54H
/Wv3QF6X1ese5Mvgz1jV7LKC8OR6mbXr5zqo8jdB8VufWPJonhZ4jnxlbB7N
XmpfR981iSgZSVmjOE7OXdZIlsefI+lFelmyRJzi39HCLQ1RZ4by7+sH6OX7
18TQ/k6EMcTofGBof6t0VKV3ifI4MpS/jztGL/e6UEtGimaly91nCfqBosc2
AqK2DTVRFG/UeLLdMPSZolkVubOsGVrvu/zOmmRY1zCa/37vnl4/b4X3Nr0j
0PokJHq7VBQr/wPeDlTP\
\>"]]}], "}"}]], "Output",
 ImageSize->{452, 96},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->907727]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23927],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Line Specification",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->125713211],

Cell["Single line segment:", "ExampleText",
 CellID->91146826],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Line", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->55162297],

Cell[BoxData[
 GraphicsBox[LineBox[{{0, 0}, {2, 1}}]]], "Output",
 ImageSize->{154, 78},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->123733240]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->313197051],

Cell["Multiple connected line segments:", "ExampleText",
 CellID->826845247],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Line", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "0"}], "}"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10146755],

Cell[BoxData[
 GraphicsBox[LineBox[{{0, 0}, {2, 1}, {4, 0}}]]], "Output",
 ImageSize->{154, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->97427600]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->113594254],

Cell["Multiple disconnected line segments:", "ExampleText",
 CellID->253837842],

Cell[BoxData[
 RowBox[{
  RowBox[{"s", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "0"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20699716],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Line", "[", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"s", "+", "1"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->660974692],

Cell[BoxData[
 GraphicsBox[
  LineBox[{{{0, 0}, {2, 1}, {4, 0}}, {{1, 1}, {3, 2}, {5, 1}}}]]], "Output",
 ImageSize->{154, 64},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->211647418]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Line Styling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->77444043],

Cell[TextData[{
 "Lines with different thickness:  ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->2840,
  ButtonNote->"2840"]
}], "ExampleText",
 CellID->258900324],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Thickness", "[", "i", "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->153708139],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Thickness[Tiny], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Thickness[Small], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Thickness[Medium], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Thickness[Large], LineBox[{{0, 0}, {2, 1}}]}]}], "}"}]], "Output",
 ImageSize->{452, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->257220805]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"t", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"{", 
      RowBox[{"Thin", ",", "Thick"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->706499252],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Thickness[Tiny], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Thickness[Large], LineBox[{{0, 0}, {2, 1}}]}]}], "}"}]], "Output",
 ImageSize->{230, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->387026841]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->717252622],

Cell["Thickness in scaled size:", "ExampleText",
 CellID->220038262],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Thickness", "[", "i", "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{".005", ",", ".05", ",", ".1"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->388303278],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Thickness[0.005], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Thickness[0.05], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Thickness[0.1], LineBox[{{0, 0}, {2, 1}}]}]}], "}"}]], "Output",
 ImageSize->{341, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->105043073]
}, Open  ]],

Cell["Thickness in printer's point:", "ExampleText",
 CellID->27522066],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"AbsoluteThickness", "[", "i", "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "5", ",", "10"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->165797838],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {AbsoluteThickness[1], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {AbsoluteThickness[5], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {AbsoluteThickness[10], LineBox[{{0, 0}, {2, 1}}]}]}], "}"}]], "Output",
 ImageSize->{341, 58},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->27434985]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->39829922],

Cell[TextData[{
 "Dashed lines: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->4436,
  ButtonNote->"4436"]
}], "ExampleText",
 CellID->696306419],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Dashing", "[", "i", "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->919899669],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Dashing[Tiny], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Dashing[Small], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Dashing[Medium], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Dashing[Large], LineBox[{{0, 0}, {2, 1}}]}]}], "}"}]], "Output",
 ImageSize->{452, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->398612044]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"d", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"d", ",", 
     RowBox[{"{", 
      RowBox[{"Dotted", ",", "Dashed", ",", "DotDashed"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->281025011],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Dashing[{0, Small}], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Dashing[{Small, Small}], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Dashing[{0, Small, Small, Small}], LineBox[{{0, 0}, {2, 1}}]}]}], 
  "}"}]], "Output",
 ImageSize->{341, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->196690892]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->395840683],

Cell[TextData[{
 "Colored lines: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->24458,
  ButtonNote->"24458"]
}], "ExampleText",
 CellID->171107226],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"c", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Green", ",", "Blue", ",", "Yellow"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->198130078],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[1, 0, 0], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {RGBColor[0, 1, 0], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {RGBColor[0, 0, 1], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {RGBColor[1, 1, 0], LineBox[{{0, 0}, {2, 1}}]}]}], "}"}]], "Output",
 ImageSize->{452, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->113204540]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Coordinate Specification",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->95542222],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " coordinates: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->25881,
  ButtonNote->"25881"]
}], "ExampleText",
 CellID->199674725],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Line", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Scaled", "[", 
       RowBox[{"{", 
        RowBox[{"0", ",", ".2"}], "}"}], "]"}], ",", 
      RowBox[{"Scaled", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", ".8"}], "}"}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->155645107],

Cell[BoxData[
 GraphicsBox[LineBox[{Scaled[{0, 0.2}], Scaled[{1, 0.8}]}],
  Frame->True]], "Output",
 ImageSize->{154, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->763743544]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Line", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Scaled", "[", 
       RowBox[{"{", 
        RowBox[{"0", ",", ".2", ",", "0"}], "}"}], "]"}], ",", 
      RowBox[{"Scaled", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", ".8", ",", "1"}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->98388125],

Cell[BoxData[
 Graphics3DBox[Line3DBox[{Scaled[{0, 0.2, 0}], Scaled[{1, 0.8, 1}]}],
  Axes->True]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->10518890,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->707353207],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ImageScaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageScaled"]], "InlineFormula"],
 " coordinates in 2D: "
}], "ExampleText",
 CellID->32811465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Line", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"ImageScaled", "[", 
       RowBox[{"{", 
        RowBox[{"0", ",", ".2"}], "}"}], "]"}], ",", 
      RowBox[{"ImageScaled", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", ".8"}], "}"}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->469786256],

Cell[BoxData[
 GraphicsBox[LineBox[{ImageScaled[{0, 0.2}], ImageScaled[{1, 0.8}]}],
  Frame->True]], "Output",
 ImageSize->{154, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->382809446]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->213028339],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Offset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Offset"]], "InlineFormula"],
 " coordinates in 2D: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->9575]
}], "ExampleText",
 CellID->12468032],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Line", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Offset", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"10", ",", "20"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
      RowBox[{"Offset", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "10"}], ",", 
          RowBox[{"-", "20"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->47775883],

Cell[BoxData[
 GraphicsBox[LineBox[{Offset[{10, 20}, {0, 0}], Offset[{-10, -20}, {1, 1}]}],
  Frame->True]], "Output",
 ImageSize->{154, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->435192456]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4659],

Cell["Complete graph with 11 nodes:", "ExampleText",
 CellID->208544288],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{"Tuples", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", "t", "]"}], ",", 
         RowBox[{"Sin", "[", "t", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", 
         RowBox[{"2", 
          RowBox[{"Pi", "/", "11"}]}]}], "}"}]}], "]"}], ",", "2"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24065159],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Line", "[", "p", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->211822337],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->539977422]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->227796908],

Cell["The tangent bundle for a quadratic curve:", "ExampleText",
 CellID->308272457],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->333244862],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a", "-", "2"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"f", "'"}], "[", "a", "]"}], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a", "-", "2"}], ")"}], "-", "a"}], ")"}]}], "+", 
          RowBox[{"f", "[", "a", "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a", "+", "2"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"f", "'"}], "[", "a", "]"}], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a", "+", "2"}], ")"}], "-", "a"}], ")"}]}], "+", 
          RowBox[{"f", "[", "a", "]"}]}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", 
       RowBox[{"-", "10"}], ",", "10", ",", ".1"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->61029561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Line", "[", "p", "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->31059989],

Cell[BoxData[
 GraphicsBox[LineBox[CompressedData["
1:eJxlmW1wVUcZgJN703AJIQnJzQf5uNx8p612EGgMGnperBAICAQIUEIwOEVr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   "]],
  PlotRange->{{-1, 1}, {-1, 1}}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->437108404]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->331925191],

Cell["A vector field: ", "ExampleText",
 CellID->114014821],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}], "+", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"y", ",", "x"}], "}"}], "/", "5"}], "-", "1"}]}], "}"}], 
       "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", "10"}], "}"}]}], "]"}], "}"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->181855052],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15875574]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->124539022],

Cell["2D random walk on regular lattice:", "ExampleText",
 CellID->314582086],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Line", "[", 
   RowBox[{"Accumulate", "[", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", "1000"}], "]"}], "]"}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->525162],

Cell[BoxData[
 GraphicsBox[LineBox[CompressedData["
1:eJyNlYtyIjcQRcVjeAwYMGAb8zDr3XU+KJ+QD0h+O1XJOmsDxg8YZ1V1u3zc
qxnvVFHHV91qdUst+fqPv37/sx5C+LsRQmT8XvEVYPwdQf93auwAFmL8XsAC
9lTMwv0sn5irz4852xfc58dqYl22uuJGHsEfWxQO4gvYhDb7EWxqvAkdmUEX
4iuYiS3ZW9CRbacz+WWJ+Mynrnx8fTWN16CLD7SP5+svwDq038+yfMry9edj
2p+fX8/vB/NrJrQ/j/gZW+qdlnrH2E7oGsaNnR+/BtgVc7EnP2MfugbmYlfs
KL+O8jZ2xVzsya8HXWbnev2S9VP5mr/XH81vgLnGjbZPkU2wo7PpJHTrA3um
c8nkaz+v/VgbzGBvu9i2JnPOxBZ0Dja1B03ortPWK96fe+g199L3Tg4G+Qed
mTF1pidgEGMPUafsA7CQv5H2IRi/ARjjDsG62IAeiCdgrWL+AKyKPxJPxTFY
h56IU/EMbEKfV9gz2TPoyJbitrSOsa1xY0fjHWhvPwO7Gu8mdGQOPQFz6Kr5
XI/5fGS3fFnvFMzEJvREHIOp/UrFS+0f6+0k7GPxVByBbTHGH4KZxo3N8NZf
kdZ3RuvHIMb7MQIL8ei02YObz/vA+8X7OQSPiD8EDx/Yq+YPwKJE27sS2Q/v
/3f1S+z+PSp7P3z9ZftjeiSeimMwaDxA0x7PcSJOwar3wtsjrc/tnah6L87B
Vnh7P87BtthxOuV/Ic7ES3Hu9AzMNG5sig3Ni1yIS7Au1mSvQXv7Uvu9EJdg
zenYFyswflfiukSv5e/1J7CAvgbj5/VnkP6peEetayxgvwar4n+W3xfwtUJ/
FW/E35z+Cr6K8bsRy/RXnccNmLJHxvP9Ipq+cTqyIT9jU8ygP4MNnYcxxvkE
xvXXYBy/ElcleiX/Kzff4l2DIbz1wycwhJ/77Sq879clGLRuCG/9auuvwF/J
j/U3ZG9Am30d3u/XGmR82x9q5mv1XIHe7uNZffT39fj6/fsxB4MY4y3AQjxC
z8FXMX6XYByn5noLsO605RHCz+/XAuT5+3yX4qpEr1RP5EF8EZ/lb3wSH6FX
4hX46PRzhV6Dz+KL7C/Qa8zz8Wy9PfQKfErosnpML0D6m56Ll07PNW+ufOYu
3rIiv2fs/xLnYDxo/PD6/ryOCftCnJfoueZdinPwoHFjXH8mXojnJfpcdVyI
M/ESfIKegU/io+Yb9+ID9Dn4IO6gLzBOPQP3WG+GdRjfrz9z8S60rs/Px/Oa
9T1pPWPcjzNxCkb7RJyCzxp/ht30GHxy9kdx7zTtY3AvPog7cSt/40Z5bVSH
cav6jDwvr8/AXULTf4v4Z279acK+07jxQXkbd66+OH6Kuo2/sh/TEu3zm6JO
5jdJ5Ovn31foCXhfcT5+vvmPwQ3qG7v43n4KbhK6av69y/dOed1B+3q8TuW7
K8lvV3K+PP+q/mC8svgjcCtuxHv5Ge+gzT4UB+Cd+B36ROyD38X/ZDd+h70n
5mLX6Vzxcq3fA7leD7yHfxfcJHQO3mO9LhjHO4l4dxX59cGNxjcV9hNwq33d
av+NG+iRs3s9dOfPfivzt75gf4xUn++X1P30/fTR/UzlV/b+Re7lv1e+VXqk
eUNwp33daZ+NW+gBuE3YTxRvIJruiz2n+8qnB5rfTtzKbwtt/VLWn77frZ/K
7gf7jffT7qO/z0OcO8+f/ZF6T1L+jDd06/n3wN6LyFvVcQtNe+r9KHtPuprX
VZzIb9A5+C1ht/m52ANvoVPv3a3qvVX9xm/aH+MtdMr+r+7Bv9CR/8g/8n96
+Vzl
   "]]]], "Output",
 ImageSize->{184, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12032320]
}, Open  ]],

Cell["3D random walk on regular lattice:", "ExampleText",
 CellID->632690008],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Line", "[", 
   RowBox[{"Accumulate", "[", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"IdentityMatrix", "[", "3", "]"}], ",", 
        RowBox[{"-", 
         RowBox[{"IdentityMatrix", "[", "3", "]"}]}]}], "]"}], ",", "500"}], 
     "]"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->81214253],

Cell[BoxData[
 Graphics3DBox[Line3DBox[CompressedData["
1:eJyd2Atu20YQxnG+ZCnNKXqlHCEHaO+dUrJeJJePJRsCO/UfH2YjpwQM//xh
dna4pIzEf37/+9tfVVEUz7Io6p/ff3777yqdn+ktXeZVXGXyIjmK7VodF9iP
5rXnq3h18s/04c86zwrHTM76AveuPVfny+u9iO2emM9iq9Hcrklsc05Yu7tM
Hh1vqNlSf9regQWexbV4RQ0dURPTvnQjXlGzSj5LDX0QR8lnxxFenLwRL/Cc
zke9JB/EETXRyXUGnSd3X8zHF/ULzs1ci6Pks9g7B/MEj7hfOjh5LQ7wgPeQ
7vGO9Wlmdbd9vOfd9vGed1jboWcn/aO4Fg/JDWZrXuRmm9/MPMKr4wEO8Jh8
gBux1ddiq6mSo7gWB8lfPUcv5/twyOSsr+ASM6gHJy8y9ZXcC23nTFdOvjkO
yQ2sZx7QM0j/KPbm4b77/eXmqeBS3Eu+Ov7MOdt7W4itT/Giv9XQY5qNLjP5
ftk7bN7EuT4VzM9C/Ru5nT89wfa7R22/q9RjciMOaU/a3qUKzuW7qxd56XhA
zYC1A+6FDpLn6ivHIZP3OAe6g5+opx84k92N4ztq7lh7x8zmRnxDzQ3nZi7F
1l99SzOYK8dX+D25SC7hwvEVvmVyrbfPjnm/zKv4lhzhBZ7F9+QJnsWsv8Lv
28e/j82T+IL+5hEO4nPyAPeZ/HfqV3F4kUfHLWpayT9Tb3u1sm/MzPmr++pT
H+ZF+lzuLh3v51yJu+QabsRP1NAP+J7Jde07er5Lf+57gN8cn1Fzxtozepof
Tn6A38QP8QXeZz46viTfxWe4RX2Lni1maDGb5lr/QH/1XnOCv4if4jN8SWvV
dr/mk+ML9s31OUt+FP/f8zT/gxnoH9iXtppO/COTt5/I7TzNJ7F9No/wm2N7
1p3Y1tJ6tuaHuHVy77l4z/fq5B3ciy+Sf3F8fZEPyX/AX8UBNfQoviVP4jv8
gJ9wl+Yxnxw/07Mwnxxb/SzuUdOjj3kU21p17+Q6Zy/7Hh0PcIDH5CX55Dik
s6Jn8YiaMZ2zOiRHONd/Qc9ZPEl+cjw5+SS2PhPqJ1k74azMizh3bpPkR3GE
Vyd/E9vag+OwffyNKkjeiGfx/m7Uju3/BebacQc/nXxJrsRW8y+sIX/y
   "]],
  ImageSize->{180., 206.83829099710593`},
  ViewPoint->{1.3, -2.4, 2.},
  ViewVertical->{0., 0., 1.1111111111111112`}]], "Output",
 ImageSize->{184, 207},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->351519468,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5688],

Cell[TextData[{
 "Several visualization function produce ",
 Cell[BoxData[
  ButtonBox["Line",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Line"]], "InlineFormula"],
 " objects:",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->285586197,
  ButtonNote->"285586197"]
}], "ExampleText",
 CellID->592292553],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"10", ",", 
     RowBox[{"{", "10", "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->261524770],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->37463606],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1., 4.}, {2., 3.}, {3., 6.}, {4., 5.}, {5., 3.}, {6., 8.}, {7., 
     4.}, {8., 0.}, {9., 3.}, {10., 1.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 10.}, {0., 8.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 125},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->762116551]
}, Open  ]],

Cell["You use directive styles appropriate for lines:", "ExampleText",
 CellID->375562487],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"PlotStyle", "\[Rule]", "DotDashed"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->153055715],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Dashing[{0, Small, Small, Small}], 
    LineBox[{{1., 4.}, {2., 3.}, {3., 6.}, {4., 5.}, {5., 3.}, {6., 8.}, {7., 
     4.}, {8., 0.}, {9., 3.}, {10., 1.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 10.}, {0., 8.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 125},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->728068574]
}, Open  ]],

Cell["You can also transform the output:", "ExampleText",
 CellID->631102540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"Line", "\[Rule]", "Arrow"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->264906932],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Dashing[{0, Small, Small, Small}], 
    ArrowBox[{{1., 4.}, {2., 3.}, {3., 6.}, {4., 5.}, {5., 3.}, {6., 8.}, {7.,
      4.}, {8., 0.}, {9., 3.}, {10., 1.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 10.}, {0., 8.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 125},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->283059825]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->85279040],

Cell["The same idea applies in 3D:", "ExampleText",
 CellID->754722668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}], ",", 
     RowBox[{"\[Theta]", "/", "4"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"3", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Thick", ",", "Pink"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->110897748],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->516668584]
}, Open  ]],

Cell["This shows the points at which it was sampled:", "ExampleText",
 CellID->800763984],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{
   RowBox[{"Line", "[", "p_List", "]"}], "\[RuleDelayed]", 
   RowBox[{"Point", "[", "p", "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->126772222],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29420609]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17754],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Line",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Line"]], "InlineFormula"],
 " objects need to be specified using numbers representable as machine \
numbers:"
}], "ExampleText",
 CellID->149194561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Line", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10.", "^", "500"}], ",", 
       RowBox[{"10.", "^", "500"}]}], "}"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->517940425],

Cell[BoxData[
 GraphicsBox[
  LineBox[{{0, 0}, {
    9.999999999999998*^499, 9.999999999999998*^499}}]]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->792787008]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MachineNumberQ", "[", 
  RowBox[{"10.", "^", "500"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->111975066],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->57240269]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13432],

Cell["A random collection of lines:", "ExampleText",
 CellID->176329113],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{"RandomReal", "[", "]"}], "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"1", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", "100", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->111295440],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.5893472626865748], 
    LineBox[{{0.07736457871738134, 0.3873761866627592}, {0.6979359384746877, 
     0.5559241242563633}}]}, 
   {Hue[0.7329782801205269], 
    LineBox[{{0.7185500130728055, 0.10787166412503435`}, {0.8399562646987295, 
     0.1357626398424714}}]}, 
   {Hue[0.3513859150594676], 
    LineBox[{{0.3531228026126241, 0.3425458224762479}, {0.08784552417936031, 
     0.16776085674585017`}}]}, 
   {Hue[0.9277312371800839], 
    LineBox[{{0.18671520617528348`, 0.4405827172343717}, {0.8324635848968527, 
     0.46061084623869}}]}, 
   {Hue[0.4183117190456189], 
    LineBox[{{0.06486607405246025, 0.6721037796492446}, {0.1829497319336293, 
     0.25848061047306126`}}]}, 
   {Hue[0.6852615776875721], 
    LineBox[{{0.1420862445959763, 0.2755173241212041}, {0.023192783987332488`,
      0.3680679459901568}}]}, 
   {Hue[0.5107095482447708], 
    LineBox[{{0.3086633825928784, 0.0448400465867933}, {0.4630047550838685, 
     0.10709332046912468`}}]}, 
   {Hue[0.03665000083640102], 
    LineBox[{{0.2316904158123736, 0.8940690313414168}, {0.7288051076816775, 
     0.48592612718960004`}}]}, 
   {Hue[0.9246793292228737], 
    LineBox[{{0.31304431423421164`, 0.8819640873756982}, {0.5129503418214356, 
     0.5697868492690974}}]}, 
   {Hue[0.9852345725968574], 
    LineBox[{{0.5012402250732784, 0.7288646536845289}, {0.6713362530759215, 
     0.6015826032542446}}]}, 
   {Hue[0.6677045511306916], 
    LineBox[{{0.056465786600470746`, 0.29890640833974147`}, {
     0.26466370279529494`, 0.8603370721280916}}]}, 
   {Hue[0.5464849886285261], 
    LineBox[{{0.002971116979716193, 0.15386965461720403`}, {
     0.06038913571037785, 0.5405245581133384}}]}, 
   {Hue[0.3907530611662595], 
    LineBox[{{0.6907976204492188, 0.7497301147967776}, {0.9081633200448453, 
     0.03798684697830068}}]}, 
   {Hue[0.5947661826228796], 
    LineBox[{{0.701192852905649, 0.5161357913906386}, {0.19008779576309354`, 
     0.5313175961268397}}]}, 
   {Hue[0.44160035114882157`], 
    LineBox[{{0.20749556398503022`, 0.3833416142792665}, {0.4732662095649389, 
     0.5910062624196397}}]}, 
   {Hue[0.9585466818582928], 
    LineBox[{{0.373101105761374, 0.20384063809481123`}, {0.5299394637789472, 
     0.26495001778014604`}}]}, 
   {Hue[0.9110803603160043], 
    LineBox[{{0.5995528173976226, 0.26626272950637087`}, {0.9582875673515043, 
     0.9192536097677051}}]}, 
   {Hue[0.9544475999029793], 
    LineBox[{{0.16242936587517298`, 0.6236428861726746}, {0.7985562287272114, 
     0.8555518871728061}}]}, 
   {Hue[0.20454275544913547`], 
    LineBox[{{0.09281500849354951, 0.20875332351445586`}, {
     0.49639660652756157`, 0.9464649810776447}}]}, 
   {Hue[0.5490315161972117], 
    LineBox[{{0.6685342456582748, 0.8456330302449464}, {0.8031567561668826, 
     0.8147383701535873}}]}, 
   {Hue[0.0026800680243650454`], 
    LineBox[{{0.7765730705002376, 0.7599396157245055}, {0.9222087866797026, 
     0.5161166578891021}}]}, 
   {Hue[0.9147422063114055], 
    LineBox[{{0.3256855646145531, 0.004449703256090176}, {0.5944751388907594, 
     0.6322789248025322}}]}, 
   {Hue[0.6071249651703945], 
    LineBox[{{0.03271646676926432, 0.060834331111352835`}, {
     0.2688747788270558, 0.10817726845589992`}}]}, 
   {Hue[0.09931946659752922], 
    LineBox[{{0.17706267879901127`, 0.2148687213214726}, {0.9677112113700976, 
     0.23359410590824936`}}]}, 
   {Hue[0.8571867025832138], 
    LineBox[{{0.0432314715202331, 0.056870314344871664`}, {0.9016533214873157,
      0.3556183571655358}}]}, 
   {Hue[0.4614897659443935], 
    LineBox[{{0.9506033760961801, 0.230241898386772}, {0.2116633409463835, 
     0.5996313122886949}}]}, 
   {Hue[0.9623358985991957], 
    LineBox[{{0.18351808836450667`, 0.953511932753992}, {0.6334917235716733, 
     0.962101488397948}}]}, 
   {Hue[0.036597117310285476`], 
    LineBox[{{0.5351379915212711, 0.5052021375064673}, {0.24792031247947088`, 
     0.8074563677937725}}]}, 
   {Hue[0.8428753340209347], 
    LineBox[{{0.3316433063144679, 0.5172920511233281}, {0.40613382952749144`, 
     0.6933139877043932}}]}, 
   {Hue[0.04386767530329161], 
    LineBox[{{0.8269902327273368, 0.1871887425716081}, {0.8851798578117007, 
     0.5896523371147591}}]}, 
   {Hue[0.1152951128079962], 
    LineBox[{{0.4681237904165765, 0.8223938186105426}, {0.06247649502349595, 
     0.36163555023859395`}}]}, 
   {Hue[0.8435323974101772], 
    LineBox[{{0.6483337844663095, 0.3693199221221981}, {0.17870207758735845`, 
     0.62614010519167}}]}, 
   {Hue[0.8515151369945797], 
    LineBox[{{0.2596959692675158, 0.6761319666433532}, {0.39942426490474214`, 
     0.9141545916400498}}]}, 
   {Hue[0.9564457310133603], 
    LineBox[{{0.5652886421513443, 0.02452926261716981}, {0.2803204795253489, 
     0.3253515088828207}}]}, 
   {Hue[0.916210879787636], 
    LineBox[{{0.9477974641802862, 0.24402483796299235`}, {0.6050539739447656, 
     0.795328932878911}}]}, 
   {Hue[0.13764231889563217`], 
    LineBox[{{0.32049772575019797`, 0.14239170315315341`}, {
     0.5948727396910793, 0.23273309110270635`}}]}, 
   {Hue[0.8210661572861762], 
    LineBox[{{0.7401707141158376, 0.8087333521786857}, {0.14227524335504382`, 
     0.13094939277557716`}}]}, 
   {Hue[0.5025747069550606], 
    LineBox[{{0.1612290601946913, 0.7901740497449503}, {0.07480932008445929, 
     0.15223714367389896`}}]}, 
   {Hue[0.1710011182395006], 
    LineBox[{{0.6252265423499193, 0.44296048528384513`}, {0.7243903892339922, 
     0.7640879270044185}}]}, 
   {Hue[0.9308926535695079], 
    LineBox[{{0.2600815405414387, 0.6462028595056788}, {0.14764291924400474`, 
     0.3860370433621687}}]}, 
   {Hue[0.6340235024487597], 
    LineBox[{{0.2506412201564412, 0.02790689011969638}, {0.9571496018187142, 
     0.03350899346268155}}]}, 
   {Hue[0.17428156746005707`], 
    LineBox[{{0.6872180352810802, 0.8685961464562644}, {0.0296724818384273, 
     0.17328503349057245`}}]}, 
   {Hue[0.8941856732152882], 
    LineBox[{{0.0647479360346559, 0.20757318530190805`}, {0.9163538859646645, 
     0.8519520547955892}}]}, 
   {Hue[0.8073312178596255], 
    LineBox[{{0.383033079029073, 0.10554601139775244`}, {0.8296697120703824, 
     0.3609364190384867}}]}, 
   {Hue[0.24273440058267148`], 
    LineBox[{{0.7576117655879107, 0.6975986518460633}, {0.07694373492378093, 
     0.617937365755791}}]}, 
   {Hue[0.9835999309729719], 
    LineBox[{{0.9573374576611471, 0.39644393925262844`}, {
     0.24007544287703686`, 0.6524306229659991}}]}, 
   {Hue[0.16143256927126193`], 
    LineBox[{{0.662504588316051, 0.6121106644748884}, {0.7653943040084925, 
     0.9061896461172474}}]}, 
   {Hue[0.24957959659252893`], 
    LineBox[{{0.3221180699784767, 0.32192017202366285`}, {
     0.015311322219030421`, 0.18472521474911763`}}]}, 
   {Hue[0.5747317505705802], 
    LineBox[{{0.1666442304193816, 0.3353482544149564}, {0.5428123129822173, 
     0.5860823949281033}}]}, 
   {Hue[0.4270064019101443], 
    LineBox[{{0.6310488105704017, 0.7282488130330562}, {0.2334498550558386, 
     0.1277099106834929}}]}, 
   {Hue[0.5772085242233151], 
    LineBox[{{0.6814402815898482, 0.14635720531578755`}, {0.9947537927657897, 
     0.1734004602143142}}]}, 
   {Hue[0.0711351891998162], 
    LineBox[{{0.02090185606901729, 0.5138188791518881}, {0.7719160118314001, 
     0.8755063034942248}}]}, 
   {Hue[0.26943228271402164`], 
    LineBox[{{0.5023898108471556, 0.8708823236205598}, {0.4765024697743989, 
     0.8386669906965336}}]}, 
   {Hue[0.9801368563346649], 
    LineBox[{{0.9879910525234106, 0.9228313350987896}, {0.8781725753646608, 
     0.5235030801286227}}]}, 
   {Hue[0.5050084804656627], 
    LineBox[{{0.817474475009438, 0.2016617364260409}, {0.8301530187955983, 
     0.8509480902900444}}]}, 
   {Hue[0.10277987454080817`], 
    LineBox[{{0.6038248029717137, 0.6660855041255946}, {0.8264411176069688, 
     0.5925722058438163}}]}, 
   {Hue[0.07618877796221168], 
    LineBox[{{0.3174025466441954, 0.9891260320983921}, {0.19668875565874533`, 
     0.6021312081631971}}]}, 
   {Hue[0.20712168704863787`], 
    LineBox[{{0.9257797100927185, 0.3616408395040105}, {0.7891174956512739, 
     0.6168366322101979}}]}, 
   {Hue[0.20659766385088063`], 
    LineBox[{{0.8896122661211043, 0.9221977183791048}, {0.8253743593818301, 
     0.8970152362865262}}]}, 
   {Hue[0.4390866651580354], 
    LineBox[{{0.41611755141479456`, 0.16074786439534794`}, {
     0.2745994769943412, 0.7434314360573895}}]}, 
   {Hue[0.08440101651508702], 
    LineBox[{{0.6274046485848901, 0.7365517877018599}, {0.6371242145921188, 
     0.06661152748308297}}]}, 
   {Hue[0.01601715237660417], 
    LineBox[{{0.32294753520724684`, 0.23710467427116155`}, {
     0.29591524052834983`, 0.9206492179365946}}]}, 
   {Hue[0.512749631007914], 
    LineBox[{{0.1361688094663518, 0.5271681090647069}, {0.02888577103271106, 
     0.4525884683194079}}]}, 
   {Hue[0.5491117022338665], 
    LineBox[{{0.8436576330577861, 0.7923747749723549}, {0.08980101147551811, 
     0.956199983584971}}]}, 
   {Hue[0.3635149991357731], 
    LineBox[{{0.14352361618702436`, 0.8607272786442863}, {0.7381567798959323, 
     0.4882229287975459}}]}, 
   {Hue[0.29737408643654595`], 
    LineBox[{{0.33978162467486683`, 0.6133068346550195}, {0.6131021786318382, 
     0.613559057411144}}]}, 
   {Hue[0.3455260519377472], 
    LineBox[{{0.6432962160016871, 0.8001357493975563}, {0.8733265560957675, 
     0.37307269012274813`}}]}, 
   {Hue[0.8893658564605031], 
    LineBox[{{0.5254278993339323, 0.8014475113167552}, {0.8982949312502606, 
     0.10378683663192079`}}]}, 
   {Hue[0.9210467457971263], 
    LineBox[{{0.34453722209490656`, 0.46375240542612417`}, {0.304252126420002,
      0.8827620032179495}}]}, 
   {Hue[0.3009236244124327], 
    LineBox[{{0.18263508686475616`, 0.6902775454269796}, {
     0.19015813816397253`, 0.7833417972715573}}]}, 
   {Hue[0.09060639671690018], 
    LineBox[{{0.9720336286366693, 0.7322055339174514}, {0.3811448275145093, 
     0.5934245149087101}}]}, 
   {Hue[0.3838197511495349], 
    LineBox[{{0.6080927274750951, 0.8893690427630856}, {0.6643688089587572, 
     0.7955378209613486}}]}, 
   {Hue[0.9144066768010839], 
    LineBox[{{0.08032983068707922, 0.937894669187481}, {0.875818732473651, 
     0.9439794456982473}}]}, 
   {Hue[0.9092010063853655], 
    LineBox[{{0.5907540039727703, 0.255712431837964}, {0.35668196170295596`, 
     0.536681238509094}}]}, 
   {Hue[0.7240877324691197], 
    LineBox[{{0.462791963105188, 0.6714620692455571}, {0.6273051693768117, 
     0.4193348545339062}}]}, 
   {Hue[0.8599465777496016], 
    LineBox[{{0.45267809437654094`, 0.6810810530022551}, {0.2852799280826688, 
     0.9857430782759637}}]}, 
   {Hue[0.5649025378444594], 
    LineBox[{{0.5200982495315816, 0.5736128706317238}, {0.43502139684914964`, 
     0.32785538854991336`}}]}, 
   {Hue[0.05239340944399706], 
    LineBox[{{0.5915177299037409, 0.11461651754837421`}, {
     0.20917757957135352`, 0.7922975420889513}}]}, 
   {Hue[0.5444309612151108], 
    LineBox[{{0.4431276065672429, 0.8945416953350818}, {0.5010211174991912, 
     0.34187373330379445`}}]}, 
   {Hue[0.5827314006979496], 
    LineBox[{{0.18198844413567605`, 0.6829237859099369}, {0.6553934215741188, 
     0.437036092156732}}]}, 
   {Hue[0.7366065997548934], 
    LineBox[{{0.5511941191248682, 0.3730026363215939}, {0.031222126103763514`,
      0.1553656024169392}}]}, 
   {Hue[0.18909305232815754`], 
    LineBox[{{0.5358773631733069, 0.0839393958201653}, {0.5426036130480714, 
     0.6852495599999313}}]}, 
   {Hue[0.7138534769429743], 
    LineBox[{{0.6976473235243934, 0.12329530897088192`}, {
     0.46909118056776866`, 0.7128140465299804}}]}, 
   {Hue[0.6611990317412078], 
    LineBox[{{0.9076183837112073, 0.7619249561924817}, {0.45911326814661546`, 
     0.9712451511304265}}]}, 
   {Hue[0.7541573532459733], 
    LineBox[{{0.7477598353961112, 0.43041774310683434`}, {0.5197547632189885, 
     0.8575010211457914}}]}, 
   {Hue[0.9276639718820776], 
    LineBox[{{0.6989569697460194, 0.006010664749324102}, {0.8282863100077538, 
     0.7549043389495504}}]}, 
   {Hue[0.19310483742151918`], 
    LineBox[{{0.7988256800123106, 0.7440303363163965}, {0.1920485707028885, 
     0.9004706497460735}}]}, 
   {Hue[0.5607204193906468], 
    LineBox[{{0.7886611966850112, 0.31899113065686}, {0.01024982165624655, 
     0.9967644114036898}}]}, 
   {Hue[0.10258419267420082`], 
    LineBox[{{0.4509194119334168, 0.10145780171027119`}, {0.9586159556436671, 
     0.10634564071101837`}}]}, 
   {Hue[0.76731081549856], 
    LineBox[{{0.45048348093485147`, 0.7860201623627461}, {0.9093683966535231, 
     0.07336506492824846}}]}, 
   {Hue[0.7930462461985273], 
    LineBox[{{0.48893556969856466`, 0.19355309147870137`}, {
     0.9695499392896854, 0.7496583493633884}}]}, 
   {Hue[0.42880043490906394`], 
    LineBox[{{0.6587219248772116, 0.9816771637416377}, {0.2590760689275957, 
     0.6738294702933896}}]}, 
   {Hue[0.011115398171443358`], 
    LineBox[{{0.4542525268193902, 0.9949818025782144}, {0.7746274702844895, 
     0.25566140872532284`}}]}, 
   {Hue[0.28315883248005735`], 
    LineBox[{{0.07952285407523485, 0.4336048007296738}, {0.9754215850480081, 
     0.7992166325536656}}]}, 
   {Hue[0.24377117631378975`], 
    LineBox[{{0.393374026892507, 0.9905605450306032}, {0.438734972346857, 
     0.8783389997381854}}]}, 
   {Hue[0.7165897350879966], 
    LineBox[{{0.6647794589668907, 0.9171219344640336}, {0.8385559141489303, 
     0.7823031718976836}}]}, 
   {Hue[0.5272755074590825], 
    LineBox[{{0.3048420094885207, 0.6523619453846323}, {0.7375883114770763, 
     0.40180948570969277`}}]}, 
   {Hue[0.21844799589822905`], 
    LineBox[{{0.17638746185605658`, 0.25045543295387773`}, {
     0.02408079725380685, 0.517576708878358}}]}, 
   {Hue[0.06735592578062155], 
    LineBox[{{0.38722241611628205`, 0.7745987378058374}, {0.893352853835579, 
     0.3386826512478054}}]}, 
   {Hue[0.4883561249131114], 
    LineBox[{{0.03814621156431253, 0.28487193876047123`}, {0.5418573706583214,
      0.9327287894976388}}]}}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->208236448]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{"RandomReal", "[", "]"}], "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"1", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", "100", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30586822],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->893841922]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->221170755],

Cell["Moir\[EAcute] pattern:", "ExampleText",
 CellID->74389220],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", "-", "x"}], ",", "1"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "x"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"1", "-", "x"}]}], "}"}]}], "}"}]}], "}"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1", ",", ".02"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->378344974],

Cell[BoxData[
 GraphicsBox[{LineBox[{{{0., 0}, {1., 1}}, {{0, 0.}, {1, 1.}}}], 
   LineBox[{{{0.02, 0}, {0.98, 1}}, {{0, 0.02}, {1, 0.98}}}], 
   LineBox[{{{0.04, 0}, {0.96, 1}}, {{0, 0.04}, {1, 0.96}}}], 
   LineBox[{{{0.06, 0}, {0.94, 1}}, {{0, 0.06}, {1, 0.94}}}], 
   LineBox[{{{0.08, 0}, {0.92, 1}}, {{0, 0.08}, {1, 0.92}}}], 
   LineBox[{{{0.1, 0}, {0.9, 1}}, {{0, 0.1}, {1, 0.9}}}], 
   LineBox[{{{0.12, 0}, {0.88, 1}}, {{0, 0.12}, {1, 0.88}}}], 
   LineBox[{{{0.14, 0}, {0.86, 1}}, {{0, 0.14}, {1, 0.86}}}], 
   LineBox[{{{0.16, 0}, {0.84, 1}}, {{0, 0.16}, {1, 0.84}}}], 
   LineBox[{{{0.18, 0}, {0.8200000000000001, 1}}, {{0, 0.18}, {
      1, 0.8200000000000001}}}], 
   LineBox[{{{0.2, 0}, {0.8, 1}}, {{0, 0.2}, {1, 0.8}}}], 
   LineBox[{{{0.22, 0}, {0.78, 1}}, {{0, 0.22}, {1, 0.78}}}], 
   LineBox[{{{0.24, 0}, {0.76, 1}}, {{0, 0.24}, {1, 0.76}}}], 
   LineBox[{{{0.26, 0}, {0.74, 1}}, {{0, 0.26}, {1, 0.74}}}], 
   LineBox[{{{0.28, 0}, {0.72, 1}}, {{0, 0.28}, {1, 0.72}}}], 
   LineBox[{{{0.3, 0}, {0.7, 1}}, {{0, 0.3}, {1, 0.7}}}], 
   LineBox[{{{0.32, 0}, {0.6799999999999999, 1}}, {{0, 0.32}, {
      1, 0.6799999999999999}}}], 
   LineBox[{{{0.34, 0}, {0.6599999999999999, 1}}, {{0, 0.34}, {
      1, 0.6599999999999999}}}], 
   LineBox[{{{0.36, 0}, {0.64, 1}}, {{0, 0.36}, {1, 0.64}}}], 
   LineBox[{{{0.38, 0}, {0.62, 1}}, {{0, 0.38}, {1, 0.62}}}], 
   LineBox[{{{0.4, 0}, {0.6, 1}}, {{0, 0.4}, {1, 0.6}}}], 
   LineBox[{{{0.42, 0}, {0.5800000000000001, 1}}, {{0, 0.42}, {
      1, 0.5800000000000001}}}], 
   LineBox[{{{0.44, 0}, {0.56, 1}}, {{0, 0.44}, {1, 0.56}}}], 
   LineBox[{{{0.46, 0}, {0.54, 1}}, {{0, 0.46}, {1, 0.54}}}], 
   LineBox[{{{0.48, 0}, {0.52, 1}}, {{0, 0.48}, {1, 0.52}}}], 
   LineBox[{{{0.5, 0}, {0.5, 1}}, {{0, 0.5}, {1, 0.5}}}], 
   LineBox[{{{0.52, 0}, {0.48, 1}}, {{0, 0.52}, {1, 0.48}}}], 
   LineBox[{{{0.54, 0}, {0.45999999999999996`, 1}}, {{0, 0.54}, {
      1, 0.45999999999999996`}}}], 
   LineBox[{{{0.56, 0}, {0.43999999999999995`, 1}}, {{0, 0.56}, {
      1, 0.43999999999999995`}}}], 
   LineBox[{{{0.58, 0}, {0.42000000000000004`, 1}}, {{0, 0.58}, {
      1, 0.42000000000000004`}}}], 
   LineBox[{{{0.6, 0}, {0.4, 1}}, {{0, 0.6}, {1, 0.4}}}], 
   LineBox[{{{0.62, 0}, {0.38, 1}}, {{0, 0.62}, {1, 0.38}}}], 
   LineBox[{{{0.64, 0}, {0.36, 1}}, {{0, 0.64}, {1, 0.36}}}], 
   LineBox[{{{0.66, 0}, {0.33999999999999997`, 1}}, {{0, 0.66}, {
      1, 0.33999999999999997`}}}], 
   LineBox[{{{0.68, 0}, {0.31999999999999995`, 1}}, {{0, 0.68}, {
      1, 0.31999999999999995`}}}], 
   LineBox[{{{0.7000000000000001, 0}, {0.29999999999999993`, 1}}, {{
      0, 0.7000000000000001}, {1, 0.29999999999999993`}}}], 
   LineBox[{{{0.72, 0}, {0.28, 1}}, {{0, 0.72}, {1, 0.28}}}], 
   LineBox[{{{0.74, 0}, {0.26, 1}}, {{0, 0.74}, {1, 0.26}}}], 
   LineBox[{{{0.76, 0}, {0.24, 1}}, {{0, 0.76}, {1, 0.24}}}], 
   LineBox[{{{0.78, 0}, {0.21999999999999997`, 1}}, {{0, 0.78}, {
      1, 0.21999999999999997`}}}], 
   LineBox[{{{0.8, 0}, {0.19999999999999996`, 1}}, {{0, 0.8}, {
      1, 0.19999999999999996`}}}], 
   LineBox[{{{0.8200000000000001, 0}, {0.17999999999999994`, 1}}, {{
      0, 0.8200000000000001}, {1, 0.17999999999999994`}}}], 
   LineBox[{{{0.84, 0}, {0.16000000000000003`, 1}}, {{0, 0.84}, {
      1, 0.16000000000000003`}}}], 
   LineBox[{{{0.86, 0}, {0.14, 1}}, {{0, 0.86}, {1, 0.14}}}], 
   LineBox[{{{0.88, 0}, {0.12, 1}}, {{0, 0.88}, {1, 0.12}}}], 
   LineBox[{{{0.9, 0}, {0.09999999999999998, 1}}, {{0, 0.9}, {
      1, 0.09999999999999998}}}], 
   LineBox[{{{0.92, 0}, {0.07999999999999996, 1}}, {{0, 0.92}, {
      1, 0.07999999999999996}}}], 
   LineBox[{{{0.9400000000000001, 0}, {0.05999999999999994, 1}}, {{
      0, 0.9400000000000001}, {1, 0.05999999999999994}}}], 
   LineBox[{{{0.96, 0}, {0.040000000000000036`, 1}}, {{0, 0.96}, {
      1, 0.040000000000000036`}}}], 
   LineBox[{{{0.98, 0}, {0.020000000000000018`, 1}}, {{0, 0.98}, {
      1, 0.020000000000000018`}}}], 
   LineBox[{{{1., 0}, {0., 1}}, {{0, 1.}, {1, 0.}}}]}]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->224820449]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->96329481],

Cell["Tangent vectors along an elliptic curve:", "ExampleText",
 CellID->57565437],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"f", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Cos", "[", "x", "]"}], "+", 
        RowBox[{"Sin", "[", "x", "]"}]}], ",", 
       RowBox[{"Sin", "[", "x", "]"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Hue", "[", 
          RowBox[{
           RowBox[{"t", "/", 
            RowBox[{"(", 
             RowBox[{"2", "Pi"}], ")"}]}], ",", "1", ",", ".8"}], "]"}], ",", 
         
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{"f", ",", 
            RowBox[{
             RowBox[{"Normalize", "[", 
              RowBox[{"D", "[", 
               RowBox[{"f", ",", "x"}], "]"}], "]"}], "+", "f"}]}], "}"}], 
          "]"}]}], "}"}], "/.", 
       RowBox[{"x", "\[Rule]", "t"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", 
        RowBox[{"2", "Pi"}], ",", ".1"}], "}"}]}], "]"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->316243333],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0., 1, 0.8], 
    LineBox[{{1., 0.}, {1.7071067811865475`, 0.7071067811865475}}]}, 
   {Hue[0.015915494309189534`, 1, 0.8], 
    LineBox[{{1.094837581924854, 0.09983341664682815}, {1.7636648428808375`, 
     0.8432512634881026}}]}, 
   {Hue[0.03183098861837907, 1, 0.8], 
    LineBox[{{1.1787359086363027`, 0.19866933079506122`}, {1.802138039729897, 
     0.9805707203244348}}]}, 
   {Hue[0.04774648292756861, 1, 0.8], 
    LineBox[{{1.2508566957869456`, 0.2955202066613396}, {1.8191519135638443`, 
     1.118344942222873}}]}, 
   {Hue[0.06366197723675814, 1, 0.8], 
    LineBox[{{1.3104793363115357`, 0.3894183423086505}, {1.8103861294825117`, 
     1.2554975523936813`}}]}, 
   {Hue[0.07957747154594767, 1, 0.8], 
    LineBox[{{1.3570081004945758`, 0.479425538604203}, {1.7701709796703633`, 
     1.3900826833470386`}}]}, 
   {Hue[0.09549296585513722, 1, 0.8], 
    LineBox[{{1.3899780883047137`, 0.5646424733950355}, {1.6911733759293677`, 
     1.5182049510086957`}}]}, 
   {Hue[0.11140846016432675`, 1, 0.8], 
    LineBox[{{1.4090598745221796`, 0.6442176872376911}, {1.5648459637362113`, 
     1.6320085023434998`}}]}, 
   {Hue[0.12732395447351627`, 1, 0.8], 
    LineBox[{{1.4140628002466882`, 0.7173560908995228}, {1.3844372525332238`, 
     1.7169171580298295`}}]}, 
   {Hue[0.1432394487827058, 1, 0.8], 
    LineBox[{{1.4049368778981477`, 0.7833269096274834}, {1.15315960382653, 
     1.7511121152702778`}}]}, 
   {Hue[0.15915494309189535`, 1, 0.8], 
    LineBox[{{1.3817732906760363`, 0.8414709848078965}, {0.8948945915176176, 
     1.7149405791875783`}}]}, 
   {Hue[0.17507043740108488`, 1, 0.8], 
    LineBox[{{1.3448034814870127`, 0.8912073600614354}, {0.6504911901640069, 
     1.6108812043254863`}}]}, 
   {Hue[0.19098593171027445`, 1, 0.8], 
    LineBox[{{1.2943968404438997`, 0.9320390859672264}, {0.45062351811608947`,
      1.4687387976570028`}}]}, 
   {Hue[0.20690142601946396`, 1, 0.8], 
    LineBox[{{1.2310570140417803`, 0.963558185417193}, {0.29761425087073706`, 
     1.3222845545115316`}}]}, 
   {Hue[0.2228169203286535, 1, 0.8], 
    LineBox[{{1.155416872888701, 0.9854497299884603}, {0.1764544189979884, 
     1.1894902011511055`}}]}, 
   {Hue[0.238732414637843, 1, 0.8], 
    LineBox[{{1.0682321882717574`, 0.9974949866040544}, {0.0711324734245856, 
     1.0736012192771336`}}]}, 
   {Hue[0.25464790894703254`, 1, 0.8], 
    LineBox[{{0.9703740807402162, 
     0.9995736030415051}, {-0.029223369124849307`, 0.971202169816205}}]}, 
   {Hue[0.27056340325622213`, 1, 0.8], 
    LineBox[{{0.8628203161569437, 0.9916648104524686}, {-0.1306334733676649, 
     0.8774301043461602}}]}, 
   {Hue[0.2864788975654116, 1, 0.8], 
    LineBox[{{0.7466455361851081, 0.9738476308781951}, {-0.2359282252025195, 
     0.7879745466713373}}]}, 
   {Hue[0.30239439187460115`, 1, 0.8], 
    LineBox[{{0.623010520823911, 0.9463000876874145}, {-0.3460645170701743, 
     0.6995338603981488}}]}, 
   {Hue[0.3183098861837907, 1, 0.8], 
    LineBox[{{0.4931505902785393, 0.9092974268256817}, {-0.4609298413890091, 
     0.6097468803246534}}]}, 
   {Hue[0.33422538049298023`, 1, 0.8], 
    LineBox[{{0.35836326204901614`, 0.8632093666488737}, {-0.5797960490296175,
      0.5170055147978821}}]}, 
   {Hue[0.35014087480216977`, 1, 0.8], 
    LineBox[{{0.21999528656424427`, 0.8084964038195901}, {-0.7015712683067716,
      0.4202759961345136}}]}, 
   {Hue[0.36605636911135936`, 1, 0.8], 
    LineBox[{{0.0794291908968956, 0.74570521217672}, {-0.824941316170836, 
     0.31895705934409946`}}]}, 
   {Hue[0.3819718634205489, 1, 0.8], 
    LineBox[{{-0.061930534990095154`, 
     0.6754631805511506}, {-0.9484507868713645, 0.212773389217507}}]}, 
   {Hue[0.3978873577297384, 1, 0.8], 
    LineBox[{{-0.20267147144297726`, 
     0.5984721441039564}, {-1.0705502563325289`, 0.1016961234078731}}]}, 
   {Hue[0.4138028520389279, 1, 0.8], 
    LineBox[{{-0.34138738154748316`, 
     0.5155013718214642}, {-1.1896231274639626`, -0.014117471640051948`}}]}, 
   {Hue[0.42971834634811745`, 1, 0.8], 
    LineBox[{{-0.47669226178323143`, 
     0.4273798802338298}, {-1.3039985773824556`, -0.1343711857817469}}]}, 
   {Hue[0.445633840657307, 1, 0.8], 
    LineBox[{{-0.6072341905127536, 
     0.33498815015590466`}, {-1.4119529389169463`, -0.25866809378227695`}}]}, \

   {Hue[0.4615493349664966, 1, 0.8], 
    LineBox[{{-0.7317088359356086, 
     0.23924932921398198`}, {-1.5116990305894886`, -0.3865424063049543}}]}, 
   {Hue[0.477464829275686, 1, 0.8], 
    LineBox[{{-0.8488724885405782, 
     0.1411200080598672}, {-1.6013604721644608`, -0.5174859701256208}}]}, 
   {Hue[0.4933803235848756, 1, 0.8], 
    LineBox[{{-0.957554487839989, 
     0.04158066243329049}, {-1.6789251973110346`, -0.6509684690492636}}]}, 
   {Hue[0.5092958178940651, 1, 0.8], 
    LineBox[{{-1.0566689192223333`, -0.058374143427580086`}, \
{-1.7421686086171666`, -0.7864470627423881}}]}, 
   {Hue[0.5252113122032547, 1, 0.8], 
    LineBox[{{-1.1452254640521136`, -0.15774569414324865`}, \
{-1.7885316720108762`, -0.9233546823361232}}]}, 
   {Hue[0.5411268065124443, 1, 0.8], 
    LineBox[{{-1.2223392946062925`, -0.25554110202683167`}, \
{-1.8149330972788489`, -1.061042551456986}}]}, 
   {Hue[0.5570423008216338, 1, 0.8], 
    LineBox[{{-1.2872399149804161`, -0.35078322768961984`}, \
{-1.8174914596014755`, -1.1986236014788023`}}]}, 
   {Hue[0.5729577951308232, 1, 0.8], 
    LineBox[{{-1.3392788596289995`, -0.44252044329485246`}, \
{-1.7911489578761617`, -1.3346041917793205`}}]}, 
   {Hue[0.5888732894400128, 1, 0.8], 
    LineBox[{{-1.3779361726189014`, -0.5298361409084934}, \
{-1.7292787015964146`, -1.4660831314679745`}}]}, 
   {Hue[0.6047887837492023, 1, 0.8], 
    LineBox[{{-1.4028256028571358`, -0.6118578909427193}, \
{-1.6236779885590154`, -1.5871651367528734`}}]}, 
   {Hue[0.6207042780583919, 1, 0.8], 
    LineBox[{{-1.4136984633841139`, -0.6877661591839741}, \
{-1.4662013002074457`, -1.686386934115831}}]}, 
   {Hue[0.6366197723675814, 1, 0.8], 
    LineBox[{{-1.4104461161715403`, -0.7568024953079282}, \
{-1.2545543346607086`, -1.7445766357152275`}}]}, 
   {Hue[0.652535266676771, 1, 0.8], 
    LineBox[{{-1.3931010575976792`, -0.8182771110644108}, \
{-1.0031099793769567`, -1.7390957462517305`}}]}, 
   {Hue[0.6684507609859605, 1, 0.8], 
    LineBox[{{-1.3618365937542876`, -0.8715757724135882}, \
{-0.7478949981942424, -1.6609272259760592`}}]}, 
   {Hue[0.6843662552951499, 1, 0.8], 
    LineBox[{{-1.3169651088294303`, -0.9161659367494549}, \
{-0.5275819802263793, -1.5300668051939121`}}]}, 
   {Hue[0.7002817496043395, 1, 0.8], 
    LineBox[{{-1.2589349438679354`, -0.951602073889516}, \
{-0.3563672012639345, -1.3821499458047286`}}]}, 
   {Hue[0.716197243913529, 1, 0.8], 
    LineBox[{{-1.1883259170958766`, -0.977530117665097}, \
{-0.22410247715079717`, -1.2426209659803071`}}]}, 
   {Hue[0.7321127382227187, 1, 0.8], 
    LineBox[{{-1.1058435305685186`, -0.9936910036334645}, \
{-0.11383952030723424`, -1.1198973569819783`}}]}, 
   {Hue[0.7480282325319082, 1, 0.8], 
    LineBox[{{-1.0123119210269913`, -0.9999232575641008}, \
{-0.01239060078604668, -1.0124673130329715`}}]}, 
   {Hue[0.7639437268410978, 1, 0.8], 
    LineBox[{{-0.9086656253963933, -0.9961646088358406}, {
     0.08809045694056393, -0.91568285733725}}]}, 
   {Hue[0.7798592211502873, 1, 0.8], 
    LineBox[{{-0.7959402432017567, -0.9824526126243325}, {
     0.1915690930026317, -0.8248921134211111}}]}, 
   {Hue[0.7957747154594768, 1, 0.8], 
    LineBox[{{-0.6752620891999122, -0.9589242746631385}, {
     0.2996573228989497, -0.7363661026882375}}]}, 
   {Hue[0.8116902097686663, 1, 0.8], 
    LineBox[{{-0.5478369396147511, -0.9258146823277321}, {
     0.41261624871936636`, -0.6473731749714678}}]}, 
   {Hue[0.8276057040778558, 1, 0.8], 
    LineBox[{{-0.41493798441977603`, -0.8834546557201531}, {
     0.529934268196041, -0.5560154610034673}}]}, 
   {Hue[0.8435211983870454, 1, 0.8], 
    LineBox[{{-0.27789310604473927`, -0.8322674422239008}, {
     0.6506487732556901, -0.46103977840393856`}}]}, 
   {Hue[0.8594366926962349, 1, 0.8], 
    LineBox[{{-0.13807161161335246`, -0.7727644875559871}, {
     0.7735255332431328, -0.3616797694144534}}]}, 
   {Hue[0.8753521870054244, 1, 0.8], 
    LineBox[{{0.0031294487208680666`, -0.7055403255703919}, {
     0.8971606165165542, -0.2575355588436509}}]}, 
   {Hue[0.891267681314614, 1, 0.8], 
    LineBox[{{0.14429924063792932`, -0.6312666378723208}, {
     1.0200394810909637`, -0.1484840457552669}}]}, 
   {Hue[0.9071831756238035, 1, 0.8], 
    LineBox[{{0.2840272422415222, -0.5506855425976376}, {
     1.1405711887429535`, -0.03461145129702481}}]}, 
   {Hue[0.9230986699329932, 1, 0.8], 
    LineBox[{{0.4209173375275628, -0.4646021794137566}, {1.257106656148762, 
     0.08383872298486483}}]}, 
   {Hue[0.9390141642421826, 1, 0.8], 
    LineBox[{{0.5536017659138, -0.373876664830236}, {1.3679447607359057`, 
     0.20650724844111218`}}]}, 
   {Hue[0.954929658551372, 1, 0.8], 
    LineBox[{{0.6807547884514401, -0.27941549819892586`}, {
     1.4713269000484912`, 0.3329534562435573}}]}, 
   {Hue[0.9708451528605617, 1, 0.8], 
    LineBox[{{0.8011059341704897, -0.18216250427209502`}, {1.5654180781857, 
     0.4626839476146104}}]}, 
   {Hue[0.9867606471697512, 1, 0.8], 
    LineBox[{{0.9134526942057211, -0.0830894028174964}, {1.648269987728047, 
     0.5951756966388476}}]}}]], "Output",
 ImageSize->{184, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->520132995]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31379],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Arrow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Arrow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Polygon",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Polygon"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EdgeForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EdgeForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Thick",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Thick"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Thin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Thin"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListLinePlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListLinePlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Point",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Point"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31955]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23292],

Cell[TextData[ButtonBox["Three\[Hyphen]Dimensional Graphics Primitives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ThreeDimensionalGraphicsPrimitives"]], "Tutorials",
 CellID->595610080],

Cell[TextData[ButtonBox["Three\[Hyphen]Dimensional Graphics Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ThreeDimensionalGraphicsDirectives"]], "Tutorials",
 CellID->815154705],

Cell[TextData[ButtonBox["The Structure of Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheStructureOfGraphics"]], "Tutorials",
 CellID->659944600]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Line",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Line"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->123068854],

Cell[TextData[ButtonBox["Graphics Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsObjects"]], "MoreAbout",
 CellID->503603191],

Cell[TextData[ButtonBox["Precollege Education",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecollegeEducation"]], "MoreAbout",
 CellID->1395992],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "MoreAbout",
 CellID->234075441],

Cell[TextData[ButtonBox["New in 6.0: Graphics Primitives & Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]], "MoreAbout",
 CellID->752389891]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Line - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 53, 32.8908948}", "context" -> "System`", 
    "keywords" -> {"polyline", "line segments", "polygonal line", "lines"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Line[{pt_1, pt_2, ...}] is a graphics primitive which represents a line \
joining a sequence of points. Line[{{pt_11, pt_12, ...}, {pt_21, ...}, ...}] \
represents a collection of lines. ", "synonyms" -> {}, "title" -> "Line", 
    "type" -> "Symbol", "uri" -> "ref/Line"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[15063, 439, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->516344809]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 160221, 3968}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3311, 71, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3934, 98, 4188, 83, 70, "ObjectNameGrid"],
Cell[8125, 183, 1605, 50, 70, "Usage",
 CellID->28451]
}, Open  ]],
Cell[CellGroupData[{
Cell[9767, 238, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[10245, 255, 493, 17, 70, "Notes",
 CellID->25432],
Cell[10741, 274, 1029, 39, 70, "Notes",
 CellID->25881],
Cell[11773, 315, 265, 8, 70, "Notes",
 CellID->9575],
Cell[12041, 325, 126, 4, 70, "Notes",
 CellID->12736],
Cell[12170, 331, 788, 27, 70, "Notes",
 CellID->2840],
Cell[12961, 360, 787, 27, 70, "Notes",
 CellID->4436],
Cell[13751, 389, 898, 32, 70, "Notes",
 CellID->24458],
Cell[14652, 423, 374, 11, 70, "Notes",
 CellID->19227]
}, Closed]],
Cell[CellGroupData[{
Cell[15063, 439, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->516344809],
Cell[CellGroupData[{
Cell[15448, 453, 148, 5, 70, "ExampleSection",
 CellID->131769752],
Cell[15599, 460, 60, 1, 70, "ExampleText",
 CellID->552131808],
Cell[CellGroupData[{
Cell[15684, 465, 414, 14, 28, "Input",
 CellID->1973840],
Cell[16101, 481, 264, 7, 75, "Output",
 CellID->484197155]
}, Open  ]],
Cell[CellGroupData[{
Cell[16402, 493, 507, 17, 28, "Input",
 CellID->320913855],
Cell[16912, 512, 1914, 36, 115, 102, 2, "CachedBoxData", "BoxData", "Output",
 CellID->16143279]
}, Open  ]],
Cell[18841, 551, 124, 3, 70, "ExampleDelimiter",
 CellID->84855261],
Cell[18968, 556, 71, 1, 70, "ExampleText",
 CellID->272687774],
Cell[19042, 559, 563, 19, 70, "Input",
 CellID->448259495],
Cell[CellGroupData[{
Cell[19630, 582, 530, 17, 70, "Input",
 CellID->297059210],
Cell[20163, 601, 747, 21, 47, "Output",
 CellID->175696362]
}, Open  ]],
Cell[20925, 625, 123, 3, 70, "ExampleDelimiter",
 CellID->7987048],
Cell[21051, 630, 71, 1, 70, "ExampleText",
 CellID->95422291],
Cell[21125, 633, 524, 18, 70, "Input",
 CellID->303391499],
Cell[CellGroupData[{
Cell[21674, 655, 538, 17, 70, "Input",
 CellID->476177038],
Cell[22215, 674, 7191, 132, 117, "Output",
 CellID->907727]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29455, 812, 216, 7, 70, "ExampleSection",
 CellID->23927],
Cell[CellGroupData[{
Cell[29696, 823, 239, 7, 70, "ExampleSubsection",
 CellID->125713211],
Cell[29938, 832, 62, 1, 70, "ExampleText",
 CellID->91146826],
Cell[CellGroupData[{
Cell[30025, 837, 289, 10, 70, "Input",
 CellID->55162297],
Cell[30317, 849, 248, 7, 99, "Output",
 CellID->123733240]
}, Open  ]],
Cell[30580, 859, 125, 3, 70, "ExampleDelimiter",
 CellID->313197051],
Cell[30708, 864, 76, 1, 70, "ExampleText",
 CellID->826845247],
Cell[CellGroupData[{
Cell[30809, 869, 352, 12, 70, "Input",
 CellID->10146755],
Cell[31164, 883, 255, 7, 64, "Output",
 CellID->97427600]
}, Open  ]],
Cell[31434, 893, 125, 3, 70, "ExampleDelimiter",
 CellID->113594254],
Cell[31562, 898, 79, 1, 70, "ExampleText",
 CellID->253837842],
Cell[31644, 901, 327, 12, 70, "Input",
 CellID->20699716],
Cell[CellGroupData[{
Cell[31996, 917, 210, 7, 70, "Input",
 CellID->660974692],
Cell[32209, 926, 287, 8, 85, "Output",
 CellID->211647418]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[32545, 940, 232, 7, 70, "ExampleSubsection",
 CellID->77444043],
Cell[32780, 949, 195, 7, 70, "ExampleText",
 CellID->258900324],
Cell[CellGroupData[{
Cell[33000, 960, 612, 21, 70, "Input",
 CellID->153708139],
Cell[33615, 983, 532, 16, 75, "Output",
 CellID->257220805]
}, Open  ]],
Cell[CellGroupData[{
Cell[34184, 1004, 538, 19, 70, "Input",
 CellID->706499252],
Cell[34725, 1025, 383, 12, 75, "Output",
 CellID->387026841]
}, Open  ]],
Cell[35123, 1040, 125, 3, 70, "ExampleDelimiter",
 CellID->717252622],
Cell[35251, 1045, 68, 1, 70, "ExampleText",
 CellID->220038262],
Cell[CellGroupData[{
Cell[35344, 1050, 590, 21, 70, "Input",
 CellID->388303278],
Cell[35937, 1073, 455, 14, 78, "Output",
 CellID->105043073]
}, Open  ]],
Cell[36407, 1090, 71, 1, 70, "ExampleText",
 CellID->27522066],
Cell[CellGroupData[{
Cell[36503, 1095, 590, 20, 70, "Input",
 CellID->165797838],
Cell[37096, 1117, 470, 14, 79, "Output",
 CellID->27434985]
}, Open  ]],
Cell[37581, 1134, 124, 3, 70, "ExampleDelimiter",
 CellID->39829922],
Cell[37708, 1139, 176, 7, 70, "ExampleText",
 CellID->696306419],
Cell[CellGroupData[{
Cell[37909, 1150, 610, 21, 70, "Input",
 CellID->919899669],
Cell[38522, 1173, 524, 16, 75, "Output",
 CellID->398612044]
}, Open  ]],
Cell[CellGroupData[{
Cell[39083, 1194, 562, 20, 70, "Input",
 CellID->281025011],
Cell[39648, 1216, 488, 15, 75, "Output",
 CellID->196690892]
}, Open  ]],
Cell[40151, 1234, 125, 3, 70, "ExampleDelimiter",
 CellID->395840683],
Cell[40279, 1239, 179, 7, 70, "ExampleText",
 CellID->171107226],
Cell[CellGroupData[{
Cell[40483, 1250, 570, 20, 70, "Input",
 CellID->198130078],
Cell[41056, 1272, 536, 16, 75, "Output",
 CellID->113204540]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[41641, 1294, 244, 7, 70, "ExampleSubsection",
 CellID->95542222],
Cell[41888, 1303, 302, 12, 70, "ExampleText",
 CellID->199674725],
Cell[CellGroupData[{
Cell[42215, 1319, 437, 14, 70, "Input",
 CellID->155645107],
Cell[42655, 1335, 284, 8, 162, "Output",
 CellID->763743544]
}, Open  ]],
Cell[CellGroupData[{
Cell[42976, 1348, 461, 15, 70, "Input",
 CellID->98388125],
Cell[43440, 1365, 3179, 57, 194, 109, 2, "CachedBoxData", "BoxData", "Output",
 
 CellID->10518890]
}, Open  ]],
Cell[46634, 1425, 125, 3, 70, "ExampleDelimiter",
 CellID->707353207],
Cell[46762, 1430, 211, 8, 70, "ExampleText",
 CellID->32811465],
Cell[CellGroupData[{
Cell[46998, 1442, 447, 14, 70, "Input",
 CellID->469786256],
Cell[47448, 1458, 294, 8, 162, "Output",
 CellID->382809446]
}, Open  ]],
Cell[47757, 1469, 125, 3, 70, "ExampleDelimiter",
 CellID->213028339],
Cell[47885, 1474, 283, 11, 70, "ExampleText",
 CellID->12468032],
Cell[CellGroupData[{
Cell[48193, 1489, 668, 22, 70, "Input",
 CellID->47775883],
Cell[48864, 1513, 302, 8, 169, "Output",
 CellID->435192456]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[49227, 1528, 222, 7, 70, "ExampleSection",
 CellID->4659],
Cell[49452, 1537, 72, 1, 70, "ExampleText",
 CellID->208544288],
Cell[49527, 1540, 525, 18, 70, "Input",
 CellID->24065159],
Cell[CellGroupData[{
Cell[50077, 1562, 135, 4, 70, "Input",
 CellID->211822337],
Cell[50215, 1568, 22669, 376, 70, "Output",
 Evaluatable->False,
 CellID->539977422]
}, Open  ]],
Cell[72899, 1947, 125, 3, 70, "ExampleDelimiter",
 CellID->227796908],
Cell[73027, 1952, 84, 1, 70, "ExampleText",
 CellID->308272457],
Cell[73114, 1955, 145, 5, 70, "Input",
 CellID->333244862],
Cell[73262, 1962, 1078, 36, 70, "Input",
 CellID->61029561],
Cell[CellGroupData[{
Cell[74365, 2002, 405, 14, 70, "Input",
 CellID->31059989],
Cell[74773, 2018, 3630, 64, 201, "Output",
 CellID->437108404]
}, Open  ]],
Cell[78418, 2085, 125, 3, 70, "ExampleDelimiter",
 CellID->331925191],
Cell[78546, 2090, 59, 1, 70, "ExampleText",
 CellID->114014821],
Cell[CellGroupData[{
Cell[78630, 2095, 753, 24, 70, "Input",
 CellID->181855052],
Cell[79386, 2121, 6401, 109, 70, "Output",
 Evaluatable->False,
 CellID->15875574]
}, Open  ]],
Cell[85802, 2233, 125, 3, 70, "ExampleDelimiter",
 CellID->124539022],
Cell[85930, 2238, 77, 1, 70, "ExampleText",
 CellID->314582086],
Cell[CellGroupData[{
Cell[86032, 2243, 607, 20, 70, "Input",
 CellID->525162],
Cell[86642, 2265, 2039, 38, 161, "Output",
 CellID->12032320]
}, Open  ]],
Cell[88696, 2306, 77, 1, 70, "ExampleText",
 CellID->632690008],
Cell[CellGroupData[{
Cell[88798, 2311, 431, 13, 70, "Input",
 CellID->81214253],
Cell[89232, 2326, 6226, 108, 228, 1351, 24, "CachedBoxData", "BoxData", \
"Output",
 CellID->351519468]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[95507, 2440, 232, 7, 70, "ExampleSection",
 CellID->5688],
Cell[95742, 2449, 336, 12, 70, "ExampleText",
 CellID->592292553],
Cell[96081, 2463, 207, 7, 70, "Input",
 CellID->261524770],
Cell[CellGroupData[{
Cell[96313, 2474, 110, 3, 70, "Input",
 CellID->37463606],
Cell[96426, 2479, 550, 17, 146, "Output",
 CellID->762116551]
}, Open  ]],
Cell[96991, 2499, 90, 1, 70, "ExampleText",
 CellID->375562487],
Cell[CellGroupData[{
Cell[97106, 2504, 180, 5, 70, "Input",
 CellID->153055715],
Cell[97289, 2511, 585, 17, 146, "Output",
 CellID->728068574]
}, Open  ]],
Cell[97889, 2531, 77, 1, 70, "ExampleText",
 CellID->631102540],
Cell[CellGroupData[{
Cell[97991, 2536, 129, 4, 70, "Input",
 CellID->264906932],
Cell[98123, 2542, 586, 17, 146, "Output",
 CellID->283059825]
}, Open  ]],
Cell[98724, 2562, 124, 3, 70, "ExampleDelimiter",
 CellID->85279040],
Cell[98851, 2567, 71, 1, 70, "ExampleText",
 CellID->754722668],
Cell[CellGroupData[{
Cell[98947, 2572, 514, 15, 70, "Input",
 CellID->110897748],
Cell[99464, 2589, 3966, 69, 70, "Output",
 Evaluatable->False,
 CellID->516668584]
}, Open  ]],
Cell[103445, 2661, 89, 1, 70, "ExampleText",
 CellID->800763984],
Cell[CellGroupData[{
Cell[103559, 2666, 199, 6, 70, "Input",
 CellID->126772222],
Cell[103761, 2674, 4002, 70, 70, "Output",
 Evaluatable->False,
 CellID->29420609]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[107812, 2750, 226, 7, 70, "ExampleSection",
 CellID->17754],
Cell[108041, 2759, 248, 8, 70, "ExampleText",
 CellID->149194561],
Cell[CellGroupData[{
Cell[108314, 2771, 354, 12, 70, "Input",
 CellID->517940425],
Cell[108671, 2785, 247, 8, 201, "Output",
 CellID->792787008]
}, Open  ]],
Cell[CellGroupData[{
Cell[108955, 2798, 137, 4, 70, "Input",
 CellID->111975066],
Cell[109095, 2804, 161, 5, 36, "Output",
 CellID->57240269]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[109305, 2815, 224, 7, 70, "ExampleSection",
 CellID->13432],
Cell[109532, 2824, 72, 1, 70, "ExampleText",
 CellID->176329113],
Cell[CellGroupData[{
Cell[109629, 2829, 476, 15, 70, "Input",
 CellID->111295440],
Cell[110108, 2846, 14105, 306, 201, "Output",
 CellID->208236448]
}, Open  ]],
Cell[CellGroupData[{
Cell[124250, 3157, 477, 15, 70, "Input",
 CellID->30586822],
Cell[124730, 3174, 13584, 227, 70, "Output",
 Evaluatable->False,
 CellID->893841922]
}, Open  ]],
Cell[138329, 3404, 125, 3, 70, "ExampleDelimiter",
 CellID->221170755],
Cell[138457, 3409, 64, 1, 70, "ExampleText",
 CellID->74389220],
Cell[CellGroupData[{
Cell[138546, 3414, 744, 25, 70, "Input",
 CellID->378344974],
Cell[139293, 3441, 4196, 76, 171, "Output",
 CellID->224820449]
}, Open  ]],
Cell[143504, 3520, 124, 3, 70, "ExampleDelimiter",
 CellID->96329481],
Cell[143631, 3525, 82, 1, 70, "ExampleText",
 CellID->57565437],
Cell[CellGroupData[{
Cell[143738, 3530, 1131, 37, 70, "Input",
 CellID->316243333],
Cell[144872, 3569, 9471, 195, 194, "Output",
 CellID->520132995]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[154404, 3771, 311, 9, 70, "SeeAlsoSection",
 CellID->31379],
Cell[154718, 3782, 1656, 62, 70, "SeeAlso",
 CellID->31955]
}, Open  ]],
Cell[CellGroupData[{
Cell[156411, 3849, 314, 9, 70, "TutorialsSection",
 CellID->23292],
Cell[156728, 3860, 197, 4, 70, "Tutorials",
 CellID->595610080],
Cell[156928, 3866, 197, 4, 70, "Tutorials",
 CellID->815154705],
Cell[157128, 3872, 162, 3, 70, "Tutorials",
 CellID->659944600]
}, Open  ]],
Cell[CellGroupData[{
Cell[157327, 3880, 305, 8, 70, "RelatedLinksSection"],
Cell[157635, 3890, 348, 11, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[158020, 3906, 319, 9, 70, "MoreAboutSection",
 CellID->123068854],
Cell[158342, 3917, 143, 3, 70, "MoreAbout",
 CellID->503603191],
Cell[158488, 3922, 149, 3, 70, "MoreAbout",
 CellID->1395992],
Cell[158640, 3927, 162, 3, 70, "MoreAbout",
 CellID->234075441],
Cell[158805, 3932, 197, 4, 70, "MoreAbout",
 CellID->752389891]
}, Open  ]],
Cell[159017, 3939, 50, 0, 70, "History"],
Cell[159070, 3941, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

