(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33923,       1021]
NotebookOptionsPosition[     28586,        843]
NotebookOutlinePosition[     30198,        887]
CellTagsIndexPosition[     30080,        881]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Text and Font Options" :> 
          Documentation`HelpLookup["paclet:tutorial/TextAndFontOptions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Text and Font Options\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FontSize" :> Documentation`HelpLookup["paclet:ref/FontSize"], 
          "ParagraphSpacing" :> 
          Documentation`HelpLookup["paclet:ref/ParagraphSpacing"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FontSize\"\>", 
       2->"\<\"ParagraphSpacing\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Stylesheets" :> 
          Documentation`HelpLookup["paclet:guide/Stylesheets"], 
          "Text Layout Options" :> 
          Documentation`HelpLookup["paclet:guide/TextLayoutOptions"], 
          "Text Styling" :> 
          Documentation`HelpLookup["paclet:guide/TextStyling"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Stylesheets\"\>", 
       2->"\<\"Text Layout Options\"\>", 
       3->"\<\"Text Styling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["LineSpacing", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["LineSpacing",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LineSpacing"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Style",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Style"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " which specifies the spacing between successive lines of text. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32661]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"LineSpacing", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["c", "TI"], ",", "0"}], "}"}]}]], "InlineFormula"],
 " leaves space so that the total height of each line is ",
 Cell[BoxData[
  StyleBox["c", "TI"]], "InlineFormula"],
 " times the height of its contents. "
}], "Notes",
 CellID->28280],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"LineSpacing", "->", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     StyleBox["n", "TI"]}], "}"}]}]], "InlineFormula"],
 " makes the total height of each line exactly ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " printer\[CloseCurlyQuote]s points. "
}], "Notes",
 CellID->21527],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"LineSpacing", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["c", "TI"], ",", 
     StyleBox["n", "TI"]}], "}"}]}]], "InlineFormula"],
 " makes the total height ",
 Cell[BoxData[
  StyleBox["c", "TI"]], "InlineFormula"],
 " times the height of the contents plus ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " printer\[CloseCurlyQuote]s points. "
}], "Notes",
 CellID->22039],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"LineSpacing", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["c", "TI"], ",", 
     StyleBox["n", "TI"], ",", 
     StyleBox["max", "TI"]}], "}"}]}]], "InlineFormula"],
 " limits the amount of extra space to be ",
 Cell[BoxData[
  StyleBox["max", "TI"]], "InlineFormula"],
 " times the height of a single line of ordinary text in the current font. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->6771],

Cell[TextData[{
 "A typical default setting for text is ",
 Cell[BoxData[
  RowBox[{"LineSpacing", "->", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}]], "InlineFormula"],
 ", which leaves space for the contents of the line, plus 1 printer\
\[CloseCurlyQuote]s point (approximately ",
 Cell[BoxData[
  FractionBox[
   StyleBox["1",
    FontFamily->"Verdana"], 
   StyleBox["72",
    FontFamily->"Verdana"]]], "InlineFormula"],
 " of an inch) of extra space. "
}], "Notes",
 CellID->1402],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"LineSpacing", "->", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0"}], "}"}]}]], "InlineFormula"],
 " makes text \[OpenCurlyDoubleQuote]double spaced\[CloseCurlyDoubleQuote]. "
}], "Notes",
 CellID->5761],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"LineSpacing", "->", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", 
      StyleBox["n", "TI"]}]}], "}"}]}]], "InlineFormula"],
 " tightens text by ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " printer\[CloseCurlyQuote]s points. "
}], "Notes",
 CellID->15815],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LineSpacing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LineSpacing"]], "InlineFormula"],
 " applies both to ordinary text and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions, including graphics. "
}], "Notes",
 CellID->1749],

Cell[TextData[{
 "A typical default setting for general ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions is ",
 Cell[BoxData[
  RowBox[{"LineSpacing", "->", 
   RowBox[{"{", 
    RowBox[{"1.25", ",", "0", ",", "2"}], "}"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->17722],

Cell[TextData[{
 "In ordinary text, ",
 Cell[BoxData[
  ButtonBox["LineSpacing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LineSpacing"]], "InlineFormula"],
 " determines the spacing between lines produced by automatic linebreaking. \
For lines produced by explicit ",
 StyleBox["Return", "KeyEvent"],
 " characters, ",
 Cell[BoxData[
  ButtonBox["ParagraphSpacing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParagraphSpacing"]], "InlineFormula"],
 " is added. "
}], "Notes",
 CellID->31434],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions, ",
 Cell[BoxData[
  ButtonBox["LineSpacing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LineSpacing"]], "InlineFormula"],
 " is used whether lines are produced by automatic linebreaking or by \
explicit ",
 StyleBox["Return", "KeyEvent"],
 " characters. "
}], "Notes",
 CellID->3985],

Cell[TextData[{
 "Extra space specified by ",
 Cell[BoxData[
  ButtonBox["LineSpacing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LineSpacing"]], "InlineFormula"],
 " is inserted equally above and below a line, except that no extra space is \
inserted before the first line or after the last line of an expression or \
cell. "
}], "Notes",
 CellID->22988]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->258208879],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->102314860],

Cell["Double spacing:", "ExampleText",
 CellID->49411886],

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "=", 
   RowBox[{"StringJoin", "@@", 
    RowBox[{"Table", "[", 
     RowBox[{"\"\<abcde \>\"", ",", 
      RowBox[{"{", "40", "}"}]}], "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->320669149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "@", 
  RowBox[{"Text", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"t", ",", 
     RowBox[{"LineSpacing", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"2", ",", "0"}], "}"}]}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->525120996],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnN1OgzAYhstgG0Y9cwme7Wr0yDPjTzwii8l2YDRzt7dEr6z2hw6cxRiI
s8WHBOjXfu8zGFAKb8JVuVk+PpWb1aKcX67Ll+Vq8Tq/eF6rqjQRInkTQtwV
QpWlKplZT+9qVuU0z3NhJx1u1ZzYqtRlSrPaqjmxidG3zNQi03WZ/ROqBBWM
qvXYVVRtExQoglAcec/oM72Y1LEpOGG6C8VoL/6uXRdHcOHChXtgru4Xu/dy
pjOd7vKaqWIKAwaMgzKOZdsoPBUOZZP3+4ns86/vEvWYaYwePfrO+ly23mPH
dVxxxdd7uC/WeWbDmgC7FTBhwoTZkenvrWZVvuFkNcd2immTmDWJumaCFi1a
U+N/q3gu66tTF0+Io4r9z10c1bhj/1EtpL2STwe8DtFLpCXsFrxeFLEq8Hrh
woU7bC5eLwwYQ2Hg9aJHH5oerxcmTJhxMPF60aLF6yX+eYzXO8QYr7fea70I
1WWkJYQWfe8Lz8VDEbvi1nu2xeazwIUL93Dca9mn14jB64EB47cZ97JtpJcK
h7LJMfkx6NH30d/I1ntLBO/3YcKE2Z/p7wXck2xMngRatG1a/9sXM7ZsxH/9
pv6/xf5xOUclxKPirr4QfJ0u6wfvXulFqE7EfktRFLZUf2XVVOm86kusyQcd
GGiH\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{448, 88},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->88145051]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->747777131],

Cell["Make the height of each line 10 printer's points: ", "ExampleText",
 CellID->643382238],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "@", 
  RowBox[{"Text", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"t", ",", 
     RowBox[{"LineSpacing", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}]}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->125698937],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnM9Og0AQh5cubTHqzSZ46yP4FHryZjTGE2lM2oPR1L5eE32ydf+wBeti
DI0tSz8SYGeZ31coMCwzCbfFav78UqwWs2J6syze5ovZ+/T6dam7ZCJE8iGE
uMqFbivdsrOZPvWs2zLLMuEmY671nLgu6T2VXa31nDjH6LdM9CI1fan7E0oH
bQzK9dB3lNtGKFB0QnESvKIvzGJU2bbhhXJjisGW/dt20xzAhQsX7p65Ji62
j3I2mI43fnVXMYYBA8ZeGaeqaRQuhUc55+04kX7/9Y2jGTMN0aNH31qfqcZn
7LCyS674+QwP2cbP7lgd4PYCJkyYMFsyw9FqUvpbTlpxXFCUdWJaJ5qeEVq0
aG1POKt4qaq70zTPsKOyw+9dnNW47fBZzZW7k897vKbGh+IYFNT44MKF228u
NT4YMPrCoMaHHn3X9NT4YMKEGQeTGh9atNT4sP9uU+Pro02NrzpqswjX+EzM
6171BkXsiofg1RZbfh0uXLj7496pXaJGDDl+GDD+m/GomkZ6UniUc44pD48e
/S76e9X4bIkgrwsTJszdmeEo4N9kY8pFo0XbpA1nX+zYsmYfOkN7bHZ4XM5Z
6eJZ8XdfF/L5bdZPwaMyi65+UXB7S57nrlV9VdF2Gb/yy4vJFwoqRCE=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{448, 48},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->365909371]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->64897720],

Cell["\<\
Single spacing with 5 printer's point of extra space added to each line:\
\>", "ExampleText",
 CellID->779543827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "@", 
  RowBox[{"Text", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"t", ",", 
     RowBox[{"LineSpacing", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1", ",", "5"}], "}"}]}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->105787743],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnF1PwjAUhjs2YEa9k2Te8WOMXnlnNMarhZjABdEgf49Ef1ntx8omdsaM
CO18SLb1tOd9+Bg7K30Tbsv1/HlZrhezcnqzKl/ni9nb9PplpbrSRIjkXQhx
VQjVlqplNv34UJtqp3meC/vQ4UZtie1KXaY0h43aEpsY/chE7TLdl9kPoUpQ
waA6Dl1HNTZCgSIIxYn3G32hd6M6Ng0nTLehGOzEP43r5gAuXLhwD8zVdbF7
lTPFdLzNa6aKMQwYMA7KOJVts/BUOJRN3q0T2ddn3ybqOdMQPXr0nfW5bL3H
Duu44orv93BfrPPMC2sC7KuACRMmzI5Mf7WaVPmGk9UcWxTTJjFrEnXPCC1a
tKbHv6p4KeurUzfPiKOK/b+7OKtxx/6zWkh7JZ/3+BiilxjyCD4nilgV+Jxw
4cLtNxefEwaMvjDwOdGjD02PzwkTJsw4mPicaNHicxL/Psbn7GOMz1m/a70L
1WU8/oiu++E5WChiVzx4v22xeQxw4cI9HPdO7lM1YvA5YMD4a8ajbJvppcKh
bHJMXgR69Pvo72XrvSWCtW2YMGHuz/RXAfdLNqb1eLRo27T+1Rczt2zEx16l
/m+xf17OWQnxrLirLwRPo8vxyfuu9C5UJ2J3pCgK26r/XdN06bzqHziTT4Jo
VlQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{448, 68},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4612605]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18781],

Cell["Limit the line space to be half the height of a single line:", \
"ExampleText",
 CellID->370877752],

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "=", 
   RowBox[{"StringJoin", "@@", 
    RowBox[{"Table", "[", 
     RowBox[{"\"\<abcde \>\"", ",", 
      RowBox[{"{", "40", "}"}]}], "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->292361605],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "@", 
  RowBox[{"Text", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"t", ",", 
     RowBox[{"LineSpacing", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"2", ",", "0", ",", 
        RowBox[{"1", "/", "2"}]}], "}"}]}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->114084118],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnN1KwzAYhtOl2yrqmYN6tqtREDwTRTwqQ9gORJm7vYFeWcxPu9aZinS4
Jd1TaJsv+d5n7bqmWV7obbGaP78Uq8WsmF4vi7f5YvY+vXpd6iqZCJF8CCFu
cqHLSpfsapZPveqyzLJMuMWEa70mrkpWmcru1npNXGL0LRO9SU1d6r6EMkEH
g3I/rCrKthEKFEEoTry/6AuzGdWxLVRCuQnFYCv+rd0UB3DhwoW7Z67pF7v3
crYzHW/ymqliDAMGjL0yTlXbKFyKCuWSt/uJ9PunbxLNmGmIHj36zvpMtT5j
h3VccsXPZ7gvNnn2wJoAdxQwYcKE2ZHp760mZb7lpDXHdYqySUybRFMzQosW
ra3xzypeqvruNMUz4qhi//8urmrcsf+q5srdyec93ofoJR5PC64pilgVuKZw
4cLtNxfXFAaMvjBwTdGjD02PawoTJsw4mLimaNHimhL/PcY17WOMa1qftdmE
6jL2rcU8RcLzw1DErnjw/tpicyzgwoW7P+6d2qXXiME1gQHjvxmPqm2kJ0WF
cskxORvo0e+iv1etz5YIZsphwoS5O9PfC1T/ZGOa3UeLtk3rn32xY8tGfOg5
72OL/eNyrkqIV6W6+0JwSLrsn7xnZTahOhHbLXmeu1L95k9bZfLKt4MmX7EG
qJI=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{448, 74},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->465063248]
}, Open  ]],

Cell["Tighten text by 3 printer's points:", "ExampleText",
 CellID->217859946],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "@", 
  RowBox[{"Text", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"t", ",", 
     RowBox[{"LineSpacing", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "3"}]}], "}"}]}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->31717419],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnN9OgzAUh8vKNox65xK820P4DHrlndEYr8hisl0YzdzrLdEnq/1DB85i
DOik20dS2lPO7xsMOJSehOtiNX98KlaLWTG9WhYv88XsdXr5vNRdMhEieRNC
XORCt5Vu2WKWd110W2ZZJtxizLUuieuS3lPZaq1L4hyj3zLRq9T0pe5PKB20
MSjroe8ot41QoOiF4ih4RZ+Z1aiybcML5cYUgy37u+2mOYALFy7cHXNNXGwf
5WwwHW/86q5iDAMGjJ0yjlXTKFwKj3LO23Ei/fzrG0czZhqiR4++tT5Tjc/Y
YWWXXPH1GR6yjZ/dsTrA7QVMmDBhtmSGo9Wk9LectOK4oCjrxLROND0jtGjR
2p7wrOK5qu5O0zzBjsoOv3dxVuO2w2c1V+5OPt3jmrwgChTkBeHChXuIXPKC
MGDsC4O8IHr0fdOTF4QJE2YcTPKCaNGSF8T+uU1ecB9t8oLVUZvV7+UFTZzs
X8YHReyKu+DVFtucPFy4cHfHvVFdokYMeQEYMP6aca+aRnpSeJRzjmnuHj36
Lvpb1fhsiWAuGCZMmN2Z4Sjg32Rjmr9Gi7ZJG559sWPLmv3fs7qHZofH5ZyV
Pp4Vf/f1IQfQpn4IHpVZ9fXLhdtb8jx3rerrjbbL+JVfeEw+ACmzevU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{448, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->553349593]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->79870146],

Cell["Create a notebook with double spacing:", "ExampleText",
 CellID->622411107],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"ExpressionCell", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", "\"\<Input\>\"", ",", 
      RowBox[{"LineSpacing", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0"}], "}"}]}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14917052],

Cell[TextData[{
 "When you press the ",
 Cell[BoxData[
  FormBox[
   DynamicBox[ToBoxes[
     If[$OperatingSystem === "MacOSX", "Return", "Enter"], StandardForm],
    ImageSizeCache->{36., {0., 8.}}], TraditionalForm]], "KeyEvent",
  ShowStringCharacters->False],
 " key, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " leaves two times the height of each line:"
}], "ExampleText",
 CellID->128077075],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3etzVPUdx/Ht9LGN/0Kf53EZieOlWCePdNoBGYUh2TQJIKNWZ6ftDIyt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   "], {{0, 0}, {508, 189}}, {0, 255}],
  ImageSize->{508 0.75, 189 0.75},
  PlotRange->{{0, 508}, {0, 189}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->232821403]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24044],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FontSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FontSize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ParagraphSpacing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ParagraphSpacing"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7249]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9884],

Cell[TextData[ButtonBox["Text and Font Options",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TextAndFontOptions"]], "Tutorials",
 CellID->11798]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->1275784],

Cell[TextData[ButtonBox["Stylesheets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Stylesheets"]], "MoreAbout",
 CellID->676652226],

Cell[TextData[ButtonBox["Text Layout Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TextLayoutOptions"]], "MoreAbout",
 CellID->178168885],

Cell[TextData[ButtonBox["Text Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TextStyling"]], "MoreAbout",
 CellID->11796338]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LineSpacing - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 53, 34.5159364}", "context" -> "System`", 
    "keywords" -> {
     "\\baselineskip (TeX)", "double-spaced text", "double spacing", 
      "fixed spacing", "interline spacing", "leading", "\\linespread (TeX)", 
      "looseness", "skip", "spacing", "tightness"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LineSpacing is an option for Style and Cell which specifies the spacing \
between successive lines of text. ", "synonyms" -> {"line spacing"}, "title" -> 
    "LineSpacing", "type" -> "Symbol", "uri" -> "ref/LineSpacing"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12954, 388, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->258208879]},
 "Notebook Image"->{
  Cell[22047, 680, 4333, 74, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->232821403]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 29810, 870},
 {"Notebook Image", 29952, 874}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2101, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2724, 79, 4195, 83, 70, "ObjectNameGrid"],
Cell[6922, 164, 748, 23, 70, "Usage",
 CellID->32661]
}, Open  ]],
Cell[CellGroupData[{
Cell[7707, 192, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8185, 209, 343, 11, 70, "Notes",
 CellID->28280],
Cell[8531, 222, 334, 11, 70, "Notes",
 CellID->21527],
Cell[8868, 235, 436, 15, 70, "Notes",
 CellID->22039],
Cell[9307, 252, 553, 16, 70, "Notes",
 CellID->6771],
Cell[9863, 270, 495, 16, 70, "Notes",
 CellID->1402],
Cell[10361, 288, 242, 7, 70, "Notes",
 CellID->5761],
Cell[10606, 297, 329, 12, 70, "Notes",
 CellID->15815],
Cell[10938, 311, 295, 10, 70, "Notes",
 CellID->1749],
Cell[11236, 323, 427, 14, 70, "Notes",
 CellID->17722],
Cell[11666, 339, 505, 16, 70, "Notes",
 CellID->31434],
Cell[12174, 357, 378, 14, 70, "Notes",
 CellID->3985],
Cell[12555, 373, 362, 10, 70, "Notes",
 CellID->22988]
}, Closed]],
Cell[CellGroupData[{
Cell[12954, 388, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->258208879],
Cell[CellGroupData[{
Cell[13339, 402, 148, 5, 70, "ExampleSection",
 CellID->102314860],
Cell[13490, 409, 57, 1, 70, "ExampleText",
 CellID->49411886],
Cell[13550, 412, 245, 8, 70, "Input",
 CellID->320669149],
Cell[CellGroupData[{
Cell[13820, 424, 283, 9, 28, "Input",
 CellID->525120996],
Cell[14106, 435, 886, 19, 109, "Output",
 Evaluatable->False,
 CellID->88145051]
}, Open  ]],
Cell[15007, 457, 125, 3, 70, "ExampleDelimiter",
 CellID->747777131],
Cell[15135, 462, 93, 1, 70, "ExampleText",
 CellID->643382238],
Cell[CellGroupData[{
Cell[15253, 467, 284, 9, 28, "Input",
 CellID->125698937],
Cell[15540, 478, 878, 18, 69, "Output",
 Evaluatable->False,
 CellID->365909371]
}, Open  ]],
Cell[16433, 499, 124, 3, 70, "ExampleDelimiter",
 CellID->64897720],
Cell[16560, 504, 123, 3, 70, "ExampleText",
 CellID->779543827],
Cell[CellGroupData[{
Cell[16708, 511, 283, 9, 28, "Input",
 CellID->105787743],
Cell[16994, 522, 885, 19, 89, "Output",
 Evaluatable->False,
 CellID->4612605]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17928, 547, 216, 7, 70, "ExampleSection",
 CellID->18781],
Cell[18147, 556, 105, 2, 70, "ExampleText",
 CellID->370877752],
Cell[18255, 560, 245, 8, 70, "Input",
 CellID->292361605],
Cell[CellGroupData[{
Cell[18525, 572, 322, 10, 70, "Input",
 CellID->114084118],
Cell[18850, 584, 887, 19, 70, "Output",
 Evaluatable->False,
 CellID->465063248]
}, Open  ]],
Cell[19752, 606, 78, 1, 70, "ExampleText",
 CellID->217859946],
Cell[CellGroupData[{
Cell[19855, 611, 306, 10, 70, "Input",
 CellID->31717419],
Cell[20164, 623, 878, 18, 70, "Output",
 Evaluatable->False,
 CellID->553349593]
}, Open  ]],
Cell[21057, 644, 124, 3, 70, "ExampleDelimiter",
 CellID->79870146],
Cell[21184, 649, 81, 1, 70, "ExampleText",
 CellID->622411107],
Cell[21268, 652, 365, 11, 70, "Input",
 CellID->14917052],
Cell[21636, 665, 408, 13, 70, "ExampleText",
 CellID->128077075],
Cell[22047, 680, 4333, 74, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->232821403]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26429, 760, 311, 9, 70, "SeeAlsoSection",
 CellID->24044],
Cell[26743, 771, 466, 17, 70, "SeeAlso",
 CellID->7249]
}, Open  ]],
Cell[CellGroupData[{
Cell[27246, 793, 313, 9, 70, "TutorialsSection",
 CellID->9884],
Cell[27562, 804, 150, 3, 70, "Tutorials",
 CellID->11798]
}, Open  ]],
Cell[CellGroupData[{
Cell[27749, 812, 317, 9, 70, "MoreAboutSection",
 CellID->1275784],
Cell[28069, 823, 134, 3, 70, "MoreAbout",
 CellID->676652226],
Cell[28206, 828, 148, 3, 70, "MoreAbout",
 CellID->178168885],
Cell[28357, 833, 134, 3, 70, "MoreAbout",
 CellID->11796338]
}, Open  ]],
Cell[28506, 839, 50, 0, 70, "History"],
Cell[28559, 841, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

