(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     85711,       3113]
NotebookOptionsPosition[     71159,       2604]
NotebookOutlinePosition[     72865,       2648]
CellTagsIndexPosition[     72779,       2643]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Solving Linear Systems" :> 
          Documentation`HelpLookup["paclet:tutorial/SolvingLinearSystems"], 
          "Linear Algebra in Mathematica" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LinearAlgebraOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Solving Linear Systems\"\>", 
       2->"\<\"Linear Algebra in Mathematica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Inverse" :> Documentation`HelpLookup["paclet:ref/Inverse"], 
          "Solve" :> Documentation`HelpLookup["paclet:ref/Solve"], 
          "NullSpace" :> Documentation`HelpLookup["paclet:ref/NullSpace"], 
          "CoefficientArrays" :> 
          Documentation`HelpLookup["paclet:ref/CoefficientArrays"], 
          "CholeskyDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/CholeskyDecomposition"], 
          "PseudoInverse" :> 
          Documentation`HelpLookup["paclet:ref/PseudoInverse"], 
          "LeastSquares" :> 
          Documentation`HelpLookup["paclet:ref/LeastSquares"], "RowReduce" :> 
          Documentation`HelpLookup["paclet:ref/RowReduce"], 
          "LinearSolveFunction" :> 
          Documentation`HelpLookup["paclet:ref/LinearSolveFunction"], 
          "MatrixPower" :> 
          Documentation`HelpLookup["paclet:ref/MatrixPower"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Inverse\"\>", 2->"\<\"Solve\"\>", 
       3->"\<\"NullSpace\"\>", 4->"\<\"CoefficientArrays\"\>", 
       5->"\<\"CholeskyDecomposition\"\>", 6->"\<\"PseudoInverse\"\>", 
       7->"\<\"LeastSquares\"\>", 8->"\<\"RowReduce\"\>", 
       9->"\<\"LinearSolveFunction\"\>", 
       10->"\<\"MatrixPower\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Equation Solving" :> 
          Documentation`HelpLookup["paclet:guide/EquationSolving"], 
          "Linear Systems" :> 
          Documentation`HelpLookup["paclet:guide/LinearSystems"], 
          "Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Matrix Operations" :> 
          Documentation`HelpLookup["paclet:guide/MatrixOperations"], 
          "Signal Processing" :> 
          Documentation`HelpLookup["paclet:guide/SignalProcessing"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Equation Solving\"\>", 
       2->"\<\"Linear Systems\"\>", 3->"\<\"Matrices and Linear Algebra\"\>", 
       4->"\<\"Matrix Operations\"\>", 5->"\<\"Signal Processing\"\>", 
       6->"\<\"New in 6.0: Mathematics & Algorithms\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LinearSolve", "ObjectName",
 CellID->13200],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LinearSolve",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LinearSolve"], "[", 
       RowBox[{
        StyleBox["m", "TI"], ",", 
        StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]finds an ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " which solves the matrix equation ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        StyleBox["m", "TI"], ".", 
        StyleBox["x", "TI"]}], "==", 
       StyleBox["b", "TI"]}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LinearSolve",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LinearSolve"], "[", 
       StyleBox["m", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["LinearSolveFunction",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LinearSolveFunction"], "[", 
       StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
     " which can be applied repeatedly to different ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->5289]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 " works on both numerical and symbolic matrices, as well as ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->11663],

Cell[TextData[{
 "The argument ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " can be either a vector or a matrix. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->346530297,
  ButtonNote->"346530297"]
}], "Notes",
 CellID->28223],

Cell[TextData[{
 "The matrix ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " can be square or rectangular. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->122153443,
  ButtonNote->"122153443"]
}], "Notes",
 CellID->2615],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinearSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinearSolve"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinearSolveFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinearSolveFunction"], "[", 
   StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
 " provide an efficient way to solve the same approximate numerical linear \
system many times. "
}], "Notes",
 CellID->23460],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinearSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinearSolve"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"LinearSolve", "[", 
    StyleBox["m", "TI"], "]"}], "[", 
   StyleBox["b", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->30992],

Cell[TextData[{
 "For underdetermined systems, ",
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 " will return one of the possible solutions; ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " will return a general solution. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->308488225,
  ButtonNote->"308488225"]
}], "Notes",
 CellID->9892],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinearSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinearSolve"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    StyleBox["b", "TI"], ",", 
    RowBox[{
     ButtonBox["Modulus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Modulus"], "->", 
     StyleBox["n", "TI"]}]}], "]"}]], "InlineFormula"],
 " takes the matrix equation to be modulo ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->222012567,
  ButtonNote->"222012567"]
}], "Notes",
 CellID->7050],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinearSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinearSolve"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    StyleBox["b", "TI"], ",", 
    RowBox[{
     ButtonBox["ZeroTest",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ZeroTest"], "->", 
     StyleBox["test", "TI"]}]}], "]"}]], "InlineFormula"],
 " evaluates ",
 Cell[BoxData[
  RowBox[{
   StyleBox["test", "TI"], "[", 
   RowBox[{
    StyleBox["m", "TI"], "[", 
    RowBox[{"[", 
     RowBox[{
      StyleBox["i", "TI"], ",", 
      StyleBox["j", "TI"]}], "]"}], "]"}], "]"}]], "InlineFormula"],
 " to determine whether matrix elements are zero. The default setting is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ZeroTest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ZeroTest"], "->", "Automatic"}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->22114],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " option can also be given. Settings for exact and symbolic matrices include \
",
 Cell[BoxData["\"\<CofactorExpansion\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<DivisionFreeRowReduction\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<OneStepRowReduction\>\""], "InlineFormula"],
 ". Settings for approximate numerical matrices include ",
 Cell[BoxData["\"\<Cholesky\>\""], "InlineFormula"],
 ", and for sparse arrays ",
 Cell[BoxData["\"\<Multifrontal\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<Krylov\>\""], "InlineFormula"],
 ". The default setting of ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " switches among these methods depending on the matrix given. "
}], "Notes",
 CellID->25067]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->59607972],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->524548177],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->142520274],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"d", " ", "x"}], "-", 
     RowBox[{"b", " ", "y"}]}], 
    RowBox[{
     RowBox[{
      RowBox[{"-", "b"}], " ", "c"}], "+", 
     RowBox[{"a", " ", "d"}]}]], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"c", " ", "x"}], "-", 
     RowBox[{"a", " ", "y"}]}], 
    RowBox[{
     RowBox[{"b", " ", "c"}], "-", 
     RowBox[{"a", " ", "d"}]}]]}], "}"}]], "Output",
 ImageSize->{139, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->721156261]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->411692487],

Cell[TextData[{
 "With no right\[Hyphen]hand side, a ",
 Cell[BoxData[
  ButtonBox["LinearSolveFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolveFunction"]], "InlineFormula"],
 " is returned:"
}], "ExampleText",
 CellID->55534934],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", "=", 
  RowBox[{"LinearSolve", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->46914770],

Cell[BoxData[
 TagBox[
  RowBox[{"LinearSolveFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->53712882]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", "[", 
  RowBox[{"{", 
   RowBox[{"5", ",", "6"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->86469674],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "4"}], ",", 
   FractionBox["9", "2"]}], "}"}]], "Output",
 ImageSize->{55, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4914524]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->437348419],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "4"}], ",", 
   FractionBox["9", "2"]}], "}"}]], "Output",
 ImageSize->{55, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->169237187]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5055],

Cell[TextData[{
 "Find the solution ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["m", "TI"], ".", 
    StyleBox["x", "TI"]}], " ", "=", " ", 
   StyleBox["b", "TI"]}]], "InlineFormula"],
 " with exact arithmetic:"
}], "ExampleText",
 CellID->419679908],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4", ",", "9"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], ";"}], "\n", 
 RowBox[{"LinearSolve", "[", 
  RowBox[{"m", ",", "b"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->241293362],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], ",", "2", ",", 
   RowBox[{"-", 
    FractionBox["1", "2"]}]}], "}"}]], "Output",
 ImageSize->{85, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->230881774]
}, Open  ]],

Cell["\<\
Find the solution using numerical methods with machine numbers:\
\>", "ExampleText",
 CellID->181691984],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearSolve", "[", 
  RowBox[{
   RowBox[{"N", "[", "m", "]"}], ",", 
   RowBox[{"N", "[", "b", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->205635973],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.5000000000000002`"}], ",", "2.0000000000000004`", ",", 
   RowBox[{"-", "0.5000000000000002`"}]}], "}"}]], "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->547582856]
}, Open  ]],

Cell["\<\
Find the solution using numerical methods with 20\[Hyphen]digit arithmetic:\
\>", "ExampleText",
 CellID->85381944],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearSolve", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"m", ",", "20"}], "]"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{"b", ",", "20"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->72151486],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.5`20."}], ",", "2.`20.", ",", 
   RowBox[{"-", "0.5`20."}]}], "}"}]], "Output",
 ImageSize->{511, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->279576092]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->956256033],

Cell["Find a solution even when the matrix is singular:", "ExampleText",
 CellID->96757593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->343066684],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2"}], ",", "2", ",", "0"}], "}"}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->362967152]
}, Open  ]],

Cell["In this case there is no solution:", "ExampleText",
 CellID->212137539],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "2"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->430156023],

Cell[BoxData[
 RowBox[{
  RowBox[{"LinearSolve", "::", "\<\"nosol\"\>"}], ":", 
  " ", "\<\"Linear equation encountered that has no solution. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/LinearSolve/nosol\\\", \
ButtonNote -> \\\"LinearSolve::nosol\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->475875466],

Cell[BoxData[
 RowBox[{"LinearSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "2"}], ",", "1"}], "}"}]}], "]"}]], "Output",
 ImageSize->{380, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->69345192]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->662308102],

Cell["Find a solution for a rectangular matrix:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->122153443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "6", ",", "7", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "10", ",", "11", ",", "12"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "14", ",", "15"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->114867240],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["25", "2"]}], ",", 
   FractionBox["51", "4"], ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{110, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->490975034]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19866],

Cell[TextData[{
 "Solve ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["m", "TI"], ".", 
    StyleBox["x", "TI"]}], " ", "=", " ", 
   StyleBox["b", "TI"]}]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " when ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " is a matrix:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->346530297],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4", ",", "9"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "6"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"LinearSolve", "[", 
  RowBox[{"m", ",", "b"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->139154922],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->679958285]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->516201730],

Cell[TextData[{
 "When no right\[Hyphen]hand side ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["m", "TI"], ".", 
    StyleBox["x", "TI"]}], " ", "=", " ", 
   StyleBox["b", "TI"]}]], "InlineFormula"],
 " is given, a ",
 Cell[BoxData[
  ButtonBox["LinearSolveFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolveFunction"]], "InlineFormula"],
 " is returned:"
}], "ExampleText",
 CellID->274225114],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4", ",", "9"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"f", "=", 
  RowBox[{"LinearSolve", "[", "m", "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->42493765],

Cell[BoxData[
 TagBox[
  RowBox[{"LinearSolveFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->615599975]
}, Open  ]],

Cell[TextData[{
 "This contains data to solve the problem quickly for a given value of ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->104314392],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->184729738],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], ",", "2", ",", 
   RowBox[{"-", 
    FractionBox["1", "2"]}]}], "}"}]], "Output",
 ImageSize->{85, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->93939893]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->418990341],

Cell["Sparse methods are used for sparse matrices:", "ExampleText",
 CellID->275476936],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"s", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "i_"}], "}"}], "\[Rule]", 
        RowBox[{"-", "2."}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{"i", "-", "j"}], "]"}], "\[Equal]", "1"}]}], "\[Rule]", 
        "1."}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"999", ",", "999"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", "999", "}"}]}], "]"}]}], ";", 
  RowBox[{
   RowBox[{"b", "[", 
    RowBox[{"[", "499", "]"}], "]"}], "=", "1"}], ";"}], "\n", 
 RowBox[{"ListPlot", "[", 
  RowBox[{"LinearSolve", "[", 
   RowBox[{"s", ",", "b"}], "]"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->533014834],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->543896100]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27513],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Method",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->23224],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " is a large sparse matrix:"
}], "ExampleText",
 CellID->133779876],

Cell[BoxData[{
 RowBox[{
  RowBox[{"s", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "i_"}], "}"}], "\[Rule]", 
        RowBox[{"-", "2."}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{"i", "-", "j"}], "]"}], "\[Equal]", "1"}]}], "\[Rule]", 
        "1."}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"19999", ",", "19999"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0.", ",", 
     RowBox[{"{", "19999", "}"}]}], "]"}]}], ";", 
  RowBox[{
   RowBox[{"b", "[", 
    RowBox[{"[", "9999", "]"}], "]"}], "=", "1."}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->260416927],

Cell[TextData[{
 "Solve ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["s", "TI"], ".", 
    StyleBox["x", "TI"]}], " ", "=", " ", 
   StyleBox["b", "TI"]}]], "InlineFormula"],
 " using a direct multifrontal method:"
}], "ExampleText",
 CellID->308318901],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"xm", "=", 
    RowBox[{"LinearSolve", "[", 
     RowBox[{"s", ",", "b", ",", 
      RowBox[{"Method", "\[Rule]", "\"\<Multifrontal\>\""}]}], "]"}]}], ";"}],
   "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->443831889],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.36099999999999993`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->355022946]
}, Open  ]],

Cell[TextData[{
 "Solve ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["s", "TI"], ".", 
    StyleBox["x", "TI"]}], " ", "=", " ", 
   StyleBox["b", "TI"]}]], "InlineFormula"],
 " using an iterative Krylov subspace method:"
}], "ExampleText",
 CellID->515241404],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"xk", "=", 
    RowBox[{"LinearSolve", "[", 
     RowBox[{"s", ",", "b", ",", 
      RowBox[{"Method", "\[Rule]", "\"\<Krylov\>\""}]}], "]"}]}], ";"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->112807183],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.08000000000000035`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->324470044]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modulus",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->28886],

Cell[TextData[{
 "Find the solution ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["m", "TI"], ".", 
    StyleBox["x", "TI"]}], " ", "=", " ", 
   StyleBox["b", "TI"]}]], "InlineFormula"],
 " modulo 47:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->222012567],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4", ",", "9"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], ";"}], "\n", 
 RowBox[{"LinearSolve", "[", 
  RowBox[{"m", ",", "b", ",", 
   RowBox[{"Modulus", "\[Rule]", "47"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->462119316],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"23", ",", "2", ",", "23"}], "}"}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->303224149]
}, Open  ]],

Cell["Verify the solution.", "ExampleText",
 CellID->145753576],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mod", "[", 
  RowBox[{
   RowBox[{"m", ".", "%"}], ",", "47"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->308180616],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->433410927]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27080],

Cell["\<\
Newton's method for finding a root of a multivariate function:\
\>", "ExampleText",
 CellID->148129436],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"{", 
     RowBox[{"x_", ",", "y_", ",", "z_"}], "}"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "-", 
      RowBox[{"Sin", "[", "y", "]"}]}], ",", 
     RowBox[{"z", "-", 
      RowBox[{"Cos", "[", "y", "]"}]}], ",", 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], 
      RowBox[{"Sin", "[", "z", "]"}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"J", "[", 
    RowBox[{"{", 
     RowBox[{"x_", ",", "y_", ",", "z_"}], "}"}], "]"}], "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], "}"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"FixedPoint", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"#", "-", 
      RowBox[{"LinearSolve", "[", 
       RowBox[{
        RowBox[{"J", "[", "#", "]"}], ",", 
        RowBox[{"f", "[", "#", "]"}]}], "]"}]}], ")"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{".5", ",", ".5", ",", ".5"}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->205116309],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.`", ",", "1.5707963267948966`", ",", "0.`"}], "}"}]], "Output",
 ImageSize->{111, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->306178604]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->189534435],

Cell[TextData[{
 "Approximately solve the boundary value problem ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["u", "xx"], " ", "+", " ", "u"}], " ", "=", " ", "f"}], 
    ";", " ", 
    RowBox[{
     RowBox[{"u", 
      RowBox[{"(", "0", ")"}]}], " ", "=", " ", 
     RowBox[{
      RowBox[{"u", 
       RowBox[{"(", "1", ")"}]}], " ", "=", " ", "0"}]}]}], TraditionalForm]],
   "InlineMath"],
 ":"
}], "ExampleText",
 CellID->221615405],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", "100"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", 
        RowBox[{"1", "/", "2"}]}], ")"}], "^", "2"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"n", "=", "100"}], ";", 
  RowBox[{"h", "=", 
   RowBox[{"1.", "/", "n"}]}], ";", 
  RowBox[{"grid", "=", 
   RowBox[{
    RowBox[{"N", "[", 
     RowBox[{"Range", "[", 
      RowBox[{"n", "-", "1"}], "]"}], "]"}], "/", "n"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"s", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "i_"}], "}"}], "\[Rule]", 
        RowBox[{"1.", "-", 
         RowBox[{"2", "/", 
          RowBox[{"h", "^", "2"}]}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{"i", "-", "j"}], "]"}], "\[Equal]", "1"}]}], "\[Rule]", 
        RowBox[{"1", "/", 
         RowBox[{"h", "^", "2"}]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"n", "-", "1"}], ",", 
       RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"f", "[", "grid", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ux", "=", 
   RowBox[{"LinearSolve", "[", 
    RowBox[{"s", ",", "b"}], "]"}]}], ";"}], "\n", 
 RowBox[{"ListPlot", "[", 
  RowBox[{"Transpose", "[", 
   RowBox[{"{", 
    RowBox[{"grid", ",", "ux"}], "}"}], "]"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->21041015],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxVlXtMk2cUxhsxGpxODF6SBWmWbUQnMQx1cTH4mG0Z1Lhl4OIGdhnbMnXO
zVov2ypiK4WYBrlYlaJQKG3RZUkZBDKMmy8DFnHBK9BWUWihlEJbcMvqRqbJ
+L5z/vFNmqb9+p7L8zvn6Yuf7c/5Yo5Cofh89iW9H13qyvTrjOiOmF9baHhf
0OcziI89SnLr80V7cnE4u92Kx3nrZy537OHnDuxVlN58elwjzldL5wckzHup
ML3uEP/eheNP/pnv+/U7EcmWvmnG8n+X7wsPFvD9Vlgu7PDUFOjFAo9dk7Hg
Z3j0uRGP6QTHu4wc8zsF1RajWK0u74yt+gX9+veW9DtLOP5VTOxyb9S1nBSO
2dseewc2bTUVFV41cb7fkChWF/ddLxXr5NOF1ldv9X3VX8b5u+GKU8at3F8h
umKrZjP8jrwrGz6yHKzkeq4hb5Fmre3b0yJHTtiDuk+yO9KOmrm+69he9lf6
lsIzwq+TAv6BnqwrRT36s1xvL/LPBb7sPHFOHJDK09zAN9rJl1OMVVz/Tbgz
Fq8NGy1CIZ/biNVCzC+u5n5uY2Zb4kqN8bzIkhPcQZWuvnRZ0QXu7w7WV/3p
DehrhJRNXX4XHz9Jzuo+Vsv99qGrtW2o4nurkNvx9GFTQ/TuC4fquP9+VDcl
nqp4vV4opXKSB2CZmTsvpaWe9RhAdtk2iznVJnbvko4bakNo4ymnjfXx4AP/
c6bmpAYhRVvq8qB38U9FJZUNrJcX8cfKLx6Js4vHUriYFzUptrRbB+ys3z2o
c2vbxKBdbJYD3ofK1ta0c4uD9bwP79/7YLU6hFxe8SAOb9Xma2IO1vcBep8e
Nja/5RQ3eqXzAPXPq1RvnnSy3g9hCqW1J3Q6xTK5wCFgJjXjlUdO1n8I8drM
D5uWNAo5nHoY6dqu6YSURubhQ6bydM54aiP348M6fk58fFjI96k/H97m+MTL
j0rOT/36cYnrI35+uLl+6n8EBu6PeI4gyP1TuBHksj7EdxRfs36kzyhcrC/h
GUUS6096BTDMfIh/AHuYH+kXgJb50jyMYS/zJz3H0PLMfIyhleeH9A1Cy/NF
8xLEfzx/pHcQVTyfND/j0PD8kv7jGOD5pnkaxxvv0vwTjxA2WGk/iEcIKzbT
/hCPEJp4v4hHCDbeP+IxgXgV7SfxmICZ95d4TGCI95t4TMLC+18h85jEWfYH
4jGJIPsH8QhDuYb8hXiEoWP/IR5hWNmfiEcEmbvJv4hHBGsM5G/EI4IG9j/i
EYXSQP5IPKLwsn8SjyhK2F+JxxSG2X+JxxQ+fcafp/Aj+zfxmMaOneTvxGMa
KvZ/4jGNuVH6f/gf72A4Aw==
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 0.99}, {-0.04331133730835162, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->67383611]
}, Open  ]],

Cell["Show the error compared with the exact solution:", "ExampleText",
 CellID->346152208],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ex", "=", 
   RowBox[{
    RowBox[{"First", "[", 
     RowBox[{"u", "/.", 
      RowBox[{"DSolve", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"u", "''"}], "[", "x", "]"}], "+", 
            RowBox[{"u", "[", "x", "]"}]}], "\[Equal]", 
           RowBox[{"f", "[", "x", "]"}]}], ",", 
          RowBox[{
           RowBox[{"u", "[", "0", "]"}], "\[Equal]", 
           RowBox[{"u", "[", "1", "]"}], "\[Equal]", "0"}]}], "}"}], ",", "u",
         ",", "x"}], "]"}]}], "]"}], "[", "grid", "]"}]}], ";"}], "\n", 
 RowBox[{"ListPlot", "[", 
  RowBox[{"Transpose", "[", 
   RowBox[{"{", 
    RowBox[{"grid", ",", 
     RowBox[{"Abs", "[", 
      RowBox[{"ux", "-", "ex"}], "]"}]}], "}"}], "]"}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->287741907],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxNlXtMzWEYx99lRFs0ihmLNn8wMhYbxXv4o5hlq1zm0krSZakUraWL/Vxi
FIVETFJnpaxDZM5JayklrRxy6pScnC6U3DYtl+YPz+X9w29r7dP7+z3v83y/
z/Pksf9QUISDECIcfvB3mqthU3/qKZ0QUZa167ZJ5jzgB342n3BpdM/8HGgs
BJ6ePdQdq871wIXuB72PyOsF+JQDe01UOKao9w3AkbWTLOnySyD+pQp4d02J
WVPfVwOP+epXnZRO1pKE9U6PgS+6fL2WqeKZgJ0ORP89I5cE5zSML64Fzp7k
EHpOxa8Dbiu6U58t9fC1taQeuK40wCNH3fdUJ7QLj9Prc6UXPY1wbgnp/X5R
3f8M+HSL3f2ybBxfDDc0AW/Mb92ap/J5jvWOzci4IoPowhbgksNnK/NVfi+A
J3bdt1+V/akYsBXPHcXcApVvG/CSTWf2XJeJmF5CO/APo+nuDZX/S+DR35dm
35SCnld4X9K8ikJVD7C2I32ZLJKb6YLXcF7mv33nbVUfsBZ/bPXDYom3Bed0
AIclDyfqVb1v4P1fsSuMpZLKsQJr3SHxj8pV/RY4v5fYVlwpF2A67p3AntEr
w6qUHsBazES8oVpGReLTBedZ5so+o9LHCuw7ucKtTmI0VwPy/YryNQ1Kr27g
aS3nHZrlTww3jrzdcjSmVenXoxMbdjz0jTZLDvhWJ4qW+gwc6VB6Ird/soV3
Skovsxd4QfyUuG6l7zvgqY76w72yvQ0fYK1p2LatT+lt0wn7LNN4sl26UYJ9
OuHS5LUvp1/pD/zq+K2f4QOSwgW/h/dNvwwjA8oPO8Sbf83sNqjqARY1dM7+
ALucoO+5PuAAjs9+9QO70v1cL3BRM+XH/gHbp1H+XP+ATiz0oPrYT2DNTPVz
OGCxnPRhfwdxnkg/1gd5F+nL9gBrzqQ/6zWkE/XV5A/7DywCyT/WD1jLJ3+5
Hz7AeQr5z3oie//XH8gt1D+s70ecZ+ov7hdgbWYc9h/rjZxB/cn9M4z9RP3L
+iM3U39zPyEnUf+zHyPA/jQf7Aey5x+cH/YDeZUJ54v9QI6g+WM/PgHbaD7Z
D2Tv3Ti/7AeyneabExwF3kLzn0t+IKfSfmA/kE20P9iPz8DOobhf2A/kJ7R/
2A/kOWW4n9iPL8CLbuP+Yj+Qu2i/sR/Ie2n/sR9fga20H9kPZC8/3J/sB7CW
RfuV/fgG5w20f9kP5LT/9jNyD+1v9uM78H7a7+wH8l/a/+wHsoX+P/wDVQO9
IQ==
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 0.99}, {0., 9.10053200048333*^-6}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 98},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->57481310]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31216],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a 3\[Times]3 matrix:"
}], "ExampleText",
 CellID->292179322],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "1"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2133535],

Cell["A system of linear equations:", "ExampleText",
 CellID->471104607],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqns", "=", 
  RowBox[{"Thread", "[", 
   RowBox[{
    RowBox[{"m", ".", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "\[Equal]", 
    RowBox[{"{", 
     RowBox[{"6", ",", "4", ",", "5"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->73896087],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "+", "y", "+", "z"}], "\[Equal]", "6"}], ",", 
   RowBox[{
    RowBox[{"x", "+", "z"}], "\[Equal]", "4"}], ",", 
   RowBox[{
    RowBox[{"y", "+", "z"}], "\[Equal]", "5"}]}], "}"}]], "Output",
 ImageSize->{212, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->8376579]
}, Open  ]],

Cell[TextData[{
 "The solution computed by ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->255546580],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ssol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"eqns", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->5770224],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "1"}], ",", 
    RowBox[{"y", "\[Rule]", "2"}], ",", 
    RowBox[{"z", "\[Rule]", "3"}]}], "}"}], "}"}]], "Output",
 ImageSize->{145, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->16290167]
}, Open  ]],

Cell[TextData[{
 "The solution computed by ",
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->637526724],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lssol", "=", 
  RowBox[{"LinearSolve", "[", 
   RowBox[{"m", ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "4", ",", "5"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->14610808],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->166001187]
}, Open  ]],

Cell["Verify they are the same:", "ExampleText",
 CellID->139635540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lssol", "\[Equal]", 
  RowBox[{"First", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], "/.", "ssol"}], 
   "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->642087442],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->582504204]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->757265779],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is nonsingular, the solution ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"m", ".", "x"}], " ", "=", " ", "b"}], TraditionalForm]], 
  "InlineMath"],
 " is the inverse of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " when ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " is the identity matrix:"
}], "ExampleText",
 CellID->257394739],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4", ",", "9"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"LinearSolve", "[", 
  RowBox[{"m", ",", 
   RowBox[{"IdentityMatrix", "[", "3", "]"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->674988225],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"-", 
      FractionBox["5", "2"]}], ",", 
     FractionBox["1", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", "4", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", 
      FractionBox["3", "2"]}], ",", 
     FractionBox["1", "2"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{260, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17621683]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inverse", "[", "m", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->236320586],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"-", 
      FractionBox["5", "2"]}], ",", 
     FractionBox["1", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", "4", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", 
      FractionBox["3", "2"]}], ",", 
     FractionBox["1", "2"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{260, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->490821]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->54357596],

Cell[TextData[{
 "In this case there is no solution to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"m", ".", "x"}], "\[LongEqual]", "b"}], TraditionalForm]], 
  "InlineMath"],
 ": "
}], "ExampleText",
 CellID->33963208],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}]}], ";", " ", 
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "2"}], ",", "1"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->142054667],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearSolve", "[", 
  RowBox[{"m", ",", "b"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->421191116],

Cell[BoxData[
 RowBox[{
  RowBox[{"LinearSolve", "::", "\<\"nosol\"\>"}], ":", 
  " ", "\<\"Linear equation encountered that has no solution. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/LinearSolve/nosol\\\", \
ButtonNote -> \\\"LinearSolve::nosol\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->19236157],

Cell[BoxData[
 RowBox[{"LinearSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "2"}], ",", "1"}], "}"}]}], "]"}]], "Output",
 ImageSize->{380, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->149089772]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["LeastSquares",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LeastSquares"]], "InlineFormula"],
 " to minimize ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[LeftDoubleBracketingBar]", 
    RowBox[{
     RowBox[{"m", ".", "x"}], "-", "b"}], "\[RightDoubleBracketingBar]"}], 
   TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->143238871],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"LeastSquares", "[", 
   RowBox[{"m", ",", "b"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->191807952],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->191730042]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", 
  RowBox[{
   RowBox[{"m", ".", "x"}], "-", "b"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->410520110],

Cell[BoxData[
 SqrtBox["6"]], "Output",
 ImageSize->{28, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->101833144]
}, Open  ]],

Cell["Compare to general minimization: ", "ExampleText",
 CellID->8081317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"Norm", "[", 
    RowBox[{
     RowBox[{"m", ".", 
      RowBox[{"{", 
       RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}]}], "-", "b"}], "]"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->415688167],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SqrtBox["6"], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", "0"}], ",", 
     RowBox[{"x2", "\[Rule]", "0"}], ",", 
     RowBox[{"x3", "\[Rule]", "0"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{201, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->179902818]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->279232323],

Cell[TextData[{
 "There are multiple solutions to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"m", ".", "x"}], "\[LongEqual]", "0"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->77168951],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->74252850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearSolve", "[", 
  RowBox[{"m", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11268222],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->38209162]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["NullSpace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NullSpace"]], "InlineFormula"],
 " to get the complete spanning set of solutions:"
}], "ExampleText",
 CellID->30913082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NullSpace", "[", "m", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->50364945],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"1", ",", 
    RowBox[{"-", "2"}], ",", "1"}], "}"}], "}"}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->318756036]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26372],

Cell["Solution found for an underdetermined system is not unique:", \
"ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->308488225],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "15"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->672205549],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "3", ",", "0"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->136225349]
}, Open  ]],

Cell[TextData[{
 "All solutions found by ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->161576735],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}], "/.", 
  RowBox[{"First", "[", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"Thread", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}], ".", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "\[Equal]", 
       RowBox[{"{", 
        RowBox[{"6", ",", "15"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->333134106],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   RowBox[{"3", "-", 
    RowBox[{"2", " ", "z"}]}], ",", "z"}], "}"}]], "Output",
 ImageSize->{91, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->290009952]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->77408050],

Cell["\<\
With ill-conditioned matrices, numerical solutions may not be very good:\
\>", "ExampleText",
 CellID->454031625],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"HilbertMatrix", "[", "20", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"m", ".", 
    RowBox[{"Table", "[", 
     RowBox[{"1", ",", 
      RowBox[{"{", "20", "}"}]}], "]"}]}]}], ";"}], "\n", 
 RowBox[{"LinearSolve", "[", 
  RowBox[{
   RowBox[{"N", "[", "m", "]"}], ",", 
   RowBox[{"N", "[", "b", "]"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->78257356],

Cell[BoxData[
 RowBox[{
  RowBox[{"LinearSolve", "::", "\<\"luc\"\>"}], ":", 
  " ", "\<\"Result for \\!\\(LinearSolve\\) of badly conditioned matrix \
\\!\\({\\(\\({1.`, 0.5`, 0.3333333333333333`, 0.25`, 0.2`, \\(\\(\
\[LeftSkeleton] 20 \[RightSkeleton]\\)\\), 0.14285714285714285`, 0.125`, \
0.1111111111111111`, 0.1`, \\(\\(\[LeftSkeleton] 10 \
\[RightSkeleton]\\)\\)}\\)\\), \\(\\(\[LeftSkeleton] 10 \
\[RightSkeleton]\\)\\)}\\) may contain significant numerical errors. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/luc\\\", \
ButtonNote -> \\\"LinearSolve::luc\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->251067142],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.0000000158380435`", ",", "0.9999980941042604`", ",", 
   "1.0000589652040834`", ",", "0.999168386331059`", ",", 
   "1.006727084192484`", ",", "0.965595128379418`", ",", 
   "1.1094553509032565`", ",", "0.8368492822354289`", ",", 
   "0.7731000071706434`", ",", "2.7442639839074308`", ",", 
   RowBox[{"-", "3.060323085678936`"}], ",", "5.7517830311152265`", ",", 
   RowBox[{"-", "0.24875546386849343`"}], ",", 
   RowBox[{"-", "5.663909758774916`"}], ",", "18.527457157686417`", ",", 
   RowBox[{"-", "26.336178151690163`"}], ",", "29.634006401717794`", ",", 
   RowBox[{"-", "18.121030384895864`"}], ",", "8.282113709004278`", ",", 
   RowBox[{"-", "0.20037977940688634`"}]}], "}"}]], "Output",
 ImageSize->{451, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18743775]
}, Open  ]],

Cell["\<\
The solution is resolved better if sufficient precision is used:\
\>", "ExampleText",
 CellID->99544213],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearSolve", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"m", ",", "30"}], "]"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{"b", ",", "30"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1682320],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.999999999999999999999999999999999678037405721605`30.", ",", 
   "1.000000000000000000000000000000120122697125283322`30.", ",", 
   "0.999999999999999999999999999988831506361773154847`30.", ",", 
   "1.000000000000000000000000000457417558760437646325`30.", ",", 
   "0.999999999999999999999999989616020129296707856559`30.", ",", 
   "1.000000000000000000000000147771319876341160341606`30.", ",", 
   "0.999999999999999999999998578703237010673636436332`30.", ",", 
   "1.000000000000000000000009708184690116879899300315`30.", ",", 
   "0.999999999999999999999951293349132265585415875626`30.", ",", 
   "1.000000000000000000000183674607134490596215090917`30.", ",", 
   "0.999999999999999999999471413184552282585735398904`30.", ",", 
   "1.000000000000000000001171136463761855887905923013`30.", ",", 
   "0.99999999999999999999799632635901980249092235518`30.", ",", 
   "1.000000000000000000002639451411603353653302440503`30.", ",", 
   "0.999999999999999999997348913931677623368777646628`30.", ",", 
   "1.000000000000000000001992278434342151519334552173`30.", ",", 
   "0.999999999999999999998915968517585512553088559254`30.", ",", 
   "1.000000000000000000000403183361701235390215875024`30.", ",", 
   "0.999999999999999999999908326534258958142277584221`30.", ",", 
   "1.000000000000000000000009609123594703870655611528`30."}], 
  "}"}]], "Output",
 ImageSize->{471, 169},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->336925019]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4900],

Cell["Solve 100,000 equations using direct methods:", "ExampleText",
 CellID->122296237],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], "\[Rule]", 
       RowBox[{"-", "2."}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{"i", "-", "j"}], "]"}], "\[Equal]", "1"}]}], "\[Rule]", 
       "1."}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"10", "^", "5"}], ",", 
      RowBox[{"10", "^", "5"}]}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->364999355],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "299998", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 299998, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"100000", ",", "100000"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{278, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->592647899]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"LinearSolve", "[", 
    RowBox[{"s", ",", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"1", ",", 
       RowBox[{"10", "^", "5"}]}], "]"}]}], "]"}], ";"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->233564401],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.6560000000000002`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->81371664]
}, Open  ]],

Cell["Solve a million equations using iterative methods:", "ExampleText",
 CellID->461272377],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], "\[Rule]", 
       RowBox[{"-", "2."}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{"i", "-", "j"}], "]"}], "\[Equal]", "1"}]}], "\[Rule]", 
       "1."}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"10", "^", "6"}], ",", 
      RowBox[{"10", "^", "6"}]}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->284241444],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2999998", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 2999998, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"1000000", ",", "1000000"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{306, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->423816039]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"LinearSolve", "[", 
    RowBox[{"s", ",", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"1", ",", 
       RowBox[{"10", "^", "6"}]}], "]"}], ",", 
     RowBox[{"Method", "\[Rule]", "\"\<Krylov\>\""}]}], "]"}], ";"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->125771906],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.062000000000001`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->532350119]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13462],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inverse",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inverse"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Solve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Solve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NullSpace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NullSpace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CoefficientArrays",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CoefficientArrays"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CholeskyDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CholeskyDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PseudoInverse",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PseudoInverse"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LeastSquares",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LeastSquares"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RowReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RowReduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinearSolveFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinearSolveFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MatrixPower",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MatrixPower"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22576]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12558],

Cell[TextData[ButtonBox["Solving Linear Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SolvingLinearSystems"]], "Tutorials",
 CellID->15515],

Cell[TextData[{
 ButtonBox["Linear Algebra in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraOverview"],
  FontSlant->"Italic"]
}], "Tutorials",
 CellID->293437061]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->1153],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#5783"], None}]], "RelatedLinks",
 CellID->11485],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
LinearSolve"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->147273845],

Cell[TextData[ButtonBox["Equation Solving",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EquationSolving"]], "MoreAbout",
 CellID->652943895],

Cell[TextData[ButtonBox["Linear Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LinearSystems"]], "MoreAbout",
 CellID->349799604],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout",
 CellID->74790419],

Cell[TextData[ButtonBox["Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixOperations"]], "MoreAbout",
 CellID->267542839],

Cell[TextData[ButtonBox["Signal Processing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SignalProcessing"]], "MoreAbout",
 CellID->86556202],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->110189733]
}, Open  ]],

Cell["New in 1  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LinearSolve - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 53, 26.7501126}", "context" -> "System`", 
    "keywords" -> {
     "Cholesky", "cofactor expansion", "direct solver methods", 
      "division-free row reduction", "division of matrices", 
      "Gaussian elimination", "Krylov", "Krylov methods", "LINPACK", 
      "matrix equations", "multifrontal", "multifrontal methods", 
      "one-step row reduction", "solution of linear systems", 
      "sparse matrices", "UMFPACK"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LinearSolve[m, b] finds an x which solves the matrix equation m.x == b. \
LinearSolve[m] generates a LinearSolveFunction[...] which can be applied \
repeatedly to different b. ", "synonyms" -> {"linear solve", "linear solve"}, 
    "title" -> "LinearSolve", "type" -> "Symbol", "uri" -> 
    "ref/LinearSolve"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11338, 365, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->59607972]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 72636, 2636}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3779, 81, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4402, 108, 49, 1, 70, "ObjectName",
 CellID->13200],
Cell[4454, 111, 1434, 46, 70, "Usage",
 CellID->5289]
}, Open  ]],
Cell[CellGroupData[{
Cell[5925, 162, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6403, 179, 372, 12, 70, "Notes",
 CellID->11663],
Cell[6778, 193, 274, 10, 70, "Notes",
 CellID->28223],
Cell[7055, 205, 265, 10, 70, "Notes",
 CellID->2615],
Cell[7323, 217, 530, 17, 70, "Notes",
 CellID->23460],
Cell[7856, 236, 441, 17, 70, "Notes",
 CellID->30992],
Cell[8300, 255, 515, 17, 70, "Notes",
 CellID->9892],
Cell[8818, 274, 633, 23, 70, "Notes",
 CellID->7050],
Cell[9454, 299, 908, 33, 70, "Notes",
 CellID->22114],
Cell[10365, 334, 936, 26, 70, "Notes",
 CellID->25067]
}, Closed]],
Cell[CellGroupData[{
Cell[11338, 365, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->59607972],
Cell[CellGroupData[{
Cell[11722, 379, 148, 5, 70, "ExampleSection",
 CellID->524548177],
Cell[CellGroupData[{
Cell[11895, 388, 334, 12, 28, "Input",
 CellID->142520274],
Cell[12232, 402, 578, 22, 52, "Output",
 CellID->721156261]
}, Open  ]],
Cell[12825, 427, 125, 3, 70, "ExampleDelimiter",
 CellID->411692487],
Cell[12953, 432, 251, 8, 70, "ExampleText",
 CellID->55534934],
Cell[CellGroupData[{
Cell[13229, 444, 284, 10, 28, "Input",
 CellID->46914770],
Cell[13516, 456, 326, 12, 36, "Output",
 CellID->53712882]
}, Open  ]],
Cell[CellGroupData[{
Cell[13879, 473, 143, 5, 70, "Input",
 CellID->86469674],
Cell[14025, 480, 242, 9, 51, "Output",
 CellID->4914524]
}, Open  ]],
Cell[CellGroupData[{
Cell[14304, 494, 334, 12, 70, "Input",
 CellID->437348419],
Cell[14641, 508, 244, 9, 51, "Output",
 CellID->169237187]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14934, 523, 215, 7, 70, "ExampleSection",
 CellID->5055],
Cell[15152, 532, 327, 13, 70, "ExampleText",
 CellID->419679908],
Cell[CellGroupData[{
Cell[15504, 549, 541, 18, 70, "Input",
 CellID->241293362],
Cell[16048, 569, 297, 11, 51, "Output",
 CellID->230881774]
}, Open  ]],
Cell[16360, 583, 114, 3, 70, "ExampleText",
 CellID->181691984],
Cell[CellGroupData[{
Cell[16499, 590, 188, 6, 70, "Input",
 CellID->205635973],
Cell[16690, 598, 306, 9, 36, "Output",
 CellID->547582856]
}, Open  ]],
Cell[17011, 610, 125, 3, 70, "ExampleText",
 CellID->85381944],
Cell[CellGroupData[{
Cell[17161, 617, 239, 8, 70, "Input",
 CellID->72151486],
Cell[17403, 627, 269, 9, 36, "Output",
 CellID->279576092]
}, Open  ]],
Cell[17687, 639, 125, 3, 70, "ExampleDelimiter",
 CellID->956256033],
Cell[17815, 644, 91, 1, 70, "ExampleText",
 CellID->96757593],
Cell[CellGroupData[{
Cell[17931, 649, 437, 14, 70, "Input",
 CellID->343066684],
Cell[18371, 665, 232, 8, 36, "Output",
 CellID->362967152]
}, Open  ]],
Cell[18618, 676, 77, 1, 70, "ExampleText",
 CellID->212137539],
Cell[CellGroupData[{
Cell[18720, 681, 458, 15, 70, "Input",
 CellID->430156023],
Cell[19181, 698, 388, 7, 70, "Message",
 CellID->475875466],
Cell[19572, 707, 546, 18, 36, "Output",
 CellID->69345192]
}, Open  ]],
Cell[20133, 728, 125, 3, 70, "ExampleDelimiter",
 CellID->662308102],
Cell[20261, 733, 132, 2, 70, "ExampleText",
 CellID->122153443],
Cell[CellGroupData[{
Cell[20418, 739, 473, 14, 70, "Input",
 CellID->114867240],
Cell[20894, 755, 290, 10, 51, "Output",
 CellID->490975034]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21233, 771, 239, 7, 70, "ExampleSection",
 CellID->19866],
Cell[21475, 780, 422, 17, 70, "ExampleText",
 CellID->346530297],
Cell[CellGroupData[{
Cell[21922, 801, 700, 24, 70, "Input",
 CellID->139154922],
Cell[22625, 827, 445, 17, 36, "Output",
 CellID->679958285]
}, Open  ]],
Cell[23085, 847, 125, 3, 70, "ExampleDelimiter",
 CellID->516201730],
Cell[23213, 852, 491, 18, 70, "ExampleText",
 CellID->274225114],
Cell[CellGroupData[{
Cell[23729, 874, 430, 14, 70, "Input",
 CellID->42493765],
Cell[24162, 890, 327, 12, 36, "Output",
 CellID->615599975]
}, Open  ]],
Cell[24504, 905, 190, 6, 70, "ExampleText",
 CellID->104314392],
Cell[CellGroupData[{
Cell[24719, 915, 154, 5, 70, "Input",
 CellID->184729738],
Cell[24876, 922, 296, 11, 51, "Output",
 CellID->93939893]
}, Open  ]],
Cell[25187, 936, 125, 3, 70, "ExampleDelimiter",
 CellID->418990341],
Cell[25315, 941, 87, 1, 70, "ExampleText",
 CellID->275476936],
Cell[CellGroupData[{
Cell[25427, 946, 983, 33, 70, "Input",
 CellID->533014834],
Cell[26413, 981, 2478, 45, 70, "Output",
 Evaluatable->False,
 CellID->543896100]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28940, 1032, 218, 7, 70, "ExampleSection",
 CellID->27513],
Cell[CellGroupData[{
Cell[29183, 1043, 223, 7, 70, "ExampleSubsection",
 CellID->23224],
Cell[29409, 1052, 141, 5, 70, "ExampleText",
 CellID->133779876],
Cell[29553, 1059, 885, 30, 70, "Input",
 CellID->260416927],
Cell[30441, 1091, 262, 10, 70, "ExampleText",
 CellID->308318901],
Cell[CellGroupData[{
Cell[30728, 1105, 281, 9, 70, "Input",
 CellID->443831889],
Cell[31012, 1116, 225, 7, 36, "Output",
 CellID->355022946]
}, Open  ]],
Cell[31252, 1126, 269, 10, 70, "ExampleText",
 CellID->515241404],
Cell[CellGroupData[{
Cell[31546, 1140, 275, 9, 70, "Input",
 CellID->112807183],
Cell[31824, 1151, 225, 7, 36, "Output",
 CellID->324470044]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[32098, 1164, 224, 7, 70, "ExampleSubsection",
 CellID->28886],
Cell[32325, 1173, 363, 14, 70, "ExampleText",
 CellID->222012567],
Cell[CellGroupData[{
Cell[32713, 1191, 588, 19, 70, "Input",
 CellID->462119316],
Cell[33304, 1212, 215, 7, 36, "Output",
 CellID->303224149]
}, Open  ]],
Cell[33534, 1222, 63, 1, 70, "ExampleText",
 CellID->145753576],
Cell[CellGroupData[{
Cell[33622, 1227, 147, 5, 70, "Input",
 CellID->308180616],
Cell[33772, 1234, 213, 7, 36, "Output",
 CellID->433410927]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[34046, 1248, 223, 7, 70, "ExampleSection",
 CellID->27080],
Cell[34272, 1257, 113, 3, 70, "ExampleText",
 CellID->148129436],
Cell[CellGroupData[{
Cell[34410, 1264, 1201, 41, 70, "Input",
 CellID->205116309],
Cell[35614, 1307, 236, 7, 36, "Output",
 CellID->306178604]
}, Open  ]],
Cell[35865, 1317, 125, 3, 70, "ExampleDelimiter",
 CellID->189534435],
Cell[35993, 1322, 479, 18, 70, "ExampleText",
 CellID->221615405],
Cell[CellGroupData[{
Cell[36497, 1344, 1681, 58, 70, "Input",
 CellID->21041015],
Cell[38181, 1404, 1849, 39, 118, "Output",
 CellID->67383611]
}, Open  ]],
Cell[40045, 1446, 91, 1, 70, "ExampleText",
 CellID->346152208],
Cell[CellGroupData[{
Cell[40161, 1451, 886, 27, 70, "Input",
 CellID->287741907],
Cell[41050, 1480, 1768, 38, 119, "Output",
 CellID->57481310]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[42867, 1524, 233, 7, 70, "ExampleSection",
 CellID->31216],
Cell[43103, 1533, 139, 5, 70, "ExampleText",
 CellID->292179322],
Cell[43245, 1540, 356, 12, 70, "Input",
 CellID->2133535],
Cell[43604, 1554, 72, 1, 70, "ExampleText",
 CellID->471104607],
Cell[CellGroupData[{
Cell[43701, 1559, 307, 10, 70, "Input",
 CellID->73896087],
Cell[44011, 1571, 390, 13, 36, "Output",
 CellID->8376579]
}, Open  ]],
Cell[44416, 1587, 202, 8, 70, "ExampleText",
 CellID->255546580],
Cell[CellGroupData[{
Cell[44643, 1599, 213, 7, 70, "Input",
 CellID->5770224],
Cell[44859, 1608, 330, 11, 36, "Output",
 CellID->16290167]
}, Open  ]],
Cell[45204, 1622, 214, 8, 70, "ExampleText",
 CellID->637526724],
Cell[CellGroupData[{
Cell[45443, 1634, 218, 7, 70, "Input",
 CellID->14610808],
Cell[45664, 1643, 213, 7, 36, "Output",
 CellID->166001187]
}, Open  ]],
Cell[45892, 1653, 68, 1, 70, "ExampleText",
 CellID->139635540],
Cell[CellGroupData[{
Cell[45985, 1658, 228, 8, 70, "Input",
 CellID->642087442],
Cell[46216, 1668, 161, 5, 36, "Output",
 CellID->582504204]
}, Open  ]],
Cell[46392, 1676, 125, 3, 70, "ExampleDelimiter",
 CellID->757265779],
Cell[46520, 1681, 523, 21, 70, "ExampleText",
 CellID->257394739],
Cell[CellGroupData[{
Cell[47068, 1706, 473, 15, 70, "Input",
 CellID->674988225],
Cell[47544, 1723, 572, 21, 51, "Output",
 CellID->17621683]
}, Open  ]],
Cell[CellGroupData[{
Cell[48153, 1749, 103, 3, 70, "Input",
 CellID->236320586],
Cell[48259, 1754, 570, 21, 51, "Output",
 CellID->490821]
}, Open  ]],
Cell[48844, 1778, 124, 3, 70, "ExampleDelimiter",
 CellID->54357596],
Cell[48971, 1783, 228, 9, 70, "ExampleText",
 CellID->33963208],
Cell[49202, 1794, 476, 16, 70, "Input",
 CellID->142054667],
Cell[CellGroupData[{
Cell[49703, 1814, 130, 4, 70, "Input",
 CellID->421191116],
Cell[49836, 1820, 387, 7, 70, "Message",
 CellID->19236157],
Cell[50226, 1829, 547, 18, 36, "Output",
 CellID->149089772]
}, Open  ]],
Cell[50788, 1850, 407, 15, 70, "ExampleText",
 CellID->143238871],
Cell[CellGroupData[{
Cell[51220, 1869, 155, 5, 70, "Input",
 CellID->191807952],
Cell[51378, 1876, 213, 7, 36, "Output",
 CellID->191730042]
}, Open  ]],
Cell[CellGroupData[{
Cell[51628, 1888, 147, 5, 70, "Input",
 CellID->410520110],
Cell[51778, 1895, 169, 6, 38, "Output",
 CellID->101833144]
}, Open  ]],
Cell[51962, 1904, 74, 1, 70, "ExampleText",
 CellID->8081317],
Cell[CellGroupData[{
Cell[52061, 1909, 344, 12, 70, "Input",
 CellID->415688167],
Cell[52408, 1923, 375, 13, 43, "Output",
 CellID->179902818]
}, Open  ]],
Cell[52798, 1939, 125, 3, 70, "ExampleDelimiter",
 CellID->279232323],
Cell[52926, 1944, 222, 9, 70, "ExampleText",
 CellID->77168951],
Cell[53151, 1955, 357, 12, 70, "Input",
 CellID->74252850],
Cell[CellGroupData[{
Cell[53533, 1971, 188, 6, 70, "Input",
 CellID->11268222],
Cell[53724, 1979, 212, 7, 36, "Output",
 CellID->38209162]
}, Open  ]],
Cell[53951, 1989, 234, 8, 70, "ExampleText",
 CellID->30913082],
Cell[CellGroupData[{
Cell[54210, 2001, 104, 3, 70, "Input",
 CellID->50364945],
Cell[54317, 2006, 257, 9, 36, "Output",
 CellID->318756036]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[54623, 2021, 226, 7, 70, "ExampleSection",
 CellID->26372],
Cell[54852, 2030, 152, 3, 70, "ExampleText",
 CellID->308488225],
Cell[CellGroupData[{
Cell[55029, 2037, 355, 12, 70, "Input",
 CellID->672205549],
Cell[55387, 2051, 213, 7, 36, "Output",
 CellID->136225349]
}, Open  ]],
Cell[55615, 2061, 200, 8, 70, "ExampleText",
 CellID->161576735],
Cell[CellGroupData[{
Cell[55840, 2073, 723, 23, 70, "Input",
 CellID->333134106],
Cell[56566, 2098, 262, 9, 36, "Output",
 CellID->290009952]
}, Open  ]],
Cell[56843, 2110, 124, 3, 70, "ExampleDelimiter",
 CellID->77408050],
Cell[56970, 2115, 123, 3, 70, "ExampleText",
 CellID->454031625],
Cell[CellGroupData[{
Cell[57118, 2122, 445, 15, 70, "Input",
 CellID->78257356],
Cell[57566, 2139, 713, 12, 70, "Message",
 CellID->251067142],
Cell[58282, 2153, 872, 18, 71, "Output",
 CellID->18743775]
}, Open  ]],
Cell[59169, 2174, 114, 3, 70, "ExampleText",
 CellID->99544213],
Cell[CellGroupData[{
Cell[59308, 2181, 238, 8, 70, "Input",
 CellID->1682320],
Cell[59549, 2191, 1526, 28, 190, "Output",
 CellID->336925019]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[61124, 2225, 223, 7, 70, "ExampleSection",
 CellID->4900],
Cell[61350, 2234, 88, 1, 70, "ExampleText",
 CellID->122296237],
Cell[CellGroupData[{
Cell[61463, 2239, 664, 23, 70, "Input",
 CellID->364999355],
Cell[62130, 2264, 499, 17, 36, "Output",
 CellID->592647899]
}, Open  ]],
Cell[CellGroupData[{
Cell[62666, 2286, 280, 9, 70, "Input",
 CellID->233564401],
Cell[62949, 2297, 223, 7, 36, "Output",
 CellID->81371664]
}, Open  ]],
Cell[63187, 2307, 93, 1, 70, "ExampleText",
 CellID->461272377],
Cell[CellGroupData[{
Cell[63305, 2312, 664, 23, 70, "Input",
 CellID->284241444],
Cell[63972, 2337, 503, 17, 36, "Output",
 CellID->423816039]
}, Open  ]],
Cell[CellGroupData[{
Cell[64512, 2359, 343, 11, 70, "Input",
 CellID->125771906],
Cell[64858, 2372, 223, 7, 36, "Output",
 CellID->532350119]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[65142, 2386, 311, 9, 70, "SeeAlsoSection",
 CellID->13462],
Cell[65456, 2397, 2497, 89, 70, "SeeAlso",
 CellID->22576]
}, Open  ]],
Cell[CellGroupData[{
Cell[67990, 2491, 314, 9, 70, "TutorialsSection",
 CellID->12558],
Cell[68307, 2502, 153, 3, 70, "Tutorials",
 CellID->15515],
Cell[68463, 2507, 297, 9, 70, "Tutorials",
 CellID->293437061]
}, Open  ]],
Cell[CellGroupData[{
Cell[68797, 2521, 320, 9, 70, "RelatedLinksSection",
 CellID->1153],
Cell[69120, 2532, 266, 6, 70, "RelatedLinks",
 CellID->11485],
Cell[69389, 2540, 389, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[69815, 2558, 319, 9, 70, "MoreAboutSection",
 CellID->147273845],
Cell[70137, 2569, 143, 3, 70, "MoreAbout",
 CellID->652943895],
Cell[70283, 2574, 139, 3, 70, "MoreAbout",
 CellID->349799604],
Cell[70425, 2579, 162, 3, 70, "MoreAbout",
 CellID->74790419],
Cell[70590, 2584, 145, 3, 70, "MoreAbout",
 CellID->267542839],
Cell[70738, 2589, 144, 3, 70, "MoreAbout",
 CellID->86556202],
Cell[70885, 2594, 179, 3, 70, "MoreAbout",
 CellID->110189733]
}, Open  ]],
Cell[71079, 2600, 50, 0, 70, "History"],
Cell[71132, 2602, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

