(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9438,        305]
NotebookOptionsPosition[      7425,        242]
NotebookOutlinePosition[      8565,        273]
CellTagsIndexPosition[      8522,        270]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LineBreakWithin" :> 
          Documentation`HelpLookup["paclet:ref/LineBreakWithin"], 
          "LineSpacing" :> 
          Documentation`HelpLookup["paclet:ref/LineSpacing"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"LineBreakWithin\"\>", 
       2->"\<\"LineSpacing\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Text Layout Options" :> 
          Documentation`HelpLookup["paclet:guide/TextLayoutOptions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Text Layout Options\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LinebreakAdjustments", "ObjectName",
 CellID->15350],

Cell[TextData[{
 "This function has not been fully integrated into the long-term ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system, and is subject to change.  "
}], "AwaitingReviewNote",
 CellID->368744037],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["LinebreakAdjustments",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LinebreakAdjustments"]], "InlineFormula"],
     "\[LineSeparator]is an option for selections that sets parameters used \
for calculating where automatic line breaks should be inserted."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15006]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
The automatic linebreaking of expressions uses a complex algorithm that takes \
into account many factors that affect the length of lines. Each such factor \
is assigned a weight, which is then used as a parameter in a global \
optimization routine that determines the exact positions of the line breaks. \
By adjusting the parameters, you can control the relative importance given to \
the different line breaking criteria. For most cases, the default settings \
provide a good optimal solution, and it is not necessary to adjust the \
parameters yourself.\
\>", "Notes",
 PageWidth->WindowWidth,
 CellID->31101],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LinebreakAdjustments",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinebreakAdjustments"]], "InlineFormula"],
 " is specified as a list of five numbers: ",
 Cell[BoxData[
  RowBox[{"LinebreakAdjustments", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", " ", 
     StyleBox["b", "TI"], ",", " ", 
     StyleBox["c", "TI"], ",", " ", 
     StyleBox["d", "TI"], ",", " ", 
     StyleBox["e", "TI"]}], "}"}]}]], "InlineFormula"],
 ". Here, ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " specifies the optimal line width to aim for, expressed as a percentage of \
the total line width; ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " is the penalty assigned for deviating from the line width specified by ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 "; ",
 Cell[BoxData[
  StyleBox["c", "TI"]], "InlineFormula"],
 " is a penalty based on the depth of the box tree (the deeper in the box \
tree the line break would occur, the greater the penalty for line breaks); ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 " is a penalty based on how bad the break was at the previous line; ",
 Cell[BoxData[
  StyleBox["e", "TI"]], "InlineFormula"],
 " is a penalty based on the total number of lines (the larger the number ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 ", the smaller the number of lines used to format the expression)."
}], "Notes",
 CellID->24393],

Cell[TextData[{
 "The default setting ",
 Cell[BoxData[
  RowBox[{"LinebreakAdjustments", "->", 
   RowBox[{"{", 
    RowBox[{
    "0.85", ",", " ", "2", ",", " ", "12", ",", " ", "1", ",", " ", "1"}], 
    "}"}]}]], "InlineFormula"],
 ", represents an empirical choice that works well for most ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input. An alternative setting that gives good results for program code is \
",
 Cell[BoxData[
  RowBox[{"LinebreakAdjustments", "->", 
   RowBox[{"{", 
    RowBox[{
    "0.5", ",", " ", "10", ",", " ", "100", ",", " ", "1", ",", " ", "0.5"}], 
    "}"}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->3548]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18756],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LineBreakWithin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LineBreakWithin"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LineSpacing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LineSpacing"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11840]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->106625578],

Cell[TextData[ButtonBox["Text Layout Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TextLayoutOptions"]], "MoreAbout",
 CellID->120031066]
}, Open  ]],

Cell["New in 4.0", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LinebreakAdjustments - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 53, 27.5782588}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LinebreakAdjustments is an option for selections that sets parameters \
used for calculating where automatic line breaks should be inserted.", 
    "synonyms" -> {"linebreak adjustments"}, "title" -> 
    "LinebreakAdjustments", "type" -> "Symbol", "uri" -> 
    "ref/LinebreakAdjustments"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1294, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1917, 60, 58, 1, 70, "ObjectName",
 CellID->15350],
Cell[1978, 63, 218, 6, 70, "AwaitingReviewNote",
 CellID->368744037],
Cell[2199, 71, 526, 14, 70, "Usage",
 CellID->15006]
}, Open  ]],
Cell[CellGroupData[{
Cell[2762, 90, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3240, 107, 623, 11, 70, "Notes",
 CellID->31101],
Cell[3866, 120, 1495, 40, 70, "Notes",
 CellID->24393],
Cell[5364, 162, 658, 21, 70, "Notes",
 CellID->3548]
}, Closed]],
Cell[CellGroupData[{
Cell[6059, 188, 311, 9, 70, "SeeAlsoSection",
 CellID->18756],
Cell[6373, 199, 471, 17, 70, "SeeAlso",
 CellID->11840]
}, Open  ]],
Cell[CellGroupData[{
Cell[6881, 221, 319, 9, 70, "MoreAboutSection",
 CellID->106625578],
Cell[7203, 232, 148, 3, 70, "MoreAbout",
 CellID->120031066]
}, Open  ]],
Cell[7366, 238, 29, 0, 70, "History"],
Cell[7398, 240, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

