(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17983,        637]
NotebookOptionsPosition[     13856,        501]
NotebookOutlinePosition[     15271,        540]
CellTagsIndexPosition[     15186,        535]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Using MathLink to Communicate between Mathematica Sessions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/\
UsingMathLinkToCommunicateBetweenMathematicaSessions"], 
          "Running Mathematica from Within an External Program" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RunningMathematicaFromWithinAnExternalProgram"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Using MathLink to Communicate between Mathematica \
Sessions\"\>", 
       2->"\<\"Running Mathematica from Within an External Program\"\>"}, "\<\
\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LinkConnect" :> 
          Documentation`HelpLookup["paclet:ref/LinkConnect"], "LinkLaunch" :> 
          Documentation`HelpLookup["paclet:ref/LinkLaunch"], "LinkClose" :> 
          Documentation`HelpLookup["paclet:ref/LinkClose"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"LinkConnect\"\>", 
       2->"\<\"LinkLaunch\"\>", 3->"\<\"LinkClose\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"External Operations" :> 
          Documentation`HelpLookup["paclet:guide/ExternalOperations"], 
          "MathLink API" :> 
          Documentation`HelpLookup["paclet:guide/MathLinkAPI"], 
          "MathLink Mathematica Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkMathematicaFunctions"], 
          "Parallel & Grid Computing" :> 
          Documentation`HelpLookup[
           "paclet:guide/ParallelAndGridComputing"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"External Operations\"\>", 
       2->"\<\"MathLink API\"\>", 3->"\<\"MathLink Mathematica Functions\"\>",
        4->"\<\"Parallel & Grid Computing\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LinkCreate", "ObjectName",
 CellID->31974],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LinkCreate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LinkCreate"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]creates a ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " link with the specified name for another program to connect to. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LinkCreate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LinkCreate"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]creates a ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " link and picks an unused name for the link."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->28805]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LinkCreate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkCreate"]], "InlineFormula"],
 " returns a ",
 Cell[BoxData[
  ButtonBox["LinkObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkObject"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28548],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["LinkCreate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkCreate"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["LinkConnect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkConnect"]], "InlineFormula"],
 " to set up peer\[Hyphen]to\[Hyphen]peer communication between two ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " processes. "
}], "Notes",
 CellID->12388],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinkCreate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkCreate"], "[", "]"}]], "InlineFormula"],
 " by default creates a shared memory link."
}], "Notes",
 CellID->512353133],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["LinkProtocol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkProtocol"]], "InlineFormula"],
 " specifies the underlying data transport protocol to use. "
}], "Notes",
 CellID->4577],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinkCreate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkCreate"], "[", 
   RowBox[{
    ButtonBox["LinkProtocol",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/LinkProtocol"], "->", "\"\<TCPIP\>\""}], "]"}]], 
  "InlineFormula"],
 " picks an unused TCP/IP port on your computer system and creates a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " link on it."
}], "Notes",
 CellID->116722195],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LinkCreate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkCreate"]], "InlineFormula"],
 " internally calls a function analogous to the ",
 Cell[BoxData[
  RowBox[{"MLOpenArgv", 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " function in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library. "
}], "Notes",
 CellID->10243]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->111786263],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->198553812],

Cell[TextData[{
 "Create a link with name ",
 Cell[BoxData["\"\<test\>\""], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1210286157],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"link", "=", 
  RowBox[{"LinkCreate", "[", "\"\<test\>\"", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->314336315],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"test\"\>", ",", "73", ",", "7"}], "]"}]], "Output",
 ImageSize->{160, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->139597062]
}, Open  ]],

Cell["Close the link:", "ExampleText",
 CellID->744124059],

Cell[BoxData[
 RowBox[{"LinkClose", "[", "link", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1695783132],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1630005709],

Cell["Create a link:", "ExampleText",
 CellID->57066384],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"link", "=", 
  RowBox[{"LinkCreate", "[", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1006795071],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"6tf_shm\"\>", ",", "74", ",", "7"}], "]"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->230829535]
}, Open  ]],

Cell["Close the link:", "ExampleText",
 CellID->15733225],

Cell[BoxData[
 RowBox[{"LinkClose", "[", "link", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->287823994],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1771620187],

Cell[TextData[{
 "Find an unallocated TCPIP port and create a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " link:"
}], "ExampleText",
 CellID->1664839151],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"link", "=", 
  RowBox[{"LinkCreate", "[", 
   RowBox[{"LinkProtocol", "\[Rule]", " ", "\"\<TCPIP\>\""}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1387174094],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"49350@computer.wolfram.com,49351@computer.wolfram.com\"\>", 
   ",", "15", ",", "8"}], "]"}]], "Output",
 ImageSize->{503, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1324694114]
}, Open  ]],

Cell[BoxData[
 RowBox[{"LinkClose", "[", "link", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1171005549]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5643],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkConnect",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkConnect"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkLaunch",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkLaunch"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkClose",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkClose"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20320]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->256],

Cell[TextData[{
 ButtonBox["Using ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UsingMathLinkToCommunicateBetweenMathematicaSessions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UsingMathLinkToCommunicateBetweenMathematicaSessions"],
  FontSlant->"Italic"],
 ButtonBox[" to Communicate between ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UsingMathLinkToCommunicateBetweenMathematicaSessions"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UsingMathLinkToCommunicateBetweenMathematicaSessions"],
  FontSlant->"Italic"],
 ButtonBox[" Sessions",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UsingMathLinkToCommunicateBetweenMathematicaSessions"]
}], "Tutorials",
 CellID->586],

Cell[TextData[{
 ButtonBox["Running ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/RunningMathematicaFromWithinAnExternalProgram"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/RunningMathematicaFromWithinAnExternalProgram"],
  FontSlant->"Italic"],
 ButtonBox[" from Within an External Program",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/RunningMathematicaFromWithinAnExternalProgram"]
}], "Tutorials",
 CellID->3916]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->6264731],

Cell[TextData[ButtonBox["External Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExternalOperations"]], "MoreAbout",
 CellID->707318893],

Cell[TextData[ButtonBox["MathLink API",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathLinkAPI"]], "MoreAbout",
 CellID->546458000],

Cell[TextData[ButtonBox["MathLink Mathematica Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathLinkMathematicaFunctions"]], "MoreAbout",
 CellID->346209060],

Cell[TextData[ButtonBox["Parallel & Grid Computing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ParallelAndGridComputing"]], "MoreAbout",
 CellID->260005552]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LinkCreate - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 53, 39.9535756}", "context" -> "System`", 
    "keywords" -> {
     "bind name", "create link", "listen on link", "publish link", 
      "register link"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LinkCreate[\"name\"] creates a MathLink link with the specified name for \
another program to connect to. LinkCreate[] creates a MathLink link and picks \
an unused name for the link.", "synonyms" -> {"link create"}, "title" -> 
    "LinkCreate", "type" -> "Symbol", "uri" -> "ref/LinkCreate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7111, 235, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->111786263]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15043, 528}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2806, 65, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3429, 92, 48, 1, 70, "ObjectName",
 CellID->31974],
Cell[3480, 95, 952, 29, 70, "Usage",
 CellID->28805]
}, Open  ]],
Cell[CellGroupData[{
Cell[4469, 129, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4947, 146, 312, 12, 70, "Notes",
 CellID->28548],
Cell[5262, 160, 455, 16, 70, "Notes",
 CellID->12388],
Cell[5720, 178, 242, 8, 70, "Notes",
 CellID->512353133],
Cell[5965, 188, 248, 8, 70, "Notes",
 CellID->4577],
Cell[6216, 198, 471, 16, 70, "Notes",
 CellID->116722195],
Cell[6690, 216, 384, 14, 70, "Notes",
 CellID->10243]
}, Closed]],
Cell[CellGroupData[{
Cell[7111, 235, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->111786263],
Cell[CellGroupData[{
Cell[7496, 249, 148, 5, 70, "ExampleSection",
 CellID->198553812],
Cell[7647, 256, 138, 5, 70, "ExampleText",
 CellID->1210286157],
Cell[CellGroupData[{
Cell[7810, 265, 143, 4, 28, "Input",
 CellID->314336315],
Cell[7956, 271, 240, 7, 36, "Output",
 CellID->139597062]
}, Open  ]],
Cell[8211, 281, 58, 1, 70, "ExampleText",
 CellID->744124059],
Cell[8272, 284, 109, 3, 70, "Input",
 CellID->1695783132],
Cell[8384, 289, 126, 3, 70, "ExampleDelimiter",
 CellID->1630005709],
Cell[8513, 294, 56, 1, 70, "ExampleText",
 CellID->57066384],
Cell[CellGroupData[{
Cell[8594, 299, 128, 4, 70, "Input",
 CellID->1006795071],
Cell[8725, 305, 243, 7, 36, "Output",
 CellID->230829535]
}, Open  ]],
Cell[8983, 315, 57, 1, 70, "ExampleText",
 CellID->15733225],
Cell[9043, 318, 108, 3, 70, "Input",
 CellID->287823994],
Cell[9154, 323, 126, 3, 70, "ExampleDelimiter",
 CellID->1771620187],
Cell[9283, 328, 160, 6, 70, "ExampleText",
 CellID->1664839151],
Cell[CellGroupData[{
Cell[9468, 338, 195, 6, 70, "Input",
 CellID->1387174094],
Cell[9666, 346, 294, 8, 36, "Output",
 CellID->1324694114]
}, Open  ]],
Cell[9975, 357, 109, 3, 70, "Input",
 CellID->1171005549]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10133, 366, 310, 9, 70, "SeeAlsoSection",
 CellID->5643],
Cell[10446, 377, 708, 26, 70, "SeeAlso",
 CellID->20320]
}, Open  ]],
Cell[CellGroupData[{
Cell[11191, 408, 312, 9, 70, "TutorialsSection",
 CellID->256],
Cell[11506, 419, 804, 24, 70, "Tutorials",
 CellID->586],
Cell[12313, 445, 490, 15, 70, "Tutorials",
 CellID->3916]
}, Open  ]],
Cell[CellGroupData[{
Cell[12840, 465, 317, 9, 70, "MoreAboutSection",
 CellID->6264731],
Cell[13160, 476, 149, 3, 70, "MoreAbout",
 CellID->707318893],
Cell[13312, 481, 135, 3, 70, "MoreAbout",
 CellID->546458000],
Cell[13450, 486, 170, 3, 70, "MoreAbout",
 CellID->346209060],
Cell[13623, 491, 161, 3, 70, "MoreAbout",
 CellID->260005552]
}, Open  ]],
Cell[13799, 497, 27, 0, 70, "History"],
Cell[13829, 499, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

