(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17501,        611]
NotebookOptionsPosition[     13925,        492]
NotebookOutlinePosition[     15278,        530]
CellTagsIndexPosition[     15193,        525]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calling Subsidiary Mathematica Processes" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/CallingSubsidiaryMathematicaProcesses"], 
          "Running Mathematica from Within an External Program" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RunningMathematicaFromWithinAnExternalProgram"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Calling Subsidiary Mathematica Processes\"\>", 
       2->"\<\"Running Mathematica from Within an External Program\"\>"}, "\<\
\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Install" :> Documentation`HelpLookup["paclet:ref/Install"], 
          "LinkCreate" :> Documentation`HelpLookup["paclet:ref/LinkCreate"], 
          "LinkConnect" :> Documentation`HelpLookup["paclet:ref/LinkConnect"],
           "LinkClose" :> Documentation`HelpLookup["paclet:ref/LinkClose"], 
          "LinkProtocol" :> 
          Documentation`HelpLookup["paclet:ref/LinkProtocol"], "Links" :> 
          Documentation`HelpLookup["paclet:ref/Links"], "$Linked" :> 
          Documentation`HelpLookup["paclet:ref/$Linked"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Install\"\>", 2->"\<\"LinkCreate\"\>", 
       3->"\<\"LinkConnect\"\>", 4->"\<\"LinkClose\"\>", 
       5->"\<\"LinkProtocol\"\>", 6->"\<\"Links\"\>", 
       7->"\<\"$Linked\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calling External Programs" :> 
          Documentation`HelpLookup["paclet:guide/CallingExternalPrograms"], 
          "MathLink API" :> 
          Documentation`HelpLookup["paclet:guide/MathLinkAPI"], 
          "MathLink Mathematica Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkMathematicaFunctions"], 
          "Parallel & Grid Computing" :> 
          Documentation`HelpLookup[
           "paclet:guide/ParallelAndGridComputing"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Calling External Programs\"\>", 
       2->"\<\"MathLink API\"\>", 3->"\<\"MathLink Mathematica Functions\"\>",
        4->"\<\"Parallel & Grid Computing\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LinkLaunch", "ObjectName",
 CellID->8645],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LinkLaunch",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LinkLaunch"], "[", "\"\<\!\(\*
StyleBox[\"prog\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]starts the external program ",
     Cell[BoxData[
      StyleBox["prog", "TI"]], "InlineFormula"],
     " and opens a ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " connection to it. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24733]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinkLaunch",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkLaunch"], "[", "\"\<\!\(\*
StyleBox[\"prog\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " runs ",
 Cell[BoxData[
  StyleBox["prog", "TI"]], "InlineFormula"],
 " as a subsidiary or child process to your current ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. "
}], "Notes",
 CellID->7905],

Cell[TextData[{
 "You can use a command such as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinkLaunch",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkLaunch"], "[", "\"\<math -mathlink\>\"", 
   "]"}]], "InlineFormula"],
 " to launch a subsidiary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel process from within your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. "
}], "Notes",
 CellID->20512],

Cell[TextData[{
 "On most computer systems calling ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinkLaunch",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkLaunch"], "[", "\"\<\!\(\*
StyleBox[\"prog\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " multiple times with the same argument will start several ",
 Cell[BoxData[
  StyleBox["prog", "TI"]], "InlineFormula"],
 " processes running. "
}], "Notes",
 CellID->8945],

Cell[TextData[{
 "On some computer systems, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinkLaunch",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkLaunch"], "[", "]"}]], "InlineFormula"],
 " will bring up a program browser. "
}], "Notes",
 CellID->14017],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LinkLaunch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkLaunch"]], "InlineFormula"],
 " returns a ",
 Cell[BoxData[
  ButtonBox["LinkObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkObject"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22202],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["LinkProtocol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkProtocol"]], "InlineFormula"],
 " specifies the underlying data transport protocol to use. "
}], "Notes",
 CellID->9221],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LinkLaunch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkLaunch"]], "InlineFormula"],
 " internally calls a function analogous to the ",
 Cell[BoxData[
  RowBox[{"MLOpenArgv", 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " function in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library. "
}], "Notes",
 CellID->13878]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->119198997],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->534563740],

Cell[TextData[{
 "Launch a subsidiary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel process:"
}], "ExampleText",
 CellID->609497087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kernel", "=", 
  RowBox[{"LinkLaunch", "[", 
   RowBox[{
    RowBox[{"First", "[", "$CommandLine", "]"}], " ", "<>", " ", 
    "\"\< -mathlink\>\""}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->320545019],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"MathKernel -mathlink\"\>", ",", "450", ",", "9"}], 
  "]"}]], "Output",
 ImageSize->{279, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->186654624]
}, Open  ]],

Cell[TextData[{
 "Read the first packet from the subsidiary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " process:"
}], "ExampleText",
 CellID->1412893454],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "kernel", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->677592424],

Cell[BoxData[
 RowBox[{"InputNamePacket", "[", "\<\"In[1]:= \"\>", "]"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->19795083]
}, Open  ]],

Cell["Close the link and the subsidiary kernel:", "ExampleText",
 CellID->1763338333],

Cell[BoxData[
 RowBox[{"LinkClose", "[", "kernel", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1773596499]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18192],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Install",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Install"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkCreate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkCreate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkConnect",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkConnect"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkClose",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkClose"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkProtocol",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkProtocol"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Links",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Links"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Linked",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Linked"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11680]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19549],

Cell[TextData[{
 ButtonBox["Calling Subsidiary ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CallingSubsidiaryMathematicaProcesses"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CallingSubsidiaryMathematicaProcesses"],
  FontSlant->"Italic"],
 ButtonBox[" Processes",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CallingSubsidiaryMathematicaProcesses"]
}], "Tutorials",
 CellID->13033],

Cell[TextData[{
 ButtonBox["Running ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/RunningMathematicaFromWithinAnExternalProgram"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/RunningMathematicaFromWithinAnExternalProgram"],
  FontSlant->"Italic"],
 ButtonBox[" from Within an External Program",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/RunningMathematicaFromWithinAnExternalProgram"]
}], "Tutorials",
 CellID->3916]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->12823536],

Cell[TextData[ButtonBox["Calling External Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CallingExternalPrograms"]], "MoreAbout",
 CellID->291318113],

Cell[TextData[ButtonBox["MathLink API",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathLinkAPI"]], "MoreAbout",
 CellID->80378738],

Cell[TextData[ButtonBox["MathLink Mathematica Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathLinkMathematicaFunctions"]], "MoreAbout",
 CellID->30390393],

Cell[TextData[ButtonBox["Parallel & Grid Computing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ParallelAndGridComputing"]], "MoreAbout",
 CellID->40337897]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LinkLaunch - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 53, 40.5004646}", "context" -> "System`", 
    "keywords" -> {
     "child processes", "launching programs", "slave processes", 
      "starting programs", "subsidiary processes"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LinkLaunch[\"prog\"] starts the external program prog and opens a \
MathLink connection to it. ", "synonyms" -> {"link launch"}, "title" -> 
    "LinkLaunch", "type" -> "Symbol", "uri" -> "ref/LinkLaunch"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7571, 246, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->119198997]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15050, 518}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3169, 69, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3792, 96, 47, 1, 70, "ObjectName",
 CellID->8645],
Cell[3842, 99, 664, 21, 70, "Usage",
 CellID->24733]
}, Open  ]],
Cell[CellGroupData[{
Cell[4543, 125, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5021, 142, 428, 15, 70, "Notes",
 CellID->7905],
Cell[5452, 159, 437, 16, 70, "Notes",
 CellID->20512],
Cell[5892, 177, 424, 13, 70, "Notes",
 CellID->8945],
Cell[6319, 192, 262, 9, 70, "Notes",
 CellID->14017],
Cell[6584, 203, 312, 12, 70, "Notes",
 CellID->22202],
Cell[6899, 217, 248, 8, 70, "Notes",
 CellID->9221],
Cell[7150, 227, 384, 14, 70, "Notes",
 CellID->13878]
}, Closed]],
Cell[CellGroupData[{
Cell[7571, 246, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->119198997],
Cell[CellGroupData[{
Cell[7956, 260, 148, 5, 70, "ExampleSection",
 CellID->534563740],
Cell[8107, 267, 148, 6, 70, "ExampleText",
 CellID->609497087],
Cell[CellGroupData[{
Cell[8280, 277, 236, 7, 28, "Input",
 CellID->320545019],
Cell[8519, 286, 260, 8, 36, "Output",
 CellID->186654624]
}, Open  ]],
Cell[8794, 297, 164, 6, 70, "ExampleText",
 CellID->1412893454],
Cell[CellGroupData[{
Cell[8983, 307, 109, 3, 28, "Input",
 CellID->677592424],
Cell[9095, 312, 214, 6, 36, "Output",
 CellID->19795083]
}, Open  ]],
Cell[9324, 321, 85, 1, 70, "ExampleText",
 CellID->1763338333],
Cell[9412, 324, 111, 3, 70, "Input",
 CellID->1773596499]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9572, 333, 311, 9, 70, "SeeAlsoSection",
 CellID->18192],
Cell[9886, 344, 1686, 62, 70, "SeeAlso",
 CellID->11680]
}, Open  ]],
Cell[CellGroupData[{
Cell[11609, 411, 314, 9, 70, "TutorialsSection",
 CellID->19549],
Cell[11926, 422, 444, 12, 70, "Tutorials",
 CellID->13033],
Cell[12373, 436, 490, 15, 70, "Tutorials",
 CellID->3916]
}, Open  ]],
Cell[CellGroupData[{
Cell[12900, 456, 318, 9, 70, "MoreAboutSection",
 CellID->12823536],
Cell[13221, 467, 160, 3, 70, "MoreAbout",
 CellID->291318113],
Cell[13384, 472, 134, 3, 70, "MoreAbout",
 CellID->80378738],
Cell[13521, 477, 169, 3, 70, "MoreAbout",
 CellID->30390393],
Cell[13693, 482, 160, 3, 70, "MoreAbout",
 CellID->40337897]
}, Open  ]],
Cell[13868, 488, 27, 0, 70, "History"],
Cell[13898, 490, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

