(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16815,        607]
NotebookOptionsPosition[     12361,        461]
NotebookOutlinePosition[     14082,        507]
CellTagsIndexPosition[     13956,        501]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Setting Up External Functions to Be Called from Mathematica" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/\
SettingUpExternalFunctionsToBeCalledFromMathematica"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Setting Up External Functions to Be Called from \
Mathematica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LinkObject" :> 
          Documentation`HelpLookup["paclet:ref/LinkObject"], "Install" :> 
          Documentation`HelpLookup["paclet:ref/Install"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"LinkObject\"\>", 
       2->"\<\"Install\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calling External Programs" :> 
          Documentation`HelpLookup["paclet:guide/CallingExternalPrograms"], 
          "External Operations" :> 
          Documentation`HelpLookup["paclet:guide/ExternalOperations"], 
          "Installable MathLink Programs" :> 
          Documentation`HelpLookup[
           "paclet:guide/InstallableMathLinkPrograms"], "MathLink API" :> 
          Documentation`HelpLookup["paclet:guide/MathLinkAPI"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Calling External Programs\"\>", 
       2->"\<\"External Operations\"\>", 
       3->"\<\"Installable MathLink Programs\"\>", 
       4->"\<\"MathLink API\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LinkPatterns", "ObjectName",
 CellID->30648],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LinkPatterns",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LinkPatterns"], "[", 
       StyleBox["link", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the patterns for which definitions were \
set up when the external program associated with the specified ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " connection was installed. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18437]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Each element of the list returned by ",
 Cell[BoxData[
  ButtonBox["LinkPatterns",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkPatterns"]], "InlineFormula"],
 " is wrapped in ",
 Cell[BoxData[
  ButtonBox["HoldForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldForm"]], "InlineFormula"],
 " to prevent evaluation. "
}], "Notes",
 CellID->4848],

Cell[TextData[{
 "The patterns in ",
 Cell[BoxData[
  ButtonBox["LinkPatterns",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkPatterns"]], "InlineFormula"],
 " typically originate in ",
 Cell[BoxData[
  RowBox[{":", 
   RowBox[{
    ButtonBox["Pattern",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Pattern"], ":"}]}]], "InlineFormula"],
 " specifications in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " templates used to create source code for the external program. "
}], "Notes",
 CellID->741],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Uninstall",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Uninstall"], "[", 
   StyleBox["link", "TI"], "]"}]], "InlineFormula"],
 " calls ",
 Cell[BoxData[
  ButtonBox["Unset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unset"]], "InlineFormula"],
 " on the patterns in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinkPatterns",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkPatterns"], "[", 
   StyleBox["link", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29781]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->229759041],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->24127185],

Cell["Set the directory: ", "ExampleText",
 CellContext->"Global`",
 CellID->210774478],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{
   "$InstallationDirectory", "<>", " ", 
    "\"\</SystemFiles/Links/MathLink/DeveloperKit/\>\"", "<>", "$SystemID", 
    "<>", "\"\</PrebuiltExamples/\>\""}], "]"}], ";"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[1]:=",
 CellID->506558866],

Cell[TextData[{
 "Install an external ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "-compatible program:"
}], "ExampleText",
 CellContext->"Global`",
 CellID->287270249],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"link", "=", 
  RowBox[{"Install", "[", "\"\<addtwo\>\"", "]"}]}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[2]:=",
 CellID->825582282],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"addtwo\"\>", ",", "157", ",", "7"}], "]"}]], "Output",
 CellContext->"Global`",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->140199549]
}, Open  ]],

Cell[TextData[{
 "Get the complete set of ",
 Cell[BoxData[
  ButtonBox["LinkPatterns",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkPatterns"]], "InlineFormula"],
 " installed: "
}], "ExampleText",
 CellContext->"Global`",
 CellID->73579464],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkPatterns", "[", "link", "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[3]:=",
 CellID->59619846],

Cell[BoxData[
 RowBox[{"{", 
  TagBox[
   RowBox[{"AddTwo", "[", 
    RowBox[{"i_Integer", ",", "j_Integer"}], "]"}],
   HoldForm], "}"}]], "Output",
 CellContext->"Global`",
 ImageSize->{212, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->36711391]
}, Open  ]],

Cell["Get usage information about linked-in symbols: ", "ExampleText",
 CellContext->"Global`",
 CellID->661897471],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "AddTwo"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[4]:=",
 CellID->227051880],

Cell[BoxData[
 StyleBox["\<\"AddTwo[x, y] gives the sum of two machine integers x and \
y.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->"Info3384534861-1716585",
 CellID->625744173]
}, Open  ]],

Cell["Use the new function: ", "ExampleText",
 CellContext->"Global`",
 CellID->125900338],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AddTwo", "[", 
  RowBox[{"1", ",", "2"}], "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[5]:=",
 CellID->56273106],

Cell[BoxData["3"], "Output",
 CellContext->"Global`",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->25174265]
}, Open  ]],

Cell["Terminate the external program:", "ExampleText",
 CellContext->"Global`",
 CellID->184445389],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Uninstall", "[", "link", "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[6]:=",
 CellID->51547842],

Cell[BoxData["\<\"addtwo\"\>"], "Output",
 CellContext->"Global`",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->244749445]
}, Open  ]],

Cell["Reset to the original directory: ", "ExampleText",
 CellContext->"Global`",
 CellID->82136485],

Cell[BoxData[
 RowBox[{
  RowBox[{"ResetDirectory", "[", "]"}], ";"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[7]:=",
 CellID->304638792]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25249],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkObject",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkObject"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Install",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Install"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11961]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->461],

Cell[TextData[{
 ButtonBox["Setting Up External Functions to Be Called from ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/SettingUpExternalFunctionsToBeCalledFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/SettingUpExternalFunctionsToBeCalledFromMathematica"],
  FontSlant->"Italic"]
}], "Tutorials",
 CellID->766]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->41495739],

Cell[TextData[ButtonBox["Calling External Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CallingExternalPrograms"]], "MoreAbout",
 CellID->74042685],

Cell[TextData[ButtonBox["External Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExternalOperations"]], "MoreAbout",
 CellID->36396649],

Cell[TextData[ButtonBox["Installable MathLink Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InstallableMathLinkPrograms"]], "MoreAbout",
 CellID->338950495],

Cell[TextData[ButtonBox["MathLink API",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathLinkAPI"]], "MoreAbout",
 CellID->360649480]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LinkPatterns - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 53, 41.1098552}", "context" -> "System`", 
    "keywords" -> {
     "information about Mathlink program", "Mathlink program usage", 
      "patterns in MathLink program", "foreign function call", 
      "function call patterns", "external call patterns", 
      "external calling API"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LinkPatterns[link] gives a list of the patterns for which definitions \
were set up when the external program associated with the specified MathLink \
connection was installed. ", "synonyms" -> {"link patterns"}, "title" -> 
    "LinkPatterns", "type" -> "Symbol", "uri" -> "ref/LinkPatterns"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5779, 190, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->229759041]},
 "Info3384534861-1716585"->{
  Cell[8370, 300, 185, 4, 70, "Print",
   CellTags->"Info3384534861-1716585",
   CellID->625744173]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13682, 490},
 {"Info3384534861-1716585", 13831, 494}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2425, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3048, 85, 50, 1, 70, "ObjectName",
 CellID->30648],
Cell[3101, 88, 664, 19, 70, "Usage",
 CellID->18437]
}, Open  ]],
Cell[CellGroupData[{
Cell[3802, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4280, 129, 379, 13, 70, "Notes",
 CellID->4848],
Cell[4662, 144, 521, 18, 70, "Notes",
 CellID->741],
Cell[5186, 164, 556, 21, 70, "Notes",
 CellID->29781]
}, Closed]],
Cell[CellGroupData[{
Cell[5779, 190, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->229759041],
Cell[CellGroupData[{
Cell[6164, 204, 147, 5, 70, "ExampleSection",
 CellID->24127185],
Cell[6314, 211, 87, 2, 70, "ExampleText",
 CellID->210774478],
Cell[6404, 215, 319, 9, 70, "Input",
 CellID->506558866],
Cell[6726, 226, 174, 7, 70, "ExampleText",
 CellID->287270249],
Cell[CellGroupData[{
Cell[6925, 237, 167, 5, 28, "Input",
 CellID->825582282],
Cell[7095, 244, 268, 8, 36, "Output",
 CellID->140199549]
}, Open  ]],
Cell[7378, 255, 250, 9, 70, "ExampleText",
 CellID->73579464],
Cell[CellGroupData[{
Cell[7653, 268, 135, 4, 70, "Input",
 CellID->59619846],
Cell[7791, 274, 304, 11, 36, "Output",
 CellID->36711391]
}, Open  ]],
Cell[8110, 288, 115, 2, 70, "ExampleText",
 CellID->661897471],
Cell[CellGroupData[{
Cell[8250, 294, 117, 4, 70, "Input",
 CellID->227051880],
Cell[8370, 300, 185, 4, 70, "Print",
 CellTags->"Info3384534861-1716585",
 CellID->625744173]
}, Open  ]],
Cell[8570, 307, 90, 2, 70, "ExampleText",
 CellID->125900338],
Cell[CellGroupData[{
Cell[8685, 313, 149, 5, 70, "Input",
 CellID->56273106],
Cell[8837, 320, 182, 6, 36, "Output",
 CellID->25174265]
}, Open  ]],
Cell[9034, 329, 99, 2, 70, "ExampleText",
 CellID->184445389],
Cell[CellGroupData[{
Cell[9158, 335, 132, 4, 70, "Input",
 CellID->51547842],
Cell[9293, 341, 196, 6, 36, "Output",
 CellID->244749445]
}, Open  ]],
Cell[9504, 350, 100, 2, 70, "ExampleText",
 CellID->82136485],
Cell[9607, 354, 148, 5, 70, "Input",
 CellID->304638792]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9804, 365, 311, 9, 70, "SeeAlsoSection",
 CellID->25249],
Cell[10118, 376, 453, 17, 70, "SeeAlso",
 CellID->11961]
}, Open  ]],
Cell[CellGroupData[{
Cell[10608, 398, 312, 9, 70, "TutorialsSection",
 CellID->461],
Cell[10923, 409, 389, 11, 70, "Tutorials",
 CellID->766]
}, Open  ]],
Cell[CellGroupData[{
Cell[11349, 425, 318, 9, 70, "MoreAboutSection",
 CellID->41495739],
Cell[11670, 436, 159, 3, 70, "MoreAbout",
 CellID->74042685],
Cell[11832, 441, 148, 3, 70, "MoreAbout",
 CellID->36396649],
Cell[11983, 446, 168, 3, 70, "MoreAbout",
 CellID->338950495],
Cell[12154, 451, 135, 3, 70, "MoreAbout",
 CellID->360649480]
}, Open  ]],
Cell[12304, 457, 27, 0, 70, "History"],
Cell[12334, 459, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

