(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17260,        606]
NotebookOptionsPosition[     13204,        470]
NotebookOutlinePosition[     14581,        509]
CellTagsIndexPosition[     14496,        504]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Using MathLink to Communicate between Mathematica Sessions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/\
UsingMathLinkToCommunicateBetweenMathematicaSessions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Using MathLink to Communicate between Mathematica \
Sessions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LinkReadyQ" :> 
          Documentation`HelpLookup["paclet:ref/LinkReadyQ"], "LinkWrite" :> 
          Documentation`HelpLookup["paclet:ref/LinkWrite"], "Read" :> 
          Documentation`HelpLookup["paclet:ref/Read"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"LinkReadyQ\"\>", 2->"\<\"LinkWrite\"\>", 
       3->"\<\"Read\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calling External Programs" :> 
          Documentation`HelpLookup["paclet:guide/CallingExternalPrograms"], 
          "External Operations" :> 
          Documentation`HelpLookup["paclet:guide/ExternalOperations"], 
          "MathLink API" :> 
          Documentation`HelpLookup["paclet:guide/MathLinkAPI"], 
          "MathLink Expression Packet Handling" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkExpressionPacketHandling"], 
          "MathLink Mathematica Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkMathematicaFunctions"], 
          "Parallel & Grid Computing" :> 
          Documentation`HelpLookup[
           "paclet:guide/ParallelAndGridComputing"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Calling External Programs\"\>", 
       2->"\<\"External Operations\"\>", 3->"\<\"MathLink API\"\>", 
       4->"\<\"MathLink Expression Packet Handling\"\>", 
       5->"\<\"MathLink Mathematica Functions\"\>", 
       6->"\<\"Parallel & Grid Computing\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LinkRead", "ObjectName",
 CellID->17248],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LinkRead",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LinkRead"], "[", 
       StyleBox["link", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]reads one expression from the specified ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " connection. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LinkRead",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LinkRead"], "[", 
       RowBox[{
        StyleBox["link", "TI"], ",", 
        StyleBox["h", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]wraps ",
     Cell[BoxData[
      StyleBox["h", "TI"]], "InlineFormula"],
     " around the expression read before evaluating it. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->22911]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["link", "TI"]], "InlineFormula"],
 " must be an active ",
 Cell[BoxData[
  ButtonBox["LinkObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkObject"]], "InlineFormula"],
 ", as returned by functions like ",
 Cell[BoxData[
  ButtonBox["LinkLaunch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkLaunch"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Links",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Links"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->16035],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LinkRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkRead"]], "InlineFormula"],
 " will wait until it has read a complete expression before returning. "
}], "Notes",
 CellID->26403],

Cell[TextData[{
 "You can test whether an expression is ready to be read from a particular \
link using ",
 Cell[BoxData[
  ButtonBox["LinkReadyQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkReadyQ"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14986],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinkRead",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkRead"], "[", 
   RowBox[{
    StyleBox["link", "TI"], ",", 
    ButtonBox["Hold",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Hold"]}], "]"}]], "InlineFormula"],
 " to get an expression from a link without evaluating it. "
}], "Notes",
 CellID->7054]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->531503518],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->16329661],

Cell[TextData[{
 "Launch a subsidiary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel process:"
}], "ExampleText",
 CellID->609497087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kernel", "=", 
  RowBox[{"LinkLaunch", "[", 
   RowBox[{
    RowBox[{"First", "[", "$CommandLine", "]"}], " ", "<>", " ", 
    "\"\< -mathlink\>\""}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->320545019],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"MathKernel -mathlink\"\>", ",", "598", ",", "9"}], 
  "]"}]], "Output",
 ImageSize->{279, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->296479811]
}, Open  ]],

Cell["Read the first packet:", "ExampleText",
 CellID->747935290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "kernel", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1944338714],

Cell[BoxData[
 RowBox[{"InputNamePacket", "[", "\<\"In[1]:= \"\>", "]"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->124051113]
}, Open  ]],

Cell["Write a packet to enter 10!:", "ExampleText",
 CellID->1412893454],

Cell[BoxData[
 RowBox[{"LinkWrite", "[", 
  RowBox[{"kernel", ",", 
   RowBox[{"EnterTextPacket", "[", "\"\<10!\>\"", "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->677592424],

Cell["Read a packet representing the output prompt:", "ExampleText",
 CellID->634289832],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "kernel", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->400382716],

Cell[BoxData[
 RowBox[{"OutputNamePacket", "[", "\<\"Out[1]= \"\>", "]"}]], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->590204679]
}, Open  ]],

Cell["Read the actual result from the computation:", "ExampleText",
 CellID->1875598252],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "kernel", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->267367051],

Cell[BoxData[
 RowBox[{"ReturnTextPacket", "[", "\<\"3628800\"\>", "]"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->376550964]
}, Open  ]],

Cell["Close the link:", "ExampleText",
 CellID->1763338333],

Cell[BoxData[
 RowBox[{"LinkClose", "[", "kernel", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1773596499]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32340],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkReadyQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkReadyQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkWrite"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Read",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Read"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31683]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24840],

Cell[TextData[{
 ButtonBox["Using ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UsingMathLinkToCommunicateBetweenMathematicaSessions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UsingMathLinkToCommunicateBetweenMathematicaSessions"],
  FontSlant->"Italic"],
 ButtonBox[" to Communicate between ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UsingMathLinkToCommunicateBetweenMathematicaSessions"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UsingMathLinkToCommunicateBetweenMathematicaSessions"],
  FontSlant->"Italic"],
 ButtonBox[" Sessions",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UsingMathLinkToCommunicateBetweenMathematicaSessions"]
}], "Tutorials",
 CellID->10361]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->643013878],

Cell[TextData[ButtonBox["Calling External Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CallingExternalPrograms"]], "MoreAbout",
 CellID->10789311],

Cell[TextData[ButtonBox["External Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExternalOperations"]], "MoreAbout",
 CellID->966549282],

Cell[TextData[ButtonBox["MathLink API",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathLinkAPI"]], "MoreAbout",
 CellID->197864610],

Cell[TextData[ButtonBox["MathLink Expression Packet Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathLinkExpressionPacketHandling"]], "MoreAbout",
 CellID->708808023],

Cell[TextData[ButtonBox["MathLink Mathematica Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathLinkMathematicaFunctions"]], "MoreAbout",
 CellID->516719802],

Cell[TextData[ButtonBox["Parallel & Grid Computing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ParallelAndGridComputing"]], "MoreAbout",
 CellID->370641704]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LinkRead - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 53, 48.1725360}", "context" -> "System`", 
    "keywords" -> {
     "get data from Mathlink", "reading expression from Mathlink", 
      "read packet"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LinkRead[link] reads one expression from the specified MathLink \
connection. LinkRead[link, h] wraps h around the expression read before \
evaluating it. ", "synonyms" -> {"link read"}, "title" -> "LinkRead", "type" -> 
    "Symbol", "uri" -> "ref/LinkRead"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6585, 212, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->531503518]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14353, 497}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2909, 67, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3532, 94, 46, 1, 70, "ObjectName",
 CellID->17248],
Cell[3581, 97, 1006, 32, 70, "Usage",
 CellID->22911]
}, Open  ]],
Cell[CellGroupData[{
Cell[4624, 134, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5102, 151, 539, 20, 70, "Notes",
 CellID->16035],
Cell[5644, 173, 236, 7, 70, "Notes",
 CellID->26403],
Cell[5883, 182, 264, 9, 70, "Notes",
 CellID->14986],
Cell[6150, 193, 398, 14, 70, "Notes",
 CellID->7054]
}, Closed]],
Cell[CellGroupData[{
Cell[6585, 212, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->531503518],
Cell[CellGroupData[{
Cell[6970, 226, 147, 5, 70, "ExampleSection",
 CellID->16329661],
Cell[7120, 233, 148, 6, 70, "ExampleText",
 CellID->609497087],
Cell[CellGroupData[{
Cell[7293, 243, 236, 7, 28, "Input",
 CellID->320545019],
Cell[7532, 252, 260, 8, 36, "Output",
 CellID->296479811]
}, Open  ]],
Cell[7807, 263, 65, 1, 70, "ExampleText",
 CellID->747935290],
Cell[CellGroupData[{
Cell[7897, 268, 110, 3, 28, "Input",
 CellID->1944338714],
Cell[8010, 273, 215, 6, 36, "Output",
 CellID->124051113]
}, Open  ]],
Cell[8240, 282, 72, 1, 70, "ExampleText",
 CellID->1412893454],
Cell[8315, 285, 186, 5, 70, "Input",
 CellID->677592424],
Cell[8504, 292, 88, 1, 70, "ExampleText",
 CellID->634289832],
Cell[CellGroupData[{
Cell[8617, 297, 109, 3, 70, "Input",
 CellID->400382716],
Cell[8729, 302, 216, 6, 36, "Output",
 CellID->590204679]
}, Open  ]],
Cell[8960, 311, 88, 1, 70, "ExampleText",
 CellID->1875598252],
Cell[CellGroupData[{
Cell[9073, 316, 109, 3, 70, "Input",
 CellID->267367051],
Cell[9185, 321, 215, 6, 36, "Output",
 CellID->376550964]
}, Open  ]],
Cell[9415, 330, 59, 1, 70, "ExampleText",
 CellID->1763338333],
Cell[9477, 333, 111, 3, 70, "Input",
 CellID->1773596499]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9637, 342, 311, 9, 70, "SeeAlsoSection",
 CellID->32340],
Cell[9951, 353, 694, 26, 70, "SeeAlso",
 CellID->31683]
}, Open  ]],
Cell[CellGroupData[{
Cell[10682, 384, 314, 9, 70, "TutorialsSection",
 CellID->24840],
Cell[10999, 395, 806, 24, 70, "Tutorials",
 CellID->10361]
}, Open  ]],
Cell[CellGroupData[{
Cell[11842, 424, 319, 9, 70, "MoreAboutSection",
 CellID->643013878],
Cell[12164, 435, 159, 3, 70, "MoreAbout",
 CellID->10789311],
Cell[12326, 440, 149, 3, 70, "MoreAbout",
 CellID->966549282],
Cell[12478, 445, 135, 3, 70, "MoreAbout",
 CellID->197864610],
Cell[12616, 450, 179, 3, 70, "MoreAbout",
 CellID->708808023],
Cell[12798, 455, 170, 3, 70, "MoreAbout",
 CellID->516719802],
Cell[12971, 460, 161, 3, 70, "MoreAbout",
 CellID->370641704]
}, Open  ]],
Cell[13147, 466, 27, 0, 70, "History"],
Cell[13177, 468, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

