(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22369,        729]
NotebookOptionsPosition[     18607,        609]
NotebookOutlinePosition[     20157,        649]
CellTagsIndexPosition[     20072,        644]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Using MathLink to Communicate between Mathematica Sessions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/\
UsingMathLinkToCommunicateBetweenMathematicaSessions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Using MathLink to Communicate between Mathematica \
Sessions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LinkRead" :> Documentation`HelpLookup["paclet:ref/LinkRead"], 
          "LinkWrite" :> Documentation`HelpLookup["paclet:ref/LinkWrite"], 
          "LinkInterrupt" :> 
          Documentation`HelpLookup["paclet:ref/LinkInterrupt"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"LinkRead\"\>", 
       2->"\<\"LinkWrite\"\>", 
       3->"\<\"LinkInterrupt\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink Mathematica Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkMathematicaFunctions"], 
          "Parallel & Grid Computing" :> 
          Documentation`HelpLookup[
           "paclet:guide/ParallelAndGridComputing"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"MathLink Mathematica Functions\"\>", 
       2->"\<\"Parallel & Grid Computing\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["LinkReadyQ", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LinkReadyQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LinkReadyQ"], "[", 
       StyleBox["link", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]tests whether there is an expression ready to read from \
the specified ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " connection. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LinkReadyQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LinkReadyQ"], "[", 
       RowBox[{
        StyleBox["link", "TI"], ",", 
        StyleBox["t", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]waits for up to ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " seconds to see if an expression becomes ready to read."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LinkReadyQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LinkReadyQ"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["link", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["link", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["t", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]tests all the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["link", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " in parallel, returning as soon as any of them are ready to read from."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->1542]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["link", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " must be active ",
 Cell[BoxData[
  ButtonBox["LinkObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkObject"]], "InlineFormula"],
 " objects, as returned by functions like ",
 Cell[BoxData[
  ButtonBox["LinkLaunch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkLaunch"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Links",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Links"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28985],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinkReadyQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkReadyQ"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["link", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["link", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["t", "TI"]}], "]"}]], "InlineFormula"],
 " returns a list of ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", specifying which of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["link", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are ready to read from."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->80844356],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinkReadyQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkReadyQ"], "[", 
   StyleBox["link", "TI"], "]"}]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", then ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinkRead",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkRead"], "[", 
   StyleBox["link", "TI"], "]"}]], "InlineFormula"],
 " will not block under any normal circumstances. "
}], "Notes",
 CellID->15550],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinkReadyQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkReadyQ"], "[", 
   StyleBox["link", "TI"], "]"}]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", then ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinkRead",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkRead"], "[", 
   StyleBox["link", "TI"], "]"}]], "InlineFormula"],
 " will block, and will not return until something becomes available to read \
on ",
 Cell[BoxData[
  StyleBox["link", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12293],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinkReadyQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkReadyQ"], "[", 
   StyleBox["link", "TI"], "]"}]], "InlineFormula"],
 " tests whether there is any data to read; it cannot determine whether the \
data represents a complete expression. "
}], "Notes",
 CellID->7450],

Cell[TextData[{
 "The basic form of ",
 Cell[BoxData[
  ButtonBox["LinkReadyQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkReadyQ"]], "InlineFormula"],
 " corresponds to the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library function ",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"MLReady", 
    RowBox[{"(", ")"}]}],
   BaseStyle->"Link",
   ButtonData->"paclet:ref/c/MLReady"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->26573]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->973392732],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->109791493],

Cell[TextData[{
 "Launch a subsidiary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel process:"
}], "ExampleText",
 CellID->292720395],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"link", "=", 
  RowBox[{"LinkLaunch", "[", 
   RowBox[{
    RowBox[{"First", "[", "$CommandLine", "]"}], " ", "<>", " ", 
    "\"\< -mathlink\>\""}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->320545019],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"MathKernel -mathlink\"\>", ",", "643", ",", "9"}], 
  "]"}]], "Output",
 ImageSize->{279, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14857775]
}, Open  ]],

Cell["Test whether there is an expression ready to be read:", "ExampleText",
 CellID->650030284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkReadyQ", "[", "link", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->383001458],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->793368768]
}, Open  ]],

Cell["Read the expression:", "ExampleText",
 CellID->747935290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1944338714],

Cell[BoxData[
 RowBox[{"InputNamePacket", "[", "\<\"In[1]:= \"\>", "]"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->45334629]
}, Open  ]],

Cell["Close the link:", "ExampleText",
 CellID->2014127135],

Cell[BoxData[
 RowBox[{"LinkClose", "[", "link", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1773596499]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24882],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkRead",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkRead"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkWrite"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkInterrupt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkInterrupt"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1370]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24013],

Cell[TextData[{
 ButtonBox["Using ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UsingMathLinkToCommunicateBetweenMathematicaSessions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UsingMathLinkToCommunicateBetweenMathematicaSessions"],
  FontSlant->"Italic"],
 ButtonBox[" to Communicate between ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UsingMathLinkToCommunicateBetweenMathematicaSessions"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UsingMathLinkToCommunicateBetweenMathematicaSessions"],
  FontSlant->"Italic"],
 ButtonBox[" Sessions",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UsingMathLinkToCommunicateBetweenMathematicaSessions"]
}], "Tutorials",
 CellID->5554]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->2290150],

Cell[TextData[ButtonBox["MathLink Mathematica Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathLinkMathematicaFunctions"]], "MoreAbout",
 CellID->24831214],

Cell[TextData[ButtonBox["Parallel & Grid Computing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ParallelAndGridComputing"]], "MoreAbout",
 CellID->84218023]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LinkReadyQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 53, 48.4225424}", "context" -> "System`", 
    "keywords" -> {
     "data available", "MathLink expression ready", "synchronization"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "LinkReadyQ[link] tests whether there is an expression ready to read from \
the specified MathLink connection. LinkReadyQ[link, t] waits for up to t \
seconds to see if an expression becomes ready to read. LinkReadyQ[{link_1, \
link_2, ...}, t] tests all the link_i in parallel, returning as soon as any \
of them are ready to read from.", "synonyms" -> {"link ready q"}, "title" -> 
    "LinkReadyQ", "type" -> "Symbol", "uri" -> "ref/LinkReadyQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[13366, 401, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->973392732]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19928, 637}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2292, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2915, 83, 4194, 83, 70, "ObjectNameGrid"],
Cell[7112, 168, 1847, 57, 70, "Usage",
 CellID->1542]
}, Open  ]],
Cell[CellGroupData[{
Cell[8996, 230, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9474, 247, 596, 23, 70, "Notes",
 CellID->28985],
Cell[10073, 272, 1044, 37, 70, "Notes",
 CellID->80844356],
Cell[11120, 311, 591, 22, 70, "Notes",
 CellID->15550],
Cell[11714, 335, 692, 26, 70, "Notes",
 CellID->12293],
Cell[12409, 363, 339, 10, 70, "Notes",
 CellID->7450],
Cell[12751, 375, 578, 21, 70, "Notes",
 CellID->26573]
}, Closed]],
Cell[CellGroupData[{
Cell[13366, 401, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->973392732],
Cell[CellGroupData[{
Cell[13751, 415, 148, 5, 70, "ExampleSection",
 CellID->109791493],
Cell[13902, 422, 148, 6, 70, "ExampleText",
 CellID->292720395],
Cell[CellGroupData[{
Cell[14075, 432, 234, 7, 28, "Input",
 CellID->320545019],
Cell[14312, 441, 259, 8, 36, "Output",
 CellID->14857775]
}, Open  ]],
Cell[14586, 452, 96, 1, 70, "ExampleText",
 CellID->650030284],
Cell[CellGroupData[{
Cell[14707, 457, 109, 3, 28, "Input",
 CellID->383001458],
Cell[14819, 462, 161, 5, 36, "Output",
 CellID->793368768]
}, Open  ]],
Cell[14995, 470, 63, 1, 70, "ExampleText",
 CellID->747935290],
Cell[CellGroupData[{
Cell[15083, 475, 108, 3, 70, "Input",
 CellID->1944338714],
Cell[15194, 480, 214, 6, 36, "Output",
 CellID->45334629]
}, Open  ]],
Cell[15423, 489, 59, 1, 70, "ExampleText",
 CellID->2014127135],
Cell[15485, 492, 109, 3, 70, "Input",
 CellID->1773596499]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15643, 501, 311, 9, 70, "SeeAlsoSection",
 CellID->24882],
Cell[15957, 512, 707, 26, 70, "SeeAlso",
 CellID->1370]
}, Open  ]],
Cell[CellGroupData[{
Cell[16701, 543, 314, 9, 70, "TutorialsSection",
 CellID->24013],
Cell[17018, 554, 805, 24, 70, "Tutorials",
 CellID->5554]
}, Open  ]],
Cell[CellGroupData[{
Cell[17860, 583, 317, 9, 70, "MoreAboutSection",
 CellID->2290150],
Cell[18180, 594, 169, 3, 70, "MoreAbout",
 CellID->24831214],
Cell[18352, 599, 160, 3, 70, "MoreAbout",
 CellID->84218023]
}, Open  ]],
Cell[18527, 605, 50, 0, 70, "History"],
Cell[18580, 607, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

