(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21051,        681]
NotebookOptionsPosition[     17204,        554]
NotebookOutlinePosition[     18603,        593]
CellTagsIndexPosition[     18518,        588]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Setting Up External Functions to Be Called from Mathematica" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/\
SettingUpExternalFunctionsToBeCalledFromMathematica"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Setting Up External Functions to Be Called from \
Mathematica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$ParentLink" :> 
          Documentation`HelpLookup["paclet:ref/$ParentLink"], "$CurrentLink" :> 
          Documentation`HelpLookup["paclet:ref/$CurrentLink"], "Streams" :> 
          Documentation`HelpLookup["paclet:ref/Streams"], "LinkReadyQ" :> 
          Documentation`HelpLookup["paclet:ref/LinkReadyQ"], "LinkLaunch" :> 
          Documentation`HelpLookup["paclet:ref/LinkLaunch"], "LinkClose" :> 
          Documentation`HelpLookup["paclet:ref/LinkClose"], "LinkObject" :> 
          Documentation`HelpLookup["paclet:ref/LinkObject"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"$ParentLink\"\>", 
       2->"\<\"$CurrentLink\"\>", 3->"\<\"Streams\"\>", 
       4->"\<\"LinkReadyQ\"\>", 5->"\<\"LinkLaunch\"\>", 
       6->"\<\"LinkClose\"\>", 7->"\<\"LinkObject\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Mathematica Session Information" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaSessionInformation"], "MathLink API" :> 
          Documentation`HelpLookup["paclet:guide/MathLinkAPI"], 
          "MathLink Mathematica Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkMathematicaFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Mathematica Session Information\"\>", 
       2->"\<\"MathLink API\"\>", 
       3->"\<\"MathLink Mathematica Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Links", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Links",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Links"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of all ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " connections that are currently open. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Links",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Links"], "[", 
       StyleBox["patt", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]lists only links whose names match the specified string \
pattern."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->3648]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Links",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Links"]], "InlineFormula"],
 " returns a list of ",
 Cell[BoxData[
  ButtonBox["LinkObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkObject"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->23088]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->43129460],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->138884744],

Cell[TextData[{
 "List of all ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " connections ending in ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"shm\", \"TI\"]\)\>\""], "InlineFormula"],
 " that are currently open:"
}], "ExampleText",
 CellID->1859203921],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Links", "[", "\"\<*shm\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1753236397],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"LinkObject", "[", 
    RowBox[{"\<\"dc5_shm\"\>", ",", "1", ",", "1"}], "]"}], ",", 
   RowBox[{"LinkObject", "[", 
    RowBox[{"\<\"y5u_shm\"\>", ",", "2", ",", "2"}], "]"}], ",", 
   RowBox[{"LinkObject", "[", 
    RowBox[{"\<\"mvs_shm\"\>", ",", "3", ",", "3"}], "]"}], ",", 
   RowBox[{"LinkObject", "[", 
    RowBox[{"\<\"v9e_shm\"\>", ",", "5", ",", "5"}], "]"}], ",", 
   RowBox[{"LinkObject", "[", 
    RowBox[{"\<\"g7v_shm\"\>", ",", "6", ",", "6"}], "]"}]}], "}"}]], "Output",\

 ImageSize->{549, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->58396374]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->310516695],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["LinkCreate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkCreate"]], "InlineFormula"],
 " to create a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " connection:"
}], "ExampleText",
 CellID->468830655],

Cell[CellGroupData[{

Cell["link = LinkCreate[]", "Input",
 CellLabel->"In[1]:=",
 CellID->519317742],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"tcc_shm\"\>", ",", "275", ",", "7"}], "]"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->197539002]
}, Open  ]],

Cell["\<\
The newly created link appears in the list of open connections:\
\>", "ExampleText",
 CellID->1643914063],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemberQ", "[", 
  RowBox[{
   RowBox[{"Links", "[", "]"}], ",", "link"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->502642494],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->14880843]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->786832602],

Cell[TextData[{
 "Obtain the name of the link object used to invoke ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ":"
}], "ExampleText",
 CellID->1605815999],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Last", "[", "$CommandLine", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->91243588],

Cell[BoxData["\<\"as2_shm\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->805941394]
}, Open  ]],

Cell[TextData[{
 "Get the ",
 Cell[BoxData[
  ButtonBox["LinkObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkObject"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->438503102],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Links", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1446048603],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"LinkObject", "[", 
   RowBox[{"\<\"as2_shm\"\>", ",", "1", ",", "1"}], "]"}], "}"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1277647329]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13446],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ParentLink",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$ParentLink"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$CurrentLink",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$CurrentLink"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Streams",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Streams"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkReadyQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkReadyQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkLaunch",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkLaunch"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkClose",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkClose"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkObject",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkObject"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21073]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5995],

Cell[TextData[{
 ButtonBox["Setting Up External Functions to Be Called from ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/SettingUpExternalFunctionsToBeCalledFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/SettingUpExternalFunctionsToBeCalledFromMathematica"],
  FontSlant->"Italic"]
}], "Tutorials",
 CellID->4039]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->103497326],

Cell[TextData[ButtonBox["Mathematica Session Information",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessionInformation"]], "MoreAbout",
 CellID->144771516],

Cell[TextData[ButtonBox["MathLink API",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathLinkAPI"]], "MoreAbout",
 CellID->306483572],

Cell[TextData[ButtonBox["MathLink Mathematica Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathLinkMathematicaFunctions"]], "MoreAbout",
 CellID->383727076]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Links - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 53, 49.0788092}", "context" -> "System`", 
    "keywords" -> {
     "links", "link objects", "active links", "external Mathlink programs", 
      "Mathlink connections", "discovering open links"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Links[] gives a list of all MathLink connections that are currently \
open. Links[patt] lists only links whose names match the specified string \
pattern.", "synonyms" -> {}, "title" -> "Links", "type" -> "Symbol", "uri" -> 
    "ref/Links"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9388, 242, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->43129460]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18376, 581}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2855, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3478, 91, 4189, 83, 70, "ObjectNameGrid"],
Cell[7670, 176, 848, 27, 70, "Usage",
 CellID->3648]
}, Open  ]],
Cell[CellGroupData[{
Cell[8555, 208, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9033, 225, 318, 12, 70, "Notes",
 CellID->23088]
}, Closed]],
Cell[CellGroupData[{
Cell[9388, 242, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->43129460],
Cell[CellGroupData[{
Cell[9772, 256, 148, 5, 70, "ExampleSection",
 CellID->138884744],
Cell[9923, 263, 254, 9, 70, "ExampleText",
 CellID->1859203921],
Cell[CellGroupData[{
Cell[10202, 276, 113, 3, 28, "Input",
 CellID->1753236397],
Cell[10318, 281, 670, 18, 54, "Output",
 CellID->58396374]
}, Open  ]],
Cell[11003, 302, 125, 3, 70, "ExampleDelimiter",
 CellID->310516695],
Cell[11131, 307, 266, 11, 70, "ExampleText",
 CellID->468830655],
Cell[CellGroupData[{
Cell[11422, 322, 79, 2, 70, "Input",
 CellID->519317742],
Cell[11504, 326, 244, 7, 36, "Output",
 CellID->197539002]
}, Open  ]],
Cell[11763, 336, 115, 3, 70, "ExampleText",
 CellID->1643914063],
Cell[CellGroupData[{
Cell[11903, 343, 157, 5, 70, "Input",
 CellID->502642494],
Cell[12063, 350, 160, 5, 36, "Output",
 CellID->14880843]
}, Open  ]],
Cell[12238, 358, 125, 3, 70, "ExampleDelimiter",
 CellID->786832602],
Cell[12366, 363, 164, 6, 70, "ExampleText",
 CellID->1605815999],
Cell[CellGroupData[{
Cell[12555, 373, 110, 3, 70, "Input",
 CellID->91243588],
Cell[12668, 378, 172, 5, 36, "Output",
 CellID->805941394]
}, Open  ]],
Cell[12855, 386, 195, 8, 70, "ExampleText",
 CellID->438503102],
Cell[CellGroupData[{
Cell[13075, 398, 102, 3, 70, "Input",
 CellID->1446048603],
Cell[13180, 403, 267, 8, 36, "Output",
 CellID->1277647329]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13508, 418, 311, 9, 70, "SeeAlsoSection",
 CellID->13446],
Cell[13822, 429, 1702, 62, 70, "SeeAlso",
 CellID->21073]
}, Open  ]],
Cell[CellGroupData[{
Cell[15561, 496, 313, 9, 70, "TutorialsSection",
 CellID->5995],
Cell[15877, 507, 390, 11, 70, "Tutorials",
 CellID->4039]
}, Open  ]],
Cell[CellGroupData[{
Cell[16304, 523, 319, 9, 70, "MoreAboutSection",
 CellID->103497326],
Cell[16626, 534, 172, 3, 70, "MoreAbout",
 CellID->144771516],
Cell[16801, 539, 135, 3, 70, "MoreAbout",
 CellID->306483572],
Cell[16939, 544, 170, 3, 70, "MoreAbout",
 CellID->383727076]
}, Open  ]],
Cell[17124, 550, 50, 0, 70, "History"],
Cell[17177, 552, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

