(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    135655,       4543]
NotebookOptionsPosition[    114025,       3763]
NotebookOutlinePosition[    115322,       3800]
CellTagsIndexPosition[    115235,       3795]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Making Lists of Objects" :> 
          Documentation`HelpLookup["paclet:tutorial/MakingListsOfObjects"], 
          "Operations on Scalars, Vectors and Matrices" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OperationsOnScalarsVectorsAndMatrices"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Making Lists of Objects\"\>", 
       2->"\<\"Operations on Scalars, Vectors and Matrices\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Sequence" :> Documentation`HelpLookup["paclet:ref/Sequence"], 
          "ListPlot" :> Documentation`HelpLookup["paclet:ref/ListPlot"], 
          "Listable" :> Documentation`HelpLookup["paclet:ref/Listable"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Sequence\"\>", 
       2->"\<\"ListPlot\"\>", 3->"\<\"Listable\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Core Language" :> 
          Documentation`HelpLookup["paclet:guide/CoreLanguageOverview"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Core Language\"\>", 
       2->"\<\"List Manipulation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "List ",
 StyleBox["({...})", "OperatorCharacter"]
}], "ObjectName",
 CellID->15056],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
     "\[LineSeparator]is a list of elements. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8309]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Lists are very general objects that represent collections of expressions. \
\>", "Notes",
 CellID->17892],

Cell[TextData[{
 "Functions with attribute ",
 Cell[BoxData[
  ButtonBox["Listable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
 " are automatically \"threaded\" over lists, so that they act separately on \
each list element. Most built\[Hyphen]in mathematical functions are ",
 Cell[BoxData[
  ButtonBox["Listable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4338],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"], ",", 
    StyleBox["c", "TI"]}], "}"}]], "InlineFormula"],
 " represents a vector. "
}], "Notes",
 CellID->618],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["c", "TI"], ",", 
      StyleBox["d", "TI"]}], "}"}]}], "}"}]], "InlineFormula"],
 " represents a matrix. "
}], "Notes",
 CellID->26630],

Cell["Nested lists can be used to represent tensors. ", "Notes",
 CellID->13140]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->240544338],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->693056281],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"List", "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14519],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22426]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3418],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"List", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->13713]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(19)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17740],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Representation of Vectors, Matrices and other Arrays",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->139292986],

Cell["A vector is a list of nonlist elements:", "ExampleText",
 CellID->377632319],

Cell[BoxData[
 RowBox[{
  RowBox[{"v", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2.3", ",", 
     RowBox[{"x", "+", "4"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->209410081],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorQ", "[", "v", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->50520839],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->419520607]
}, Open  ]],

Cell[TextData[{
 "Many operations work on vectors, like ",
 Cell[BoxData[
  ButtonBox["Dot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Norm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Norm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->139852321],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", ".", "v"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->159275699],

Cell[BoxData[
 RowBox[{"6.289999999999999`", "\[InvisibleSpace]", "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"4", "+", "x"}], ")"}], "2"]}]], "Output",
 ImageSize->{91, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->551057742]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->697811082],

Cell["A matrix is a list of vectors of equal length:", "ExampleText",
 CellID->474967222],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4", ",", "9"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17117278],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixQ", "[", "m", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->36298892],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->880402698]
}, Open  ]],

Cell[TextData[{
 "Many operations work with matrices, like ",
 Cell[BoxData[
  ButtonBox["Dot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Transpose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Transpose"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Det",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Det"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->588593625],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", ".", 
  RowBox[{"Transpose", "[", "m", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->142746469],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"14", ",", "36"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"36", ",", "98"}], "}"}]}], "}"}]], "Output",
 ImageSize->{136, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->66807155]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", "m", "]"}], ".", "m"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->42117054],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1071722404]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->81728638],

Cell["\<\
A rectangular array is represented by nested lists with consistent \
dimensions:\
\>", "ExampleText",
 CellID->126322054],

Cell[BoxData[
 RowBox[{
  RowBox[{"ra", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"7", ",", "8", ",", "9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "11", ",", "12"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"13", ",", "14", ",", "15"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16", ",", "17", ",", "18"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"19", ",", "20", ",", "21"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"22", ",", "23", ",", "24"}], "}"}]}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->583789452],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayQ", "[", "ra", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->40944997],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->698287863]
}, Open  ]],

Cell[TextData[{
 "Many operations work on arrays of any depth, like ",
 Cell[BoxData[
  ButtonBox["Dot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Fourier",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fourier"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->740120202],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ra", ".", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->216219848],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"14", ",", "32"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"50", ",", "68"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"86", ",", "104"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"122", ",", "140"}], "}"}]}], "}"}]], "Output",
 ImageSize->{286, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->40795815]
}, Open  ]],

Cell["The three-dimensional discrete Fourier transform:", "ExampleText",
 CellID->118181887],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fourier", "[", "ra", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->134188521],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXM9z3DQUduzdTdNutgkzhMCluUAPwJFeChzhxI0D3LoTOtPAMDCl/wFc
gH8WGCjcXEuWssrnz/q1lm1SdSaxnyy99/T06Vn6rOaL7YtnT7/fvri63F58
/nz747Ory58uPvvheVNUHRTFwd9FUXx5XjT3dXMnf8S/f5qf9ra9uyd+V/pp
XSxA/hnkj0F+7GiP+j9y6EMZ9aFcyV7cddT6pflVNuInxhW1iHL09hG0+zTQ
u9LLu6Pm17IRl81VFJfKmpYrdUX5CPQsI/UcNtdDJZv6DtXzhdKD9lbwPFbP
0lMPixuOoqnnTiJ/x9YzDMoQ2ytZ6VpWPshWS7O0UIjplqKfKK9IPKbzQGvR
keba+vDpVzveBu+1zQa2FvUQA6VVK86PMfo5Txvhs42OHyBxqdEMrVc69h0f
YUZ45AJtB+fW0HbMKAkNG6p3Xe/eQN2nmyAdfEagDswxm7obn66WewP6OZ4O
7KsLqQeyXeh7geeMI1oqoitg1J9nFgSbDKvpLPZHH7Gyz0iiLj/0Yu458YrM
cUK/x9cVl39DUS3zwI2MJ/C1UJjpellan7oQnc5aRnNG883nReG7miy9ap2O
aEvvWPkInNHStbXNm9Y2cQi16xzOd3ubaZCF7XmGovuwYGQNaes8IMIPaCkf
9TOwvg+CuN0QH3ld9NEPKS4mUMx7vRfTXFlV9LNKp4H1Ma9sVPm5umKk9fO3
ep4jTt4gvba197Xf9zyUxWmZTHGLHG34nWssn4A8N1b3vdond23rcVhdreeh
l1dDsblzYyszS7sfS/uuF3qmZ2nnydBlRvV2MaqiXZvl58akzoUTzPxnKP/5
fh2TYdPznXNlNDKrMxSr80Edg7y0nORcI55RNy3qUvJ592np8EzZ68vyDTPm
QzJtfMwfBPSd1729/Fs7hin4NnGN5bH+rzzahzKa4jY9b5ZPQ8bwZgsvr2J5
s9PIdlPzSplPu52nHjF/5VOOMDqZk5vIhmt2lRprs+Pk8unGtsrrzO7JsZ4B
u4enGPLpxb43X+Zo1GptYmYQEZtPJ9YZrbvI7Y3WfBox85RpkJRPHxINAyGG
203PfrbIyKcN4+zHsqQS3VLYnyXFvj0BOZQVRflPaQXnq+u0Xx/7+BfVxlZc
JmuoWaoSZMZ2IRcjxLmwbbEsI8p/BEWRv1/D9+X43vb7xj01zzIFL4ayaNfO
I5Yp2Bt8DfJKu6AM41isii7/s6jnxTzEsSzYq5c1wz7GS8pddPuUWPK43+nM
6fcfcXswjPS/XpEW77LrLNOJZkWfoOUc17qzt6XcmWGFry5xHY2RPaatpj4T
4hchzuLxUoyDX7R4rWnPVPDY4KrvjoqsmI16haS/IJhyqeqd1OOcT0Dv/5Pe
i9v9V76uVRLKX4H8G8i/Otp/I62GrtW+VpH/3biyVdrTKO16fPU6wlzzabki
M07jAPOD70p3A/bMlW91PbX0v0NaetqjQ69z5G2x2wVgue7DMqGP7HtlSp9x
fC+jUOHOdibyLCydUwevNcz/YuF5t+9LMj19gz5YnrNMxux0Vt7S+E7ujpZt
3zRdf/E5+6sJ4/Wf7ZjafEvZYlccnLhFfpH+zQhLH3Qe8F9dLnu8MHd20lMS
kRUp6/saf6R0sh6sim48bThI5bvOgql9xzx0JcvTZFN6tsmCqGH2luckgr65
PO4Lu3u97R8zlHH80vfO9VfxxuwtovnbOhatbB7ivl3ndxffgnr8cPk2i6OD
fekfKZ96iNO7nXb0TWHlJWz88jS9dOF1jF4Ph1Nb/kM+JHS3t6bx0wzEO1Ab
16BD8gc2nt6VJ9iY961FxuwTrpZT9WkYrLnWviHvlZBSzo09pKW2CE6NQL/3
28Xo/doXhX79ug9yi8HQfGQyNeK9u65vshEmg1MV/QzdmSo/rnffSBnTh9/i
N0a5+W3eZOnZee5Qeyd72sO5+p2Mtrj14QSLg1ePovv7\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{500, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->28221018]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->35901885],

Cell["Ragged arrays that are not rectangular can also be used:", "ExampleText",
 CellID->209993991],

Cell[BoxData[
 RowBox[{
  RowBox[{"ragged", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}], ",", 
     RowBox[{"{", "6", "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->280919768],

Cell["Many structural functions will work with ragged arrays:", "ExampleText",
 CellID->316227341],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ragged", "[", 
  RowBox[{"[", 
   RowBox[{"All", ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->85698737],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "4", ",", "6"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->136875805]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"Total", ",", "ragged"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->991473272],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", "9", ",", "6"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->509967971]
}, Open  ]],

Cell[TextData[{
 "If the elements are at the same depth you can use ",
 Cell[BoxData[
  ButtonBox["PadRight",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PadRight"]], "InlineFormula"],
 " to make a rectangular array:"
}], "ExampleText",
 CellID->197369176],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PadRight", "[", "ragged", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->335629842],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->48977499]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Constructing Lists",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->3078886],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Range",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Range"]], "InlineFormula"],
 " constructs a list consisting of a range of values:"
}], "ExampleText",
 CellID->382335087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Range", "[", "4", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->173869405],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->331584928]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Range", "[", 
  RowBox[{"4", ",", 
   RowBox[{"-", "4"}], ",", 
   RowBox[{"-", "2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->98046970],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "2", ",", "0", ",", 
   RowBox[{"-", "2"}], ",", 
   RowBox[{"-", "4"}]}], "}"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->286777298]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Range", "[", 
  RowBox[{"0.", ",", "1.", ",", ".1"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->458364094],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.`", ",", "0.1`", ",", "0.2`", ",", "0.30000000000000004`", ",", "0.4`", 
   ",", "0.5`", ",", "0.6000000000000001`", ",", "0.7000000000000001`", ",", 
   "0.8`", ",", "0.9`", ",", "1.`"}], "}"}]], "Output",
 ImageSize->{347, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->392236778]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->391030073],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Array",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Array"]], "InlineFormula"],
 " constructs lists using a function:"
}], "ExampleText",
 CellID->351958655],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{"f", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->683885709],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "1", "]"}], ",", 
   RowBox[{"f", "[", "2", "]"}], ",", 
   RowBox[{"f", "[", "3", "]"}], ",", 
   RowBox[{"f", "[", "4", "]"}]}], "}"}]], "Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->331356290]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "^", "#"}], "&"}], ",", "4"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->397804539],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "4", ",", "8", ",", "16"}], "}"}]], "Output",
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->445437436]
}, Open  ]],

Cell["\<\
When given multiple dimensions, matrices or deeper arrays are constructed:\
\>", "ExampleText",
 CellID->228252792],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"h", "[", 
    RowBox[{"i_", ",", "j_"}], "]"}], ":=", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"i", "+", "j", "-", "1"}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Array", "[", 
  RowBox[{"h", ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3"}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->445920851],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     FractionBox["1", "2"], ",", 
     FractionBox["1", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     FractionBox["1", "3"], ",", 
     FractionBox["1", "4"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "3"], ",", 
     FractionBox["1", "4"], ",", 
     FractionBox["1", "5"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "4"], ",", 
     FractionBox["1", "5"], ",", 
     FractionBox["1", "6"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{327, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->63568681]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->258825259],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " constructs lists using an expression and an iterator:"
}], "ExampleText",
 CellID->219510804],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"f", "[", "i", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32493989],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "1", "]"}], ",", 
   RowBox[{"f", "[", "2", "]"}], ",", 
   RowBox[{"f", "[", "3", "]"}], ",", 
   RowBox[{"f", "[", "4", "]"}]}], "}"}]], "Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->518273200]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"2", "^", "i"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19869994],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "16"], ",", 
   FractionBox["1", "8"], ",", 
   FractionBox["1", "4"], ",", 
   FractionBox["1", "2"], ",", "1", ",", "2", ",", "4", ",", "8", ",", "16"}],
   "}"}]], "Output",
 ImageSize->{201, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->87466388]
}, Open  ]],

Cell["\<\
When given multiple iterators, matrices and arrays can be constructed:\
\>", "ExampleText",
 CellID->279888978],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"h", "[", 
    RowBox[{"i_", ",", "j_"}], "]"}], ":=", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"i", "+", "j", "-", "1"}], ")"}]}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->226481533],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"h", "[", 
    RowBox[{"i", ",", "j"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->41436093],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     FractionBox["1", "2"], ",", 
     FractionBox["1", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     FractionBox["1", "3"], ",", 
     FractionBox["1", "4"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "3"], ",", 
     FractionBox["1", "4"], ",", 
     FractionBox["1", "5"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "4"], ",", 
     FractionBox["1", "5"], ",", 
     FractionBox["1", "6"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{327, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->325809948]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"h", "[", 
    RowBox[{"i", ",", "j"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "i"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->229202020],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     FractionBox["1", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "3"], ",", 
     FractionBox["1", "4"], ",", 
     FractionBox["1", "5"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "4"], ",", 
     FractionBox["1", "5"], ",", 
     FractionBox["1", "6"], ",", 
     FractionBox["1", "7"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{282, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->83804664]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->99798847],

Cell[TextData[{
 "Functional commands like ",
 Cell[BoxData[
  ButtonBox["NestList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NestList"]], "InlineFormula"],
 " create lists of the results:"
}], "ExampleText",
 CellID->285827941],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"3", "#", 
     RowBox[{"(", 
      RowBox[{"1", "-", "#"}], ")"}]}], "&"}], ",", ".1", ",", "20"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16199504],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.1`", ",", "0.27`", ",", "0.5912999999999999`", ",", 
   "0.7249929300000001`", ",", "0.5981345443500452`", ",", 
   "0.721108833615627`", ",", "0.6033326510914109`", ",", 
   "0.7179670896552622`", ",", "0.6074710434816446`", ",", 
   "0.7153499244388993`", ",", "0.6108732301324811`", ",", 
   "0.7131213805199696`", ",", "0.6137378314957869`", ",", 
   "0.7111911170599079`", ",", "0.6161949362249649`", ",", 
   "0.709496210387029`", ",", "0.6183340135004209`", ",", 
   "0.7079911837466466`", ",", "0.6202190024510061`", ",", 
   "0.706642174349055`", ",", "0.6218970353408844`"}], "}"}]], "Output",
 ImageSize->{478, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->600929530]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"%", ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8264930],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnEtPFEEQgIfZWYgyXlAT3q5/wpvxYNSTJxHPK9HAAVDkB3jw/Th6IOIj
KP4AJXr0dfEVveKBCx44oImYEIwE137Ndk9Nz0zvzC40a22yj9rq6a76umqm
p3rheHly+MxoeXJkqFw6NlE+NzwydKF0dHyCfFVocRxnjjzPdjrkc4V8Ys+5
SoW876WvBSqzhzOd8q1Lviwy7crK77W1dfqxk7zQxiXx7op2/UJ2PHa4ePQR
wVNa7dCOyA4pLC39IsPQjz1A388aSZn3p7boBXIByKzHIperr5FeWrfIut7U
HqRlck4aaVGfImcn1SXs3W9mj2whjivVzQpVXzKzpqha44gId1rV47LMVbf4
fp94L1Rk/rgifVyROareLHPu1NhKZ2GtfSS18pm8sfE3pJdyMae+0e03e/wW
RrWDvM6w86eer5SLcfr19Y2Q/H15VcpEKaK3evzq6h+pJ5MH9bB/Mb/Z2pPB
YPtNtVeOz3I3Qnk3kxcWfihWucSiotaab4s/oTUkAaT+6/xyyBqZHXrr09qT
wciQsn2CnUSV3U4NNTGupEbPH3saaoWGVk3tN4tW/LgZYwypIbUc1DAzMcaQ
mo3UMDMxxpCajdQwM01p8YIRf6i1I1alUaoW8H4MY9GIbqg61Qb5AqZQRsaN
YUxFZIvxayNj2ocbsA1pPKRbF7rR/QBdHOMKIssKok2JXlw14Lof1/0208IY
Q2qYmTbSwhhDapiZttFKq5UFtQVc9WaiG1trqLbBWgMybkLGWI/MxjaoleEe
RZ0rZAnx6iHjnCuHoEYWRK1XwTWYOUlc5yM1vDuylRbGGFLDzLSRFsZYXmod
TJ59/OXQwambN97wuw+kZlgjYy3AvZpbve89dfIJoXrk8DRS1VON/hLE4O8X
ocwj+P27xfGxZy+ezwPWj2Y+kzm4festsq4D6+6QzYMDanwj29rZUjHMNBzH
UVvv3/sYiuf/h2nw1/zJvx8LaO7SWgUjVlrFz+r8Onj1yiuhbw56rA+j34eZ
k4RxCkmGr32qR55CWsaxtSRTfgdG33tiSPlaMpAcJAPJQQsfPvgUImfLSjIu
XiCFdq3XkAocHWZu2GuncHfqg6DiAe/VeLt+7XXuzK6v9752NEgDeitp6L3N
m30yxsJ3pqaRnualr/VKeq33iujHRnNkzuDArNA3dg6hd+3AGz9TBjDvn1K9
XdbD4+V/AmlkxGS3ym5m9lqXdg+s/k7EvpnXrBoT15GmqyH0Zmu8Ue+cbPWi
kLCLb7Pt0Na03XLLfDHYlbbr3GT3ed9+63BGm806nNFms86+GY2sZyPX7215
3a5bnc8Gj1oj85JWRd++XtgwJ1wvq+A7t4E3coeP6+UOCdfLqpDOm1p2a/Kc
wyBZX5HpvrsPbOWyrPPx42UFTPiinMPovAR7JPnPXPEU9ZbK6hWUO5mJplco
lZOc03gOcLQD1dHU2VJp0xpwmg8ntDZ3Kb1cvvQytZfTCb3EH3U+5EE30F7U
9sn/J7bT8g+/bpS/\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->584332872]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->210393110],

Cell[TextData[{
 "To construct a list when the length is not known ahead of time, ",
 Cell[BoxData[
  ButtonBox["Sow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sow"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Reap",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reap"]], "InlineFormula"],
 " are efficient:"
}], "ExampleText",
 CellID->252253405],

Cell[BoxData[
 RowBox[{"rolls", " ", ":=", " ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"prev", "=", "0"}], ",", "next", ",", " ", 
      RowBox[{"r6", "=", 
       RowBox[{"Range", "[", "6", "]"}]}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"Reap", "[", "\[IndentingNewLine]", 
      RowBox[{"While", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"next", "=", 
           RowBox[{"RandomChoice", "[", "r6", "]"}]}], ")"}], "\[NotEqual]", 
         "prev"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Sow", "[", "next", "]"}], ";", 
         RowBox[{"prev", "=", "next"}]}]}], "]"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", "1"}], "]"}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30196012],

Cell["\<\
Some trials of rolling a die until the same number comes up twice in a row:\
\>", "ExampleText",
 CellID->290704949],

Cell[CellGroupData[{

Cell[BoxData["rolls"], "Input",
 CellLabel->"In[2]:=",
 CellID->246867975],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", "3", ",", "2"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->196540173]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["rolls"], "Input",
 CellLabel->"In[3]:=",
 CellID->68351010],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", "1"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->320281763]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["rolls"], "Input",
 CellLabel->"In[4]:=",
 CellID->259890839],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", "1", ",", "2", ",", "4", ",", "5", ",", "1", ",", "2"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->129421152]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Listable Functions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->391413977],

Cell["Add two vectors:", "ExampleText",
 CellID->237459754],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "+", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->162354393],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", "a"}], ",", 
   RowBox[{"2", "+", "b"}], ",", 
   RowBox[{"3", "+", "c"}]}], "}"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37800407]
}, Open  ]],

Cell["Scalar multiple:", "ExampleText",
 CellID->314806771],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", "*", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->299282514],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "4", ",", "6"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->280229554]
}, Open  ]],

Cell["Sine of a vector:", "ExampleText",
 CellID->129658073],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"2", " ", "Pi", " ", 
   RowBox[{"Range", "[", 
    RowBox[{"0.", ",", "1.", ",", 
     RowBox[{"1", "/", "13"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->443819908],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.`", ",", "0.46472317204376856`", ",", "0.8229838658936565`", ",", 
   "0.992708874098054`", ",", "0.9350162426854148`", ",", 
   "0.6631226582407952`", ",", "0.23931566428755768`", ",", 
   RowBox[{"-", "0.2393156642875583`"}], ",", 
   RowBox[{"-", "0.6631226582407953`"}], ",", 
   RowBox[{"-", "0.9350162426854147`"}], ",", 
   RowBox[{"-", "0.992708874098054`"}], ",", 
   RowBox[{"-", "0.822983865893656`"}], ",", 
   RowBox[{"-", "0.4647231720437684`"}], ",", 
   RowBox[{"-", "2.4492935982947064`*^-16"}]}], "}"}]], "Output",
 ImageSize->{510, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->86784660]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->110300142],

Cell["Scalar multiple of a matrix:", "ExampleText",
 CellID->146473879],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "*", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->176522230],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"2", " ", "a"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", " ", "a"}], ",", 
     RowBox[{"4", " ", "a"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{138, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->115961594]
}, Open  ]],

Cell["\<\
Matrix plus a vector adds the component of the vector to the rows of the \
matrix:\
\>", "ExampleText",
 CellID->290048179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], "}"}], "+", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13646456],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", "a"}], ",", 
     RowBox[{"2", "+", "a"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "+", "b"}], ",", 
     RowBox[{"4", "+", "b"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{187, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->183816647]
}, Open  ]],

Cell["Function applied elementwise to a matrix:", "ExampleText",
 CellID->147036007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1.", ",", "2.", ",", "3."}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4.", ",", "5.", ",", "6."}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->412107387],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "2.718281828459045`", ",", "7.38905609893065`", ",", 
     "20.085536923187668`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "54.598150033144236`", ",", "148.4131591025766`", ",", 
     "403.4287934927351`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{396, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->376097868]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->44139790],

Cell[TextData[{
 "Any function that has the ",
 Cell[BoxData[
  ButtonBox["Listable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
 " attribute will thread over lists elementwise:"
}], "ExampleText",
 CellID->40325209],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", "Listable"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->197037909],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->64889264],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "1", "]"}], ",", 
   RowBox[{"f", "[", "2", "]"}], ",", 
   RowBox[{"f", "[", "3", "]"}], ",", 
   RowBox[{"f", "[", "4", "]"}]}], "}"}]], "Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->712890097]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Operations on List Elements",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->15700557],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Apply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Apply"]], "InlineFormula"],
 " makes the elements of a list the arguments of a function: "
}], "ExampleText",
 CellID->16104382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->459365832],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"1", ",", "2", ",", "3"}], "]"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->96733543]
}, Open  ]],

Cell[TextData[{
 "If you have a nested list, applying at level 1 gives a list ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " applied to the sublists:"
}], "ExampleText",
 CellID->759420512],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "6"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", "1", "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->398687728],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"1", ",", "2"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"3", ",", "4"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"5", ",", "6"}], "]"}]}], "}"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->283882399]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->376613042],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 " applies a function to the elements of a list:"
}], "ExampleText",
 CellID->467761975],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19311491],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "1", "]"}], ",", 
   RowBox[{"f", "[", "2", "]"}], ",", 
   RowBox[{"f", "[", "3", "]"}], ",", 
   RowBox[{"f", "[", "4", "]"}]}], "}"}]], "Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->574999198]
}, Open  ]],

Cell[TextData[{
 "For a nested list, ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 " can apply ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " at any level or multiple levels:"
}], "ExampleText",
 CellID->415592216],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "6"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->361592007],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "1", "]"}], ",", 
     RowBox[{"f", "[", "2", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "3", "]"}], ",", 
     RowBox[{"f", "[", "4", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "5", "]"}], ",", 
     RowBox[{"f", "[", "6", "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{284, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->373740437]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "6"}], "}"}]}], "}"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->298558107],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], ",", 
      RowBox[{"f", "[", "2", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"f", "[", "3", "]"}], ",", 
      RowBox[{"f", "[", "4", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"f", "[", "5", "]"}], ",", 
      RowBox[{"f", "[", "6", "]"}]}], "}"}], "]"}]}], "}"}]], "Output",
 ImageSize->{347, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->276745883]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->59157918],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Do",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Do"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Product",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Product"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Sum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sum"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " can iterate over a list:"
}], "ExampleText",
 CellID->171631101],

Cell[BoxData[
 RowBox[{
  RowBox[{"list", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "8"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->206232631],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"Log", "[", 
       RowBox[{"2", ",", "i"}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "list"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->404374084],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->677654904],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->717906298],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "2"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->553184690],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"8", ",", "3"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->841616841]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"2", ",", "i"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "list"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->28172078],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->42596184]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{"k", ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "list"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->269420831],

Cell[BoxData["15"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->161532676]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->104044563],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 " can be used to get elements of lists:"
}], "ExampleText",
 CellID->166624717],

Cell[BoxData[
 RowBox[{
  RowBox[{"list", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "8"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->592747453],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"list", "[", 
  RowBox[{"[", "3", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->90901646],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->93337733]
}, Open  ]],

Cell["You can get multiple parts by specifying a list of parts:", \
"ExampleText",
 CellID->456077875],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"list", "[", 
  RowBox[{"[", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->716114506],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "8"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->197152462]
}, Open  ]],

Cell[TextData[{
 "Or by using ",
 Cell[BoxData[
  ButtonBox["Span",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Span"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->892711240],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"list", "[", 
  RowBox[{"[", 
   RowBox[{"1", ";;", 
    RowBox[{"-", "1"}], ";;", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->62810570],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "4"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->114674558]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->176706357],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Outer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Outer"]], "InlineFormula"],
 " to apply a function to elements of multiple lists: "
}], "ExampleText",
 CellID->93830436],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->386301060],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"1", ",", "a"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"1", ",", "b"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"1", ",", "c"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"2", ",", "a"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"2", ",", "b"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"2", ",", "c"}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{380, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->448074114]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Lists as Finite Sets",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->476849031],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Complement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complement"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Union",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Union"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Intersection",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Intersection"]], "InlineFormula"],
 " treat ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 " as a set: "
}], "ExampleText",
 CellID->457621728],

Cell[BoxData[{
 RowBox[{
  RowBox[{"s1", "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s2", "=", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d", ",", "e"}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->629174268],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Complement", "[", 
  RowBox[{"s1", ",", "s2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->153126914],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->138580621]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{"s1", ",", "s2"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->108206179],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->478209764]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Intersection", "[", 
  RowBox[{"s1", ",", "s2"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->750175521],

Cell[BoxData[
 RowBox[{"{", "c", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->225296869]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->660563844],

Cell[TextData[{
 "Construct various combinatorial structures using ",
 Cell[BoxData[
  ButtonBox["Subsets",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Subsets"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Tuples",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tuples"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["IntegerPartitions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerPartitions"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->101412333],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subsets", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->67894136],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", "3", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{349, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->551625458]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tuples", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->603872052],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "b"}], "}"}]}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->404864141]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerPartitions", "[", "5", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->304445848],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "5", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{469, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->355962395]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Lists as Control Structures",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->305705386],

Cell[TextData[{
 "Many commands use ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["var", "TI"], ",", " ", 
    StyleBox["vmin", "TI"], ",", " ", 
    StyleBox["vmax", "TI"]}], "}"}]], "InlineFormula"],
 " as a specification of variable range:"
}], "ExampleText",
 CellID->281076404],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"Pi", "/", "2"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->255288681],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->538401458]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "t", "]"}], "\[Equal]", 
      RowBox[{"x", "[", "t", "]"}]}], ",", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", "x", ",",
    
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->541119807],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{309, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->186031695]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"var", "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"var", ",", 
     RowBox[{"-", "1"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->333527026],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0", ",", "1", ",", "4", ",", "9"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->111750774]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->342772075],

Cell[TextData[{
 "Many commands use ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["v", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["v", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 " for a collection of variables:"
}], "ExampleText",
 CellID->44595354],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "+", "y", "+", "z"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"x", "+", "y"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{"y", "+", "z"}], "==", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->767900118],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "2"}]}], ",", 
    RowBox[{"y", "\[Rule]", "3"}], ",", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"-", "1"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{160, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->73640392]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "t", "]"}], "\[Equal]", 
      RowBox[{"y", "[", "t", "]"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "t", "]"}], "\[Equal]", 
      RowBox[{"-", 
       RowBox[{"x", "[", "t", "]"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "t"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->102391728],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"C", "[", "1", "]"}], " ", 
         RowBox[{"Cos", "[", "t", "]"}]}], "+", 
        RowBox[{
         RowBox[{"C", "[", "2", "]"}], " ", 
         RowBox[{"Sin", "[", "t", "]"}]}]}]}], "]"}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"C", "[", "2", "]"}], " ", 
         RowBox[{"Cos", "[", "t", "]"}]}], "-", 
        RowBox[{
         RowBox[{"C", "[", "1", "]"}], " ", 
         RowBox[{"Sin", "[", "t", "]"}]}]}]}], "]"}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{316, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->83460430]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Lists of Rules",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->61436655],

Cell["\<\
A list of rules is returned as a solution by many solving commands:\
\>", "ExampleText",
 CellID->74458003],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "=", 
  RowBox[{"FindRoot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", "y"}], "]"}], ",", 
      RowBox[{"(", 
       RowBox[{"x", "-", 
        RowBox[{"2", " ", "y"}]}], ")"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "2"}], "}"}]}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->339649584],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "\[Rule]", 
    RowBox[{"-", "1.5280048226806118`"}]}], ",", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"-", "0.7640024113403059`"}]}]}], "}"}]], "Output",
 ImageSize->{182, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->110963697]
}, Open  ]],

Cell[TextData[{
 "You can use the values of the results with ",
 Cell[BoxData[
  ButtonBox["ReplaceAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceAll"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->666074],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}], " ", "/.", "r"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->58681330],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.5280048226806118`"}], ",", 
   RowBox[{"-", "0.7640024113403059`"}]}], "}"}]], "Output",
 ImageSize->{136, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->103876126]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", "y"}], "]"}], ",", 
    RowBox[{"(", 
     RowBox[{"x", "-", 
      RowBox[{"2", " ", "y"}]}], ")"}]}], "}"}], "/.", "r"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->431129932],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "5.267838178243384`*^-15"}], ",", "0.`"}], "}"}]], "Output",
 ImageSize->{141, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->58814732]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->450568691],

Cell["\<\
When multiple solutions are possible, the result is a list of rule lists:\
\>", "ExampleText",
 CellID->98218888],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s2", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], ",", 
      RowBox[{
       RowBox[{"x", "+", "y"}], "==", "0"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->102347436],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", 
        SqrtBox["2"]]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox["1", 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox["1", 
       SqrtBox["2"]]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", 
        SqrtBox["2"]]}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{299, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->317569889]
}, Open  ]],

Cell["\<\
When a list of rule lists is used in ReplaceAll, you get a list of results:\
\>", "ExampleText",
 CellID->443783751],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}], " ", "/.", " ", "s2"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->713145512],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["2"]]}], ",", 
     FractionBox["1", 
      SqrtBox["2"]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["2"]], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["2"]]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{207, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->173343180]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], " ", "&&", " ", 
   RowBox[{
    RowBox[{"x", "+", "y"}], "==", "0"}]}], " ", "/.", "s2"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->62456138],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->139993086]
}, Open  ]],

Cell[TextData[{
 "Even if there is only one solution, the extra ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 " is used for consistent structure:"
}], "ExampleText",
 CellID->217166982],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "-", "y"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{"x", "+", "y"}], "==", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->713351396],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     FractionBox["1", "2"]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{120, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->6242456]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Lists of Data",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->647498807],

Cell["\<\
Lists are very good for holding data since the elements can be anything:\
\>", "ExampleText",
 CellID->216481517],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "\"\<George\>\"", ",", "\"\<Washington\>\"", ",", "1789", ",", 
       "False"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<John\>\"", "\"\<Adams\>\""}], ",", "1797", ",", "True"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Thomas\>\"", ",", "\"\<Jefferson\>\"", ",", "1801", ",", "True"}], 
      "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->100811809],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29244195],

Cell["Sine of successive squares:", "ExampleText",
 CellID->369071445],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ssq", "=", 
  RowBox[{"N", "[", 
   RowBox[{"Sin", "[", 
    RowBox[{
     RowBox[{"Range", "[", "10", "]"}], "^", "2"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->462848773],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.8414709848078965`", ",", 
   RowBox[{"-", "0.7568024953079282`"}], ",", "0.4121184852417566`", ",", 
   RowBox[{"-", "0.2879033166650653`"}], ",", 
   RowBox[{"-", "0.13235175009777303`"}], ",", 
   RowBox[{"-", "0.9917788534431158`"}], ",", 
   RowBox[{"-", "0.9537526527594719`"}], ",", "0.9200260381967906`", ",", 
   RowBox[{"-", "0.6298879942744539`"}], ",", 
   RowBox[{"-", "0.5063656411097588`"}]}], "}"}]], "Output",
 ImageSize->{374, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->219390948]
}, Open  ]],

Cell["Plot the data:", "ExampleText",
 CellID->38975542],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", "ssq", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1634213],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{1., 0.8414709848078965}, {2., -0.7568024953079282}, {3., 
     0.4121184852417566}, {4., -0.2879033166650653}, {
     5., -0.13235175009777303`}, {6., -0.9917788534431158}, {
     7., -0.9537526527594719}, {8., 0.9200260381967906}, {
     9., -0.6298879942744539}, {10., -0.5063656411097588}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 10.}, {-0.9917788534431158, 0.9200260381967906}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->506587948]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->60532774],

Cell["Data from a function sampled at points in two dimensions:", \
"ExampleText",
 CellID->9944371],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{"Sin", "[", 
    RowBox[{"2", " ", "Pi", " ", "x", " ", "y"}], "]"}]}], ";"}], "\n", 
 RowBox[{"Short", "[", 
  RowBox[{"data", " ", "=", " ", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], ",", 
         RowBox[{"f", "[", 
          RowBox[{"x", ",", "y"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0.", ",", "1.", ",", ".1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "0.", ",", "1.", ",", ".1"}], "}"}]}], "]"}], ",", 
     "1"}], "]"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->59028123],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.`", ",", "0.`"}], "}"}], ",", "0.`"}], "}"}], ",", 
    RowBox[{"\[LeftSkeleton]", "119", "\[RightSkeleton]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1.`", ",", "1.`"}], "}"}], ",", 
      RowBox[{"-", "2.4492935982947064`*^-16"}]}], "}"}]}], "}"}],
  Short]], "Output",
 ImageSize->{358, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->27300275]
}, Open  ]],

Cell["A piecewise polynomial that interpolates the data:", "ExampleText",
 CellID->122510873],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ifun", " ", "=", " ", 
  RowBox[{"Interpolation", "[", "data", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8969631],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.`", ",", "1.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.`", ",", "1.`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
   "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{322, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->216555946]
}, Open  ]],

Cell[TextData[{
 "Plot the ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->553394784],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"ifun", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->19594258],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->64339668]
}, Open  ]],

Cell["Plot the data directly:", "ExampleText",
 CellID->103999514],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{"Map", "[", 
   RowBox[{"Flatten", ",", "data"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->181559384],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->416260522]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30179],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " represents a list:"
}], "ExampleText",
 CellID->787688225],

Cell[BoxData[
 RowBox[{
  RowBox[{"list", "=", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0",
      ",", "0", ",", "1"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->76735992],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"slist", "=", 
  RowBox[{"SparseArray", "[", "list", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->639279098],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "4", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 4, ">"],
     Editable->False], ",", 
    RowBox[{"{", "10", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->717944103]
}, Open  ]],

Cell[TextData[{
 "They are ",
 Cell[BoxData[
  ButtonBox["Equal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Equal"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->22656942],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"slist", "\[Equal]", "list"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->10969802],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->448175938]
}, Open  ]],

Cell["They can be equivalently used in many commands:", "ExampleText",
 CellID->546576124],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"slist", "+", "3"}], " ", "\[Equal]", " ", 
  RowBox[{"list", "+", "3"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->456512681],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->711099965]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   RowBox[{"N", "[", "slist", "]"}], "]"}], "\[Equal]", 
  RowBox[{"Sin", "[", 
   RowBox[{"N", "[", "list", "]"}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->100911950],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->203764504]
}, Open  ]],

Cell["\<\
They are not identical because the representation is different:\
\>", "ExampleText",
 CellID->294693722],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"slist", "===", "list"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->563313325],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->401675973]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Normal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Normal"], "[", 
    StyleBox["slist", "TI"], "]"}], " "}]], "InlineFormula"],
 "gives the ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 " representation:"
}], "ExampleText",
 CellID->112213029],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "slist", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->328682228],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", 
   ",", "0", ",", "1"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->127745241]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "===", "list"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->43959925],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->67680316]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5214],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sequence"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Listable",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Listable"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15644]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7798],

Cell[TextData[ButtonBox["Making Lists of Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MakingListsOfObjects"]], "Tutorials",
 CellID->29085],

Cell[TextData[ButtonBox["Operations on Scalars, Vectors and Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/OperationsOnScalarsVectorsAndMatrices"]], "Tutorials",
 CellID->527030841]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->466175841],

Cell[TextData[ButtonBox["Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CoreLanguageOverview"]], "MoreAbout",
 CellID->57067689],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->217225326]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"List ({...}) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 56, 58.5524096}", "context" -> "System`", 
    "keywords" -> {
     "array", "collection", "dyad", "pair", "sequence", "set", "triple", 
      "tuple", "vector", "matrix", "tensor", "finite set"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "{e_1, e_2, ...} is a list of elements. ", "synonyms" -> {"{ }"}, "title" -> 
    "List", "type" -> "Symbol", "uri" -> "ref/List"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5374, 181, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->240544338]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 115092, 3788}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2274, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2897, 80, 101, 4, 70, "ObjectName",
 CellID->15056],
Cell[3001, 86, 572, 19, 70, "Usage",
 CellID->8309]
}, Open  ]],
Cell[CellGroupData[{
Cell[3610, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4088, 127, 115, 3, 70, "Notes",
 CellID->17892],
Cell[4206, 132, 467, 14, 70, "Notes",
 CellID->4338],
Cell[4676, 148, 226, 9, 70, "Notes",
 CellID->618],
Cell[4905, 159, 349, 14, 70, "Notes",
 CellID->26630],
Cell[5257, 175, 80, 1, 70, "Notes",
 CellID->13140]
}, Closed]],
Cell[CellGroupData[{
Cell[5374, 181, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->240544338],
Cell[CellGroupData[{
Cell[5759, 195, 148, 5, 70, "ExampleSection",
 CellID->693056281],
Cell[CellGroupData[{
Cell[5932, 204, 139, 4, 28, "Input",
 CellID->14519],
Cell[6074, 210, 219, 7, 36, "Output",
 CellID->22426]
}, Open  ]],
Cell[CellGroupData[{
Cell[6330, 222, 166, 5, 28, "Input",
 CellID->3418],
Cell[6499, 229, 363, 13, 50, "Output",
 CellID->13713]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6911, 248, 217, 7, 70, "ExampleSection",
 CellID->17740],
Cell[CellGroupData[{
Cell[7153, 259, 273, 7, 70, "ExampleSubsection",
 CellID->139292986],
Cell[7429, 268, 82, 1, 70, "ExampleText",
 CellID->377632319],
Cell[7514, 271, 207, 7, 70, "Input",
 CellID->209410081],
Cell[CellGroupData[{
Cell[7746, 282, 102, 3, 70, "Input",
 CellID->50520839],
Cell[7851, 287, 161, 5, 36, "Output",
 CellID->419520607]
}, Open  ]],
Cell[8027, 295, 332, 13, 70, "ExampleText",
 CellID->139852321],
Cell[CellGroupData[{
Cell[8384, 312, 92, 3, 70, "Input",
 CellID->159275699],
Cell[8479, 317, 291, 9, 36, "Output",
 CellID->551057742]
}, Open  ]],
Cell[8785, 329, 125, 3, 70, "ExampleDelimiter",
 CellID->697811082],
Cell[8913, 334, 89, 1, 70, "ExampleText",
 CellID->474967222],
Cell[9005, 337, 294, 10, 70, "Input",
 CellID->17117278],
Cell[CellGroupData[{
Cell[9324, 351, 102, 3, 70, "Input",
 CellID->36298892],
Cell[9429, 356, 161, 5, 36, "Output",
 CellID->880402698]
}, Open  ]],
Cell[9605, 364, 461, 18, 70, "ExampleText",
 CellID->588593625],
Cell[CellGroupData[{
Cell[10091, 386, 128, 4, 70, "Input",
 CellID->142746469],
Cell[10222, 392, 305, 11, 36, "Output",
 CellID->66807155]
}, Open  ]],
Cell[CellGroupData[{
Cell[10564, 408, 158, 5, 70, "Input",
 CellID->42117054],
Cell[10725, 415, 159, 5, 36, "Output",
 CellID->1071722404]
}, Open  ]],
Cell[10899, 423, 124, 3, 70, "ExampleDelimiter",
 CellID->81728638],
Cell[11026, 428, 131, 4, 70, "ExampleText",
 CellID->126322054],
Cell[11160, 434, 956, 31, 70, "Input",
 CellID->583789452],
Cell[CellGroupData[{
Cell[12141, 469, 102, 3, 70, "Input",
 CellID->40944997],
Cell[12246, 474, 161, 5, 36, "Output",
 CellID->698287863]
}, Open  ]],
Cell[12422, 482, 350, 13, 70, "ExampleText",
 CellID->740120202],
Cell[CellGroupData[{
Cell[12797, 499, 150, 5, 70, "Input",
 CellID->216219848],
Cell[12950, 506, 430, 15, 36, "Output",
 CellID->40795815]
}, Open  ]],
Cell[13395, 524, 92, 1, 70, "ExampleText",
 CellID->118181887],
Cell[CellGroupData[{
Cell[13512, 529, 104, 3, 70, "Input",
 CellID->134188521],
Cell[13619, 534, 2207, 40, 70, "Output",
 Evaluatable->False,
 CellID->28221018]
}, Open  ]],
Cell[15841, 577, 124, 3, 70, "ExampleDelimiter",
 CellID->35901885],
Cell[15968, 582, 99, 1, 70, "ExampleText",
 CellID->209993991],
Cell[16070, 585, 326, 11, 70, "Input",
 CellID->280919768],
Cell[16399, 598, 98, 1, 70, "ExampleText",
 CellID->316227341],
Cell[CellGroupData[{
Cell[16522, 603, 150, 5, 70, "Input",
 CellID->85698737],
Cell[16675, 610, 213, 7, 36, "Output",
 CellID->136875805]
}, Open  ]],
Cell[CellGroupData[{
Cell[16925, 622, 131, 4, 70, "Input",
 CellID->991473272],
Cell[17059, 628, 213, 7, 36, "Output",
 CellID->509967971]
}, Open  ]],
Cell[17287, 638, 261, 8, 70, "ExampleText",
 CellID->197369176],
Cell[CellGroupData[{
Cell[17573, 650, 109, 3, 70, "Input",
 CellID->335629842],
Cell[17685, 655, 390, 13, 36, "Output",
 CellID->48977499]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18124, 674, 237, 7, 70, "ExampleSubsection",
 CellID->3078886],
Cell[18364, 683, 222, 7, 70, "ExampleText",
 CellID->382335087],
Cell[CellGroupData[{
Cell[18611, 694, 101, 3, 70, "Input",
 CellID->173869405],
Cell[18715, 699, 223, 7, 36, "Output",
 CellID->331584928]
}, Open  ]],
Cell[CellGroupData[{
Cell[18975, 711, 171, 6, 70, "Input",
 CellID->98046970],
Cell[19149, 719, 272, 9, 36, "Output",
 CellID->286777298]
}, Open  ]],
Cell[CellGroupData[{
Cell[19458, 733, 137, 4, 70, "Input",
 CellID->458364094],
Cell[19598, 739, 382, 10, 36, "Output",
 CellID->392236778]
}, Open  ]],
Cell[19995, 752, 125, 3, 70, "ExampleDelimiter",
 CellID->391030073],
Cell[20123, 757, 206, 7, 70, "ExampleText",
 CellID->351958655],
Cell[CellGroupData[{
Cell[20354, 768, 124, 4, 70, "Input",
 CellID->683885709],
Cell[20481, 774, 340, 11, 36, "Output",
 CellID->331356290]
}, Open  ]],
Cell[CellGroupData[{
Cell[20858, 790, 168, 6, 70, "Input",
 CellID->397804539],
Cell[21029, 798, 224, 7, 36, "Output",
 CellID->445437436]
}, Open  ]],
Cell[21268, 808, 125, 3, 70, "ExampleText",
 CellID->228252792],
Cell[CellGroupData[{
Cell[21418, 815, 388, 14, 70, "Input",
 CellID->445920851],
Cell[21809, 831, 723, 26, 51, "Output",
 CellID->63568681]
}, Open  ]],
Cell[22547, 860, 125, 3, 70, "ExampleDelimiter",
 CellID->258825259],
Cell[22675, 865, 225, 7, 70, "ExampleText",
 CellID->219510804],
Cell[CellGroupData[{
Cell[22925, 876, 201, 7, 70, "Input",
 CellID->32493989],
Cell[23129, 885, 340, 11, 36, "Output",
 CellID->518273200]
}, Open  ]],
Cell[CellGroupData[{
Cell[23506, 901, 227, 8, 70, "Input",
 CellID->19869994],
Cell[23736, 911, 366, 12, 51, "Output",
 CellID->87466388]
}, Open  ]],
Cell[24117, 926, 121, 3, 70, "ExampleText",
 CellID->279888978],
Cell[24241, 931, 252, 9, 70, "Input",
 CellID->226481533],
Cell[CellGroupData[{
Cell[24518, 944, 285, 10, 70, "Input",
 CellID->41436093],
Cell[24806, 956, 724, 26, 51, "Output",
 CellID->325809948]
}, Open  ]],
Cell[CellGroupData[{
Cell[25567, 987, 286, 10, 70, "Input",
 CellID->229202020],
Cell[25856, 999, 640, 23, 51, "Output",
 CellID->83804664]
}, Open  ]],
Cell[26511, 1025, 124, 3, 70, "ExampleDelimiter",
 CellID->99798847],
Cell[26638, 1030, 236, 8, 70, "ExampleText",
 CellID->285827941],
Cell[CellGroupData[{
Cell[26899, 1042, 238, 9, 70, "Input",
 CellID->16199504],
Cell[27140, 1053, 779, 17, 71, "Output",
 CellID->600929530]
}, Open  ]],
Cell[CellGroupData[{
Cell[27956, 1075, 164, 5, 70, "Input",
 CellID->8264930],
Cell[28123, 1082, 1754, 33, 70, "Output",
 Evaluatable->False,
 CellID->584332872]
}, Open  ]],
Cell[29892, 1118, 125, 3, 70, "ExampleDelimiter",
 CellID->210393110],
Cell[30020, 1123, 372, 13, 70, "ExampleText",
 CellID->252253405],
Cell[30395, 1138, 824, 24, 70, "Input",
 CellID->30196012],
Cell[31222, 1164, 126, 3, 70, "ExampleText",
 CellID->290704949],
Cell[CellGroupData[{
Cell[31373, 1171, 74, 2, 70, "Input",
 CellID->246867975],
Cell[31450, 1175, 213, 7, 36, "Output",
 CellID->196540173]
}, Open  ]],
Cell[CellGroupData[{
Cell[31700, 1187, 73, 2, 70, "Input",
 CellID->68351010],
Cell[31776, 1191, 203, 7, 36, "Output",
 CellID->320281763]
}, Open  ]],
Cell[CellGroupData[{
Cell[32016, 1203, 74, 2, 70, "Input",
 CellID->259890839],
Cell[32093, 1207, 257, 8, 36, "Output",
 CellID->129421152]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[32399, 1221, 239, 7, 70, "ExampleSubsection",
 CellID->391413977],
Cell[32641, 1230, 59, 1, 70, "ExampleText",
 CellID->237459754],
Cell[CellGroupData[{
Cell[32725, 1235, 206, 7, 70, "Input",
 CellID->162354393],
Cell[32934, 1244, 285, 10, 36, "Output",
 CellID->37800407]
}, Open  ]],
Cell[33234, 1257, 59, 1, 70, "ExampleText",
 CellID->314806771],
Cell[CellGroupData[{
Cell[33318, 1262, 149, 5, 70, "Input",
 CellID->299282514],
Cell[33470, 1269, 213, 7, 36, "Output",
 CellID->280229554]
}, Open  ]],
Cell[33698, 1279, 60, 1, 70, "ExampleText",
 CellID->129658073],
Cell[CellGroupData[{
Cell[33783, 1284, 230, 7, 70, "Input",
 CellID->443819908],
Cell[34016, 1293, 707, 17, 58, "Output",
 CellID->86784660]
}, Open  ]],
Cell[34738, 1313, 125, 3, 70, "ExampleDelimiter",
 CellID->110300142],
Cell[34866, 1318, 71, 1, 70, "ExampleText",
 CellID->146473879],
Cell[CellGroupData[{
Cell[34962, 1323, 241, 9, 70, "Input",
 CellID->176522230],
Cell[35206, 1334, 380, 14, 36, "Output",
 CellID->115961594]
}, Open  ]],
Cell[35601, 1351, 133, 4, 70, "ExampleText",
 CellID->290048179],
Cell[CellGroupData[{
Cell[35759, 1359, 287, 11, 70, "Input",
 CellID->13646456],
Cell[36049, 1372, 406, 15, 36, "Output",
 CellID->183816647]
}, Open  ]],
Cell[36470, 1390, 84, 1, 70, "ExampleText",
 CellID->147036007],
Cell[CellGroupData[{
Cell[36579, 1395, 274, 9, 70, "Input",
 CellID->412107387],
Cell[36856, 1406, 447, 15, 36, "Output",
 CellID->376097868]
}, Open  ]],
Cell[37318, 1424, 124, 3, 70, "ExampleDelimiter",
 CellID->44139790],
Cell[37445, 1429, 253, 8, 70, "ExampleText",
 CellID->40325209],
Cell[37701, 1439, 139, 4, 70, "Input",
 CellID->197037909],
Cell[CellGroupData[{
Cell[37865, 1447, 163, 5, 70, "Input",
 CellID->64889264],
Cell[38031, 1454, 340, 11, 36, "Output",
 CellID->712890097]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38420, 1471, 247, 7, 70, "ExampleSubsection",
 CellID->15700557],
Cell[38670, 1480, 229, 7, 70, "ExampleText",
 CellID->16104382],
Cell[CellGroupData[{
Cell[38924, 1491, 183, 6, 70, "Input",
 CellID->459365832],
Cell[39110, 1499, 217, 7, 36, "Output",
 CellID->96733543]
}, Open  ]],
Cell[39342, 1509, 205, 6, 70, "ExampleText",
 CellID->759420512],
Cell[CellGroupData[{
Cell[39572, 1519, 376, 13, 70, "Input",
 CellID->398687728],
Cell[39951, 1534, 376, 13, 36, "Output",
 CellID->283882399]
}, Open  ]],
Cell[40342, 1550, 125, 3, 70, "ExampleDelimiter",
 CellID->376613042],
Cell[40470, 1555, 213, 7, 70, "ExampleText",
 CellID->467761975],
Cell[CellGroupData[{
Cell[40708, 1566, 190, 6, 70, "Input",
 CellID->19311491],
Cell[40901, 1574, 340, 11, 36, "Output",
 CellID->574999198]
}, Open  ]],
Cell[41256, 1588, 297, 11, 70, "ExampleText",
 CellID->415592216],
Cell[CellGroupData[{
Cell[41578, 1603, 374, 13, 70, "Input",
 CellID->361592007],
Cell[41955, 1618, 547, 19, 36, "Output",
 CellID->373740437]
}, Open  ]],
Cell[CellGroupData[{
Cell[42539, 1642, 350, 12, 70, "Input",
 CellID->298558107],
Cell[42892, 1656, 646, 22, 36, "Output",
 CellID->276745883]
}, Open  ]],
Cell[43553, 1681, 124, 3, 70, "ExampleDelimiter",
 CellID->59157918],
Cell[43680, 1686, 554, 22, 70, "ExampleText",
 CellID->171631101],
Cell[44237, 1710, 182, 6, 70, "Input",
 CellID->206232631],
Cell[CellGroupData[{
Cell[44444, 1720, 319, 11, 70, "Input",
 CellID->404374084],
Cell[CellGroupData[{
Cell[44788, 1735, 136, 4, 70, "Print",
 CellID->677654904],
Cell[44927, 1741, 136, 4, 70, "Print",
 CellID->717906298],
Cell[45066, 1747, 136, 4, 70, "Print",
 CellID->553184690],
Cell[45205, 1753, 136, 4, 70, "Print",
 CellID->841616841]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[45390, 1763, 231, 8, 70, "Input",
 CellID->28172078],
Cell[45624, 1773, 222, 7, 36, "Output",
 CellID->42596184]
}, Open  ]],
Cell[CellGroupData[{
Cell[45883, 1785, 174, 6, 70, "Input",
 CellID->269420831],
Cell[46060, 1793, 159, 5, 36, "Output",
 CellID->161532676]
}, Open  ]],
Cell[46234, 1801, 125, 3, 70, "ExampleDelimiter",
 CellID->104044563],
Cell[46362, 1806, 207, 7, 70, "ExampleText",
 CellID->166624717],
Cell[46572, 1815, 182, 6, 70, "Input",
 CellID->592747453],
Cell[CellGroupData[{
Cell[46779, 1825, 122, 4, 70, "Input",
 CellID->90901646],
Cell[46904, 1831, 157, 5, 36, "Output",
 CellID->93337733]
}, Open  ]],
Cell[47076, 1839, 102, 2, 70, "ExampleText",
 CellID->456077875],
Cell[CellGroupData[{
Cell[47203, 1845, 193, 7, 70, "Input",
 CellID->716114506],
Cell[47399, 1854, 203, 7, 36, "Output",
 CellID->197152462]
}, Open  ]],
Cell[47617, 1864, 187, 8, 70, "ExampleText",
 CellID->892711240],
Cell[CellGroupData[{
Cell[47829, 1876, 178, 6, 70, "Input",
 CellID->62810570],
Cell[48010, 1884, 203, 7, 36, "Output",
 CellID->114674558]
}, Open  ]],
Cell[48228, 1894, 125, 3, 70, "ExampleDelimiter",
 CellID->176706357],
Cell[48356, 1899, 231, 8, 70, "ExampleText",
 CellID->93830436],
Cell[CellGroupData[{
Cell[48612, 1911, 242, 8, 70, "Input",
 CellID->386301060],
Cell[48857, 1921, 670, 23, 36, "Output",
 CellID->448074114]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[49576, 1950, 241, 7, 70, "ExampleSubsection",
 CellID->476849031],
Cell[49820, 1959, 572, 22, 70, "ExampleText",
 CellID->457621728],
Cell[50395, 1983, 303, 11, 70, "Input",
 CellID->629174268],
Cell[CellGroupData[{
Cell[50723, 1998, 131, 4, 70, "Input",
 CellID->153126914],
Cell[50857, 2004, 203, 7, 36, "Output",
 CellID->138580621]
}, Open  ]],
Cell[CellGroupData[{
Cell[51097, 2016, 126, 4, 70, "Input",
 CellID->108206179],
Cell[51226, 2022, 233, 7, 36, "Output",
 CellID->478209764]
}, Open  ]],
Cell[CellGroupData[{
Cell[51496, 2034, 133, 4, 70, "Input",
 CellID->750175521],
Cell[51632, 2040, 180, 6, 36, "Output",
 CellID->225296869]
}, Open  ]],
Cell[51827, 2049, 125, 3, 70, "ExampleDelimiter",
 CellID->660563844],
Cell[51955, 2054, 499, 18, 70, "ExampleText",
 CellID->101412333],
Cell[CellGroupData[{
Cell[52479, 2076, 159, 5, 70, "Input",
 CellID->67894136],
Cell[52641, 2083, 561, 19, 36, "Output",
 CellID->551625458]
}, Open  ]],
Cell[CellGroupData[{
Cell[53239, 2107, 251, 9, 70, "Input",
 CellID->603872052],
Cell[53493, 2118, 420, 15, 36, "Output",
 CellID->404864141]
}, Open  ]],
Cell[CellGroupData[{
Cell[53950, 2138, 113, 3, 70, "Input",
 CellID->304445848],
Cell[54066, 2143, 645, 21, 36, "Output",
 CellID->355962395]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[54760, 2170, 248, 7, 70, "ExampleSubsection",
 CellID->305705386],
Cell[55011, 2179, 295, 10, 70, "ExampleText",
 CellID->281076404],
Cell[CellGroupData[{
Cell[55331, 2193, 245, 8, 70, "Input",
 CellID->255288681],
Cell[55579, 2203, 158, 5, 36, "Output",
 CellID->538401458]
}, Open  ]],
Cell[CellGroupData[{
Cell[55774, 2213, 433, 15, 70, "Input",
 CellID->541119807],
Cell[56210, 2230, 466, 17, 36, "Output",
 CellID->186031695]
}, Open  ]],
Cell[CellGroupData[{
Cell[56713, 2252, 232, 8, 70, "Input",
 CellID->333527026],
Cell[56948, 2262, 233, 7, 36, "Output",
 CellID->111750774]
}, Open  ]],
Cell[57196, 2272, 125, 3, 70, "ExampleDelimiter",
 CellID->342772075],
Cell[57324, 2277, 373, 14, 70, "ExampleText",
 CellID->44595354],
Cell[CellGroupData[{
Cell[57722, 2295, 414, 14, 70, "Input",
 CellID->767900118],
Cell[58139, 2311, 372, 13, 36, "Output",
 CellID->73640392]
}, Open  ]],
Cell[CellGroupData[{
Cell[58548, 2329, 496, 17, 70, "Input",
 CellID->102391728],
Cell[59047, 2348, 938, 31, 54, "Output",
 CellID->83460430]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[60034, 2385, 234, 7, 70, "ExampleSubsection",
 CellID->61436655],
Cell[60271, 2394, 117, 3, 70, "ExampleText",
 CellID->74458003],
Cell[CellGroupData[{
Cell[60413, 2401, 538, 19, 70, "Input",
 CellID->339649584],
Cell[60954, 2422, 340, 11, 36, "Output",
 CellID->110963697]
}, Open  ]],
Cell[61309, 2436, 227, 8, 70, "ExampleText",
 CellID->666074],
Cell[CellGroupData[{
Cell[61561, 2448, 144, 5, 70, "Input",
 CellID->58681330],
Cell[61708, 2455, 278, 9, 36, "Output",
 CellID->103876126]
}, Open  ]],
Cell[CellGroupData[{
Cell[62023, 2469, 303, 11, 70, "Input",
 CellID->431129932],
Cell[62329, 2482, 246, 8, 39, "Output",
 CellID->58814732]
}, Open  ]],
Cell[62590, 2493, 125, 3, 70, "ExampleDelimiter",
 CellID->450568691],
Cell[62718, 2498, 123, 3, 70, "ExampleText",
 CellID->98218888],
Cell[CellGroupData[{
Cell[62866, 2505, 427, 15, 70, "Input",
 CellID->102347436],
Cell[63296, 2522, 646, 25, 55, "Output",
 CellID->317569889]
}, Open  ]],
Cell[63957, 2550, 126, 3, 70, "ExampleText",
 CellID->443783751],
Cell[CellGroupData[{
Cell[64108, 2557, 151, 5, 70, "Input",
 CellID->713145512],
Cell[64262, 2564, 508, 21, 55, "Output",
 CellID->173343180]
}, Open  ]],
Cell[CellGroupData[{
Cell[64807, 2590, 290, 10, 70, "Input",
 CellID->62456138],
Cell[65100, 2602, 209, 7, 36, "Output",
 CellID->139993086]
}, Open  ]],
Cell[65324, 2612, 254, 8, 70, "ExampleText",
 CellID->217166982],
Cell[CellGroupData[{
Cell[65603, 2624, 336, 12, 70, "Input",
 CellID->713351396],
Cell[65942, 2638, 358, 13, 51, "Output",
 CellID->6242456]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[66349, 2657, 234, 7, 70, "ExampleSubsection",
 CellID->647498807],
Cell[66586, 2666, 123, 3, 70, "ExampleText",
 CellID->216481517],
Cell[66712, 2671, 551, 18, 70, "Input",
 CellID->100811809],
Cell[67266, 2691, 124, 3, 70, "ExampleDelimiter",
 CellID->29244195],
Cell[67393, 2696, 70, 1, 70, "ExampleText",
 CellID->369071445],
Cell[CellGroupData[{
Cell[67488, 2701, 214, 7, 70, "Input",
 CellID->462848773],
Cell[67705, 2710, 598, 14, 54, "Output",
 CellID->219390948]
}, Open  ]],
Cell[68318, 2727, 56, 1, 70, "ExampleText",
 CellID->38975542],
Cell[CellGroupData[{
Cell[68399, 2732, 104, 3, 70, "Input",
 CellID->1634213],
Cell[68506, 2737, 771, 20, 124, "Output",
 CellID->506587948]
}, Open  ]],
Cell[69292, 2760, 124, 3, 70, "ExampleDelimiter",
 CellID->60532774],
Cell[69419, 2765, 100, 2, 70, "ExampleText",
 CellID->9944371],
Cell[CellGroupData[{
Cell[69544, 2771, 805, 25, 70, "Input",
 CellID->59028123],
Cell[70352, 2798, 564, 19, 39, "Output",
 CellID->27300275]
}, Open  ]],
Cell[70931, 2820, 93, 1, 70, "ExampleText",
 CellID->122510873],
Cell[CellGroupData[{
Cell[71049, 2825, 146, 4, 70, "Input",
 CellID->8969631],
Cell[71198, 2831, 451, 17, 36, "Output",
 CellID->216555946]
}, Open  ]],
Cell[71664, 2851, 218, 8, 70, "ExampleText",
 CellID->553394784],
Cell[CellGroupData[{
Cell[71907, 2863, 309, 10, 70, "Input",
 CellID->19594258],
Cell[72219, 2875, 17609, 293, 70, "Output",
 Evaluatable->False,
 CellID->64339668]
}, Open  ]],
Cell[89843, 3171, 66, 1, 70, "ExampleText",
 CellID->103999514],
Cell[CellGroupData[{
Cell[89934, 3176, 169, 5, 70, "Input",
 CellID->181559384],
Cell[90106, 3183, 17114, 285, 70, "Output",
 Evaluatable->False,
 CellID->416260522]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[107281, 3475, 233, 7, 70, "ExampleSection",
 CellID->30179],
Cell[107517, 3484, 209, 8, 70, "ExampleText",
 CellID->787688225],
Cell[107729, 3494, 252, 8, 70, "Input",
 CellID->76735992],
Cell[CellGroupData[{
Cell[108006, 3506, 137, 4, 70, "Input",
 CellID->639279098],
Cell[108146, 3512, 454, 16, 36, "Output",
 CellID->717944103]
}, Open  ]],
Cell[108615, 3531, 185, 8, 70, "ExampleText",
 CellID->22656942],
Cell[CellGroupData[{
Cell[108825, 3543, 105, 3, 70, "Input",
 CellID->10969802],
Cell[108933, 3548, 161, 5, 36, "Output",
 CellID->448175938]
}, Open  ]],
Cell[109109, 3556, 90, 1, 70, "ExampleText",
 CellID->546576124],
Cell[CellGroupData[{
Cell[109224, 3561, 162, 5, 70, "Input",
 CellID->456512681],
Cell[109389, 3568, 161, 5, 36, "Output",
 CellID->711099965]
}, Open  ]],
Cell[CellGroupData[{
Cell[109587, 3578, 224, 7, 70, "Input",
 CellID->100911950],
Cell[109814, 3587, 161, 5, 36, "Output",
 CellID->203764504]
}, Open  ]],
Cell[109990, 3595, 114, 3, 70, "ExampleText",
 CellID->294693722],
Cell[CellGroupData[{
Cell[110129, 3602, 101, 3, 70, "Input",
 CellID->563313325],
Cell[110233, 3607, 162, 5, 36, "Output",
 CellID->401675973]
}, Open  ]],
Cell[110410, 3615, 393, 15, 70, "ExampleText",
 CellID->112213029],
Cell[CellGroupData[{
Cell[110828, 3634, 106, 3, 70, "Input",
 CellID->328682228],
Cell[110937, 3639, 291, 9, 36, "Output",
 CellID->127745241]
}, Open  ]],
Cell[CellGroupData[{
Cell[111265, 3653, 96, 3, 70, "Input",
 CellID->43959925],
Cell[111364, 3658, 160, 5, 36, "Output",
 CellID->67680316]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[111585, 3670, 310, 9, 70, "SeeAlsoSection",
 CellID->5214],
Cell[111898, 3681, 696, 26, 70, "SeeAlso",
 CellID->15644]
}, Open  ]],
Cell[CellGroupData[{
Cell[112631, 3712, 313, 9, 70, "TutorialsSection",
 CellID->7798],
Cell[112947, 3723, 154, 3, 70, "Tutorials",
 CellID->29085],
Cell[113104, 3728, 198, 4, 70, "Tutorials",
 CellID->527030841]
}, Open  ]],
Cell[CellGroupData[{
Cell[113339, 3737, 319, 9, 70, "MoreAboutSection",
 CellID->466175841],
Cell[113661, 3748, 144, 3, 70, "MoreAbout",
 CellID->57067689],
Cell[113808, 3753, 145, 3, 70, "MoreAbout",
 CellID->217225326]
}, Open  ]],
Cell[113968, 3759, 27, 0, 70, "History"],
Cell[113998, 3761, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

