(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    137311,       4909]
NotebookOptionsPosition[    117005,       4196]
NotebookOutlinePosition[    119374,       4248]
CellTagsIndexPosition[    119287,       4243]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Convolutions and Correlations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ConvolutionsAndCorrelations"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Convolutions and Correlations\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ListCorrelate" :> 
          Documentation`HelpLookup["paclet:ref/ListCorrelate"], 
          "MovingAverage" :> 
          Documentation`HelpLookup["paclet:ref/MovingAverage"], "Partition" :> 
          Documentation`HelpLookup["paclet:ref/Partition"], "Inner" :> 
          Documentation`HelpLookup["paclet:ref/Inner"], "CellularAutomaton" :> 
          Documentation`HelpLookup["paclet:ref/CellularAutomaton"], "PadLeft" :> 
          Documentation`HelpLookup["paclet:ref/PadLeft"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ListCorrelate\"\>", 2->"\<\"MovingAverage\"\>", 
       3->"\<\"Partition\"\>", 4->"\<\"Inner\"\>", 
       5->"\<\"CellularAutomaton\"\>", 
       6->"\<\"PadLeft\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Handling Arrays of Data" :> 
          Documentation`HelpLookup["paclet:guide/HandlingArraysOfData"], 
          "Image Processing" :> 
          Documentation`HelpLookup["paclet:guide/ImageProcessing"], 
          "Numerical Data" :> 
          Documentation`HelpLookup["paclet:guide/NumericalData"], 
          "Signal Processing" :> 
          Documentation`HelpLookup["paclet:guide/SignalProcessing"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Handling Arrays of Data\"\>", 
       2->"\<\"Image Processing\"\>", 3->"\<\"Numerical Data\"\>", 
       4->"\<\"Signal Processing\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ListConvolve", "ObjectName",
 CellID->7441],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListConvolve",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListConvolve"], "[", 
       RowBox[{
        StyleBox["ker", "TI"], ",", 
        StyleBox["list", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]forms the convolution of the kernel ",
     Cell[BoxData[
      StyleBox["ker", "TI"]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListConvolve",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListConvolve"], "[", 
       RowBox[{
        StyleBox["ker", "TI"], ",", 
        StyleBox["list", "TI"], ",", 
        StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]forms the cyclic convolution in which the ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " element of ",
     Cell[BoxData[
      StyleBox["ker", "TI"]], "InlineFormula"],
     " is aligned with each element in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListConvolve",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListConvolve"], "[", 
       RowBox[{
        StyleBox["ker", "TI"], ",", 
        StyleBox["list", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["k", "TI"], 
           StyleBox["L", "TI"]], ",", 
          SubscriptBox[
           StyleBox["k", "TI"], 
           StyleBox["R", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]forms the cyclic convolution whose first element \
contains ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        StyleBox["list", "TI"], "[", 
        RowBox[{"[", "1", "]"}], "]"}], 
       RowBox[{
        StyleBox["ker", "TI"], "[", 
        RowBox[{"[", 
         SubscriptBox[
          StyleBox["k", "TI"], 
          StyleBox["L", "TI"]], "]"}], "]"}]}]], "InlineFormula"],
     " and whose last element contains ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        StyleBox["list", "TI"], "[", 
        RowBox[{"[", 
         RowBox[{"-", "1"}], "]"}], "]"}], 
       RowBox[{
        StyleBox["ker", "TI"], "[", 
        RowBox[{"[", 
         SubscriptBox[
          StyleBox["k", "TI"], 
          StyleBox["R", "TI"]], "]"}], "]"}]}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListConvolve",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListConvolve"], "[", 
       RowBox[{
        StyleBox["ker", "TI"], ",", 
        StyleBox["list", "TI"], ",", 
        StyleBox["klist", "TI"], ",", 
        StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]forms the convolution in which ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " is padded at each end with repetitions of the element ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListConvolve",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListConvolve"], "[", 
       RowBox[{
        StyleBox["ker", "TI"], ",", 
        StyleBox["list", "TI"], ",", 
        StyleBox["klist", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["p", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["p", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]forms the convolution in which ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " is padded at each end with cyclic repetitions of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListConvolve",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListConvolve"], "[", 
       RowBox[{
        StyleBox["ker", "TI"], ",", 
        StyleBox["list", "TI"], ",", 
        StyleBox["klist", "TI"], ",", 
        StyleBox["padding", "TI"], ",", 
        StyleBox["g", "TI"], ",", 
        StyleBox["h", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]forms a generalized convolution in which ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     " is used in place of ",
     Cell[BoxData[
      ButtonBox["Times",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Times"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["h", "TI"]], "InlineFormula"],
     " in place of ",
     Cell[BoxData[
      ButtonBox["Plus",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListConvolve",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListConvolve"], "[", 
       RowBox[{
        StyleBox["ker", "TI"], ",", 
        StyleBox["list", "TI"], ",", 
        StyleBox["klist", "TI"], ",", 
        StyleBox["padding", "TI"], ",", 
        StyleBox["g", "TI"], ",", 
        StyleBox["h", "TI"], ",", 
        StyleBox["lev", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]forms a convolution using elements at level ",
     Cell[BoxData[
      StyleBox["lev", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["ker", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->9512]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With kernel ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["K", "TI"], 
   StyleBox["r", "TI"]]], "InlineFormula"],
 " and list ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["a", "TI"], 
   StyleBox["s", "TI"]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListConvolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListConvolve"], "[", 
   RowBox[{
    StyleBox["ker", "TI"], ",", 
    StyleBox["list", "TI"]}], "]"}]], "InlineFormula"],
 " computes ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderscriptBox["\[Sum]", "r",
     LimitsPositioning->True], 
    SubscriptBox["K", "r"], 
    SubscriptBox["a", 
     RowBox[{"s", "-", "r"}]]}], TraditionalForm]], "InlineMath"],
 ", where the limits of the sum are such that the kernel never overhangs \
either end of the list. "
}], "Notes",
 CellID->30145],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListConvolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListConvolve"], "[", 
   RowBox[{
    StyleBox["ker", "TI"], ",", 
    StyleBox["list", "TI"]}], "]"}]], "InlineFormula"],
 " gives a result of length ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Length",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Length"], "[", 
    StyleBox["list", "TI"], "]"}], "-", 
   RowBox[{
    ButtonBox["Length",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Length"], "[", 
    StyleBox["ker", "TI"], "]"}], "+", "1"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18060],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListConvolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListConvolve"], "[", 
   RowBox[{
    StyleBox["ker", "TI"], ",", 
    StyleBox["list", "TI"]}], "]"}]], "InlineFormula"],
 " allows no overhangs and is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListConvolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListConvolve"], "[", 
   RowBox[{
    StyleBox["ker", "TI"], ",", 
    StyleBox["list", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21718],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListConvolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListConvolve"], "[", 
   RowBox[{
    StyleBox["ker", "TI"], ",", 
    StyleBox["list", "TI"], ",", 
    StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListConvolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListConvolve"], "[", 
   RowBox[{
    StyleBox["ker", "TI"], ",", 
    StyleBox["list", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["k", "TI"], ",", 
      StyleBox["k", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3753],

Cell[TextData[{
 "The values of ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["k", "TI"], 
   StyleBox["L", "TI"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["k", "TI"], 
   StyleBox["R", "TI"]]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListConvolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListConvolve"], "[", 
   RowBox[{
    StyleBox["ker", "TI"], ",", 
    StyleBox["list", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["k", "TI"], 
       StyleBox["L", "TI"]], ",", 
      SubscriptBox[
       StyleBox["k", "TI"], 
       StyleBox["R", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " determine the amount of overhang to allow at each end of ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->16139],

Cell[TextData[{
 "Common settings for ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["k", "TI"], 
     StyleBox["L", "TI"]], ",", 
    SubscriptBox[
     StyleBox["k", "TI"], 
     StyleBox["R", "TI"]]}], "}"}]], "InlineFormula"],
 " are: "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->12423],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}], Cell[
    "no overhangs (default) ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "1"}]}], "}"}], Cell["\<\
maximal overhang at the right\[Hyphen]hand end \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], Cell["\<\
maximal overhang at the left\[Hyphen]hand end \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}]}], "}"}], Cell[
    "maximal overhangs at both beginning and end ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->16279],

Cell[TextData[{
 "With maximal overhang at one end only, the result from ",
 Cell[BoxData[
  ButtonBox["ListConvolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListConvolve"]], "InlineFormula"],
 " is the same length as ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->25996],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListConvolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListConvolve"], "[", 
   RowBox[{
    StyleBox["ker", "TI"], ",", 
    StyleBox["list", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["k", "TI"], 
       StyleBox["L", "TI"]], ",", 
      SubscriptBox[
       StyleBox["k", "TI"], 
       StyleBox["R", "TI"]]}], "}"}], ",", 
    StyleBox["padlist", "TI"]}], "]"}]], "InlineFormula"],
 " effectively lays down repeated copies of ",
 Cell[BoxData[
  StyleBox["padlist", "TI"]], "InlineFormula"],
 ", then superimposes one copy of ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " on them and forms a convolution of the result. "
}], "Notes",
 CellID->16687],

Cell[TextData[{
 "Common settings for ",
 Cell[BoxData[
  StyleBox["padlist", "TI"]], "InlineFormula"],
 " are: "
}], "Notes",
 CellID->12529],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["p", "TI"], Cell[
    "pad with repetitions of a single element ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["p", "TI"], "1"], ",", 
      SubscriptBox[
       StyleBox["p", "TI"], "2"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[
    "pad with cyclic repetitions of a sequence of elements ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["list", "TI"], Cell[TextData[{
     "pad by treating ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " as cyclic (default) "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", "}"}], Cell["do no padding ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->22549],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListConvolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListConvolve"]], "InlineFormula"],
 " works with multidimensional kernels and lists of data. "
}], "Notes",
 CellID->17437],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListConvolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListConvolve"], "[", 
   RowBox[{
    StyleBox["ker", "TI"], ",", 
    StyleBox["list", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["k", "TI"], 
         StyleBox["L1", "TI"]], ",", 
        SubscriptBox[
         StyleBox["k", "TI"], 
         StyleBox["L2", "TI"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["k", "TI"], 
         StyleBox["R1", "TI"]], ",", 
        SubscriptBox[
         StyleBox["k", "TI"], 
         StyleBox["R2", "TI"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " forms the cyclic convolution whose ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "1", ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 " element contains ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["ker", "TI"], "[", 
    RowBox[{"[", 
     RowBox[{
      SubscriptBox[
       StyleBox["k", "TI"], 
       StyleBox["L1", "TI"]], ",", 
      SubscriptBox[
       StyleBox["k", "TI"], 
       StyleBox["L2", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], "]"}], 
   RowBox[{
    StyleBox["list", "TI"], "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1", ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], "]"}]}]], "InlineFormula"],
 " and whose ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", 
    RowBox[{"-", "1"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 " element contains ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["ker", "TI"], "[", 
    RowBox[{"[", 
     RowBox[{
      SubscriptBox[
       StyleBox["k", "TI"], 
       StyleBox["R1", "TI"]], ",", 
      SubscriptBox[
       StyleBox["k", "TI"], 
       StyleBox["R2", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], "]"}], 
   RowBox[{
    StyleBox["list", "TI"], "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "1"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], "]"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->19866],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["k", "TI"], 
     StyleBox["L", "TI"]], ",", 
    SubscriptBox[
     StyleBox["k", "TI"], 
     StyleBox["R", "TI"]]}], "}"}]], "InlineFormula"],
 " is taken to be equivalent to ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["k", "TI"], 
       StyleBox["L", "TI"]], ",", 
      SubscriptBox[
       StyleBox["k", "TI"], 
       StyleBox["L", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["k", "TI"], 
       StyleBox["R", "TI"]], ",", 
      SubscriptBox[
       StyleBox["k", "TI"], 
       StyleBox["R", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12949],

Cell[TextData[{
 "When a function ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 " is specified to use in place of ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 ", explicit nested ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 " expressions are generated with a depth equal to the depth of ",
 Cell[BoxData[
  StyleBox["ker", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->193],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListConvolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListConvolve"]], "InlineFormula"],
 " works with exact numbers and symbolic data as well as approximate numbers. \
"
}], "Notes",
 CellID->23195]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->61043363],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->647262440],

Cell[TextData[{
 "Convolve a kernel ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}]], "InlineFormula"],
 " with a list of data:"
}], "ExampleText",
 CellID->11701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31316],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "x"}], "+", 
    RowBox[{"a", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"c", " ", "x"}], "+", 
    RowBox[{"b", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"d", " ", "x"}], "+", 
    RowBox[{"c", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"e", " ", "x"}], "+", 
    RowBox[{"d", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"f", " ", "x"}], "+", 
    RowBox[{"e", " ", "y"}]}]}], "}"}]], "Output",
 ImageSize->{296, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->406811336]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5786],

Cell["\<\
Make a cyclic convolution the same length as the original data:\
\>", "ExampleText",
 CellID->12263],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
   ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4313],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", 
    RowBox[{"f", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"b", " ", "x"}], "+", 
    RowBox[{"a", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"c", " ", "x"}], "+", 
    RowBox[{"b", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"d", " ", "x"}], "+", 
    RowBox[{"c", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"e", " ", "x"}], "+", 
    RowBox[{"d", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"f", " ", "x"}], "+", 
    RowBox[{"e", " ", "y"}]}]}], "}"}]], "Output",
 ImageSize->{354, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->58468102]
}, Open  ]],

Cell[TextData[{
 "Align element ",
 Cell[BoxData["2"], "InlineFormula"],
 " in the kernel with successive elements in the data:"
}], "ExampleText",
 CellID->31185],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
   ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20053],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "x"}], "+", 
    RowBox[{"a", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"c", " ", "x"}], "+", 
    RowBox[{"b", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"d", " ", "x"}], "+", 
    RowBox[{"c", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"e", " ", "x"}], "+", 
    RowBox[{"d", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"f", " ", "x"}], "+", 
    RowBox[{"e", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", 
    RowBox[{"f", " ", "y"}]}]}], "}"}]], "Output",
 ImageSize->{354, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->484993596]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10808],

Cell[TextData[{
 "Pad with ",
 Cell[BoxData["zzz"], "InlineFormula"],
 " instead of using the data cyclically:"
}], "ExampleText",
 CellID->1832],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
   ",", "1", ",", "zzz"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20945],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", 
    RowBox[{"y", " ", "zzz"}]}], ",", 
   RowBox[{
    RowBox[{"b", " ", "x"}], "+", 
    RowBox[{"a", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"c", " ", "x"}], "+", 
    RowBox[{"b", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"d", " ", "x"}], "+", 
    RowBox[{"c", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"e", " ", "x"}], "+", 
    RowBox[{"d", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"f", " ", "x"}], "+", 
    RowBox[{"e", " ", "y"}]}]}], "}"}]], "Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->337971803]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28321],

Cell["Two-dimensional convolution:", "ExampleText",
 CellID->19558],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "h", ",", "i"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23646],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "+", "b", "+", "d", "+", "e"}], ",", 
     RowBox[{"b", "+", "c", "+", "e", "+", "f"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"d", "+", "e", "+", "g", "+", "h"}], ",", 
     RowBox[{"e", "+", "f", "+", "h", "+", "i"}]}], "}"}]}], "}"}]], "Output",\

 ImageSize->{344, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2540882]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4144],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Overhangs and Alignments",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->23196],

Cell["\<\
\[OpenCurlyDoubleQuote]Slide\[CloseCurlyDoubleQuote] the kernel along the \
data, allowing no overhangs:\
\>", "ExampleText",
 CellID->20222],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7129],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"3", " ", "x"}], "+", 
    RowBox[{"2", " ", "y"}], "+", "z"}], ",", 
   RowBox[{
    RowBox[{"4", " ", "x"}], "+", 
    RowBox[{"3", " ", "y"}], "+", 
    RowBox[{"2", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"5", " ", "x"}], "+", 
    RowBox[{"4", " ", "y"}], "+", 
    RowBox[{"3", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"6", " ", "x"}], "+", 
    RowBox[{"5", " ", "y"}], "+", 
    RowBox[{"4", " ", "z"}]}]}], "}"}]], "Output",
 ImageSize->{347, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->883329182]
}, Open  ]],

Cell["Maximal overhang at the beginning; none at the end:", "ExampleText",
 CellID->5535],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
   ",", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20450],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "+", 
    RowBox[{"6", " ", "y"}], "+", 
    RowBox[{"5", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", "y", "+", 
    RowBox[{"6", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"3", " ", "x"}], "+", 
    RowBox[{"2", " ", "y"}], "+", "z"}], ",", 
   RowBox[{
    RowBox[{"4", " ", "x"}], "+", 
    RowBox[{"3", " ", "y"}], "+", 
    RowBox[{"2", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"5", " ", "x"}], "+", 
    RowBox[{"4", " ", "y"}], "+", 
    RowBox[{"3", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"6", " ", "x"}], "+", 
    RowBox[{"5", " ", "y"}], "+", 
    RowBox[{"4", " ", "z"}]}]}], "}"}]], "Output",
 ImageSize->{502, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->71911419]
}, Open  ]],

Cell["Maximal overhang at the end; none at the beginning:", "ExampleText",
 CellID->10466],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
   ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->12044],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"3", " ", "x"}], "+", 
    RowBox[{"2", " ", "y"}], "+", "z"}], ",", 
   RowBox[{
    RowBox[{"4", " ", "x"}], "+", 
    RowBox[{"3", " ", "y"}], "+", 
    RowBox[{"2", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"5", " ", "x"}], "+", 
    RowBox[{"4", " ", "y"}], "+", 
    RowBox[{"3", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"6", " ", "x"}], "+", 
    RowBox[{"5", " ", "y"}], "+", 
    RowBox[{"4", " ", "z"}]}], ",", 
   RowBox[{"x", "+", 
    RowBox[{"6", " ", "y"}], "+", 
    RowBox[{"5", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", "y", "+", 
    RowBox[{"6", " ", "z"}]}]}], "}"}]], "Output",
 ImageSize->{502, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->39996776]
}, Open  ]],

Cell["Maximal overhangs at both beginning and end:", "ExampleText",
 CellID->26292],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->26439],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "+", 
    RowBox[{"6", " ", "y"}], "+", 
    RowBox[{"5", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", "y", "+", 
    RowBox[{"6", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"3", " ", "x"}], "+", 
    RowBox[{"2", " ", "y"}], "+", "z"}], ",", 
   RowBox[{
    RowBox[{"4", " ", "x"}], "+", 
    RowBox[{"3", " ", "y"}], "+", 
    RowBox[{"2", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"5", " ", "x"}], "+", 
    RowBox[{"4", " ", "y"}], "+", 
    RowBox[{"3", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"6", " ", "x"}], "+", 
    RowBox[{"5", " ", "y"}], "+", 
    RowBox[{"4", " ", "z"}]}], ",", 
   RowBox[{"x", "+", 
    RowBox[{"6", " ", "y"}], "+", 
    RowBox[{"5", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", "y", "+", 
    RowBox[{"6", " ", "z"}]}]}], "}"}]], "Output",
 ImageSize->{337, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->245454876]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20024],

Cell[TextData[{
 "Align element ",
 Cell[BoxData["1"], "InlineFormula"],
 " of the kernel with the first element of the data:"
}], "ExampleText",
 CellID->26154],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
   ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29510],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "+", 
    RowBox[{"6", " ", "y"}], "+", 
    RowBox[{"5", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", "y", "+", 
    RowBox[{"6", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"3", " ", "x"}], "+", 
    RowBox[{"2", " ", "y"}], "+", "z"}], ",", 
   RowBox[{
    RowBox[{"4", " ", "x"}], "+", 
    RowBox[{"3", " ", "y"}], "+", 
    RowBox[{"2", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"5", " ", "x"}], "+", 
    RowBox[{"4", " ", "y"}], "+", 
    RowBox[{"3", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"6", " ", "x"}], "+", 
    RowBox[{"5", " ", "y"}], "+", 
    RowBox[{"4", " ", "z"}]}]}], "}"}]], "Output",
 ImageSize->{502, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->204504099]
}, Open  ]],

Cell[TextData[{
 "Align element ",
 Cell[BoxData["2"], "InlineFormula"],
 " of the kernel with the first element of the data:"
}], "ExampleText",
 CellID->20649],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
   ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13186],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", "y", "+", 
    RowBox[{"6", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"3", " ", "x"}], "+", 
    RowBox[{"2", " ", "y"}], "+", "z"}], ",", 
   RowBox[{
    RowBox[{"4", " ", "x"}], "+", 
    RowBox[{"3", " ", "y"}], "+", 
    RowBox[{"2", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"5", " ", "x"}], "+", 
    RowBox[{"4", " ", "y"}], "+", 
    RowBox[{"3", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"6", " ", "x"}], "+", 
    RowBox[{"5", " ", "y"}], "+", 
    RowBox[{"4", " ", "z"}]}], ",", 
   RowBox[{"x", "+", 
    RowBox[{"6", " ", "y"}], "+", 
    RowBox[{"5", " ", "z"}]}]}], "}"}]], "Output",
 ImageSize->{502, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->523074325]
}, Open  ]],

Cell[TextData[{
 "Align element ",
 Cell[BoxData["3"], "InlineFormula"],
 " of the kernel with the first element of the data:"
}], "ExampleText",
 CellID->4474],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
   ",", "3"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->28022],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"3", " ", "x"}], "+", 
    RowBox[{"2", " ", "y"}], "+", "z"}], ",", 
   RowBox[{
    RowBox[{"4", " ", "x"}], "+", 
    RowBox[{"3", " ", "y"}], "+", 
    RowBox[{"2", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"5", " ", "x"}], "+", 
    RowBox[{"4", " ", "y"}], "+", 
    RowBox[{"3", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"6", " ", "x"}], "+", 
    RowBox[{"5", " ", "y"}], "+", 
    RowBox[{"4", " ", "z"}]}], ",", 
   RowBox[{"x", "+", 
    RowBox[{"6", " ", "y"}], "+", 
    RowBox[{"5", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", "y", "+", 
    RowBox[{"6", " ", "z"}]}]}], "}"}]], "Output",
 ImageSize->{502, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->96503380]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14018],

Cell["\<\
Align the last element of the kernel with the first element of the data:\
\>", "ExampleText",
 CellID->18787],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
   ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9905],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"3", " ", "x"}], "+", 
    RowBox[{"2", " ", "y"}], "+", "z"}], ",", 
   RowBox[{
    RowBox[{"4", " ", "x"}], "+", 
    RowBox[{"3", " ", "y"}], "+", 
    RowBox[{"2", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"5", " ", "x"}], "+", 
    RowBox[{"4", " ", "y"}], "+", 
    RowBox[{"3", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"6", " ", "x"}], "+", 
    RowBox[{"5", " ", "y"}], "+", 
    RowBox[{"4", " ", "z"}]}], ",", 
   RowBox[{"x", "+", 
    RowBox[{"6", " ", "y"}], "+", 
    RowBox[{"5", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", "y", "+", 
    RowBox[{"6", " ", "z"}]}]}], "}"}]], "Output",
 ImageSize->{502, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->523027613]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7391],

Cell["\<\
Align the first element of the kernel with both the first and last elements \
of the data:\
\>", "ExampleText",
 CellID->10202],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3625],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "+", 
    RowBox[{"6", " ", "y"}], "+", 
    RowBox[{"5", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", "y", "+", 
    RowBox[{"6", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"3", " ", "x"}], "+", 
    RowBox[{"2", " ", "y"}], "+", "z"}], ",", 
   RowBox[{
    RowBox[{"4", " ", "x"}], "+", 
    RowBox[{"3", " ", "y"}], "+", 
    RowBox[{"2", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"5", " ", "x"}], "+", 
    RowBox[{"4", " ", "y"}], "+", 
    RowBox[{"3", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"6", " ", "x"}], "+", 
    RowBox[{"5", " ", "y"}], "+", 
    RowBox[{"4", " ", "z"}]}]}], "}"}]], "Output",
 ImageSize->{502, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->333544574]
}, Open  ]],

Cell[TextData[{
 "Align element ",
 Cell[BoxData["2"], "InlineFormula"],
 " of the kernel with the first element of the data:"
}], "ExampleText",
 CellID->4414],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9314],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", "y", "+", 
    RowBox[{"6", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"3", " ", "x"}], "+", 
    RowBox[{"2", " ", "y"}], "+", "z"}], ",", 
   RowBox[{
    RowBox[{"4", " ", "x"}], "+", 
    RowBox[{"3", " ", "y"}], "+", 
    RowBox[{"2", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"5", " ", "x"}], "+", 
    RowBox[{"4", " ", "y"}], "+", 
    RowBox[{"3", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"6", " ", "x"}], "+", 
    RowBox[{"5", " ", "y"}], "+", 
    RowBox[{"4", " ", "z"}]}]}], "}"}]], "Output",
 ImageSize->{424, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27895507]
}, Open  ]],

Cell[TextData[{
 "Align element ",
 Cell[BoxData["2"], "InlineFormula"],
 " of the kernel with the last element of the data:"
}], "ExampleText",
 CellID->29334],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->25874],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "+", 
    RowBox[{"6", " ", "y"}], "+", 
    RowBox[{"5", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", "y", "+", 
    RowBox[{"6", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"3", " ", "x"}], "+", 
    RowBox[{"2", " ", "y"}], "+", "z"}], ",", 
   RowBox[{
    RowBox[{"4", " ", "x"}], "+", 
    RowBox[{"3", " ", "y"}], "+", 
    RowBox[{"2", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"5", " ", "x"}], "+", 
    RowBox[{"4", " ", "y"}], "+", 
    RowBox[{"3", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"6", " ", "x"}], "+", 
    RowBox[{"5", " ", "y"}], "+", 
    RowBox[{"4", " ", "z"}]}], ",", 
   RowBox[{"x", "+", 
    RowBox[{"6", " ", "y"}], "+", 
    RowBox[{"5", " ", "z"}]}]}], "}"}]], "Output",
 ImageSize->{579, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->28332456]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Data Padding",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->28297],

Cell[TextData[{
 "Use padding ",
 Cell[BoxData["aa"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->7518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", "1", 
   ",", "aa"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8177],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "+", 
    RowBox[{"aa", " ", "y"}], "+", 
    RowBox[{"aa", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", "y", "+", 
    RowBox[{"aa", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"3", " ", "x"}], "+", 
    RowBox[{"2", " ", "y"}], "+", "z"}], ",", 
   RowBox[{
    RowBox[{"4", " ", "x"}], "+", 
    RowBox[{"3", " ", "y"}], "+", 
    RowBox[{"2", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"5", " ", "x"}], "+", 
    RowBox[{"4", " ", "y"}], "+", 
    RowBox[{"3", " ", "z"}]}]}], "}"}]], "Output",
 ImageSize->{435, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->454111893]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32270],

Cell["Cyclically use a list of padding elements:", "ExampleText",
 CellID->1763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", "1", 
   ",", 
   RowBox[{"{", 
    RowBox[{"aa", ",", "bb"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2668],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "+", 
    RowBox[{"bb", " ", "y"}], "+", 
    RowBox[{"aa", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", "y", "+", 
    RowBox[{"bb", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"3", " ", "x"}], "+", 
    RowBox[{"2", " ", "y"}], "+", "z"}], ",", 
   RowBox[{
    RowBox[{"4", " ", "x"}], "+", 
    RowBox[{"3", " ", "y"}], "+", 
    RowBox[{"2", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"5", " ", "x"}], "+", 
    RowBox[{"4", " ", "y"}], "+", 
    RowBox[{"3", " ", "z"}]}]}], "}"}]], "Output",
 ImageSize->{435, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13985390]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", "1", 
   ",", 
   RowBox[{"{", 
    RowBox[{"aa", ",", "bb", ",", "cc"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13985],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "+", 
    RowBox[{"cc", " ", "y"}], "+", 
    RowBox[{"bb", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", "y", "+", 
    RowBox[{"cc", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"3", " ", "x"}], "+", 
    RowBox[{"2", " ", "y"}], "+", "z"}], ",", 
   RowBox[{
    RowBox[{"4", " ", "x"}], "+", 
    RowBox[{"3", " ", "y"}], "+", 
    RowBox[{"2", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"5", " ", "x"}], "+", 
    RowBox[{"4", " ", "y"}], "+", 
    RowBox[{"3", " ", "z"}]}]}], "}"}]], "Output",
 ImageSize->{435, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->646562016]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"aa", ",", "bb", ",", "cc"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->8480],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "+", 
    RowBox[{"cc", " ", "y"}], "+", 
    RowBox[{"bb", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", "y", "+", 
    RowBox[{"cc", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"3", " ", "x"}], "+", 
    RowBox[{"2", " ", "y"}], "+", "z"}], ",", 
   RowBox[{
    RowBox[{"aa", " ", "x"}], "+", 
    RowBox[{"3", " ", "y"}], "+", 
    RowBox[{"2", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"bb", " ", "x"}], "+", 
    RowBox[{"aa", " ", "y"}], "+", 
    RowBox[{"3", " ", "z"}]}]}], "}"}]], "Output",
 ImageSize->{456, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->372632100]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Higher Dimensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->29972],

Cell["Allow no overhangs:", "ExampleText",
 CellID->13061],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14181],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"5", " ", "a"}], "+", 
      RowBox[{"4", " ", "b"}], "+", 
      RowBox[{"2", " ", "c"}], "+", "d"}], ",", 
     RowBox[{
      RowBox[{"6", " ", "a"}], "+", 
      RowBox[{"5", " ", "b"}], "+", 
      RowBox[{"3", " ", "c"}], "+", 
      RowBox[{"2", " ", "d"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"8", " ", "a"}], "+", 
      RowBox[{"7", " ", "b"}], "+", 
      RowBox[{"5", " ", "c"}], "+", 
      RowBox[{"4", " ", "d"}]}], ",", 
     RowBox[{
      RowBox[{"9", " ", "a"}], "+", 
      RowBox[{"8", " ", "b"}], "+", 
      RowBox[{"6", " ", "c"}], "+", 
      RowBox[{"5", " ", "d"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{494, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->362566467]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27432],

Cell[TextData[{
 "Align with the ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "1"}], "}"}]], "InlineFormula"],
 " elements of the kernel and data: "
}], "ExampleText",
 CellID->17505],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27593],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "+", 
      RowBox[{"3", " ", "b"}], "+", 
      RowBox[{"7", " ", "c"}], "+", 
      RowBox[{"9", " ", "d"}]}], ",", 
     RowBox[{
      RowBox[{"2", " ", "a"}], "+", "b", "+", 
      RowBox[{"8", " ", "c"}], "+", 
      RowBox[{"7", " ", "d"}]}], ",", 
     RowBox[{
      RowBox[{"3", " ", "a"}], "+", 
      RowBox[{"2", " ", "b"}], "+", 
      RowBox[{"9", " ", "c"}], "+", 
      RowBox[{"8", " ", "d"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "a"}], "+", 
      RowBox[{"6", " ", "b"}], "+", "c", "+", 
      RowBox[{"3", " ", "d"}]}], ",", 
     RowBox[{
      RowBox[{"5", " ", "a"}], "+", 
      RowBox[{"4", " ", "b"}], "+", 
      RowBox[{"2", " ", "c"}], "+", "d"}], ",", 
     RowBox[{
      RowBox[{"6", " ", "a"}], "+", 
      RowBox[{"5", " ", "b"}], "+", 
      RowBox[{"3", " ", "c"}], "+", 
      RowBox[{"2", " ", "d"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"7", " ", "a"}], "+", 
      RowBox[{"9", " ", "b"}], "+", 
      RowBox[{"4", " ", "c"}], "+", 
      RowBox[{"6", " ", "d"}]}], ",", 
     RowBox[{
      RowBox[{"8", " ", "a"}], "+", 
      RowBox[{"7", " ", "b"}], "+", 
      RowBox[{"5", " ", "c"}], "+", 
      RowBox[{"4", " ", "d"}]}], ",", 
     RowBox[{
      RowBox[{"9", " ", "a"}], "+", 
      RowBox[{"8", " ", "b"}], "+", 
      RowBox[{"6", " ", "c"}], "+", 
      RowBox[{"5", " ", "d"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{372, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15637650]
}, Open  ]],

Cell["The result has the same dimensions as the input data:", "ExampleText",
 CellID->13031],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8492],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "3"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->129351867]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17222],

Cell["Give a different overhang in each dimension: ", "ExampleText",
 CellID->31286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->40815026],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{486, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->525471155]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22413],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListConvolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListConvolve"]], "InlineFormula"],
 " works with sparse arrays:"
}], "ExampleText",
 CellID->30974],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"6", "->", "x"}], ",", "20"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14270],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", 
   RowBox[{"a", " ", "x"}], ",", 
   RowBox[{"b", " ", "x"}], ",", 
   RowBox[{"c", " ", "x"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], 
  "}"}]], "Output",
 ImageSize->{365, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->112221564]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->235],

Cell[TextData[{
 "Use ",
 Cell[BoxData["f"], "InlineFormula"],
 " in place of ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->30833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", "1", ",", "0", 
   ",", "f"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19711],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"x", ",", "1"}], "]"}], "+", 
    RowBox[{"f", "[", 
     RowBox[{"y", ",", "0"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"x", ",", "2"}], "]"}], "+", 
    RowBox[{"f", "[", 
     RowBox[{"y", ",", "1"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"x", ",", "3"}], "]"}], "+", 
    RowBox[{"f", "[", 
     RowBox[{"y", ",", "2"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"x", ",", "4"}], "]"}], "+", 
    RowBox[{"f", "[", 
     RowBox[{"y", ",", "3"}], "]"}]}]}], "}"}]], "Output",
 ImageSize->{472, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->177992401]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData["g"], "InlineFormula"],
 " in place of ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->18896],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", "1", ",", "0", 
   ",", "f", ",", "g"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4667],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"y", ",", "0"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "1"}], "]"}]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"y", ",", "1"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "2"}], "]"}]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"y", ",", "2"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "3"}], "]"}]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"y", ",", "3"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "4"}], "]"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{550, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->561016503]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", "1", ",", "0", 
   ",", "f", ",", "List"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->12550],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"y", ",", "0"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "1"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"y", ",", "1"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "2"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"y", ",", "2"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "3"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"y", ",", "3"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "4"}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{522, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->102231174]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7627],

Cell[TextData[{
 "Use ",
 Cell[BoxData["f"], "InlineFormula"],
 " and ",
 Cell[BoxData["g"], "InlineFormula"],
 " in place of ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 ", with empty data padding: "
}], "ExampleText",
 CellID->4802],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "1", ",", 
   RowBox[{"{", "}"}], ",", "f", ",", "g"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4099],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"f", "[", "z", "]"}], ",", 
     RowBox[{"f", "[", "y", "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "1"}], "]"}]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"f", "[", "z", "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"y", ",", "1"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "2"}], "]"}]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"z", ",", "1"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"y", ",", "2"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "3"}], "]"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{532, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->44766550]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{"{", "}"}], ",", "f", ",", "g"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2625],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"z", ",", "1"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"y", ",", "2"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "3"}], "]"}]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"z", ",", "2"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"y", ",", "3"}], "]"}], ",", 
     RowBox[{"f", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"z", ",", "3"}], "]"}], ",", 
     RowBox[{"f", "[", "y", "]"}], ",", 
     RowBox[{"f", "[", "x", "]"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{532, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->295652887]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", "}"}], ",", "f", ",", "g"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1924],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"f", "[", "z", "]"}], ",", 
     RowBox[{"f", "[", "y", "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "1"}], "]"}]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"f", "[", "z", "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"y", ",", "1"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "2"}], "]"}]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"z", ",", "1"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"y", ",", "2"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "3"}], "]"}]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"z", ",", "2"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"y", ",", "3"}], "]"}], ",", 
     RowBox[{"f", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"z", ",", "3"}], "]"}], ",", 
     RowBox[{"f", "[", "y", "]"}], ",", 
     RowBox[{"f", "[", "x", "]"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{532, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->285825595]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2695],

Cell["Find a moving average:", "ExampleText",
 CellID->21624],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], "/", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28019],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["a", "2"], "+", 
    FractionBox["b", "2"]}], ",", 
   RowBox[{
    FractionBox["b", "2"], "+", 
    FractionBox["c", "2"]}], ",", 
   RowBox[{
    FractionBox["c", "2"], "+", 
    FractionBox["d", "2"]}], ",", 
   RowBox[{
    FractionBox["d", "2"], "+", 
    FractionBox["e", "2"]}]}], "}"}]], "Output",
 ImageSize->{192, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->363273452]
}, Open  ]],

Cell[TextData[{
 "Or use the ",
 Cell[BoxData[
  ButtonBox["MovingAverage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MovingAverage"]], "InlineFormula"],
 " function:"
}], "ExampleText",
 CellID->282285111],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MovingAverage", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->67670409],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"a", "+", "b"}], "2"], ",", 
   FractionBox[
    RowBox[{"b", "+", "c"}], "2"], ",", 
   FractionBox[
    RowBox[{"c", "+", "d"}], "2"], ",", 
   FractionBox[
    RowBox[{"d", "+", "e"}], "2"]}], "}"}]], "Output",
 ImageSize->{175, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->480924317]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26576],

Cell["Smooth noisy data:", "ExampleText",
 CellID->21694],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", "x", "]"}], "+", 
      RowBox[{"RandomReal", "[", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "30"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22658],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26302],

Cell[BoxData[
 GraphicsBox[{{}, {}, {
    {Hue[0.67, 0.6, 0.6]}, 
    LineBox[{{1., 1.94170605205077}, {2., 2.11177310049472}, {3., 
     2.1449779921055}, {4., 2.08198975207091}, {5., 3.01746516563903}, {6., 
     3.1019660339378}, {7., 3.09581236192851}, {8., 3.16694827177711}, {9., 
     3.77047443096017}, {10., 4.14714678523307}, {11., 4.08858015766108}, {
     12., 4.43827401636962}, {13., 3.82932236449328}, {14., 
     4.01298161601278}, {15., 4.13600171231522}, {16., 4.02237573973585}, {
     17., 4.65655162393595}, {18., 4.97186572245268}, {19., 
     5.18470975610565}, {20., 5.1761790911835}, {21., 4.72702631480375}, {22.,
      4.76517718897205}, {23., 5.79174270894562}, {24., 5.23856950473552}, {
     25., 5.56937406474763}, {26., 5.18451338845456}, {27., 
     5.50712319153686}, {28., 5.34009962146033}, {29., 5.49673694963239}, {
     30., 6.05279710379431}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  Axes->True,
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->{{0., 30.}, {1.94170605205077, 6.05279710379431}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[2]=",
 CellID->41059133]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"ListConvolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "2", ",", "1", ",", "1"}], "}"}], "/", 
     "6"}], ",", "data"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->22466],

Cell[BoxData[
 GraphicsBox[{{}, {}, {
    {Hue[0.67, 0.6, 0.6]}, 
    LineBox[{{1., 2.2404816757444}, {2., 2.42336029938648}, {3., 
     2.7432794118868}, {4., 2.92769126988186}, {5., 3.20807977102852}, {6., 
     3.40821602593563}, {7., 3.67323940642002}, {8., 3.95976174120569}, {9., 
     4.06039631872972}, {10., 4.15909649268991}, {11., 4.05574703855754}, {
     12., 4.07532284415659}, {13., 4.13220579480138}, {14., 
     4.30369202569805}, {15., 4.60467602974688}, {16., 4.83059127597772}, {
     17., 4.98350704409786}, {18., 5.00018952745019}, {19., 
     5.06197689580239}, {20., 5.07731199960208}, {21., 5.31393874852503}, {
     22., 5.29799106009848}, {23., 5.47678282052797}, {24., 
     5.33736552656491}, {25., 5.43416173456144}, {26., 5.48689497938979}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  Axes->True,
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->{{0., 26.}, {2.2404816757444, 5.48689497938979}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[3]=",
 CellID->39245503]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22593],

Cell["Find the autocorrelation of a list:", "ExampleText",
 CellID->23851],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{"i", "^", "2"}], ",", "17"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "100"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25484],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"ListConvolve", "[", 
   RowBox[{"data", ",", "data", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1018],

Cell[BoxData[
 GraphicsBox[{{}, {}, {
    {Hue[0.67, 0.6, 0.6]}, LineBox[CompressedData["
1:eJxdlLtKpEEQhYeNjGQDAwVBV0SWQcTbel+nx/tlXO+6BpuIgpiYa1IPIGKk
mZj4BrLrFVtMDHwKMRuDAcF4lXNOiT0w8/FN/d1/V3d1fVvdmlv/kslk1t6+
78SnlHv/tZq7wD/Ax2t6GfjnjP4VbLigV4CHileCQ5f0avBEz9eCpVN6XeL1
4MJfegN4JP8OBs2XBXfkjWCZ1tME7iveDB7LW0DPtxV8vaW3gV2Kt4MFzf8D
7NR8HeCz4p3gkuJd4P05vRv0/HsS7wVb/tH7wF35T7Co+frBTb0vB1ZpPQHs
4fkY/eWK8Tyo/TC4PUTGB8A9Pm/0Xs0/CI7x/UbPa31D4Abd6EWNHwaVvyWe
GQHL+bzRtzV+FDzQ/PQV7ccYmNV4+pPqdRwcuWGc7vUxkcQnkvGTyfyTyfsL
yfoKyfqnkvzonv+vz250379p0PeX7vs/A+p8Al3nZ3Sdb4R/nP8sqP0IdNWP
0VVfke71NweqPgNd9Wt01Xeke/3Pg8o/JG503a9I9/u3AOp+Brrur9F1vyPd
7/8iqP4Q6H5f6Oovke79ZwlUfwp09S+jq79Fuve/ZVD9MdA9/8Qj3fvvb1D9
OdDVv42u/h7p3v9XPN//iWDkiQ==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  Axes->True,
  ImageMargins->0.,
  ImageSize->Small,
  PlotRange->{{0., 100.}, {5360., 9791.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->490322642]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21119],

Cell["\<\
Apply a simple image\[Hyphen]processing filter:\
\>", "ExampleText",
 CellID->23152],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"CellularAutomaton", "[", 
   RowBox[{"150", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "30"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2800],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJydU9sRgzAMs7tIj0G6REdgge7/R2hLHlZkOxhCIgdH6IS3/fPeHyLyLONV
hqioKn96e+WS3zhjtvb2tDIoWXt75znfD6jzFQyPeelVaAuGx3yvpQ+Gx7yY
2eb99/5SpIoKsD1z7ivDppr4yjDqyfg8q+W+Moy6Mz6T6qTPjHsNW+7xtgk/
oGNNLqg23tpcxI3/MPcXuRU0x3obN2rO1mLf5vQ27vmc5fb6N+b2+jfm9vo3
5l7xF7lX/EXuO3ob9/3aUO8Bb8UH8w==
   "], {{0, 0}, {61, 31}}, {0, 1}],
  Frame->Automatic,
  FrameTicks->{None, None},
  ImageMargins->0.,
  ImageSize->{150, Automatic}]], "Output",
 ImageSize->{154, 80},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->7593814]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"ListConvolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", 
    RowBox[{"CellularAutomaton", "[", 
     RowBox[{"150", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "30"}], "]"}]}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31060],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJydk+sRAyEIhHELyUz6SBUp4RpI//+iZhBBQXLOPVx8fHJ7PK/P+wIRPer9
qjeV3qgAZdOPxsYU1LbrR2N1F7S90LrtTX0YI261mid7YShMcatVvB2c86Ax
1dcqPueBqXlaxVsuBfwB5PL0fJp+evmS8vQ01HEcPz2tFzt+etqQc/4uVM45
4+9mad7f/eKkvw4ZylD+f/lyqZzN7KlWAZVzmj21tRsvNp7a2IGs69TW9YFs
mRJNkNd8U9Q9M0n9kYN6PZODej2Tg3o9k4N6PZP/8HUly/MG+UauQo6pX6Dx
DWE=
   "], {{0, 0}, {60, 30}}, {0, 2}],
  Frame->Automatic,
  FrameTicks->{None, None},
  ImageMargins->0.,
  ImageSize->{150, Automatic}]], "Output",
 ImageSize->{154, 78},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->120735464]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9010],

Cell["Multiply polynomials by convolving coefficient lists:", "ExampleText",
 CellID->4757],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefficientList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       RowBox[{"x", "^", "2"}]}]}], ")"}], 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", "x"}], "+", 
      RowBox[{"3", 
       RowBox[{"x", "^", "2"}]}], "+", 
      RowBox[{"4", 
       RowBox[{"x", "^", "3"}]}]}], ")"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32170],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{
    RowBox[{"2", " ", "a"}], "+", "b"}], ",", 
   RowBox[{
    RowBox[{"3", " ", "a"}], "+", 
    RowBox[{"2", " ", "b"}], "+", "c"}], ",", 
   RowBox[{
    RowBox[{"4", " ", "a"}], "+", 
    RowBox[{"3", " ", "b"}], "+", 
    RowBox[{"2", " ", "c"}]}], ",", 
   RowBox[{
    RowBox[{"4", " ", "b"}], "+", 
    RowBox[{"3", " ", "c"}]}], ",", 
   RowBox[{"4", " ", "c"}]}], "}"}]], "Output",
 ImageSize->{324, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->90345652]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", "0"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9576],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{
    RowBox[{"2", " ", "a"}], "+", "b"}], ",", 
   RowBox[{
    RowBox[{"3", " ", "a"}], "+", 
    RowBox[{"2", " ", "b"}], "+", "c"}], ",", 
   RowBox[{
    RowBox[{"4", " ", "a"}], "+", 
    RowBox[{"3", " ", "b"}], "+", 
    RowBox[{"2", " ", "c"}]}], ",", 
   RowBox[{
    RowBox[{"4", " ", "b"}], "+", 
    RowBox[{"3", " ", "c"}]}], ",", 
   RowBox[{"4", " ", "c"}]}], "}"}]], "Output",
 ImageSize->{324, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->97800715]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12043],

Cell["Multiply numbers by convolving digit lists:", "ExampleText",
 CellID->22758],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"IntegerDigits", "[", "24561", "]"}], ",", 
   RowBox[{"IntegerDigits", "[", "1247", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7164],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "8", ",", "21", ",", "46", ",", "61", ",", "61", ",", "46", ",", 
   "7"}], "}"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->328936719]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromDigits", "[", 
  RowBox[{"%", ",", "10"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7882],

Cell[BoxData["30627567"], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->160033422]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"24561", " ", "1247"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->29565],

Cell[BoxData["30627567"], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->153801455]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29577],

Cell["Pascal's triangle:", "ExampleText",
 CellID->14474],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{
   RowBox[{"NestList", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"ListConvolve", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", "#", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"-", "1"}]}], "}"}], ",", "0"}], "]"}], "&"}], ",", 
     RowBox[{"{", "1", "}"}], ",", "5"}], "]"}], ",", "Center"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25627],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{"{", "1", "}"}]},
    {
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "1"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "3", ",", "1"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{"1", ",", "4", ",", "6", ",", "4", ",", "1"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{"1", ",", "5", ",", "10", ",", "10", ",", "5", ",", "1"}], 
      "}"}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  "Column"]], "Output",
 ImageSize->{130, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8575588]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31928],

Cell["Additive cellular automaton in base 5:", "ExampleText",
 CellID->25423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{"ListConvolve", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2", ",", "3", ",", "1"}], "}"}], ",", "#", ",", "2"}], 
        "]"}], ",", "5"}], "]"}], "&"}], ",", 
    RowBox[{"SparseArray", "[", 
     RowBox[{
      RowBox[{"50", "->", "1"}], ",", "101"}], "]"}], ",", "50"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28520],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJy1llF2xCAIRVHcSNfQnXQJPaff3f9fATM+NDoj9sybxhowmnhR+fj+/frO
RPQp149cZaG8cqSVg5cOypnL9EqrH2eaX/N+sg7O8o+JpODEKVGz5ZKIUrnX
Ckm7kuTWXlLe57LRqj/5fhK7FSSv6WyZKaVZzdrZLaes/T1sy/6KvES+CjF6
mzw8r1k7u5VBvG3Z3wU59/Bygzyrcbul3rbsT+qcSuUHXGqqtiIzUmRCiv4l
vSGrmJ1Yf9o2VbdeZruYQzrHlSWQ6YxXW9K30nkXp5BWAMJB31YMMl+swMSr
oGoTs9EY1GAJZLDVSVC+RtqKOgVas3bmRRPPHAJLIIOt9qh8jbQVdQq0Zu3M
iyaeueMyQQZbaXypFaXVuHlTb7sJaI0b4gDBYB5b3oBscYGtwGLgxtxxSR03
xAGCgctjiQNy5m4rsHi5MXdcem6IAwQDljgaD1vBnLnj0nNDHCAYsMTReNgK
5swdl55b7gtu3gHysBU8H6O4RYzFXj9SiQK83dc5bucC9vtXwiLGYq8fyR34
3A4vnAvY719pAO8+sgcPxwB+Y4wbePeRPXg3fA9+SwN495HNOxz0A/gtGUsw
h2yRg7kbXsNii7l7JnfMIdsU8iRhsbDYYu6e6ZlDA3M3/DZz9wxPx7gxd8Nv
M3fPrBzx5O6J6qY9uZ7kcHEZS9u47QA33OA7z+HiwsYN3K9yuLiwcQP3qxwu
LmzcqbfV8VrxnzGuJY6zeyuHi8uWOM7urRwuruHs3srh4hrO7q0cLq7h7N7K
4eKycz+Yw8Vl534wh4vrJIeL6ySHi+skh4vrJIeL6ySHi+skh4vrJIeL6ySH
i+skh4vrJIeL653MoXcyh07G+AMmSEP4
   "], {{0, 0}, {101, 51}}, {0, 4}],
  Frame->Automatic,
  FrameTicks->{None, None},
  ImageMargins->0.,
  ImageSize->Small]], "Output",
 ImageSize->{184, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->566625941]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->132953520],

Cell["\<\
Fast multiplication of high\[Hyphen]degree polynomials:\
\>", "ExampleText",
 CellID->58171455],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"p1", "[", "x_", "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"RandomInteger", "[", 
     RowBox[{"9", ",", " ", "101"}], "]"}], ".", 
    RowBox[{"x", "^", 
     RowBox[{"Range", "[", 
      RowBox[{"0", ",", "100"}], "]"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"p2", "[", "x_", "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"RandomInteger", "[", 
     RowBox[{"9", ",", " ", "101"}], "]"}], ".", 
    RowBox[{"x", "^", 
     RowBox[{"Range", "[", 
      RowBox[{"0", ",", "100"}], "]"}]}]}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->156237349],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListConvolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListConvolve"]], "InlineFormula"],
 " with maximal overhangs and zero padding:"
}], "ExampleText",
 CellID->50778219],

Cell[BoxData[
 RowBox[{
  RowBox[{"c3", " ", "=", " ", 
   RowBox[{"ListConvolve", "[", 
    RowBox[{
     RowBox[{"CoefficientList", "[", 
      RowBox[{
       RowBox[{"p1", "[", "x", "]"}], ",", "x"}], "]"}], ",", " ", 
     RowBox[{"CoefficientList", "[", 
      RowBox[{
       RowBox[{"p2", "[", "x", "]"}], ",", "x"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", " ", "0"}], "]"}]}], " ", 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->208833980],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"p3", "[", "x_", "]"}], " ", "=", " ", 
   RowBox[{"c3", ".", 
    RowBox[{"x", "^", 
     RowBox[{"Range", "[", 
      RowBox[{"0", ",", " ", 
       RowBox[{
        RowBox[{"Length", "[", "c3", "]"}], " ", "-", " ", "1"}]}], 
      "]"}]}]}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->97712419],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"p3", "[", "x", "]"}], " ", "\[Equal]", " ", 
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{"p1", "[", "x", "]"}], " ", 
    RowBox[{"p2", "[", "x", "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->329105975],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->128991887]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14962],

Cell["\<\
Cyclic convolution is equivalent to multiplication in the discrete Fourier \
transform domain:\
\>", "ExampleText",
 CellID->129707231],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", " ", "b"}], "}"}], " ", "=", " ", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", " ", 
     RowBox[{"{", 
      RowBox[{"2", ",", "31"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->196296258],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ListConvolve", "[", 
   RowBox[{"a", ",", " ", "b", ",", " ", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}], "]"}], " ", "==", 
  RowBox[{
   RowBox[{"InverseFourier", "[", 
    RowBox[{
     RowBox[{"Fourier", "[", "a", "]"}], " ", 
     RowBox[{"Fourier", "[", "b", "]"}]}], "]"}], " ", 
   RowBox[{"Sqrt", "[", "31", "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5777019],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->566111958]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->405633154],

Cell["Convolve with a single element:", "ExampleText",
 CellID->123],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24596],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->249128479]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
   ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13261],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "1"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->788151143]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32525],

Cell["\<\
A kernel of the same length as the data, with no overhangs, is like a \
reversed dot product:\
\>", "ExampleText",
 CellID->1264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8260],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"c", " ", "x"}], "+", 
   RowBox[{"b", " ", "y"}], "+", 
   RowBox[{"a", " ", "z"}]}], "}"}]], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->81894433]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8116],

Cell["Successive differences:", "ExampleText",
 CellID->5030],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20326],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "a"}], "+", "b"}], ",", 
   RowBox[{
    RowBox[{"-", "b"}], "+", "c"}], ",", 
   RowBox[{
    RowBox[{"-", "c"}], "+", "d"}], ",", 
   RowBox[{
    RowBox[{"-", "d"}], "+", "e"}]}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->535487660]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Differences", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30771],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "a"}], "+", "b"}], ",", 
   RowBox[{
    RowBox[{"-", "b"}], "+", "c"}], ",", 
   RowBox[{
    RowBox[{"-", "c"}], "+", "d"}], ",", 
   RowBox[{
    RowBox[{"-", "d"}], "+", "e"}]}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->85377601]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25547],

Cell["Align with successive elements:", "ExampleText",
 CellID->21153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ListConvolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}],
       ",", "i"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "3"}], "}"}]}], "]"}], "//", "Column"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21520],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmttO20AQhp34EFCbAK3EKagKVVGROKl9iPaqDxGhSnBRtaI8efsArjfx
gPN7ZnfWXjuogES8O17Paddr+9N8m9/ffP8xv7+9ns++3s1/3dxe/559+XlX
iOJBFA3+RFF0th8V7bxoLf7N39/if9lcthLzG9PZPDotfpKiuw/yq1J+LMjf
g/xSkJ8I8g+CPF54GYP0DPp7xc+w6H4G+UyQH5fyT4L8VJB/BDl6O2S9NX3T
TUstw/KYwThzPi26I5Bjn8bh3G2WdmKwg9dn5bgNRs7ZkeyNhLjQ3kY5DvVL
fmUt7aVCfJJfiWDPZUfKo29cVbnLXhs7/OpcSNOH/mLMMsdR8jiKz3L9ulHp
O+aEH00Rv4LRcc26Th9Z1/lq92mkzAt6tsnY1mekG58Sa7ZcEcRun1rM1Trz
kgXyoX6XDUGKK5I8p3vVdm9HlnGT4ieLHvfEUTkO5zABfanCrmm+EfwmO2nF
PuevzQ/yv57TDKyw65mxxnljmluM17zVJjFsMTmsWRO8tXuR5/Vdf7AYh7s4
jqJ50jyb7Ps89sfWGcNcsblbsedagdjfESLl9l0hu9Z4WT2N42dXbsPnKt43
fUaNa1yKt817g+0e499dqruo3ar+iWiPZqsmcT9laD/I5LnxWjHGh5iNmn2j
r3vrjHvF45XrzbpLVLbpLZyP2r0P1fM6UdlMvGzyeeT2mKZvWKJ/9Wid6x3X
Cn0p0BGf1sMywqV79GfymNJarjyX8PvjrUob5ioutU+Y2Kvadxjrde0YEWkf
M5mpasf9KmW1b4MP9Fb02qEtY7Vxo1ImQzhrY3GW8J5s+1W3z0ovIAsHHtci
JzrS66pcdejQcg7np9B3x2WaOD/LzHH5NN3D8nhVztIhyE1k5hY+Up6/qJwn
wkb6Y2ZFL8mXaSKzs7cwnnc5T9aI3O0Jci3Rk8b7ET3kikTckNztCnIX0ZPG
NyN6RsoRG9932ZDEiyOHEtELTQ4lf9qSQxrXFznUxteWHGoJZb9E7ykQmRBc
ryuquM68cLbX7ZNftkJTRT+mGZ7ocXuMRPSiyJf6uLibixdKfK8pL9RwSo3f
Sd4HL9RGo+WF/Fprygt1RI+7ilvZbvah++bXcjX3l7trjYQmiK63rKaRWma9
R4LoH387gthV1Lp3F/aqANHK5GU7l1iX6xns3hUe/OuYIapoZ0OGWPetP4a4
Quh6YohJHoYhhiF6fmzIRZp0RG+ch+SDEsFz8UFkc2H54DZjva5dywcxFj8+
2OarDhkXT8J4ClelavIoHcGbqnTZrjJN5H5Y54Xj/YgekTYib9PyeJmvEjyS
E8GbwvnqsUr4zkHeN9Gj2jqpRg+z70v0pPF+RA9r62Y5T+iops+X6OF4C9F7
3K9zO8fru9LLxfG65oahKw61vOu5Vxxadv7Oa/G6YURPoSJvvZWK3XKql0rF
2my04HlVftdvjRjqTdVemGZbWuhbXaitx3se1YU6nkfPSN3d1V/Flpvf9c0P
w1Yg+lfgvVQgauY75LvLemq2dHtrf+Swm+pDWhf9k8P/q/rQwvPE78h2XMhF
8yasNqQOYdmgtnZQV4nYlA0+5dpB3b64C/1mFW0+tA+r/Hyu7afKD2edp3m7
ub2ODuke1e8d5Dzd09bvuWheNPgHQf8TEA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{498, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->149345559]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ListConvolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}],
       ",", "i"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"-", "3"}], ",", 
      RowBox[{"-", "1"}]}], "}"}]}], "]"}], "//", "Column"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14924],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmttO20AQhp34EFCbAK3EKagKVVGROKl9iPaqDxGhSnBRtaI8efsArjfx
gPN7ZnfWXjuogES8O17Paddr+9N8m9/ffP8xv7+9ns++3s1/3dxe/559+XlX
iOJBFA3+RFF0th8V7bxoLf7N39/if9lcthLzG9PZPDotfpKiuw/yq1J+LMjf
g/xSkJ8I8g+CPF54GYP0DPp7xc+w6H4G+UyQH5fyT4L8VJB/BDl6O2S9NX3T
TUstw/KYwThzPi26I5Bjn8bh3G2WdmKwg9dn5bgNRs7ZkeyNhLjQ3kY5DvVL
fmUt7aVCfJJfiWDPZUfKo29cVbnLXhs7/OpcSNOH/mLMMsdR8jiKz3L9ulHp
O+aEH00Rv4LRcc26Th9Z1/lq92mkzAt6tsnY1mekG58Sa7ZcEcRun1rM1Trz
kgXyoX6XDUGKK5I8p3vVdm9HlnGT4ieLHvfEUTkO5zABfanCrmm+EfwmO2nF
PuevzQ/yv57TDKyw65mxxnljmluM17zVJjFsMTmsWRO8tXuR5/Vdf7AYh7s4
jqJ50jyb7Ps89sfWGcNcsblbsedagdjfESLl9l0hu9Z4WT2N42dXbsPnKt43
fUaNa1yKt817g+0e499dqruo3ar+iWiPZqsmcT9laD/I5LnxWjHGh5iNmn2j
r3vrjHvF45XrzbpLVLbpLZyP2r0P1fM6UdlMvGzyeeT2mKZvWKJ/9Wid6x3X
Cn0p0BGf1sMywqV79GfymNJarjyX8PvjrUob5ioutU+Y2Kvadxjrde0YEWkf
M5mpasf9KmW1b4MP9Fb02qEtY7Vxo1ImQzhrY3GW8J5s+1W3z0ovIAsHHtci
JzrS66pcdejQcg7np9B3x2WaOD/LzHH5NN3D8nhVztIhyE1k5hY+Up6/qJwn
wkb6Y2ZFL8mXaSKzs7cwnnc5T9aI3O0Jci3Rk8b7ET3kikTckNztCnIX0ZPG
NyN6RsoRG9932ZDEiyOHEtELTQ4lf9qSQxrXFznUxteWHGoJZb9E7ykQmRBc
ryuquM68cLbX7ZNftkJTRT+mGZ7ocXuMRPSiyJf6uLibixdKfK8pL9RwSo3f
Sd4HL9RGo+WF/Fprygt1RI+7ilvZbvah++bXcjX3l7trjYQmiK63rKaRWma9
R4LoH387gthV1Lp3F/aqANHK5GU7l1iX6xns3hUe/OuYIapoZ0OGWPetP4a4
Quh6YohJHoYhhiF6fmzIRZp0RG+ch+SDEsFz8UFkc2H54DZjva5dywcxFj8+
2OarDhkXT8J4ClelavIoHcGbqnTZrjJN5H5Y54Xj/YgekTYib9PyeJmvEjyS
E8GbwvnqsUr4zkHeN9Gj2jqpRg+z70v0pPF+RA9r62Y5T+iops+X6OF4C9F7
3K9zO8fru9LLxfG65oahKw61vOu5Vxxadv7Oa/G6YURPoSJvvZWK3XKql0rF
2my04HlVftdvjRjqTdVemGZbWuhbXaitx3se1YU6nkfPSN3d1V/Flpvf9c0P
w1Yg+lfgvVQgauY75LvLemq2dHtrf+Swm+pDWhf9k8P/q/rQwvPE78h2XMhF
8yasNqQOYdmgtnZQV4nYlA0+5dpB3b64C/1mFW0+tA+r/Hyu7afKD2edp3m7
ub2ODuke1e8d5Dzd09bvuWheNPgHQf8TEA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{498, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->266155122]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21763],

Cell["Varying alignments:", "ExampleText",
 CellID->4940],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ListConvolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "j"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "4"}], "}"}]}], "]"}], "//", "Grid"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20851],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlW8FuE0EMnSSEAm1pgBZxoE35AlRx4ogQcOIjogqpPSBQ6a/R31t2MwpC
r57aju3ZqaiUdGdiv+fxzO7OczZfV9cX376vri/PV6dfrlY/Ly7Pf51+/nHV
d80mKU1+p5Tev0r9cdcfrV/D303/Smk5vM82fV16DO1PzOcHRntv/wW0T9aj
PIHeXWh/hPaT/m3aN58J7RZb2m/+Pwe7YzLqaf8275sPGJaS3cMg/9q4O4X+
ctbS/G97bSOLlfYa5munKmZrjMOnj0Tx5Bk5hl5qnv9tf2Ds8Zy3+kfj4TUJ
8V931LpFFm6uuais/tF4mCXZ2T2H9oyJCu0xCqt/NB5mCfHpLOGKmzJRoT1G
YfWPxsMsIX78nWI/HGsshqci3pzhJcE+I6xx17exO9jS3uq3KPjn3eRweKM6
egk43K72ndLe298bD89H/PxonaUj6C3tws8KdqVdOGfv4Uf5H5Kj0u6CMQqv
XXQUbm2+khoo2Zdnxbr7pkYYu9+vw9hiPGX9IY82r4RD6NWqjbdK/2i8aHzu
Wo58LzrqfNOqFVxZVrVixYvG57Isu6pp1Q5GbVU7VrxofC7LyEdnWauWMGqr
WrLiReNzWUY+zR1apoJk9yWLzvJnGIuX1neyaPLModrh1ByqC6mak/pZ/RcM
TlYvw6FOFe4DjlZVvTH6R+N543PXEWzvrbO8B72cWlwy9lY/D967cHbJUXup
LYwyWjXW5qsdh1a9lvrLsx6r+Ki8jKlAW4inxWi31cvyseQViN+sW9Uw992h
VQ1740fzae+ByD/cVW5fJ6xqeumcxWj8aD7tLMmu5lY1jqPyVuPe+NF82llC
fnqWrGoeR+Wt5r3xo/m0s4T8mp2RRYnjOGtVAGrxjhWNph4hizGvCFTf0qoD
qlht1UHrb8XB6kUJL6vl4VBXxUAc76qBN15t/Np85BNCt+5d0qoGniXaqobW
3xun9ITtlMxKdHWBuuaMUc1oJY77Gl+palNeVWNWGahstlsTaT/a/2cs8ie9
88rHvbd3tcZaXWqNrzV+7kn1SUdd37yrPXjWRFd7ovla4+eetKfvYt7VIhx1
dLUomq81fu6XAvQse1ebcNTR1aZovtb4uV86aHak/tUg2f6nVm1q3Gjub4yy
X3zklUb1Dk1pVYs6v+7y98aJwiv9oiRXZ4bDXE1Lkz+pb25k\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{437, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->162147013]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ListConvolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"-", "j"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "4"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13829],

Cell[BoxData[
 RowBox[{
  RowBox[{"ListConvolve", "::", "\<\"nlen\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"The end conditions cannot be \
satisfied. A zero length list will be returned.\\\\\\\"\\\", \\\"MSG\\\"]\\) \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, \
ButtonData:>\\\"paclet://Messages/ListConvolve/nlen\\\"]\\)\"\>"}]], "Message",\
 "MSG",
 CellID->89566712],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2", ",", "2", ",", "2"}], "}"}], 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2", ",", "2"}], "}"}], 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2"}], "}"}], 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2", ",", "2"}], "}"}], 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2"}], "}"}], 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], 
     RowBox[{"{", "2", "}"}]},
    {
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2"}], "}"}], 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], 
     RowBox[{"{", "2", "}"}], 
     RowBox[{"{", "}"}]},
    {
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], 
     RowBox[{"{", "2", "}"}], 
     RowBox[{"{", "}"}], 
     RowBox[{"{", "}"}]}
   }],
  "Grid"]], "Output",
 ImageSize->{296, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->191790175]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ListConvolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "i"}], ",", "j"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "4"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->18958],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmsFuEzEQhp2EtEApTaAgDrQpT4AqThwRgqoHHiKqkNoDApW+f1jH2mr1
x8t4OjPeSdRKcWJnPfN7xvZ6v/TH8u7656/l3c3V8uzidvnn+ubq79n337dN
02QUwvgihPD5XWg+r5pP61f7d9m8QngSy8l9e3gG9SPjurW/mXP/3vVMYpHK
Tuvzphg31RnxPod+hw+0076/UrY3N9I5z9S79sbZqMbWadhck3sDtWMUvOnb
3zHdu5YHrp3+VRGm9/X1NalvXFn77r6lMudLLf3t08eRPmZceV2klT6GVrxK
++yzB/WDyv7x7OVNj/d4cfM7isXG/cRaNbUj1I6aNz3e48XNb/7UMjVWjf4w
atb+MWre9HiPFze/+VmGO562arxDY9Ss/WPUvOnxHi9ufjlPYIdVWx92zq6r
8eWOKd+1TEjmW1oZudZYPSp8p84yXHszY7vWuqn4JPrc5uVSVMN5qk3aPwjt
c/duqT/pvWVo//j9i1ikstNKkXsk84vC/hThL7VT+kuH1F7fLx0H2agNRZhx
lFo6tAi1lT5rEr+tuvuu75+1vmgqlYNt5bf1xjL07xq7PdLyjKcVZ02A8fn4
ROhPSpCl/qVnHG96qHjFU8nmvqytklqj1rNE2780K970UPHK3721CSxSLIwK
15+U4Er9S7PiTQ8Vr/ws0SaoSEAxKlx/UgIr9a9N2IfWQ8WL8yRQi01jzORq
9HmmvsZa/Hx7lJdlIs3gHEWPVS5RRirXZ6eUwJba4xJqLbt9uhMNbOMuI8dv
wbaUdH4S2qP2SGv72v6k94g3sUhlp/V/5LZ73Tmjn0Z/qY5SYnycjYo1+cNR
DEVwveiorc+ayPbPqiHZai6aflmaf7UexzI0CU4z/xhapWwFn6c+Cu1ziZ21
P2v/2oT19Sq3v0lVUatGO+q1/Vn71yak+buYlIAhwcJRaxPH2v6s/WsTznyW
pQQLCRSOWpsY1vZn7V+bUHJOpPqsr+z8U4slDatmKI21yGOaaUiDKHKFVpCW
lBI6LTtSe1zSl+hMG1cZiVuAbS5p+ibsj3uRtj1rvdT1p+son0IrkigkV1+J
6/sIVWm/PvLG7d+n/yQ7ai0igyqtSVRtf17GzbXTn3VbYpKLy5Bcw4Oe7Yqe
1kxIM1D6P114/v4itEcREm37tcfDjef7VW6f4Kqg5rF0VNb2a4+HG8/8bs4l
EEgQcFRSomJtv/Z4uPHMZ4lLEJAA4KikRMTafu3xcOPJORlJSEDZvVz/Ob6W
X19RkGQqzYhFRmmsUmQBn2IpUiHtr6WDGld6Wm7jlghFGP0Dy2b2qw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{583, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->241309527]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8365],

Cell["Varying alignments, with padding:", "ExampleText",
 CellID->13007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ListConvolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "j"}], "}"}], ",", "0"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "4"}], "}"}]}], "]"}], "//", "Grid"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11477],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "2", ",", "2"}], "}"}], 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "2", ",", "2", ",", "1"}], "}"}], 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "2", ",", "2", ",", "1", ",", "0"}], "}"}], 
     
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "2", ",", "2", ",", "1", ",", "0", ",", "0"}], 
      "}"}]},
    {
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2"}], "}"}], 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2", ",", "1"}], "}"}], 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2", ",", "1", ",", "0"}], "}"}], 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2", ",", "1", ",", "0", ",", "0"}], 
      "}"}]},
    {
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "1"}], "}"}], 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "1", ",", "0"}], "}"}], 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "1", ",", "0", ",", "0"}], "}"}]},
    {
     RowBox[{"{", "2", "}"}], 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "0"}], "}"}], 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "0", ",", "0"}], "}"}]}
   }],
  "Grid"]], "Output",
 ImageSize->{441, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->516272963]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ListConvolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"-", "j"}]}], "}"}], ",", "0"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "4"}], "}"}]}], "]"}], "//", "Grid"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26058],

Cell[BoxData[
 RowBox[{
  RowBox[{"ListConvolve", "::", "\<\"nlen\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"The end conditions cannot be \
satisfied. A zero length list will be returned.\\\\\\\"\\\", \\\"MSG\\\"]\\) \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, \
ButtonData:>\\\"paclet://Messages/ListConvolve/nlen\\\"]\\)\"\>"}]], "Message",\
 "MSG",
 CellID->163882859],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "2", ",", "2", ",", "1"}], "}"}], 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "2", ",", "2"}], "}"}], 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "2"}], "}"}], 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2", ",", "1"}], "}"}], 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2"}], "}"}], 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], 
     RowBox[{"{", "2", "}"}]},
    {
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "1"}], "}"}], 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], 
     RowBox[{"{", "2", "}"}], 
     RowBox[{"{", "}"}]},
    {
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], 
     RowBox[{"{", "2", "}"}], 
     RowBox[{"{", "}"}], 
     RowBox[{"{", "}"}]}
   }],
  "Grid"]], "Output",
 ImageSize->{296, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->363392247]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ListConvolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "i"}], ",", "j"}], "}"}], ",", "0"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "4"}], "}"}]}], "]"}], "//", "Grid"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->12760],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlXN9PE0EQPnoWEASpovFBKP4FxvjkozFKePCPaIgJPBgN8v/Xu55Hmo/Z
zszNzHZbSbiys92Zb37s3t63Ld9n9zc/fs7ub69nF5d3s983t9d/Lr79umtE
9U5VjS6rqvr0pmr+njd/LX77n6vmt6qetNf6QV49hfbz4Ha0vZPC7ZeOp24v
3XVJetBcRk3zhHmdwLijgXr61xfO+iZBOCdEe1nfiIxq226bY5DvJeS7zWVc
PZ7DXnKMQmn49rYMdwrPtvmTktOzYiEdP7QX7+lstTNrb2UvrqayUUN7V+Vs
c7xoew8Ii9vt3f+cWa+a7+bvCKQ1OfaIlOLu4xja3G5lF9qHa8SC93xc7UrC
RlvZPMQyP3YWctl9RuaNtj1sTYnBgk8EJWOjrWweYpkfmv2QzJtBT39BkdVi
yTmHrNjy12kM4nXVKa72HHrcc3hGVosF72yRWbdiy1+nMYjXVacaNPljbUeX
c2/gj3YbIm6vd0pa/8Pev/ZcJcprQiu19mr09Zwo7sq99Pb9UbixH+10jHmf
lytTC2vT+3TgnVG/dtdhtWfdja/bPvY/ay/ddUnKnTbgPXQqHM+dSkj1SE9n
rPpSpzOHZNRSrHg0+41eeuFIseql4POS7yfwbCru1OkGXbWr2eP1nV9g9CNw
7hu8oCzmxm/pTVlMx2S7vZNXZjePZFy093nCmYtVbleA/biS+KDQ7l2OSSsl
Y5OdBixOxITrsjfvP3Wxqt2Fx6DQtumclYxN9tStuc978/PDooVWORQcw+mD
QssMRtZTDLb4erLy6MOihVa56CHL4ZMzre+IIrKeYrDF15M/3z0sfrRuTVRi
7on2+OS8S+ZCq6lLio2vKz1LjUxfSg+lj2KnpfoQV98/MeLk9Kbi0DGMfdxt
bPRr0G1lTz8a9XH3lWj93vas7PKr9tJdl6Sr2ODl931QjPMYb8UhZaFPyai0
8yySHUQvvOxpWeFScKRY0Sh8Q/yh8KVYXrqqUGs+vhbjGIFkNXvHMbJlIiwr
whGfFpcxyl09n4IUq97Kn7436ueYCtQXbU/GMFpRcKg0T0No++Vcso5ZeU5u
7lh3YrntyZ5orChErIAw7/R85/Ju5SO5CGhPQjjmMdqeT96tbGJ83q28IRcB
Tj+5whnybrXnk3cr6xefd39+j4uJRjftqfVe4I8gf2Qsn07V1A8yQO2817By
yJCkxi+3KTZuqJ7UZ0Ol+pB9QxYR9XaMTB9XG/s2Bd1adumrcTyukd76ovFy
7z9fRPkcpMg+4Rr+hXl/ipWSjkuxbdrxKfxnpNdeLAyijGafcttLsUal4EjJ
01mPZamouMRwJdx/MFgvkk2JmFfeu3rDz4Zpn4eRTfps1Md9Q99bv4wtymNV
huXtnFontIi4mrayM9H6Zfv5PFZlWOj1nfvGFcfmoIdafdq6sOoflrcYq5a8
4bqnZWPQQ60+jnXz1j8sbzFWLXnTfJN0mM92C9q11N9iKZ7b8z8lMLZNjhXB
J93UuNQ3Z7XjU2zFUD0pv7on6j5uHYtR7fwFkXKGKg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{583, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->602126462]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14460],

Cell["By default, the output is not the same length as the input:", \
"ExampleText",
 CellID->22428],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12993],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "5", ",", "7", ",", "9"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->576142209]
}, Open  ]],

Cell["\<\
Use overhangs to make the output the same length as the input:\
\>", "ExampleText",
 CellID->19405],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6540],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", "3", ",", "5", ",", "7", ",", "9"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->106593571]
}, Open  ]],

Cell["Use overhangs to do the same in 2D:", "ExampleText",
 CellID->28704],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->12835],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"20", ",", "18", ",", "22"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "12", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"26", ",", "24", ",", "28"}], "}"}]}], "}"}]], "Output",
 ImageSize->{276, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->115827329]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24488],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListCorrelate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListCorrelate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MovingAverage",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MovingAverage"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Partition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Partition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inner",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inner"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellularAutomaton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellularAutomaton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PadLeft",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadLeft"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16282]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3297],

Cell[TextData[ButtonBox["Convolutions and Correlations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ConvolutionsAndCorrelations"]], "Tutorials",
 CellID->20416]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->28286],

Cell[TextData[{
 ButtonBox["Demonstrations with ListConvolve",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=ListConvolve"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#15670"], None}]], "RelatedLinks",
 CellID->16105],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
ListConvolve"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->9073103],

Cell[TextData[ButtonBox["Handling Arrays of Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HandlingArraysOfData"]], "MoreAbout",
 CellID->854937423],

Cell[TextData[ButtonBox["Image Processing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImageProcessing"]], "MoreAbout",
 CellID->313307482],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "MoreAbout",
 CellID->542696018],

Cell[TextData[ButtonBox["Signal Processing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SignalProcessing"]], "MoreAbout",
 CellID->390431479]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ListConvolve - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 55, 55.3164158}", "context" -> "System`", 
    "keywords" -> {
     "banded matrices", "circulant matrix multiplication", "convolutions", 
      "data", "filtering", "finite difference methods", "FIR filters", 
      "image processing", "kernel", "masking", "signal processing", 
      "smoothing", "time series", "Toeplitz matrix multiplication"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ListConvolve[ker, list] forms the convolution of the kernel ker with \
list. ListConvolve[ker, list, k] forms the cyclic convolution in which the \
k\\[Null]^th element of ker is aligned with each element in list. \
ListConvolve[ker, list, {k_L, k_R}] forms the cyclic convolution whose first \
element contains list[[1]] ker[[k_L]] and whose last element contains \
list[[-1]] ker[[k_R]]. ListConvolve[ker, list, klist, p] forms the \
convolution in which list is padded at each end with repetitions of the \
element p. ListConvolve[ker, list, klist, {p_1, p_2, ...}] forms the \
convolution in which list is padded at each end with cyclic repetitions of \
the p_i. ListConvolve[ker, list, klist, padding, g, h] forms a generalized \
convolution in which g is used in place of Times and h in place of Plus. \
ListConvolve[ker, list, klist, padding, g, h, lev] forms a convolution using \
elements at level lev in ker and list. ", "synonyms" -> {"list convolve"}, 
    "title" -> "ListConvolve", "type" -> "Symbol", "uri" -> 
    "ref/ListConvolve"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[21934, 753, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->61043363]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 119144, 4236}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2743, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3366, 89, 49, 1, 70, "ObjectName",
 CellID->7441],
Cell[3418, 92, 6189, 197, 70, "Usage",
 CellID->9512]
}, Open  ]],
Cell[CellGroupData[{
Cell[9644, 294, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[10122, 311, 851, 32, 70, "Notes",
 CellID->30145],
Cell[10976, 345, 652, 24, 70, "Notes",
 CellID->18060],
Cell[11631, 371, 638, 23, 70, "Notes",
 CellID->21718],
Cell[12272, 396, 668, 25, 70, "Notes",
 CellID->3753],
Cell[12943, 423, 849, 33, 70, "Notes",
 CellID->16139],
Cell[13795, 458, 348, 14, 70, "Notes",
 CellID->12423],
Cell[14146, 474, 1149, 32, 70, "2ColumnTableMod",
 CellID->16279],
Cell[15298, 508, 325, 11, 70, "Notes",
 CellID->25996],
Cell[15626, 521, 778, 26, 70, "Notes",
 CellID->16687],
Cell[16407, 549, 142, 6, 70, "Notes",
 CellID->12529],
Cell[16552, 557, 1186, 31, 70, "2ColumnTableMod",
 CellID->22549],
Cell[17741, 590, 231, 7, 70, "Notes",
 CellID->17437],
Cell[17975, 599, 2304, 84, 70, "Notes",
 CellID->19866],
Cell[20282, 685, 875, 34, 70, "Notes",
 CellID->12949],
Cell[21160, 721, 481, 17, 70, "Notes",
 CellID->193],
Cell[21644, 740, 253, 8, 70, "Notes",
 CellID->23195]
}, Closed]],
Cell[CellGroupData[{
Cell[21934, 753, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->61043363],
Cell[CellGroupData[{
Cell[22318, 767, 148, 5, 70, "ExampleSection",
 CellID->647262440],
Cell[22469, 774, 183, 7, 70, "ExampleText",
 CellID->11701],
Cell[CellGroupData[{
Cell[22677, 785, 268, 9, 28, "Input",
 CellID->31316],
Cell[22948, 796, 604, 22, 36, "Output",
 CellID->406811336]
}, Open  ]],
Cell[23567, 821, 120, 3, 70, "ExampleDelimiter",
 CellID->5786],
Cell[23690, 826, 110, 3, 70, "ExampleText",
 CellID->12263],
Cell[CellGroupData[{
Cell[23825, 833, 278, 9, 70, "Input",
 CellID->4313],
Cell[24106, 844, 687, 25, 36, "Output",
 CellID->58468102]
}, Open  ]],
Cell[24808, 872, 163, 5, 70, "ExampleText",
 CellID->31185],
Cell[CellGroupData[{
Cell[24996, 881, 279, 9, 70, "Input",
 CellID->20053],
Cell[25278, 892, 688, 25, 36, "Output",
 CellID->484993596]
}, Open  ]],
Cell[25981, 920, 121, 3, 70, "ExampleDelimiter",
 CellID->10808],
Cell[26105, 925, 145, 5, 70, "ExampleText",
 CellID->1832],
Cell[CellGroupData[{
Cell[26275, 934, 291, 9, 70, "Input",
 CellID->20945],
Cell[26569, 945, 690, 25, 36, "Output",
 CellID->337971803]
}, Open  ]],
Cell[27274, 973, 121, 3, 70, "ExampleDelimiter",
 CellID->28321],
Cell[27398, 978, 67, 1, 70, "ExampleText",
 CellID->19558],
Cell[CellGroupData[{
Cell[27490, 983, 530, 18, 70, "Input",
 CellID->23646],
Cell[28023, 1003, 486, 16, 36, "Output",
 CellID->2540882]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28558, 1025, 215, 7, 70, "ExampleSection",
 CellID->4144],
Cell[CellGroupData[{
Cell[28798, 1036, 241, 7, 70, "ExampleSubsection",
 CellID->23196],
Cell[29042, 1045, 151, 4, 70, "ExampleText",
 CellID->20222],
Cell[CellGroupData[{
Cell[29218, 1053, 277, 9, 70, "Input",
 CellID->7129],
Cell[29498, 1064, 635, 22, 36, "Output",
 CellID->883329182]
}, Open  ]],
Cell[30148, 1089, 89, 1, 70, "ExampleText",
 CellID->5535],
Cell[CellGroupData[{
Cell[30262, 1094, 289, 9, 70, "Input",
 CellID->20450],
Cell[30554, 1105, 822, 28, 36, "Output",
 CellID->71911419]
}, Open  ]],
Cell[31391, 1136, 90, 1, 70, "ExampleText",
 CellID->10466],
Cell[CellGroupData[{
Cell[31506, 1141, 308, 10, 70, "Input",
 CellID->12044],
Cell[31817, 1153, 822, 28, 36, "Output",
 CellID->39996776]
}, Open  ]],
Cell[32654, 1184, 83, 1, 70, "ExampleText",
 CellID->26292],
Cell[CellGroupData[{
Cell[32762, 1189, 359, 12, 70, "Input",
 CellID->26439],
Cell[33124, 1203, 1011, 34, 54, "Output",
 CellID->245454876]
}, Open  ]],
Cell[34150, 1240, 121, 3, 70, "ExampleDelimiter",
 CellID->20024],
Cell[34274, 1245, 161, 5, 70, "ExampleText",
 CellID->26154],
Cell[CellGroupData[{
Cell[34460, 1254, 289, 9, 70, "Input",
 CellID->29510],
Cell[34752, 1265, 823, 28, 36, "Output",
 CellID->204504099]
}, Open  ]],
Cell[35590, 1296, 161, 5, 70, "ExampleText",
 CellID->20649],
Cell[CellGroupData[{
Cell[35776, 1305, 289, 9, 70, "Input",
 CellID->13186],
Cell[36068, 1316, 823, 28, 36, "Output",
 CellID->523074325]
}, Open  ]],
Cell[36906, 1347, 160, 5, 70, "ExampleText",
 CellID->4474],
Cell[CellGroupData[{
Cell[37091, 1356, 289, 9, 70, "Input",
 CellID->28022],
Cell[37383, 1367, 822, 28, 36, "Output",
 CellID->96503380]
}, Open  ]],
Cell[38220, 1398, 121, 3, 70, "ExampleDelimiter",
 CellID->14018],
Cell[38344, 1403, 119, 3, 70, "ExampleText",
 CellID->18787],
Cell[CellGroupData[{
Cell[38488, 1410, 307, 10, 70, "Input",
 CellID->9905],
Cell[38798, 1422, 823, 28, 36, "Output",
 CellID->523027613]
}, Open  ]],
Cell[39636, 1453, 120, 3, 70, "ExampleDelimiter",
 CellID->7391],
Cell[39759, 1458, 137, 4, 70, "ExampleText",
 CellID->10202],
Cell[CellGroupData[{
Cell[39921, 1466, 337, 11, 70, "Input",
 CellID->3625],
Cell[40261, 1479, 823, 28, 36, "Output",
 CellID->333544574]
}, Open  ]],
Cell[41099, 1510, 160, 5, 70, "ExampleText",
 CellID->4414],
Cell[CellGroupData[{
Cell[41284, 1519, 337, 11, 70, "Input",
 CellID->9314],
Cell[41624, 1532, 728, 25, 36, "Output",
 CellID->27895507]
}, Open  ]],
Cell[42367, 1560, 160, 5, 70, "ExampleText",
 CellID->29334],
Cell[CellGroupData[{
Cell[42552, 1569, 338, 11, 70, "Input",
 CellID->25874],
Cell[42893, 1582, 916, 31, 36, "Output",
 CellID->28332456]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[43858, 1619, 229, 7, 70, "ExampleSubsection",
 CellID->28297],
Cell[44090, 1628, 110, 5, 70, "ExampleText",
 CellID->7518],
Cell[CellGroupData[{
Cell[44225, 1637, 289, 9, 70, "Input",
 CellID->8177],
Cell[44517, 1648, 707, 24, 36, "Output",
 CellID->454111893]
}, Open  ]],
Cell[45239, 1675, 121, 3, 70, "ExampleDelimiter",
 CellID->32270],
Cell[45363, 1680, 80, 1, 70, "ExampleText",
 CellID->1763],
Cell[CellGroupData[{
Cell[45468, 1685, 339, 11, 70, "Input",
 CellID->2668],
Cell[45810, 1698, 706, 24, 36, "Output",
 CellID->13985390]
}, Open  ]],
Cell[CellGroupData[{
Cell[46553, 1727, 351, 11, 70, "Input",
 CellID->13985],
Cell[46907, 1740, 707, 24, 36, "Output",
 CellID->646562016]
}, Open  ]],
Cell[CellGroupData[{
Cell[47651, 1769, 396, 13, 70, "Input",
 CellID->8480],
Cell[48050, 1784, 710, 24, 36, "Output",
 CellID->372632100]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[48809, 1814, 234, 7, 70, "ExampleSubsection",
 CellID->29972],
Cell[49046, 1823, 58, 1, 70, "ExampleText",
 CellID->13061],
Cell[CellGroupData[{
Cell[49129, 1828, 530, 18, 70, "Input",
 CellID->14181],
Cell[49662, 1848, 891, 30, 36, "Output",
 CellID->362566467]
}, Open  ]],
Cell[50568, 1881, 121, 3, 70, "ExampleDelimiter",
 CellID->27432],
Cell[50692, 1886, 193, 7, 70, "ExampleText",
 CellID->17505],
Cell[CellGroupData[{
Cell[50910, 1897, 543, 19, 70, "Input",
 CellID->27593],
Cell[51456, 1918, 1668, 54, 71, "Output",
 CellID->15637650]
}, Open  ]],
Cell[53139, 1975, 92, 1, 70, "ExampleText",
 CellID->13031],
Cell[CellGroupData[{
Cell[53256, 1980, 101, 3, 70, "Input",
 CellID->8492],
Cell[53360, 1985, 203, 7, 36, "Output",
 CellID->129351867]
}, Open  ]],
Cell[53578, 1995, 121, 3, 70, "ExampleDelimiter",
 CellID->17222],
Cell[53702, 2000, 84, 1, 70, "ExampleText",
 CellID->31286],
Cell[CellGroupData[{
Cell[53811, 2005, 698, 24, 70, "Input",
 CellID->40815026],
Cell[54512, 2031, 2383, 43, 70, "Output",
 Evaluatable->False,
 CellID->525471155]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[56956, 2081, 239, 7, 70, "ExampleSection",
 CellID->22413],
Cell[57198, 2090, 207, 7, 70, "ExampleText",
 CellID->30974],
Cell[CellGroupData[{
Cell[57430, 2101, 278, 9, 70, "Input",
 CellID->14270],
Cell[57711, 2112, 443, 12, 36, "Output",
 CellID->112221564]
}, Open  ]],
Cell[58169, 2127, 119, 3, 70, "ExampleDelimiter",
 CellID->235],
Cell[58291, 2132, 233, 10, 70, "ExampleText",
 CellID->30833],
Cell[CellGroupData[{
Cell[58549, 2146, 279, 9, 70, "Input",
 CellID->19711],
Cell[58831, 2157, 768, 27, 36, "Output",
 CellID->177992401]
}, Open  ]],
Cell[59614, 2187, 231, 10, 70, "ExampleText",
 CellID->18896],
Cell[CellGroupData[{
Cell[59870, 2201, 288, 9, 70, "Input",
 CellID->4667],
Cell[60161, 2212, 904, 31, 36, "Output",
 CellID->561016503]
}, Open  ]],
Cell[CellGroupData[{
Cell[61102, 2248, 292, 9, 70, "Input",
 CellID->12550],
Cell[61397, 2259, 884, 31, 36, "Output",
 CellID->102231174]
}, Open  ]],
Cell[62296, 2293, 120, 3, 70, "ExampleDelimiter",
 CellID->7627],
Cell[62419, 2298, 427, 17, 70, "ExampleText",
 CellID->4802],
Cell[CellGroupData[{
Cell[62871, 2319, 303, 9, 70, "Input",
 CellID->4099],
Cell[63177, 2330, 846, 28, 36, "Output",
 CellID->44766550]
}, Open  ]],
Cell[CellGroupData[{
Cell[64060, 2363, 322, 10, 70, "Input",
 CellID->2625],
Cell[64385, 2375, 847, 28, 36, "Output",
 CellID->295652887]
}, Open  ]],
Cell[CellGroupData[{
Cell[65269, 2408, 373, 12, 70, "Input",
 CellID->1924],
Cell[65645, 2422, 1262, 41, 54, "Output",
 CellID->285825595]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[66956, 2469, 222, 7, 70, "ExampleSection",
 CellID->2695],
Cell[67181, 2478, 61, 1, 70, "ExampleText",
 CellID->21624],
Cell[CellGroupData[{
Cell[67267, 2483, 284, 10, 70, "Input",
 CellID->28019],
Cell[67554, 2495, 504, 19, 51, "Output",
 CellID->363273452]
}, Open  ]],
Cell[68073, 2517, 213, 8, 70, "ExampleText",
 CellID->282285111],
Cell[CellGroupData[{
Cell[68311, 2529, 213, 7, 70, "Input",
 CellID->67670409],
Cell[68527, 2538, 412, 15, 51, "Output",
 CellID->480924317]
}, Open  ]],
Cell[68954, 2556, 121, 3, 70, "ExampleDelimiter",
 CellID->26576],
Cell[69078, 2561, 57, 1, 70, "ExampleText",
 CellID->21694],
Cell[69138, 2564, 318, 11, 70, "Input",
 CellID->22658],
Cell[CellGroupData[{
Cell[69481, 2579, 107, 3, 70, "Input",
 CellID->26302],
Cell[69591, 2584, 1357, 29, 170, "Output",
 CellID->41059133]
}, Open  ]],
Cell[CellGroupData[{
Cell[70985, 2618, 284, 9, 70, "Input",
 CellID->22466],
Cell[71272, 2629, 1245, 27, 159, "Output",
 CellID->39245503]
}, Open  ]],
Cell[72532, 2659, 121, 3, 70, "ExampleDelimiter",
 CellID->22593],
Cell[72656, 2664, 74, 1, 70, "ExampleText",
 CellID->23851],
Cell[72733, 2667, 311, 11, 70, "Input",
 CellID->25484],
Cell[CellGroupData[{
Cell[73069, 2682, 233, 7, 70, "Input",
 CellID->1018],
Cell[73305, 2691, 1129, 28, 118, "Output",
 CellID->490322642]
}, Open  ]],
Cell[74449, 2722, 121, 3, 70, "ExampleDelimiter",
 CellID->21119],
Cell[74573, 2727, 94, 3, 70, "ExampleText",
 CellID->23152],
Cell[CellGroupData[{
Cell[74692, 2734, 262, 9, 70, "Input",
 CellID->2800],
Cell[74957, 2745, 660, 17, 101, "Output",
 CellID->7593814]
}, Open  ]],
Cell[CellGroupData[{
Cell[75654, 2767, 546, 19, 70, "Input",
 CellID->31060],
Cell[76203, 2788, 695, 18, 99, "Output",
 CellID->120735464]
}, Open  ]],
Cell[76913, 2809, 120, 3, 70, "ExampleDelimiter",
 CellID->9010],
Cell[77036, 2814, 91, 1, 70, "ExampleText",
 CellID->4757],
Cell[CellGroupData[{
Cell[77152, 2819, 485, 17, 70, "Input",
 CellID->32170],
Cell[77640, 2838, 583, 20, 36, "Output",
 CellID->90345652]
}, Open  ]],
Cell[CellGroupData[{
Cell[78260, 2863, 344, 11, 70, "Input",
 CellID->9576],
Cell[78607, 2876, 583, 20, 36, "Output",
 CellID->97800715]
}, Open  ]],
Cell[79205, 2899, 121, 3, 70, "ExampleDelimiter",
 CellID->12043],
Cell[79329, 2904, 82, 1, 70, "ExampleText",
 CellID->22758],
Cell[CellGroupData[{
Cell[79436, 2909, 305, 9, 70, "Input",
 CellID->7164],
Cell[79744, 2920, 276, 9, 36, "Output",
 CellID->328936719]
}, Open  ]],
Cell[CellGroupData[{
Cell[80057, 2934, 125, 4, 70, "Input",
 CellID->7882],
Cell[80185, 2940, 165, 5, 36, "Output",
 CellID->160033422]
}, Open  ]],
Cell[CellGroupData[{
Cell[80387, 2950, 95, 3, 70, "Input",
 CellID->29565],
Cell[80485, 2955, 165, 5, 36, "Output",
 CellID->153801455]
}, Open  ]],
Cell[80665, 2963, 121, 3, 70, "ExampleDelimiter",
 CellID->29577],
Cell[80789, 2968, 57, 1, 70, "ExampleText",
 CellID->14474],
Cell[CellGroupData[{
Cell[80871, 2973, 482, 16, 70, "Input",
 CellID->25627],
Cell[81356, 2991, 784, 29, 108, "Output",
 CellID->8575588]
}, Open  ]],
Cell[82155, 3023, 121, 3, 70, "ExampleDelimiter",
 CellID->31928],
Cell[82279, 3028, 77, 1, 70, "ExampleText",
 CellID->25423],
Cell[CellGroupData[{
Cell[82381, 3033, 514, 17, 70, "Input",
 CellID->28520],
Cell[82898, 3052, 1210, 26, 116, "Output",
 CellID->566625941]
}, Open  ]],
Cell[84123, 3081, 125, 3, 70, "ExampleDelimiter",
 CellID->132953520],
Cell[84251, 3086, 105, 3, 70, "ExampleText",
 CellID->58171455],
Cell[84359, 3091, 621, 20, 70, "Input",
 CellID->156237349],
Cell[84983, 3113, 234, 8, 70, "ExampleText",
 CellID->50778219],
Cell[85220, 3123, 512, 16, 70, "Input",
 CellID->208833980],
Cell[85735, 3141, 352, 12, 70, "Input",
 CellID->97712419],
Cell[CellGroupData[{
Cell[86112, 3157, 257, 8, 70, "Input",
 CellID->329105975],
Cell[86372, 3167, 161, 5, 36, "Output",
 CellID->128991887]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[86582, 3178, 233, 7, 70, "ExampleSection",
 CellID->14962],
Cell[86818, 3187, 145, 4, 70, "ExampleText",
 CellID->129707231],
Cell[86966, 3193, 296, 10, 70, "Input",
 CellID->196296258],
Cell[CellGroupData[{
Cell[87287, 3207, 427, 13, 70, "Input",
 CellID->5777019],
Cell[87717, 3222, 161, 5, 36, "Output",
 CellID->566111958]
}, Open  ]],
Cell[87893, 3230, 125, 3, 70, "ExampleDelimiter",
 CellID->405633154],
Cell[88021, 3235, 68, 1, 70, "ExampleText",
 CellID->123],
Cell[CellGroupData[{
Cell[88114, 3240, 243, 8, 70, "Input",
 CellID->24596],
Cell[88360, 3250, 247, 8, 36, "Output",
 CellID->249128479]
}, Open  ]],
Cell[CellGroupData[{
Cell[88644, 3263, 254, 8, 70, "Input",
 CellID->13261],
Cell[88901, 3273, 247, 8, 36, "Output",
 CellID->788151143]
}, Open  ]],
Cell[89163, 3284, 121, 3, 70, "ExampleDelimiter",
 CellID->32525],
Cell[89287, 3289, 139, 4, 70, "ExampleText",
 CellID->1264],
Cell[CellGroupData[{
Cell[89451, 3297, 244, 8, 70, "Input",
 CellID->8260],
Cell[89698, 3307, 284, 10, 36, "Output",
 CellID->81894433]
}, Open  ]],
Cell[89997, 3320, 120, 3, 70, "ExampleDelimiter",
 CellID->8116],
Cell[90120, 3325, 61, 1, 70, "ExampleText",
 CellID->5030],
Cell[CellGroupData[{
Cell[90206, 3330, 279, 10, 70, "Input",
 CellID->20326],
Cell[90488, 3342, 400, 15, 36, "Output",
 CellID->535487660]
}, Open  ]],
Cell[CellGroupData[{
Cell[90925, 3362, 183, 6, 70, "Input",
 CellID->30771],
Cell[91111, 3370, 399, 15, 36, "Output",
 CellID->85377601]
}, Open  ]],
Cell[91525, 3388, 121, 3, 70, "ExampleDelimiter",
 CellID->25547],
Cell[91649, 3393, 70, 1, 70, "ExampleText",
 CellID->21153],
Cell[CellGroupData[{
Cell[91744, 3398, 445, 14, 70, "Input",
 CellID->21520],
Cell[92192, 3414, 1895, 35, 70, "Output",
 Evaluatable->False,
 CellID->149345559]
}, Open  ]],
Cell[CellGroupData[{
Cell[94124, 3454, 499, 16, 70, "Input",
 CellID->14924],
Cell[94626, 3472, 1895, 35, 70, "Output",
 Evaluatable->False,
 CellID->266155122]
}, Open  ]],
Cell[96536, 3510, 121, 3, 70, "ExampleDelimiter",
 CellID->21763],
Cell[96660, 3515, 57, 1, 70, "ExampleText",
 CellID->4940],
Cell[CellGroupData[{
Cell[96742, 3520, 522, 17, 70, "Input",
 CellID->20851],
Cell[97267, 3539, 1419, 27, 70, "Output",
 Evaluatable->False,
 CellID->162147013]
}, Open  ]],
Cell[CellGroupData[{
Cell[98723, 3571, 550, 18, 70, "Input",
 CellID->13829],
Cell[99276, 3591, 434, 9, 70, "Message",
 CellID->89566712],
Cell[99713, 3602, 1065, 38, 78, "Output",
 CellID->191790175]
}, Open  ]],
Cell[CellGroupData[{
Cell[100815, 3645, 550, 18, 70, "Input",
 CellID->18958],
Cell[101368, 3665, 1549, 29, 70, "Output",
 Evaluatable->False,
 CellID->241309527]
}, Open  ]],
Cell[102932, 3697, 120, 3, 70, "ExampleDelimiter",
 CellID->8365],
Cell[103055, 3702, 72, 1, 70, "ExampleText",
 CellID->13007],
Cell[CellGroupData[{
Cell[103152, 3707, 532, 17, 70, "Input",
 CellID->11477],
Cell[103687, 3726, 1472, 47, 78, "Output",
 CellID->516272963]
}, Open  ]],
Cell[CellGroupData[{
Cell[105196, 3778, 556, 18, 70, "Input",
 CellID->26058],
Cell[105755, 3798, 435, 9, 70, "Message",
 CellID->163882859],
Cell[106193, 3809, 1065, 38, 78, "Output",
 CellID->363392247]
}, Open  ]],
Cell[CellGroupData[{
Cell[107295, 3852, 556, 18, 70, "Input",
 CellID->12760],
Cell[107854, 3872, 1781, 33, 70, "Output",
 Evaluatable->False,
 CellID->602126462]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[109684, 3911, 226, 7, 70, "ExampleSection",
 CellID->14460],
Cell[109913, 3920, 100, 2, 70, "ExampleText",
 CellID->22428],
Cell[CellGroupData[{
Cell[110038, 3926, 258, 9, 70, "Input",
 CellID->12993],
Cell[110299, 3937, 223, 7, 36, "Output",
 CellID->576142209]
}, Open  ]],
Cell[110537, 3947, 109, 3, 70, "ExampleText",
 CellID->19405],
Cell[CellGroupData[{
Cell[110671, 3954, 267, 9, 70, "Input",
 CellID->6540],
Cell[110941, 3965, 233, 7, 36, "Output",
 CellID->106593571]
}, Open  ]],
Cell[111189, 3975, 74, 1, 70, "ExampleText",
 CellID->28704],
Cell[CellGroupData[{
Cell[111288, 3980, 543, 19, 70, "Input",
 CellID->12835],
Cell[111834, 4001, 400, 13, 36, "Output",
 CellID->115827329]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[112295, 4021, 311, 9, 70, "SeeAlsoSection",
 CellID->24488],
Cell[112609, 4032, 1463, 53, 70, "SeeAlso",
 CellID->16282]
}, Open  ]],
Cell[CellGroupData[{
Cell[114109, 4090, 313, 9, 70, "TutorialsSection",
 CellID->3297],
Cell[114425, 4101, 167, 3, 70, "Tutorials",
 CellID->20416]
}, Open  ]],
Cell[CellGroupData[{
Cell[114629, 4109, 321, 9, 70, "RelatedLinksSection",
 CellID->28286],
Cell[114953, 4120, 369, 12, 70, "RelatedLinks"],
Cell[115325, 4134, 267, 6, 70, "RelatedLinks",
 CellID->16105],
Cell[115595, 4142, 390, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[116022, 4160, 317, 9, 70, "MoreAboutSection",
 CellID->9073103],
Cell[116342, 4171, 155, 3, 70, "MoreAbout",
 CellID->854937423],
Cell[116500, 4176, 143, 3, 70, "MoreAbout",
 CellID->313307482],
Cell[116646, 4181, 139, 3, 70, "MoreAbout",
 CellID->542696018],
Cell[116788, 4186, 145, 3, 70, "MoreAbout",
 CellID->390431479]
}, Open  ]],
Cell[116948, 4192, 27, 0, 70, "History"],
Cell[116978, 4194, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

