(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    719173,      17328]
NotebookOptionsPosition[    676361,      15860]
NotebookOutlinePosition[    678028,      15903]
CellTagsIndexPosition[    677940,      15898]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ListPlot" :> Documentation`HelpLookup["paclet:ref/ListPlot"], 
          "Plot" :> Documentation`HelpLookup["paclet:ref/Plot"], "ListPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/ListPlot3D"], "Graphics" :> 
          Documentation`HelpLookup["paclet:ref/Graphics"], "Fit" :> 
          Documentation`HelpLookup["paclet:ref/Fit"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ListPlot\"\>", 2->"\<\"Plot\"\>", 
       3->"\<\"ListPlot3D\"\>", 4->"\<\"Graphics\"\>", 
       5->"\<\"Fit\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DataVisualization"], 
          "New in 6.0: Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60DataVisualization"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Data Visualization\"\>", 
       2->"\<\"New in 6.0: Data Visualization\"\>", 
       3->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ListLinePlot", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListLinePlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListLinePlot"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["y", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["y", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]plots a line through a list of values, assumed to \
correspond to ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " coordinates 1, 2, ",
     StyleBox["\[Ellipsis]", "TR"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListLinePlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListLinePlot"], "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["1", "TR"]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["2", "TR"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["2", "TR"]]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]plots a line through specific ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " positions. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListLinePlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListLinePlot"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["list", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["list", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]plots several lines. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->25430]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListLinePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLinePlot"]], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ", with the following additions and changes: "
}], "Notes",
 CellID->16078],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AspectRatio",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AspectRatio"], 
    RowBox[{"1", "/", 
     ButtonBox["GoldenRatio",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GoldenRatio"]}], Cell[
    "ratio of height to width", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Axes",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Axes"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to draw axes ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ClippingStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ClippingStyle"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "what to draw when lines are clipped", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ColorFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to determine the coloring of lines ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ColorFunctionScaling",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunctionScaling"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[{
     "whether to scale arguments to ",
     Cell[BoxData[
      ButtonBox["ColorFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DataRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DataRange"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "the range of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " values to assume for data "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Filling",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Filling"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "filling under each line ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FillingStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FillingStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "style to use for filling ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["InterpolationOrder",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/InterpolationOrder"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "the polynomial degree of curves used in joining data points", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MaxPlotPoints",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MaxPlotPoints"], 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[
    "the maximum number of points to include ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Mesh",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Mesh"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "how many mesh points to draw on each line ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MeshFunctions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MeshFunctions"], 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}], Cell[
    "how to determine the placement of mesh points ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MeshShading",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MeshShading"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "how to shade regions between mesh points ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MeshStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MeshStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the style for mesh points ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the method to use for interpolation and data reduction ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotMarkers",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotMarkers"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "markers to use to indicate each point ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRange"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "range of values to include", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotRangeClipping",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRangeClipping"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to clip at the plot range ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "graphics directives to determine the style of each line ", "TableText"]}
  },
  GridBoxAlignment->{"Columns" -> {Left, Left, {Left}}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True}}}},
 CellID->21901],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlotStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotStyle"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " uses a sequence of different plot styles for different lines. "
}], "Notes",
 CellID->19086],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlotStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotStyle"], "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["style", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["style", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["style", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are used cyclically to determine the styles for each line. "
}], "Notes",
 CellID->25019],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlotMarkers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotMarkers"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " explicitly draws markers to indicate each point in each of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5075],

Cell[TextData[{
 "Interactive labeling can be specified for points or lines using ",
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["StatusArea",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StatusArea"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Annotation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Annotation"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18467],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"], "[", 
   SubscriptBox[
    StyleBox["y", "TI"], 
    StyleBox["i", "TI"]], "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["i", "TI"]], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["i", "TI"]]}], "}"}], "]"}]], "InlineFormula"],
 " indicates that the coordinates of a point should be displayed in its \
tooltip. "
}], "Notes",
 CellID->30492],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " specifies that coordinate tooltips should be displayed for all points in \
the list. "
}], "Notes",
 CellID->17251],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["label", "TI"]}], "]"}]], "InlineFormula"],
 " gives the specified tooltip label for the line defined by ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23597],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListLinePlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListLinePlot"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["list", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["list", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 " by default takes the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " coordinates for successive values in each of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " to be successive integers starting at 1. "
}], "Notes",
 CellID->15715],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DataRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DataRange"], "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["max", "TI"]]}], "}"}]}]], "InlineFormula"],
 " specifies other ranges of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " coordinates to use, with ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["max", "TI"]]], "InlineFormula"],
 " being associated with the last element in the longest of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27057],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DataRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DataRange"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListLinePlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListLinePlot"], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["11", "TR"]], ",", 
       SubscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["12", "TR"]]}], "}"}], ",", 
     StyleBox["\[Ellipsis]", "TR"], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["n1", "TI"]], ",", 
       SubscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["n2", "TI"]]}], "}"}]}], "}"}], "]"}]], "InlineFormula"],
 " will be taken to give ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " values for ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " points on a single line, rather than the ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " values for ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " separate lines each containing just two points. "
}], "Notes",
 CellID->15588],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListLinePlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListLinePlot"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{
     ButtonBox["DataRange",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DataRange"], "->", 
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"]}]}], "]"}]], "InlineFormula"],
 " always takes ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " to represent values in a list of separate lines. "
}], "Notes",
 CellID->8999],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can be ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->22588],

Cell[TextData[{
 "The arguments supplied to functions in ",
 Cell[BoxData[
  ButtonBox["MeshFunctions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshFunctions"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 ". Functions in ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " are by default supplied with scaled versions of these arguments. "
}], "Notes",
 CellID->11025],

Cell["The functions are evaluated all along each line. ", "Notes",
 CellID->8007],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ClippingStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ClippingStyle"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " a line is drawn at the top or bottom of the plotting area wherever a line \
goes outside the range of the plot. "
}], "Notes",
 CellID->29624],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListLinePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLinePlot"]], "InlineFormula"],
 " normally returns ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      ButtonBox["Line",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Line"], "[", 
      StyleBox["\[Ellipsis]", "TR"], "]"}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15768],

Cell[TextData[{
 "With a ",
 Cell[BoxData[
  ButtonBox["Filling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Filling"]], "InlineFormula"],
 " specification given, ",
 Cell[BoxData[
  ButtonBox["ListLinePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLinePlot"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      ButtonBox["GraphicsComplex",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GraphicsComplex"], "[", 
      StyleBox["\[Ellipsis]", "TR"], "]"}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15115]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->63489598],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->118367028],

Cell[TextData[{
 "Plot a list of ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " values:"
}], "ExampleText",
 CellID->1588],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Prime", "[", 
    RowBox[{"Range", "[", "25", "]"}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->55522471],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 2.}, {2., 3.}, {3., 5.}, {4., 7.}, {5., 11.}, {6., 
   13.}, {7., 17.}, {8., 19.}, {9., 23.}, {10., 29.}, {11., 31.}, {12., 
   37.}, {13., 41.}, {14., 43.}, {15., 47.}, {16., 53.}, {17., 59.}, {18., 
   61.}, {19., 67.}, {20., 71.}, {21., 73.}, {22., 79.}, {23., 83.}, {24., 
   89.}, {25., 97.}, {1., 0.}, {25., 0.}}, {{{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{1, 26, 27, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14,
         13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2}},
        VertexColors->None]]}, {}, {}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
       19, 20, 21, 22, 23, 24, 25}]}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 25.}, {0., 97.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->490717526]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->288302413],

Cell[TextData[{
 "Plot a list of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", ",", " ", "y"}], TraditionalForm]], "InlineMath"],
 " pairs: "
}], "ExampleText",
 CellID->148438464],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"k", " ", "2", 
         RowBox[{"Pi", "/", "7"}]}], "]"}], ",", 
       RowBox[{"Sin", "[", 
        RowBox[{"k", " ", "2", 
         RowBox[{"Pi", "/", "7"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "21", ",", "3"}], "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->219104540],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1., 0.}, {-0.9009688679024191, 0.4338837391175581}, {
     0.6234898018587335, -0.7818314824680298}, {-0.2225209339563144, 
     0.9749279121818236}, {-0.2225209339563144, -0.9749279121818236}, {
     0.6234898018587335, 
     0.7818314824680298}, {-0.9009688679024191, -0.4338837391175581}, {1., 
     0.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  AxesOrigin->{0, 0},
  Frame->True,
  PlotRange->{{-0.9009688679024191, 1.}, {-0.9749279121818236, 
   0.9749279121818236}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33495792]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->483632782],

Cell["Plot multiple datasets: ", "ExampleText",
 CellID->189219298],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Accumulate", "[", 
      RowBox[{"RandomReal", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "250"}], "]"}], "]"}], 
     ",", 
     RowBox[{"{", "3", "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->760142577],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 99},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->243933347]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32708],

Cell["Use different styling to emphasize features: ", "ExampleText",
 CellID->327438128],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Accumulate", "[", 
    RowBox[{"RandomReal", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "250"}], "]"}], "]"}], 
   ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<Rainbow\>\""}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19242602],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->430409822]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(16)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7359],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Data",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->22776660],

Cell["Lines are drawn through the data points:", "ExampleText",
 CellID->5555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"{", 
   RowBox[{
   "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13", ",", "21"}], "}"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->172764079],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1., 1.}, {2., 2.}, {3., 3.}, {4., 5.}, {5., 8.}, {6., 13.}, {7.,
      21.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 7.}, {0., 21.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->386768367]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1676973343],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", ",", "y"}], TraditionalForm]], "InlineMath"],
 " pairs:"
}], "ExampleText",
 CellID->1689261069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"8", ",", "16"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"13", ",", "32"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"21", ",", "64"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1315592573],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1., 1.}, {2., 2.}, {3., 4.}, {5., 8.}, {8., 16.}, {13., 32.}, {
     21., 64.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 21.}, {0., 64.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->201306680]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1261349458],

Cell["Show multiple sets of data:", "ExampleText",
 CellID->557014116],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13", ",", "21"}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "2", ",", "4", ",", "8", ",", "16", ",", "32", ",", "64"}], 
     "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->855030339],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1., 1.}, {2., 2.}, {3., 3.}, {4., 5.}, {5., 8.}, {6., 13.}, {7.,
      21.}}]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], 
    LineBox[{{1., 1.}, {2., 2.}, {3., 4.}, {4., 8.}, {5., 16.}, {6., 32.}, {
     6.3531249999999995`, 43.29999999999998}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 7.}, {0., 43.29999999999998}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->124357235]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->100736041],

Cell["The plot range is selected automatically: ", "ExampleText",
 CellID->749339086],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "25", ",", "8", ",", "9"}],
    "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11813271],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1., 1.}, {2., 2.}, {3., 3.}, {4., 4.}, {4.661904761904762, 
     17.900000000000002`}}], 
    LineBox[{{5.41764705882353, 17.900000000000002`}, {6., 8.}, {7., 9.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 7.}, {0., 17.900000000000002`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->197237925]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->77265725],

Cell["Specify what values the data ranges over:", "ExampleText",
 CellID->1524917287],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "4", ",", "3", ",", "5", ",", "9", ",", "8", ",", 
     "7"}], "}"}], ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1214999311],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{0., 1.}, {0.14285714285714285`, 2.}, {0.2857142857142857, 4.}, {
     0.42857142857142855`, 3.}, {0.5714285714285714, 5.}, {0.7142857142857143,
      9.}, {0.8571428571428571, 8.}, {1., 7.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 1.}, {0., 9.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->267763261]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->119237889],

Cell["Ranges where the data is nonreal are excluded:", "ExampleText",
 CellID->360827733],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "None", ",", "5", ",", "6", ",", 
    RowBox[{"Missing", "[", "\"\<NotAvailable\>\"", "]"}], ",", "8", ",", 
    "9"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->453187265],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[{{1., 1.}, {2., 2.}, {3., 3.}}], 
    LineBox[{{5., 5.}, {6., 6.}}], LineBox[{{8., 8.}, {9., 9.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 2.},
  PlotRange->{{0, 9.}, {1., 9.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->411301112]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->252963271],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["InterpolationOrder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolationOrder"]], "InlineFormula"],
 " to smooth the data:"
}], "ExampleText",
 CellID->430742835],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListLinePlot", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "2", ",", "4", ",", "7", ",", "3", ",", "5", ",", "8", ",", 
      "10", ",", "9"}], "}"}], "]"}], ",", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "4", ",", "7", ",", "3", ",", "5", ",", "8", ",", 
       "10", ",", "9"}], "}"}], ",", 
     RowBox[{"InterpolationOrder", "\[Rule]", "2"}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30552953],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{1., 1.}, {2., 2.}, {3., 4.}, {4., 7.}, {5., 3.}, {6., 5.}, {
       7., 8.}, {8., 10.}, {9., 9.}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 9.}, {0., 10.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxF0glMFGcUB/BdWHa5BJbdZU9gdmcRyFLwaKhY6PcnDaWaIodQUDxXrBcp
msYDNSpVa0F7YBGwClKkSgtoKRa01QoJXlCvrU3xiC0elVREwGsR0Qrz1k5m
8jKZ+eb9f28+ozUnZb6TSCRa9PIarsLRyxy1XvHmy7OPdTQuvl7wYy+zBq94
efaz6Hkpk0vW9THl8OP6ByzcpentoKx+dmJKd+uU7oesdndp2+vzHrAVIwse
s8bQJ9dPrHnIRpZbn7D3am0bOuoescv5ZR35ZXZW2Rnyc7D9MSsYvu0YYDcn
dJ9UTbWzkc8rBtk7Obr6mccG2PDXW6c8Y62bGla9iBxk5cOv5w+xrNwm/8Hj
z1jiyAvPGZ8wuiIp4zk5RHBUoZ8IQ+9Wlm+6KoLgE2Ob+Kml8VcxhP5iVIfK
qou+c4LgdUJqyxlfbrczhDzOKDwdm51RLIHgd8YMlnMoptQFQj4JuJ6Ms+Xf
SiHMQ4KpW4Kd0/6QQcjrglm/d74RYXGDMB8pmG3Lktf2u0PIL8XQRm154iRP
CPOS4cuu4vM75F7kcKXqQx5XmOd/r453l5PHDYf2toVXBPuSxw0HfpkT55Gh
II871HXZmZ/uUpLHA90re5aq+1Xk8YDF8M/mw5lq8ngi6eLxsUlnNeTxRMgt
iXiiREeeUbBsM26d/khHHi/MOqO6UF+hJ48Xju7qPM+kBvJ4I955c4FktOGV
Q6gG6ueDrsKUMeOK9OTzwcDhtfpdN3TU3wdRy9e1TLyrJa8c1SfTTfIDGsoj
B+pc3wqwqMkvh0toodJqVVE+X+TyOblclmMevshTFc/tLZRTXl+wi7JYi92b
5qPAwahl2VzcKMqvQFzWwrhmdw+alwKy5Hvt7pPcyKGEmP6T4FFCu6yic0+E
jDxKzKg6t/TfPx37Q4kzOwvq/rJLyaPC7ORLJeu3O/aLCsb2moi2KlfyqDBK
Jl9+PMKdPH4YG34juJ/3JI8fLkSmnrKZvcjjh2dVlW6r5T7kUeNSwxUXi7ec
PGrcj0/JWOvhSx41Eue6iT+UKsijeeUSPBrc4SPTxtmV5NFAfrZG5HJfRR4N
NgzOcVp1y488Wow7mDZ9a4eaPFoEd+W7snYNebSw7hvy/Oqoljw62IJYCavV
kUcH7tze1h2ljv2kQ+zVI60JeQby6DE+Ia9kwQf+5NHDzj+NvhkfQB49vpht
/qk5KPDVPnsxcgSSx4Cyj09+nrSEI48BlU23pbZLHHkMkO+ZuXBTtJE8/uia
EN6woNJIHn+EbE6/s0ZqIo8/bBsvS1oWmsgTAP/J4/dfOWUiTwCmpc/+qFzP
kycAzc3XJD9YefIEIvmTmkzvMp48gfCobl95tI0nTyD6gmKmNd3lycNRNVM/
DlGRyuximZl8HHafzi1b7WSm/hxCm8YU1fby5OXwtzgqKczmyMOhuXr7xYF9
PPk5/FYTo1HlOPIZIWvZGXssjKd5GPF12O2h7HsmymvEZ1XrF89rMNF8jLgW
smhLxToT5Tei4Mg3qeZEx7yMKHk/1NZjNpHj//ofxaSWrQ==
       "]]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 9.}, {0., 10.01481950518347}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{390, 124},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->234407370]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1484798803],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["MaxPlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxPlotPoints"]], "InlineFormula"],
 " to limit the number of points used:"
}], "ExampleText",
 CellID->694407743],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"5", "x"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"MaxPlotPoints", "\[Rule]", "10"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1253503881],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1., 0.}, {7., 0.14112000805986677`}, {14., 
     0.21511998808781552`}, {21., -0.5440211108893698}, {28., 
     0.803784426551621}, {35., -0.9613974918795568}, {42., 
     0.9968297942787989}, {49., -0.9055783620066223}, {56., 
     0.6992400316550977}, {63., -0.404037645323065}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 63.}, {-0.9613974918795568, 0.9968297942787989}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2009217200]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Sin", "[", 
        RowBox[{"5", "x"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"MaxPlotPoints", "\[Rule]", "10"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1880614972],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{0., 0.}, {1., -0.9589242746631385}, {1.6, 0.9893582466233818}, {
     2.2, -0.9999902065507035}, {2.8000000000000003`, 0.9906073556948706}, {
     3.5, -0.9756260054681576}, {4.1000000000000005`, 0.9968297942787989}, {
     4.7, -0.9980820279793963}, {5.300000000000001, 0.9793576431039178}, {
     6.2, -0.404037645323065}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 6.2}, {-0.9999902065507035, 0.9968297942787989}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->831517858]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->226160967],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " to focus in on areas of interest: "
}], "ExampleText",
 CellID->316263374],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListLinePlot", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "4"}], "-", 
       RowBox[{"x", "^", "2"}], "+", "1"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "2"}], ",", "2", ",", "0.1"}], "}"}]}], "]"}], "]"}], 
   ",", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "4"}], "-", 
        RowBox[{"x", "^", "2"}], "+", "1"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "2", ",", "0.1"}], "}"}]}], "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}]}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41344862],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{1., 13.}, {2., 10.422099999999999`}, {3., 8.2576}, {4., 
       6.462099999999999}, {5., 4.993600000000001}, {6., 3.8125}, {7., 
       2.8815999999999997`}, {8., 2.1661}, {9., 1.6336}, {10., 
       1.2540999999999995`}, {11., 1.}, {12., 0.8461}, {13., 0.7696}, {14., 
       0.7501}, {15., 0.7696000000000001}, {16., 0.8125}, {17., 0.8656}, {18.,
        0.9181}, {19., 0.9616000000000001}, {20., 0.9901}, {21., 1.}, {22., 
       0.9901}, {23., 0.9616}, {24., 0.9180999999999999}, {25., 
       0.8655999999999999}, {26., 0.8125}, {27., 0.7696}, {28., 0.7501}, {29.,
        0.7696000000000001}, {30., 0.8461000000000001}, {31., 
       1.0000000000000004`}, {32., 1.2541000000000002`}, {33., 
       1.6336000000000008`}, {34., 2.166100000000002}, {35., 
       2.881600000000001}, {36., 3.8125000000000018`}, {37., 
       4.993600000000001}, {38., 6.462100000000003}, {39., 
       8.257600000000004}, {40., 10.422100000000004`}, {41., 13.}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 41.}, {0., 13.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{8.311924882629109, 2.}, {9., 1.6336}, {10., 
       1.2540999999999995`}, {11., 1.}, {12., 0.8461}, {13., 0.7696}, {14., 
       0.7501}, {15., 0.7696000000000001}, {16., 0.8125}, {17., 0.8656}, {18.,
        0.9181}, {19., 0.9616000000000001}, {20., 0.9901}, {21., 1.}, {22., 
       0.9901}, {23., 0.9616}, {24., 0.9180999999999999}, {25., 
       0.8655999999999999}, {26., 0.8125}, {27., 0.7696}, {28., 0.7501}, {29.,
        0.7696000000000001}, {30., 0.8461000000000001}, {31., 
       1.0000000000000004`}, {32., 1.2541000000000002`}, {33., 
       1.6336000000000008`}, {33.688075117370886`, 2.}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0, 41.}, {0, 2}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], Automatic}]}], "}"}]], "Output",
 ImageSize->{390, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->453643178]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Presentation",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->5373264],

Cell["Multiple curves are automatically colored to be distinct:", \
"ExampleText",
 CellID->150311282],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Sin", "[", "x", "]"}], ",", 
         RowBox[{"Sin", "[", 
          RowBox[{"2", "x"}], "]"}]}], "}"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->576945024],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->74897845],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxdzn8s1HEYB/BzKD9Ozvlxh2KhVsuPONuJ2edBpFgbCVPWJmVqyrDarFla
tcbSHylHM5dltbawEt2hM2XX4eQYx5DjuNzP7yksY66ue/qn9/bdZ599n+f1
/uzPu55+iU6j0cifz3L+n4Z6S4QkeKh6qLVGSKx3KekZiw00F0lJJNeScRIp
Ej2Racbw/zS5WnBEE62fIlZFSUz2KWUrrd9wXkVy4lrYD90WScFlS9RE6J1U
eK1xCfc1RLYj7q9dUxPZsCV6Evcql2/rpkHPRIwMx0cZBi3Or5KoiyGpA3f1
6P8kA2d9mhPGDbi/RlL8BjZvThixb4PYLhyflz2g0PtFqouCn5XrKPQ2yUC8
UlK5TaG3RTr5YYqubgq9bWLy7K3sP0yht0Oyonz82clG9GiQ1CHXbnD+9dNg
q0RHCpt06NuAg+L1NHdeg/t0CAjLDpHPfsc+W+DLP63nNy6jZwftg19d2g6q
0LOD7nuC7u0KJXr2wHgZFBSeM4PeLuhbzg0sKZ5AbzeMH02e/NA0gp4DnJvo
LIpi9qPnAKFM/h3XUy3oOUJEyMoxnuqN2Oo5QR2ja5Ae/lls9ZyhLNXMlOaM
iq0eA/zzRBUxpZNiq8eAVbkpIS59Vmz1XCDON1R/ZU2J3h4Q9OnNmbUq9Fxh
5J1/SChdjR4TWv1m54S8FZxnQu+XxfIzYVr0mTDFGp3/odKJ/65z3eBAlU10
TJoB+9yAOpQYfr/UiB4LboMk1nCCQo8FIn2ue9owhR4L0vU81wtmCt/jDuZY
RkOtkkLPHV7oAm5AMYWeB3DrleuVbUb0PEAYMLU3SWBAzwMUQaK38Yl69DyB
x+rJoJ5r0fOEYvuIuluiFfS8IKvd6bT0sRo9L+hYf8rO5C6h5wUCSflJXtMC
emwYnK+ROPXMoccG317nfL5BgR4H+prbq1YX5Ohx4PwWV+GdJkGPA/tkH2ey
E9+LfwNStM5i
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJxd0WtIk2EUB/Dlrc1WbtM5MQxCDc3LcKssQZ7jrQ8ZWOItxZJyGpgpaX7I
boqlBCsqqbYuiiSMwK6WOLXJwkRRdJpOU9l0udz11byTuFo7funAy8vLe87v
PPyfvWeLkkVONBqN/H3s7/9LKrFXK2kfiva3FfYQx3cPKcgPMUSZx8gBob2G
SWZMI0/MnsH/46R/U6GsXdITh6IlVibjXorFiP060pXq2xA3bCH5efbSE+fp
eE1/DYXzBtIVq+2u2KBIf5+9zGSe21GhDKbQmydHm1XGFR8L9i8QuvrVuFBj
QH+RPFF9Wc59PovzS6TtVn3bxnUt7lshnbPZ/peKR9BbI1kjnwoPs5TorRNB
2NyRSF2TwuH9JqXHbayezEGFw9sgC6r5uJjkSYXD2yT1nWZbWq1OgbHB6z2T
U62Rc9hPgzHOoOaXzqRw+NuACkqIuF1ixXknkJuzPU/2UbjPGWzRTGmtlkLP
BYQS7XLFGyt6LqAOkL+PTTCj5wrFroLHV+Vz6LlB8/IjXprwB3rboVdzt9u9
fQo9OnQ2vL2zMK1Cjw5+/Z8nMhI+oseA0P0H+SGjHZiXOzxgGPiJ88OY7w5g
sI1ScZ0G82MC3b1QSXfbypsJHj26QLnIgHnuhJVg1/JIpRm9XeCxxmoSrFvR
8wB+y81Q9tLW/bKgfCCofkhGYT8LwoWG1TJfK/oskKyGDWgyTOTfuJANYe+a
08Nv/sR9bJga6o192TKDHgfu85mH9uV8R48DBU9H/GTVfehxYCYmXiY/LcHz
eEJQC5eefuIr5uEJzhc/aHNL1ZifFyQnLS6/OD+NeXtBYt6g5IxIj3l6QZ24
iBJfM2L+XFAHhibnVFvQ44J4d0nOt3Nb9+sNpofhZSYbhZ433Gi8XHMhlULP
G44l0WT+BRb0eDCRKmx4lmJEjwf0U8qqrAg9ej7QKFKvSkO2zucDV5JMlVGW
UfR8IGB0sLJK0KX4A0O90SY=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 6.2}, {-0.9999902065507035, 0.9995736030415051}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->166180578]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->90466730],

Cell["Provide explicit styling to different curves:", "ExampleText",
 CellID->238286887],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Sin", "[", "x", "]"}], ",", 
         RowBox[{"Sin", "[", 
          RowBox[{"2", "x"}], "]"}]}], "}"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->673972360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Dashed", ",", "Red"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1624700242],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxdzn8s1HEYB/BzKD9Ozvlxh2KhVsuPONuJ2edBpFgbCVPWJmVqyrDarFla
tcbSHylHM5dltbawEt2hM2XX4eQYx5DjuNzP7yksY66ue/qn9/bdZ599n+f1
/uzPu55+iU6j0cifz3L+n4Z6S4QkeKh6qLVGSKx3KekZiw00F0lJJNeScRIp
Ej2Racbw/zS5WnBEE62fIlZFSUz2KWUrrd9wXkVy4lrYD90WScFlS9RE6J1U
eK1xCfc1RLYj7q9dUxPZsCV6Evcql2/rpkHPRIwMx0cZBi3Or5KoiyGpA3f1
6P8kA2d9mhPGDbi/RlL8BjZvThixb4PYLhyflz2g0PtFqouCn5XrKPQ2yUC8
UlK5TaG3RTr5YYqubgq9bWLy7K3sP0yht0Oyonz82clG9GiQ1CHXbnD+9dNg
q0RHCpt06NuAg+L1NHdeg/t0CAjLDpHPfsc+W+DLP63nNy6jZwftg19d2g6q
0LOD7nuC7u0KJXr2wHgZFBSeM4PeLuhbzg0sKZ5AbzeMH02e/NA0gp4DnJvo
LIpi9qPnAKFM/h3XUy3oOUJEyMoxnuqN2Oo5QR2ja5Ae/lls9ZyhLNXMlOaM
iq0eA/zzRBUxpZNiq8eAVbkpIS59Vmz1XCDON1R/ZU2J3h4Q9OnNmbUq9Fxh
5J1/SChdjR4TWv1m54S8FZxnQu+XxfIzYVr0mTDFGp3/odKJ/65z3eBAlU10
TJoB+9yAOpQYfr/UiB4LboMk1nCCQo8FIn2ue9owhR4L0vU81wtmCt/jDuZY
RkOtkkLPHV7oAm5AMYWeB3DrleuVbUb0PEAYMLU3SWBAzwMUQaK38Yl69DyB
x+rJoJ5r0fOEYvuIuluiFfS8IKvd6bT0sRo9L+hYf8rO5C6h5wUCSflJXtMC
emwYnK+ROPXMoccG317nfL5BgR4H+prbq1YX5Ohx4PwWV+GdJkGPA/tkH2ey
E9+LfwNStM5i
     "]]}, 
   {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJxd0WtIk2EUB/Dlrc1WbtM5MQxCDc3LcKssQZ7jrQ8ZWOItxZJyGpgpaX7I
boqlBCsqqbYuiiSMwK6WOLXJwkRRdJpOU9l0udz11byTuFo7funAy8vLe87v
PPyfvWeLkkVONBqN/H3s7/9LKrFXK2kfiva3FfYQx3cPKcgPMUSZx8gBob2G
SWZMI0/MnsH/46R/U6GsXdITh6IlVibjXorFiP060pXq2xA3bCH5efbSE+fp
eE1/DYXzBtIVq+2u2KBIf5+9zGSe21GhDKbQmydHm1XGFR8L9i8QuvrVuFBj
QH+RPFF9Wc59PovzS6TtVn3bxnUt7lshnbPZ/peKR9BbI1kjnwoPs5TorRNB
2NyRSF2TwuH9JqXHbayezEGFw9sgC6r5uJjkSYXD2yT1nWZbWq1OgbHB6z2T
U62Rc9hPgzHOoOaXzqRw+NuACkqIuF1ixXknkJuzPU/2UbjPGWzRTGmtlkLP
BYQS7XLFGyt6LqAOkL+PTTCj5wrFroLHV+Vz6LlB8/IjXprwB3rboVdzt9u9
fQo9OnQ2vL2zMK1Cjw5+/Z8nMhI+oseA0P0H+SGjHZiXOzxgGPiJ88OY7w5g
sI1ScZ0G82MC3b1QSXfbypsJHj26QLnIgHnuhJVg1/JIpRm9XeCxxmoSrFvR
8wB+y81Q9tLW/bKgfCCofkhGYT8LwoWG1TJfK/oskKyGDWgyTOTfuJANYe+a
08Nv/sR9bJga6o192TKDHgfu85mH9uV8R48DBU9H/GTVfehxYCYmXiY/LcHz
eEJQC5eefuIr5uEJzhc/aHNL1ZifFyQnLS6/OD+NeXtBYt6g5IxIj3l6QZ24
iBJfM2L+XFAHhibnVFvQ44J4d0nOt3Nb9+sNpofhZSYbhZ433Gi8XHMhlULP
G44l0WT+BRb0eDCRKmx4lmJEjwf0U8qqrAg9ej7QKFKvSkO2zucDV5JMlVGW
UfR8IGB0sLJK0KX4A0O90SY=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 6.2}, {-0.9999902065507035, 0.9995736030415051}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->50307452]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->103486521],

Cell["Add labels:", "ExampleText",
 CellID->797294755],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"k", ",", 
       RowBox[{"Binomial", "[", 
        RowBox[{"15", ",", "k"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"k", ",", "None"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"Binomial", "[", 
     RowBox[{"15", ",", "k"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->575371355],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{0., 1.}, {1., 15.}, {2., 105.}, {3., 455.}, {4., 1365.}, {5., 
     3003.}, {6., 5005.}, {7., 6435.}, {8., 6435.}, {9., 5005.}, {10., 
     3003.}, {11., 1365.}, {12., 455.}, {13., 105.}, {14., 15.}, {15., 
     1.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["k", TraditionalForm], None},
  AxesOrigin->{0, 0},
  PlotLabel->FormBox[
    TagBox[
     RowBox[{"(", 
       GridBox[{{
          TagBox["15", Identity, Editable -> True, Selectable -> True]}, {
          TagBox["k", Identity, Editable -> True, Selectable -> True]}}], 
       ")"}], 
     InterpretTemplate[Binomial[#, #2]& ], Editable -> False, Selectable -> 
     False], TraditionalForm],
  PlotRange->{{0., 15.}, {0., 6435.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->572626768]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->64589049],

Cell[TextData[{
 "Provide an interactive ",
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 " for the data: "
}], "ExampleText",
 CellID->213196035],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Tooltip", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"PrimeQ", "[", "x", "]"}], ",", 
        RowBox[{"Tooltip", "[", 
         RowBox[{"x", ",", 
          RowBox[{"Row", "[", 
           RowBox[{"{", 
            RowBox[{"\"\<prime: \>\"", ",", "x"}], "}"}], "]"}]}], "]"}], ",",
         "x"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "1", ",", "25"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1129040372],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{{1., 1.}, {2., 2.}, {3., 3.}, {4., 4.}, {5., 5.}, {6., 6.}, {7.,
       7.}, {8., 8.}, {9., 9.}, {10., 10.}, {11., 11.}, {12., 12.}, {13., 
      13.}, {14., 14.}, {15., 15.}, {16., 16.}, {17., 17.}, {18., 18.}, {19., 
      19.}, {20., 20.}, {21., 21.}, {22., 22.}, {23., 23.}, {24., 24.}, {25., 
      25.}}]}}, {
    {Hue[0.67, 0.6, 0.6], 
     PointBox[{{1., 1.}, {2., 2.}, {3., 3.}, {4., 4.}, {5., 5.}, {6., 6.}, {
      7., 7.}, {8., 8.}, {9., 9.}, {10., 10.}, {11., 11.}, {12., 12.}, {13., 
      13.}, {14., 14.}, {15., 15.}, {16., 16.}, {17., 17.}, {18., 18.}, {19., 
      19.}, {20., 20.}, {21., 21.}, {22., 22.}, {23., 23.}, {24., 24.}, {25., 
      25.}}]}, {}, {}}, {
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1.}}]},
      "1"],
     Annotation[#, 1, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       TooltipBox[
        {Opacity[0.], PointBox[{{2., 2.}}]},
        InterpretationBox[
         RowBox[{"\"prime: \"", "\[InvisibleSpace]", "2"}], 
         Row[{"prime: ", 2}]]],
       Annotation[#, 
        Row[{"prime: ", 2}], "Tooltip"]& ],
      "2"],
     Annotation[#, 2, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       TooltipBox[
        {Opacity[0.], PointBox[{{3., 3.}}]},
        InterpretationBox[
         RowBox[{"\"prime: \"", "\[InvisibleSpace]", "3"}], 
         Row[{"prime: ", 3}]]],
       Annotation[#, 
        Row[{"prime: ", 3}], "Tooltip"]& ],
      "3"],
     Annotation[#, 3, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{4., 4.}}]},
      "4"],
     Annotation[#, 4, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       TooltipBox[
        {Opacity[0.], PointBox[{{5., 5.}}]},
        InterpretationBox[
         RowBox[{"\"prime: \"", "\[InvisibleSpace]", "5"}], 
         Row[{"prime: ", 5}]]],
       Annotation[#, 
        Row[{"prime: ", 5}], "Tooltip"]& ],
      "5"],
     Annotation[#, 5, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{6., 6.}}]},
      "6"],
     Annotation[#, 6, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       TooltipBox[
        {Opacity[0.], PointBox[{{7., 7.}}]},
        InterpretationBox[
         RowBox[{"\"prime: \"", "\[InvisibleSpace]", "7"}], 
         Row[{"prime: ", 7}]]],
       Annotation[#, 
        Row[{"prime: ", 7}], "Tooltip"]& ],
      "7"],
     Annotation[#, 7, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{8., 8.}}]},
      "8"],
     Annotation[#, 8, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{9., 9.}}]},
      "9"],
     Annotation[#, 9, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10., 10.}}]},
      "10"],
     Annotation[#, 10, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       TooltipBox[
        {Opacity[0.], PointBox[{{11., 11.}}]},
        InterpretationBox[
         RowBox[{"\"prime: \"", "\[InvisibleSpace]", "11"}], 
         Row[{"prime: ", 11}]]],
       Annotation[#, 
        Row[{"prime: ", 11}], "Tooltip"]& ],
      "11"],
     Annotation[#, 11, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12., 12.}}]},
      "12"],
     Annotation[#, 12, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       TooltipBox[
        {Opacity[0.], PointBox[{{13., 13.}}]},
        InterpretationBox[
         RowBox[{"\"prime: \"", "\[InvisibleSpace]", "13"}], 
         Row[{"prime: ", 13}]]],
       Annotation[#, 
        Row[{"prime: ", 13}], "Tooltip"]& ],
      "13"],
     Annotation[#, 13, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14., 14.}}]},
      "14"],
     Annotation[#, 14, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15., 15.}}]},
      "15"],
     Annotation[#, 15, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16., 16.}}]},
      "16"],
     Annotation[#, 16, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       TooltipBox[
        {Opacity[0.], PointBox[{{17., 17.}}]},
        InterpretationBox[
         RowBox[{"\"prime: \"", "\[InvisibleSpace]", "17"}], 
         Row[{"prime: ", 17}]]],
       Annotation[#, 
        Row[{"prime: ", 17}], "Tooltip"]& ],
      "17"],
     Annotation[#, 17, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{18., 18.}}]},
      "18"],
     Annotation[#, 18, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       TooltipBox[
        {Opacity[0.], PointBox[{{19., 19.}}]},
        InterpretationBox[
         RowBox[{"\"prime: \"", "\[InvisibleSpace]", "19"}], 
         Row[{"prime: ", 19}]]],
       Annotation[#, 
        Row[{"prime: ", 19}], "Tooltip"]& ],
      "19"],
     Annotation[#, 19, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{20., 20.}}]},
      "20"],
     Annotation[#, 20, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{21., 21.}}]},
      "21"],
     Annotation[#, 21, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{22., 22.}}]},
      "22"],
     Annotation[#, 22, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       TooltipBox[
        {Opacity[0.], PointBox[{{23., 23.}}]},
        InterpretationBox[
         RowBox[{"\"prime: \"", "\[InvisibleSpace]", "23"}], 
         Row[{"prime: ", 23}]]],
       Annotation[#, 
        Row[{"prime: ", 23}], "Tooltip"]& ],
      "23"],
     Annotation[#, 23, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{24., 24.}}]},
      "24"],
     Annotation[#, 24, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{25., 25.}}]},
      "25"],
     Annotation[#, 25, "Tooltip"]& ]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 25.}, {0., 25.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->735804]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Tooltip", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "1", ",", "2", ",", "4", ",", "8", ",", "16", ",", "32", ",", "64"}], 
        "}"}], ",", 
       RowBox[{"TraditionalForm", "[", 
        RowBox[{"2", "^", "k"}], "]"}]}], "]"}], ",", 
     RowBox[{"Tooltip", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13", ",", "21"}], 
        "}"}], ",", 
       RowBox[{"TraditionalForm", "[", 
        RowBox[{"Fibonacci", "[", "k", "]"}], "]"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "Full"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->162853632],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 1.}, {2., 2.}, {3., 4.}, {4., 8.}, {5., 16.}, {6., 
   32.}, {7., 64.}, {1., 1.}, {2., 2.}, {3., 3.}, {4., 5.}, {5., 8.}, {6., 
   13.}, {7., 21.}, {1., 1.}, {2., 2.}, {3., 4.}, {4., 8.}, {5., 16.}, {6., 
   32.}, {7., 64.}, {1., 1.}, {2., 2.}, {3., 3.}, {4., 5.}, {5., 8.}, {6., 
   13.}, {7., 21.}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[{15, 16, 17, 18, 19, 20, 21}]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], 
      LineBox[{22, 23, 24, 25, 26, 27, 28}]}}, {
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 
       14}]}, {}, {}, {}}, {
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[1]},
       TagBox[
        FormBox[
         SuperscriptBox["2", "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[2^$CellContext`k], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[2]},
       TagBox[
        FormBox[
         SuperscriptBox["2", "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[2^$CellContext`k], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[3]},
       TagBox[
        FormBox[
         SuperscriptBox["2", "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[2^$CellContext`k], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[4]},
       TagBox[
        FormBox[
         SuperscriptBox["2", "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[2^$CellContext`k], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[5]},
       TagBox[
        FormBox[
         SuperscriptBox["2", "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[2^$CellContext`k], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[6]},
       TagBox[
        FormBox[
         SuperscriptBox["2", "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[2^$CellContext`k], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[7]},
       TagBox[
        FormBox[
         SuperscriptBox["2", "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[2^$CellContext`k], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[8]},
       TagBox[
        FormBox[
         SubscriptBox[
          TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[
        Fibonacci[$CellContext`k]], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[9]},
       TagBox[
        FormBox[
         SubscriptBox[
          TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[
        Fibonacci[$CellContext`k]], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[10]},
       TagBox[
        FormBox[
         SubscriptBox[
          TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[
        Fibonacci[$CellContext`k]], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[11]},
       TagBox[
        FormBox[
         SubscriptBox[
          TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[
        Fibonacci[$CellContext`k]], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[12]},
       TagBox[
        FormBox[
         SubscriptBox[
          TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[
        Fibonacci[$CellContext`k]], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[13]},
       TagBox[
        FormBox[
         SubscriptBox[
          TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[
        Fibonacci[$CellContext`k]], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[14]},
       TagBox[
        FormBox[
         SubscriptBox[
          TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[
        Fibonacci[$CellContext`k]], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[15]},
       TagBox[
        FormBox[
         SuperscriptBox["2", "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[2^$CellContext`k], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[16]},
       TagBox[
        FormBox[
         SuperscriptBox["2", "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[2^$CellContext`k], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[17]},
       TagBox[
        FormBox[
         SuperscriptBox["2", "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[2^$CellContext`k], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[18]},
       TagBox[
        FormBox[
         SuperscriptBox["2", "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[2^$CellContext`k], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[19]},
       TagBox[
        FormBox[
         SuperscriptBox["2", "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[2^$CellContext`k], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[20]},
       TagBox[
        FormBox[
         SuperscriptBox["2", "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[2^$CellContext`k], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[21]},
       TagBox[
        FormBox[
         SuperscriptBox["2", "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[2^$CellContext`k], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[22]},
       TagBox[
        FormBox[
         SubscriptBox[
          TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[
        Fibonacci[$CellContext`k]], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[23]},
       TagBox[
        FormBox[
         SubscriptBox[
          TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[
        Fibonacci[$CellContext`k]], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[24]},
       TagBox[
        FormBox[
         SubscriptBox[
          TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[
        Fibonacci[$CellContext`k]], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[25]},
       TagBox[
        FormBox[
         SubscriptBox[
          TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[
        Fibonacci[$CellContext`k]], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[26]},
       TagBox[
        FormBox[
         SubscriptBox[
          TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[
        Fibonacci[$CellContext`k]], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[27]},
       TagBox[
        FormBox[
         SubscriptBox[
          TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[
        Fibonacci[$CellContext`k]], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[28]},
       TagBox[
        FormBox[
         SubscriptBox[
          TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[
        Fibonacci[$CellContext`k]], "Tooltip"]& ]}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 7.}, {0., 64.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->53993349]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->71232987],

Cell["Create filled plots: ", "ExampleText",
 CellID->594811598],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "4", ",", "8", ",", "16", ",", "32", ",", "64"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13", ",", "21"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", "2", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->388733632],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 1.}, {2., 2.}, {3., 4.}, {4., 8.}, {5., 16.}, {6., 
   32.}, {7., 43.29999999999998}, {1., 1.}, {2., 2.}, {3., 3.}, {4., 5.}, {5.,
    8.}, {6., 13.}, {7., 21.}, {6.3531249999999995`, 
   43.29999999999998}}, {{{}, {}, {}, {}, {}, {}, {}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{8, 9, 10, 11, 12, 13, 14, 7, 15, 6, 5, 4, 3, 2, 1}},
        VertexColors->None]]}, {}, {}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[{1, 2, 3, 4, 5, 6, 15}]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], 
      LineBox[{8, 9, 10, 11, 12, 13, 14}]}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 7.}, {0., 43.29999999999998}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->207164869]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->122198397],

Cell["Create an overlay mesh:", "ExampleText",
 CellID->130631304],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13", ",", "21"}], 
    "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->766762485],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 1.}, {2., 2.}, {3., 3.}, {4., 5.}, {5., 8.}, {6., 
   13.}, {7., 21.}, {1.5454545454545454`, 1.5454545454545454`}, {
   2.090909090909091, 2.090909090909091}, {2.6363636363636362`, 
   2.6363636363636362`}, {3.1818181818181817`, 3.3636363636363633`}, {
   3.727272727272727, 4.454545454545454}, {4.2727272727272725`, 
   5.8181818181818175`}, {4.818181818181818, 7.454545454545455}, {
   5.363636363636363, 9.818181818181817}, {5.909090909090908, 
   12.545454545454541`}, {6.454545454545454, 
   16.636363636363633`}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 8, 2, 9, 10, 3, 11, 12, 4, 13, 14, 5, 15, 16, 6, 17, 
       7}]}}, {
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{8, 9, 10, 11, 12, 13, 14, 15, 16, 17}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 7.}, {0., 21.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->431266465]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1146303558],

Cell["Use shapes to distinguish different datasets:", "ExampleText",
 CellID->848102069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Tooltip", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "1", ",", "2", ",", "4", ",", "8", ",", "16", ",", "32", ",", "64"}], 
        "}"}], ",", 
       RowBox[{"TraditionalForm", "[", 
        RowBox[{"2", "^", "k"}], "]"}]}], "]"}], ",", 
     RowBox[{"Tooltip", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13", ",", "21"}], 
        "}"}], ",", 
       RowBox[{"TraditionalForm", "[", 
        RowBox[{"Fibonacci", "[", "k", "]"}], "]"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "Full"}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1202508544],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 1.}, {2., 2.}, {3., 4.}, {4., 8.}, {5., 16.}, {6., 
   32.}, {7., 64.}, {1., 1.}, {2., 2.}, {3., 3.}, {4., 5.}, {5., 8.}, {6., 
   13.}, {7., 21.}, {1., 1.}, {2., 2.}, {3., 4.}, {4., 8.}, {5., 16.}, {6., 
   32.}, {7., 64.}, {1., 1.}, {2., 2.}, {3., 3.}, {4., 5.}, {5., 8.}, {6., 
   13.}, {7., 21.}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[{15, 16, 17, 18, 19, 20, 21}]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], 
      LineBox[{22, 23, 24, 25, 26, 27, 28}]}}, {
     {Hue[0.67, 0.6, 0.6], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 1], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 2], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 3], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 4], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 5], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 6], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 7]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 8], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 9], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 10], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 11], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 12], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 13], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 14]}, {}}, {
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[1]},
       TagBox[
        FormBox[
         SuperscriptBox["2", "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[2^$CellContext`k], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[2]},
       TagBox[
        FormBox[
         SuperscriptBox["2", "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[2^$CellContext`k], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[3]},
       TagBox[
        FormBox[
         SuperscriptBox["2", "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[2^$CellContext`k], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[4]},
       TagBox[
        FormBox[
         SuperscriptBox["2", "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[2^$CellContext`k], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[5]},
       TagBox[
        FormBox[
         SuperscriptBox["2", "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[2^$CellContext`k], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[6]},
       TagBox[
        FormBox[
         SuperscriptBox["2", "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[2^$CellContext`k], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[7]},
       TagBox[
        FormBox[
         SuperscriptBox["2", "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[2^$CellContext`k], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[8]},
       TagBox[
        FormBox[
         SubscriptBox[
          TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[
        Fibonacci[$CellContext`k]], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[9]},
       TagBox[
        FormBox[
         SubscriptBox[
          TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[
        Fibonacci[$CellContext`k]], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[10]},
       TagBox[
        FormBox[
         SubscriptBox[
          TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[
        Fibonacci[$CellContext`k]], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[11]},
       TagBox[
        FormBox[
         SubscriptBox[
          TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[
        Fibonacci[$CellContext`k]], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[12]},
       TagBox[
        FormBox[
         SubscriptBox[
          TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[
        Fibonacci[$CellContext`k]], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[13]},
       TagBox[
        FormBox[
         SubscriptBox[
          TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[
        Fibonacci[$CellContext`k]], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[14]},
       TagBox[
        FormBox[
         SubscriptBox[
          TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[
        Fibonacci[$CellContext`k]], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[15]},
       TagBox[
        FormBox[
         SuperscriptBox["2", "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[2^$CellContext`k], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[16]},
       TagBox[
        FormBox[
         SuperscriptBox["2", "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[2^$CellContext`k], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[17]},
       TagBox[
        FormBox[
         SuperscriptBox["2", "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[2^$CellContext`k], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[18]},
       TagBox[
        FormBox[
         SuperscriptBox["2", "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[2^$CellContext`k], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[19]},
       TagBox[
        FormBox[
         SuperscriptBox["2", "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[2^$CellContext`k], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[20]},
       TagBox[
        FormBox[
         SuperscriptBox["2", "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[2^$CellContext`k], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[21]},
       TagBox[
        FormBox[
         SuperscriptBox["2", "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[2^$CellContext`k], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[22]},
       TagBox[
        FormBox[
         SubscriptBox[
          TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[
        Fibonacci[$CellContext`k]], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[23]},
       TagBox[
        FormBox[
         SubscriptBox[
          TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[
        Fibonacci[$CellContext`k]], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[24]},
       TagBox[
        FormBox[
         SubscriptBox[
          TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[
        Fibonacci[$CellContext`k]], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[25]},
       TagBox[
        FormBox[
         SubscriptBox[
          TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[
        Fibonacci[$CellContext`k]], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[26]},
       TagBox[
        FormBox[
         SubscriptBox[
          TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[
        Fibonacci[$CellContext`k]], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[27]},
       TagBox[
        FormBox[
         SubscriptBox[
          TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[
        Fibonacci[$CellContext`k]], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[28]},
       TagBox[
        FormBox[
         SubscriptBox[
          TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
        Editable -> True]],
      Annotation[#, 
       TraditionalForm[
        Fibonacci[$CellContext`k]], "Tooltip"]& ]}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 7.}, {0., 64.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7305623]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->266062213],

Cell["Style the curve segments between mesh points:", "ExampleText",
 CellID->207010765],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13", ",", "21"}], 
    "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "None", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->643226829],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 1.}, {2., 2.}, {3., 3.}, {4., 5.}, {5., 8.}, {6., 
   13.}, {7., 21.}, {1.5454545454545454`, 1.5454545454545454`}, {
   2.090909090909091, 2.090909090909091}, {2.6363636363636362`, 
   2.6363636363636362`}, {3.1818181818181817`, 3.3636363636363633`}, {
   3.727272727272727, 4.454545454545454}, {4.2727272727272725`, 
   5.8181818181818175`}, {4.818181818181818, 7.454545454545455}, {
   5.363636363636363, 9.818181818181817}, {5.909090909090908, 
   12.545454545454541`}, {6.454545454545454, 
   16.636363636363633`}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      {RGBColor[1, 0, 0], LineBox[{1, 8}]}, {}, 
      {RGBColor[0, 0, 1], LineBox[{9, 10}]}, 
      {RGBColor[1, 0, 0], LineBox[{10, 3, 11}]}, {}, 
      {RGBColor[0, 0, 1], LineBox[{12, 4, 13}]}, 
      {RGBColor[1, 0, 0], LineBox[{13, 14}]}, {}, 
      {RGBColor[0, 0, 1], LineBox[{15, 16}]}, 
      {RGBColor[1, 0, 0], LineBox[{16, 6, 17}]}, {}}}, {
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{8, 9, 10, 11, 12, 13, 14, 15, 16, 17}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 7.}, {0., 21.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->233201668]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23911],

Cell["The data can be self-intersecting:", "ExampleText",
 CellID->1013298950],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"3", "t"}], "]"}], ",", 
      RowBox[{"Cos", "[", 
       RowBox[{"5", "t"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", 
      RowBox[{"2", "Pi"}], ",", 
      RowBox[{"2", 
       RowBox[{"Pi", "/", "50"}]}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->970131940],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{0., 1.}, {0.3681245526846779, 0.8090169943749475}, {
     0.6845471059286886, 0.30901699437494745`}, {
     0.9048270524660195, -0.30901699437494745`}, {
     0.9980267284282716, -0.8090169943749475}, {0.9510565162951535, -1.}, {
     0.7705132427757893, -0.8090169943749475}, {
     0.4817536741017153, -0.30901699437494745`}, {0.12533323356430426`, 
     0.30901699437494745`}, {-0.2486898871648548, 
     0.8090169943749475}, {-0.5877852522924731, 1.}, {-0.8443279255020151, 
     0.8090169943749475}, {-0.9822872507286887, 
     0.30901699437494745`}, {-0.9822872507286887, -0.30901699437494745`}, \
{-0.8443279255020151, -0.8090169943749475}, {-0.5877852522924731, -1.}, \
{-0.2486898871648548, -0.8090169943749475}, {
     0.12533323356430426`, -0.30901699437494745`}, {0.4817536741017153, 
     0.30901699437494745`}, {0.7705132427757893, 0.8090169943749475}, {
     0.9510565162951535, 1.}, {0.9980267284282716, 0.8090169943749475}, {
     0.9048270524660195, 0.30901699437494745`}, {
     0.6845471059286886, -0.30901699437494745`}, {
     0.3681245526846779, -0.8090169943749475}, {
     0., -1.}, {-0.3681245526846779, -0.8090169943749475}, \
{-0.6845471059286886, -0.30901699437494745`}, {-0.9048270524660195, 
     0.30901699437494745`}, {-0.9980267284282716, 
     0.8090169943749475}, {-0.9510565162951535, 1.}, {-0.7705132427757893, 
     0.8090169943749475}, {-0.4817536741017153, 
     0.30901699437494745`}, {-0.12533323356430426`, -0.30901699437494745`}, {
     0.2486898871648548, -0.8090169943749475}, {0.5877852522924731, -1.}, {
     0.8443279255020151, -0.8090169943749475}, {
     0.9822872507286887, -0.30901699437494745`}, {0.9822872507286887, 
     0.30901699437494745`}, {0.8443279255020151, 0.8090169943749475}, {
     0.5877852522924731, 1.}, {0.2486898871648548, 
     0.8090169943749475}, {-0.12533323356430426`, 
     0.30901699437494745`}, {-0.4817536741017153, -0.30901699437494745`}, \
{-0.7705132427757893, -0.8090169943749475}, {-0.9510565162951535, -1.}, \
{-0.9980267284282716, -0.8090169943749475}, {-0.9048270524660195, \
-0.30901699437494745`}, {-0.6845471059286886, 
     0.30901699437494745`}, {-0.3681245526846779, 0.8090169943749475}, {0., 
     1.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-0.9980267284282716, 0.9980267284282716}, {-1., 1.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->204854141]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(56)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13645187],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AspectRatio",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->342690970],

Cell["Use the default aspect ratio: ", "ExampleText",
 CellID->2129016678],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"2", 
       RowBox[{"Cos", "[", "t", "]"}]}], ",", 
      RowBox[{"Sin", "[", "t", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "Pi", ",", "0.1"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1010780832],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{2., 0.}, {1.9900083305560516`, 0.09983341664682815}, {
     1.9601331556824833`, 0.19866933079506122`}, {1.910672978251212, 
     0.2955202066613396}, {1.8421219880057702`, 0.3894183423086505}, {
     1.7551651237807455`, 0.479425538604203}, {1.6506712298193564`, 
     0.5646424733950355}, {1.5296843745689768`, 0.6442176872376911}, {
     1.3934134186943308`, 0.7173560908995228}, {1.2432199365413288`, 
     0.7833269096274834}, {1.0806046117362795`, 0.8414709848078965}, {
     0.9071922428511546, 0.8912073600614354}, {0.7247155089533468, 
     0.9320390859672264}, {0.5349976572491747, 0.963558185417193}, {
     0.33993428580048163`, 0.9854497299884603}, {0.1414744033354058, 
     0.9974949866040544}, {-0.05839904460257763, 
     0.9995736030415051}, {-0.2576889885910497, 
     0.9916648104524686}, {-0.4544041893861742, 
     0.9738476308781951}, {-0.6465791337270071, 
     0.9463000876874145}, {-0.8322936730942848, 
     0.9092974268256817}, {-1.0096922091997151`, 
     0.8632093666488737}, {-1.1770022345106916`, 
     0.8084964038195901}, {-1.3325520425596489`, 
     0.74570521217672}, {-1.4747874310824916`, 
     0.6754631805511506}, {-1.6022872310938674`, 
     0.5984721441039565}, {-1.7137775067378946`, 
     0.5155013718214642}, {-1.8081442840341224`, 
     0.4273798802338298}, {-1.8844446813373166`, 
     0.33498815015590466`}, {-1.9419163302991813`, 
     0.23924932921398198`}, {-1.9799849932008908`, 
     0.1411200080598672}, {-1.998270300546559, 0.04158066243329049}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-1.998270300546559, 2.}, {0., 0.9995736030415051}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1060457343]
}, Open  ]],

Cell["Use the aspect ratio as derived from data: ", "ExampleText",
 CellID->683756596],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", 
        RowBox[{"Cos", "[", "t", "]"}]}], ",", 
       RowBox[{"Sin", "[", "t", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "Pi", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->498052464],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{2., 0.}, {1.9900083305560516`, 0.09983341664682815}, {
     1.9601331556824833`, 0.19866933079506122`}, {1.910672978251212, 
     0.2955202066613396}, {1.8421219880057702`, 0.3894183423086505}, {
     1.7551651237807455`, 0.479425538604203}, {1.6506712298193564`, 
     0.5646424733950355}, {1.5296843745689768`, 0.6442176872376911}, {
     1.3934134186943308`, 0.7173560908995228}, {1.2432199365413288`, 
     0.7833269096274834}, {1.0806046117362795`, 0.8414709848078965}, {
     0.9071922428511546, 0.8912073600614354}, {0.7247155089533468, 
     0.9320390859672264}, {0.5349976572491747, 0.963558185417193}, {
     0.33993428580048163`, 0.9854497299884603}, {0.1414744033354058, 
     0.9974949866040544}, {-0.05839904460257763, 
     0.9995736030415051}, {-0.2576889885910497, 
     0.9916648104524686}, {-0.4544041893861742, 
     0.9738476308781951}, {-0.6465791337270071, 
     0.9463000876874145}, {-0.8322936730942848, 
     0.9092974268256817}, {-1.0096922091997151`, 
     0.8632093666488737}, {-1.1770022345106916`, 
     0.8084964038195901}, {-1.3325520425596489`, 
     0.74570521217672}, {-1.4747874310824916`, 
     0.6754631805511506}, {-1.6022872310938674`, 
     0.5984721441039565}, {-1.7137775067378946`, 
     0.5155013718214642}, {-1.8081442840341224`, 
     0.4273798802338298}, {-1.8844446813373166`, 
     0.33498815015590466`}, {-1.9419163302991813`, 
     0.23924932921398198`}, {-1.9799849932008908`, 
     0.1411200080598672}, {-1.998270300546559, 0.04158066243329049}}]}},
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-1.998270300546559, 2.}, {0., 0.9995736030415051}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 64},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1139777348]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AxesOrigin",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1421393691],

Cell["The position of the axes is determined automatically:", "ExampleText",
 CellID->712113875],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"x", "!"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->571532394],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1., 1.}, {2., 2.}, {3., 6.}, {4., 24.}, {5., 120.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 5.}, {0., 120.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1946961923]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1790749060],

Cell["Specify an explicit origin for the axes:", "ExampleText",
 CellID->278907602],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"x", "!"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1", ",", "5"}], "}"}]}], "]"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "20"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1380710522],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1., 1.}, {2., 2.}, {3., 6.}, {4., 24.}, {5., 120.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{1, -20},
  PlotRange->{{1., 5.}, {-20, 120.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2040937419]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ClippingStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->552467490],

Cell["Omit clipped regions of the plot:", "ExampleText",
 CellID->619238589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ListLinePlot", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{
         RowBox[{"Sin", "[", "x", "]"}], "/", 
         RowBox[{"x", "^", "2"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "10"}], ",", "10", ",", "0.2"}], "}"}]}], "]"}], ",", 
    RowBox[{"ClippingStyle", "\[Rule]", "None"}]}], "]"}], "//", 
  "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1239030680],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->455639442]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->703669682],

Cell["Show the clipped regions like the rest of the curve:  ", "ExampleText",
 CellID->47276655],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ListLinePlot", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{
         RowBox[{"Sin", "[", "x", "]"}], "/", 
         RowBox[{"x", "^", "2"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "10"}], ",", "10", ",", "0.2"}], "}"}]}], "]"}], ",", 
    RowBox[{"ClippingStyle", "\[Rule]", "Automatic"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}], "//", 
  "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->761757896],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytWV2IFlUYPn4z8+3qqrnmz/pXm0nRr1l0Wf7sXxIRXaiFdLEtgUJlmN3U
Td3UTd3UTVLoRSWYBVZiBAaRIAmRIBlRQRiEXSRB0oUQTM/7PmfmnDkzc/bb
dZfdb79z5p3nPOf9PzOPTB7Y8/Szkwf2Tk0OT+yffH7P3qkXhsf37cdUMs8Y
cwJ/zwwZfM/xTf9O5Dn+b5fP5MIPf1669I98vQ4fHVzeVV5NNj9w0CSHD32X
64/piETDHOUEmXM7Z4Xg1n5ImV25chWzjz36vlms4107jsid+Hnck7p48W/M
Tj31cVTq3Pd/YPbFAycplTqp6ppfnfoV86+/9nUU7cMPzmEWO2iRGreaNOmb
b5zGlS9O/oSB7lNnVcj+pC18xuSz63RqDASwDZX3dJ3IR185xk/IZgs+Uxn2
EccHhOnNzBGVWxZAmawJp1vHEZGdNRxYW/a+4whxUv++TqGnmqZ9hF9+/gtf
9j33OREyH0HuyOK2Ehd89ZVTBfNiTfmftNhoQoWPfXQe8wffOasRVF+BUm+/
dQaznx6/QKlWtJdf+hLzZ7/9PYoGf8csfD8q9fD2w5i9evW/1jXHg0hb0qoj
k0C/mN2753hEil5PNVLthdd3fDu2+btYncGFL92qH1iMHn094x2IZHt9Nmgl
J2w6yml6L5d7oODZ76xEwSzsei0oCSOl0Erh4dNax2ZHWNcMNnoApVx2HIyi
AQfzwIyi0dOFcUxqbOQ96+lta456PizVYmkj2miwz4hUiogv19AM4eW+juf5
bTpVlAzxjpnT3/xGE1pp36rpDLxeYtiYy5f/nRXasF7D3TAh8ih+UTFRvCQ3
b9LbR3KXL0zhcf6+m9driY91ejf2zkRlUu0MsAekP7m00VuTFby3NSu5xrPe
DTLuZ77GL1SPhQAMeyPC2ZegYsONRPAuBevLq/lrgx2z8hOrd1a1+ljxi7U6
g46M7gwrZHY1k8AYULsIrA8YKY7pn3a9DcF4IHf1RqKw4+WDSuXzNEiGIMIp
BLk2FRniiq6H0BJvubmRjbSj8+Q/pxLrpHK1GEZ3sMb6edhpDHgspaO5vpE1
KzAMDfuqtjKR1YRqWa/vgfXM9bxAx4gqm7mX1ey+WmcgQbtDmXqPdDAUs/xu
mhN+661tF+U2+hgK5OVpbY2OqTW5Pt/ep04C1VESGQL6HJ4zZv54oY6ZZ6We
hAypNyxf6k04mvl+tgmImht7YNqXV6vigsI+SBfgAZV0pM0UZkgAiFf1OJEk
Y1y0PVzd1qtyV2Gklxqwd3YKj2QutGzXBUwYMssVA90fmEjHPL/Im0he0hOu
q+oFrtOoORv7SDPs6FIokKuj9N2qK7H+AQlVQNjqeS6FEG6FJrCNDvKnSXAZ
XJ7cfZQSUtttEeJKzN5Sd5cHTFQfklHIFXcNFlw4gxbuFuXCrhPz2KXEEfM1
hCABL1b/NF3sH9d5K6TAcLXnx9KlL6/ZZEgl0JtjRgyr+SOF/UoGpUYxCQws
x0Pcoib9JDAe1hX76fUMm8IUiw7IWR+Atnika9aJ9SI5Maj1Mp+PYJeeBGXj
gtUHLlrPVo+yvgv5UpBy0A02IhlQbZzBkYluPW+F3ofrmMIFTIUsh6pehk2q
RFZ6EUuW81ZrN+oIvoD1JXaoScnpnxRxwFzRZXLGL1QFbwNE2GeFlaDxDCr6
ZxsJ8rLjbi93JTSZ6L+/J3mnmSVt8pv9pwbBdZuToLGyF4GCeCxmXukHd9xe
HiOgTAZ84wnesoZdsQXZtfpwBsCKLsK9lLmutOqKWrys9PYr/qsR1gU1WgsE
8R3gZIAvIKEJU3cFY4KRbCy0A3nfVuVpa9+gF6PyHMfn4DjRX8XL1hbZwp7d
VKP9AEMiADvQRsjiC+IFhBIvl4hP6nnZ3F4wqVRhWpew8mSnmQmZyhlCu84E
0YucKXHKbI2B7ax1Z+aO3Ob/SrVaXIvClTVrqH0SnnShaHYJ/dggBtggkLhl
JACoQ6PR3FngEgg0F3tZUlgPNe7KncYeVBztkVO4ICMeJBZW/QeiIRL9iWcI
7olYd+dh1h3wOEkHsqq2d+YWVhfJv5sVaWOBVLLS2iCdNT0UrFY1sbJnV6xo
ke5pzGjdYge8HeKrG9Fcb020TQUaQxji0iOkhZfRpdigavS6DtzFiH+yrJ8g
qA/CS3Rz3XvlcyHGNB+1iRpGHynJFBFbP7/FTnTl8lybdpUI3KLi9+W2QsID
xfuzIvvbp87XviJ0aHMCV7xfPuUUixDkKdbF2oJeV8vC1UTfPFfwzCc+wvXG
e8CsnNU8P+EO+JRYKs3MEOvnTd8XlgURS+wJyyQ86XUambnnKrz7iUCKa/AZ
vHR/W51UhQs1x7OGZJetETT2+9KVxqQYW9L3xdd0T0pjaG6fzVLE4hlOOu5t
FV2GMVo7nVd4sad2byS2tdh82meNJSjZseJIfzlXiLSE1JQZIjZGz2Bgt7li
6Sx8rSw7pXWcP1QtHT4vDeN5aeAnI43eFHqAJ1XxFGoMqcvaNYbG7ku6y5iU
ex8VX5O9r/R2MTSeYKTOxKSoS/k6Mm3UVN+N1WNnSaDf0ZjF299FlZDcLfsC
6VDnBo95Tt4izgivMWr4foc1R6wbRay9NQv9k/zcu6goWu0NWv1JNu3h3lmN
NkZLW40hGxe/o41eRCn3LsuTqnChpiBh+4+xRjQyZkctFSsmxQgVv/Ck0omx
Q+WaPHmhokFIKhafrpdjjNy7BB9j25Z3iQEn8Z9Si88Qoxxj5DoOH+PEZz8e
O3oeGOUJEH4MyqLJcNwpdGO7Lupwd+6/8Tfz/gdBraqU\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->169968319]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27882075],

Cell["Show clipped regions with red lines:", "ExampleText",
 CellID->293919194],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ListLinePlot", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{
         RowBox[{"Sin", "[", "x", "]"}], "/", 
         RowBox[{"x", "^", "2"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "10"}], ",", "10", ",", "0.2"}], "}"}]}], "]"}], ",", 
    RowBox[{"ClippingStyle", "\[Rule]", "Red"}]}], "]"}], "//", 
  "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1464476363],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->432447038]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->356775015],

Cell["\<\
Show clipped regions as red at the bottom, and thick at the top:\
\>", "ExampleText",
 CellID->216629929],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ListLinePlot", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{
         RowBox[{"Sin", "[", "x", "]"}], "/", 
         RowBox[{"x", "^", "2"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "10"}], ",", "10", ",", "0.2"}], "}"}]}], "]"}], ",", 
    RowBox[{"ClippingStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Thick"}], "}"}]}]}], "]"}], "//", 
  "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2143098721],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->870834014]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->116971732],

Cell["Show clipped regions as red and thick:", "ExampleText",
 CellID->214104852],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ListLinePlot", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{
         RowBox[{"Sin", "[", "x", "]"}], "/", 
         RowBox[{"x", "^", "2"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "10"}], ",", "10", ",", "0.2"}], "}"}]}], "]"}], ",", 
    RowBox[{"ClippingStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Red", ",", "Thick"}], "]"}]}]}], "]"}], "//", 
  "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1643613234],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22404221]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ColorFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->9587682],

Cell[TextData[{
 "Color by scaled ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " coordinates:"
}], "ExampleText",
 CellID->4524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"Sinc", "[", 
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", "10", ",", "0.1"}], "]"}], "]"}], ",", 
     RowBox[{"ColorFunction", "->", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], ",", "f"}], "]"}]}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "f"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Hue", "[", "x", "]"}], ",", 
       RowBox[{"Hue", "[", "y", "]"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1257599304],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20406842]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->176597214],

Cell["Color with a named color scheme:", "ExampleText",
 CellID->29246231],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Sinc", "[", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", "10", ",", "0.1"}], "]"}], "]"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<DarkRainbow\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->835092793],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9Wd1PFFcUH3Z2F9FabVcFaW1X1H7YtDWtaUvL5yCwYEEkhm00RhbFgLWC
ywJavypai/ULjYmJ+mTS9KVJX3wwNWn0wQfjU9PEmDTxP5nYe885s8ycufOx
OwSyO/f+7v2d3z33nDt35i49ucLI8A+5wuj+XLoznxsfGd0/ke4Yy4smvULT
tPviO1KjiforUYPvfdM0RYftWimuMdGlS6SLCrRqUE3Y2mT1NvQl5TU+3+rk
aZ52OAT+xYo0mwwq2+ziDDeKS1XDwI1dHn5UMr5Oc2uQZePAjSpoFAKiLqs7
S9Cx43rQy15fTmWfh07cN1Ky+hVgIUF4BSn2OnKTtJV269XiIuVj1F9jjdec
nWvKzlHrG2CF2B4Vq1zDsFTVbap2vqZVMx+ktZYo5p4yGVN46owEZ8DMhZPQ
nrQz1fw3Q/JSviNbvsrbpUKWyjlWB3qfoky41zSMrzdD9HlkVJFazHnVBPiS
UvU7xlwli8rm7DW3w0q1mFLFf3Us5FxasletHUjphe49y0XKyeqQY8E6iYv5
kLLK7+K9iTSPyCzmiuN7DUQ20brngmn9abbeGnN+xXjtVHyH8t6ptgBu3XeK
cB3i3bOEjVBWGxDvnSFcj3jwJOGEUuVTprKJsGX1BeLccRTCJ5BL5RPAxoE8
4fctFWNoSlY/l/M3hiaXKq0/Btw2epDwZlQbHnf4aBw8ggNoy0BFZuiuRs8y
lyZ/QnPMn3eh+ufXmHA2aISoI+Kz3Rg5RMuY95c1A/4OIubhx0kqY1vL8ArA
247sJVzF+t9SetJ2aJhwivXje0Hb90OEVyq9+IiNusVSbTs8KKsbYX6HB1Oh
rD9jOA24fWwPNuF+4FLBldqR30V4q6XSPrZbVtehyvh3QsikXcat8iFT+VJ6
3nE0W4vlwNpQVvUMw36td070YxNmzaXyAeDM1HbC38gxhZGwLOygNsxvZrK3
s9AnPjirQKUmqSSMZNu31LZEXuKZqW5By0z2iE9aqYX7R8+JbYQNstveNd2N
H71ruismSqneTay6UFrjStZ7jHUUWNJfrzMIv1dQIXvWcCjAful7JuE6m5hO
3kOHv3Pzs0BYHX6msJ5paD8020ztEyXY2/HGkDruMwmPzAamVHDkyDqL8H0P
rcbmmhxWPP91jDUZmTVzp8WXtZ6xpiKw0ow17cO6+Zvhy3qXsY45ogyrLFFk
Y6JcMVdrlL6G3wH8+5/thI976MiVElesmFLs+e8Ecrbc/kcPe4vP47AO8IMH
mQW1t3IR9GvA28z6hKnKdzgWPsOfPrJ28pMRWLWMdcqH9e/jXl/WWsY6HYGF
J7UXf/cRPuOINo+uKl9qhXL2uoVTqmZKP5WkVPz1Rn/5sD+EgurXuTXM/qyH
fdAbq1rHfjfEFPPH96D//thJeMZU5T4caxVjnfNhPb+zw5eVYqzzEVhwUtb/
uWSt758jsPDt+9kx663qgiPKYe4CtUI5a3clU/olotKTA+0BSvadWJbcbrZs
D15nShcjKj3qb3EoBb0HLWdWv5qq7L8G+GFrA+FLEVhwTtf/avya8GUlaylj
XYnAqmKsq0rWEsa6pmRVMtZcMcrF3+IC7oMkU7gOCvx0DHeUb75hHxYyN8u0
15kfpejAjipMb5U59u1IdnxN34NW9/+KtIr/ARl2R7k=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->338202792]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->140499403],

Cell["Fill with the color used for the curve:", "ExampleText",
 CellID->94185551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Sinc", "[", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", "10", ",", "0.1"}], "]"}], "]"}], ",", 
   RowBox[{"ColorFunction", "->", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"Hue", "[", "x", "]"}]}], "]"}]}], ",", 
   RowBox[{"Filling", "->", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15063],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->421700574]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{"Prime", ",", "100"}], "]"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"Blend", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Yellow", ",", "Red"}], "}"}], ",", "x"}], "]"}]}], "]"}]}], 
   ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5186],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->6481608]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->317528645],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " has higher priority than ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " for coloring the curve:"
}], "ExampleText",
 CellID->147068490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Sinc", "[", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", "10", ",", "0.1"}], "]"}], "]"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<DarkRainbow\>\""}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Red", ",", "Thick"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26433733],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWd9PXEUUHmbugvijrbRQtBVRwaqJP1ITS/i1S6ELFGhJZRuapgilKpBS
kN22FtRirWhrS7EaYxufNL6Y+NY0NjH1wQfjkzExJib+K0S/c+7c5e7szF12
VdzM3pkz3/m+mTkzd+7c3YGxzMSr02OZyfGx+u65sdmJyfF0fXJmDlWqTAhx
C9+JWoHyXyjx99bq6iqA0LUCVwlIkaVQ4FrBxViojoo3GSunq7dWm+snLLw4
LrHmoZXDPq60Gz4y6x6S81sI8T3DbmG7JXUNmkiiEpeXHX2rMLhKj7c50GgZ
WkESChrUDuWSK3yM3A4WoR22m0gPMtBiIaqrZBVqFPKcXOpeZJypuEfrb6Yx
IZetqeWBnFktD+VhZjUuJC01Xhu0BQUk0oKxhfRheqE1QnmNYZOaCqmpUC7E
dqNtYotYdrXoOZeG1zb2akst+51yeG2ilgBLcqww1pGDU0WX8nxH029rXvzD
HoEy3WhllFvHuj1SI2jFs94F3E8PA2tLXUVytP9/jay2QF+2BrbfdR/PaZM8
JKHr7LG0qlRvwFgorrI9dcXeA16pHmARfBw+GzQz1ets60E9qpz9OK/97N0K
z/jwUkSENmp85u7DayN+5CLPQVY3QGt1Lry13tt3MHPncu9gz7MdP7aAVqnh
x317eCl+dBFJtPr2yLz295wqEiINnIMGxYDBOzsEyq3M5xg9ttDo5/Mv+e29
chYMJCGdzGeJkTg+u4u7BWpiNENp/NRu6kViNC0hU+nkSnCf4XqfheRHw0uc
OAmM0mj6PubTmv9CCMfozWe6aZvPumJx2fH6CfN5/G+3yc+7xGsT/+k4qA2M
BRFHQ/5tYnLsc/2wYW9ie+/Jo1Cj4r0GvsOw+R7omBgXqmNqRNdVGT6b2Qbe
MTmKxFHfYu0NrRpq/AUeJGSJNDWCmie4nakRCYEqJ1fC80WdC9U5PayxOtbr
nD6Cehrb1Mg2q8bTxO2aPcQR0HW7mQsbckhdM6md5NV56rCEYE2kzh7OZ1JU
9k9PKHTNDIGMVGvlPkUxgFsTTyLIRJk9tO+NwX1zA/4+hrLfS0hplltLJjO9
LQGLJFQy3a/x+xlP96P+AOE7rSq7tEo7jwASYFDK7Kda2X26J+Z79EA705tM
9yEJ0hUKwlolWruD6yFJApleoaCKb7fwUIAyp15o9j1m1XmSdPrO7U1SHnBJ
ROMNkaw5Ru9Zdb/lmHdcI9up8wmwqegr8OEy8q3HpiMhk3bwzTO5uVs1aH7G
wTffPoLTd2MJvLDN9+PoUttpBz//vcQcea5CEPvgXcTcvejpqbLe5jwSKqeX
W89YUVoxKhIl7lkrWk/o4o12QQK6zt6HwPPNEtBH2b7+VQIeVHR7STidy4kY
r4hY1ssPdl786jR33jFfhdZZIT7NrmeZ5UeI9/W3nQsRPPNXARpVXQFe4GeO
k3YZVSJP3r6dfCsntoXe3XNZ5nzt0OjbTlSon+7uhwcV7Rr0fJZweqcE9CG2
f/2hHx5UdHtJOJ23ovRcUZEocRdzomZGyRZvUlK/f39gMWpdRO4fpCCh8O4G
K9BomPnnncELEUzbb2M1BXiFznnVmv9eTryD33Fs3kL98c1BMKh4wTqHdBKS
cLpYAsqnkd9uDLxfAlql0SUnKtQvl/rhQUW7Br+dwumDdaDFrE46ncqfz/R8
WNTKMM+86h8rUB8uORTCOxnl3OKPxztd/oVb5N/JoHC5ZIUH2L472A4VKl7O
ibzr2U6nUCJ9ZJ1FPqMCvWJF6S1S3ok3X7Wi/tvLdy1N8EASbi8Jp2UrWqnR
a1aUxqacaIVGV6xouUY/zkaJQPOkZYtYTDOvM7PSQFXBeSIPD/xPiuGv1eAT
A/vTItg8CnA+K7bH4CAJmoHPSxztzWx8w6vwS67N/69DlP0N5tC5IA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->266775754]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->257641459],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " to use the ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->2145045611],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", "10", ",", "0.1"}], "]"}], "]"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<Rainbow\>\""}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Red", ",", "Thick"}], "]"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Black"}], "}"}]}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1973601888],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->199866696]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ColorFunctionScaling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->574084471],

Cell[TextData[{
 "Color the line based on scaled ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " value:"
}], "ExampleText",
 CellID->29852],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], 
      RowBox[{"Exp", "[", 
       RowBox[{"-", 
        RowBox[{"x", "^", "2"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "5"}], ",", "5", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"Hue", "[", "y", "]"}]}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21197],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWdtSWzcUFZYvwUAcLjZOjIHcSusm4BAwlKRp2odmeMhHMBlmkhmYZtI8
dvIjlL7xB/mCvPYlH9CnvPQrNO3eW1tGR0c6N7tO6jk+OtrSWmtL2pLO5fnR
25fHp0dvX704Wn/25uj1y1cvfl3/+Zc3YJJTQoj38H/dFnD9D1zR/71SCgqs
8yacy1BUgrQEaRutaFDmh9ZlTmUg34RUWizSSoXYwnNFcw7PVFfIoRJxWMqe
Got4qto1xlAvqGh8xK6cwpRs/UxeYgVRGWozW/ML8P+Bp0aM0y2PaGRtxRLH
QIBhzH4nq8mRWlKknzdH7qWWupw1Q+NEY2VLRWezf21oWy0IrQ3umnC5NsRX
JH1uOv7/7ljpECuKiEpCVagZPeQGW4/qobFE9VbhVCWGBTj/AZayV6Xj5Euq
Dv8F+K/G6s7Q+KhzoTbYHbjQVqsWjWIV4MCCRx1dhV/XqVf1+nOTehxxQNDH
4xa1cEN3HyrDpbb1ycuel+c2nCTUuKn7RftM7dswthMWEPe8DHeI4VCsk9a5
Hm1A6/yhuO9F3eVSF7U21DwkP/zor6j2CYyeRktGr5IvJ3qOeVFY2vWgdNtP
SNOP3mBNGy0BvULpud7LTPDST7oxw3NBmi3AYUeWFWYvc2ryfU0bmacUqXFL
JEqj+a8d1gmoXKihSofSv/SKXUgFe7DHbDeYvVKI3bC54/ANs7jsN2h88rDb
rG5bklSE/FMJKMNLVrNiqsp+l63UZu4x83VmrjIz5YF4W/liO4TCFVwWQqHW
Qy/qWy5tF0ItM6pWHHXB+WMldkZAJc10mRBh95i9ReVqL8AeiadqaoS5eVfl
Cqu0xq9yHFehO6uRVLDn7iewo313bG1AX5s+FaEa41ExbUlR8cx0c1fkxpFh
XGLGaS+jG9shFOcbgzGjBHYt1MBjMRd6k0ttlLxQhiUjqs5a/PSizqAML/29
40VDiveGCB7ERsk38/kWkn/uuCVpQHq2F4o3WyUl2qIaH9V/obHFGvOsMTMm
DYz1flHu2DOI2/uFvY49b7ltYeYzl3me7fsqNMNDe3k2RjeGXdQso65R+kH5
UdzjZ9f+d6gGo75LRDUYNedFhWY05RP28ozskWiqWNF0qZK2f/BbDli/PlB+
LqL4USUp5t+tHjDb1RwqNaffQrv6ts3dEmPjDvoPGqYdOl3zatDsy/C+JKvW
HGsdxCIsbWfPxuhGejGUGY25QqhZRjU+A2qWUY9i/eubwcl78jZzpWjE57Gl
kvZU7GqYdUy/F3onFL37UOLAo5V3b07SKoGUrz21FE4zf3eYe8bmhjQXt2cM
Hhbgzf/kHVH5FFTJsUsbxjozzjNjnRkfK19UTxK1o/Nr6h1ZxJXcaCydZtQC
o6YLo6B3xd/sy6NcaPIcwN/HRsmd80nra0b2kXagSWngwlFjjcUMGhXuk/hX
BRPfA/Y8wvopmTX/HcZuAZW8/RPRUOK3JdZAb6U3irB3ZELk7LJ3Pka0P1G+
aC6GGnBphVHNKOr0y0O1GFVm1A/ZUZBGUWlzO/QefaDH9rSczJ5757Pze8yl
vx+I7vIENTjfeerRMHPb7ROzc+87nG3mLCVwZnuqNsylHMy1KLOI3+Uwa0d/
0RJdOPS7Zrwok62jj6exmDEzObRr7+s46SDXdX3dRa0flS9m6XlBkhZ9Nexw
vsv5n7yoA+0rf10J1dLfL8XUv+NDWo4=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->36867273]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->330269683],

Cell[TextData[{
 "Color the line based on unscaled ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " value:"
}], "ExampleText",
 CellID->775742741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], 
      RowBox[{"Exp", "[", 
       RowBox[{"-", 
        RowBox[{"x", "^", "2"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "5"}], ",", "5", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"Hue", "[", "y", "]"}]}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->402141089],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWctyEzkUVVp+ECeeJCRObAghzMMJARJjiDGBGWAWw4qq2eQDUtRUwYJH
ATt/BcV2ar6CD5gfGBb8CmsV3Ht15ajVUr9sDONq67Ye55wr6Urqth+dvHny
17OTN08fn2w/fHXy8snTx6+3/3jxCorknBDiPXxftgXcf4Y7+r5XSkGFle5D
WoGqCGwEto2lWKDMB0s32MpAvgVWWizSskIcYFrVnOOU2go5ViIOS9nTYhWT
mt1iCu2CisZHHMo5tFTWy+UlNhDVsTaztb4D/697WiQ43fqYRt5erHEMBBim
7He6mpyoJ2XGeX/iUVpXp6tmXDjTWDlQ8dXs3xvaVg9Ce4O7J5zuDckdSact
x/+/nVK6xBYkV5AP7B7YS2Br1PIspP9Ai4qX7byTj8CjSFXh20i0XaB5UEOh
miwLN7rUakWzVQM4sOAVkX9CXHDa1bz+XKKRRRwQLOP1I/WqqYcJleFWly2T
l3tenp8gkdCC+CT7TP1rmrIuC4irXoafiaEjtklrqGcV0DrfEde8qF+41kVd
HGt2yA8/ukutuzCbGi0ZvUW+dPVa8qKw9oIHpfveJU0/eoc1bbQE9CbZoT6z
TJDSR7oxwzEvzVbvsCPLJrNX2Jp8T9PG1iNFarIkFqXx/K7DOguV0VjlPNk/
9c5cSgVHcI/ZzjF7tRS7YXPn4TKzuOznaH6KsNusbl/SVCBsnguow1tWs2Kq
xn5XLGsz7zFzh5lrzKzzz0Vf+WI7hGpTr8ugUOuGF3WFa9ulUBuMqk+AGnH+
nbg5ASptpcuUCLvK7OtkP4TYY/FUy4wwN++qnGGV9a+g8i6hQk9QE6ngyF1L
Ycfyw6n1AX1teVX+nZKK6UuGimelm6cfN44M4xozznsZ3dgOodYYNZgySuDQ
Qgu46IkyP3qfa22UBNRqIVSDtfRbivpEvsCtf3T86A/0bIjgQWKWfCufHyH5
485bmkYEGrdC8WarZERbTOOj+ioaB6yxwhoLU9LAWO+V5U68a7ijX9rrxHuV
25cDZnCZV7h8qEIrPHSW52N0Y9hFLTJqGe1/KoDqMWr5f4daYtTtVNQSo5pe
VGhFUz7lLM/JHoumqhVNpypZ54f+NQOkgBVvm7Yi2DTF4qfVdWb7oYBK3Rm3
0Knet7lH0+MO+j867QfZt34NWn05fhfJq9VkraNEhGWd7PkY3UgvhzKz0SyF
WmTU0jdALTLqTmJ8fSs4/UzuM1eGRnIdWypZb8WuhtnH9O9Cx0q81Sv7yKNV
9GxO04qO/f2pZ3Ca9XuTuRds7lFBbs8c3CjBW/zNO6bSC6oUOKUNY4MZV5ix
wYx3lS+qZ4mitzAJsGMdYWcKo7F2nlFnGTVfGiXk1tiXO4XQ5DmAf03Mkrvm
0/bXnOwTnUCz0sCNo84aqzk0qjwmyX8PTHwP2PMYay+dtfgTxmEJlaLjE9MQ
qrLGGuit9EYRjo5MiZxD9s7HiOW/KV80l0MNuLbKqJaNEqrx/aHWGVVh1L38
KLBxVNbaDv2OPqBy1aiksxc++ez8LebSUaJ2Nmaowfnd+x4Ns7bdMTEn99Dh
bDNnlMKZ763aMEcFmOtxZpF8ymHWXR0AagevDivoYxjq6LqfiBmzkkOn9lDH
yS5ydfT9Dmo9UL6Yva3zqNXHi/8NRJco/7sXdaR97W+y9bfS/1OKuS9R20ac
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3099265]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "DataRange",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->173102855],

Cell["\<\
Lists of height values are displayed against the number of elements:\
\>", "ExampleText",
 CellID->566001237],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", 
      RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->723396511],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxVz38s1HEcx/GL2STNUc3PKC5TcZxT50e61zl3fjMSpqxNWlNThtVmzWjV
Gkt/pFw1c1lWawuVyCGm7EInxzgN3fkZ7s6PRltjXTXv7x99ts8+e3yf2+fz
fe/PvJx0zozFYgn/7n/n1loRsv5f8O4r66srb6HvlmgbDPUw5fSQ2QhQKO6r
FgbJu3Hx/OGFYMMo2QErFjEF83XfyC5IF9Xa37GdIu9Di6M0+1LVDNkdqt8d
XRVrc2QORM8zZOa2C2RPLFlvv5tsXCR7IfCsT2z3DQP5ELpPOtWIh4xkb8S4
dv+6OrxE5sJ8Mlyrur1M9kNZjvfjQj1jHrrDdMqSTcb+aJL5appbGfOxsqe9
pOsg4wCkBjq52Ucy9x+BtFG9+NOBef8oNvL0wuxqPVkAS82Lr3wtM08g3H3T
fNTj38lBkKk/rGdVzZKD8ar3y856z2lyCFpvyls3i3TkY7B+xuHw0sfIoeic
zfDIyx0mH8eQX+TIu+p+shCnhptyAtldZIDLll23ia7dcjHg7zMfJJh+2bHV
Rai0bu41433ccrEIBbEmdk/6APUwuGUqikLyR6iHYVW9IhYljVMXQ+TMNVxY
01EXQ95pMKVUTFMPR/8bNx+u2Rz1cNS5jk+0COapS9D+aarwhO8idQlG7Qa0
P6b11KU4ULotOCTRSF2KZS8J71b+EvUIFEMZaoxYph4BhSFjV+JnMisSSQaB
zRkT0yNhCrV+VKFjehSe6t2vIJfpUeA/1K2X1DP3R6PFfdRFKmfej4aGo3gd
JjFQj4HAri15+Qnz/zHItfCvvKZg5otFaoNVfM89Zv5YNK4/sE/hz1CPg1xZ
GCWonqQeh15tudKqbYJ6PJzbd2TJjBrq8eisaShdnVRTT8DpDb7GMVFJPQF7
Ve/H0iRvO/4ASIw7LA==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 63.}, {-0.9999232575641008, 0.9995736030415051}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1220234710]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1720727163],

Cell["Rescale to the sampling space:", "ExampleText",
 CellID->1577717696],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"2", "Pi"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15942120],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxdkX1Mk1cUxilfCrTSUmpBHASEZToKQp3tNN05CFQcZhuMgcF1Ouay6AIS
dW4jjgCZmxHHSMZGnRE6I5lZHIgfaF/oLuJIR1kZlUEhlFEoAv18y1acBLXb
8r5/7SY3Nyf33nOe5/cklh0tfDcwICAA/t3/nf9fibWGxs+XtJA6WD/Y3qAF
ph6AnvuKTf7yAZiwNl9N+WAEtlHU10b7ffZ+At5/73n7Dtc43GqspnzbreAN
yT+x2P4H+94GpVlt4i8Es/Bka2dL8Y150MYqD1dcnGP/28H4lPQ1+eZBabLV
3Ul3Q9YVlTpIYGf7ecHDDfuyyO0AvbxeyhtbAvk7kr39n7rY/n9B/xsbLmWP
uMF55nLKS9HLkB/fv/LhqIed9xCCZnKmjWdoiJzQiY8WPoL68tQLVU6anb8C
/bus+trHNGRuNodpGlehS51uvt1Ns3qegFekq+3bTEPJx97V4aGnUCLfkCDO
87D6AlB50+R4GOMG3Vzw3zWhHFw95oTDrU5WLwfXmn+YkE7bYficoPJ8WyAm
pe+TmCwLrP4gVJvuLR+6+ABmtsXbO3OCsdPwG6/jWRvrJwS7T2u6H1dbwWfZ
UmawhSD3++TkjNJJ1l8o9j5QbTpWOQqhp2WTs3VrcGRr3tid1iHW71rcP9pV
Luf3QYwkp2g1MQzT+Oq6yJfbWP9hmClZfFFm+5FsGX3NKLwbjs3c24bAjJ8J
wyMCT+z18wdKh4niE5Uy9SAXE8qo6p3HxwjDh4dLJm92VqGFvJpyhOT4eZgV
l+Y64rMShtc61PS6/MVNNnLQeFKuaonEoRsJkrTAecLw42N7vGVKK1skWuru
ONXCR90vs1WvpzsIw1OA41HD03/anOTeujzR7goBppzl7NhZ4CYMXwHSz+Vm
fHbcQwbLhgpGFFFYg3qFezdNGN5RSLlUwoJfafJ7V1HDAZ4QC12yyAN+mjD8
hehXcL9tstJkKnzS4LQI8bIz6SRW0oTJIxql563LtR0esvDW22s+uhqN2qTx
jUqNmzD5iNCcTF3flesi9PWF7OBTIpRF9RTR3zkIk5cIK0Mym09Ri+RRaEVN
Y/56LLkW/srAV/OEyW893lz+RlwsnSOc/b6ejXFi1Oir9shaZwiTpxgN0w36
8J4pEtFRtXLFIcY4XcQhtdtMmHxjsPfStbNLMyYSHcTZ/gIVg2+uSs2xBXrC
5B2Lzxh/mtyXe4v8A1UD+cs=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 6.283185307179586}, {-0.9999232575641008, 
   0.9995736030415051}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1651238612]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->99154392],

Cell["Each dataset is scaled to the same domain:", "ExampleText",
 CellID->1080449043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6", ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "9", ",", "10", ",", "11", ",", "12"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->40556272],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[{{0., 1.}, {0.5, 2.}, {1., 3.}}]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], 
    LineBox[{{0., 4.}, {0.3333333333333333, 5.}, {0.6666666666666666, 6.}, {
     1., 7.}}]}, 
   {Hue[0.1421359549995791, 0.6, 0.6], 
    LineBox[{{0., 8.}, {0.25, 9.}, {0.5, 10.}, {0.75, 11.}, {1., 12.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 1.}, {0., 12.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2086472358]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->299772908],

Cell[TextData[{
 "Pairs are interpreted as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", ",", " ", "y"}], TraditionalForm]], "InlineMath"],
 " coordinates:"
}], "ExampleText",
 CellID->1755387432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->436181703],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[{{1., 1.}, {2., 2.}, {3., 2.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{1., 1.},
  PlotRange->{{1., 3.}, {1., 2.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23461482]
}, Open  ]],

Cell[TextData[{
 "Specifying ",
 Cell[BoxData[
  ButtonBox["DataRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DataRange"]], "InlineFormula"],
 " in this case has no effect, since ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " values are part of the data:"
}], "ExampleText",
 CellID->310538846],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->302693796],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[{{1., 1.}, {2., 2.}, {3., 2.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{1., 1.},
  PlotRange->{{1., 3.}, {1., 2.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->528912377]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->286628894],

Cell["Force interpretation as multiple datasets: ", "ExampleText",
 CellID->666227138],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"DataRange", "\[Rule]", "All"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->947339775],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[{{1., 1.}, {2., 1.}}]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[{{1., 2.}, {2., 2.}}]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], LineBox[{{1., 3.}, {2., 2.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 2.}, {0, 3.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3317855]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Filling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->116701697],

Cell["Use symbolic or explicit values: ", "ExampleText",
 CellID->13911],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Prime", "[", "n", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "30"}], "}"}]}], "]"}], ",", 
     RowBox[{"Filling", "\[Rule]", "c"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Top", ",", "Bottom", ",", "Axis", ",", 
       RowBox[{"Prime", "[", "15", "]"}]}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->456081556],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    GraphicsComplexBox[{{1., 2.}, {2., 3.}, {3., 5.}, {4., 7.}, {5., 11.}, {
     6., 13.}, {7., 17.}, {8., 19.}, {9., 23.}, {10., 29.}, {11., 31.}, {12., 
     37.}, {13., 41.}, {14., 43.}, {15., 47.}, {16., 53.}, {17., 59.}, {18., 
     61.}, {19., 67.}, {20., 71.}, {21., 73.}, {22., 79.}, {23., 83.}, {24., 
     89.}, {25., 97.}, {26., 101.}, {27., 103.}, {28., 107.}, {29., 109.}, {
     30., 113.}, {1., 113.}}, {{
       {Hue[0.67, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
        GraphicsGroupBox[
         PolygonBox[{{30, 31, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 
          15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29}},
          VertexColors->None]]}, {}, {}, {}}, {{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
         18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30}]}}}],
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 30.}, {0., 113.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[
    GraphicsComplexBox[{{1., 2.}, {2., 3.}, {3., 5.}, {4., 7.}, {5., 11.}, {
     6., 13.}, {7., 17.}, {8., 19.}, {9., 23.}, {10., 29.}, {11., 31.}, {12., 
     37.}, {13., 41.}, {14., 43.}, {15., 47.}, {16., 53.}, {17., 59.}, {18., 
     61.}, {19., 67.}, {20., 71.}, {21., 73.}, {22., 79.}, {23., 83.}, {24., 
     89.}, {25., 97.}, {26., 101.}, {27., 103.}, {28., 107.}, {29., 109.}, {
     30., 113.}, {1., 0.}, {30., 0.}}, {{{}, 
       {Hue[0.67, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
        GraphicsGroupBox[
         PolygonBox[{{1, 31, 32, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 
          19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2}},
          VertexColors->None]]}, {}, {}}, {{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
         18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30}]}}}],
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 30.}, {0., 113.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[
    GraphicsComplexBox[{{1., 2.}, {2., 3.}, {3., 5.}, {4., 7.}, {5., 11.}, {
     6., 13.}, {7., 17.}, {8., 19.}, {9., 23.}, {10., 29.}, {11., 31.}, {12., 
     37.}, {13., 41.}, {14., 43.}, {15., 47.}, {16., 53.}, {17., 59.}, {18., 
     61.}, {19., 67.}, {20., 71.}, {21., 73.}, {22., 79.}, {23., 83.}, {24., 
     89.}, {25., 97.}, {26., 101.}, {27., 103.}, {28., 107.}, {29., 109.}, {
     30., 113.}, {1., 0.}, {30., 0.}}, {{{}, 
       {Hue[0.67, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
        GraphicsGroupBox[
         PolygonBox[{{1, 31, 32, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 
          19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2}},
          VertexColors->None]]}, {}, {}}, {{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
         18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30}]}}}],
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 30.}, {0., 113.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[
    GraphicsComplexBox[{{1., 2.}, {2., 3.}, {3., 5.}, {4., 7.}, {5., 11.}, {
     6., 13.}, {7., 17.}, {8., 19.}, {9., 23.}, {10., 29.}, {11., 31.}, {12., 
     37.}, {13., 41.}, {14., 43.}, {15., 47.}, {16., 53.}, {17., 59.}, {18., 
     61.}, {19., 67.}, {20., 71.}, {21., 73.}, {22., 79.}, {23., 83.}, {24., 
     89.}, {25., 97.}, {26., 101.}, {27., 103.}, {28., 107.}, {29., 109.}, {
     30., 113.}, {1., 47.}, {30., 47.}}, {{
       {Hue[0.67, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
        GraphicsGroupBox[
         PolygonBox[{{15, 31, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14}},
          
          VertexColors->None]]}, 
       {Hue[0.67, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
        GraphicsGroupBox[
         PolygonBox[{{15, 32, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 
          18, 17, 16}},
          VertexColors->None]]}, {}, {}}, {{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
         18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30}]}}}],
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 30.}, {0., 113.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{390, 242},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5753440]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->491200879],

Cell["Fills that overlap by default combine using opacity:", "ExampleText",
 CellID->410116164],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"n", "/", "3"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "20"}], "}"}]}], "]"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"n", "/", "3"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "20"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 0.3271946967961522}, {2., 0.618369803069737}, {3., 
   0.8414709848078965}, {4., 0.9719379013633127}, {5., 0.9954079577517649}, {
   6., 0.9092974268256817}, {7., 0.7230858817383246}, {8., 
   0.457272626635812}, {9., 0.1411200080598672}, {
   10., -0.19056796287548539`}, {11., -0.5012770485883448}, {
   12., -0.7568024953079282}, {13., -0.9290145012707619}, {
   14., -0.9989549170979283}, {15., -0.9589242746631385}, {
   16., -0.81332939156758}, {17., -0.5781982417443089}, {
   18., -0.27941549819892586`}, {19., 0.050127009882172724`}, {20., 
   0.37415123057121996`}, {1., 0.9449569463147377}, {2., 0.785887260776948}, {
   3., 0.5403023058681398}, {4., 0.23523757330298942`}, {
   5., -0.09572354801437566}, {6., -0.4161468365471424}, {
   7., -0.6907581397498764}, {8., -0.8893265682130413}, {
   9., -0.9899924966004454}, {10., -0.981674004711079}, {
   11., -0.8652868429362359}, {12., -0.6536436208636119}, {
   13., -0.3700433169625381}, {14., -0.04570638473858045}, {15., 
   0.28366218546322625`}, {16., 0.5818034898591706}, {17., 
   0.815896312801933}, {18., 0.960170286650366}, {19., 0.9987428512286196}, {
   20., 0.9273677030509753}, {4.710771018561469, 0.}, {14.138769721441776`, 
   0.}, {1., 0.}, {20., 0.}, {9.425460132491125, 0.}, {18.84788909274843, 
   0.}, {1., 0.}, {20., 0.}}, {{
     {Hue[0.67, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{46, 45, 10, 11, 12, 13, 14, 15, 16, 17, 18}},
        VertexColors->None]]}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[{{46, 48, 20, 19}},
         VertexColors->None], 
        PolygonBox[{{1, 47, 45, 9, 8, 7, 6, 5, 4, 3, 2}},
         VertexColors->None]}]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{42, 41, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34}},
        VertexColors->None]]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[{{21, 43, 41, 24, 23, 22}},
         VertexColors->None], PolygonBox[{{42, 44, 40, 39, 38, 37, 36, 35}},
         VertexColors->None]}]}, {}, {}, {}, {}, {}, {}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 45, 10, 11, 12, 13, 14, 15, 16, 17, 
       18, 46, 19, 20}]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], 
      LineBox[{21, 22, 23, 24, 41, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 42,
        35, 36, 37, 38, 39, 40}]}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 20.}, {-0.9989549170979283, 0.9987428512286196}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->136521073]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1527938944],

Cell["Fill between the first curve and the axis:", "ExampleText",
 CellID->460380982],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"n", "/", "3"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "20"}], "}"}]}], "]"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"n", "/", "3"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "20"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", "Axis"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5949202],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 0.3271946967961522}, {2., 0.618369803069737}, {3., 
   0.8414709848078965}, {4., 0.9719379013633127}, {5., 0.9954079577517649}, {
   6., 0.9092974268256817}, {7., 0.7230858817383246}, {8., 
   0.457272626635812}, {9., 0.1411200080598672}, {
   10., -0.19056796287548539`}, {11., -0.5012770485883448}, {
   12., -0.7568024953079282}, {13., -0.9290145012707619}, {
   14., -0.9989549170979283}, {15., -0.9589242746631385}, {
   16., -0.81332939156758}, {17., -0.5781982417443089}, {
   18., -0.27941549819892586`}, {19., 0.050127009882172724`}, {20., 
   0.37415123057121996`}, {1., 0.9449569463147377}, {2., 0.785887260776948}, {
   3., 0.5403023058681398}, {4., 0.23523757330298942`}, {
   5., -0.09572354801437566}, {6., -0.4161468365471424}, {
   7., -0.6907581397498764}, {8., -0.8893265682130413}, {
   9., -0.9899924966004454}, {10., -0.981674004711079}, {
   11., -0.8652868429362359}, {12., -0.6536436208636119}, {
   13., -0.3700433169625381}, {14., -0.04570638473858045}, {15., 
   0.28366218546322625`}, {16., 0.5818034898591706}, {17., 
   0.815896312801933}, {18., 0.960170286650366}, {19., 0.9987428512286196}, {
   20., 0.9273677030509753}, {9.425460132491125, 0.}, {18.84788909274843, 
   0.}, {1., 0.}, {20., 0.}}, {{
     {Hue[0.67, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{42, 41, 10, 11, 12, 13, 14, 15, 16, 17, 18}},
        VertexColors->None]]}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[{{42, 44, 20, 19}},
         VertexColors->None], 
        PolygonBox[{{1, 43, 41, 9, 8, 7, 6, 5, 4, 3, 2}},
         VertexColors->None]}]}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 41, 10, 11, 12, 13, 14, 15, 16, 17, 
       18, 42, 19, 20}]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], 
      LineBox[{21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36,
        37, 38, 39, 40}]}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 20.}, {-0.9989549170979283, 0.9987428512286196}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->479319396]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->114396081],

Cell["Fill between two lines:", "ExampleText",
 CellID->27112],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"n", "/", "3"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "20"}], "}"}]}], "]"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"n", "/", "3"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "20"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", "2", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6962],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 0.3271946967961522}, {2., 0.618369803069737}, {3., 
   0.8414709848078965}, {4., 0.9719379013633127}, {5., 0.9954079577517649}, {
   6., 0.9092974268256817}, {7., 0.7230858817383246}, {8., 
   0.457272626635812}, {9., 0.1411200080598672}, {
   10., -0.19056796287548539`}, {11., -0.5012770485883448}, {
   12., -0.7568024953079282}, {13., -0.9290145012707619}, {
   14., -0.9989549170979283}, {15., -0.9589242746631385}, {
   16., -0.81332939156758}, {17., -0.5781982417443089}, {
   18., -0.27941549819892586`}, {19., 0.050127009882172724`}, {20., 
   0.37415123057121996`}, {1., 0.9449569463147377}, {2., 0.785887260776948}, {
   3., 0.5403023058681398}, {4., 0.23523757330298942`}, {
   5., -0.09572354801437566}, {6., -0.4161468365471424}, {
   7., -0.6907581397498764}, {8., -0.8893265682130413}, {
   9., -0.9899924966004454}, {10., -0.981674004711079}, {
   11., -0.8652868429362359}, {12., -0.6536436208636119}, {
   13., -0.3700433169625381}, {14., -0.04570638473858045}, {15., 
   0.28366218546322625`}, {16., 0.5818034898591706}, {17., 
   0.815896312801933}, {18., 0.960170286650366}, {19., 0.9987428512286196}, {
   20., 0.9273677030509753}, {2.3574192718940856`, 0.6981104650052999}, {
   2.3574192718940856`, 0.6981104650052999}, {
   11.77918280626349, -0.7003780832350418}, {
   11.77918280626349, -0.7003780832350418}}, {{{}, {}, {}, {}, {}, {}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[{{1, 2, 42, 41, 22, 21}},
         VertexColors->None], 
        PolygonBox[{{43, 12, 13, 14, 15, 16, 17, 18, 19, 20, 40, 39, 38, 37, 
         36, 35, 34, 33, 32, 44}},
         VertexColors->None]}]}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{41, 23, 24, 25, 26, 27, 28, 29, 30, 31, 44, 43, 11, 10, 9,
         8, 7, 6, 5, 4, 3, 42}},
        VertexColors->None]]}, {}, {}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 42, 3, 4, 5, 6, 7, 8, 9, 10, 11, 43, 12, 13, 14, 15, 16, 
       17, 18, 19, 20}]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], 
      LineBox[{21, 22, 41, 23, 24, 25, 26, 27, 28, 29, 30, 31, 44, 32, 33, 34,
        35, 36, 37, 38, 39, 40}]}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 20.}, {-0.9989549170979283, 0.9987428512286196}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17718664]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8368027],

Cell["Fill between curves 1 and 2 with a specific style:", "ExampleText",
 CellID->140266586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"n", "/", "3"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "20"}], "}"}]}], "]"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"n", "/", "3"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "20"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Filling", "->", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "2", "}"}], ",", "LightOrange"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->88789063],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 0.3271946967961522}, {2., 0.618369803069737}, {3., 
   0.8414709848078965}, {4., 0.9719379013633127}, {5., 0.9954079577517649}, {
   6., 0.9092974268256817}, {7., 0.7230858817383246}, {8., 
   0.457272626635812}, {9., 0.1411200080598672}, {
   10., -0.19056796287548539`}, {11., -0.5012770485883448}, {
   12., -0.7568024953079282}, {13., -0.9290145012707619}, {
   14., -0.9989549170979283}, {15., -0.9589242746631385}, {
   16., -0.81332939156758}, {17., -0.5781982417443089}, {
   18., -0.27941549819892586`}, {19., 0.050127009882172724`}, {20., 
   0.37415123057121996`}, {1., 0.9449569463147377}, {2., 0.785887260776948}, {
   3., 0.5403023058681398}, {4., 0.23523757330298942`}, {
   5., -0.09572354801437566}, {6., -0.4161468365471424}, {
   7., -0.6907581397498764}, {8., -0.8893265682130413}, {
   9., -0.9899924966004454}, {10., -0.981674004711079}, {
   11., -0.8652868429362359}, {12., -0.6536436208636119}, {
   13., -0.3700433169625381}, {14., -0.04570638473858045}, {15., 
   0.28366218546322625`}, {16., 0.5818034898591706}, {17., 
   0.815896312801933}, {18., 0.960170286650366}, {19., 0.9987428512286196}, {
   20., 0.9273677030509753}, {2.3574192718940856`, 0.6981104650052999}, {
   2.3574192718940856`, 0.6981104650052999}, {
   11.77918280626349, -0.7003780832350418}, {
   11.77918280626349, -0.7003780832350418}}, {{{}, {}, {}, {}, {}, {}, 
     {RGBColor[1, 0.9, 0.8], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[{{1, 2, 42, 41, 22, 21}},
         VertexColors->None], 
        PolygonBox[{{43, 12, 13, 14, 15, 16, 17, 18, 19, 20, 40, 39, 38, 37, 
         36, 35, 34, 33, 32, 44}},
         VertexColors->None]}]}, 
     {RGBColor[1, 0.9, 0.8], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{41, 23, 24, 25, 26, 27, 28, 29, 30, 31, 44, 43, 11, 10, 9,
         8, 7, 6, 5, 4, 3, 42}},
        VertexColors->None]]}, {}, {}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 42, 3, 4, 5, 6, 7, 8, 9, 10, 11, 43, 12, 13, 14, 15, 16, 
       17, 18, 19, 20}]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], 
      LineBox[{21, 22, 41, 23, 24, 25, 26, 27, 28, 29, 30, 31, 44, 32, 33, 34,
        35, 36, 37, 38, 39, 40}]}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 20.}, {-0.9989549170979283, 0.9987428512286196}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->111788571]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->185630674],

Cell[TextData[{
 "Fill between curves 1 and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    FractionBox["1", "2"]}], TraditionalForm]], "InlineMath"],
 " with light orange:"
}], "ExampleText",
 CellID->1031125038],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"n", "/", "3"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "20"}], "}"}]}], "]"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"n", "/", "3"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "20"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", "2"}], ",", "LightOrange"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2072966023],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 0.3271946967961522}, {2., 0.618369803069737}, {3., 
   0.8414709848078965}, {4., 0.9719379013633127}, {5., 0.9954079577517649}, {
   6., 0.9092974268256817}, {7., 0.7230858817383246}, {8., 
   0.457272626635812}, {9., 0.1411200080598672}, {
   10., -0.19056796287548539`}, {11., -0.5012770485883448}, {
   12., -0.7568024953079282}, {13., -0.9290145012707619}, {
   14., -0.9989549170979283}, {15., -0.9589242746631385}, {
   16., -0.81332939156758}, {17., -0.5781982417443089}, {
   18., -0.27941549819892586`}, {19., 0.050127009882172724`}, {20., 
   0.37415123057121996`}, {1., 0.9449569463147377}, {2., 0.785887260776948}, {
   3., 0.5403023058681398}, {4., 0.23523757330298942`}, {
   5., -0.09572354801437566}, {6., -0.4161468365471424}, {
   7., -0.6907581397498764}, {8., -0.8893265682130413}, {
   9., -0.9899924966004454}, {10., -0.981674004711079}, {
   11., -0.8652868429362359}, {12., -0.6536436208636119}, {
   13., -0.3700433169625381}, {14., -0.04570638473858045}, {15., 
   0.28366218546322625`}, {16., 0.5818034898591706}, {17., 
   0.815896312801933}, {18., 0.960170286650366}, {19., 0.9987428512286196}, {
   20., 0.9273677030509753}, {1.593475539222374, 0.5}, {7.839257928098018, 
   0.5}, {1., 0.5}, {20., 0.5}}, {{
     {RGBColor[1, 0.9, 0.8], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[{{41, 43, 1}},
         VertexColors->None], 
        PolygonBox[{{20, 44, 42, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
         19}},
         VertexColors->None]}]}, 
     {RGBColor[1, 0.9, 0.8], EdgeForm[None], 
      GraphicsGroupBox[PolygonBox[{{41, 42, 7, 6, 5, 4, 3, 2}},
        VertexColors->None]]}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 41, 2, 3, 4, 5, 6, 7, 42, 8, 9, 10, 11, 12, 13, 14, 15, 16, 
       17, 18, 19, 20}]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], 
      LineBox[{21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36,
        37, 38, 39, 40}]}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 20.}, {-0.9989549170979283, 0.9987428512286196}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->415801359]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->245368575],

Cell["\<\
Fill between curves 1 and 2; use yellow when 1 is below 2, and green when 2 \
is above 1:\
\>", "ExampleText",
 CellID->1241540290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"n", "/", "3"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "20"}], "}"}]}], "]"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"n", "/", "3"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "20"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "2", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Yellow", ",", "Green"}], "}"}]}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9250746],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 0.3271946967961522}, {2., 0.618369803069737}, {3., 
   0.8414709848078965}, {4., 0.9719379013633127}, {5., 0.9954079577517649}, {
   6., 0.9092974268256817}, {7., 0.7230858817383246}, {8., 
   0.457272626635812}, {9., 0.1411200080598672}, {
   10., -0.19056796287548539`}, {11., -0.5012770485883448}, {
   12., -0.7568024953079282}, {13., -0.9290145012707619}, {
   14., -0.9989549170979283}, {15., -0.9589242746631385}, {
   16., -0.81332939156758}, {17., -0.5781982417443089}, {
   18., -0.27941549819892586`}, {19., 0.050127009882172724`}, {20., 
   0.37415123057121996`}, {1., 0.9449569463147377}, {2., 0.785887260776948}, {
   3., 0.5403023058681398}, {4., 0.23523757330298942`}, {
   5., -0.09572354801437566}, {6., -0.4161468365471424}, {
   7., -0.6907581397498764}, {8., -0.8893265682130413}, {
   9., -0.9899924966004454}, {10., -0.981674004711079}, {
   11., -0.8652868429362359}, {12., -0.6536436208636119}, {
   13., -0.3700433169625381}, {14., -0.04570638473858045}, {15., 
   0.28366218546322625`}, {16., 0.5818034898591706}, {17., 
   0.815896312801933}, {18., 0.960170286650366}, {19., 0.9987428512286196}, {
   20., 0.9273677030509753}, {2.3574192718940856`, 0.6981104650052999}, {
   2.3574192718940856`, 0.6981104650052999}, {
   11.77918280626349, -0.7003780832350418}, {
   11.77918280626349, -0.7003780832350418}}, {{{}, {}, {}, {}, {}, {}, 
     {RGBColor[1, 1, 0], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[{{1, 2, 42, 41, 22, 21}},
         VertexColors->None], 
        PolygonBox[{{43, 12, 13, 14, 15, 16, 17, 18, 19, 20, 40, 39, 38, 37, 
         36, 35, 34, 33, 32, 44}},
         VertexColors->None]}]}, 
     {RGBColor[0, 1, 0], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{41, 23, 24, 25, 26, 27, 28, 29, 30, 31, 44, 43, 11, 10, 9,
         8, 7, 6, 5, 4, 3, 42}},
        VertexColors->None]]}, {}, {}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 42, 3, 4, 5, 6, 7, 8, 9, 10, 11, 43, 12, 13, 14, 15, 16, 
       17, 18, 19, 20}]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], 
      LineBox[{21, 22, 41, 23, 24, 25, 26, 27, 28, 29, 30, 31, 44, 32, 33, 34,
        35, 36, 37, 38, 39, 40}]}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 20.}, {-0.9989549170979283, 0.9987428512286196}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->687024047]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->392432106],

Cell["Filling between curves applies where the curves overlap:", "ExampleText",
 CellID->684125605],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{
          RowBox[{"i", "^", "2"}], "+", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{
          RowBox[{"i", "^", "2"}], "-", "20"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "2", ",", "7"}], "}"}]}], "]"}]}], "}"}], ",", " ", 
   
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", "2", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->471597197],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{0., 1.}, {1., 2.}, {2., 5.}, {3., 10.}, {4., 17.}, {5.,
    26.}, {2., -16.}, {3., -11.}, {4., -4.}, {5., 5.}, {6., 16.}, {7., 29.}, {
   5., 5.}}, {{{}, {}, {}, {}, {}, {}, {}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
      GraphicsGroupBox[PolygonBox[{{7, 8, 9, 10, 13, 6, 5, 4, 3}},
        VertexColors->None]]}, {}, {}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[{1, 2, 3, 4, 5, 6}]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], 
      LineBox[{7, 8, 9, 10, 13, 11, 12}]}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 7.}, {-16., 29.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->157912523]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FillingStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->7509],

Cell["Use different fill colors:", "ExampleText",
 CellID->10234],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"Sin", "[", "x", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
     RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
     RowBox[{"FillingStyle", "\[Rule]", "c"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Green", ",", "Blue", ",", "Yellow"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12500],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{448, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->203002990]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->839],

Cell["Fill with opacity 0.5 orange:", "ExampleText",
 CellID->21157],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"Sin", "[", "x", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
   RowBox[{"FillingStyle", "->", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"Opacity", "[", "0.5", "]"}], ",", "Orange"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5668],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx11QtM00ccwPHKG8QB5dH6joiASgUtCQ7E+6FDUYgoIqDo2BjqBBWGRAcD
pxssDJUtDLFqGFgnOB2PCaKt4B9wrILiLIjAQHlDKW3/6EAlENhY785siZc0
zT//u+81zX1yi8KjA/bqcDic5H8+09//HxfOTw8Jcnpw6kFhugRpn2tReYPn
4qlDtchVOD0akatUerZ+sAG/b0VR+5cPuqtakLbSiYb1feMUhc/x/B60y+sK
74xFN9q/b3r0I8nsDQcOZ/fi9YOofpKpzhzpR/UPp4cKeV3dI9K1GMS9YaQx
Nf4uUK3E81+g1Z8I/GqSVbj/F6rZMUe8vlGN148g3wU1Y8eaNHi/V0i364OO
+lQW996gU4ecLiYMsbg3hmrWdcpOTrC4N47KRM7Nt+6wuDeBhq0rTlYvZXFv
EgWvnrOQ56PBPQ5sKJUrX/HJ/hwYjx1CB3KGcH8GGDVfaxV2DOL1OmDrHCKQ
tw/g/XRBJL83GpHdh3t6UFz3x6wi+x7c04M7Kbl3Jo534p4+mObb2a3c1YZ7
BlDZt2dxbEwT7hlCo4vP09s5j3DPCEKbyg6tNq/GPSNYYS76ymzzFdwzhlUC
xftuPQWMtmcC50xv1ems/I3R9mZCnN+Uee2ux4y2ZwoLw6XHPY48ZbQ9U3gh
H17vFdDOaHuzwGvuClXkSCfuvQe5laqpoMwe3DODRyULBSt0+nHPHAoXtD+T
uCnwfHOouN+dsN1Zifvm0MJ93PGyZ4j5d7nQApakzXD32KbG+1kA6+i98psj
GtzjwgmQeao3srjHBalqj+W2hyzucSFA5WYWNsXi32MJU56mFzI7WdyzhJ+G
bI9CDIt7ViA83zl6skiDe1YgsW2ZtyFXjXtW0GwnvbHOW4V71uDGLQ9kLylx
zxpi9FedS5QqcM8GgotNttT+0I97NlA6msULEvbing3kyhI2ueV04R4P6jrS
ZSblz3CPB3MrZkaI1M24x4dKcXHaiy457vFh97iwefY2Ge7xYX793bYQ75vM
f7UPI+K9ind1jNvMUu8J4cfOlu5mqXepsfOT+Rka6v2NuG0gMF5NvW9NCjVw
tFZR71ahPmvsDyip94zsnICseAX1vlf02fMo37fe53VnZLn39lDvpw1umjlu
7qLeLT6WGdw2fEa9P473yHzu0ky9h/kt+7Rkgfyt92DL8i+qaqj3/LEa/6a5
N6h3oU1YTUJ/NkO8px8Uj4wlVTLEe8J7S/xHreoZ4r3I21Xye/ET8v+Bfuz2
YHvxnwzxXvejSK/EoZMh3mMKUn05Td0M8d7r7MKzDehjiPdU+felUtEAQ7wn
nUphX4sHGeI9ZuTEq0tRQwzxnqe7r8RRo2KId7+Y4GNF9hqGeK+Dy202XHJe
jaChL+WuXiE570Zglxe0UfmGnG9jKHsg6TZ8yVLvZTPznaLPs9S7zt0P7+kM
a6j3sDlVunGv1dT7TqeG0rU3VNS7W2tSgXjxEPWuuNqWfNF/kHofuO8a/tR9
gHqvsmszyFP2Uu8RgkiX0Yhu6n2+LE11+KMO6n27h03Gr3mt1Pu16vDE4OuN
1HukZ0hg6Hgd9Z52Zudyw7Jy6t01cut697BvqfcvYUvIjn1liHiPsEl0uNwh
Q8R76+aomBSHBkS8X9/dm17r0oKId02k207BBDmP1tC+Kg5FV5Dzag2ni5dE
7/fvRcS7zxPDNQcL+hHxnmzydWq0XIGI92WTs7Je31Qi4t0hNt9AEKRCxPvS
rWNrBwqINz6M2n5ufEtC7jc+lIo2hbFHyX3Fh0c/x8MvPSzSZBf6qhaNkXuK
wzZxLU60coHzjkHWk+dEvmv/5CJjeNf7vwGfaqet
   "], {{
     {RGBColor[1, 0.5, 0], Opacity[0.5], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{63, 132, 131, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 
        44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 
        61, 62}},
        VertexColors->None]]}, 
     {RGBColor[1, 0.5, 0], Opacity[0.5], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{1, 131, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 
        20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2}},
        VertexColors->None]]}, 
     {RGBColor[1, 0.5, 0], Opacity[0.5], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{128, 127, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 
        92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 
        107, 108, 109, 110, 111}},
        VertexColors->None]]}, 
     {RGBColor[1, 0.5, 0], Opacity[0.5], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{128, 130, 126, 125, 124, 123, 122, 121, 120, 119, 118, 
         117, 116, 115, 114, 113, 112}},
         VertexColors->None], 
        PolygonBox[{{64, 129, 127, 79, 78, 77, 76, 75, 74, 73, 72, 71, 70, 69,
          68, 67, 66, 65}},
         VertexColors->None]}]}, {}, {}, {}, {}, {}, {}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
       19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 131, 33, 34, 
       35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52,
        53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63}]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], 
      LineBox[{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
        127, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 
       96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 
       111, 128, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 
       124, 125, 126}]}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 6.2}, {-0.9999232575641008, 1.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->384458003]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1711066621],

Cell["Fill with red below the axis, and blue above:", "ExampleText",
 CellID->943182170],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Sin", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
   RowBox[{"FillingStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1485932683],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxd038s1GEcB/Dzq/w4uTs/7lCZH7VafsTZTsyezxEp1kbClLVJmZoyrDYz
S6vWWPoj5WhGltXawkp0h86UXYeTYxxDjuO6cz++FJYxV9d9/NN7e/bs2fP5
vD7PP49v9s2UK9Y0Go3/d5n3/1NXa46QBA5WDrZUCYnlLCXdo9H+pnwpCeea
M0bCRaKnMu0o3k+R67nHtJH6SWJRlGTFLrFY0/Id61Ukk9/MfsRcILlXzVET
oWd83o36RezXEtmOuK96TU1kQ+boCf91lsCGqUVvhRjpDo9TDctYv0oiLgcl
9d/To/+L9J/3aoodM2D/Gkk82L95e9yI8zaIzfzJOdlDCr3fpDI/8HmJjkJv
k/THKCXl2xR6W6RDEKLo7KLQ2yYr7j3lfUcp9HZIeoSXDzvBiB4N4tvlyxuc
3fk02CrUkbwGHfpWYK94M8Wd02K/NfiFZATJZ37gPBsQyD+v59QvoWcLbQPf
nFsPq9Czha77jV3bZUr07ID+KiAgNHMavT3Qu5TlX1gwjt5eGDueMPGxYRg9
e7gw3pEfwehDzx6CGYK7Lmea0XOAsCDNCZ7qrdjiOUINvXPAOvSL2OI5QXGS
iSHNHBFbPDr4ZIvKooomxBaPDqvylVh+yozY4jkD3ztYf21Nid4+aOzVm9Kq
Vei5wPB7n6BgazV6DGg5ODMr5GmwngE9XxdKzoUso8+ASdbI3E+VTvyvncuE
QxVWkVHJBpzHBOpIXOiDIiN6LLgDkmjDKQo9Foj0Wa7JQxR6LEjR81wumSh8
jyuYoul11UoKPVd4qfO7BQUUem7ArVWul7ca0XMDod/k/vhGA3puoAgQvYuJ
06PnDjxWdyr1Yhk9dyiwC6spFWnQ84D0Nsez0idq9Dygff0ZO427iJ4HNEpK
TvMa5tFjw8BclcSxexY9Nnj3OOUIDAr0ONDb1FaxOi9HjwMXt7gKz2QJehw4
IPs0nRH3QVzKCVfv+DrA7n/fvd89/wHFcdab
   "], {{
     {RGBColor[1, 0, 0], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{63, 65, 64, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 
        44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 
        61, 62}},
        VertexColors->None]]}, 
     {RGBColor[0, 0, 1], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{1, 64, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20,
         19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2}},
        VertexColors->None]]}, {}, {}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
       19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 64, 33, 34, 35,
        36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 
       53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63}]}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 6.2}, {-0.9999232575641008, 0.9995736030415051}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->341128309]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4485],

Cell[TextData[{
 "Use a variable filling style obtained from ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->23592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Sin", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "->", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"Hue", "[", "y", "]"}]}], "]"}]}], ",", 
   RowBox[{"Filling", "->", "Axis"}], ",", 
   RowBox[{"FillingStyle", "->", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31022],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24042258]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "InterpolationOrder",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->72517662],

Cell["Points are normally joined with straight lines:", "ExampleText",
 CellID->1440267227],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "4", ",", "2", ",", "3", ",", "10", ",", "8", ",", "2"}], 
     "}"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "Full"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->94906264],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 1.}, {2., 4.}, {3., 2.}, {4., 3.}, {5., 10.}, {6., 
   8.}, {7., 2.}, {1., 1.}, {2., 4.}, {3., 2.}, {4., 3.}, {5., 10.}, {6., 
   8.}, {7., 2.}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[{8, 9, 10, 11, 12, 13, 14}]}}, {
     {Hue[0.67, 0.6, 0.6], PointBox[{1, 2, 3, 4, 5, 6, 7}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 7.}, {0., 10.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->242960924]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->123537426],

Cell["Use quadratic spline interpolation to fit the data:", "ExampleText",
 CellID->135615205],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "4", ",", "2", ",", "3", ",", "10", ",", "8", ",", "2"}], 
     "}"}], "}"}], ",", 
   RowBox[{"InterpolationOrder", "\[Rule]", "2"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "Full"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->86516259],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx9lHtsU1Ucx/tcV1t6+14fc2xtCeAyZ2ZmFI3nKzFkLKF7oAxX/xjFZWOa
Kj5Kg0aQILMO5gPDHJMEF0oEx6SMxoAdr9XUByRWEhmMbCZggu6BPNaNdlS7
3l8xusSTc/PNvfec8/t9ft9zTpH75dpGkUAgWJV+ZpVvf7J/qwC8qElz8f/f
9aQOUhNpIWn+f+b/Ey+oezzdb7DnP7V8PZF7i7kXetP9JuNe1McvbY4z/ezv
4C1m8o2HI00J9q1zLOIcu802nAwoevpTzJuZEGc79xasrzgtRGa6e4p1pp7b
+5hLgkH/nnSfZv3N5468a5bh/dnXwTss5Ct+4Vm/HJnldUnm2RM+v7VDgdnV
I84ZNvrLZqH+6XnIDPffZSULfOOiD1SoygxIsfL3ujtqfNw9rr8yjaN4AlQs
q9DJdGrwfEJcKXlG8dYfHMUXInmlsnf5Cg48rwgXel/nNjhVlI8YvvbYg5IJ
JXh+MS5vWaO8UZzNT4L6ha3tNoscfD0kOD//Y2vcLqN8peiW/dZZ7ZKCr08O
+oc3yctOiSn/HJQE3C27a0VULxnG6neE/VrhHL95nlycWfTGukR5ivySY8FD
G0Oi6AzjeeQoNXJXTX1J8u8+DF56ePKJRILxPArY3r52zfNZgvxUQC0oOdnb
mWA8jxIjP+1f5BEnyV8lUh89srxu6QzjeeYh2PdObKgp67cKcUvk17vHBMSj
QoMysN3Vl+XhoOldO5ZTKJ2zX/l4aiwRbYwuW6nAxQyfGuGjsaVDZo7qqcZA
m/jY8AEN+adBpWHHQW96n/P5aDDplXpDHxrJTw0GDr9k7ao3U721OF1brn50
RT75q0Vxv8pwXTSf8tVCcipU1RwqJL91OHguUOc5U0T567C9ta7b/4UNOn4A
9o//UHq8yX7vvPH7zU48erSdiGtd6x3klx7Vi79q/vEbB/Ho4cRiYc2Ig3gM
2CZuvDw65CAeA6ZedSe6gg5kpg8a8Hl7kWtNg4N4jFjye+nZllE78RiRujlc
EGu0I7N8xIh9T4YLB362EU8eis9GYyizEU8ePukSllVuLSKePAz3rHtq5Lvs
/WCCkO4LnscEywP+odUrC4jHhKkLHsP3bfnEY8IuefBQ9QEL8ZgxfaJq3/Uv
TcRjxv3TlXcCO7P+mCENdfe81qAnHgs6ru5e67ZqiceCduxK1k1y5I8F04cm
cFSlJB4rXtGwjotbconHitstralojZTOpxXbjke9m94Uzbnv/gb74g3o
   "], {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 
       24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
        42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 
       59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76,
        77, 78, 79, 80, 81, 82, 83, 84, 85, 86}]}}, {
     {Hue[0.67, 0.6, 0.6], PointBox[{1, 2, 3, 4, 5, 6, 7}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{1., 0},
  PlotRange->{{1., 7.}, {0., 10.436164890561624`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24767911]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1824315780],

Cell["Use flat regions with steps at each data point:", "ExampleText",
 CellID->804600968],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "4", ",", "2", ",", "3", ",", "10", ",", "8", ",", "2"}], 
     "}"}], "}"}], ",", 
   RowBox[{"InterpolationOrder", "\[Rule]", "0"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "Full"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->57081524],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 1.}, {2., 4.}, {3., 2.}, {4., 3.}, {5., 10.}, {6., 
   8.}, {7., 2.}, {2., 1.}, {1., 1.}, {2., 4.}, {3., 4.}, {3., 2.}, {4., 
   2.}, {4., 3.}, {5., 3.}, {5., 10.}, {6., 10.}, {6., 8.}, {7., 8.}, {7., 
   2.}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{9, 8, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20}]}}, {
     {Hue[0.67, 0.6, 0.6], PointBox[{1, 2, 3, 4, 5, 6, 7}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 7.}, {0., 10.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->124207887]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MaxPlotPoints",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->265503371],

Cell["All points are included by default:", "ExampleText",
 CellID->517132780],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"10", "x"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", 
      RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->823101385],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxVkntIU3EUx6eJrhIVtDAQWzFlpKlpqenUr69tPlci0j+ZGD4CzR4WRYrT
FMIkU5HUWumojJBaGoISTabD0si5qKVT2mTTNZ0aPjHLCs/9ox9cLp/75XM4
9/zOgeyitBxbFosV9ff5994+i1Gs/w/mHXfWplst9J0NwetRy6q7ldgFSZ+7
C0NdlMRueOE5MdkTYlZsszuCmvUr5S/niT3wSiav/mEYJebAaVehkm1vIv8g
bozwWjXPFoi5qPN3DPbOGif2Rpp4aeVhvoF8HmYb/K7Obi0QH0JTjnatxYfJ
fWGvKhfZGRnfD8LMkkCnLqZ+AMzKjxd5I0biI1jnnGHbFmrID4TPrZiOgX6m
/yB4e7rm72Uz/3cUI5UrvMP+/eQfg55/euVrMDOfYFi18t1TKmZ+IVjuOf9I
xqkgPxSupVw1322W+Dhs3PZdL9uYIw6DVOK5NL3YRxyOm179G/pcM9XjI6DX
JG9rmSeOQJNbfHhVxihxJLbeP+WU8k3kRyHirkfZspSZF1C+ie4+3dg2S4Dc
nJi6hCcG8qMRmh3NE27RvCTRaCsNVUfO6ymPgXm4RnQqT0d+DAYMNTbtb5j6
sXD+XiuavGekPBbSFqGla01Dfhws9nYF57TUvyQOrDLbO2vaGcrjodJcOatI
GSA/Hlbn5C1uupXqC+B6st1lWmqhXIBouXRPMaeefCF23I9waAmbpfpCNLrL
+Jd1c5SLsLo6vl4iU1AuwnNxx4fqRuZ+E6DNqxBxq+j+JQl4923TpBhSU56I
zhNTxZWXaH8liRh8zHUormf2Kwnh1+YufMkYozwJQ4Px9c0GZj+TUdDaWfv7
F81Lkgyju1fvbbme8hS0xk427LfoyE9BRrfrxAMVUz8Vw47N2bws2l9JKpR6
Qb5dxSfyxfjZLlIXWZj+xRD7vhVkts8o/gDKqD5m
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 63.}, {-0.9999902065507035, 0.9999118601072672}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->455909126]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->584314051],

Cell["Uniformly spaced data is downsampled: ", "ExampleText",
 CellID->284070523],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"2", "Pi", " ", 
         RowBox[{"n", "/", "10"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "100"}], "}"}]}], "]"}], ",", 
     RowBox[{"MaxPlotPoints", "\[Rule]", "mp"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"mp", ",", 
     RowBox[{"{", 
      RowBox[{"Infinity", ",", "50", ",", "30"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->455487916],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxdkUlKA1EURR/iwJEIZuDAgR0iImLfa70kZRrTWFWpJjpwIDrOyPnfmX8H
2YMLEHdgQyrCO4EQTnJz38nN6vMoeZ0RkZff59/r5PEVPD2+za6PP4LyDf1O
w8X50WfJc+AFtfmKinksTT9/n/Dy9Pslr4DXkN9A3ybubcFnG7yD/C769nBv
Hz4H4EPkj9B3jHsn8DkFnyF/jr4L3LuEzxX4Gvkb9AW4p9bHgaVq866Kvpq9
52rwqVt2dfiFts+F8LuFH1ga8GvArwm/Jvxa8GvBrw2/Nvzu4AeWDvw68OvC
rwu/Hvx68OvDrw+/e/iBJbJ5jdAX2Xs+gl9sWWP8ntj2+Rh+ifVRsEts3ifY
b2Dv6QB7gT3ykto+TfF/pdbHgyXDfhn2y7Bfhv1y7Jdjvxz75divwH5gV2C/
AvsNsd8Q+4E98vLw3/cDQRFneQ==
       "]]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 100.}, {-0.9510565162951535, 0.9510565162951535}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{1., 0.5877852522924731}, {2., 0.9510565162951535}, {3., 
       0.9510565162951535}, {4., 0.5877852522924731}, {
       6., -0.5877852522924731}, {7., -0.9510565162951535}, {
       9., -0.5877852522924731}, {10., 0.}, {12., 0.9510565162951535}, {13., 
       0.9510565162951535}, {15., 0.}, {16., -0.5877852522924731}, {
       18., -0.9510565162951535}, {19., -0.5877852522924731}, {21., 
       0.5877852522924731}, {22., 0.9510565162951535}, {24., 
       0.5877852522924731}, {25., 0.}, {27., -0.9510565162951535}, {
       28., -0.9510565162951535}, {30., 0.}, {31., 0.5877852522924731}, {33., 
       0.9510565162951535}, {34., 0.5877852522924731}, {
       36., -0.5877852522924731}, {37., -0.9510565162951535}, {
       39., -0.5877852522924731}, {40., 0.}, {42., 0.9510565162951535}, {43., 
       0.9510565162951535}, {45., 0.}, {48., -0.9510565162951535}, {51., 
       0.5877852522924731}, {54., 0.5877852522924731}, {
       57., -0.9510565162951535}, {60., 0.}, {63., 0.9510565162951535}, {
       66., -0.5877852522924731}, {69., -0.5877852522924731}, {72., 
       0.9510565162951535}, {75., 0.}, {78., -0.9510565162951535}, {81., 
       0.5877852522924731}, {84., 0.5877852522924731}, {
       87., -0.9510565162951535}, {90., 0.}, {93., 0.9510565162951535}, {
       96., -0.5877852522924731}, {99., -0.5877852522924731}, {100., 0.}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 100.}, {-0.9510565162951535, 0.9510565162951535}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{1., 0.5877852522924731}, {2., 0.9510565162951535}, {4., 
       0.5877852522924731}, {5., 0.}, {7., -0.9510565162951535}, {
       8., -0.9510565162951535}, {9., -0.5877852522924731}, {12., 
       0.9510565162951535}, {16., -0.5877852522924731}, {20., 0.}, {24., 
       0.5877852522924731}, {28., -0.9510565162951535}, {32., 
       0.9510565162951535}, {36., -0.5877852522924731}, {40., 0.}, {44., 
       0.5877852522924731}, {48., -0.9510565162951535}, {52., 
       0.9510565162951535}, {56., -0.5877852522924731}, {60., 0.}, {64., 
       0.5877852522924731}, {68., -0.9510565162951535}, {72., 
       0.9510565162951535}, {76., -0.5877852522924731}, {80., 0.}, {84., 
       0.5877852522924731}, {88., -0.9510565162951535}, {92., 
       0.9510565162951535}, {96., -0.5877852522924731}, {100., 0.}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 100.}, {-0.9510565162951535, 0.9510565162951535}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{491, 80},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->909746607]
}, Open  ]],

Cell[TextData[{
 "In this case, downsampling from ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "6"], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "3"], TraditionalForm]], "InlineMath"],
 " points: "
}], "ExampleText",
 CellID->445067901],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"Range", "[", 
       SuperscriptBox["10", "6"], "]"}], "2.", 
      RowBox[{"Pi", "/", 
       SuperscriptBox["10", "5"]}]}], "]"}], "+", 
    RowBox[{"RandomReal", "[", 
     RowBox[{"0.3", ",", 
      SuperscriptBox["10", "6"]}], "]"}]}], ",", 
   RowBox[{"MaxPlotPoints", "\[Rule]", 
    SuperscriptBox["10", "3"]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->38288660],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 124},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[2]=",
 CellID->220238894]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1651286241],

Cell["\<\
Nonuniform data topologically subsampled, to preserve features: \
\>", "ExampleText",
 CellID->998613596],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"n", ",", 
         RowBox[{"Sin", "[", 
          RowBox[{"2", "Pi", " ", 
           RowBox[{"n", "/", "10"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "100"}], "}"}]}], "]"}], ",", 
     RowBox[{"MaxPlotPoints", "\[Rule]", "mp"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"mp", ",", 
     RowBox[{"{", 
      RowBox[{"Infinity", ",", "50", ",", "30"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1127695697],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxdkUlKA1EURR/iwJEIZuDAgR0iImLfa70kZRrTWFWpJjpwIDrOyPnfmX8H
2YMLEHdgQyrCO4EQTnJz38nN6vMoeZ0RkZff59/r5PEVPD2+za6PP4LyDf1O
w8X50WfJc+AFtfmKinksTT9/n/Dy9Pslr4DXkN9A3ybubcFnG7yD/C769nBv
Hz4H4EPkj9B3jHsn8DkFnyF/jr4L3LuEzxX4Gvkb9AW4p9bHgaVq866Kvpq9
52rwqVt2dfiFts+F8LuFH1ga8GvArwm/Jvxa8GvBrw2/Nvzu4AeWDvw68OvC
rwu/Hvx68OvDrw+/e/iBJbJ5jdAX2Xs+gl9sWWP8ntj2+Rh+ifVRsEts3ifY
b2Dv6QB7gT3ykto+TfF/pdbHgyXDfhn2y7Bfhv1y7Jdjvxz75divwH5gV2C/
AvsNsd8Q+4E98vLw3/cDQRFneQ==
       "]]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 100.}, {-0.9510565162951535, 0.9510565162951535}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{1., 0.5877852522924731}, {3., 0.9510565162951535}, {4., 
       0.5877852522924731}, {6., -0.5877852522924731}, {
       7., -0.9510565162951535}, {9., -0.5877852522924731}, {12., 
       0.9510565162951535}, {14., 0.5877852522924731}, {
       17., -0.9510565162951535}, {19., -0.5877852522924731}, {22., 
       0.9510565162951535}, {24., 0.5877852522924731}, {
       27., -0.9510565162951535}, {29., -0.5877852522924731}, {31., 
       0.5877852522924731}, {32., 0.9510565162951535}, {34., 
       0.5877852522924731}, {36., -0.5877852522924731}, {
       37., -0.9510565162951535}, {39., -0.5877852522924731}, {42., 
       0.9510565162951535}, {44., 0.5877852522924731}, {
       47., -0.9510565162951535}, {49., -0.5877852522924731}, {51., 
       0.5877852522924731}, {52., 0.9510565162951535}, {54., 
       0.5877852522924731}, {57., -0.9510565162951535}, {
       59., -0.5877852522924731}, {62., 0.9510565162951535}, {64., 
       0.5877852522924731}, {67., -0.9510565162951535}, {
       69., -0.5877852522924731}, {71., 0.5877852522924731}, {72., 
       0.9510565162951535}, {74., 0.5877852522924731}, {
       76., -0.5877852522924731}, {77., -0.9510565162951535}, {
       79., -0.5877852522924731}, {81., 0.5877852522924731}, {82., 
       0.9510565162951535}, {84., 0.5877852522924731}, {
       86., -0.5877852522924731}, {87., -0.9510565162951535}, {
       89., -0.5877852522924731}, {92., 0.9510565162951535}, {94., 
       0.5877852522924731}, {97., -0.9510565162951535}, {
       98., -0.9510565162951535}, {100., 0.}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 100.}, {-0.9510565162951535, 0.9510565162951535}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{1., 0.5877852522924731}, {3., 0.9510565162951535}, {
       7., -0.9510565162951535}, {9., -0.5877852522924731}, {12., 
       0.9510565162951535}, {17., -0.9510565162951535}, {22., 
       0.9510565162951535}, {27., -0.9510565162951535}, {32., 
       0.9510565162951535}, {34., 0.5877852522924731}, {
       37., -0.9510565162951535}, {39., -0.5877852522924731}, {42., 
       0.9510565162951535}, {47., -0.9510565162951535}, {52., 
       0.9510565162951535}, {57., -0.9510565162951535}, {
       59., -0.5877852522924731}, {62., 0.9510565162951535}, {
       67., -0.9510565162951535}, {72., 0.9510565162951535}, {74., 
       0.5877852522924731}, {77., -0.9510565162951535}, {
       79., -0.5877852522924731}, {82., 0.9510565162951535}, {84., 
       0.5877852522924731}, {87., -0.9510565162951535}, {
       89., -0.5877852522924731}, {92., 0.9510565162951535}, {
       97., -0.9510565162951535}, {100., 0.}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 100.}, {-0.9510565162951535, 0.9510565162951535}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{491, 80},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->579551144]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"Sqrt", "[", "n", "]"}], 
          RowBox[{"Cos", "[", 
           RowBox[{"n", "/", "5"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"Sqrt", "[", "n", "]"}], 
          RowBox[{"Sin", "[", 
           RowBox[{"n", "/", "5"}], "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "100"}], "}"}]}], "]"}], ",", 
     RowBox[{"MaxPlotPoints", "\[Rule]", "mp"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"mp", ",", 
     RowBox[{"{", 
      RowBox[{"Infinity", ",", "50", ",", "30"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->331109889],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVknk81AkfgB3DOGeGOTFjDspuNqV2bd43/b6iIoU3+2EdYR2RvK8c61zK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       "]]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{-8.850576102131257, 9.683457270344118}, {-9.258910312253905, 
     9.129452507276277}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{0.9800665778412416, 0.19866933079506122`}, {1.302576949491724,
        0.550720701129742}, {1.3934134186943308`, 1.4347121817990456`}, {
       0.8875916028085572, 2.2830201809497295`}, {-0.08258872090659658, 
       2.827221092022874}, {-1.95183739464093, 
       2.6814792158212426`}, {-3.089556337640156, 
       1.8586666286743163`}, {-3.834224452203828, 
       0.5465554410325222}, {-3.9862110666613626`, -1.0536229553433645`}, \
{-3.447748323838536, -2.6670267144272426`}, {-2.9231831386202725`, \
-3.3845236500999865`}, {-0.5378646240943149, -4.765574639657622}, {
       1.4183109273161312`, -4.794621373315692}, {
       2.388975649404159, -4.504752528891456}, {
       4.768668538663136, -2.501959305896957}, {
       5.548511573865768, -0.4626222159360848}, {5.618302328209027, 
       0.6593018647334729}, {4.460145885353649, 3.8867851344476083`}, {
       2.6675792519319206`, 5.4666279308786265`}, {-0.9202230129334451, 
       6.257250962400956}, {-3.3653751149554467`, 
       5.5384339244626375`}, {-5.380182395441938, 
       3.879901724499816}, {-6.611711122307876, 
       1.511712947338325}, {-6.822117583325935, -1.2077713687925795`}, \
{-5.933131681105249, -3.8468101661851213`}, {-2.80530437335546, \
-6.717906472468393}, {1.5191492965169309`, -7.327495166487121}, {
       5.533746872626921, -5.32706725597601}, {
       7.291911866049484, -2.7978601354904646`}, {
       7.765285953433609, -1.3039685814492217`}, {7.3160698449154244`, 
       3.3874949482352275`}, {5.50213751969787, 6.060237843049808}, {
       4.219619219869191, 7.084829824301393}, {-0.5290924618741043, 
       8.409522053409932}, {-3.814768584454088, 
       7.6450991260455305`}, {-6.579090314837181, 
       5.631657893481775}, {-8.362127908546453, 
       2.6598527856083582`}, {-8.850576102131257, -0.8168859531067398}, \
{-7.932352413260112, -4.2517978775861955`}, {-5.719785614236866, \
-7.0911249126756335`}, {-4.222188995715799, -8.134686231469313}, \
{-0.7296315618574055, -9.244870890604235}, {
       2.961938968278091, -8.900950373313837}, {
       4.697709421696463, -8.181168998945338}, {
       7.59671839556689, -5.76973739597008}, {
       9.34491160835573, -2.3817277409515807`}, {
       9.683457270344118, -0.4802658570205413}, {9.20244242178898, 
       3.363785586754682}, {7.24035295055077, 6.751095403817871}, {
       4.080820618133919, 9.129452507276277}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{-8.850576102131257, 9.683457270344118}, {-9.244870890604235, 
     9.129452507276277}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{0.9800665778412416, 0.19866933079506122`}, {
       1.3934134186943308`, 1.4347121817990456`}, {-0.08258872090659658, 
       2.827221092022874}, {-1.95183739464093, 
       2.6814792158212426`}, {-3.089556337640156, 
       1.8586666286743163`}, {-3.9862110666613626`, -1.0536229553433645`}, \
{-2.9231831386202725`, -3.3845236500999865`}, {-0.5378646240943149, \
-4.765574639657622}, {2.388975649404159, -4.504752528891456}, {
       4.768668538663136, -2.501959305896957}, {5.618302328209027, 
       0.6593018647334729}, {2.6675792519319206`, 
       5.4666279308786265`}, {-3.3653751149554467`, 
       5.5384339244626375`}, {-6.611711122307876, 
       1.511712947338325}, {-5.933131681105249, -3.8468101661851213`}, \
{-2.80530437335546, -6.717906472468393}, {
       1.5191492965169309`, -7.327495166487121}, {
       5.533746872626921, -5.32706725597601}, {
       7.765285953433609, -1.3039685814492217`}, {7.3160698449154244`, 
       3.3874949482352275`}, {4.219619219869191, 
       7.084829824301393}, {-0.5290924618741043, 
       8.409522053409932}, {-3.814768584454088, 
       7.6450991260455305`}, {-8.362127908546453, 
       2.6598527856083582`}, {-7.932352413260112, -4.2517978775861955`}, \
{-0.7296315618574055, -9.244870890604235}, {
       4.697709421696463, -8.181168998945338}, {
       7.59671839556689, -5.76973739597008}, {9.20244242178898, 
       3.363785586754682}, {4.080820618133919, 9.129452507276277}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{-8.362127908546453, 9.20244242178898}, {-9.244870890604235, 
     9.129452507276277}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{491, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->88304733]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2130429834],

Cell["Points on either side of nonreal data are always included:", \
"ExampleText",
 CellID->1139373607],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "None", ",", "5", ",", "6", ",", "7", ",", 
     "8", ",", "None", ",", "10", ",", "11", ",", "12"}], "}"}], ",", 
   RowBox[{"MaxPlotPoints", "\[Rule]", "3"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->340532550],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[{{1., 1.}, {3., 3.}}], 
     LineBox[{{5., 5.}, {8., 8.}}], LineBox[{{10., 10.}, {12., 12.}}]}}, {
    {Hue[0.67, 0.6, 0.6], 
     PointBox[{{1., 1.}, {3., 3.}, {5., 5.}, {8., 8.}, {10., 10.}, {12., 
      12.}}]}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 12.}, {0., 12.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->349435616]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Mesh",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->9937],

Cell["\<\
The initial and final sampling meshes are typically the same:\
\>", "ExampleText",
 CellID->9407],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "8"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "Full"}]}], "]"}], ",", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "8"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->931680886],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    GraphicsComplexBox[{{1., 0.8414709848078965}, {2., 0.9092974268256817}, {
     3., 0.1411200080598672}, {4., -0.7568024953079282}, {
     5., -0.9589242746631385}, {6., -0.27941549819892586`}, {7., 
     0.6569865987187891}, {8., 0.9893582466233818}, {1., 
     0.8414709848078965}, {2., 0.9092974268256817}, {3., 
     0.1411200080598672}, {4., -0.7568024953079282}, {
     5., -0.9589242746631385}, {6., -0.27941549819892586`}, {7., 
     0.6569865987187891}, {8., 0.9893582466233818}}, {{{}, {}, 
       {Hue[0.67, 0.6, 0.6], LineBox[{9, 10, 11, 12, 13, 14, 15, 16}]}}, {
       {Hue[0.67, 0.6, 0.6], PointBox[{1, 2, 3, 4, 5, 6, 7, 8}]}, {}, {}}}],
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 8.}, {-0.9589242746631385, 0.9893582466233818}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{{}, {}, 
      {Hue[0.67, 0.6, 0.6], 
       LineBox[{{1., 0.8414709848078965}, {2., 0.9092974268256817}, {3., 
        0.1411200080598672}, {4., -0.7568024953079282}, {
        5., -0.9589242746631385}, {6., -0.27941549819892586`}, {7., 
        0.6569865987187891}, {8., 0.9893582466233818}}]}}, {
      {Hue[0.67, 0.6, 0.6], 
       PointBox[{{1., 0.8414709848078965}, {2., 0.9092974268256817}, {3., 
        0.1411200080598672}, {4., -0.7568024953079282}, {
        5., -0.9589242746631385}, {6., -0.27941549819892586`}, {7., 
        0.6569865987187891}, {8., 0.9893582466233818}}]}, {}, {}}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0, 8.}, {-0.9589242746631385, 0.9893582466233818}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{390, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->439688444]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->371721903],

Cell["Interpolated data may introduce points:", "ExampleText",
 CellID->500094598],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "8"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "Full"}], ",", 
     RowBox[{"InterpolationOrder", "\[Rule]", "2"}]}], "]"}], ",", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "8"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "All"}], ",", 
     RowBox[{"InterpolationOrder", "\[Rule]", "2"}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->929117308],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5157091]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->908508703],

Cell[TextData[{
 "Use 20 mesh levels evenly spaced in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->11427],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29355],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxVz3tMU2cYx/EO4+KwG8hmuClsXIwy7hXLxdpfKS0tVAzg0DAZk7lszOCI
GhU0BpwQg8ISZbNzEdBJWFxEpoijgIeBpIJDKAxbAoxLufYKE5xGMkblOX/s
TZqTT7/nPO/7fpDxddLndhwOJ3n5Z3uurFkh5/8L/o/PP64uqaf/16CxR+C9
lNVOdsRWleq7zpke8ns4+MWHM5EmHdkFs6vjj05X/0XegFRRpXPxujHy+6h3
lWYeujpO9kLnv0xL6fwk2Qein9OUq9bNkDfBwn3r291mA3kzwj8LULSdNZH9
0PaR23Vxr5nsj3iPtpfH+yzkQKwajRnuPGclB+N8lv+PuUbWIWiLHlHnL7IO
RZ0ySHu/gTUPs+ub8lu2sN6KPeFuns4ydn4YpLUaw3MXdv9teHXYKMwsN5L5
WKO92c8bZu8TDq+gvQGawSlyBJSa1oUDVyfIkfi1o+vt25v05Cg0FFQ0LJ4e
IW8Ht8rHJyR1gCxA80Sa9+HsPvIO9AbLnv5W/oQsxMd9dVnhji1kINBRecYh
rnLFeUBowHQEX3+LWekiXObe77ALebjiPBGOKpYc21O7qUfDM0N1OurIU+rR
mNPMikVJg9TFELkHmr6aH6EuRkWzaSmlVE89Bk/uegYE2k1Sj0G1x+BQPX+a
ugRNj8Zyk4MM1CXQOXUP/603UpfCt+iNyKhEM3UprJslIYVHLNRjkQe1wBxr
pR4LlSnt3cQ/yBwZkkx8h/QltsuwJOBeKR1huxw3jF7HkM12OXg/jCzk32bn
x6HeS7dBWsHuHwetj+pOtMREPR58p8bd1mvs+eORvTr08ikVez8F9tTYJ7Rf
Yu+vQO3C984pvHHqO1GhzpXzy0ep70THcInavnGIegLcm9YeUJq11BPQfL2m
aG5UQ30X9r3iaV0T1dR3YWPng4G9knvMdE7ZVE6ZA/z8DLcEZT3CFbtD39+u
cewaFR4aqMsaqPNGSH9tcFfrNPUtEPT86Vx8ySzMcCnc71IYhIPX4nwXe630
fiiG0+0SjyVbhb/ctK0wPDhX7C3eaKLvw5F0UvLplROTQl/5RR/5xShUPs+5
N/9wiObtQERKSUbm2kfC7mfbu541AncKvhn7/Z0G5vX8bdHgDbgVZfyjY7it
wdzWGjEs6ilRVP4483o7PwlcLwzODTUbGJlt/A0pOk/cNYbVWJhJ2/4eMpzK
qpLZv7AyZ5d326+U40xE9XrdSQvjZTuPUzw4YelVin0Gpnl5fPAFBQoiNarj
83rmE9v53kyA2vSleuInLfMfKW7eOA==
   "], {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 3, 64, 4, 5, 6, 65, 7, 8, 9, 66, 10, 11, 12, 67, 13, 14, 
       15, 68, 16, 17, 18, 69, 19, 20, 21, 70, 22, 23, 24, 71, 25, 26, 27, 72,
        28, 29, 30, 73, 31, 32, 33, 74, 34, 35, 36, 75, 37, 38, 39, 76, 40, 
       41, 42, 77, 43, 44, 45, 78, 46, 47, 48, 79, 49, 50, 51, 80, 52, 53, 54,
        81, 55, 56, 57, 82, 58, 59, 60, 83, 61, 62, 63}]}}, {
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 
       79, 80, 81, 82, 83}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 63.}, {-0.9999232575641008, 0.9995736030415051}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1235711264]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->314682034],

Cell[TextData[{
 "Use an explicit list of values for the mesh in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->238138513],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Sin", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Range", "[", 
      RowBox[{"0", ",", 
       RowBox[{"2", "Pi"}], ",", 
       RowBox[{"Pi", "/", "4"}]}], "]"}], "}"}]}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", "Medium", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->50003947],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdzntI01EUB/A1s3zMnJu69VI0iyKn2YKZZfdYalYSaD7CsqAnFZaYGUhU
RoVo2R9ZTkO0KIwgkzJtm+snPliaq6bolGbOlsu5x09LS5m1Wr/jP33hcjnc
cz7nBh06k3yUzWKx4v8e5/1/KsqdkZHQt8Vva0tkhKk7SFN39ApHVgfZIHam
h2yQy++oTd34PkBOHV9rirL0E0bRk3HXXbmjtZ+w30AyYh4Jbvp8JsePOWMk
ssXxJ05XfsF5E1H/plpKJ41E3eWMhcQ8zpS6+JjQGyc2jvutFOsY9k+QyMOi
xParFvS/k/bUJQ+29VhxfpLsCmifOd9rw30/iMtw7JC6kEZvmhRnhd7LN9Po
zZD2rXpVwSyNnp00SMO1jQoavVky7qcsaFlDo/ebpEcuCRQk2NBjQXy9ZuyH
cG4/C+w5ZnKiyoz+PHDTPhkQD5lwng3B4XtFGt1X3OcCUk3r1JHKEfTmQ13n
e69nqwzozQfFtWrF7EU9eq7AqQkJicj4iN4CaB7JXJGT3YveQuhZl9D3quod
em6wr7chK5Lbgp4bhHGlV7x3PkLPHdaLRjdKDE8pxvOAMk5jJzuijWI8T8hN
dHA7Mj5QjMeBwEPyi5vO9lGMx4EJzfi2mGQdxXheELM0zHJyUo/eIqhutjjS
Sg3oecO7F4GiMLYRPS7UBugGZZJR7OeC8s3n/D3hY+hzoZ/3YeibwUz9Gxf7
wMqieVGbkqy4zwfo1XER18/a0OPBZVBFW7fT6PFAbsnkJ3XR6PEg2SLxPuig
8T98cERzKkr1NHp8eGgOzoNsGj1fEJfrpwqe2dDzBVlw/7L4ait6vqANkT/f
GmdBzw8kvKYU+v4Yen6Q7bq+7IJ8FD1/SK/z2N1x24ieP9RP3RWkib+g5w/V
qvwdkqph9ATQOVSi8mgaRE8AS5WeR6RWLXpCaH5QVzQxrEFPCPvtYu3iJBV6
Qliufv1xb9xLSiiKTbEHmUhrzkiAsNJImHqGdAUPKgt/0qQ7SHzpwgAbEpQp
/LzyuXd3KNzsmR1xQ7flQGTqmvyT3lCT03a0p8JIMf086NP1Xy6x09S5GoVJ
8csP+Mu3z0xXGak/93YE5g==
   "], {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 64, 9, 10, 11, 12, 13, 14, 15, 16, 65, 
       17, 18, 19, 20, 21, 22, 23, 24, 66, 25, 26, 27, 28, 29, 30, 31, 32, 67,
        33, 34, 35, 36, 37, 38, 39, 40, 68, 41, 42, 43, 44, 45, 46, 47, 48, 
       69, 49, 50, 51, 52, 53, 54, 55, 70, 56, 57, 58, 59, 60, 61, 62, 
       63}]}}, {
     {PointSize[Medium], 
      PointBox[{1, 64, 65, 66, 67, 68, 69, 70}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 6.2}, {-0.9999232575641008, 0.9995736030415051}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->184567595]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3572689],

Cell[TextData[{
 "Specify style and mesh levels in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction: "
}], "ExampleText",
 CellID->378589077],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Sin", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", 
       RowBox[{"2", 
        RowBox[{"Pi", "/", "20"}]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"Hue", "[", 
          RowBox[{"x", "/", 
           RowBox[{"(", 
            RowBox[{"2", "Pi"}], ")"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0.", ",", 
         RowBox[{"2", "Pi"}], ",", 
         RowBox[{"2", 
          RowBox[{"Pi", "/", "8"}]}]}], "}"}]}], "]"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->45007179],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{0., 0.}, {0.3141592653589793, 0.30901699437494745`}, {
   0.6283185307179586, 0.5877852522924731}, {0.9424777960769379, 
   0.8090169943749475}, {1.2566370614359172`, 0.9510565162951535}, {
   1.5707963267948966`, 1.}, {1.8849555921538759`, 0.9510565162951535}, {
   2.199114857512855, 0.8090169943749475}, {2.5132741228718345`, 
   0.5877852522924731}, {2.827433388230814, 0.30901699437494745`}, {
   3.141592653589793, 0.}, {3.455751918948773, -0.30901699437494745`}, {
   3.7699111843077517`, -0.5877852522924731}, {
   4.084070449666731, -0.8090169943749475}, {
   4.39822971502571, -0.9510565162951535}, {4.71238898038469, -1.}, {
   5.026548245743669, -0.9510565162951535}, {
   5.340707511102648, -0.8090169943749475}, {
   5.654866776461628, -0.5877852522924731}, {
   5.969026041820607, -0.30901699437494745`}, {6.283185307179586, 0.}, {
   0.7853981633974483, 0.6984011233337103}, {2.356194490192345, 
   0.6984011233337103}, {3.9269908169872414`, -0.6984011233337103}, {
   5.497787143782138, -0.6984011233337103}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 3, 22, 4, 5, 6, 7, 8, 23, 9, 10, 11, 12, 13, 24, 14, 15, 
       16, 17, 18, 25, 19, 20, 21}]}}, {
     {Hue[0.], PointBox[{1}]}, 
     {Hue[0.125], PointBox[{22}]}, 
     {Hue[0.25], PointBox[{6}]}, 
     {Hue[0.375], PointBox[{23}]}, 
     {Hue[0.5], PointBox[{11}]}, 
     {Hue[0.625], PointBox[{24}]}, 
     {Hue[0.75], PointBox[{16}]}, 
     {Hue[0.875], PointBox[{25}]}, 
     {Hue[1.], PointBox[{21}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 6.283185307179586}, {-1., 1.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->467975428]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MeshFunctions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->208274223],

Cell[TextData[{
 "Use a mesh evenly spaced in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " directions:"
}], "ExampleText",
 CellID->236651916],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Binomial", "[", 
        RowBox[{"15", ",", "k"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", 
     RowBox[{"MeshFunctions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], ",", 
         RowBox[{"Evaluate", "[", "f", "]"}]}], "]"}], "}"}]}], ",", 
     RowBox[{"Mesh", "\[Rule]", "9"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "f"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->237800640],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    GraphicsComplexBox[{{1., 1.}, {2., 15.}, {3., 105.}, {4., 455.}, {5., 
     1365.}, {6., 3003.}, {7., 5005.}, {8., 6435.}, {9., 6435.}, {10., 
     5005.}, {11., 3003.}, {12., 1365.}, {13., 455.}, {14., 105.}, {15., 
     15.}, {16., 1.}, {2.4999847412109375`, 59.998626708984375`}, {
     5.4999847412109375`, 2183.9750061035156`}, {8.499984741210938, 6435.}, {
     11.499984741210938`, 2184.0249938964844`}, {14.499984741210938`, 
     60.001373291015625`}}, {{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{1, 2, 17, 3, 4, 5, 18, 6, 7, 8, 19, 9, 10, 11, 20, 12, 13, 
         14, 21, 15, 16}]}}, {
       {Hue[0.67, 0.6, 0.6], 
        PointBox[{4, 7, 10, 13, 17, 18, 19, 20, 21}]}, {}, {}}}],
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotLabel->FormBox["x", TraditionalForm],
    PlotRange->{{0., 16.}, {0., 6435.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[
    GraphicsComplexBox[{{1., 1.}, {2., 15.}, {3., 105.}, {4., 455.}, {5., 
     1365.}, {6., 3003.}, {7., 5005.}, {8., 6435.}, {9., 6435.}, {10., 
     5005.}, {11., 3003.}, {12., 1365.}, {13., 455.}, {14., 105.}, {15., 
     15.}, {16., 1.}, {4.2081451416015625`, 644.4120788574219}, {
     4.915167038561776, 1287.8020050912164`}, {5.3456573486328125`, 
     1931.1867370605469`}, {5.738456638297066, 2574.5919735305943`}, {
     6.1074066162109375`, 3218.028045654297}, {6.42876801895909, 
     3861.3935739560984`}, {6.750147022452733, 4504.794338950372}, {
     7.1001434326171875`, 5148.205108642578}, {7.5500579855870456`, 
     5791.582919389475}, {9.899856567382812, 5148.205108642578}, {
     9.449942014412954, 5791.582919389475}, {10.892593383789062`, 
     3218.028045654297}, {10.57123198104091, 3861.3935739560984`}, {
     10.249852977547267`, 4504.794338950372}, {11.654342651367188`, 
     1931.1867370605469`}, {11.261543361702934`, 2574.5919735305943`}, {
     12.791854858398438`, 644.4120788574219}, {12.084832961438224`, 
     1287.8020050912164`}}, {{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{1, 2, 3, 4, 17, 18, 5, 19, 20, 6, 21, 22, 23, 7, 24, 25, 8, 
         9, 27, 26, 10, 30, 29, 28, 11, 32, 31, 12, 34, 33, 13, 14, 15, 
         16}]}}, {
       {Hue[0.67, 0.6, 0.6], 
        PointBox[{17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 
         32, 33, 34}]}, {}, {}}}],
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotLabel->FormBox["y", TraditionalForm],
    PlotRange->{{0., 16.}, {0., 6435.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{390, 133},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->320363855]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->450987812],

Cell[TextData[{
 "Show five mesh levels in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction (red) and ten in the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " direction (blue):"
}], "ExampleText",
 CellID->1980240883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"15", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"5", ",", "10"}], "}"}]}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"#1", "&"}], ",", 
      RowBox[{"#2", "&"}]}], "}"}]}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Red"}], "]"}], ",", 
      "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->206959375],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 1.}, {2., 15.}, {3., 105.}, {4., 455.}, {5., 
   1365.}, {6., 3003.}, {7., 5005.}, {8., 6435.}, {9., 6435.}, {10., 5005.}, {
   11., 3003.}, {12., 1365.}, {13., 455.}, {14., 105.}, {15., 15.}, {16., 
   1.}, {3.5, 280.}, {8.5, 6435.}, {13.5, 280.}, {4.143856143856143, 
   585.9090909090909}, {4.786613386613387, 1170.8181818181818`}, {
   5.238539238539238, 1755.7272727272725`}, {5.595626595626595, 
   2340.6363636363635`}, {5.952713952713952, 2925.5454545454545`}, {
   6.253473798928344, 3510.454545454545}, {6.545636181999819, 
   4095.363636363636}, {6.837798565071292, 4680.272727272727}, {
   7.181945327399872, 5265.181818181818}, {7.590972663699937, 
   5850.090909090909}, {9.818054672600127, 5265.181818181818}, {
   9.409027336300063, 5850.090909090909}, {10.746526201071656`, 
   3510.454545454545}, {10.454363818000182`, 4095.363636363636}, {
   10.162201434928708`, 4680.272727272727}, {11.761460761460762`, 
   1755.7272727272725`}, {11.404373404373406`, 2340.6363636363635`}, {
   11.047286047286047`, 2925.5454545454545`}, {12.856143856143856`, 
   585.9090909090909}, {12.213386613386612`, 
   1170.8181818181818`}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 3, 17, 4, 20, 21, 5, 22, 23, 24, 6, 25, 26, 27, 7, 28, 
       29, 8, 18, 9, 31, 30, 10, 34, 33, 32, 11, 37, 36, 35, 12, 39, 38, 13, 
       19, 14, 15, 16}]}}, {
     {RGBColor[1, 0, 0], PointSize[Medium], PointBox[{6, 11, 17, 18, 19}]}, 
     {RGBColor[0, 0, 1], 
      PointBox[{20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
       35, 36, 37, 38, 39}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 16.}, {0., 6435.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->182359206]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MeshShading",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->145776117],

Cell[TextData[{
 "Alternate red and blue segments of equal width in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->1563263586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"15", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1456152504],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 1.}, {2., 15.}, {3., 105.}, {4., 455.}, {5., 
   1365.}, {6., 3003.}, {7., 5005.}, {8., 6435.}, {9., 6435.}, {10., 5005.}, {
   11., 3003.}, {12., 1365.}, {13., 455.}, {14., 105.}, {15., 15.}, {16., 
   1.}, {2.3636363636363633`, 47.7272727272727}, {3.727272727272727, 
   359.54545454545445`}, {5.090909090909091, 1513.9090909090908`}, {
   6.454545454545454, 3912.999999999999}, {7.8181818181818175`, 
   6174.999999999999}, {9.181818181818182, 6175.}, {10.545454545454545`, 
   3913.000000000001}, {11.909090909090908`, 1513.9090909090921`}, {
   13.272727272727272`, 359.54545454545496`}, {14.636363636363635`, 
   47.72727272727286}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      {RGBColor[1, 0, 0], LineBox[{1, 2, 17}]}, 
      {RGBColor[0, 0, 1], LineBox[{17, 3, 18}]}, 
      {RGBColor[1, 0, 0], LineBox[{18, 4, 5, 19}]}, 
      {RGBColor[0, 0, 1], LineBox[{19, 6, 20}]}, 
      {RGBColor[1, 0, 0], LineBox[{20, 7, 21}]}, 
      {RGBColor[0, 0, 1], LineBox[{21, 8, 9, 22}]}, 
      {RGBColor[1, 0, 0], LineBox[{22, 10, 23}]}, 
      {RGBColor[0, 0, 1], LineBox[{23, 11, 24}]}, 
      {RGBColor[1, 0, 0], LineBox[{24, 12, 13, 25}]}, 
      {RGBColor[0, 0, 1], LineBox[{25, 14, 26}]}, 
      {RGBColor[1, 0, 0], LineBox[{26, 15, 16}]}}}, {
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{17, 18, 19, 20, 21, 22, 23, 24, 25, 26}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 16.}, {0., 6435.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->156724962]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->913462102],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " to remove segments:"
}], "ExampleText",
 CellID->1504189831],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"15", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "None"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->740997133],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 1.}, {2., 15.}, {3., 105.}, {4., 455.}, {5., 
   1365.}, {6., 3003.}, {7., 5005.}, {8., 6435.}, {9., 6435.}, {10., 5005.}, {
   11., 3003.}, {12., 1365.}, {13., 455.}, {14., 105.}, {15., 15.}, {16., 
   1.}, {2.3636363636363633`, 47.7272727272727}, {3.727272727272727, 
   359.54545454545445`}, {5.090909090909091, 1513.9090909090908`}, {
   6.454545454545454, 3912.999999999999}, {7.8181818181818175`, 
   6174.999999999999}, {9.181818181818182, 6175.}, {10.545454545454545`, 
   3913.000000000001}, {11.909090909090908`, 1513.9090909090921`}, {
   13.272727272727272`, 359.54545454545496`}, {14.636363636363635`, 
   47.72727272727286}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      {RGBColor[1, 0, 0], LineBox[{1, 2, 17}]}, {}, 
      {RGBColor[1, 0, 0], LineBox[{18, 4, 5, 19}]}, {}, 
      {RGBColor[1, 0, 0], LineBox[{20, 7, 21}]}, {}, 
      {RGBColor[1, 0, 0], LineBox[{22, 10, 23}]}, {}, 
      {RGBColor[1, 0, 0], LineBox[{24, 12, 13, 25}]}, {}, 
      {RGBColor[1, 0, 0], LineBox[{26, 15, 16}]}}}, {
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{17, 18, 19, 20, 21, 22, 23, 24, 25, 26}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 16.}, {0., 6435.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->463855323]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->113916258],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " can be used with ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->101485524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"15", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->914958790],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 1.}, {2., 15.}, {3., 105.}, {4., 455.}, {5., 
   1365.}, {6., 3003.}, {7., 5005.}, {8., 6435.}, {9., 6435.}, {10., 5005.}, {
   11., 3003.}, {12., 1365.}, {13., 455.}, {14., 105.}, {15., 15.}, {16., 
   1.}, {2.3636363636363633`, 47.7272727272727}, {3.727272727272727, 
   359.54545454545445`}, {5.090909090909091, 1513.9090909090908`}, {
   6.454545454545454, 3912.999999999999}, {7.8181818181818175`, 
   6174.999999999999}, {9.181818181818182, 6175.}, {10.545454545454545`, 
   3913.000000000001}, {11.909090909090908`, 1513.9090909090921`}, {
   13.272727272727272`, 359.54545454545496`}, {14.636363636363635`, 
   47.72727272727286}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], Thickness[Large], 
      {RGBColor[1, 0, 0], LineBox[{1, 2, 17}]}, 
      {RGBColor[0, 0, 1], LineBox[{17, 3, 18}]}, 
      {RGBColor[1, 0, 0], LineBox[{18, 4, 5, 19}]}, 
      {RGBColor[0, 0, 1], LineBox[{19, 6, 20}]}, 
      {RGBColor[1, 0, 0], LineBox[{20, 7, 21}]}, 
      {RGBColor[0, 0, 1], LineBox[{21, 8, 9, 22}]}, 
      {RGBColor[1, 0, 0], LineBox[{22, 10, 23}]}, 
      {RGBColor[0, 0, 1], LineBox[{23, 11, 24}]}, 
      {RGBColor[1, 0, 0], LineBox[{24, 12, 13, 25}]}, 
      {RGBColor[0, 0, 1], LineBox[{25, 14, 26}]}, 
      {RGBColor[1, 0, 0], LineBox[{26, 15, 16}]}}}, {
     {Hue[0.67, 0.6, 0.6], Thickness[Large], 
      PointBox[{17, 18, 19, 20, 21, 22, 23, 24, 25, 26}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 16.}, {0., 6435.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->407790868]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->424843825],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " has higher priority than ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " for styling the curve:"
}], "ExampleText",
 CellID->649526388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"15", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Black"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->122170518],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 1.}, {2., 15.}, {3., 105.}, {4., 455.}, {5., 
   1365.}, {6., 3003.}, {7., 5005.}, {8., 6435.}, {9., 6435.}, {10., 5005.}, {
   11., 3003.}, {12., 1365.}, {13., 455.}, {14., 105.}, {15., 15.}, {16., 
   1.}, {2.3636363636363633`, 47.7272727272727}, {3.727272727272727, 
   359.54545454545445`}, {5.090909090909091, 1513.9090909090908`}, {
   6.454545454545454, 3912.999999999999}, {7.8181818181818175`, 
   6174.999999999999}, {9.181818181818182, 6175.}, {10.545454545454545`, 
   3913.000000000001}, {11.909090909090908`, 1513.9090909090921`}, {
   13.272727272727272`, 359.54545454545496`}, {14.636363636363635`, 
   47.72727272727286}}, {{{}, {}, 
     {GrayLevel[0], 
      {RGBColor[1, 0, 0], LineBox[{1, 2, 17}]}, 
      {RGBColor[0, 0, 1], LineBox[{17, 3, 18}]}, 
      {RGBColor[1, 0, 0], LineBox[{18, 4, 5, 19}]}, 
      {RGBColor[0, 0, 1], LineBox[{19, 6, 20}]}, 
      {RGBColor[1, 0, 0], LineBox[{20, 7, 21}]}, 
      {RGBColor[0, 0, 1], LineBox[{21, 8, 9, 22}]}, 
      {RGBColor[1, 0, 0], LineBox[{22, 10, 23}]}, 
      {RGBColor[0, 0, 1], LineBox[{23, 11, 24}]}, 
      {RGBColor[1, 0, 0], LineBox[{24, 12, 13, 25}]}, 
      {RGBColor[0, 0, 1], LineBox[{25, 14, 26}]}, 
      {RGBColor[1, 0, 0], LineBox[{26, 15, 16}]}}}, {
     {GrayLevel[0], 
      PointBox[{17, 18, 19, 20, 21, 22, 23, 24, 25, 26}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 16.}, {0., 6435.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->321725142]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->78638807],

Cell[TextData[{
 "Use the ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " for some segments by setting ",
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->68474456],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"15", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Thick", ",", "Yellow"}], "]"}]}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Automatic"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1946430847],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 1.}, {2., 15.}, {3., 105.}, {4., 455.}, {5., 
   1365.}, {6., 3003.}, {7., 5005.}, {8., 6435.}, {9., 6435.}, {10., 5005.}, {
   11., 3003.}, {12., 1365.}, {13., 455.}, {14., 105.}, {15., 15.}, {16., 
   1.}, {2.3636363636363633`, 47.7272727272727}, {3.727272727272727, 
   359.54545454545445`}, {5.090909090909091, 1513.9090909090908`}, {
   6.454545454545454, 3912.999999999999}, {7.8181818181818175`, 
   6174.999999999999}, {9.181818181818182, 6175.}, {10.545454545454545`, 
   3913.000000000001}, {11.909090909090908`, 1513.9090909090921`}, {
   13.272727272727272`, 359.54545454545496`}, {14.636363636363635`, 
   47.72727272727286}}, {{{}, {}, 
     {RGBColor[1, 1, 0], Thickness[Large], 
      {RGBColor[1, 0, 0], LineBox[{1, 2, 17}]}, LineBox[{17, 3, 18}], 
      {RGBColor[1, 0, 0], LineBox[{18, 4, 5, 19}]}, LineBox[{19, 6, 20}], 
      {RGBColor[1, 0, 0], LineBox[{20, 7, 21}]}, LineBox[{21, 8, 9, 22}], 
      {RGBColor[1, 0, 0], LineBox[{22, 10, 23}]}, LineBox[{23, 11, 24}], 
      {RGBColor[1, 0, 0], LineBox[{24, 12, 13, 25}]}, LineBox[{25, 14, 26}], 
      {RGBColor[1, 0, 0], LineBox[{26, 15, 16}]}}}, {
     {RGBColor[1, 1, 0], Thickness[Large], 
      PointBox[{17, 18, 19, 20, 21, 22, 23, 24, 25, 26}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 16.}, {0., 6435.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->846292163]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13901850],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " can be used with ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1974674987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"15", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Black", ",", "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]",
    
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"Hue", "[", "x", "]"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1920453998],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVmetOE0EYhge2VFJAUVQQEZFDC7RAOZdDOVPQeIr6wxh/SIgJ/DAS5Ca8
AhP/eBMk3gP34WVMdL6Zd9rZ3Wm77e6aQGS/nZ1n3nd35pthZ31xdHHy+cvR
xenx0dDB+dHZyenxt6HS13NxyWlhjF2K37M+Js7/ijP5e8k5FxXGcU8cHVGV
RWwVsVXECZRZQmL46ZCFAzpSJZc/kmWJSlmpmETGU3Y85fZrqbuPvsoF06sQ
aNdRVjHZbDC1NlONxqZTxhK0JxEdYzxbMZwUU9ybCeax1+P4U17tEcdf+n58
TFIcuqi2uPYjwb8L6kr1k4cxyzfq1HfX4b1lL096Sc6u6J660Bv+O78nDo64
4zZxx8fUP38YbxOteqx0vzgkBPmJoiD7rNQAqI+g+q3UILkJiu7vvRx3gYpz
8U+cDFjbDFEbAdAovuOYtaL8yEoPg3iL+NhKjSAr3iA+sVKjqH0NreoUFV+B
HrZSY6h9iTgiKfdqo9cixxPbPFppXH8OZ6Uls7TqPGJ1ynTqLaeh/wxxNCaf
DPSf4rnGIvQx14JDxHRMz6F9SnieOH2oqNfjjGrnVHLJm0HVMkmvmnuI49yW
u1nU7sC3OkXFbaPX/VQOtVu8sm7bKeZ84EytDWyTqzXATk+hdgPXsaJU0Za0
kN5Qd8CzVmoaVNFFJRqYpVphHQo5NTxJFcxj2HwgJ+qsNZdT9Hk3gydahc+U
bOc0oFprluZjUzfL2mXF5cKSZj9F01vaqQCnad7sLM1jfJddSt6MnYXfEqiZ
ENQcqMVA1AKofAhqHhTRTiCKtGat1AKoWRflNNDjWiEPhblYcvH/uCxyrKWM
yyZT6OE5Xz7Klg3OBO1IvahyCiufqJ3n8axDi/IJsJKXfaLuN/006i9Wji80
nEV2BW+2LuFpsjWpZWhNgloMSZHjRE2qAK1xUEshKXLM1KRWoJUGtWzLn4B9
H0grgixZ0WW8c8j3fHGi/MhKbdp8k6php1Uoj6rrOf2Wo5x8SiHmMd4jyvuf
Ao9ypfA+k97BxOukn0nvDwshcsvUoihzwJfNwSi8HcpdrhOIorgagiqidhCO
9SmdE0GpRtZIvIXL7wdORaHG6DYzd0wXiuvXzMXcMT10qccxVzbh0I9YdDmV
W0TkRMUHLif9xEF3Wrpn+hDlPtCXq1vw6q1J6d3rfcTNENQOau/CuT6lx9lP
7aL2DrTqUxS3rZTe7d92Uc3sTLRSN+KOkohhN6W/29+K3Ul/VbmJuBupk/l9
qMvl4EQ4g/VX8U7EPdcIl1tE5GS+/9A3fnpLUY6NzuQDtE55VJWaN48lzfjv
lIxXfN9KHYJql71ei0oxfkU6pSYJ9b8GrOUfN7zJ/w==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->623154150]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MeshStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->291423660],

Cell["Color the mesh the same color as the plot:", "ExampleText",
 CellID->124974016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"15", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->199280146],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 1.}, {2., 15.}, {3., 105.}, {4., 455.}, {5., 
   1365.}, {6., 3003.}, {7., 5005.}, {8., 6435.}, {9., 6435.}, {10., 5005.}, {
   11., 3003.}, {12., 1365.}, {13., 455.}, {14., 105.}, {15., 15.}, {16., 
   1.}, {2.3636363636363633`, 47.7272727272727}, {3.727272727272727, 
   359.54545454545445`}, {5.090909090909091, 1513.9090909090908`}, {
   6.454545454545454, 3912.999999999999}, {7.8181818181818175`, 
   6174.999999999999}, {9.181818181818182, 6175.}, {10.545454545454545`, 
   3913.000000000001}, {11.909090909090908`, 1513.9090909090921`}, {
   13.272727272727272`, 359.54545454545496`}, {14.636363636363635`, 
   47.72727272727286}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 17, 3, 18, 4, 5, 19, 6, 20, 7, 21, 8, 9, 22, 10, 23, 11, 
       24, 12, 13, 25, 14, 26, 15, 16}]}}, {
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{17, 18, 19, 20, 21, 22, 23, 24, 25, 26}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 16.}, {0., 6435.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25842975]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->751885160],

Cell[TextData[{
 "Use a red mesh in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->542506413],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"15", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", "Red"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1343653111],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 1.}, {2., 15.}, {3., 105.}, {4., 455.}, {5., 
   1365.}, {6., 3003.}, {7., 5005.}, {8., 6435.}, {9., 6435.}, {10., 5005.}, {
   11., 3003.}, {12., 1365.}, {13., 455.}, {14., 105.}, {15., 15.}, {16., 
   1.}, {2.3636363636363633`, 47.7272727272727}, {3.727272727272727, 
   359.54545454545445`}, {5.090909090909091, 1513.9090909090908`}, {
   6.454545454545454, 3912.999999999999}, {7.8181818181818175`, 
   6174.999999999999}, {9.181818181818182, 6175.}, {10.545454545454545`, 
   3913.000000000001}, {11.909090909090908`, 1513.9090909090921`}, {
   13.272727272727272`, 359.54545454545496`}, {14.636363636363635`, 
   47.72727272727286}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 17, 3, 18, 4, 5, 19, 6, 20, 7, 21, 8, 9, 22, 10, 23, 11, 
       24, 12, 13, 25, 14, 26, 15, 16}]}}, {
     {RGBColor[1, 0, 0], 
      PointBox[{17, 18, 19, 20, 21, 22, 23, 24, 25, 26}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 16.}, {0., 6435.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->239763510]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->643903660],

Cell[TextData[{
 "Use a red mesh in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction and a blue mesh in the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->1837201776],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"15", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"#1", "&"}], ",", 
      RowBox[{"#2", "&"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1330372666],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 1.}, {2., 15.}, {3., 105.}, {4., 455.}, {5., 
   1365.}, {6., 3003.}, {7., 5005.}, {8., 6435.}, {9., 6435.}, {10., 5005.}, {
   11., 3003.}, {12., 1365.}, {13., 455.}, {14., 105.}, {15., 15.}, {16., 
   1.}, {2.3636363636363633`, 47.7272727272727}, {3.727272727272727, 
   359.54545454545445`}, {5.090909090909091, 1513.9090909090908`}, {
   6.454545454545454, 3912.999999999999}, {7.8181818181818175`, 
   6174.999999999999}, {9.181818181818182, 6175.}, {10.545454545454545`, 
   3913.000000000001}, {11.909090909090908`, 1513.9090909090921`}, {
   13.272727272727272`, 359.54545454545496`}, {14.636363636363635`, 
   47.72727272727286}, {4.143856143856143, 585.9090909090909}, {
   4.786613386613387, 1170.8181818181818`}, {6.253473798928344, 
   3510.454545454545}, {7.181945327399872, 5265.181818181818}, {
   7.590972663699936, 5850.090909090909}, {10.454363818000182`, 
   4095.363636363636}, {10.162201434928708`, 4680.272727272727}, {
   11.76146076146076, 1755.7272727272725`}, {11.404373404373404`, 
   2340.6363636363635`}, {11.047286047286047`, 2925.5454545454545`}, {
   12.856143856143856`, 585.9090909090909}, {12.213386613386612`, 
   1170.8181818181818`}, {5.238539238539238, 1755.7272727272725`}, {
   5.595626595626595, 2340.6363636363635`}, {5.952713952713952, 
   2925.5454545454545`}, {6.545636181999818, 4095.363636363636}, {
   6.837798565071292, 4680.272727272727}, {9.818054672600127, 
   5265.181818181818}, {9.409027336300063, 5850.090909090909}, {
   10.746526201071656`, 3510.454545454545}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 17, 3, 18, 4, 27, 28, 5, 19, 39, 40, 41, 6, 29, 20, 42, 
       43, 7, 30, 31, 21, 8, 9, 22, 45, 44, 10, 33, 32, 23, 46, 11, 36, 35, 
       34, 24, 12, 38, 37, 13, 25, 14, 26, 15, 16}]}}, {
     {RGBColor[1, 0, 0], 
      PointBox[{17, 18, 19, 20, 21, 22, 23, 24, 25, 26}]}, 
     {RGBColor[0, 0, 1], 
      PointBox[{27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 
       42, 43, 44, 45, 46}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 16.}, {0., 6435.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->51463816]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->420838548],

Cell[TextData[{
 "Use big red mesh points in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->2133487437],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"15", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2002303716],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 1.}, {2., 15.}, {3., 105.}, {4., 455.}, {5., 
   1365.}, {6., 3003.}, {7., 5005.}, {8., 6435.}, {9., 6435.}, {10., 5005.}, {
   11., 3003.}, {12., 1365.}, {13., 455.}, {14., 105.}, {15., 15.}, {16., 
   1.}, {2.3636363636363633`, 47.7272727272727}, {3.727272727272727, 
   359.54545454545445`}, {5.090909090909091, 1513.9090909090908`}, {
   6.454545454545454, 3912.999999999999}, {7.8181818181818175`, 
   6174.999999999999}, {9.181818181818182, 6175.}, {10.545454545454545`, 
   3913.000000000001}, {11.909090909090908`, 1513.9090909090921`}, {
   13.272727272727272`, 359.54545454545496`}, {14.636363636363635`, 
   47.72727272727286}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 17, 3, 18, 4, 5, 19, 6, 20, 7, 21, 8, 9, 22, 10, 23, 11, 
       24, 12, 13, 25, 14, 26, 15, 16}]}}, {
     {RGBColor[1, 0, 0], PointSize[Large], 
      PointBox[{17, 18, 19, 20, 21, 22, 23, 24, 25, 26}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 16.}, {0., 6435.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->479456467]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotMarkers",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->135624826],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListLinePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLinePlot"]], "InlineFormula"],
 " normally uses distinct color to distinguish different sets of data:"
}], "ExampleText",
 CellID->1490919188],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"n", "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "p"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->538803949],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1., 1.}, {2., 2.}, {3., 3.}, {4., 4.}, {5., 5.}, {
     5.378679656440364, 5.378679656440364}}]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], 
    LineBox[{{1., 1.}, {2., 1.4142135623730951`}, {3., 1.7320508075688772`}, {
     4., 2.}, {5., 2.23606797749979}, {6., 2.449489742783178}, {7., 
     2.6457513110645907`}, {8., 2.8284271247461903`}, {9., 3.}, {10., 
     3.1622776601683795`}}]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], 
    LineBox[{{1., 1.}, {2., 1.2599210498948732`}, {3., 1.4422495703074083`}, {
     4., 1.5874010519681996`}, {5., 1.7099759466766968`}, {6., 
     1.8171205928321397`}, {7., 1.912931182772389}, {8., 2.}, {9., 
     2.080083823051904}, {10., 2.154434690031884}}]}, 
   {Hue[0.37820393249936934`, 0.6, 0.6], 
    LineBox[{{1., 1.}, {2., 1.189207115002721}, {3., 1.3160740129524924`}, {
     4., 1.4142135623730951`}, {5., 1.4953487812212205`}, {6., 
     1.5650845800732873`}, {7., 1.6265765616977856`}, {8., 
     1.681792830507429}, {9., 1.7320508075688772`}, {10., 
     1.7782794100389228`}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 1.},
  PlotRange->{{0., 10.}, {1., 5.378679656440364}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15921021]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->800926095],

Cell["\<\
Automatically use colors and shapes to distinguish sets of data:\
\>", "ExampleText",
 CellID->1039599520],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"n", "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "p"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->300085940],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->415133264]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->108453591],

Cell["Use shapes only:", "ExampleText",
 CellID->892273693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"n", "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "p"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Black"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->565651250],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->425321110]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->351763345],

Cell["Change the size of the default plot markers:", "ExampleText",
 CellID->1984415605],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"n", "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "p"}], ")"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"p", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"PlotMarkers", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "s"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"Small", ",", "Medium"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->651224550],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->291468401]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->411107243],

Cell["Use arbitrary text for plot markers:", "ExampleText",
 CellID->1454835775],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"n", "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "p"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<1\>\"", ",", "\"\<2\>\"", ",", "\"\<3\>\"", ",", "\"\<4\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->956633561],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{{1., 1.}, {2., 2.}, {3., 3.}, {4., 4.}, {5., 5.}, {
      5.378679656440364, 5.378679656440364}}]}, 
    {Hue[0.9060679774997897, 0.6, 0.6], 
     LineBox[{{1., 1.}, {2., 1.4142135623730951`}, {3., 
      1.7320508075688772`}, {4., 2.}, {5., 2.23606797749979}, {6., 
      2.449489742783178}, {7., 2.6457513110645907`}, {8., 
      2.8284271247461903`}, {9., 3.}, {10., 3.1622776601683795`}}]}, 
    {Hue[0.14213595499957954`, 0.6, 0.6], 
     LineBox[{{1., 1.}, {2., 1.2599210498948732`}, {3., 
      1.4422495703074083`}, {4., 1.5874010519681996`}, {5., 
      1.7099759466766968`}, {6., 1.8171205928321397`}, {7., 
      1.912931182772389}, {8., 2.}, {9., 2.080083823051904}, {10., 
      2.154434690031884}}]}, 
    {Hue[0.37820393249936934`, 0.6, 0.6], 
     LineBox[{{1., 1.}, {2., 1.189207115002721}, {3., 1.3160740129524924`}, {
      4., 1.4142135623730951`}, {5., 1.4953487812212205`}, {6., 
      1.5650845800732873`}, {7., 1.6265765616977856`}, {8., 
      1.681792830507429}, {9., 1.7320508075688772`}, {10., 
      1.7782794100389228`}}]}}, {
    {Hue[0.67, 0.6, 0.6], InsetBox[
      TagBox["1",
       "InsetString"], {1., 1.}], InsetBox[
      TagBox["1",
       "InsetString"], {2., 2.}], InsetBox[
      TagBox["1",
       "InsetString"], {3., 3.}], InsetBox[
      TagBox["1",
       "InsetString"], {4., 4.}], InsetBox[
      TagBox["1",
       "InsetString"], {5., 5.}], InsetBox[
      TagBox["1",
       "InsetString"], {5.378679656440364, 5.378679656440364}]}, 
    {Hue[0.9060679774997897, 0.6, 0.6], InsetBox[
      TagBox["2",
       "InsetString"], {1., 1.}], InsetBox[
      TagBox["2",
       "InsetString"], {2., 1.4142135623730951`}], InsetBox[
      TagBox["2",
       "InsetString"], {3., 1.7320508075688772`}], InsetBox[
      TagBox["2",
       "InsetString"], {4., 2.}], InsetBox[
      TagBox["2",
       "InsetString"], {5., 2.23606797749979}], InsetBox[
      TagBox["2",
       "InsetString"], {6., 2.449489742783178}], InsetBox[
      TagBox["2",
       "InsetString"], {7., 2.6457513110645907`}], InsetBox[
      TagBox["2",
       "InsetString"], {8., 2.8284271247461903`}], InsetBox[
      TagBox["2",
       "InsetString"], {9., 3.}], InsetBox[
      TagBox["2",
       "InsetString"], {10., 3.1622776601683795`}]}, 
    {Hue[0.14213595499957954`, 0.6, 0.6], InsetBox[
      TagBox["3",
       "InsetString"], {1., 1.}], InsetBox[
      TagBox["3",
       "InsetString"], {2., 1.2599210498948732`}], InsetBox[
      TagBox["3",
       "InsetString"], {3., 1.4422495703074083`}], InsetBox[
      TagBox["3",
       "InsetString"], {4., 1.5874010519681996`}], InsetBox[
      TagBox["3",
       "InsetString"], {5., 1.7099759466766968`}], InsetBox[
      TagBox["3",
       "InsetString"], {6., 1.8171205928321397`}], InsetBox[
      TagBox["3",
       "InsetString"], {7., 1.912931182772389}], InsetBox[
      TagBox["3",
       "InsetString"], {8., 2.}], InsetBox[
      TagBox["3",
       "InsetString"], {9., 2.080083823051904}], InsetBox[
      TagBox["3",
       "InsetString"], {10., 2.154434690031884}]}, 
    {Hue[0.37820393249936934`, 0.6, 0.6], InsetBox[
      TagBox["4",
       "InsetString"], {1., 1.}], InsetBox[
      TagBox["4",
       "InsetString"], {2., 1.189207115002721}], InsetBox[
      TagBox["4",
       "InsetString"], {3., 1.3160740129524924`}], InsetBox[
      TagBox["4",
       "InsetString"], {4., 1.4142135623730951`}], InsetBox[
      TagBox["4",
       "InsetString"], {5., 1.4953487812212205`}], InsetBox[
      TagBox["4",
       "InsetString"], {6., 1.5650845800732873`}], InsetBox[
      TagBox["4",
       "InsetString"], {7., 1.6265765616977856`}], InsetBox[
      TagBox["4",
       "InsetString"], {8., 1.681792830507429}], InsetBox[
      TagBox["4",
       "InsetString"], {9., 1.7320508075688772`}], InsetBox[
      TagBox["4",
       "InsetString"], {10., 1.7782794100389228`}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 1.},
  PlotRange->{{0., 10.}, {1., 5.378679656440364}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->494608982]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->118321171],

Cell["Use explicit graphics for plot markers:", "ExampleText",
 CellID->1798300351],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"m1", ",", "m2", ",", "m3", ",", "m4"}], "}"}], "=", 
  RowBox[{"Graphics", "/@", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "]"}], ",", 
     RowBox[{"Disk", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.5"}], ",", 
          RowBox[{"-", "0.5"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.5", ",", 
          RowBox[{"-", "0.5"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.5", ",", "0.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.5"}], ",", "0.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.5"}], ",", 
          RowBox[{"-", "0.5"}]}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"Polygon", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.5"}], ",", 
          RowBox[{"-", "0.5"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.5", ",", 
          RowBox[{"-", "0.5"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.5", ",", "0.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.5"}], ",", "0.5"}], "}"}]}], "}"}], "]"}]}], 
    "}"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->226990082],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[CircleBox[{0, 0}]], ",", 
   GraphicsBox[DiskBox[{0, 0}]], ",", 
   GraphicsBox[
    LineBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
     0.5}, {-0.5, -0.5}}]], ",", 
   GraphicsBox[
    PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 0.5}}]]}], 
  "}"}]], "Output",
 ImageSize->{452, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->397568449]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"n", "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "p"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"s", ",", "0.05"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"s", ",", 
        RowBox[{"{", 
         RowBox[{"m1", ",", "m2", ",", "m3", ",", "m4"}], "}"}]}], "}"}]}], 
     "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1508798363],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9Wwt0VNUVfWQ+SfhJQb5+oGog9QcIyE80COEjQqISoaKBJBgSEAgh/IKF
oJBYiOVfCCBBRRCMMjQaoI2CIEg0JEKhfGSJoWKwhZUlSG1a1prue86dd997
uTNksdrOisO89+49955z9tnnnDvj8KSstBcnJ2WlpyR1GJyZlJGWnjK9w6Cp
mbjlamAYRhX+W93GwGc/PtF/VX4//rW+d8a7G4+ixZVLjKGX0QlvYfK++Lcj
/hWPw+S1i2Z3scwyNFLELMOtro163RFrCAUaiH/pVleH3Ci5607/JfkPOeTf
o9PLJiNgn7o7uLH0KIttXfXUoq7UzkH39Kub8EJd+V2CSAsgIrBaRwsiFDKs
GItwSPiL9u4tePMIY7saNGhQXFws7u0NOtJLI+Pj4+W9T2ikG+9npRZ15zmv
3QE53h59O45b88zQDWMSt05ZW7bl8PnKMMfY8BvI+l8//3+vd6PnrtA+bAQf
blm56d3EV0tW5RW8mTJjXULqlkn9Cp7NKsndfuyjM5fO1ZnbyXGtY6RQ18F3
ZLTq2bNnhw4d2rZt26RJk9atW7dpc+eCnPfxpHJz6bYxeV/t3F1+cOOW9QlL
30xZUJyT9F5W3NupOaXLSk7tvXytBsP27t3rmT9/fpF2hZbirdmMrJKyw+fx
8drlK/tyt/rSll08/u3F74/v25379po4386Xt372Ru6+30PwmG3ThqbECyuF
kOe6fPlaSnIR3ikyjUaQBpkH8t+D/Ov/rj17snSPLxuSD/wp//i3X0Z3vdfg
2Cn+bLeUs82ULqKyNUk9sP/c3Ow9prVcJ3wHof+x7ft4Ffe1ny6f+Mq3beOY
hg09JC+8/5Th8Br2nL1nycby7YiM6it/M97R7pzXyMvdt6vklLmGu/bqPw6t
8GGZCxVf86q33NLU4JeYbDQpLCzE/aqa7/af+wJrACIJhJUpxQvyD6wHXCou
nKi9/i/eowujY+hluOiturparr8qxK5qa6/DnlVVNYZHXHtrqn4onrJ6T/ZG
2BM3mjVrRvq6UxO7ln6YAyPUXK5yE/CxuO/EH1cc2oTtDNgwBh7Eh7jUBLb3
uXPnQq7ehu18/OLUKcXYg+EV155z+49tSXi1fOPuDu3bQwJbKnLcuHEFa1fB
tXAqfABAAj2njpdc+bGad+0CHLEdLM7edi/yLd9cuQO3EFArteu3Ff4v3FhO
8Rx5vfbfWLRlo18kJzw/adKkYcOGTZgwoUuXLrAp7yECa2FFrIvVsQfsBPsB
LNhzU6dOtXqu0RLfatAl7JFcNBMOg9vwGaZipBy/eIY41nDt2rXL5rPKykq5
v/naXbej6/Q0HwznN9lozbJVPe/pLBYOoy306tWLzc9WjYDL4Di4D3GBvR/a
u+Lc1/tbtGjBnpo5c6aUzhEFHMNwQBdDLs03FxqwdxGoKfMnyohC8NfZq1j/
NtpTdfUV4Orq1Vq5x5qamoiICNNCrpMnT8rZkRQN2OOx8u2I3YaRbpYPm9pG
sI/BPdgCjfA+nZvENsVN9nVkYK299KJNWiNhotaqvGMEJ0LUtJrr888/t/rU
NX1g4tnSCvGosXhrCOKsKN9bWba55P2sDcsGjIx7IPG5GFxeOF8BImoUiEmr
DO+6ok1sWFiS0REG44bho+EFYPCg9OxBqIKYF9xKE5kFgu/+drpekFP6celZ
CiK6/vnnn9u0aWNiwgvjH9v3ZWnOW4gv8BoA35DGQQuJFfJ+5KyZGVMmJZbt
X1u8bQq0KnorGZiHZ6CV9KRDJwsOxMph2L3hRfBBF6QKaAaOfHB6DOsyLW8W
noshjQO7DOKphBC6AlXAFhAmWQNRw7qCrXbs2MGaeK5UXwa/vh03r2zthyAz
KcuubxiyF3PMpR/OIL4RGtC7IL+f7500hDiiBqlK8mtsbKxNbzCE3BXrIhSw
Ph85OxHaC9cKHxsuJgG6hm0MF4NW2ILlC76zzld+19viDrqurLgABlVcoOKK
GMaDLINkDisg+V46853EtiAb/Vr0PBJaQ3dYAHaANWCTh7pEvVX4Gqyksg1o
WXxsotVeSeTxzCqkLWnPAaCs88TyRNv8nKWLMFjkVCFfVBlWpMVoLXInXRes
LXtns6BRoxmZ4VRJWVFyPpIakgtlnYbAco9u9y1bPB7oBsahXfaMUXHDY3C/
9p9X9d5U+vDzL44fsT2PzYiHMvAx6+M2vY1MTRp7kMTZAkjZ5BqaB8Xq6CQi
tr1fZmeQ/ddnLhnNaQpKBaRmhDAKFISw0UrcbQpvsmnAO9Bh0StThg3pCa0K
Vw4F4+MDwhngxiPGyOnTp5fSy3DR29GjR226BUciV0OmL5H/WTcUQawtCgGh
PuuGfIyn0NsgVhAYkHKElh7KeHl5efLefVqfsh1QnyDiRZ3QgvCJ2EbJZ8Y2
7gH3a9asAROw112mTXjPzU284oW0DVuAqkFtHO7IimBxFLtIjMA4xmBwdHQ0
Z2V8sGE9uH0IqxbdYReD2N3NlRv+hhYmuXDHRVEgbGOVZG5RroQcJPkxjPhR
1QettNbqQNc7fSdezz8gPt5K/mIOAGoy41J4nYyMDNs6Q4YMQbUjlA0LaJyW
luYPsEoTZOfz3xyGfZCgETSw2OOPdpo9fSTuwJKojdi8RlN/aFZX9lG4p3zl
vlr7E2MKf2wbYTuLbTyt+3RgjHEhYohRLgeumGvA8XIm10NQKaTVfknXZqci
O41LP/w93OtVvlHMylECrWxaouqwPm88alR83sJpsBAghqJx7KiOsBnshzsc
jIjWyJuwl3nPA4ubNkM2YYtQLWGijbuFpq2auUlKdLf7uMCQEclUFIhIa15g
y8GS8rn+5IAtp3qylgHU2rn8+Qy0FWo89s0hw/4SfQ6MhdCDaTgkwcogL3xA
CsJNYE9kHq61wRjYlsIqgAv4ikcCfR6yoOo+lAVVbLH/YIB2d9ymdgnbcMEi
I5apjP/Iqh5Uw7Aw/93fo7PhrpeN7qJr1WHeGvC5vT4Lj/i08A/oBvEHckfI
ttfZypJ3Kb83Q8IClJCsYSZQGAcn6Ay2S02OS09NwFPwnZ+addhLnOA5mbfJ
DaJG1AQUaR40L6YF7u7aKYQFhAw+LQQVgZBMzYNUawAIGL1waDZK1POHT8rq
RqQnK5JUFFD1KngJ+kHRlLECLch20H7hyyMeuPd22IOLcYGchto4UxF91w0s
0OSmouNuv9/WYRP7WFYl5vOgqSjJKuBchrxG55dmXdr0g6LC3r27Qxkuydm/
nNURKriPNpTrFhMfsK6KDvSCvE25m+AZ5eZ0ZB+rPp5Q60VO5ozjS1uG+gto
vt+qlYuxqFDMGRm0CIXQp3LtwmV4Rnrs8Cf6mq5EZGNLvUkKspjsnlnX0aNH
2/Yq0Ol27DeKbL6psOyp+ImYNHv2bPA279pz8fi3qJK5VkalJSNOVRZRAUw6
+YePW5lXmqJ2Xvp6DvZseiw3u8etzSPxmdmfuynowraERuAvdQagcjNXRKxC
4MjdqQ/ZPxzIxtzu3UeuX1eEuMZnoRW53YM6ES5A/Qt3zE2aajgrAIELjy6D
WbiGayjstH37O7F3pmpulhiRzNZcQ7GvYAbMh2Zukq12zFo5z5FdOr08vAN1
liAQxDj+6+lvvB5tdn5Yt3cX48Yv2cxoxLzJRQ07ClhDju77cFtWxAjDExLO
4VXPisyph1jdFeDCcMCNaZcPG2TVZEamjevmxE/g0JEaOTsSxU7kLTeEjU1M
ZKVo75EYZUYSKhATgHCQESYaei9KEH/ghfXByG7CYEREBBchIbSqi0IzqvGC
drGxT4mzAtbOke/CscIXvk8QaKB8tDRS0yEO33Fvbq6DF2pNE4DwmxEGrYxw
1Atm2kNf161rNIKMdRQiuOnnE0/D/v2Olh+8iA4QJ8AWGzsoKqo/AMh4dOYu
2p8XjaVDkdiAHiAHal3pTa1C+cjD2QttNfaLYGJdPFCkRfOIVYvj2V8Sh3Aq
Z3LZwcM9tvM05THmPnnsTy+PQ0f6lssDf2NXu3btAnmjyeS7ljjy2nUDgaAu
AbE/TuPAFfPpJXVz9seK4fm0Gy44WnmQXUcaeRBjZsoGRqX28Cmefryn8I7b
26maT53a6LPQvX4+zaXvQ73gbu4OzT07mTxOt0fLKtz1MEdwq4hNvfvmjFYt
mzLf4V3hKizonij7IzPCxEY3srp1b/PSZtRh4yf9kq2AMOVdLMTkrDp0yWbB
7SPi7H6JlSsvjNkmsnMPtsOnR7zykNXBnePqLd2qKa+izk+7+3V8NvWR0ahw
kGPlKoArdFR5z4lg5yoP0LU65+ym4xUIiThd/mcUH6g8OJMDwUiBLwQQEIS9
Q62JzAP7if6me3AWCAfMEPyggA0DZuAdwBPVXIpW7oN0rc7uejhiLzwQe8AK
0nZRcj5Md+nMd24Hjn+tlU7fgFvOwfqTSEyHWSAKZoFYCF+9cnUd/D1rw0+X
AIblKdRAimVoCu3ez1zlCXO7HQjSn1WyHHWKE6tFyCvjpqP0Dy6Ff+2gTjcG
6hAQjtcn6z5ASW36Ab2F8bRWIv8CAY0Z2jNTor5DiQCI2CHo0OATNiFujggh
WXXGgxweJnYNB0KwP8YMAAv/iDNap5cH2nzC0VV2+PyMrBLxkTQLR1wBIuxd
gB5IXJ6/tI53+2v3yhJXrjj03vZj4uPIgJch5cN5b2i8rD9/7R5Ai+x3ntV6
edaT46Gn4AG9lB4OrCTovCzi/MhHB6AyzMaOPrZ9H4z3iFYmV1BQD0qa+NLH
sfTzoRU+GJNzOkOol1ZyT7pGGCOYzfhxRnIESgITO3AQelyYFs535qXONk/3
cmBoPF3DL2gZ4WMjDDA0PJlxKUbgBU8zt9TZJ8tSpxAT6BpVtO2Mq6RgG3Yl
HulPY7nvUh19qs7D3nmjJ2Nn+IOebLvoENIUXlJ1nm5k5gXsDIqzEdkxcLnA
EdVmJNhZ6fQhP1ccqerbZ+yjjz4mu73xWu97LZ6C9xlXoBGA1fyGXnmqHa/p
WM9ZF5OGsjsbMTxpeuYa1Z296EAK1YThQB84ELhGfVDQbxre5yROrhPHrYOu
Li5pVY9ZRTM4qXeaxWsi/1t7pz2FH/Ahuqz2Q9WOrJHZx3BrtnbtetHHzNKi
Ye7IiYC8iQbEKJ3h37AD5JWsPQUSf9cug0VPMUuHlMZ1kYIQZieWb9wNJ8K4
TevlN8KN6gLQxXZ7aAgKnNnBkRPJnsNC8BnTOVCEbYjvHp3ocQdFbF9a2azN
za865zjQQt8vC9ZHDMCwpoV1NaW+tnmMrlUNspiuYboK36eiPBSc3wALql++
BXhJZBFRbS/R+LvB1q1b7TOsa8YEIl7WxIt1frxhJUhZzJIhFmu9ov/dE3cv
qlZd4rCrftYAulZ1wrIQoxRfq1FCL655VN5eqpXBo1Qu/l2IUYo59aO45kDd
hupN2Ol17ajBdI1SEQWj+JivHcWducpzS2y6DQ1ojjpZnNMs0crgUYhiFPEm
4uqMeoKu1a+lfhtiFLTCiuKXAPpRw+iaG1zx8TXtKNFzCTyrp0Kn4Q6s5mnn
8ijVYeVqR41woG6RdlScA2UL/fXhSZrl+f77y927j+nbt5/Mca/Uay7tS+an
pKSXnnk6V+WnBSQhcIYqJtFolVcYpJRXeGxAsi5v8Epm3mDo5uevFnkjMFtO
DTrbmguA+qio/uvXv1GP2WQhG5vHxMRh9wvqZSM62lWMjCv+pjBH60OqnS0c
MN+GKa4OVRU2TyuDR6kq6zchRikO0I8a5ZcRIM/nX9aOGu23c8Bc7SjqNi0c
kG3T7bmA5pIDsrUyeJTigDnaUWP8dg6YHWKU4gD9qOcdFpilHSXOBwQHqKfi
YSKNUr+3m6Gdy6PUKbV+1Fi/nQOytKPGOTSfHmKU+h2UflQSXasMn2nzV4rU
OFM7NzlgW8l+07Sj6HTDkokzaJSuruGae6fv6ODBqep7l8k83jHWGZG0imSp
Pr1HrVi+VbHUS/WXIJlLneYI5go+3yVtZGEtNqU8teeZoXiHZ1tZC6QD6hEV
rH02bU9nMcVagwYNju70OJI5zwz8/ybO82vqKhRbma6ZpPVfOl2rvlj/C0O6
a4n7dBuOSLKF8dK1MniUYr407SjSzYL+CcFHeX788SdkvF69HpFYejH4uhI7
48dPRoZbuHCRxM744DNUlgMpgq0IK2q80Jv3amKjzvfz+pM/toM6eeZZ6lt+
/SzW2JrBBAJZY6PBfwAIR40u\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[2]=",
 CellID->560422586]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->213068314],

Cell["Use the same symbol for all the sets of data:", "ExampleText",
 CellID->259408171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"n", "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "p"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", "\"\<\[FilledCircle]\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->481326587],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->223929019]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->62995286],

Cell["Explicitly use a symbol and size:", "ExampleText",
 CellID->1200966200],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"n", "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "p"}], ")"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"p", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "10"}], "}"}]}], "]"}], ",", 
     RowBox[{"PlotMarkers", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<\[FilledCircle]\>\"", ",", "s"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "8", ",", "12"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1349648965],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{487, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->576829826]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotRange",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->194194198],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " is automatically calculated:"
}], "ExampleText",
 CellID->1204301404],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "45", ",", "6", ",", "7", ",", "8"}],
    "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2138201140],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1., 1.}, {2., 2.}, {3., 3.}, {3.295238095238095, 
     15.400000000000002`}}], 
    LineBox[{{4.758974358974359, 15.400000000000002`}, {5., 6.}, {6., 7.}, {
     7., 8.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 7.}, {0., 15.400000000000002`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->485055476]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1761355773],

Cell["Show the whole dataset:", "ExampleText",
 CellID->836124642],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "45", ",", "6", ",", "7", ",", "8"}], "}"}],
    ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->660324053],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1., 1.}, {2., 2.}, {3., 3.}, {4., 45.}, {5., 6.}, {6., 7.}, {7.,
      8.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 10.},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->251431141]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->450032879],

Cell["Use different style directives:", "ExampleText",
 CellID->193335196],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Binomial", "[", 
        RowBox[{"10", ",", "k"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "ps"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"ps", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Thick", ",", "Dashed", ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Red", ",", "Thick"}], "]"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42985262],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, {}, 
     {RGBColor[1, 0, 0], 
      LineBox[{{1., 1.}, {2., 10.}, {3., 45.}, {4., 120.}, {5., 210.}, {6., 
       252.}, {7., 210.}, {8., 120.}, {9., 45.}, {10., 10.}, {11., 1.}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 11.}, {0., 252.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], Thickness[Large], 
      LineBox[{{1., 1.}, {2., 10.}, {3., 45.}, {4., 120.}, {5., 210.}, {6., 
       252.}, {7., 210.}, {8., 120.}, {9., 45.}, {10., 10.}, {11., 1.}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 11.}, {0., 252.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], Dashing[{Small, Small}], 
      LineBox[{{1., 1.}, {2., 10.}, {3., 45.}, {4., 120.}, {5., 210.}, {6., 
       252.}, {7., 210.}, {8., 120.}, {9., 45.}, {10., 10.}, {11., 1.}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 11.}, {0., 252.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {RGBColor[1, 0, 0], Thickness[Large], 
      LineBox[{{1., 1.}, {2., 10.}, {3., 45.}, {4., 120.}, {5., 210.}, {6., 
       252.}, {7., 210.}, {8., 120.}, {9., 45.}, {10., 10.}, {11., 1.}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 11.}, {0., 252.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{452, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->729653173]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1845615257],

Cell["By default different styles are chosen for multiple curves:", \
"ExampleText",
 CellID->702451365],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"k", " ", "x"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", 
        RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->210197233],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxVz3tIk1EYx/GlCGYLtQte05omVm5eZs1L5m+bm7epaKZiSWBGWFiiUiAh
GhWhZH9kuQrRJCmCVMq0TU2xZKnNnKIz1Davqdu8hAahtAqf948OHA6f9wvn
vM+BzCtJ5y1YLFb43/3v3For4az/F3z6yvrqyxX03Rptg2Ee5pwesh0ClcoH
6oVB8h5cunBkIcQ4SnbEilVswXz9N7Ir0oV1Dnftp8j7oXCSZl+umiFzoP7d
0VWxNkf2hPBFhtzSfoHshSX29nvJpkWyN4LOcWXdN43kw+g+5VwrHjKRfRDr
1v3r2vASmQfLyQid+s4y2Q9lOT5PCg2M/dEt0qtKNhkHoFnuq21pZczHyt72
kq5DjAORGuTs7hDF3H8U0ibN4k9H5v1j2MgzhGdXG8gCWGtffuXrmHmCwPFN
42rGv5ODIdd8WM+qmiWHoLH3y84Gr2lyKFpv1bRuFunJx8F+7unpnz5GDkPn
bIZHXu4w+QSG/KJG3lX3k8Nxerg5J8iuiwzw7OQ3bGPqtlwMBHDngwXTrzq2
uhCV7JZeC/+PWy4WokBmtutJH6Augnumsig0f4S6CKuaFbEwaZy6GEIXnvHi
mp66GDWdRnNKxTT1CPS/cefyLOaoR6DebXxCIZinLkH7p6nCk76L1CUY3TWg
+zFtoC7FwdJtIaGJJupSLHtL/G/nL1GPRDFUYabIZeqRUBozdid+JrOikGQU
2J41Mz0K5jD24wo906PxzMC5ilymR4P/SL9e0sDcHwMFZ9RVWsO8HwOtp/K1
SGKkHgvBrrbk5afM/8ci1yqg8rqSmU+G1Eab+J77zPwyNK0/dEjhz1CPQ42q
MFpQPUk9Dr26cpVN2wT1eLi078iSm7TU49FZ21i6OqmhnoAzG3ytU6KKegL2
qd+PpUnedvwBRjQ7Kw==
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJxV0ntIU1EcB/CRGFMEZyWKZVQ+mDq33NKpZf728jV1NXylWFKuAjMlzT+y
xxRLCVZUUs0eiiSMwJ6WNDVlYaIobprOUtl0ae7lZjktkFax3/2jA4fL53zP
uefy+93dx8vEkk0kEinx7/z3dA17Iun/Ad1jCUHO0kFcJ0PJqQhjvGUKTYF8
TpufzGcevQ1GfveqGlcX0f6w7OVxM8tqQu+A/uyAVt64Fb0L3Ob4upEGG3oP
9HP1AzUbhIPB7ttTowojHApJHRrTmj9xngpk7dPPLJ0RHQ73NR8cxY8W0DTo
utrStXFZj6ZD30Jh0LnyCfReKJh4WxpLUaGjgBm5FMc2tPe6zITKdCdlMF+N
ZsGKxs7jiGfQ+6Clz+LMaTSgo+HZzpnZd+wldAxMbVHrvhvMaDbYqIKoaxXL
6FhQWgq3Hh62oePAmeDV1KgnHA8sud5R85zYvx+0wcpXXIEFfQDK3Zn3LiqJ
+xKgw3HXL4f1FX0QhnQ3Bjy7Z9GJ0Nf64vrKnAYNEDjyfjpP8MZlKQAtPJoR
MdmD9eDAbQ8jQ2gfd1nKAQ8fU5OsWYc5F8iepSryZqy3lAveg4YQpYToBw/W
wtyr2SoL5jzw/klpZ/5axpwPjE4pzWcV+yvlQ/UotWVMQfRbAHSWcb0qAPdL
BSBfjxzV5ZkxT4LIlx25dOk3zJNgdmyI+6ST+B+T4RbDKya06AvmyVDyYCJQ
UT+MeQrMc/gK5VE55ilA7fQl5x76iPVJBbezr/XFlVqsTyqIRT8cj0/PYZ4G
wpNq+THJIuZp0Cwrs8kumTAXgjaEJi6qt2IuBNn2iqJPJ4j+poP5Dr3K7ERL
0+FK2/mGM9lEngFpIpIiqIQ4nwHT2azWh1nE+zOBfERVVxBF3J8JbRLtelME
8X0iuCAy18ZbJzEXQfCkuraO2d/7Bzc9Pe8=
     "]]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], LineBox[CompressedData["
1:eJxV0n8s1HEcx/FLtagzFGWYhPzI7yOnwr3uzu/fsxWxxnCWNaVfa7NqX/3R
kmljjFTzY7vSambLEMuJolh+HhFCfnfJdTJGWz92788ffbbvvnt83/+8P899
D6VciJXp8Hg80d/n31t71CLe/wdeTU3FH5YG6LsuEsTyA/lGX8iGkFSfKd1u
tEQ2xtuTZlXSwWWyKfIynR9kq1bIFlCbvMppc2S2wtYllSijXEW2Rml/+1ra
ozmyLfhPbG09EsbIdkgcqs/0MWwjO6CE39Cl4/FGofURbPSrpeLYcbIzel4c
dHHVmSe7YmRv36RmRkV2B4dOv+XgFbIHfvvxy4qmmAV4aT1iEVSxTPZE1k5B
yfWmRbIXKjqzQ4Xl0+SjaK2qvftjup/sjZui7ranwgLaV4hCvSW3cPUg2QcK
sxHzolus5zEYv5853CRjPY/DvebXbdMd38kn4NbAORv9ZP18kVoXmnhKj9kP
99ddeifjWU9/rFe6ivYIWU8RCtz43nbJn8hAjHNPi/+4QmsOcGgw0Y2L6aD9
xciqt6oMCJnQmhMjPL3vfpKM9ZTARKpuvGb3jeYS5JtfTlamsn5SGFQYrCYN
kjkpwqJ51TbnWM8AbDyvkDmlUE8uAHLZx/UyJ9YzEIGt3fZdI300D0R2TwZ2
Cytp/yB4KUtOx60paf8g3BnttQ/QsJ7BqI23tixrpJ5cMLqu1EleC1jPEGyT
LNbEbVI/LgSru1xsns2zeShy8+5VJxpSTy4Ui209Fx16Z2kehuEFeaEgbZTm
YZAXPI5oKW6meTjkU0UD+uff0f7hUOQmZTr6fqb7RWBBtaCv6aCeXARyajs3
NenUkxeJueGW2as3WL9ICPjzZRPtrG8UlN6mFlOe1JOLgp3lvrP7ddn/GY2t
5jGutX6K5tFI/2roO/SwV/EHfU02Bw==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 63.}, {-0.9999902065507035, 0.9995736030415051}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->143844503]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28469554],

Cell["Explicitly specify the style for different curves:", "ExampleText",
 CellID->24232],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"k", " ", "x"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5765],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJxVz3tIk1EYx/GlCGYLtQte05omVm5eZs1L5m+bm7epaKZiSWBGWFiiUiAh
GhWhZH9kuQrRJCmCVMq0TU2xZKnNnKIz1Davqdu8hAahtAqf948OHA6f9wvn
vM+BzCtJ5y1YLFb43/3v3For4az/F3z6yvrqyxX03Rptg2Ee5pwesh0ClcoH
6oVB8h5cunBkIcQ4SnbEilVswXz9N7Ir0oV1Dnftp8j7oXCSZl+umiFzoP7d
0VWxNkf2hPBFhtzSfoHshSX29nvJpkWyN4LOcWXdN43kw+g+5VwrHjKRfRDr
1v3r2vASmQfLyQid+s4y2Q9lOT5PCg2M/dEt0qtKNhkHoFnuq21pZczHyt72
kq5DjAORGuTs7hDF3H8U0ibN4k9H5v1j2MgzhGdXG8gCWGtffuXrmHmCwPFN
42rGv5ODIdd8WM+qmiWHoLH3y84Gr2lyKFpv1bRuFunJx8F+7unpnz5GDkPn
bIZHXu4w+QSG/KJG3lX3k8Nxerg5J8iuiwzw7OQ3bGPqtlwMBHDngwXTrzq2
uhCV7JZeC/+PWy4WokBmtutJH6Augnumsig0f4S6CKuaFbEwaZy6GEIXnvHi
mp66GDWdRnNKxTT1CPS/cefyLOaoR6DebXxCIZinLkH7p6nCk76L1CUY3TWg
+zFtoC7FwdJtIaGJJupSLHtL/G/nL1GPRDFUYabIZeqRUBozdid+JrOikGQU
2J41Mz0K5jD24wo906PxzMC5ilymR4P/SL9e0sDcHwMFZ9RVWsO8HwOtp/K1
SGKkHgvBrrbk5afM/8ci1yqg8rqSmU+G1Eab+J77zPwyNK0/dEjhz1CPQ42q
MFpQPUk9Dr26cpVN2wT1eLi078iSm7TU49FZ21i6OqmhnoAzG3ytU6KKegL2
qd+PpUnedvwBRjQ7Kw==
     "]]}, 
   {RGBColor[0, 1, 0], LineBox[CompressedData["
1:eJxV0ntIU1EcB/CRGFMEZyWKZVQ+mDq33NKpZf728jV1NXylWFKuAjMlzT+y
xxRLCVZUUs0eiiSMwJ6WNDVlYaIobprOUtl0ae7lZjktkFax3/2jA4fL53zP
uefy+93dx8vEkk0kEinx7/z3dA17Iun/Ad1jCUHO0kFcJ0PJqQhjvGUKTYF8
TpufzGcevQ1GfveqGlcX0f6w7OVxM8tqQu+A/uyAVt64Fb0L3Ob4upEGG3oP
9HP1AzUbhIPB7ttTowojHApJHRrTmj9xngpk7dPPLJ0RHQ73NR8cxY8W0DTo
utrStXFZj6ZD30Jh0LnyCfReKJh4WxpLUaGjgBm5FMc2tPe6zITKdCdlMF+N
ZsGKxs7jiGfQ+6Clz+LMaTSgo+HZzpnZd+wldAxMbVHrvhvMaDbYqIKoaxXL
6FhQWgq3Hh62oePAmeDV1KgnHA8sud5R85zYvx+0wcpXXIEFfQDK3Zn3LiqJ
+xKgw3HXL4f1FX0QhnQ3Bjy7Z9GJ0Nf64vrKnAYNEDjyfjpP8MZlKQAtPJoR
MdmD9eDAbQ8jQ2gfd1nKAQ8fU5OsWYc5F8iepSryZqy3lAveg4YQpYToBw/W
wtyr2SoL5jzw/klpZ/5axpwPjE4pzWcV+yvlQ/UotWVMQfRbAHSWcb0qAPdL
BSBfjxzV5ZkxT4LIlx25dOk3zJNgdmyI+6ST+B+T4RbDKya06AvmyVDyYCJQ
UT+MeQrMc/gK5VE55ilA7fQl5x76iPVJBbezr/XFlVqsTyqIRT8cj0/PYZ4G
wpNq+THJIuZp0Cwrs8kumTAXgjaEJi6qt2IuBNn2iqJPJ4j+poP5Dr3K7ERL
0+FK2/mGM9lEngFpIpIiqIQ4nwHT2azWh1nE+zOBfERVVxBF3J8JbRLtelME
8X0iuCAy18ZbJzEXQfCkuraO2d/7Bzc9Pe8=
     "]]}, 
   {RGBColor[0, 0, 1], LineBox[CompressedData["
1:eJxV0n8s1HEcx/FLtagzFGWYhPzI7yOnwr3uzu/fsxWxxnCWNaVfa7NqX/3R
kmljjFTzY7vSambLEMuJolh+HhFCfnfJdTJGWz92788ffbbvvnt83/+8P899
D6VciJXp8Hg80d/n31t71CLe/wdeTU3FH5YG6LsuEsTyA/lGX8iGkFSfKd1u
tEQ2xtuTZlXSwWWyKfIynR9kq1bIFlCbvMppc2S2wtYllSijXEW2Rml/+1ra
ozmyLfhPbG09EsbIdkgcqs/0MWwjO6CE39Cl4/FGofURbPSrpeLYcbIzel4c
dHHVmSe7YmRv36RmRkV2B4dOv+XgFbIHfvvxy4qmmAV4aT1iEVSxTPZE1k5B
yfWmRbIXKjqzQ4Xl0+SjaK2qvftjup/sjZui7ranwgLaV4hCvSW3cPUg2QcK
sxHzolus5zEYv5853CRjPY/DvebXbdMd38kn4NbAORv9ZP18kVoXmnhKj9kP
99ddeifjWU9/rFe6ivYIWU8RCtz43nbJn8hAjHNPi/+4QmsOcGgw0Y2L6aD9
xciqt6oMCJnQmhMjPL3vfpKM9ZTARKpuvGb3jeYS5JtfTlamsn5SGFQYrCYN
kjkpwqJ51TbnWM8AbDyvkDmlUE8uAHLZx/UyJ9YzEIGt3fZdI300D0R2TwZ2
Cytp/yB4KUtOx60paf8g3BnttQ/QsJ7BqI23tixrpJ5cMLqu1EleC1jPEGyT
LNbEbVI/LgSru1xsns2zeShy8+5VJxpSTy4Ui209Fx16Z2kehuEFeaEgbZTm
YZAXPI5oKW6meTjkU0UD+uff0f7hUOQmZTr6fqb7RWBBtaCv6aCeXARyajs3
NenUkxeJueGW2as3WL9ICPjzZRPtrG8UlN6mFlOe1JOLgp3lvrP7ddn/GY2t
5jGutX6K5tFI/2roO/SwV/EHfU02Bw==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 63.}, {-0.9999902065507035, 0.9995736030415051}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->891604571]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8248407],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " can be combined with ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->185208180],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"Hue", "[", "y", "]"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1043126087],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9mUtQFEcYxz9mdlk2GGB5CSrhYQkxxljESEIZtVIUcIhE8IVvWXkEiqjB
WBw9eeHGIadcUhVz85AcPHjkmptVqRxTlHfOOdmVfK/ene3p2V1WzFbv9HT3
7/v318+dnp3KP15evJ9/vDKf75t8lP9+eWX+h76Jh48wK6wDgBf4Xe0CvP8X
7/j7whiDBZFrBq8hFgWUohvDHwjw9hkTDU5JSJdUMQ3wi0ShRPQJbLKsXdoh
fqqyPrKjGh5IcTNgijLqxYtGS/bvQi9KrFKfoGyAomkjknjpseW9NequsO4A
iM+Sl2Er8rlHQ19hXKiN9ZE4qvUt5Zuz6OMAvM/3PXg/Ah+w9X6HXsJLCukW
9mAEerzUIuvMkX9nbV6O80Yob9bmHfBaL7D2HHRIZ4wAGcwCHPTS86y7Qbpz
Nq+DFWYT9O9x6QZ0iz6KP6Eg6RidF+oloAVVc5Ctn0CXl57j0pfcLwGJhuZ5
1Cu/RYAWvWz5HDq91F2l+jlOou6wxg4MiM9Y8zYVQbuXvq304Si9DWXoAOkj
bLUNbV7qFlF/GhhiOom6SRpIfUjUawOtiRRpHSX6tcygOHWD0z8aQJJuP1JN
P32dtBD+WKkWE10j0Z3G7j7ueiGFABWOk9KvBpqZZapkzWYcO3cXu6aefEJ6
BR1375OlH5GtSpf8O6H+Ne3CP6qR7WcMDKtfSfZ273T75yrVi/afUvk9w3tK
kn3Uzk1fVT9Okh7q7CsZKRu7Vlc43WhghgN8pl7s884GogOET2kdjV7qslKf
U3yoGipE6j0vdUmpUdXyUxe5dWaUW6J5X6hFtqzF6bLUDPmG1JdCDzV4qZwp
/pJTH9MaSTnpUKcqpbNad6Z0jLU059A5U1xrPMPRoSGtud7rT2ts7rjPGDxH
04V1a3T1OlRLJO0r17lknlLPY8hUrDdXQZHnfn1UwdGRptfc7uaKRDVtxrF7
Wq9jHN9v2vagjRRqbWOlFjQZmUdBTIlqDLVtMYUScg/auEbhXbWx8jindBwb
Ensjl1jSbCJP7iUl2Htr6RrbVLHPqmx7qC3Llm2ZXf2FzLJ7hEOpmgyiv73u
ruWm3T1R55x5hZ7TbbbUa6XaIm2iuNVJB6xq1lJen6akZ16NS1wFRVqhlzqv
1KRqlafOe0u/5tK/zRSX0lPkz1hYV2TtDv2GA35SjkLs7FhNOjame6Jaey3Y
A+/Od/ep7f/rkbrSsbRrhsey3eGPe+xpZuSc/E4n3V/UL3mD8MZMSt6m0d79
piwZIHgh5qt8AvjdjCszncCEyIxxXMLEWiQUKc0kUqT1FVPj0gItu+C1kP1j
oWBxMZEKkTrHcRKVUq1zqnUpkSKtM6rlp9KqdYZjMJcTqRBP3ac5TqLkTYRQ
pHXFS2WUGlWtyhSEE2CkBPw0/zoeBcNP8gjPvgWVVeqUUteYsr+/vpOke1Yh
hRAVTnL+BpgJDiBK8afPSmufzxIkeF/6gE9gKHv9LfRC1KKTYLhLHWovnbkC
tSc/biTY25Ok2z/W/oTa3yxj785onw6Ev9klDseoTX9YTTtq9lTpKvB7MTSm
fS1Aq1veGUEUVWG1/VSTah1Trdteip/4SGxHxpLflBj4504iHe7IYSJMpFqU
GlStu16Kn2yQOsL5BraQpNtkGqG/Dku8NeelWpXqVyrvpdqU6tWaN7nyLX5f
F6fbpRXPeiXenPdSHUr1KLVQlqJa1zVP3w7CEjuyCX7LTvF5vVvipUUvtV8p
jZeWvFSX1rhuYBqD9WpMvBDGr6+1T8tTuYFBtJKwbOz8Ljzhl/xexlfPAal1
Gr/DzXI/SB6MabkoZh2r+Dtrdw0dEq1h/HY3qp85dpXCao2qNK70an2YOkFD
g+wRaVuFhEH4bhd1UM/0qZckKYHe4aP/KfzmHtTosb6bJT3gM5ZeUlr+sEbd
4n8e0bf98o9K/N8aqPsPN0Sc7g==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->272498335]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->170913875],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " can be combined with ",
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->43022358],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"Opacity", "[", "0.5", "]"}], ",", "Thick"}], "]"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->891938947],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxVz39MzHEcx/FTY0omxSI/Immhu1yHSznf13Xdr7qyClnERiYsGo2tYWWY
ifwhOsw6LWM2aX53lUvkFBeHXKbc5fy4677XHZPNmPPj3t8/fLbvvnt8nt99
3t/PzPXbczYG8Hg89Z/n79u/vAzv/4X4x5WPG6qaaH80Wp5LZvmKO8mhWKDX
nzQ5n5MnYOumec5ktpc8Cd6RGaWOhrfkqciXXog4Nv4deQaaJis2bzv3nhwN
0y9De/XXj+QYSC8VaAPHO8mxGAoJOr7cPUiOQ9IGvqbjAEuei44VkXWyF25y
PDKmd3zf3TNEFiBwIM1qOuwhz0dlcfzZMhdnITpSbcaKn5wTcUubYLndzFkE
78TWivY5nBcgLykyKkLFnb8QihvmwW+TuPmL8GOHi9lc6yKLMdpy+bXIyt0n
CdEJq/jmvk/kxdCa7w8XnvtATkZj19OxV2Pt5BQ0H9Q1/9xnIy9ByMWYGGH+
G7IEbR8KZu0o6SEvxYv5qld3arvJDFb33CpOCm0nA4JQ7f5x6Rf8LgcS+Y7F
YvsVg79LURNyuytA+MDvcilKNb7Qzvxn1FMRtV6/L2XnK+qp+Gz2yqQ5fdRl
kE4RsFu+2qjLoGtjfSur7dTT0H09ii8I+Eg9DQ3T+/qbxA7qcrQ+eleWmzBI
XY7esGfWL3YXdQVmHxmRnJLtpq6AJ04uPLRziLoS5TBK3EoPdSX0bEF49hMy
T4UcVjxunY/rKvgkIWeqbVxXo94VvQslXFdDdNo2XHGVOz8dTdG9UxU6bn46
LDH6a6lylnoGxGEtyz3nuf/PQMnIxJo9eu5+GuQ1Bmd1nuDur8GN4VMRK0Xv
qWdCZyxTi2sHqGeiy1plDG7pp56FKa1jCrVuC/UstNU1Hvk8YKa+DGt+iCyT
s43Ul2Ga6e6bVfKbhqMCvaOuMhIbw6u018IHGL/joFQdHOWzsoyzrvLPjhDx
l5iLZ+95qIvBLwzy6h46mIS/FEhQ1GasZ3Jf+r8vkiK2SLyd3dZt+JeT0+AO
WzuDCfzknzdGibzgxOxvuR7D2lKzPKJfjcz8vXOYQbfh33kNGlw2Oe3pMrvh
N0PLiwA=
   "], {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], Thickness[Large], Opacity[0.5], 
      {RGBColor[1, 0, 0], LineBox[{1, 2, 3, 4, 5, 6, 64}]}, 
      {RGBColor[0, 0, 1], LineBox[{64, 7, 8, 9, 10, 11, 12, 65}]}, 
      {RGBColor[1, 0, 0], LineBox[{65, 13, 14, 15, 16, 17, 66}]}, 
      {RGBColor[0, 0, 1], LineBox[{66, 18, 19, 20, 21, 22, 23, 67}]}, 
      {RGBColor[1, 0, 0], LineBox[{67, 24, 25, 26, 27, 28, 29, 68}]}, 
      {RGBColor[0, 0, 1], LineBox[{68, 30, 31, 32, 33, 34, 69}]}, 
      {RGBColor[1, 0, 0], LineBox[{69, 35, 36, 37, 38, 39, 40, 70}]}, 
      {RGBColor[0, 0, 1], LineBox[{70, 41, 42, 43, 44, 45, 46, 71}]}, 
      {RGBColor[1, 0, 0], LineBox[{71, 47, 48, 49, 50, 51, 72}]}, 
      {RGBColor[0, 0, 1], LineBox[{72, 52, 53, 54, 55, 56, 57, 73}]}, 
      {RGBColor[1, 0, 0], LineBox[{73, 58, 59, 60, 61, 62, 63}]}}}, {
     {Hue[0.67, 0.6, 0.6], Thickness[Large], Opacity[0.5], 
      PointBox[{64, 65, 66, 67, 68, 69, 70, 71, 72, 73}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 63.}, {-0.9999232575641008, 0.9995736030415051}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->540577279]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->534064321],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshStyle"]], "InlineFormula"],
 " by default uses the same style as ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->214639584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Red"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1575199054],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJxVz3tIk1EYx/GlCGYLtQte05omVm5eZs1L5m+bm7epaKZiSWBGWFiiUiAh
GhWhZH9kuQrRJCmCVMq0TU2xZKnNnKIz1Davqdu8hAahtAqf948OHA6f9wvn
vM+BzCtJ5y1YLFb43/3v3For4az/F3z6yvrqyxX03Rptg2Ee5pwesh0ClcoH
6oVB8h5cunBkIcQ4SnbEilVswXz9N7Ir0oV1Dnftp8j7oXCSZl+umiFzoP7d
0VWxNkf2hPBFhtzSfoHshSX29nvJpkWyN4LOcWXdN43kw+g+5VwrHjKRfRDr
1v3r2vASmQfLyQid+s4y2Q9lOT5PCg2M/dEt0qtKNhkHoFnuq21pZczHyt72
kq5DjAORGuTs7hDF3H8U0ibN4k9H5v1j2MgzhGdXG8gCWGtffuXrmHmCwPFN
42rGv5ODIdd8WM+qmiWHoLH3y84Gr2lyKFpv1bRuFunJx8F+7unpnz5GDkPn
bIZHXu4w+QSG/KJG3lX3k8Nxerg5J8iuiwzw7OQ3bGPqtlwMBHDngwXTrzq2
uhCV7JZeC/+PWy4WokBmtutJH6Augnumsig0f4S6CKuaFbEwaZy6GEIXnvHi
mp66GDWdRnNKxTT1CPS/cefyLOaoR6DebXxCIZinLkH7p6nCk76L1CUY3TWg
+zFtoC7FwdJtIaGJJupSLHtL/G/nL1GPRDFUYabIZeqRUBozdid+JrOikGQU
2J41Mz0K5jD24wo906PxzMC5ilymR4P/SL9e0sDcHwMFZ9RVWsO8HwOtp/K1
SGKkHgvBrrbk5afM/8ci1yqg8rqSmU+G1Eab+J77zPwyNK0/dEjhz1CPQ42q
MFpQPUk9Dr26cpVN2wT1eLi078iSm7TU49FZ21i6OqmhnoAzG3ytU6KKegL2
qd+PpUnedvwBRjQ7Kw==
      "]]}}, {
    {RGBColor[1, 0, 0], PointBox[CompressedData["
1:eJxVz3tIk1EYx/GlCGYLtQte05omVm5eZs1L5m+bm7epaKZiSWBGWFiiUiAh
GhWhZH9kuQrRJCmCVMq0TU2xZKnNnKIz1Davqdu8hAahtAqf948OHA6f9wvn
vM+BzCtJ5y1YLFb43/3v3For4az/F3z6yvrqyxX03Rptg2Ee5pwesh0ClcoH
6oVB8h5cunBkIcQ4SnbEilVswXz9N7Ir0oV1Dnftp8j7oXCSZl+umiFzoP7d
0VWxNkf2hPBFhtzSfoHshSX29nvJpkWyN4LOcWXdN43kw+g+5VwrHjKRfRDr
1v3r2vASmQfLyQid+s4y2Q9lOT5PCg2M/dEt0qtKNhkHoFnuq21pZczHyt72
kq5DjAORGuTs7hDF3H8U0ibN4k9H5v1j2MgzhGdXG8gCWGtffuXrmHmCwPFN
42rGv5ODIdd8WM+qmiWHoLH3y84Gr2lyKFpv1bRuFunJx8F+7unpnz5GDkPn
bIZHXu4w+QSG/KJG3lX3k8Nxerg5J8iuiwzw7OQ3bGPqtlwMBHDngwXTrzq2
uhCV7JZeC/+PWy4WokBmtutJH6Augnumsig0f4S6CKuaFbEwaZy6GEIXnvHi
mp66GDWdRnNKxTT1CPS/cefyLOaoR6DebXxCIZinLkH7p6nCk76L1CUY3TWg
+zFtoC7FwdJtIaGJJupSLHtL/G/nL1GPRDFUYabIZeqRUBozdid+JrOikGQU
2J41Mz0K5jD24wo906PxzMC5ilymR4P/SL9e0sDcHwMFZ9RVWsO8HwOtp/K1
SGKkHgvBrrbk5afM/8ci1yqg8rqSmU+G1Eab+J77zPwyNK0/dEjhz1CPQ42q
MFpQPUk9Dr26cpVN2wT1eLi078iSm7TU49FZ21i6OqmhnoAzG3ytU6KKegL2
qd+PpUnedvwBRjQ7Kw==
      "]]}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 63.}, {-0.9999232575641008, 0.9995736030415051}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4765930]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21221],

Cell[TextData[{
 "Compare the ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " prime to an estimate:"
}], "ExampleText",
 CellID->20192],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Prime", "[", "n", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "80"}], "}"}]}], "]"}], ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"n", " ", 
       RowBox[{"Log", "[", "n", "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "80"}], "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32076],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxd00tOFFEYBtAKI4c1YODAQUsMIcYQQFDAByWCD0QtHjG+EkueBhRaEJTZ
XUIvoZbQS+gl9BJqCb0ENXXuoJqEfH346q8u6t57c+d0c38kSZL83+//rH8G
Sz5kzbw2lKMylTeG/j4ur8vbQ9dNy5a8K8fkfXlLPhq675KcqDMsN78nrPAd
XuVJfs5TvNZ8rvCaZ/hN8zl7Oc/yBs/VmW3yPf1W8//qbfO869/xAr/nRf7A
D8xHP+SP7D1ln/gxf2bvrfeFszqLos7Ara/6J3oOXO7ol+usOK5Duat/an5P
zxUn1qnc13NxoLduJcd1rA71zzzvNz2XnFjnKvZcHOlf6I/1XHzXv3Q/Dtz6
obdvKo77qHWif+V+p3pO2/r1OtscuB97+3AQe85/6u3LDsd92o39W9ef6Xnq
XG8ftznjDgfuc9z33V/m7fv0wjx3OXCf4zlJL807J22O52bAgfPf5rnLiXM1
4IzzP+a5z/EcplfmncPOVfYXpEyNSw==
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJxV021MU2cYxvEz6gZhbiLMBQUmUxAFIRWqjNqXiwq0QGkPLW7V4XCosAqt
CO0A33JmzIiCuqGYRgO1LFmiosYaI0RGyGCyuLhsMokzTojGjC0GNFFRynAu
XF92Jycnv/PPnTwfnvN+6TbLliBBEMRXz3/vmXmkFf4/GM+YnNalPOP3EHy1
T9Y5vCEUMw5jf5d+B6h7olwWGUtHIsjjDRikeDoas+dU2uI0SXQsas6s1vrb
5fQiVH4TdK38ahodh+LT7Yltb6TTSxDy0BRdv1FJL0W3Qx3V/quaTkSQLnJT
RAfo5UjtnxqU1+voFLTWdN50mbNoOc+fQ69AdcKCPeHzDHQqLsu6fFtleXQa
+o/GJ4w8z6cVcN8RF0Q8LaBXwtByY9HZCTO9CpO1k3PlQiGdjqIu56HqYAv9
Aa74HK2751rpDIjHLuxPe6+IVmJg3v3puuS19GrcntD1KbQf0ioMS307zdaP
aDWM5/x1F+02WoMV83fuN+5dR2vx0mccCm5dTwMVP3b2DHZ9PGMJ8JTt6vbe
KmbPxM2233KLX2xgz4S3+vdrk1El7Dq85r/cvSp2I7sO9YGuU9aLtLAGU2MV
r5v0n7KvgXPUH1h4hxayYGh4Oat/eyl7FkrLDo8oQjaxZ2OJTXPY4aWlbJx4
e8hkT9/MnoOx+usti3+hpRwMLKuY47FvYdej57zW872sjF2Pq1VjSm8bLRjg
aVIlJyrL2Q1IOvjJ9ZIhWsiFz73Hq6r5jD0XPzW58r8Ls7PnofGvs8fvnqOl
PGjWqz5vLdjKno/w3jcfPHtIS/lILcsIHW2qYDeiSX1gsTO5kt2IceU/DV/+
TAsFqCyp/TalysFegFpFw6zN4U52E37oUavjLtGSCS9iogSHbRu7GcGqt8JU
U7RkxpVGrU8vVrGL/P9oiIjace+P4qe0JKLPFf1FjmH7jHtFBB67Fc4T9Kt7
HdM4EDo4RqMQNzrux7h01dwvhGrccEg8RvcWQn/31t7yv2nBgoR7zUs7NTXc
t6B92uLPPEJLFtyOP2qTjdK9FpwcWbluSuXivhUtEdkTSc00rKjqGNjx9Z+0
ZIUuuFG+XO3mvhWhw0/sgWZaKMLak0O7pkfd+Be1gFI0
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 80.}, {0., 409.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->60396670]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->250474635],

Cell["Show a random walk in one dimension:", "ExampleText",
 CellID->659242325],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Accumulate", "[", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "250"}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1017621402],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw1lgs4lGkbx+ezhXRgqa02fFMOq3JYtDWi/ENl6TCYYTAxjGGcSyetDu+2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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 250.}, {-12.276149183548764`, 1.0375192187734554`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2671607]
}, Open  ]],

Cell["Show a random walk in two dimensions:", "ExampleText",
 CellID->663008312],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Accumulate", "[", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"250", ",", "2"}], "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2035539148],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVl2k41G8Xx8cwMmaMmTG2ViQVklRCuI+lIkv+oiKKkIiisqTSKEolOxWS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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-6.444345249622804, 6.623370276221855}, {-2.575556974878785, 
   6.038529313736987}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->245471473]
}, Open  ]],

Cell["Random walk on a lattice:", "ExampleText",
 CellID->2100579346],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Accumulate", "[", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", "250"}], "]"}], "]"}], 
   ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1974704815],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJylljtqw0AURYdUKqdwoUKFIoQQxngL0hq8hEDqLFFekutUSXDugI7nMrI1
EMzJee/OF+P3j6/L51sI4fv37+/zPm5LWI9rnm8T/Jz3ykv1AX7a59OY8X9w
VfDF/FDw8xorcAQfNnrNQ65RT2Y+fQNulb/kuQP36CcPxmv9qX7O84B6cqm/
A6f9THnmeTTGl/pfvR/dv/r5Huz7WJB3XXNlOIIr46Opd/3RcACnd21YowbT
R8M6F/pSvjjdo/yMfnBV8G5/yS+Yf8l77o8+5V+xfvDW/Krg7flP8PM6j/zq
+ynd797z5/toDKuevn2yvwV3hnWfYp1jb5j1ZDc/15/8hH59LxvWsH6+fwxg
+rQ/1ItHw6Hgo/FHw8wLxu/tL62f+acnvTgYvzf/vHH+iHryAfXiI3gseHGN
ejLzSp7vR34A9+AO3Bquwfq90Rluje8Nq34A0zN/r28NNxu92z/PS9wY5nyN
8TX4YFjrjeDKcPfPwXAPTr+HlzXTi0fwEfOTT6gnn1FPVn0Eb83XerQ/sut/
8CHPKW9ac8mLx40+fW8/2f+4/h9HV0cM
     "]]}},
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-15., 2.}, {-3., 15.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 188},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1290122894]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1479664],

Cell["\<\
Compute and plot the shortest tour through a hundred random points: \
\>", "ExampleText",
 CellID->224890095],

Cell[BoxData[
 RowBox[{
  RowBox[{"pts", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"10", ",", 
     RowBox[{"{", 
      RowBox[{"100", ",", "2"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->820365792],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"pts", "[", 
    RowBox[{"[", 
     RowBox[{"Last", "@", 
      RowBox[{"FindShortestTour", "[", "pts", "]"}]}], "]"}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->339646131],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVknk81AkDh8c17hkzrjnMzxzpcJREivL7bjrYXJWmolLC2sIWsuwuSuE1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      "]]}}, {
    {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJwVknk81AkDh8c17hkzrjnMzxzpcJREivL7bjrYXJWmolLC2sIWsuwuSuE1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      "]]}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 9.948915623031256}, {0., 9.925157393905701}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[2]=",
 CellID->14281400]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1348366412],

Cell["Create a stacked line chart:", "ExampleText",
 CellID->1746843340],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "2", ",", "3", ",", "3", ",", "4", ",", "8", ",", "8", ",", "8", ",", 
       "8", ",", "9", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "1", ",", "4", ",", "5", ",", "5", ",", "6", ",", "7", ",", 
       "9", ",", "9", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "4", ",", "5", ",", "7", ",", "7", ",", "8", ",", 
       "9", ",", "9", ",", "10"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->947077243],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Accumulate", "[", "data", "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Axis", ",", "LightRed"}], "}"}]}], ",", 
      RowBox[{"2", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "1", "}"}], ",", "LightOrange"}], "}"}]}], ",", 
      RowBox[{"3", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "2", "}"}], ",", "LightBlue"}], "}"}]}]}], "}"}]}], ",",
    
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Orange", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->378431537],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 2.}, {2., 3.}, {3., 3.}, {4., 4.}, {5., 8.}, {6., 
   8.}, {7., 8.}, {8., 8.}, {9., 9.}, {10., 10.}, {1., 3.}, {2., 4.}, {3., 
   7.}, {4., 9.}, {5., 13.}, {6., 14.}, {7., 15.}, {8., 17.}, {9., 18.}, {10.,
    20.}, {1., 4.}, {2., 6.}, {3., 11.}, {4., 14.}, {5., 20.}, {6., 21.}, {7.,
    23.}, {8., 26.}, {9., 27.}, {10., 30.}, {1., 0.}, {10., 0.}}, {{{}, 
     {RGBColor[1, 0.85, 0.85], EdgeForm[None], 
      GraphicsGroupBox[PolygonBox[{{1, 31, 32, 10, 9, 8, 7, 6, 5, 4, 3, 2}},
        VertexColors->None]]}, {}, {}, {}, {}, {}, {}, {}, 
     {RGBColor[1, 0.9, 0.8], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 20, 19, 18, 17, 16, 15, 14,
         13, 12, 11}},
        VertexColors->None]]}, {}, {}, {}, {}, {}, 
     {RGBColor[0.87, 0.94, 1], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 30, 29, 28, 27, 
        26, 25, 24, 23, 22, 21}},
        VertexColors->None]]}, {}, {}}, {{}, {}, 
     {RGBColor[1, 0, 0], LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}]}, 
     {RGBColor[1, 0.5, 0], 
      LineBox[{11, 12, 13, 14, 15, 16, 17, 18, 19, 20}]}, 
     {RGBColor[0, 0, 1], 
      LineBox[{21, 22, 23, 24, 25, 26, 27, 28, 29, 30}]}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 10.}, {0., 30.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->952723900]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2145090741],

Cell[TextData[{
 "Show the numbers of graphs with different numbers of nodes available in ",
 Cell[BoxData[
  ButtonBox["GraphData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphData"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->132723446],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Length", "[", 
     RowBox[{"GraphData", "[", "n", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "50"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->289378790],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1., 1.}, {2., 2.}, {3., 3.}, {4., 5.}, {5., 7.}, {6., 12.}, {7.,
      11.}, {8., 20.}, {9., 14.}, {10., 23.}, {11., 14.}, {12., 64.}, {13., 
     17.}, {14., 56.}, {15., 47.}, {16., 36.}, {17., 11.}, {18., 36.}, {19., 
     11.}, {20., 23.}, {21., 0.}, {22., 11.}, {23., 1.}, {24., 23.}, {25., 
     3.}, {26., 15.}, {27., 2.}, {28., 15.}, {29., 0.}, {30., 24.}, {31., 
     0.}, {32., 24.}, {33., 0.}, {34., 13.}, {35., 0.}, {36., 14.}, {37., 
     0.}, {38., 10.}, {39., 0.}, {40., 8.}, {41., 0.}, {42., 2.}, {43., 0.}, {
     44., 1.}, {45., 1.}, {46., 1.}, {47., 0.}, {48., 3.}, {49., 0.}, {50., 
     5.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 50.}, {0., 64.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1413817491]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1356558605],

Cell["\<\
Show the density at standard temperature and pressure for the elements:\
\>", "ExampleText",
 CellID->183278447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ElementData", "[", 
     RowBox[{"z", ",", "\"\<Density\>\""}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "118"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->222503889],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxdkktIVFEchw9TREEPF0MNEpGSoj3sNdX0nKNmL81ysl3QMFCLEGYTFWRw
ooX0wE1Elr3sQVKLKMvRUrlaWJmBVAQujBa5CFrMIoQoqPT3nUUduHx853f/
/3PuuScvlU4cCBljav8+49TIxn/M+pp5MCkTZ8JODy1qmD3cj0+1E+hwoskR
P1/Bw2LsFh4RW1vwufZQ1+Hzkcnf6TffHu25nrt0ZAzPt6dLk6ND+T/xBfbt
4Pj4hheqj22kX5FY1IwvFCN38MVi9CZeItb7/S4Tb1zDl9tTwUBLRfs0fIUt
mHLyQvnZX6y/UvPBGfIo39uErxITd/HVYvNDfI34KYPHxC/P8LViSTe+Tuzr
wdeLqV58g3jQ+0axzvum//rHxRy/vhXfPBYdvr+dvFR8/4gcT7aSl8GZ5Hj2
IvPl4rnb5Pgxfx6bxXQnOd4dkFeI4Rfk+JF+8i1i8StyvAY3Wyfojr8kl5sT
9DPbxFHWc3hjF/n2f93hxU/Jd4jJDnK8qo280l6+ND7mkFeK+66SV4l198nx
EP3MTjGP9Rye5bxMtZji/zo86fe/S+z0+8fr+d9mtzjC/bJyN8OfB96GB/gS
f79qxCe4lbtoH/Xk99hvQB57Tn1C/P2aerkrG6IeH3xHPe83fKB+j/LwR+rx
ebjDm3g/kJth+plaMT1APV7g7wteyH0L8Fy//73iWK/9A1KC0Fc=
     "]], 
    LineBox[{{88., 5000.}, {89., 10070.}, {90., 11724.}, {91., 15370.}, {92., 
     19050.}, {93., 20450.}, {94., 19816.}}], 
    LineBox[{{96., 13510.}, {97., 14780.}, {98., 15100.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 98.}, {0., 22650.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->670099118]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->951631358],

Cell[TextData[{
 "Distribution of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " symbols by length:"
}], "ExampleText",
 CellID->1366768117],

Cell[BoxData[
 RowBox[{
  RowBox[{"n", "=", 
   RowBox[{"StringLength", "/@", 
    RowBox[{"Names", "[", "\"\<System`*\>\"", "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1757514697],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Sort", "[", 
   RowBox[{"Tally", "[", "n", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2059431641],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1., 8.}, {2., 11.}, {3., 49.}, {4., 101.}, {5., 117.}, {6., 
     126.}, {7., 150.}, {8., 221.}, {9., 226.}, {10., 226.}, {11., 219.}, {
     12., 205.}, {13., 199.}, {14., 187.}, {15., 173.}, {16., 146.}, {17., 
     146.}, {18., 80.}, {19., 59.}, {20., 66.}, {21., 57.}, {22., 35.}, {23., 
     41.}, {24., 30.}, {25., 21.}, {26., 12.}, {27., 14.}, {28., 9.}, {29., 
     6.}, {30., 4.}, {31., 5.}, {32., 4.}, {33., 1.}, {34., 2.}, {36., 
     1.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 36.}, {0., 226.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1909523555]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->70408815],

Cell[TextData[{
 "Plot the sample behavior for different ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions: "
}], "ExampleText",
 CellID->305339583],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"Sort", "@", 
      RowBox[{
       RowBox[{"Reap", "[", 
        RowBox[{"f", "[", 
         RowBox[{
          RowBox[{"Sinc", "[", "x", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "0", ",", "15"}], "}"}], ",", 
          RowBox[{"EvaluationMonitor", ":>", 
           RowBox[{"Sow", "[", 
            RowBox[{"{", 
             RowBox[{"x", ",", 
              RowBox[{"Sinc", "[", "x", "]"}]}], "}"}], "]"}]}]}], "]"}], 
        "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "1"}], "]"}], "]"}]}], ",", 
     RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "f"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"NIntegrate", ",", "Plot", ",", "NSum"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->156466751],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{487, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->94758077]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4806696],

Cell[TextData[{
 "Plot the sample order in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " space used by ",
 Cell[BoxData[
  ButtonBox["Plot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot3D"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->169656083],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", " ", "y"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "2"}], "}"}], ",", 
     RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
      RowBox[{"Sow", "[", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], "]"}]}]}], "]"}], ",", "_", ",", 
   RowBox[{
    RowBox[{"ListLinePlot", "[", 
     RowBox[{"#2", ",", 
      RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}], "&"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->82600449],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{400, 181},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->857653837]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(11)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27462],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListLinePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLinePlot"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->528126457],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListLinePlot", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Binomial", "[", 
       RowBox[{"9", ",", "k"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "0", ",", "9"}], "}"}]}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Binomial", "[", 
        RowBox[{"9", ",", "k"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "9"}], "}"}]}], "]"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->671449748],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{1., 1.}, {2., 9.}, {3., 36.}, {4., 84.}, {5., 126.}, {6., 
       126.}, {7., 84.}, {8., 36.}, {9., 9.}, {10., 1.}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 10.}, {0., 126.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{1., 1.}, {2., 9.}, {3., 36.}, {4., 84.}, {5., 126.}, {6., 
       126.}, {7., 84.}, {8., 36.}, {9., 9.}, {10., 1.}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 10.}, {0., 126.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{390, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->91158223]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->762793504],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " to visualize functions:"
}], "ExampleText",
 CellID->71264896],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "^", "2"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}], ",", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"Sin", "[", 
         RowBox[{"x", "^", "2"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "5", ",", "0.1"}], "}"}]}], "]"}], "]"}]}],
   "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33614225],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 91},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->283639899]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->448224811],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListLogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLogPlot"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ListLogLogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLogLogPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ListLogLinearPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLogLinearPlot"]], "InlineFormula"],
 " for logarithmic data plots: "
}], "ExampleText",
 CellID->46767761],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"25", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "25"}], "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24914874],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->231315081]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1505829194],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListPolarPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPolarPlot"]], "InlineFormula"],
 " for polar plots:"
}], "ExampleText",
 CellID->376483663],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Sqrt", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1074099979],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdins8FAYcwO8cYl5NwiKxUti1dJI81u/yyTpWNu8+dj5FHXntVh0f85op
z9ojz85MGIkmxjqZj/sdY56jkRbuCOeO8zqcRxzW/t338/l+vv98TQKY7gwF
AoEAb/2v/8e+r8bk+MEXoCgoqpOZF4IPV7NcT4MPGcKxnjouB2zgb/907muQ
/9Mhm6trgdt9Hta6JePgWvlLRFhyL5CCxK4JwxMweMHQwbFmAFTZW7PmEULQ
8d6MG90aht44Uo5FtBCYI7QbITAGsyG5N0elE+CvbpNMThVC/pn7udMj46DU
2tTFaRPDXeWnWmYuYzCvrvq955wEzOPCXt68MQKNBw6JDafn4Eu0x1tBg8Au
YJYSvaVgHN5jq57UDxsKUZbrmYsgEF3tFjV2wMU0HdZC2RLstp5I5hzlQH43
U23rzjIcWX6XYjRdjCmdMS8EdjI4UOxU3J7QiiGnCy0Uq2XQk6E1YJfYjzSH
oqESsQwOugd8sC+Jj2HJUdebR2TgqlmxaDYwjgHVsfknM2VAqrJhU4LFqJ3t
619PkkFJ1pmPa+dnsG/XEFF0bBlC/VbyBiykKDhNDv1Ifwl8XUrfGJ9bwhY9
K4PDXCmwvZyZMWdl+KDC5XXfuXkIKrd7eM1gFa1SuTw6WwKDC1W9bS1reDjc
03EiSgS39XT9JbZvsOWv2tzVhTFIU/GtL2dtYPepE1doe4bgMccqOIa5iW5P
iHEBzr1wJ29ScMtUjhUGvZTpxhr48GU/pSxDjqzO2CxWw++o6dq/nFsrR8Yf
Hjy5dx/aNOsUTiTJse1qt6KG2QhW0ne3yHfJkc63JKsRJjFurTXF0XYTveVq
RpQRCUo7VrKV9m0gLUs0Ee0qxS5WBi398To2ILk6bO8yvuOQpKkiXUWdGfsq
14YVbDo0rPxQIsMnRnxBvc06rvsmDLAeLOEqXfEpO3EDL04+a2TskWL22TmK
U5YcybFT5Pj7EmRdHp7KYWzjzmrlNcMiIQbfC/iTJN3BKA6l9vMCPrqRFY69
yiHwFrRjhcqdPXipLOp4szqRZ8zgVT1K+BGfnSJrF/gQed7q3KbStHaIDyJM
NUQQef2Tpt0+YUOgnDlvKmS8/Sv1rXTPC8GpKJBLP0LkpZNST5R8NgNp1PGZ
2XoCT9Fr3URffxECgrd/GN1P4P1s/v717FAZtEeXnld5tI3fGL7nZ85egzyL
lMv0Bjney5g8Gpm7ARriC5GBX21g1hfMtFi/Lfg6PoLXI1rDLveI/ZzxHai0
N/7NUnUFRcklP+VqEam/NrkFaooXMcmD/m2vkgJV5rw3MlFrDiWXGKfxuQKV
Vrip+1w0iZ6eCdbfhZOoV/qF+EkXH/NOfhryapBE3WF5qQTFdOK/pJwSMQ==

   "], {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
      19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 
      37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 
      55, 56, 57, 58, 59, 60, 61, 62, 63}]}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->758152982]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->584618151],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["DateListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateListPlot"]], "InlineFormula"],
 " to show data over time:"
}], "ExampleText",
 CellID->939578832],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "34", ",", "51", ",", "11", ",", "5", ",", "39", ",", "47", ",", "28", 
     ",", "42", ",", " ", "66", ",", " ", "13", ",", "24", ",", " ", "31"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2006", ",", "1"}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1054173033],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{3.3450624*^9, 34.}, {3.3477408*^9, 51.}, {3.35016*^9, 11.}, {
     3.3528384*^9, 5.}, {3.3554304*^9, 39.}, {3.3581088*^9, 47.}, {
     3.3607008*^9, 28.}, {3.3633792*^9, 42.}, {3.3660576*^9, 66.}, {
     3.3686496*^9, 13.}, {3.371328*^9, 24.}, {3.37392*^9, 31.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  AxesOrigin->NCache[{3345062400, 0}, {3.3450624*^9, 0}],
  Frame->True,
  FrameTicks->{{Automatic, Automatic}, {{{
       NCache[3345062400, 3.3450624*^9], 
       FormBox["\"Jan\"", TraditionalForm]}, {
       NCache[3352838400, 3.3528384*^9], 
       FormBox["\"Apr\"", TraditionalForm]}, {
       NCache[3360700800, 3.3607008*^9], 
       FormBox["\"Jul\"", TraditionalForm]}, {
       NCache[3368649600, 3.3686496*^9], 
       FormBox["\"Oct\"", TraditionalForm]}, {
       NCache[3376598400, 3.3765984*^9], 
       FormBox["\"Jan\"", TraditionalForm]}, {
       NCache[3347740800, 3.3477408*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3350160000, 3.35016*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3355430400, 3.3554304*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3358108800, 3.3581088*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3363379200, 3.3633792*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3366057600, 3.3660576*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3371328000, 3.371328*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3373920000, 3.37392*^9], 
       FormBox["\" \"", TraditionalForm]}}, {{
       NCache[3345062400, 3.3450624*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3352838400, 3.3528384*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3360700800, 3.3607008*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3368649600, 3.3686496*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3376598400, 3.3765984*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3347740800, 3.3477408*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3350160000, 3.35016*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3355430400, 3.3554304*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3358108800, 3.3581088*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3363379200, 3.3633792*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3366057600, 3.3660576*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3371328000, 3.371328*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3373920000, 3.37392*^9], 
       FormBox["\" \"", TraditionalForm]}}}},
  GridLines->NCache[{{{3345062400, 
       GrayLevel[0.8]}, {3352838400, 
       GrayLevel[0.8]}, {3360700800, 
       GrayLevel[0.8]}, {3368649600, 
       GrayLevel[0.8]}, {3376598400, 
       GrayLevel[0.8]}}, None}, {{{3.3450624*^9, 
       GrayLevel[0.8]}, {3.3528384*^9, 
       GrayLevel[0.8]}, {3.3607008*^9, 
       GrayLevel[0.8]}, {3.3686496*^9, 
       GrayLevel[0.8]}, {3.3765984*^9, 
       GrayLevel[0.8]}}, None}],
  PlotRange->{{3.3450624*^9, 3.37392*^9}, {0., 66.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->None]], "Output",
 ImageSize->{184, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1172134152]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->443981753],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListPointPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPointPlot3D"]], "InlineFormula"],
 " to show three-dimensional data plots:"
}], "ExampleText",
 CellID->1643132993],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "Pi", ",", "0.1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "0", ",", "Pi", ",", "0.1"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1643996578],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->97974335]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->157163518],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot3D"]], "InlineFormula"],
 " to create surfaces from data:"
}], "ExampleText",
 CellID->660946410],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "Pi", ",", "0.1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "0", ",", "Pi", ",", "0.1"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1740890586],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->195005635]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->668298874],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListContourPlot"]], "InlineFormula"],
 " to create contours from continuous data:"
}], "ExampleText",
 CellID->759701508],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListContourPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "Pi", ",", "0.1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "0", ",", "Pi", ",", "0.1"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1512963541],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxlnHdczf/7/6NIVKLSRJ32Xud09jlXhcjeMkJI9sjeROhtlIxkFkVSVvYs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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1614, 1651, 500}, {2192, 2191, 941}, {1575, 1574, 466}, {
         1976, 1975, 783}, {2171, 2170, 925}, {1464, 1502, 373}, {1848, 1847, 
         688}, {1462, 1461, 371}, {1307, 1306, 244}, {1728, 1727, 593}, {1888,
          1933, 722}, {1676, 1675, 543}, {2280, 2279, 1004}, {2193, 2238, 
         944}, {2263, 2307, 990}, {1155, 1195, 119}, {1310, 1351, 246}, {1153,
          1152, 117}, {1446, 1445, 352}, {2066, 2106, 849}, {1767, 1809, 
         627}, {2064, 2063, 846}, {1911, 1910, 734}, {2002, 2043, 799}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJxFlclLllEUxu/3fsNrq9QGF4EWldqqzKEkKFfRIpxNiEgpqFVaDgkFVrQV
p7RFYbapQCynFFs49Adk5rhSK4hoUY4FSWXP43mixU/ve+8598z323OhPL/M
c87VgBBIxJ9zoBjrIyDZd+5PxLlbEGoHl6KcywRlQefqwf6Q6VA2DuRDpgBU
ggowEXBuEqyClYDpRoPsoN2xHXs7QDpIA1fCzp0M2z6/o2H/E+xfw11N4Cxs
7QMZsHUGjEH2KSiF7O2AydFus+RHYOsLWISttyAT95WCCZz1gjzPfKYOdR/C
1uuIxZAKkrHOBmu4e0o+0dciUAiqIqZD2W0g1jcbvfLhGGxfBo2wfTVoPjXL
do9nsY1GzA/aPyy7BfJrHXeNg3joHgenIZsUsbwynycgkwVKQQmYxVlXxPb5
nQOdXNkuBwvIVQDnL6HbAnaqbqwfc3oQMoekQ13eVQcSPLvzAdYVIFa+voHM
GPgGvko3BeTpjjHlfVEyL3in9njGWu8Ca85q7m1xbhr5msPZb/BcOpSlLfqx
WzHTnyHmNsrkeF6IdSI4j3Utewx3N4WtXqxbrOqUKv97VAv2wzvP+jJHuWJ/
sveZU+aSM8DcsSfYC8whe3FvyPLI/NE2a8Za0YdJ9c2aZiBDuS5W/zLu785m
gPGXQPco6IatcdbPtxnk7I14Npt3Qzav/+4o1vxed6bXo1ioP4fYB0Al7r4H
GsM2Y2nq337oDIAZMA0OwFaub7Zo00XsDur2gQnY7gCtznTLlKsGvQediH8W
zGM9HDS9FuWK+vSjSns8Y28/4RvjWY8/42yCBKw3PNvnf37z/GfIfOiXv78g
m6R6M+f1+H4FYrBehl6dbzllLpY8i5m9UC0/xpWrZZ0X4a5a8Ej9w94ZDJs8
9T7irtgo62/2+Tp8icf5D+VwSHEzfvYwe7kjyvb5vaI+2HwrwDxY8P7HWq5Z
bVROOWuc+RX1LnNV45se5atV9/vOasLa3AnZPr87sZ4MWY0pw9wwBvrOHPFt
agLdshmt/RTNcr386NIcXoQvWeA9/HGexXYTtAUtRuaOPcAcMIfspRu+xcie
OhW2mUzXu98gu92y0ademdLvRhxsrUL+MdajAVvzzedbzz3WfrNmmrdp1eGH
5mpJtY1RbFv1n7HxreNb/zliv1d8cxkbbdIWY2xV3gbU722Ka1jxfkBsg77d
y/sYK3t4Q3Vl7tkjM7rD+TZj7XpP/gJXVP8Q
         "],
         VertexColors->None], 
        PolygonBox[{{2279, 2237, 973, 1005, 1004}, {2238, 2239, 975, 943, 
         944}, {1502, 1503, 404, 372, 373}, {1791, 1792, 639, 607, 608}, {
         1910, 1871, 703, 735, 734}, {1651, 1652, 531, 499, 500}, {1675, 1635,
          512, 544, 543}, {2170, 2132, 894, 926, 925}, {1574, 1536, 435, 467, 
         466}, {1847, 1808, 657, 689, 688}, {2191, 2150, 910, 942, 941}, {
         1152, 1114, 86, 118, 117}, {2106, 2107, 880, 848, 849}, {1306, 1273, 
         213, 245, 244}, {2307, 2308, 1021, 989, 990}, {2063, 2017, 815, 847, 
         846}, {1933, 1934, 753, 721, 722}, {1195, 1196, 150, 118, 119}, {
         2043, 2044, 830, 798, 799}, {1461, 1424, 340, 372, 371}, {1351, 1352,
          277, 245, 246}, {1975, 1932, 752, 784, 783}, {1727, 1690, 562, 594, 
         593}, {1809, 1810, 658, 626, 627}},
         VertexColors->None]}]}, 
     {RGBColor[0.35616142628527653`, 0.1665017509664138, 0.6176082871470167], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1934, 1933, 754}, {1536, 1574, 434}, {1810, 1809, 659}, {
         1792, 1791, 640}, {1731, 1766, 596}, {2134, 2173, 895}, {1275, 1309, 
         215}, {1806, 1805, 655}, {2308, 2307, 1022}, {2195, 2240, 945}, {
         1690, 1727, 561}, {1352, 1351, 278}, {2017, 2063, 814}, {1688, 1687, 
         560}, {1787, 1786, 638}, {1192, 1191, 148}, {2149, 2148, 908}, {1578,
          1613, 469}, {1890, 1935, 723}, {1931, 1930, 750}, {1652, 1651, 
         532}, {1424, 1461, 339}, {1997, 1996, 797}, {1331, 1330, 256}, {1556,
          1555, 447}, {1196, 1195, 151}, {1273, 1306, 212}, {1572, 1571, 
         465}, {1065, 1115, 56}, {2258, 2257, 988}, {2237, 2279, 972}, {1348, 
         1347, 275}, {2150, 2191, 909}, {2132, 2170, 893}, {2044, 2043, 
         831}, {2236, 2235, 971}, {1871, 1910, 702}, {1426, 1463, 342}, {2020,
          2065, 818}, {1932, 1975, 751}, {1114, 1152, 85}, {2062, 2061, 
         845}, {1503, 1502, 405}, {2107, 2106, 881}, {1808, 1847, 656}, {1635,
          1675, 511}, {2239, 2238, 976}, {1459, 1458, 370}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlFlsTmEQhr///P9Z3DR2boQGrboQe2rvhQhBNLUkxC62xNI2hNgT7hSt
JQQRN2ioWGoPXeLS3mraC6IECRJ7Yl+eN/NdPMmcM3PmzLwz35e9cHXRqsA5
txwykJ84lwWT086thAZe/oDH+C7BUnwjoARfBeRhz4Ct2PMgm9ju0InYITAz
Y+9kT4fTGcupXPvhLHYTXMU+CCPJtSyx3PrHw9i5nzAKuxucxdcCzVAFRdAL
5uDbDBMjnuFRyrlP0IQvaOPcb3xPYFXo3HjojG8oTMefm1jt6qEntfTy9aqH
o+S6DdMQaTDs4NvZ0INvC1JmDwKXsncLiB0Nz7D/wRxy7YDtMBseQWXGepcG
+tesjGmjf16j1+fQj1qy0tZ7ju9PGpTzfAPaY3+mnjP4NsFGOA0rqGUsdODf
g1Km7S9odqaxQ4uGxLSQJhWJzVR6X4Bh2Etgl59/28TeydZO/CRXo5+Xctbj
ewsfNStpmNiMNJstsBsWQxm+qrT1Mi2xWamn19g34Q72O/nJ3Ru6ahfhDb7a
xHLrH9+9htJOO6ld2ZdY7epB2ryEgWnTKJfYvIzlUs5yYm/BXV9PJbGN0ACn
oAMMh2q03RdYr1UZ2031nIfPwTZ8x6ELsy7w866Fr2j/AO7DF8gh9hf+LcQe
gye8q4ZSYvdCgK8vNGFfhpfYNVBIbDG0hhYj3wHYE9qMNdup2mHyZ8EeYs9B
RWg7rt2eAcO0K7H1op4KY+tBtdfBBGKLfbzOxBH+tQY6+n1Xb4si22X1qNoO
Qf/AapwcW4/qrQaukOtpaL2pxxZiz8M5aIZJUArtAjuf82OrUbU1wji+Xen7
0w6XRHamFatv5sbWs3p9ENisFsb2rXLk+n8oXneAanE8X/R6fyP2Xmx3ic6T
ajkMAwLLn9IsQ9Namv8LbWb6Vjn+4u/j+9VMW7GvxHZWdWY1+1Nw0u/AC3zX
/XnVTupu6BjZrkjPjbHtoHZvA5yE9bAOTkAdsa8i2wXp/Se2O1f31Zi03V2/
Y7P1TlrvgjKveT6+ebFpJc10V37z96nOn3K35bnc75t6mxLbLNWjvi2DD17v
tZHdidoN7UifyDSTVtph9bo7trtJPddHtlOK1x0qrXbC+8A006zLQ9tlzVy7
uDe03dVO/getHtu1
         "],
         VertexColors->None], 
        PolygonBox[{{1154, 1113, 85, 1152, 1153}, {1847, 1848, 687, 655, 
         656}, {2235, 2190, 940, 972, 971}, {2264, 2309, 1022, 2307, 2263}, {
         2279, 2280, 1003, 971, 972}, {1975, 1976, 782, 750, 751}, {1115, 
         1117, 1116, 1062, 56}, {1912, 1869, 702, 1910, 1911}, {1913, 1915, 
         1914, 1872, 704}, {1347, 1308, 1307, 1350, 275}, {1311, 1353, 278, 
         1351, 1310}, {2172, 2130, 893, 2170, 2171}, {1996, 1958, 1957, 2000, 
         797}, {1191, 1154, 1153, 1194, 148}, {2148, 2104, 877, 909, 908}, {
         1308, 1272, 212, 1306, 1307}, {1768, 1811, 659, 1809, 1767}, {1766, 
         1768, 1767, 1729, 596}, {2003, 2045, 831, 2043, 2002}, {1555, 1524, 
         1523, 1559, 447}, {1463, 1465, 1464, 1425, 342}, {1786, 1752, 1751, 
         1790, 638}, {1930, 1886, 719, 751, 750}, {1447, 1412, 320, 1445, 
         1446}, {1727, 1728, 592, 560, 561}, {1613, 1615, 1614, 1576, 469}, {
         2173, 2175, 2174, 2133, 895}, {2067, 2108, 881, 2106, 2066}, {1687, 
         1649, 529, 561, 560}, {1309, 1311, 1310, 1274, 215}, {1465, 1504, 
         405, 1502, 1464}, {1615, 1653, 532, 1651, 1614}, {2257, 2219, 2218, 
         2261, 988}, {1677, 1633, 511, 1675, 1676}, {1805, 1764, 624, 656, 
         655}, {2191, 2192, 940, 908, 909}, {1156, 1197, 151, 1195, 1155}, {
         2065, 2067, 2066, 2018, 818}},
         VertexColors->None], 
        PolygonBox[{{2061, 2016, 814, 2063, 2064, 845}, {1935, 1936, 754, 
         1933, 1888, 723}, {1571, 1535, 434, 1574, 1575, 465}, {1458, 1423, 
         339, 1461, 1462, 370}, {2240, 2241, 976, 2238, 2193, 945}},
         VertexColors->None]}]}, 
     {RGBColor[
      0.43683493940537443`, 0.30677120318977313`, 0.7310046691549967], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1498, 1497, 401}, {2190, 2235, 939}, {1768, 1766, 628}, {
         2153, 2194, 914}, {2219, 2257, 956}, {1845, 1844, 686}, {1694, 1730, 
         565}, {1764, 1805, 623}, {1354, 1391, 279}, {1154, 1191, 116}, {1199,
          1236, 152}, {1231, 1230, 179}, {1111, 1110, 84}, {2016, 2061, 
         813}, {2147, 2146, 907}, {1958, 1996, 765}, {1851, 1889, 692}, {1386,
          1385, 306}, {1907, 1906, 733}, {1886, 1930, 718}, {2060, 2059, 
         844}, {2067, 2065, 850}, {1441, 1440, 351}, {1535, 1571, 433}, {1524,
          1555, 415}, {1465, 1463, 374}, {1117, 1115, 88}, {1752, 1786, 
         606}, {1609, 1608, 496}, {2167, 2166, 924}, {1929, 1928, 749}, {1724,
          1723, 591}, {1915, 1913, 736}, {1980, 2019, 787}, {1213, 1212, 
         160}, {2277, 2276, 1001}, {1311, 1309, 247}, {1649, 1687, 528}, {
         2222, 2262, 959}, {1672, 1671, 542}, {2234, 2233, 970}, {1308, 1347, 
         243}, {1615, 1613, 501}, {1540, 1577, 438}, {1423, 1458, 338}, {2175,
          2173, 927}, {1936, 1935, 755}, {2241, 2240, 977}, {2104, 2148, 
         876}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlG1ozXEUx/939/4fCKlNUjITZitvMITm9TxNlzbKtkwKLdsYW1GLtqJl
bCQvluEFKzbkoXA9viRbM9OITLRYlDVstQc+X+f/4nM793fO75zzOw//tOLS
+N4kx3HyIAZv+BmFEeiGXYHjrIJ9UcdphHrXcfbAoojjxGEich92T7jbC/Ow
HfYdZwjmIg+gfwHV2DbDR87vwGR8LYQCdEtgMWwLbS9CUcTuzED+g/8ufA9C
A3cTkMzdQRJ/gP4TnMX2INxF1+ubb8VYRg6TYB1ySdRyfQgXHMt5HNtM9Bkw
Fsr5kBeebQrsTXpLHC5hsx8+EHsMxon9DhqIfRNasKmEJmIlopZbzCOviOV4
At0OqEN3FZLQ9Yb5yyYFXXZY7zjcQN8DhcTKTrJeJAemk41qeRx+JNl7v2E7
jf9n+F8BychfPZN1lkOsVBji7dOJ99q3GujtXZCGbo1rOtm0cHZINdWQ4D8d
eRR/IzAfuda1Hqp3NXCE3NrgMbbNUetdB9xyrIdT0C0PrBfqySP8fIFS/OdC
OT5OQyOUwX1inPKt1+p5CWcnXZs9zWAVusu+9UI9WYpcCO3IbdBJ7OFwfpTD
Bt/eoNzXwxV8dYTzqZlbrfpBCmTDVu4ehQruboYmzg7IBt9ZUIl83jNZZ2uR
y2Eq8k/89fPWp9BJ7gOad2Jm+ZabcqzzbWbVO/XwM3cTntVCNVEvV8LtsH81
5FIAW8ilChYgZ0IGpENkAm8l3itwkLvxdc2z2dEMJTjvg37iPYe3yB52LvQg
r/BtZhRLMd9Tm7+uzbZmfA4xZkMqpMWsdr9c223VULvfDi/Db8AzfH4P7O2q
QStydWCzoRnZ6FkNVbvfEattrmeyzrQb91zb7f/749lO6D2zYCe+6gPbJe1U
sWc9VO+2Qy05XodzYb20W7sD+5Zpf1pjVlPpZFONnB+zXqvnRTHzIb1qXobP
HM96qx6rtsc8y0U5adZmuvat0swdVm6BfQv0TfgHFIe62Q==
         "],
         VertexColors->None], 
        PolygonBox[{{2135, 2177, 927, 2173, 2134}, {2262, 2265, 2264, 2221, 
         959}, {2194, 2196, 2195, 2152, 914}, {1440, 1413, 1412, 1447, 351}, {
         1689, 1648, 528, 1687, 1688}, {1730, 1732, 1731, 1692, 565}, {1236, 
         1238, 1237, 1197, 152}, {1460, 1422, 338, 1458, 1459}, {1427, 1467, 
         374, 1463, 1426}, {1230, 1193, 1192, 1233, 179}, {2166, 2131, 2130, 
         2172, 924}, {1723, 1689, 1688, 1726, 591}, {1807, 1763, 623, 1805, 
         1806}, {1788, 1749, 606, 1786, 1787}, {1906, 1870, 1869, 1912, 
         733}, {1608, 1573, 1572, 1611, 496}, {1889, 1891, 1890, 1850, 692}, {
         1671, 1634, 1633, 1677, 542}, {1998, 1954, 765, 1996, 1997}, {2021, 
         2068, 850, 2065, 2020}, {1732, 1769, 628, 1766, 1731}, {1844, 1807, 
         1806, 1846, 686}, {1497, 1460, 1459, 1500, 401}, {1385, 1349, 1348, 
         1388, 306}, {1391, 1393, 1392, 1353, 279}, {2196, 2242, 977, 2240, 
         2195}, {2259, 2216, 956, 2257, 2258}, {1332, 1290, 224, 1330, 
         1331}, {1891, 1937, 755, 1935, 1890}, {1193, 1151, 116, 1191, 
         1192}, {1573, 1534, 433, 1571, 1572}, {1066, 1119, 88, 1115, 1065}, {
         1110, 1058, 1057, 1113, 84}, {1557, 1521, 415, 1555, 1556}, {2001, 
         2004, 2003, 1960, 768}, {1349, 1305, 243, 1347, 1348}, {1276, 1313, 
         247, 1309, 1275}, {2276, 2234, 970, 1002, 1001}, {1579, 1616, 501, 
         1613, 1578}, {1577, 1579, 1578, 1538, 438}, {2019, 2021, 2020, 1978, 
         787}},
         VertexColors->None], 
        PolygonBox[{{1928, 1885, 718, 1930, 1931, 749}, {2233, 2189, 939, 
         2235, 2236, 970}, {2146, 2103, 876, 2148, 2149, 907}, {2059, 2015, 
         813, 2061, 2062, 844}},
         VertexColors->None]}]}, 
     {RGBColor[0.5175084525254723, 0.44704065541313254`, 0.8444010511629769], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{2015, 2059, 812}, {1870, 1906, 701}, {1420, 1419, 337}, {
         2058, 2057, 843}, {1926, 1925, 748}, {1429, 1466, 343}, {1149, 1148, 
         115}, {2131, 2166, 892}, {1807, 1844, 654}, {2301, 2300, 1019}, {
         2243, 2283, 978}, {1771, 1812, 629}, {1393, 1391, 311}, {1532, 1531, 
         432}, {2189, 2233, 938}, {2196, 2194, 946}, {1193, 1230, 147}, {1349,
          1385, 274}, {1368, 1367, 287}, {2004, 2001, 800}, {1646, 1645, 
         527}, {1303, 1302, 242}, {1618, 1654, 502}, {1579, 1577, 470}, {1689,
          1723, 559}, {1594, 1593, 478}, {1885, 1928, 717}, {1131, 1130, 
         96}, {1070, 1118, 57}, {2265, 2262, 991}, {1278, 1312, 216}, {1939, 
         1979, 756}, {1460, 1497, 369}, {2188, 2187, 937}, {1058, 1110, 52}, {
         2234, 2276, 969}, {2069, 2109, 851}, {2103, 2146, 875}, {1413, 1440, 
         319}, {2081, 2080, 860}, {1891, 1889, 724}, {1573, 1608, 464}, {1732,
          1730, 597}, {1762, 1761, 622}, {2021, 2019, 819}, {1238, 1236, 
         184}, {1634, 1671, 510}, {2102, 2101, 874}, {1827, 1826, 669}, {2275,
          2274, 1000}, {1842, 1841, 685}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlE1IVVEQx0/27r3PEoJQQ4hSQwqVgtKkDzKCNgpiSuhCy5QWJVhhoYui
FJQME0ITWlRkBBmZFgZC2aJsEVlKmRWBklEStUnCCuzV78/cxY83786c+Txz
0qqPlNTFOeeKIAJ/fecm4Q0swCdYFjjXgZEMMzFaBynYboGY51wGNuOLnBuA
GLYTkLrYuZ3wFtsYvMN2CO5i3w57sD0GXehqoQrdGejGV51iEmsD5CNXQwzb
KTiKfMk3nWz6kNvgLNyG/Khzh+EQ7IAb+D4F9fjuhLXkVgTDnL0MCcgzvtWm
GpvIrRxWEysfEvHxGZtN1FIK15GPQz30QDP6frgDTZABpXAS2wpow+Y+JCB/
x/8+Ym31rRbVdAFdjXqG7if0crYRGuAmTETtm+TXkAB5UIu/QniM3AX3kF9B
Mr62wzZIUp7UchHKiJUHWdiWQxlkgh/v3Ht+pzn7D56S2zc4QS5748y2OaxN
Z4rRZemO4GsecolRCS80C2hEdxWuQAMUcyYtar1QT1Yxi5WQyCxyoJLcWjzr
tXq+FHkW/RdYglyB742B+VaMKr63QgvshwWYjNjd0h2bVd1Rm5VmNsX/wbD/
2XAa296I3QXdiQ/YBvFWu3qQii49YrkpR+XyCIbDnA7iqzOwWWlm8t0a2GwV
I52cC6EA0qAb/0+iNhvNKNezGlVbDqTAblhO7XPES6Znc/z/AUnqNTHXR2zX
tHMzfPf4HoGPyEP4btcdwfczOIC8WTuAfA5+cXYcxmAeatCdh1uhPhs/Jb7N
UjP9ijzi2+x1BzqIMejZrmpnxwLbAd39l/DQs5yUywPPZjMA/eGM0vWOePY2
6I3YhbzCs1pVs3ZjOrDZqH+j6HrgGjz3rBejoaye6G3qC3ddb1SncvPsbuuO
/wksR+X2GwpgTWC7rp3/DyU2qLo=
         "],
         VertexColors->None], 
        PolygonBox[{{2300, 2260, 2259, 2305, 1019}, {1725, 1686, 559, 1723, 
         1724}, {2088, 2091, 2090, 2046, 832}, {2168, 2128, 892, 2166, 
         2167}, {1645, 1610, 1609, 1648, 527}, {2080, 2041, 2040, 2085, 
         860}, {1200, 1239, 184, 1236, 1199}, {1112, 1054, 52, 1110, 1111}, {
         1695, 1733, 597, 1730, 1694}, {1908, 1866, 701, 1906, 1907}, {1654, 
         1656, 1655, 1616, 502}, {1148, 1112, 1111, 1151, 115}, {1761, 1725, 
         1724, 1763, 622}, {2146, 2147, 906, 874, 875}, {1541, 1580, 470, 
         1577, 1540}, {1531, 1499, 1498, 1534, 432}, {2101, 2058, 843, 875, 
         874}, {1673, 1630, 510, 1671, 1672}, {1852, 1893, 724, 1889, 1851}, {
         2223, 2267, 991, 2262, 2222}, {2109, 2111, 2110, 2068, 851}, {1979, 
         1981, 1980, 1937, 756}, {1812, 1814, 1813, 1769, 629}, {2187, 2145, 
         906, 938, 937}, {1302, 1271, 1270, 1305, 242}, {1466, 1468, 1467, 
         1427, 343}, {1367, 1333, 1332, 1373, 287}, {2233, 2234, 969, 937, 
         938}, {1499, 1457, 369, 1497, 1498}, {1387, 1346, 274, 1385, 1386}, {
         1118, 1120, 1119, 1066, 57}, {1214, 1172, 128, 1212, 1213}, {1355, 
         1395, 311, 1391, 1354}, {1312, 1314, 1313, 1276, 216}, {2283, 2285, 
         2284, 2242, 978}, {1981, 2023, 819, 2019, 1980}, {1826, 1789, 1788, 
         1831, 669}, {1593, 1558, 1557, 1599, 478}, {2154, 2198, 946, 2194, 
         2153}, {1232, 1189, 147, 1230, 1231}, {1442, 1409, 319, 1440, 
         1441}, {1610, 1570, 464, 1608, 1609}, {1419, 1387, 1386, 1422, 337}},
         
         VertexColors->None], 
        PolygonBox[{{2274, 2232, 969, 2276, 2277, 1000}, {2057, 2014, 812, 
         2059, 2060, 843}, {1925, 1884, 717, 1928, 1929, 748}, {1841, 1804, 
         654, 1844, 1845, 685}},
         VertexColors->None]}]}, 
     {RGBColor[0.5890842232878236, 0.5681566197277818, 0.9100746680223403], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{2041, 2080, 828}, {2155, 2197, 915}, {1314, 1312, 248}, {
         1993, 1992, 796}, {1508, 1539, 407}, {1499, 1531, 400}, {1814, 1812, 
         661}, {2058, 2101, 842}, {2100, 2099, 873}, {1455, 1454, 368}, {1228,
          1227, 178}, {1387, 1419, 305}, {1558, 1593, 446}, {1568, 1567, 
         463}, {1327, 1326, 255}, {1357, 1394, 280}, {2091, 2088, 864}, {1759,
          1758, 621}, {1120, 1118, 89}, {2145, 2187, 905}, {2260, 2300, 
         987}, {2213, 2212, 955}, {1160, 1198, 121}, {2273, 2272, 998}, {1344,
          1343, 273}, {1746, 1745, 605}, {1804, 1841, 653}, {1982, 2022, 
         788}, {1333, 1367, 255}, {2285, 2283, 1010}, {2056, 2055, 842}, {
         1725, 1761, 590}, {2186, 2185, 936}, {1684, 1683, 558}, {1883, 1882, 
         716}, {2232, 2274, 968}, {1981, 1979, 788}, {1971, 1970, 779}, {1271,
          1302, 210}, {1112, 1148, 83}, {2111, 2109, 883}, {1884, 1925, 
         716}, {1656, 1654, 534}, {1854, 1892, 693}, {2014, 2057, 811}, {2231,
          2230, 967}, {1789, 1826, 637}, {1610, 1645, 495}, {1517, 1516, 
         414}, {1050, 1049, 51}, {1468, 1466, 375}, {1657, 1693, 534}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwt00tIlFEUwPFjfd93PxkXtsgiInRsN2aE0aKkNJBAKUpbjItyDIpqeoFG
uTDKIDIKAmd0V5EpuvBZQVTqogcFxoREBvYACRQsgkCsRY//4czix5zh3nvu
ved+p+jQ6dpTy0SkCh4GA5FraMcAljCFA0xqxU9fpID/4zkit1DFokoUsrYC
AWMbUAIfESfyhd+TrL2Bx8QplBLvwfVQ5BFeLRfpQwNj27AVB5Em9wkkkcJO
9k9iE3uvQDn5C5Am10N0M9aGS7iLZnQijSZcIUcC9Zy1Bb3EF9CKHrxkz29Y
wAvMIs/Z2fUOi8SvsZazluMDOYdwhrPcxCfG7iPCWAz7ybkGZexVh1WMbXd2
Vj1zlPzV+MHaTI7Vrg612RoOU5uPmMEQZtnrKc4xtwv5zPnu21vom/Qz553O
Z+8nGGPsq29zdU0Ne69HMaqd1aoe8WzNulj7HM/Qqcg/Fthb6ZvpWcJcEZdr
Z7oTWM20VrdRTI7dWM1ev7hvJXOS6OAsTchjbJ56zCFCnOEMv53VUmv6gPiz
s9ppDXeRszCw2miN9pEriiLsRQY9od1V75wg3oxjxO04TrwjtL31DHHiGBLE
F/X9OMc//MU0zjqrkdamGROefYP67Y3jcmhvom/RhiPMSaEDhzHiWU7NNYx7
znJqrm5nd5/I5tIatIR2J73Leczr98zvSswRb+G3MbS76J1qqFnUt9pqjY8S
V/jWC9oTi+ScxCjjU3hP7f4E1rvaw9rbDdne0h5fx9y4Z9+mfqONxFc96w3t
kTe+9ZT20iRKGNuIUsTwFkue7aV7jjBnxrde0J74D/2ukvM=
         "],
         VertexColors->None], 
        PolygonBox[{{1843, 1803, 653, 1841, 1842}, {1198, 1201, 1200, 1158, 
         121}, {1304, 1269, 210, 1302, 1303}, {1369, 1327, 255, 1367, 1368}, {
         1454, 1421, 1420, 1457, 368}, {2230, 2186, 936, 968, 967}, {1394, 
         1396, 1395, 1355, 280}, {1683, 1647, 1646, 1686, 558}, {1595, 1552, 
         446, 1593, 1594}, {1430, 1469, 375, 1466, 1429}, {1892, 1894, 1893, 
         1852, 693}, {1049, 1053, 1052, 1054, 51}, {2274, 2275, 999, 967, 
         968}, {1693, 1696, 1695, 1656, 534}, {1343, 1304, 1303, 1346, 273}, {
         1619, 1657, 534, 1654, 1618}, {2022, 2024, 2023, 1981, 788}, {2176, 
         2179, 2178, 2136, 896}, {1927, 1883, 716, 1925, 1926}, {2082, 2037, 
         828, 2080, 2081}, {1227, 1190, 1189, 1232, 178}, {1326, 1292, 1291, 
         1333, 255}, {1647, 1607, 495, 1645, 1646}, {1279, 1315, 248, 1312, 
         1278}, {1539, 1542, 1541, 1506, 407}, {2244, 2287, 1010, 2283, 
         2243}, {1516, 1485, 1484, 1522, 414}, {1071, 1121, 89, 1118, 1070}, {
         1150, 1108, 83, 1148, 1149}, {2272, 2231, 967, 999, 998}, {2212, 
         2169, 2168, 2217, 955}, {1992, 1956, 1955, 1999, 796}, {1940, 1982, 
         788, 1979, 1939}, {1132, 1093, 64, 1130, 1131}, {2197, 2199, 2198, 
         2154, 915}, {2302, 2255, 987, 2300, 2301}, {1533, 1496, 400, 1531, 
         1532}, {1882, 1843, 1842, 1884, 716}, {1567, 1533, 1532, 1570, 
         463}, {1970, 1927, 1926, 1972, 779}, {1772, 1815, 661, 1812, 1771}, {
         2070, 2113, 883, 2109, 2069}, {1421, 1384, 305, 1419, 1420}, {1745, 
         1710, 1709, 1750, 605}, {1828, 1783, 637, 1826, 1827}},
         VertexColors->None], 
        PolygonBox[{{2055, 2013, 811, 2057, 2058, 842}, {2099, 2056, 842, 
         2101, 2102, 873}, {1758, 1722, 590, 1761, 1762, 621}, {2185, 2144, 
         905, 2187, 2188, 936}},
         VertexColors->None]}]}, 
     {RGBColor[0.6483979226276808, 0.6634572303545461, 0.9114268376785982], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{2143, 2142, 903}, {1242, 1277, 185}, {1802, 1801, 652}, {
         1494, 1493, 399}, {1881, 1880, 715}, {2245, 2286, 979}, {2271, 2270, 
         996}, {1396, 1394, 312}, {1485, 1516, 382}, {1533, 1567, 431}, {1696,
          1693, 566}, {1647, 1683, 526}, {1146, 1145, 114}, {1542, 1539, 
         439}, {2125, 2124, 891}, {1969, 1968, 778}, {2013, 2055, 810}, {2024,
          2022, 820}, {1382, 1381, 304}, {1304, 1343, 241}, {1251, 1250, 
         191}, {1583, 1617, 471}, {1895, 1938, 725}, {1073, 1069, 26}, {1956, 
         1992, 764}, {1267, 1266, 209}, {1053, 1049, 19}, {1843, 1882, 684}, {
         1398, 1428, 312}, {1480, 1479, 382}, {2054, 2053, 841}, {2056, 2099, 
         841}, {1292, 1326, 223}, {1894, 1892, 725}, {2229, 2228, 965}, {1722,
          1758, 589}, {1903, 1902, 732}, {1721, 1720, 589}, {2231, 2272, 
         966}, {2169, 2212, 923}, {2199, 2197, 947}, {1605, 1604, 494}, {2184,
          2183, 934}, {1190, 1227, 146}, {2144, 2185, 904}, {2179, 2176, 
         928}, {1927, 1970, 747}, {1201, 1198, 153}, {1668, 1667, 541}, {2186,
          2230, 935}, {1421, 1454, 336}, {1735, 1770, 598}, {2071, 2112, 
         852}, {1710, 1745, 573}, {2098, 2097, 872}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwt001IVFEUwPFTvnfvsyIKxKRoUekmiBlI2mSFA9qijD6mQFtoLkRoaiBp
oUGLFLIogkhF2gxpQhCVuYgWOS0yMRd9CCUx0aICqRQi1IjK/ofzFj/mzJx7
zzvv3jObmrOHTy8XkRQCVHiRX05kEeXEZdiD3ViH/d7WaG4fulCPSYp8Q2so
chUHl4kkMeushu79TtxALokE6rElElkgN4/NkT17Cm/iHoQ15boOSzTYi1PI
oAeeNQm841mPcJw6F731oj1VkVuLNdjprNYB1MU1f+MtrrH3PkqIf1L3NY/+
gVvsGccxau1AgdrDWFEkshU54iwK5P7As/8T+/Ps/Yg+vo/iCXrRw9o8RnED
H3jn4mKRCAXis/w26K2W1hxkTycuYAAryW3HXXJXkNRevMX62xI1XuEl/uGr
nj2faXqtxFF624D1SOMSNVtCuyu9swzvWoM54tXUm2bNMPp5l8d4QK1O5Kj1
FG3EdThHfLPIem2I71Z7TlOrA+044uwsvuBzfCba6xBuxz1Xognd1GrFM+I+
jBBP6TPjGdC7z2MbNZ2zu9cZSLE2g5OoxnNyOWd3p3dYy54UqlET2GzM0cds
aDMyzeff0GZBZ6LJ2Qzp7DRiL7LOzkbPSGexNq6lM3mHXBc2kt+FZj1jdOME
RvTOvc2OztBDfnsf2NnqGQ8Qd+AM8XXMEK8KbZZ0pvp5p7HIzkLPRP87LzAR
/4fmWV8W2uzqDB9ibXtkd6N3lAysJ+0lgVJyM95mQ2fkMr3fc9a7vsN51gwF
1ov29B+nCI1u
         "],
         VertexColors->None], 
        PolygonBox[{{1069, 1072, 1071, 1068, 26}, {2183, 2143, 903, 935, 
         934}, {2270, 2229, 965, 997, 996}, {1051, 1047, 19, 1049, 1050}, {
         2228, 2184, 934, 966, 965}, {2142, 2098, 872, 904, 903}, {1161, 1202,
          153, 1198, 1160}, {1569, 1530, 431, 1567, 1568}, {1801, 1760, 1759, 
         1803, 652}, {1428, 1431, 1430, 1396, 312}, {1760, 1721, 589, 1758, 
         1759}, {1770, 1773, 1772, 1734, 598}, {1509, 1543, 439, 1539, 
         1508}, {1604, 1569, 1568, 1607, 494}, {1479, 1444, 1443, 1485, 
         382}, {1938, 1941, 1940, 1894, 725}, {1658, 1698, 566, 1693, 1657}, {
         1747, 1705, 573, 1745, 1746}, {2156, 2201, 947, 2197, 2155}, {1229, 
         1187, 146, 1227, 1228}, {1720, 1685, 1684, 1722, 589}, {2272, 2273, 
         997, 965, 966}, {2214, 2163, 923, 2212, 2213}, {1456, 1417, 336, 
         1454, 1455}, {2185, 2186, 935, 903, 904}, {1617, 1620, 1619, 1581, 
         471}, {1667, 1632, 1631, 1674, 541}, {1493, 1456, 1455, 1496, 399}, {
         1381, 1345, 1344, 1384, 304}, {2286, 2288, 2287, 2244, 979}, {1328, 
         1287, 223, 1326, 1327}, {1855, 1895, 725, 1892, 1854}, {1994, 1952, 
         764, 1992, 1993}, {1345, 1300, 241, 1343, 1344}, {1902, 1868, 1867, 
         1909, 732}, {2112, 2114, 2113, 2070, 852}, {1266, 1229, 1228, 1269, 
         209}, {1250, 1216, 1215, 1256, 191}, {1685, 1644, 526, 1683, 1684}, {
         1518, 1480, 382, 1516, 1517}, {1358, 1398, 312, 1394, 1357}, {2230, 
         2231, 966, 934, 935}, {1983, 2026, 820, 2022, 1982}, {1145, 1109, 
         1108, 1150, 114}, {2124, 2083, 2082, 2129, 891}, {1277, 1280, 1279, 
         1240, 185}, {2266, 2269, 2268, 2224, 960}},
         VertexColors->None], 
        PolygonBox[{{1968, 1924, 747, 1970, 1971, 778}, {1880, 1840, 684, 
         1882, 1883, 715}, {2053, 2012, 810, 2055, 2056, 841}, {2097, 2054, 
         841, 2099, 2100, 872}},
         VertexColors->None]}]}, 
     {RGBColor[0.7077116219675379, 0.7587578409813105, 0.9127790073348561], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1341, 1340, 272}, {2143, 2183, 902}, {1456, 1493, 367}, {
         1685, 1720, 557}, {2054, 2097, 840}, {1817, 1853, 662}, {1868, 1902, 
         700}, {1169, 1168, 127}, {1280, 1277, 217}, {1045, 1044, 50}, {1879, 
         1878, 714}, {1072, 1069, 58}, {2157, 2200, 916}, {1643, 1642, 525}, {
         1924, 1968, 746}, {2269, 2266, 992}, {1967, 1966, 777}, {2083, 2124, 
         859}, {2012, 2053, 809}, {2098, 2142, 871}, {1406, 1405, 318}, {1472,
          1507, 376}, {1431, 1428, 344}, {1225, 1224, 177}, {1660, 1697, 
         535}, {1444, 1479, 350}, {1941, 1938, 757}, {1453, 1452, 367}, {1627,
          1626, 509}, {1840, 1880, 683}, {2288, 2286, 1011}, {2096, 2095, 
         871}, {1760, 1801, 620}, {1569, 1604, 462}, {1123, 1159, 90}, {1719, 
         1718, 588}, {2252, 2251, 986}, {1800, 1799, 651}, {2184, 2228, 
         933}, {1620, 1617, 503}, {1632, 1667, 509}, {1109, 1145, 82}, {2181, 
         2180, 932}, {1318, 1356, 249}, {1026, 1098, 35}, {2114, 2112, 884}, {
         1528, 1527, 430}, {1773, 1770, 630}, {1229, 1266, 177}, {2229, 2270, 
         964}, {1028, 1027, 5}, {2141, 2140, 902}, {2011, 2010, 808}, {1823, 
         1822, 668}, {1984, 2025, 789}, {1345, 1381, 272}, {1216, 1250, 
         159}, {2034, 2033, 827}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwt1F9ojWEcwPHnnPc97/Me5YKsTULHEBfaodz434jRMXWysJWLKVPONmWN
RlzsUJsrsg2RPxtCKduFVuKYMCMpbmxWY7iYWPm/c8P31++p8+n9vc/7vL/3
+fM7T6K6Pl0XNcak4KMiMOYwCmn8EzGml3gEGe5TKLLGfOW+kbgdE8Rv8Bp/
cQp7MZlnizBL2mPG3CbXS3Ry34+nuIJJ5EviFn1PRDXXTdxwOdfwbA9qsBqX
sQ/1uIQ+z5hHGMUHhHzrIxMZhSX2uEZ8nRu3ZhNBGeYQF6M7NOZOqHkeehr3
hJpT2qTvRiSMvrOBeC1KsR4FJP3J9QemEc/gWoE0fZegh3gIg+j29Rt9bqzv
0UXbITShE3W+fkNy1yLPWF5gkL557GDOWYyxVgM4wzdzOMjabsdzt0ayNgN4
gDb8om+BzI/4HRYSxzGPOIV7PD+PC+Q6glXk2gl+JurmLmvQ6uucZC4tWMfY
anGaXA2opi2JZfStRDtxDheJjyJL3+O4KnPHVPZ4nO99wxTi6zxrwH5cw2fa
Q9otPhE3oyumY5MxSq0cQ9bVTAZtgdae1GAJcwut1pbUmOQux2b3jWaebbO6
lrKmGdpKQ52LzKmXsZ/0dewyB59nQ/RfILWBKsayGElU4j46YroXsifyTGrS
uj4dvJuzuheyJ6201WA3WrAy0DWRtVjh1uYZ+t0alfHubKt7JXu2hbYDaEQ5
0lKTvtae1ODcmBb+Wy4TRtcyiRK3pjOZz3fyLZe54AtxEW2FGLO69577r0gN
NPHO1kDPBjkjIuSeH9Pc8o08cSLQ/7r855cyll2+1oLUxDnyPsFjnMU4fadb
PUvkTHlF279Qa11qPh43Zpj7EU8PqGH63w30LJIz6TfvFoc6dpnDf9Avmho=

         "],
         VertexColors->None], 
        PolygonBox[{{1025, 1026, 35, 3, 4}, {1044, 1048, 1047, 1051, 50}, {
         1147, 1106, 82, 1145, 1146}, {1268, 1225, 177, 1266, 1267}, {1642, 
         1606, 1605, 1644, 525}, {1243, 1281, 217, 1277, 1242}, {1252, 1209, 
         159, 1250, 1251}, {1168, 1134, 1133, 1174, 127}, {1224, 1188, 1187, 
         1229, 177}, {1356, 1359, 1358, 1316, 249}, {1606, 1566, 462, 1604, 
         1605}, {2010, 1967, 777, 809, 808}, {1584, 1621, 503, 1617, 1583}, {
         1383, 1341, 272, 1381, 1382}, {1626, 1597, 1596, 1632, 509}, {2227, 
         2181, 932, 964, 963}, {1669, 1627, 509, 1667, 1668}, {1481, 1437, 
         350, 1479, 1480}, {2025, 2027, 2026, 1983, 789}, {1405, 1371, 1370, 
         1411, 318}, {2246, 2290, 1011, 2286, 2245}, {1697, 1699, 1698, 1658, 
         535}, {2200, 2202, 2201, 2156, 916}, {2033, 1995, 1994, 2038, 827}, {
         1340, 1301, 1300, 1345, 272}, {1822, 1785, 1784, 1829, 668}, {2270, 
         2271, 995, 963, 964}, {2228, 2229, 964, 932, 933}, {1074, 1077, 58, 
         1069, 1073}, {2251, 2215, 2214, 2256, 986}, {1736, 1775, 630, 1770, 
         1735}, {2053, 2054, 840, 808, 809}, {1159, 1162, 1161, 1122, 90}, {
         2126, 2077, 859, 2124, 2125}, {1495, 1453, 367, 1493, 1494}, {1399, 
         1432, 344, 1428, 1398}, {1904, 1864, 700, 1902, 1903}, {1507, 1510, 
         1509, 1470, 376}, {1527, 1495, 1494, 1530, 430}, {2072, 2116, 884, 
         2112, 2071}, {1452, 1418, 1417, 1456, 367}, {1853, 1856, 1855, 1816, 
         662}, {1896, 1943, 757, 1938, 1895}},
         VertexColors->None], 
        PolygonBox[{{1966, 1923, 746, 1968, 1969, 777}, {2095, 2052, 840, 
         2097, 2098, 871}, {1799, 1757, 620, 1801, 1802, 651}, {1718, 1682, 
         557, 1720, 1721, 588}, {2140, 2096, 871, 2142, 2143, 902}, {1878, 
         1839, 683, 1880, 1881, 714}, {2182, 2141, 902, 2183, 2184, 933}},
         VertexColors->None]}]}, 
     {RGBColor[0.7665773987813184, 0.8483140188380504, 0.9122630168824661], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1136, 1177, 99}, {1323, 1322, 254}, {1545, 1582, 440}, {
         2210, 2209, 954}, {1360, 1397, 281}, {2215, 2251, 954}, {1162, 1159, 
         122}, {1798, 1797, 650}, {1923, 1966, 745}, {1949, 1948, 763}, {1026,
          1025, 36}, {1897, 1942, 726}, {2093, 2092, 868}, {1495, 1527, 
         398}, {1030, 1099, 38}, {1048, 1044, 18}, {1995, 2033, 795}, {1418, 
         1452, 335}, {1877, 1876, 713}, {1757, 1799, 619}, {2202, 2200, 
         948}, {1100, 1137, 69}, {1031, 1029, 7}, {1380, 1379, 303}, {1450, 
         1449, 366}, {2052, 2095, 839}, {1839, 1878, 682}, {1264, 1263, 
         208}, {2027, 2025, 821}, {1785, 1822, 636}, {2096, 2140, 870}, {1699,
          1697, 567}, {1565, 1564, 461}, {1641, 1640, 524}, {1205, 1241, 
         154}, {2141, 2182, 901}, {1682, 1718, 556}, {1856, 1853, 694}, {1301,
          1340, 240}, {1359, 1356, 281}, {1549, 1548, 445}, {2009, 2008, 
         807}, {1143, 1142, 113}, {1742, 1741, 604}, {2247, 2289, 980}, {2073,
          2115, 853}, {1371, 1405, 286}, {1086, 1085, 63}, {1597, 1626, 
         477}, {1717, 1716, 587}, {1134, 1168, 95}, {1606, 1642, 493}, {1188, 
         1224, 145}, {1510, 1507, 408}, {1922, 1921, 744}, {1967, 2010, 
         776}, {1738, 1774, 599}, {2051, 2050, 838}, {2181, 2227, 931}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlEtIlFEUx++M3/fNJ9SmKHowU0HlItEszFVPNbUgwZikRoh0wkQaGyiM
nuSLmCDQjQ8y8LEyXJTZCwTdWFpGC6mFuutJiEOPRQnR73Du4gfnu/fcc849
53+/LdUNFYmgMSYKDpwLGXMAnrD4HoKuMVmwHQJwyjfmJDRlGHMLSjiUgNOc
3Q8PPGPaoBWGII7PWWiFFgjgmwHb8N0Ke7DjUAP5ME2O+9ALU1BIjDDMBIxZ
hNusxSEXuxxesTcABdRaCV3UPgHj0Alt1Nria26pYYQcKbhC7h6jd4lBc4be
qZvYEzAOXXDZ1TWxG+EpuRagnlxHoZRYR6CQWIcgQqyf5P0BYexazqRcrVVq
LmYtAeehCCbx64VlYm0k/yL2etaj2PmQx9kYRDj7j/jZ7OX42tO4nYHU3Q99
8Ita1uCfxvcdHOd7raxBBdyBUUfvLj0YJl8TfCW/z/llYs/AG/gL/fg2QhLf
dijg7ithjHoWAjqrm3DDzmzeUc2IVuawZ/H9A9eIXwWXiFkOx+Ci1ZH0fsDe
IZNznzj3EXzsMkd7LL09aPSs9DhsY6Rd1YxoZclVTYm2iqHIaKwX8NzGrIV9
jmpVNCt7HdBuffroxeuQzkJmMkzMD3CXuyYghz0PUuwNwW5HNSza3SV1slcX
0rcjb+g3d3/r6d2lBz72Z9ETsZ7BJHfogcfkm4VV7O/1tLfS40HsaU+1LRqv
x+6AbOwVQe2J9KYazsBqmb2jsxcNRPne4ap2REMj5Hroa6+l53nEOgFR2Gnt
6zIvuzYPo55qXTQfwT7s6VuUN9mOXedpLVKT1CJvocbWJP+CKojZf4LkfuSr
VqWGddjfQ6p10fw9vl/62gvpyRx7Dt8l2FmQ5LsMSuECVEIzfCP3FKTJsUHe
ECxhz3L3IVdnJzOUs5thk42RpFcNjmpFNOOzlhvS2cqMv3A209NZycw68e1y
tNdyv6vYg46+DXkj3Y76VNse/AdcDqoT
         "],
         VertexColors->None], 
        PolygonBox[{{1397, 1400, 1399, 1359, 281}, {1241, 1244, 1243, 1203, 
         154}, {2209, 2165, 2164, 2215, 954}, {1628, 1591, 477, 1626, 1627}, {
         1226, 1186, 145, 1224, 1225}, {1948, 1905, 1904, 1953, 763}, {1098, 
         1026, 36, 68, 67}, {2289, 2291, 2290, 2246, 980}, {2158, 2204, 948, 
         2200, 2157}, {1263, 1226, 1225, 1268, 208}, {2050, 2009, 807, 839, 
         838}, {1027, 1028, 6, 38, 37}, {2115, 2117, 2116, 2072, 853}, {1322, 
         1289, 1288, 1329, 254}, {1379, 1342, 1341, 1383, 303}, {2139, 2093, 
         868, 900, 899}, {1741, 1707, 1706, 1748, 604}, {2095, 2096, 870, 838,
          839}, {1124, 1163, 122, 1159, 1123}, {2180, 2181, 931, 899, 900}, {
         1407, 1365, 286, 1405, 1406}, {1824, 1781, 636, 1822, 1823}, {1942, 
         1944, 1943, 1896, 726}, {1966, 1967, 776, 744, 745}, {1548, 1520, 
         1519, 1554, 445}, {1135, 1136, 99, 67, 68}, {1029, 1030, 38, 6, 7}, {
         1661, 1700, 567, 1697, 1660}, {1774, 1776, 1775, 1736, 599}, {1085, 
         1092, 1091, 1095, 63}, {1046, 1042, 18, 1044, 1045}, {1582, 1585, 
         1584, 1544, 440}, {1170, 1127, 95, 1168, 1169}, {2253, 2210, 954, 
         2251, 2252}, {2140, 2141, 901, 869, 870}, {1099, 1100, 69, 37, 38}, {
         1921, 1877, 713, 745, 744}, {1473, 1511, 408, 1507, 1472}, {2094, 
         2051, 838, 870, 869}, {1985, 2029, 821, 2025, 1984}, {1319, 1360, 
         281, 1356, 1318}, {1142, 1107, 1106, 1147, 113}, {1529, 1492, 398, 
         1527, 1528}, {1818, 1858, 694, 1853, 1817}, {2035, 1990, 795, 2033, 
         2034}, {1342, 1299, 240, 1340, 1341}, {1564, 1529, 1528, 1566, 461}},
         
         VertexColors->None], 
        PolygonBox[{{1876, 1838, 682, 1878, 1879, 713}, {1640, 1603, 493, 
         1642, 1643, 524}, {1449, 1416, 335, 1452, 1453, 366}, {1716, 1681, 
         556, 1718, 1719, 587}, {1797, 1756, 619, 1799, 1800, 650}, {2008, 
         1965, 776, 2010, 2011, 807}},
         VertexColors->None]}]}, 
     {RGBColor[0.8198451264725957, 0.8660773866542235, 0.8883991226117226], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1477, 1476, 381}, {2117, 2115, 885}, {1101, 1138, 71}, {
         1964, 1963, 774}, {1416, 1449, 334}, {1107, 1142, 81}, {1905, 1948, 
         731}, {1179, 1219, 133}, {1434, 1471, 345}, {1877, 1921, 712}, {1289,
          1322, 222}, {1707, 1741, 572}, {1092, 1085, 31}, {1400, 1397, 
         313}, {1681, 1716, 555}, {1136, 1135, 100}, {1944, 1942, 758}, {1378,
          1377, 302}, {1034, 1032, 8}, {2051, 2094, 837}, {1298, 1297, 239}, {
         2093, 2139, 867}, {1226, 1263, 176}, {1796, 1795, 649}, {1585, 1582, 
         472}, {1529, 1564, 429}, {1715, 1714, 586}, {1491, 1490, 397}, {1819,
          1857, 663}, {1244, 1241, 186}, {2165, 2209, 922}, {1248, 1247, 
         190}, {1965, 2008, 775}, {1080, 1076, 27}, {1139, 1178, 102}, {2122, 
         2121, 890}, {1837, 1836, 680}, {1838, 1876, 681}, {1218, 1259, 
         163}, {1862, 1861, 699}, {1603, 1640, 492}, {1639, 1638, 523}, {1030,
          1029, 39}, {1520, 1548, 413}, {1776, 1774, 631}, {1623, 1659, 
         504}, {2009, 2050, 806}, {2159, 2203, 917}, {1563, 1562, 460}, {1283,
          1317, 218}, {1041, 1040, 49}, {1185, 1184, 144}, {1665, 1664, 
         540}, {1100, 1099, 70}, {1342, 1379, 271}, {2296, 2295, 1017}, {2006,
          2005, 804}, {1920, 1919, 743}, {1756, 1797, 618}, {2291, 2289, 
         1012}, {1986, 2028, 790}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlFlIlFEUx68z32ZRUYGQrUJhoAlDkEVhNJNFQsskGrY8ZIoLocyDFIKV
tlOBFaEOjeFYVIQQhD0kBBqpWNlDRZEWvYRlm5FJPdXvcL6HH5zvO/f+z3bv
zSit3VkTMMYUgQV7PGNKoDRozAHYjl0Hcex6GLeNeQwNKcYkIMy/iL9W9tx0
jGmEBYiugw1BXSO+/TCF7zkMw29Yyr9lkA8b4SNJpKL/nlweguMakwO30ToL
6dgT7DuE3RLQXHd7qi0xMlyNIdpLsAfQ64BmtO7CcrSjsAMyYQpewAVq6YJi
7GzIgiIYRrsTkvAMGtFogiR0QDdxRqGaXApgIXYEvqL1FOLk0AdpUjv+NjQP
wxp8JbCPtashF/ZCH75PMAa9UMjeFXCLvYPwkzXzXa1dehCWb0djScxaao1B
ObmVGdWahj/VUc1/7E3xdGYylxH+33M0d6nhIP5N0IM9Akm0hiztnfSwmbUV
MB1fFrxE86+tvZMeVrJ2PeRBhezFN2HrWZEzcw37GByFdlt7eRw6/Z6Kr9jv
vax5RS6vXT0jclZOEfuOo2dLztgWfDFXc5WcI9jVUAVh+EIOny3Vlhgr2bsL
/pDLG+hlTaurs5EZfcdOpz/z4JucH2iHBPRDFK3ZEEIrCqnYW2EzdiakYRda
6gv5M5BZnIQTUEXsi472TnpYRo1nYBu55MARfDfgOjTAebTuQzeckzjkVQtX
yLUOWvjXZmkPpZcxfAWe3lW5s2vRngM/8M1Cv4e1l+ESPLD07M2EGf4ZLLc0
psQqg1xL/4m9Ck6jVWprrpKzaFX6sxbNVktzklzkrgRYOyqxsN9CPd9xW8++
3IEacs33tBapKQc729O3QN6ER+zttbR30kOZ5bild09mOhetPFtrkxqld09g
yO9hMYQcnbXMvIkZdoGL9hj9TxBrEAbgKiyGSfy/YBH2O2IFbc1dajCe3iG5
O/K22fg+WPpWyZs16Z+Zfl/jP3pGsG0=
         "],
         VertexColors->None], 
        PolygonBox[{{1963, 1920, 743, 775, 774}, {1659, 1662, 1661, 1622, 
         504}, {1550, 1514, 413, 1548, 1549}, {1664, 1629, 1628, 1670, 540}, {
         1451, 1415, 334, 1449, 1450}, {1217, 1218, 163, 131, 132}, {1476, 
         1439, 1438, 1482, 381}, {1490, 1451, 1450, 1492, 397}, {1265, 1223, 
         176, 1263, 1264}, {1099, 1030, 39, 71, 70}, {1546, 1587, 472, 1582, 
         1545}, {2028, 2030, 2029, 1985, 790}, {1836, 1796, 649, 681, 680}, {
         1040, 1043, 1042, 1046, 49}, {1324, 1285, 222, 1322, 1323}, {1178, 
         1179, 133, 101, 102}, {1144, 1105, 81, 1142, 1143}, {1471, 1474, 
         1473, 1433, 345}, {1177, 1136, 100, 132, 131}, {1743, 1703, 572, 
         1741, 1742}, {2203, 2205, 2204, 2158, 917}, {2050, 2051, 837, 805, 
         806}, {1297, 1265, 1264, 1299, 239}, {2248, 2293, 1012, 2289, 
         2247}, {1950, 1900, 731, 1948, 1949}, {1739, 1777, 631, 1774, 
         1738}, {1361, 1402, 313, 1397, 1360}, {2007, 1964, 774, 806, 805}, {
         2049, 2006, 804, 836, 835}, {1898, 1946, 758, 1942, 1897}, {2092, 
         2093, 867, 835, 836}, {2074, 2119, 885, 2115, 2073}, {1247, 1211, 
         1210, 1253, 190}, {2008, 2009, 806, 774, 775}, {2121, 2079, 2078, 
         2127, 890}, {1857, 1859, 1858, 1818, 663}, {1137, 1100, 70, 102, 
         101}, {1206, 1245, 186, 1241, 1205}, {2295, 2254, 2253, 2299, 
         1017}, {2211, 2161, 922, 2209, 2210}, {1861, 1825, 1824, 1865, 
         699}, {1138, 1139, 102, 70, 71}, {1184, 1144, 1143, 1186, 144}, {
         1876, 1877, 712, 680, 681}, {1076, 1079, 1078, 1075, 27}, {1317, 
         1320, 1319, 1282, 218}, {1087, 1083, 31, 1085, 1086}},
         VertexColors->None], 
        PolygonBox[{{1714, 1680, 555, 1716, 1717, 586}, {1795, 1755, 618, 
         1797, 1798, 649}, {1377, 1339, 271, 1379, 1380, 302}, {1638, 1602, 
         492, 1640, 1641, 523}, {1562, 1526, 429, 1564, 1565, 460}, {1919, 
         1875, 712, 1921, 1922, 743}, {1032, 1033, 39, 1029, 1031, 8}},
         VertexColors->None]}]}, 
     {RGBColor[0.8731128541638729, 0.8838407544703968, 0.8645352283409792], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1033, 1032, 40}, {1989, 1988, 794}, {1364, 1363, 285}, {
         1964, 2007, 773}, {1680, 1714, 554}, {1874, 1873, 709}, {1320, 1317, 
         250}, {1637, 1636, 522}, {1899, 1945, 727}, {1140, 1180, 104}, {1526,
          1562, 428}, {1265, 1297, 207}, {2075, 2118, 854}, {1662, 1659, 
         536}, {1296, 1295, 238}, {1139, 1138, 103}, {1754, 1753, 616}, {1755,
          1795, 617}, {1629, 1664, 508}, {1439, 1476, 349}, {1038, 1037, 
         48}, {1339, 1377, 270}, {2030, 2028, 822}, {1590, 1589, 476}, {1165, 
         1204, 123}, {1917, 1916, 739}, {1167, 1166, 126}, {1679, 1678, 
         553}, {1043, 1040, 17}, {2205, 2203, 949}, {1036, 1102, 41}, {1451, 
         1490, 365}, {2006, 2049, 803}, {1179, 1178, 134}, {1294, 1337, 
         228}, {1376, 1375, 301}, {1602, 1638, 491}, {1144, 1184, 112}, {1183,
          1182, 143}, {1547, 1586, 441}, {2208, 2207, 953}, {1796, 1836, 
         648}, {1489, 1488, 396}, {1780, 1779, 635}, {1261, 1293, 197}, {1335,
          1374, 257}, {1920, 1963, 742}, {1875, 1919, 711}, {2249, 2292, 
         981}, {1859, 1857, 695}, {2254, 2295, 985}, {1794, 1793, 647}, {1218,
          1217, 164}, {1211, 1247, 158}, {1825, 1861, 667}, {1079, 1076, 
         59}, {1561, 1560, 459}, {1474, 1471, 377}, {1181, 1220, 135}, {1221, 
         1260, 166}, {1835, 1834, 678}, {1362, 1401, 282}, {1702, 1737, 
         568}, {2079, 2121, 858}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlFtoz2EYx9/t/zv8bZrDFWNpc7OJUjSzkWOOiY0cU1o5GyMK0xwuuKEp
VzY2wjaHksTIlc02p4ykJYfMKdtqDuFCis+357349H/+v/c5v8/zZpduK9ma
6pwrhQAqQudqoBr2wi0+VkElZ7UwPnJuOSyDcTANhsKjFOd64TryK9iI07nw
GPkHfJcOTMXXJCiCKfCUb43QAB1wgJh1sBpfk+Fb7FwrZCacK4Sz2LTDVXKp
go2B+ZSvDVAI62AVZ0VwAZ+VMIRcCuAachXk+fzS0e0Peej2g0vEugipxEqB
j+h8ghA5SFgtwzkfFltNb7ENyDcBb5B/8fsMjpL7FShGzoU/+M7k/zBspkfW
K/VsTtK5ctgGs+EuPlrgAvrn4Qi2l6EM3QXQxlldYLWrB3mclYTmWzF+4zub
3GrIuQJW8D8fXnP+Fx4S4wzcppaXEGHbhb93ECL/w9Zxns1ZDqzH9jiMwlca
lIaWk3IZA2uxmxBYr9XzE8h3ApsVzcx+bOsj673uQH1NwEjvf2lod667zoId
xJ4P82A7FGC7OrLcVYPuJNXbKkfNziE46GdoF7EXCWKXw4dUu8PAx20k1mGf
v3r6HPl3aHelO+uk/hex6evOB+Gr2Psb62z2vkOH738htgOhDzlD+SWthzm+
xhrkFmiGaujBthua0b8L9eTWAO3QBgs46we5nM1xFnt3YLUoh+FJ2wntwkpo
R/7p/2tH9iFXxlazar+P/mm4wdkL6CXXNmiFHjgF+3z/tXMzsd0Mndg2wYDI
bKSbgZyleJHNlmashe/dcBLbPfAFuTk0Wd9qif0gabGVQyZyHz7ydfcJ29Vj
UOHnZwxni2Prh/qyCXlGbLkopzLk2TALtsTWy17tjLOe1sWmo7Pa2Hqs7++h
Cxaiu1Nvhe9vq+/7Z7/n8nMPPmp2lE9oO6LdGK29Dmzmlaty/qq3IGm1qKa+
wHZUs6EZ0aytCW1XNHPq9ZLQZl09192NSNpd6g6Va4uPrZwHo1sU2mxpxs6h
+yRpu6sdTous5+r17RS7i/TIZH3TG6K3pNXXNZHzgtD8q0btSkZgs635agrs
TdNbdjMw3fzQcpHNf6vvzMc=
         "],
         VertexColors->None], 
        PolygonBox[{{2292, 2294, 2293, 2248, 981}, {1919, 1920, 742, 710, 
         711}, {1753, 1713, 585, 617, 616}, {1260, 1261, 197, 165, 166}, {
         1793, 1754, 616, 648, 647}, {1589, 1551, 1550, 1592, 476}, {1259, 
         1218, 164, 196, 195}, {1102, 1103, 72, 40, 41}, {1961, 1917, 739, 
         771, 770}, {1586, 1588, 1587, 1546, 441}, {1836, 1837, 679, 647, 
         648}, {2297, 2250, 985, 2295, 2296}, {1863, 1821, 667, 1861, 1862}, {
         1219, 1179, 134, 166, 165}, {1363, 1325, 1324, 1366, 285}, {1032, 
         1034, 9, 41, 40}, {1180, 1181, 135, 103, 104}, {1249, 1208, 158, 
         1247, 1248}, {1779, 1744, 1743, 1782, 635}, {1945, 1947, 1946, 1898, 
         727}, {1987, 2031, 822, 2028, 1986}, {2118, 2120, 2119, 2074, 854}, {
         1293, 1294, 228, 196, 197}, {1918, 1874, 709, 741, 740}, {1138, 1101,
          72, 104, 103}, {1334, 1335, 257, 225, 226}, {1963, 1964, 773, 741, 
         742}, {1820, 1860, 695, 1857, 1819}, {1478, 1436, 349, 1476, 1477}, {
         1834, 1794, 647, 679, 678}, {1737, 1740, 1739, 1701, 568}, {1166, 
         1129, 1128, 1171, 126}, {1401, 1403, 1402, 1361, 282}, {1178, 1139, 
         103, 135, 134}, {1795, 1796, 648, 616, 617}, {1666, 1625, 508, 1664, 
         1665}, {1435, 1475, 377, 1471, 1434}, {1220, 1221, 166, 134, 135}, {
         1873, 1835, 678, 710, 709}, {1204, 1207, 1206, 1164, 123}, {2123, 
         2076, 858, 2121, 2122}, {1081, 1082, 59, 1076, 1080}, {1678, 1637, 
         522, 554, 553}, {1284, 1321, 250, 1317, 1283}, {1714, 1715, 585, 553,
          554}, {2207, 2162, 2161, 2211, 953}, {1988, 1951, 1950, 1991, 
         794}, {1624, 1663, 536, 1659, 1623}, {2160, 2206, 949, 2203, 2159}, {
         2005, 2006, 803, 771, 772}},
         VertexColors->None], 
        PolygonBox[{{1488, 1448, 365, 1490, 1491, 396}, {1636, 1601, 491, 
         1638, 1639, 522}, {1375, 1338, 270, 1377, 1378, 301}, {1560, 1525, 
         428, 1562, 1563, 459}, {1037, 1039, 17, 1040, 1041, 48}, {1182, 1141,
          112, 1184, 1185, 143}, {1295, 1262, 207, 1297, 1298, 238}},
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1744, 1779, 603}, {1917, 1961, 738}, {2120, 2118, 886}, {
         1448, 1488, 364}, {1835, 1873, 677}, {1403, 1401, 314}, {2162, 2207, 
         921}, {1525, 1560, 427}, {1951, 1988, 762}, {2294, 2292, 1013}, {
         1294, 1293, 229}, {1221, 1220, 167}, {1754, 1793, 615}, {1713, 1753, 
         584}, {1207, 1204, 155}, {1637, 1678, 521}, {1947, 1945, 759}, {1129,
          1166, 94}, {1338, 1375, 269}, {1103, 1102, 73}, {1551, 1589, 444}, {
         1261, 1260, 198}, {1325, 1363, 253}, {1141, 1182, 111}, {1262, 1295, 
         206}, {1601, 1636, 490}, {1181, 1180, 136}, {1588, 1586, 473}, {1794,
          1834, 646}, {1740, 1737, 600}, {1335, 1334, 258}, {1874, 1918, 
         708}, {1039, 1037, 16}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJxNmFlsVlUUhe9//1Eo6psyaMJQJgFfjNKCRKAUBBRjTCyCRlsolgIa48BQ
NQwyq2+KLU6MpaiJLyKDD1iGUtHoizKoCaICImqMymjiWu4v0YeV//Scffa4
9rnntHftY/fOS5Mk6ZlJkpx+79TvRGG20CAMEAYKE4TxwONHhVnCYOEmYRL7
qoRxwkxhBrJ3ost75haT5E3hkoweE57TuElo13if0Fcy/dAzFlShq04Yw5zH
tcIIYaQwXZiGr4OwOQFfqoV6fKpkj2UfwPchwmRi2CZf2oQT8uU7oT85GI+e
asaz0Glfy7FTxbg/cp4bjc/29RHhReX4JeE94V3hkOY6hZ+EM8JS2VwmbBI2
Ch+qKCeEjyT7urBYc0uEDcLbyL4gbGbPt5LdIbRIdrewQHMLhWbhNeGLfJL8
KWyXrTXCoVKSvCF8kE2SL7Oheym2bWO5ZFuFOeSop2R/VX5uk+z92fgdLtTw
9xHtOSpcFC6ksVYhTEWmSbrW56NertsMycwkBsdyrdYqhW5aO5dELQfDLdf0
rNauKSTJHo3XC+uIa6dzJfTJBIfGkvdG+VpVjLUjxLUJrrWzZyc+e905+Eo4
L/zF+Ihwgbmj8PYSMc5PI8f2YR0524juj9G9iz1HkWtmbic13IDsXuFAPmJ0
bE2ZyJXnmuB4u8Yt+eDuQuGAav2L8Bmc2osuc9ccdl/3Itfm/SnJnBZKGhcz
Uct24TpquUpzq4U294KwMhNzHrfC+0eZX0Ffz2bPKtYaGK9k3jzbjs4/VLsb
ipED8/JjxyScFL4T9mZizuMTQkcmesS9cVrY75iFH4Uf6MFZ+LJc2IeM174X
fpe9w0INtdqlud3CceEYtvche5Izoh5dL2Ti3JnJeBlnhs+OReR/KfObhI3C
EuY83sCa925G5kw+aui9zehpgsstwmJ0eO/b2FjEWjOxH3QdycEK8uzabMXv
FYy34Ot0bFiPz6BabCzGt+XIbmatjhiWUNtGauhaupd6FYPr7p06crSMPQep
2Wl83EbdO6ljM7G4Bq7FZXHxShIcNVdTIZuJHnYv/6C1H4WCxvlMcLVFOJ8G
Z7tormsmznGfE1dlYs7jQayVZeKMt0wJGa/5W2Hd7gn3gm0MV20qhBx+/KS1
s0nosd6fkziXuqHXvXQmCZ3WbVnLlGF7v3z9rRhnYHfOSJ+D84VnhHtla1A+
8uD4rcs2u+CnfbAv/chJHj/9jSmHZ+aVOdwOZ8wd99BeeLGN3Lsurp17Yj7n
VddCcLKZerTAxT3UaAM22tGZw4dyfNqKjQ5qv4W5g3DVvjq3A/C5SJ4GMreZ
PZZ13/am7j67/e30N9nfnTnwcHwx7hDHOEMnItMIV322WGYX52wN354F5Pxp
8v6q8IowV7mexzfZ3+b1fGf9vd0jdAqfwAHXxbXsVQqdrulkzd2VhJ45ltfa
xVJ8L/zdKNPZ3FXoorXBwh0aNwgPaTwKG7b1jfC1MFGYJDQKs4VVwmqhTdiG
rbvx2TZ7CTcItwsjhauFa4SbhWHcAfag+7jvd9iw7gZ0TREeQ+cB4SA94d5Y
I6wV3hG2uw/FlaHC3/i8iRruh4ON5GEte2/NR09l6e1bxbepwuVMnME1Gt8i
HNX4ovBmLr5p71GTleTAsbfidyO6V4M1+OYcdfhORU+eJpYOxqeIeTb7rLdJ
eJaau/ZvlaKGrt2H2YhlLtxwTN3IsXM7VKgQxyqFB4SpadT4Jmo4EV864c4Z
9gwj766luTSpFPw0p7x3SBK8so4XlYt6YTq+dhXKkLHsk1qbkou6NsCFG+HW
v5zIBedGMV+pcUUueGO+PC7bE0rRF+6HVnJ9iLzZtvdYdjprbcRkma3UpYNc
DyHGu4hhLbl7Fw5dLV335IJz5qjvnvbBtn0HdS6eEF6jZ9uo7SfYtA8PUjPn
w7qeygV/pxCzY30IuZHMPche6zmcxBntnv4aHpvPV8j5ZDhsnnUh5861a3uc
PZb1md0Cb9xju4nRsX6KnWHEOYWae83c/gyZMjg1lNxtR8fh//lquXP43F8c
GyCMF6rTONOcJ+drXTbWBgoTkCkIRfZ4b545j8uFHHMe90ujBy8JPTTunsbY
vdozjbkt6tXnC7Fm7ruXlxRi3XK2VcIH23w5F2+Y16mZ73S+26Vay6Qx9r0r
m/43598+Qu807mjH8cG+eL6vMFYYk4btVmFEGj74HDmG7EXsZNnTh3GOWPsS
Yw962PG8Sh7d+zuy8YbxPd/f7uuFh/PxJprMneI87xyv+T7ib3kuHzwxP57h
u7OOb47fcj5DzTmf+47dd88cvvluvygf71TfNe/Lx5vJ93ffkRzr58K0NGKu
S+MN5beT322vYGcH/eS3Vb2wPI031vXcQyp4t9lXvxl3w+3riHM47wHf4XyX
K8Gjl2X7/ULwyzX2HfQUdTevajgHF3DfnsrZuJA56/Jd/ip4UiWMS8PPGdS1
irFje0SoTeNd6rfvB8T2Fe/VMeypQ64vta1ivhyuV2OnH3PjkKkkj9PwczS8
qsX2OPbW42M1fTWLuR1w5Qg+9YZnY9DVA16OwJZ7x988c9Pc8zvFOSzQh921
NroQ/w/ohBuWycPbWmJdSk7+AamcJPw=
         "],
         VertexColors->None], 
        PolygonBox[{{1586, 1547, 442, 474, 473}, {1589, 1590, 475, 443, 
         444}, {2292, 2249, 982, 1014, 1013}, {1166, 1167, 125, 93, 94}, {
         1102, 1036, 42, 74, 73}, {1636, 1637, 521, 489, 490}, {1260, 1221, 
         167, 199, 198}, {1737, 1702, 569, 601, 600}, {1295, 1296, 237, 205, 
         206}, {1834, 1835, 677, 645, 646}, {1363, 1364, 284, 252, 253}, {
         1793, 1794, 646, 614, 615}, {1182, 1183, 142, 110, 111}, {2118, 2075,
          855, 887, 886}, {1779, 1780, 634, 602, 603}, {1374, 1335, 258, 290, 
         289}, {1375, 1376, 300, 268, 269}, {1916, 1917, 738, 706, 707}, {
         1678, 1679, 552, 520, 521}, {1945, 1899, 728, 760, 759}, {1293, 1261,
          198, 230, 229}, {1488, 1489, 395, 363, 364}, {1873, 1874, 708, 676, 
         677}, {1037, 1038, 47, 15, 16}, {1180, 1140, 105, 137, 136}, {1560, 
         1561, 458, 426, 427}, {2207, 2208, 952, 920, 921}, {1988, 1989, 793, 
         761, 762}, {1220, 1181, 136, 168, 167}, {1204, 1165, 124, 156, 
         155}, {1401, 1362, 283, 315, 314}, {1753, 1754, 615, 583, 584}, {
         1337, 1294, 229, 261, 260}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1035, 1036, 1102, 1103, 1140, 1180, 1181, 1220, 1221, 1260, 
         1261, 1293, 1294, 1337, 1336, 1334, 1335, 1374}],
        "0.72`"],
       Annotation[#, 0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1039, 1037, 1038, 1104, 1141, 1182, 1183, 1222, 1262, 1295, 
         1296, 1338, 1375, 1376, 1414, 1448, 1488, 1489, 1525, 1560, 1561, 
         1601, 1636, 1637, 1678, 1679, 1713, 1753, 1754, 1793, 1794, 1834, 
         1835, 1873, 1874, 1918, 1916, 1917, 1961, 1962}],
        "0.72`"],
       Annotation[#, 0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1084, 1088, 1129, 1166, 1167, 1208, 1249, 1286, 1325, 1363, 
         1364, 1404, 1436, 1478, 1515, 1551, 1589, 1590, 1625, 1666, 1704, 
         1744, 1779, 1780, 1821, 1863, 1901, 1951, 1988, 1989, 2032, 2076, 
         2123, 2162, 2207, 2208, 2250, 2297}],
        "0.72`"],
       Annotation[#, 0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2294, 2292, 2249, 2206, 2160, 2120, 2118, 2075, 2031, 1987, 
         1947, 1945, 1899, 1860, 1820, 1778, 1740, 1737, 1702, 1663, 1624, 
         1588, 1586, 1547, 1513, 1475, 1435, 1403, 1401, 1362, 1321, 1284, 
         1246, 1207, 1204, 1165, 1126, 1082, 1081}],
        "0.72`"],
       Annotation[#, 0.72, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1034, 1032, 1033, 1101, 1138, 1139, 1178, 1179, 1219, 1217, 
         1218, 1259, 1257, 1258}],
        "0.54`"],
       Annotation[#, 0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1043, 1040, 1041, 1105, 1144, 1184, 1185, 1223, 1265, 1297, 
         1298, 1339, 1377, 1378, 1415, 1451, 1490, 1491, 1526, 1562, 1563, 
         1602, 1638, 1639, 1680, 1714, 1715, 1755, 1795, 1796, 1836, 1837, 
         1875, 1919, 1920, 1963, 1964, 2007, 2005, 2006, 2049, 2047, 2048}],
        "0.54`"],
       Annotation[#, 0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1080, 1076, 1079, 1125, 1164, 1206, 1245, 1283, 1317, 1320, 
         1361, 1402, 1434, 1471, 1474, 1512, 1546, 1587, 1623, 1659, 1662, 
         1701, 1739, 1777, 1819, 1857, 1859, 1898, 1946, 1986, 2028, 2030, 
         2074, 2119, 2159, 2203, 2205, 2248, 2293}],
        "0.54`"],
       Annotation[#, 0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2296, 2295, 2254, 2211, 2161, 2122, 2121, 2079, 2036, 1991, 
         1950, 1900, 1862, 1861, 1825, 1782, 1743, 1703, 1665, 1664, 1629, 
         1592, 1550, 1514, 1477, 1476, 1439, 1408, 1366, 1324, 1285, 1248, 
         1247, 1211, 1171, 1128, 1087, 1083}],
        "0.54`"],
       Annotation[#, 0.54, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1031, 1029, 1030, 1099, 1100, 1137, 1135, 1136, 1177, 1175, 
         1176}],
        "0.36`"],
       Annotation[#, 0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1092, 1085, 1086, 1127, 1170, 1210, 1253, 1289, 1322, 1323, 
         1365, 1407, 1438, 1482, 1520, 1548, 1549, 1591, 1628, 1670, 1707, 
         1741, 1742, 1781, 1824, 1865, 1905, 1948, 1949, 1990, 2035, 2078, 
         2127, 2165, 2209, 2210, 2253, 2299}],
        "0.36`"],
       Annotation[#, 0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2138, 2137, 2139, 2093, 2092, 2094, 2051, 2050, 2009, 2008, 
         1965, 1922, 1921, 1877, 1876, 1838, 1798, 1797, 1756, 1717, 1716, 
         1681, 1641, 1640, 1603, 1565, 1564, 1529, 1492, 1450, 1449, 1416, 
         1380, 1379, 1342, 1299, 1264, 1263, 1226, 1186, 1143, 1142, 1107, 
         1046, 1042}],
        "0.36`"],
       Annotation[#, 0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2291, 2289, 2247, 2204, 2158, 2117, 2115, 2073, 2029, 1985, 
         1944, 1942, 1897, 1858, 1818, 1776, 1774, 1738, 1700, 1661, 1622, 
         1585, 1582, 1545, 1511, 1473, 1433, 1400, 1397, 1360, 1319, 1282, 
         1244, 1241, 1205, 1163, 1124, 1078, 1075}],
        "0.36`"],
       Annotation[#, 0.36, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[{1028, 1027, 1025, 1026, 1098, 1096, 1097}],
        "0.18`"],
       Annotation[#, 0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1048, 1044, 1045, 1106, 1147, 1188, 1224, 1225, 1268, 1301, 
         1340, 1341, 1383, 1418, 1452, 1453, 1495, 1527, 1528, 1566, 1606, 
         1642, 1643, 1682, 1718, 1719, 1757, 1799, 1800, 1839, 1878, 1879, 
         1923, 1966, 1967, 2010, 2011, 2052, 2095, 2096, 2140, 2141, 2182, 
         2180, 2181, 2227, 2225, 2226}],
        "0.18`"],
       Annotation[#, 0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2298, 2252, 2251, 2215, 2164, 2126, 2077, 2034, 2033, 1995, 
         1953, 1904, 1864, 1823, 1822, 1785, 1748, 1706, 1669, 1627, 1626, 
         1597, 1554, 1519, 1481, 1437, 1406, 1405, 1371, 1329, 1288, 1252, 
         1209, 1169, 1168, 1134, 1095, 1091}],
        "0.18`"],
       Annotation[#, 0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1074, 1077, 1123, 1159, 1162, 1203, 1243, 1281, 1318, 1356, 
         1359, 1399, 1432, 1472, 1507, 1510, 1544, 1584, 1621, 1660, 1697, 
         1699, 1736, 1775, 1817, 1853, 1856, 1896, 1943, 1984, 2025, 2027, 
         2072, 2116, 2157, 2200, 2202, 2246, 2290}],
        "0.18`"],
       Annotation[#, 0.18, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1073, 1069, 1072, 1122, 1161, 1202, 1242, 1277, 1280, 1316, 
         1358, 1398, 1428, 1431, 1470, 1509, 1543, 1583, 1617, 1620, 1658, 
         1698, 1735, 1770, 1773, 1816, 1855, 1895, 1938, 1941, 1983, 2026, 
         2071, 2112, 2114, 2156, 2201, 2245, 2286, 2288}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{2266, 2269, 2313}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2271, 2270, 2229, 2228, 2184, 2183, 2143, 2142, 2098, 2097, 
         2054, 2053, 2012, 1969, 1968, 1924, 1881, 1880, 1840, 1802, 1801, 
         1760, 1721, 1720, 1685, 1644, 1605, 1604, 1569, 1530, 1494, 1493, 
         1456, 1417, 1382, 1381, 1345, 1300, 1267, 1266, 1229, 1187, 1146, 
         1145, 1109, 1051, 1047}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1090, 1094, 1133, 1174, 1216, 1250, 1251, 1287, 1328, 1370, 
         1411, 1444, 1479, 1480, 1518, 1553, 1596, 1632, 1667, 1668, 1705, 
         1747, 1784, 1829, 1868, 1902, 1903, 1952, 1994, 2038, 2083, 2124, 
         2125, 2163, 2214, 2256, 2303}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1053, 1049, 1050, 1108, 1150, 1190, 1227, 1228, 1269, 1304, 
         1343, 1344, 1384, 1421, 1454, 1455, 1496, 1533, 1567, 1568, 1607, 
         1647, 1683, 1684, 1722, 1758, 1759, 1803, 1843, 1882, 1883, 1927, 
         1970, 1971, 2013, 2055, 2056, 2099, 2100, 2144, 2185, 2186, 2230, 
         2231, 2272, 2273}],
        RowBox[{"-", "0.18`"}]],
       Annotation[#, -0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{2176, 2179, 2224, 2268, 2312}],
        RowBox[{"-", "0.18`"}]],
       Annotation[#, -0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1068, 1071, 1121, 1160, 1198, 1201, 1240, 1279, 1315, 1357, 
         1394, 1396, 1430, 1469, 1508, 1539, 1542, 1581, 1619, 1657, 1693, 
         1696, 1734, 1772, 1815, 1854, 1892, 1894, 1940, 1982, 2022, 2024, 
         2070, 2113, 2155, 2197, 2199, 2244, 2287}],
        RowBox[{"-", "0.18`"}]],
       Annotation[#, -0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1089, 1093, 1132, 1173, 1215, 1256, 1292, 1326, 1327, 1369, 
         1410, 1443, 1485, 1516, 1517, 1552, 1595, 1631, 1674, 1710, 1745, 
         1746, 1783, 1828, 1867, 1909, 1956, 1992, 1993, 2037, 2082, 2129, 
         2169, 2212, 2213, 2255, 2302}],
        RowBox[{"-", "0.18`"}]],
       Annotation[#, -0.18, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1067, 1070, 1118, 1120, 1158, 1200, 1239, 1278, 1312, 1314, 
         1355, 1395, 1429, 1466, 1468, 1506, 1541, 1580, 1618, 1654, 1656, 
         1695, 1733, 1771, 1812, 1814, 1852, 1893, 1939, 1979, 1981, 2023, 
         2069, 2109, 2111, 2154, 2198, 2243, 2283, 2285}],
        RowBox[{"-", "0.36`"}]],
       Annotation[#, -0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1130, 1131, 1172, 1214, 1255, 1291, 1333, 1367, 1368, 1409, 
         1442, 1484, 1522, 1558, 1593, 1594, 1630, 1673, 1709, 1750, 1789, 
         1826, 1827, 1866, 1908, 1955, 1999, 2041, 2080, 2081, 2128, 2168, 
         2217, 2260, 2300, 2301}],
        RowBox[{"-", "0.36`"}]],
       Annotation[#, -0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{2088, 2091, 2136, 2178, 2223, 2267, 2311}],
        RowBox[{"-", "0.36`"}]],
       Annotation[#, -0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2275, 2274, 2232, 2188, 2187, 2145, 2102, 2101, 2058, 2057, 
         2014, 1972, 1926, 1925, 1884, 1842, 1841, 1804, 1762, 1761, 1725, 
         1686, 1646, 1645, 1610, 1570, 1532, 1531, 1499, 1457, 1420, 1419, 
         1387, 1346, 1303, 1302, 1271, 1232, 1189, 1149, 1148, 1112, 1054, 
         1052}],
        RowBox[{"-", "0.36`"}]],
       Annotation[#, -0.36, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1056, 1058, 1110, 1111, 1151, 1193, 1230, 1231, 1270, 1305, 
         1349, 1385, 1386, 1422, 1460, 1497, 1498, 1534, 1573, 1608, 1609, 
         1648, 1689, 1723, 1724, 1763, 1807, 1844, 1845, 1885, 1928, 1929, 
         1973, 2015, 2059, 2060, 2103, 2146, 2147, 2189, 2233, 2234, 2276, 
         2277}],
        RowBox[{"-", "0.54`"}]],
       Annotation[#, -0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1212, 1213, 1254, 1290, 1332, 1373, 1413, 1440, 1441, 1483, 
         1521, 1557, 1599, 1634, 1671, 1672, 1708, 1749, 1788, 1831, 1870, 
         1906, 1907, 1954, 1998, 2040, 2085, 2131, 2166, 2167, 2216, 2259, 
         2305}],
        RowBox[{"-", "0.54`"}]],
       Annotation[#, -0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2001, 2004, 2046, 2090, 2135, 2177, 2222, 2262, 2265, 2310}],
        
        RowBox[{"-", "0.54`"}]],
       Annotation[#, -0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1064, 1066, 1119, 1157, 1199, 1236, 1238, 1276, 1313, 1354, 
         1391, 1393, 1427, 1467, 1505, 1540, 1577, 1579, 1616, 1655, 1694, 
         1730, 1732, 1769, 1813, 1851, 1889, 1891, 1937, 1980, 2019, 2021, 
         2068, 2110, 2153, 2194, 2196, 2242, 2284}],
        RowBox[{"-", "0.54`"}]],
       Annotation[#, -0.54, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1063, 1065, 1115, 1117, 1156, 1197, 1237, 1275, 1309, 1311, 
         1353, 1392, 1426, 1463, 1465, 1504, 1538, 1578, 1613, 1615, 1653, 
         1692, 1731, 1766, 1768, 1811, 1850, 1890, 1935, 1936, 1978, 2020, 
         2065, 2067, 2108, 2152, 2195, 2240, 2241, 2282}],
        RowBox[{"-", "0.72`"}]],
       Annotation[#, -0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1330, 1331, 1372, 1412, 1447, 1487, 1524, 1555, 1556, 1598, 
         1633, 1677, 1712, 1752, 1786, 1787, 1830, 1869, 1912, 1958, 1996, 
         1997, 2039, 2084, 2130, 2172, 2219, 2257, 2258, 2304}],
        RowBox[{"-", "0.72`"}]],
       Annotation[#, -0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1913, 1915, 1960, 2003, 2045, 2089, 2134, 2173, 2175, 2221, 
         2264, 2309}],
        RowBox[{"-", "0.72`"}]],
       Annotation[#, -0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2278, 2236, 2235, 2190, 2149, 2148, 2104, 2062, 2061, 2016, 
         1974, 1931, 1930, 1886, 1846, 1806, 1805, 1764, 1726, 1688, 1687, 
         1649, 1611, 1572, 1571, 1535, 1500, 1459, 1458, 1423, 1388, 1348, 
         1347, 1308, 1272, 1233, 1192, 1191, 1154, 1113, 1057, 1055}],
        RowBox[{"-", "0.72`"}]],
       Annotation[#, -0.72, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1059, 1060, 1114, 1152, 1153, 1194, 1234, 1273, 1306, 1307, 
         1350, 1389, 1424, 1461, 1462, 1501, 1536, 1574, 1575, 1612, 1650, 
         1690, 1727, 1728, 1765, 1808, 1847, 1848, 1887, 1932, 1975, 1976, 
         2017, 2063, 2064, 2105, 2150, 2191, 2192, 2237, 2279, 2280}],
        RowBox[{"-", "0.8999999999999999`"}]],
       Annotation[#, -0.8999999999999999, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1061, 1062, 1116, 1155, 1195, 1196, 1235, 1274, 1310, 1351, 
         1352, 1390, 1425, 1464, 1502, 1503, 1537, 1576, 1614, 1651, 1652, 
         1691, 1729, 1767, 1809, 1810, 1849, 1888, 1933, 1934, 1977, 2018, 
         2066, 2106, 2107, 2151, 2193, 2238, 2239, 2281}],
        RowBox[{"-", "0.8999999999999999`"}]],
       Annotation[#, -0.8999999999999999, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1445, 1446, 1486, 1523, 1559, 1600, 1635, 1675, 1676, 1711, 
         1751, 1790, 1832, 1871, 1910, 1911, 1957, 2000, 2042, 2086, 2132, 
         2170, 2171, 2218, 2261, 2306}],
        RowBox[{"-", "0.8999999999999999`"}]],
       Annotation[#, -0.8999999999999999, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1791, 1792, 1833, 1872, 1914, 1959, 2002, 2043, 2044, 2087, 
         2133, 2174, 2220, 2263, 2307, 2308}],
        RowBox[{"-", "0.8999999999999999`"}]],
       Annotation[#, -0.8999999999999999, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{1., 32.}, {1., 32.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->285303821]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1555621290],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListDensityPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListDensityPlot"]], "InlineFormula"],
 " to create densities from continuous data:"
}], "ExampleText",
 CellID->1861102452],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListDensityPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "Pi", ",", "0.1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "0", ",", "Pi", ",", "0.1"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1449592209],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx12zuKJEcQANBByFhzjDHGaKPVNE3TFEX9v/mZM+gIAtm6uo4gsWwi9Nhs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   "], PolygonBox[CompressedData["
1:eJwt21MUZXUfx+HTTJhqaqqpRtXU2DZrbJs1ts0a22aNbbPGtpltu3f/3/Nc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    "]],
   VertexColors->CompressedData["
1:eJztvHlUjW37/x8yRGRIiooiMiUUGt80CaFSEclQpFAKRYhIijQYU6YURdKc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    "]],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{1., 32.}, {1., 32.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1892848697,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1821370873],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ArrayPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MatrixPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixPlot"]], "InlineFormula"],
 " for arrays of discrete values:"
}], "ExampleText",
 CellID->1145295310],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"GCD", "[", 
     RowBox[{"i", ",", "j"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "20"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "1", ",", "20"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->92855398],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztm09uglAQxiF2IYmbdlV2pk28ANsm7tqNbpu4JKZWF00bce+6CRewB3DT
jYnuvYAX8AJcgAPYGWDIA4TaSqMNHwm+P/O9+SXwcN48tGtPhk8v9mTUt5sP
Y/ttOOo7zfvXMXXVdE3TVnxea1TfUS08a7sdV/hY0KmHzRrbgkNb0IceCo7v
vYh76aj7vm94nheUm83GWK/XdWob1K5zm/un06nYYz3pjMge69k5OOBUiPPB
4xqNBo+H5nea+Npvt1tDrvlyuYzvgeu68b2k/r160zRFDw444JTPeedxrVbL
LHiWq6zJxBw1hsxmMyNlT+gty0royQ4OOOCUz7lkO3/38TheF1Kd+wzu43ZU
D3TtdvtK0fP6EH7h95R+E/Ne5juX8/lc5r9qD8pOp5PR+weuK8ABB5wfc57Z
3uv17vz8NWOVNYk8ROK95C3cjvKTQDcYDL7TgwMOOOVzHtnuOE634FmGpliT
iTnqfrTEHNmPVmMP70enYw7pwAGnShzJpSRHCvIo13Uln0rYo374gq9T+Dpq
Hyuy//l+GTjgnCnHYj3l4moJ7Wm0iZxB7p36blHNMfLeLSp6cMABp3zODY+j
NbVa8hr7Niox7rzHFcZW+b1aXmzdowcHHHDK5+zNE1Nl2g5f8HWor8x+mjov
vZx3kwV6cMABp3zOZ8Ez/E9tR/+zaBXa9C8uFQ4b\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->96411842]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->402920390],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ParametricPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot"]], "InlineFormula"],
 " for parametric curves:"
}], "ExampleText",
 CellID->34695851],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
       RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
         RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->557810802],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->8047162]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23685],

Cell["Limiting the number of points may introduce artifacts:", "ExampleText",
 CellID->1347617723],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"10", "x"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"MaxPlotPoints", "\[Rule]", "30"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2048529199],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1., 0.}, {2., 0.8414709848078965}, {3., 0.9092974268256817}, {
     4., 0.14112000805986677`}, {6., -0.9589242746631385}, {
     7., -0.279415498198925}, {9., 0.9893582466233818}, {10., 
     0.4121184852417566}, {12., -0.9999902065507035}, {
     13., -0.5365729180004335}, {15., 0.9906073556948706}, {16., 
     0.6502878401571168}, {18., -0.9613974918795568}, {
     19., -0.750987246771676}, {21., 0.9129452507276277}, {22., 
     0.8366556385360561}, {24., -0.8462204041751725}, {27., 
     0.7625584504796027}, {30., -0.6636338842129702}, {33., 
     0.5514266812416906}, {36., -0.428182669496151}, {39., 
     0.2963685787093853}, {42., -0.158622668804716}, {45., 
     0.017701925105413577`}, {48., 0.123573122745224}, {
     51., -0.26237485370392877`}, {54., 0.39592515018182767`}, {
     57., -0.5215510020869059}, {60., 0.6367380071391379}, {
     63., -0.7391806966492228}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 63.}, {-0.9999902065507035, 0.9906073556948706}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6983746]
}, Open  ]],

Cell["Use more points to have fewer artifacts: ", "ExampleText",
 CellID->169496643],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"10", "x"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"MaxPlotPoints", "\[Rule]", "50"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26526337],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1., 0.}, {2., 0.8414709848078965}, {3., 0.9092974268256817}, {
     4., 0.14112000805986677`}, {5., -0.7568024953079282}, {
     6., -0.9589242746631385}, {7., -0.279415498198925}, {8., 
     0.6569865987187897}, {9., 0.9893582466233818}, {10., 
     0.4121184852417566}, {11., -0.5440211108893698}, {
     12., -0.9999902065507035}, {13., -0.5365729180004335}, {14., 
     0.4201670368266409}, {15., 0.9906073556948706}, {16., 
     0.6502878401571168}, {17., -0.2879033166650653}, {
     18., -0.9613974918795568}, {19., -0.750987246771676}, {20., 
     0.14987720966295234`}, {21., 0.9129452507276277}, {22., 
     0.8366556385360561}, {23., -0.008851309290403876}, {
     24., -0.8462204041751725}, {25., -0.9055783620066223}, {
     26., -0.13235175009777303`}, {27., 0.7625584504796027}, {28., 
     0.956375928404503}, {29., 0.2709057883078656}, {
     30., -0.6636338842129702}, {31., -0.9880316240928618}, {
     32., -0.404037645323065}, {33., 0.5514266812416906}, {34., 
     0.9999118601072672}, {35., 0.5290826861200238}, {
     36., -0.428182669496151}, {38., -0.6435381333569995}, {40., 
     0.9637953862840878}, {42., -0.158622668804716}, {
     44., -0.8317747426285983}, {46., 0.8509035245341184}, {48., 
     0.123573122745224}, {50., -0.9537526527594719}, {52., 
     0.67022917584338}, {54., 0.39592515018182767`}, {
     56., -0.9997551733586199}, {58., 0.43616475524782494`}, {60., 
     0.6367380071391379}, {62., -0.9661177700083948}, {
     63., -0.7391806966492228}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 63.}, {-0.9999902065507035, 0.9999118601072672}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->79430508]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->567261646],

Cell["Unordered data may display in unexpected ways:", "ExampleText",
 CellID->1286575289],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Sin", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"RandomReal", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"2", "Pi"}]}], "}"}], ",", "100"}], "]"}]}], "}"}]}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->458040580],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1706637212],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVkn881Hccx09c7nA43J2Uyq/yI8zvbWXvz7AZK8weipssVixMP2gPo1Bj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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 6.2424849028418965`}, {-0.9976945902836829, 
   0.9977090846723765}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->144177934]
}, Open  ]],

Cell["Sort the data to interpret as a function: ", "ExampleText",
 CellID->176659333],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Sort", "[", "data", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1660032752],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->22244324]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11426],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Plot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Plot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPlot3D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Fit"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2323]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with ListLinePlot",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=ListLinePlot"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->604983327],

Cell[TextData[ButtonBox["Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataVisualization"]], "MoreAbout",
 CellID->357933927],

Cell[TextData[ButtonBox["New in 6.0: Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataVisualization"]], "MoreAbout",
 CellID->4090893],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->7286820]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ListLinePlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 56, 29.4422894}", "context" -> "System`", 
    "keywords" -> {
     "data plotting", "line charts", "LineListPlot", 
      "plot multiple data sets", "plot x y values", "plot y values", 
      "plotting discrete data", "plotting sampled data", 
      "plotting time series", "stacked line chart"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ListLinePlot[{y_1, y_2, ...}] plots a line through a list of values, \
assumed to correspond to x coordinates 1, 2, .... ListLinePlot[{{x_1, y_1}, \
{x_2, y_2}, ...}] plots a line through specific x and y positions. \
ListLinePlot[{list_1, list_2, ...}] plots several lines. ", 
    "synonyms" -> {"list line plot"}, "title" -> "ListLinePlot", "type" -> 
    "Symbol", "uri" -> "ref/ListLinePlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[23428, 778, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->63489598]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 677797, 15891}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1898, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2521, 69, 1577, 37, 70, "ObjectNameGrid"],
Cell[4101, 108, 2457, 79, 70, "Usage",
 CellID->25430]
}, Open  ]],
Cell[CellGroupData[{
Cell[6595, 192, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7073, 209, 368, 12, 70, "Notes",
 CellID->16078],
Cell[7444, 223, 6289, 175, 70, "3ColumnTableMod",
 CellID->21901],
Cell[13736, 400, 362, 12, 70, "Notes",
 CellID->19086],
Cell[14101, 414, 633, 23, 70, "Notes",
 CellID->25019],
Cell[14737, 439, 476, 17, 70, "Notes",
 CellID->5075],
Cell[15216, 458, 498, 18, 70, "Notes",
 CellID->18467],
Cell[15717, 478, 690, 26, 70, "Notes",
 CellID->30492],
Cell[16410, 506, 305, 10, 70, "Notes",
 CellID->17251],
Cell[16718, 518, 395, 14, 70, "Notes",
 CellID->23597],
Cell[17116, 534, 729, 25, 70, "Notes",
 CellID->15715],
Cell[17848, 561, 802, 30, 70, "Notes",
 CellID->27057],
Cell[18653, 593, 1439, 52, 70, "Notes",
 CellID->15588],
Cell[20095, 647, 580, 20, 70, "Notes",
 CellID->8999],
Cell[20678, 669, 308, 13, 70, "Notes",
 CellID->22588],
Cell[20989, 684, 567, 19, 70, "Notes",
 CellID->11025],
Cell[21559, 705, 81, 1, 70, "Notes",
 CellID->8007],
Cell[21643, 708, 413, 13, 70, "Notes",
 CellID->29624],
Cell[22059, 723, 580, 21, 70, "Notes",
 CellID->15768],
Cell[22642, 746, 749, 27, 70, "Notes",
 CellID->15115]
}, Closed]],
Cell[CellGroupData[{
Cell[23428, 778, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->63489598],
Cell[CellGroupData[{
Cell[23812, 792, 148, 5, 70, "ExampleSection",
 CellID->118367028],
Cell[23963, 799, 145, 6, 70, "ExampleText",
 CellID->1588],
Cell[CellGroupData[{
Cell[24133, 809, 237, 7, 28, "Input",
 CellID->55522471],
Cell[24373, 818, 1156, 27, 139, "Output",
 CellID->490717526]
}, Open  ]],
Cell[25544, 848, 125, 3, 70, "ExampleDelimiter",
 CellID->288302413],
Cell[25672, 853, 179, 7, 70, "ExampleText",
 CellID->148438464],
Cell[CellGroupData[{
Cell[25876, 864, 600, 18, 70, "Input",
 CellID->219104540],
Cell[26479, 884, 805, 22, 137, "Output",
 CellID->33495792]
}, Open  ]],
Cell[27299, 909, 125, 3, 70, "ExampleDelimiter",
 CellID->483632782],
Cell[27427, 914, 67, 1, 70, "ExampleText",
 CellID->189219298],
Cell[CellGroupData[{
Cell[27519, 919, 456, 15, 28, "Input",
 CellID->760142577],
Cell[27978, 936, 8699, 147, 120, "Output",
 Evaluatable->False,
 CellID->243933347]
}, Open  ]],
Cell[36692, 1086, 121, 3, 70, "ExampleDelimiter",
 CellID->32708],
Cell[36816, 1091, 88, 1, 70, "ExampleText",
 CellID->327438128],
Cell[CellGroupData[{
Cell[36929, 1096, 423, 13, 47, "Input",
 CellID->19242602],
Cell[37355, 1111, 4145, 72, 136, "Output",
 Evaluatable->False,
 CellID->430409822]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[41549, 1189, 216, 7, 70, "ExampleSection",
 CellID->7359],
Cell[CellGroupData[{
Cell[41790, 1200, 224, 7, 70, "ExampleSubsection",
 CellID->22776660],
Cell[42017, 1209, 78, 1, 70, "ExampleText",
 CellID->5555],
Cell[CellGroupData[{
Cell[42120, 1214, 214, 7, 70, "Input",
 CellID->172764079],
Cell[42337, 1223, 520, 17, 140, "Output",
 CellID->386768367]
}, Open  ]],
Cell[42872, 1243, 126, 3, 70, "ExampleDelimiter",
 CellID->1676973343],
Cell[43001, 1248, 163, 7, 70, "ExampleText",
 CellID->1689261069],
Cell[CellGroupData[{
Cell[43189, 1259, 568, 19, 70, "Input",
 CellID->1315592573],
Cell[43760, 1280, 525, 17, 140, "Output",
 CellID->201306680]
}, Open  ]],
Cell[44300, 1300, 126, 3, 70, "ExampleDelimiter",
 CellID->1261349458],
Cell[44429, 1305, 70, 1, 70, "ExampleText",
 CellID->557014116],
Cell[CellGroupData[{
Cell[44524, 1310, 386, 13, 70, "Input",
 CellID->855030339],
Cell[44913, 1325, 701, 20, 140, "Output",
 CellID->124357235]
}, Open  ]],
Cell[45629, 1348, 125, 3, 70, "ExampleDelimiter",
 CellID->100736041],
Cell[45757, 1353, 85, 1, 70, "ExampleText",
 CellID->749339086],
Cell[CellGroupData[{
Cell[45867, 1358, 209, 6, 70, "Input",
 CellID->11813271],
Cell[46079, 1366, 623, 18, 140, "Output",
 CellID->197237925]
}, Open  ]],
Cell[46717, 1387, 124, 3, 70, "ExampleDelimiter",
 CellID->77265725],
Cell[46844, 1392, 85, 1, 70, "ExampleText",
 CellID->1524917287],
Cell[CellGroupData[{
Cell[46954, 1397, 341, 11, 70, "Input",
 CellID->1214999311],
Cell[47298, 1410, 634, 18, 141, "Output",
 CellID->267763261]
}, Open  ]],
Cell[47947, 1431, 125, 3, 70, "ExampleDelimiter",
 CellID->119237889],
Cell[48075, 1436, 89, 1, 70, "ExampleText",
 CellID->360827733],
Cell[CellGroupData[{
Cell[48189, 1441, 288, 7, 70, "Input",
 CellID->453187265],
Cell[48480, 1450, 534, 16, 130, "Output",
 CellID->411301112]
}, Open  ]],
Cell[49029, 1469, 125, 3, 70, "ExampleDelimiter",
 CellID->252963271],
Cell[49157, 1474, 226, 8, 70, "ExampleText",
 CellID->430742835],
Cell[CellGroupData[{
Cell[49408, 1486, 545, 17, 70, "Input",
 CellID->30552953],
Cell[49956, 1505, 2523, 56, 145, "Output",
 CellID->234407370]
}, Open  ]],
Cell[52494, 1564, 126, 3, 70, "ExampleDelimiter",
 CellID->1484798803],
Cell[52623, 1569, 232, 8, 70, "ExampleText",
 CellID->694407743],
Cell[CellGroupData[{
Cell[52880, 1581, 387, 12, 70, "Input",
 CellID->1253503881],
Cell[53270, 1595, 759, 20, 130, "Output",
 CellID->2009217200]
}, Open  ]],
Cell[CellGroupData[{
Cell[54066, 1620, 444, 14, 70, "Input",
 CellID->1880614972],
Cell[54513, 1636, 802, 20, 129, "Output",
 CellID->831517858]
}, Open  ]],
Cell[55330, 1659, 125, 3, 70, "ExampleDelimiter",
 CellID->226160967],
Cell[55458, 1664, 223, 8, 70, "ExampleText",
 CellID->316263374],
Cell[CellGroupData[{
Cell[55706, 1676, 834, 27, 70, "Input",
 CellID->41344862],
Cell[56543, 1705, 2358, 49, 148, "Output",
 CellID->453643178]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[58950, 1760, 231, 7, 70, "ExampleSubsection",
 CellID->5373264],
Cell[59184, 1769, 102, 2, 70, "ExampleText",
 CellID->150311282],
Cell[59289, 1773, 608, 21, 70, "Input",
 CellID->576945024],
Cell[CellGroupData[{
Cell[59922, 1798, 110, 3, 70, "Input",
 CellID->74897845],
Cell[60035, 1803, 2565, 52, 128, "Output",
 CellID->166180578]
}, Open  ]],
Cell[62615, 1858, 124, 3, 70, "ExampleDelimiter",
 CellID->90466730],
Cell[62742, 1863, 88, 1, 70, "ExampleText",
 CellID->238286887],
Cell[62833, 1866, 608, 21, 70, "Input",
 CellID->673972360],
Cell[CellGroupData[{
Cell[63466, 1891, 231, 7, 70, "Input",
 CellID->1624700242],
Cell[63700, 1900, 2573, 52, 128, "Output",
 CellID->50307452]
}, Open  ]],
Cell[66288, 1955, 125, 3, 70, "ExampleDelimiter",
 CellID->103486521],
Cell[66416, 1960, 54, 1, 70, "ExampleText",
 CellID->797294755],
Cell[CellGroupData[{
Cell[66495, 1965, 580, 18, 70, "Input",
 CellID->575371355],
Cell[67078, 1985, 1065, 30, 160, "Output",
 CellID->572626768]
}, Open  ]],
Cell[68158, 2018, 124, 3, 70, "ExampleDelimiter",
 CellID->64589049],
Cell[68285, 2023, 218, 8, 70, "ExampleText",
 CellID->213196035],
Cell[CellGroupData[{
Cell[68528, 2035, 634, 19, 70, "Input",
 CellID->1129040372],
Cell[69165, 2056, 6241, 214, 70, "Output",
 CellID->735804]
}, Open  ]],
Cell[CellGroupData[{
Cell[75443, 2275, 764, 23, 70, "Input",
 CellID->162853632],
Cell[76210, 2300, 9398, 305, 70, "Output",
 CellID->53993349]
}, Open  ]],
Cell[85623, 2608, 124, 3, 70, "ExampleDelimiter",
 CellID->71232987],
Cell[85750, 2613, 64, 1, 70, "ExampleText",
 CellID->594811598],
Cell[CellGroupData[{
Cell[85839, 2618, 539, 18, 70, "Input",
 CellID->388733632],
Cell[86381, 2638, 1027, 25, 140, "Output",
 CellID->207164869]
}, Open  ]],
Cell[87423, 2666, 125, 3, 70, "ExampleDelimiter",
 CellID->122198397],
Cell[87551, 2671, 66, 1, 70, "ExampleText",
 CellID->130631304],
Cell[CellGroupData[{
Cell[87642, 2676, 276, 9, 70, "Input",
 CellID->766762485],
Cell[87921, 2687, 1160, 28, 140, "Output",
 CellID->431266465]
}, Open  ]],
Cell[89096, 2718, 126, 3, 70, "ExampleDelimiter",
 CellID->1146303558],
Cell[89225, 2723, 88, 1, 70, "ExampleText",
 CellID->848102069],
Cell[CellGroupData[{
Cell[89338, 2728, 823, 24, 70, "Input",
 CellID->1202508544],
Cell[90164, 2754, 10917, 346, 70, "Output",
 CellID->7305623]
}, Open  ]],
Cell[101096, 3103, 125, 3, 70, "ExampleDelimiter",
 CellID->266062213],
Cell[101224, 3108, 88, 1, 70, "ExampleText",
 CellID->207010765],
Cell[CellGroupData[{
Cell[101337, 3113, 395, 12, 70, "Input",
 CellID->643226829],
Cell[101735, 3127, 1426, 33, 140, "Output",
 CellID->233201668]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[103222, 3167, 239, 7, 70, "ExampleSection",
 CellID->23911],
Cell[103464, 3176, 78, 1, 70, "ExampleText",
 CellID->1013298950],
Cell[CellGroupData[{
Cell[103567, 3181, 475, 16, 70, "Input",
 CellID->970131940],
Cell[104045, 3199, 2677, 51, 134, "Output",
 CellID->204854141]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[106771, 3256, 222, 7, 70, "ExampleSection",
 CellID->13645187],
Cell[CellGroupData[{
Cell[107018, 3267, 232, 7, 70, "ExampleSubsection",
 CellID->342690970],
Cell[107253, 3276, 74, 1, 70, "ExampleText",
 CellID->2129016678],
Cell[CellGroupData[{
Cell[107352, 3281, 384, 13, 70, "Input",
 CellID->1010780832],
Cell[107739, 3296, 1977, 41, 148, "Output",
 CellID->1060457343]
}, Open  ]],
Cell[109731, 3340, 86, 1, 70, "ExampleText",
 CellID->683756596],
Cell[CellGroupData[{
Cell[109842, 3345, 460, 14, 70, "Input",
 CellID->498052464],
Cell[110305, 3361, 1915, 40, 85, "Output",
 CellID->1139777348]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[112269, 3407, 232, 7, 70, "ExampleSubsection",
 CellID->1421393691],
Cell[112504, 3416, 96, 1, 70, "ExampleText",
 CellID->712113875],
Cell[CellGroupData[{
Cell[112625, 3421, 245, 8, 70, "Input",
 CellID->571532394],
Cell[112873, 3431, 497, 16, 140, "Output",
 CellID->1946961923]
}, Open  ]],
Cell[113385, 3450, 126, 3, 70, "ExampleDelimiter",
 CellID->1790749060],
Cell[113514, 3455, 83, 1, 70, "ExampleText",
 CellID->278907602],
Cell[CellGroupData[{
Cell[113622, 3460, 387, 13, 70, "Input",
 CellID->1380710522],
Cell[114012, 3475, 501, 16, 139, "Output",
 CellID->2040937419]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[114562, 3497, 234, 7, 70, "ExampleSubsection",
 CellID->552467490],
Cell[114799, 3506, 76, 1, 70, "ExampleText",
 CellID->619238589],
Cell[CellGroupData[{
Cell[114900, 3511, 524, 17, 70, "Input",
 CellID->1239030680],
Cell[115427, 3530, 2673, 48, 70, "Output",
 Evaluatable->False,
 CellID->455639442]
}, Open  ]],
Cell[118115, 3581, 125, 3, 70, "ExampleDelimiter",
 CellID->703669682],
Cell[118243, 3586, 96, 1, 70, "ExampleText",
 CellID->47276655],
Cell[CellGroupData[{
Cell[118364, 3591, 581, 18, 70, "Input",
 CellID->761757896],
Cell[118948, 3611, 3063, 54, 70, "Output",
 Evaluatable->False,
 CellID->169968319]
}, Open  ]],
Cell[122026, 3668, 124, 3, 70, "ExampleDelimiter",
 CellID->27882075],
Cell[122153, 3673, 79, 1, 70, "ExampleText",
 CellID->293919194],
Cell[CellGroupData[{
Cell[122257, 3678, 523, 17, 70, "Input",
 CellID->1464476363],
Cell[122783, 3697, 2746, 49, 70, "Output",
 Evaluatable->False,
 CellID->432447038]
}, Open  ]],
Cell[125544, 3749, 125, 3, 70, "ExampleDelimiter",
 CellID->356775015],
Cell[125672, 3754, 115, 3, 70, "ExampleText",
 CellID->216629929],
Cell[CellGroupData[{
Cell[125812, 3761, 580, 19, 70, "Input",
 CellID->2143098721],
Cell[126395, 3782, 2746, 49, 70, "Output",
 Evaluatable->False,
 CellID->870834014]
}, Open  ]],
Cell[129156, 3834, 125, 3, 70, "ExampleDelimiter",
 CellID->116971732],
Cell[129284, 3839, 81, 1, 70, "ExampleText",
 CellID->214104852],
Cell[CellGroupData[{
Cell[129390, 3844, 593, 19, 70, "Input",
 CellID->1643613234],
Cell[129986, 3865, 2745, 49, 70, "Output",
 Evaluatable->False,
 CellID->22404221]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[132780, 3920, 232, 7, 70, "ExampleSubsection",
 CellID->9587682],
Cell[133015, 3929, 225, 9, 70, "ExampleText",
 CellID->4524],
Cell[CellGroupData[{
Cell[133265, 3942, 742, 22, 70, "Input",
 CellID->1257599304],
Cell[134010, 3966, 4168, 72, 70, "Output",
 Evaluatable->False,
 CellID->20406842]
}, Open  ]],
Cell[138193, 4041, 125, 3, 70, "ExampleDelimiter",
 CellID->176597214],
Cell[138321, 4046, 74, 1, 70, "ExampleText",
 CellID->29246231],
Cell[CellGroupData[{
Cell[138420, 4051, 299, 9, 70, "Input",
 CellID->835092793],
Cell[138722, 4062, 1904, 35, 70, "Output",
 Evaluatable->False,
 CellID->338202792]
}, Open  ]],
Cell[140641, 4100, 125, 3, 70, "ExampleDelimiter",
 CellID->140499403],
Cell[140769, 4105, 81, 1, 70, "ExampleText",
 CellID->94185551],
Cell[CellGroupData[{
Cell[140875, 4110, 465, 14, 70, "Input",
 CellID->15063],
Cell[141343, 4126, 2392, 43, 70, "Output",
 Evaluatable->False,
 CellID->421700574]
}, Open  ]],
Cell[CellGroupData[{
Cell[143772, 4174, 533, 17, 70, "Input",
 CellID->5186],
Cell[144308, 4193, 2516, 45, 70, "Output",
 Evaluatable->False,
 CellID->6481608]
}, Open  ]],
Cell[146839, 4241, 125, 3, 70, "ExampleDelimiter",
 CellID->317528645],
Cell[146967, 4246, 363, 12, 70, "ExampleText",
 CellID->147068490],
Cell[CellGroupData[{
Cell[147355, 4262, 413, 11, 70, "Input",
 CellID->26433733],
Cell[147771, 4275, 2160, 39, 70, "Output",
 Evaluatable->False,
 CellID->266775754]
}, Open  ]],
Cell[149946, 4317, 125, 3, 70, "ExampleDelimiter",
 CellID->257641459],
Cell[150074, 4322, 470, 18, 70, "ExampleText",
 CellID->2145045611],
Cell[CellGroupData[{
Cell[150569, 4344, 618, 16, 70, "Input",
 CellID->1973601888],
Cell[151190, 4362, 2291, 42, 70, "Output",
 Evaluatable->False,
 CellID->199866696]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[153530, 4410, 241, 7, 70, "ExampleSubsection",
 CellID->574084471],
Cell[153774, 4419, 161, 6, 70, "ExampleText",
 CellID->29852],
Cell[CellGroupData[{
Cell[153960, 4429, 725, 22, 70, "Input",
 CellID->21197],
Cell[154688, 4453, 1952, 36, 70, "Output",
 Evaluatable->False,
 CellID->36867273]
}, Open  ]],
Cell[156655, 4492, 125, 3, 70, "ExampleDelimiter",
 CellID->330269683],
Cell[156783, 4497, 167, 6, 70, "ExampleText",
 CellID->775742741],
Cell[CellGroupData[{
Cell[156975, 4507, 730, 22, 70, "Input",
 CellID->402141089],
Cell[157708, 4531, 1919, 36, 70, "Output",
 Evaluatable->False,
 CellID->3099265]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[159676, 4573, 230, 7, 70, "ExampleSubsection",
 CellID->173102855],
Cell[159909, 4582, 119, 3, 70, "ExampleText",
 CellID->566001237],
Cell[CellGroupData[{
Cell[160053, 4589, 292, 9, 70, "Input",
 CellID->723396511],
Cell[160348, 4600, 1434, 32, 128, "Output",
 CellID->1220234710]
}, Open  ]],
Cell[161797, 4635, 126, 3, 70, "ExampleDelimiter",
 CellID->1720727163],
Cell[161926, 4640, 74, 1, 70, "ExampleText",
 CellID->1577717696],
Cell[CellGroupData[{
Cell[162025, 4645, 432, 14, 70, "Input",
 CellID->15942120],
Cell[162460, 4661, 1761, 38, 128, "Output",
 CellID->1651238612]
}, Open  ]],
Cell[164236, 4702, 124, 3, 70, "ExampleDelimiter",
 CellID->99154392],
Cell[164363, 4707, 86, 1, 70, "ExampleText",
 CellID->1080449043],
Cell[CellGroupData[{
Cell[164474, 4712, 505, 16, 70, "Input",
 CellID->40556272],
Cell[164982, 4730, 720, 20, 142, "Output",
 CellID->2086472358]
}, Open  ]],
Cell[165717, 4753, 125, 3, 70, "ExampleDelimiter",
 CellID->299772908],
Cell[165845, 4758, 195, 7, 70, "ExampleText",
 CellID->1755387432],
Cell[CellGroupData[{
Cell[166065, 4769, 318, 11, 70, "Input",
 CellID->436181703],
Cell[166386, 4782, 468, 15, 140, "Output",
 CellID->23461482]
}, Open  ]],
Cell[166869, 4800, 328, 11, 70, "ExampleText",
 CellID->310538846],
Cell[CellGroupData[{
Cell[167222, 4815, 438, 15, 70, "Input",
 CellID->302693796],
Cell[167663, 4832, 469, 15, 140, "Output",
 CellID->528912377]
}, Open  ]],
Cell[168147, 4850, 125, 3, 70, "ExampleDelimiter",
 CellID->286628894],
Cell[168275, 4855, 86, 1, 70, "ExampleText",
 CellID->666227138],
Cell[CellGroupData[{
Cell[168386, 4860, 489, 16, 70, "Input",
 CellID->947339775],
Cell[168878, 4878, 599, 17, 140, "Output",
 CellID->3317855]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[169526, 4901, 228, 7, 70, "ExampleSubsection",
 CellID->116701697],
Cell[169757, 4910, 72, 1, 70, "ExampleText",
 CellID->13911],
Cell[CellGroupData[{
Cell[169854, 4915, 556, 18, 70, "Input",
 CellID->456081556],
Cell[170413, 4935, 4975, 104, 263, "Output",
 CellID->5753440]
}, Open  ]],
Cell[175403, 5042, 125, 3, 70, "ExampleDelimiter",
 CellID->491200879],
Cell[175531, 5047, 95, 1, 70, "ExampleText",
 CellID->410116164],
Cell[CellGroupData[{
Cell[175651, 5052, 580, 19, 70, "Input",
 CellID->70],
Cell[176234, 5073, 2949, 58, 127, "Output",
 CellID->136521073]
}, Open  ]],
Cell[179198, 5134, 126, 3, 70, "ExampleDelimiter",
 CellID->1527938944],
Cell[179327, 5139, 85, 1, 70, "ExampleText",
 CellID->460380982],
Cell[CellGroupData[{
Cell[179437, 5144, 642, 21, 70, "Input",
 CellID->5949202],
Cell[180082, 5167, 2428, 49, 127, "Output",
 CellID->479319396]
}, Open  ]],
Cell[182525, 5219, 125, 3, 70, "ExampleDelimiter",
 CellID->114396081],
Cell[182653, 5224, 62, 1, 70, "ExampleText",
 CellID->27112],
Cell[CellGroupData[{
Cell[182740, 5229, 663, 22, 70, "Input",
 CellID->6962],
Cell[183406, 5253, 2649, 53, 127, "Output",
 CellID->17718664]
}, Open  ]],
Cell[186070, 5309, 123, 3, 70, "ExampleDelimiter",
 CellID->8368027],
Cell[186196, 5314, 93, 1, 70, "ExampleText",
 CellID->140266586],
Cell[CellGroupData[{
Cell[186314, 5319, 732, 25, 70, "Input",
 CellID->88789063],
Cell[187049, 5346, 2626, 53, 127, "Output",
 CellID->111788571]
}, Open  ]],
Cell[189690, 5402, 125, 3, 70, "ExampleDelimiter",
 CellID->185630674],
Cell[189818, 5407, 220, 8, 70, "ExampleText",
 CellID->1031125038],
Cell[CellGroupData[{
Cell[190063, 5419, 739, 25, 70, "Input",
 CellID->2072966023],
Cell[190805, 5446, 2410, 49, 127, "Output",
 CellID->415801359]
}, Open  ]],
Cell[193230, 5498, 125, 3, 70, "ExampleDelimiter",
 CellID->245368575],
Cell[193358, 5503, 141, 4, 70, "ExampleText",
 CellID->1241540290],
Cell[CellGroupData[{
Cell[193524, 5511, 794, 27, 70, "Input",
 CellID->9250746],
Cell[194321, 5540, 2618, 53, 127, "Output",
 CellID->687024047]
}, Open  ]],
Cell[196954, 5596, 125, 3, 70, "ExampleDelimiter",
 CellID->392432106],
Cell[197082, 5601, 99, 1, 70, "ExampleText",
 CellID->684125605],
Cell[CellGroupData[{
Cell[197206, 5606, 804, 27, 70, "Input",
 CellID->471597197],
Cell[198013, 5635, 916, 23, 128, "Output",
 CellID->157912523]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[198978, 5664, 228, 7, 70, "ExampleSubsection",
 CellID->7509],
Cell[199209, 5673, 65, 1, 70, "ExampleText",
 CellID->10234],
Cell[CellGroupData[{
Cell[199299, 5678, 681, 21, 70, "Input",
 CellID->12500],
Cell[199983, 5701, 5408, 93, 70, "Output",
 Evaluatable->False,
 CellID->203002990]
}, Open  ]],
Cell[205406, 5797, 119, 3, 70, "ExampleDelimiter",
 CellID->839],
Cell[205528, 5802, 68, 1, 70, "ExampleText",
 CellID->21157],
Cell[CellGroupData[{
Cell[205621, 5807, 894, 28, 70, "Input",
 CellID->5668],
Cell[206518, 5837, 4297, 82, 128, "Output",
 CellID->384458003]
}, Open  ]],
Cell[210830, 5922, 126, 3, 70, "ExampleDelimiter",
 CellID->1711066621],
Cell[210959, 5927, 88, 1, 70, "ExampleText",
 CellID->943182170],
Cell[CellGroupData[{
Cell[211072, 5932, 523, 16, 70, "Input",
 CellID->1485932683],
Cell[211598, 5950, 2344, 48, 128, "Output",
 CellID->341128309]
}, Open  ]],
Cell[213957, 6001, 120, 3, 70, "ExampleDelimiter",
 CellID->4485],
Cell[214080, 6006, 232, 8, 70, "ExampleText",
 CellID->23592],
Cell[CellGroupData[{
Cell[214337, 6018, 659, 20, 70, "Input",
 CellID->31022],
Cell[214999, 6040, 2940, 52, 70, "Output",
 Evaluatable->False,
 CellID->24042258]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[217988, 6098, 238, 7, 70, "ExampleSubsection",
 CellID->72517662],
Cell[218229, 6107, 91, 1, 70, "ExampleText",
 CellID->1440267227],
Cell[CellGroupData[{
Cell[218345, 6112, 304, 10, 70, "Input",
 CellID->94906264],
Cell[218652, 6124, 714, 19, 143, "Output",
 CellID->242960924]
}, Open  ]],
Cell[219381, 6146, 125, 3, 70, "ExampleDelimiter",
 CellID->123537426],
Cell[219509, 6151, 94, 1, 70, "ExampleText",
 CellID->135615205],
Cell[CellGroupData[{
Cell[219628, 6156, 361, 11, 70, "Input",
 CellID->86516259],
Cell[219992, 6169, 2206, 43, 140, "Output",
 CellID->24767911]
}, Open  ]],
Cell[222213, 6215, 126, 3, 70, "ExampleDelimiter",
 CellID->1824315780],
Cell[222342, 6220, 90, 1, 70, "ExampleText",
 CellID->804600968],
Cell[CellGroupData[{
Cell[222457, 6225, 361, 11, 70, "Input",
 CellID->57081524],
Cell[222821, 6238, 810, 21, 143, "Output",
 CellID->124207887]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[223680, 6265, 234, 7, 70, "ExampleSubsection",
 CellID->265503371],
Cell[223917, 6274, 78, 1, 70, "ExampleText",
 CellID->517132780],
Cell[CellGroupData[{
Cell[224020, 6279, 314, 10, 70, "Input",
 CellID->823101385],
Cell[224337, 6291, 1453, 32, 128, "Output",
 CellID->455909126]
}, Open  ]],
Cell[225805, 6326, 125, 3, 70, "ExampleDelimiter",
 CellID->584314051],
Cell[225933, 6331, 81, 1, 70, "ExampleText",
 CellID->284070523],
Cell[CellGroupData[{
Cell[226039, 6336, 581, 19, 70, "Input",
 CellID->455487916],
Cell[226623, 6357, 3923, 79, 101, "Output",
 CellID->909746607]
}, Open  ]],
Cell[230561, 6439, 293, 11, 70, "ExampleText",
 CellID->445067901],
Cell[CellGroupData[{
Cell[230879, 6454, 502, 16, 70, "Input",
 CellID->38288660],
Cell[231384, 6472, 9638, 162, 70, "Output",
 Evaluatable->False,
 CellID->220238894]
}, Open  ]],
Cell[241037, 6637, 126, 3, 70, "ExampleDelimiter",
 CellID->1651286241],
Cell[241166, 6642, 115, 3, 70, "ExampleText",
 CellID->998613596],
Cell[CellGroupData[{
Cell[241306, 6649, 645, 21, 70, "Input",
 CellID->1127695697],
Cell[241954, 6672, 4223, 87, 101, "Output",
 CellID->579551144]
}, Open  ]],
Cell[CellGroupData[{
Cell[246214, 6764, 805, 26, 70, "Input",
 CellID->331109889],
Cell[247022, 6792, 7425, 144, 116, "Output",
 CellID->88304733]
}, Open  ]],
Cell[254462, 6939, 126, 3, 70, "ExampleDelimiter",
 CellID->2130429834],
Cell[254591, 6944, 104, 2, 70, "ExampleText",
 CellID->1139373607],
Cell[CellGroupData[{
Cell[254720, 6950, 387, 10, 70, "Input",
 CellID->340532550],
Cell[255110, 6962, 661, 19, 143, "Output",
 CellID->349435616]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[255820, 6987, 220, 7, 70, "ExampleSubsection",
 CellID->9937],
Cell[256043, 6996, 107, 3, 70, "ExampleText",
 CellID->9407],
Cell[CellGroupData[{
Cell[256175, 7003, 628, 20, 70, "Input",
 CellID->931680886],
Cell[256806, 7025, 2022, 45, 133, "Output",
 CellID->439688444]
}, Open  ]],
Cell[258843, 7073, 125, 3, 70, "ExampleDelimiter",
 CellID->371721903],
Cell[258971, 7078, 82, 1, 70, "ExampleText",
 CellID->500094598],
Cell[CellGroupData[{
Cell[259078, 7083, 749, 23, 70, "Input",
 CellID->929117308],
Cell[259830, 7108, 5225, 90, 70, "Output",
 Evaluatable->False,
 CellID->5157091]
}, Open  ]],
Cell[265070, 7201, 125, 3, 70, "ExampleDelimiter",
 CellID->908508703],
Cell[265198, 7206, 174, 6, 70, "ExampleText",
 CellID->11427],
Cell[CellGroupData[{
Cell[265397, 7216, 351, 11, 70, "Input",
 CellID->29355],
Cell[265751, 7229, 2344, 46, 128, "Output",
 CellID->1235711264]
}, Open  ]],
Cell[268110, 7278, 125, 3, 70, "ExampleDelimiter",
 CellID->314682034],
Cell[268238, 7283, 189, 6, 70, "ExampleText",
 CellID->238138513],
Cell[CellGroupData[{
Cell[268452, 7293, 649, 20, 70, "Input",
 CellID->50003947],
Cell[269104, 7315, 2041, 42, 128, "Output",
 CellID->184567595]
}, Open  ]],
Cell[271160, 7360, 123, 3, 70, "ExampleDelimiter",
 CellID->3572689],
Cell[271286, 7365, 176, 6, 70, "ExampleText",
 CellID->378589077],
Cell[CellGroupData[{
Cell[271487, 7375, 897, 30, 70, "Input",
 CellID->45007179],
Cell[272387, 7407, 1937, 43, 128, "Output",
 CellID->467975428]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[274373, 7456, 234, 7, 70, "ExampleSubsection",
 CellID->208274223],
Cell[274610, 7465, 245, 9, 70, "ExampleText",
 CellID->236651916],
Cell[CellGroupData[{
Cell[274880, 7478, 829, 25, 70, "Input",
 CellID->237800640],
Cell[275712, 7505, 2940, 62, 154, "Output",
 CellID->320363855]
}, Open  ]],
Cell[278667, 7570, 125, 3, 70, "ExampleDelimiter",
 CellID->450987812],
Cell[278795, 7575, 276, 9, 70, "ExampleText",
 CellID->1980240883],
Cell[CellGroupData[{
Cell[279096, 7588, 779, 25, 70, "Input",
 CellID->206959375],
Cell[279878, 7615, 2003, 40, 133, "Output",
 CellID->182359206]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[281930, 7661, 232, 7, 70, "ExampleSubsection",
 CellID->145776117],
Cell[282165, 7670, 193, 6, 70, "ExampleText",
 CellID->1563263586],
Cell[CellGroupData[{
Cell[282383, 7680, 559, 17, 70, "Input",
 CellID->1456152504],
Cell[282945, 7699, 1765, 38, 133, "Output",
 CellID->156724962]
}, Open  ]],
Cell[284725, 7740, 125, 3, 70, "ExampleDelimiter",
 CellID->913462102],
Cell[284853, 7745, 199, 8, 70, "ExampleText",
 CellID->1504189831],
Cell[CellGroupData[{
Cell[285077, 7757, 558, 17, 70, "Input",
 CellID->740997133],
Cell[285638, 7776, 1530, 33, 133, "Output",
 CellID->463855323]
}, Open  ]],
Cell[287183, 7812, 125, 3, 70, "ExampleDelimiter",
 CellID->113916258],
Cell[287311, 7817, 328, 12, 70, "ExampleText",
 CellID->101485524],
Cell[CellGroupData[{
Cell[287664, 7833, 610, 18, 70, "Input",
 CellID->914958790],
Cell[288277, 7853, 1801, 38, 133, "Output",
 CellID->407790868]
}, Open  ]],
Cell[290093, 7894, 125, 3, 70, "ExampleDelimiter",
 CellID->424843825],
Cell[290221, 7899, 358, 12, 70, "ExampleText",
 CellID->649526388],
Cell[CellGroupData[{
Cell[290604, 7915, 610, 18, 70, "Input",
 CellID->122170518],
Cell[291217, 7935, 1751, 38, 133, "Output",
 CellID->321725142]
}, Open  ]],
Cell[292983, 7976, 124, 3, 70, "ExampleDelimiter",
 CellID->78638807],
Cell[293110, 7981, 482, 18, 70, "ExampleText",
 CellID->68474456],
Cell[CellGroupData[{
Cell[293617, 8003, 685, 20, 70, "Input",
 CellID->1946430847],
Cell[294305, 8025, 1657, 33, 133, "Output",
 CellID->846292163]
}, Open  ]],
Cell[295977, 8061, 124, 3, 70, "ExampleDelimiter",
 CellID->13901850],
Cell[296104, 8066, 337, 12, 70, "ExampleText",
 CellID->1974674987],
Cell[CellGroupData[{
Cell[296466, 8082, 849, 25, 70, "Input",
 CellID->1920453998],
Cell[297318, 8109, 1599, 30, 70, "Output",
 Evaluatable->False,
 CellID->623154150]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[298966, 8145, 230, 7, 70, "ExampleSubsection",
 CellID->291423660],
Cell[299199, 8154, 85, 1, 70, "ExampleText",
 CellID->124974016],
Cell[CellGroupData[{
Cell[299309, 8159, 409, 12, 70, "Input",
 CellID->199280146],
Cell[299721, 8173, 1321, 29, 133, "Output",
 CellID->25842975]
}, Open  ]],
Cell[301057, 8205, 125, 3, 70, "ExampleDelimiter",
 CellID->751885160],
Cell[301185, 8210, 160, 6, 70, "ExampleText",
 CellID->542506413],
Cell[CellGroupData[{
Cell[301370, 8220, 404, 12, 70, "Input",
 CellID->1343653111],
Cell[301777, 8234, 1320, 29, 133, "Output",
 CellID->239763510]
}, Open  ]],
Cell[303112, 8266, 125, 3, 70, "ExampleDelimiter",
 CellID->643903660],
Cell[303240, 8271, 264, 9, 70, "ExampleText",
 CellID->1837201776],
Cell[CellGroupData[{
Cell[303529, 8284, 607, 19, 70, "Input",
 CellID->1330372666],
Cell[304139, 8305, 2423, 46, 133, "Output",
 CellID->51463816]
}, Open  ]],
Cell[306577, 8354, 125, 3, 70, "ExampleDelimiter",
 CellID->420838548],
Cell[306705, 8359, 170, 6, 70, "ExampleText",
 CellID->2133487437],
Cell[CellGroupData[{
Cell[306900, 8369, 515, 16, 70, "Input",
 CellID->2002303716],
Cell[307418, 8387, 1338, 29, 133, "Output",
 CellID->479456467]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[308805, 8422, 232, 7, 70, "ExampleSubsection",
 CellID->135624826],
Cell[309040, 8431, 254, 7, 70, "ExampleText",
 CellID->1490919188],
Cell[CellGroupData[{
Cell[309319, 8442, 430, 14, 70, "Input",
 CellID->538803949],
Cell[309752, 8458, 1485, 33, 142, "Output",
 CellID->15921021]
}, Open  ]],
Cell[311252, 8494, 125, 3, 70, "ExampleDelimiter",
 CellID->800926095],
Cell[311380, 8499, 116, 3, 70, "ExampleText",
 CellID->1039599520],
Cell[CellGroupData[{
Cell[311521, 8506, 435, 14, 70, "Input",
 CellID->300085940],
Cell[311959, 8522, 4108, 71, 70, "Output",
 Evaluatable->False,
 CellID->415133264]
}, Open  ]],
Cell[316082, 8596, 125, 3, 70, "ExampleDelimiter",
 CellID->108453591],
Cell[316210, 8601, 59, 1, 70, "ExampleText",
 CellID->892273693],
Cell[CellGroupData[{
Cell[316294, 8606, 487, 15, 70, "Input",
 CellID->565651250],
Cell[316784, 8623, 3543, 62, 70, "Output",
 Evaluatable->False,
 CellID->425321110]
}, Open  ]],
Cell[320342, 8688, 125, 3, 70, "ExampleDelimiter",
 CellID->351763345],
Cell[320470, 8693, 88, 1, 70, "ExampleText",
 CellID->1984415605],
Cell[CellGroupData[{
Cell[320583, 8698, 678, 22, 70, "Input",
 CellID->651224550],
Cell[321264, 8722, 6491, 110, 70, "Output",
 Evaluatable->False,
 CellID->291468401]
}, Open  ]],
Cell[327770, 8835, 125, 3, 70, "ExampleDelimiter",
 CellID->411107243],
Cell[327898, 8840, 80, 1, 70, "ExampleText",
 CellID->1454835775],
Cell[CellGroupData[{
Cell[328003, 8845, 542, 18, 70, "Input",
 CellID->956633561],
Cell[328548, 8865, 4336, 110, 142, "Output",
 CellID->494608982]
}, Open  ]],
Cell[332899, 8978, 125, 3, 70, "ExampleDelimiter",
 CellID->118321171],
Cell[333027, 8983, 83, 1, 70, "ExampleText",
 CellID->1798300351],
Cell[CellGroupData[{
Cell[333135, 8988, 1564, 51, 70, "Input",
 CellID->226990082],
Cell[334702, 9041, 523, 16, 123, "Output",
 CellID->397568449]
}, Open  ]],
Cell[CellGroupData[{
Cell[335262, 9062, 690, 23, 70, "Input",
 CellID->1508798363],
Cell[335955, 9087, 6572, 112, 70, "Output",
 Evaluatable->False,
 CellID->560422586]
}, Open  ]],
Cell[342542, 9202, 125, 3, 70, "ExampleDelimiter",
 CellID->213068314],
Cell[342670, 9207, 88, 1, 70, "ExampleText",
 CellID->259408171],
Cell[CellGroupData[{
Cell[342783, 9212, 452, 15, 70, "Input",
 CellID->481326587],
Cell[343238, 9229, 3901, 68, 70, "Output",
 Evaluatable->False,
 CellID->223929019]
}, Open  ]],
Cell[347154, 9300, 124, 3, 70, "ExampleDelimiter",
 CellID->62995286],
Cell[347281, 9305, 77, 1, 70, "ExampleText",
 CellID->1200966200],
Cell[CellGroupData[{
Cell[347383, 9310, 696, 22, 70, "Input",
 CellID->1349648965],
Cell[348082, 9334, 8170, 138, 70, "Output",
 Evaluatable->False,
 CellID->576829826]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[356301, 9478, 230, 7, 70, "ExampleSubsection",
 CellID->194194198],
Cell[356534, 9487, 209, 7, 70, "ExampleText",
 CellID->1204301404],
Cell[CellGroupData[{
Cell[356768, 9498, 211, 6, 70, "Input",
 CellID->2138201140],
Cell[356982, 9506, 630, 19, 141, "Output",
 CellID->485055476]
}, Open  ]],
Cell[357627, 9528, 126, 3, 70, "ExampleDelimiter",
 CellID->1761355773],
Cell[357756, 9533, 66, 1, 70, "ExampleText",
 CellID->836124642],
Cell[CellGroupData[{
Cell[357847, 9538, 280, 9, 70, "Input",
 CellID->660324053],
Cell[358130, 9549, 495, 15, 132, "Output",
 CellID->251431141]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[358674, 9570, 230, 7, 70, "ExampleSubsection",
 CellID->450032879],
Cell[358907, 9579, 74, 1, 70, "ExampleText",
 CellID->193335196],
Cell[CellGroupData[{
Cell[359006, 9584, 642, 20, 70, "Input",
 CellID->42985262],
Cell[359651, 9606, 2097, 56, 94, "Output",
 CellID->729653173]
}, Open  ]],
Cell[361763, 9665, 126, 3, 70, "ExampleDelimiter",
 CellID->1845615257],
Cell[361892, 9670, 104, 2, 70, "ExampleText",
 CellID->702451365],
Cell[CellGroupData[{
Cell[362021, 9676, 507, 17, 70, "Input",
 CellID->210197233],
Cell[362531, 9695, 3491, 68, 128, "Output",
 CellID->143844503]
}, Open  ]],
Cell[366037, 9766, 124, 3, 70, "ExampleDelimiter",
 CellID->28469554],
Cell[366164, 9771, 89, 1, 70, "ExampleText",
 CellID->24232],
Cell[CellGroupData[{
Cell[366278, 9776, 638, 20, 70, "Input",
 CellID->5765],
Cell[366919, 9798, 3455, 68, 128, "Output",
 CellID->891604571]
}, Open  ]],
Cell[370389, 9869, 123, 3, 70, "ExampleDelimiter",
 CellID->8248407],
Cell[370515, 9874, 336, 12, 70, "ExampleText",
 CellID->185208180],
Cell[CellGroupData[{
Cell[370876, 9890, 568, 17, 70, "Input",
 CellID->1043126087],
Cell[371447, 9909, 2193, 40, 70, "Output",
 Evaluatable->False,
 CellID->272498335]
}, Open  ]],
Cell[373655, 9952, 125, 3, 70, "ExampleDelimiter",
 CellID->170913875],
Cell[373783, 9957, 331, 12, 70, "ExampleText",
 CellID->43022358],
Cell[CellGroupData[{
Cell[374139, 9973, 716, 21, 70, "Input",
 CellID->891938947],
Cell[374858, 9996, 2531, 48, 128, "Output",
 CellID->540577279]
}, Open  ]],
Cell[377404, 10047, 125, 3, 70, "ExampleDelimiter",
 CellID->534064321],
Cell[377532, 10052, 341, 12, 70, "ExampleText",
 CellID->214639584],
Cell[CellGroupData[{
Cell[377898, 10068, 407, 12, 70, "Input",
 CellID->1575199054],
Cell[378308, 10082, 2444, 50, 128, "Output",
 CellID->4765930]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[380813, 10139, 223, 7, 70, "ExampleSection",
 CellID->21221],
Cell[381039, 10148, 232, 9, 70, "ExampleText",
 CellID->20192],
Cell[CellGroupData[{
Cell[381296, 10161, 481, 16, 70, "Input",
 CellID->32076],
Cell[381780, 10179, 2207, 46, 137, "Output",
 CellID->60396670]
}, Open  ]],
Cell[384002, 10228, 125, 3, 70, "ExampleDelimiter",
 CellID->250474635],
Cell[384130, 10233, 79, 1, 70, "ExampleText",
 CellID->659242325],
Cell[CellGroupData[{
Cell[384234, 10238, 290, 10, 70, "Input",
 CellID->1017621402],
Cell[384527, 10250, 4000, 74, 122, "Output",
 CellID->2671607]
}, Open  ]],
Cell[388542, 10327, 80, 1, 70, "ExampleText",
 CellID->663008312],
Cell[CellGroupData[{
Cell[388647, 10332, 340, 11, 70, "Input",
 CellID->2035539148],
Cell[388990, 10345, 5853, 105, 136, "Output",
 CellID->245471473]
}, Open  ]],
Cell[394858, 10453, 69, 1, 70, "ExampleText",
 CellID->2100579346],
Cell[CellGroupData[{
Cell[394952, 10458, 654, 21, 70, "Input",
 CellID->1974704815],
Cell[395609, 10481, 989, 25, 209, "Output",
 CellID->1290122894]
}, Open  ]],
Cell[396613, 10509, 123, 3, 70, "ExampleDelimiter",
 CellID->1479664],
Cell[396739, 10514, 119, 3, 70, "ExampleText",
 CellID->224890095],
Cell[396861, 10519, 231, 8, 70, "Input",
 CellID->820365792],
Cell[CellGroupData[{
Cell[397117, 10531, 300, 9, 70, "Input",
 CellID->339646131],
Cell[397420, 10542, 4961, 91, 171, "Output",
 CellID->14281400]
}, Open  ]],
Cell[402396, 10636, 126, 3, 70, "ExampleDelimiter",
 CellID->1348366412],
Cell[402525, 10641, 72, 1, 70, "ExampleText",
 CellID->1746843340],
Cell[402600, 10644, 619, 18, 70, "Input",
 CellID->947077243],
Cell[CellGroupData[{
Cell[403244, 10666, 750, 23, 70, "Input",
 CellID->378431537],
Cell[403997, 10691, 1662, 37, 143, "Output",
 CellID->952723900]
}, Open  ]],
Cell[405674, 10731, 126, 3, 70, "ExampleDelimiter",
 CellID->2145090741],
Cell[405803, 10736, 257, 8, 70, "ExampleText",
 CellID->132723446],
Cell[CellGroupData[{
Cell[406085, 10748, 290, 9, 70, "Input",
 CellID->289378790],
Cell[406378, 10759, 1058, 24, 139, "Output",
 CellID->1413817491]
}, Open  ]],
Cell[407451, 10786, 126, 3, 70, "ExampleDelimiter",
 CellID->1356558605],
Cell[407580, 10791, 122, 3, 70, "ExampleText",
 CellID->183278447],
Cell[CellGroupData[{
Cell[407727, 10798, 297, 9, 70, "Input",
 CellID->222503889],
Cell[408027, 10809, 1379, 31, 125, "Output",
 CellID->670099118]
}, Open  ]],
Cell[409421, 10843, 125, 3, 70, "ExampleDelimiter",
 CellID->951631358],
Cell[409549, 10848, 148, 6, 70, "ExampleText",
 CellID->1366768117],
Cell[409700, 10856, 196, 6, 70, "Input",
 CellID->1757514697],
Cell[CellGroupData[{
Cell[409921, 10866, 173, 5, 70, "Input",
 CellID->2059431641],
Cell[410097, 10873, 898, 22, 137, "Output",
 CellID->1909523555]
}, Open  ]],
Cell[411010, 10898, 124, 3, 70, "ExampleDelimiter",
 CellID->70408815],
Cell[411137, 10903, 163, 6, 70, "ExampleText",
 CellID->305339583],
Cell[CellGroupData[{
Cell[411325, 10913, 1056, 31, 70, "Input",
 CellID->156466751],
Cell[412384, 10946, 6791, 116, 70, "Output",
 Evaluatable->False,
 CellID->94758077]
}, Open  ]],
Cell[419190, 11065, 123, 3, 70, "ExampleDelimiter",
 CellID->4806696],
Cell[419316, 11070, 364, 14, 70, "ExampleText",
 CellID->169656083],
Cell[CellGroupData[{
Cell[419705, 11088, 684, 21, 70, "Input",
 CellID->82600449],
Cell[420392, 11111, 32579, 538, 70, "Output",
 Evaluatable->False,
 CellID->857653837]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[453020, 11655, 234, 7, 70, "ExampleSection",
 CellID->27462],
Cell[453257, 11664, 332, 12, 70, "ExampleText",
 CellID->528126457],
Cell[CellGroupData[{
Cell[453614, 11680, 673, 21, 70, "Input",
 CellID->671449748],
Cell[454290, 11703, 1052, 31, 138, "Output",
 CellID->91158223]
}, Open  ]],
Cell[455357, 11737, 125, 3, 70, "ExampleDelimiter",
 CellID->762793504],
Cell[455485, 11742, 201, 8, 70, "ExampleText",
 CellID->71264896],
Cell[CellGroupData[{
Cell[455711, 11754, 595, 20, 70, "Input",
 CellID->33614225],
Cell[456309, 11776, 6664, 113, 70, "Output",
 Evaluatable->False,
 CellID->283639899]
}, Open  ]],
Cell[462988, 11892, 125, 3, 70, "ExampleDelimiter",
 CellID->448224811],
Cell[463116, 11897, 505, 18, 70, "ExampleText",
 CellID->46767761],
Cell[CellGroupData[{
Cell[463646, 11919, 355, 11, 70, "Input",
 CellID->24914874],
Cell[464004, 11932, 2474, 45, 70, "Output",
 Evaluatable->False,
 CellID->231315081]
}, Open  ]],
Cell[466493, 11980, 126, 3, 70, "ExampleDelimiter",
 CellID->1505829194],
Cell[466622, 11985, 213, 8, 70, "ExampleText",
 CellID->376483663],
Cell[CellGroupData[{
Cell[466860, 11997, 417, 13, 70, "Input",
 CellID->1074099979],
Cell[467280, 12012, 2070, 41, 169, "Output",
 CellID->758152982]
}, Open  ]],
Cell[469365, 12056, 125, 3, 70, "ExampleDelimiter",
 CellID->584618151],
Cell[469493, 12061, 218, 8, 70, "ExampleText",
 CellID->939578832],
Cell[CellGroupData[{
Cell[469736, 12073, 423, 12, 70, "Input",
 CellID->1054173033],
Cell[470162, 12087, 3517, 84, 155, "Output",
 CellID->1172134152]
}, Open  ]],
Cell[473694, 12174, 125, 3, 70, "ExampleDelimiter",
 CellID->443981753],
Cell[473822, 12179, 239, 8, 70, "ExampleText",
 CellID->1643132993],
Cell[CellGroupData[{
Cell[474086, 12191, 414, 13, 70, "Input",
 CellID->1643996578],
Cell[474503, 12206, 4904, 84, 70, "Output",
 Evaluatable->False,
 CellID->97974335]
}, Open  ]],
Cell[479422, 12293, 125, 3, 70, "ExampleDelimiter",
 CellID->157163518],
Cell[479550, 12298, 220, 8, 70, "ExampleText",
 CellID->660946410],
Cell[CellGroupData[{
Cell[479795, 12310, 409, 13, 70, "Input",
 CellID->1740890586],
Cell[480207, 12325, 19659, 326, 70, "Output",
 Evaluatable->False,
 CellID->195005635]
}, Open  ]],
Cell[499881, 12654, 125, 3, 70, "ExampleDelimiter",
 CellID->668298874],
Cell[500009, 12659, 241, 8, 70, "ExampleText",
 CellID->759701508],
Cell[CellGroupData[{
Cell[500275, 12671, 414, 13, 70, "Input",
 CellID->1512963541],
Cell[500692, 12686, 78864, 1326, 70, "Output",
 CellID->285303821]
}, Open  ]],
Cell[579571, 14015, 126, 3, 70, "ExampleDelimiter",
 CellID->1555621290],
Cell[579700, 14020, 243, 8, 70, "ExampleText",
 CellID->1861102452],
Cell[CellGroupData[{
Cell[579968, 14032, 414, 13, 70, "Input",
 CellID->1449592209],
Cell[580385, 14047, 73046, 1210, 203, 28642, 478, "CachedBoxData", "BoxData", \
"Output",
 CellID->1892848697]
}, Open  ]],
Cell[653446, 15260, 126, 3, 70, "ExampleDelimiter",
 CellID->1821370873],
Cell[653575, 15265, 353, 13, 70, "ExampleText",
 CellID->1145295310],
Cell[CellGroupData[{
Cell[653953, 15282, 352, 11, 70, "Input",
 CellID->92855398],
Cell[654308, 15295, 923, 19, 70, "Output",
 Evaluatable->False,
 CellID->96411842]
}, Open  ]],
Cell[655246, 15317, 125, 3, 70, "ExampleDelimiter",
 CellID->402920390],
Cell[655374, 15322, 220, 8, 70, "ExampleText",
 CellID->34695851],
Cell[CellGroupData[{
Cell[655619, 15334, 839, 25, 70, "Input",
 CellID->557810802],
Cell[656461, 15361, 5748, 98, 70, "Output",
 Evaluatable->False,
 CellID->8047162]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[662258, 15465, 226, 7, 70, "ExampleSection",
 CellID->23685],
Cell[662487, 15474, 98, 1, 70, "ExampleText",
 CellID->1347617723],
Cell[CellGroupData[{
Cell[662610, 15479, 388, 12, 70, "Input",
 CellID->2048529199],
Cell[663001, 15493, 1362, 30, 129, "Output",
 CellID->6983746]
}, Open  ]],
Cell[664378, 15526, 84, 1, 70, "ExampleText",
 CellID->169496643],
Cell[CellGroupData[{
Cell[664487, 15531, 386, 12, 70, "Input",
 CellID->26526337],
Cell[664876, 15545, 1971, 40, 128, "Output",
 CellID->79430508]
}, Open  ]],
Cell[666862, 15588, 125, 3, 70, "ExampleDelimiter",
 CellID->567261646],
Cell[666990, 15593, 90, 1, 70, "ExampleText",
 CellID->1286575289],
Cell[667083, 15596, 479, 17, 70, "Input",
 CellID->458040580],
Cell[CellGroupData[{
Cell[667587, 15617, 112, 3, 70, "Input",
 CellID->1706637212],
Cell[667702, 15622, 2714, 54, 129, "Output",
 CellID->144177934]
}, Open  ]],
Cell[670431, 15679, 85, 1, 70, "ExampleText",
 CellID->176659333],
Cell[CellGroupData[{
Cell[670541, 15684, 143, 4, 70, "Input",
 CellID->1660032752],
Cell[670687, 15690, 2489, 45, 70, "Output",
 Evaluatable->False,
 CellID->22244324]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[673237, 15742, 311, 9, 70, "SeeAlsoSection",
 CellID->11426],
Cell[673551, 15753, 1171, 44, 70, "SeeAlso",
 CellID->2323]
}, Open  ]],
Cell[CellGroupData[{
Cell[674759, 15802, 305, 8, 70, "RelatedLinksSection"],
Cell[675067, 15812, 369, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[675473, 15829, 319, 9, 70, "MoreAboutSection",
 CellID->604983327],
Cell[675795, 15840, 147, 3, 70, "MoreAbout",
 CellID->357933927],
Cell[675945, 15845, 164, 3, 70, "MoreAbout",
 CellID->4090893],
Cell[676112, 15850, 177, 3, 70, "MoreAbout",
 CellID->7286820]
}, Open  ]],
Cell[676304, 15856, 27, 0, 70, "History"],
Cell[676334, 15858, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

