(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31392,        886]
NotebookOptionsPosition[     27196,        750]
NotebookOutlinePosition[     28713,        790]
CellTagsIndexPosition[     28628,        785]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Some Special Plots" :> 
          Documentation`HelpLookup["paclet:tutorial/SomeSpecialPlots"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Some Special Plots\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LogLinearPlot" :> 
          Documentation`HelpLookup["paclet:ref/LogLinearPlot"], "ListPlot" :> 
          Documentation`HelpLookup["paclet:ref/ListPlot"], "ListLogLogPlot" :> 
          Documentation`HelpLookup["paclet:ref/ListLogLogPlot"], 
          "ListLogPlot" :> 
          Documentation`HelpLookup["paclet:ref/ListLogPlot"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"LogLinearPlot\"\>", 
       2->"\<\"ListPlot\"\>", 3->"\<\"ListLogLogPlot\"\>", 
       4->"\<\"ListLogPlot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DataVisualization"], 
          "New in 6.0: Data Visualization" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataVisualization"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Data Visualization\"\>", 
       2->"\<\"New in 6.0: Data Visualization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ListLogLinearPlot", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListLogLinearPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListLogLinearPlot"], "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["1", "TR"]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["2", "TR"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["2", "TR"]]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]makes a log-linear plot of the specified list of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " values."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListLogLinearPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListLogLinearPlot"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["list", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["list", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]plots several lists of values."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListLogLinearPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListLogLinearPlot"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " by default plots each value as a separate point."
}], "Notes",
 CellID->35506798],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListLogLinearPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListLogLinearPlot"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{
     ButtonBox["Joined",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Joined"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}]}], "]"}]], "InlineFormula"],
 " draws a line through the list of values. "
}], "Notes",
 CellID->721546604],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListLogLinearPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLogLinearPlot"]], "InlineFormula"],
 " effectively plots ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["y", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " against ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Log",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Log"], "[", 
   SubscriptBox[
    StyleBox["x", "TI"], 
    StyleBox["i", "TI"]], "]"}]], "InlineFormula"],
 ", but with tick marks indicating the underlying values ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "Notes",
 CellID->590143150],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListLogLinearPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLogLinearPlot"]], "InlineFormula"],
 " makes logarithmic variations appear as straight lines."
}], "Notes",
 CellID->52897017],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListLogLinearPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLogLinearPlot"]], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->312555850]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->179592327],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->132791201],

Cell[TextData[{
 "Make a plot with a logarithmic ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " scale:"
}], "ExampleText",
 CellID->177389336],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogLinearPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"n", ",", 
      RowBox[{"Sqrt", "[", "n", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1698521587],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WFdPFFEYHbaBhaIuYkUE24Mttthhg73HRoixLESFqKCIxhLFGo2KsTd8
UIP6oG8aTXz1RR+Mrz77R8bb5843Z2Z3bSTM3e/O+c75vnPvnc3O+mx3295D
2e721mzNyq7s4bb21qM1Kzq72FS8yHGc9+z/xAiHfXbZJ/H/3nXZGLzWsmuC
AUazMc7GtBpjbIyxsULd13GVuh9XcTnBx63Rcer4ld8WkeNUWzH/OJRfEl4s
eWxEGb8kDYPioagqokPvl0bq6AxuXREfxdwEwjG24NrLcyL+Rd0TCceYguuu
yFHV/6h6lCv3UeUfV1upmGIBpuj1wXXWBnKov+mcFQt/UjYC40TvSRP/Rbfr
lCfVahzm+k/vEBKPtDzUp56edu/U28+XUlJtv5gdLGZf9n9nN3pvfHZeitmB
7PqKzSQszNcvP9nMxw8/nOGEifpemSOm5zdN4hSsl7L8H9V+OJvWrtUvecxd
641ANW17xVDLG59aKHOeuKudHe+4q5ijlij1CFTSld8FCYj2FCU6ZaGc0Cyv
EplVTFBxEk8llR0TWSUExfcpD6eSysLRQQ2vsgTR7DBu+M8d7XA2Ue8wvvCV
SEK0p9oBV2YhqWW/b3UXEcX9ERyeUoxwtsCsesIdhQrn3gmzlhHuCFSx4WaR
x9vs82E14WuGfKv4JWX4DNl2iF4r1A2nT31zRIZdr1cRztgYUtFGX3dbeJSU
XI0NfaqG9ZBR6CQl44Z1z5U6xm4NUV/j5nMym2BVqwrIpVXK3LCnTrOV03Pm
k9JbYXLsZw+PebhDdGhWwXTY6EadTJFVYnwhLWYic3fBzjJ5ubKHXxIst7np
tdRqgOuWhc4v9e2ZFmsvyjo85GLI2up6J5llODGGduIMr+4vgFl79R5ibdoi
GL0vh8Y8mNWmfZEa7Dof4trhDvE4uS8HBZf0TgLmQq4DmktqKq45EHswxINZ
EH0ohwczYFYnrGemr7cjEIP5MHY6xHZB7LTIc3AU5ohv2jy+Sbu1RzI74NGU
CB5OcyxH/uQ86ziueVr2vGnM9AV4JhmeOPDgBPRgsvHNxlLlkzBX6hUrz2nO
KZgzEa7p6QB298438jew2U9nNKZhyROPrw7ySeyL598allrYWog9C+scD7E9
EFsDsec0Vp5AhR3n6+mCwGza8EICFKYa8p3XfGz1M/W8rUx9Xwj2IuQdE4G1
e+K8GHvJ9JSxehoNsZfhmo7y9X8FrulIyHcFrukIiL0K+68yex09I65Cf2VO
7rN5TSCMImt1eEQmT7wGe6+MrPE69CCdZ403/DWy9grK9K07X8thkbX2Bvrj
OUPhet3UffnWa4hvr9yCvVdAvluBTiNwgb7KIfY2XK8yiL0j9Neufmb0y3y9
3IW6pZDrbkCXYwdD7D2ha/uIcff99THCQeG4gPZAiH0Q0PZwvOdHAc0BkOch
9LnE2pj6T78PojuPKLH9IrOD7+Dob28aP9K1mJ54/8W/yfYY7vJUAWw8fKJ9
lueAPV0LYbDjPhF7v5Z/l0e+L1Kv38SffiP3VkwF3/s7Rb8An4Jofw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->263129519]
}, Open  ]],

Cell["Join the points with a line:", "ExampleText",
 CellID->13696603],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogLinearPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n", ",", 
       RowBox[{"Sqrt", "[", "n", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "100"}], "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->418056392],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->405543505]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1015258886],

Cell["Show multiple sets of data on a scale:", "ExampleText",
 CellID->1659689418],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogLinearPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n", ",", 
       RowBox[{"n", "^", "k"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "0.5"}], ",", "0.5", ",", "1"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "1", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->263694797],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNmg1sVtUZx6/vfd++FKgf+4gSNsHhHIIfc37Mj1W+dUy0YwNZ+IhrGVqY
FsGKUja+bYmrQiBzVLqyQMG0MnkdrIrrJmkHaZeGLk2JpJAxGljZQkNWZFkn
Sfc7z7n39n6ct31j4jJye95zzj3nef7P//mf59635fH84sJFz+UXL16YP/rR
5fnPFy5e+MLoR5YuZ8q+yrKsg/yU3GDR76MnPwf7+viMtqNobRbE1Eh1ZJYx
P9n046F7qqvuXefssw33Rgxw7+rwnGFNjg9TLI0dmbNGh+5khcbJUFRx9Rnv
v29ZnzfhCawYOeiKnNCKqJecyEwkbvOKQSMcEhrbn0mE4axFvXx2EWYPakdp
UWki8X8eWdzBOXzQ/Z8bFNWItDH/ryOKqDGw79OcuBEmL4EVwzPw8+mjHOVw
m3Q+s53PLOfTrX3ueKQvF26Ns33jnL7+Oua3o2uYvxqHT3PNALPKeo1jLbom
zGE49nDNCq+/KTQeasp05NT29l5pPXaOy8pWTaK5qXNnVYu+LIfJwbGG1W/E
1p83/mUpb/a7qeOOq7hq7FUlh5YWHeCy4qpRFibkVnBZWaqxp02pdO5nqybx
YnFdGrQqW/NDEcbE53t1J5wNdsinTaP8ZMngtfLGALbGhtOOnbjY6e6+7EQ3
2sjRd0zeE3uqWz3E69bWi08rsWBejY6Tixid6MtKDweQ9iOwaW4T++fb/3ru
2EkuK64a+0LHWcd/0ojqYcmEh4p0xyTEiu3NmoXFhalYiOuYYGSFh/z39acE
g2WfOXPRsTwmhMeW5njqSEvV+1xWXDX2oZKqA0U/57LiqrH3zt5QkbuMCwg0
dqpwS+D+0a2pSDwqt3dnGkfciwOx6DXkQO863n5+FHYSgrSt9rCDNCZIG8vf
dpDY0uzOW+0gtUNI9X3WByI93dAWyExPV7cTyReNmRknhxJUpBmYJD/zKK4X
W1d6P3E8xlST8Ljnat5+0GF0X0G5L46Ey3IgdnYGsni5u8dBeacRu+Q+52TH
BV0+ODognZm3G+h0OGFMcu40WHmeiN1EZ9NHUYQJj2muyikvOrMev1yt1fUR
vU8L6OPLggh14hPn27YeBcic2XtBtLBgn64bVB/uco51rUxgS0fNpTzYksy6
4gqdZy6lUcl2glkDmn6e5hh5kszndHX14Pft2jYtVn34aemDinnussZ5Qnqo
EGgsiGjn9BLRYoKcehgVjxo57HrxLDHikTePHBjAo67FMAM/4IEr8MCb1llH
21mtqvip+mM67MOlb8XkoHr5Aoae8fQEBNll9176l+Pzpb7+x7/7z33PEnxX
61Ot67SuzuBBTSvzd215+Z1frv/NuxtqPyjfT6Dam6dogOiZ+rW7tP8Tdc2x
UGY2iOPw01We7Nf6n1D6JFZt/kPZ0ho8L5m0aenEso1Pbt0269UdT26qfuq1
NycVx3CqPXp6QAyxkDI3p/c4lPGKVQs2LSzYMvOZihnPYO/NGWt2LSh/q+D1
xs37db69SsIBr0xrSw2tIXMq575cNb9s8+Sd26YfqCmq+3Vxy5Gq1ubq2LnO
YzvT4xjmjdvPd2xv3luwb8WsPYvXvVf2TlN10x8rmxu2WzHMxSrKc61kak8h
feYwffpkA5Z7/33JeiOt9Zib7mRXzz9Sxz8oOfSzKZXziutK6TOj91xz/m/t
WAIqVg+lSvBACPirqZpH//D7pcyfaK9jzcXuM9brWj52v4oSIc/yvMhq6mwt
b9wxe++P59Us23r0Vwxl/hpsYAl7WMU2HvCDt92/yKOPf00ba8BllRpPj1SN
5JmLZ2vbfks003fmr63fUnfiw+7LF61hcu/yx91YgCOswReW4c5SLAqbzFp2
51+aHAZ/GqhgcjaTl3o/rj91pPTwG3m7nyYppKbjwmn9/YldYmEoSfbY2rer
QOfm+J9T2uwKI/brxDq2qlv3Yxfr+MAT/nSVSlz4e4fOR+PvyjFpxXBgJegx
1sz0/LPLet5o/QtiHR5gA05gpujAOliCK+sGdW84wLAASE3L3h2zAU+n/uBa
YoIT3C8J8CHvlFk8QUgjySSlJLbh9J++JPrF2KmP6tkKGXCgmdDq16KxfmRE
OjKiS1pHlzcKUoAAx5OJpxGAt7XUao4XGG3L/mTvlf+A0i9Cjph+Ix6m9QGb
Rz/cqlMIERo1olH8/kAsx301coxPdYWpVQHVyb2h7NOIkTH2KrdM0XAhAjF/
P1B/fQMf8q9GtIcnlKK0J/eGXfmkVyOHFTQNK7T0tTK4az2evtr4xrdKVr2i
o3XIKR0rkQAX0FoihEEw+mQSHqx/WzxEftfk1EJ5P05oDXI6MU4arPFqNhuG
9KGEa006uiOb6qxPTWvVP5b3oDh8IBdt+g7XMjoknR4p9JlRNWuCQ3bkW7DP
7l0RuzKTDTLwgZIyBWKtEU2D9aCxFiqt3BOxJu/N2ezSCtHxY5NDDdNKcfcZ
tXxvxJKsG0JcHGISD4ecC4/GbwTO7v2R3TKTjf49trRMweTo53YjjgciliT6
IVqP7NZKwR6qYWac0cpDESu5oniAI2B9yqGGvlLELYFYHo7slbwmIRSXOIZQ
VAoNKudfMfqfELExUaIgL+gSPsgIhEIr9DB5o9HKpIiVyYKELJJLUgES8ECK
imKk1rVPHVMj+6e6LLBHR4IVbJEn6/qMzsW0iE2ZSRIEoRAQIqEywyx1VT8n
BrX5aMSmzCSxAONYwyb6hTmlm2uNp0GZm+6zQ0WgvEkFUU9pNEzOdOaceOX3
LYPWr8dkTMGitNPqb/1JcIBGRwuPaEGdrKEZRTtDUFK3gMjDgseHniErCANV
IM/sSC7zxAqPBAhSVfoJGcO6Y9X82wC9i2eJLu9pvrV8V/wDhBrNQqDNDpwI
eaLY1HA4oNhas4xWZFUc0inwXHS+Z1wntm3sYE09KWcGfM1x2QEIcACVZ7Qi
z02bmFin3jqeCFiZK3fhCbbgLMNn1VyXB9JCcgDxWEb75ps04j3T1UJ5f7Ch
BLNEpZVq+f8OEn67fcqNDyq9MzLg+/APXV7xQQzWI8Ydip0CFy8vbep9cFpG
URa4KmCXenuaaszLQpd5Vqm8TAnkZZHcZTdZUyqebLSxyGWLVYrPScZVT8uY
SDntSpUTA54K3bvwpxQwwWhjsYxJN0lR3VzjqiWhXHyrL3w6nw1x/1BfJpXg
2VAeHsxo13O+PKhdD6TdpYZFvnyo1fcPqqOlLip4VbF8M7BDtW7Uy2Qlr5C8
oKrufZ6OvG+EPrt6NbmAbtW918j1chmTDuhW3XsCWS2Wu6QBqlX3bqONF3zK
UPoxryp2VzlaDL7RrHA1SAVRar/LaEOv0npW7+dfN656KZSDO405UF5Xhri/
Qy8Z8I1yZSgLt2ewpySUi9vS7FFbVvU5Z4Tlqju+z69+v9VVLqPEqSr7eKNy
/Dt+4vIHy4qZcREFqc/VsorXAlhR3VuNLK8O4RwbyOeaELaxRhtrQni+Zly1
1s0Sp111g++P69VnVUvtLca962UMCL7oqu7NA6xCUeBQurrZyKTytlFWYgyT
qjtmUM43OvjGeFwPVPVfCeG9Ke0uNXzFh1vpN/1q/1hIVGfNGY9Oo8boX9yC
v2VMySD6Pyqsq/4LZsDxqQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->536932306]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->307205976],

Cell["Generate filled plots:", "ExampleText",
 CellID->660151244],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogLinearPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n", ",", 
       RowBox[{"Sqrt", "[", "n", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "1", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Bottom"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1261437506],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXDlvFEkUbmbGY3NY5kjIbH4EZIiAK0IgLTZHxAghTGAb2WghAAkkdjmX
1S4IyeI0YEQMCFKOhEuQQkACAQGLBEiWEAj11qvqqnr9qvpg6Gb6Gml6uqqr
3vveV6/u6lnX2jO8Y6S1Z9f21sDa8dbu4V3bJwbWjI2zqPosx3Fus+/vix12
77I7/r3tuuzXvPaza50lqEEIbngsC7Nvg903yDO4hWdzvHx1y7O+kGfdNM6S
pokw1QLkyDQcpCM/NGVXhBQe5wyQJ80QjEplQz93nHm2HL4UCyJTUK2mlqYR
Y7AXKdVgAS49OAe+RsuvxWKQaq2nwiD1LVNLagwSvzKlmKUZj7lGJD6oiaCz
K1+MJe5zDY8Hawvjyz830uq+QE5TZEzHYO2p8BRuQTvtW59Niy+FyWWCLVwX
5s6RsT2KrDa563e1T8keUfY+uBeU4QWo5GS+OgrLdHUSbhL5kL5hSSf6K9x/
zyeWTPFYURrT116wB3+dfOhc4bG97DolufHSPH70hsXcvfPSWUQkiVry6dMX
j7WF8vl/72fgVvjE2zcfZ2a+crJ5mAW89KKmvH794du377yIZH4vLFoFFmBJ
lMfUX718j8sE0jMIKtxU+tiH3bCgiFdy/PGQ38NXY7i5UUzeu3ef8Q27ekrY
Z7aV14VuxY6fHfDHJZIFkZKzAJJ6g6xnUcHW63A86zWw9qzX+OJYz7QH+MZA
xUKpWahqQuUDlQ9UPmCycPHC0xXLJ2EEVg4W/KsxtjUlORIWdWXwt2nGz+qV
50vCD513hK00aS9iY/TRkZswRq9YsrG0tGLFQwPBcrKBZ86Vb9A1HhouByve
cgn/0BWcZaVggI5KylHucjy+jEs5N/nEG4MFrskUxmpa1niEVUbr2chpbPQW
jJyKbz14/OrCW4nLeFVlbWGsDTpnIOeLxfZsOW9GAXOnDDGzkoenr71gbfux
o/eFlMKwQf0gYIfS4GPT4HWvrysWH9b9c4MPSCB40OsFZeQBp1hfKPujds/l
3GZDsaxGszi5D05n+cUqZ9rzF8867aWXLz3zZmf5t8oss6GNskcqonV6dpV/
68Ajt+beClxGW3JvTf7LhM5q8C4YLqvNPCzG8yeOP/DW9vNipX/2EnXCW9iq
x+r5sjXuLoywUreQ+bLSOEcfUaatXFsnT1lSK/NlleW0rWV/TNikW5pGtm0K
2MHBlm1z/e1Jti2ivbRAr9uJ7KOHMhjOPErM8c7Mo9WcXr3y3JsPZQ+lySmt
ddlGS2tZVtAGvSsn177HsoWWIoVL6CrcaM7xj/Cw6DOhZtY7ih/3ifZ3agC6
wKzrZ2cx//iKvsCva2xn8f+4z0x0Fi9ZK4XfCeTFR/68J2zqWIs8bvPPX97n
TkgvGx3RXtYxTvaVTDuUwD7klbCTKbSptW72EZp5fDeOT8ruvcQTO4VAt3Xp
I6AjDrwuBb8H0kdAOIhaYdjPEandgswgUn6TAiLc0/dY0EBQoFC+kwIKanfQ
SduDHImav7jprdXY0Bzi2tV+S1LaQ9YdDkrmxV57Qhpp23A4sXKULe4fXCKu
ScliHdo4rcogWcnYy3+WhWOJltIR7oqqF3PFKduflYfbljbqrPFOfM31jwiP
ci2Y1bRH9Sfg0qtO5MbS0nCCzjqAYCFRnXKN2a7qXi/gXwkMzGqMmNAcDWs4
BZc54YLjyoVy/ZvLU++ehciL27YLhMofQyRSTxY5lY9F5ATd/0KoW6GPUVv+
cX3tTuwcClVIO3EGQl1q1hQq9TRPi2stqStNUiNd/79DCF24Prb/TtRZHtZr
Fnz8wN0lan9O5NTj4R6X1pmgsYjIqcexMqf22aDzO1PWlDjFDSsLkjnx1Px3
K2fW/zJzTZc=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->388130958]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"PartitionsQ", "[", "n", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "50"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Bottom"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->902097741],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->216413410]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LogLinearPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LogLinearPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListLogLogPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListLogLogPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListLogPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListLogPlot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Some Special Plots",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SomeSpecialPlots"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataVisualization"]], "MoreAbout",
 CellID->829497222],

Cell[TextData[ButtonBox["New in 6.0: Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataVisualization"]], "MoreAbout",
 CellID->336985162]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ListLogLinearPlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 56, 36.5830972}", "context" -> "System`", 
    "keywords" -> {
     "loglinear", "log-linear plot", "log-normal plot", "semi-logarithmic", 
      "semi log plot", "Bode plot", "frequency plot", "LogListLinearPlot"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ListLogLinearPlot[{{x_1, y_1}, {x_2, y_2}, ...}] makes a log-linear plot \
of the specified list of x and y values. ListLogLinearPlot[{list_1, list_2, \
...}] plots several lists of values.", "synonyms" -> {"list log linear plot"},
     "title" -> "ListLogLinearPlot", "type" -> "Symbol", "uri" -> 
    "ref/ListLogLinearPlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8887, 282, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->179592327]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28485, 778}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2256, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2879, 81, 1582, 37, 70, "ObjectNameGrid"],
Cell[4464, 120, 1789, 56, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6290, 181, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6768, 198, 291, 9, 70, "Notes",
 CellID->35506798],
Cell[7062, 209, 504, 17, 70, "Notes",
 CellID->721546604],
Cell[7569, 228, 693, 26, 70, "Notes",
 CellID->590143150],
Cell[8265, 256, 243, 7, 70, "Notes",
 CellID->52897017],
Cell[8511, 265, 339, 12, 70, "Notes",
 CellID->312555850]
}, Closed]],
Cell[CellGroupData[{
Cell[8887, 282, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->179592327],
Cell[CellGroupData[{
Cell[9272, 296, 148, 5, 70, "ExampleSection",
 CellID->132791201],
Cell[9423, 303, 158, 6, 70, "ExampleText",
 CellID->177389336],
Cell[CellGroupData[{
Cell[9606, 313, 309, 10, 28, "Input",
 CellID->1698521587],
Cell[9918, 325, 1794, 33, 141, "Output",
 Evaluatable->False,
 CellID->263129519]
}, Open  ]],
Cell[11727, 361, 70, 1, 70, "ExampleText",
 CellID->13696603],
Cell[CellGroupData[{
Cell[11822, 366, 376, 12, 28, "Input",
 CellID->418056392],
Cell[12201, 380, 2295, 42, 141, "Output",
 Evaluatable->False,
 CellID->405543505]
}, Open  ]],
Cell[14511, 425, 126, 3, 70, "ExampleDelimiter",
 CellID->1015258886],
Cell[14640, 430, 82, 1, 70, "ExampleText",
 CellID->1659689418],
Cell[CellGroupData[{
Cell[14747, 435, 571, 18, 28, "Input",
 CellID->263694797],
Cell[15321, 455, 3897, 68, 143, "Output",
 Evaluatable->False,
 CellID->536932306]
}, Open  ]],
Cell[19233, 526, 125, 3, 70, "ExampleDelimiter",
 CellID->307205976],
Cell[19361, 531, 65, 1, 70, "ExampleText",
 CellID->660151244],
Cell[CellGroupData[{
Cell[19451, 536, 389, 12, 28, "Input",
 CellID->1261437506],
Cell[19843, 550, 2116, 39, 139, "Output",
 Evaluatable->False,
 CellID->388130958]
}, Open  ]],
Cell[CellGroupData[{
Cell[21996, 594, 372, 11, 28, "Input",
 CellID->902097741],
Cell[22371, 607, 2238, 41, 137, "Output",
 Evaluatable->False,
 CellID->216413410]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24670, 655, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[24989, 666, 973, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[25999, 706, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[26320, 717, 149, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[26506, 725, 299, 8, 70, "MoreAboutSection"],
Cell[26808, 735, 147, 3, 70, "MoreAbout",
 CellID->829497222],
Cell[26958, 740, 166, 3, 70, "MoreAbout",
 CellID->336985162]
}, Open  ]],
Cell[27139, 746, 27, 0, 70, "History"],
Cell[27169, 748, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

