(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   3813928,      68220]
NotebookOptionsPosition[   3761620,      66464]
NotebookOutlinePosition[   3763548,      66510]
CellTagsIndexPosition[   3763459,      66505]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Plotting Lists of Data" :> 
          Documentation`HelpLookup["paclet:tutorial/PlottingListsOfData"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Plotting Lists of Data\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ListPointPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/ListPointPlot3D"], 
          "ListSurfacePlot3D" :> 
          Documentation`HelpLookup["paclet:ref/ListSurfacePlot3D"], "Plot3D" :> 
          Documentation`HelpLookup["paclet:ref/Plot3D"], "ListDensityPlot" :> 
          Documentation`HelpLookup["paclet:ref/ListDensityPlot"], 
          "ListContourPlot" :> 
          Documentation`HelpLookup["paclet:ref/ListContourPlot"], 
          "ListContourPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/ListContourPlot3D"], 
          "ListLinePlot" :> 
          Documentation`HelpLookup["paclet:ref/ListLinePlot"], "ReliefPlot" :> 
          Documentation`HelpLookup["paclet:ref/ReliefPlot"], "ArrayPlot" :> 
          Documentation`HelpLookup["paclet:ref/ArrayPlot"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ListPointPlot3D\"\>", 
       2->"\<\"ListSurfacePlot3D\"\>", 3->"\<\"Plot3D\"\>", 
       4->"\<\"ListDensityPlot\"\>", 5->"\<\"ListContourPlot\"\>", 
       6->"\<\"ListContourPlot3D\"\>", 7->"\<\"ListLinePlot\"\>", 
       8->"\<\"ReliefPlot\"\>", 9->"\<\"ArrayPlot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DataVisualization"], 
          "Numerical Data" :> 
          Documentation`HelpLookup["paclet:guide/NumericalData"], 
          "New in 6.0: Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60DataVisualization"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Data Visualization\"\>", 
       2->"\<\"Numerical Data\"\>", 
       3->"\<\"New in 6.0: Data Visualization\"\>", 
       4->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ListPlot3D", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListPlot3D",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListPlot3D"], "[", 
       StyleBox["array", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a three\[Hyphen]dimensional plot of a surface \
representing an array of height values. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListPlot3D",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListPlot3D"], "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["z", "TI"], 
            StyleBox["1", "TR"]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["2", "TR"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["2", "TR"]], ",", 
           SubscriptBox[
            StyleBox["z", "TI"], 
            StyleBox["2", "TR"]]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a plot of the surface with heights ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at positions ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["i", "TI"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["i", "TI"]]}], "}"}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListPlot3D",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListPlot3D"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["data", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["data", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]plots the surfaces corresponding to each of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["data", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->12121]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot3D"]], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 ", with the following additions and changes: "
}], "Notes",
 CellID->29012],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Axes",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Axes"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to draw axes ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["BoundaryStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BoundaryStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to draw boundary lines for surfaces ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BoxRatios",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BoxRatios"], 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "0.4"}], "}"}], Cell[
    "bounding 3D box ratios ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["ClippingStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ClippingStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to draw clipped parts of the surface ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["ColorFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to determine the color of surfaces ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["ColorFunctionScaling",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunctionScaling"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[{
     "whether to scale arguments to ",
     Cell[BoxData[
      ButtonBox["ColorFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["DataRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DataRange"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "the range of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " values to assume for data "
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["Filling",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Filling"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "filling under the surface ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["FillingStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FillingStyle"], 
    RowBox[{
     ButtonBox["Opacity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Opacity"], "[", "0.5", "]"}], Cell[
    "style to use for filling ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["InterpolationOrder",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/InterpolationOrder"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["\<\
the polynomial degree in each variable of surfaces used in joining data \
points\
\>", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["MaxPlotPoints",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MaxPlotPoints"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the maximum number of points to include ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["Mesh",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Mesh"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how many mesh lines in each direction to draw ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["MeshFunctions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MeshFunctions"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"#1", "&"}], ",", 
      RowBox[{"#2", "&"}]}], "}"}], Cell[
    "how to determine the placement of mesh lines ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["MeshShading",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MeshShading"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "how to shade regions between mesh lines ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["MeshStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MeshStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the style for mesh lines ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the method to use for interpolation and data reduction ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["NormalsFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NormalsFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to determine effective surface normals", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["PerformanceGoal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PerformanceGoal"], 
    ButtonBox["$PerformanceGoal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$PerformanceGoal"], Cell[
    "aspects of performance to try to optimize", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["PlotRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRange"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Full",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Full"], ",", 
      ButtonBox["Full",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Full"], ",", 
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"]}], "}"}], Cell[TextData[{
     "the range of ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     " or other values to include "
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["PlotRangePadding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRangePadding"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how much to pad the range of values ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["PlotStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "graphics directives to specify the style for the surface ", 
     "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["RegionFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/RegionFunction"], 
    RowBox[{"(", 
     RowBox[{
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"], "&"}], ")"}], Cell[
    "how to determine whether a point should be included ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["VertexColors",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/VertexColors"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "colors to assume at each point ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["VertexNormals",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/VertexNormals"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "effective normals to assume at each point ", "TableText"]}
  },
  GridBoxAlignment->{"Columns" -> {Left, Left, {Left}}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {
      Dynamic[
       If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
        RGBColor[0.92, 1, 0.59], None]]}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True, True, True, True, True, 
      True}}}},
 CellID->22939],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPlot3D"], "[", 
   StyleBox["array", "TI"], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["array", "TI"]], "InlineFormula"],
 " must be a rectangular array. Each element can be either a single real \
number representing a ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " value, or an ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], TraditionalForm]], 
  "InlineMath"],
 " triple. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->139640668],

Cell["\<\
There will be holes in the surface corresponding to array elements that do \
not represent explicit height values. \
\>", "Notes",
 CellID->3472],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPlot3D"], "[", 
   StyleBox["array", "TI"], "]"}]], "InlineFormula"],
 " by default takes the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " coordinate values for each data point to be successive integers starting \
at 1. "
}], "Notes",
 CellID->1283],

Cell[TextData[{
 "The elements of ",
 Cell[BoxData[
  StyleBox["array", "TI"]], "InlineFormula"],
 " can also be triples ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["11", "TR"]], ",", 
    SubscriptBox[
     StyleBox["y", "TI"], 
     StyleBox["11", "TR"]], ",", 
    SubscriptBox[
     StyleBox["z", "TI"], 
     StyleBox["11", "TR"]]}], "}"}]], "InlineFormula"],
 ", specifying heights ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["z", "TI"], 
   StyleBox["ij", "TI"]]], "InlineFormula"],
 " at explicit positions ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["ij", "TI"]], ",", 
    SubscriptBox[
     StyleBox["y", "TI"], 
     StyleBox["ij", "TI"]]}], "}"}]], "InlineFormula"],
 ". The connectivity of the surface in this case is still taken to follow the \
2D array. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->51877402],

Cell[TextData[{
 "In the default case with no explicit ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " given, the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DataRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DataRange"], "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["min", "TI"]], ",", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["max", "TI"]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["min", "TI"]], ",", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["max", "TI"]]}], "}"}]}], "}"}]}]], "InlineFormula"],
 " specifies the ranges of coordinate values to use. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->6057],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DataRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DataRange"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPlot3D"], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["11", "TR"]], ",", 
       SubscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["12", "TR"]], ",", 
       SubscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["13", "TR"]]}], "}"}], ",", 
     StyleBox["\[Ellipsis]", "TR"], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["n1", "TI"]], ",", 
       SubscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["n2", "TI"]], ",", 
       SubscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["n3", "TI"]]}], "}"}]}], "}"}], "]"}]], "InlineFormula"],
 " will assume that the data being given is ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["1", "TR"]]}], "}"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 ", rather than an ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "\[Times]3 array of height values. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->7142],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPlot3D"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{
     ButtonBox["DataRange",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DataRange"], "->", 
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"]}]}], "]"}]], "InlineFormula"],
 " always takes ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " to represent an array of height values. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->9487],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPlot3D"], "[", 
   StyleBox["array", "TI"], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mesh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mesh"], "->", 
   ButtonBox["Full",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Full"]}]], "InlineFormula"],
 " draws a mesh that crosses at the position of each data point."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->364162425],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["array", "TI"]], "InlineFormula"],
 " can be a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " object. "
}], "Notes",
 CellID->10404],

Cell[TextData[{
 "The arguments supplied to functions in ",
 Cell[BoxData[
  ButtonBox["MeshFunctions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshFunctions"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RegionFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionFunction"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 ". Functions in ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " are by default supplied with scaled versions of these arguments. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->24233],

Cell[TextData[{
 "The setting for ",
 Cell[BoxData[
  ButtonBox["VertexColors",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexColors"]], "InlineFormula"],
 " must be an array or list with the same structure as the coordinate data. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->24702],

Cell[TextData[{
 "An explicit setting for ",
 Cell[BoxData[
  ButtonBox["VertexColors",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexColors"]], "InlineFormula"],
 " overrides colors determined from ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->31937],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot3D"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics3D"], "[", 
   RowBox[{
    ButtonBox["GraphicsComplex",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GraphicsComplex"], "[", 
    StyleBox["data", "TI"], "]"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23139]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->243561783],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->50874401],

Cell["Use an array of values to define heights for a surface:", "ExampleText",
 CellID->26734],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "3", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "1", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21267],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[{{1., 1., 1.}, {2., 1., 1.}, {3., 1., 1.}, {4., 1., 
   1.}, {1., 2., 1.}, {2., 2., 2.}, {3., 2., 1.}, {4., 2., 2.}, {1., 3., 
   1.}, {2., 3., 1.}, {3., 3., 3.}, {4., 3., 1.}, {1., 4., 1.}, {2., 4., 
   2.}, {3., 4., 1.}, {4., 4., 4.}}, {
    {EdgeForm[GrayLevel[0.]], 
     GraphicsGroup3DBox[
      Polygon3DBox[{{1, 2, 6, 5}, {2, 3, 7, 6}, {3, 4, 8, 7}, {5, 6, 10, 9}, {
       6, 7, 11, 10}, {7, 8, 12, 11}, {9, 10, 14, 13}, {10, 11, 15, 14}, {11, 
       12, 16, 15}}]]}, {}, {}, {}},
   VertexNormals->{{0., 0., 1.}, {0., -0.7071067811865475, 
    0.7071067811865475}, {0., 0., 1.}, {0., -0.7071067811865475, 
    0.7071067811865475}, {-0.7071067811865475, 0., 0.7071067811865475}, {0., 
    0., 1.}, {-4.387470414374264*^-18, -0.3162277660168379, 
    0.9486832980505138}, {-0.7071067811865475, 0., 0.7071067811865475}, {0., 
    0., 1.}, {-0.31622776601683794`, 0., 0.9486832980505138}, {
    1.0418505251227894`*^-17, -1.0418505251227894`*^-17, 1.}, {
    0.8846517369293828, 0.14744195615489714`, 
    0.4423258684646914}, {-0.7071067811865475, 0., 0.7071067811865475}, {
    0., -0.7071067811865475, 0.7071067811865475}, {0.14744195615489716`, 
    0.8846517369293829, 
    0.44232586846469146`}, {-0.6882472016116853, -0.6882472016116853, 
    0.22941573387056177`}}],
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{1., 4.}, {1., 4.}, {1., 4.}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 153},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->729313703,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30905],

Cell[TextData[{
 "Give explicit ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], TraditionalForm]], 
  "InlineMath"],
 " coordinates for points on a surface:"
}], "ExampleText",
 CellID->387502584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12269],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[{{0., 0., 1.}, {1., 0., 0.}, {0., 1., 0.}}, {
    {EdgeForm[GrayLevel[0.]], 
     GraphicsGroup3DBox[Polygon3DBox[{{1, 2, 3}}]]}, {}, {}, {}},
   VertexNormals->{{0.5773502691896258, 0.5773502691896258, 
    0.5773502691896258}, {0.5773502691896258, 0.5773502691896258, 
    0.5773502691896258}, {0.5773502691896258, 0.5773502691896258, 
    0.5773502691896258}}],
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{0., 1.}, {0., 1.}, {0., 1.}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->373377079,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->511253499],

Cell["Use different interpolations of data: ", "ExampleText",
 CellID->917728],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "Pi", ",", 
       RowBox[{"Pi", "/", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "Pi", ",", 
       RowBox[{"Pi", "/", "5"}]}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1029436505],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{"data", ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"InterpolationOrder", "\[Rule]", "0"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<SouthwestColors\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->144633011],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJyN1M8rRFEUwPEbyi3iai7edsxG4h+w8RYWouTXFKYkTLHABmvFyo8MC2OD
RMqGspkF0yxsFFLGgrBAk181I4pEfmzem945577r1uvWp9d3cc7rebsGm4IZ
jLGevyeTWee5ynnbx3R3+wYdtXe0D2f5jm/gewrnwK2O2n9aqj15g0nUoV0A
tzr/dVXHcqnoqJ2eg8oNxRygp/d46O1/G1g8s+fl7sx0OtN6n/8msdv4hDq0
c+BM62P7oenuRAp1aBfAmdYTdx+Tvtp71KFdAmdan5tpXitcPkId2g3gTOHp
PQa2K/MjPyn7e3V3Zjqda72g5C3q2XlAHdo5cK715Gto/rA6jjq0C+Bc63uj
35uRmtMY7NAugXOtr9bmDgVzHlGHdgM4V3h6jxff5dknC+cxq+vuzHS60Hpk
pDf+GH5CHdo5cKF1FpgarTpPoQ7tArjQev3n9VbD8x3q0C6BC637O5a+6iYO
UId2A7hQeHqPVyfRyxfPiv0fd3dmOl1qnbdFD8Y3blGHdg5can22LNxaGkui
Du0CuNR68XrcV1OEO7RL4FLrne8VfcHUNerQbgCXyH8BBUbwcg==
   "], {{
     {EdgeForm[None], 
      GraphicsGroup3DBox[
       Polygon3DBox[{{1, 2, 3, 4}, {5, 6, 7, 8}, {9, 10, 11, 12}, {13, 14, 15,
         16}, {17, 18, 19, 20}, {21, 22, 23, 24}, {25, 26, 27, 28}, {29, 30, 
        31, 32}, {33, 34, 35, 36}, {37, 38, 39, 40}, {41, 42, 43, 44}, {45, 
        46, 47, 48}, {49, 50, 51, 52}, {53, 54, 55, 56}, {57, 58, 59, 60}, {
        61, 62, 63, 64}, {65, 66, 67, 68}, {69, 70, 71, 72}, {73, 74, 75, 
        76}, {77, 78, 79, 80}, {81, 82, 83, 84}, {85, 86, 87, 88}, {89, 90, 
        91, 92}, {93, 94, 95, 96}, {97, 98, 99, 100}}]]}, {}, {}, {}}, {
     Line3DBox[{2, 1, 4, 3, 2}], Line3DBox[{6, 5, 8, 7, 6}], 
     Line3DBox[{10, 9, 12, 11, 10}], Line3DBox[{14, 13, 16, 15, 14}], 
     Line3DBox[{18, 17, 20, 19, 18}], Line3DBox[{22, 21, 24, 23, 22}], 
     Line3DBox[{26, 25, 28, 27, 26}], Line3DBox[{30, 29, 32, 31, 30}], 
     Line3DBox[{34, 33, 36, 35, 34}], Line3DBox[{38, 37, 40, 39, 38}], 
     Line3DBox[{42, 41, 44, 43, 42}], Line3DBox[{46, 45, 48, 47, 46}], 
     Line3DBox[{50, 49, 52, 51, 50}], Line3DBox[{54, 53, 56, 55, 54}], 
     Line3DBox[{58, 57, 60, 59, 58}], Line3DBox[{62, 61, 64, 63, 62}], 
     Line3DBox[{66, 65, 68, 67, 66}], Line3DBox[{70, 69, 72, 71, 70}], 
     Line3DBox[{74, 73, 76, 75, 74}], Line3DBox[{78, 77, 80, 79, 78}], 
     Line3DBox[{82, 81, 84, 83, 82}], Line3DBox[{86, 85, 88, 87, 86}], 
     Line3DBox[{90, 89, 92, 91, 90}], Line3DBox[{94, 93, 96, 95, 94}], 
     Line3DBox[{98, 97, 100, 99, 98}]}},
   VertexColors->CompressedData["
1:eJzV1NtLk3Ecx/HhIQMbkdZUmpKJjS4iVGoMya/ZjOVKmmisYmKppS0PTWHL
MiUM3KycCBK0llEpaVEMWuaWyjwQgodtzx42V7r5bD4+OxSuZZqt8o/4ddHF
++Z1+bn4JF+sKSgPo9FoZZuFbyb8wpBVsDygxqWr8gwSLu2m+v1FdkDlFSb1
8A3JEqScihGWYiQ443KVIrYZmWOPgwFGuQ04weKsQC8B6w2/H/bJl/8b/9f7
HGrv5bXMUXCwoW3YJ6egMrHgUZwER+ayn4GhmOwFgJ0GtXPeBQoeL3CZRiBz
tXQks/A5DvWkbmN1FwGnj0xFbk/xInNtz5j5zblFOPrkezc9Ygn+VN8Wfyj9
hMw7RCtSw6wHpjprxXVXKOA0CNqKT9qQeWK8ZtBSh4P9/gudJpqArjjW0JzA
i8wJrS4sP8kJCuvLDFmjG/a5mIfvHXAg89Ls6+nK1x7oFDfRz4xRIBd02VcK
rch8QE5rmy0hQdO9JZR+0wl6i17v68OQeb62qTm1cBEieX7hBZEJSnRZKXlV
Y8i8vWmQIx5YgjW8o4qTtQAzylyucJsRmXMNsUkyswMmVLFDEwYT+F28jQeB
cWS+9bxv9ezm771T8a8V2czAUa1bmHsmkbkeZzv6pwkI0ltrdSMmsKkUQUbe
KDIvMZq5+wuWgRVaU063EFCW+T45nGlF5j0/2N+oSg+MRzlanr4iQYJ/bd5g
25G5zY0xymbcoIiQOJh3Sag+1mpxP8OQeUCTX39r2go5oY/H37YSgC8m5NDj
KWSeNspv/BU9B1FOGqacJKC+2nV13ksic3oV39uZQMKdHWlYTdIynEjdm/B5
xIjM/wJs2PV3
    "],
   VertexNormals->CompressedData["
1:eJxTTMoPSmViYGBIAWJmBlzgg/2o+Kj4qPio+Kj4qPio+Kj4qDh54gDGR3hv

    "]],
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  ImageSize->{180., 143.73049906347435`},
  Lighting->"Neutral",
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{1., 6.}, {1., 6.}, {-0.9952695379932663, 0.9999652192542031}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  ViewPoint->{1.7707840316044716`, -1.8538855764607844`, 2.2084909288483097`},
  
  ViewVertical->{0., 0., 1.}]], "Output",
 ImageSize->{184, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->472459865,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{"data", ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"InterpolationOrder", "\[Rule]", "3"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<SouthwestColors\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->41817764],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->459587003]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(16)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30917],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Data",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->22776660],

Cell[TextData[{
 "For regular data consisting of ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " values, the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " data ranges are taken to be integer values: "
}], "ExampleText",
 CellID->5555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"x", " ", "y"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "3", ",", "0.1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "3", ",", "0.1"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->217407891],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8261566]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->67153451],

Cell[TextData[{
 "Provide explicit ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " data ranges by using ",
 Cell[BoxData[
  ButtonBox["DataRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DataRange"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->628844391],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", " ", "y"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "3", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "3", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "3"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25356304],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->364685067]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->227940066],

Cell["Plot multiple sets of regular data: ", "ExampleText",
 CellID->348435932],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"x", " ", "y"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "3", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "3", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Green", ",", "Yellow"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->520649158],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->123059508]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->459665701],

Cell[TextData[{
 "For irregular data consisting of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], TraditionalForm]], 
  "InlineMath"],
 " triples the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " data ranges are inferred from data:"
}], "ExampleText",
 CellID->576980735],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "=", 
        RowBox[{"RandomReal", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]}], ",", 
       RowBox[{"y", "=", 
        RowBox[{"RandomReal", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "-", 
        RowBox[{"y", "^", "2"}]}]}], "}"}], ",", 
     RowBox[{"{", "300", "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150315547],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{"data", ",", 
   RowBox[{"BoxRatios", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->375438938],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJwNl3s80/0bxhd60kHprBJLKpWyIolyL6kUv6LTQ6ERUpRVkkMxUQ8qIcmx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   "], {
    {EdgeForm[GrayLevel[0.]], GraphicsGroup3DBox[Polygon3DBox[CompressedData["

1:eJxNmHm8VlUVhvfHPGhITCLIPF2kBI2gyNBIEsUoJAdEuYKJZoGAiqghKYqC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       "]]]}, {}, {}, {}},
   VertexNormals->CompressedData["
1:eJwNl3cglX0YhkWJEsksCV9S2Soq0dNSkSJSZpStKCoSTStFUSFJGUlSRtnr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    "]],
  Axes->True,
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{-0.9986797556013496, 0.9878757775202804}, {-0.9971900823350537,
    0.9764473926868718}, {-0.9381312811363111, 0.8969768845458534}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 205},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->221752595,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->42353607],

Cell["Plot multiple sets of irregular data: ", "ExampleText",
 CellID->286999164],

Cell[BoxData[
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "=", 
        RowBox[{"RandomReal", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]}], ",", 
       RowBox[{"y", "=", 
        RowBox[{"RandomReal", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "-", 
        RowBox[{"y", "^", "2"}]}]}], "}"}], ",", 
     RowBox[{"{", "300", "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1648262915],

Cell[BoxData[
 RowBox[{
  RowBox[{"data2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "=", 
        RowBox[{"RandomReal", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]}], ",", 
       RowBox[{"y", "=", 
        RowBox[{"RandomReal", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"y", "^", "2"}], "-", 
        RowBox[{"x", "^", "2"}]}]}], "}"}], ",", 
     RowBox[{"{", "300", "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->252345709],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"data1", ",", "data2"}], "}"}], ",", 
   RowBox[{"BoxRatios", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Cyan", ",", "Red"}], "}"}]}], ",", " ", 
   RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1618084037],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVvXecFNW6LvycCQzBgNkdzv72Sffcc+7FnN1u4zZst4o5ZxRzzhEUBYmS
cwZBgoI5AoogqOTJsSdPT86BoX/3W+t511tdXd0D4z7n/nHrNxRd1RXWep43
r1XVV9z9zAP3PXr3Mw/ee/cfL3nq7iceePDep/948eNPmV3J/wDgE/Nv57Ew
n/+P+cR/n0QiEfNF3Ppxs042ByTZLfshwgVJ5uPZPOKJwDfJdpUS3QbO+n/i
ONtT26s+7v+ze0DkZb3efffdZz+exr3XubOSfXeDxc38+537jl/GnHVtXFvS
Aq09yuEvF5bLJplr9Pb8I3y9QrLc3Kxxai/PP8zfdnf/1F5eK9Wde5jrQ38e
IefJqafs50x/Kw5J0IqerqZMpLn/B7i7H8qme8e7tp/Mcx5wxxzm6xmRDmyf
wKPvd1c+sldH3+uufXTg2+TA9vE8+uxIvBxFnL793n33m8CZKYHt43ils+JQ
TYnbc6xr2+/+2654dA/tP1CbB/X6Dke6O/zTf9sVVT7/JXCF1MD2/+71FQ91
bfwfgSv0CWz/r4ifc7U8B7v2/M9enT04oroR/SZ4Zlpg+z955pXuzEG9Ovpy
16rjA9/2DWz/B4/+18iB7eFJgTP7BbbZC2FlvzZKZe6UXl3vH806RT3aAW1n
It93YuC6/QPb/97LdqttPTNw/oDA9v/o4XpB+xq8frCdv+a6QetrNy3Tqeb/
EwLXOSiw/W8RvwSoHT7I/d/f4W/uMKQYsiSSwsRXPcO1ZYC7GvrgoRJ4yz3F
uDPUx3z4j8DZBwe2/5VXOy0Sq3Hoi4e0TdK4u4pxRwi3FomG4bp8X4uD2n1I
YJvIetdOFEH93mHh3X8AHinBg7zzfSHXIbOYJtwWws1FuKEQEg3gilxcniMf
gX/uVUsOCbQgPhL6jcNjoN083F792VLX4UeK8SBbNKTIru8OWWjMYtp1SxFu
LMJ1hbimAFflO6QuzcHF2bgoizf44wHax/bTvqWoPd1vO49xeLGdR9kbPqft
fKwED7Op97Od93B9Z8hCaJZbQripCNebphZicAGuyMfleQZ0YeLALTwwgke6
lgX9H6X5aNuEF9jSZ8u0sSE8UIT7CoONvY3tvSmEG4pwbSGuLsCVBbhc0E3B
RTk4PxvnZuGczL6Ijwj6BO4e9Bz/1MveHB6Jj7sO06PwEnvyYnma/e8Y3M0+
3FGE29n6W9gB0/rrinB1Ia4qwN+oPBfn2vUFOdJ6nJ2BM9Nx2h6cshsn7YLV
3WCklBqJ2h///j/2shcDXS+O8lr+Clv+SgX7loonSy0TVsKLcH8hNRP9cSf7
c1uR0X7bmZvZn+uLrOhcVchj+uKSXFzE/pybjXOycHYmzszA6enuuifsxHHb
nVwO+oW3PiLQh5SIxvdd0CXIlvTz4EhslKBW+WjtP14rxbByaX0/vFCOZ8vt
xydK8WgJHgphqCiEsyBpVm2NRTHqcCN7dm0RBru+H45L8vCXXEuSWbx+meXU
PTh5F07cieO3u07Z9c8Y9BMGbU1yEhOMckWCOtm3veZfkl35GAtGbv9fRP2S
PfNYr3+vl+AN178Bhjy8WIHn2MUny5zaP8Ce3FuEu4soSea864scqqmyOi/b
/n92ll2fni5Hpdgu2I701IskP0t75XpJ3XZ7r8daMFr8A3vxx0h8/naUYjIQ
w0swotxdYFglXq3AyxV4ocJuPlWGx4U62tkhIdwTcrbfiKI1DCGBJRVXUlIv
y8fFebgwV3rahzq1CyftxAk7hCvndQdtcTdMlO1YPJL2mcO6YzkK5jbSuz+4
nvxWe3QY3izB29qjEVUYXonXK/FKpSXLLE+Xk6xSPEynfX8x7i2G05bb1fMa
ebw+BOfdBxfhCnbvknz8JQ8X5Lr9Z2XijAy1G7aP7ipGJEUebZe3wPMS0Uwx
ovGH4W6fTzaS93lcBnOzf2RvNf+K5vN4S2MPpzdvV+HNKgyrwquVeKkSL1SS
yXI8XmYdu1mGlmAIP9zN9W0luKXYycJ1xbg2ZD9eSZG9tAAX5+PCPPv5zxRa
2990ZydP2OlaMGib67LzDB67LuP121Ge0e2TWMCLhON6q5xqjILfYVSZdy5G
hjEijOFVeK0Kr1ThRfb06Qo8UW7pNcsD7OCQUtzDzTtKcWsJbubO601Pi3FN
seryXwtwSQEuons4Nwd/Ym9tV/fgpN3WijrOpa+AR6+X17vWCyTwrA2ZiVhz
GM8pPT49p+3db1VPUzCyBCPZ5HfKk4XVt8J4M4xhYbxahZeq7L5nKh2rZnmI
B99XhiHcvKsMt5fh1lLnRa5jR/2s/oX9PC8X52Q7W+36uctuHSfKuo3rnzXa
G/Sj6w29XZqtXHBhY9AGWO+Ryl46WUwhGJB1sO/M9xmJ9xSZ+nMAezdPw/vg
7SK8HcJIdmpUqUGJ+4/FqLD93wpFGK+F8TI3n6t0QmGWh4nP0DLcV457uefO
couVWW4khkYori52d7ms0MqEWc7Pw59zcHa287gn7YkFSvzQz6oNxMmsNapn
r1USeOV2RBdFh3fkZkR3OhyDuiHIDQggFh9zBGoC5gJaa7EIFloQzWJAJILc
/x8YWW3/f6MarxtRC+OlsBO1J2k7HyFkD5RjaAXu4567K3AHd95chhuI4NXU
rytCdn0pzeYF+Tg316rUmXR5J+/BibsJ304ffBKbWOsh+G2G5GvoE0UPaAU6
YqUrihMxTA1gGCd3vyU4KU7ngjFyDyimenucLGq+b6RhJEXkLa4NpILnaMHT
SCTxHFGN4dV4rRovc/O5KjxNY/UoMXyoAg9U4P5K3Medd3HnreW4qQzXE9LB
JSqRpOzCApyXh3NycJZKpIenBykNcrKHKOFURFP9iLZBLLDAJ0tqxO30kEwk
h7/9NXK4Hz9+eMTLfEdqbmvgNFiOKsY7Hpb9LJZOPGvwejVe4efnw1Y8icPR
eLQSD1fiwUo8UIn7aZju4fr2CtxSjhvLcB3xvIoi+teQXV9UgPPz8edcnJ2D
M7Kcdhy/y7XDImks/s/0URZFo9+bpCtS27GS4cHZDDCTs/ZeeuxkMIEc/qaX
6AUlNBipamZh7Pw7RM9g+BY99tsFGBnF0B0zmgptYHy7xn4YXoPX+OGFajxb
xWMOxmNVeLQKD1fhwSo8wOOHcH1HJW6twM3luKEM15aK1PTBxYW4oADn5uFP
OTgzG6dl9pH9nqcERKcdfnZzE+nWllt5rFbZ64IYwhQXGSR72h3b72P/TvyC
MbJX10/BO0yjDIoj81wkGQshxlA/xxCMUQrhG7V4vQav1DhhdJr6RBiPhfFI
GA+H8WAYQ6vd/ruqcHslbqnATRW4vhzXlDmJu6TISeI5uTgrB6dnuQzpeNFs
Fz5zvVW00aKZ4qAc9AOkypWseJr/xMvYiNIKaarPSiaSR8GzfyQ2wwvqbjAv
1Iqa6cHoHIzJcwBaEctzMaUH4JgyjK2IAXBkDd6qtZ+H1eLVWhFDd7Unq/F4
NR6rxiPVeLgaD9YkCR73VOPOMG6rws2VuKEC15Xj6jIj1uzkiek4YQ/hYtLr
IhsXqKlX8QHmVXsYzbQAnR5iorrJTg5jdDmwHdTHY4jjsQ6XYL1A8cUhGJ2N
MRS4Mfl4h8CN4lr8yTvFGF0ikLl+jKaKCGQjCNbrXL9YozL3dDWerMHjNXis
Bo/U4KEal48MqcHd1bgjjFurcFOl6G0aLivGxSFcWIjzjNDlidDB+RMDYyLB
0xiYKPqA1OoI+tXSGrYFcJR1Uk9opkS34/E82sPTL4dBXPtG5XBMFsZkY6xA
m8f7GnhZIBol0IY8aKW/RzlsR9XgbcV2WJ1dv8TPz9XgmRo8VYMna/F4LR6r
xSO1eIgH3F+Le2s0Qr6xEtdRwJ0dvbQYFxXh/EL8OR9n5+IMljJOYhHjeJ+c
Mt81cCZZMI1/2Qg3xhqRWjf72SHoCKP+yAcJUE1KGAn1DtngiIVaAiOBYzIw
NgvjcjAuzwMXo/MwOl/z53cYnwi64ypUmsYouiNrrfC+SeRer3PfPl+L52rx
TC2eqsOTdXi8Do/W4ZE6Z//uqcGd1bgtjJurcAPN72B33UMpvkU4rwDn0OKc
no1TGGCekE5wd1npPU6ymJ+glYdNTveTLNB+v0qIGim/JivvdllcIIeBPy5S
pOMipSDSrPqJZfDdMTgWkqJIp2FsOsZmYlw2xlOMBe8kjM0zeI3VGGk0wR5T
grEWbHemsa3OUBDrEXV4o05rNC/W4fk6PFuHZ+rwVL3k4n1xfx3urcVdNbi9
GreEcSMDpmsqtbpYgotCOL8If6bunJGLU7NxcqbLdY7b7SJOrXxsdW2TeJMS
TWBVqEWem72YSXTWj/F+kU6O7oluC3rBqDKKeUwe5osTnNcfl4FxmRifjQm5
4lfHGc81Lt/1aEwIY5hmjo1KtA/lUbU0GVGUk/FSPV6ox/P1cBg91YAnGvBY
g2wfgwfqcV8d7qnDnbW4jVHDDWFcR9SvYCZ1cTEuDOFcpk5n5eH0HCvWJ2ba
TWc2dmh92MMbiHFsBu5B3wu2ufp9A9cGghTER6jcTkOsxXDfpfYg1UcmlGoi
HVPpcpo8PgMTsjCBRnACBXp8nrnu+HwjZeMLXCPHhjC2GGMZnzuZNhIfVhNC
tN+qsyZkeL2rMT7XgGcaHMpmebTB1cGGNmBIPe6uwx004jdV43rGHVdV4nLi
fFGxlWuznJ1Puc7ByVlOJo5XuZaKpbXOPjk22Eolt0khRdTDqXWO9ArbPgEp
DkZlRyTEODgy5CRvQibezca7OS4+nGDkeIJFd4KiOy6EccUYR3THl8egO5qS
OJLoWnGudzb/lQa83IAXG/B8A55twNMNeLLRfqPyfBgeaMR9DbinHnfSrt9S
gxtrcB35uqICl7G2cgFV6E8FOCsfp+dqe400WyO9U/1EQJpVlJ3ODfpOvqkH
WjzckxXfaO3EAzfoFVWOgxlAFGNv3FErNuN3qRa/m4mJ2ZiU623n4d18TLSe
b2KBk5rxIYwvwfhSjC9zGes4H7ZWeImtWYY3wNUHXmzEC414rhHPEFYD7uMU
40e4ObQRQxpwd739fGsdbq7FDbzWVVW4nJHGReTyz0UOwdOMDGc7BI+LlWHP
9zHIELwdok2aK1hMNNfvGdMkH5ZaNVD/Fczr42VX56UY2zqBWfa7DIgmqdRO
MlI7yVjfSQUyMPIuVXRCCSaUYkKZi6zG01yOrcYYH7RmebPeQjuM2L3cqPVo
g+6z3PVUI/W2P+7n5l0NuL0et9ThJlqIq6txRRUuK3dVk3MKKa15OCXHtfc4
yisgJYEEEQXPG/S9ANuiCAmqHlh+H+ZDMnHVNCirgunRAUwps32JlkC6BxOJ
6uQc3mWywXSywXRygevJxBAPK8G7pXi3XCMBA6aIqlneqseIerzRgOGNrl8v
NeJFGrxnm5wOGGF9ogmPNak3GmrrH7inEXc24LZ63FyPG8nKVWFcXumi8/OL
8ecQ/lSIM/NxWi5OznFXP47pBgtXCXFNdriav2RF1TU1cQyW6pPkAK492IHD
EmLryWsKJhLciXswKZN2B1PyDHRTNB4zy5RC1a2JJW7XROrpu3Q946pTBP+3
DboNeNOii2FN2kNjCJ5vAnT8AE804/FmPNqso6X3NuHuRtzRiFsbcBNtwjU1
ms2dV4xzinBWAc7Ix6n0+SdkesjtcBKrUZpW8kGH5qoJ39lvNoB5mwM3cUW1
j0+KlZ+46AzxY8gD4/C1Z3PshJo+aadDeFI6Jmc6zKfmeU1NwlQjv1MLTeRv
oQ653ZPKMKkck5gbTCTME2owvhZjqdSj63WEx6D9BtE2yytcC9jPNOPpZjzZ
LI1Iw33NuKcZdzXh9kbcQlt8XZ1c4yBcWhFF7k9FOLMAp7F9J2bheCrcoJ1p
0m5raDdKuLAfbGOkNlg51Cg3kawKljqvKdEMN52ZdahnGybvwOSdmESIJ6dj
aham5Qj304xtmGawnWbFdxoN7tRitWeTyzGlAlMqMSXs5GliLSbUYnyd+u3R
DRjZ4FAZ3oTXaQZeah5o/zsEN9PWXkM2/lqJixl7nUf1OLsQZzA2OTnHBLhq
P0Vaf3Jja9Gs2BgAaK3aF3MlkMY+XsSaGM2gZBIj2bvf2XLBUSqdD2FEZwrB
nUxwp2RgmkaS0/MwPR/TC8xfEqYXmn9FwsY0HWqeWo6plZhahamK76RaTKzD
u/XKwNhGjG7EyCaMaHJ3e63Fnfx8M55rwbMtajHa8HgbHmtTC3JvK+5qwe3N
Kr/X0R7/LYxLK/EXEnEum3FmIU6nGTspW23ETjeKAI5ha+VHbbLda+1xkhVr
E5ut95xcdJ0Cf+4Qz0Syh3BgzpM3U0H5FPH3EdMrZkx/Lbw7MGWn/bPE7MHU
DExnhDSDijvDSP6MAnPkjELMKOJfyO6fTlimMXidVolpVZhW7ezIlDpMpvGd
SJmf0ISxTRjdjJHNGNGMN1rg6t/PteHZNjzThqfb8FQbnmxzbA5lrHV3G+5o
pSz3xZXV+GsVLqFtOa8U5/DeZxQ6Jk5kTWPQbqcYOlvkB08lyEGycADoeDpi
tEKrvnE8AIGII6gbh/ydunGQZ3embbckTN2JqdSOqemYrro+kyTMLDB/SZhp
ejyzyPR4JimYQRMx3c22GYgZYcxgVjGdQjyFHExuxGRa8QnNGNuC0S0Y2YIR
rXijVfOXVrzchpfa8GIbXmjD822WF0tKu3rHB9txf7snaf1xcxNuoMkaXIu/
VeOyKvyFzJxbgj8Vu0rKSdk4ngn5oF1WTbTSvFXLzJv8/Fjz7zjSEDs6XtlD
LdRX84jZEzwnqD8H98CWegOtMR3iZ2faDkxTdqalY4ZWd2blYVa+IDPLcDPL
ZBmzQpzIgJkkZ0Y5ZtLvzgxjZg1m1qqvnUbVmNKEqfQFE1swoRVjWzG6FSPb
MKJNEXu9Da+14ZU25agdL7Tj+XY857HzSAce6MB9HdLYVFxSiYtouP5cgrND
GtGcnOtTk51apeFcKsEpyoeLduLY2F+WHhid974IZpi/ho34rB+xukOcZ2zH
dPNHgqaRoOnpmJmlnmF2HmaTodmGn9mGn9khI8Gz1bXMLMPMCsyqxCzmS7Nq
MKvOMTSDDE1rwjS6kimtmNiKCW0Y24bRbRjZLh7kYAxrw+vteK0dr7bjlXa8
3I6X2i1PZnmaNemHOzC0Q/3DrS24uRk3UCMH1+GKGjfj7ayQa9FJOVZxnBZJ
UEpPL1IW6+mDds1jKSZqSlZ+UhFgTecWBVk5KCZ2ShRDxdovw4H924HpdCLT
92BmhuuBwX9OPuYwhplTZFo4J2T+FTv5m1WG2RWYXYnZDEvn1GJOnVqZmTQx
M5oxg/hPb8OUNkxsx4R2jG3n1Q/BW4T5jXYMb8cwj4QOvEzgn+f60U481OlG
Ym+isl3TgKvqcHkNLg07Vs4xqqIiYTTlBBlbHOBz8J7hSmC1UqKxVs/17uhe
WTQC89cHgjyw/i112mBVXGzMNszcjpk7LPQzCP2MPZiVATdiOofYzy3AXFZK
5xrk5xYbZOdq5jWnHHMqMKcKc8KYy7x2br1DfzYldFYLZrViFkerprdjSgcm
dmBCh0N/VDveJgFvtuONDgzvwLAOvN6B1zrwKqF/hsOFj3Q6/3RnG25rtR9v
JA2DG3AFHdXFVbiADuRPbNjpbO2JOVrzkoKCzIFRTRj0Q5Kre5GBPn4GElue
ZB/Wdkn7u/HnkyRU21m/YNY2zCIFxjPvlNB7JgdX5mQ52Zqbh7n5mFeAeezX
PMPCvGIcg3nKwtxyzK3E3CrMq8a8GswjJvNofeaShTktmNOGOYR6Zgemd2IK
gX23U3pwBMZ24J0OjCTob3VgRAfeFD468ToPfYHrx7rwMGcw39PuyHAzii6v
xaXVuKgS55c7r3JGEU6l0rq4eJBUH2Sw8+eE+tATE1q30Ui3bwLkrb23anRQ
z4jb5A+zf8FsIj5rB2btxEzKxmwCPjdLvdq8PMwj4vMLMT9k9823udr8EidR
8yowrxLzw5hfjfm1mE/AFzS6iuTcVsxrwzyiPacTM7swnZhN6ZLrH2kUAOM6
MIZoG8zf7sRbnRjRiTc78QZxfrkLz/KcR7k2vvnudtzRhltbOQ5/KE4r9OQQ
g9j6Qa4Q6UTcHx9pjWKDf0QoQa1GbXksujzD4GfFOlg7J67uCckA2mzonF8w
Z5v9m70dswn4LAI+J90hOZ+JgsF7fj7mE+8FIbZwQYm5woJSd//5FZhfhQVh
LKjBglosqMPChhRBe34b5rdjfgfmE7k5nKo9Y6/F3KE9qdMK+vhOjOUR73Ri
VCdGdlrYR3DPa114kTg/wZOHdmKIA9z5oKsa8Lc6K+B/qcL5FWI6+0RrPlaW
N4v8bgxirdVzLzPoA58N13wgAeLm/GCesB+02dC5v2DuNushtxtbOWcHZlMk
5nBAax5jaYF7fh4W5GNBARYUWbgXFrPtC0tdxLigAgursDCMhTVYWItF9VhE
W7LI5bi/wcJ2LOzAwk4sJGzzu6PIz+SeaZ2Y3ImJnZjQiXHEeHQn3unCqC6M
5AHDu/DKXjy3V6PLhzptiHMvNeKONo1erqzHX2txSTUurMR55Zpxn6L1KrUs
mkcHJB90sGRC8zV/FTjJ978/X0uO2y8498yGPZqW/hgiTRbmbsfcHZaEOSRh
LkmYTxIWkIQFJGFhARYWYWEIi4qxiPZ8UZnWfBZVYlEVFlVjUQ0W12FxPRY3
YnGTQ2xxGxa3Y3EHFndh8V614wu6HRtzlQ2jB1O7MLkLE7swgdiP7cKYLozm
57f24vW9eMmdfzAe6cKD5Ote0QAasesYPxkNuKwGfwlbVyvSmu5Jq7N8NlUL
KkWMDbJKMWi9x110fqnivb/sIDgyHVc1TTQTKLG+OAznbcM88mT/XE5zCOZn
YAErjQtJ1MI8LCRRi4qwiEQtJlGLy5z8La7E4jAWV2NJLZbUYUkDljRiaTOW
Eral7VjakcoeL96Hw0g9uZnThVldmNGFaV3WNUwiH+O7MK4LY3nAqL14Yy9e
7dbI/3HuNfTcLwaqw2Uo1zIYurzOKIrTkDOLbQx0Sr7Hy+5YJflRR7I3Ov0j
LxvgQe6N+QUxP/B8gbjINRgT7ceKsbA7j/Gy4WXeDszb6fFysCVlIXlZRF4W
5WFRPhYVYHERFoewmLwsKdVK/pIqLAljSQ2W1mJpPZY2YGmTBF0pWKZPYS3b
Ry/yByzudsTM24vZezHT+I+9mLoXk4n5u3sxYS/G8/Pb3RjWjZd5/FNcW53p
oteg5txKnbmagddlteKD9sjtzgjZmOikPBzPHgzaE6sxW6IaY9ffCSsSYfk1
JTWOiZ7mZf8aBuysJDcuNH875hN8tSrpWEhlX5wZBX9xPhYT/CUhLCnGkhIs
LcVSlvOWVmJpFZZWu2dRsIwSutxlvCl4vxvv77N/tn3L3TOoyziZzZiyhXsx
f681YH4izDJxL94l4O90481uvLbP6YVhwajGI3vxkGGhy7DgtPu6VgyW6QPY
CW+M66wSnF5kdcON6kQVY2tUMZKsyUqJasWg9fboPglRTknIhsSpsbhz3pd7
NjAWd2bBGzyC53NGlaFgvjz/cygW7sEiZWAxGVhMBpYUYAkZWFqMpWTgvTK4
mueyGiyrw7J6LG/E8iYspzl6v915lxV7saKbf8R9RUTW7n7vdWNJNxZ1W4cy
rxtzujGrGzO6MY0ETOZ6bDdG7sPwfapxT+3D49141PCw1/Jglts7RQKOwAVV
OJcZmjFNErueoCoA+Mcj/Cpg8U9yGpCWEPvUQI4WzdkS++woA7af3uzy9fwj
5r+InByOBTuwYKfjY9EeLCb6SzKxhO1ekocl+VhagKVFWBrCe8V4rwTvlbqs
f3kYy6uxvBbL6/B+A95vxPsUxBXMg1d2ugrZqm5z91WEf1XErZ0PMrws78bS
bmuYFtKnz+3G7G7MJPLCwoR9GL3PxWyvRvCimognDAndlgSz3NMlDKThojDO
ZyHRKkDIfjgx16vi7Xan+tUg6hnsFxRO47p17CfxPDE3KuGrWSSyP4n1IE09
wPoAIQu2aS1uIQlZtBuL97gqw9JMLCUhS/OwlIS8V4T3SMiyEurBwXg/jPer
saIWK+qwogErWBZayTrCqg6s7sQHFNYkfNBt2vOBPh9otu34xoeEdfU+rKTF
MlZq6T7ryRfuw/x9mLsPs/a5OGAyzxzN49+I4LUIXorgOW4+sY+UdIt8uIeF
L2d5/cJwVDPMcnI+TsjxxoJ2xpQtBm1OzIm9amovOPFHwb3jxHvCfB3/NC43
9mnBdixk0wwnyY4L6vJ7WY6R9/LwXj7eIyPLQo6v5b5nC1eEsbIGK2uxsh4r
G7CqybG8uh0fdODDTqzpcpZ8TTfWKC1rrI6sjRxiP/fFJBX6kRG8GcGwCF6J
4AV9bvPRKJfcvqYVVzbhsnpp8UCczfzylAKrChZKGV/eoc/lRR0CPcF3rn2D
1ntdOBDqOiaUFElcJ02MOmvX9vBv+WfP/xZi/awyWOh3WNxdrxbvxpI9Fn1X
d35P4V+Wj2UFWMbB5uXFeJ9h64pyjadWhbGqBqtqsaoeq5nhraaL+LAdazqw
thNru/DRXtW9jxTLj/QdFp9EHB9GT4zlMh7EuPL3IlgSwaIIFkQ0/56hHI2L
4J0I3opgeMQZrGftV1fwyx2ANbHXt+PqFvytEZfW4aJqN9PjtCKrF8dzXqPz
GPbJF9dfffAqqBY9Zg+JtjU/379uiPVzz1NaTpK/8WSBBY/fYxnRX0b0lxfY
z++H8H4xVlDWVlHVV3OsYHUNVtfhA1qBD+gf1rRibRvWduCjTnzchU9owj/Z
J/MjP7XW6DN26VOuP44YPbD2KRZ8h9lMHmP0Y3zE2qS3I2KTJDZwju2mLlzb
hquacXkDLq7FBTo6buJUUQonKa5290t0uMenFbF2KIitv+bhz+rUPyQjfjxU
8NZxtETvyAqO7uixqd8oEWKfFu3AIvZ1yS4s2Y2l5m8PETgUy/OwnOM67xdh
RQgrqRyryrCaDH3A4YQPavBhHT6s14x8bQs+asVHbfi4HZ904NMufMo3HeCz
fRJ0GXrM3+emLV+4mswXdlPtucfY6ghWWsZc5DSfsEyPYHIEEyIYE7HmTLgQ
5fgF3oylGzpxDcMIN88uRjfStQzoCqy+7M5NRFSegpYqNZYn9DwakWhOASPd
Az8fm4BN7+mnr/mHlK+hdszxtwOLlULyh/doAZZlCuQHYUUhVhZhJd3n6lJ8
UI4PyOGH5HBNLdboiNxHzfioBR+34pM2fNqOzzrwWSc+34svGE99sc/FZV8a
/r5y9WLzv/n7MmKJBDXPT6LmmvxuTsSauikRTORm0hXQSHxo9J0DGNyKvzWJ
deO3R+FErWfJBASI52EkPOiHKHdxds1Zt7RADJx4RPv/AmspHmvmL/kraHZn
Gdvh2mIpS3GMmWV5pqsgrsjDygKsLMSqIqwmcx+U4cNyrCFza8NYy9Gktays
f9yIj5vwSQs+bcVnbfisHZ934ItOfNmFr/Y6zr5yI4lfR/BNBN+y49/y89dk
01k2jz/NRHngwgjmRfz6Jm03S3/3eKVEErdTTq5tx1UtYjLdONZpRd5Z1MFd
GkEIiZtI4vcaQfSJJ/HAHHp7PFH672PTs6Zf8Y9ccvtz15pPXUUU71k2lymb
72e6yHdlPlYVYHUhVofsjg9LsaYMa8qxlgnHR2F8VOM8yccN+KQRnzbhs2Z8
3orP2/BFO77swFed+LoLX+/FN91C1LfK2Hr2f721h+vsLEYl1f7B2ldnF9dq
lMEi0iEmf4xOwTSZ6UPE7TZ6VGM/JQw0y/lV7j6nFDpF1FHDHTpy+6Nj0H7+
zkWkyqC7qY5I0fv1BYLeTnhL5Ot+HWsaf/BeXzqJ+ML4HeHpE8fbx/xD0seu
N4diBSvPqxjmri7AB0X4kFStKcXaMnxUgY9I1cfV+KSGRcokbLBof8fGf8+1
+bzB3Hm9lZV1EUcEx0KOXY3oYsIiY6/sFLY3GOaB6Y9Z7tmLW1khkwDPLBdV
47xKF4XTiemshe36SOkmqQGwp54BHLT+IMW6h+rjfxfecblQX8Fb/kDgPxXs
LeDJH/HzWrttV1YUPzSmjXtXcP2eStgRWFuCj0rxUTk+rsAnhP/TanxKu/dZ
PT5vwBeN+KIJXzbjqxZ83Ypv2vFNB77tlDzOkOLefbRRJZ+Bz+/e561Wco/c
+QtaaCuxEggO5wnPkpShe3FXJ27hwIsEgma5gJ7zTIZEJ+bpO5UY+akifK8W
1GfL+jKQQKz0B2cu7JeXlMiBn42WmsUXap0+lRcdGzOjqFsY1uifWYxwriIm
ywk/0Vtg/s2HTAjGZ/pk/Bf1+LIBXzbiqyZ83YxvWvBtq8Zd61kk+H6fZl0/
RLCJf0nYrO+U2az7fjCt3Oj2LgGW8sbL1Kes0vYa6bFKPFmD9LdsBstjjrb1
zPu7cGcHbmY9+UomCH+pcUUcE6Gb5QQv6tulhYIfPYJUl4y+rPPQ98YaE2kP
bfx++TkswIfdK/cRGnzyb7Hv+yG3P4yjQTBdyP3zoZHDHGA2d832MvavGvB1
I75p0hkp69uxoQMbOvEd6fhhn/ilH00rtrg57j9F3HprxOyTERBzD8O4ud8i
YLEJJXmXZaKTcqc1NJmfa1v62Ux1hCrWU3vttIf7Oux42I2tOmZpY7gwzmPE
clqRzreLFhGs96Dn3+gerJC2ugD8AHx4Ff196vL3IfHM6jSPGa+maY3yxzzp
E35Yy89rhImkD9yVxWiv9KHQbwkRElLm8YNwMguSHOCQySanBN4FxvPrMebf
hnZ814Hvado30X1vkc78ZFr0swu1folAsU2bxWuaK8/lXYQch+pSygeoM+/r
GcmYq1S4EYrnu/FEF7RVKbiQGfVZxSZvVQ8tsyJsWVl9CJ8S4Al0Ih4JqRHf
HLf/IgfByr60f63aIqKfZJHvs8r1iN2kgZA6mkA/lzsF+pnADGAaMNVFN6mj
+O1bwAjgTdfIJINxErZJhn/wVJ4wnWfO5FU8yEFNWCy+KE3wXGwjYJu+uCc0
DLgPdeBemp4bWRW6vF41w9iek5k5G1HXygDlfLOOr6nN8WHb4yj7PgTi2t5j
y8Z+qOfJB2KbvIpyvdIhg+RFepCTcyfSRGe6QguKtpPDsZTtd4CRxBmsNyZP
5CGT7VFT7FEBlJ0tmU+Al3jbc2LvnmyTR0k8iH5fSvNeOwfCLLe3OcD/Vk8u
UjlMuNNIMjH+0ZvNo4WXoEXRKlbsnPO49xf8nbh7o+fJHvDuHYzLaVGXai9T
5uvXs1XvBWkQQIPkBDEicrSR6Lcpzm8oAy+YEMWYXuBx4GFoLm14GcfzJtAK
eYSQj7SpeodZlPT5Ys5SlBWx++pLVkRc4j6TWfu7EfeOk8vrcHHYtf3UfC/6
tBOXSMEWl/XrgHl8rTHN247J1BM9m4gUz7J06zys3vLAjkmgt8r1st8K2hPP
pICKvkD0XnibqVLvqvmTlIxxYs4F/bdoWAwZrwOveOc+YTJh6YtkfkY5RlFL
RvPchOQkTYao4QyKwlyx9mIXJ8nFNrt3Qwyw+fkaorWUFeTZEUzTespbHFJx
4whGV4xxur3VzQS9nI8+nSuJRC6nmfRHNFiVp5x9lcpB69Tn0gYFdOO/wpO+
K8p7bilZ4n7LSNL7WrVbQgsxnxYZYjp8hojH9BtNbEfyK0PFcOA14GXgBTiu
D32DX4yggXqbh+6HDNeLacrDPM8a7Y5gZwTbHQcH2/jVW9ayuryMFf25dBCT
+e3IiNr621rcZHTI9J5k++SGT0ak+rjJ7TIMqP3SUZRE70nwIqK42SS/hge/
vnhvUUoW3Vhmz7Qrm+wupZ1YQOGcpVyAXEzhBy/kGUt0JdM65jVqh/kbRnp6
QweoFVPI9Eyh3+GRFUEGEeCjl/0wK4KpSsTwbjtFyywPt/twviyMC8rsc74a
6duim3PEOrOnf09lw2hVKagB/mxA0e7+lWjrm877LHXXGbiQEjdbZd3zuJO5
9oMrnkB834vASxR6Y4Jete0ykGPAARF3kjeBxE0hm7N0bwoKFNZcIxE5Wmfa
pXvdnJU1LNG/J3LOqSBpGNKK252s26dkziu2j68r+tsUfZ1BskE9hwuFEuHM
e0UZ8XJlzysn94B7n4S4H6JeQTydWScvtuiDAi75lifj04iNECCG2OOA6Pd7
hh74OeB5Wh0/GUiydAx8rWfxBy80jtxOItszXO6NYoN5SN5Tk7KaSeMXHF62
btPJ9mR9f61j536GRNfX6fa5RfZ9IlFO+WZnSbbUvmyw/xvsk30YKweS4f7X
sWbWYEOMAYLtAl/sPoNrQdiLK5PHe+2gtT3EBDfGqT7JQOdpYD+QE/HUAOJu
ZGkUTcx4gj2ZzLq8KRxBFf+SUGklo8LhMF3rnCsYOH8qgy/A9yaFY+XUdr+f
XGNoM+6ox/U1Gv+fLjN3ZKTiJ/jHAaO2XYTeL9/ylWzGvYn5gMjbb/X/5AWQ
ys18Yj0n1mgL3BP17kePRXR5iKHkI4xiHmNk2Rvwk6zAD3iVDvh1XudNivg7
VJfxatLlYdi+k/VmyxiWSUnkayfZqQZaA9l2YJeMdxPjQ3B7rXs/0YUhuz5V
igg6iOAb21aE1abEjeP5EP518qxvYUi2ib81AHPUXs+IyovNgHxc4uj7gaHA
A/x78O8COOlld+204TQfI2k4xjJumaT3SUFTBI3uLwkN7pnw4TxcdEpCqRR9
Zc23MqFOrIyBMwcwSWtI+1HNt9w0wbMg17KOc2GBvoM4xSv/myv6x20E++44
9IHoEyp+2U5yTMgMg0RMHBpgYqDWDfpJnyRbFRamekZbnki7G7gHuBcYYoQE
MHQkGT7wx7+PDtDSvE7T8ha9qWfD7dLIbjaL52o2HDQ5Kz6aEioLc9pDZQhg
C4eujaXYA2Qah8uryHNyRtrlRShN2pdkXJBnX/ge5XzQZpX79ToqE8U+Lru1
MrtPI0N4EUuK/v/rsO8jNmWmxuVTXCsH3GZydOAO4E7gLiCeAGHgkN4zINL/
EkOcYWpcRvmzMSv9hB0tro7WIu9Wtk+J2B1HrGGt73NamnW045uBrcA2Tn6V
mfp5gAxUGlGXBLdB79Cn1ZPX8+UdijtlfqwSsM5b6886+OMWTw9cpYy/mpDi
UfWrWLBH0zZRkD5yUxO9Apjc+9AbgZuAm4FbgFuB/ZOCJEvLkUN7YaVAhXiB
dv81elmhw8mf0QCPitYI2vihTeIAC9XvwTNB/sA2z9Vo7AMWYj9ltPMNrZMM
Uoo/MItnpcxSSpbMUqcMNetLuexyXhbO2OO9udLR07cnJlLl9yv2enyk9OAZ
3EsgfO+GSPTeEx2l8WoS+JgsUWKOvAa4FrjORGvADcCvIoo89e2JJ8HhaTL0
olqq4fHcGB1pdcSgXXya6SLR+sNr9DFjVKakSLWSQdDHHJD5yjeCKT+y4Ddf
8tidTGKUUSN5K0uTZ8PO0NFxsWFk51v7cdC6/sqH7/dE7K+k9EW8Xjgm4t8H
EfOedHuFwwMsiP+5ChgMXG23r7EH/X2UJFnlOcjz8R4loNI8SQP2PL24m03f
SL/n56A9oj65XWVK6oXD6LvHaYuPkhrtalbKA6YMsaYsm6bMLCVcO08i/W70
kJXoNfoOK/UpQ7wjTBg1RHTI93svjpNE3vpXckJIPqE4fJYu0ZLHivn7+/Qk
aQh7RUczVHud8ij5eCrqTfqiuhu13ahjtxq70Uxi2vgUJyfKpNyhMDzpsPnH
d+jopYCa0GQh1mTtVpOFOMfCeTtWNxqhkQpO8+Y22Qmb9mlSJcE1hM9YmE0Z
k/DpCNQO9YKLmD06Z9Mw9Fk6Pqcb/CoTX7snfR0fg/+rfFj+H6BiPEpXIj1O
Rc1e1HGUqnEvmro1t+1QPSAPabfyUg9yz3NcD1dpHThTIRAL9ZHO9PBbKH+A
JX0N+dxHDbSe6MgwyynevJaNiL7j0dMNsx40JMXt0HxDvxEfc2Au9G0owVkU
3i/Npjk6vjR0ZOKbLHybjXU5MlY02HLz91ECasaDJMNVZqpUkmq7UNepLLR2
o70bHftcrQPNbWhoQq2dFHQtj76TV3oUqmPDGBKPpo7IzMNVOqq3n7BLzi1k
1GvcRqUbqzO3SbKeIy1qr+xzq9/5+fChnmRXyW5Dv0qJbg8a0sd3hsW5txz5
uUly3Hi/B9cPX/hUxnC0Lhvrc7AhF9/liaU0CoRDf5X+OC8+RMyXLOWdqOh0
d6zu9DIJu6OpEy1daNuLDvccZBq6utHJOKatHc0taGhErXsrTp9reFNZHqJl
E40YwWR9PKP4mQ4G9N9PNLZbmcujzzfklauH0aEhs10nTCK1Ab5Fa68xv6oi
zCQ5zQryqdoW/ysoaXERmb5NJfg2KP19UPTHVxk+ncrGhhx8l4vv87AxHz/I
+PjAK4Gremf5QFVwElnWjvIOVHSIT6cBq2dNuqkDzZ1o7UR7Fzr2OqY69feZ
WprRWI+6GlS73xFJuYb3uV1sKJl/TpEaxahgMuOzuTKCJ7VszwJ+lcgCCjsS
QBcpxylhTTNrhS+qe72GbXxS/LsYto5XnYtnSesC0Qgiya+H/EuU43A77hcM
Pb4OwtcZ+CYT33r6Rb425uGHfGwqsIf8KG+f7b9/1txb0UrbYjQo3OHYqGtH
PWeON7ejpQNtnejolO4dhg79vaSmOtSHUWOdh0yF9Yi6hz5Ohv9eUjT6jGWR
ZrqWX3QWQ9+eklGeNSBLawEhuirQMFZp8MBozo7o2bp1Hemqd3Rt5Hqd69oJ
Q/x0qbfaL0OyJ1Hu0zNLSTEsZWJdFtZ7WkWiNuVjcwF+LHRjLltDcvOEdLEy
J0a+vBUVbah07+o6DDWkp565eFObdUmt7Wjn3DwhqJ0ZYGsjmjngWVsmKpg8
lMQ8DY08vDBugW8eQj9vxD5g8n7WI1KkTmCoKdBR8kr99bFqVaRke+sBdR7C
bnZ6LCfHDYnTFkE9OU6n9sfGwQE2rGeSaAbrs7AhG9/lOAZ+IAk/FmBLoVah
fyILP7u3bCZ7ZLh5Nsivj+pJSTPKmlHegooWVLaiSt4keChqyUUDYW9uRUsb
2shRe6vjoo3jQc01aKh0sxy8GeRXcX0LgxPhqZ+Mec2jUZPReYmwP1EG+opd
2+TLPcEoWxj0p5+cB2g1xs1eTGaoR7lw4bdU5AetkzHYk4bgxBhuUv16IlGG
b68v9oifGxJlx357pJftfJuBdZmGmoOFgV+Ksa0YDvEUraMegZImlDYR8GYL
eFULwsS5pgV1RLWBo/otLWjlfgN1WzPa3Num+1i4GytQx/SvwhYM7bMWHJQd
zL54nuVBhuPPsVYg/mAGLdUCjvmKhMrMPwkERFLEXmm70TeTSQ4NsU05PfiF
MWGg2qchtdGqTZqUZqL4i3rIfC3NPqM89IyzXwv4vOChincG1mdiQxa+y8bG
HPyQi0152JyHH/OxpQBbKTE/F6lObA9huzBim3QQsqrcnQspMsV0i2WNKG9C
RRMqm1HV7GxabTPqmt3Bzc3Wo5vFstKEtgYXHRhS6j2+LSdi7a/hSaIInqV6
kdWbt6QWI+fP42SVZdCoba0WAsTfuxku23TsJEvLAMV0IuV6nf7iSMI+5agh
KeJEqBF94kmJ4+LX8cEJYuvSsT4DGzLxXRa+Fz5ysCnX8bGVIvRzobOM20Oe
/eGeg5HJnC03jHwKUqgOJfUoJScVjahsRFUTwt67wOuaUK+j0S38YLhobUBr
PVprHd9N+jZlqU6JbbpCET74em7fwVrPQz5deUPrlxKFuRnga7RG9qVUA4j2
AC8A280U1CsHRFmRtognsfKWVOXg9TTGxwwrzqcMwck+dYlarONibZPtVfA5
mF5z9H0WNmbjh2xsysHmXPyYhy3K0S+FzkPvCNnNXcUuH0dOJfLCKPDoqUMZ
217RYOkJN6KaRNQ2or7RZCYuAxVSWurQUoOWajfn0vekkf1oBw+v5qZkMHfH
6sqwaBXazuGZxdLlYvXSH+ljCGDAtUE17yfGXAF18bjhvSuEGjaqyqcyEncJ
J9Z5RWnxOZIYVmRx7j347ovknlnhHPz16diQge+ElawoK1vysDWfF3ISvaMI
O0PYFYLqTCmyy5FbiXyasqIaFNeipBZldSgnNVUNCDeo/atrQH2DzUWcJ2nx
0dIcRnOle9YhZMe1r9AYOMrQYIZw0MTIU5vnOXjzpjIkajOHUy54xYFRraGD
Bx38z3F6U8iQuNjVIcuFH+LvBWI16mDqyc567/cRPXZcJVoU5zjZDv7mlPCh
s6L4vrw0x8N3Gfg+Exsz8UMWNmVHR1TxSz62FSiSO4ssCbsdD4crDxWOh1A1
imtQWoOyWlTUoZLupZqE1BoO6tFQb3INd62WWjRT6voj6jeI+RFg2Hwjey4V
y6EcC3iGScgw7pER/qnUCpm1vhwO90O+4vYGhrpgdu+VZvg2W5stCujs4sFl
NFl8/a2toEmQVe1DnTK+3pfhn0rhV0fibLuHvehIz+j7tSEaR20QFjKcFfox
B1tysTVXpdYQsV3CEaPcRdhd5PLIrBLklCGPNr+oCqEwSqpRWo3yGlTUoqoW
YUW8rg4NdWis05yxiT1uLEE9C7nhDO4/xrNR8uFqJps38/PdXD/MIotIP2Tu
lToNLyEUwTp4XSLB5zwHm3DIqFcIToMOKWWcJaGWsFGpximWCpkRkeaY8DsO
Xut4rWCeoJWxxJYpyIXVCDeP9IdMbMrC5mzSQDX9iYZ0Wz52FIiUIcO2HNkl
yC1DPttbVIniKpSEURZGeTUqa1BVg+paYpGG5io0VVrv3MQuNhajvtB52ahf
iHpq6oKVjOvoHm5zKB30gE8XQA8hI1tTdUrMEifXh3/i8xDf8GEwUYjAEHGO
OonC6FyJgSXqLYSOCp+jEPcdTTe8X7+yb/AmBSfo2l6rf6+wP1yxZ9L0fTo2
ZlgSNmfhx2xsycbWHMfptjxstyTAZWt7KLwZRT462PDCCtJRiZIqlFWhIozK
as0C62pQb7I3dqSJ9QfLSjmaSo06OEtaqS8CSvbZJtFFr0hyA33CnRpZeYoB
ugVPMWSOkswWWwmt83+m1KzzHp6kkkglErRV4iAK6L9FR4p1BEyoKfdVUcSH
u5jX6QizwNOGRNXE2SpPW3rLj62RWK/Ab5nqbUzHDxnYZDjKxI9ZliPbfrZ4
Wy525GFnvs7wNuxkkqacYuQJO+UIVaC4AqWVlh1XbQnrQ3l11aivRqNQQ3ts
dKbRsFOstkyfn092DCUrVW6R3g9W43W7GC/h6XGOmUEDLLC8L2m6jA0v5ywu
OfpIUSHxKfEqBNozcSt5mjCGuC7WiEzsWkVcwcuFW+4pMfQLcgV1MUDcrxom
ZmmA0yLGxwc5ljZlYHMGfszElixs9bG03bLkkN+j75Y1PGWRqlwmdQWlKCpD
qBwl5S72qqhEVRWq2YnaMOrCaKDzN3lgozqUxmIv9tLfyWP2e4UjzNEk48ey
IQ7/NuaLQxT7NJmc8WqsOrlrSznFe47tMHki9Eud1RhQKai1y1aDV6BnHhxy
bUSJpi8Vvtir2nM9kvvb4HjQlzFckaikXrPU17FEzTvWnv2DYSk9ypJtNYna
loMdRHAXfeUeilcmucoWltj2whIUlTrNLitHeQUqKxHW35qsrUJ9pa1VWXKo
RvZDKMpQbZbHRko0W4zlS50R0q6m3buFodm9DM0eVmxSX47VKdl7rGQtEKVi
fi+27yt91dH3XG+Vd56o+cskV7k+5ySyGqJmlaj5q/BVxbwoQTIkDPo8SpNZ
TiZHBwU44phK3C9e93EcMXvhuwo37cHmdPyYgS2Z2Coccb09GzuoT7vZ0PR8
x1FWocznQ76+JL64FKVlKCtDRTmqKhCu0NiurhL1DOAaytBQgga1cvV5qMux
9MhIX9S6pWicHAjWBmu0IPbuPlbDHuNXL/j1iC07VqK1pVQiqROLrZOkRWab
ejoENXfpPmrAIE54KdI0ptRHDahFXgAnswIsKacPsbyYheoT/B3RxJwkO04G
ej7Iz4lHyLYs7KD27Mq1nLg6VWYBsgqQ456cSENRMULFKClBaSnKS1FZhir3
lqwBqK1AHW1ZQyn5CKGBOmf5yEZtpo6dhzZ6jGh0kKyK4imS3F+GVG6FPn05
TNXEoSej/ovpe+QhXb89+zaa3/eVn96QIvEeHx0yph1SK1YWF0PrfB2vOnk6
CRDdODADbLY54EjPt/yYji0Z2CrQc72dBOzMwa4c7M6ViAUZ+cjKR7YBn+Yr
vxAFRSgKodjAX4yyEsJfinCZ04baMtQx6qw3EXLIBMlqqQh9dXpcLSWm8ujX
Evb3TjoUGcYSf+KNZPUbhegimft7DNHW6BGpX9BMSfT8nV4zeQcLLHt0O8Uz
URqn9fFIgAbPjCF99Xq7iIGy3wR/ezSAvxto4a8+kugt6djKROrnDPyS4Wz/
zizsysZug71Gy5l5FnvoDEoUFiJUhOIQSkMoK0ZFCaroDqq5ruW6rthmhPWF
qjm1GajmjCbmKn2CuYpgn+rD/ko9Nk2sz9Pc+7JOMnbWeapWtJbwSbkPFLnP
fQZoA+Mtacc2FXpnRQTzAoU9pM+Fe1672pufN+hTh19ilLUiQnTZ8C17sJXh
wi8ZWoXckUl4s7A7G3vc2xqPtPiaJScfuUS5gBIeKkRJkUW4PIRKGv8wY/aa
EgdvXRHqCqJSbZu7R+1SSJyh0zgHtt+qyJ8n61cK3iIB1zHYFccsvxrgH1Jf
5vPA0FeEiGn5Xiy9sLhbYyVn5/wYJ9n+9JEUpFxF294/DP9Mk4g+eRfFOrHf
1fGkoz3st1LWfk7HL+nKn0M92/ktZOchh8Dn56OQwBcXoKQQZUWoMJCHCDmB
r+G6thC1ZEbC0VoqTnineNUo0F7W7Yt5oiMaV+roHpj73aQD5EM5W/Upj4PX
RMjpaKUWPFsHn5yf9eTcb1k2qsWRclXUwohcxEt7sXelMnW1XswaHMNIjH1w
Brb3TkrHgdP/HRnYmYldmfqsaEYOsnKRnYtcNqqAHIRIQ2kBygpRwdA0CeGQ
Gw+z+Of78M+08p7mwNcMLla+JVO/Skf3wKDzNkY19zPifEJzhFe1JCiPzb4r
z+WI9C2OzeVSP1OHKrbF8SOB53YGOLu9Y3P0xgI6kmyvbHVCwrlSX8UQ8bXv
IOL/QIz1aaYjIvqWCCvlZtlh7czOTCfrWVbW2YrfItOgnYMcgzaxK8hDUV4U
7fICVDI0CRPzaq5r+G2tYJ2Fmj1G1ikeP6U6zH0RCmKrrzoXT2KN63UI7z4W
vR/n4S8o8m9oDDNeyxzes619vJDyMxqar3Q+j76S0Eb7P/skHQxjZHQpX/No
eIKu1SiBPK5mEcy7BO3DffJtPyr6+A1+2YNtAnwmhVtBN0s611nZyDawUwjy
c1GYa2EvzkMJZb6CCFcVIFyoY74Ceo0J13lOTTqqd6r9KvzW9SZFrZw/zRKb
kwaf9MOzNUlXO+QO9wy7TBt9iuN2UgMczkFVSZAnchrIbPWsRPS3/jKgxPUb
OeEArI7/ohnyHi3OiuxLfdZvc8DoMlEWFWREGNC5uHxq4F/s6Ubct/MeHuq7
FfUMBT4nG7lsQUEOinIRykVJLkr9wOcjzA/VeQ70mmwFfReqthNMnY2a5LMt
PrxT4c0NoT13PPrNOmhlntHvBgzTZ9WgFaOZOrFjmc/KDPREHjTu32sW5Yk8
aGe8eoTYqvwYS2N5C0YrwREFwVjfxxScG5jk9tn/B3px4zaCr8GMVE4c+BkM
3rOzLP55xLPQ4J+DYuJflotyWpTKPFS5rKovqgm9FBCqdyNMOarY6j2l4tqS
7OfC712Jlxc1DtbhUJmNe6PP4kOtz/NqSd6MtT4zfBH8Cif3h0ksCa2xSrq2
RYUeno/VCl4uNOYp1OntUD95IB76BfCPf99c8Lka5lxH2U9OJRhfmsUYIkNJ
epalJFNZyeWHgmwUZiNkWMlBaY5lxVUZqrTSVp2NamP0PUp26Mz0IrVCkk70
UZnwWx2NdtIScyLfeS4BOjfwOf2un5gicDrnJDVFC3wz0o5eq++pglaA1msF
6EfVEXi+mG4BtEhSCsoXhg4LcBD0v8KJlf+UAPKJudHnm8gJQ+cdvLEQYqPP
LI8QV1fLyVROslBkOMlGSbbhRKTT6ohHSZiUVPOC1dYbu9i/Yos7QGKBCKf/
0kW41iQHKqYSYUokKvMLZaTnZh0ofYDrJ7TALSN0I3Rmh99oLVbtW8MZtl61
4ZvYAQlRFvgCUml7tjoJwnh4AP3g/IzeakifwBEDIvpkJv2zUpCRicxMV482
LOQR2ELDQhaKsywLZqkg+B4LJhq1ZTTDQbWL/u268ieXOZd8j8KvHcaBtqtk
2JqbaJIff08rjhbPIcvDtFbP8PMr+gC5WKsJvmnOkJlPDJXWavTj5WRireSN
pjHxqVhXgd+28MgE6P+D2bSo9xZ5/+8O2+t673xKc8g78C3yyMrUSlkuwSzI
RFEmQgZ66kN5ThR9V9MJZyKcodBbFy11E4T878mI7YX3pIIzTske/uK2vcm1
co9jbtMLPRRbdHiNH/xGabq+c9CbjimPdHgzMvt94zNKMi3Qi1VddpDOUClT
HYfUDgLPuP5aDvpGEj8/oxJojnZakGmISLJMHIKsDNftPMYThRmWimJqRFk2
KnKsv7ag5zo2DQ3hdFtFs/w4d42oFuiS6Nkr1QK/h0CACzLUd4gWnp/ysaBP
bR40llGqDLgtUBZWa8IgEzPlHuv0F3L8sarz0LvVdZvl2AOir9jq20SDlU39
PsmCm0I5z7DYZmc4e+7BGyLgpVkoz3ZiHpZRNOODiW2Yzara4bA1S7n3Brf8
L3rAV39hIDqW6RUbXGX3Xi1iPsmd/kfH3TjWBH4xk6H/Un6Wck/AwjtsPa6l
oCxhKZJ2yve/TcB/LKJ/iETfPulqZBkZHmrITtfIpCAdRQSvJBNlWdY6VDrY
NHeqCoD2Eyp+VJksZsaYZ0eMgs9YeJGvNzJ/pW/mvTwlIez5KzVPsJ8v+t56
wGMOHR+HnrxmTWzzxzo48pVkUHK/zQqgxCzbZf/vE3iQWOz+GNBwfb7H9NcC
mG7Ry0l3FcFCQlOcgdJMp9JqV1NsZGFhM2HebodlxU+e3KCUPjz/Sx4dRK+/
+tZUL9YTr+ZmRd3E3F8Wr+SC2OfkRygSh06iT4vOxKLsfaCyJwHfF1ructqw
2Qsv7B3/EGhfchxq/xTQWR9qxMt+zN2jddT0OHnL14pWFQsOVdtU/rw4zCwm
DMjjW4aDTydYi8GRhz7XUrJuZK31NkZeEhE+5MtRPPUcoePTE+l4/F5/Ja3e
B7EK6g2KWvdvPf0fA+1IisPlnx0OasNMD3MoM3m71f8W7QkIUIz8VBqPvDM5
HouidVZ4EF9P9N50d5jMJvYjcivjoDu5X3IEGYCUB/hfVfaPkjzaj4o4ghUK
jKd40Fo1NIv7wV3ln2mavHZF5Pk5qW7+a0BabB9kVAKFuykeGc6KG/FQjUq2
kYpFZKfW4yv0p+7LNqN4Awq/Ucnz48EM0Y6JeRGgH4i7WbYBfaLYo2f1sGG0
315JYRqTWLHmy6hIK2IVKWrEvREpe/S/7EdGgH+LRH+TPcamuI5lUSRyPQT0
XX5OWwwCYlTc90XrHKhBFLz62mHCvr/392lFxXNgYoGHeTUV6fU0nUQIWuFl
HBsKyMOnXluiGe2/JZQE6f/vIvFxlfYnWDVJjUpJqQvtrHCYpTrXphCuomcA
qfRjQi+lPsmPic2MeM5hHggP6usUPBw8S+GlaZAQVeKKJVSNeGGwqmGv/e90
Mt49Pd7pw3uM8vWj1Qt5osxWc8IZvl5V/IxK/rntko2ul8EKCDOQ30Frk97T
2I+qRfTS0eFx/ZRJi/J24gDjjHz+w3evKKdHKa7uIWevi3F9DDLcJ+L95mUl
dd2w6iTddvYX++f6W7bZ9TdY3fTunvIIzduTzDe88Yjh+iYleFPL5IoLWCy0
tRD7por/ZeXy17CVoCeupaX6a36Mh2wXTG+2WReHxPXaY9QWHPQEo3TJVROW
k/UN1MlRXuwVBx2g9Zox9PTsstYEzcXLd1kXJIu02mQm9tDgrITfaKsPlxf2
wJfe+dsLWpF5TC8EcFEge78TIn7bmLjdwdlawahDBKaCzZasoWq7/T9YsVXL
g0Nfklcocnk7tlYPfUfufFUDXvM4a4m8duqVFE2Nun0+X6Ka8A6eHaxZ/l6R
s1VsWUZzLW+BnEE9nCMTIO35/zsi8z3lXU0nBjBJc/I/MHAXzQn49H3MLaxN
/U93Tfkt2pN8PfFfO9hyG/9Y+/TvDg9ijJPd2cE8xcaI9l7/5u7FMU2c6o4O
5on/Erj3P7mzmM3jtIhvXoDvrAtcS37Ho/4z0vNvlmnmHqzQnOvuw9hOLFxc
NTLBHt/VgxW3s90V/7XXV0x1EhGspJ7mevc/e32l+HewBPXgJNe6Qb2+puZ2
wSsd5650Yq+v1D+AXNAS/ofr76kxbKpt9c/dpPoEzlY5O4vfnx/xVxdipdIe
9WcedWGgRcGY4R/d0Rfw6IsiUU33H3Wsa/fFPOriQDuD2cuR7pqX8/szIz1H
RN7v6gWuMNBd4Soee0ZiKUhg34OVjgGu3df28jremKl3hI0C+rnW3NTLq6i0
BzNMe43beriGejBPgu7jwlDrrv2c479vMHK4NwZ/teZPcO8nvvUlkZ5H9eQa
lybAO7Yt9/w/cdwlkViNuzcOC1njH/5/MGxH8Q==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 208},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1063171495]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->119237889],

Cell["Areas around where the data is nonreal are excluded:", "ExampleText",
 CellID->360827733],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{
   RowBox[{"ReplacePart", "[", 
    RowBox[{
     RowBox[{"Partition", "[", 
      RowBox[{
       RowBox[{"Range", "[", "100", "]"}], ",", "10"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "None"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"5", ",", "7"}], "}"}], "\[Rule]", "I"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"8", ",", "4"}], "}"}], "\[Rule]", 
        RowBox[{"Missing", "[", "\"\<NotAvailable\>\"", "]"}]}]}], "}"}]}], 
    "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->468454124],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJxt1c1OFEEUhuGKbnrZi170ohdNpUKIIQYFjQhIofjDrwgosISEtbdQl9aX
5CXo4ntNzhdIyJvzzJnuqcDMrDz8vnx8llK6//f7PPHzZ//ppvr03Jkz9+bM
gznzaM48mTPP5szZnLmY+8x5Vmuc6Zramb9Qe/N1dTB/qY7mG+pk/kqdzV+r
2XxTLeZbqv+d3tge/lbtzd+pg/m2Opq/VyfzHXU231Wz+Z5azD+o/n+2r3Iu
vNrz5a3aHj1QB9vHR9v/qE62j8+2/0nNto8X2z9U7f3TcM7L6/2sdtEb7u/L
Lzazj4/2+Fd1Nv+mZrsOXmz/SLX3f8M5F/c/VrvoDe9t/8Tux/6J7dFTdbJ9
fLb9MzXbPl5s/1y1z7WGc17u/13toje8t/0LdYhecft8bRdxpgs+2+M/1GzX
x0v0htvn9YJzXu5zqXbRKz5EX/Axerqy1811rmxPbXi26+MlerpW7fum4pxL
3vAu+oL30dNPdYhe8TF6w6foC+7fk79s5vp4id5w+x5dcM7L827ULnrF++gN
H6Iv+Bg93apT9IrP0Rue7fq3cf7fu/oXQjabTA==
   "], {
    {EdgeForm[GrayLevel[0.]], 
     GraphicsGroup3DBox[
      Polygon3DBox[{{1, 2, 12, 11}, {3, 4, 14, 13}, {2, 3, 13, 12}, {4, 5, 15,
        14}, {6, 7, 17, 16}, {5, 6, 16, 15}, {7, 8, 18, 17}, {8, 9, 19, 18}, {
       9, 10, 20, 19}, {14, 15, 24, 23}, {11, 12, 22, 21}, {15, 16, 25, 24}, {
       17, 18, 27, 26}, {16, 17, 26, 25}, {18, 19, 28, 27}, {19, 20, 29, 
       28}, {21, 22, 31, 30}, {23, 24, 34, 33}, {24, 25, 35, 34}, {25, 26, 36,
        35}, {26, 27, 37, 36}, {27, 28, 38, 37}, {28, 29, 39, 38}, {30, 31, 
       41, 40}, {42, 43, 52, 51}, {32, 33, 43, 42}, {33, 34, 44, 43}, {34, 35,
        45, 44}, {37, 38, 47, 46}, {38, 39, 48, 47}, {40, 41, 50, 49}, {41, 
       42, 51, 50}, {43, 44, 53, 52}, {31, 32, 42, 41}, {44, 45, 54, 53}, {76,
        77, 87, 86}, {49, 50, 60, 59}, {47, 48, 58, 57}, {50, 51, 61, 60}, {
       52, 53, 63, 62}, {51, 52, 62, 61}, {53, 54, 64, 63}, {54, 55, 65, 
       64}, {55, 56, 66, 65}, {57, 58, 68, 67}, {56, 57, 67, 66}, {59, 60, 70,
        69}, {63, 64, 73, 72}, {60, 61, 71, 70}, {64, 65, 74, 73}, {65, 66, 
       75, 74}, {66, 67, 76, 75}, {67, 68, 77, 76}, {69, 70, 79, 78}, {70, 71,
        80, 79}, {72, 73, 83, 82}, {73, 74, 84, 83}, {74, 75, 85, 84}, {75, 
       76, 86, 85}, {85, 86, 96, 95}, {78, 79, 89, 88}, {79, 80, 90, 89}, {80,
        81, 91, 90}, {81, 82, 92, 91}, {82, 83, 93, 92}, {83, 84, 94, 93}, {
       84, 85, 95, 94}, {46, 47, 57, 56}, {86, 87, 97, 96}}]]}, {}, {}, {}},
   VertexNormals->CompressedData["
1:eJxTTMoPSmViYGBIBGJmIHZZ3f6aPXLnfrFpmc8817/fD+XbjzRxVzRxVzLV
D5T4QIXPYPPXQMUjtcwfbPFC6/AfKultsMXjUAm3oZ5ORuNxZIoDACnKxmE=

    "]],
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{1., 10.}, {1., 10.}, {0., 100.}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->260148533,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzVXNmuHDUQ7fQy6703ZLtLws1C2DclLAmEnYgExCZ44AEJpBCNFB4QiOSR
b+Aj5hvywseNoG1Xud3H5S73wAsj3ZnpxfapqlPlcrXnfnnv0YPVL/ce/Xz/
3uW7v9/77cHP9x9evvPr7+2p6kRRFI/bvz8Pi/b73+03+/d4s9m0F6L3h+17
1d5Qtp9l+3nLnn1k3uv2cGNfdL2oujM3/xf3PSSpqp50TvI/oMWb9uyPdOcR
6aWoVquVu4nu+CEae5/alNTmRuK+M3S95itt1+5Kf+zTdN/MIvQ3FW8k+t2j
+5dwv5Ha3PhKot0Ojbdnr7h27koV6KbwPTC+hdeNu2zeF3StmLRfPIS4N/P1
ZXv6QTC61d76L3cXtUaL4vFLtpcVybjDuoVe7NiNb9WT5y6NfJ4+d1nvto9O
H1WkOdf+jsiEKkCzND11mm1fBsqridbMD9TXhGTcZVyk2RruS6E6FchXhjpq
P83XBfTbiPa6Q+hOgoyTVG/ms33Jvd2Fs8xF7nUBvc6FXktviU/paC4wc0bn
dqUea9ej63QCmF60nXxDfS/ZOtDPEo5nmf1+RVZlz0E9iv02vl/SA/b9gu37
NTh7ADLMlbGmybFMLy+KY5xlyzE/csaYONa5lxsmZHXhR7tG2uLYiD5S0/lS
GRWPjS9YxkTSTmGE5zyOEB37Fkvd5Ixf+2MavQrYbb56KWhs9CGMhVcsmuub
LqKyJcoMay8JxURBUXP8GBx9BzSCPEDPNryuw6hL56sBHVgXb/+eEpk4ZZYn
OIEIUpzAONkoCNk/wujjEN6C+KSxZCGyZKrgqdeCxupOY0Vx1X67QL50KETL
JhEhJJ35GQ50p2GqPZInwaacSXHMzokhTgLntOYd26BvNYAozBA6JA7fMTDr
dEJjZRHPC6gxPDY4pNkYZdTw4wzgGHcRznJMYM0iA0WfUBmIWEvAOlGwXhGx
cgTZhpcLiiaajyNStsaUxu48pZ9L8QzKMSaHoV3uBvc1oX7NTMiRByMv6u2y
9x6OtKgvng/HsjIV+0R9TgA/tUWG4kx6ycJ8JtBkKXBLQ5rDx1DLhV0TFCGH
Etp1+K4OaDWHhVJ0TN1nzUTJrYTO4HA2v0wIeE2gza6TdRwhtZyI24TzplHd
EpChXY+9N6Peqs1GZJWmxyrBRk2v3K4ZKQFXQY6899temKkjGGoUYGeyDD9q
QkYRCxAps6CMItKh/ThKaL3MYOGMtJWTqVUQyyStzgKtFkVcm9m35/dBu0MM
RZ40AkNT2pWiG0ZF079Zsu2AJNMsSZ4IbFOTCaQ5VmR7NMfK62mtlZQbmulN
8+EZYXaMN2v7Yh6yy79zPSWD0xzVcnNIPF8S9omC3TDH+M75Dvskxu5s5kK/
5rVrin45kbU3s1M1z73mgJtXOIvAdwv7OuyQN4i8zMCOGvbxkk01xKGMODsj
S6DHVyQRZveh55uvh4OWQZRDfOF4Oh0r2YBviLlR51nGe0K2BzJ2c0RKtkaR
jWPpUpFnvg4yib7Xg4eEnhdmtphPoI0OohgWXtVsxBH1pHJfMg+pPavaVzJ7
aXwrYuACpJqLkfkMSTVR0JmIw5X34VhbC3GdvQQjRhne3+OVhv6cRy/mqYEU
pttzAmop/g7xvub7ozWJxB+jqwMRI/onR9MDOM/RcyeL173MQ9dklx8R1lM9
NswAC0c/rOfsJ+6T1kaVwF6fbUisUvW8CDRbCJ65J+o/lM3HzAG5onsC+9iJ
ZyA21YJnyevaFIdcmAyCp41DsVRzGAX7O7eRM92KpJDWHTnRV6tnxDO6Y9pp
wL9Q8CPTQhxGf2X7hhbi2IiRV2YXZ8wcfxmVFPP3vAxczx2D3Vw3eKWKS5WK
sZLOnUKLXo1M0LtT/ROi3jXsGDknnvVrP0sZfEadQzZinENc4ToHr9DSbBmr
cc6XkeUcY4+E/rp4p7A7OHY65soXry75c2+ErpnTuJKIIiy1xdmjJslw/Zfl
r8Gx9R050sbsGpDNPrmFDCAVfQ+4d++fUo4q1SdTGUMXN4fmDM83YXY+Tfhx
pmIG4crrYCM/pdVq1aj/vSzUGDE4kiBLdkgKnJOGVv1DLMupGYftlyDdrsXP
c52VSlzlGfm6J2DdHTOSB2cP8zVZJUjIso2lvFe7rCLaRYF2OgNjipVMs5pM
sAdlwDinPRlBPqA9eH8OV/lcIJ4H9pFmQ2QfSlWSlZZkxaw6VqaV8GkaM39X
kCzeD2W2gp0wn/bUKWgjWqtXx+BnHci15Dp9rN0K9+rt/gls522UIZm59yyM
yzlsatdDspoyZJ0ocqsMlP0m3r3WzTJ0HrMTzmalJ+Nhbjco27q/opJyg66y
k37WvSPLkCFVyI4ot6V7erUlzVoBwl5OkLCiVInQnqTP2bej9UrMRq6k7FNc
SK3GteNeVhDKotYjNNstCFmYvVWirTgv8DFxHVQSRjIulUvsk26laoW2H6T2
2LrdejNRkpObIDeIfFh7LpWqemkZhYmxxv2xMoSyIWfLEK0qm93XZ+rOG8gj
MqSxRhRiPMb0Pepb80rRar1ZZQEy2YqRtY/f/2cyaSEuaeyqirgCgBbJnQs0
Cy2TUkgZHK4fNAtF+wAS96GVxjwVjne87WbJ1JBMyWxvBMuSbWis1HPjnL01
tirvkwwHYidLQvY+nDlGcy44bjL8UnwOxlGWngsjD2VvcmV7foX5brhP3cSM
Cwozo1l1hD/Wgm5S+3UakZGylyUyDdIKSxzU5doOLg7Y0rYo4jW4JiPX97U9
NtKzEP/Mv7dT+L+Q10XZSyAvc1XDNoqraiYixxmZs5lS9rJp494oKVtlLGO5
FpK7Z0di/LA1J2PkhHgU9nNMUT6Lr5GNxuY6zFacU2J50a7byltBP36XaAKh
xFUpDxK5r3JYHm3lf4kgSx1WebFSaivBbYNjJfZKGXEjMFSyoJRRSzsY+hac
i7Lsw1ltzoj1mpNjS3O4n/0oUGuSo21keQ7g7PkMfmXn1aP5lJa7k2MmynGo
yIF4uWo+tk6Qw6WhWLPyvyyainIckT+ouUgRZ5A5mXR2VQ78B9mEVnDFgAtw
9hCk4Exom/V/duUNpMW5z0uSsIOT5ElFEn46s20umJN79KRJaqCTBFfITpJj
QZJmC/b47FeJECmvEX/DpaK/CGe1dYgkRcMRhPrQ9vGo1bQE49AejSjRJfJw
ZJSmf78Tmaobmi8YqbVduh5xTzOI+AqcxZo2IsdjzkLDPrSaxpgMNPp9aiTB
U3AWq8kpzhpd43PC1Mpn7JxubFOCVlD/bul6VUGvzW2GkZLE2Xmh4Av+uUVC
7w7508R1jTFVmBskpNymzhr5wSr4JXSE9lk4i1WdaPai++yzltFrC3Wv7Sr8
7TdifU7Bqq78AuxV7ozck7EZknEQ+/MCdmkNh8+A8ZlWDuZkvtZ4lBu3dnb5
1wvEWNRnMjpviS07F6M1voPa4XwJdIhRKhmTM2MI7ujJzsBqr1eu2btfuf8L
rJpuUzmVGB0ifboZ4hXAqFWpzTE/2cqZHZJPRwaO/Q4pV8YipK8SQzUtcqQO
d7lJs4CUJ+Tm1jhfuYX+NTiLu/JmNCruSEI7j1njh1xlZLVn4HVAhPuzmrX8
PC5E5HseaUlmJz+jszUS+p12GpE0EvoF75UZu5YoAZHb1/K6gEj6xTyi2CUU
GsNTmbmxkBnW7i2x/9elZEwj4i//dmds3ZqZPCVduN3mN0AXmK1qEavexPtf
xqx5OeIyKvf7ipv/AhX3mFfR64654slIjm1fbwES3Dss9SIxVa+W2RyVxna/
kH6bGKJJ3wic1NZYvsJDnHzGjvgOSIt70Fg6TZdShG5oNCOfzYuKd2E0XOul
Mrsc2cxoCxrN/e+Z94TRBnOxlLbZwtS7nQOK98lWqDGtt/CY4y737P7z04eA
G39roY3g15fUq2V08dE2vUZ85ef21pLFxyP79M8YCNkHtpfbpEmtNbNjl1rf
tq0/AQz4i6wZtLL/kcj996SBViUh5Vaf21Z3oZXPEQr3MnMK70D52rb4FFrg
6oz7/9be/RlpAu9iL/rO3mWxdP9tijRnTnxvr38RtDbYKrr6o736ZfvetEc/
2aPixD+lhdv2\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "=", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]}], ",", 
      RowBox[{"y", "=", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]}], ",", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"1", "-", 
        RowBox[{"x", "^", "2"}], "-", 
        RowBox[{"y", "^", "2"}]}], "]"}]}], "}"}], ",", 
    RowBox[{"{", "1000", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->564735941],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->257118139]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1484798803],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["MaxPlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxPlotPoints"]], "InlineFormula"],
 " to limit the number of points used:"
}], "ExampleText",
 CellID->694407743],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", " ", "y"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "3", ",", "0.075"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "3", ",", "0.075"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->54254729],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListPlot3D", "[", 
    RowBox[{"data", ",", 
     RowBox[{"MaxPlotPoints", "\[Rule]", "mp"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"mp", ",", 
     RowBox[{"{", 
      RowBox[{"Infinity", ",", "25", ",", "10"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->35106720],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{487, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->91105762]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->226160967],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " is selected automatically: "
}], "ExampleText",
 CellID->76854780],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "2"}], ",", "2", ",", 
      RowBox[{"4", "/", "51"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "2"}], ",", "2", ",", 
      RowBox[{"4", "/", "51"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->501375403],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->648983689]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " to focus in on areas of interest: "
}], "ExampleText",
 CellID->316263374],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListPlot3D", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "4"}], "+", 
       RowBox[{"y", "^", "4"}], "-", 
       RowBox[{"x", "^", "2"}], "-", 
       RowBox[{"y", "^", "2"}], "+", "1"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "2"}], ",", "2", ",", "0.1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "2"}], ",", "2", ",", "0.1"}], "}"}]}], "]"}], "]"}], 
   ",", 
   RowBox[{"ListPlot3D", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "4"}], "+", 
        RowBox[{"y", "^", "4"}], "-", 
        RowBox[{"x", "^", "2"}], "-", 
        RowBox[{"y", "^", "2"}], "+", "1"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "2", ",", "0.1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "2"}], ",", "2", ",", "0.1"}], "}"}]}], "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}]}], ",", 
     RowBox[{"ClippingStyle", "\[Rule]", "None"}]}], "]"}]}], "}"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->41344862],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->518126281]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->428308280],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["RegionFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionFunction"]], "InlineFormula"],
 " to restrict the surface to a region given by inequalities:"
}], "ExampleText",
 CellID->272043783],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"data", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{
             RowBox[{"x", "^", "2"}], "+", 
             RowBox[{"y", "^", "2"}]}], "]"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"x", "^", "2"}], "+", 
             RowBox[{"y", "^", "2"}]}], ")"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "4"}], ",", "4", ",", "0.2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "4"}], ",", "4", ",", "0.2"}], "}"}]}], "]"}], ",", 
      "1"}], "]"}]}], ";"}], "//", "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1147823540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{"data", ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"RegionFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{
       RowBox[{"Norm", "[", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], "]"}], "<", "4"}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5386680],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->224888369]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Presentation",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1630514962],

Cell[TextData[{
 "Provide an explicit ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " for the surface:"
}], "ExampleText",
 CellID->157416703],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"-", "3"}], ",", "3", ",", "0.05"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", 
       RowBox[{"-", "3"}], ",", "3", ",", "0.05"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Orange", ",", 
      RowBox[{"Specularity", "[", 
       RowBox[{"White", ",", "20"}], "]"}]}], "]"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->254754736],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->308681981]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->77456497],

Cell["Provide separate styles for different surfaces:", "ExampleText",
 CellID->1298077331],

Cell[BoxData[
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "-", 
       RowBox[{"x", "^", "2"}], "-", 
       RowBox[{"y", "^", "2"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0.05"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0.05"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5012897],

Cell[BoxData[
 RowBox[{
  RowBox[{"data2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"1", "-", 
        RowBox[{"x", "^", "2"}], "-", 
        RowBox[{"y", "^", "2"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0.05"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0.05"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->499897646],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"data1", ",", "data2"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Yellow", ",", "Cyan"}], "}"}]}], ",", 
   RowBox[{"BoxRatios", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->499332244],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->388991646]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18985160],

Cell["Add labels:", "ExampleText",
 CellID->400933500],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"i", "+", 
       RowBox[{"j", "^", "2"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "3", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "3", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"j", ",", "i"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"Sin", "[", 
     RowBox[{"i", "+", 
      RowBox[{"j", "^", "2"}]}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Purple"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1833133861],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 162},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5508029]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->324506061],

Cell["Color the surface by height:", "ExampleText",
 CellID->2000753416],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"i", "+", 
       RowBox[{"j", "^", "2"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "3", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "3", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"Hue", "[", "z", "]"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1363717986],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->763460656]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2111548574],

Cell["Provide overlay meshes:", "ExampleText",
 CellID->1629616543],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"i", "+", 
       RowBox[{"j", "^", "2"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "3", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "3", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "8"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<SolarColors\>\""}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "z"}], "]"}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2106288010],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->124001499]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16000128],

Cell["Style the areas between mesh lines:", "ExampleText",
 CellID->418097482],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"i", "+", 
       RowBox[{"j", "^", "2"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "3", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "3", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "8"}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Blue", ",", "Green"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Cyan", ",", "Purple"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->770854980],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->663417442]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->468410419],

Cell[TextData[{
 "Provide an interactive ",
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 " for a surface:"
}], "ExampleText",
 CellID->581641354],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{
   RowBox[{"Tooltip", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"i", "+", 
         RowBox[{"j", "^", "2"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", "3", ",", "0.1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "0", ",", "3", ",", "0.1"}], "}"}]}], "]"}], ",", 
     RowBox[{"TraditionalForm", "@", 
      RowBox[{"Sin", "[", 
       RowBox[{"i", "+", 
        RowBox[{"j", "^", "2"}]}], "]"}]}]}], "]"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Darker", "[", "Green", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->300675534],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJxdnXdcE9vTxsECEVuQqKioIWLAGGMgtAQIY++KvSsiXnvvHRUrWLGLir1h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   "], {{
     {RGBColor[0, 
       NCache[
        Rational[2, 3], 0.6666666666666666], 0], EdgeForm[None], 
      GraphicsGroup3DBox[
       TagBox[
        TooltipBox[Polygon3DBox[CompressedData["
1:eJxN3QnYdtX0P/D7fZ5zvyeVDFEhNM9pnpWopMwkJGmepHk2NvyKzIRQmiVp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          "]],
         TagBox[
          FormBox[
           RowBox[{"sin", "(", 
             RowBox[{
               SuperscriptBox["j", "2"], "+", "i"}], ")"}], TraditionalForm], 
          TraditionalForm, Editable -> True]],
        Annotation[#, 
         TraditionalForm[
          Sin[$CellContext`i + $CellContext`j^2]], 
         "Tooltip"]& ]]}, {}, {}, {}}, {
     Line3DBox[{2, 1, 32, 1397, 63, 94, 1428, 125, 156, 1459, 187, 218, 1490, 
      249, 280, 1521, 311, 342, 1552, 373, 404, 1583, 435, 466, 497, 1614, 
      528, 559, 1645, 590, 621, 1676, 652, 683, 1707, 714, 745, 1738, 776, 
      807, 1769, 838, 869, 1800, 900, 931, 932, 1382, 933, 934, 1383, 935, 
      936, 1384, 937, 938, 1385, 939, 940, 1386, 941, 942, 1387, 943, 944, 
      1388, 945, 946, 947, 1389, 948, 949, 1390, 950, 951, 1391, 952, 953, 
      1392, 954, 955, 1393, 956, 957, 1394, 958, 959, 1395, 960, 961, 930, 
      1829, 899, 868, 1798, 837, 806, 1767, 775, 744, 1736, 713, 682, 1705, 
      651, 620, 1674, 589, 558, 1643, 527, 496, 465, 1612, 434, 403, 1581, 
      372, 341, 1550, 310, 279, 1519, 248, 217, 1488, 186, 155, 1457, 124, 93,
       1426, 62, 31, 30, 988, 29, 28, 986, 27, 26, 984, 25, 24, 982, 23, 22, 
      980, 21, 20, 978, 19, 18, 976, 17, 16, 15, 974, 14, 13, 972, 12, 11, 
      970, 10, 9, 968, 8, 7, 966, 6, 5, 964, 4, 3, 962, 2}], {
      Line3DBox[{1397, 1396, 1830, 1398, 1399, 1831, 1400, 1401, 1832, 1402, 
       1403, 1833, 1404, 1405, 1834, 1406, 1407, 1835, 1408, 1409, 1836, 1410,
        1411, 1412, 1837, 1413, 1414, 1838, 1415, 1416, 1839, 1417, 1418, 
       1840, 1419, 1420, 1841, 1421, 1422, 1842, 1423, 1424, 1843, 1425, 
       1426}], Line3DBox[{1428, 1427, 1844, 1429, 1430, 1845, 1431, 1432, 
       1846, 1433, 1434, 1847, 1435, 1436, 1848, 1437, 1438, 1849, 1439, 1440,
        1850, 1441, 1442, 1443, 1851, 1444, 1445, 1852, 1446, 1447, 1853, 
       1448, 1449, 1854, 1450, 1451, 1855, 1452, 1453, 1856, 1454, 1455, 1857,
        1456, 1457}], 
      Line3DBox[{1459, 1458, 1858, 1460, 1461, 1859, 1462, 1463, 1860, 1464, 
       1465, 1861, 1466, 1467, 1862, 1468, 1469, 1863, 1470, 1471, 1864, 1472,
        1473, 1474, 1865, 1475, 1476, 1866, 1477, 1478, 1867, 1479, 1480, 
       1868, 1481, 1482, 1869, 1483, 1484, 1870, 1485, 1486, 1871, 1487, 
       1488}], 
      Line3DBox[{1490, 1489, 1872, 1491, 1492, 1873, 1493, 1494, 1874, 1495, 
       1496, 1875, 1497, 1498, 1876, 1499, 1500, 1877, 1501, 1502, 1878, 1503,
        1504, 1505, 1879, 1506, 1507, 1880, 1508, 1509, 1881, 1510, 1511, 
       1882, 1512, 1513, 1883, 1514, 1515, 1884, 1516, 1517, 1885, 1518, 
       1519}], Line3DBox[{1521, 1520, 1886, 1522, 1523, 1887, 1524, 1525, 
       1888, 1526, 1527, 1889, 1528, 1529, 1890, 1530, 1531, 1891, 1532, 1533,
        1892, 1534, 1535, 1536, 1893, 1537, 1538, 1894, 1539, 1540, 1895, 
       1541, 1542, 1896, 1543, 1544, 1897, 1545, 1546, 1898, 1547, 1548, 1899,
        1549, 1550}], 
      Line3DBox[{1552, 1551, 1900, 1553, 1554, 1901, 1555, 1556, 1902, 1557, 
       1558, 1903, 1559, 1560, 1904, 1561, 1562, 1905, 1563, 1564, 1906, 1565,
        1566, 1567, 1907, 1568, 1569, 1908, 1570, 1571, 1909, 1572, 1573, 
       1910, 1574, 1575, 1911, 1576, 1577, 1912, 1578, 1579, 1913, 1580, 
       1581}], Line3DBox[{1583, 1582, 1914, 1584, 1585, 1915, 1586, 1587, 
       1916, 1588, 1589, 1917, 1590, 1591, 1918, 1592, 1593, 1919, 1594, 1595,
        1920, 1596, 1597, 1598, 1921, 1599, 1600, 1922, 1601, 1602, 1923, 
       1603, 1604, 1924, 1605, 1606, 1925, 1607, 1608, 1926, 1609, 1610, 1927,
        1611, 1612}], 
      Line3DBox[{466, 467, 1172, 468, 469, 1173, 470, 471, 1174, 472, 473, 
       1175, 474, 475, 1176, 476, 477, 1177, 478, 479, 1178, 480, 481, 482, 
       1179, 483, 484, 1180, 485, 486, 1181, 487, 488, 1182, 489, 490, 1183, 
       491, 492, 1184, 493, 494, 1185, 495, 496}], 
      Line3DBox[{1614, 1613, 1928, 1615, 1616, 1929, 1617, 1618, 1930, 1619, 
       1620, 1931, 1621, 1622, 1932, 1623, 1624, 1933, 1625, 1626, 1934, 1627,
        1628, 1629, 1935, 1630, 1631, 1936, 1632, 1633, 1937, 1634, 1635, 
       1938, 1636, 1637, 1939, 1638, 1639, 1940, 1640, 1641, 1941, 1642, 
       1643}], Line3DBox[{1645, 1644, 1942, 1646, 1647, 1943, 1648, 1649, 
       1944, 1650, 1651, 1945, 1652, 1653, 1946, 1654, 1655, 1947, 1656, 1657,
        1948, 1658, 1659, 1660, 1949, 1661, 1662, 1950, 1663, 1664, 1951, 
       1665, 1666, 1952, 1667, 1668, 1953, 1669, 1670, 1954, 1671, 1672, 1955,
        1673, 1674}], 
      Line3DBox[{1676, 1675, 1956, 1677, 1678, 1957, 1679, 1680, 1958, 1681, 
       1682, 1959, 1683, 1684, 1960, 1685, 1686, 1961, 1687, 1688, 1962, 1689,
        1690, 1691, 1963, 1692, 1693, 1964, 1694, 1695, 1965, 1696, 1697, 
       1966, 1698, 1699, 1967, 1700, 1701, 1968, 1702, 1703, 1969, 1704, 
       1705}], Line3DBox[{1707, 1706, 1970, 1708, 1709, 1971, 1710, 1711, 
       1972, 1712, 1713, 1973, 1714, 1715, 1974, 1716, 1717, 1975, 1718, 1719,
        1976, 1720, 1721, 1722, 1977, 1723, 1724, 1978, 1725, 1726, 1979, 
       1727, 1728, 1980, 1729, 1730, 1981, 1731, 1732, 1982, 1733, 1734, 1983,
        1735, 1736}], 
      Line3DBox[{1738, 1737, 1984, 1739, 1740, 1985, 1741, 1742, 1986, 1743, 
       1744, 1987, 1745, 1746, 1988, 1747, 1748, 1989, 1749, 1750, 1990, 1751,
        1752, 1753, 1991, 1754, 1755, 1992, 1756, 1757, 1993, 1758, 1759, 
       1994, 1760, 1761, 1995, 1762, 1763, 1996, 1764, 1765, 1997, 1766, 
       1767}], Line3DBox[{1769, 1768, 1998, 1770, 1771, 1999, 1772, 1773, 
       2000, 1774, 1775, 2001, 1776, 1777, 2002, 1778, 1779, 2003, 1780, 1781,
        2004, 1782, 1783, 1784, 2005, 1785, 1786, 2006, 1787, 1788, 2007, 
       1789, 1790, 2008, 1791, 1792, 2009, 1793, 1794, 2010, 1795, 1796, 2011,
        1797, 1798}], 
      Line3DBox[{1800, 1799, 2012, 1801, 1802, 2013, 1803, 1804, 2014, 1805, 
       1806, 2015, 1807, 1808, 2016, 1809, 1810, 2017, 1811, 1812, 2018, 1813,
        1814, 1815, 2019, 1816, 1817, 2020, 1818, 1819, 2021, 1820, 1821, 
       2022, 1822, 1823, 2023, 1824, 1825, 2024, 1826, 1827, 2025, 1828, 
       1829}]}, {
      Line3DBox[{962, 963, 1830, 990, 1004, 1844, 1018, 1032, 1858, 1046, 
       1060, 1872, 1074, 1088, 1886, 1102, 1116, 1900, 1130, 1144, 1914, 1158,
        1172, 1186, 1928, 1200, 1214, 1942, 1228, 1242, 1956, 1256, 1270, 
       1970, 1284, 1298, 1984, 1312, 1326, 1998, 1340, 1354, 2012, 1368, 
       1382}], Line3DBox[{964, 965, 1831, 991, 1005, 1845, 1019, 1033, 1859, 
       1047, 1061, 1873, 1075, 1089, 1887, 1103, 1117, 1901, 1131, 1145, 1915,
        1159, 1173, 1187, 1929, 1201, 1215, 1943, 1229, 1243, 1957, 1257, 
       1271, 1971, 1285, 1299, 1985, 1313, 1327, 1999, 1341, 1355, 2013, 1369,
        1383}], 
      Line3DBox[{966, 967, 1832, 992, 1006, 1846, 1020, 1034, 1860, 1048, 
       1062, 1874, 1076, 1090, 1888, 1104, 1118, 1902, 1132, 1146, 1916, 1160,
        1174, 1188, 1930, 1202, 1216, 1944, 1230, 1244, 1958, 1258, 1272, 
       1972, 1286, 1300, 1986, 1314, 1328, 2000, 1342, 1356, 2014, 1370, 
       1384}], Line3DBox[{968, 969, 1833, 993, 1007, 1847, 1021, 1035, 1861, 
       1049, 1063, 1875, 1077, 1091, 1889, 1105, 1119, 1903, 1133, 1147, 1917,
        1161, 1175, 1189, 1931, 1203, 1217, 1945, 1231, 1245, 1959, 1259, 
       1273, 1973, 1287, 1301, 1987, 1315, 1329, 2001, 1343, 1357, 2015, 1371,
        1385}], 
      Line3DBox[{970, 971, 1834, 994, 1008, 1848, 1022, 1036, 1862, 1050, 
       1064, 1876, 1078, 1092, 1890, 1106, 1120, 1904, 1134, 1148, 1918, 1162,
        1176, 1190, 1932, 1204, 1218, 1946, 1232, 1246, 1960, 1260, 1274, 
       1974, 1288, 1302, 1988, 1316, 1330, 2002, 1344, 1358, 2016, 1372, 
       1386}], Line3DBox[{972, 973, 1835, 995, 1009, 1849, 1023, 1037, 1863, 
       1051, 1065, 1877, 1079, 1093, 1891, 1107, 1121, 1905, 1135, 1149, 1919,
        1163, 1177, 1191, 1933, 1205, 1219, 1947, 1233, 1247, 1961, 1261, 
       1275, 1975, 1289, 1303, 1989, 1317, 1331, 2003, 1345, 1359, 2017, 1373,
        1387}], 
      Line3DBox[{974, 975, 1836, 996, 1010, 1850, 1024, 1038, 1864, 1052, 
       1066, 1878, 1080, 1094, 1892, 1108, 1122, 1906, 1136, 1150, 1920, 1164,
        1178, 1192, 1934, 1206, 1220, 1948, 1234, 1248, 1962, 1262, 1276, 
       1976, 1290, 1304, 1990, 1318, 1332, 2004, 1346, 1360, 2018, 1374, 
       1388}], Line3DBox[{16, 47, 1411, 78, 109, 1442, 140, 171, 1473, 202, 
       233, 1504, 264, 295, 1535, 326, 357, 1566, 388, 419, 1597, 450, 481, 
       512, 1628, 543, 574, 1659, 605, 636, 1690, 667, 698, 1721, 729, 760, 
       1752, 791, 822, 1783, 853, 884, 1814, 915, 946}], 
      Line3DBox[{976, 977, 1837, 997, 1011, 1851, 1025, 1039, 1865, 1053, 
       1067, 1879, 1081, 1095, 1893, 1109, 1123, 1907, 1137, 1151, 1921, 1165,
        1179, 1193, 1935, 1207, 1221, 1949, 1235, 1249, 1963, 1263, 1277, 
       1977, 1291, 1305, 1991, 1319, 1333, 2005, 1347, 1361, 2019, 1375, 
       1389}], Line3DBox[{978, 979, 1838, 998, 1012, 1852, 1026, 1040, 1866, 
       1054, 1068, 1880, 1082, 1096, 1894, 1110, 1124, 1908, 1138, 1152, 1922,
        1166, 1180, 1194, 1936, 1208, 1222, 1950, 1236, 1250, 1964, 1264, 
       1278, 1978, 1292, 1306, 1992, 1320, 1334, 2006, 1348, 1362, 2020, 1376,
        1390}], 
      Line3DBox[{980, 981, 1839, 999, 1013, 1853, 1027, 1041, 1867, 1055, 
       1069, 1881, 1083, 1097, 1895, 1111, 1125, 1909, 1139, 1153, 1923, 1167,
        1181, 1195, 1937, 1209, 1223, 1951, 1237, 1251, 1965, 1265, 1279, 
       1979, 1293, 1307, 1993, 1321, 1335, 2007, 1349, 1363, 2021, 1377, 
       1391}], Line3DBox[{982, 983, 1840, 1000, 1014, 1854, 1028, 1042, 1868, 
       1056, 1070, 1882, 1084, 1098, 1896, 1112, 1126, 1910, 1140, 1154, 1924,
        1168, 1182, 1196, 1938, 1210, 1224, 1952, 1238, 1252, 1966, 1266, 
       1280, 1980, 1294, 1308, 1994, 1322, 1336, 2008, 1350, 1364, 2022, 1378,
        1392}], 
      Line3DBox[{984, 985, 1841, 1001, 1015, 1855, 1029, 1043, 1869, 1057, 
       1071, 1883, 1085, 1099, 1897, 1113, 1127, 1911, 1141, 1155, 1925, 1169,
        1183, 1197, 1939, 1211, 1225, 1953, 1239, 1253, 1967, 1267, 1281, 
       1981, 1295, 1309, 1995, 1323, 1337, 2009, 1351, 1365, 2023, 1379, 
       1393}], Line3DBox[{986, 987, 1842, 1002, 1016, 1856, 1030, 1044, 1870, 
       1058, 1072, 1884, 1086, 1100, 1898, 1114, 1128, 1912, 1142, 1156, 1926,
        1170, 1184, 1198, 1940, 1212, 1226, 1954, 1240, 1254, 1968, 1268, 
       1282, 1982, 1296, 1310, 1996, 1324, 1338, 2010, 1352, 1366, 2024, 1380,
        1394}], 
      Line3DBox[{988, 989, 1843, 1003, 1017, 1857, 1031, 1045, 1871, 1059, 
       1073, 1885, 1087, 1101, 1899, 1115, 1129, 1913, 1143, 1157, 1927, 1171,
        1185, 1199, 1941, 1213, 1227, 1955, 1241, 1255, 1969, 1269, 1283, 
       1983, 1297, 1311, 1997, 1325, 1339, 2011, 1353, 1367, 2025, 1381, 
       1395}]}, {}, {}}},
   VertexNormals->CompressedData["
1:eJwUm3c8lW8Yxsko0Q6JyMgoSWS1biEVychokJFEZZZIooxQ9ix7y15n2I8t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    "]],
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{1., 31.}, {1., 31.}, {-0.999997146387718, 0.9999920733059188}},
  
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->182195754]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->763626859],

Cell["Fill below a surface:", "ExampleText",
 CellID->914344741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"i", "+", 
       RowBox[{"j", "^", "2"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "3", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "3", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Bottom"}], ",", 
   RowBox[{"FillingStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"Opacity", "[", "0.6", "]"}], ",", "Blue"}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2146567702],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->330982613]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(60)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->110299102],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BoundaryStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->156755312],

Cell["Use a black boundary around the edges of the surface:", "ExampleText",
 CellID->1681439957],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "Pi", ",", "0.1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "0", ",", "Pi", ",", "0.1"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1224046426],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->540052966]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->80311887],

Cell["Use a thick boundary around the edges of the surface:", "ExampleText",
 CellID->989104801],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "Pi", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "Pi", ",", "0.1"}], "}"}]}], "]"}], ",", 
   " ", 
   RowBox[{"BoundaryStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->213478980],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8629040]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->271347385],

Cell["Use a thick red boundary around the edges of the surface:", \
"ExampleText",
 CellID->729894026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "Pi", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "Pi", ",", "0.1"}], "}"}]}], "]"}], ",", 
   " ", 
   RowBox[{"BoundaryStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Red", ",", "Thick"}], "]"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->902303318],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->281027830]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->449715931],

Cell["Do not use any boundary:", "ExampleText",
 CellID->676537931],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "Pi", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "Pi", ",", "0.1"}], "}"}]}], "]"}], ",", 
   " ", 
   RowBox[{"BoundaryStyle", "\[Rule]", "None"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "5"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1794579099],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->230335838]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21889664],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BoundaryStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BoundaryStyle"]], "InlineFormula"],
 " applies to holes cut by ",
 Cell[BoxData[
  ButtonBox["RegionFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1081074962],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "Pi", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "Pi", ",", "0.1"}], "}"}]}], "]"}], ",", 
   " ", 
   RowBox[{"BoundaryStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"RegionFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{
       RowBox[{"Abs", "[", "z", "]"}], "\[GreaterEqual]", "0.25"}]}], "]"}]}],
    ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->653624081],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12481653]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->174337180],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BoundaryStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BoundaryStyle"]], "InlineFormula"],
 " applies where there are jumps in the surface:"
}], "ExampleText",
 CellID->683839315],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10", ",", "10", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "8", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "9", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "6", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "4", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "6", ",", "8"}], "}"}]}], "}"}], ",", 
   RowBox[{"InterpolationOrder", "\[Rule]", "0"}], ",", 
   RowBox[{"BoundaryStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->400495622],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[{{9., 8., 1.}, {7.642857142857143, 6.285714285714286, 
   10.}, {8., 7., 10.}, {6.1, 5.9, 10.}, {8., 7., 9.}, {9., 8., 9.}, {
   3.9285714285714284`, 2.642857142857143, 2.}, {6.1, 5.9, 4.}, {
   3.9285714285714284`, 2.642857142857143, 4.}, {7.642857142857143, 
   6.285714285714286, 9.}, {6.1, 5.9, 9.}, {3.9285714285714284`, 
   2.642857142857143, 9.}, {8., 7., 8.}, {7.642857142857143, 
   6.285714285714286, 8.}, {9., 8., 8.}, {10., 8., 1.}, {1., 
   4.3999999999999995`, 2.}, {1., 4.3999999999999995`, 4.}, {10., 
   2.750000000000001, 9.}, {10., 2.750000000000001, 8.}, {10., 8., 8.}, {5., 
   10., 10.}, {8.333333333333334, 10., 9.}, {2., 10., 4.}, {4.75, 1., 9.}, {
   8.333333333333334, 10., 1.}, {2., 10., 10.}, {5., 10., 9.}, {4.75, 1., 
   2.}, {10., 10., 1.}, {1., 1., 2.}, {1., 10., 4.}, {10., 1., 9.}}, {{
     {EdgeForm[None], 
      GraphicsGroup3DBox[{
        Polygon3DBox[{{30, 26, 1, 16}, {23, 28, 5, 6}, {31, 29, 7, 17}}], 
        Polygon3DBox[{{24, 32, 18, 9, 8}, {20, 21, 15, 13, 14}, {22, 27, 4, 2,
          3}}], Polygon3DBox[{{25, 33, 19, 10, 11, 12}}]}]}, {}, {}, {}}, 
    {Thickness[Large], Line3DBox[{16, 1, 26, 30, 16}], 
     Line3DBox[{3, 2, 4, 27, 22, 3}], Line3DBox[{6, 5, 28, 23, 6}], 
     Line3DBox[{17, 7, 29, 31, 17}], Line3DBox[{24, 8, 9, 18, 32, 24}], 
     Line3DBox[{11, 10, 19, 33, 25, 12, 11}], 
     Line3DBox[{14, 13, 15, 21, 20, 14}]}},
   VertexNormals->{{0., 0., 1.}, {0., 0., 1.}, {0., 0., 1.}, {0., 0., 1.}, {
    0., 0., 1.}, {0., 0., 1.}, {0., 0., 1.}, {0., 0., 1.}, {0., 0., 1.}, {0., 
    0., 1.}, {0., 0., 1.}, {0., 0., 1.}, {0., 0., 1.}, {0., 0., 1.}, {0., 0., 
    1.}, {0., 0., 1.}, {0., 0., 1.}, {0., 0., 1.}, {0., 0., 1.}, {0., 0., 
    1.}, {0., 0., 1.}, {0., 0., 1.}, {0., 0., 1.}, {0., 0., 1.}, {0., 0., 
    1.}, {0., 0., 1.}, {0., 0., 1.}, {0., 0., 1.}, {0., 0., 1.}, {0., 0., 
    1.}, {0., 0., 1.}, {0., 0., 1.}, {0., 0., 1.}}],
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{1., 10.}, {1., 10.}, {0., 10.}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->85203419,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ClippingStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->657685506],

Cell["Do not draw clipped regions:", "ExampleText",
 CellID->1132446978],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", 
         RowBox[{"Re", "[", 
          RowBox[{"Sin", "[", 
           RowBox[{"x", "+", 
            RowBox[{"I", " ", "y"}]}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{
          RowBox[{"-", "2"}], "Pi"}], ",", 
         RowBox[{"2", "Pi"}], ",", "0.2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{
          RowBox[{"-", "2"}], "Pi"}], ",", 
         RowBox[{"2", "Pi"}], ",", "0.2"}], "}"}]}], "]"}], ",", "1"}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1162216659],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{"data", ",", 
   RowBox[{"ClippingStyle", "\[Rule]", "None"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Orange"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2011618348],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->549877152]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1139722],

Cell["Make clipped regions partially transparent:", "ExampleText",
 CellID->2036279532],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", 
         RowBox[{"Re", "[", 
          RowBox[{"Sin", "[", 
           RowBox[{"x", "+", 
            RowBox[{"I", " ", "y"}]}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{
          RowBox[{"-", "2"}], "Pi"}], ",", 
         RowBox[{"2", "Pi"}], ",", "0.2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{
          RowBox[{"-", "2"}], "Pi"}], ",", 
         RowBox[{"2", "Pi"}], ",", "0.2"}], "}"}]}], "]"}], ",", "1"}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2020120395],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{"data", ",", 
   RowBox[{"ClippingStyle", "\[Rule]", 
    RowBox[{"Opacity", "[", "0.5", "]"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Orange"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->447019695],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->576778594]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->623011313],

Cell["Color clipped regions red at the bottom and blue at the top:", \
"ExampleText",
 CellID->1450695732],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", 
         RowBox[{"Re", "[", 
          RowBox[{"Sin", "[", 
           RowBox[{"x", "+", 
            RowBox[{"I", " ", "y"}]}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{
          RowBox[{"-", "2"}], "Pi"}], ",", 
         RowBox[{"2", "Pi"}], ",", "0.2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{
          RowBox[{"-", "2"}], "Pi"}], ",", 
         RowBox[{"2", "Pi"}], ",", "0.2"}], "}"}]}], "]"}], ",", "1"}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1975138997],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{"data", ",", 
   RowBox[{"ClippingStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Orange"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->358907253],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->556568235]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ColorFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->309428465],

Cell[TextData[{
 "Color by scaled ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " values: "
}], "ExampleText",
 CellID->638191020],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListPlot3D", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{
         RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", "Pi", ",", "0.1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "0", ",", "Pi", ",", "0.1"}], "}"}]}], "]"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
        RowBox[{"Evaluate", "[", "f", "]"}]}], "]"}]}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "f"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Hue", "[", "x", "]"}], ",", 
       RowBox[{"Hue", "[", "y", "]"}], ",", 
       RowBox[{"Hue", "[", "z", "]"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1744032263],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{487, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->111200266]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->144496],

Cell[TextData[{
 "Color by scaled ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " coordinates:"
}], "ExampleText",
 CellID->895408000],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "Pi", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "Pi", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"RGBColor", "[", 
       RowBox[{"x", ",", "y", ",", "0."}], "]"}]}], "]"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->287649445],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->330114289]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->121764205],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ColorData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorData"]], "InlineFormula"],
 " for predefined color gradients:"
}], "ExampleText",
 CellID->479475942],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "Pi", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "Pi", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"ColorData", "[", "\"\<DarkRainbow\>\"", "]"}], "[", "#1", 
       "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->334353853],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->199747371]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->284351414],

Cell[TextData[{
 "Named color gradients color in the ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->588278373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "Pi", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "Pi", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<DarkRainbow\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->535164012],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->213540462]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13890496],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " ",
 "has higher priority than",
 " ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->127654874],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "Pi", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "Pi", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<DarkRainbow\>\""}], ",", " ", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"Opacity", "[", "0.5", "]"}], ",", "Red"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1972178269],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->199906253]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->584691355],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " has lower priority than ",
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->426353608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "Pi", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "Pi", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "Hue"}], ",", " ", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"None", ",", " ", "Automatic"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1719643264],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->59407995]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ColorFunctionScaling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->49681617],

Cell["Use unscaled coordinates: ", "ExampleText",
 CellID->205569143],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", 
         RowBox[{"Abs", "[", 
          RowBox[{"Sin", "[", 
           RowBox[{"x", "+", 
            RowBox[{"I", " ", "y"}]}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{
          RowBox[{"-", "2"}], "Pi"}], ",", 
         RowBox[{"2", "Pi"}], ",", 
         RowBox[{"Pi", "/", "5"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "2"}], ",", "2", ",", 
         RowBox[{"1", "/", "5"}]}], "}"}]}], "]"}], ",", "1"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->119565465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{"data", ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"Hue", "@", 
       RowBox[{"Rescale", "[", 
        RowBox[{
         RowBox[{"Arg", "[", 
          RowBox[{"Sin", "[", 
           RowBox[{"x", "+", 
            RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], "]"}]}]}], "]"}]}], ",",
    " ", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1846882025],

Cell[GraphicsData["CompressedBitmap", "\<\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