(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    677848,      14888]
NotebookOptionsPosition[    656640,      14166]
NotebookOutlinePosition[    658296,      14208]
CellTagsIndexPosition[    658208,      14203]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ListPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/ListPlot3D"], "Graphics3D" :> 
          Documentation`HelpLookup["paclet:ref/Graphics3D"], "Point" :> 
          Documentation`HelpLookup["paclet:ref/Point"], "ContourPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/ContourPlot3D"], "ListPlot" :> 
          Documentation`HelpLookup["paclet:ref/ListPlot"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ListPlot3D\"\>", 
       2->"\<\"Graphics3D\"\>", 3->"\<\"Point\"\>", 
       4->"\<\"ContourPlot3D\"\>", 5->"\<\"ListPlot\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DataVisualization"], 
          "New in 6.0: Data Visualization" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataVisualization"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Data Visualization\"\>", 
       2->"\<\"New in 6.0: Data Visualization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ListPointPlot3D", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListPointPlot3D",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListPointPlot3D"], "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["z", "TI"], 
            StyleBox["1", "TR"]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["2", "TR"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["2", "TR"]], ",", 
           SubscriptBox[
            StyleBox["z", "TI"], 
            StyleBox["2", "TR"]]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a 3D scatter plot of points with coordinates \
",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["i", "TI"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["i", "TI"]], ",", 
        SubscriptBox[
         StyleBox["z", "TI"], 
         StyleBox["i", "TI"]]}], "}"}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListPointPlot3D",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListPointPlot3D"], "[", 
       StyleBox["array", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a 3D scatter plot of points with a 2D array \
of height values."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListPointPlot3D",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListPointPlot3D"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["data", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["data", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]plots several collections of points, by default in \
different colors. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->12121]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListPointPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPointPlot3D"]], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 ", with the following additions and changes: "
}], "Notes",
 CellID->29012],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Axes",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Axes"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to draw axes ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BoxRatios",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BoxRatios"], 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "0.4"}], "}"}], Cell[
    "bounding 3D box ratios ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ColorFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to determine the color of points ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ColorFunctionScaling",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunctionScaling"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[{
     "whether to scale arguments to ",
     Cell[BoxData[
      ButtonBox["ColorFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DataRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DataRange"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "the range of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " values to assume for data "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Filling",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Filling"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "how to fill in stems for each point ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FillingStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FillingStyle"], "Automatic", Cell[
    "style to use for filling ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRange"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Full",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Full"], ",", 
      ButtonBox["Full",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Full"], ",", 
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"]}], "}"}], Cell[TextData[{
     "the range of ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     " or other values to include "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotRangePadding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRangePadding"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how much to pad the range of values ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "graphics directives to specify the styles of points", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["RegionFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/RegionFunction"], 
    RowBox[{"(", 
     RowBox[{
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"], "&"}], ")"}], Cell[
    "how to determine whether a point should be included ", "TableText"]}
  },
  GridBoxAlignment->{"Columns" -> {Left, Left, {Left}}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, 
      True}}}},
 CellID->22939],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListPointPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPointPlot3D"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["data", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["data", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 " by default uses different colors to indicate points from different lists."
}], "Notes",
 CellID->8031],

Cell[TextData[{
 "Interactive labeling can be specified for points or lists of points using \
",
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["StatusArea",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StatusArea"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Annotation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Annotation"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->267096302],

Cell[TextData[{
 "The option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Filling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Filling"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " show stems for all points. "
}], "Notes",
 CellID->84038818],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListPointPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPointPlot3D"], "[", 
   StyleBox["array", "TI"], "]"}]], "InlineFormula"],
 " by default takes the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " coordinate values for each data point to be successive integers starting \
at 1. "
}], "Notes",
 CellID->1283],

Cell[TextData[{
 "The elements of ",
 Cell[BoxData[
  StyleBox["array", "TI"]], "InlineFormula"],
 " can also be triples ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["11", "TR"]], ",", 
    SubscriptBox[
     StyleBox["y", "TI"], 
     StyleBox["11", "TR"]], ",", 
    SubscriptBox[
     StyleBox["z", "TI"], 
     StyleBox["11", "TR"]]}], "}"}]], "InlineFormula"],
 ", specifying heights ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["z", "TI"], 
   StyleBox["ij", "TI"]]], "InlineFormula"],
 " at explicit positions ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["ij", "TI"]], ",", 
    SubscriptBox[
     StyleBox["y", "TI"], 
     StyleBox["ij", "TI"]]}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->51877402],

Cell[TextData[{
 "In the default case with no explicit ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " given, the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DataRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DataRange"], "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["min", "TI"]], ",", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["max", "TI"]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["min", "TI"]], ",", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["max", "TI"]]}], "}"}]}], "}"}]}]], "InlineFormula"],
 " specifies the ranges of coordinate values to use. "
}], "Notes",
 CellID->6057],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DataRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DataRange"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListPointPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPointPlot3D"], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["11", "TR"]], ",", 
       SubscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["12", "TR"]], ",", 
       SubscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["13", "TR"]]}], "}"}], ",", 
     StyleBox["\[Ellipsis]", "TR"], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["n1", "TI"]], ",", 
       SubscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["n2", "TI"]], ",", 
       SubscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["n3", "TI"]]}], "}"}]}], "}"}], "]"}]], "InlineFormula"],
 " will assume that the data being given is ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["1", "TR"]]}], "}"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 ", rather than an ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 "\[Times]3 array of height values. "
}], "Notes",
 CellID->7142],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListPointPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPointPlot3D"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{
     ButtonBox["DataRange",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DataRange"], "->", 
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"]}]}], "]"}]], "InlineFormula"],
 " always takes ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " to represent an array of height values. "
}], "Notes",
 CellID->9487],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["array", "TI"]], "InlineFormula"],
 " can be a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " object. "
}], "Notes",
 CellID->10404],

Cell[TextData[{
 "The arguments supplied to functions in ",
 Cell[BoxData[
  ButtonBox["MeshFunctions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshFunctions"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RegionFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionFunction"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 ". Functions in ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " are by default supplied with scaled versions of these arguments. "
}], "Notes",
 CellID->24233],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListPointPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPointPlot3D"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics3D"], "[", 
   RowBox[{
    ButtonBox["GraphicsComplex",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GraphicsComplex"], "[", 
    StyleBox["data", "TI"], "]"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23139]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->871068191],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(5)", "ExampleCount"]
}], "ExampleSection",
 CellID->56317417],

Cell["Show a scatter plot from an array of height values:", "ExampleText",
 CellID->308361593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "3", ",", "0.1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "0", ",", "3", ",", "0.1"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->378989803],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9W+uOHUcRPj736+6es+vdjdeXNbZj1k4cX4htbCZAUK5gIRAIRQKEFa2U
/AiJkiAhXoEH4EXyei2Y6q7qrv665sxZe4WVnNmZ6an+6l7V0/Pi5fdfnH71
8vsvP395/NG3L7/54svPvzv+8Otv60u9C51O54f6/38fduq//1v/5f//wTlX
3yh+v6p/e/WAXn3s1sef+6vf0C9d9medTled058/O8OovzNlf7ef7nY67/nD
18X115nN5kdz/K/6l6Z77M/+qdH1Tk9PeYJ3/d1/MLUB3P2Jv/td9mxC0pPR
jDSM/oTn7fJT15j2VNFOoz+l30HktoHnS0xj7mUYZgxDH/nDr1tle8AUtv18
kQLP99Aff9Mi+YvM0eo1aKxYOrtKdvQnjnsnyrIz1HzZ3O0wsoNcPszz/Sjp
rrKYHb77BiDpAe17/um/8uhwO+DAJ/vw5Nt+6J+VHejRAxj9lh/9mVN2XT3/
z+WNnvqTa7DQmoInVR/pTwsxDQ9I/8BnfZ67y8d1FIYw411P6fdMie72mFK/
PuLTI3j6jn/6hJ9GD0LN9Jm6/yPgq/+7BHOMracU9at+Tj/zWg+6xOO3eFaR
0kHLfINWykcbIhAf1jYoaLSOSNL7hqS7rJHzQbPHaBaMYGBYi4VkAnR654Zo
5VKMG9QzE+U+H7v/VyTbjGSPEYitaNlYiKZAp8ylNqITV8Y2Oh6CBFA3ezD/
DOdXNIOfVK60wUOWd9clb+8Z1MkziJnb/tHnTPcYnkIZIZU5YLzpqT11KZrT
U2PF+bA+Yr5ZAJUbnspjxnSZnx4htizSLKNU2+g+YnRXGc3Isgeec0dTrY9C
lXAFXu+7FMH0XNdYDwOFemhQFMki1uue+j2e60RRQ6wD5l5TJOxoP4HiXdb7
Wy75pURQ4TiLVfU19M1jp+38AVDS2Hoam9hx/TMSudfPB1xvshzfZRyWBVr4
BixXzH0+w3sd0Rx3GONUWaKFdRuoj5XcNfXgf9cZM8lyzHISXU8MapMGalc8
tWuM9SFTE3vvsbyQc+EFK51A7TJje6rk0y+8RqQ8VlaA/i3aSHFHsq+OO8/U
PGihou04/6n821b6KCOp5Nj3eZT4kqY9ZPTeDSJd8WHNi2Rnq3PQPYKXs9e8
5dc0YsAjP1AaGBq26qsbajIgivpzblV21qBq70V81Nggd/ajxpI8HrCmli73
CfHPXFMDtl1NYVsslGWyPjsGrF2WNmrcxqyu1NM+ZDlvKcTkZyjjaGug/b7I
ngWq/fA8pIsWR33TVNmF4xjQr8rIk0t7xFbtraUf4zrz3mgv58CLqRfFE+lg
piKGVDNdRi19SkSvshKNn/NzQfhq4gzx63IQvbSe/AlbiURAAjRRSEOdF6KH
RJQp39O9ia7nQnyQGr6rbGAE8noi1IO6O7Em8DabrmPMHBaxOq5ZqKgaIl89
bbjGkjv0x32QJyKTiI3es9U8Mz9JEhmzREM8TvL3s8YOp7BKFT0nQPUWy/wi
S6dbpa5B4xurWIU0CPZIIi94e0BW9lzY96Ld4Rw3mfu54HSp/pHKewyYuwbW
IY+XfoSm3E8m3An/fNQufKUNM2qMZDtTGUkipNS5m8p3pHjtgnwvrpNvusLa
XwBl6kNSLA+2TNeldyCkiyrVqWN4fuKMupGR7TUgE0vECgqx+R6TMRE8iirj
KvU1RSyH2kesGD1wHebdNZgx/hEPWGteUZhlLsJNvE5VNNRY50q+TVhVZOCZ
g3TF4y3Ppz8R3xHT8zGkvkzdyqiya7xJJRVi4ke8btiEc+hUBAuyCzKVldNY
qeYc5VdqwpcZGU1CqxpDRrPL0koVfV6bSzbEtdGAIGYWy35KRGqE12y/UtWu
HiG2o9cAcnpT1q7wYfUU3syynLKK9mhp1/KiQeQ/15o+HwBve8Kbk3+Yncjv
lsgf3Be5EpchEucc9nL7iOnJd6pGJdsvrojX6Zl3nFTI6dqy0BXFDMqwM6c6
K8wWrB3hb+JU7Q0ZRaIxxgT9PqZ3Jr40paEoKTMH22u0bgWhtkrJl1IF7qgo
1KbJWbyfJCDe323wdr32K/Ukvai7QMcza9patWv3VV+pU/cEspCol9u6rG/M
mbOVksyWc1n1N+Soo7tzXRW8HsdYW8jaCdY1RkbwXGltSOdIUWla5X2mfh9R
dMkZlcg/oxpV5SqOoEX09pvQ7ivbwMTQNFr/II+ijE7sH3mVupUyg8Rla0XB
XElQ51i5SE2qa9P2VfbcZiTmN8X+1OklLMOce5ZJrJQlZw1hhEsVMeX8PYV6
qfSNXErNoivxtt4453HXQU3Q7uXr/Z68oC1uVqmOpnkX7P2ysoG5xNK/+BBK
RCJDEYskZ7EwyixBkpD1HPStOaMt1rSaZdKPT7tUt6/4aPvIokoV89zgK1WD
0O/Eet7qOrE6CXVjhBbfsxo8ENmYv51ULaZ12xomTqZqPhpE2c/S0sykMKjK
Lpw4kF6tyxW0Fb3s/mu2ztLzyjKTSBgT85BBZai4XrJdW338dpXqZ6s39vlf
LI0lP13H40Dz2OEVhkHJgclXc01TSMmltXKivi9Y6+N+lVaDsUNNqyV5FYer
hpMz6VGir3T2E7Drsp9p0OmajCSdDI6bKgkRdzO5z9oK1aNevRRw2Hc08Wx5
tJNItEmMNfS3JlqBlqWzm6l7NMeWS3kJo/ScNT/N/aQKUVO/wyz2KTTwb1Uz
U1d2RhvnKeNKQJLiTVFVMVd7lXqTA76cRy3p59HaZd3YloDoW1YRsF4ZNvC9
2JBbsWSJyHts6TPgp8i1LlXhcYWK14vjaskgel1wAY5WK5dWmXq8AiMec+Y4
VNwRbYm9Lp3L8oyuuNdrzK+cMD7RjOYP31xNIne+iqivzt2anPIKVqmvSF1H
kXVfaRKr5FmVYpWss2N2yd9PIEfSPTe9+fPXQnr0caio05QGXHNEMrmTt4ZY
/e6hPQqFmKmxAvS8pO6yvqFyZ/t7N3gHnHU9m0XXrLYP1Kw8QxK9WKl6UN1f
Kf2ILeFb8Jmz4kg7l7hiF/dlFHo5o62SBxk+QB50UKX11bLu3VGxCVdLX5VL
H2PYOs7RMxt0K/lwxhZrxR08nym/RhtGrkcbco2V19SlteJXiz7Wjh1B7d97
qIgrK3eibaoNsXbH8005w0jm6WRrSK/Bn+3XHBulKyVu9l0Zd5c5BfbsbaBi
a1Q6UFlhwFFTd17Wa3ue7C05YBux+1K0AYxWspdsXjXU9AXffn8cR+b0LqM6
U+awVoFQTsTKpUp1YakuhbcH4pFZpeDsvUHoZYGnI+Oq9BMbV+vtHBa7mEj6
OueF35XxrLXGs4h+DPwU/OEe8HEz5pYrEjFtK5XocuDyVVeZc9SidzrH3Zo2
R1eMq2eOli1I6HSmvCpMVXG9kOssVrW8bk71h/iUtZMVufJe5HeqdbnjEoqv
pid715xUakeK9pYrOwlCjPtd8Z1lQHxsXG3AN9JX4u+Gna30E+m9ZaJAEZAq
+qkag+ixcgrorxuj0lpsdaaY1rbSPWSroDAm8XplPKf9yNo3WnLxI7ga92Zs
aCsNPl3Zbzm8Dxtr4DrTEIoxx4E5I6EjVhAYnQM/Nwyu12XS8NsclfIrsQbg
7H6JcY4K7mXdFjM7rgMF1Ddd8F0T7cY2vt6mcH+grN7R3inZ32atQNuI37RG
bVKXqaiO9URbXPW9YT0l7REfFxI/bMHt7T/s/odRm2jewrJu/eSNKnwLtDCQ
Ya0UkP3YGNXiiWvwWDZPp4dV+KrLyqYe5yAiCGbOOfOELdR+a2DtWy/8vqEn
ihLJcqLsadOR9Kqz95kdrMHtvwjLvsnbpH4s3uwZ2YQ0fN2ldRnSwMV8Ns7G
Yb+8pdtcitsGEjolL6VcKXs4CZGuCRK3b7dyu9jAx7KOtPCzG4xEVv13Xao7
+PuNU2MHeMbpEmal9ZBbLr3pkq+DEt37KMEW+297l7ziGSnvH/FMIbI9UDNZ
lCx70OdoocTTHeaN+p9enOkh8HS3HnHCmGRPaFihexSlGn2kc5vpWnj8W1Ve
nwxfmGiObtU/91y5+kRPzvjJsG/rMTx5s/55xxWrRBWvkdcDw964J/Dccf0j
e9mHPDLs2X0KMrhWj/BfFcO+mi4/5buRzk9ZHnSVcvAzllb4Tud54QXkQU+Z
gq8QwnfckAdoPeoJjwpfiVUwagjI0g6DNOYhUwjfor7HSLEau8ejwpfGv4C7
uC50l/kL31v/Eu5ixr7NtMO35+/DXaxIbvDoZ370r5x6t6r1wqPC1/QfwF3s
jI94tJ+78yHcxf7lgEf7cZ2P4C7WreIZ/tv1zscuVU561JJpvvCjPoW7qLMF
j/6dH+2/Zy/yiXjGH/0Y/6V5Eenpwmf+/guX3n3Q8S/+6m/rXyL8N3/WufA/
urOz8g==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->313466608]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1988213045],

Cell["Use irregularly spaced data:", "ExampleText",
 CellID->461767540],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"r", " ", 
          RowBox[{"Cos", "[", "t", "]"}]}], ",", 
         RowBox[{"r", " ", 
          RowBox[{"Sin", "[", "t", "]"}]}], ",", 
         RowBox[{"Sinc", "[", "r", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"r", ",", "0", ",", "10", ",", "0.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", "1"}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1145859703],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1713633048],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->15166567]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->880219883],

Cell["Fill below the points:", "ExampleText",
 CellID->2068628169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "3", ",", "0.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "3", ",", "0.2"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Bottom"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->755253340],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->95631189]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1260662455],

Cell["Show multiple sets of points:", "ExampleText",
 CellID->1818031653],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{
        RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", "3", ",", "0.1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "0", ",", "3", ",", "0.1"}], "}"}]}], "]"}], ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{
         RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], "+", "3"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", "3", ",", "0.1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "0", ",", "3", ",", "0.1"}], "}"}]}], "]"}]}], "}"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->459716027],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->163045547]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->340927836],

Cell["Color the points by height:", "ExampleText",
 CellID->217836768],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "i", "]"}], 
      RowBox[{"Cos", "[", "j", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"-", "5"}], ",", "5", ",", ".25"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", 
       RowBox[{"-", "5"}], ",", "5", ",", ".25"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<Rainbow\>\""}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->247541331],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->492749226]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(13)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Data",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->116659251],

Cell[TextData[{
 "For regular data consisting of ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " values, the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " data ranges are taken to be integer values: "
}], "ExampleText",
 CellID->5555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"j", "/", "3"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "20"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "20"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->96713535],

Cell[BoxData[
 Graphics3DBox[
  {Hue[0.67, 0.6, 0.6], Point3DBox[CompressedData["
1:eJx10zHIGDUAxfGoUE5xiBgw1FPieR4hxJC7RHSRHAgOgos4CO1iteAidSoO
RSpFhA7qVro4CA462A4i6KJUkKpTwVIQC1UH5ZOvPUXtaof7hC/c/y0Pfm9+
Dx059tzR24UQ790mxB1iL0vZ629Onj5wYfmh7Hcxb3sDLsEVuAZvwQ14B96D
D+AW3IF78AAewUfwCTyB58rFvLcfPWNeP/ftr5WLedsbcAmuwDV4C27AO/Ae
fAC34A7cgwfwCD6CT+AJPFferL6U63ff+e7zuzuVi3nbG3AJrsA1eAtuwDvw
HnwAt+AO3IMH8Ag+gk/gCTxXLldfyjOPnDr1wMEblYt52xtwCa7ANXgLbsA7
8B58ALfgDtyDB/AIPoJP4Ak8V65WX8rxg/d99+KPtYt52xtwCa7ANXgLbsA7
8B58ALfgDtyDB/AIPoJP4Ak8V65XX8rTn17a+VfvVi7mbW/AJbgC1+AtuAHv
wHvwAdyCO3APHsAj+Ag+gSfwXHm7+lKOvHFRvPXwb5WLedsbcAmuwDV4C27A
O/AefAC34A7cgwfwCD6CT+AJPFduVl/KH8fiK38/dbVyMW97Ay7BFbgGb8EN
eAfegw/gFtyBe/AAHsFH8Ak8gefKu9WXcujyZ68+IS9ULuZtb8AluALX4C24
Ae/Ae/AB3II7cA8ewCP4CD6BJ/Bceb/6UvKZ+5e3X7745X4X87Y34BJcgWvw
FtyAd+A9+ABuwR24Bw/gEXwEn8ATeK58WH0pV0496Y7fda1yMW97Ay7BFbgG
b8ENeAfegw/gFtyBe/AAHsFH8Ak8gefK7epL+eTBn65+/vjvlYt52xtwCa7A
NXgLbsA78B58ALfgDtyDB/AIPoJP4Ak8V+5WX8qjN995/8QXu5WLedsbcAmu
wDV4C27AO/AefAC34A7cgwfwCD6CT+AJPFfuV1/K5Q9feva1mzcqF/O2N+AS
XIFr8BbcgHfgPfgAbsEduAcP4BF8BJ/AE3iuPKy+lHT22j9vnrteuZi3vQGX
4Apcg7fgBrwD78EHcAvuwD14AI/gI/gEnsBz5XH1pdx7z2OHvz+wU7mYt70B
l+AKXIO34Aa8A+/BB3AL7sA9eACP4CP4BJ7Ac+Xj6rf+e/7w2bMnf6n81n83
vQGX4Apcg7fgBrwD78EHcAvuwD14AI/gI/gEnsBz5dPqS/nqg/On//z5UuVi
3vYGXIIrcA3eghvwDrwHH8AtuAP34AE8go/gE3gCz5Wn1ZdyMYQXyscflf0u
5m1vwCW4AtfgLbgB78B78AHcgjtwDx7AI/gIPoEn8Fx5Xn0ph5avhf7rSuVi
3vYGXIIrcA3eghvwDrwHH8AtuAP34AE8go/gE3gCz//7f3LKElA=
    "]]},
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  PlotRange->{{1., 20.}, {1., 20.}, Automatic},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}, {Automatic, Automatic}}]], "Output",
 ImageSize->{184, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->104764449,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->640365652],

Cell[TextData[{
 "Provide an explicit ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " data ranges by using ",
 Cell[BoxData[
  ButtonBox["DataRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DataRange"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->628844391],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"j", "/", "3"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->180860335],

Cell[BoxData[
 Graphics3DBox[
  {Hue[0.67, 0.6, 0.6], Point3DBox[CompressedData["
1:eJx12FHIX3Mcx/E/akUUubAeEUlJWYrhRrt4yoVSSy6UtTJWCs3VoqSthdoF
LtTajaJc2IXtQspJ0UiP48bqrNXJdMxZhx87eyzs1mzev6X35//cnJ7X83t+
v+/v/+7c/G/fsevxnVcuFot3rlgsrlr455s9+zccXe+28Ptdh9///I1zh7Zk
b+TbV1+57vTmr5esb+X/rn73xPdL9unkq5f+Ycn+vfzi6q0/Ljl3kL9wcaNT
S+YZ5Vsv/uH0kjkn+QMXptm++uuS+Yt8pX3+wp9+X3KvWX7pZ706/fjLzgO3
vXz425+r88zeyOmb17dy+uZ9Ojl98/69nL753EFO3zzPKKdvnnOS0zfPX+T0
zfea5fT9vze173zt1W8/caZU5/+yN3L65vWtnL55n05O37x/L6dvPneQ0zfP
M8rpm+ec5PTN8xc5ffO9Zjl9cXrQ99E79+27ZeVsdfpmb+Q88/pWTt+8Tyen
b96/l9M3nzvI6ZvnGeX0zXNOcvrm+Yucvvles5y+OJ87fXev3NQ+3V92+mZv
5JyT17dy+uZ9Ojl98/69nL753EFO3zzPKKdvnnOS0zfPX+T0zfea5fTF+Xzp
+8gnx8rfG89Up2/2Rk7fvL6V88z7dHL65v17OX3zuYOcvnmeUU7fPOckp2+e
v8jpm+81y+mL8znSd8dra4vX75iq0zd7I6dvXt/KmSvv08npm/fv5fTN5w5y
+uZ5Rjl985yTnL55/iKnb77XLKcvzudF39923fvcn6snq9M3eyOnb17fyumb
9+nkPPP+vZy++dxBTt88zyinb55zktM3z1/k9M33muX0xflc6PvU8U9ffOj6
o9Xpm72R0zevb+X0zft0cu6R9+/l9M3nDnL65nlGOX3znJOcvnn+Iqdvvtcs
py/O/el7/4Gb1998du0LnL7ZGzl98/pWTt+8Tyenb96/l/PM5w5y+uZ5Rjl9
85yTnL55/iKnb77XLKcvzj3pe2Lfw3fvvmaoTt/sjZy+eX0rp2/ep5PTN+/f
y7l3PneQ0zfPM8rpm+ec5PTN8xc5ffO9Zjl9ce5D349v/eHkZw/+Up2+2Rs5
ffP6Vk7fvE8np2/ev5fTN587yHnmeUY5ffOck5y+ef4ip2++1yynL87c9L3n
/FvvvdqcqU7f7I2cvnl9K6dv3qeT0zfv38vpm88d5HxOeZ5RTt885ySnb56/
yOmb7zXL6YszH32Pf/jMYy+dP1udvtkbOX3z+lZO37xPJ6dv3r+X0zefO8jp
m+cZ5TzznJOcvnn+Iqdvvtcspy/OHPS97+Dw197Dc3X6Zm/k9M3rWzl98z6d
nL55/15O33zuIKdvnmeU87nmOSc5ffP8RU7ffK9ZTl+c8+h74w2bt323oVSn
b/ZGTt+8vpXTN+/Tyemb9+/l9M3nDnL65nlGOX3znJOcZ56/yOmb7zXL6Yuz
b31/j2w7eHDPqer1/Y3eyOv7G9e38vr+xn06eX1/4/69vL6/8dxBXt/fOM8o
r+9vnHOS1/c3zl/k9f2N95rl9f39z/l/+n75wZH9f/x0rDp9szdy+ub1rZy+
eZ9OTt+8fy+nbz53kNM3zzPK6ZvnnOT0zfMXOc98r1lOX5x19F3btOnJLYc+
qv9P3+yNnL55fSunb96nk9M379/L6ZvPHeT0zfOMcvrmOSc5ffP8RU63fK9Z
Tl+c3+v3k+tfLTaeu/w9Jn2zN/L6/WRc38rpm/fp5PX7ybh/L6dvPneQ1+8n
4zyjvH4/Geec5PX7yTh/kdfvJ+O9ZjlP/B8SMEA2
    "]]},
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  PlotRange->{{0., 1.}, {0., 1.}, Automatic},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}, {Automatic, Automatic}}]], "Output",
 ImageSize->{184, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->695256,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->66967797],

Cell["Plot multiple sets of regular data: ", "ExampleText",
 CellID->159530242],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"j", "/", "3"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "20"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "20"}], "}"}]}], "]"}], ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Sin", "[", 
        RowBox[{"j", "/", "3"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "20"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "20"}], "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->143866527],

Cell[BoxData[
 Graphics3DBox[{
   {Hue[0.67, 0.6, 0.6], Point3DBox[CompressedData["
1:eJx10zHIGDUAxfGoUE5xiBgw1FPieR4hxJC7RHSRHAgOgos4CO1iteAidSoO
RSpFhA7qVro4CA462A4i6KJUkKpTwVIQC1UH5ZOvPUXtaof7hC/c/y0Pfm9+
Dx059tzR24UQ790mxB1iL0vZ629Onj5wYfmh7Hcxb3sDLsEVuAZvwQ14B96D
D+AW3IF78AAewUfwCTyB58rFvLcfPWNeP/ftr5WLedsbcAmuwDV4C27AO/Ae
fAC34A7cgwfwCD6CT+AJPFferL6U63ff+e7zuzuVi3nbG3AJrsA1eAtuwDvw
HnwAt+AO3IMH8Ag+gk/gCTxXLldfyjOPnDr1wMEblYt52xtwCa7ANXgLbsA7
8B58ALfgDtyDB/AIPoJP4Ak8V65WX8rxg/d99+KPtYt52xtwCa7ANXgLbsA7
8B58ALfgDtyDB/AIPoJP4Ak8V65XX8rTn17a+VfvVi7mbW/AJbgC1+AtuAHv
wHvwAdyCO3APHsAj+Ag+gSfwXHm7+lKOvHFRvPXwb5WLedsbcAmuwDV4C27A
O/AefAC34A7cgwfwCD6CT+AJPFduVl/KH8fiK38/dbVyMW97Ay7BFbgGb8EN
eAfegw/gFtyBe/AAHsFH8Ak8gefKu9WXcujyZ68+IS9ULuZtb8AluALX4C24
Ae/Ae/AB3II7cA8ewCP4CD6BJ/Bceb/6UvKZ+5e3X7745X4X87Y34BJcgWvw
FtyAd+A9+ABuwR24Bw/gEXwEn8ATeK58WH0pV0496Y7fda1yMW97Ay7BFbgG
b8ENeAfegw/gFtyBe/AAHsFH8Ak8gefK7epL+eTBn65+/vjvlYt52xtwCa7A
NXgLbsA78B58ALfgDtyDB/AIPoJP4Ak8V+5WX8qjN995/8QXu5WLedsbcAmu
wDV4C27AO/AefAC34A7cgwfwCD6CT+AJPFfuV1/K5Q9feva1mzcqF/O2N+AS
XIFr8BbcgHfgPfgAbsEduAcP4BF8BJ/AE3iuPKy+lHT22j9vnrteuZi3vQGX
4Apcg7fgBrwD78EHcAvuwD14AI/gI/gEnsBz5XH1pdx7z2OHvz+wU7mYt70B
l+AKXIO34Aa8A+/BB3AL7sA9eACP4CP4BJ7Ac+Xj6rf+e/7w2bMnf6n81n83
vQGX4Apcg7fgBrwD78EHcAvuwD14AI/gI/gEnsBz5dPqS/nqg/On//z5UuVi
3vYGXIIrcA3eghvwDrwHH8AtuAP34AE8go/gE3gCz5Wn1ZdyMYQXyscflf0u
5m1vwCW4AtfgLbgB78B78AHcgjtwDx7AI/gIPoEn8Fx5Xn0ph5avhf7rSuVi
3vYGXIIrcA3eghvwDrwHH8AtuAP34AE8go/gE3gCz//7f3LKElA=
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Point3DBox[CompressedData["
1:eJx10zHIGDUAxfGoUE5xiBgw1FNiPMMRYshdIrrIHQgOgos4CO1iteAidSoO
IpUPETqoW+niIDjoYDuIoEulglSdCpaCWKg6KJ+0PUXtaof7hC/c/y0Pfm9+
Dx059tzR24UQ798mxB1iL8u019+cOHng/PLDuf0u5m1vwCW4AtfgLbgBt+Ad
uAPvwT14AI/gCXwAH8EzeKlczHv70VPm9TPf/lq5mLe9AZfgClyDt+AG3IJ3
4A68B/fgATyCJ/ABfATP4KXyZvVlun73ne89f223cjFvewMuwRW4Bm/BDbgF
78AdeA/uwQN4BE/gA/gInsFL5XL1ZXrmkZ2dBw7eqFzM296AS3AFrsFbcANu
wTtwB96De/AAHsET+AA+gmfwUrlafZmOH7zvuxd/rF3M296AS3AFrsFbcANu
wTtwB96De/AAHsET+AA+gmfwUrlefZme/uzi7r/6WuVi3vYGXIIrcA3eghtw
C96BO/Ae3IMH8AiewAfwETyDl8rb1ZfpyJsXxNsP/1a5mLe9AZfgClyDt+AG
3IJ34A68B/fgATyCJ/ABfATP4KVys/oy/XEsvfL3U1cqF/O2N+ASXIFr8Bbc
gFvwDtyB9+AePIBH8AQ+gI/gGbxUbldfpkOXPn/1CXm+cjFvewMuwRW4Bm/B
DbgF78AdeA/uwQN4BE/gA/gInsFL5d3qy1RO3b+88/KFab+LedsbcAmuwDV4
C27ALXgH7sB7cA8ewCN4Ah/AR/AMXip3qy/T5Z0n/fG7rlYu5m1vwCW4Atfg
LbgBt+AduAPvwT14AI/gCXwAH8EzeKm8X32ZPn3wpytfPP575WLe9gZcgitw
Dd6CG3AL3oE78B7cgwfwCJ7AB/ARPIOXyv3qy/TozXc/eOPLa5WLedsbcAmu
wDV4C27ALXgH7sB7cA8ewCN4Ah/AR/AMXioPqy/TpY9eeva1mzcqF/O2N+AS
XIFr8BbcgFvwDtyB9+AePIBH8AQ+gI/gGbxUHldfpnz66j9vnbleuZi3vQGX
4Apcg7fgBtyCd+AOvAf34AE8gifwAXwEz+Cl8rT6Mt17z2OHvz+wW7mYt70B
l+AKXIO34AbcgnfgDrwH9+ABPIIn8AF8BM/gpfJh9Vv/PXv49OkTv1R+67+b
3oBLcAWuwVtwA27BO3AH3oN78AAewRP4AD6CZ/BS+bj6Mn314dmTf/58sXIx
b3sDLsEVuAZvwQ24Be/AHXgP7sEDeARP4AP4CJ7BS+V59WW6EOML0ycfn9vv
Yt72BlyCK3AN3oIbcAvegTvwHtyDB/AInsAH8BE8g5fKy+rLdGj5Wui/Llcu
5m1vwCW4AtfgLbgBt+AduAPvwT14AI/gCXwAH8EzePnf/wMx9iZQ
     "]]}},
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  PlotRange->{{1., 20.}, {1., 20.}, Automatic},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}, {Automatic, Automatic}}]], "Output",
 ImageSize->{184, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->179166814,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->86934994],

Cell[TextData[{
 "For irregular data consisting of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], TraditionalForm]], 
  "InlineMath"],
 " triples the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " data ranges are inferred from data:"
}], "ExampleText",
 CellID->41928725],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"Cos", "[", "i", "]"}], ",", 
      RowBox[{"Sin", "[", "i", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "20", ",", ".1"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->137625449],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1WttyG8cRhbG7AHiBSIAgKV4g0ZIlWnKsyLrFsUTH5UsU23HlIXG5Kg+p
kh1W7IfEjuPnvOUhX5Af8e9NJTszfWZ6z/aCK1lhFbHY2Z7uM9093T2N/ezZ
D1+f//XZD9989ezk6ffPvvv6m6/+cfLrb7+vh4pXBoPBj/X/vy8P6u//rb+F
/x+dc/WD1uff6s+yJhjW12F9fTeMfus/q/o23MlnoBkU8d5/fRzGv/OfZR7t
ovu7Gu3m1o/Kox6MtExb8kb9URjjfqU300r9XSHXLaIsWqu7ES7/FL0VPen/
9ZLp/iArG5SiqPB3hWav9eT2uUWn7i9DWpG1PRGNjeR6sxenPaEeiv7e7jVr
R+SXCv/5+Xlzfl6XyFjINWqhphdV/SLPqfQc/2wukjYCxzgnPnqU9D4UJP46
dbaHran50TZx/l9k3ixIT/yF6mG4/tnQ9rZag//K8u4F0i+F+14v6scKu5+1
NOTu+o8x4RS098P1SVP3hi4uC/8jQlUS3d2e/HYNnIcvifeOYD0hfoXIfKsn
n20D41XiOaI56y7HokYMrP8Pe8qFP964QNZai9OYKPYdfETHx0tyfZ3482xP
79kPqrR+WY0t5zPB/QbxrUgXfXF/KjjvXIBz3OJXycyo8dcF11Kud4nfhPiN
TH6a4iAMv0Gj2CP3DbyeDNF2LFeby65o/YFl/Qaqn5nz4f28e94ifuv0/Fbg
dktm7wiK1+prdfb4Pxy74Oe30yzeOcgn6/XsKc3WOW2QuNx2zXh8Wl9H9ezg
iPXVfy3rjw3itknSTwO3R8LFcy3qWWNZyVqv2Q9cznH8tBAMQ4UtWYg4p32W
7HIsuO4Ihyg/svAM/RhzukQoYsaftzziQGTcFZSXCGXQ4Avy3hOPuKfwJlvX
txZfXVtwPZBynCELWZ99+I6sa4Z1VUn7LlYTc5bS4l22RnY7UMxcO/4/pNXP
BVGgkVJh9hIxbIkm3hE5i0ChlzzX+u0lBZ6IffZEeO9Bq8qKsxaPVh3eIcVn
Sj983cUYMCfN7b5UaUuXI86mxCsv7LITrxTvn7m8r7V3Rk88NCzu8ZdpT+Z9
Wkpc80M+Xw1rIUNEygbCV8MF2eGWsyOI/3rNP/NuXEbbxuEd0kGoQUI26ToX
If/pddwUuVuuHbnWZGwm8itozeWYhJgeqqoep5IyYcj21Rg45gHDJcGQqu+o
hORBWcYyCMIp5OJTHO2HmvWpyGzsYtHJjuDg3GWj6KeP5lnFG/qmINgVBCO5
TsSjWmcGZYkrPSWbmlE8r4lM7Mix3FeigR1YwsFRWQdHz4EE/skIhrJbC+SS
HOUER6gKG+ctb7JtEwufbEt1z3VMSZbfcjl2IBv7KXw+SbupI8t55/djIcPL
eS4/YST+flPFlCORXkhcOTY84eJMw7VysFGqQC20iB0Tkuc1OCJNjVUcOxQt
FXK/VF4T/4Zp5z8/4nb1y3QcBxn/UCy9LuuYCKJ9wV3KPZ8ah8rKbY+20SLu
QqcdJ6hWt4M6Fi5XcRydKkG7EPRj184mS2MlF2dY7NHNVXpvId9UshDREVV1
5vRfQ/yqSdcNzFcMq+m50174uX9orQN+zjVmWokg0hVXHCq0XWpC2Id7A4VU
97o3i523CpVlDUSFPbkOXT49eJEzGT9pelA6uWWOsdIZE55Gb4CqsoWyAWy7
LnKBx7IbsjmfbqVmI51zFe05jyQXeMb+bFNCUiuuTBXHQarn0GUKTyudT3zu
PYBUqbbi37LDmlb0WiQrdp1w2LtgR87Be/CyhONVjDj43bJDx1ORH3VbtXyq
fQ7Q1k75VnFG7VOKHkZmPC8M+86fC4OeCc/j2mDL5bxSif2rnvapXHeNXLyw
tsxzfqpYk5fVX1DXtHWn7Wb13YwY95O0OibME9Fq7ALl+Jr3ch6zV2BZn739
/7ESqy7xt40YorIJZ85WpDL8pu86sPN1BPBXnD4ZayEVPfolQ1Xn4b6taSuO
XnzaiQj57IjT35rLURV5ozBijGVlM+N2WLmrygxWE01h14dKl+TPlXa0T0Jr
foe1zwTobMAejQht+FrYHebvSEPJtR4S73t0oUZOVcCqPjg2LYmMvbUKS6u+
inWbzg+hehILwo8au3aFRbH7WdvT59LPTBBsEZdtQgL9nNA4n6e8lJK6D6tQ
af9K8VlWVZy1u87wfdTK0BxqadteqRfRExHvFFR76KvkeEO90hXItA195ZL7
xowJOkFdx3t17OyzLE7eVxWCUp3mzJ77AL1H7F7E4FXr0yfryuXOA3I8+2q3
ZOg+fmJPFWftXyuAawKmMr7vcv3j8aDu4WzZrQH8priqCzdED4XOQO1fIfJz
dMPQk4VnTMUujAY1eRvhxbmMq789wsLWnNJzYIPv4GwQO6G6b/SiCDkiLFz+
HUCPb7jcW9UIF0qLehy1w46hTfN3oh5YOUvsuOxbjDVp66zZfdNZZ1/Nw+mL
64q+2Niv+RdgeBss6T33qIf8jZ7y0dWE/eY9dQJdBBFn6Af3R8Z1AO8eZPIF
ja934TmP/aKU5QkF6zmiOKDRU5f7INor9f2Z/Gbht5HV/zkG7XloWKyQzhEf
a96lcUQerHnqmrkL2RwVWLNHz94fZR/JStGlYJkTkokIMvkJMpc0qn9z8F8Z
A/YdckUpWp+6Zq46BAbVI7IR8EmD6yL2NtZCsy+BMwVwHBk4OE5GHHxSxjmW
3zBCdk7+Jz61IMmocyEZ/th6uyD8VpQrxLxylgz7ogJs7nPIx47jlXfLv2as
vI8PIN7A5/HrjKl7mctZNCK4TqPwrn3X1kBBHGEPRB2sn/2Kq6Yo+TVDMn5j
afXFQ3RpVh+FWjckL3tJvtFD66jz4W9ayzg/2b1glhZ+QVP7lNfHUnQHNfX5
Kl31e2XEjMr5cb1DBnbuxLW7tN0y4u68ZdhpVZSAVyBOo4Zt7plVEm8bq+qK
yoValZfkO4HUY0Y1Gt5EGqbatHsFa4ovtOmPtnq3ZrRvdtjAqh2Ks3zGOCAU
1zS61jtlax1csV+xP99tcPm5obFmB5Dr/KnBj3HE93dQGXSdp0q1L8MbHAnV
PcNj+Bd/Phsju2Dv+XdyvYnD3m290QaPsLis1eMPZHbsBvObbGNBzydYT+1/
Ubwrs2MP/6HL3VXrPOjrat8PvuPUyTa+H2zIhJ0/EBnLQP22sb7UJRMreer4
JscvO3jD894R6hAHw5s7wF+qHPJIqOJ7d08MniMVQe7L6sJuGJwZeCdKc/FN
Wcu3vKbeFKpgl8GviIqtcirU8S3t92Q1THVdqMI6Bu8bkvX9VaF+L1B/YKxG
3x/L2j8M1B8amuJOhuf9NFB/JHiZaiFUnwaqp/SUc/m2UP8uUP+GnnIW3BTq
3wfqj+kpZzF0Yr8I1J8IXqaqhOcfA9Vv1dNzORj4p38KT/17uD70fxnuBq/8
D5j15Mo=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 137},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->45660084]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->67570298],

Cell["Plot multiple sets of irregular data:", "ExampleText",
 CellID->333416587],

Cell[BoxData[{
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Cos", "[", "i", "]"}], ",", 
       RowBox[{"Sin", "[", "i", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "20", ",", ".1"}], "}"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"data2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Cos", "[", 
        RowBox[{"i", "+", 
         RowBox[{"Pi", "/", "2"}]}], "]"}], ",", 
       RowBox[{"Sin", "[", 
        RowBox[{"i", "+", 
         RowBox[{"Pi", "/", "2"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "20", ",", ".1"}], "}"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->73990447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{"{", 
   RowBox[{"data1", ",", "data2"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->127994308],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 137},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21750110]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->119237889],

Cell["Areas around where the data is nonreal are excluded:", "ExampleText",
 CellID->360827733],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{
   RowBox[{"ReplacePart", "[", 
    RowBox[{
     RowBox[{"Partition", "[", 
      RowBox[{
       RowBox[{"Range", "[", "100", "]"}], ",", "10"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "None"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"5", ",", "7"}], "}"}], "\[Rule]", "I"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"8", ",", "4"}], "}"}], "\[Rule]", 
        RowBox[{"Missing", "[", "\"\<NotAvailable\>\"", "]"}]}]}], "}"}]}], 
    "]"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", "Large", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->64910129],

Cell[BoxData[
 Graphics3DBox[
  {Hue[0.67, 0.6, 0.6], PointSize[Large], Point3DBox[CompressedData["
1:eJx91clKA0EUheFCNy5duHDhQgsRERFnnK04z2Y2LhVc+wr9aHkkH0Gh79+Q
f6EQDvXRJjl9c5Olz+/u11RK6ePvMZ34+zn/P1OpY6VM+kyc9+SzcT6Xz9Xn
6ko+H34vXwh/kS/W53FHnutz6cuX4/phmezjfs5Vnem7L6dvkUffdC2PvulB
Hn3Tqzz6pq4811n15dE3vel9e24k/7cmj15VkTPHazlzfJAzx1d59Cpdea5z
3JdHr0Iv7rs/dyS91uU834GcbOnMHG/kzPFRzhzb8hw5kEevil68nvamSXpt
yOl1KGeOLTlzvJEzx0d59CptOfvYlee4fiBnH+nLfdT3QZP03ZTT90jOfb2Q
8/q3cvJJZz63bTn72JPnuH4gZx9Hk8/r77km6bslp++xnPleyJnjkzxy3Jaz
jz15jusHcvaRXtwXfU83Sa9tOb1O5MzxUs4c7+Tc72c577cjj6x68hw5lLOn
I12n358m6bsjp++pnDleytnTOznzfZazpx05e9qTR5ahnD0dTZ79u9okfXfl
9D2TM98rOfO9lzPfFzl72pEzt748x/VDOflefgHv7ZtM
    "]]},
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  PlotRange->{{1., 10.}, {1., 10.}, Automatic},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}, {Automatic, Automatic}}]], "Output",
 ImageSize->{184, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->562341963,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellLabel->"In[2]:=",
 CellID->27997802],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"2", "-", 
      RowBox[{"i", "^", "2"}], "-", 
      RowBox[{"j", "^", "2"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"-", "2"}], ",", "2", ",", ".1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", 
      RowBox[{"-", "2"}], ",", "2", ",", ".1"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->234457578],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->619116201]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->226160967],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " is selected automatically: "
}], "ExampleText",
 CellID->76854780],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "2"}], ",", "2", ",", 
      RowBox[{"8", "/", "51"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "2"}], ",", "2", ",", 
      RowBox[{"8", "/", "51"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->501375403],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytXP1uHLcRX9/u3emk07ciybXlqBUcy3Y+GgdJCieXNEGawE2MIH+kSNu0
jWEIcAoELdK8RJ+gL5LXI9olOUMOfxxy94QK9t3tLjnf85shedLTZz+9uPrh
2U/fP392/tmPz/754vvn/zr/9B8/9rfaG03T/Nz///dp03/+b//J/f/ZGNM/
EK/f9K9d/2jSv0/695ft3bb/YNxP88iN+qN9nfq74dXNkWNv9i/2smmvrq5o
mJ//J/vaxZH53BPiP+GRPQk/0lP4sxiv8T4i3lN3P0weOXufZi9g9pvBRs1M
Sq/rsEtUNuz76r3/NF2k1DS/Dpa0erb0znO25JzAwc/5gcZu2vd+jNNx6mkH
kZo33Pvfid4Sx/afcewLouuEIZ5zkiNYws/LdH3VTbkSGjddYEE0OpKhBVot
0HroaD0nabZo1oKoTIRPyrO/kx5MJGErBElm8qmnOyE+lr/X7C9ED7lNSSr2
8VTwi7Q6mHXfcBRKP05UO0VHtRwTQvupSvkb8PoCKDMnjshoGdTv0tH7gxHZ
KJ7OpK3QriB5iL6MJ1rnnuP5OunAfrgjdOKInIDFkWb/wYeZj8iMh4v7Kg7d
NGkUtoJ+jMbcRxvAny3vPjT8czlSimPjUXlp0mhDf2YZBlKhd++O5H9EVlia
un8X8N4Kf/eXIlLQ52MlYWTeAU4ceZJ+9IN3gjW/xz8ZLdYPr4zkvkN+YHSu
eb/kJykNS4l+uTCcAVgb2AsJV84C7Z6aGVV0sdNC6Di4KfhsatIMPXFSf0R3
twu2QJu0qZQ9Z/bhnCjNB/1y5G5/aGLt1LICUQqvM0QJVpARhb7qRkr3vomR
y3bQcqbuNZnVM6P7ZaxEj8lv2yPto+WW1ETKxmMXwLkdKdu7ii+llTCa6lbz
FsqlS59HGULXOSDl20aviyglWg75l3Jxw4D8hBtMF6xpUrzw+fjIpL2A9Coi
hpajulU1bGVtbFxaoc4No6rmSYyeoZpSxFIaL32p+fTMSfPagMdKiO7Iez0V
2RfAeyFnJShSoo+o4qV9sKbvahmSxFqsgLQkaUF6KcttJ8ulSTsh9KOmWS1z
a7EfVyoShbk45ZmDst41te4/rMfa4FM1Y4cqewmXJyrXJPd72byHL0zaWSEy
TIDf2OzFPPW9p+y8h3wgrfoLJ+s5WXVzpCy1bC9FQwmpW6NJjBLeIWsuCtyH
YlRKXfP2AqUVCDhUhdK1RdPcMmLNDFbk1beMVL3SoWY8cwhdE6SH+bx+4fE1
jDh1upwa0bGBLihhXIMaQNYxnpsX4qozWpyk8cR4W4snr8+xiCfND5NR8mso
iPrUIwfri03k4V6R+wAfZ7wjxpZL5cYe+TqZUkZaHo1IYTsF6xzMI1kVtejU
1seN74eVPRp7L+SeiOean9AeC7RH/7G0CuTc406/Iy3nEIuoZakX8Np5X8ue
NO/z2eMO6YNAMnI51lRUUTB8KItnwgYlnE9oUORqe4ErdX2+EutkRNCX1rIM
z7QUJ6B/ySZ5ppQyoz5Kzzq5P6flh7Nqbxy5Atfqzrr5cjTabtyt6Ggx5u7/
016lURhlnIHu4EFE/i7bTdp3FasG24+1Hp95PANxYwhXcFyur0Yl6e0pPrCL
0rKL7+tZhnvJh9fS/jpoM94SnDG8ZzE1EVsxQ1rFAhrWar3ZgZEVRassnBSs
hw210NMMIKt8jr7FGC/tgHDtlGO3YS7igLYvnOFNZj20Slewhr03pWf1LsMN
C3c5AoYsNWSZpZC6FfuISHc38Xl6DoUxpPWG9lqekc6c/vnO1hzmlU5PsrVj
ITPq1sMVJL+7mEjOuPxny5Q7GG3vpJQ9moVc3JP3h8+F25q9st2srYGoqCFq
Nk+13J5Jd2v8T7H3hnd5wmxMvg9VOvEY3qVdz06bZn3sCevLzC44cl+LS4G7
Z6aeU0M9rrTOOjHDeIPWjTtweNqoxwB6q953HJvYX3B8nJhy7rAGsuKkvRpo
ek1L4Dhtd7/Yj6l2wdGHWkQleXNg9B60hB0hf1b1Cl0/OShbiqvV3Jhkd5zP
pzQs0W2BlbqQNdVccl0CIa/s5EodXHrGk37/Qls7pufLE9DZV6oDiIx0l3qo
6pbjBXZzTAlbpA2tSnyWK+sy6h5sQOdynpoWI14jGSe7IWNaJUomSu7sGqOg
AGNd2f8hY7Le2uFRLzfi6G0Tz6+0jr2aDULiZYj1+mkbR8I+6wCVq+yxI9Jg
j2beGhGpMqdwRxs12FpDg2yVApXpun7jiGQM44xna0kdu4K3tGqHMbeOrtZb
h2YdrCrkYWIT2R/vGFPYu1O78oLf+ZtQJf9LHGFckWvtdSP4MESw4eqjds/j
6prLP0tiwG56drMusvaxZWW8+JOhYBvIhlp+L9awDu6QeStIrmwFZa1t0vX0
YHSJzClVfsY2jJRWtUYnrCJPf3JryKqm9YBBd4oQFrxSp0IXU4qTRT6//3dX
aNitxu0+SJxAfHBrl2ZP3G14Nyqu5FZ8OFOPct5xHdfZntKom8JXrFE9grV3
PjvxVRerL+8ZcId2k20rLJafpUrk0s6UsDtlTSSGt+CriaqZhuaRa/TWPEQj
ru7zVVrQcWbSb1mRZrof9bt4hnEsNOWeohOatvQu8wGjsJZ1Yp8D706lntav
Z0SjEzuwwZ+F/Q1HSmopvHPfxKrUCd2SDKoiq9QOv8U21nu2W+tgzw33HVBb
pfaafM3M1WImdEt2E8X3NGoZN6wZZxuipcsTF4GAMPmOy2BEco5x/cNT/j3S
VOJkh5kPkdiiRWiNo0clasdo5E6oaXdntsI6gOtkHS+lRPJ7qFqXxJZYED/W
dB3fclfqNWVNeD3L1y8ZqNydGawRM4Wjs2TW4eAuHGPNtkmxBfVyH9UMcDzt
2QVYwS9gd8F/+6TdMtAXHWbmR71HsXd5x4t7kTug15bQR/qZ10krgZlyNaP5
02vCO8XaiXT4Pmg/Y5cpTIPlTOwuy70Yc15UR50J787BX6nfUj1DNqS9MaNN
8r1djze8AyEu1P59SXrXO9RCPRRoJCsze5eltlrvrqDyKfiCWViyAu71tiEj
1+vK+dyOuy3egYkoNFxFuKu232hkZJmu0m4lQRLOtYSK/A2nqBHKOxnUiM/h
zopROFPv2li8oDlLoQGuApz3ZjJCvMwtYdB1dEC/uerUkznP7W2yWmBEvpOf
rOynHEJEk9cL9n0BXvG4pXWcMv52VO3GnsjyCuDCRFQP9huZYdZzJyQ3f/dv
Qb7CTJR4gn28zEyZcdqpPIdYrPHhxJF+G9D/3FP8gDsNmpy8W2/r2Fz6AxBi
LBKgl7wOOxRRD1Trz4DfhqDPqxYb21sj5eI4k3Jgbni59uAud9dpfB8IOZZg
J0aTtPdM415yWKpy7MPdS/aCXguEDbYo1zgWl2wTYSOMOYyzLVWmA8U2W2qe
2Hy+E/yT8i5VmsNRMuCo+xzlg3bZEdf2+RHkwnaCPVKjE+C5qUp2JCI6W6uD
LJhPzDtbsSun0yeZfDhzSN4bTt7jkiVzbAeEkNcPVWm4w5D0Me69FCirjfMN
4PEWXP9yFOXTUfp1K0Be5qEiS7x+BahvqDLwytHynma8M3SG64NCtmjV9QHw
x29UenluKdbGWEXsnaoZvg2jcFY3WqbbikyYH0u4PlW8Zuc+BFozlSNGpmYF
rdJn17FDMR7r3gXKWAs9/zsiKtLaZ0zc98nXbpgX5R7lPUWOG/2l5e9lOC/a
INLfBJssFKxZDXLCbA0VFThpWWgZfQLzu4zDr0oRlGW6bi0+L3kH6LQZpwsT
MX6yUiJGpY87BLzng/wmGb+7MOKeUXoxEUX+x1nUxK5U8n57kCciG/aR7GWN
+sfuYZhr4nf/Gv975UAX0YHXLLIvWKk0vayX5A+ktQNy8V5TWqner1BG7LpQ
OFiKG6r1P7B34/dryL5Nhk8Yubsg9+fieZTtVZiFGfZXsoof/Ro8xcxPR79u
4kpPjvqbiXFCf21DPD2D62+N3w32o9+Ep4j49i992Eu/S/IInmLN+ppo+5Og
t0heHPUVjfJnpxj12Bs8pdGu+28wL7FHeUKj4+/jyqfYV/2ORvvfm/kNyYuj
PiYb+N/SewxPsev9gGi6v0HTINpjn/6YRrsYdr9tLZ/iSuMdGu3/DsSK5MVR
j2iU/5siH8JTXPO9Qdr5v6byW3iKK7GHRNv/RZqP4Cmul+7RaOc1Z8cJ+x3y
145ylm2wpmAH+TKNdnnsPFjr9W7RaId+zafwFLse3md345rPSF4cdUQ0n7hR
T+BpB9d7NPqpG/17eNrC9ZJGf+VGfw5PJybX1o7+2o3+wr5mmDknndxfP3LZ
ZK86mvmtu/tl/2onfueumhv/A8mi+kk=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 137},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->112281200]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " to focus in on areas of interest: "
}], "ExampleText",
 CellID->316263374],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListPointPlot3D", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "4"}], "+", 
       RowBox[{"y", "^", "4"}], "-", 
       RowBox[{"x", "^", "2"}], "-", 
       RowBox[{"y", "^", "2"}], "+", "1"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "2"}], ",", "2", ",", "0.15"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "2"}], ",", "2", ",", "0.15"}], "}"}]}], "]"}], "]"}], 
   ",", 
   RowBox[{"ListPointPlot3D", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "4"}], "+", 
        RowBox[{"y", "^", "4"}], "-", 
        RowBox[{"x", "^", "2"}], "-", 
        RowBox[{"y", "^", "2"}], "+", "1"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "2", ",", "0.15"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "2"}], ",", "2", ",", "0.15"}], "}"}]}], "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}]}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->41344862],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->83535626]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->428308280],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["RegionFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionFunction"]], "InlineFormula"],
 " to restrict the surface to a region given by inequalities:"
}], "ExampleText",
 CellID->272043783],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"data", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{
             RowBox[{"x", "^", "2"}], "+", 
             RowBox[{"y", "^", "2"}]}], "]"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"x", "^", "2"}], "+", 
             RowBox[{"y", "^", "2"}]}], ")"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "4"}], ",", "4", ",", "0.2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "4"}], ",", "4", ",", "0.2"}], "}"}]}], "]"}], ",", 
      "1"}], "]"}]}], ";"}], "//", "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1147823540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{"data", ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"RegionFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{
       RowBox[{"Norm", "[", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], "]"}], "<", "4"}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5386680],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->438239646]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Presentation",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->132373399],

Cell[TextData[{
 "Provide an explicit ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " for the points:"
}], "ExampleText",
 CellID->157416703],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"-", "3"}], ",", "3", ",", "0.05"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", 
       RowBox[{"-", "3"}], ",", "3", ",", "0.05"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Orange", ",", 
      RowBox[{"PointSize", "[", "Tiny", "]"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->254754736],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39596880]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->77456497],

Cell["Provide separate styles for different surfaces:", "ExampleText",
 CellID->1298077331],

Cell[BoxData[
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "-", 
       RowBox[{"x", "^", "2"}], "-", 
       RowBox[{"y", "^", "2"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0.05"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0.1"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5012897],

Cell[BoxData[
 RowBox[{
  RowBox[{"data2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"1", "-", 
        RowBox[{"x", "^", "2"}], "-", 
        RowBox[{"y", "^", "2"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0.05"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0.1"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->499897646],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"data1", ",", "data2"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"BoxRatios", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->499332244],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->581862501]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18985160],

Cell["Add labels:", "ExampleText",
 CellID->400933500],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"i", "+", 
       RowBox[{"j", "^", "2"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "3", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "3", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"j", ",", "i"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"Sin", "[", 
     RowBox[{"i", "+", 
      RowBox[{"j", "^", "2"}]}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Purple"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1833133861],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 162},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->727198395]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->324506061],

Cell["Color the surface by height:", "ExampleText",
 CellID->2000753416],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"i", "+", 
       RowBox[{"j", "^", "2"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "3", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "3", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"Hue", "[", "z", "]"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1363717986],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->211158439]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->468410419],

Cell[TextData[{
 "Provide an interactive ",
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 " for each point:"
}], "ExampleText",
 CellID->581641354],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{
   RowBox[{"Tooltip", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"i", "+", 
        RowBox[{"j", "^", "2"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", "3", ",", "0.1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "0", ",", "3", ",", "0.1"}], "}"}]}], "]"}], "]"}], 
   ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Darker", "[", "Green", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->93552325],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[0, 
    NCache[
     Rational[2, 3], 0.6666666666666666], 0], 
   TagBox[
    TooltipBox[Point3DBox[{1., 1., 0.}],
     "0.`"],
    Annotation[#, 0., "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{1., 2., 0.09983341664682815}],
     "0.09983341664682815`"],
    Annotation[#, 0.09983341664682815, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{1., 3., 0.19866933079506122`}],
     "0.19866933079506122`"],
    Annotation[#, 0.19866933079506122`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{1., 4., 0.2955202066613396}],
     "0.2955202066613396`"],
    Annotation[#, 0.2955202066613396, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{1., 5., 0.3894183423086505}],
     "0.3894183423086505`"],
    Annotation[#, 0.3894183423086505, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{1., 6., 0.479425538604203}],
     "0.479425538604203`"],
    Annotation[#, 0.479425538604203, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{1., 7., 0.5646424733950355}],
     "0.5646424733950355`"],
    Annotation[#, 0.5646424733950355, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{1., 8., 0.6442176872376911}],
     "0.6442176872376911`"],
    Annotation[#, 0.6442176872376911, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{1., 9., 0.7173560908995228}],
     "0.7173560908995228`"],
    Annotation[#, 0.7173560908995228, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{1., 10., 0.7833269096274834}],
     "0.7833269096274834`"],
    Annotation[#, 0.7833269096274834, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{1., 11., 0.8414709848078965}],
     "0.8414709848078965`"],
    Annotation[#, 0.8414709848078965, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{1., 12., 0.8912073600614354}],
     "0.8912073600614354`"],
    Annotation[#, 0.8912073600614354, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{1., 13., 0.9320390859672264}],
     "0.9320390859672264`"],
    Annotation[#, 0.9320390859672264, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{1., 14., 0.963558185417193}],
     "0.963558185417193`"],
    Annotation[#, 0.963558185417193, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{1., 15., 0.9854497299884603}],
     "0.9854497299884603`"],
    Annotation[#, 0.9854497299884603, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{1., 16., 0.9974949866040544}],
     "0.9974949866040544`"],
    Annotation[#, 0.9974949866040544, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{1., 17., 0.9995736030415051}],
     "0.9995736030415051`"],
    Annotation[#, 0.9995736030415051, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{1., 18., 0.9916648104524686}],
     "0.9916648104524686`"],
    Annotation[#, 0.9916648104524686, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{1., 19., 0.9738476308781951}],
     "0.9738476308781951`"],
    Annotation[#, 0.9738476308781951, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{1., 20., 0.9463000876874145}],
     "0.9463000876874145`"],
    Annotation[#, 0.9463000876874145, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{1., 21., 0.9092974268256817}],
     "0.9092974268256817`"],
    Annotation[#, 0.9092974268256817, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{1., 22., 0.8632093666488737}],
     "0.8632093666488737`"],
    Annotation[#, 0.8632093666488737, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{1., 23., 0.8084964038195901}],
     "0.8084964038195901`"],
    Annotation[#, 0.8084964038195901, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{1., 24., 0.74570521217672}],
     "0.74570521217672`"],
    Annotation[#, 0.74570521217672, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{1., 25., 0.6754631805511506}],
     "0.6754631805511506`"],
    Annotation[#, 0.6754631805511506, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{1., 26., 0.5984721441039564}],
     "0.5984721441039564`"],
    Annotation[#, 0.5984721441039564, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{1., 27., 0.5155013718214642}],
     "0.5155013718214642`"],
    Annotation[#, 0.5155013718214642, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{1., 28., 0.4273798802338298}],
     "0.4273798802338298`"],
    Annotation[#, 0.4273798802338298, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{1., 29., 0.33498815015590466`}],
     "0.33498815015590466`"],
    Annotation[#, 0.33498815015590466`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{1., 30., 0.23924932921398198`}],
     "0.23924932921398198`"],
    Annotation[#, 0.23924932921398198`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{1., 31., 0.1411200080598672}],
     "0.1411200080598672`"],
    Annotation[#, 0.1411200080598672, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{2., 1., 0.009999833334166666}],
     "0.009999833334166666`"],
    Annotation[#, 0.009999833334166666, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{2., 2., 0.10977830083717482`}],
     "0.10977830083717482`"],
    Annotation[#, 0.10977830083717482`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{2., 3., 0.20845989984609958`}],
     "0.20845989984609958`"],
    Annotation[#, 0.20845989984609958`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{2., 4., 0.30505863644344355`}],
     "0.30505863644344355`"],
    Annotation[#, 0.30505863644344355`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{2., 5., 0.39860932798442295`}],
     "0.39860932798442295`"],
    Annotation[#, 0.39860932798442295`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{2., 6., 0.4881772468829075}],
     "0.4881772468829075`"],
    Annotation[#, 0.4881772468829075, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{2., 7., 0.5728674601004814}],
     "0.5728674601004814`"],
    Annotation[#, 0.5728674601004814, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{2., 8., 0.6518337710215367}],
     "0.6518337710215367`"],
    Annotation[#, 0.6518337710215367, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{2., 9., 0.7242871743701426}],
     "0.7242871743701426`"],
    Annotation[#, 0.7242871743701426, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{2., 10., 0.7895037396899505}],
     "0.7895037396899505`"],
    Annotation[#, 0.7895037396899505, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{2., 11., 0.8468318446180152}],
     "0.8468318446180152`"],
    Annotation[#, 0.8468318446180152, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{2., 12., 0.8956986856800476}],
     "0.8956986856800476`"],
    Annotation[#, 0.8956986856800476, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{2., 13., 0.935616001553386}],
     "0.935616001553386`"],
    Annotation[#, 0.935616001553386, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{2., 14., 0.966184951612734}],
     "0.966184951612734`"],
    Annotation[#, 0.966184951612734, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{2., 15., 0.9871001010138504}],
     "0.9871001010138504`"],
    Annotation[#, 0.9871001010138504, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{2., 16., 0.9981524724975481}],
     "0.9981524724975481`"],
    Annotation[#, 0.9981524724975481, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{2., 17., 0.9992316344213905}],
     "0.9992316344213905`"],
    Annotation[#, 0.9992316344213905, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{2., 18., 0.990326804156158}],
     "0.990326804156158`"],
    Annotation[#, 0.990326804156158, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{2., 19., 0.9715269558223153}],
     "0.9715269558223153`"],
    Annotation[#, 0.9715269558223153, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{2., 20., 0.9430199312900105}],
     "0.9430199312900105`"],
    Annotation[#, 0.9430199312900105, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{2., 21., 0.905090563325201}],
     "0.905090563325201`"],
    Annotation[#, 0.905090563325201, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{2., 22., 0.8581178296348089}],
     "0.8581178296348089`"],
    Annotation[#, 0.8581178296348089, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{2., 23., 0.8025710662467472}],
     "0.8025710662467472`"],
    Annotation[#, 0.8025710662467472, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{2., 24., 0.7390052780594708}],
     "0.7390052780594708`"],
    Annotation[#, 0.7390052780594708, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{2., 25., 0.668055593416491}],
     "0.668055593416491`"],
    Annotation[#, 0.668055593416491, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{2., 26., 0.590430918113913}],
     "0.590430918113913`"],
    Annotation[#, 0.590430918113913, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{2., 27., 0.5069068522480534}],
     "0.5069068522480534`"],
    Annotation[#, 0.5069068522480534, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{2., 28., 0.418317940675659}],
     "0.418317940675659`"],
    Annotation[#, 0.418317940675659, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{2., 29., 0.32554933451756}],
     "0.32554933451756`"],
    Annotation[#, 0.32554933451756, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{2., 30., 0.2295279470212642}],
     "0.2295279470212642`"],
    Annotation[#, 0.2295279470212642, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{2., 31., 0.13121319215018423`}],
     "0.13121319215018423`"],
    Annotation[#, 0.13121319215018423`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{3., 1., 0.03998933418663417}],
     "0.03998933418663417`"],
    Annotation[#, 0.03998933418663417, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{3., 2., 0.1395431146442365}],
     "0.1395431146442365`"],
    Annotation[#, 0.1395431146442365, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{3., 3., 0.2377026264271346}],
     "0.2377026264271346`"],
    Annotation[#, 0.2377026264271346, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{3., 4., 0.33348709214081446`}],
     "0.33348709214081446`"],
    Annotation[#, 0.33348709214081446`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{3., 5., 0.42593946506599967`}],
     "0.42593946506599967`"],
    Annotation[#, 0.42593946506599967`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{3., 6., 0.5141359916531132}],
     "0.5141359916531132`"],
    Annotation[#, 0.5141359916531132, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{3., 7., 0.5971954413623921}],
     "0.5971954413623921`"],
    Annotation[#, 0.5971954413623921, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{3., 8., 0.6742879116281452}],
     "0.6742879116281452`"],
    Annotation[#, 0.6742879116281452, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{3., 9., 0.7446431199708594}],
     "0.7446431199708594`"],
    Annotation[#, 0.7446431199708594, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{3., 10., 0.8075581004051143}],
     "0.8075581004051143`"],
    Annotation[#, 0.8075581004051143, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{3., 11., 0.8624042272433384}],
     "0.8624042272433384`"],
    Annotation[#, 0.8624042272433384, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{3., 12., 0.9086334961158833}],
     "0.9086334961158833`"],
    Annotation[#, 0.9086334961158833, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{3., 13., 0.9457839994495391}],
     "0.9457839994495391`"],
    Annotation[#, 0.9457839994495391, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{3., 14., 0.9734845416953194}],
     "0.9734845416953194`"],
    Annotation[#, 0.9734845416953194, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{3., 15., 0.9914583481916864}],
     "0.9914583481916864`"],
    Annotation[#, 0.9914583481916864, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{3., 16., 0.9995258306054791}],
     "0.9995258306054791`"],
    Annotation[#, 0.9995258306054791, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{3., 17., 0.9976063813191737}],
     "0.9976063813191737`"],
    Annotation[#, 0.9976063813191737, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{3., 18., 0.9857191788355535}],
     "0.9857191788355535`"],
    Annotation[#, 0.9857191788355535, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{3., 19., 0.9639829961524481}],
     "0.9639829961524481`"],
    Annotation[#, 0.9639829961524481, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{3., 20., 0.9326150140222004}],
     "0.9326150140222004`"],
    Annotation[#, 0.9326150140222004, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{3., 21., 0.8919286509533796}],
     "0.8919286509533796`"],
    Annotation[#, 0.8919286509533796, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{3., 22., 0.8423304316366457}],
     "0.8423304316366457`"],
    Annotation[#, 0.8423304316366457, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{3., 23., 0.7843159250844198}],
     "0.7843159250844198`"],
    Annotation[#, 0.7843159250844198, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{3., 24., 0.7184647930691259}],
     "0.7184647930691259`"],
    Annotation[#, 0.7184647930691259, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{3., 25., 0.6454349983343703}],
     "0.6454349983343703`"],
    Annotation[#, 0.6454349983343703, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{3., 26., 0.5659562304487028}],
     "0.5659562304487028`"],
    Annotation[#, 0.5659562304487028, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{3., 27., 0.48082261498864826`}],
     "0.48082261498864826`"],
    Annotation[#, 0.48082261498864826`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{3., 28., 0.3908847788984522}],
     "0.3908847788984522`"],
    Annotation[#, 0.3908847788984522, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{3., 29., 0.29704135130683196`}],
     "0.29704135130683196`"],
    Annotation[#, 0.29704135130683196`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{3., 30., 0.2002299847217701}],
     "0.2002299847217701`"],
    Annotation[#, 0.2002299847217701, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{3., 31., 0.10141798631660186`}],
     "0.10141798631660186`"],
    Annotation[#, 0.10141798631660186`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{4., 1., 0.08987854919801107}],
     "0.08987854919801107`"],
    Annotation[#, 0.08987854919801107, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{4., 2., 0.1888588949765006}],
     "0.1888588949765006`"],
    Annotation[#, 0.1888588949765006, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{4., 3., 0.2859522251048356}],
     "0.2859522251048356`"],
    Annotation[#, 0.2859522251048356, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{4., 4., 0.3801884151231615}],
     "0.3801884151231615`"],
    Annotation[#, 0.3801884151231615, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{4., 5., 0.4706258881711581}],
     "0.4706258881711581`"],
    Annotation[#, 0.4706258881711581, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{4., 6., 0.5563610229127839}],
     "0.5563610229127839`"],
    Annotation[#, 0.5563610229127839, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{4., 7., 0.6365371822219681}],
     "0.6365371822219681`"],
    Annotation[#, 0.6365371822219681, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{4., 8., 0.7103532724176078}],
     "0.7103532724176078`"],
    Annotation[#, 0.7103532724176078, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{4., 9., 0.777071747526824}],
     "0.777071747526824`"],
    Annotation[#, 0.777071747526824, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{4., 10., 0.8360259786005205}],
     "0.8360259786005205`"],
    Annotation[#, 0.8360259786005205, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{4., 11., 0.8866269144494873}],
     "0.8866269144494873`"],
    Annotation[#, 0.8866269144494873, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{4., 12., 0.9283689672491667}],
     "0.9283689672491667`"],
    Annotation[#, 0.9283689672491667, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{4., 13., 0.9608350642060727}],
     "0.9608350642060727`"],
    Annotation[#, 0.9608350642060727, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{4., 14., 0.9837008148112766}],
     "0.9837008148112766`"],
    Annotation[#, 0.9837008148112766, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{4., 15., 0.9967377520431434}],
     "0.9967377520431434`"],
    Annotation[#, 0.9967377520431434, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{4., 16., 0.9998156151342908}],
     "0.9998156151342908`"],
    Annotation[#, 0.9998156151342908, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{4., 17., 0.9929036510941185}],
     "0.9929036510941185`"],
    Annotation[#, 0.9929036510941185, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{4., 18., 0.9760709219825241}],
     "0.9760709219825241`"],
    Annotation[#, 0.9760709219825241, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{4., 19., 0.9494856148646305}],
     "0.9494856148646305`"],
    Annotation[#, 0.9494856148646305, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{4., 20., 0.9134133613412251}],
     "0.9134133613412251`"],
    Annotation[#, 0.9134133613412251, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{4., 21., 0.8682145834456126}],
     "0.8682145834456126`"],
    Annotation[#, 0.8682145834456126, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{4., 22., 0.814340892425796}],
     "0.814340892425796`"],
    Annotation[#, 0.814340892425796, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{4., 23., 0.7523305763941707}],
     "0.7523305763941707`"],
    Annotation[#, 0.7523305763941707, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{4., 24., 0.6828032219306397}],
     "0.6828032219306397`"],
    Annotation[#, 0.6828032219306397, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{4., 25., 0.6064535233783147}],
     "0.6064535233783147`"],
    Annotation[#, 0.6064535233783147, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{4., 26., 0.5240443416872761}],
     "0.5240443416872761`"],
    Annotation[#, 0.5240443416872761, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{4., 27., 0.4363990821601263}],
     "0.4363990821601263`"],
    Annotation[#, 0.4363990821601263, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{4., 28., 0.34439346725839}],
     "0.34439346725839`"],
    Annotation[#, 0.34439346725839, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{4., 29., 0.24894678667315256`}],
     "0.24894678667315256`"],
    Annotation[#, 0.24894678667315256`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{4., 30., 0.15101271208634384`}],
     "0.15101271208634384`"],
    Annotation[#, 0.15101271208634384`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{4., 31., 0.05156976839853464}],
     "0.05156976839853464`"],
    Annotation[#, 0.05156976839853464, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{5., 1., 0.159318206614246}],
     "0.159318206614246`"],
    Annotation[#, 0.159318206614246, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{5., 2., 0.2570805518921551}],
     "0.2570805518921551`"],
    Annotation[#, 0.2570805518921551, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{5., 3., 0.35227423327509}],
     "0.35227423327509`"],
    Annotation[#, 0.35227423327509, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{5., 4., 0.44394810696551984`}],
     "0.44394810696551984`"],
    Annotation[#, 0.44394810696551984`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{5., 5., 0.5311861979208834}],
     "0.5311861979208834`"],
    Annotation[#, 0.5311861979208834, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{5., 6., 0.6131168519734338}],
     "0.6131168519734338`"],
    Annotation[#, 0.6131168519734338, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{5., 7., 0.6889214451105514}],
     "0.6889214451105514`"],
    Annotation[#, 0.6889214451105514, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{5., 8., 0.7578425628952771}],
     "0.7578425628952771`"],
    Annotation[#, 0.7578425628952771, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{5., 9., 0.8191915683009983}],
     "0.8191915683009983`"],
    Annotation[#, 0.8191915683009983, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{5., 10., 0.8723554823449863}],
     "0.8723554823449863`"],
    Annotation[#, 0.8723554823449863, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{5., 11., 0.916803108771767}],
     "0.916803108771767`"],
    Annotation[#, 0.916803108771767, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{5., 12., 0.9520903415905159}],
     "0.9520903415905159`"],
    Annotation[#, 0.9520903415905159, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{5., 13., 0.9778646024353163}],
     "0.9778646024353163`"],
    Annotation[#, 0.9778646024353163, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{5., 14., 0.9938683634116449}],
     "0.9938683634116449`"],
    Annotation[#, 0.9938683634116449, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{5., 15., 0.9999417202299663}],
     "0.9999417202299663`"],
    Annotation[#, 0.9999417202299663, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{5., 16., 0.9960239899165367}],
     "0.9960239899165367`"],
    Annotation[#, 0.9960239899165367, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{5., 17., 0.9821543171376185}],
     "0.9821543171376185`"],
    Annotation[#, 0.9821543171376185, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{5., 18., 0.958471283078914}],
     "0.958471283078914`"],
    Annotation[#, 0.958471283078914, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{5., 19., 0.9252115207881683}],
     "0.9252115207881683`"],
    Annotation[#, 0.9252115207881683, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{5., 20., 0.8827073508159741}],
     "0.8827073508159741`"],
    Annotation[#, 0.8827073508159741, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{5., 21., 0.8313834607786831}],
     "0.8313834607786831`"],
    Annotation[#, 0.8313834607786831, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{5., 22., 0.7717526620201257}],
     "0.7717526620201257`"],
    Annotation[#, 0.7717526620201257, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{5., 23., 0.7044107657701759}],
     "0.7044107657701759`"],
    Annotation[#, 0.7044107657701759, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{5., 24., 0.6300306299958919}],
     "0.6300306299958919`"],
    Annotation[#, 0.6300306299958919, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{5., 25., 0.5493554364271263}],
     "0.5493554364271263`"],
    Annotation[#, 0.5493554364271263, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{5., 26., 0.4631912649303452}],
     "0.4631912649303452`"],
    Annotation[#, 0.4631912649303452, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{5., 27., 0.3723990394250553}],
     "0.3723990394250553`"],
    Annotation[#, 0.3723990394250553, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{5., 28., 0.27788592581658633`}],
     "0.27788592581658633`"],
    Annotation[#, 0.27788592581658633`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{5., 29., 0.1805962678942325}],
     "0.1805962678942325`"],
    Annotation[#, 0.1805962678942325, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{5., 30., 0.08150215176026868}],
     "0.08150215176026868`"],
    Annotation[#, 0.08150215176026868, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{5., 31., -0.01840630693305381}],
     RowBox[{"-", "0.01840630693305381`"}]],
    Annotation[#, -0.01840630693305381, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{6., 1., 0.24740395925452294`}],
     "0.24740395925452294`"],
    Annotation[#, 0.24740395925452294`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{6., 2., 0.34289780745545134`}],
     "0.34289780745545134`"],
    Annotation[#, 0.34289780745545134`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{6., 3., 0.43496553411123023`}],
     "0.43496553411123023`"],
    Annotation[#, 0.43496553411123023`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{6., 4., 0.5226872289306592}],
     "0.5226872289306592`"],
    Annotation[#, 0.5226872289306592, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{6., 5., 0.6051864057360395}],
     "0.6051864057360395`"],
    Annotation[#, 0.6051864057360395, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{6., 6., 0.6816387600233341}],
     "0.6816387600233341`"],
    Annotation[#, 0.6816387600233341, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{6., 7., 0.7512804051402928}],
     "0.7512804051402928`"],
    Annotation[#, 0.7512804051402928, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{6., 8., 0.8134155047893737}],
     "0.8134155047893737`"],
    Annotation[#, 0.8134155047893737, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{6., 9., 0.867423225594017}],
     "0.867423225594017`"],
    Annotation[#, 0.867423225594017, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{6., 10., 0.912763940260521}],
     "0.912763940260521`"],
    Annotation[#, 0.912763940260521, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{6., 11., 0.9489846193555862}],
     "0.9489846193555862`"],
    Annotation[#, 0.9489846193555862, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{6., 12., 0.9757233578266591}],
     "0.9757233578266591`"],
    Annotation[#, 0.9757233578266591, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{6., 13., 0.9927129910375885}],
     "0.9927129910375885`"],
    Annotation[#, 0.9927129910375885, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{6., 14., 0.999783764189357}],
     "0.999783764189357`"],
    Annotation[#, 0.999783764189357, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{6., 15., 0.9968650284539189}],
     "0.9968650284539189`"],
    Annotation[#, 0.9968650284539189, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{6., 16., 0.9839859468739369}],
     "0.9839859468739369`"],
    Annotation[#, 0.9839859468739369, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{6., 17., 0.9612752029752999}],
     "0.9612752029752999`"],
    Annotation[#, 0.9612752029752999, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{6., 18., 0.9289597150038692}],
     "0.9289597150038692`"],
    Annotation[#, 0.9289597150038692, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{6., 19., 0.8873623686333755}],
     "0.8873623686333755`"],
    Annotation[#, 0.8873623686333755, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{6., 20., 0.8368987907984975}],
     "0.8368987907984975`"],
    Annotation[#, 0.8368987907984975, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{6., 21., 0.7780731968879212}],
     "0.7780731968879212`"],
    Annotation[#, 0.7780731968879212, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{6., 22., 0.7114733527908443}],
     "0.7114733527908443`"],
    Annotation[#, 0.7114733527908443, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{6., 23., 0.6377647021345036}],
     "0.6377647021345036`"],
    Annotation[#, 0.6377647021345036, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{6., 24., 0.5576837173914166}],
     "0.5576837173914166`"],
    Annotation[#, 0.5576837173914166, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{6., 25., 0.47203054128988226`}],
     "0.47203054128988226`"],
    Annotation[#, 0.47203054128988226`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{6., 26., 0.38166099205233167`}],
     "0.38166099205233167`"],
    Annotation[#, 0.38166099205233167`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{6., 27., 0.2874780123425444}],
     "0.2874780123425444`"],
    Annotation[#, 0.2874780123425444, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{6., 28., 0.19042264736102704`}],
     "0.19042264736102704`"],
    Annotation[#, 0.19042264736102704`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{6., 29., 0.09146464223243675}],
     "0.09146464223243675`"],
    Annotation[#, 0.09146464223243675, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{6., 30., -0.008407247367149063}],
     RowBox[{"-", "0.008407247367149063`"}]],
    Annotation[#, -0.008407247367149063, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{6., 31., -0.10819513453010837`}],
     RowBox[{"-", "0.10819513453010837`"}]],
    Annotation[#, -0.10819513453010837`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{7., 1., 0.35227423327509005`}],
     "0.35227423327509005`"],
    Annotation[#, 0.35227423327509005`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{7., 2., 0.44394810696551984`}],
     "0.44394810696551984`"],
    Annotation[#, 0.44394810696551984`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{7., 3., 0.5311861979208834}],
     "0.5311861979208834`"],
    Annotation[#, 0.5311861979208834, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{7., 4., 0.6131168519734339}],
     "0.6131168519734339`"],
    Annotation[#, 0.6131168519734339, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{7., 5., 0.6889214451105514}],
     "0.6889214451105514`"],
    Annotation[#, 0.6889214451105514, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{7., 6., 0.7578425628952771}],
     "0.7578425628952771`"],
    Annotation[#, 0.7578425628952771, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{7., 7., 0.8191915683009984}],
     "0.8191915683009984`"],
    Annotation[#, 0.8191915683009984, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{7., 8., 0.8723554823449863}],
     "0.8723554823449863`"],
    Annotation[#, 0.8723554823449863, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{7., 9., 0.916803108771767}],
     "0.916803108771767`"],
    Annotation[#, 0.916803108771767, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{7., 10., 0.9520903415905159}],
     "0.9520903415905159`"],
    Annotation[#, 0.9520903415905159, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{7., 11., 0.9778646024353163}],
     "0.9778646024353163`"],
    Annotation[#, 0.9778646024353163, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{7., 12., 0.9938683634116449}],
     "0.9938683634116449`"],
    Annotation[#, 0.9938683634116449, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{7., 13., 0.9999417202299663}],
     "0.9999417202299663`"],
    Annotation[#, 0.9999417202299663, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{7., 14., 0.9960239899165367}],
     "0.9960239899165367`"],
    Annotation[#, 0.9960239899165367, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{7., 15., 0.9821543171376185}],
     "0.9821543171376185`"],
    Annotation[#, 0.9821543171376185, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{7., 16., 0.9584712830789142}],
     "0.9584712830789142`"],
    Annotation[#, 0.9584712830789142, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{7., 17., 0.9252115207881682}],
     "0.9252115207881682`"],
    Annotation[#, 0.9252115207881682, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{7., 18., 0.8827073508159738}],
     "0.8827073508159738`"],
    Annotation[#, 0.8827073508159738, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{7., 19., 0.8313834607786831}],
     "0.8313834607786831`"],
    Annotation[#, 0.8313834607786831, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{7., 20., 0.7717526620201257}],
     "0.7717526620201257`"],
    Annotation[#, 0.7717526620201257, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{7., 21., 0.7044107657701759}],
     "0.7044107657701759`"],
    Annotation[#, 0.7044107657701759, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{7., 22., 0.6300306299958922}],
     "0.6300306299958922`"],
    Annotation[#, 0.6300306299958922, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{7., 23., 0.5493554364271263}],
     "0.5493554364271263`"],
    Annotation[#, 0.5493554364271263, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{7., 24., 0.4631912649303452}],
     "0.4631912649303452`"],
    Annotation[#, 0.4631912649303452, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{7., 25., 0.37239903942505487`}],
     "0.37239903942505487`"],
    Annotation[#, 0.37239903942505487`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{7., 26., 0.27788592581658633`}],
     "0.27788592581658633`"],
    Annotation[#, 0.27788592581658633`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{7., 27., 0.18059626789423291`}],
     "0.18059626789423291`"],
    Annotation[#, 0.18059626789423291`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{7., 28., 0.08150215176026868}],
     "0.08150215176026868`"],
    Annotation[#, 0.08150215176026868, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{7., 29., -0.01840630693305381}],
     RowBox[{"-", "0.01840630693305381`"}]],
    Annotation[#, -0.01840630693305381, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{7., 30., -0.11813085589181825`}],
     RowBox[{"-", "0.11813085589181825`"}]],
    Annotation[#, -0.11813085589181825`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{7., 31., -0.21667508038738006`}],
     RowBox[{"-", "0.21667508038738006`"}]],
    Annotation[#, -0.21667508038738006`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{8., 1., 0.47062588817115814`}],
     "0.47062588817115814`"],
    Annotation[#, 0.47062588817115814`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{8., 2., 0.5563610229127839}],
     "0.5563610229127839`"],
    Annotation[#, 0.5563610229127839, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{8., 3., 0.6365371822219681}],
     "0.6365371822219681`"],
    Annotation[#, 0.6365371822219681, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{8., 4., 0.7103532724176079}],
     "0.7103532724176079`"],
    Annotation[#, 0.7103532724176079, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{8., 5., 0.777071747526824}],
     "0.777071747526824`"],
    Annotation[#, 0.777071747526824, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{8., 6., 0.8360259786005205}],
     "0.8360259786005205`"],
    Annotation[#, 0.8360259786005205, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{8., 7., 0.8866269144494874}],
     "0.8866269144494874`"],
    Annotation[#, 0.8866269144494874, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{8., 8., 0.9283689672491667}],
     "0.9283689672491667`"],
    Annotation[#, 0.9283689672491667, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{8., 9., 0.9608350642060727}],
     "0.9608350642060727`"],
    Annotation[#, 0.9608350642060727, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{8., 10., 0.9837008148112766}],
     "0.9837008148112766`"],
    Annotation[#, 0.9837008148112766, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{8., 11., 0.9967377520431434}],
     "0.9967377520431434`"],
    Annotation[#, 0.9967377520431434, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{8., 12., 0.9998156151342908}],
     "0.9998156151342908`"],
    Annotation[#, 0.9998156151342908, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{8., 13., 0.9929036510941185}],
     "0.9929036510941185`"],
    Annotation[#, 0.9929036510941185, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{8., 14., 0.9760709219825242}],
     "0.9760709219825242`"],
    Annotation[#, 0.9760709219825242, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{8., 15., 0.9494856148646305}],
     "0.9494856148646305`"],
    Annotation[#, 0.9494856148646305, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{8., 16., 0.9134133613412251}],
     "0.9134133613412251`"],
    Annotation[#, 0.9134133613412251, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{8., 17., 0.8682145834456124}],
     "0.8682145834456124`"],
    Annotation[#, 0.8682145834456124, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{8., 18., 0.8143408924257957}],
     "0.8143408924257957`"],
    Annotation[#, 0.8143408924257957, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{8., 19., 0.7523305763941707}],
     "0.7523305763941707`"],
    Annotation[#, 0.7523305763941707, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{8., 20., 0.6828032219306397}],
     "0.6828032219306397`"],
    Annotation[#, 0.6828032219306397, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{8., 21., 0.6064535233783147}],
     "0.6064535233783147`"],
    Annotation[#, 0.6064535233783147, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{8., 22., 0.5240443416872758}],
     "0.5240443416872758`"],
    Annotation[#, 0.5240443416872758, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{8., 23., 0.4363990821601259}],
     "0.4363990821601259`"],
    Annotation[#, 0.4363990821601259, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{8., 24., 0.3443934672583896}],
     "0.3443934672583896`"],
    Annotation[#, 0.3443934672583896, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{8., 25., 0.24894678667315215`}],
     "0.24894678667315215`"],
    Annotation[#, 0.24894678667315215`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{8., 26., 0.15101271208634384`}],
     "0.15101271208634384`"],
    Annotation[#, 0.15101271208634384`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{8., 27., 0.051569768398534194`}],
     "0.051569768398534194`"],
    Annotation[#, 0.051569768398534194`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{8., 28., -0.048388443368414594`}],
     RowBox[{"-", "0.048388443368414594`"}]],
    Annotation[#, -0.048388443368414594`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{8., 29., -0.14786317380431896`}],
     RowBox[{"-", "0.14786317380431896`"}]],
    Annotation[#, -0.14786317380431896`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{8., 30., -0.24586050428463746`}],
     RowBox[{"-", "0.24586050428463746`"}]],
    Annotation[#, -0.24586050428463746`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{8., 31., -0.34140127787682095`}],
     RowBox[{"-", "0.34140127787682095`"}]],
    Annotation[#, -0.34140127787682095`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{9., 1., 0.5971954413623921}],
     "0.5971954413623921`"],
    Annotation[#, 0.5971954413623921, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{9., 2., 0.6742879116281452}],
     "0.6742879116281452`"],
    Annotation[#, 0.6742879116281452, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{9., 3., 0.7446431199708594}],
     "0.7446431199708594`"],
    Annotation[#, 0.7446431199708594, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{9., 4., 0.8075581004051143}],
     "0.8075581004051143`"],
    Annotation[#, 0.8075581004051143, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{9., 5., 0.8624042272433384}],
     "0.8624042272433384`"],
    Annotation[#, 0.8624042272433384, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{9., 6., 0.9086334961158833}],
     "0.9086334961158833`"],
    Annotation[#, 0.9086334961158833, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{9., 7., 0.9457839994495391}],
     "0.9457839994495391`"],
    Annotation[#, 0.9457839994495391, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{9., 8., 0.9734845416953194}],
     "0.9734845416953194`"],
    Annotation[#, 0.9734845416953194, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{9., 9., 0.9914583481916864}],
     "0.9914583481916864`"],
    Annotation[#, 0.9914583481916864, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{9., 10., 0.9995258306054791}],
     "0.9995258306054791`"],
    Annotation[#, 0.9995258306054791, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{9., 11., 0.9976063813191737}],
     "0.9976063813191737`"],
    Annotation[#, 0.9976063813191737, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{9., 12., 0.9857191788355535}],
     "0.9857191788355535`"],
    Annotation[#, 0.9857191788355535, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{9., 13., 0.9639829961524481}],
     "0.9639829961524481`"],
    Annotation[#, 0.9639829961524481, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{9., 14., 0.9326150140222004}],
     "0.9326150140222004`"],
    Annotation[#, 0.9326150140222004, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{9., 15., 0.8919286509533796}],
     "0.8919286509533796`"],
    Annotation[#, 0.8919286509533796, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{9., 16., 0.8423304316366457}],
     "0.8423304316366457`"],
    Annotation[#, 0.8423304316366457, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{9., 17., 0.7843159250844198}],
     "0.7843159250844198`"],
    Annotation[#, 0.7843159250844198, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{9., 18., 0.7184647930691259}],
     "0.7184647930691259`"],
    Annotation[#, 0.7184647930691259, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{9., 19., 0.6454349983343703}],
     "0.6454349983343703`"],
    Annotation[#, 0.6454349983343703, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{9., 20., 0.5659562304487028}],
     "0.5659562304487028`"],
    Annotation[#, 0.5659562304487028, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{9., 21., 0.48082261498864826`}],
     "0.48082261498864826`"],
    Annotation[#, 0.48082261498864826`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{9., 22., 0.3908847788984522}],
     "0.3908847788984522`"],
    Annotation[#, 0.3908847788984522, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{9., 23., 0.29704135130683196`}],
     "0.29704135130683196`"],
    Annotation[#, 0.29704135130683196`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{9., 24., 0.2002299847217701}],
     "0.2002299847217701`"],
    Annotation[#, 0.2002299847217701, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{9., 25., 0.10141798631660143`}],
     "0.10141798631660143`"],
    Annotation[#, 0.10141798631660143`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{9., 26., 0.0015926529164868282`}],
     "0.0015926529164868282`"],
    Annotation[#, 0.0015926529164868282`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{9., 27., -0.09824859374510868}],
     RowBox[{"-", "0.09824859374510868`"}]],
    Annotation[#, -0.09824859374510868, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{9., 28., -0.19710817293467028`}],
     RowBox[{"-", "0.19710817293467028`"}]],
    Annotation[#, -0.19710817293467028`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{9., 29., -0.293998312415568}],
     RowBox[{"-", "0.293998312415568`"}]],
    Annotation[#, -0.293998312415568, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{9., 30., -0.3879509179417307}],
     RowBox[{"-", "0.3879509179417307`"}]],
    Annotation[#, -0.3879509179417307, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{9., 31., -0.47802724613534286`}],
     RowBox[{"-", "0.47802724613534286`"}]],
    Annotation[#, -0.47802724613534286`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{10., 1., 0.7242871743701426}],
     "0.7242871743701426`"],
    Annotation[#, 0.7242871743701426, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{10., 2., 0.7895037396899505}],
     "0.7895037396899505`"],
    Annotation[#, 0.7895037396899505, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{10., 3., 0.8468318446180152}],
     "0.8468318446180152`"],
    Annotation[#, 0.8468318446180152, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{10., 4., 0.8956986856800476}],
     "0.8956986856800476`"],
    Annotation[#, 0.8956986856800476, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{10., 5., 0.9356160015533859}],
     "0.9356160015533859`"],
    Annotation[#, 0.9356160015533859, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{10., 6., 0.966184951612734}],
     "0.966184951612734`"],
    Annotation[#, 0.966184951612734, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{10., 7., 0.9871001010138504}],
     "0.9871001010138504`"],
    Annotation[#, 0.9871001010138504, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{10., 8., 0.9981524724975481}],
     "0.9981524724975481`"],
    Annotation[#, 0.9981524724975481, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{10., 9., 0.9992316344213905}],
     "0.9992316344213905`"],
    Annotation[#, 0.9992316344213905, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{10., 10., 0.990326804156158}],
     "0.990326804156158`"],
    Annotation[#, 0.990326804156158, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{10., 11., 0.9715269558223153}],
     "0.9715269558223153`"],
    Annotation[#, 0.9715269558223153, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{10., 12., 0.9430199312900105}],
     "0.9430199312900105`"],
    Annotation[#, 0.9430199312900105, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{10., 13., 0.9050905633252009}],
     "0.9050905633252009`"],
    Annotation[#, 0.9050905633252009, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{10., 14., 0.8581178296348086}],
     "0.8581178296348086`"],
    Annotation[#, 0.8581178296348086, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{10., 15., 0.8025710662467472}],
     "0.8025710662467472`"],
    Annotation[#, 0.8025710662467472, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{10., 16., 0.7390052780594708}],
     "0.7390052780594708`"],
    Annotation[#, 0.7390052780594708, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{10., 17., 0.668055593416491}],
     "0.668055593416491`"],
    Annotation[#, 0.668055593416491, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{10., 18., 0.5904309181139127}],
     "0.5904309181139127`"],
    Annotation[#, 0.5904309181139127, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{10., 19., 0.5069068522480531}],
     "0.5069068522480531`"],
    Annotation[#, 0.5069068522480531, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{10., 20., 0.418317940675659}],
     "0.418317940675659`"],
    Annotation[#, 0.418317940675659, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{10., 21., 0.32554933451756}],
     "0.32554933451756`"],
    Annotation[#, 0.32554933451756, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{10., 22., 0.2295279470212642}],
     "0.2295279470212642`"],
    Annotation[#, 0.2295279470212642, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{10., 23., 0.1312131921501838}],
     "0.1312131921501838`"],
    Annotation[#, 0.1312131921501838, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{10., 24., 0.03158739843645345}],
     "0.03158739843645345`"],
    Annotation[#, 0.03158739843645345, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{10., 25., -0.06835400612104822}],
     RowBox[{"-", "0.06835400612104822`"}]],
    Annotation[#, -0.06835400612104822, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{10., 26., -0.16761244004421832`}],
     RowBox[{"-", "0.16761244004421832`"}]],
    Annotation[#, -0.16761244004421832`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{10., 27., -0.26519614587177337`}],
     RowBox[{"-", "0.26519614587177337`"}]],
    Annotation[#, -0.26519614587177337`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{10., 28., -0.36013009947196856`}],
     RowBox[{"-", "0.36013009947196856`"}]],
    Annotation[#, -0.36013009947196856`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{10., 29., -0.45146575216142354`}],
     RowBox[{"-", "0.45146575216142354`"}]],
    Annotation[#, -0.45146575216142354`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{10., 30., -0.538290508290018}],
     RowBox[{"-", "0.538290508290018`"}]],
    Annotation[#, -0.538290508290018, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{10., 31., -0.6197368435949633}],
     RowBox[{"-", "0.6197368435949633`"}]],
    Annotation[#, -0.6197368435949633, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{11., 1., 0.8414709848078965}],
     "0.8414709848078965`"],
    Annotation[#, 0.8414709848078965, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{11., 2., 0.8912073600614354}],
     "0.8912073600614354`"],
    Annotation[#, 0.8912073600614354, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{11., 3., 0.9320390859672263}],
     "0.9320390859672263`"],
    Annotation[#, 0.9320390859672263, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{11., 4., 0.963558185417193}],
     "0.963558185417193`"],
    Annotation[#, 0.963558185417193, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{11., 5., 0.9854497299884601}],
     "0.9854497299884601`"],
    Annotation[#, 0.9854497299884601, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{11., 6., 0.9974949866040544}],
     "0.9974949866040544`"],
    Annotation[#, 0.9974949866040544, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{11., 7., 0.9995736030415051}],
     "0.9995736030415051`"],
    Annotation[#, 0.9995736030415051, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{11., 8., 0.9916648104524686}],
     "0.9916648104524686`"],
    Annotation[#, 0.9916648104524686, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{11., 9., 0.9738476308781951}],
     "0.9738476308781951`"],
    Annotation[#, 0.9738476308781951, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{11., 10., 0.9463000876874145}],
     "0.9463000876874145`"],
    Annotation[#, 0.9463000876874145, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{11., 11., 0.9092974268256817}],
     "0.9092974268256817`"],
    Annotation[#, 0.9092974268256817, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{11., 12., 0.8632093666488737}],
     "0.8632093666488737`"],
    Annotation[#, 0.8632093666488737, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{11., 13., 0.8084964038195901}],
     "0.8084964038195901`"],
    Annotation[#, 0.8084964038195901, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{11., 14., 0.7457052121767203}],
     "0.7457052121767203`"],
    Annotation[#, 0.7457052121767203, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{11., 15., 0.6754631805511506}],
     "0.6754631805511506`"],
    Annotation[#, 0.6754631805511506, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{11., 16., 0.5984721441039564}],
     "0.5984721441039564`"],
    Annotation[#, 0.5984721441039564, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{11., 17., 0.5155013718214642}],
     "0.5155013718214642`"],
    Annotation[#, 0.5155013718214642, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{11., 18., 0.4273798802338298}],
     "0.4273798802338298`"],
    Annotation[#, 0.4273798802338298, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{11., 19., 0.3349881501559051}],
     "0.3349881501559051`"],
    Annotation[#, 0.3349881501559051, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{11., 20., 0.23924932921398198`}],
     "0.23924932921398198`"],
    Annotation[#, 0.23924932921398198`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{11., 21., 0.1411200080598672}],
     "0.1411200080598672`"],
    Annotation[#, 0.1411200080598672, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{11., 22., 0.04158066243329049}],
     "0.04158066243329049`"],
    Annotation[#, 0.04158066243329049, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{11., 23., -0.058374143427580086`}],
     RowBox[{"-", "0.058374143427580086`"}]],
    Annotation[#, -0.058374143427580086`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{11., 24., -0.15774569414324865`}],
     RowBox[{"-", "0.15774569414324865`"}]],
    Annotation[#, -0.15774569414324865`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{11., 25., -0.25554110202683167`}],
     RowBox[{"-", "0.25554110202683167`"}]],
    Annotation[#, -0.25554110202683167`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{11., 26., -0.35078322768961984`}],
     RowBox[{"-", "0.35078322768961984`"}]],
    Annotation[#, -0.35078322768961984`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{11., 27., -0.44252044329485246`}],
     RowBox[{"-", "0.44252044329485246`"}]],
    Annotation[#, -0.44252044329485246`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{11., 28., -0.5298361409084934}],
     RowBox[{"-", "0.5298361409084934`"}]],
    Annotation[#, -0.5298361409084934, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{11., 29., -0.6118578909427193}],
     RowBox[{"-", "0.6118578909427193`"}]],
    Annotation[#, -0.6118578909427193, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{11., 30., -0.6877661591839741}],
     RowBox[{"-", "0.6877661591839741`"}]],
    Annotation[#, -0.6877661591839741, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{11., 31., -0.7568024953079282}],
     RowBox[{"-", "0.7568024953079282`"}]],
    Annotation[#, -0.7568024953079282, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{12., 1., 0.935616001553386}],
     "0.935616001553386`"],
    Annotation[#, 0.935616001553386, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{12., 2., 0.9661849516127341}],
     "0.9661849516127341`"],
    Annotation[#, 0.9661849516127341, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{12., 3., 0.9871001010138504}],
     "0.9871001010138504`"],
    Annotation[#, 0.9871001010138504, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{12., 4., 0.9981524724975481}],
     "0.9981524724975481`"],
    Annotation[#, 0.9981524724975481, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{12., 5., 0.9992316344213905}],
     "0.9992316344213905`"],
    Annotation[#, 0.9992316344213905, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{12., 6., 0.990326804156158}],
     "0.990326804156158`"],
    Annotation[#, 0.990326804156158, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{12., 7., 0.9715269558223153}],
     "0.9715269558223153`"],
    Annotation[#, 0.9715269558223153, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{12., 8., 0.9430199312900105}],
     "0.9430199312900105`"],
    Annotation[#, 0.9430199312900105, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{12., 9., 0.9050905633252009}],
     "0.9050905633252009`"],
    Annotation[#, 0.9050905633252009, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{12., 10., 0.8581178296348086}],
     "0.8581178296348086`"],
    Annotation[#, 0.8581178296348086, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{12., 11., 0.8025710662467472}],
     "0.8025710662467472`"],
    Annotation[#, 0.8025710662467472, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{12., 12., 0.7390052780594706}],
     "0.7390052780594706`"],
    Annotation[#, 0.7390052780594706, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{12., 13., 0.668055593416491}],
     "0.668055593416491`"],
    Annotation[#, 0.668055593416491, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{12., 14., 0.5904309181139127}],
     "0.5904309181139127`"],
    Annotation[#, 0.5904309181139127, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{12., 15., 0.5069068522480531}],
     "0.5069068522480531`"],
    Annotation[#, 0.5069068522480531, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{12., 16., 0.418317940675659}],
     "0.418317940675659`"],
    Annotation[#, 0.418317940675659, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{12., 17., 0.3255493345175596}],
     "0.3255493345175596`"],
    Annotation[#, 0.3255493345175596, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{12., 18., 0.2295279470212642}],
     "0.2295279470212642`"],
    Annotation[#, 0.2295279470212642, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{12., 19., 0.1312131921501838}],
     "0.1312131921501838`"],
    Annotation[#, 0.1312131921501838, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{12., 20., 0.03158739843645345}],
     "0.03158739843645345`"],
    Annotation[#, 0.03158739843645345, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{12., 21., -0.06835400612104778}],
     RowBox[{"-", "0.06835400612104778`"}]],
    Annotation[#, -0.06835400612104778, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{12., 22., -0.16761244004421877`}],
     RowBox[{"-", "0.16761244004421877`"}]],
    Annotation[#, -0.16761244004421877`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{12., 23., -0.26519614587177337`}],
     RowBox[{"-", "0.26519614587177337`"}]],
    Annotation[#, -0.26519614587177337`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{12., 24., -0.360130099471969}],
     RowBox[{"-", "0.360130099471969`"}]],
    Annotation[#, -0.360130099471969, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{12., 25., -0.45146575216142354`}],
     RowBox[{"-", "0.45146575216142354`"}]],
    Annotation[#, -0.45146575216142354`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{12., 26., -0.5382905082900177}],
     RowBox[{"-", "0.5382905082900177`"}]],
    Annotation[#, -0.5382905082900177, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{12., 27., -0.6197368435949636}],
     RowBox[{"-", "0.6197368435949636`"}]],
    Annotation[#, -0.6197368435949636, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{12., 28., -0.694990973216472}],
     RowBox[{"-", "0.694990973216472`"}]],
    Annotation[#, -0.694990973216472, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{12., 29., -0.7633009827670739}],
     RowBox[{"-", "0.7633009827670739`"}]],
    Annotation[#, -0.7633009827670739, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{12., 30., -0.8239843412116258}],
     RowBox[{"-", "0.8239843412116258`"}]],
    Annotation[#, -0.8239843412116258, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{12., 31., -0.8764347204918014}],
     RowBox[{"-", "0.8764347204918014`"}]],
    Annotation[#, -0.8764347204918014, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{13., 1., 0.9914583481916865}],
     "0.9914583481916865`"],
    Annotation[#, 0.9914583481916865, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{13., 2., 0.9995258306054791}],
     "0.9995258306054791`"],
    Annotation[#, 0.9995258306054791, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{13., 3., 0.9976063813191737}],
     "0.9976063813191737`"],
    Annotation[#, 0.9976063813191737, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{13., 4., 0.9857191788355534}],
     "0.9857191788355534`"],
    Annotation[#, 0.9857191788355534, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{13., 5., 0.9639829961524481}],
     "0.9639829961524481`"],
    Annotation[#, 0.9639829961524481, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{13., 6., 0.9326150140222004}],
     "0.9326150140222004`"],
    Annotation[#, 0.9326150140222004, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{13., 7., 0.8919286509533794}],
     "0.8919286509533794`"],
    Annotation[#, 0.8919286509533794, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{13., 8., 0.8423304316366454}],
     "0.8423304316366454`"],
    Annotation[#, 0.8423304316366454, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{13., 9., 0.7843159250844198}],
     "0.7843159250844198`"],
    Annotation[#, 0.7843159250844198, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{13., 10., 0.7184647930691259}],
     "0.7184647930691259`"],
    Annotation[#, 0.7184647930691259, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{13., 11., 0.6454349983343703}],
     "0.6454349983343703`"],
    Annotation[#, 0.6454349983343703, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{13., 12., 0.5659562304487024}],
     "0.5659562304487024`"],
    Annotation[#, 0.5659562304487024, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{13., 13., 0.48082261498864787`}],
     "0.48082261498864787`"],
    Annotation[#, 0.48082261498864787`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{13., 14., 0.3908847788984522}],
     "0.3908847788984522`"],
    Annotation[#, 0.3908847788984522, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{13., 15., 0.29704135130683157`}],
     "0.29704135130683157`"],
    Annotation[#, 0.29704135130683157`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{13., 16., 0.2002299847217701}],
     "0.2002299847217701`"],
    Annotation[#, 0.2002299847217701, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{13., 17., 0.10141798631660143`}],
     "0.10141798631660143`"],
    Annotation[#, 0.10141798631660143`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{13., 18., 0.0015926529164863841`}],
     "0.0015926529164863841`"],
    Annotation[#, 0.0015926529164863841`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{13., 19., -0.09824859374510868}],
     RowBox[{"-", "0.09824859374510868`"}]],
    Annotation[#, -0.09824859374510868, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{13., 20., -0.19710817293467073`}],
     RowBox[{"-", "0.19710817293467073`"}]],
    Annotation[#, -0.19710817293467073`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{13., 21., -0.293998312415568}],
     RowBox[{"-", "0.293998312415568`"}]],
    Annotation[#, -0.293998312415568, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{13., 22., -0.3879509179417307}],
     RowBox[{"-", "0.3879509179417307`"}]],
    Annotation[#, -0.3879509179417307, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{13., 23., -0.47802724613534325`}],
     RowBox[{"-", "0.47802724613534325`"}]],
    Annotation[#, -0.47802724613534325`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{13., 24., -0.5633272841003705}],
     RowBox[{"-", "0.5633272841003705`"}]],
    Annotation[#, -0.5633272841003705, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{13., 25., -0.6429987420539095}],
     RowBox[{"-", "0.6429987420539095`"}]],
    Annotation[#, -0.6429987420539095, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{13., 26., -0.7162455691239709}],
     RowBox[{"-", "0.7162455691239709`"}]],
    Annotation[#, -0.7162455691239709, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{13., 27., -0.7823359072266534}],
     RowBox[{"-", "0.7823359072266534`"}]],
    Annotation[#, -0.7823359072266534, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{13., 28., -0.840609403550195}],
     RowBox[{"-", "0.840609403550195`"}]],
    Annotation[#, -0.840609403550195, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{13., 29., -0.8904838085819885}],
     RowBox[{"-", "0.8904838085819885`"}]],
    Annotation[#, -0.8904838085819885, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{13., 30., -0.9314607937532429}],
     RowBox[{"-", "0.9314607937532429`"}]],
    Annotation[#, -0.9314607937532429, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{13., 31., -0.9631309305733167}],
     RowBox[{"-", "0.9631309305733167`"}]],
    Annotation[#, -0.9631309305733167, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{14., 1., 0.9929036510941185}],
     "0.9929036510941185`"],
    Annotation[#, 0.9929036510941185, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{14., 2., 0.9760709219825241}],
     "0.9760709219825241`"],
    Annotation[#, 0.9760709219825241, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{14., 3., 0.9494856148646305}],
     "0.9494856148646305`"],
    Annotation[#, 0.9494856148646305, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{14., 4., 0.9134133613412251}],
     "0.9134133613412251`"],
    Annotation[#, 0.9134133613412251, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{14., 5., 0.8682145834456124}],
     "0.8682145834456124`"],
    Annotation[#, 0.8682145834456124, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{14., 6., 0.8143408924257957}],
     "0.8143408924257957`"],
    Annotation[#, 0.8143408924257957, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{14., 7., 0.7523305763941707}],
     "0.7523305763941707`"],
    Annotation[#, 0.7523305763941707, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{14., 8., 0.6828032219306397}],
     "0.6828032219306397`"],
    Annotation[#, 0.6828032219306397, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{14., 9., 0.6064535233783147}],
     "0.6064535233783147`"],
    Annotation[#, 0.6064535233783147, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{14., 10., 0.5240443416872758}],
     "0.5240443416872758`"],
    Annotation[#, 0.5240443416872758, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{14., 11., 0.4363990821601259}],
     "0.4363990821601259`"],
    Annotation[#, 0.4363990821601259, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{14., 12., 0.34439346725839}],
     "0.34439346725839`"],
    Annotation[#, 0.34439346725839, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{14., 13., 0.24894678667315215`}],
     "0.24894678667315215`"],
    Annotation[#, 0.24894678667315215`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{14., 14., 0.15101271208634384`}],
     "0.15101271208634384`"],
    Annotation[#, 0.15101271208634384`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{14., 15., 0.051569768398534194`}],
     "0.051569768398534194`"],
    Annotation[#, 0.051569768398534194`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{14., 16., -0.048388443368414594`}],
     RowBox[{"-", "0.048388443368414594`"}]],
    Annotation[#, -0.048388443368414594`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{14., 17., -0.14786317380431852`}],
     RowBox[{"-", "0.14786317380431852`"}]],
    Annotation[#, -0.14786317380431852`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{14., 18., -0.24586050428463746`}],
     RowBox[{"-", "0.24586050428463746`"}]],
    Annotation[#, -0.24586050428463746`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{14., 19., -0.34140127787682095`}],
     RowBox[{"-", "0.34140127787682095`"}]],
    Annotation[#, -0.34140127787682095`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{14., 20., -0.4335308827527181}],
     RowBox[{"-", "0.4335308827527181`"}]],
    Annotation[#, -0.4335308827527181, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{14., 21., -0.5213287903544069}],
     RowBox[{"-", "0.5213287903544069`"}]],
    Annotation[#, -0.5213287903544069, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{14., 22., -0.6039177530112606}],
     RowBox[{"-", "0.6039177530112606`"}]],
    Annotation[#, -0.6039177530112606, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{14., 23., -0.6804725691086944}],
     RowBox[{"-", "0.6804725691086944`"}]],
    Annotation[#, -0.6804725691086944, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{14., 24., -0.750228328229919}],
     RowBox[{"-", "0.750228328229919`"}]],
    Annotation[#, -0.750228328229919, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{14., 25., -0.8124880538879847}],
     RowBox[{"-", "0.8124880538879847`"}]],
    Annotation[#, -0.8124880538879847, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{14., 26., -0.8666296674844443}],
     RowBox[{"-", "0.8666296674844443`"}]],
    Annotation[#, -0.8666296674844443, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{14., 27., -0.9121122039130803}],
     RowBox[{"-", "0.9121122039130803`"}]],
    Annotation[#, -0.9121122039130803, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{14., 28., -0.9484812167044259}],
     RowBox[{"-", "0.9484812167044259`"}]],
    Annotation[#, -0.9484812167044259, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{14., 29., -0.9753733187046665}],
     RowBox[{"-", "0.9753733187046665`"}]],
    Annotation[#, -0.9753733187046665, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{14., 30., -0.9925198129199633}],
     RowBox[{"-", "0.9925198129199633`"}]],
    Annotation[#, -0.9925198129199633, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{14., 31., -0.999749377247994}],
     RowBox[{"-", "0.999749377247994`"}]],
    Annotation[#, -0.999749377247994, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{15., 1., 0.925211520788168}],
     "0.925211520788168`"],
    Annotation[#, 0.925211520788168, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{15., 2., 0.8827073508159738}],
     "0.8827073508159738`"],
    Annotation[#, 0.8827073508159738, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{15., 3., 0.8313834607786829}],
     "0.8313834607786829`"],
    Annotation[#, 0.8313834607786829, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{15., 4., 0.7717526620201254}],
     "0.7717526620201254`"],
    Annotation[#, 0.7717526620201254, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{15., 5., 0.7044107657701759}],
     "0.7044107657701759`"],
    Annotation[#, 0.7044107657701759, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{15., 6., 0.6300306299958919}],
     "0.6300306299958919`"],
    Annotation[#, 0.6300306299958919, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{15., 7., 0.5493554364271263}],
     "0.5493554364271263`"],
    Annotation[#, 0.5493554364271263, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{15., 8., 0.4631912649303448}],
     "0.4631912649303448`"],
    Annotation[#, 0.4631912649303448, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{15., 9., 0.37239903942505487`}],
     "0.37239903942505487`"],
    Annotation[#, 0.37239903942505487`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{15., 10., 0.27788592581658633`}],
     "0.27788592581658633`"],
    Annotation[#, 0.27788592581658633`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{15., 11., 0.1805962678942325}],
     "0.1805962678942325`"],
    Annotation[#, 0.1805962678942325, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{15., 12., 0.08150215176026868}],
     "0.08150215176026868`"],
    Annotation[#, 0.08150215176026868, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{15., 13., -0.018406306933054253`}],
     RowBox[{"-", "0.018406306933054253`"}]],
    Annotation[#, -0.018406306933054253`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{15., 14., -0.11813085589181825`}],
     RowBox[{"-", "0.11813085589181825`"}]],
    Annotation[#, -0.11813085589181825`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{15., 15., -0.21667508038738006`}],
     RowBox[{"-", "0.21667508038738006`"}]],
    Annotation[#, -0.21667508038738006`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{15., 16., -0.31305435910297064`}],
     RowBox[{"-", "0.31305435910297064`"}]],
    Annotation[#, -0.31305435910297064`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{15., 17., -0.4063057021444172}],
     RowBox[{"-", "0.4063057021444172`"}]],
    Annotation[#, -0.4063057021444172, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{15., 18., -0.4954973729168453}],
     RowBox[{"-", "0.4954973729168453`"}]],
    Annotation[#, -0.4954973729168453, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{15., 19., -0.5797381977287435}],
     RowBox[{"-", "0.5797381977287435`"}]],
    Annotation[#, -0.5797381977287435, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{15., 20., -0.6581864701049053}],
     RowBox[{"-", "0.6581864701049053`"}]],
    Annotation[#, -0.6581864701049053, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{15., 21., -0.7300583608392999}],
     RowBox[{"-", "0.7300583608392999`"}]],
    Annotation[#, -0.7300583608392999, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{15., 22., -0.7946357497573974}],
     RowBox[{"-", "0.7946357497573974`"}]],
    Annotation[#, -0.7946357497573974, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{15., 23., -0.8512734009355745}],
     RowBox[{"-", "0.8512734009355745`"}]],
    Annotation[#, -0.8512734009355745, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{15., 24., -0.899405409685178}],
     RowBox[{"-", "0.899405409685178`"}]],
    Annotation[#, -0.899405409685178, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{15., 25., -0.9385508568851082}],
     RowBox[{"-", "0.9385508568851082`"}]],
    Annotation[#, -0.9385508568851082, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{15., 26., -0.9683186141667074}],
     RowBox[{"-", "0.9683186141667074`"}]],
    Annotation[#, -0.9683186141667074, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{15., 27., -0.9884112519391306}],
     RowBox[{"-", "0.9884112519391306`"}]],
    Annotation[#, -0.9884112519391306, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{15., 28., -0.9986280112074989}],
     RowBox[{"-", "0.9986280112074989`"}]],
    Annotation[#, -0.9986280112074989, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{15., 29., -0.9988668094904142}],
     RowBox[{"-", "0.9988668094904142`"}]],
    Annotation[#, -0.9988668094904142, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{15., 30., -0.9891252607943697}],
     RowBox[{"-", "0.9891252607943697`"}]],
    Annotation[#, -0.9891252607943697, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{15., 31., -0.9695006994538086}],
     RowBox[{"-", "0.9695006994538086`"}]],
    Annotation[#, -0.9695006994538086, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{16., 1., 0.7780731968879212}],
     "0.7780731968879212`"],
    Annotation[#, 0.7780731968879212, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{16., 2., 0.7114733527908443}],
     "0.7114733527908443`"],
    Annotation[#, 0.7114733527908443, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{16., 3., 0.6377647021345036}],
     "0.6377647021345036`"],
    Annotation[#, 0.6377647021345036, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{16., 4., 0.557683717391417}],
     "0.557683717391417`"],
    Annotation[#, 0.557683717391417, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{16., 5., 0.47203054128988264`}],
     "0.47203054128988264`"],
    Annotation[#, 0.47203054128988264`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{16., 6., 0.38166099205233167`}],
     "0.38166099205233167`"],
    Annotation[#, 0.38166099205233167`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{16., 7., 0.2874780123425444}],
     "0.2874780123425444`"],
    Annotation[#, 0.2874780123425444, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{16., 8., 0.19042264736102704`}],
     "0.19042264736102704`"],
    Annotation[#, 0.19042264736102704`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{16., 9., 0.0914646422324372}],
     "0.0914646422324372`"],
    Annotation[#, 0.0914646422324372, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{16., 10., -0.008407247367148618}],
     RowBox[{"-", "0.008407247367148618`"}]],
    Annotation[#, -0.008407247367148618, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{16., 11., -0.10819513453010837`}],
     RowBox[{"-", "0.10819513453010837`"}]],
    Annotation[#, -0.10819513453010837`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{16., 12., -0.20690197167339977`}],
     RowBox[{"-", "0.20690197167339977`"}]],
    Annotation[#, -0.20690197167339977`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{16., 13., -0.30354151270842933`}],
     RowBox[{"-", "0.30354151270842933`"}]],
    Annotation[#, -0.30354151270842933`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{16., 14., -0.3971481672859598}],
     RowBox[{"-", "0.3971481672859598`"}]],
    Annotation[#, -0.3971481672859598, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{16., 15., -0.48678664865569976`}],
     RowBox[{"-", "0.48678664865569976`"}]],
    Annotation[#, -0.48678664865569976`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{16., 16., -0.5715613187423437}],
     RowBox[{"-", "0.5715613187423437`"}]],
    Annotation[#, -0.5715613187423437, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{16., 17., -0.6506251370651673}],
     RowBox[{"-", "0.6506251370651673`"}]],
    Annotation[#, -0.6506251370651673, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{16., 18., -0.7231881240865121}],
     RowBox[{"-", "0.7231881240865121`"}]],
    Annotation[#, -0.7231881240865121, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{16., 19., -0.788525254426195}],
     RowBox[{"-", "0.788525254426195`"}]],
    Annotation[#, -0.788525254426195, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{16., 20., -0.8459837010754465}],
     RowBox[{"-", "0.8459837010754465`"}]],
    Annotation[#, -0.8459837010754465, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{16., 21., -0.8949893582285835}],
     RowBox[{"-", "0.8949893582285835`"}]],
    Annotation[#, -0.8949893582285835, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{16., 22., -0.9350525775584491}],
     RowBox[{"-", "0.9350525775584491`"}]],
    Annotation[#, -0.9350525775584491, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{16., 23., -0.9657730606206388}],
     RowBox[{"-", "0.9657730606206388`"}]],
    Annotation[#, -0.9657730606206388, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{16., 24., -0.9868438585032366}],
     RowBox[{"-", "0.9868438585032366`"}]],
    Annotation[#, -0.9868438585032366, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{16., 25., -0.9980544387588794}],
     RowBox[{"-", "0.9980544387588794`"}]],
    Annotation[#, -0.9980544387588794, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{16., 26., -0.999292788975378}],
     RowBox[{"-", "0.999292788975378`"}]],
    Annotation[#, -0.999292788975378, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{16., 27., -0.9905465359667133}],
     RowBox[{"-", "0.9905465359667133`"}]],
    Annotation[#, -0.9905465359667133, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{16., 28., -0.9719030694018208}],
     RowBox[{"-", "0.9719030694018208`"}]],
    Annotation[#, -0.9719030694018208, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{16., 29., -0.9435486686359064}],
     RowBox[{"-", "0.9435486686359064`"}]],
    Annotation[#, -0.9435486686359064, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{16., 30., -0.9057666414687044}],
     RowBox[{"-", "0.9057666414687044`"}]],
    Annotation[#, -0.9057666414687044, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{16., 31., -0.858934493426592}],
     RowBox[{"-", "0.858934493426592`"}]],
    Annotation[#, -0.858934493426592, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{17., 1., 0.5493554364271263}],
     "0.5493554364271263`"],
    Annotation[#, 0.5493554364271263, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{17., 2., 0.4631912649303448}],
     "0.4631912649303448`"],
    Annotation[#, 0.4631912649303448, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{17., 3., 0.37239903942505487`}],
     "0.37239903942505487`"],
    Annotation[#, 0.37239903942505487`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{17., 4., 0.27788592581658633`}],
     "0.27788592581658633`"],
    Annotation[#, 0.27788592581658633`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{17., 5., 0.1805962678942325}],
     "0.1805962678942325`"],
    Annotation[#, 0.1805962678942325, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{17., 6., 0.08150215176026868}],
     "0.08150215176026868`"],
    Annotation[#, 0.08150215176026868, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{17., 7., -0.018406306933054253`}],
     RowBox[{"-", "0.018406306933054253`"}]],
    Annotation[#, -0.018406306933054253`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{17., 8., -0.11813085589181825`}],
     RowBox[{"-", "0.11813085589181825`"}]],
    Annotation[#, -0.11813085589181825`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{17., 9., -0.21667508038738006`}],
     RowBox[{"-", "0.21667508038738006`"}]],
    Annotation[#, -0.21667508038738006`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{17., 10., -0.31305435910297064`}],
     RowBox[{"-", "0.31305435910297064`"}]],
    Annotation[#, -0.31305435910297064`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{17., 11., -0.4063057021444172}],
     RowBox[{"-", "0.4063057021444172`"}]],
    Annotation[#, -0.4063057021444172, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{17., 12., -0.4954973729168453}],
     RowBox[{"-", "0.4954973729168453`"}]],
    Annotation[#, -0.4954973729168453, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{17., 13., -0.5797381977287435}],
     RowBox[{"-", "0.5797381977287435`"}]],
    Annotation[#, -0.5797381977287435, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{17., 14., -0.6581864701049053}],
     RowBox[{"-", "0.6581864701049053`"}]],
    Annotation[#, -0.6581864701049053, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{17., 15., -0.7300583608393002}],
     RowBox[{"-", "0.7300583608393002`"}]],
    Annotation[#, -0.7300583608393002, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{17., 16., -0.7946357497573974}],
     RowBox[{"-", "0.7946357497573974`"}]],
    Annotation[#, -0.7946357497573974, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{17., 17., -0.8512734009355745}],
     RowBox[{"-", "0.8512734009355745`"}]],
    Annotation[#, -0.8512734009355745, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{17., 18., -0.899405409685178}],
     RowBox[{"-", "0.899405409685178`"}]],
    Annotation[#, -0.899405409685178, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{17., 19., -0.9385508568851079}],
     RowBox[{"-", "0.9385508568851079`"}]],
    Annotation[#, -0.9385508568851079, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{17., 20., -0.9683186141667074}],
     RowBox[{"-", "0.9683186141667074`"}]],
    Annotation[#, -0.9683186141667074, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{17., 21., -0.9884112519391306}],
     RowBox[{"-", "0.9884112519391306`"}]],
    Annotation[#, -0.9884112519391306, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{17., 22., -0.9986280112074989}],
     RowBox[{"-", "0.9986280112074989`"}]],
    Annotation[#, -0.9986280112074989, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{17., 23., -0.9988668094904142}],
     RowBox[{"-", "0.9988668094904142`"}]],
    Annotation[#, -0.9988668094904142, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{17., 24., -0.9891252607943697}],
     RowBox[{"-", "0.9891252607943697`"}]],
    Annotation[#, -0.9891252607943697, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{17., 25., -0.9695006994538086}],
     RowBox[{"-", "0.9695006994538086`"}]],
    Annotation[#, -0.9695006994538086, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{17., 26., -0.9401892075986283}],
     RowBox[{"-", "0.9401892075986283`"}]],
    Annotation[#, -0.9401892075986283, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{17., 27., -0.9014836559663548}],
     RowBox[{"-", "0.9014836559663548`"}]],
    Annotation[#, -0.9014836559663548, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{17., 28., -0.8537707776345429}],
     RowBox[{"-", "0.8537707776345429`"}]],
    Annotation[#, -0.8537707776345429, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{17., 29., -0.7975273039117038}],
     RowBox[{"-", "0.7975273039117038`"}]],
    Annotation[#, -0.7975273039117038, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{17., 30., -0.733315200995656}],
     RowBox[{"-", "0.733315200995656`"}]],
    Annotation[#, -0.733315200995656, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{17., 31., -0.6617760549930369}],
     RowBox[{"-", "0.6617760549930369`"}]],
    Annotation[#, -0.6617760549930369, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{18., 1., 0.24894678667315215`}],
     "0.24894678667315215`"],
    Annotation[#, 0.24894678667315215`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{18., 2., 0.1510127120863434}],
     "0.1510127120863434`"],
    Annotation[#, 0.1510127120863434, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{18., 3., 0.05156976839853375}],
     "0.05156976839853375`"],
    Annotation[#, 0.05156976839853375, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{18., 4., -0.048388443368414594`}],
     RowBox[{"-", "0.048388443368414594`"}]],
    Annotation[#, -0.048388443368414594`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{18., 5., -0.14786317380431896`}],
     RowBox[{"-", "0.14786317380431896`"}]],
    Annotation[#, -0.14786317380431896`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{18., 6., -0.24586050428463746`}],
     RowBox[{"-", "0.24586050428463746`"}]],
    Annotation[#, -0.24586050428463746`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{18., 7., -0.3414012778768214}],
     RowBox[{"-", "0.3414012778768214`"}]],
    Annotation[#, -0.3414012778768214, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{18., 8., -0.4335308827527185}],
     RowBox[{"-", "0.4335308827527185`"}]],
    Annotation[#, -0.4335308827527185, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{18., 9., -0.5213287903544069}],
     RowBox[{"-", "0.5213287903544069`"}]],
    Annotation[#, -0.5213287903544069, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{18., 10., -0.6039177530112609}],
     RowBox[{"-", "0.6039177530112609`"}]],
    Annotation[#, -0.6039177530112609, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{18., 11., -0.6804725691086944}],
     RowBox[{"-", "0.6804725691086944`"}]],
    Annotation[#, -0.6804725691086944, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{18., 12., -0.7502283282299193}],
     RowBox[{"-", "0.7502283282299193`"}]],
    Annotation[#, -0.7502283282299193, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{18., 13., -0.8124880538879847}],
     RowBox[{"-", "0.8124880538879847`"}]],
    Annotation[#, -0.8124880538879847, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{18., 14., -0.8666296674844443}],
     RowBox[{"-", "0.8666296674844443`"}]],
    Annotation[#, -0.8666296674844443, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{18., 15., -0.9121122039130807}],
     RowBox[{"-", "0.9121122039130807`"}]],
    Annotation[#, -0.9121122039130807, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{18., 16., -0.9484812167044259}],
     RowBox[{"-", "0.9484812167044259`"}]],
    Annotation[#, -0.9484812167044259, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{18., 17., -0.9753733187046665}],
     RowBox[{"-", "0.9753733187046665`"}]],
    Annotation[#, -0.9753733187046665, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{18., 18., -0.9925198129199633}],
     RowBox[{"-", "0.9925198129199633`"}]],
    Annotation[#, -0.9925198129199633, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{18., 19., -0.999749377247994}],
     RowBox[{"-", "0.999749377247994`"}]],
    Annotation[#, -0.999749377247994, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{18., 20., -0.9969897762717694}],
     RowBox[{"-", "0.9969897762717694`"}]],
    Annotation[#, -0.9969897762717694, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{18., 21., -0.9842685830120413}],
     RowBox[{"-", "0.9842685830120413`"}]],
    Annotation[#, -0.9842685830120413, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{18., 22., -0.9617129034267934}],
     RowBox[{"-", "0.9617129034267934`"}]],
    Annotation[#, -0.9617129034267934, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{18., 23., -0.9295481064105248}],
     RowBox[{"-", "0.9295481064105248`"}]],
    Annotation[#, -0.9295481064105248, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{18., 24., -0.8880955719827539}],
     RowBox[{"-", "0.8880955719827539`"}]],
    Annotation[#, -0.8880955719827539, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{18., 25., -0.8377694801650973}],
     RowBox[{"-", "0.8377694801650973`"}]],
    Annotation[#, -0.8377694801650973, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{18., 26., -0.7790726726314026}],
     RowBox[{"-", "0.7790726726314026`"}]],
    Annotation[#, -0.7790726726314026, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{18., 27., -0.7125916284799615}],
     RowBox[{"-", "0.7125916284799615`"}]],
    Annotation[#, -0.7125916284799615, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{18., 28., -0.6389906043282231}],
     RowBox[{"-", "0.6389906043282231`"}]],
    Annotation[#, -0.6389906043282231, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{18., 29., -0.5590049972802481}],
     RowBox[{"-", "0.5590049972802481`"}]],
    Annotation[#, -0.5590049972802481, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{18., 30., -0.4734339970819343}],
     RowBox[{"-", "0.4734339970819343`"}]],
    Annotation[#, -0.4734339970819343, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{18., 31., -0.38313260088125056`}],
     RowBox[{"-", "0.38313260088125056`"}]],
    Annotation[#, -0.38313260088125056`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{19., 1., -0.09824859374510868}],
     RowBox[{"-", "0.09824859374510868`"}]],
    Annotation[#, -0.09824859374510868, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{19., 2., -0.19710817293467028`}],
     RowBox[{"-", "0.19710817293467028`"}]],
    Annotation[#, -0.19710817293467028`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{19., 3., -0.293998312415568}],
     RowBox[{"-", "0.293998312415568`"}]],
    Annotation[#, -0.293998312415568, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{19., 4., -0.3879509179417303}],
     RowBox[{"-", "0.3879509179417303`"}]],
    Annotation[#, -0.3879509179417303, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{19., 5., -0.47802724613534286`}],
     RowBox[{"-", "0.47802724613534286`"}]],
    Annotation[#, -0.47802724613534286`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{19., 6., -0.56332728410037}],
     RowBox[{"-", "0.56332728410037`"}]],
    Annotation[#, -0.56332728410037, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{19., 7., -0.6429987420539092}],
     RowBox[{"-", "0.6429987420539092`"}]],
    Annotation[#, -0.6429987420539092, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{19., 8., -0.7162455691239709}],
     RowBox[{"-", "0.7162455691239709`"}]],
    Annotation[#, -0.7162455691239709, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{19., 9., -0.7823359072266528}],
     RowBox[{"-", "0.7823359072266528`"}]],
    Annotation[#, -0.7823359072266528, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{19., 10., -0.840609403550195}],
     RowBox[{"-", "0.840609403550195`"}]],
    Annotation[#, -0.840609403550195, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{19., 11., -0.8904838085819885}],
     RowBox[{"-", "0.8904838085819885`"}]],
    Annotation[#, -0.8904838085819885, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{19., 12., -0.9314607937532425}],
     RowBox[{"-", "0.9314607937532425`"}]],
    Annotation[#, -0.9314607937532425, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{19., 13., -0.9631309305733167}],
     RowBox[{"-", "0.9631309305733167`"}]],
    Annotation[#, -0.9631309305733167, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{19., 14., -0.9851777815038595}],
     RowBox[{"-", "0.9851777815038595`"}]],
    Annotation[#, -0.9851777815038595, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{19., 15., -0.9973810616980934}],
     RowBox[{"-", "0.9973810616980934`"}]],
    Annotation[#, -0.9973810616980934, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{19., 16., -0.9996188400141854}],
     RowBox[{"-", "0.9996188400141854`"}]],
    Annotation[#, -0.9996188400141854, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{19., 17., -0.9918687573109126}],
     RowBox[{"-", "0.9918687573109126`"}]],
    Annotation[#, -0.9918687573109126, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{19., 18., -0.9742082498528091}],
     RowBox[{"-", "0.9742082498528091`"}]],
    Annotation[#, -0.9742082498528091, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{19., 19., -0.9468137755926089}],
     RowBox[{"-", "0.9468137755926089`"}]],
    Annotation[#, -0.9468137755926089, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{19., 20., -0.9099590510617103}],
     RowBox[{"-", "0.9099590510617103`"}]],
    Annotation[#, -0.9099590510617103, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{19., 21., -0.8640123164850744}],
     RowBox[{"-", "0.8640123164850744`"}]],
    Annotation[#, -0.8640123164850744, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{19., 22., -0.8094326564466194}],
     RowBox[{"-", "0.8094326564466194`"}]],
    Annotation[#, -0.8094326564466194, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{19., 23., -0.7467654128678123}],
     RowBox[{"-", "0.7467654128678123`"}]],
    Annotation[#, -0.7467654128678123, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{19., 24., -0.6766367361314563}],
     RowBox[{"-", "0.6766367361314563`"}]],
    Annotation[#, -0.6766367361314563, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{19., 25., -0.599747328794043}],
     RowBox[{"-", "0.599747328794043`"}]],
    Annotation[#, -0.599747328794043, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{19., 26., -0.5168654443974288}],
     RowBox[{"-", "0.5168654443974288`"}]],
    Annotation[#, -0.5168654443974288, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{19., 27., -0.4288192113333959}],
     RowBox[{"-", "0.4288192113333959`"}]],
    Annotation[#, -0.4288192113333959, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{19., 28., -0.3364883584585042}],
     RowBox[{"-", "0.3364883584585042`"}]],
    Annotation[#, -0.3364883584585042, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{19., 29., -0.24079542513415833`}],
     RowBox[{"-", "0.24079542513415833`"}]],
    Annotation[#, -0.24079542513415833`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{19., 30., -0.14269654351825772`}],
     RowBox[{"-", "0.14269654351825772`"}]],
    Annotation[#, -0.14269654351825772`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{19., 31., -0.04317188520872868}],
     RowBox[{"-", "0.04317188520872868`"}]],
    Annotation[#, -0.04317188520872868, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{20., 1., -0.45146575216142354`}],
     RowBox[{"-", "0.45146575216142354`"}]],
    Annotation[#, -0.45146575216142354`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{20., 2., -0.538290508290018}],
     RowBox[{"-", "0.538290508290018`"}]],
    Annotation[#, -0.538290508290018, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{20., 3., -0.6197368435949636}],
     RowBox[{"-", "0.6197368435949636`"}]],
    Annotation[#, -0.6197368435949636, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{20., 4., -0.694990973216472}],
     RowBox[{"-", "0.694990973216472`"}]],
    Annotation[#, -0.694990973216472, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{20., 5., -0.7633009827670739}],
     RowBox[{"-", "0.7633009827670739`"}]],
    Annotation[#, -0.7633009827670739, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{20., 6., -0.8239843412116258}],
     RowBox[{"-", "0.8239843412116258`"}]],
    Annotation[#, -0.8239843412116258, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{20., 7., -0.8764347204918018}],
     RowBox[{"-", "0.8764347204918018`"}]],
    Annotation[#, -0.8764347204918018, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{20., 8., -0.920128053755624}],
     RowBox[{"-", "0.920128053755624`"}]],
    Annotation[#, -0.920128053755624, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{20., 9., -0.9546277716602164}],
     RowBox[{"-", "0.9546277716602164`"}]],
    Annotation[#, -0.9546277716602164, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{20., 10., -0.979589164428367}],
     RowBox[{"-", "0.979589164428367`"}]],
    Annotation[#, -0.979589164428367, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{20., 11., -0.9947628260746756}],
     RowBox[{"-", "0.9947628260746756`"}]],
    Annotation[#, -0.9947628260746756, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{20., 12., -0.999997146387718}],
     RowBox[{"-", "0.999997146387718`"}]],
    Annotation[#, -0.999997146387718, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{20., 13., -0.9952398257691626}],
     RowBox[{"-", "0.9952398257691626`"}]],
    Annotation[#, -0.9952398257691626, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{20., 14., -0.9805383977940689}],
     RowBox[{"-", "0.9805383977940689`"}]],
    Annotation[#, -0.9805383977940689, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{20., 15., -0.9560397542711179}],
     RowBox[{"-", "0.9560397542711179`"}]],
    Annotation[#, -0.9560397542711179, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{20., 16., -0.9219886775482162}],
     RowBox[{"-", "0.9219886775482162`"}]],
    Annotation[#, -0.9219886775482162, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{20., 17., -0.8787253947281894}],
     RowBox[{"-", "0.8787253947281894`"}]],
    Annotation[#, -0.8787253947281894, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{20., 18., -0.8266821782320357}],
     RowBox[{"-", "0.8266821782320357`"}]],
    Annotation[#, -0.8266821782320357, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{20., 19., -0.7663790266757844}],
     RowBox[{"-", "0.7663790266757844`"}]],
    Annotation[#, -0.7663790266757844, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{20., 20., -0.698418469216213}],
     RowBox[{"-", "0.698418469216213`"}]],
    Annotation[#, -0.698418469216213, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{20., 21., -0.6234795452786853}],
     RowBox[{"-", "0.6234795452786853`"}]],
    Annotation[#, -0.6234795452786853, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{20., 22., -0.542311019819669}],
     RowBox[{"-", "0.542311019819669`"}]],
    Annotation[#, -0.542311019819669, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{20., 23., -0.4557239019148047}],
     RowBox[{"-", "0.4557239019148047`"}]],
    Annotation[#, -0.4557239019148047, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{20., 24., -0.3645833414243013}],
     RowBox[{"-", "0.3645833414243013`"}]],
    Annotation[#, -0.3645833414243013, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{20., 25., -0.26979998470151534`}],
     RowBox[{"-", "0.26979998470151534`"}]],
    Annotation[#, -0.26979998470151534`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{20., 26., -0.17232087571561025`}],
     RowBox[{"-", "0.17232087571561025`"}]],
    Annotation[#, -0.17232087571561025`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{20., 27., -0.0731199935012622}],
     RowBox[{"-", "0.0731199935012622`"}]],
    Annotation[#, -0.0731199935012622, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{20., 28., 0.026811479517893238`}],
     "0.026811479517893238`"],
    Annotation[#, 0.026811479517893238`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{20., 29., 0.1264750610964027}],
     "0.1264750610964027`"],
    Annotation[#, 0.1264750610964027, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{20., 30., 0.2248749456715346}],
     "0.2248749456715346`"],
    Annotation[#, 0.2248749456715346, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{20., 31., 0.32102795412328977`}],
     "0.32102795412328977`"],
    Annotation[#, 0.32102795412328977`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{21., 1., -0.7568024953079282}],
     RowBox[{"-", "0.7568024953079282`"}]],
    Annotation[#, -0.7568024953079282, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{21., 2., -0.8182771110644103}],
     RowBox[{"-", "0.8182771110644103`"}]],
    Annotation[#, -0.8182771110644103, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{21., 3., -0.8715757724135882}],
     RowBox[{"-", "0.8715757724135882`"}]],
    Annotation[#, -0.8715757724135882, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{21., 4., -0.9161659367494549}],
     RowBox[{"-", "0.9161659367494549`"}]],
    Annotation[#, -0.9161659367494549, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{21., 5., -0.951602073889516}],
     RowBox[{"-", "0.951602073889516`"}]],
    Annotation[#, -0.951602073889516, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{21., 6., -0.977530117665097}],
     RowBox[{"-", "0.977530117665097`"}]],
    Annotation[#, -0.977530117665097, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{21., 7., -0.9936910036334644}],
     RowBox[{"-", "0.9936910036334644`"}]],
    Annotation[#, -0.9936910036334644, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{21., 8., -0.9999232575641008}],
     RowBox[{"-", "0.9999232575641008`"}]],
    Annotation[#, -0.9999232575641008, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{21., 9., -0.9961646088358407}],
     RowBox[{"-", "0.9961646088358407`"}]],
    Annotation[#, -0.9961646088358407, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{21., 10., -0.9824526126243325}],
     RowBox[{"-", "0.9824526126243325`"}]],
    Annotation[#, -0.9824526126243325, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{21., 11., -0.9589242746631385}],
     RowBox[{"-", "0.9589242746631385`"}]],
    Annotation[#, -0.9589242746631385, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{21., 12., -0.9258146823277325}],
     RowBox[{"-", "0.9258146823277325`"}]],
    Annotation[#, -0.9258146823277325, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{21., 13., -0.8834546557201531}],
     RowBox[{"-", "0.8834546557201531`"}]],
    Annotation[#, -0.8834546557201531, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{21., 14., -0.8322674422239013}],
     RowBox[{"-", "0.8322674422239013`"}]],
    Annotation[#, -0.8322674422239013, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{21., 15., -0.7727644875559871}],
     RowBox[{"-", "0.7727644875559871`"}]],
    Annotation[#, -0.7727644875559871, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{21., 16., -0.7055403255703919}],
     RowBox[{"-", "0.7055403255703919`"}]],
    Annotation[#, -0.7055403255703919, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{21., 17., -0.6312666378723216}],
     RowBox[{"-", "0.6312666378723216`"}]],
    Annotation[#, -0.6312666378723216, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{21., 18., -0.5506855425976376}],
     RowBox[{"-", "0.5506855425976376`"}]],
    Annotation[#, -0.5506855425976376, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{21., 19., -0.46460217941375737`}],
     RowBox[{"-", "0.46460217941375737`"}]],
    Annotation[#, -0.46460217941375737`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{21., 20., -0.373876664830236}],
     RowBox[{"-", "0.373876664830236`"}]],
    Annotation[#, -0.373876664830236, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{21., 21., -0.27941549819892586`}],
     RowBox[{"-", "0.27941549819892586`"}]],
    Annotation[#, -0.27941549819892586`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{21., 22., -0.18216250427209588`}],
     RowBox[{"-", "0.18216250427209588`"}]],
    Annotation[#, -0.18216250427209588`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{21., 23., -0.0830894028174964}],
     RowBox[{"-", "0.0830894028174964`"}]],
    Annotation[#, -0.0830894028174964, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{21., 24., 0.0168139004843506}],
     "0.0168139004843506`"],
    Annotation[#, 0.0168139004843506, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{21., 25., 0.11654920485049364`}],
     "0.11654920485049364`"],
    Annotation[#, 0.11654920485049364`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{21., 26., 0.21511998808781552`}],
     "0.21511998808781552`"],
    Annotation[#, 0.21511998808781552`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{21., 27., 0.31154136351337786`}],
     "0.31154136351337786`"],
    Annotation[#, 0.31154136351337786`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{21., 28., 0.4048499206165983}],
     "0.4048499206165983`"],
    Annotation[#, 0.4048499206165983, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{21., 29., 0.49411335113860894`}],
     "0.49411335113860894`"],
    Annotation[#, 0.49411335113860894`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{21., 30., 0.5784397643882001}],
     "0.5784397643882001`"],
    Annotation[#, 0.5784397643882001, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{21., 31., 0.6569865987187891}],
     "0.6569865987187891`"],
    Annotation[#, 0.6569865987187891, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{22., 1., -0.9546277716602164}],
     RowBox[{"-", "0.9546277716602164`"}]],
    Annotation[#, -0.9546277716602164, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{22., 2., -0.9795891644283669}],
     RowBox[{"-", "0.9795891644283669`"}]],
    Annotation[#, -0.9795891644283669, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{22., 3., -0.9947628260746756}],
     RowBox[{"-", "0.9947628260746756`"}]],
    Annotation[#, -0.9947628260746756, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{22., 4., -0.999997146387718}],
     RowBox[{"-", "0.999997146387718`"}]],
    Annotation[#, -0.999997146387718, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{22., 5., -0.9952398257691626}],
     RowBox[{"-", "0.9952398257691626`"}]],
    Annotation[#, -0.9952398257691626, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{22., 6., -0.9805383977940689}],
     RowBox[{"-", "0.9805383977940689`"}]],
    Annotation[#, -0.9805383977940689, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{22., 7., -0.9560397542711181}],
     RowBox[{"-", "0.9560397542711181`"}]],
    Annotation[#, -0.9560397542711181, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{22., 8., -0.9219886775482162}],
     RowBox[{"-", "0.9219886775482162`"}]],
    Annotation[#, -0.9219886775482162, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{22., 9., -0.8787253947281899}],
     RowBox[{"-", "0.8787253947281899`"}]],
    Annotation[#, -0.8787253947281899, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{22., 10., -0.8266821782320357}],
     RowBox[{"-", "0.8266821782320357`"}]],
    Annotation[#, -0.8266821782320357, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{22., 11., -0.7663790266757844}],
     RowBox[{"-", "0.7663790266757844`"}]],
    Annotation[#, -0.7663790266757844, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{22., 12., -0.6984184692162135}],
     RowBox[{"-", "0.6984184692162135`"}]],
    Annotation[#, -0.6984184692162135, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{22., 13., -0.6234795452786853}],
     RowBox[{"-", "0.6234795452786853`"}]],
    Annotation[#, -0.6234795452786853, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{22., 14., -0.5423110198196698}],
     RowBox[{"-", "0.5423110198196698`"}]],
    Annotation[#, -0.5423110198196698, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{22., 15., -0.4557239019148047}],
     RowBox[{"-", "0.4557239019148047`"}]],
    Annotation[#, -0.4557239019148047, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{22., 16., -0.3645833414243013}],
     RowBox[{"-", "0.3645833414243013`"}]],
    Annotation[#, -0.3645833414243013, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{22., 17., -0.26979998470151617`}],
     RowBox[{"-", "0.26979998470151617`"}]],
    Annotation[#, -0.26979998470151617`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{22., 18., -0.17232087571561025`}],
     RowBox[{"-", "0.17232087571561025`"}]],
    Annotation[#, -0.17232087571561025`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{22., 19., -0.07311999350126308}],
     RowBox[{"-", "0.07311999350126308`"}]],
    Annotation[#, -0.07311999350126308, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{22., 20., 0.026811479517893238`}],
     "0.026811479517893238`"],
    Annotation[#, 0.026811479517893238`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{22., 21., 0.1264750610964027}],
     "0.1264750610964027`"],
    Annotation[#, 0.1264750610964027, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{22., 22., 0.2248749456715337}],
     "0.2248749456715337`"],
    Annotation[#, 0.2248749456715337, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{22., 23., 0.32102795412328977`}],
     "0.32102795412328977`"],
    Annotation[#, 0.32102795412328977`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{22., 24., 0.4139733573751788}],
     "0.4139733573751788`"],
    Annotation[#, 0.4139733573751788, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{22., 25., 0.5027824756815727}],
     "0.5027824756815727`"],
    Annotation[#, 0.5027824756815727, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{22., 26., 0.5865679576887464}],
     "0.5865679576887464`"],
    Annotation[#, 0.5865679576887464, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{22., 27., 0.664492646556282}],
     "0.664492646556282`"],
    Annotation[#, 0.664492646556282, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{22., 28., 0.7357779445514936}],
     "0.7357779445514936`"],
    Annotation[#, 0.7357779445514936, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{22., 29., 0.7997115925405986}],
     "0.7997115925405986`"],
    Annotation[#, 0.7997115925405986, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{22., 30., 0.8556547866465439}],
     "0.8556547866465439`"],
    Annotation[#, 0.8556547866465439, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{22., 31., 0.9030485609661848}],
     "0.9030485609661848`"],
    Annotation[#, 0.9030485609661848, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{23., 1., -0.9918687573109125}],
     RowBox[{"-", "0.9918687573109125`"}]],
    Annotation[#, -0.9918687573109125, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{23., 2., -0.9742082498528091}],
     RowBox[{"-", "0.9742082498528091`"}]],
    Annotation[#, -0.9742082498528091, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{23., 3., -0.9468137755926086}],
     RowBox[{"-", "0.9468137755926086`"}]],
    Annotation[#, -0.9468137755926086, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{23., 4., -0.9099590510617103}],
     RowBox[{"-", "0.9099590510617103`"}]],
    Annotation[#, -0.9099590510617103, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{23., 5., -0.8640123164850739}],
     RowBox[{"-", "0.8640123164850739`"}]],
    Annotation[#, -0.8640123164850739, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{23., 6., -0.809432656446619}],
     RowBox[{"-", "0.809432656446619`"}]],
    Annotation[#, -0.809432656446619, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{23., 7., -0.7467654128678117}],
     RowBox[{"-", "0.7467654128678117`"}]],
    Annotation[#, -0.7467654128678117, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{23., 8., -0.6766367361314563}],
     RowBox[{"-", "0.6766367361314563`"}]],
    Annotation[#, -0.6766367361314563, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{23., 9., -0.599747328794043}],
     RowBox[{"-", "0.599747328794043`"}]],
    Annotation[#, -0.599747328794043, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{23., 10., -0.516865444397428}],
     RowBox[{"-", "0.516865444397428`"}]],
    Annotation[#, -0.516865444397428, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{23., 11., -0.42881921133339507`}],
     RowBox[{"-", "0.42881921133339507`"}]],
    Annotation[#, -0.42881921133339507`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{23., 12., -0.3364883584585034}],
     RowBox[{"-", "0.3364883584585034`"}]],
    Annotation[#, -0.3364883584585034, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{23., 13., -0.24079542513415833`}],
     RowBox[{"-", "0.24079542513415833`"}]],
    Annotation[#, -0.24079542513415833`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{23., 14., -0.14269654351825772`}],
     RowBox[{"-", "0.14269654351825772`"}]],
    Annotation[#, -0.14269654351825772`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{23., 15., -0.04317188520872779}],
     RowBox[{"-", "0.04317188520872779`"}]],
    Annotation[#, -0.04317188520872779, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{23., 16., 0.05678413230707894}],
     "0.05678413230707894`"],
    Annotation[#, 0.05678413230707894, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{23., 17., 0.1561727815432128}],
     "0.1561727815432128`"],
    Annotation[#, 0.1561727815432128, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{23., 18., 0.254001003970024}],
     "0.254001003970024`"],
    Annotation[#, 0.254001003970024, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{23., 19., 0.3492913323267357}],
     "0.3492913323267357`"],
    Annotation[#, 0.3492913323267357, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{23., 20., 0.44109165715120313`}],
     "0.44109165715120313`"],
    Annotation[#, 0.44109165715120313`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{23., 21., 0.5284847399429315}],
     "0.5284847399429315`"],
    Annotation[#, 0.5284847399429315, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{23., 22., 0.6105973779069798}],
     "0.6105973779069798`"],
    Annotation[#, 0.6105973779069798, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{23., 23., 0.6866091287076391}],
     "0.6866091287076391`"],
    Annotation[#, 0.6866091287076391, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{23., 24., 0.7557605080570543}],
     "0.7557605080570543`"],
    Annotation[#, 0.7557605080570543, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{23., 25., 0.8173605782311734}],
     "0.8173605782311734`"],
    Annotation[#, 0.8173605782311734, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{23., 26., 0.8707938516910915}],
     "0.8707938516910915`"],
    Annotation[#, 0.8707938516910915, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{23., 27., 0.91552644083109}],
     "0.91552644083109`"],
    Annotation[#, 0.91552644083109, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{23., 28., 0.9511113924071092}],
     "0.9511113924071092`"],
    Annotation[#, 0.9511113924071092, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{23., 29., 0.977193153345823}],
     "0.977193153345823`"],
    Annotation[#, 0.977193153345823, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{23., 30., 0.993511123313416}],
     "0.993511123313416`"],
    Annotation[#, 0.993511123313416, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{23., 31., 0.9999022585479752}],
     "0.9999022585479752`"],
    Annotation[#, 0.9999022585479752, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{24., 1., -0.8377694801650973}],
     RowBox[{"-", "0.8377694801650973`"}]],
    Annotation[#, -0.8377694801650973, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{24., 2., -0.7790726726314026}],
     RowBox[{"-", "0.7790726726314026`"}]],
    Annotation[#, -0.7790726726314026, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{24., 3., -0.7125916284799608}],
     RowBox[{"-", "0.7125916284799608`"}]],
    Annotation[#, -0.7125916284799608, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{24., 4., -0.6389906043282231}],
     RowBox[{"-", "0.6389906043282231`"}]],
    Annotation[#, -0.6389906043282231, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{24., 5., -0.5590049972802481}],
     RowBox[{"-", "0.5590049972802481`"}]],
    Annotation[#, -0.5590049972802481, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{24., 6., -0.4734339970819343}],
     RowBox[{"-", "0.4734339970819343`"}]],
    Annotation[#, -0.4734339970819343, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{24., 7., -0.38313260088125056`}],
     RowBox[{"-", "0.38313260088125056`"}]],
    Annotation[#, -0.38313260088125056`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{24., 8., -0.2890030703793603}],
     RowBox[{"-", "0.2890030703793603`"}]],
    Annotation[#, -0.2890030703793603, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{24., 9., -0.19198591672995416`}],
     RowBox[{"-", "0.19198591672995416`"}]],
    Annotation[#, -0.19198591672995416`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{24., 10., -0.09305050326268802}],
     RowBox[{"-", "0.09305050326268802`"}]],
    Annotation[#, -0.09305050326268802, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{24., 11., 0.006814640074771064}],
     "0.006814640074771064`"],
    Annotation[#, 0.006814640074771064, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{24., 12., 0.10661169378122355`}],
     "0.10661169378122355`"],
    Annotation[#, 0.10661169378122355`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{24., 13., 0.20534351868455547`}],
     "0.20534351868455547`"],
    Annotation[#, 0.20534351868455547`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{24., 14., 0.3020236190267332}],
     "0.3020236190267332`"],
    Annotation[#, 0.3020236190267332, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{24., 15., 0.3956859992033316}],
     "0.3956859992033316`"],
    Annotation[#, 0.3956859992033316, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{24., 16., 0.48539481567229104`}],
     "0.48539481567229104`"],
    Annotation[#, 0.48539481567229104`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{24., 17., 0.5702537275932467}],
     "0.5702537275932467`"],
    Annotation[#, 0.5702537275932467, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{24., 18., 0.6494148527689119}],
     "0.6494148527689119`"],
    Annotation[#, 0.6494148527689119, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{24., 19., 0.722087239403719}],
     "0.722087239403719`"],
    Annotation[#, 0.722087239403719, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{24., 20., 0.7875447690327114}],
     "0.7875447690327114`"],
    Annotation[#, 0.7875447690327114, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{24., 21., 0.8451334116572178}],
     "0.8451334116572178`"],
    Annotation[#, 0.8451334116572178, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{24., 22., 0.8942777605964088}],
     "0.8942777605964088`"],
    Annotation[#, 0.8942777605964088, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{24., 23., 0.9344867817606464}],
     "0.9344867817606464`"],
    Annotation[#, 0.9344867817606464, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{24., 24., 0.9653587199017923}],
     "0.9653587199017923`"],
    Annotation[#, 0.9653587199017923, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{24., 25., 0.986585112818846}],
     "0.986585112818846`"],
    Annotation[#, 0.986585112818846, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{24., 26., 0.9979538734102933}],
     "0.9979538734102933`"],
    Annotation[#, 0.9979538734102933, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{24., 27., 0.999351408778317}],
     "0.999351408778317`"],
    Annotation[#, 0.999351408778317, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{24., 28., 0.9907637552114834}],
     "0.9907637552114834`"],
    Annotation[#, 0.9907637552114834, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{24., 29., 0.9722767177055316}],
     "0.9722767177055316`"],
    Annotation[#, 0.9722767177055316, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{24., 30., 0.944075012628219}],
     "0.944075012628219`"],
    Annotation[#, 0.944075012628219, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{24., 31., 0.906440422094434}],
     "0.906440422094434`"],
    Annotation[#, 0.906440422094434, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{25., 1., -0.49964188311690094`}],
     RowBox[{"-", "0.49964188311690094`"}]],
    Annotation[#, -0.49964188311690094`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{25., 2., -0.41066684829434}],
     RowBox[{"-", "0.41066684829434`"}]],
    Annotation[#, -0.41066684829434, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{25., 3., -0.3175885660720332}],
     RowBox[{"-", "0.3175885660720332`"}]],
    Annotation[#, -0.3175885660720332, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{25., 4., -0.2213370438783578}],
     RowBox[{"-", "0.2213370438783578`"}]],
    Annotation[#, -0.2213370438783578, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{25., 5., -0.12287399510654828`}],
     RowBox[{"-", "0.12287399510654828`"}]],
    Annotation[#, -0.12287399510654828`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{25., 6., -0.023183229992377676`}],
     RowBox[{"-", "0.023183229992377676`"}]],
    Annotation[#, -0.023183229992377676`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{25., 7., 0.07673917429251981}],
     "0.07673917429251981`"],
    Annotation[#, 0.07673917429251981, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{25., 8., 0.17589482611448576`}],
     "0.17589482611448576`"],
    Annotation[#, 0.17589482611448576`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{25., 9., 0.2732929949770141}],
     "0.2732929949770141`"],
    Annotation[#, 0.2732929949770141, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{25., 10., 0.36796051057238627`}],
     "0.36796051057238627`"],
    Annotation[#, 0.36796051057238627`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{25., 11., 0.45895148637769184`}],
     "0.45895148637769184`"],
    Annotation[#, 0.45895148637769184`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{25., 12., 0.5453567706403027}],
     "0.5453567706403027`"],
    Annotation[#, 0.5453567706403027, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{25., 13., 0.6263130303216573}],
     "0.6263130303216573`"],
    Annotation[#, 0.6263130303216573, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{25., 14., 0.7010113772355994}],
     "0.7010113772355994`"],
    Annotation[#, 0.7010113772355994, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{25., 15., 0.768705450191757}],
     "0.768705450191757`"],
    Annotation[#, 0.768705450191757, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{25., 16., 0.8287188723898363}],
     "0.8287188723898363`"],
    Annotation[#, 0.8287188723898363, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{25., 17., 0.8804520095530348}],
     "0.8804520095530348`"],
    Annotation[#, 0.8804520095530348, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{25., 18., 0.9233879612755196}],
     "0.9233879612755196`"],
    Annotation[#, 0.9233879612755196, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{25., 19., 0.9570977257204175}],
     "0.9570977257204175`"],
    Annotation[#, 0.9570977257204175, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{25., 20., 0.9812444860643624}],
     "0.9812444860643624`"],
    Annotation[#, 0.9812444860643624, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{25., 21., 0.995586975859855}],
     "0.995586975859855`"],
    Annotation[#, 0.995586975859855, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{25., 22., 0.9999818896898556}],
     "0.9999818896898556`"],
    Annotation[#, 0.9999818896898556, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{25., 23., 0.9943853150281402}],
     "0.9943853150281402`"],
    Annotation[#, 0.9943853150281402, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{25., 24., 0.978853170998747}],
     "0.978853170998747`"],
    Annotation[#, 0.978853170998747, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{25., 25., 0.9535406496505737}],
     "0.9535406496505737`"],
    Annotation[#, 0.9535406496505737, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{25., 26., 0.918700665329724}],
     "0.918700665329724`"],
    Annotation[#, 0.918700665329724, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{25., 27., 0.8746813276429644}],
     "0.8746813276429644`"],
    Annotation[#, 0.8746813276429644, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{25., 28., 0.8219224632616022}],
     "0.8219224632616022`"],
    Annotation[#, 0.8219224632616022, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{25., 29., 0.7609512213187731}],
     "0.7609512213187731`"],
    Annotation[#, 0.7609512213187731, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{25., 30., 0.6923768063095591}],
     "0.6923768063095591`"],
    Annotation[#, 0.6923768063095591, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{25., 31., 0.6168843911210433}],
     "0.6168843911210433`"],
    Annotation[#, 0.6168843911210433, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{26., 1., -0.03317921654755682}],
     RowBox[{"-", "0.03317921654755682`"}]],
    Annotation[#, -0.03317921654755682, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{26., 2., 0.06676499152155546}],
     "0.06676499152155546`"],
    Annotation[#, 0.06676499152155546, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{26., 3., 0.1660421058649572}],
     "0.1660421058649572`"],
    Annotation[#, 0.1660421058649572, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{26., 4., 0.2636601823727784}],
     "0.2636601823727784`"],
    Annotation[#, 0.2636601823727784, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{26., 5., 0.35864385349280037`}],
     "0.35864385349280037`"],
    Annotation[#, 0.35864385349280037`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{26., 6., 0.4500440737806176}],
     "0.4500440737806176`"],
    Annotation[#, 0.4500440737806176, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{26., 7., 0.536947602448011}],
     "0.536947602448011`"],
    Annotation[#, 0.536947602448011, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{26., 8., 0.618486128163024}],
     "0.618486128163024`"],
    Annotation[#, 0.618486128163024, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{26., 9., 0.6938449449297637}],
     "0.6938449449297637`"],
    Annotation[#, 0.6938449449297637, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{26., 10., 0.7622710923614112}],
     "0.7622710923614112`"],
    Annotation[#, 0.7622710923614112, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{26., 11., 0.8230808790115055}],
     "0.8230808790115055`"],
    Annotation[#, 0.8230808790115055, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{26., 12., 0.8756667135928823}],
     "0.8756667135928823`"],
    Annotation[#, 0.8756667135928823, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{26., 13., 0.9195031758289707}],
     "0.9195031758289707`"],
    Annotation[#, 0.9195031758289707, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{26., 14., 0.9541522662795148}],
     "0.9541522662795148`"],
    Annotation[#, 0.9541522662795148, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{26., 15., 0.9792677826862}],
     "0.9792677826862`"],
    Annotation[#, 0.9792677826862, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{26., 16., 0.9945987791111761}],
     "0.9945987791111761`"],
    Annotation[#, 0.9945987791111761, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{26., 17., 0.9999920733059188}],
     "0.9999920733059188`"],
    Annotation[#, 0.9999920733059188, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{26., 18., 0.9953937772576199}],
     "0.9953937772576199`"],
    Annotation[#, 0.9953937772576199, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{26., 19., 0.9808498356203995}],
     "0.9808498356203995`"],
    Annotation[#, 0.9808498356203995, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{26., 20., 0.9565055666515091}],
     "0.9565055666515091`"],
    Annotation[#, 0.9565055666515091, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{26., 21., 0.9226042102393402}],
     "0.9226042102393402`"],
    Annotation[#, 0.9226042102393402, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{26., 22., 0.8794844975308649}],
     "0.8794844975308649`"],
    Annotation[#, 0.8794844975308649, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{26., 23., 0.827577266441984}],
     "0.827577266441984`"],
    Annotation[#, 0.827577266441984, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{26., 24., 0.7674011568674873}],
     "0.7674011568674873`"],
    Annotation[#, 0.7674011568674873, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{26., 25., 0.699557428602668}],
     "0.699557428602668`"],
    Annotation[#, 0.699557428602668, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{26., 26., 0.6247239537541924}],
     "0.6247239537541924`"],
    Annotation[#, 0.6247239537541924, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{26., 27., 0.5436484436660883}],
     "0.5436484436660883`"],
    Annotation[#, 0.5436484436660883, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{26., 28., 0.4571409780351558}],
     "0.4571409780351558`"],
    Annotation[#, 0.4571409780351558, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{26., 29., 0.366065910862411}],
     "0.366065910862411`"],
    Annotation[#, 0.366065910862411, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{26., 30., 0.27133323411363275`}],
     "0.27133323411363275`"],
    Annotation[#, 0.27133323411363275`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{26., 31., 0.17388948538043356`}],
     "0.17388948538043356`"],
    Annotation[#, 0.17388948538043356`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{27., 1., 0.45895148637769106`}],
     "0.45895148637769106`"],
    Annotation[#, 0.45895148637769106`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{27., 2., 0.545356770640302}],
     "0.545356770640302`"],
    Annotation[#, 0.545356770640302, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{27., 3., 0.6263130303216565}],
     "0.6263130303216565`"],
    Annotation[#, 0.6263130303216565, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{27., 4., 0.7010113772355987}],
     "0.7010113772355987`"],
    Annotation[#, 0.7010113772355987, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{27., 5., 0.7687054501917564}],
     "0.7687054501917564`"],
    Annotation[#, 0.7687054501917564, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{27., 6., 0.8287188723898358}],
     "0.8287188723898358`"],
    Annotation[#, 0.8287188723898358, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{27., 7., 0.8804520095530348}],
     "0.8804520095530348`"],
    Annotation[#, 0.8804520095530348, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{27., 8., 0.9233879612755193}],
     "0.9233879612755193`"],
    Annotation[#, 0.9233879612755193, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{27., 9., 0.9570977257204173}],
     "0.9570977257204173`"],
    Annotation[#, 0.9570977257204173, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{27., 10., 0.9812444860643623}],
     "0.9812444860643623`"],
    Annotation[#, 0.9812444860643623, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{27., 11., 0.9955869758598549}],
     "0.9955869758598549`"],
    Annotation[#, 0.9955869758598549, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{27., 12., 0.9999818896898556}],
     "0.9999818896898556`"],
    Annotation[#, 0.9999818896898556, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{27., 13., 0.9943853150281403}],
     "0.9943853150281403`"],
    Annotation[#, 0.9943853150281403, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{27., 14., 0.9788531709987474}],
     "0.9788531709987474`"],
    Annotation[#, 0.9788531709987474, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{27., 15., 0.9535406496505743}],
     "0.9535406496505743`"],
    Annotation[#, 0.9535406496505743, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{27., 16., 0.918700665329724}],
     "0.918700665329724`"],
    Annotation[#, 0.918700665329724, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{27., 17., 0.8746813276429644}],
     "0.8746813276429644`"],
    Annotation[#, 0.8746813276429644, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{27., 18., 0.8219224632616022}],
     "0.8219224632616022`"],
    Annotation[#, 0.8219224632616022, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{27., 19., 0.7609512213187744}],
     "0.7609512213187744`"],
    Annotation[#, 0.7609512213187744, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{27., 20., 0.6923768063095604}],
     "0.6923768063095604`"],
    Annotation[#, 0.6923768063095604, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{27., 21., 0.6168843911210433}],
     "0.6168843911210433`"],
    Annotation[#, 0.6168843911210433, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{27., 22., 0.5352282710113146}],
     "0.5352282710113146`"],
    Annotation[#, 0.5352282710113146, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{27., 23., 0.4482243269405849}],
     "0.4482243269405849`"],
    Annotation[#, 0.4482243269405849, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{27., 24., 0.3567418735583286}],
     "0.3567418735583286`"],
    Annotation[#, 0.3567418735583286, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{27., 25., 0.2616949732986626}],
     "0.2616949732986626`"],
    Annotation[#, 0.2616949732986626, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{27., 26., 0.16403330337065172`}],
     "0.16403330337065172`"],
    Annotation[#, 0.16403330337065172`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{27., 27., 0.06473266689756411}],
     "0.06473266689756411`"],
    Annotation[#, 0.06473266689756411, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{27., 28., -0.03521475698538918}],
     RowBox[{"-", "0.03521475698538918`"}]],
    Annotation[#, -0.03521475698538918, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{27., 29., -0.1348103266569955}],
     RowBox[{"-", "0.1348103266569955`"}]],
    Annotation[#, -0.1348103266569955, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{27., 30., -0.2330589161070144}],
     RowBox[{"-", "0.2330589161070144`"}]],
    Annotation[#, -0.2330589161070144, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{27., 31., -0.3289788579063288}],
     RowBox[{"-", "0.3289788579063288`"}]],
    Annotation[#, -0.3289788579063288, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{28., 1., 0.8451334116572178}],
     "0.8451334116572178`"],
    Annotation[#, 0.8451334116572178, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{28., 2., 0.8942777605964088}],
     "0.8942777605964088`"],
    Annotation[#, 0.8942777605964088, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{28., 3., 0.9344867817606464}],
     "0.9344867817606464`"],
    Annotation[#, 0.9344867817606464, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{28., 4., 0.965358719901792}],
     "0.965358719901792`"],
    Annotation[#, 0.965358719901792, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{28., 5., 0.986585112818846}],
     "0.986585112818846`"],
    Annotation[#, 0.986585112818846, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{28., 6., 0.9979538734102933}],
     "0.9979538734102933`"],
    Annotation[#, 0.9979538734102933, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{28., 7., 0.999351408778317}],
     "0.999351408778317`"],
    Annotation[#, 0.999351408778317, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{28., 8., 0.9907637552114834}],
     "0.9907637552114834`"],
    Annotation[#, 0.9907637552114834, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{28., 9., 0.9722767177055316}],
     "0.9722767177055316`"],
    Annotation[#, 0.9722767177055316, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{28., 10., 0.944075012628219}],
     "0.944075012628219`"],
    Annotation[#, 0.944075012628219, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{28., 11., 0.906440422094434}],
     "0.906440422094434`"],
    Annotation[#, 0.906440422094434, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{28., 12., 0.8597489784924482}],
     "0.8597489784924482`"],
    Annotation[#, 0.8597489784924482, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{28., 13., 0.8044672072925926}],
     "0.8044672072925926`"],
    Annotation[#, 0.8044672072925926, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{28., 14., 0.7411474656789739}],
     "0.7411474656789739`"],
    Annotation[#, 0.7411474656789739, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{28., 15., 0.6704224235790709}],
     "0.6704224235790709`"],
    Annotation[#, 0.6704224235790709, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{28., 16., 0.5929987422349551}],
     "0.5929987422349551`"],
    Annotation[#, 0.5929987422349551, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{28., 17., 0.5096500134777504}],
     "0.5096500134777504`"],
    Annotation[#, 0.5096500134777504, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{28., 18., 0.42120903025377054`}],
     "0.42120903025377054`"],
    Annotation[#, 0.42120903025377054`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{28., 19., 0.3285594656326905}],
     "0.3285594656326905`"],
    Annotation[#, 0.3285594656326905, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{28., 20., 0.2326270434383283}],
     "0.2326270434383283`"],
    Annotation[#, 0.2326270434383283, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{28., 21., 0.1343702887222073}],
     "0.1343702887222073`"],
    Annotation[#, 0.1343702887222073, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{28., 22., 0.03477095049808608}],
     "0.03477095049808608`"],
    Annotation[#, 0.03477095049808608, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{28., 23., -0.06517580756966568}],
     RowBox[{"-", "0.06517580756966568`"}]],
    Annotation[#, -0.06517580756966568, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{28., 24., -0.16447135051243716`}],
     RowBox[{"-", "0.16447135051243716`"}]],
    Annotation[#, -0.16447135051243716`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{28., 25., -0.2621235500878886}],
     RowBox[{"-", "0.2621235500878886`"}]],
    Annotation[#, -0.2621235500878886, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{28., 26., -0.3571566977973876}],
     RowBox[{"-", "0.3571566977973876`"}]],
    Annotation[#, -0.3571566977973876, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{28., 27., -0.44862125384280294`}],
     RowBox[{"-", "0.44862125384280294`"}]],
    Annotation[#, -0.44862125384280294`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{28., 28., -0.5356033346142929}],
     RowBox[{"-", "0.5356033346142929`"}]],
    Annotation[#, -0.5356033346142929, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{28., 29., -0.6172338439132387}],
     RowBox[{"-", "0.6172338439132387`"}]],
    Annotation[#, -0.6172338439132387, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{28., 30., -0.6926971566741857}],
     RowBox[{"-", "0.6926971566741857`"}]],
    Annotation[#, -0.6926971566741857, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{28., 31., -0.7612392684208814}],
     RowBox[{"-", "0.7612392684208814`"}]],
    Annotation[#, -0.7612392684208814, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{29., 1., 0.9999022585479752}],
     "0.9999022585479752`"],
    Annotation[#, 0.9999022585479752, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{29., 2., 0.9963027009388655}],
     "0.9963027009388655`"],
    Annotation[#, 0.9963027009388655, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{29., 3., 0.9827484160758618}],
     "0.9827484160758618`"],
    Annotation[#, 0.9827484160758618, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{29., 4., 0.9593748338928637}],
     "0.9593748338928637`"],
    Annotation[#, 0.9593748338928637, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{29., 5., 0.9264154954967655}],
     "0.9264154954967655`"],
    Annotation[#, 0.9264154954967655, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{29., 6., 0.8841997197019119}],
     "0.8841997197019119`"],
    Annotation[#, 0.8841997197019119, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{29., 7., 0.8331493125853651}],
     "0.8331493125853651`"],
    Annotation[#, 0.8331493125853651, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{29., 8., 0.7737743529400123}],
     "0.7737743529400123`"],
    Annotation[#, 0.7737743529400123, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{29., 9., 0.7066680957358767}],
     "0.7066680957358767`"],
    Annotation[#, 0.7066680957358767, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{29., 10., 0.6325010445125648}],
     "0.6325010445125648`"],
    Annotation[#, 0.6325010445125648, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{29., 11., 0.5520142519295314}],
     "0.5520142519295314`"],
    Annotation[#, 0.5520142519295314, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{29., 12., 0.46601191541286957`}],
     "0.46601191541286957`"],
    Annotation[#, 0.46601191541286957`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{29., 13., 0.3753533418804595}],
     "0.3753533418804595`"],
    Annotation[#, 0.3753533418804595, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{29., 14., 0.28094436183130006`}],
     "0.28094436183130006`"],
    Annotation[#, 0.28094436183130006`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{29., 15., 0.18372827858658125`}],
     "0.18372827858658125`"],
    Annotation[#, 0.18372827858658125`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{29., 16., 0.08467644311471965}],
     "0.08467644311471965`"],
    Annotation[#, 0.08467644311471965, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{29., 17., -0.01522145138643352}],
     RowBox[{"-", "0.01522145138643352`"}]],
    Annotation[#, -0.01522145138643352, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{29., 18., -0.11496725817687808`}],
     RowBox[{"-", "0.11496725817687808`"}]],
    Annotation[#, -0.11496725817687808`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{29., 19., -0.21356435012674044`}],
     RowBox[{"-", "0.21356435012674044`"}]],
    Annotation[#, -0.21356435012674044`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{29., 20., -0.31002757768512473`}],
     RowBox[{"-", "0.31002757768512473`"}]],
    Annotation[#, -0.31002757768512473`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{29., 21., -0.4033931121687712}],
     RowBox[{"-", "0.4033931121687712`"}]],
    Annotation[#, -0.4033931121687712, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{29., 22., -0.49272807601966173`}],
     RowBox[{"-", "0.49272807601966173`"}]],
    Annotation[#, -0.49272807601966173`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{29., 23., -0.5771398638092126}],
     RowBox[{"-", "0.5771398638092126`"}]],
    Annotation[#, -0.5771398638092126, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{29., 24., -0.6557850608566549}],
     RowBox[{"-", "0.6557850608566549`"}]],
    Annotation[#, -0.6557850608566549, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{29., 25., -0.7278778703497378}],
     RowBox[{"-", "0.7278778703497378`"}]],
    Annotation[#, -0.7278778703497378, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{29., 26., -0.7926979647667212}],
     RowBox[{"-", "0.7926979647667212`"}]],
    Annotation[#, -0.7926979647667212, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{29., 27., -0.8495976831508647}],
     RowBox[{"-", "0.8495976831508647`"}]],
    Annotation[#, -0.8495976831508647, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{29., 28., -0.8980085023246211}],
     RowBox[{"-", "0.8980085023246211`"}]],
    Annotation[#, -0.8980085023246211, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{29., 29., -0.9374467173852938}],
     RowBox[{"-", "0.9374467173852938`"}]],
    Annotation[#, -0.9374467173852938, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{29., 30., -0.9675182747245383}],
     RowBox[{"-", "0.9675182747245383`"}]],
    Annotation[#, -0.9675182747245383, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{29., 31., -0.9879227092817559}],
     RowBox[{"-", "0.9879227092817559`"}]],
    Annotation[#, -0.9879227092817559, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{30., 1., 0.8493633785054664}],
     "0.8493633785054664`"],
    Annotation[#, 0.8493633785054664, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{30., 2., 0.7924271699085272}],
     "0.7924271699085272`"],
    Annotation[#, 0.7924271699085272, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{30., 3., 0.7275732909714585}],
     "0.7275732909714585`"],
    Annotation[#, 0.7275732909714585, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{30., 4., 0.655449740214756}],
     "0.655449740214756`"],
    Annotation[#, 0.655449740214756, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{30., 5., 0.576777152316707}],
     "0.576777152316707`"],
    Annotation[#, 0.576777152316707, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{30., 6., 0.4923415977698876}],
     "0.4923415977698876`"],
    Annotation[#, 0.4923415977698876, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{30., 7., 0.40298672872464614`}],
     "0.40298672872464614`"],
    Annotation[#, 0.40298672872464614`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{30., 8., 0.30960534949568985`}],
     "0.30960534949568985`"],
    Annotation[#, 0.30960534949568985`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{30., 9., 0.21313049595649275`}],
     "0.21313049595649275`"],
    Annotation[#, 0.21313049595649275`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{30., 10., 0.11452611295327532`}],
     "0.11452611295327532`"],
    Annotation[#, 0.11452611295327532`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{30., 11., 0.01477742288672846}],
     "0.01477742288672846`"],
    Annotation[#, 0.01477742288672846, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{30., 12., -0.08511891830453604}],
     RowBox[{"-", "0.08511891830453604`"}]],
    Annotation[#, -0.08511891830453604, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{30., 13., -0.18416477940067688`}],
     RowBox[{"-", "0.18416477940067688`"}]],
    Annotation[#, -0.18416477940067688`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{30., 14., -0.28137052689782677`}],
     RowBox[{"-", "0.28137052689782677`"}]],
    Annotation[#, -0.28137052689782677`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{30., 15., -0.37576491309894394`}],
     RowBox[{"-", "0.37576491309894394`"}]],
    Annotation[#, -0.37576491309894394`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{30., 16., -0.46640478049974243`}],
     RowBox[{"-", "0.46640478049974243`"}]],
    Annotation[#, -0.46640478049974243`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{30., 17., -0.5523844855067103}],
     RowBox[{"-", "0.5523844855067103`"}]],
    Annotation[#, -0.5523844855067103, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{30., 18., -0.6328449473285309}],
     RowBox[{"-", "0.6328449473285309`"}]],
    Annotation[#, -0.6328449473285309, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{30., 19., -0.7069822316273704}],
     RowBox[{"-", "0.7069822316273704`"}]],
    Annotation[#, -0.7069822316273704, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{30., 20., -0.7740555831650443}],
     RowBox[{"-", "0.7740555831650443`"}]],
    Annotation[#, -0.7740555831650443, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{30., 21., -0.8333948271844903}],
     RowBox[{"-", "0.8333948271844903`"}]],
    Annotation[#, -0.8333948271844903, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{30., 22., -0.8844070655744125}],
     RowBox[{"-", "0.8844070655744125`"}]],
    Annotation[#, -0.8844070655744125, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{30., 23., -0.9265826009112234}],
     RowBox[{"-", "0.9265826009112234`"}]],
    Annotation[#, -0.9265826009112234, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{30., 24., -0.9595000291872144}],
     RowBox[{"-", "0.9595000291872144`"}]],
    Annotation[#, -0.9595000291872144, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{30., 25., -0.9828304503401081}],
     RowBox[{"-", "0.9828304503401081`"}]],
    Annotation[#, -0.9828304503401081, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{30., 26., -0.9963407545137565}],
     RowBox[{"-", "0.9963407545137565`"}]],
    Annotation[#, -0.9963407545137565, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{30., 27., -0.9998959512147693}],
     RowBox[{"-", "0.9998959512147693`"}]],
    Annotation[#, -0.9998959512147693, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{30., 28., -0.9934605180929015}],
     RowBox[{"-", "0.9934605180929015`"}]],
    Annotation[#, -0.9934605180929015, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{30., 29., -0.9770987558686357}],
     RowBox[{"-", "0.9770987558686357`"}]],
    Annotation[#, -0.9770987558686357, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{30., 30., -0.9509741458616373}],
     RowBox[{"-", "0.9509741458616373`"}]],
    Annotation[#, -0.9509741458616373, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{30., 31., -0.9153477165394484}],
     RowBox[{"-", "0.9153477165394484`"}]],
    Annotation[#, -0.9153477165394484, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{31., 1., 0.4121184852417566}],
     "0.4121184852417566`"],
    Annotation[#, 0.4121184852417566, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{31., 2., 0.3190983623493521}],
     "0.3190983623493521`"],
    Annotation[#, 0.3190983623493521, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{31., 3., 0.22288991410024764`}],
     "0.22288991410024764`"],
    Annotation[#, 0.22288991410024764`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{31., 4., 0.1244544235070617}],
     "0.1244544235070617`"],
    Annotation[#, 0.1244544235070617, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{31., 5., 0.024775425453357765`}],
     "0.024775425453357765`"],
    Annotation[#, 0.024775425453357765`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{31., 6., -0.0751511204618093}],
     RowBox[{"-", "0.0751511204618093`"}]],
    Annotation[#, -0.0751511204618093, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{31., 7., -0.17432678122297965`}],
     RowBox[{"-", "0.17432678122297965`"}]],
    Annotation[#, -0.17432678122297965`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{31., 8., -0.27176062641094245`}],
     RowBox[{"-", "0.27176062641094245`"}]],
    Annotation[#, -0.27176062641094245`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{31., 9., -0.36647912925192844`}],
     RowBox[{"-", "0.36647912925192844`"}]],
    Annotation[#, -0.36647912925192844`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{31., 10., -0.45753589377532133`}],
     RowBox[{"-", "0.45753589377532133`"}]],
    Annotation[#, -0.45753589377532133`, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{31., 11., -0.5440211108893698}],
     RowBox[{"-", "0.5440211108893698`"}]],
    Annotation[#, -0.5440211108893698, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{31., 12., -0.6250706488928821}],
     RowBox[{"-", "0.6250706488928821`"}]],
    Annotation[#, -0.6250706488928821, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{31., 13., -0.6998746875935423}],
     RowBox[{"-", "0.6998746875935423`"}]],
    Annotation[#, -0.6998746875935423, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{31., 14., -0.7676858097635825}],
     RowBox[{"-", "0.7676858097635825`"}]],
    Annotation[#, -0.7676858097635825, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{31., 15., -0.8278264690856537}],
     RowBox[{"-", "0.8278264690856537`"}]],
    Annotation[#, -0.8278264690856537, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{31., 16., -0.87969575997167}],
     RowBox[{"-", "0.87969575997167`"}]],
    Annotation[#, -0.87969575997167, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{31., 17., -0.9227754216128066}],
     RowBox[{"-", "0.9227754216128066`"}]],
    Annotation[#, -0.9227754216128066, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{31., 18., -0.9566350162701879}],
     RowBox[{"-", "0.9566350162701879`"}]],
    Annotation[#, -0.9566350162701879, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{31., 19., -0.9809362300664916}],
     RowBox[{"-", "0.9809362300664916`"}]],
    Annotation[#, -0.9809362300664916, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{31., 20., -0.9954362533063774}],
     RowBox[{"-", "0.9954362533063774`"}]],
    Annotation[#, -0.9954362533063774, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{31., 21., -0.9999902065507035}],
     RowBox[{"-", "0.9999902065507035`"}]],
    Annotation[#, -0.9999902065507035, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{31., 22., -0.9945525882039892}],
     RowBox[{"-", "0.9945525882039892`"}]],
    Annotation[#, -0.9945525882039892, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{31., 23., -0.9791777291513174}],
     RowBox[{"-", "0.9791777291513174`"}]],
    Annotation[#, -0.9791777291513174, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{31., 24., -0.954019249902089}],
     RowBox[{"-", "0.954019249902089`"}]],
    Annotation[#, -0.954019249902089, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{31., 25., -0.9193285256646757}],
     RowBox[{"-", "0.9193285256646757`"}]],
    Annotation[#, -0.9193285256646757, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{31., 26., -0.8754521746884285}],
     RowBox[{"-", "0.8754521746884285`"}]],
    Annotation[#, -0.8754521746884285, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{31., 27., -0.8228285949687089}],
     RowBox[{"-", "0.8228285949687089`"}]],
    Annotation[#, -0.8228285949687089, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{31., 28., -0.7619835839190333}],
     RowBox[{"-", "0.7619835839190333`"}]],
    Annotation[#, -0.7619835839190333, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{31., 29., -0.6935250847771224}],
     RowBox[{"-", "0.6935250847771224`"}]],
    Annotation[#, -0.6935250847771224, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{31., 30., -0.6181371122370333}],
     RowBox[{"-", "0.6181371122370333`"}]],
    Annotation[#, -0.6181371122370333, "Tooltip"]& ], 
   TagBox[
    TooltipBox[Point3DBox[{31., 31., -0.5365729180004349}],
     RowBox[{"-", "0.5365729180004349`"}]],
    Annotation[#, -0.5365729180004349, "Tooltip"]& ]},
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  PlotRange->{{1., 31.}, {1., 31.}, Automatic},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}, {Automatic, Automatic}}]], "Output",
 ImageSize->{184, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->225768634]
}, Open  ]],

Cell[TextData[{
 "Provide an interactive ",
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 " for the whole points:"
}], "ExampleText",
 CellID->562981635],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{
   RowBox[{"Tooltip", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"i", "+", 
         RowBox[{"j", "^", "2"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", "3", ",", "0.1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "0", ",", "3", ",", "0.1"}], "}"}]}], "]"}], ",", 
     RowBox[{"TraditionalForm", "@", 
      RowBox[{"Sin", "[", 
       RowBox[{"i", "+", 
        RowBox[{"j", "^", "2"}]}], "]"}]}]}], "]"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Darker", "[", "Green", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->300675534],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[0, 
    NCache[
     Rational[2, 3], 0.6666666666666666], 0], 
   TagBox[
    TooltipBox[Point3DBox[CompressedData["
1:eJxd23l0jOf7BvCgGFsNHToIYowRY4xZMjOZyTKXXdEWtddWS6mWokqLovYK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      "]],
     TagBox[
      FormBox[
       RowBox[{"sin", "(", 
         RowBox[{
           SuperscriptBox["j", "2"], "+", "i"}], ")"}], TraditionalForm], 
      TraditionalForm, Editable -> True]],
    Annotation[#, 
     TraditionalForm[
      Sin[$CellContext`i + $CellContext`j^2]], "Tooltip"]& ]},
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  PlotRange->{{1., 31.}, {1., 31.}, Automatic},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}, {Automatic, Automatic}}]], "Output",
 ImageSize->{184, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->298540019]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->763626859],

Cell["Fill below the points:", "ExampleText",
 CellID->914344741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"i", "+", 
       RowBox[{"j", "^", "2"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "3", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "3", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Bottom"}], ",", 
   RowBox[{"FillingStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"Opacity", "[", "0.3", "]"}], ",", "Blue"}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"PointSize", "[", "Tiny", "]"}], ",", "Red"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2146567702],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->272834274]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(19)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->491200172],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ColorFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->46577706],

Cell[TextData[{
 "Color by scaled ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " values: "
}], "ExampleText",
 CellID->638191020],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListPointPlot3D", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{
         RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", "Pi", ",", "0.1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "0", ",", "Pi", ",", "0.1"}], "}"}]}], "]"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
        RowBox[{"Evaluate", "[", "f", "]"}]}], "]"}]}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "f"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Hue", "[", "x", "]"}], ",", 
       RowBox[{"Hue", "[", "y", "]"}], ",", 
       RowBox[{"Hue", "[", "z", "]"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1744032263],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlfQuQZkWVZnbee/96dVc33Q3dTdNNN9A0IFAiLYgoBTrqiMq2jwVlRAvZ
RnF8FRISuqNGuULIrK5jOb52dTAKDRhfuC2GzDqOjqWh7iihto9RdhhXysFR
x9WJFmNXM2bPdx6ZefO/f9VfTbsxEVtx/6r6/z9vPs453zknT57M+7Srb3jR
gZdefcN111y960nXX/2KF113zSt3PfHl19NH1Rrn1jzgnLt5q6P//4X+4xd+
fkwv50bo9ztDCBP09130d1z/jhyVb6+gdxU1WNFfT3/P19Ll54/Su7s+T7Vd
Se8cvsZf+vHZe/y7T2tfqdwjtbVhyv1raf3ZShEuVadSzp2n7Q4ucb62uHyJ
1NZz+r4fNNaVS9pohyv5r4XaR1dul8fIi4qePExLl5+fqXd3fZ5qO0DvQOaz
tJYD2jNXHThwQIdvNQ36LtX2gmxceSnr4zW5RKGgFOHWx1f4PrVyofbZa+kd
+rdnrSrPrNWu8qi8KcrbOB9TlD9hmfKpV7jLNVFiBsjNlkjDVCzW6+TH+j1c
jVu1l3011qlGqRNje+zQvRyuzjR+rnlZxB6rtTbF55XVHO88QykwXJ14W69Y
p1HgohXr3DygzrpDvtL4L8pKd9F0o0rVWiZm7JmWPl1HPEwtpfyMd9Z4ho53
eogaS15PdHJk+LFu0Do3PKSxtmqpUm/KcnuHHOl6pd3gXrV1jOvlUtItK+uU
q8cUfUSR00LSP6upa2M5Xu2d6aZh66qWqautt7xLtmhS/x5bjqhoYU9IWqrr
/uNW4NqpIWmk/H7redl+1/1pFJfpXVuG7PVlSuuy/KBeDirfVX/q1VN1TNtX
uOsU7dWw5fdor1ZTPvXqyUortm/TLmxbhgZAhtGsdR99s9J9RrsnK+1YgdJ/
cm3t6LPXu1JfT87bdMkW8/tJJ7fRGKbx76wLm7Vvec1dejyvc6uOr2xrR0iS
Sb/kfh6GSWdgDwX/ljatbGOb0mK5NnzYRZ/X8ia8xtGl7bjwCm2nV7RTdbST
qHcKd2U5W2f+CPc3oyeR0vkB9Owa68pWemL1/QlKmDDlpKxz7f5MuSPrz3HK
jdX2Z5f25xhHF5V9jfSH2CP+W9hz5P1ZDdfMQ6naJemnJh5WxD/wbpPRii25
c3LVIfPCjhLXWv3JPpdyaHcKF/07lTga1PeIPaTPZlyYX0UPh+ej+Z5dPQTu
CFjrnPAVF/3c7jYZb2vh7c7grgmr7N1quGq+3bjysYXFBcGiyL2LeOj2e48O
V60/E0wj5twMfzeDsvy+VVb6NuPk+/kj6Nvw/Gz3bR364vm7U1H2dnr/2tDX
N2IgXc4TF131wdCW0kJqjypnzfMc4787A2tt5rCwd0E5vClSUeqpOji8cu+G
53CrX0HQUYN9tahcubhXNhuYB0J9WAQADie9Y+b9aPHXfP9x5u/dYufwSUUc
Jv6+FnykX3nfrmF8emKsa+4PR9K31fDU/FRIYE089cpTeFQRrXU+y6iVwjb/
Tr3r5+mWoXmY90Mt5lSSlRm8n3cCXCeWU1FM73nW0poJgbGeGOuaQwUFjyZ6
rc9rlbs+3KKa2KtWISY/LuNwq49gsL8fXA73HUkf295l19wDuGigK6Dkiady
TatP5KoFa7Zv3ueNzy75ZFZ77mcOapVaNGsp9pBrqRhzMy3edrVcHYLCWAjm
gff3IfdDu/qwgVu7pSUlkBpP7PDhe25T0ar4rfeh/IfivDuyQn7ythPtH6kt
okbgh4sJoR0wBCKXs9dKqVtydadSNq8TA3AjkP2gWotkW6DA1qusm+36AuiX
y89upZfVLP4n13yRzgdwrYG4EnmcvyB010zkkZpf61LNiRqPCGn+2kUN30GN
JmQ+snTanaiUyOujguxX6cU9WuykAWr0s6DBdEg02KU06K/zIruYN2vQk2sd
UYCu7rpp9D5c3tfjRIepIHNF8b32h8booUiUqR57RIfIUyva6HVQxGTj4Zls
+OC0P9GW0Q+Zs8MqJCzzXbX7aYB7MiLMaPPw0B9Fw/3+2TpnGwWZTuaLfkhe
1jqi1QOIyIT7u2l1OfXivL6xJFqdpW2CHw3RqlJaiWdBNDrEF2MbemUq2A/8
2bFgMykXZ+xGq7OUVsdpmZb3F8xrXiQ5OgzTOp98hbXxjvaIRlDjZOgbzXjR
WvVslPnPwX0vqFShvpPBofXc+lqmHMM/3M+tPdqFKnTJwXmsidrydYbKF3Rx
j2gm8/SdGkuYZoLBG0PNIFle62iUrqQhTlCKPayD/zn1vHhV88lesZUdgZU9
7OQ36OsggIUtn+FlkHHuadiZt7BDKTiwdaKmJ2L677Ej+UBqvSJyEpmIlCe6
8Fa6Y5zISb+NoqSrRoN7hgqL+IcnuLLtRNfTtAelt7pVZdMHw/GkIVgElCld
R0qTkNK/o/JZi9LbldKnqbTsDKKJgWFWaHFs9SGWM8HyotB/wqS90WkmExXf
Ymw0WiJs2I/LRblstfQ9SP0DaOkTORU9fXqi8x8Cjr8SJpR6HsSriHxg3E+C
tkEEDBO4tM5EvT2hP6q/SyknJN2pF8tpPW3YpmudjKxFP5KdqZ6OGPWalA5q
R3xEo9Zh+Z6oCEJ6puYCv4EaADXXKe1JguaVjiLFC4o9IqRFt0DJUzvkcxfX
8QDV9wl8/sakW7yE2CCZn3VKWYkqP0M8QZCULrR6o2J9wll7/d7dXqPkWE5J
kcOFiPj1UYcIDYH+ZGGTHB4f2l4cSwnTLHrMTC4HMQRZ2ZNbLxKQUSvSdTao
TWa6zeU02h7aUcO93NYbQa/n5t4Zvb8AxKKLqcUrHCNKKeErUSqctUXtXmkj
t7fotqtDSnbwZ3OBkQlaVomWkEn4xdSTw4mK0rseUTHF8hIVtykVra1dhs/M
w4XNiFSi/0FU9k6MamqnhbaxzUOYS6MUFSFrPRni7I+IGw7iEkSMl+278F/p
de2IIIIk8rm4qI0LZXFZrRyR+kp3HbXyPBeKtonMVMNZriJKXxXcrSGPZLZl
KNF7p0oSuDxCNG6Mxr1I46g0u2gM3Qo6e20JdZmU5nVzL+qo/4h8jB2iVcM+
HzSm2fHJjjZcTyiqRGWN6UVqD9oqxHjZJtEUlL/WQfudsNdsM1N0V2qPKBp+
5SqiaGfLSs+rMDom6t+F3JLKmNtSvF05y2slRFXB134Nz2ZUdV00Rekmo2kZ
x8rzA9Ypra3FU6VQjHom2y9IPKzyKFIs8Ge/EmyAqDvzA0paiHU14u+E72gc
WMrRWvZwUjnT7iFYA8Zci3pO8HuBmZcE99HkeVGDFzqwia51VNsE1AdzihhF
F8IwZR8lLkpMAovuxyU+nHcr9TDxbqt+e6YiolLewVNzCI0u8EV8Uys3w9yl
TqjnMCVR5hQn7YtDrpgDMa5c3aY0OzNk84UqmjsZHTGu4ZnBIdG3U6Iw4jxD
e8b8IjUkowbP3JJ1oR6qVxPKyVaviHOeGOc/CmT8pIUMrCgp5+rwBncKSPJn
73dBezfb6h3xyoc70fU5rsPDk4GjqNHuoXqXuGhrJ+cE+NpzEiGDL8jzWwEf
sZDxp1Zphsl5gH9cl1fPvM10sXVl5Wi88TPvlTc7XEc7HLEoc7xJVndsdMKU
zsuSlUIvQb2u2Q5RK9qbsIQPPJidYWDlmKRxu9Vn4rL/Cevr77rwAeszc5k9
px2OGP2VgMsTp5Wys/Cp3nvAfrp7TMxHn+dYHTNS1vcjZ8UeJwkYDWl1shXD
zmcKym1k6DV9UiIiolKyKBghMYnjgMjUxVh0ntbWAc611k6XQ/xyvW6yXuPf
c/m9qILkn0yb7JCyUk9EPMG0ZoM4XxrFjOseBXQEd3spJE3RzqBaTkusNBL8
3cffQWt8FxeV/QDk+0bVACxVnoTKYUJNMvV+sZg3sFwJTN09uXyUUlWrPF0J
z8lnEuWGHEmSp7Hi2355tFij6RF8KrOeg2GtShiTFp6AXOwHyCIMZMyncaHY
jCglN1OOzaSs9KXzGfByUnbkY7GYAs82ZxEfTDEpFjeOEkyKLzEvAXWWoiRv
IVhMwmZ+wTytUgKX1KQfxLUKro0PNcacWiD6qdzmRfjslqClJFL1AWrlRvT3
6UkyuYLzXPg4LsIijfQG7lw+UpR7L0upBPj6pFQ4eQGGdaLF6E52q5dOiXH0
rzEP5mxJcXjMo0TmMa5pTv3V3P8nAXWGunm9C7WMZLbTaBals07S2R7DcvJ5
dEbTP+eA/8QAbGQeId6sVAq5nTYfmKvy5mFZpKeJsQaVmHHp35JKKOm2g6DZ
XMgHveKoTWKP0qhJgj0JMN3xbVGs/5Eu8bFupDue7tr+KUd5P46Qx30uFON2
93gIbXM3T+HP5Q6kcWMyeiIup1HSiwZ7aEdLv/ZneLRHv5Y40KgEi+yZotWR
LUJ4UaLHUitmPJdajv/En3INy+Zbw2vQEvEnS/HWDC2XruTds5Wc5Cj9ThmL
RAnDfhnLlDNtLPN8XReX2Bnp5sipGmI5p1fX6qDN0R7qqKA8b+HLk/B5SF/D
8ncxXUTXS21UJIU+PALoPJ4XsOi6QnULllXdZdKWlr4bMigCSJfbkGSwhgBK
WP4i7mjX2l97fjf8GEuvSGeuYomIotCWlcoac4Tjo4dYUcoFWYPxa3JZc+C3
m+mZvPHMJms+5lAceU/3Cm2yWb8vIlOGH8iWN4mSCP+iSSZUp/itUaqkDsRB
80AMl2LvBkZDR2Er8qvHdSlbe+V7U2XAw8WuEXGi6y3BfdU824qECiJ1vGhw
+vAKuLHu80isIqpflus+jvGdi3nmBmjt57BY/ZJo82kkXvG3JFieJIvuutpl
43ooWqvkFVaFIEnJ9wMhRWvxPKSetXkIz0LcvK6etSSqtjgEx426c5aGl6lc
a3f1t5x15F6gFecpKH82r9HSmb61PJn5iUTSLSpQkEfw2+au6FEvxn2lY5tX
JV1VxzjO5PciP2/BOESI/tmFz9i8FtxowphpGLpeR+WexObR/TC4h9NlMXC2
ZjYmT8IkMXAVJ5aosOeaYDHZNSxS5YiSXI2E/tkT67RsRL1iRDuCeiP6XvIq
DqYZhdoAz7ZRrCJd0xLZhW2ULGly7viaiPWLjDU6E/EqY7mu3azytVy/LXux
u99JBfIKz7ROYFtRA45fccQXskViorLVI5GK+0ZsOY1LOp7GisqWGnby2n7e
92NVlo6877dZ2Ev6/lW09c+mgeiHRGjMMSpPRFWvc/cGdwVQ/UMa9sMhPFnv
VVY80gUrkpgPZto6iCqybJAkL70+uR9pf6L9Hy36v52xtcSrh/i4Vk0EGWE6
1TIDkLWqSjXQuPU21g1vymeyUeqfY1Q+Hko/81VpTB95vVjtlukMuN7K9oO6
6rJ/gVe404wzBMsSnSha4bhonfx5WTt2ldCA15ssP0bFY5PKzoBx9Xmr6X0p
STzC2+BBkKnZzpc7LfKFwEdq6S18/TuVh7Y8uVfB1nmopErWvkmsUGoHj7KJ
LUkqseQq1shVtEQ2ka5bXDm+JGU5ajg60MSS+oVGHzNu4tPxYqxYIVpHZPbK
QV7xgKbKpc4mnYdbUleszjQ299SVU5u7lPmcE0e596UsdnvwZtPFT5P4O4tm
klLIGyzdzmmO3vckaGIZBX04EGweDFGHB0vVqjQPtETd+NEeOcmovxpyKhKK
63rqz1/xJPrnpCqkcKV8pbZEZum6RCO7rFBp9vhh8Xw/SVz7GL22qv3Zwdd5
ZeuydqISS9eHFAeepbZr7KvXj2WbsrtJbCr0wgj9Yo7SX5lnHuzSlSq1Kpkw
ppDMPgnWnMI+Cc75ZZ7bkY5gRyhzVUxC2ecvPTcZb1w9qOJKEf2l9yzBtWYz
aj625GPxLGGA1Ir8W1w9xF1TcReVjnUFbdo5VugPXvXdDk/+NHpdjxGQOIaf
H9A1EgyDlOO6RwZbrVFppGtPSx7fF3CZPKpFO49el491jYlkEHmFIrfrnFw+
/AUL4sYVJNCi4OZblNboxEz2bCRjkD+Vuyrz48Q+mx+nmcDzXX2u2VJLdK4r
J79b1lbqKzJKWZ44+yRfq+dZZQNfzX5UjpYaXpOifyZ1bslWelG0ZpHVMtIp
UZKTxBm7+FuMZsNAaSpHs7aofZeNhsDsITqNCA9drwnuv5mNaUR+9GJdxDvo
rnTh7yFGzr/H8WoLx/3lEv13OX69dsDYVGu+1oXL+WLRohv+oo9fG4aQsP6Z
dXpfclH2UoWlno4ff0fVTte51Ynm2SQONdNA57vGYhLXZZsnl5W4su8++lVp
tmA+BO/GD+KhW985oqtxXoluyMyANRuPCSsM8PRUwe2fzOSQ51lFplTptUkv
Y3Kw5ujr+nLo9/rWLyuTg8fr7g4tHqYeSL65ux00+X5WJtEgyq7zrwE6SX4f
5Ct8VbG2AYypeffZlRj/32PS8+sgE0Zow1HJitPqL6dPXov2PhzcfQMluILs
noeLatgtAgz/YABV2nNfG7lFudM+1akYMa1YVxx2JTV6xEp8tC7I3Ea6c1Cv
qDXFbVKtWanW7GnErkuGJY/ZZWv/tpZps3Lr5UTHKIrIBEqZpdd1E+WkRElq
yRKVH55VQnTrfF1fqRhnKxUjFKK9YJm9bJSlXPc6ceJWIdN1TJSdlV2duZ0u
x1yHNIMeNGb57d2v6HVfgEB79x/oNR06aHA78eT7rv4HF9o0gOodEcnF9V9c
eDmPYgOoVtHrGHq9gTr0B8H9Ldywub91IVk6Thoiof0wZPo+V/0winQ3DSC+
J/C1m27+eVzNkp+6gwoixTVWc1Ckon+yFjp3gWY1CcpsB47JuegiieEeJxQN
S5EuZJqWTNJrW3+KwZ1DmmNWaQYD2aD5UoNo3JCXmlW++3KpV1yNzLjfNUKL
Wa1nmT8g+0iD7aGjwWZxHpsBsZ8qOV4jIvG4lkKKwDOWe6q/l4Is3x2SgLXk
wNpPjFLWKWod5kpKyChnLceLU0DK0XRSooXr8RVoYZLg3W878VCtRdMvjLJ5
jMru7YSJ5NESNv7chReBvyehPLtgwovAhkrwIRC5lLEHDtgONwKJ/5/QA1td
YKQ8x9keQWDD/xAzvA+6cA0Ty53at89BEWJ55eFCosTP+8a7MrVYhzJqABb+
7l/spz+zqj9vKendtBZGzcbdDodFU0MqbP0joxMm4yk+KhJGTvyS5BovhSr3
eiZt44AhCv0bw+ROJHreRlxpSD5ZixIvw+Cp30foztoSKyRal/Atp6AE5+K4
shgFz9TquJ6zEFzccxVTO0V2lzjO0JNVHbhHcxybP6RCoutBPI61+Wp68rAM
rOiG7KbyDKpDEV/wlrrXR1bC1zC0aVmf3wZFm7jgBDOJ6DPQXPWliDbdRXQ+
VygqCZ8Q3DzhzQNwNQC3m68/pDo/xRr5QQ5I0PU8WTl6OfX8UnTiTBUBen8q
uvk4B9yFt5Ih8oBdtiIl8k7Q+yBfhD0P8PUIfu4Vwf0lceGXHCNeL+MH7hyg
B/R9o9+/X5mWnqNDEXPOP0Qk9nmwYYoXfEz24g4P9UWqwhfhVXidsR/MRrER
Pl2GSVdHK4eZX4bJnqAgYVJjL6rZOnDZ0smdCFsNGnP6yidrOXvTZpkhZh36
tL4arV2eESqzaGQAkATEPUKGLdF7op1qjq3Mxdk0iIqZeL6DIcpDR12cHYoI
cSSqOXwAazXrwsp0qlaBzPLu3wYZzZ/Ta55eLyEePyp4cm2ATv8l2WlkuUdX
tKSbAHkSX2RPd4MCfxiAyE9x5OFBeA4f4nzxzXSdHdwrg7sr2rlLqSdnooPH
mVOPncYfd/5YLuJ+HKgb7lEaa3cNZy4DkeMJkQxKgqvg8txAhlwoJ0S5yhEu
v1FYAJfZrW5KHm1cxnmUWskSk5geVHElN3Ayn9E4s48WEzwI2zkZM/8lQ9Rs
hsRDsd9OolK6eC3Cv6j7C1v4xHtv+FzGC+1G50Oxm/h7TNCkH9PEZsVl3cW1
98TLSl1fhKs2PM3J+uSSa6KrijvYUd2veutgEJD2FsTeWIYOGsz22cWt/tBt
bDf1vI4h6XJEVjOnjHcfJyQmVHqCQ0Wo9M9Q9UDI/BL/676OXzdmyNR8q/M9
ljrpu9fpd7piT/iEyXwQ1PsQqJcg6l8JGSSU/oLKfMPk9kzw57hkSx+Hzn/c
fYDePZ9q/DE18agKs59KZhVohm39mODThedEiN7IKA33JEwYUsNNQ0vd79aO
tmuP0jkVURl39LLtqIr8HsAYlgP5uN7WoU0+eQ8ImYGDHD/USEKl6HW9mH8y
bf5upbY17bdp4xb/zAhsO1fgypySo4FaX5znpDGnGS49gzjgVJppqods2Y2S
FSo/ogtdlos8Ke3mkRaOIglGlSPYv225BLKCt1/Inu8SnFVv3PWo4ZhHa7F6
VYhEWzuDp53PdTR84JxiFaEZNlZ3+5ykVTUaqSRMV3ewH/V1QJnXCHjtknpS
S6wZttddQd+8Dj3/SHA/oEt3YYltBXQ9DGwj4A23uvBKjfkdByr3eLv3OHp0
Ld4vUWfvJQRDbj5BL2SggVeb6FJOUCcEsIdR6h7lPu/puklzVdzwlPtderxN
GBShDC2Pl5HJq4hhf614HFM8NsW+Cwnv6QpjFaegINNhYsviuohJ6wMwiUyd
9ujldxmpLKnRW40HV4x8QnAkiNQT12weGnPBoy2tIl4tP0zXEHVmKacwZZ7+
fsGdrvlwZhw+tshPJftIQ4iec0QeiG+wSyuzDDtG3rJUEoliIQGRBqy0DEYe
+4zuKno9ieo9KXiadPqnqP0kvN0hvPw1ft1KuLMIT4X6ZD28AvrcBqUYWVJA
7yOg7Q/8D3D7bU7yE/W8jUqxx7bzVqg+guBlDtjrqfXcji5fC1F7AfTj2RF9
0uImvk6T2JvK1j0wmOG9LIBPlb05OQJXpuKwyOu1KNeuw6I8JcLY/s0KEHj/
nO5Slex+xM4bjfcdQzjrGc5a3mtm+3YmPd3CWSvnqVKk2dpW6TeM6Zg5Ip7F
BPNxlX7GMZolqT63nISmubg5tjB+OdunjRrJz427z4uMyjlNPZEeyHr8CLxN
jhkj+gWK8exxWgcUvdz+8YtXyhbMZtmLmImXdBjPEOSGoIWLPD/AyKkIOT5D
TvUOyPyPgOVfG1qo7aer/74FYihy4jbQ6xShk2KlFqxIjhXyBYjn1wekC3DG
AHP9Cs4EJNAQBS5z8Ti6CqipwlsFMq/mHY6KGfbiJRuGPnnC2g5azQKHT8UG
fZwmQ9dd1EM7YqOg1mpsVBf18jWFOBftJZ8nBPGTNNYeWlFSlrwsS1y9yFpt
FTi2EVFTxRD7Rj3dYZC5jT7mI/Dq2WI/TSp1IUvP0fILqoIKzSpG3DCOoL1a
p3DJP0FOp1OMzVi++wjHadq+IMtOtgacsJHpmJTXpTHPfB+QslXPqsC0TrJe
8MlBdsmZwtm821aru6SIc3QBtxm+GG+2tjLRITlNpk8H0Sz9PaCu+lXBxu7q
3Uw1cg4JeZ6QZ1GYv2ZzdSu49nR6u0VWD9wp9P5i5tLgPLHGgLYgaTnOY3G6
ktQK04SeoCd++tYYqzsXn7yVsx0Jf8eCHjdRm2sV+U+gC/25Dh15uxJ+rIOK
T0U9BMTjeL/dXa7aH1qS142/rk/77f7gfNYy7iKUlCg8y5XGXwxxlZ6wAMuF
+zcgshAkQ6OSZLS4rydL0mXXRnMjFyf6Rs+oqyPqVOzQl3HFHOvlVY5tLMwb
nuYtJ7IXT/OccaZvZpS32VkGWrv4VLnZYqvV2skesVWlNU6uD4iaEL1T/EYp
wEwyO2I8FY2ZhyCRm35KSdSY7LthjL406TAa9c8SRvo+YY1O/hTdE/xuiZ4I
rb7lwo/4gtT+NbX1SjDvHLZhI/hsxHKp6eOL8R2ZnjeHYBkXgilcbVxdkeOq
FlylfA/xn7aCcY49QtlX9VkkXRKu7mO9fZNYNbcGF7evqHJfCGbTC2qdpREa
2cJqts0r1UptvkYcgsyzrgfLXF9mqqyxpFim0/ONbA1ZPMI8cwe8ryxaJ9FM
joGLb8TvOToCG8e5o5xBzp8vydWydHNq6RbE0hnmRghznTm7Hbau6/QG3Dux
SjqMKvY0dzhGQMairhE/0VtOnSwI6NlF+Xi8nXEybVczq8vgQNiceNIg0c5J
A6rlNiek6rJfX1YQj7UxGsjFXuPhLkpAb48PRlixpi427njSjRnOGGMEtv/E
l/PfYj7dC5xRq+dUEV9uVHn0Anq9GXz6NKKPSiPOmupFCMXEE8bQRBi1iRVd
zwSM3sfpy2dJYr27CtWt0dWnt2P8Xwju/3zB4YynS5zGKJscSQiUeJI/kr6L
XPgxUQJXjMJrpgyf1E30WUOjB5bWPGQbZafG5FG1tIZsftNia/0X840qW0FW
mVB/EVQl8sxhLo94Y6UoUh2+305BqmKMkR2gxU70iM1SX6DrxIplcDNgrOb9
zhdjtdPoFtP383LgHOdlqTM5w2kGLsvWtzNdykgsS1Ee2U+ZVQhA9GSyqRDj
tXZv5yioidKYcBmTHFP0Zrv0xQmIId+42jkls9TDJeVWj7OKcOYqC7JLZf6F
4h1yRwln3xKbBqy9DTL/NDZr5+DwNbFsQAVnFW5LfCHs0evTKP+Le7BCjuup
dj5eU2S0UC2j6CT171i+nomnVrwP7/dSX29CfQI+jQBb/AT4o8v5L2AlT2FI
hZ4S3Dt5X1/4Gxf2beC9ZzJ3RI8vcn4se15WJnfdlq1/ttYvm3keck5pnn/G
CMBMzN6waEfMwtAZSaV+Td1h24AfIs4cZzEqBvM9TrJWFzMz0ok3LCnreMbB
UfRFs625Jct33AyDxuVGzMPTtfF19O94jq6Ex+gxGtI44t6UOSg8JyvzxtRt
5F5A8YzFXK94GKP85lN+Ob5PtTRMzsxblFEsYeaRzXsLFBIFZaXE26pDI0SI
k7dOLdaNxXzeG/fH1adl+ZHV7xECFYX+a6xPfwo+3UEIBAipB0+jt9t0nrYN
KDsnYg+woxK/8PdAQwnsnsomzWNTfw97+r9t5/Twjn7PFV3aepIBsl6o8kud
JL04XWsh8XsYsBl+Ba7sdfX1oA4B7UK61OLw/cFmnZNvtO0ZfcB8fcTmd+mD
f3SRunW42tFH3wWFL+yi7LBRlW6pLSN1Mc9V248n7RbW0vBaFTahVjsJ4aoV
o14x6vvjKumcoEO6AGx7wg/Du24ynNrZA6L90zyvpMnIsihdbt+ArY430UKK
xRyX7LK4LjnPW+Kkt5biAlpIi+UaeulFFrGUHGG6/pAyNRtQpSfw1VR81DDX
ZPtCg0UDxnJLKfvqD+gu57guoTBddLa7YXicLrfrM+YVALsxrcB3YJfavYP+
vlAt+DZ2AsfSOgo+gUmlcvuFs9FkOg+jWSPWf1GQMzlwHgfZWwNvPI5DDk/A
bmXRTpc6Re9xklFJvwS6t5OE/wEkOGIXlLkQwOW54HiBz8uDezejlCCKCItQ
9WqFJ/h9YRdVVxv5LPcIpMwDmx8yCqZ0TpRFX4SKthfO7MggSwpvluP58ZRc
mS1OwLIWGR+CWTs9n5/YoKeh14rW5Gmy5HEQ3eSunfvSj9bhRr6okqfWEsd9
yzrkoh40T9Re1JNl7YwQKVjOm8XSpJ3Vli1WWD6X+7aSuAJN1Vjmivq36vmj
Hqaf7YqNVJHzFecjHlVveTuBrwOFvQEUqXKKnKYr7vUN3Lc3OVz+DsLatyRk
9kvCnCDW3UGvF1ayR27Mcr+8Yg1lX4U5dKINnxYm5tEDX43AKyKsfbbEW3ht
jABWhQadfjLAJWcmIuHs0VTVx9Dibnp5ek22aCNGD0S4y4WbNW5LgGrek2W7
H9DzcVZj8cqTD0Jo702w/URdGWRVPu/RNVhR7XUHlqCTEWHpsW9lYmUhvnI9
wZbiKl5ZklNX6wO2t0ktnvkNGX5K7ZJbu2HHujnHDB5ME8/sDDwDXkgZ1NlO
M87X78VZnpoZXgU5jJgbMj6ilwlQYMZ3sNETKzrG54rxae5NNxqGHR+j5aWE
AQKEz7BA/P0lvT5FTf17+IiPt1DNFkw3deaWsqwUEBB2IsW3f+YCXXIGOAk9
RD5KPW+5dUgB8ST5ngTfNV/BI6Ooj7PjjuWe6tpNr0n+R3tuNjNR5OaMIu/B
7Tfheqj2pM/j6c710BmKPcOiiqvRIe07MH0aUWG5lYYHlN6MVekg8X2fe32V
nD3BJwBhIlIvZGfu1xpptGh0uZOnaz6W246VR4kbMbqRfO+Yjmcyez5T3EIg
EWrLHs1X3/erjj+IrOOl3DzmZ/GahKL3rXkozkOgX40AZjbGR2T3sG1PXwo2
3C56pBy1Af7bqrleZahh4byDY/jf0jyqDD/09/FYG6tiVE3ymujz09VDWaDX
t11DoLmTr5e5cAbbyW3QgtcEdydfvwlyYjZOy3bV3uBekq+UvQW12452xegm
mPiX4sFAf8wYI4Dh6RGgICzLOgAMKHuMLPfx5KE8O0D0Rbipi35HD1mdc7WQ
svx4rbbIVc7XY2uN7DeKK97lG8TcbNYISJ1hLEY/5uJTLZocYQJkd7jrBPSH
hq6u2Fse0VgvtiU+lOWw69nMsZnN7Ltld/IEMsV6OFJhAfglPZFST2XTI2zY
I61zq+Q1I4rXBXvROsFd3SnRIWglIJhJupSHU8qT67O507xJ55HhrptSL026
4pNkrb5EGPwRW6yfUqN/SX/fBMY9i43W43FwnNvCq2iaDbIJuEOJJ0ZKAnye
wOfvBF0EfMDfNhr3NUBgwp4cWC9n1TdyVr2eXMwjvYRee2zOdLoT6Dn/x+Co
e28YV+zNAXuK/ceg+FXB3RxC/1n2QsvL2bpdbjOZ3xkGO+OaWVSjxF8+X6rj
s5U0Vo2oRuCIxn5MvSvDXU+FMj8/QCManqMJ7nCZzVjOikoqDI+9coSQqG25
zxoVSnkmStQpac4y2J6N5M8YihEGFxE2ytOaebsWF2yVWmdGS4YxOdkq5R0L
1cqTKrK9u63zd4dDWRdN/MeIGwPQRa9n0f9708o0p1rh1tMJVXj/RAz1xcG9
I3HvZdxgtGpNadU8gFXJEzpeglrxLIGeYusDTo8D30O1b5B1U4IXdf3deILZ
A5CLs+Fh+v/F1hgn73m5DvAeK3cVvW5Gr+76juj2Ti/BhW90ydbRQ1h5qsBI
C2GWGzEoNlENwBo2c+lcirHmS6zNZRlZOotCa+t1ta3vTJUOTTM8xnh+qN4j
tl/z+h/wNXrItmbHf+R3syCBwJiZoRYN9fEsYjRaZvEI9ehpnOFLUt8TEGkK
Pad6yPqinlpkCAYl1hWB+iICaFlVU332XTPoZrroMhzOcroAX8zfT5oxI5r/
GuvS8BqxnvVmQlpASvzz2ZbtI8BBjjeqFavxv8YAn8hYezF98g5I+BcBKaNc
Hc/Vt/PL+Z4NOCqMz0roIfrwRCdAepIAaT+0HFp5jkYfLNp4M1930Sf/6Ca+
g5vCv+U0Rvf64P6GWvqhC+/g4OGaSzpkqFo1xrrOUOjcV9K3ZmnPFBFPRD6v
Qvd5CoatWrGF/m1RP7IehKlMggxTunLdh6k664fNH4bDUplFgvdbFC22Y9b8
wBg975XRc929Phb7XKwTy1pfR2bhDIyuG7cgnNisw7P5KvVB3jMkK1L7sRY2
oIGIrA7fOa1R849iZDhUdVHI1T/lAr/kTV9Alq5Cf0pXl59P/+8DgnQdbCN+
7eX7Xwy5fwe9vkiv37jm8zglwVYTEOjGKvYIwtow0l/m649ceMRGcMGeHal9
iWet1ziRuIoZjMdCRK9z4b/j4XLA3C94Y4P7JmOuslWadQQzAlkLZ/tyqBnO
uunp7g0teqYzFkY0QpTnXpezvvj0vnJFS3dp5D5grXaJ77fcVcXRVs0C4cTz
sc6V2OwJ8zg4W08w6MtRiDnMmZeTx/NWGs0IbBBcS/Hx4u/AkcriQ30imRxJ
PB33YJsX2Jpv1fmoih0EcbGKYzi90tYwjQVlY0ETNFyGtcVDutLFczDzDQ+m
zKrRQRgbQL2pnHp5tHAl6lUEKa9o4gIBGbh3YI81/n8T/76GzdVjqcw+4Hk7
jpzGP3UlUMXbvXbR3OxavouR5glo/g3w3hRoFeeLvDvoU4si0JwH1HoENX1I
6wMS0wg49pvuOj7tDj0WZDCc8XMcw6uprW96bOeWGSoyG5WSg+BV+seSfXtv
KCmZzq7aVtzRhJVjGbkN6k0KzTdb/q/On5DJwMiZ07WlAjnls7Fb618FPycG
9XNB7js2i1V6OzUtkyVIfQoxdEYYkmwW/hXkcERcIsgqFqqnJdKwn0+A5cxe
bavzKeMD5LgcD8vzT23NJ7ivc8I6Ll3feRPVdI0Xid1eiVfF6zwoLZFtBBHo
k2shL3/SGn8upx6CWplJ+CNQ7BGuR4IqYhollZ812iDr73i7xjQPNDwMVuFP
3f8OuCDBt4W3g27vdyyvNROIM3Hd2i5OLy+Tx3fRZplVnFrn9k2xJ2F00jyw
NDceUc3YqAfS5PJxUORjpzyhcwVJ7dLtXT2fMP9nVnc5F+97NntPe78GZJLz
WBqXDqZMJ/jVubbuz9+VrKdGZStq7RmOZrAkp2chdElyFcfcP5vAmL2tzwT3
HS/7caPcohfPZ317DXrxWPTgJFa45KyNV2m1cpPOzK+FCNP7P6HX53D3gySn
t7g4/idYL/+OuPp10OuN4OAFE8E9Pbg/NQ59AhrVnkvKpz2NmffGknsdX55E
l9p5PzVDPjTvzOBzTAdSwb21bz7Qfo5mlzat4m647ty4Sj2TUoK3aM4NRxN7
qk73J3WKpfqm49nuqnlclybdrvzidbvCN1+fa9EmRaXTukg5VzfngaPSKU+l
f6LKQTHQYjRJ4YyEbmV/rB44gW+zSS8/7b3cD9IphycUNNDo93d0Pvh1bP/h
T96mKx3Pp9fF9P9J9He8ziOutUZcSYuqFDYihSKIT2AvBz4SdvC8jQVRZDG8
0ePBbaNRFBEX/5kLd/MC+HMdno4r4/8MS58LX6TLf1NSLW5gtbmWLmrzRBDs
guCujJLYpsKycniC8rhReuWzSZO7OvOIoYN4Jjmp0aYmX3GYVC3Dub+cSy3h
dj9A8vL5o2VW7uhARi5546YF9WCvHj8QUFUih44sk98yozqzztIJS2zyolUH
b7O9n6CEm5KRmj6cP5SyKKuOpzavNFKbB3aNlFq7jV63ltIHru9hdQjAN8Fy
+7HaZpFJa8096GqRPxFBlsCRfgnkJwfiqM4qiiDd/TMIwd18b9C46WdgElz4
PTL8fCBXwAPhqrQ7jYQPzyB0V+LDO7UfxTOcg2nE0LKF7ec1d1mSSm156VvW
KpGj09LLUdVIfMqZZeHreU9dMjlGvzrPYe/QhF19G6H21unanPmz7VkT47cX
k4YyqxvPBJqKkZwQTzdk71GnSDvt/HvR9S75oc1sS3GKnOa1dZ0r3aUNu8ZW
qRSqRiSxeSFdiJHDLtO3e+jvpMYZRvFrG0fsOE7eitl93sXntsaYZTbjqZ6d
xRXuptctemrQKYFThp5N//+Th7i19mxB1jwO8B3lYPv9f8aWewu1dRYfgbMY
yvPBy5ljryV7J3bToLVGVHXIHhfUrNct08W+o502Q66HkLxBs5munuUZOWOm
/eIOlUZjE7YrPrfHy+rA8UEzG5l7r1fpVGssqzsmnU3Mdchmb67XP4MfBnHj
Om57fgZ0Ivh/o53Dgj1OURrVS9zD14YqxXZZNlkyt3nJcBPJbDSazML5BsNT
L83NLQzmIak9CYPlM3M5vyO81VWvx/j+SR6+RVPu/CRprIbeiZj3/f/DhZZ8
LoahqJCkc1dHaZvlCEJnXMoALeW0N6sxLJXTzSqnqiNT3rFKKmofHUI3Niqh
uzJOxTUclc61eZysTs+9yvZK9QpRtKhSlUdx8wiuyaLOag+z7VbNWFmmZvzh
nPJevzT3PR9ngBzu7ihHrd5YqRSiX4/nEMs+ib7CR2QpVH+hsmsbfp2DX/uR
ZimW+ou4H3IoosiSONIviXH2Xeei6EkWVeOEE917QfLX67Pgan6ElwSNPHNu
tEMSWVMOQ4kki7uV26YhqyLyU6nkYfVrzE4tyU6mHZ+VGASf0ZHpx2NX6IVJ
20mhz6uwtbUg/t8o/eqlE8V1abvuz5DRkWS6S8+gY5kZyWQmiQ0/+cJZHgj2
eM4q19Le0tmVR2PS1TEaOZ/q6fR6mpccK5YqcHSSD8uBNGlUAeaQfvPa8Qb8
d4pACe+LvEUZ6RlRPclCtYcaHLEEkGvjQjWWqTepZN1LkvVZAPFujycwyXzM
8zU5zDiT7JzcNdo+/67SGQckaMusnaOdbwWscplp8vowSIuw9LdGA905rufl
+HLP5qDo9lg2QS2ViPRtRIIkh2yDlVnAbF6BYps7e2tRvv7eVioF6oNJ0s9e
jelNepUCeq3xehoMJOBiLvwqfL5c/t2YCsBvUv5dO0thI2M03Os/KzrsFlYo
W5nxkfOdo0n8PqWQhrqIzNXZ/BLrGJtnlUrpORwltxOFNI40Ye0UM42wczT5
QPs1gUyem1frA3/izvd4EnavEACN7fEWnFaEovS1N+rwZuKKfZPbMON+q/fG
efTedokD+ajnnLiP3CvP8em47CdijR45P6G4vxiTRHr/Arx/M2/zlvwv1wjv
X2bpX64v/0t578H86qOhPSqiyT4XfgMK3FLxk4NY+nb386PN/T3Lot08lVr5
j/VffgJAEwNXtoOaKIkkxk0D+b8noyA0/0g6s2bOTnXNsd4Z1+/1e7/tyKjT
/kUPWEJSnGCZ5/X299M4fWqBBy879ZnH4O9GCXTSBR5rnGmCXjvQ6vl8RIZc
b8Y3n4Zf09pNbHsaR/v3NMqODaXwN0Dh3yhTOd6GSAJyZzlv7+ac/9rffnSf
qlRX/aQLVOYP1MrfSjM9N0ObZ9gW5iJdE2kwG4qWjLN7M1pKdLFX8BZ77+v4
JK/sWeV17ldyzHF0UMzR52fzBnsSRdyPcEhiB1XLk1yMYlH23bid9z3uZ8NM
BDnTGxFJ7AmHwe0dXs5lxymUbxb8etuzOhKZq9vehLkevK1z7m7lFl9tfJXz
29LzbTgf2mcZY+92lk9Toipx+bRcZp1lYCeLbRhGGhTyocDrbUH9u74zARih
CxIh8xmC81bspJJezIIXXY1/a7PWGXc1O3E097+MwV3c3Za4K3w8zJwdlYOc
7cNk5I8J/bI5XlJG0Mzc9ZJBWNdJR4PD272dGDwSzzkkDv+Ajx7s29l4Cw5t
8zj0pkpnSR0v+BnB04aC+zIVrENnFlMlzMXH6zt6n7h7+hDc7RF3Nx2SJySW
WrPSpxzUHTw9veApNqz3Mh7GJ2I2RXaNxA7q5RB6vGpitbeqiXk2WMumqWhx
WnZ6Q9bH8b7xb0MN2Ida8m9C+bcPdT2L2fc6fPcR9OEHxEK65PA9h2f1xdOL
/opR2uIhr/vUkYF08SrFiMxw9IczZIDOjVl/E9fOWIFr8Kuww2Wc9yMfdie0
9a49V45IvTWkFZ4JrVmfO9uHvZjBuySLwuVT0+SSPQdFmnDkzIz5NdmTkbMT
FvPIu+rhnFvWuwr+axXkgAwJ9eD+qlJvaIdMxp1GiF6DArfLib7EKJze5sau
tsfQJlbpcy6ep3270AnO3oV6TrYZV6MTki0F+psWhx6Weho5U+ue8Y3EkR0F
liq1hfykt4wfZ1orGlPmJ9hltK9M+zWF9nPeNuVGbVZiYXvigJ1WxPuR5nMV
6KxHxoMzQ1v2RpT2OgcRO1axHXsNSO/x/Daq9fv/4ELxXJ8RecqIPtIgUl/i
0b9i0hPhjfq6L8+x2t2c9SpR/axoy3JvxGg/wuduHGadJhG1CIdIf+gHVGC5
jGfl9F+SIHZb7ucyG2RPbOR5Y7OwQnx+Z6afZrJTx6PHqdrbdi+N5/1RyW80
Ap/PAM+Xo6zR3usgAR/Bw/OY/njKixuVp0rEh7zEw0F3J7rTPGA97l/vZZ3z
NNR7nfZ7XdanRPuzO2lf60lCG4jmJ2U0n85oPqH1rVOanx1pLnk4dTwVT8LW
Zjeq5bVNU87VT1K77ywPdL4urMq49mRSqX12QW0vuTQNvMBNMbbMvh2fDYm6
XsDOm1qHOrcOrRMjr2/Zd6XsidrDrzEHXiL090b/JwgLWr1M9J/q7ytzAKd+
jmpkBac8ndIh+bKv2Yg4ovXbc82nImeDOtiNcqA2DlSRA65vvtwp+7uDZonU
McEkO23YerBR+TBlVgnC0PA8aZNdbLN597q3M87G9Iwzdq5uY985aXsP16qS
yRF6cpL05Gvg6e/H/RXSU/pz3ahqmvYTbx8eLOYtVMZ5kOP5GXUBzxULTB0Q
x3Y+H6s0tfvtCTe17Re1Z22uPCN11kZT0NZOSzhOqXdOkoyNSArWiAKvG/t8
179bkFmlnlF1TzyjyvfYpxG39DeSU0wlfx+jz0eW6POIDg+lITqtI/KckdHF
dvtuU7rwfXoqd74oYCvrVaFd06zbF5rzdKEMRyRrbWHcWoizMo2oPR536oYD
1IRM6QXQQYOnEkBx/gymwzaLnp4hdDijKtpJdDi38BJAMTwzSfR42h+MO09Q
Gpyb95B/cozFPK5e/1Jd8pKl1rO0Tzt07B01xxxA9zksjXmsSDT5ioTk6SLm
LEsSqOLsrN401n3FWDEvGAvt7Lcz9c5dOtaue2wP50J8Hl2uy2UWYyPbrSPb
F/EoRP6cPAf2y3Q/0sGaJ4hN4nyw8v40gkcWvSl3pO3Vu07R3j9SWy139lm5
Pdq784rvyxWXvHzqzXlae9mLk7X0adqL84vvy3U7K3+69mal8hhdpeVTbx5V
lCrX10/UVs7UXq1Ufpe2cpb2apjyVn/q1QVFqXLfxAnaysO1V8OUr7X8uJa3
3U2DyqXePLooVWZgbNW7ztXePDrkO3r6y+3TXlxYfF/ut8vLp95cGNLsKS+9
WUufr714TPF9M6D8o7Q3qymfevPYolSZj2Ge94Xaq2HLP0Z7tVL5Y1QSHtPq
1UVFqXKNe622Mq29Wqm8PcvtYu3VMOWt/tSr6aJU1/mxePt47dV0SGuyZbla
y40PWS714uKQouolv1H6idr6JaFlVVTi8MGTtN3lS6QWH5e1dECPkUKpS7Wl
Qd8/RdtZ7vvUCkbZ0KeXaa32/t9oLfn7dNc7tfS7tNS7/h9/iycDYhfLRZ2l
nhXk9JsR/ftIveuZIT59mf0w+d1kpcY77j6vr+7y2R/5+3OztlY6Wa+8b3yI
+tta7eKQzgCyJyLUzo4zkR85rybWoF/0nRo0YBzTw7aQ3Vue+Vm+t7EO3fvW
qb61MXAgVS7pGtuyFOh6Xz5hqmsUEzqKh96a7csaJBdHZ0yDzt84upQs6+zc
zXvUKLmctA3i25FTtKxtJdk/GvSsMkx0tXF06Vm21oTlKfDQ6LnasfXTs2cV
9HK5lt9laxhL16nEOcVWU19vFbRZTb0ryfAQUlWcCFfqVO+6bUBetquuZWXr
CNqsOtrskueBEnaE46weMlUniveDPIGVKFXWU74fdvQr9ef/p9GVnsXa0O0R
lt6NlRsLbZ9wpfraPuLvxv+lX//yY/7Prfm/egX2Pw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{487, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->573163800]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->144496],

Cell[TextData[{
 "Color by scaled ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " coordinates:"
}], "ExampleText",
 CellID->895408000],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "Pi", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "Pi", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"RGBColor", "[", 
       RowBox[{"x", ",", "y", ",", "0."}], "]"}]}], "]"}]}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->287649445],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->560778469]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->121764205],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ColorData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorData"]], "InlineFormula"],
 " for predefined color gradients:"
}], "ExampleText",
 CellID->479475942],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "Pi", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "Pi", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", "#1", "]"}], 
      "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->334353853],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40239979]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->284351414],

Cell[TextData[{
 "Named color gradients color in the ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->588278373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "Pi", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "Pi", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<Rainbow\>\""}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->535164012],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->336485]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13890496],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " ",
 "has higher priority than",
 " ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->127654874],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "Pi", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "Pi", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<Rainbow\>\""}], ",", " ", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"Opacity", "[", ".5", "]"}], ",", "Red"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1972178269],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4903144]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ColorFunctionScaling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->49681617],

Cell["Use unscaled coordinates: ", "ExampleText",
 CellID->205569143],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", 
         RowBox[{"Abs", "[", 
          RowBox[{"Sin", "[", 
           RowBox[{"x", "+", 
            RowBox[{"I", " ", "y"}]}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{
          RowBox[{"-", "2"}], "Pi"}], ",", 
         RowBox[{"2", "Pi"}], ",", 
         RowBox[{"Pi", "/", "5"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "2"}], ",", "2", ",", 
         RowBox[{"1", "/", "5"}]}], "}"}]}], "]"}], ",", "1"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->119565465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{"data", ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"Hue", "@", 
       RowBox[{"Rescale", "[", 
        RowBox[{
         RowBox[{"Arg", "[", 
          RowBox[{"Sin", "[", 
           RowBox[{"x", "+", 
            RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], "]"}]}]}], "]"}]}], ",",
    " ", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->321275787],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->366685883]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->243700253],

Cell[TextData[{
 "Unscaled coordinates are dependent on ",
 Cell[BoxData[
  ButtonBox["DataRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DataRange"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->135328758],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "Pi", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "Pi", ",", "0.1"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->507703941],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{"data", ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"RGBColor", "[", 
       RowBox[{"x", ",", "y", ",", "0"}], "]"}]}], "]"}]}], ",", " ", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->285253533],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->227922385]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{"data", ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"RGBColor", "[", 
       RowBox[{"x", ",", "y", ",", "0"}], "]"}]}], "]"}]}], ",", " ", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1111763265],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->76016597]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "DataRange",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->5478209],

Cell["\<\
Arrays of height values are displayed against the number of elements in each \
direction:\
\>", "ExampleText",
 CellID->566001237],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"i", " ", "+", "j"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", 
      RowBox[{"2", "Pi"}], ",", "0.2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "0", ",", 
      RowBox[{"2", "Pi"}], ",", "0.2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->723396511],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->655487920]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1720727163],

Cell["Rescale to the sampling space:", "ExampleText",
 CellID->1577717696],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"i", " ", "+", "j"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", "0.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", "0.2"}], "}"}]}], "]"}], ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"2", "Pi"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"2", "Pi"}]}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15942120],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->241034983]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->99154392],

Cell["Each dataset is scaled to the same domain:", "ExampleText",
 CellID->1080449043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Array", "[", 
      RowBox[{"Times", ",", 
       RowBox[{"{", 
        RowBox[{"40", ",", "40"}], "}"}]}], "]"}], ",", 
     RowBox[{"Array", "[", 
      RowBox[{
       RowBox[{"700", "&"}], ",", 
       RowBox[{"{", 
        RowBox[{"30", ",", "30"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->535363502],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->259413824]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->152901898],

Cell[TextData[{
 "Triples are interpreted as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", ",", "y", ",", "z"}], TraditionalForm]], "InlineMath"],
 " coordinates:"
}], "ExampleText",
 CellID->1755387432],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i", ",", "j", ",", 
         RowBox[{"Sin", "[", 
          RowBox[{"i", "+", " ", "j"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", "0.2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"-", "3"}], ",", "3", ",", ".5"}], "}"}]}], "]"}], ",", 
     "1"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1432427007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->436181703],

Cell[BoxData[
 Graphics3DBox[
  {Hue[0.67, 0.6, 0.6], Point3DBox[CompressedData["
1:eJxtmH1sVWcdx5/SB9LSjr5Q2g5kRGALGy8FylZk4jnAwCFEw4ulMgk6mAtq
lWxkS8AQmLrNEWamTAqEtCJTMBlDh0ALeJs66KAUBgTKdbAWOjYufXuwvJxm
jSg55/e9/r7x/HN7Pm1uT799ns/ve58vP/vT+c/1McZUpRiTauRKq5Wvnjm/
v3xydl0svLPge0+cfuC9R1ojbsBn7Ttz405hR8QD+b7ZUD5m2+q2rujegXdm
pv96YceN6L4F3PWds+r6nk9w//+vFo9+Prp34NH7R/cBePQ8cu/T80fcgkd/
b8TTwKN8hNdu3XL/Ou59eG3JiBdWnkduwkcWlY09c+lz5CbcDTqyvu7RLuQm
fM5DR3tePt+J3IQ3/jtWt+nWZ8hNeHFNzduNibPITfjhs1NH3Cs/7kluwg8+
OGvFT7Z/ityEf/DtwTtmnOtAbsL3VxQ1HTiUzE14WtOf48XNCeQmPPNPI0dO
WPwxchM+cez1r5S0vhvTucW9Q7+sOtS7toVyi3tfvNDmrahso9zi3tHpLfXr
ezm3uDd52di5R3/RTrnFve9Me6dgY85Vyi3uPdawoWHPm9WUW9z70fOjE1Pa
L1JucW/ariUVqTkJyi3u9bnyVHPj612UW9xbNHnwsIKnOym3uLftzD9uL99+
jXKLe63jn75wsPIU5Rb3fjz3XvbxxR8ht0nF969WeR/kJjz6vchNePScyE24
H/5dyE34ijAH5CZ8Ypgb9pXwxWHOyE149H9BbsKj/yNyEx7935Gb8GidIDfh
47IrXsn6xjvITfjNM27GtPmXaL0lZN3SekvIOqf1lpB9QestIfuI1lvCqwn3
Ha23hDcp3KfITXi0r2m9JcQDtN4S4g1abwnxDK23hHiJ1lvCey3zwIk+Ez6Q
fMC317bfK93Uitzk92vPW3DteQOuPS9zwXna8w7cqKuFf56+j/dHbvQ8NBfw
/DQXnKc9L3PBedrzFnzYszVrn3zxAnITvuehS5erS67TPu32birPW3DteQN+
Unle9mm3N1553oHXac+D1yjPyz7t9o4qz8s+7SbPO3Dt+QBce172aTd53oJP
GzKu/Ye3WpCb8Iu5HzX/q7UNuT3/g/vXHe+Y8rwFL1GeN+BlyvNBTPhw5XkH
Xq49Dz5ded4Y4anK8y2ecO15B16hPB+An1OeN77wVcrzFvzU+8PGjuvzGXIT
3jVq5oRXX+xEbuH+7SHPW3DteQOuPS9+6yHPO3DyPLj2vPithzwvfushzztw
7fkAXHte/NZDnrfgBz+8unpB0Q3kJry6fcnAeSe7kFvjyftXL3negmvPG3Dt
+SAmXHvegZPnwbXnjRGuPd/iCdeed+Da8wG49rzxhWvPW/CH30iZ8uS8DuQm
3Hwtc+umlmRu8n7a8/i84FOfBzfqwucFn/o8OHkenPq8XL72PD4v+NrzmDe+
9jw+L/ja83huX3senxf8dX791I6vIx/w4i0tt9e/x/s0xdeet+Da8wZce172
aYqvPe/AyfPg1OeNcO152acpvva8A9eeD8C152Wfpvja8xZ8fntJ1tJ7ydyE
N42s+ev0me3ILZwXqX6p8rwFz9V9Hnyl8rzM01R/hu7z4OR58FLd541w7XmZ
p6m+9rwD154PwLXnZZ6m+trzFnxn2/CX/JXJ3PD39p24+Wc1yR4S7l/ra89b
cOrz4Nrz4jfrU58HJ8+DU583wrXnxW/W15534NrzAbj2vPjN+trzFvzw8Itf
mlXFfvvv89z+XUFp8afILZyz/fz3lect+GTd58FPKc9LD+nnz9V9Hpw8Dz5c
93kjvFZ5XnpIP3+z8rwDr1KeD8BHKc9LD+nn35v6v5634CW5hxd2/T45T4Wf
aH6zvv/hyzQXkuclkptw6vPgdG6D30N9Hpw8D0593gjXnpd1l0aed+Da8wG4
9rzMhTTyvAVftLf/N4//Ntnf5LV2x943bl45Q3MhnTxvwanPg2vPy1xIJ887
cPI8OPV5I1x7XuZCOnnegWvPB+Da8zIX0snzFryqfvXsksorNBfS/aGNf/+4
bObfaC5kkOctuPa8Adeel7mQQZ534OR5cOrzRrj2vMyFDPK8A9eeD8C152Uu
ZJDnLfiQIxnLKzqaaC5k+GMee7xo9IUjso4jz2eS5y049XlwOreJCac+D06e
B6c+b4Rrz8tcyCTPO3Dt+QBce17mQiZ53oKv+aK46cF59TQXMv2fpyeK5rhz
yC303gDyvAXXnjfgdG4TE64978DJ8+Da8zIXBpDnZS4MIM87cO35AFx7XubC
APK8BV/rNdTtLnkLfhSennNj68bKZuQWvmaT5y049XlwOreJCac+D06eB6c+
b4Rrz8s6zSbPO3Dt+QBce17mQjZ53oJ/teGY/8CvGpCb8LT+5XVp/a4ht3Ad
ZpPnLTj1eXA6t4kJpz4PTp4Hpz5vhGvPyz7NJs87cO35AFx7XvZpNnnegve+
/vjOrEQcuQnPOt76cM1zCeQWzosc8rwFpz4PTuc2MeHU58HJ8+DU541w7XmZ
pznkeQeuPR+Aa8/LPM0hz1vw2OCLQza9chW5Cb/zaN81JXXtyC3cv7nkeQve
o/s8+EF9bhMT3pml+jx4oD0PfkT3eSO8Rnle/JbrVyvPO/B9yvMB+HeV58Vv
uf5vlOct+IZly6/sX/A5chOeFWS/O7GnE7mFc3ag36U8b8GH6T4PXq3PbWLC
/6j7PPgftOfBqc8b4drz0kMGkucduPZ8AK49Lz1kIHnegs9eNfTSsSfakJvw
ogPrxuTc6kJu4Wseed6CU58Hp3ObmHDq8+DkeXDq80a49rys6zzyvAPXng/A
tedlLuSR5y34+D29rxZarCvwNadHVZ3dlcwt9F4eed6CU58Hp3ObmHDq8+Dk
eXDq80a49rzMhTzyvAPXng/AtedlLuSR5y142cLO3txK5ANeXJy4+9Lg5D4N
vTeIPG/Bqc+D07lNTDj1eXDyPDj1eSNce17mwiDyvAPXng/AtedlLgwiz1vw
3UunnF9wN5mb8C13x55uLsP+jTyfT5634NrzBlx7XuZCPnnegZPnwbXnZS7k
k+dlLuST5x249nwArj0vcyGfPG/Bl+2b/UxpejI34SP+sm/RuHWYF5HnC8jz
Flx73oBrz8tcKOA+D06eB6c+b4Rrz8tcKCDPO3Dt+QBce17mQgF53oJ/6/uj
X978CfoG+OWzJ6bvPIB+Uhu+FpLnLTj1eXA6t4kJpz4PTp4Hpz5vhGvPyz4o
JM87cO35AFx7XuZCIXnegvfGl16ctBH9FvytoswnHvneP2kuFJLnLTj1eXA6
t4kJpz4PTp4Hpz5vhGvPy1woJM87cO35AFx7XuZCIXnegqfuGOdllODzFPju
beeH7nrtpPcfx9hSFg==
    "]]},
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  PlotRange->{{-3., 3.}, {0., 6.2}, Automatic},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}, {Automatic, Automatic}}]], "Output",
 ImageSize->{184, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->550471940,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->286628894],

Cell["Force interpretation as arrays of height values: ", "ExampleText",
 CellID->45035961],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"i", "+", "j"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", "0.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1163052508],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{"data", ",", 
   RowBox[{"DataRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->947339775],

Cell[BoxData[
 Graphics3DBox[
  {Hue[0.67, 0.6, 0.6], 
   Point3DBox[{{1., 1., -0.8414709848078965}, {1., 2., -0.479425538604203}, {
    1., 3., 0.}, {1., 4., 0.479425538604203}, {1., 5., 0.8414709848078965}, {
    1., 6., 0.9974949866040544}, {1., 7., 0.9092974268256817}, {1., 8., 
    0.5984721441039564}, {1., 9., 0.1411200080598672}, {1., 
    10., -0.35078322768961984`}, {1., 11., -0.7568024953079282}, {1., 
    12., -0.977530117665097}, {1., 13., -0.9589242746631385}, {2., 1., 0.}, {
    2., 2., 0.479425538604203}, {2., 3., 0.8414709848078965}, {2., 4., 
    0.9974949866040544}, {2., 5., 0.9092974268256817}, {2., 6., 
    0.5984721441039564}, {2., 7., 0.1411200080598672}, {2., 
    8., -0.35078322768961984`}, {2., 9., -0.7568024953079282}, {2., 
    10., -0.977530117665097}, {2., 11., -0.9589242746631385}, {2., 
    12., -0.7055403255703919}, {2., 13., -0.27941549819892586`}, {3., 1., 
    0.8414709848078965}, {3., 2., 0.9974949866040544}, {3., 3., 
    0.9092974268256817}, {3., 4., 0.5984721441039564}, {3., 5., 
    0.1411200080598672}, {3., 6., -0.35078322768961984`}, {3., 
    7., -0.7568024953079282}, {3., 8., -0.977530117665097}, {3., 
    9., -0.9589242746631385}, {3., 10., -0.7055403255703919}, {3., 
    11., -0.27941549819892586`}, {3., 12., 0.21511998808781552`}, {3., 13., 
    0.6569865987187891}}]},
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  PlotRange->{{1., 3.}, {1., 13.}, Automatic},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}, {Automatic, Automatic}}]], "Output",
 ImageSize->{184, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->323241984,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "The dataset is normally interpreted as a list of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", ",", "y", ",", "z"}], TraditionalForm]], "InlineMath"],
 " triples: "
}], "ExampleText",
 CellID->9356976],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", "data", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->59036276],

Cell[BoxData[
 Graphics3DBox[
  {Hue[0.67, 0.6, 0.6], 
   Point3DBox[{{-0.8414709848078965, 0., 
    0.8414709848078965}, {-0.479425538604203, 0.479425538604203, 
    0.9974949866040544}, {0., 0.8414709848078965, 0.9092974268256817}, {
    0.479425538604203, 0.9974949866040544, 0.5984721441039564}, {
    0.8414709848078965, 0.9092974268256817, 0.1411200080598672}, {
    0.9974949866040544, 0.5984721441039564, -0.35078322768961984`}, {
    0.9092974268256817, 0.1411200080598672, -0.7568024953079282}, {
    0.5984721441039564, -0.35078322768961984`, -0.977530117665097}, {
    0.1411200080598672, -0.7568024953079282, -0.9589242746631385}, \
{-0.35078322768961984`, -0.977530117665097, -0.7055403255703919}, \
{-0.7568024953079282, -0.9589242746631385, -0.27941549819892586`}, \
{-0.977530117665097, -0.7055403255703919, 
    0.21511998808781552`}, {-0.9589242746631385, -0.27941549819892586`, 
    0.6569865987187891}}]},
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  PlotRange->{{-0.977530117665097, 0.9974949866040544}, {-0.977530117665097, 
    0.9974949866040544}, Automatic},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}, {Automatic, Automatic}}]], "Output",
 ImageSize->{184, 137},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->218977947,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Filling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->553098861],

Cell["Fill to the bottom, using \"stems\":", "ExampleText",
 CellID->15967],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "Pi", ",", "0.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "Pi", ",", "0.2"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "->", "Bottom"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30102],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->189679122]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21881],

Cell[TextData[{
 "Filling occurs along the region cut by the ",
 Cell[BoxData[
  ButtonBox["RegionFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->424039988],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"-", "Pi"}], ",", "Pi", ",", "0.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", 
       RowBox[{"-", "Pi"}], ",", "Pi", ",", "0.3"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "->", "Bottom"}], ",", 
   RowBox[{"RegionFunction", "->", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"#1", "^", "2"}], "+", 
        RowBox[{"#2", "^", "2"}]}], "<", "5"}], "&"}], ")"}]}], ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], "}"}]}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->31843],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 137},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->194425388]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->133252649],

Cell["\<\
Fill surface 1 to the bottom with blue and surface 2 to the top with red:\
\>", "ExampleText",
 CellID->94044103],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", "y", "]"}], "+", "a"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", ".3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", ".3"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Bottom", ",", "Blue"}], "}"}]}], ",", 
      RowBox[{"2", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Top", ",", "Red"}], "}"}]}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2021004440],

Cell[BoxData[
 Graphics3DBox[{
   {Hue[0.67, 0.6, 0.6], Point3DBox[CompressedData["
1:eJx12j3oGDUYx/G0Dr1JDwwl6IH5h+MIxxGSy4UKDhd0cRAEFbEVqUpLqx2c
ipOL0EURBcFFLCiiCAq+IqIiCFbBItqlVaGDFsShcFiohUJ18YSG+2YJfNaQ
t+f37Dz+1H2HdwshPtslxA1iHct8/Vy6yNtegdfgElyBN+Aa3IC34B24Be/B
B3AH7sED+AgewSfwVPi6rsv86KGbvjTn3/rqehd52yvwGlyCK/AGXIMb8Ba8
A7fgPfgA7sA9eAAfwSP4BJ4KX/ftMr/78vkbjzx8qnCRt70Cr8EluAJvwDW4
AW/BO3AL3oMP4A7cgwfwETyCT+Cp8PVcXuZTd/xy5rl95woXedsr8Bpcgivw
BlyDG/AWvAO34D34AO7APXgAH8Ej+ASeCl/v3WXee9dvn7x05ELhIm97BV6D
S3AF3oBrcAPegnfgFrwHH8AduAcP4CN4BJ/AU+Hru2qZv897HjzxxcXCRd72
CrwGl+AKvAHX4Aa8Be/ALXgPPoA7cA8ewEfwCD6Bp8LXd/My//D6hXdOvnGp
cJG3vQKvwSW4Am/ANbgBb8E7cAvegw/gDtyDB/ARPIJP4Knw9V+0zIfvvefZ
n2++UrjI216B1+ASXIE34BrcgLfgHbgF78EHcAfuwQP4CB7BJ/BUuPnPl/nr
o3cfeOT01cJF3vYKvAaX4Aq8AdfgBrwF78AteA8+gDtwDx7AR/AIPoGnwte6
xjKf2fXRfvn0tcJF3vYKvAaX4Aq8AdfgBrwF78AteA8+gDtwDx7AR/AIPoGn
wte61TL/+dedB3ef/adwkbe9Aq/BJbgCb8A1uAFvwTtwC96DD+AO3IMH8BE8
gk/gqfC1LrnMv564/5VPT5cu8rZX4DW4BFfgDbgGN+AteAduwXvwAdyBe/AA
PoJH8Ak8Fb7WnZfZ7X3iwG37rxUu8rZX4DW4BFfgDbgGN+AteAduwXvwAdyB
e/AAPoJH8Ak8Fb7mCst8/NAt4dhrVwsXedsr8BpcgivwBlyDG/AWvAO34D34
AO7APXgAH8Ej+ASeCl9zo2X+9gPz+a3n/i5c5G2vwGtwCa7AG3ANbsBb8A7c
gvfgA7gD9+ABfASP4BN4KnzNBZf5vT3PP3ns4KXCRd72CrwGl+AKvAHX4Aa8
Be/ALXgPPoA7cA8ewEfwCD6Bp8LX3HeZr+y7/ECKFwsXedsr8BpcgivwBlyD
G/AWvAO34D34AO7APXgAH8Ej+ASeCl9z/WX+8KcXbn/1j98LF3nbK/AaXIIr
8AZcgxvwFrwDt+A9+ADuwD14AB/BI/gEngpf+zaW+fLJj3fCY2cLF3nbK/Aa
XIIr8AZcgxvwFrwDt+A9+ADuwD14AB/BI/gEngpf+3KW+aE93729Y78pXORt
r8BrcAmuwBtwDW7AW/AO3IL34AO4A/fgAXwEj+ATeCp87bta5vd/fOboi4fe
LFzkba/Aa3AJrsAbcA1uwFvwDtyC9+ADuAP34AF8BI/gE3j63/8F/i7xaw==

     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Point3DBox[CompressedData["
1:eJx12j+IH0UUwPH1DzKIHKOsZIpVNsOwGYdx2J2d1UJkV7tgIfinUIKCJlZy
omBjIRaHkBMsFAKKdmplIVhojtikEpQYGxHEGMTCWG0ED/wTzhSu4vz2u82y
ny0fM/PmvXf4qeceOnFtURSnrymK64rlmcf/v4tp/Tt3AS7BS3AFXoHX4Brc
gDfgFtyBe/AA3oJ34BG8B0/gQ+b//f9+59AvW0cPNuK97gJcgpfgCrwCr8E1
uAFvwC24A/fgAbwF78AjeA+ewIfMl3U7j7t3mtvfTFc21vO6C3AJXoIr8Aq8
BtfgBrwBt+AO3IMH8Ba8A4/gPXgCHzJf9uV53Hr+6AO3/fr7xn697gJcgpfg
CrwCr8E1uAFvwC24A/fgAbwF78AjeA+ewIfMl3N3Hl+8sPX+3V/+tnEer7sA
l+AluAKvwGtwDW7AG3AL7sA9eABvwTvwCN6DJ/Ah8yWvmse3n/zrkc8OX97I
t9ZdgEvwElyBV+A1uAY34A24BXfgHjyAt+AdeATvwRP4kPmSN8/j8TN3fXh2
7+eNfHrdBbgEL8EVeAVeg2twA96AW3AH7sEDeAvegUfwHjyBD5kv96J5fPbs
uf23Pvoh82JadwEuwUtwBV6B1+Aa3IA34BbcgXvwAN6Cd+ARvAdP4EPm+h+f
x/1jF07tnjufeTGtuwCX4CW4Aq/Aa3ANbsAbcAvuwD14AG/BO/AI3oMn8CHz
pa4xjxd//Or43uufZl5M6y7AJXgJrsAr8BpcgxvwBtyCO3APHsBb8A48gvfg
CXzIfKlbzeMrr736xPmXdzIvpnUX4BK8BFfgFXgNrsENeANuwR24Bw/gLXgH
HsF78AQ+ZL7UJa/G/ZZ7v0nvncz8atxXXYBL8BJcgVfgNbgGN+ANuAV34B48
gLfgHXgE78ET+JD5UneeR/vu9mM3bu9lXkzrLsAleAmuwCvwGlyDG/AG3II7
cA8ewFvwDjyC9+AJfMh86SvMo98+dc/Du19nXkzrLsAleAmuwCvwGlyDG/AG
3II7cA8ewFvwDjyC9+AJfMh86RvN4wvv7J38/MGLmRfTugtwCV6CK/AKvAbX
4Aa8AbfgDtyDB/AWvAOP4D14Ah8yX/qC8/jBfMndcd+lzItp3QW4BC/BFXgF
XoNrcAPegFtwB+7BA3gL3oFH8B48gQ+ZL33febz+p51HTzxzOfNiWncBLsFL
cAVegdfgGtyAN+AW3IF78ADegnfgEbwHT+BD5ktffx6PHDr9dLxpP/NiWncB
LsFLcAVegdfgGtyAN+AW3IF78ADegnfgEbwHT+BD5svcxjze/+0bn3x85I/M
i2ndBbgEL8EVeAVeg2twA96AW3AH7sEDeAvegUfwHjyBD5kvcznzeOvBDV/8
+fiVzItp3QW4BC/BFXgFXoNrcAPegFtwB+7BA3gL3oFH8B48gQ+ZL3NX8/jS
zWd2vjt2kHkxrbsAl+AluAKvwGtwDW7AG3AL7sA9eABvwTvwCN6DJ/DhX/8b
kiUsIg==
     "]]}, 
   {RGBColor[0, 0, 1], Line3DBox[CompressedData["
1:eJyF3D0IA3cBhvFrHZpJDzxK0IDpcYQjhCOXu6OCQw5dHARBRWxFqtLSagen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     "]]}, 
   {RGBColor[1, 0, 0], Line3DBox[CompressedData["
1:eJyVnD2oZHcBR68fyCASRhnJFKNMLpfJ9XIdZu7c0ULkjnbBQvCjUIKCJlZh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     "]]}},
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  PlotRange->{{1., 21.}, {1., 21.}, Automatic},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}, {Automatic, Automatic}}]], "Output",
 ImageSize->{184, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->695432253,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FillingStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->334295260],

Cell["Fill to the bottom with a variety of styles:", "ExampleText",
 CellID->1380003293],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListPointPlot3D", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{
         RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", "Pi", ",", "0.2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "0", ",", "Pi", ",", "0.2"}], "}"}]}], "]"}], ",", 
     RowBox[{"Filling", "\[Rule]", "Bottom"}], ",", " ", 
     RowBox[{"FillingStyle", "\[Rule]", "fs"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"fs", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Opacity", "[", "0.2", "]"}], ",", "Blue"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Red", ",", "Dashed"}], "]"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1347400923],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{
     {Hue[0.67, 0.6, 0.6], Point3DBox[CompressedData["
1:eJx113lQ02caB/BfVfAHao0abdRgY8zGnzGGAN1SHW0eD+qouCpVvJUKXmNZ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       "]]}, 
     {RGBColor[0, 0, 1], Opacity[0.2], Line3DBox[CompressedData["
1:eJyF13tw01UaxvEIgj8KasSAEVIMIRtiCCGlrhUHPS83GbksUKEIoiAF0VEW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       "]]}},
    Axes->True,
    BoxRatios->{1, 1, 0.4},
    PlotRange->{{1., 16.}, {1., 16.}, Automatic},
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.02], 
       Scaled[0.02]}, {Automatic, Automatic}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[{
     {Hue[0.67, 0.6, 0.6], Point3DBox[CompressedData["
1:eJx113lQ02caB/BfVfAHao0abdRgY8zGnzGGAN1SHW0eD+qouCpVvJUKXmNZ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       "]]}, 
     {RGBColor[1, 0, 0], Dashing[{Small, Small}], Line3DBox[CompressedData["
1:eJyF13tw01UaxvEIgj8KasSAEVIMIRtiCCGlrhUHPS83GbksUKEIoiAF0VEW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       "]]}},
    Axes->True,
    BoxRatios->{1, 1, 0.4},
    PlotRange->{{1., 16.}, {1., 16.}, Automatic},
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.02], 
       Scaled[0.02]}, {Automatic, Automatic}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{390, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->392205932]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->297562755],

Cell[TextData[{
 "Fill to the plane ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath"],
 " with orange below and blue above:"
}], "ExampleText",
 CellID->835896070],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "Pi", ",", "0.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "Pi", ",", "0.2"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "0"}], ",", " ", 
   RowBox[{"FillingStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Orange", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->355119190],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->341187517]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->122826958],

Cell[TextData[{
 "Fill to the plane ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath"],
 " from above only:"
}], "ExampleText",
 CellID->2099356867],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "Pi", ",", "0.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "Pi", ",", "0.2"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "0"}], ",", 
   RowBox[{"FillingStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1581860957],

Cell[BoxData[
 Graphics3DBox[{
   {Hue[0.67, 0.6, 0.6], Point3DBox[CompressedData["
1:eJx113lQ02caB/BfVfAHao0abdRgY8zGnzGGAN1SHW0eD+qouCpVvJUKXmNZ
Kx7dtmpLPUBd7G5lVkWteGDFrvXAC5WN4kG9KOABKnIIIoFAoivqWI7NDD7O
vt8Z88878yHzzvt+53mfJ/SctTBsdgvJ83lHklpK/HHbxBVdorN5g3o1RV+B
78m0YG5fxwBnAbiKpgxOeS+hw0NwNd1otGcmPqsA11BtW58fxtdUgWvp0oRu
u4ferAHXUcvSYcU34l3gero0pCQrth7dQO7OGbGZfdCN9Mmx3KrnGtxfITn/
wN2gYge4ibbkXqiL2vEI3Exn1iSfqV9ZAm6hc4+m94r54ja4labePhH9kSrz
Tb789/oY39nffLUXXKKMC+G9faOzwWWaZdUnbR5yH1xF+zW2Hf21ZeBqWl5d
m+136zG4hmy9G+05W6rBtTS0Mjy7cGgtuI7abUi6733aBa6n1t+eD45yohso
v3FU0dMC3MdIv6R/8uzgeie4Qie8m477dXWAm8g4PCB07s/l4GbauWBP8PVL
ReAWUvtOPZ3e4ia4lXqdWbIs7nn6mzpuXt02a1T8H+uiLoJLtL7ut/6pG+6A
yxTWak3g100l4CpaOT++fm+bCnA1KRERA3M/rALX0MUve361OLwGXEtPvJzH
Dox0gevo4ewRWWua0PV0cM6LsuxodAP5TK+zTtiG+xup3ZTflx9JwvMo9Kxw
UEz8ejy/iY4dNd0bl1gKbqY4v7tZs27ng1vo4/EBoVl+WeBWaj0gZHK3uz/a
Oa/m1W3bIOTMLkHO7DLkzK6iPkLO7GrImV0DObNrIWd2HeTMridZyJndADmz
GyFndgVyZjfRt0LO7GYaLeTMbnlLzlZK3d5+bIuz1+ycS/Pqtol9g12CvsEu
Q99gV0HfYFdD32DXQN9g10LfYNdB32DXQ99gN0DfYDdC32BXoG+wm6iV0DfY
zdQ3smVprjEd8rRQm8L+oUU5eeBWMpX5b27aXGTn+zevbps4B9kluijMQXaZ
WghzkF0Fc5BdDXOQXQNzkF0Lc5BdB3OQXQ9zkN1AvwlzkN0Ic5BdocB+lf2D
yw5CPiZaEtqkujIlB9xMT3LdQweHFYJbKPmcsyk8sQzcSr/2KHyQHlxp53s2
r27bu0J9sktQn+wy1Ce7ilKF+mRXQ32ya6A+2bW0RahPds/8FeqTXQ/1yW6A
+mQ3Qn2yKxQg1Ce7iVLT2neN2VQObqa116Wxj2QHuIVcwxZW5K90gltpy/cd
617k1tr5Ps2r29Za6J/sErUR+ie7DP2TXQX9k10N/ZNdA3OKXUtxQv9k10H/
ZNfT3qJTuxzSPXADvUx09QhOeAhupGMDmybvmfYYXKFT+vdP7hpUDW6izHUr
s7fJmJuZ9i4bslu1ywVuoaDhr9aefI5upUOj08Ybvdn1r91tE3NjlyA3dhly
Y1dBbuxqyI1dA7mxayE3dh2dFHJj10Nu7AayC7mxGyE3dgVyYze9JTczFeji
6VmBE9xCkS8bX01c4wC30rSO/q+G9Xtk5/M1r26b+E7ZJXin7DLMEXYV7RPe
KbuaYoV3yq6Bd8quhXfKriPvxA8Ob6hygetp46ywv0dmoBtoYFjg3NBQ3MdI
8cnjlYaUanCFpu0ZnPjdo8fgJjqo/mxMz4AycDPNTDPoLy+6D26hB/qG6Fl5
2eBW8m2ldEnuts/O52he3TZxLrBLVNAxp/hpWTW4TC4lJGDt4lpwFaU7p3ca
d90F7pn/H7dNSixB11DQ1pK62EO4j+f3j+H00SEhTnAdfeEVuHn5aTynZ/7W
/eu98KBycAMVFG/M8j37ANxI53YfXv+kNBdcIb8b/7k/KeQ4uInMpj/7972T
YRPdTKt8HP6j3DfBLeTToSopYWcxuJVk3+hM2Zt/Pyiv3W1LEOqHXaL+Qv2w
y7RaqB92FU0U6oddDfXDrqGxQv2wa6F+2HW0vuX/1w+7njSLkj/+W8MFuJeB
lv88XL465Q64kU4dHHNrkqMEXKFxFX7H015iPib6ZlqHmbm9q8DN1P2SrXvj
qBpwC8XeW7jJFOICt9LS95d6Bb35v8b02t227844n/Z8VWwX3dN/BgQ3zvj0
FrhMbvf3G39ZYgdXUX1CZVq/lDTYX009MhwVu1bkgmtoUbj23WUzH4BrSTvi
ys7zvuXgOirf1M08cGsluJ4KRkw8kmp2ghuoTUzpvA3JteBGMsQfC757H3NQ
aFVUnfGdPHQTfVb/wa9zV+E+ZtptVx+NbKgG9/Sfkf0iTkzGc3r6f9n+Casz
+P8s82t32yKFHNgl6izkwC5TsZADuwpyYFeTj5ADu4Z6CTmwa2m1kAO7juYI
ObDrIQd2A1UKObAb35KDQvt+n9Hl+KFCcBMFdXsest2eA+7pP3l/cY378TC4
hYryOtUvG3zeLrqV4no8DW9od9vO32te3TbxXbBLNP/M3Ox/x6DL9GBcXffA
lBpwFXXZN9yupFaBq2lRg8987x0V4BoqzSu62vVAKbiWxqx75nXVqwDc0/+3
uWPnrc4C11P7Lh/t/Nz8A9zLQJ9GHtnRKfwauJH+2NR2UkDuXXCF+jhkr9ov
H4Kb6NoodfzlkY/BzfTTivqvH/tXg1tobKDfkH801YBbaXRlVWfVDu7z1tfu
tv3Tv+2Hxoh7NtElSt12229/3HVwmR4OHrb/9Iyt4CpynOgsTxx7GfZXU8u/
ppVELckH11DYmP/W/TSvFFxLtjk5W2fOrgDX0c6Eha6EFVXgesr5kzksIq4G
3EAJ3RdH3IrE+xqpepNlWXUTuqf/pCyN/3wCuolGjpH291qA+5upfELQ7u3j
8TwWkidnrp4agOe3Usrs/BdJfUvt/wM8uyjG
     "]]}, {{}, 
    {RGBColor[0, 0, 1], Line3DBox[CompressedData["
1:eJyN1wtszWcYx/EzlH/rkiM57OB0O05PjuM4qtiYBc/jHpdNKtjmPkqJNOjG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      "]]}}},
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  PlotRange->{{1., 16.}, {1., 16.}, Automatic},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}, {Automatic, Automatic}}]], "Output",
 ImageSize->{184, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->222738820,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotRange",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->62035469],

Cell[TextData[{
 "Automatically compute the ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " range:"
}], "ExampleText",
 CellID->227564443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"x", "^", "2"}]}], "-", 
       RowBox[{"y", "^", "2"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "3"}], ",", "3", ",", ".1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "3"}], ",", "3", ",", ".1"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", "Tiny", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->90583055],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11318872]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->323133125],

Cell["Use all points to compute the range:", "ExampleText",
 CellID->86616320],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"x", "^", "2"}]}], "-", 
       RowBox[{"y", "^", "2"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "3"}], ",", "3", ",", ".1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "3"}], ",", "3", ",", ".1"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", "Tiny", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4816532],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->398057898]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->620544652],

Cell[TextData[{
 "Use an explicit ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " range to emphasize features:"
}], "ExampleText",
 CellID->40928939],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "^", "2"}], "-", 
      RowBox[{"x", "^", "2"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "2"}], ",", "2"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->186046],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->60906108]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->117054906],

Cell["Plot two point sets with different styles:", "ExampleText",
 CellID->208584661],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{"x", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "20"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "20"}], "}"}]}], "]"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{"y", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "15"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "20"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Pink", ",", "Green"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->916035],

Cell[BoxData[
 Graphics3DBox[{
   {RGBColor[1, 0.5, 0.5], Point3DBox[CompressedData["
1:eJyF2j2KFkEUQNFWE0MDAwMDfYjIIOJfbq3BJQjGbsWlugQTb1AH2prkwU0P
3V/V63n949f3n4+v6/r96LqeXP39+fb/ea191p+ufdafrX3Wn6991l+sfdZf
rn3WX6191mfts/5m7bP+du2z/m7ts/6w9ll/v/ZZ/7D2Wf+49ln/tPZZ/7z2
Wf+y9ln/uvap252rU9+6vnV96/rW9a3rWx9mXd+6vnV96/rW9a3rW9e3rm9d
37q+dX19/nw+T65Ofev61vWt61vXtz7Mur51fev61vWt61vXt65vXd+6vnV9
6/r6HvU9q69ud65Ofev61vWt61sfZl3fur51fev61vWt61vXt65vXd+6vnV9
/T3091Jfnz+fz5OrU9+6vnV968Os61vXt65vXd+6vnV96/rW9a3rW9e3rq/n
Gs89+voe9T2rr253rk596/rWh1nXt65vXd+6vnV96/rW9a3rW9e3rm9dX8+n
nl/19ffQ30t9ff58Pk+uTn3rw6zrW9e3rm9d37q+dX3r+tb1retb17eur/cM
7yH6eq7x3KOv71Hfs/rqdufqHGZd37q+dX3r+tb1retb17eub13fur51feff
1Leub13fur51fev61vWtn1yd+tb1retb17eub13fur51fev61vWt6+u9372A
vt4zvIfo67nGc4++vkd9z+qr29Dvpr51fev61vWt61vXt65vXd+6vnV93d+4
39HX+6L3SX09n3p+1dffQ38v9fX5G/rJ1alvXd+6vnV96/rW9a3rW9e3rq97
OPd0+nrvdy+gr/cM7yH6eq7x3KOv79Gh66vbnatT37q+dX3r+tb1retb17eu
r/tU9636ur9xv6Ov90Xvk/p6PvX8qq+/h0PX1+fP5/Pk6tS3rm9d37q+dX3r
+tb1dS/u3lxf93Du6fT13u9eQF/vGd5D9PVcM3R9fY/6ntVXtztXp751fev6
1vWt61vX1+8bfv/Q132q+1Z93d+439HX+6L3SX09nw5dX38P/b3U1+fP5/Pk
6tS3rm9d37q+dX39TuV3LH3di7s319c9nHs6fb33uxfQ13vG0PX1XOO5R1/f
o75n9dXtztWpb13fur51ff3e6PdIff2+4fcPfd2num/V1/2N+x19vS8OXV/P
p55f9fX30N9LfX3+fD5Prk596/rW9fW7sd+V9fU7ld+x9HUv7t5cX/dw7un0
9d4/dH29Z3gP0ddzjecefX2P+p7VV7c7V6e+dX39/u//B+jr90a/R+rr9w2/
f+jrPtV9q77ub4aur/dF75P6ej71/Kqvv4f+Xurr8+fzeXJ16tvU1//v8P8D
9PV7st8j9fX7ld8/9HVf7r51mO7n3O/o6z7A+6S+3j88v+rrecffS319v/p8
nl3/AhqTAJo=
     "]]}, 
   {RGBColor[0, 1, 0], Point3DBox[CompressedData["
1:eJyF2D2KHDEQQGHZTjrsoIMOFMhCCCGE2L/ccwYfweDYV/cRnIw2ePRzb1LU
x7LMFiVVab7/+vPz99cQwvgSwrewfv7++H8Mj2vfxHfxQ/wUj+JJPIsX8Sre
xLv4EJ9w1nHld3ET38UP8VM8iifxLF7Eq3gT7+JDfCJnX25w/t5d3MUP8VM8
iifxLF7Eq3gT7+JDfCLnOd/h7FPWkW7xED/Fo3gSz+JFvIo38S4+xCdy3psH
nOeefUnn372Lp3gUT+JZvIhX8SbexYf4RM45dMJ5j/Kc09mnrCPdYhRP4lm8
iFfxJt7Fh/hEzrke4ZxLvDfpPPfsSzo/x11M4lm8iFfxJt7Fh/hEzj0pwTnn
OYfovEd5zunsU9aRbjGLF/Eq3sS7+BCfyNfn4x66IvemFTnnV+RcWpH36Io8
9yuyT1fk576LRbyKN/EuPsQncu7xBc49lHsSnXOec4jOe5TnnM4+ZR3pFqt4
E+/iQ3wi57uowrnXc++kc2/iXKdzLvHepPPcsy/p/D/vYhPv4kN8Iuc7s8H5
TuIeT+ceyj2JzjnPOUTnPcpzTmefso50i118iE/kfLd3ON+dfBfRuddz76Rz
b+Jcp3Mu8d6k89yzL+msy10c4lN+j9+L8N1O57uT7yI693runXTuTZzr9CzO
e5TnnM4+ZR3pFqfk/J6J34PQ+Y7nO5POdxL3eDr3UO5J9CzOucR7k85zz76k
s44WX55x1fkFHh7Xvonv4of4KR7Fk3gWL+JVvIl38SHO+r4+46rzKzw8rn0T
38UP8VM8iifxLF7Eq3gT7+JDfCJ/e8ZV5zd4eFz7Jr6LH+KneBRP4lm8iFfx
Jt7Fh/hE/v6Mq87v8PC49k18Fz/ET/EonsSzeBGv4k28iw/xifzjGVedP+Dh
ce2b+C5+iJ/iUTyJZ/EiXsWbeBcf4vMz/weoVH6V
     "]]}},
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  PlotRange->{{1., 20.}, {1., 20.}, Automatic},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}, {Automatic, Automatic}}]], "Output",
 ImageSize->{184, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->72015399,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["Different point sizes:", "ExampleText",
 CellID->100602902],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListPointPlot3D", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{
         RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"-", "Pi"}], ",", "Pi", ",", "0.2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", 
         RowBox[{"-", "2"}], ",", "2", ",", "0.2"}], "}"}]}], "]"}], ",", " ",
      
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"PointSize", "[", "s", "]"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Medium"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5412690],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->352863647]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "RegionFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->911403307],

Cell[TextData[{
 "Plot over a region in ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 ": "
}], "ExampleText",
 CellID->253],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "Pi", ",", "0.05"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "Pi", ",", "0.05"}], "}"}]}], "]"}], ",", 
   RowBox[{"RegionFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{
       RowBox[{"Abs", "[", "z", "]"}], ">", "0.5"}]}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", "Small", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20311],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->55922195]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->150195850],

Cell[TextData[{
 "The region depends on ",
 Cell[BoxData[
  ButtonBox["DataRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DataRange"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1048365725],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "Pi", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "Pi", ",", "0.1"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1926900087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{"data", ",", 
   RowBox[{"RegionFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{
       RowBox[{"Norm", "[", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], "]"}], "<", "4"}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->955241146],

Cell[BoxData[
 Graphics3DBox[
  {Hue[0.67, 0.6, 0.6], 
   Point3DBox[{{1., 1., 0.}, {1., 2., 0.09983341664682815}, {1., 3., 
    0.19866933079506122`}, {2., 1., 0.009999833334166666}, {2., 2., 
    0.10977830083717482`}, {2., 3., 0.20845989984609958`}, {3., 1., 
    0.03998933418663417}, {3., 2., 0.1395431146442365}}]},
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  PlotRange->{{1., 32.}, {1., 32.}, Automatic},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}, {Automatic, Automatic}}]], "Output",
 ImageSize->{184, 137},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->466364349,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{"data", ",", 
   RowBox[{"RegionFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{
       RowBox[{"Norm", "[", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], "]"}], "<", "4"}]}], "]"}]}], ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "Pi"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "Pi"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->469134706],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->88937665]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->502968287],

Cell["Regions do not have to be connected:", "ExampleText",
 CellID->1939527681],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "Pi", ",", "0.05"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "Pi", ",", "0.05"}], "}"}]}], "]"}], ",", 
   RowBox[{"RegionFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"0", "<", 
       RowBox[{"Mod", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "2"}], "+", 
          RowBox[{"y", "^", "2"}]}], ",", "2"}], "]"}], "<", "1"}]}], "]"}]}],
    ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "Pi"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "Pi"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", "Small", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2137760513],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->465818142]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7769996],

Cell["Use any logical combination of conditions: ", "ExampleText",
 CellID->448487895],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"i", "^", "2"}], "+", 
         RowBox[{"j", "^", "2"}]}], ")"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"RegionFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{
       RowBox[{"x", "<", "0"}], "||", 
       RowBox[{"y", ">", "0"}]}]}], "]"}]}], ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", "Small", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->172650878],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->95385374]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->589267740],

Cell["Quadruple helix:", "ExampleText",
 CellID->324257115],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"Cos", "[", 
          RowBox[{"t", "+", 
           RowBox[{"s", " ", 
            RowBox[{"Pi", "/", "2"}]}]}], "]"}], ",", 
         RowBox[{"Sin", "[", 
          RowBox[{"t", "+", 
           RowBox[{"s", " ", 
            RowBox[{"Pi", "/", "2"}]}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"5", "Pi"}], ",", ".2"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "4"}], "}"}]}], "]"}], ",", 
   RowBox[{"BoxRatios", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49555088],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[1]=",
 CellID->799708791]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->70911473],

Cell["Four conical spirals:", "ExampleText",
 CellID->584510871],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", "Pi"}], "-", "t"}], ")"}], 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Cos", "[", 
            RowBox[{"t", "+", 
             RowBox[{"s", " ", 
              RowBox[{"Pi", "/", "2"}]}]}], "]"}], ",", 
           RowBox[{"Sin", "[", 
            RowBox[{"t", "+", 
             RowBox[{"s", " ", 
              RowBox[{"Pi", "/", "2"}]}]}], "]"}], ",", "0"}], "}"}]}], "+", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", 
          RowBox[{"2", "t"}]}], "}"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"4", "Pi"}], ",", ".1"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "4"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Bottom"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<Rainbow\>\""}], ",", 
   RowBox[{"BoxRatios", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"FillingStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"LightGreen", ",", "Thick", ",", 
      RowBox[{"Opacity", "[", ".1", "]"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->305587292],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1nXdcFNfe/8+dBUtiep6b3CQ35cab5OYm0aiJibFrrDEaW+wNe4kmYiGo
scWKiqLYUFQsKFZAlrbUXbazle0FWFg6WFL8h9fv9z3nzA7jsCje5z6+jsvs
7JlzPp/3fE+ZsrNj5oYvXrBibviSsLlvD/9p7qrFS8JWvz1s5U+wSvQXhFAq
/Ne8imD5/8ES+Z/a3NwMH/yfvY6BVxFUxMBfBv7OIWu/xa8h8LaZ/GM/R6KW
NW8Jtuvdzu2eZvO/9NicvdpZ4lO89wsWLEC4dLwObyT6r9XSidVN1odAPVzO
5/9rdXRg6yAL3GpaF872XDtrGsOWI2L/dhLkCiHvWzwE9uEz7Sx/Gpu/o6Cc
EEHuzgIdNEamsO86C7YOFWw9jOT+nvUuzB1gRXNNYt91CVImISriiKKhZHGi
oDbhlp0Fnw8mW41ny3tOkPspdj3NNY7V/LwgVxdBmQNI7rGCtS8E2QqXPfCh
ffuyINezglL6kdzfCNYKt3qOLY3mHsW+e0WQ6wVBKX1I7hFs7r8Jcr8oyP0l
yT1csDbYVvhjmrsHW/YL7N83BLn/R1Da52SrT5uF8Rvw93fB9n8VbP9ZG9s/
w27/lmD7V9j1bW0X6OXeCbKdiI1T/Pl7bWzP79PwIo2kBv999j1psfX++yL6
9zfa8ur8v9Gq0OuC7Tu1quGfbdTcia+wwX9PRP/eD3lMjURRXdXvrzbz+pwg
NfZoDt4nkf61kavviesVsX+FkRHaho4+rI4OvHqRaOFrB2GZK3fua7GiAPkZ
r58gi0+oh24PC2z9z/HqDabrCx4fZtlr+0g5IAv/FYEeXL4ItBAhNXUPJr8e
jxj8go3W1D+AV1D13esJiIF3zGPUMQ+prK3+g1UTiPuQNlT25lFGXL5Vr+1q
DvwTakcdZ755EvTTT2vq/pz61mlsg46nYGTC2wlgAxLWTdyACZrwCurkmzcS
+U7s9rvBnDBg5HlBHATGONriPmtuGZn4uURggWHVkz1QW/sneQ+CRfTvA/oe
JIk4jYQ1gQACqUYRq4/qrm14YHfcBXlIqJNh/z4jUPIvorNXEBeitX/bzgTE
sus7sFpFj9EsCmhvrXXEe9fpvuC0krIaH3B0BWqxLKoy0KbJaAvqHiL3CFVk
AlF39w8QRCO37t4fxCUXuTUND/j7m69xxL9uPVojI4jppwUsaSR0Z7XT8bO2
5s8AaZ5+vg/U0VZ2FzzQbHV3/7SX3cNWGPBBdIMH0nhh2e67Rx1RG7BMNHUC
G2CAlkCdjHz3Os8J+GvEH4N2nh8Sb3QVnVkBaWH80tbZTbCWtGawJvTDEqr9
0+a9V3vnT8oY7LG9RnBvXdryhnHc/91ecRcs8fdSizfUYfj7yQ7HXc6d3Xk3
mDtGsC9CWLch7L6iLj9ubpm1Yne0hJo/8aLQKQoFf/jjJ/P6fHu8wnL9/d8d
fN+ND4Z9nApeIRHfIdRrbdODNtxi/U+zbaorcfdv9t2zj3JXewfaECzYiaeg
/sh2YA8SIm0uxF3bQNucq7LxP3QJS4912WrfUu2kb4COS3isQGZK6EPB2i6C
NvyfkkChgEJjr6EsXLUNhAUDKNDLlIS7rh4cN/5+11XZACTcdXWwTEl46+oe
S8JReRcWA2346w9vw1rCATC0QQJ7wT0m7sYDxymUwgvNDx9bP9/cctRBSgnh
SglEB1lz54Hdcy9Ao3NQGg2/3SccgQXprgGFxlkDLMjaJ+HhravVuauC8ejA
5+GovBOcCGgMRqQDGx8dBZHwJiFDji0eeYTahc+sNSu7+97jWDnLG4GVq7rx
v83K7a9v+v0OYNF5/AFWHTlW9fd/o6xonDfR+cWQTzIgobZo0fe1fzazM108
kw3EEjlm4c6EtJ7JBTuP0jrKSB8ViDK8U4AgJD5CxDFU2+pojAVl+DqfYePv
9/gdESAsq6t+IoSwjIK0P4CIQup/+81Z1UTjTYQBhmC17ruQMA88FoJcEmsw
0+vYzDtKbEeMBc4FvUDKAlKh3F6hVSISZ8/xIcGCs7qJMoKFNhnd/aMRGElL
3N7KGmBkrigFLqWVNSZvKWVU2VRuLi01uCtK/O7KprJ2MCptqG6bESRYYIAR
iTEA1CrGQmiM0RTCMhOeH3mtneyE7RpD6tAqspseBGmpgA291xbB0rqaQrPX
6WsEgKaKsvYDLPXXUIC//VEPABU2hwAg5eeprtN7K9vkhxVjfoO+kMB4dedP
LFnAz2bDLgKtVMgPtz5+n9+pnTwDrf3FAEe8wu7EbZQfiyxJlaXOUdZESIb0
GyzrN0JGSTL9hsnR20ZfeXljJZDsN07ed5SCI9l3rOpJSRrK9JRkVVNpUJKw
eOePJkKyA0fSU19Hm20wliL6EgDJni8ElHCEiRcDZxufbhezlnNLgbOTwsgk
IwjMxgnVTtB++FT7DSiEZXDG9BsiRR379ZMCSMDJh4oI1U6UKiDlU+03SckA
VvRXoOr02/tOUEPSl+ldfntNU2nfKVqtzdIWVUupB6hWNFQq7fYA1Y4c1Yqm
Mn1pBXAFqogBnEhEseJF0lOLBn2ajVtVxT2IDc89fu9F4JJjHxww+HSI8Kip
9Xmd4HSfbebNzlHgfD/gtJub6IiCp3WoA0Dlo+33ZQEDbKF13f8dyOLUT0ri
tQtFa/BVlDX6yxv93to6frwCbyDLFHtNKATAVjWW6bxGIMsAV/Qin2y/WWq9
q6C8xugutbdFVlqitZa5g5I1lFZwZJ/myLogbO88YLurinsDBucN6JvXHJix
hlCwNnugByBnmhromSYh4Y7tJNz6bH1grH8Ea3vp/QGf5Q34Kl/A2ll1BxLM
QSjrssYqAA2IW7M2+sqqGsvr7rgJ63fq7riAtdpZBKwb7ri8NaagrPvO0AJr
eG1qcgZl7aiyA2I+a4XTzmcdQlkXl1Z56mtFOI5DMOi+GLTdf49wDuVzhoN0
euQInAOzwvZGb2u2wv76ZbZ3QKEUMpsa4AgSmhcoaXzAgSZx4PTfBR93YMby
G3oWIOvLKi1VrtaUXTUWe6VT6SjiUX4RKHtqzEC5oq5SQLms1uj2W1tTNpdp
mX5ztOgpjrLRpSspVzur7HzKDGBGncoa/NxYxkGGmKYzO+CMu2H/PUgQNFxH
QeZ+Nsc90lfMfS020NZbn9tsL+XATAyfnxfx6NJpcIAuOcYiM2SIXI2nFtCi
AFsGuKIurclqPea2yLp8RaqSDK9bXlUqcZdJdfZCh1dZ4S1wOcR2SzYlC0CB
rMWrra9RG515hGwInywDaCEiy10CsrZqu6GsnE/W6C/TlfmZQARTsv0HQlv8
soA/vvHJPifgF5glPHSFLwjPwFUyekXHaWpwmhrJWUh8XgnPi0WDekugT8CH
721RRV0Bq7e+BsAKYtZVY7VWuuQOuYAsgNU4ZDU1GiCr1N+gZJ3OdAFZdXGS
y55WX6niyJb5CijZ8vJ8INt/vgYSJWt2F/8HZCGxZDFYJFKoG+SaxubAOaUG
/33heeLn2yAZOPf0twBJTX4VIUmObAHl4J5ZNu99YCnCMEMBpMN/11XbyCf5
AZCUOd2AEYzwSWo9JQav3lKh4Eh6akqqa7QGW4HanNEuksYr1eZrfJJGR55G
n1TmTAWSDMdRbyuQW9Q8jk/rfMVKl1XAUer0wLw6MEvAp1FEElOV2lXXzJ4y
DLAkp5Qwmxmvn3iOHX+ef2gGwF3XZc/kvhIYnQCiw4zDkTJsJidDWzMEgJDw
gR5h+KHZ723N0FFtK7IrBQwdnvRKX05rhn7rDbvxikpx1aK+6S2Is8vjWxhq
z4BMo+wSn2GpObHUXWQq1/pq9Zgi03+xBj3HjVKQgGGBTSNgmFFiaZshA/Ma
Mi8AjBm5tYCRtHWgKLx+SmKRjjeIbfILyD/2KqbTWK/J8w9/Pxkx+EwcWQcU
FcYmAIkoSTj0U7vrgpDMspr5JC0VbqNPIyApN1znk6wqlwDJIsUFt/ZaRXGC
RRqrKjhXUngeSFpzDxuv7FBJjnIkdemH+SSd6hin8ZqA5DN8kgpPYZZJiuci
D5PE3Tpp2fhMLgBN1vhySqoeIgkYW0jieHxZQLILR5J/7Yr0pSCVrA8BmiPf
vU7PaoqCsfxU7arnswSp+fZSZZlF7rbzUeq8Bo0nn4/SWqotKj5vs1/lo7SZ
rskK45yyszb1GUBZIjsPKJ3Xd5ku/ayNWSE99zOHUnt1Ox+lvXCbXZ1AUSLa
tq3W09qSRLZtD1iuQZ0LHJkCmjCu3zQUS51uSjOET5PeLcORtDrvUwL1/t/c
hrp6/33CLnB1+GGSXJ8KSl8MxCWQhMTehVPT8EBuaOK1b0wyp8RPSbprG0Cm
rtRPSRY5neADpqEql03hLBKQNDpyC1VxfJI+8wWr9pwsJwZIWtVnLYWx+mu7
iuPW2+LXaXfOki0blbNzjvnqltKE1Zhk4iaOpLLwoD13g5Ck2XxEQFJsvCLW
ZfFJmvylQUgmFnlZkgwcsCDR1dQq4BgYswlLepmTHZNb6HUOyrQDy5SOU6Pe
TnqIqdVz/2GmfXLM1QKm0JXnOosFTPMtEj5Tm0+hs9zOVZ4x265zTJ2Fmy3K
o4q8E8AUQlOftFZ3JoIyVUWMkS0cLNk+U8DU6yvQaS4rJLvtWWs5pkBUZ0s1
6fdzSEsbqvTlxSn6c8zAVerA8T8gVZRaL2sUgJQjqnY1BCEq1za2EHUa6lmi
ZNYIWp4KSrITSxKPSxgkRzBDWscnmKwtS5S7YcyGRAkm63VpVoWxvJwjWGjX
8AmW+FQmj0ShO8snWFR0ypkbAQSV0vMswYRlmtilLMF1o2SLBmb/MtF0bo33
9DLQpTrzU3XJNZfmlK4onk+wuskL+FTmK0BQZYjnCKo8hRCUIkwwFPBJHbCb
9RRfS0TmmKta+NE2qGukBOmVaP9v+C6Gl1k2lGjL/SqdgpJ8is1NjqqAZAiP
pMLQFCA5+FKR53S+/dEk0wyZWcbbJp9WZldTksWOW0Wa43ySsvzD9szlfJK6
s4tUB2cLSBqOL3YdnQO6lCd/aE3SWF5c5itsTdJebQeSEItSRwawpLE4MFyt
JLGYaSmhLGEi0pplv2FySHyW372e8AIbhcK77IKzFN53Ru6/+eaNRNSpPnC3
D/yjbDNkdQG2/YKyvW4slDldwLbp9zuUbZr+WqEjE9h+vVVG2Q7bUSCRH+PY
FuYfKUlfYszfraBsZbG603NV0TPUx5ZYji4ibAdlb5rEZ1vnyAS22sKjwNaa
vtKmOKZ35Xs8qWrzFaU5iWPrrjUDW6k9A9hKLDd9jZX4WF4EaFEnShbAOqru
aDx1HFkSfx1gGsiH28zeMQFsn2MjT3jnYXC2z7C5yZlBzPQlAdOzNyuBKT7/
RA6B6u79gbHmOWFgolgHRaiuaFSAFTGDNyhRKHAd+oucpmxLMhIBVhRKqUKy
uDMrynMRM2J3HuoKWA05W0ZG5UB6CGvsPGXE14BVsmmC/liY8/B0jPX40hrz
Nbv8MDCVZWykWIttqYBVb00FrBrtTqn2uL3KDlghlDWeAg4rsGYw1c5cyLYG
iziyNs99HE35dS1kyR1C7J0sfGatCb8kIPw8b38wZHOPoZa7Te0hwmUPEUZE
cQhFDOlicU5rwlJHOhxfAeEOJRVKufkMhVxsuQiQCeMOwFif/TOfMTPqQDZ6
i2OcvWm8/shs56EplHGV7pxNGgWMpRmbOMblvgJgXFh8QqHeUqA9xGcsNl5O
MybpynXA2FzlUZZagDFiQDDqCE1O460FznSMSikud/jwPL8BegsKue8oBSRy
HgM3aYDczJ7vw8yebhfhF9ncoRxhGOk4wtApAGGb+77Nc48ShtCFXixVX0YJ
vwIzVI5wjlMPDmjfkFWSIik5l2O9qfYU1N9xUsDFxTuUxYcBsNORWFZWaFAc
pIARA3xRB2PujuJTcwEwJEqYGR2TiV4PTliy3ZyxyloQDYRd7ttK/bmghCGK
/9eESe8AgDuzPe8z7SIbGPPInXV4+tAZsNJzshSrXNdEseIJIB5nMVFyxfHv
aSUtPMsaqjBPSzLlCcOIrbIIeOqsF/k8rbZrxbI9JRmL9dmRhrxdfuleY+5O
bdwMYGk7NtMcM025bigiPN/heI45IqY85ZnbMc+05dBRq0xX3B4hT5gkqDyy
AnsWTAmS9ecVbimf51WDLMdhAJzQxChOxFySeVFHtaMBaHK9ArBUqhrI7Yq4
v+zYzJ97Po7nX5t5c4jOABSOwCDxieKZlgf2IAAlM7+OEKd51gq1u9ZZ3QRg
KVbEAFj0BeWaZroGXDPNl4Crp9ao8eSxXHWYq8N52eK4ppZuN6cvoFyr1Uco
V3v0tyzXjUOAqmrtEH3MdGf0RIrVpzoGWMceTVVLNgNWecZGFqvhrLT4OMWq
K9NRrFmWFAFWicOY7TBSrCLcb4UAUyAKCZByEarUNPQdq4KEiQZovtgumq8G
ohPfJBnCh4iPmekxicZbl6IvzbNWtsXwbWBo8ntv6C5mmk7kWa8rPYUqTwEw
NJXEqtVbOIYGSwIwtKYvUYtXFedu9Sn3GXJ3auJm2qK/AYYlh2YpNg41zevZ
mqEICKL/aQXwmEy5kQJ015gFAI2VZUqvhQ+QHVvVzgaJsZqDSNu5iKOI8PWy
wLwd4/sfAceOQTmS69IdIRdwnPtaLKRG/72bqRX950ObxmcfOsDxbo6hMlHq
zrVV5hKQ5BpI18s6GYCUOHVAkuN4RXUMOJZUKoCjtjTXSDgW6WIVptMPcby9
XC3ZUKmJ1WVv1pycao0eZT0yleOoXDtUHzODcrQcnx3g+Apw/O7ELUhm+7V8
7SlZ8bEi1YYs5T4BxyRNfFCO9HwjYmDkJK27E23dNsc9hbYRIELTBoS4rwSK
/PNIr7ZJMnBXBL4TGoUCuX5ztPSsLL66Qu6s64bhyVx5AXjATldWCfDOa/JS
TRqAZ6lyArw001WAJzYmATx1aYHWm0PhSTUHAJ7VmaQ2nNLkbrTenq8Rr9Tm
bhXAMx2aJo8EeD0U4YO0h6bZo8eDXvOxaQDPkLdTL4mw5YTr0pYiEeBDL1F6
clVktjKK0suz5WSUpAG9i8qTufZcAb1bhmKgh7t2EdBDHWgI8uHh64h0rtTC
7bV2RSC5cyl04WsHKTuNspZj1wPYxec6UtVlucaH2CWo8wXsklTH0o2X5c60
PLvE6FMDu3wFZmeynbU6rxhKLigkEabUuaq0FQrJL+1k51ZEc+z0aTAwhdPY
E02Iu46elyj2ylwKATqVtwDQ5dgNgC7ZWJygKuDQ4bhDHYHcqUzXLZmPDw+J
8FVY0ch3rz/0/YT2kes7QwvkIM1795jL0hggZ/TH59r55KQu5xWdLElXBORS
TWql1xogd5Qjp3DL1LqDQK5Iu99gOmZzYHLyrHBMTvwTkPMoDqozN2pOTrdE
j7TGTjEfnFZEmqxi7dC2yBluY3JyU7zKcpmQe0Gi3APkjD4tJVdgSwJyOfZc
qdt9y6RTeG1ALq4ohyOnNtezRxJ8bnb7XUSiDrD9PSgv4Zli8p08wIW+BFQL
34oBUG5Lg4CU2lIbICXnk7qmudKaVKF8c75ydytSPwpIlRz+Xnfg+6JNQ00L
einCB6sOTqGkDLFT3fk7NDlbgZRR8qM2ZSFHymhNUOgP58nCkWji6ST0LEWV
YbpyrujYo1EJSM2avXbWrDVAaopW+C2dR1GaQilBU1z25n5Iyery+DwbpaSy
YEpZVnOSTpZs0gooXZAfEVDKkW0qVGBKupKLCsPZtuKp5OD3uj2Ti6AlhgWn
pMlc+2hK/9MWJdAKlM5Ii9SWOkopR+uXmKvgcAlAzV2wEigBKyR6IkqYKWm6
Vud9vDUDnNAXU37cNWdsXNiQE3xScQXZ54rys21mWIbeAUilFp+7KI+VWJKz
zTBoZbCkpOuBVIn1DJCC6as8O9x6c648bSWQshTuk6VHak5MLdkzouTAJN3u
yUXrBplm9FD8+BhSSstlufF6sflEofZAdsFqdfFOo08jdahEk88koi58UFkm
MwV1WSUHUBBRFJQIMJG71cEkpGEfpT5pNEHv1tfqxBvTu+SS1WWU0cK+Ryij
TKi4sIVRsroYR5MqHhjJHGKOUa4iKjN3nVxzQKM/CIzUpisQTdZb8/iM1Cem
GXcNN+wZB4xkEUNNMz/FjI5Mt+wfRxlZsrdTRsXpP6hvwcQ4PE93qch4XWc9
JyuOkuSvlGv2AaM8Sw6DGT0D8XQq7yjFlKhQtcY0feGGqUu3IsIJf5dlaDcx
JGhzM7Rvt0mJu585BN/dRKbBwIf03n1SVOWXlW4cQ6aKmYsjZy6JzLSYOD43
1QbKJ0l15kx+zMN89lI+MlW0vDgB+Ciywi0BPtbs7UXpP2vippv2jKR8iiKG
mOb2UIUPUh2axudTlLklGJ8EqfaApGA18NF7ctK0mWJtptSZLpqScAE9TeFI
LW6AEyvNADiL+sas+PgAjSG1u46e98F8hnyWgbvhR/PhR9HbJIpgktsFDsFo
CMGENF5mS1GXqe21uYYKtbVu7qaf5+7ckqSSMqCHmXbhHAq5pjoz+9LxhZcP
ASBmcdIBFJpXtG3O5aOQlNpYAISYsKTD6G3TtRlASJ2zTSfempcSoTk1wxQ1
zLh3vG7fdBxBc/HMQPEwIXnmZj6hdEWCwnhVb02Q6WOz81YXqnbKHWmPIDQ3
auucLZv4hJzVd5CIEAI8ED6Y0D8EdDoEpfMOoTNKgTr1GyanaM5IbTkGP0UD
PSOOY6xBhKmIOCSIMAnhmEASYR4hwGPB1YOQgAez6Po+9Hdj1Ne6Q5N00dOA
h2H2p4rVLTx0h6fQiJGlhSvEazCP9BUZirO5qsvAI1cZw/EQazLTNZhHTkny
BWlspuE2Ivup86LB0YvGHUhQ5UPUpBfbuZ4HMyFREzK4Zxad5UBqH5V3MRV8
h2EITL+PZlmAB8w+GKCBez4cI+iZsMhIqD+lOOFa0ZlU5Q1AorQWyi1yICLJ
X61QHs2XHuSi5CEqIkzldUCy9MaeosghZPI4WIgkY4v8drhKvF6ZvFCTvuwh
JPkRgERmvXqzIIVDsn7TeiTieAyPvqKTJ8jzryvND/PA55r+Qx7kjktR/1HS
wfNy8YEAwxJBr2fb9ReUkisKucFXXmjypGg0P2xevP7wYgLmOoCRmcUApkCx
G8DICRiZ5rjefEGT+pPxygyTeLk1f6vmxuZlN3YBGeOeoUgEZFBXALP81g5I
bYFRZSynYBzOxMy86LTc9RyYm4W3AcxPu5YAmHXLNwCZWxrdjIunpU43H83g
gdlDRmQBGhEmI4JjCNZxcC7Cb2uT77mFABM4xqSHl5gKektlbuCgKDzWQpM7
U1cCU0SIlnWHlnFQsrQygFIoDQcoedKYQk1csfmiikDRi1dYCBT59TXWYxMB
iiYax4tuTV8kWpW8Bb1CoaxM3qZP2VKQupFCKbo2X566JItAMerO8aGsnLNj
5Zyd4bsXFdqzKBS5x45EwAR1htYjQDJkaJbaVT9gsQrh+1u6tp/GewCTo9F/
qLT/wIL+wwqAxilpFtCwVLkoDbU372rRmSTZ2fA9y37csYzSyJPvyStcE6Bx
UmdLBhqGNmjYd0/Sr+lrnNeTwTze4fMoBB5p4epWPPZErKQ8NiyJoDwgSIBH
ouxkWvE14KH3VQCQWYkngci4ny6NmJUKRByVd2mQIHwG/Ml4MGOOiNEAAALl
2CvvAo1+AwtSzMoJaxPGhF3jaORZcoFGivpctjk135Idvn3hksjVlIaiaH9+
4d4C3QWWRtJMnfiHR9AwrOijj5rEp7E2NfLHlM2URuLe7ymNnWE/AY2YfQsP
nZySbzq3cvYOOtwIaHh8MPYCD9SB4hg0NBdwaNx1gAPTeC8oCfLdK94d94E7
6d/Hn3YbHZMJVOCVY1J7508+k5HfJo/+/gYwuSw9sSxyJ2UCEZKpkUYfnRZ3
dryAiT5pJkRISU6k6uZm2a0NFh4Tw5qvoBvhM3EcnBi3PIxjgpjw1I3o+U2r
IjftXrIjbPXOn1el5W2CEAEoYm1GUCiDv84iTETAZNTsZAe+Bw2QiMBScB6P
v2tT+J7EDj5jLQLIlBO9z+l9CkpiN/BBrdj+K4Catfg4gJo//+CsBcdzZNvz
ZWu2rV2/LWJ9YfEFnT357La5HKijEYsAlOfwBAAlDh+dGTaMglIu+Dx9xYis
5cPAQd7K4QDqxJownXg1EmFKL2zevyhXlWhzJuYoDz+a0tAJGUBpxHSYJ8DM
AIVkWkroObRBq+X/dU74uhTuwPmcPgBOF7Q5lJPRV17kdmaZUoHTwvB9WSSg
5kyPBU65su0FsvBtayOA064Dszftmhv3y4K0veM5TkfXL+Jzki/rLeBEA4py
Oh89EccTsyE1HD0HnHIVLZy4GR1wWrp717zIw1w0cZw6UE6Dw+UDVylpI3n/
v0QKl0PG/09gUgSY6C2cQSndUMflWq+zlKbF5hpTMKWiSEpJqj6Jo2nrPKCk
y1ptyfn5aMTCo+sWegmlzHUjcTStwtFkWtUHKFn2T6CUzu0ce3bvd1eix6jF
Eabk+easZYTT81tTV/16e8Xt/M0cp1xDHnDKNN/mc2r6/Q7Ik1hNZEYlGhSu
gHDC3SvuYz8QUAr9X1AiM+nucED29VYZhwiOvFVlJYDI6PPxERVYs7WeXEBU
qNwJgWQ0nlDpTlNE+ozwkqvTrxz65ty+MUrxJmXaJopIFzPeGTVZF0BkOjCJ
Iir4uR9McPR5u/XicG3yalNyGCDKVV+Wam9tu72CAUaoS7Z0BxyUT119Zsaa
U7PXnwRE17Wnc6zXTRWlgMhbXw2IRP+HfPBTCRh8rDoI4Az9RT7+0PULWkmO
IwicbBPETxbAydElYjhFkQBHrTstUx/X229ROIbM1daCbaeiJsbvnRgUTvb6
ATnr+tL44cMx3woryVzKwQE2u28v2Zm2dEPaagqHxk9rOKO2ZcEsHAgBH4Sv
DfwrKJnAiBW4C1z4nWr8HXJy/fyrEdvzJxy6OjHm8rioZA7Cbf11gJBHICgd
Mg6CVBZhNBzX6OJbQ1Cm/aK5skq+8cuiLX11RyY5905WLOulnd1NtaQnFyEC
CCW3wiwZS1dsPLRk7THobCK3b9ubtvBQWtjutKV5lpwCe0ZQCDCL2ZbFAATy
7RQgQFNwDvj6JLaNnwiAevC9jt2XPHKrpKzBj71qTvK9SrSnwWuRYpNSHQte
tcZTAa9TDRmrrdk/Q2vQJK0qjRmr3zcic/Pg3FV99OF9jfNhh3/V2uuZPYvO
7l4EXpNipoPXpeuOgtdi08momB+PpM3Zn7aQ+UW8CnUUeB2xNYfvlYHZ6L/b
dMjfs8Rpx7JGf65LO+7gDXC6LjUCnP58ey1iILzQv6C6reIVu9IX7U5ftCN9
6QFx2Km0qWD1uHgGazVtZUnSNGP2z9Sq+sZabDVqROaGgc5tk/Qrv9LO7K5Y
8CVnVbJ+jMCqUbzwh03RBksytZov36LW7IkWhyHitTPf66jtWeB1+NZcs99r
8nsRPuZ+Qreh4DbPpYWBCxK4RQyYJV6fCur1dNpU8Ho8bQYTK56J3sw4PDE+
7fv429/H7P3p5M5l7uixeRuG3P75W+x12VfaKd3lYV+09npix3JLxtqSm7PB
q8p0hXrVW88XKPcoVVsNlnNQNbM1fQXqNDc2bsWZKLBa3lhBdyu1+h84DSmp
dsO8jzplsNUXwarClZpTcl7pTJ0Vdfa7LckWn/LH6AN7jq9Xqzb/cnAbWF0X
FRWXNhXMHk+fTq2KDmbORq/mRQ4RrxsNPnWwT6d3l89v6cxdMZOoT4tkA/Vp
zlgGPotNidRnoXIX9al0Fomwz45gcuGJIzDMldZXl/jdgf2Jj4XxxQ/Wx4dP
sF/h2BncUsPe+lrE4K9OvgB2M4xxYNfkUztrrGBXa7loNuwDu0bj8XV7DxhL
zlut1y4eDBMfnkTtIuyXOZw1A70CbuMyvzfN+9S0qu8j3FqzVoJbhf4MHJvr
LeelKtbt9IOXph64gkS/pi9FobBPObtTz50jx/0fP5k/OMSBjbz1NZ6Av5eD
+jMZojSqLeDP5bhE/dnEK63XZ3pyf/EVbLNmb7elRHoPjaUej2ZNA4/YZiuP
xZJtfI8a42WVIZ563J2w7mDCT+BxRvTFafsvt3jEXzXlPDIg+pN2e6R7HwKd
7/CV1g6VplPgUKfd/ZDDdM7hdnBovxYODh1Rowo2fgUOEQMGmZNZU9BLgp1o
lURaMtdQg2uO7/v51K8RcbtbDFoTLBXKslqDo8aGRLsyFqEQMDj1XML0hHgw
KArij4ye3PO5upNV4IkOxDDvJa7+xndl9GnAVbHphFG7XaeLNlkShK7yfnFn
b7Vlb/de/gG7OjAGXMHMwTr3C8fUboj6Op01GUTAK+cr4cQC8amJrX0Zin9t
7UvE+UIMxBnC1vjxF9Qhfw/ipwWR2dgzYBKOGGdcPL362tZHmESMqeQ8etFZ
fAhc2lKWUJdWya/g0n3wW+xyQ4tLx4o+jj2TOJPM2ayJ6DnO5OVTsy22q5Gn
foXoBG/F+oNgsth8AkxW3/GCSa03FzF7M+YjkavGzPoUgc9u7fJGnm/3DvXF
Wfv55vrV17b9kLRn0eWDzmor3xoYg/3nLI6hzlyS9Xj/5UZRZ9KtQ6kz7bQe
pikfOX7omxkxOmftSHwvgIj4upY+5lbaaLrzrParJsu5IL6aSucnHuF8hc5P
jIH+hXaBeAd2b5cz8mSw7mBo7fVNYGjl1d3E0KF554/vSFp79OrifUmrtiRu
2Hpp09aLGw+d//Fq/Mwbp6a4JBEXjocdPrYqce8s+dYhRZsHZf062hkzXTfl
U2xoZX/OELQzcOQuOkgtWZPnBLWkNZ8oCVhambRLtD9zHgrh7EBqnxvyHMVu
avfNfEu8vVLKWdlzdRVY2X15bWsrF+PnXogLO3y8TSuu/ZNL906iVioKoqiV
1LRRWclf304dyVmBpqUlVnbf+GlZUhRnBWEv5LyLCGzw2ko7903Pe380gCG5
/RIYslfKvLXGmjseY0ksBJvDcsrpSITOAgxBM3Jl/nTj1Pewb0olG0ql0aVJ
4e7937iiRuVBsMVMt0/riZvRmkECQ66iQ86cLZyhpKxvjZYEamjvjZVgaP/N
FcuT9i68fAhaEgiAwREc4SkBdtWj/U6epk6K7JcclbKgThADXmDUJVZct5eD
lbKcjWDFm7TavX90e6y4cjaX5W5wJs9DInCCOoCXHdfCwcixlDBTSezypD0M
2EAhpbUGsEDTE/p4quaOW+u6pXHfJD6k1Icp4IPBRl512BOdql2urNWujJ+c
QhsjiI0ZYMM+4ZPWNiDEOBsMuGCuZ32DQqkN2B9QE3TciPgIBR8witOEp3g9
2+8jBPtw34TmeT5rPHMpaxx6GyqDuiDdyhrldCaCE/DhkG0BH+7sCOrDm7cT
+4j61v04HyfPzwcfSQlTss6NuZkweVPSBuoECrdZTwmchGy5vZJz0iuoC+Gz
aUlrD4XBD8YD6gKb4Ii9CfWkZo6kSZw53JmxAky4MtdjE/KD0Dyc0d/gnbG2
T1AThTsHJ5yeBSYunZvOmajy5UDZIigadeAc/PZH/S9pq8CACKYanwm0i9rW
LuK0IwbUo1DQz98FiAHl6A3Qnpn+de7toRLx1xLx0ILUwW3J16z4PP+XQQL5
ZxNmQyy5k+f4cyNBfpknGYomJXeiDgD/5rSV29KWb01bAYrAw+ft9/AB7C7Y
ApoRjEIwkYB5IEzwT4hnXkybeCp1eqk3RZw+3OtOkaQNpQ7y0rADWfLgwtQh
eeKh2m19wEHOtiGG7z9u7QCiqEJ11CfbDw48t+eDA7/rJjio8OWIsIOQOPHU
beIVcNgG8jHO9iknuV6Cbgw082XHiadfSptwMnX64dS5+1MWHkoJS7o6KfPC
N6kJY/mykahAPBi9CKKN0z6hokv3T6OiS49MfoToCl8uA7uTpxs/QQBigMQC
v3U+1gN5wvHzVDclfun2+LjU6TGp80D6/pRFIF2SMBKkJ12Y5JfuPX9hGkhn
QLlIljYI/dUxuZtrzeD268ZRmDHsdPr3v/2Bn3TC6u7dLq198ctz5Y7zNsNu
n/dGtU/SWKVsqlJWqPf7xD9UZG/wF0aBxCrlkerrm307x2G8DKhkFLcHomdc
P7ZLJmJi02aLQCMKpRKhXUHCcJ9A5QtlrVWq9vsyfqiQRHIq/WdXlm37tmzH
WMnSPr69cxDWyahTB6Cn21KZnTjiTMqUOPE0ohKF1lRkSdK/hgRScdPH89kv
2q/ypSAq1ft84hWcygrZfv/ZVb5fvwOVeYu/AJXOb3s6h32EiM5ntcn9oaLy
Q1NBZ7l8P+jMuDSi6PxgSeIwqrOhWtlQowSZDIgkvROemrIanoDnywGlt/hK
K8QrKh9WWrlrQtmecXyl7hWDGZCJnsHXw2/2B6EpV0anXP4GhBZeGAJC62zX
oExOKGKgO0Ei6ENBLRb8ZVCVwifk9sMv73qsJ4jKm61VVoHKwqgWlVHf5a3s
44ue5/qOVana0JviBJWGG/2oyqr87b6MFRCcoBIKBJVQMlEJwY1H2z7tV/dK
gGFwdVUQarJ9fHXqyM9d4z+zDnvPuPATrC7ic3JsAeJQ52rVkWp5lE8S7s9c
XWM8+5A23K/1Fehi2tb16kO6qoku2XaIwsqC7aAr/+IQ0KXY18e0oadh22fa
rV9o1vQqmfihZfh7+nktukCVyHytL+rUWlZqxsiUjJG4J+j3BKqgMcL+yBEP
zUgfDoPPbfGIoqsDNRf6yS4NKrw4OP/SkJzLQzV7sCr9tt6cKuuY970rhlfu
W1C5C3+Tzn9oHgOqGEvSV6gjJwuKS8uANAJkofbrokwhO7Q9CBLEgGdcOnpW
fmUAKCu4PLgAKxtMlcF+9B2akvvDV77t011TP3dN6AbK8I9FoGcaik43GpNA
lO1KH6pKemNQhngYVQXOoRLcaT4BrxAqCiSxfhkoG3WuVxypKzpcVxRTr4mv
iV/F10QKRiGUVcXWUZgV/o4J3i5Ud/ErTtL9RjsSgZz2qRlI1IAO0EAdMo7E
PqiD88KXoKSBJwPXhjpzaPhCKCBEvkFEtqZifmu0gxgICzDbv11qhhA1IAJK
AQWQGNe5L4jzZwS7RlC/4nJ/eWJ/XDnJLfq90fYbqRvh/ix47SGCOwhaKRE1
auNrsyIaZDFkY8YT/wV6tnWUcFIsm3uoz/YFKcpL/SHIGNCPRE3WJPY7Bwzs
8QFBlfB+NYR7pc++5RTRlfQ3M0JBFy2zSXcFACGi7DlvXO/S459D4sRZ5v7b
HPGpJeJT+7ruIE5LxN0vSbtvSUMi2JC0CSgmuCr6RORWV+9aacK/ykGoh1JY
IOquVXzXmo4YkISeBUVlR3GyT3zfMeY9EGWJ6M6Juqu+fM8ipqJE2EcINAnQ
BamZfo8qeCTzn5+N2tQ2iNVGPn2qSRtfkxVRDxL1V+7axHes6bXxa/07JlOF
jO/wZ+gpvkL/9vHVhxcLFeJeJPC8DGHP/Zcn0DagueX7oegpLtaoNvOFPo5f
e7jXd3ds6B7Q9qwvulf5itH+A8sq98xprQ1ggzp4BX2Bb6wJR7y/sPHG36uP
2rd9WX7k3tenqUbX6c+dp3vbzn5pOdei0RbZvWJjGGJAIursi+rVlkgkAthP
saUK5zSsOvYXX5Dg+igG2ruZ95yILtjx8c9dJz9zn+rtOPsF1ePfNa3qwLKU
Gf0qIud5vu3DgBjUyberpz96AV+O63RvV3xvEbANfG9aeBRJ1Qh/+eUzNjd9
zhQO7NjPXcc/c8b3Zh5UlKCO9Qkb/DumVe/HCnyrp7tG93YN/RS47OqJQn3b
e3ASQDJiXHF0z2IZbPkBNcKzCsHV9GB5kLMNL0NRwN93oNcfThmIeeArqT+3
wf/r1ICaGcDDPbwnaAElFb98Cq+eiO7u2M/cJz/HWpAIbw6FgKQXWB2fBtUh
fPJhd1YHubPzOVxKVC9cza6eoOMPmxTr2DW7ev9S0FH+42T3t31cw3p5Z44G
BYgBJSgEhHhisJDfnTIsI/AdX+F5u+D1f8LmJs9VepYzCIlX+bKU6bhyz5g+
rq8/884a7Vn+sagisjsSQcUgEypGJFpw9Wy5ARXC8/HBVfybpfA3qoJKgIax
rnttXDiWcGQ13g+rJrvH9HH0e9c5+j3Pso8hAwM5kAiUggocKDha/saWJbwe
F7zmD9jcfychhKtdh6utWN3Nv3MWrhacr5zsGPQPqNYF1S7/2LPqYyC/uhsK
Zevd3gMnqP0N1rPwno7gNb/H5ibfF+hC6/T98AmkmtifvIs/ck143zHoXUf/
rlBtXVxUXfw+Bj5DIZCN7iCo9S22DHx3zF/gL66ppTbc/ruy/v5J4+uHT8qX
fAzJu/Aj13ha/rtlYRNp+fRTeMXoIbT+wZb+z6Clt7qXP+D8mYakA7iWsI/K
Zv3bNe59z9gBnlFflYVNoLXQj+AVKEZ278rW8e5j63iTzUmvKpcv+7h0/r+h
AsTgl1DvuP6e0V9xViBD2EdIBFTZrf/Jo/3oel5nvZDIfaps0Uelc3E9pVM/
9E78F7x6RvctD1Qjgg8+ZPO/2apk4S8aBSKT/P4GVt3priSZlusZ+wGRjxl5
p/6LgbWBlvnGY8t9pbml58Nboo53c1L2TfoWFzoS8H8AWDzj3kciqKg7m/e1
x5b6MquWnrlkNY79YN/3uFyYOY2EAp39u3pGv0/fj/2gB1v2q48tO/C8GHIW
oROrc+T7ULb/l7Xuoe+5BvwTXkWkDviU3SpQ/l8fW37gmSlkltGRFggJCscL
X3aFVySC1YFR8aWgJQae5Ytz0JkwW9KXXVEIvDCBYthav2hu+bZ7oLTW2gJP
bCC/myaCYpy93oUEMHu9y8Dbfs0tTyBou5TAPAXPa0Md3f5BNoet8Wf9m1ue
+tR2CSGsjhFkPRRh//AdSIjBL/g9m29gc8uTj1pKEz4blmFLG93M9n32rm9D
gtLgRQRFsvkGs6U99ejS4BPy24GhsGB76y2acFHDm1vmVQ9vj9eOI8b424xu
bpkrtuR/ms3/bUAt/IXM5PcKA8/HaMn9rNAbq3Icm/svD+UmT8iHd8MFucfz
ciPya274w6FByuTm3eRb6vjdIEGub9g66P0JgR5LeLQ2gs1Fn7L2JvtOOLMd
yq6nz1z8R3PwGeZANhe5l570pvhD4dnfvmwu8pwCMraGsP0dP9cX7Hoy2qOP
mnn9LS9XLzbX30mubs3BR/XubC76KyKBWZ3w3tyP2FxkFCQz0RB2zOHnCuil
v/D0JVuW8NtsXdlcRC83z/+7INfbbC4yCyRHLCK21+XneoPNRX9TbzD77q+C
XK+y6+nvBA5rbumz+LleZnP1I7lGsrmEzzF5ns1FIoqLI+ETubqw678muQIx
Gez5SDjXSJJrApurgyBXCJtrDMk1mc0lEuaCxe9Ijqnw2gHeTSLv/lu/+Yr+
8v8B5QaW4w==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 204},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->193870921]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPlot3D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Graphics3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics3D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Point",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Point"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ContourPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContourPlot3D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPlot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataVisualization"]], "MoreAbout",
 CellID->30836047],

Cell[TextData[ButtonBox["New in 6.0: Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataVisualization"]], "MoreAbout",
 CellID->514205114]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ListPointPlot3D - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 58, 2.3196670}", "context" -> "System`", 
    "keywords" -> {
     "list point plot3", "point cloud", "3D scatter plot", "3D stem plot", 
      "sampling plot", "data plot", "scatter plot"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ListPointPlot3D[{{x_1, y_1, z_1}, {x_2, y_2, z_2}, ...}] generates a 3D \
scatter plot of points with coordinates {x_i, y_i, z_i}. \
ListPointPlot3D[array] generates a 3D scatter plot of points with a 2D array \
of height values. ListPointPlot3D[{data_1, data_2, ...}] plots several \
collections of points, by default in different colors. ", 
    "synonyms" -> {"list point plot 3d", "scatterplot3D"}, "title" -> 
    "ListPointPlot3D", "type" -> "Symbol", "uri" -> "ref/ListPointPlot3D"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[19171, 641, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->871068191]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 658064, 14196}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1757, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2380, 67, 1580, 37, 70, "ObjectNameGrid"],
Cell[3963, 106, 2569, 81, 70, "Usage",
 CellID->12121]
}, Open  ]],
Cell[CellGroupData[{
Cell[6569, 192, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7047, 209, 378, 12, 70, "Notes",
 CellID->29012],
Cell[7428, 223, 4237, 123, 70, "3ColumnTableMod",
 CellID->22939],
Cell[11668, 348, 524, 17, 70, "Notes",
 CellID->8031],
Cell[12195, 367, 514, 19, 70, "Notes",
 CellID->267096302],
Cell[12712, 388, 333, 12, 70, "Notes",
 CellID->84038818],
Cell[13048, 402, 468, 16, 70, "Notes",
 CellID->1283],
Cell[13519, 420, 841, 34, 70, "Notes",
 CellID->51877402],
Cell[14363, 456, 908, 33, 70, "Notes",
 CellID->6057],
Cell[15274, 491, 1733, 62, 70, "Notes",
 CellID->7142],
Cell[17010, 555, 577, 20, 70, "Notes",
 CellID->9487],
Cell[17590, 577, 258, 10, 70, "Notes",
 CellID->10404],
Cell[17851, 589, 775, 27, 70, "Notes",
 CellID->24233],
Cell[18629, 618, 505, 18, 70, "Notes",
 CellID->23139]
}, Closed]],
Cell[CellGroupData[{
Cell[19171, 641, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->871068191],
Cell[CellGroupData[{
Cell[19556, 655, 147, 5, 70, "ExampleSection",
 CellID->56317417],
Cell[19706, 662, 94, 1, 70, "ExampleText",
 CellID->308361593],
Cell[CellGroupData[{
Cell[19825, 667, 411, 13, 28, "Input",
 CellID->378989803],
Cell[20239, 682, 4674, 81, 160, "Output",
 Evaluatable->False,
 CellID->313466608]
}, Open  ]],
Cell[24928, 766, 126, 3, 70, "ExampleDelimiter",
 CellID->1988213045],
Cell[25057, 771, 71, 1, 70, "ExampleText",
 CellID->461767540],
Cell[25131, 774, 677, 21, 70, "Input",
 CellID->1145859703],
Cell[CellGroupData[{
Cell[25833, 799, 115, 3, 28, "Input",
 CellID->1713633048],
Cell[25951, 804, 4201, 73, 162, "Output",
 Evaluatable->False,
 CellID->15166567]
}, Open  ]],
Cell[30167, 880, 125, 3, 70, "ExampleDelimiter",
 CellID->880219883],
Cell[30295, 885, 66, 1, 70, "ExampleText",
 CellID->2068628169],
Cell[CellGroupData[{
Cell[30386, 890, 481, 14, 28, "Input",
 CellID->755253340],
Cell[30870, 906, 6995, 119, 159, "Output",
 Evaluatable->False,
 CellID->95631189]
}, Open  ]],
Cell[37880, 1028, 126, 3, 70, "ExampleDelimiter",
 CellID->1260662455],
Cell[38009, 1033, 73, 1, 70, "ExampleText",
 CellID->1818031653],
Cell[CellGroupData[{
Cell[38107, 1038, 821, 25, 47, "Input",
 CellID->459716027],
Cell[38931, 1065, 7317, 124, 169, "Output",
 Evaluatable->False,
 CellID->163045547]
}, Open  ]],
Cell[46263, 1192, 125, 3, 70, "ExampleDelimiter",
 CellID->340927836],
Cell[46391, 1197, 70, 1, 70, "ExampleText",
 CellID->217836768],
Cell[CellGroupData[{
Cell[46486, 1202, 545, 17, 47, "Input",
 CellID->247541331],
Cell[47034, 1221, 14255, 238, 160, "Output",
 Evaluatable->False,
 CellID->492749226]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[61338, 1465, 222, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[CellGroupData[{
Cell[61585, 1476, 225, 7, 70, "ExampleSubsection",
 CellID->116659251],
Cell[61813, 1485, 354, 12, 70, "ExampleText",
 CellID->5555],
Cell[CellGroupData[{
Cell[62192, 1501, 338, 11, 70, "Input",
 CellID->96713535],
Cell[62533, 1514, 6256, 113, 160, 1718, 34, "CachedBoxData", "BoxData", \
"Output",
 CellID->104764449]
}, Open  ]],
Cell[68804, 1630, 125, 3, 70, "ExampleDelimiter",
 CellID->640365652],
Cell[68932, 1635, 371, 14, 70, "ExampleText",
 CellID->628844391],
Cell[CellGroupData[{
Cell[69328, 1653, 569, 19, 70, "Input",
 CellID->180860335],
Cell[69900, 1674, 6568, 118, 159, 2131, 41, "CachedBoxData", "BoxData", \
"Output",
 CellID->695256]
}, Open  ]],
Cell[76483, 1795, 124, 3, 70, "ExampleDelimiter",
 CellID->66967797],
Cell[76610, 1800, 79, 1, 70, "ExampleText",
 CellID->159530242],
Cell[CellGroupData[{
Cell[76714, 1805, 670, 22, 70, "Input",
 CellID->143866527],
Cell[77387, 1829, 9326, 164, 160, 3198, 59, "CachedBoxData", "BoxData", \
"Output",
 CellID->179166814]
}, Open  ]],
Cell[86728, 1996, 124, 3, 70, "ExampleDelimiter",
 CellID->86934994],
Cell[86855, 2001, 413, 15, 70, "ExampleText",
 CellID->41928725],
Cell[CellGroupData[{
Cell[87293, 2020, 372, 12, 70, "Input",
 CellID->137625449],
Cell[87668, 2034, 3697, 65, 70, "Output",
 Evaluatable->False,
 CellID->45660084]
}, Open  ]],
Cell[91380, 2102, 124, 3, 70, "ExampleDelimiter",
 CellID->67570298],
Cell[91507, 2107, 80, 1, 70, "ExampleText",
 CellID->333416587],
Cell[91590, 2110, 828, 28, 70, "Input",
 CellID->73990447],
Cell[CellGroupData[{
Cell[92443, 2142, 166, 5, 70, "Input",
 CellID->127994308],
Cell[92612, 2149, 4547, 79, 70, "Output",
 Evaluatable->False,
 CellID->21750110]
}, Open  ]],
Cell[97174, 2231, 125, 3, 70, "ExampleDelimiter",
 CellID->119237889],
Cell[97302, 2236, 95, 1, 70, "ExampleText",
 CellID->360827733],
Cell[CellGroupData[{
Cell[97422, 2241, 792, 24, 70, "Input",
 CellID->64910129],
Cell[98217, 2267, 4908, 91, 163, 935, 21, "CachedBoxData", "BoxData", \
"Output",
 CellID->562341963]
}, Open  ]],
Cell[103140, 2361, 68, 2, 70, "Input",
 CellID->27997802],
Cell[CellGroupData[{
Cell[103233, 2367, 491, 16, 70, "Input",
 CellID->234457578],
Cell[103727, 2385, 3803, 66, 70, "Output",
 Evaluatable->False,
 CellID->619116201]
}, Open  ]],
Cell[107545, 2454, 125, 3, 70, "ExampleDelimiter",
 CellID->226160967],
Cell[107673, 2459, 206, 7, 70, "ExampleText",
 CellID->76854780],
Cell[CellGroupData[{
Cell[107904, 2470, 553, 18, 70, "Input",
 CellID->501375403],
Cell[108460, 2490, 4637, 80, 70, "Output",
 Evaluatable->False,
 CellID->112281200]
}, Open  ]],
Cell[113112, 2573, 223, 8, 70, "ExampleText",
 CellID->316263374],
Cell[CellGroupData[{
Cell[113360, 2585, 1223, 37, 70, "Input",
 CellID->41344862],
Cell[114586, 2624, 8800, 148, 70, "Output",
 Evaluatable->False,
 CellID->83535626]
}, Open  ]],
Cell[123401, 2775, 125, 3, 70, "ExampleDelimiter",
 CellID->428308280],
Cell[123529, 2780, 257, 8, 70, "ExampleText",
 CellID->272043783],
Cell[123789, 2790, 873, 27, 70, "Input",
 CellID->1147823540],
Cell[CellGroupData[{
Cell[124687, 2821, 481, 15, 70, "Input",
 CellID->5386680],
Cell[125171, 2838, 4348, 75, 70, "Output",
 Evaluatable->False,
 CellID->438239646]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[129568, 2919, 233, 7, 70, "ExampleSubsection",
 CellID->132373399],
Cell[129804, 2928, 220, 8, 70, "ExampleText",
 CellID->157416703],
Cell[CellGroupData[{
Cell[130049, 2940, 638, 19, 70, "Input",
 CellID->254754736],
Cell[130690, 2961, 5567, 95, 70, "Output",
 Evaluatable->False,
 CellID->39596880]
}, Open  ]],
Cell[136272, 3059, 124, 3, 70, "ExampleDelimiter",
 CellID->77456497],
Cell[136399, 3064, 91, 1, 70, "ExampleText",
 CellID->1298077331],
Cell[136493, 3067, 507, 17, 70, "Input",
 CellID->5012897],
Cell[137003, 3086, 534, 18, 70, "Input",
 CellID->499897646],
Cell[CellGroupData[{
Cell[137562, 3108, 598, 19, 70, "Input",
 CellID->499332244],
Cell[138163, 3129, 6589, 112, 70, "Output",
 Evaluatable->False,
 CellID->581862501]
}, Open  ]],
Cell[144767, 3244, 124, 3, 70, "ExampleDelimiter",
 CellID->18985160],
Cell[144894, 3249, 54, 1, 70, "ExampleText",
 CellID->400933500],
Cell[CellGroupData[{
Cell[144973, 3254, 716, 21, 70, "Input",
 CellID->1833133861],
Cell[145692, 3277, 5007, 86, 70, "Output",
 Evaluatable->False,
 CellID->727198395]
}, Open  ]],
Cell[150714, 3366, 125, 3, 70, "ExampleDelimiter",
 CellID->324506061],
Cell[150842, 3371, 72, 1, 70, "ExampleText",
 CellID->2000753416],
Cell[CellGroupData[{
Cell[150939, 3376, 645, 19, 70, "Input",
 CellID->1363717986],
Cell[151587, 3397, 10965, 184, 70, "Output",
 Evaluatable->False,
 CellID->211158439]
}, Open  ]],
Cell[162567, 3584, 125, 3, 70, "ExampleDelimiter",
 CellID->468410419],
Cell[162695, 3589, 219, 8, 70, "ExampleText",
 CellID->581641354],
Cell[CellGroupData[{
Cell[162939, 3601, 564, 17, 70, "Input",
 CellID->93552325],
Cell[163506, 3620, 153836, 3861, 70, "Output",
 CellID->225768634]
}, Open  ]],
Cell[317357, 7484, 225, 8, 70, "ExampleText",
 CellID->562981635],
Cell[CellGroupData[{
Cell[317607, 7496, 726, 21, 70, "Input",
 CellID->300675534],
Cell[318336, 7519, 11374, 202, 70, "Output",
 CellID->298540019]
}, Open  ]],
Cell[329725, 7724, 125, 3, 70, "ExampleDelimiter",
 CellID->763626859],
Cell[329853, 7729, 65, 1, 70, "ExampleText",
 CellID->914344741],
Cell[CellGroupData[{
Cell[329943, 7734, 800, 23, 70, "Input",
 CellID->2146567702],
Cell[330746, 7759, 10322, 173, 70, "Output",
 Evaluatable->False,
 CellID->272834274]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[341129, 7939, 223, 7, 70, "ExampleSection",
 CellID->491200172],
Cell[CellGroupData[{
Cell[341377, 7950, 233, 7, 70, "ExampleSubsection",
 CellID->46577706],
Cell[341613, 7959, 297, 12, 70, "ExampleText",
 CellID->638191020],
Cell[CellGroupData[{
Cell[341935, 7975, 1007, 29, 70, "Input",
 CellID->1744032263],
Cell[342945, 8006, 20075, 333, 70, "Output",
 Evaluatable->False,
 CellID->573163800]
}, Open  ]],
Cell[363035, 8342, 122, 3, 70, "ExampleDelimiter",
 CellID->144496],
Cell[363160, 8347, 230, 9, 70, "ExampleText",
 CellID->895408000],
Cell[CellGroupData[{
Cell[363415, 8360, 692, 21, 70, "Input",
 CellID->287649445],
Cell[364110, 8383, 11900, 199, 70, "Output",
 Evaluatable->False,
 CellID->560778469]
}, Open  ]],
Cell[376025, 8585, 125, 3, 70, "ExampleDelimiter",
 CellID->121764205],
Cell[376153, 8590, 220, 8, 70, "ExampleText",
 CellID->479475942],
Cell[CellGroupData[{
Cell[376398, 8602, 625, 19, 70, "Input",
 CellID->334353853],
Cell[377026, 8623, 6836, 116, 70, "Output",
 Evaluatable->False,
 CellID->40239979]
}, Open  ]],
Cell[383877, 8742, 125, 3, 70, "ExampleDelimiter",
 CellID->284351414],
Cell[384005, 8747, 173, 6, 70, "ExampleText",
 CellID->588278373],
Cell[CellGroupData[{
Cell[384203, 8757, 500, 15, 70, "Input",
 CellID->535164012],
Cell[384706, 8774, 12540, 210, 70, "Output",
 Evaluatable->False,
 CellID->336485]
}, Open  ]],
Cell[397261, 8987, 124, 3, 70, "ExampleDelimiter",
 CellID->13890496],
Cell[397388, 8992, 350, 14, 70, "ExampleText",
 CellID->127654874],
Cell[CellGroupData[{
Cell[397763, 9010, 660, 19, 70, "Input",
 CellID->1972178269],
Cell[398426, 9031, 14558, 243, 70, "Output",
 Evaluatable->False,
 CellID->4903144]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[413033, 9280, 240, 7, 70, "ExampleSubsection",
 CellID->49681617],
Cell[413276, 9289, 69, 1, 70, "ExampleText",
 CellID->205569143],
Cell[413348, 9292, 773, 25, 70, "Input",
 CellID->119565465],
Cell[CellGroupData[{
Cell[414146, 9321, 706, 21, 70, "Input",
 CellID->321275787],
Cell[414855, 9344, 6740, 115, 70, "Output",
 Evaluatable->False,
 CellID->366685883]
}, Open  ]],
Cell[421610, 9462, 125, 3, 70, "ExampleDelimiter",
 CellID->243700253],
Cell[421738, 9467, 223, 8, 70, "ExampleText",
 CellID->135328758],
Cell[421964, 9477, 424, 14, 70, "Input",
 CellID->507703941],
Cell[CellGroupData[{
Cell[422413, 9495, 452, 12, 70, "Input",
 CellID->285253533],
Cell[422868, 9509, 4714, 81, 70, "Output",
 Evaluatable->False,
 CellID->227922385]
}, Open  ]],
Cell[CellGroupData[{
Cell[427619, 9595, 662, 19, 70, "Input",
 CellID->1111763265],
Cell[428284, 9616, 11639, 195, 70, "Output",
 Evaluatable->False,
 CellID->76016597]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[439972, 9817, 228, 7, 70, "ExampleSubsection",
 CellID->5478209],
Cell[440203, 9826, 140, 4, 70, "ExampleText",
 CellID->566001237],
Cell[CellGroupData[{
Cell[440368, 9834, 432, 13, 70, "Input",
 CellID->723396511],
Cell[440803, 9849, 5312, 91, 70, "Output",
 Evaluatable->False,
 CellID->655487920]
}, Open  ]],
Cell[446130, 9943, 126, 3, 70, "ExampleDelimiter",
 CellID->1720727163],
Cell[446259, 9948, 74, 1, 70, "ExampleText",
 CellID->1577717696],
Cell[CellGroupData[{
Cell[446358, 9953, 713, 23, 70, "Input",
 CellID->15942120],
Cell[447074, 9978, 5463, 94, 70, "Output",
 Evaluatable->False,
 CellID->241034983]
}, Open  ]],
Cell[452552, 10075, 124, 3, 70, "ExampleDelimiter",
 CellID->99154392],
Cell[452679, 10080, 86, 1, 70, "ExampleText",
 CellID->1080449043],
Cell[CellGroupData[{
Cell[452790, 10085, 807, 26, 70, "Input",
 CellID->535363502],
Cell[453600, 10113, 5068, 87, 70, "Output",
 Evaluatable->False,
 CellID->259413824]
}, Open  ]],
Cell[458683, 10203, 125, 3, 70, "ExampleDelimiter",
 CellID->152901898],
Cell[458811, 10208, 202, 7, 70, "ExampleText",
 CellID->1755387432],
Cell[459016, 10217, 600, 19, 70, "Input",
 CellID->1432427007],
Cell[CellGroupData[{
Cell[459641, 10240, 114, 3, 70, "Input",
 CellID->436181703],
Cell[459758, 10245, 8257, 146, 160, 3760, 68, "CachedBoxData", "BoxData", \
"Output",
 CellID->550471940]
}, Open  ]],
Cell[468030, 10394, 125, 3, 70, "ExampleDelimiter",
 CellID->286628894],
Cell[468158, 10399, 91, 1, 70, "ExampleText",
 CellID->45035961],
Cell[468252, 10402, 427, 14, 70, "Input",
 CellID->1163052508],
Cell[CellGroupData[{
Cell[468704, 10420, 177, 5, 70, "Input",
 CellID->947339775],
Cell[468884, 10427, 4655, 84, 166, 1565, 29, "CachedBoxData", "BoxData", \
"Output",
 CellID->323241984]
}, Open  ]],
Cell[473554, 10514, 218, 7, 70, "ExampleText",
 CellID->9356976],
Cell[CellGroupData[{
Cell[473797, 10525, 113, 3, 70, "Input",
 CellID->59036276],
Cell[473913, 10530, 4028, 75, 158, 1223, 25, "CachedBoxData", "BoxData", \
"Output",
 CellID->218977947]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[477990, 10611, 228, 7, 70, "ExampleSubsection",
 CellID->553098861],
Cell[478221, 10620, 75, 1, 70, "ExampleText",
 CellID->15967],
Cell[CellGroupData[{
Cell[478321, 10625, 474, 14, 70, "Input",
 CellID->30102],
Cell[478798, 10641, 6996, 119, 70, "Output",
 Evaluatable->False,
 CellID->189679122]
}, Open  ]],
Cell[485809, 10763, 121, 3, 70, "ExampleDelimiter",
 CellID->21881],
Cell[485933, 10768, 238, 8, 70, "ExampleText",
 CellID->424039988],
Cell[CellGroupData[{
Cell[486196, 10780, 994, 33, 70, "Input",
 CellID->31843],
Cell[487193, 10815, 5267, 90, 70, "Output",
 Evaluatable->False,
 CellID->194425388]
}, Open  ]],
Cell[492475, 10908, 125, 3, 70, "ExampleDelimiter",
 CellID->133252649],
Cell[492603, 10913, 123, 3, 70, "ExampleText",
 CellID->94044103],
Cell[CellGroupData[{
Cell[492751, 10920, 883, 28, 70, "Input",
 CellID->2021004440],
Cell[493637, 10950, 20481, 351, 166, 10120, 177, "CachedBoxData", "BoxData", \
"Output",
 CellID->695432253]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[514167, 11307, 233, 7, 70, "ExampleSubsection",
 CellID->334295260],
Cell[514403, 11316, 88, 1, 70, "ExampleText",
 CellID->1380003293],
Cell[CellGroupData[{
Cell[514516, 11321, 920, 27, 70, "Input",
 CellID->1347400923],
Cell[515439, 11350, 28341, 486, 161, "Output",
 CellID->392205932]
}, Open  ]],
Cell[543795, 11839, 125, 3, 70, "ExampleDelimiter",
 CellID->297562755],
Cell[543923, 11844, 203, 7, 70, "ExampleText",
 CellID->835896070],
Cell[CellGroupData[{
Cell[544151, 11855, 593, 17, 70, "Input",
 CellID->355119190],
Cell[544747, 11874, 6971, 118, 70, "Output",
 Evaluatable->False,
 CellID->341187517]
}, Open  ]],
Cell[551733, 11995, 125, 3, 70, "ExampleDelimiter",
 CellID->122826958],
Cell[551861, 12000, 187, 7, 70, "ExampleText",
 CellID->2099356867],
Cell[CellGroupData[{
Cell[552073, 12011, 587, 17, 70, "Input",
 CellID->1581860957],
Cell[552663, 12030, 11375, 198, 159, 5479, 97, "CachedBoxData", "BoxData", \
"Output",
 CellID->222738820]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[564087, 12234, 229, 7, 70, "ExampleSubsection",
 CellID->62035469],
Cell[564319, 12243, 160, 6, 70, "ExampleText",
 CellID->227564443],
Cell[CellGroupData[{
Cell[564504, 12253, 614, 19, 70, "Input",
 CellID->90583055],
Cell[565121, 12274, 5327, 91, 70, "Output",
 Evaluatable->False,
 CellID->11318872]
}, Open  ]],
Cell[570463, 12368, 125, 3, 70, "ExampleDelimiter",
 CellID->323133125],
Cell[570591, 12373, 78, 1, 70, "ExampleText",
 CellID->86616320],
Cell[CellGroupData[{
Cell[570694, 12378, 663, 20, 70, "Input",
 CellID->4816532],
Cell[571360, 12400, 5158, 89, 70, "Output",
 Evaluatable->False,
 CellID->398057898]
}, Open  ]],
Cell[576533, 12492, 125, 3, 70, "ExampleDelimiter",
 CellID->620544652],
Cell[576661, 12497, 171, 6, 70, "ExampleText",
 CellID->40928939],
Cell[CellGroupData[{
Cell[576857, 12507, 586, 19, 70, "Input",
 CellID->186046],
Cell[577446, 12528, 4193, 73, 70, "Output",
 Evaluatable->False,
 CellID->60906108]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[581688, 12607, 230, 7, 70, "ExampleSubsection",
 CellID->117054906],
Cell[581921, 12616, 85, 1, 70, "ExampleText",
 CellID->208584661],
Cell[CellGroupData[{
Cell[582031, 12621, 652, 21, 70, "Input",
 CellID->916035],
Cell[582686, 12644, 8433, 150, 166, 2766, 53, "CachedBoxData", "BoxData", \
"Output",
 CellID->72015399]
}, Open  ]],
Cell[591134, 12797, 65, 1, 70, "ExampleText",
 CellID->100602902],
Cell[CellGroupData[{
Cell[591224, 12802, 767, 24, 70, "Input",
 CellID->5412690],
Cell[591994, 12828, 9102, 153, 70, "Output",
 Evaluatable->False,
 CellID->352863647]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[601145, 12987, 235, 7, 70, "ExampleSubsection",
 CellID->911403307],
Cell[601383, 12996, 145, 6, 70, "ExampleText",
 CellID->253],
Cell[CellGroupData[{
Cell[601553, 13006, 765, 22, 70, "Input",
 CellID->20311],
Cell[602321, 13030, 4225, 73, 70, "Output",
 Evaluatable->False,
 CellID->55922195]
}, Open  ]],
Cell[606561, 13106, 125, 3, 70, "ExampleDelimiter",
 CellID->150195850],
Cell[606689, 13111, 208, 8, 70, "ExampleText",
 CellID->1048365725],
Cell[606900, 13121, 425, 14, 70, "Input",
 CellID->1926900087],
Cell[CellGroupData[{
Cell[607350, 13139, 433, 14, 70, "Input",
 CellID->955241146],
Cell[607786, 13155, 3243, 63, 158, 551, 14, "CachedBoxData", "BoxData", \
"Output",
 CellID->466364349]
}, Open  ]],
Cell[CellGroupData[{
Cell[611066, 13223, 641, 20, 70, "Input",
 CellID->469134706],
Cell[611710, 13245, 4811, 83, 70, "Output",
 Evaluatable->False,
 CellID->88937665]
}, Open  ]],
Cell[616536, 13331, 125, 3, 70, "ExampleDelimiter",
 CellID->502968287],
Cell[616664, 13336, 80, 1, 70, "ExampleText",
 CellID->1939527681],
Cell[CellGroupData[{
Cell[616769, 13341, 1114, 34, 70, "Input",
 CellID->2137760513],
Cell[617886, 13377, 4783, 82, 70, "Output",
 Evaluatable->False,
 CellID->465818142]
}, Open  ]],
Cell[622684, 13462, 123, 3, 70, "ExampleDelimiter",
 CellID->7769996],
Cell[622810, 13467, 86, 1, 70, "ExampleText",
 CellID->448487895],
Cell[CellGroupData[{
Cell[622921, 13472, 1172, 37, 70, "Input",
 CellID->172650878],
Cell[624096, 13511, 4193, 73, 70, "Output",
 Evaluatable->False,
 CellID->95385374]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[628350, 13591, 228, 7, 70, "ExampleSection",
 CellID->589267740],
Cell[628581, 13600, 59, 1, 70, "ExampleText",
 CellID->324257115],
Cell[CellGroupData[{
Cell[628665, 13605, 791, 24, 70, "Input",
 CellID->49555088],
Cell[629459, 13631, 5382, 92, 70, "Output",
 Evaluatable->False,
 CellID->799708791]
}, Open  ]],
Cell[634856, 13726, 124, 3, 70, "ExampleDelimiter",
 CellID->70911473],
Cell[634983, 13731, 64, 1, 70, "ExampleText",
 CellID->584510871],
Cell[CellGroupData[{
Cell[635072, 13736, 1342, 38, 70, "Input",
 CellID->305587292],
Cell[636417, 13776, 17915, 298, 70, "Output",
 Evaluatable->False,
 CellID->193870921]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[654393, 14081, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[654712, 14092, 1202, 44, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[655951, 14141, 299, 8, 70, "MoreAboutSection"],
Cell[656253, 14151, 146, 3, 70, "MoreAbout",
 CellID->30836047],
Cell[656402, 14156, 166, 3, 70, "MoreAbout",
 CellID->514205114]
}, Open  ]],
Cell[656583, 14162, 27, 0, 70, "History"],
Cell[656613, 14164, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

