(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     82419,       2899]
NotebookOptionsPosition[     69191,       2445]
NotebookOutlinePosition[     70733,       2485]
CellTagsIndexPosition[     70647,       2480]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Advanced Dynamic Functionality" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AdvancedDynamicFunctionality"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Introduction to Dynamic\"\>", 
       2->"\<\"Advanced Dynamic Functionality\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Point" :> Documentation`HelpLookup["paclet:ref/Point"], 
          "LocatorPane" :> Documentation`HelpLookup["paclet:ref/LocatorPane"],
           "Slider2D" :> Documentation`HelpLookup["paclet:ref/Slider2D"], 
          "Slider" :> Documentation`HelpLookup["paclet:ref/Slider"], 
          "VerticalSlider" :> 
          Documentation`HelpLookup["paclet:ref/VerticalSlider"], "Deploy" :> 
          Documentation`HelpLookup["paclet:ref/Deploy"], "Inset" :> 
          Documentation`HelpLookup["paclet:ref/Inset"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Point\"\>", 2->"\<\"LocatorPane\"\>", 
       3->"\<\"Slider2D\"\>", 4->"\<\"Slider\"\>", 
       5->"\<\"VerticalSlider\"\>", 6->"\<\"Deploy\"\>", 
       7->"\<\"Inset\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Click-Interactive Panels" :> 
          Documentation`HelpLookup["paclet:guide/ClickInteractivePanels"], 
          "Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"], 
          "Dynamic Graphics Elements" :> 
          Documentation`HelpLookup["paclet:guide/DynamicGraphicsElements"], 
          "Dynamic Interactivity Language" :> 
          Documentation`HelpLookup[
           "paclet:guide/DynamicInteractivityLanguage"], 
          "Dynamic Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DynamicVisualization"], 
          "Graphics Interactivity & Drawing" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsInteractivityAndDrawing"], 
          "Interactive Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/InteractiveManipulation"], 
          "Options & Styling for Interactive Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:guide/OptionsAndStylingForInteractiveManipulation"], 
          "Symbolic Graphics Language" :> 
          Documentation`HelpLookup[
           "paclet:guide/SymbolicGraphicsLanguage"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Click-Interactive Panels\"\>", 
       2->"\<\"Control Objects\"\>", 3->"\<\"Dynamic Graphics Elements\"\>", 
       4->"\<\"Dynamic Interactivity Language\"\>", 
       5->"\<\"Dynamic Visualization\"\>", 
       6->"\<\"Graphics Interactivity & Drawing\"\>", 
       7->"\<\"Interactive Manipulation\"\>", 
       8->"\<\"Options & Styling for Interactive Manipulation\"\>", 
       9->"\<\"Symbolic Graphics Language\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Locator", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Locator",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Locator"], "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["x", "TI"], ",", 
         StyleBox["y", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a locator object at position ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"]}], "}"}]], "InlineFormula"],
     " in a graphic. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Locator",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Locator"], "[", 
       RowBox[{
        ButtonBox["Dynamic",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Dynamic"], "[", 
        StyleBox["pos", "TI"], "]"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes the position to be the dynamically updated \
current value of ",
     Cell[BoxData[
      StyleBox["pos", "TI"]], "InlineFormula"],
     ", with this value being reset if the locator object is moved. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Locator",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Locator"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"]}], "}"}], ",", 
        StyleBox["obj", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]displays ",
     Cell[BoxData[
      StyleBox["obj", "TI"]], "InlineFormula"],
     " as the locator object. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Locator",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Locator"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"]}], "}"}], ",", 
        ButtonBox["None",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/None"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]displays nothing visible as the locator object. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->22576]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Locator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Locator"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"]}], "}"}], ",", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"]}], "]"}]], "InlineFormula"],
 " uses the default \[OpenCurlyDoubleQuote]crosshairs\[CloseCurlyDoubleQuote] \
appearance for the locator object. "
}], "Notes",
 CellID->13175],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Locator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Locator"], "[", 
   RowBox[{
    ButtonBox["Dynamic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Dynamic"], "[", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"]}], "}"}], "]"}], "]"}]], "InlineFormula"],
 " will reset the values of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " when the locator object is moved; ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Locator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Locator"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 " will not. "
}], "Notes",
 CellID->32059],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Locator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Locator"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["Dynamic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dynamic"], "[", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["x", "TI"], ",", 
       StyleBox["y", "TI"]}], "}"}], "]"}], ",", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"]}], "]"}]], "InlineFormula"],
 " gives no directly visible indication of position, but can be used in \
conjunction with a construct such as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Point",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Point"], "[", 
   RowBox[{
    ButtonBox["Dynamic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Dynamic"], "[", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"]}], "}"}], "]"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->1178],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Locator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Locator"]], "InlineFormula"],
 " objects that appear inside ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Deploy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Deploy"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " can still be manipulated interactively, just like, for example, ",
 Cell[BoxData[
  ButtonBox["Slider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider"]], "InlineFormula"],
 " objects. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->210497496]
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->6701],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["obj", "TI"]], "InlineFormula"],
 " does not define its own absolute size, its size when used as a locator \
object can be specified using the ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 " option of ",
 Cell[BoxData[
  ButtonBox["Locator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Locator"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2387],

Cell[TextData[{
 "The setting for ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 " can be ",
 Cell[BoxData[
  ButtonBox["Tiny",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tiny"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Small",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Small"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Medium",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Medium"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Large",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Large"]], "InlineFormula"],
 ", or an explicit value in printer\[CloseCurlyQuote]s points. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->10486581]
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->21362],

Cell[TextData[{
 "The center of the locator object is taken to be the setting for the ",
 Cell[BoxData[
  ButtonBox["AlignmentPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlignmentPoint"]], "InlineFormula"],
 " option of ",
 Cell[BoxData[
  StyleBox["obj", "TI"]], "InlineFormula"],
 ", or by default, the center of the bounding box for ",
 Cell[BoxData[
  StyleBox["obj", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->30933],

Cell["The following options can be given: ", "Notes",
 CellID->24091],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AutoAction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AutoAction"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to move automatically when the mouse is over the graphic \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Enabled",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Enabled"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether the locator is enabled, or grayed out ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the size of the displayed locator object ", "TableText"]},
   {Cell[" ", "TableRowIcon"], 
    ButtonBox["LocatorRegion",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/LocatorRegion"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "where the locator object should be allowed to go", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->19435],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Locator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Locator"], "[", "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Locator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Locator"], "[", 
   RowBox[{
    ButtonBox["Scaled",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Scaled"], "[", 
    RowBox[{"{", 
     RowBox[{"0.5", ",", "0.5"}], "}"}], "]"}], "]"}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->702456343]
}], "Notes",
 CellID->4032],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Locator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Locator"]], "InlineFormula"],
 " can be used to specify the control for a variable in ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ", to indicate that the value of the variable should be determined by the \
position of a locator. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->69664548]
}], "Notes",
 CellID->523960143]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->473800044],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->69805871],

Cell["Set up a locator that can move in a graphic:", "ExampleText",
 CellID->425337180],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Locator", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14232],

Cell[BoxData[
 GraphicsBox[LocatorBox[{0, 0}],
  PlotRange->2]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->248758001]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->47851493],

Cell[TextData[{
 "Set up locator that defines the value of ",
 Cell[BoxData["p"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->154159108],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p", "=", 
     RowBox[{"{", 
      RowBox[{"0.5", ",", "0.5"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Locator", "[", 
        RowBox[{"Dynamic", "[", "p", "]"}], "]"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}], ",", 
     RowBox[{"Dynamic", "[", "p", "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->207947504],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`p$$ = {0.5, 0.5}}, 
  RowBox[{"{", 
   RowBox[{
    GraphicsBox[LocatorBox[Dynamic[$CellContext`p$$]],
     PlotRange->2], ",", 
    DynamicBox[ToBoxes[$CellContext`p$$, StandardForm],
     ImageSizeCache->{67.1875, {2., 8.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{247, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->396207206]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17157037],

Cell[TextData[{
 "Put a locator in a ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->69664548],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", "p"}], "}"}], "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", "Locator"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->459502248],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`p$$ = {1, 1}, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`p$$], {1, 1}}, Automatic}}, Typeset`size$$ = {
    150., {73., 77.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`p$$ = {1, 1}}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[
        Line[{{0, 0}, $CellContext`p$$}], PlotRange -> 2], 
      "Specifications" :> {{{$CellContext`p$$, {1, 1}}, Automatic, 
         ControlType -> Locator}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{196., {101., 106.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{200, 209},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->861300499]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27739],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Locator Content",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->65322756],

Cell["Use an expression as a locator object:", "ExampleText",
 CellID->132851887],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Locator", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"Style", "[", 
      RowBox[{"\"\<X\>\"", ",", 
       RowBox[{"FontSize", "\[Rule]", "48"}]}], "]"}]}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->34778511],

Cell[BoxData[
 GraphicsBox[
  LocatorBox[{-0.4266666666666665, -0.05333333333333334}, StyleBox[
   "X", FontSize -> 48, StripOnInput -> False]],
  PlotRange->2]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->655339785]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->302569426],

Cell["Use a graphic as a locator object:", "ExampleText",
 CellID->32636178],

Cell[BoxData[
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Circle", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", "i"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "3"}], "}"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "20"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->133045070],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Locator", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", "l"}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->222164666],

Cell[BoxData[
 GraphicsBox[
  LocatorBox[{-0.19999999999999973`, -0.05333333333333334}, 
   GraphicsBox[{
    RGBColor[1, 0, 0], {
     CircleBox[{0, 0}, 1], CircleBox[{0, 0}, 2], CircleBox[{0, 0}, 3]}}, 
    ImageSize -> 20]],
  PlotRange->1]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->792161812]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->577953429],

Cell[TextData[{
 "Invisible locator: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->1178]
}], "ExampleText",
 CellID->841261608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Deploy", "[", 
  RowBox[{"DynamicModule", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "0.1", "]"}], ",", 
        RowBox[{"Dynamic", "@", 
         RowBox[{"Point", "[", "p", "]"}]}], ",", 
        RowBox[{"Locator", "[", 
         RowBox[{
          RowBox[{"Dynamic", "[", "p", "]"}], ",", "None"}], "]"}]}], "}"}], 
      ",", 
      RowBox[{"PlotRange", "\[Rule]", "1.5"}]}], "]"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->356661315],

Cell[BoxData[
 StyleBox[
  DynamicModuleBox[{$CellContext`p$$ = {0.2799999999999997, 
   0.3899999999999997}}, 
   GraphicsBox[
    {PointSize[0.1], 
     DynamicBox[Typeset`ToBoxes[
       Point[$CellContext`p$$], StandardForm, Graphics],
      ImageSizeCache->{{54.3125, 64.3125}, {-20., -10.}}], 
     LocatorBox[Dynamic[$CellContext`p$$], None]},
    PlotRange->1.5],
   DynamicModuleValues:>{}],
  Deployed->True,
  StripOnInput->False]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->35654912]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14294248],

Cell["Zero argument form for a locator:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->702456343],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Locator", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1466149242],

Cell[BoxData[
 GraphicsBox[
  LocatorBox[Scaled[{0.5202020202020201, 0.4595312095312095}]]]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->3919484]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Locator Control",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->994935386],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Deploy",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Deploy"]], "InlineFormula"],
 " to disable interactive graphics editing, but preserve locator \
interactivity: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->6701]
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->435925800],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Deploy", "[", 
  RowBox[{"DynamicModule", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p", "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"Locator", "[", 
       RowBox[{"Dynamic", "[", "p", "]"}], "]"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}]}], "]"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->914247653],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`p$$ = {-0.10666666666666647`, 
  0.13333333333333333`}}, 
  GraphicsBox[LocatorBox[Dynamic[$CellContext`p$$]],
   PlotRange->2],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->778313841]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5768739],

Cell[TextData[{
 "The movement of locators can be constrained by ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->104451988],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Deploy", "[", 
  RowBox[{"DynamicModule", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"Disk", "[", "]"}], ",", 
        RowBox[{"Locator", "[", 
         RowBox[{"Dynamic", "[", 
          RowBox[{"p", ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "=", 
              RowBox[{"Normalize", "[", "#", "]"}]}], ")"}], "&"}]}], "]"}], 
         "]"}]}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "1.5"}]}], "]"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->770712475],

Cell[BoxData[
 StyleBox[
  DynamicModuleBox[{$CellContext`p$$ = {0.46574643283262224`, 
   0.8849182223819824}}, 
   GraphicsBox[
    {RGBColor[1, 0, 0], DiskBox[{0, 0}], 
     LocatorBox[
      Dynamic[$CellContext`p$$, ($CellContext`p$$ = Normalize[#])& ]]},
    PlotRange->1.5],
   DynamicModuleValues:>{}],
  Deployed->True,
  StripOnInput->False]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->605268065]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3091696],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " coordinates for the locator:"
}], "ExampleText",
 CellID->564283915],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p", "=", 
     RowBox[{"Scaled", "[", 
      RowBox[{"{", 
       RowBox[{"0.5", ",", "0.5"}], "}"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Framed", "@", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"Locator", "[", 
         RowBox[{"Dynamic", "[", "p", "]"}], "]"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}]}], ",", 
     RowBox[{"Dynamic", "[", "p", "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->137152109],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`p$$ = Scaled[{0.51, 0.6699999999999999}]}, 
  RowBox[{"{", 
   RowBox[{
    FrameBox[
     GraphicsBox[LocatorBox[Dynamic[$CellContext`p$$]],
      PlotRange->2],
     StripOnInput->False], ",", 
    DynamicBox[ToBoxes[$CellContext`p$$, StandardForm],
     ImageSizeCache->{137.1875, {2., 8.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{277, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1903592418]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->329330559],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Appearance",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->209301173],

Cell["Specify the type of appearance:", "ExampleText",
 CellID->104953259],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"Locator", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"Appearance", "\[Rule]", "p"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24124471],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[LocatorBox[{0, 0},
     Appearance->Tiny]], ",", 
   GraphicsBox[LocatorBox[{0, 0},
     Appearance->Small]], ",", 
   GraphicsBox[LocatorBox[{0, 0},
     Appearance->Medium]], ",", 
   GraphicsBox[LocatorBox[{0, 0},
     Appearance->Large]]}], "}"}]], "Output",
 ImageSize->{452, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->279278841]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AutoAction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->205926217],

Cell["\<\
By default no locator values change until you drag the locator:\
\>", "ExampleText",
 CellID->214704586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p", "=", 
     RowBox[{"{", 
      RowBox[{"0.5", ",", "0.5"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Locator", "[", 
        RowBox[{"Dynamic", "[", "p", "]"}], "]"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}], ",", 
     RowBox[{"Dynamic", "[", "p", "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->119939086],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`p$$ = {0.21999999999999997`, 0.06}}, 
  RowBox[{"{", 
   RowBox[{
    GraphicsBox[LocatorBox[Dynamic[$CellContext`p$$]],
     PlotRange->2], ",", 
    DynamicBox[ToBoxes[$CellContext`p$$, StandardForm],
     ImageSizeCache->{81.1875, {2., 8.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{211, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->602591888]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->58451324],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["AutoAction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AutoAction"]], "InlineFormula"],
 " is set, the locator values change as the mouse moves over the locator:"
}], "ExampleText",
 CellID->306328665],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p", "=", 
     RowBox[{"{", 
      RowBox[{"0.5", ",", "0.5"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Locator", "[", 
        RowBox[{
         RowBox[{"Dynamic", "[", "p", "]"}], ",", 
         RowBox[{"AutoAction", "\[Rule]", "True"}]}], "]"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}], ",", 
     RowBox[{"Dynamic", "[", "p", "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1209706069],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`p$$ = {-0.8599999999999997, 
  1.3000000000000005`}}, 
  RowBox[{"{", 
   RowBox[{
    GraphicsBox[LocatorBox[Dynamic[$CellContext`p$$],
      AutoAction->True],
     PlotRange->2], ",", 
    DynamicBox[ToBoxes[$CellContext`p$$, StandardForm],
     ImageSizeCache->{81.875, {2., 8.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{212, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->106020424]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->506925381],

Cell["Change the background colors:", "ExampleText",
 CellID->187974734],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"Locator", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"Background", "\[Rule]", "c"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Pink", ",", "Green", ",", "Gray", ",", "Yellow"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1800009785],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[LocatorBox[{0, 0},
     Background->RGBColor[1, 0.5, 0.5]]], ",", 
   GraphicsBox[LocatorBox[{0, 0},
     Background->RGBColor[0, 1, 0]]], ",", 
   GraphicsBox[LocatorBox[{0, 0},
     Background->GrayLevel[0.5]]], ",", 
   GraphicsBox[LocatorBox[{0, 0},
     Background->RGBColor[1, 1, 0]]]}], "}"}]], "Output",
 ImageSize->{452, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->851711681]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->208168861],

Cell["Change the background color dynamically:", "ExampleText",
 CellID->375560463],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pt", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"Framed", "@", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"Locator", "[", 
       RowBox[{
        RowBox[{"Dynamic", "[", "pt", "]"}], ",", 
        RowBox[{"Background", "\[Rule]", 
         RowBox[{"Dynamic", "[", 
          RowBox[{"Hue", "[", 
           RowBox[{"Norm", "[", "pt", "]"}], "]"}], "]"}]}]}], "]"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->179308],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`pt$$ = {0, 0}}, 
  FrameBox[
   GraphicsBox[LocatorBox[Dynamic[$CellContext`pt$$],
     Background->Dynamic[
       Hue[
        Norm[$CellContext`pt$$]]]],
    PlotRange->1],
   StripOnInput->False],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{114, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->569177206]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Enabled",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->538582063],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["Locator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Locator"]], "InlineFormula"],
 " is enabled:"
}], "ExampleText",
 CellID->154813376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Locator", "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->94729581],

Cell[BoxData[
 GraphicsBox[LocatorBox[{0, 0}]]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->63070659]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->121212349],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Enabled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Enabled"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the locator is disabled but visible in its current state:"
}], "ExampleText",
 CellID->576258550],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Locator", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->227336428],

Cell[BoxData[
 GraphicsBox[LocatorBox[{0, 0},
   Enabled->False]]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->7230155]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->191589401],

Cell["Use predefined locator sizes:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->10486581],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"Locator", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "m"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->266959022],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[LocatorBox[{0, 0},
     ImageSize->Tiny]], ",", 
   GraphicsBox[LocatorBox[{0, 0},
     ImageSize->Small]], ",", 
   GraphicsBox[LocatorBox[{0, 0},
     ImageSize->Medium]], ",", 
   GraphicsBox[LocatorBox[{0, 0},
     ImageSize->Large]]}], "}"}]], "Output",
 ImageSize->{452, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->235061878]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->305823012],

Cell["Or use any values:", "ExampleText",
 CellID->27069804],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"Locator", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "m"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "30", ",", "50", ",", "80"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->289053222],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[LocatorBox[{0, 0},
     ImageSize->10]], ",", 
   GraphicsBox[LocatorBox[{0, 0},
     ImageSize->30]], ",", 
   GraphicsBox[LocatorBox[{0, 0},
     ImageSize->50]], ",", 
   GraphicsBox[LocatorBox[{0, 0},
     ImageSize->80]]}], "}"}]], "Output",
 ImageSize->{452, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->72559144]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "LocatorRegion",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->142851549],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["Locator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Locator"]], "InlineFormula"],
 " is constrained within the ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->827571894],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "@", 
  RowBox[{"Graphics", "[", 
   RowBox[{
    RowBox[{"Locator", "[", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "1"}], ",", 
    RowBox[{"ImagePadding", "\[Rule]", "20"}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2080315506],

Cell[BoxData[
 FrameBox[
  GraphicsBox[LocatorBox[{-0.28571428571428603`, 0.0857142857142863}],
   Frame->True,
   ImagePadding->20,
   PlotRange->1],
  StripOnInput->False]], "Output",
 ImageSize->{194, 192},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1559795843]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1001180134],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LocatorRegion",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LocatorRegion"], " ", "->", 
   ButtonBox["Full",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Full"]}]], "InlineFormula"],
 " to access all of the graphics:"
}], "ExampleText",
 CellID->1300137893],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "@", 
  RowBox[{"Graphics", "[", 
   RowBox[{
    RowBox[{"Locator", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"LocatorRegion", "\[Rule]", "Full"}]}], "]"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "1"}], ",", 
    RowBox[{"ImagePadding", "\[Rule]", "20"}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1155854372],

Cell[BoxData[
 FrameBox[
  GraphicsBox[LocatorBox[{0.09999999999999964, 1.1428571428571432`},
    LocatorRegion->Full],
   Frame->True,
   ImagePadding->20,
   PlotRange->1],
  StripOnInput->False]], "Output",
 ImageSize->{194, 192},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->307359442]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->106833112],

Cell["\<\
Dynamic tracking functions can be used to constrain locator movement:\
\>", "ExampleText",
 CellID->1308480325],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pt", "=", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Circle", "[", "]"}], ",", 
       RowBox[{"Locator", "[", 
        RowBox[{"Dynamic", "[", 
         RowBox[{"pt", ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"pt", "=", 
             RowBox[{"Normalize", "[", "#", "]"}]}], ")"}], "&"}]}], "]"}], 
        "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1396276995],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`pt$$ = {-0.5766354331625299, 
  0.8170015772453939}}, 
  GraphicsBox[{CircleBox[{0, 0}], 
    LocatorBox[
     Dynamic[$CellContext`pt$$, ($CellContext`pt$$ = Normalize[#])& ]]},
   PlotRange->2],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->738217102]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->156730191],

Cell["A simple, interactive length and slope display:", "ExampleText",
 CellID->311053418],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"p1", "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"p2", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Dynamic", "@", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Arrow", "[", 
           RowBox[{"{", 
            RowBox[{"p1", ",", "p2"}], "}"}], "]"}], ",", 
          RowBox[{"Locator", "[", 
           RowBox[{"Dynamic", "[", "p1", "]"}], "]"}], ",", 
          RowBox[{"Locator", "[", 
           RowBox[{"Dynamic", "[", "p2", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}]}], ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{"Grid", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Length:\>\"", ",", 
           RowBox[{"EuclideanDistance", "[", 
            RowBox[{"p1", ",", "p2"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<Slope:\>\"", ",", 
           RowBox[{"1", "/", 
            RowBox[{"Divide", "@@", 
             RowBox[{"(", 
              RowBox[{"p2", "-", "p1"}], ")"}]}]}]}], "}"}]}], "}"}], "]"}], 
      "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->40339901],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`p1$$ = {0, 0}, $CellContext`p2$$ = {
  0.6222222222222338, 0.9111111111111114}}, 
  RowBox[{"{", 
   RowBox[{
    DynamicBox[ToBoxes[
      Graphics[{
        Arrow[{$CellContext`p1$$, $CellContext`p2$$}], 
        Locator[
         Dynamic[$CellContext`p1$$]], 
        Locator[
         Dynamic[$CellContext`p2$$]]}, PlotRange -> 2], StandardForm],
     ImageSizeCache->{180., {88., 92.}}], ",", 
    DynamicBox[ToBoxes[
      Grid[{{"Length:", 
         EuclideanDistance[$CellContext`p1$$, $CellContext`p2$$]}, {
        "Slope:", 1/Apply[Divide, $CellContext`p2$$ - $CellContext`p1$$]}}], 
      StandardForm],
     ImageSizeCache->{106., {10., 15.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{316, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->661893291]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31232],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Deploy",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Deploy"]], "InlineFormula"],
 " to restrict graphics interactivity while keeping the locators active:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->210497496],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Deploy", "[", 
  RowBox[{"Graphics", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Cyan", ",", 
      RowBox[{"Disk", "[", "]"}], ",", " ", 
      RowBox[{"Locator", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "1"}], "}"}], "]"}]}], "}"}], ",", " ", 
    RowBox[{"PlotRange", " ", "->", " ", "1.1"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->490714701],

Cell[BoxData[
 StyleBox[
  GraphicsBox[
   {RGBColor[0, 1, 1], DiskBox[{0, 0}], 
    LocatorBox[{0.1639999999999998, 0.2519999999999998}]},
   PlotRange->1.1],
  Deployed->True,
  StripOnInput->False]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->4156420]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->838133123],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["LocatorPane",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LocatorPane"]], "InlineFormula"],
 " to use locators on complex objects: "
}], "ExampleText",
 CellID->91824667],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pts", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"LocatorPane", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "pts", "]"}], ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"InterpolatingPolynomial", "[", 
         RowBox[{"pts", ",", "x"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "3"}]}], "]"}], "]"}]}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->692586568],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`pts$$ = {{0, 0}, {0.78, 2.2}, {2, 0}, {3, 
   2}}}, 
  LocatorPaneBox[Dynamic[$CellContext`pts$$], 
   DynamicBox[ToBoxes[
     Plot[
      InterpolatingPolynomial[$CellContext`pts$$, $CellContext`x], \
{$CellContext`x, 0, 3}, PlotRange -> 3], StandardForm],
    ImageSizeCache->{180., {55., 59.}}]],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{184, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->193436804]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16526],

Cell[TextData[{
 "Without a fixed ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 ", the plot range will adapt as the locator moves:"
}], "ExampleText",
 CellID->20464],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Locator", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Locator", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27097],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[LocatorBox[{0, 0}],
    Frame->True], ",", 
   GraphicsBox[LocatorBox[{0, 0}],
    Frame->True,
    PlotRange->1]}], "}"}]], "Output",
 ImageSize->{330, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->52109775]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->325119279],

Cell["\<\
The position of a locator in graphics determines whether it is visible:\
\>", "ExampleText",
 CellID->635348701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Red", ",", 
     RowBox[{"Disk", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "0"}], "}"}], "]"}], ",", 
     RowBox[{"Locator", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
     RowBox[{"Disk", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1016924823],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0, 0], DiskBox[{-1, 0}], LocatorBox[{0, 0}], DiskBox[{1, 0}]},
  PlotRange->2]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->20648586]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6848],

Cell["Make the points follow the locator:", "ExampleText",
 CellID->451346782],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p", "=", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Locator", "[", 
        RowBox[{"Dynamic", "[", "p", "]"}], "]"}], ",", 
       RowBox[{"Dynamic", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Point", "[", 
           RowBox[{"s", " ", "p"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"s", ",", "2", ",", "4"}], "}"}]}], "]"}], "]"}]}], "}"}], 
     ",", 
     RowBox[{"PlotRange", "\[Rule]", "5"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->299845397],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`p$$ = {-0.444444444444446, \
-0.27777777777777785`}}, 
  GraphicsBox[{LocatorBox[Dynamic[$CellContext`p$$]], 
    DynamicBox[Typeset`ToBoxes[
      Table[
       Point[$CellContext`s $CellContext`p$$], {$CellContext`s, 2, 4}], 
      StandardForm, Graphics],
     ImageSizeCache->{{56., 76.}, {6., 20.}}]},
   ImageMargins->0.,
   ImageSize->Small,
   PlotRange->5],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1429467302]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->139653235],

Cell["\<\
Transform the circle using a matrix defined by the coordinates of two \
locators:\
\>", "ExampleText",
 CellID->1443139356],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"v1", "=", 
      RowBox[{"{", 
       RowBox[{"2", ",", "0"}], "}"}]}], ",", 
     RowBox[{"v2", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], "}"}], ",", 
   RowBox[{"Dynamic", "@", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Circle", "[", "]"}], ",", "Red", ",", 
        RowBox[{"GeometricTransformation", "[", 
         RowBox[{
          RowBox[{"Circle", "[", "]"}], ",", 
          RowBox[{"Transpose", "[", 
           RowBox[{"{", 
            RowBox[{"v1", ",", "v2"}], "}"}], "]"}]}], "]"}], ",", "Green", 
        ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", "v1"}], "}"}], "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", "v2"}], "}"}], "]"}], ",", 
        RowBox[{"Locator", "[", 
         RowBox[{"Dynamic", "[", "v1", "]"}], "]"}], ",", 
        RowBox[{"Locator", "[", 
         RowBox[{"Dynamic", "[", "v2", "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "3"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->860094079],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`v1$$ = {2.5333333333333288`, 
  9.298117831235686*^-16}, $CellContext`v2$$ = {-1, 1}}, 
  DynamicBox[ToBoxes[
    Graphics[{
      Circle[], Red, 
      GeometricTransformation[
       Circle[], 
       Transpose[{$CellContext`v1$$, $CellContext`v2$$}]], Green, 
      Line[{{0, 0}, $CellContext`v1$$}], 
      Line[{{0, 0}, $CellContext`v2$$}], 
      Locator[
       Dynamic[$CellContext`v1$$]], 
      Locator[
       Dynamic[$CellContext`v2$$]]}, PlotRange -> 3], StandardForm],
   ImageSizeCache->{180., {88., 92.}}],
  DynamicModuleValues:>{}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->375800570]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->784075461],

Cell["\<\
Compute a Julia set for a mapping defined by a locator position: \
\>", "ExampleText",
 CellID->377347262],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"pt", "=", 
      RowBox[{"{", 
       RowBox[{"0.25", ",", "0.25"}], "}"}]}], ",", "julia"}], "}"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"julia", "[", "z_", "]"}], ":=", 
     RowBox[{"Abs", "@", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"NestWhile", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"#", "^", "2"}], "+", "z"}], "&"}], ",", 
          RowBox[{"i", "+", 
           RowBox[{"\[ImaginaryI]", " ", "j"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"Abs", "[", "#", "]"}], "<", "4"}], "&"}], ",", "1", ",", 
          "20"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"-", "1"}], ",", "1", ",", ".05"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", 
          RowBox[{"-", "1"}], ",", "1", ",", ".05"}], "}"}]}], "]"}]}]}], ";",
     
    RowBox[{"Framed", "@", 
     RowBox[{"Dynamic", "@", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Raster", "[", 
           RowBox[{
            RowBox[{"julia", "[", 
             RowBox[{"Complex", "@@", "pt"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"pt", "-", 
               RowBox[{"{", 
                RowBox[{".5", ",", ".5"}], "}"}]}], ",", 
              RowBox[{"pt", "+", 
               RowBox[{"{", 
                RowBox[{".5", ",", ".5"}], "}"}]}]}], "}"}]}], "]"}], ",", 
          RowBox[{"Locator", "[", 
           RowBox[{"Dynamic", "[", "pt", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}]}]}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4410126],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`pt$$ = {0.22777777777777874`, 
  0.1611111111111107}, $CellContext`julia$$}, 
  FrameBox[
   DynamicBox[ToBoxes[
     Graphics[{
       Raster[
        $CellContext`julia$$[
         Apply[Complex, $CellContext`pt$$]], {$CellContext`pt$$ - {0.5, 
         0.5}, $CellContext`pt$$ + {0.5, 0.5}}], 
       Locator[
        Dynamic[$CellContext`pt$$]]}, PlotRange -> 1], StandardForm],
    ImageSizeCache->{180., {88., 92.}}],
   StripOnInput->False],
  DynamicModuleValues:>{{DownValues[$CellContext`julia$$] = {HoldPattern[
         $CellContext`julia$$[
          Pattern[$CellContext`z, 
           Blank[]]]] :> Abs[
         Table[
          
          NestWhile[#^2 + $CellContext`z& , $CellContext`i + I $CellContext`j,
            Abs[#] < 4& , 1, 20], {$CellContext`i, -1, 1, 
           0.05}, {$CellContext`j, -1, 1, 0.05}]]}}}]], "Output",
 ImageSize->{194, 192},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10217831]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15800],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Point",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Point"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LocatorPane",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LocatorPane"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Slider2D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider2D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Slider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VerticalSlider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VerticalSlider"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Deploy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Deploy"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inset"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->32094]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10724],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Advanced Dynamic Functionality",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality"]], "Tutorials",
 CellID->558945376]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Locator",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Locator"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->253185534],

Cell[TextData[ButtonBox["Click-Interactive Panels",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ClickInteractivePanels"]], "MoreAbout",
 CellID->95725162],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->61932788],

Cell[TextData[ButtonBox["Dynamic Graphics Elements",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicGraphicsElements"]], "MoreAbout",
 CellID->303462778],

Cell[TextData[ButtonBox["Dynamic Interactivity Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicInteractivityLanguage"]], "MoreAbout",
 CellID->91355889],

Cell[TextData[ButtonBox["Dynamic Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicVisualization"]], "MoreAbout",
 CellID->383953376],

Cell[TextData[ButtonBox["Graphics Interactivity & Drawing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsInteractivityAndDrawing"]], "MoreAbout",
 CellID->24217378],

Cell[TextData[ButtonBox["Interactive Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InteractiveManipulation"]], "MoreAbout",
 CellID->36527216],

Cell[TextData[ButtonBox["Options & Styling for Interactive Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/OptionsAndStylingForInteractiveManipulation"]], "MoreAbout",
 CellID->250063411],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "MoreAbout",
 CellID->657530246]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Locator - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 58, 31.2891586}", "context" -> "System`", 
    "keywords" -> {"grip", "handle", "knob", "movable thumb", "thumb"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Locator[{x, y}] represents a locator object at position {x, y} in a \
graphic. Locator[Dynamic[pos]] takes the position to be the dynamically \
updated current value of pos, with this value being reset if the locator \
object is moved. Locator[{x, y}, obj] displays obj as the locator object. \
Locator[{x, y}, None] displays nothing visible as the locator object. ", 
    "synonyms" -> {}, "title" -> "Locator", "type" -> "Symbol", "uri" -> 
    "ref/Locator"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[16857, 525, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->473800044]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 70503, 2473}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3975, 84, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4598, 111, 1572, 37, 70, "ObjectNameGrid"],
Cell[6173, 150, 2352, 74, 70, "Usage",
 CellID->22576]
}, Open  ]],
Cell[CellGroupData[{
Cell[8562, 229, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9040, 246, 519, 17, 70, "Notes",
 CellID->13175],
Cell[9562, 265, 854, 32, 70, "Notes",
 CellID->32059],
Cell[10419, 299, 1036, 36, 70, "Notes",
 CellID->1178],
Cell[11458, 337, 696, 23, 70, "Notes",
 CellID->6701],
Cell[12157, 362, 483, 17, 70, "Notes",
 CellID->2387],
Cell[12643, 381, 871, 32, 70, "Notes",
 CellID->21362],
Cell[13517, 415, 445, 14, 70, "Notes",
 CellID->30933],
Cell[13965, 431, 69, 1, 70, "Notes",
 CellID->24091],
Cell[14037, 434, 1625, 43, 70, "3ColumnTableMod",
 CellID->19435],
Cell[15665, 479, 617, 23, 70, "Notes",
 CellID->4032],
Cell[16285, 504, 535, 16, 70, "Notes",
 CellID->523960143]
}, Closed]],
Cell[CellGroupData[{
Cell[16857, 525, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->473800044],
Cell[CellGroupData[{
Cell[17242, 539, 147, 5, 70, "ExampleSection",
 CellID->69805871],
Cell[17392, 546, 87, 1, 70, "ExampleText",
 CellID->425337180],
Cell[CellGroupData[{
Cell[17504, 551, 247, 8, 28, "Input",
 CellID->14232],
Cell[17754, 561, 258, 8, 171, "Output",
 CellID->248758001]
}, Open  ]],
Cell[18027, 572, 124, 3, 70, "ExampleDelimiter",
 CellID->47851493],
Cell[18154, 577, 143, 5, 70, "ExampleText",
 CellID->154159108],
Cell[CellGroupData[{
Cell[18322, 586, 510, 16, 70, "Input",
 CellID->207947504],
Cell[18835, 604, 505, 14, 70, "Output",
 CellID->396207206]
}, Open  ]],
Cell[19355, 621, 124, 3, 70, "ExampleDelimiter",
 CellID->17157037],
Cell[19482, 626, 253, 9, 70, "ExampleText",
 CellID->69664548],
Cell[CellGroupData[{
Cell[19760, 639, 546, 19, 70, "Input",
 CellID->459502248],
Cell[20309, 660, 1648, 36, 70, "Output",
 CellID->861300499]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22006, 702, 216, 7, 70, "ExampleSection",
 CellID->27739],
Cell[CellGroupData[{
Cell[22247, 713, 235, 7, 70, "ExampleSubsection",
 CellID->65322756],
Cell[22485, 722, 81, 1, 70, "ExampleText",
 CellID->132851887],
Cell[CellGroupData[{
Cell[22591, 727, 389, 12, 70, "Input",
 CellID->34778511],
Cell[22983, 741, 356, 10, 171, "Output",
 CellID->655339785]
}, Open  ]],
Cell[23354, 754, 125, 3, 70, "ExampleDelimiter",
 CellID->302569426],
Cell[23482, 759, 76, 1, 70, "ExampleText",
 CellID->32636178],
Cell[23561, 762, 530, 17, 70, "Input",
 CellID->133045070],
Cell[CellGroupData[{
Cell[24116, 783, 278, 9, 70, "Input",
 CellID->222164666],
Cell[24397, 794, 439, 13, 171, "Output",
 CellID->792161812]
}, Open  ]],
Cell[24851, 810, 125, 3, 70, "ExampleDelimiter",
 CellID->577953429],
Cell[24979, 815, 159, 6, 70, "ExampleText",
 CellID->841261608],
Cell[CellGroupData[{
Cell[25163, 825, 686, 22, 70, "Input",
 CellID->356661315],
Cell[25852, 849, 636, 19, 70, "Output",
 CellID->35654912]
}, Open  ]],
Cell[26503, 871, 124, 3, 70, "ExampleDelimiter",
 CellID->14294248],
Cell[26630, 876, 124, 2, 70, "ExampleText",
 CellID->702456343],
Cell[CellGroupData[{
Cell[26779, 882, 134, 4, 70, "Input",
 CellID->1466149242],
Cell[26916, 888, 285, 8, 121, "Output",
 CellID->3919484]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27250, 902, 236, 7, 70, "ExampleSubsection",
 CellID->994935386],
Cell[27489, 911, 392, 13, 70, "ExampleText",
 CellID->435925800],
Cell[CellGroupData[{
Cell[27906, 928, 455, 15, 70, "Input",
 CellID->914247653],
Cell[28364, 945, 397, 11, 70, "Output",
 CellID->778313841]
}, Open  ]],
Cell[28776, 959, 123, 3, 70, "ExampleDelimiter",
 CellID->5768739],
Cell[28902, 964, 228, 8, 70, "ExampleText",
 CellID->104451988],
Cell[CellGroupData[{
Cell[29155, 976, 744, 24, 70, "Input",
 CellID->770712475],
Cell[29902, 1002, 495, 16, 70, "Output",
 CellID->605268065]
}, Open  ]],
Cell[30412, 1021, 123, 3, 70, "ExampleDelimiter",
 CellID->3091696],
Cell[30538, 1026, 211, 8, 70, "ExampleText",
 CellID->564283915],
Cell[CellGroupData[{
Cell[30774, 1038, 584, 18, 70, "Input",
 CellID->137152109],
Cell[31361, 1058, 574, 16, 70, "Output",
 CellID->1903592418]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[31996, 1081, 222, 7, 70, "ExampleSection",
 CellID->329330559],
Cell[CellGroupData[{
Cell[32243, 1092, 231, 7, 70, "ExampleSubsection",
 CellID->209301173],
Cell[32477, 1101, 74, 1, 70, "ExampleText",
 CellID->104953259],
Cell[CellGroupData[{
Cell[32576, 1106, 461, 15, 70, "Input",
 CellID->24124471],
Cell[33040, 1123, 501, 16, 123, "Output",
 CellID->279278841]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[33590, 1145, 231, 7, 70, "ExampleSubsection",
 CellID->205926217],
Cell[33824, 1154, 114, 3, 70, "ExampleText",
 CellID->214704586],
Cell[CellGroupData[{
Cell[33963, 1161, 510, 16, 70, "Input",
 CellID->119939086],
Cell[34476, 1179, 523, 14, 70, "Output",
 CellID->602591888]
}, Open  ]],
Cell[35014, 1196, 124, 3, 70, "ExampleDelimiter",
 CellID->58451324],
Cell[35141, 1201, 262, 8, 70, "ExampleText",
 CellID->306328665],
Cell[CellGroupData[{
Cell[35428, 1213, 589, 18, 70, "Input",
 CellID->1209706069],
Cell[36020, 1233, 563, 16, 70, "Output",
 CellID->106020424]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[36632, 1255, 231, 7, 70, "ExampleSubsection",
 CellID->506925381],
Cell[36866, 1264, 72, 1, 70, "ExampleText",
 CellID->187974734],
Cell[CellGroupData[{
Cell[36963, 1269, 462, 15, 70, "Input",
 CellID->1800009785],
Cell[37428, 1286, 550, 16, 123, "Output",
 CellID->851711681]
}, Open  ]],
Cell[37993, 1305, 125, 3, 70, "ExampleDelimiter",
 CellID->208168861],
Cell[38121, 1310, 83, 1, 70, "ExampleText",
 CellID->375560463],
Cell[CellGroupData[{
Cell[38229, 1315, 636, 19, 70, "Input",
 CellID->179308],
Cell[38868, 1336, 469, 15, 70, "Output",
 CellID->569177206]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39386, 1357, 228, 7, 70, "ExampleSubsection",
 CellID->538582063],
Cell[39617, 1366, 203, 8, 70, "ExampleText",
 CellID->154813376],
Cell[CellGroupData[{
Cell[39845, 1378, 186, 6, 70, "Input",
 CellID->94729581],
Cell[40034, 1386, 241, 7, 121, "Output",
 CellID->63070659]
}, Open  ]],
Cell[40290, 1396, 125, 3, 70, "ExampleDelimiter",
 CellID->121212349],
Cell[40418, 1401, 355, 12, 70, "ExampleText",
 CellID->576258550],
Cell[CellGroupData[{
Cell[40798, 1417, 254, 8, 70, "Input",
 CellID->227336428],
Cell[41055, 1427, 259, 8, 121, "Output",
 CellID->7230155]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[41363, 1441, 230, 7, 70, "ExampleSubsection",
 CellID->191589401],
Cell[41596, 1450, 119, 2, 70, "ExampleText",
 CellID->10486581],
Cell[CellGroupData[{
Cell[41740, 1456, 461, 15, 70, "Input",
 CellID->266959022],
Cell[42204, 1473, 497, 16, 123, "Output",
 CellID->235061878]
}, Open  ]],
Cell[42716, 1492, 125, 3, 70, "ExampleDelimiter",
 CellID->305823012],
Cell[42844, 1497, 60, 1, 70, "ExampleText",
 CellID->27069804],
Cell[CellGroupData[{
Cell[42929, 1502, 447, 15, 70, "Input",
 CellID->289053222],
Cell[43379, 1519, 484, 16, 123, "Output",
 CellID->72559144]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[43912, 1541, 234, 7, 70, "ExampleSubsection",
 CellID->142851549],
Cell[44149, 1550, 345, 13, 70, "ExampleText",
 CellID->827571894],
Cell[CellGroupData[{
Cell[44519, 1567, 386, 11, 70, "Input",
 CellID->2080315506],
Cell[44908, 1580, 318, 11, 213, "Output",
 CellID->1559795843]
}, Open  ]],
Cell[45241, 1594, 126, 3, 70, "ExampleDelimiter",
 CellID->1001180134],
Cell[45370, 1599, 336, 12, 70, "ExampleText",
 CellID->1300137893],
Cell[CellGroupData[{
Cell[45731, 1615, 462, 13, 70, "Input",
 CellID->1155854372],
Cell[46196, 1630, 341, 12, 213, "Output",
 CellID->307359442]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[46598, 1649, 227, 7, 70, "ExampleSection",
 CellID->106833112],
Cell[46828, 1658, 121, 3, 70, "ExampleText",
 CellID->1308480325],
Cell[CellGroupData[{
Cell[46974, 1665, 681, 22, 70, "Input",
 CellID->1396276995],
Cell[47658, 1689, 465, 13, 70, "Output",
 CellID->738217102]
}, Open  ]],
Cell[48138, 1705, 125, 3, 70, "ExampleDelimiter",
 CellID->156730191],
Cell[48266, 1710, 90, 1, 70, "ExampleText",
 CellID->311053418],
Cell[CellGroupData[{
Cell[48381, 1715, 1398, 42, 70, "Input",
 CellID->40339901],
Cell[49782, 1759, 883, 24, 70, "Output",
 CellID->661893291]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[50714, 1789, 233, 7, 70, "ExampleSection",
 CellID->31232],
Cell[50950, 1798, 300, 9, 70, "ExampleText",
 CellID->210497496],
Cell[CellGroupData[{
Cell[51275, 1811, 411, 12, 70, "Input",
 CellID->490714701],
Cell[51689, 1825, 394, 13, 121, "Output",
 CellID->4156420]
}, Open  ]],
Cell[52098, 1841, 125, 3, 70, "ExampleDelimiter",
 CellID->838133123],
Cell[52226, 1846, 228, 8, 70, "ExampleText",
 CellID->91824667],
Cell[CellGroupData[{
Cell[52479, 1858, 900, 28, 70, "Input",
 CellID->692586568],
Cell[53382, 1888, 517, 14, 70, "Output",
 CellID->193436804]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[53948, 1908, 226, 7, 70, "ExampleSection",
 CellID->16526],
Cell[54177, 1917, 245, 8, 70, "ExampleText",
 CellID->20464],
Cell[CellGroupData[{
Cell[54447, 1929, 545, 17, 70, "Input",
 CellID->27097],
Cell[54995, 1948, 372, 13, 165, "Output",
 CellID->52109775]
}, Open  ]],
Cell[55382, 1964, 125, 3, 70, "ExampleDelimiter",
 CellID->325119279],
Cell[55510, 1969, 122, 3, 70, "ExampleText",
 CellID->635348701],
Cell[CellGroupData[{
Cell[55657, 1976, 531, 17, 70, "Input",
 CellID->1016924823],
Cell[56191, 1995, 316, 9, 121, "Output",
 CellID->20648586]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[56556, 2010, 223, 7, 70, "ExampleSection",
 CellID->6848],
Cell[56782, 2019, 78, 1, 70, "ExampleText",
 CellID->451346782],
Cell[CellGroupData[{
Cell[56885, 2024, 725, 23, 70, "Input",
 CellID->299845397],
Cell[57613, 2049, 584, 17, 70, "Output",
 CellID->1429467302]
}, Open  ]],
Cell[58212, 2069, 125, 3, 70, "ExampleDelimiter",
 CellID->139653235],
Cell[58340, 2074, 133, 4, 70, "ExampleText",
 CellID->1443139356],
Cell[CellGroupData[{
Cell[58498, 2082, 1392, 41, 70, "Input",
 CellID->860094079],
Cell[59893, 2125, 789, 23, 70, "Output",
 CellID->375800570]
}, Open  ]],
Cell[60697, 2151, 125, 3, 70, "ExampleDelimiter",
 CellID->784075461],
Cell[60825, 2156, 116, 3, 70, "ExampleText",
 CellID->377347262],
Cell[CellGroupData[{
Cell[60966, 2163, 1822, 55, 70, "Input",
 CellID->4410126],
Cell[62791, 2220, 1026, 27, 70, "Output",
 CellID->10217831]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[63878, 2254, 311, 9, 70, "SeeAlsoSection",
 CellID->15800],
Cell[64192, 2265, 1674, 62, 70, "SeeAlso",
 CellID->32094]
}, Open  ]],
Cell[CellGroupData[{
Cell[65903, 2332, 314, 9, 70, "TutorialsSection",
 CellID->10724],
Cell[66220, 2343, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[66382, 2348, 173, 3, 70, "Tutorials",
 CellID->558945376]
}, Open  ]],
Cell[CellGroupData[{
Cell[66592, 2356, 305, 8, 70, "RelatedLinksSection"],
Cell[66900, 2366, 359, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[67296, 2383, 319, 9, 70, "MoreAboutSection",
 CellID->253185534],
Cell[67618, 2394, 157, 3, 70, "MoreAbout",
 CellID->95725162],
Cell[67778, 2399, 140, 3, 70, "MoreAbout",
 CellID->61932788],
Cell[67921, 2404, 160, 3, 70, "MoreAbout",
 CellID->303462778],
Cell[68084, 2409, 169, 3, 70, "MoreAbout",
 CellID->91355889],
Cell[68256, 2414, 153, 3, 70, "MoreAbout",
 CellID->383953376],
Cell[68412, 2419, 174, 3, 70, "MoreAbout",
 CellID->24217378],
Cell[68589, 2424, 158, 3, 70, "MoreAbout",
 CellID->36527216],
Cell[68750, 2429, 204, 4, 70, "MoreAbout",
 CellID->250063411],
Cell[68957, 2435, 162, 3, 70, "MoreAbout",
 CellID->657530246]
}, Open  ]],
Cell[69134, 2441, 27, 0, 70, "History"],
Cell[69164, 2443, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

