(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    137554,       4223]
NotebookOptionsPosition[    121235,       3673]
NotebookOutlinePosition[    123206,       3719]
CellTagsIndexPosition[    123119,       3714]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Generalized Input" :> 
          Documentation`HelpLookup["paclet:tutorial/GeneralizedInput"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Introduction to Dynamic\"\>",
        2->"\<\"Generalized Input\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Slider2D" :> Documentation`HelpLookup["paclet:ref/Slider2D"], 
          "ClickPane" :> Documentation`HelpLookup["paclet:ref/ClickPane"], 
          "Locator" :> Documentation`HelpLookup["paclet:ref/Locator"], 
          "Manipulate" :> Documentation`HelpLookup["paclet:ref/Manipulate"], 
          "Slider" :> Documentation`HelpLookup["paclet:ref/Slider"], 
          "ColorSlider" :> Documentation`HelpLookup["paclet:ref/ColorSlider"],
           "EventHandler" :> 
          Documentation`HelpLookup["paclet:ref/EventHandler"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Slider2D\"\>", 
       2->"\<\"ClickPane\"\>", 3->"\<\"Locator\"\>", 4->"\<\"Manipulate\"\>", 
       5->"\<\"Slider\"\>", 6->"\<\"ColorSlider\"\>", 
       7->"\<\"EventHandler\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Click-Interactive Panels" :> 
          Documentation`HelpLookup["paclet:guide/ClickInteractivePanels"], 
          "Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"], 
          "Custom Interface Construction" :> 
          Documentation`HelpLookup[
           "paclet:guide/CustomInterfaceConstruction"], 
          "Dynamic Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DynamicVisualization"], 
          "Graphics Interactivity & Drawing" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsInteractivityAndDrawing"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Click-Interactive Panels\"\>", 
       2->"\<\"Control Objects\"\>", 
       3->"\<\"Custom Interface Construction\"\>", 
       4->"\<\"Dynamic Visualization\"\>", 
       5->"\<\"Graphics Interactivity & Drawing\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["LocatorPane", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LocatorPane",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LocatorPane"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"]}], "}"}], ",", 
        StyleBox["back", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a pane with a locator at position ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], TraditionalForm]], "InlineMath"],
     " and background ",
     Cell[BoxData[
      StyleBox["back", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LocatorPane",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LocatorPane"], "[", 
       RowBox[{
        RowBox[{
         ButtonBox["Dynamic",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/Dynamic"], "[", 
         StyleBox["pt", "TI"], "]"}], ",", 
        StyleBox["back", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes the locator position to be the dynamically \
updated current value of ",
     Cell[BoxData[
      StyleBox["pt", "TI"]], "InlineFormula"],
     ", with the value of ",
     Cell[BoxData[
      StyleBox["pt", "TI"]], "InlineFormula"],
     " being reset if the locator is moved."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LocatorPane",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LocatorPane"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["pt", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["pt", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["back", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]sets up multiple locators at positions ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"p", "\[InvisibleSpace]", 
         SubscriptBox["t", "1"]}], ",", 
        RowBox[{"p", "\[InvisibleSpace]", 
         SubscriptBox["t", "2"]}], ",", "\[Ellipsis]"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LocatorPane",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LocatorPane"], "[", 
       RowBox[{
        RowBox[{
         ButtonBox["Dynamic",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/Dynamic"], "[", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["pt", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["pt", "TI"], 
            StyleBox["2", "TR"]], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], ",", 
        StyleBox["back", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes the locator positions to be dynamically updated \
current values of the ",
     Cell[BoxData[
      FormBox[
       RowBox[{"p", "\[InvisibleSpace]", 
        SubscriptBox["t", "i"]}], TraditionalForm]], "InlineMath"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LocatorPane",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LocatorPane"], "[", 
       RowBox[{
        StyleBox["pts", "TI"], ",", 
        StyleBox["back", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["min", "TI"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["min", "TI"]]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["max", "TI"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["max", "TI"]]}], "}"}]}], "}"}]}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]specifies the range of coordinates for the locator."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LocatorPane",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LocatorPane"], "[", 
       RowBox[{
        StyleBox["pts", "TI"], ",", 
        StyleBox["back", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["min", "TI"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["min", "TI"]]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["max", "TI"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["max", "TI"]]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            StyleBox["dx", "TI"], ",", 
            StyleBox["dy", "TI"]}], "}"}]}], "}"}]}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]uses jumps ",
     Cell[BoxData[
      StyleBox["dx", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["dy", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
The background in a locator pane can be a graphic or any other expression.\
\>", "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->1055956],

Cell[TextData[{
 "For a ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " object ",
 Cell[BoxData[
  FormBox["g", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LocatorPane",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LocatorPane"], "[", 
   RowBox[{
    StyleBox["pt", "TI"], ",", 
    StyleBox["g", "TI"]}], "]"}]], "InlineFormula"],
 " by default takes the range of coordinates for ",
 Cell[BoxData[
  StyleBox["pt", "TI"]], "InlineFormula"],
 " to be the range of graphics coordinates corresponding to ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  FormBox["g", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->29911436],

Cell[TextData[{
 "For a general expression, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LocatorPane",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LocatorPane"], "[", 
   RowBox[{
    StyleBox["pt", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " takes the range of coordinates for ",
 Cell[BoxData[
  StyleBox["pt", "TI"]], "InlineFormula"],
 " to be 0 to 1 in each direction."
}], "Notes",
 CellID->143470244],

Cell["The following options can be given: ", "Notes",
 CellID->7420],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Appearance",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Appearance"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the appearance of locators  ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaselinePosition",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaselinePosition"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to align with a surrounding text baseline ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], 
    RowBox[{"{", "}"}], Cell[
    "base style specifications for the locator pane ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ContinuousAction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ContinuousAction"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to update continuously when locators are moved", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Enabled",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Enabled"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
whether the locator pane is enabled, or its locators are grayed out\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Exclusions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Exclusions"], 
    RowBox[{"{", "}"}], Cell["specific points to exclude", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["LocatorAutoCreate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/LocatorAutoCreate"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to allow clicks to create new locators", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->20383],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Appearance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Appearance"], "->", 
   StyleBox["g", "TI"]}]], "InlineFormula"],
 ", all locators in the locator pane are displayed as ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->78302160]
}], "Notes",
 CellID->148252763],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Appearance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Appearance"], "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["g", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["g", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 ", the ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " locator is displayed as ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", "i"], TraditionalForm]], "InlineMath"],
 "."
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->71945347],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["LocatorPane",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LocatorPane"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["back", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["range", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["range", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " specifies different ranges for different locators."
}], "Notes",
 CellID->769229223],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["LocatorPane",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LocatorPane"], "[", 
   RowBox[{
    StyleBox["pts", "TI"], ",", 
    StyleBox["back", "TI"], ",", 
    StyleBox["range", "TI"]}], "]"}]], "InlineFormula"],
 " by default directs any click to the nearest locator."
}], "Notes",
 CellID->151551424],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " are appended to the default style typically given by the ",
 Cell[BoxData["\"\<LocatorPane\>\""], "InlineFormula"],
 " style in the current stylesheet. "
}], "Notes",
 CellID->307511469]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->25079978],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->76046162],

Cell["\<\
Create a locator pane with a single locator, and a background image of a \
disk:\
\>", "ExampleText",
 CellID->70173164],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LocatorPane", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], "/", "2"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Gray", ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->497815861],

Cell[BoxData[
 LocatorPaneBox[{
   Rational[1, 2], 
   Rational[1, 2]}, 
  GraphicsBox[
   {GrayLevel[0.5], DiskBox[{0, 0}]}]]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->502885084]
}, Open  ]],

Cell["Create multiple locators:", "ExampleText",
 CellID->332575430],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LocatorPane", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], "/", "2"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], "/", "2"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "1"}]}], "}"}], "/", "2"}]}], "}"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Gray", ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1608606553],

Cell[BoxData[
 LocatorPaneBox[{{
    Rational[1, 2], 
    Rational[1, 2]}, {
    Rational[-1, 2], 
    Rational[1, 2]}, {
    Rational[1, 2], 
    Rational[-1, 2]}}, 
  GraphicsBox[
   {GrayLevel[0.5], DiskBox[{0, 0}]}]]], "Output",
 CellFrameLabels->{{None, None}, {None, None}},
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->1812471632]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->745831676],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " to connect locator positions to variables:"
}], "ExampleText",
 CellID->159505980],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pt", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], "/", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"LocatorPane", "[", 
      RowBox[{
       RowBox[{"Dynamic", "[", "pt", "]"}], ",", 
       RowBox[{"Graphics", "[", 
        RowBox[{"{", 
         RowBox[{"Gray", ",", 
          RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]}], "]"}], ",", 
     RowBox[{"Dynamic", "[", "pt", "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1410452276],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`pt$$ = {-0.020000000000000018`, 0.49}}, 
  RowBox[{"{", 
   RowBox[{
    LocatorPaneBox[Dynamic[$CellContext`pt$$], 
     GraphicsBox[
      {GrayLevel[0.5], DiskBox[{0, 0}]}]], ",", 
    DynamicBox[ToBoxes[$CellContext`pt$$, StandardForm],
     ImageSizeCache->{88.875, {2., 8.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{219, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1431372240]
}, Open  ]],

Cell["Do the same for multiple locators:", "ExampleText",
 CellID->1002268619],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pt", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], "/", "2"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], "/", "2"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"-", "1"}]}], "}"}], "/", "2"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"LocatorPane", "[", 
      RowBox[{
       RowBox[{"Dynamic", "[", "pt", "]"}], ",", 
       RowBox[{"Graphics", "[", 
        RowBox[{"{", 
         RowBox[{"Gray", ",", 
          RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]}], "]"}], ",", 
     RowBox[{"Dynamic", "[", "pt", "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->155186329],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`pt$$ = {{0.605, 0.49}, {-0.5, 0.5}, {
  0.5, -0.5}}}, 
  RowBox[{"{", 
   RowBox[{
    LocatorPaneBox[Dynamic[$CellContext`pt$$], 
     GraphicsBox[
      {GrayLevel[0.5], DiskBox[{0, 0}]}]], ",", 
    DynamicBox[ToBoxes[$CellContext`pt$$, StandardForm],
     ImageSizeCache->{274.3125, {2., 8.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{404, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->1171484045]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "LocatorPane Content",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->65322756],

Cell["Use a graphic as the background:", "ExampleText",
 CellID->251377458],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LocatorPane", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5", ",", "0.5"}], "}"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->330837619],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->611847003]
}, Open  ]],

Cell["Including an empty graphic:", "ExampleText",
 CellID->567932866],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LocatorPane", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], "/", "2"}], ",", 
   RowBox[{"Framed", "@", 
    RowBox[{"Graphics", "[", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->473891562],

Cell[BoxData[
 LocatorPaneBox[{0.15500000000000003`, 0.030000000000000027`}, 
  FrameBox[
   GraphicsBox[{}],
   StripOnInput->False]]], "Output",
 ImageSize->{114, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->515337999]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2589442],

Cell["Use any expression as the background: ", "ExampleText",
 CellID->78934132],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LocatorPane", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5", ",", "0.5"}], "}"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"Sphere", "[", "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->139734327],

Cell[BoxData[
 LocatorPaneBox[{0.8200000000000001, 0.5700000000000001}, 
  Graphics3DBox[SphereBox[{0, 0, 0}],
   ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyVewdYXNeZtiLbiXezm2ySbdk/u/FmN5t/kxx1q7jJsi1btnxBHfXmCwJE
FVWAKEIUUUUTvffeGXrvMJShMzD03gYGmHbf5/9nLuDIIyWR9cDVPfd8fOd9
z1dOufdQd0y1NfXvmOp8c+edLx7cMdLW+cbknc8NHygevfGDXbt20YpfvX/d
pbj/f4o79vcTALve0NTUBPtv16+Vl13HFde3FA/fYUsfKq67FaU3tv/fevqe
4qr8w7de0KC4bms4ui379itrD2/X/q2y9Oa3rStu/oOtP7it+++Upbe+rd/W
8e+szP5tHT/9CzJ7t2V+/kqZX7Eyf9xu6x9VemK3SvmXrPTvtzX+y2tJ/25b
9y9Vat9QKf8rK/3bbd2/ei3p/9qW/g+V2jdVyizSXe9sI3lHpfYtlfI/s9L/
sa37v15L+v9s6/6tSu0PVcr/xEr/clv3/30t6X/Zlv69Su2PVMqs9dir8uEf
VWrfVin/gpX++bbuva8l/Q/b0vtVav9Gpcz62q6/30ZyUKX2b1XKP2Olf7yt
+/BrSf/NtvRRldofq5T/gZV+e1v6vb+i+0/SL8brf7MdcpXQdwitTWgDQpsR
2pLQ1oS2JfRuB0Krtqpa/umf9H4n0tlM8PMzhL7MKtchtBGhzQltQ2iFVhdC
uxHai9A+hA4gdCChgwgdQuhQ9l7V+n+nUv7Jn9p8KeqV3rrrX9UIfZ7QV15o
2oLQjwj9mG3ak9C+bLvBhA4ndBSh4wgdT+gkQqcQOo29Ku4TCa0abX8ByV/I
Fmwc/Zoi9FlCaxD6JqE1Ca1PaFO2oxXd4UxoD7YvnrO9EEHoGEInEDqZ0Ol7
6Mw9dA6h8whdQGjOHpqzj+bsVd5n71Hi3ub9U5U2/55FptqTqnyUvr9bAWzX
r8+90F2GO5ZyJPRT1kx+rIHCWVzxW7gInaUAtYcu2EcXHaBLDtLlB+jK/XTV
Abp6P119UHlTsY8u3kO/PjrV/KP02TeU6P5zy49uv2BMhXs+YZ3oGaH9WUsq
ei1WYbc9dOp+OnM/nbuf5uyni/fTZQfpykN09bt03RG64SjdeIxuep9ufo9u
OUa3sEVFg2X76Zcw/t0rMarmsZ/s9OB/q7H2/Ram8Y7PfQszgDVuJOttSaxl
s/fTeQfpwsN06RG68ghdfYyue59u/JBu/ojmHqfbP6Y7TtC8T+iuz+iuT2ne
CSXS9o/oxiO0KtYfvxLrK+PoNwqwW1Av7KC9x5p8C+2Wyb230O7RjNyrFbdX
K3nfvfR993L238s/dK/o8L2yo/eq3teq/VCr4bhm8wma+ynd8TnNO0V3f0n3
fkX3fUUPnKZ3D35Ns9HZr3j4Bd3xCV17lN6y+1/FrRpPf7PjB/97ho3ry2wM
ae3kq0dE8zHRciXaXkTHn+iGEL3IvfqxB/STDhmkv2uQ/a5hwWHD4mOGZR8Y
Vh03qPvEoPEzg5bP9dtO3e/8Srf7a50+de2BM1r8c5rD52nBBXrkIj16UdnT
o4r78/SQOt1/mm498TL2v30ldtXx4kc72P+gzvb4lZ341yOaJkTbiug6ED0X
YuBJDH2JcRB5EEFMY/eaJh4wSztknn3EvOCYRfEHFuXHLao+Ma87ad50yrz1
tHkHZcZTN+k5+6D/vDH/kuGwhsHIFb2xq7oT17Qnr2tN31DCV1ynr9NT1+ix
y/TwBaV5XmLAYn3Jo1UzvDIq31Qy+KPCZy4R+jqh7xJtHaJrRPQsiaEdMXYm
Ju7EzIeYB+6xDNtrFbPPOuGgTephm6xjj/I+sC06blv2iV3VSdu6U7aNp21b
1R51nH3Udd6m95L1wGWroauWI9ctxm6aT9w2mbpjPHPXcJbWn6d1Fe0vKH/o
BZqeu0vP3KLHr9F9Z2jVDPxqDqpSb+5wIOeJ5lWifZvcv0cMDIixGTGxIeaO
xPLpHmvvfTb+B2xDDthFHnSIP+SYcsQx4/0nucedOJ84lZ50rjzlXHvauVHN
qeWsU/sFpy4Np94rTwauPx666TBy2378rt2k5qNpLes5bcsFHfPF+6bLeg8U
7a/o3RfqaQv1tFbu00s69IIWPXWH5mvQLyF8+5U8VC22e8eb9lJEU51oXyL3
bxBDmjzQI2YPiOVDYmVPHjkTe889j333PQk66BT+rkvskadJR93SP3DPPu5e
8KlHyReeFV951qh5NZz1bLng2a7hybvq0XvDY+CW+9BdtxH66biWy5S28+x9
p3m9x4sG9suGtkJj69UHDxUoRCYP1k0MN0z1RCbaImPNVSN6WY+e1XpdNj9R
KbNM9lPkHkV0zxADDWJ8i5jdIw8NySNzYmdDHjsSJzfi8myP2/P97qEHPaOO
eCW89yz1Q5+sE755J32LTvmVfe1Xfca//rx/8yV/7hX/zut+Pbf8+u/6DWn6
jtzzGdd9NqXnPWvguWDssfTAbcXUddXMSWThuGHpoACx8dBKbGUutX4gsTLc
fKi7YXlvw5wWGtPz91/m86NX8mGz8BFFWcFj50ebInoUMTpHzK6Rh9+QR/eJ
gwl58pC42BM35z0ennu9/fb7BL3rG3HML/aDgKTjzzM+Dcr5PIjzVXCJWnDl
2ZDaiyGNV0Jbr4d03ArpuhvSpxnC1w4W6AaN6QdOGj6fMQ6YN/VfMvdbtvRZ
fegtsvbcfOQusXVVYBDbO0jsbWUOVjIHc7m9sdROT2Krs2mtuWZOz+q/zOiH
r2TEzhKPsEQUpHQooq9GHpwhlpeIzU1ir0WcDMlT8z0eNvu8HPf7PD3g530w
IODdwNBjwVEfhsSfCE09GZ51KiL/68gi9cjy81HVGlH1V6Nbbka33Ynm0dG9
96IGdKOG9aNGjSInHkRMm4bPWYQtPgxdsQ5efRS4ZhewYe8nfuwje+KtACRz
fipzdpK5PJa72MpdLBlnE7mTgdRRR2ynKbKixxU2Us1TW4xeNYfYdXSHkS5F
DNSJ6VlidZ7YXyVP7hJXXeJhTLwf7vG12x/gdDDQ491g38NhQUcjwj+IjP04
OulkTPqXsTlUPOdsfMmFhMrLCbXXExtvJXK/SezQSuzWSezXSxwyTBh5kDBu
Fj9tETf3MHbRJmbFNnrVIUr0OGLjSdimc4jEJUj+9LnMzU8BS+7hyXg+ZTyd
GE97xsOa8TCHm6HMRUfyREtoTSvjRjmNfvvPczm2YxoDNWJ+lticJ48vEdcb
xF2TeOsRX1Py3HpP8ON9oa4HI7zejfI/FhPyYVzkifj4k4kpXyZlqiXnnUsp
upRadiW16kZa/Z20Zjq9TTuddz+91yB90Dht2DRtzCJt8mHqjE3KvG3ykkOS
0DFR5JSw7hK3+TRG4h4t84xkvMLl3sFKLj5+jO8z+HnAz5XxdWR8beFjAS8j
uYeuxFlzwYpm866SgOq8861X8mPj6b2dMDKgiIUasT1LnlwkT68Qr9vE9x55
bkiCLUi47d6oJwdi3A7HPXsv4flHSWEnUqI/T034Ki1NLSP7XGaBRlbx1eyK
m9k1d3MaNXNadXI79HK7DXP7H+TwzXJGLHMmrHOmbbPn7LMWHTNXnDLWXNM3
3NI2PFI2vZIkzxLkvvHwi0VAlAIZ8zyECQxEkB+CvBHkhiBnBNojwBJ+RnJv
nU0XWmmtV85jX83ufTbbKaiZU8ROnTifJ+6XybPrJOAbEqxLwh7siXq4L9b+
QILz4SSP91N8j6cFfZIR8XlW7OnsJPWc9PN5uRr5hdcLSm9xqr7h1GkVNukW
thkU8oyLek0LBywKh60Kxx4VTtoXzjpyFpwKll3zV93y1j1zN71zxD5ZEt8M
qX+a/HkKgpIRnKBEFhbFhIcjPAThAQj3QbgHwl0Qao/gh3huJH+mNW9Pv7SS
fDU7Nrd/sBNkSnYUcTlDPC8S3ysk8CYJ09wbqbcvxuRAvPXBpMfvproey/D6
KMv/k5yQL/KiThfEq3NSzhdmXi7Ku15cdLuknC6tvldaf7+sxaCs/UF5l1l5
n2U537pMYFs27lA2/aRszqV00a1kxaN4zbtow6dQ7MeRBBRIA/NkwTny0CyE
ZyAiTQkuKgHRsYiJQmwYYoMQ64cYL0S7ItIB4Q8RpC9+pvn9+CmsZ8KSc6aI
5xnid4EEXSXht0nMvb3xBgeSzA6l2hzOeHI02+2D3Gcn8gM+54SeLopWL0m4
UJp6uSzrenn+7YpiuqpCu6pGr7rRsLrVpLrDvKbbqqb/Uc2Qfc2oY/WEc/XM
0+p596olr0rhs0qRX4U4oFwSVCoNKZGFFcnDC5nIAkTnISZbCS4+DQnJSExA
YgySIpAUgsQAJHgh3hWxDog0R4ju6/FjZxofsbFnSBGbLX4U8T9DQi6RyOsk
9i5J1NmbarQ/w+JQtu2RPKcPOO4fF/mcLAn8qjRcvTzmQmXS5ar069U5t2s5
dF2pTn2lXn2dUUOTSQPXopFn1dhr2zjg0Dj8pHHMpXHSrXHWs2HhWf2yb/1a
QN1GYK0kpEYaVi2NqJRFlctjypi4EsQXIZGjxJeSg9RMpKYhLQlpcUiPQnoo
0gKQ4o1kV8TbIspkw59WnXdvsVTNOz/ZZqnwUkuKPNmiSJHQMyRKg8TdJMk0
Sb+/N/vBgTzLIwV27xc5f1zqcbLc98vKILXqiPM1cZfrkq83ZNxuzNVsKtRp
LtNvqTJurTdtbbZsbbPmdtlx+x5zB524AlfuuDt32os759O65N8qfN4iCm7e
DG2SRjTKohpkMXXyuFp5QjWTVImUcqSWKvFlcJCZj6xsZGUgOwXZCciORlYo
sp4jwxupTki0lkfofD+WCkPaU8SdIn4UCaFIlDpJuERSbpAMem+u3v4CkyNF
Vu+XOHxc7vJZldeXNX5qdcHnGyI1muKvN6fcbs2kuXnabUX67eXGHdWmHQ2W
nS3Wne12nV2Pef3OPP5T3ogHb8K7c9q3cz6gcymwQxjSsR7eLo5sk8Vw5XGt
8oRmJqmJSWlg0uqRUYvMKiW+nFLkFiOvAPm5yM9EQRoKEpEfjbww5D5HlgfS
HRFvouqxb/5FllaKREMRny2KFElQI2kX92Td2JeneYCjf6jE9Fi59UdVjz+t
eXqq3ptq9D/XHKLRGnWNG3+7PZXuyNLuzNfjFRl1lZt211j2NNj0tNr1djj2
djv39bv1DXn2jT7rnfDrnXneuxDcuxzasxrRvR7VJY7tkifw5Ekd8pR2Jq2N
yWhlslqQ04TceiW+gipwKlBYgqJCFOejOBvFaShORFE0CkOR74ccN6TZvB5L
Ni4/ZuPSgXXXQIpEUiSeIqlqJPvS/vybB4u03i01OFJp9kGNzYl6xy8an37d
8uwsN+BSe+jVjuhbvAS6O027J0uvN9+or9i0v8JyoNZmsNF+sNVxsNOF3+PG
H/AaGvbhj/nzJwP5syH8xfDBlcjBtZiBjbh+SWKfPLmXSe1hMrqZLB6T04m8
duRzwWlRQixuQEktSqtQVobyYpQXoDwb5ekoS0RpNIqDwfFBtqMkwUDVb/8y
V1PWooq4DN8iqk6yzpICjX3Ftw6W3ztcZfhenfnxxkcnmx2/4rqdaX92kff8
alfYzZ7ob/oStfvT9AazjfgFpkMllsOVNoI6e0GT4wjXZaTTbaTXa3TQZ3TY
f3QscHQqZGQufGQxamQlViCKF2wmDUtTh5h0PpM5yGT3M7l9TH4PON0o4qGk
QwmxvAUVTaisQ1U1qitQXYLqAlTnoDodlQkoj0BpIDhuTKbV9+OqyLReFAmm
SMwO0fzzpPjy3orbB2u0j9YbfdRk8Wnroy/bn6h1up3v9rnSG3ijP+zuYMw9
fuL94XQjQY7pCMdytMRmrNJuvM5xosllgus2wfOa7PWZHAyYFARNjoVOTkVM
zkVPLMZNCBPGRcnjm6lj0oxRJnuEyRUw+cMMh88UDaKkH2W9KO9WQqzuQA0X
tc2oa0B9LeorUV+C+gLU56AuFTVxqApDqQ+T5/BqrqpvNH6yzdWRzUQK702i
SKY6yT9Hii+Qiiv7au8cbtB+v9noRJvFF522X3c9OdfrrtHvc50feGcoXEsQ
ozuSZDiWbjKeYzHBsZ4stZuqdJyuc5lpdptp85rh+cz2BswOBs0KQmfHI2an
omfn4maXEmeEKTOitOnNzClZzhSTN8kUjDOFY0zJKFMmQMUwKvmoHlBCrOtG
fSca2tDYgqZGNNeiuRLNJWjmoDELDcmoi0blc6bI5ftxfUqRIIrEUSSNIrnq
pPgsqbi4r/bKwcY7x1p0jrcbneRZnu61O9PvdHHQ/eqQz+2RQHo0XGc8Rn8i
6cFUuvl0jvUMx3a29PFclfN8vdtCs9dCm88iL2CxL2iRH7YkiFwaj1mcjl+c
T1pcSl0Upi+sZ82Lc+Zk+XMMZ5YpnmZKp5jySaZyAtVjqB1B3bASYtMAmnvR
0oXWDnC54DaBW4u2SnBL0JqPlgw0JaI2lCn3/H5cvdlITaZIFkUK1Uj5uX01
lw41XjvSeueDDp1PuoxP9VmqDdqdH3K6InC/OerzzUSQ9lS43nSs8WyS2VyG
1UKu7SLn8VKp81KV23K910qzz0pbgJAXJOwLFfIjV0dihOPxwukk4XyqcClD
uJq1sp67LC5YlhUuMSWLTNkCUzHHVM2idgZ1U2iYQNOYEmLrMLiDaOtDezc6
OtHJRWcTOmvRWYGOIrTloDUVjVFMlc/34LqPHWcUkZpOkXyKlFJ7as4dbNA4
0nr9/Y67x7t1TvYZnR60PDtspzHqdH3c/c6kr9ZM0P25cKP5WNPFpIdLGY+W
cx1WOE7C0qerVZ5r9T6iZn9RW5CIFyrqi1znx6wL4tfHk9anU9fnM0RL2SJh
nmi9YE1ctCorXWXKhUzlClO9xNQtomEBTXNonlG++VFAax9FhwA8Prr60d2D
7k50c9HThO4adJWDx0F7BlrjURugOua88ee5EjYDJ1AkmyJF1J5Kam/9mQMt
l450XPug++4n/Tqn+EZqAosLY3ZXJ51uTbvTs746C0EGS+Emy7EWK0k2q+n2
a7lPRBzX9VKPjapnG/X+m82B4rZQMS9C3Bcj5sdLBEni8VTxdIZ4Plu8lCcW
cjbXizbFpRuyinV5lYipWWPqVplGIQtMsfRtn0PnjBJj9zh6RtA7hL4B9PWg
vxP9XPQ1oLcKvaXoykF7MhqDvwfT37ODqsJ986g9ZdTeGmpfs/qB9gtHuq99
1H/35JDO6RGjs+MWGlN2N2ad7s6731v00VsONBaGm6/FWImS7NbTHTdzXMQc
d0mpt6TKT1oXKGsOkbVFyHjR8t54OT9JLkiVj2fIp7Pl83nyJY5MWCwTlUrF
FVJZtUReK2b5/QLcNbQL0bkC3hK6F9Azq0TZP4GBUQwOYXAA/B7wOzDYgsE6
9FegtwC8dLSEv7Q+22Kq+g6KXX3+jp0kKZy3kCJV1N4Gah+XOth14b2+ayf4
d0+N6KhPGF2Ytrg6Z3t7wUlz2V1X6GO4Fmi6Hv5wI+aROPGxJN1ZmuMm53gx
pb5M1XOmLoRpDkdbNHhx6E3CYCoEGRjPxnQe5jhYKoawDKLKLRi7/lneJGNa
pWgTo2MTvHV0r6FHiL5l9C9icE6JdGgCw6MYHoKgH4JuDLdjuAn8agwUoycT
bVHfg+l/sSkpkyIlFKmh9rRQ+zvVjvSe+5B/9bORO6cntM/NGGrMmd9YfHR3
5Yn2qpu+6NmDjecW4jAbaYy9LNGJSXvK5HgyHB+mJICpDGbqwpmmKHDjwEtE
bwoGMyDIxlgepjhbrz13/XKzDtJGyJoZeSvDtDPolKNLih4xejfRv47BVfBX
MLwEwbwS6egERkcxNoTRPozyMNoKQR34ZejLQUfs97HoO+zcQRGiZRSpp/a0
qR3qVn9v4MzHAo0vxm9R0/cuzBleXTK7vWKjueZ4f8PNSPzMTPrcShZmJ492
lCe4MGkeTPYzpsCfKQliKkKZ2kimKRbcBHSmoCcdA9ns7s2uf58tw2IlVqqx
VofNRkiaIeMy8naG6WTQxaBHjj4ZBqTgizG8AcEaRoQYW1JiHZ/BxAQmRjAx
iIkejLdjtBGCSgzkSdujX5Mpu+/1K8U4SpFKijRR+zrVDvepfzB09tOxS19O
3Twzp3Vp0eCG0OyuyEZ7w1Ff8tRE6m0hC7CRhTrIo52ZBDcm1YvJ8mXyA5ni
EKYigqmJYRoT0Jq8xe6d4QKMFmOyDLOVWKjGch3WGrHRAgkXsnYwPIbpZtDL
oJ/BoBxDMghkGJFgbBPjIkwIMckynZ7G9DimhzHVj0keJlowWg1+wUZb5Pdg
+UtlFlLEpsJjD3RRRwbVPxw5+9nkxa9nb5xb1Ly8on9LZKq5aa0rcTCSuprJ
vKxk/nbyEEd5lCsT78mk+DBZAUx+MFMcjvLo7bj7TUcmunPRX4ChIoyWYqIC
M9WYr8NyI1ZbsM6FuANSHphuoI/BAAM+g2E5RuQYlWFcigkJpsSYFmFGiFmW
6ewUZkcxy8d0N6a4GKvBcKHq/vLuP8/xn1hLVlN7udShHurokPpH4+c+n75E
LVy7sPLNtbX7dzZN7okf6kvsH0hdLGSeNnI/BybYmYl0Z+K8mWS/7Yj7bXUi
6lOVk5b2HHTlo68Q/FKMVGC8GtN1mGvAUjOEXIg6sMmDtAfyPmAALDsGIwzG
GEzIMSnDtBQzEsxuYk6EeSHmF5V4FyYwP4y5Xsy0Y6JONlTw0g76X2D4czb1
1FB726iDfdRRAfXx5LlTcxrqS9c01u7e2ND9ZtNYR2JpKLMzlTk9lHvYMb5P
mCDXLW/83/QQ5EaAE4PSBFQppp/paM5GW55yGO8twWA5BFUYr8VUA+aascjF
SjvWeNjohqQPMgXBIUAAjALjwASDKQYzcszKMCfFghiLG1hcw9IylthEtDiC
hQHMdijUSfh5f4Yj67BbD7e+lvkJS66dOjBAHR2lTkyrf7Vw4azwyuX127c2
tTXFhvelFsZyW3PmiQ3DcvpjmDdi/JEYhLQwZEehIA4lSahMQ20WmnLB5aBT
keLLMFCJ4VqMNWCyGbOtWGjHMg+r3Vjvg3gA0iEw3zKbBKaBWWCOwbwcizIs
SbEsxvI6VlaxsohldrKwOIi5TvlUvbA/4zW5/ZgiFdSedmr/AHVsjPpkhjq9
dPb82uWr67fuiLXuSQ305VtxteepI7xdEeCJUB9EPUdCCFIjkBWD/EQUp6A8
AzU5aMhHaxE6StFdif4aDNVjpAkTrZhux3wnlroh7INoAJtDkAogV2E2DywA
SwyWGazIIJRAuIlVEVaXIWTHyyU+5nnSydpXvSV8BbO3lRM50kbtG6TeG6c+
naO+XlG/ILp0bZPls9/EDFZWcLCHixM83eDvjWA/RAYhLgwpUciMQ14SCtNQ
loXqPNRzlGuktnJ0VaO3DoOKnN6CsTZMdWK2G4u9WBnAGh8bAkhGIVOwmnqB
1aKCFbACCIFVOVZlWBNjbR1rQqwtQDihfP0z37k5Xv3K95/fZbb1XR9FWrZo
beWGg1e/kd3Vha4RjM1haQM7Bzi5wMMDvj4IClDud8dGICkG6QnISQEnAyU5
qCxAXTGaysCtVC4Tehow0IxhLkY7MNGFmV7M9ys7XDgM0Sg2xyGdhHwGzLeM
lncYrQEixQ+DdSnWN7G+CtECVifly0Nbk/XXYcRa5Cj12YKa2uqZixvnbkg1
NHHrPu49gIElzB7hkSMcXfHUE8988TwQoaGIjkJCHFKTkJWG/CwU56G8EDWl
aKhASzU66tHVhL5W8NsxwsN4j3KUmhvE4jBWRrA6jvVJiKchnYVsHvJFMMtb
1tmhsw5mA9iQY0PMbKwx64vM2pR0eXB1ulmBVJXTD17i9LMdTsrP66g9PcrQ
+myBolbVLonP3JRf1GKu64E2gd5DmNjB6gkc3ODiDU9/+AUhOByRMYhLQHIK
MjKQm4PCApQVo6oMdVVoUqxgG8FrQU8bBjox3K2cU00OYmYI8yNYGoNwEmvT
2JiFeB7SRciWIReCWd2mhQ2FDZhN5etDMcNsSpgNkYKddHVic2lANbervnHc
4fnd9cS377sUq8Vm6oiA+nReQZS6JFG/xVzQYq7qM3dMoWMFI3tYOMHWHU7P
4B4AnxAERiI8FjGJSExDWhay81BQiOISVFSgphqN9WhtQkcrujrQ1wV+r3Ka
PM7HlEA5GivGq+UprM5CNI+NRYiXIVmBdBUyEeQsSwXH3YxYwZORgBFLmU2R
dH1hUzi+OMf7/jyVM5pv31PupQ4OUB/PUl8rSardlJ/VYi7rMzfNGC1r6DvA
1AXWHnjsg6eB8A6FfxRC4hGZjPh0pGQrN73zilBYhrIqVNWirhHNLWhrQ2cn
erox0IehQYwMY2JUObmam8LCDJbnsLoA0RI2ViBehUQEyTpkG5CLoSS4Wy7B
rrdkEkYukUo21zZE80tLQy/tv6nOyV7m+KNtW7I56A/Uh5PUl8vURbHaTZm6
lvycAXPFDHetoesAYxdYesLOF06B8AiDTzQCExCegpgMJOUinYPsEhSUo6Qa
FfWoaUJDK1o60N6Frl70DihXd8MCjI1hYlI5h5ybxeIClpcgXIFoFRtr2FzH
ptJLJQpyb8skkEkhlkIqkUvEEtGGcHl1WjDVqfo+R3VX42V+O+9m2RkLoQ71
U58vUOc2qBtSNU35GQPmohluWEPrMQxcYeYFGz88DoJrOLxj4J+IkFREZSE+
DymFyCxFbiUKa1DagMpm1LWhqROt3ejoQ/cg+obBH4VgHGNTmJzFzDzmFrGw
jGUhhGtYE0G0gY1NRWLBpsJwuxXUdr21KWXWJfI1sXhRtDSxKPirX4hts/vT
F6h44avvP1DHJyn1VeqqmKJlavq4YIor1rjzGDquMPaCpR/sguEUAfdY+CQh
MA1h2YjJR2IR0sqQVYX8WhQ3orwV1e2o56G5B2396OSjR4D+MfAnIZjG2Cwm
FzC9hLkVLKxiSaSciCiHa8XApmD1xpqC1ZurEmZFLJ1fF42vzLzqO7GXGSkJ
sd+D/546NU9pbFB3ZdR9nDGBhjVuPIamK/S8YOoP62A4RMI1Dl5J8EtHcDYi
ChBXjORypFcjpx6cJpRwUdGBmi409KJlEG3D4I2gZxz9U+DPQDCH0UVMLGNK
iJk1zK1jQTFT3MSSBMsS7F5W4lfMsBYk8pkN8ahwSTV+Xo3/xSf/BnYH4swK
dUNM6eCMMc49hIYDbrngnhcM/WEegkeRcIyDWzKepSMgB6EFiCpBfDlSqpFR
j9xmcLgo7URlN2r60DCIlmG0jYI3gZ5p9M9icF65xB5ZwdgqJtcwtY6ZDcwq
wuaNOYUR3pyVYFqMiQ3Z8Oraq77w+YGiqMT93fFLc+er4t9Sl9YoWk4ZQM0C
5+xx1Rl3PaHrB+NgWEbALg5OyfDIgE8OAjkIK0F0BRJqkNqAzGbktaGwE6U9
qOxHLR8NArSMoW0CndPonkXfAgaW2B2CVYyIMLaOccWQtHtCAf2tSYlyCaZY
bI5sMH3CjZdmED98CbnqLtcvtzzo2jqlC8oU1CNccMJ1D9C+0AuCSQSsYuGQ
DJcMeOTAl4OgEoRXIKYGiQ1IbUFWG/J4KOxBab9y27xGgIYxNE+CO42OOfAW
0LOEvhUMrGJwDUPryh2A4U0INpVX/gb6ReCtSP5BBdNbL6FW5iPlfibrJ7+h
bq4rOpp6iLOPofEUN3ygGQj9cJjGwjoJDulwyYFnAfxKEFSB8BrENCCxBalt
yOQhrwecfpTwUSFQbn/XTaJpBi1z4C6gY0kBBt2r6FlDrwi7+9YVftG7jp51
dK6iaVH6cxWcb76EU/WbKTY+/4e6skAZM4quPeuMS164EQDNUOhHwywR1mlw
yIZrATyL4VeOoBqENyCmBYltSOUhswe5/eDwUSxA2RgqJ1Ezjfo5NM6jeRGt
y2gTon0V7WvoWEPbGriraFxG+czmL/4qUtWYZP3g3ykThrLHmae44IMbQdCM
hH48TFNgnQmHPLgUwbMMvtUIrEdYM6K4iO9EcjfS+5DNR54AnFEUT6BsCpWz
qJ5D7QLql9CwrPDWhhVFa/UrqFlC2Tyz9dW7yq7Hd/HtnF1go+vfFKDU3HHW
D9dCQEfjfiIepONhDuw5cCqFeyV8ahHQiJBWRHQgtgsJvUgZQMYQskeQN4aC
SRRNo3gGpXOK5rG7bEHRZMk8OLNIGZFuWUll3v1dNKoZjfXDf6aegvKHRihu
x0I7GUaZsMjDoyI4lsG1Gl718G1GIBehnYjsRmwfEgaRPITUEWSMIWsC2ZPY
nTOt0Js9jfQJRPGlW7nkzyD501kRVuoXihvKC+ohuBKDb5KhmwnjPFgWw7Yc
jtVwrYdnM3y4COhEcDfCehE5gGg+YoYUWuMEilZiBQjns62w54jeenF8VOa1
rTZVV1lsX/3ji7Jqz3EpDrdToZMDQw7MSmFVCbtaPGmEawvcufDqwDMefLrw
rAvuHWBPFn3nPMhWS6q5S/Wc1aE/83c/xavPZb37QvlPfH6mIqV69mvnfNqW
9M45IVWpI9+xi2qtahtKJG98K/1P2zpVpZTLnzd31gcvsVftHYIXvwZU9WDV
Eex/sXWqb+vcws45LFWp327r3DprpOqLqrOSd7Z1bp3W+tW2TlWpX23rZCNm
l+qJtVflS6X01lnAX2/rVJX6xXbLv2Gl/lOlVnWE++m2zt+x0r9RqX3V+kYp
/QdWeueknarUD7cRsOfH2H570dPe3NbBeuyu/1Fcf6i5fWZr164f/H/OV+o7
\
\>"]]]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->449252930]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LocatorPane", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{".2", ",", ".6"}], "}"}], ",", 
   RowBox[{"MatrixForm", "[", 
    RowBox[{"HilbertMatrix", "[", "3", "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->43144859],

Cell[BoxData[
 LocatorPaneBox[{0.465, 0.44}, 
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1", 
       FractionBox["1", "2"], 
       FractionBox["1", "3"]},
      {
       FractionBox["1", "2"], 
       FractionBox["1", "3"], 
       FractionBox["1", "4"]},
      {
       FractionBox["1", "3"], 
       FractionBox["1", "4"], 
       FractionBox["1", "5"]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]]], "Output",
 ImageSize->{73, 69},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->176149623]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "LocatorPane Control",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->444096084],

Cell["Specify a range of coordinates for locators:", "ExampleText",
 CellID->702406104],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LocatorPane", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], "/", "2"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Gray", ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"-", "1"}]}], "}"}], "/", "2"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], "/", "2"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->621782369],

Cell[BoxData[
 LocatorPaneBox[{-0.5, -0.5}, 
  GraphicsBox[
   {GrayLevel[0.5], DiskBox[{0, 0}]}], {{
    Rational[-1, 2], 
    Rational[-1, 2]}, {
    Rational[1, 2], 
    Rational[1, 2]}}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1315122764]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->224282438],

Cell["Specify both a range and jump size for locators:", "ExampleText",
 CellID->281101251],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LocatorPane", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], "/", "2"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Gray", ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"-", "1"}]}], "}"}], "/", "2"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], "/", "2"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "5"}], ",", 
       RowBox[{"1", "/", "5"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->50227531],

Cell[BoxData[
 LocatorPaneBox[{0.10000000000000009`, 0.30000000000000004`}, 
  GraphicsBox[
   {GrayLevel[0.5], DiskBox[{0, 0}]}], {{
    Rational[-1, 2], 
    Rational[-1, 2]}, {
    Rational[1, 2], 
    Rational[1, 2]}, {
    Rational[1, 5], 
    Rational[1, 5]}}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->307950084]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->486674653],

Cell["Use any expression as the appearance for locators:", "ExampleText",
 CellID->31495720],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LocatorPane", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], "/", "2"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Gray", ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Appearance", "\[Rule]", 
    RowBox[{"Framed", "[", 
     RowBox[{"x", "+", "y"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10940531],

Cell[BoxData[
 LocatorPaneBox[{0.74, -0.040000000000000036`}, 
  GraphicsBox[
   {GrayLevel[0.5], DiskBox[{0, 0}]}],
  Appearance->FrameBox[
    RowBox[{"x", "+", "y"}], StripOnInput -> False]]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->351843830]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->140540159],

Cell["Use multiple locators:", "ExampleText",
 CellID->24286701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LocatorPane", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"1", "/", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Gray", ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28967212],

Cell[BoxData[
 LocatorPaneBox[{{0.44999999999999996`, 0.6599999999999999}, {
   0.5, 0}, {-0.41000000000000003`, -0.12}}, 
  GraphicsBox[
   {GrayLevel[0.5], DiskBox[{0, 0}]}]]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->653566288]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->356381964],

Cell["Use a dynamic setting: ", "ExampleText",
 CellID->181849147],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"LocatorPane", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "pt", "]"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Gray", ",", 
        RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "pt", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->898741050],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   LocatorPaneBox[Dynamic[$CellContext`pt], 
    GraphicsBox[
     {GrayLevel[0.5], DiskBox[{0, 0}]}]], ",", 
   DynamicBox[ToBoxes[$CellContext`pt, StandardForm],
    ImageSizeCache->{82.5625, {2., 8.}}]}], "}"}]], "Output",
 ImageSize->{4, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->191364859]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->520740130],

Cell[TextData[{
 "Connect the dynamic setting to a ",
 Cell[BoxData[
  ButtonBox["Slider2D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider2D"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->43424624],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"LocatorPane", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "pt", "]"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Gray", ",", 
        RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]}], "]"}], ",", 
   RowBox[{"Slider2D", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "pt", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->136431752],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   LocatorPaneBox[Dynamic[$CellContext`pt], 
    GraphicsBox[
     {GrayLevel[0.5], DiskBox[{0, 0}]}]], ",", 
   Slider2DBox[Dynamic[$CellContext`pt], {-1, 1}]}], "}"}]], "Output",
 ImageSize->{210, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->378592923]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(10)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->359267121],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Appearance",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->78302160],

Cell[TextData[{
 "Use any expression as the appearance for locators in ",
 Cell[BoxData[
  ButtonBox["LocatorPane",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LocatorPane"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->993536701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"LocatorPane", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Gray", ",", 
        RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
     RowBox[{"Appearance", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\[MathematicaIcon]\>\"", ",", "Large"}], "]"}], ",", 
       "\"\<string\>\"", ",", 
       RowBox[{"Framed", "[", 
        RowBox[{"x", "+", "y"}], "]"}], ",", 
       RowBox[{"Graphics", "[", 
        RowBox[{
         RowBox[{"Rectangle", "[", "]"}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "20"}]}], "]"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6521209],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   LocatorPaneBox[{0.07000000000000006, 0.}, 
    GraphicsBox[
     {GrayLevel[0.5], DiskBox[{0, 0}]}],
    Appearance->StyleBox[
     "\"\[MathematicaIcon]\"", Large, StripOnInput -> False]], ",", 
   LocatorPaneBox[{0, 0}, 
    GraphicsBox[
     {GrayLevel[0.5], DiskBox[{0, 0}]}],
    Appearance->"\"string\""], ",", 
   LocatorPaneBox[{0, 0}, 
    GraphicsBox[
     {GrayLevel[0.5], DiskBox[{0, 0}]}],
    Appearance->FrameBox[
      RowBox[{"x", "+", "y"}], StripOnInput -> False]], ",", 
   LocatorPaneBox[{0, 0}, 
    GraphicsBox[
     {GrayLevel[0.5], DiskBox[{0, 0}]}],
    Appearance->GraphicsBox[
      RectangleBox[{0, 0}], ImageSize -> 20]]}], "}"}]], "Output",
 ImageSize->{452, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->21846174]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->626483],

Cell[TextData[{
 "Multiple locators with different appearance: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->71945347]
}], "ExampleText",
 CellID->267665105],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LocatorPane", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}], "/", "2"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Gray", ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Appearance", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<\[MathematicaIcon]\>\"", ",", "Large"}], "]"}], ",", 
      "\"\<string\>\"", ",", 
      RowBox[{"Framed", "[", 
       RowBox[{"x", "+", "y"}], "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1816662917],

Cell[BoxData[
 LocatorPaneBox[{{
    Rational[-1, 2], 0}, {
    Rational[1, 2], 0}, {0, 
    Rational[1, 2]}}, 
  GraphicsBox[
   {GrayLevel[0.5], DiskBox[{0, 0}]}],
  Appearance->{
    StyleBox["\"\[MathematicaIcon]\"", Large, StripOnInput -> False], 
    "\"string\"", 
    FrameBox[
     RowBox[{"x", "+", "y"}], StripOnInput -> False]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->154587111]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25534924],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Appearance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Appearance"], "\[Rule]", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 " for invisible locators:"
}], "ExampleText",
 CellID->1553717443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LocatorPane", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Gray", ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Appearance", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1265710601],

Cell[BoxData[
 LocatorPaneBox[{0, 0}, 
  GraphicsBox[
   {GrayLevel[0.5], DiskBox[{0, 0}]}],
  Appearance->None]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->144320869]
}, Open  ]],

Cell["\<\
Use an invisible locator to implement a constrained movement:\
\>", "ExampleText",
 CellID->289970787],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LocatorPane", "[", 
  RowBox[{
   RowBox[{"Dynamic", "[", "pt", "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Gray", ",", 
       RowBox[{"Disk", "[", "]"}], ",", "Red", ",", 
       RowBox[{"PointSize", "[", "Large", "]"}], ",", 
       RowBox[{"Dynamic", "[", 
        RowBox[{"Point", "[", 
         RowBox[{"Normalize", "[", "pt", "]"}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1.2"}]}], "]"}], ",", 
   RowBox[{"Appearance", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->697368794],

Cell[BoxData[
 LocatorPaneBox[Dynamic[$CellContext`pt], 
  GraphicsBox[{
    {GrayLevel[0.5], DiskBox[{0, 0}]}, 
    {RGBColor[1, 0, 0], PointSize[Large], 
     DynamicBox[Typeset`ToBoxes[
       Point[
        Normalize[$CellContext`pt]], StandardForm, Graphics],
      ImageSizeCache->{{16.5625, 24.5625}, {23.4375, 31.4375}}]}},
   PlotRange->1.2],
  Appearance->None]], "Output",
 ImageSize->{4, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->492064014]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AutoAction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->172386134],

Cell["\<\
By default the locator does not change until you click in the locator pane:\
\>", "ExampleText",
 CellID->253527996],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LocatorPane", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Gray", ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1195257669],

Cell[BoxData[
 LocatorPaneBox[{0, 0}, 
  GraphicsBox[
   {GrayLevel[0.5], DiskBox[{0, 0}]}]]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->5446185]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->88941731],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  ButtonBox["AutoAction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AutoAction"]], "InlineFormula"],
 ", the locator change as the mouse moves over the locator pane:"
}], "ExampleText",
 CellID->195054605],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LocatorPane", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Gray", ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"AutoAction", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2075400628],

Cell[BoxData[
 LocatorPaneBox[{0, 0}, 
  GraphicsBox[
   {GrayLevel[0.5], DiskBox[{0, 0}]}],
  AutoAction->True]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->496866246]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->50375713],

Cell["Change the background colors:", "ExampleText",
 CellID->187974734],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"LocatorPane", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Gray", ",", 
        RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
     RowBox[{"Background", "\[Rule]", "c"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Pink", ",", "Green", ",", "Yellow"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1289235501],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   LocatorPaneBox[{0, 0}, 
    GraphicsBox[
     {GrayLevel[0.5], DiskBox[{0, 0}]}],
    Background->RGBColor[1, 0.5, 0.5]], ",", 
   LocatorPaneBox[{0, 0}, 
    GraphicsBox[
     {GrayLevel[0.5], DiskBox[{0, 0}]}],
    Background->RGBColor[0, 1, 0]], ",", 
   LocatorPaneBox[{0, 0}, 
    GraphicsBox[
     {GrayLevel[0.5], DiskBox[{0, 0}]}],
    Background->RGBColor[1, 1, 0]]}], "}"}]], "Output",
 ImageSize->{341, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->902673974]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15418469],

Cell["Change the background color dynamically:", "ExampleText",
 CellID->779429907],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LocatorPane", "[", 
  RowBox[{
   RowBox[{"Dynamic", "[", "pt", "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Gray", ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"Dynamic", "[", 
     RowBox[{"Hue", "[", 
      RowBox[{"Norm", "[", "pt", "]"}], "]"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->245582918],

Cell[BoxData[
 LocatorPaneBox[Dynamic[$CellContext`pt], 
  GraphicsBox[
   {GrayLevel[0.5], DiskBox[{0, 0}]}],
  Background->Dynamic[
    Hue[
     Norm[$CellContext`pt]]]]], "Output",
 ImageSize->{4, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->215293576]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ContinuousAction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->543702913],

Cell["By default, variables are continuously updated:", "ExampleText",
 CellID->155072301],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"LocatorPane", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "pt", "]"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Gray", ",", 
        RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "pt", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->389557921],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   LocatorPaneBox[Dynamic[$CellContext`pt], 
    GraphicsBox[
     {GrayLevel[0.5], DiskBox[{0, 0}]}]], ",", 
   DynamicBox[ToBoxes[$CellContext`pt, StandardForm],
    ImageSizeCache->{68.5625, {2., 8.}}]}], "}"}]], "Output",
 ImageSize->{4, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->228102250]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->979817465],

Cell[TextData[{
 "Setting ",
 Cell[BoxData[
  ButtonBox["ContinuousAction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContinuousAction"]], "InlineFormula"],
 " to False, makes variable updates only when the locator is released:"
}], "ExampleText",
 CellID->83870],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"LocatorPane", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "pt", "]"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Gray", ",", 
        RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
     RowBox[{"ContinuousAction", "\[Rule]", "False"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "pt", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->74893251],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   LocatorPaneBox[Dynamic[$CellContext`pt], 
    GraphicsBox[
     {GrayLevel[0.5], DiskBox[{0, 0}]}],
    ContinuousAction->False], ",", 
   DynamicBox[ToBoxes[$CellContext`pt, StandardForm],
    ImageSizeCache->{68.5625, {2., 8.}}]}], "}"}]], "Output",
 ImageSize->{198, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->612272161]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Enabled",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->809694842],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["LocatorPane",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LocatorPane"]], "InlineFormula"],
 " is enabled: "
}], "ExampleText",
 CellID->154813376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LocatorPane", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Gray", ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->94729581],

Cell[BoxData[
 LocatorPaneBox[{0, 0}, 
  GraphicsBox[
   {GrayLevel[0.5], DiskBox[{0, 0}]}]]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->87738858]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->524517898],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Enabled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Enabled"], "\[Rule]", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the locator is disabled but visible in its current state:"
}], "ExampleText",
 CellID->576258550],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LocatorPane", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Gray", ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->227336428],

Cell[BoxData[
 LocatorPaneBox[{0, 0}, 
  GraphicsBox[
   {GrayLevel[0.5], DiskBox[{0, 0}]}],
  Enabled->False]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->280082524]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "LocatorAutoCreate",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->98672999],

Cell["\<\
By default, each click in the locator pane will move the nearest locator:\
\>", "ExampleText",
 CellID->503567006],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pts", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], "/", "2"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], "/", "2"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"LocatorPane", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "pts", "]"}], ",", 
     RowBox[{"Framed", "@", 
      RowBox[{"Graphics", "[", 
       RowBox[{"{", "}"}], "]"}]}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->217617015],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`pts$$ = {{
    Rational[-1, 2], 
    Rational[1, 2]}, {
    Rational[1, 2], 
    Rational[1, 2]}}}, 
  LocatorPaneBox[Dynamic[$CellContext`pts$$], 
   FrameBox[
    GraphicsBox[{}],
    StripOnInput->False]],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{194, 192},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1399061204]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16150127],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LocatorAutoCreate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LocatorAutoCreate"], "\[Rule]", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", you can use ",
 StyleBox["Alt", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["click", "KeyEvent"],
 " to create or remove locators:"
}], "ExampleText",
 CellID->1150080212],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pts", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], "/", "2"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], "/", "2"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"LocatorPane", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "pts", "]"}], ",", 
     RowBox[{"Framed", "@", 
      RowBox[{"Graphics", "[", 
       RowBox[{"{", "}"}], "]"}]}], ",", 
     RowBox[{"LocatorAutoCreate", "\[Rule]", "True"}]}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1177236633],

Cell[BoxData[
 DynamicModuleBox[{{
   Rational[-1, 2], 
   Rational[1, 2]} = {
   Rational[1, 2], 
   Rational[1, 2]}}, 
  LocatorPaneBox[Dynamic[$CellContext`pts$$], 
   FrameBox[
    GraphicsBox[{}],
    StripOnInput->False],
   LocatorAutoCreate->True],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{4, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1103532328]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->398053415],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LocatorAutoCreate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LocatorAutoCreate"], "\[Rule]", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 ", create a locator on each click (",
 StyleBox["Alt", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["click", "KeyEvent"],
 " to remove):"
}], "ExampleText",
 CellID->1223204625],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pts", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], "/", "2"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], "/", "2"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"LocatorPane", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "pts", "]"}], ",", 
     RowBox[{"Framed", "@", 
      RowBox[{"Graphics", "[", 
       RowBox[{"{", "}"}], "]"}]}], ",", 
     RowBox[{"LocatorAutoCreate", "\[Rule]", "All"}]}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->539179644],

Cell[BoxData[
 DynamicModuleBox[{{-0.5, 0.5} = {0.5, 0.5}}, 
  LocatorPaneBox[Dynamic[$CellContext`pts$$], 
   FrameBox[
    GraphicsBox[{}],
    StripOnInput->False],
   LocatorAutoCreate->All],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{194, 192},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1758770015]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->123550893],

Cell["Make an interactive plot that runs through all locators:", "ExampleText",
 CellID->587774259],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pts", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"LocatorPane", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "pts", "]"}], ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"InterpolatingPolynomial", "[", 
         RowBox[{"pts", ",", "x"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "3"}]}], "]"}], "]"}], ",", 
     RowBox[{"LocatorAutoCreate", "\[Rule]", "True"}]}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->595498751],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`pts$$ = {{0, 0}, {3, 2}, {
   0.665, -1.8499999999999999`}, {2.19, -0.9499999999999997}}}, 
  LocatorPaneBox[Dynamic[$CellContext`pts$$], 
   DynamicBox[ToBoxes[
     Plot[
      InterpolatingPolynomial[$CellContext`pts$$, $CellContext`x], \
{$CellContext`x, 0, 3}, PlotRange -> 3], StandardForm],
    ImageSizeCache->{180., {55., 59.}}],
   LocatorAutoCreate->True],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{184, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1178019563]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["Set up an array of movable random points:", "ExampleText",
 CellID->193335401],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pt", "=", 
     RowBox[{"RandomReal", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"100", ",", "2"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"LocatorPane", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "pt", "]"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}], ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<\[SmallCircle]\>\""}]}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->839834180],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`pt$$ = CompressedData["
1:eJwVk1lYkwcahX99UJBdwTFsErYaEBSH0FIFP1YVrYpaFRdopC4wdYRWQDoF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  "]}, 
  LocatorPaneBox[Dynamic[$CellContext`pt$$], 
   GraphicsBox[{},
    PlotRange->1],
   Appearance->"\"\[SmallCircle]\""],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->201952452]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->351978554],

Cell["Create locator that is constrained to follow the curve:", "ExampleText",
 CellID->528227269],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LocatorPane", "[", 
  RowBox[{
   RowBox[{"Dynamic", "[", "pt", "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "Large", "]"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"Dynamic", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"First", "[", "pt", "]"}], ",", 
            RowBox[{"Sin", "[", 
             RowBox[{"First", "[", "pt", "]"}], "]"}]}], "}"}], "]"}], 
         "]"}]}], "}"}]}]}], "]"}], ",", 
   RowBox[{"Appearance", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->148449963],

Cell[BoxData[
 LocatorPaneBox[Dynamic[$CellContext`pt], 
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1nc4le//AHAjsjLOMco456CQiqYiH++btpQokqRCUmaiKA0lQjIioyIi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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   Epilog->{
     PointSize[Large], 
     PointBox[
      Dynamic[{
        First[$CellContext`pt], 
        Sin[
         First[$CellContext`pt]]}]]},
   PlotRange->{{0, 10}, {-0.9999993680039507, 0.9999995755730018}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}],
  Appearance->None]], "Output",
 ImageSize->{4, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->702070537]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->258198725],

Cell[TextData[{
 "Visualize solutions to a linear system of differential equations ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "\[Prime]",
     MultilineFunction->None], "\[LongEqual]", 
    RowBox[{"A", ".", "x"}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->1260164775],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"pt", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], ",", 
     RowBox[{"A", "=", 
      RowBox[{"(", GridBox[{
         {
          RowBox[{"-", "1.1"}], "0.9"},
         {
          RowBox[{"-", "1.4"}], "0.3"}
        }], ")"}]}]}], "}"}], ",", 
   RowBox[{"LocatorPane", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "pt", "]"}], ",", 
     RowBox[{"Dynamic", "@", 
      RowBox[{"ParametricPlot", "[", 
       RowBox[{
        RowBox[{"MatrixExp", "[", 
         RowBox[{
          RowBox[{"A", " ", "t"}], ",", "pt"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "5"}]}], "]"}]}]}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1775953267],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`pt$$ = {2.6400000000000006`, 
  2.7}, $CellContext`A$$ = {{-1.1, 0.9}, {-1.4, 0.3}}}, 
  LocatorPaneBox[Dynamic[$CellContext`pt$$], 
   DynamicBox[ToBoxes[
     ParametricPlot[
      MatrixExp[$CellContext`A$$ $CellContext`t, $CellContext`pt$$], \
{$CellContext`t, 0, 10}, PlotRange -> 5], StandardForm],
    ImageSizeCache->{150., {73., 77.}}]],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->250714425]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->677451917],

Cell["Interactive curve fit plot:", "ExampleText",
 CellID->94935826],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pts", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"LocatorPane", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "pts", "]"}], ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"InterpolatingPolynomial", "[", 
         RowBox[{"pts", ",", "x"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "3"}]}], "]"}], "]"}]}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6077861],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`pts$$ = {{0, 0}, {1.025, -1.95}, {2.055, 
   1.5499999999999998`}, {2.93, -0.6499999999999999}}}, 
  LocatorPaneBox[Dynamic[$CellContext`pts$$], 
   DynamicBox[ToBoxes[
     Plot[
      InterpolatingPolynomial[$CellContext`pts$$, $CellContext`x], \
{$CellContext`x, 0, 3}, PlotRange -> 3], StandardForm],
    ImageSizeCache->{180., {55., 59.}}]],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{184, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1218878418]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->228766541],

Cell[TextData[{
 "Interactive three point circle ",
 ButtonBox["[more info]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://mathworld.wolfram.com/Circle.html"], None}],
 ":"
}], "ExampleText",
 CellID->255897645],

Cell[BoxData[
 RowBox[{
  RowBox[{"createCircle", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x1_", ",", "y1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x2_", ",", "y2_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x3_", ",", "y3_"}], "}"}]}], "}"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "=", 
       RowBox[{"Det", "[", 
        RowBox[{"(", GridBox[{
           {"x1", "y1", "1"},
           {"x2", "y2", "1"},
           {"x3", "y3", "1"}
          }], ")"}], "]"}]}], ",", 
      RowBox[{"d", "=", 
       RowBox[{"-", 
        RowBox[{"Det", "[", 
         RowBox[{"(", GridBox[{
            {
             RowBox[{
              SuperscriptBox["x1", "2"], "+", 
              SuperscriptBox["y1", "2"]}], "y1", "1"},
            {
             RowBox[{
              SuperscriptBox["x2", "2"], "+", 
              SuperscriptBox["y2", "2"]}], "y2", "1"},
            {
             RowBox[{
              SuperscriptBox["x3", "2"], "+", 
              SuperscriptBox["y3", "2"]}], "y3", "1"}
           }], ")"}], "]"}]}]}], ",", 
      RowBox[{"e", "=", 
       RowBox[{"Det", "[", 
        RowBox[{"(", GridBox[{
           {
            RowBox[{
             SuperscriptBox["x1", "2"], "+", 
             SuperscriptBox["y1", "2"]}], "x1", "1"},
           {
            RowBox[{
             SuperscriptBox["x2", "2"], "+", 
             SuperscriptBox["y2", "2"]}], "x2", "1"},
           {
            RowBox[{
             SuperscriptBox["x3", "2"], "+", 
             SuperscriptBox["y3", "2"]}], "x3", "1"}
          }], ")"}], "]"}]}], ",", 
      RowBox[{"f", "=", 
       RowBox[{"-", 
        RowBox[{"Det", "[", 
         RowBox[{"(", GridBox[{
            {
             RowBox[{
              SuperscriptBox["x1", "2"], "+", 
              SuperscriptBox["y1", "2"]}], "x1", "y1"},
            {
             RowBox[{
              SuperscriptBox["x2", "2"], "+", 
              SuperscriptBox["y2", "2"]}], "x2", "y2"},
            {
             RowBox[{
              SuperscriptBox["x3", "2"], "+", 
              SuperscriptBox["y3", "2"]}], "x3", "y3"}
           }], ")"}], "]"}]}]}]}], "}"}], ",", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["d", 
          RowBox[{"2", " ", "a"}]]}], ",", 
        RowBox[{"-", 
         FractionBox["e", 
          RowBox[{"2", " ", "a"}]]}]}], "}"}], ",", 
      SqrtBox[
       RowBox[{
        FractionBox[
         RowBox[{
          SuperscriptBox["d", "2"], "+", 
          SuperscriptBox["e", "2"]}], 
         RowBox[{"4", 
          SuperscriptBox["a", "2"]}]], "-", 
        FractionBox["f", "a"]}]]}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1609458221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pts", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"LocatorPane", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "pts", "]"}], ",", 
     RowBox[{"Framed", "@", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Dynamic", "[", 
           RowBox[{"createCircle", "[", "pts", "]"}], "]"}], ",", 
          RowBox[{"Point", "[", 
           RowBox[{"Dynamic", "[", "pts", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "5"}]}], "]"}]}]}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->460302735],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`pts$$ = {{-1, 0}, {1, 0}, {1, 
  1}}, $CellContext`c$$ = {}}, 
  LocatorPaneBox[Dynamic[$CellContext`pts$$], 
   FrameBox[
    GraphicsBox[{
      DynamicBox[Typeset`ToBoxes[
        $CellContext`createCircle[$CellContext`pts$$], StandardForm, 
        Graphics],
       ImageSizeCache->{{68.875, 111.125}, {-32.125, 10.125}}], 
      PointBox[Dynamic[$CellContext`pts$$]]},
     PlotRange->5]]],
  DynamicModuleValues:>{},
  Initialization:>($CellContext`createCircle[{{
       Pattern[$CellContext`x1, 
        Blank[]], 
       Pattern[$CellContext`y1, 
        Blank[]]}, {
       Pattern[$CellContext`x2, 
        Blank[]], 
       Pattern[$CellContext`y2, 
        Blank[]]}, {
       Pattern[$CellContext`x3, 
        Blank[]], 
       Pattern[$CellContext`y3, 
        Blank[]]}}] := 
   With[{$CellContext`a = 
      Det[{{$CellContext`x1, $CellContext`y1, 
          1}, {$CellContext`x2, $CellContext`y2, 
          1}, {$CellContext`x3, $CellContext`y3, 1}}], $CellContext`d = -
       Det[{{$CellContext`x1^2 + $CellContext`y1^2, $CellContext`y1, 
           1}, {$CellContext`x2^2 + $CellContext`y2^2, $CellContext`y2, 
           1}, {$CellContext`x3^2 + $CellContext`y3^2, $CellContext`y3, 
           1}}], $CellContext`e = 
      Det[{{$CellContext`x1^2 + $CellContext`y1^2, $CellContext`x1, 
          1}, {$CellContext`x2^2 + $CellContext`y2^2, $CellContext`x2, 
          1}, {$CellContext`x3^2 + $CellContext`y3^2, $CellContext`x3, 
          1}}], $CellContext`f = -
       Det[{{$CellContext`x1^2 + $CellContext`y1^2, $CellContext`x1, \
$CellContext`y1}, {$CellContext`x2^2 + $CellContext`y2^2, $CellContext`x2, \
$CellContext`y2}, {$CellContext`x3^2 + $CellContext`y3^2, $CellContext`x3, \
$CellContext`y3}}]}, 
     Circle[{-($CellContext`d/(2 $CellContext`a)), -($CellContext`e/(
        2 $CellContext`a))}, (($CellContext`d^2 + $CellContext`e^2)/(
        4 $CellContext`a^2) - $CellContext`f/$CellContext`a)^
      Rational[1, 2]]])]], "Output",
 ImageSize->{194, 192},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1367460505]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1886024635],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LocatorPane",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LocatorPane"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["EventHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EventHandler"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->139373048],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pt", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"LocatorPane", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "pt", "]"}], ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{"Framed", "@", 
       RowBox[{"Graphics", "[", 
        RowBox[{
         RowBox[{"{", "}"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "10"}]}], "]"}]}], "]"}]}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->162100497],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`pt$$ = {-0.3999999999999986, \
-1.1999999999999993`}}, 
  LocatorPaneBox[Dynamic[$CellContext`pt$$], 
   DynamicBox[ToBoxes[
     Framed[
      Graphics[{}, PlotRange -> 10]], StandardForm],
    ImageSizeCache->{110., {53., 57.}}]],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{114, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->419798815]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pt", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"Dynamic", "@", 
    RowBox[{"Deploy", "@", 
     RowBox[{"EventHandler", "[", 
      RowBox[{
       RowBox[{"Framed", "@", 
        RowBox[{"Graphics", "[", 
         RowBox[{
          RowBox[{"Disk", "[", "pt", "]"}], ",", 
          RowBox[{"PlotRange", "\[Rule]", "10"}]}], "]"}]}], ",", 
       RowBox[{"\"\<MouseDown\>\"", "\[RuleDelayed]", 
        RowBox[{"(", 
         RowBox[{"pt", "=", 
          RowBox[{"MousePosition", "[", "\"\<Graphics\>\"", "]"}]}], ")"}]}], 
       ",", 
       RowBox[{"\"\<MouseDragged\>\"", "\[RuleDelayed]", 
        RowBox[{"(", 
         RowBox[{"pt", "=", 
          RowBox[{"MousePosition", "[", "\"\<Graphics\>\"", "]"}]}], 
         ")"}]}]}], "]"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->126335905],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`pt$$ = {0, -2}}, 
  DynamicBox[ToBoxes[
    Deploy[
     EventHandler[
      Framed[
       Graphics[
        Disk[$CellContext`pt$$], PlotRange -> 10]], 
      "MouseDown" :> ($CellContext`pt$$ = MousePosition["Graphics"]), 
      "MouseDragged" :> ($CellContext`pt$$ = MousePosition["Graphics"])]], 
    StandardForm],
   ImageSizeCache->{110., {53., 57.}}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{114, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->110602051]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->493427463],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Setting",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Setting"]], "InlineFormula"],
 " to extract the setting of a ",
 Cell[BoxData[
  ButtonBox["LocatorPane",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LocatorPane"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->561333098],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Setting", "[", 
  RowBox[{"LocatorPane", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], "/", "2"}], ",", 
    RowBox[{"Graphics", "[", 
     RowBox[{"{", 
      RowBox[{"Gray", ",", 
       RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->55081126],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "2"], ",", 
   FractionBox["1", "2"]}], "}"}]], "Output",
 ImageSize->{52, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->199137227]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Setting", "[", 
  RowBox[{"LocatorPane", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", 
    RowBox[{"Graphics", "[", 
     RowBox[{"{", 
      RowBox[{"Gray", ",", 
       RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->356828861],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24477242]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->589267740],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["AutoAction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AutoAction"]], "InlineFormula"],
 " to select the locator closes to the mouse point:"
}], "ExampleText",
 CellID->740398586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LocatorPane", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Gray", ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Appearance", "\[Rule]", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<\[FilledCircle]\>\"", ",", 
        RowBox[{"Hue", "[", 
         RowBox[{"h", "/", "50"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"h", ",", "50"}], "}"}]}], "]"}]}], ",", 
   RowBox[{"AutoAction", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->437473124],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->130132469]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->45403825],

Cell["Constrain the locator to a circle:", "ExampleText",
 CellID->698647122],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pt", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"LocatorPane", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "pt", "]"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Circle", "[", "]"}], ",", 
        RowBox[{"PointSize", "[", "Large", "]"}], ",", 
        RowBox[{"Dynamic", "[", 
         RowBox[{"Point", "[", 
          RowBox[{"pt", "/", 
           RowBox[{"Norm", "[", "pt", "]"}]}], "]"}], "]"}]}], "}"}], "]"}], 
     ",", 
     RowBox[{"Appearance", "\[Rule]", "None"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1791293833],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`pt$$ = {0.040000000000000036`, 
  0.1399999999999999}}, 
  LocatorPaneBox[Dynamic[$CellContext`pt$$], 
   GraphicsBox[{CircleBox[{0, 0}], 
     {PointSize[Large], 
      DynamicBox[Typeset`ToBoxes[
        Point[$CellContext`pt$$/Norm[$CellContext`pt$$]], StandardForm, 
        Graphics],
       ImageSizeCache->{{109.125, 117.125}, {-89.25, -81.25}}]}}],
   Appearance->None],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1992415783]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->286943363],

Cell[TextData[{
 "Visualize solutions to a linear system of differential equations ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "\[Prime]",
     MultilineFunction->None], "\[LongEqual]", 
    RowBox[{"A", ".", "x"}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->139281443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"pt", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "3"}], ",", "0"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"A", "=", 
      RowBox[{"(", GridBox[{
         {
          RowBox[{"-", "1.1"}], "0.9"},
         {
          RowBox[{"-", "1.4"}], "0.3"}
        }], ")"}]}]}], "}"}], ",", 
   RowBox[{"LocatorPane", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "pt", "]"}], ",", 
     RowBox[{"Dynamic", "@", 
      RowBox[{"ParametricPlot", "[", 
       RowBox[{
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"MatrixExp", "[", 
            RowBox[{
             RowBox[{"A", " ", "t"}], ",", "#"}], "]"}], "&"}], "/@", "pt"}], 
         "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "5"}]}], "]"}]}]}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1898619465],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`pt$$ = {{2, 0}, {0, 1}, {-3, 
  0}}, $CellContext`A$$ = {{-1.1, 0.9}, {-1.4, 0.3}}}, 
  LocatorPaneBox[Dynamic[$CellContext`pt$$], 
   DynamicBox[ToBoxes[
     ParametricPlot[
      Evaluate[
       Map[
       MatrixExp[$CellContext`A$$ $CellContext`t, #]& , $CellContext`pt$$]], \
{$CellContext`t, 0, 10}, PlotRange -> 5], StandardForm],
    ImageSizeCache->{150., {73., 77.}}]],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->225035813]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Slider2D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider2D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClickPane",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ClickPane"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Locator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Locator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Manipulate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manipulate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Slider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorSlider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorSlider"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EventHandler",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EventHandler"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->373283810]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Generalized Input",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GeneralizedInput"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with LocatorPane",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=LocatorPane"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->5941347],

Cell[TextData[ButtonBox["Click-Interactive Panels",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ClickInteractivePanels"]], "MoreAbout",
 CellID->65097005],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->22657363],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "MoreAbout",
 CellID->97448354],

Cell[TextData[ButtonBox["Dynamic Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicVisualization"]], "MoreAbout",
 CellID->383272328],

Cell[TextData[ButtonBox["Graphics Interactivity & Drawing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsInteractivityAndDrawing"]], "MoreAbout",
 CellID->26847230]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LocatorPane - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 58, 32.2891842}", "context" -> "System`", 
    "keywords" -> {
     "applet window", "click-interactive", "event handling", "hit testing", 
      "multilocator", "slider pane", "thumbs"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LocatorPane[{x, y}, back] represents a pane with a locator at position \
{x, y} and background back. LocatorPane[Dynamic[pt], back] takes the locator \
position to be the dynamically updated current value of pt, with the value of \
pt being reset if the locator is moved. LocatorPane[{pt_1, pt_2, ...}, back] \
sets up multiple locators at positions pt_1, pt_2, .... \
LocatorPane[Dynamic[{pt_1, pt_2, ...}], back] takes the locator positions to \
be dynamically updated current values of the pt_i. LocatorPane[pts, back, \
{{x_min, y_min}, {x_max, y_max}}] specifies the range of coordinates for the \
locator. LocatorPane[pts, back, {{x_min, y_min}, {x_max, y_max}, {dx, dy}}] \
uses jumps dx, dy. ", "synonyms" -> {"locator pane"}, "title" -> 
    "LocatorPane", "type" -> "Symbol", "uri" -> "ref/LocatorPane"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[18298, 568, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->25079978]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 122976, 3707}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3200, 70, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3823, 97, 1576, 37, 70, "ObjectNameGrid"],
Cell[5402, 136, 5618, 177, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[11057, 318, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[11535, 335, 165, 4, 70, "Notes",
 CellID->1055956],
Cell[11703, 341, 857, 31, 70, "Notes",
 CellID->29911436],
Cell[12563, 374, 440, 15, 70, "Notes",
 CellID->143470244],
Cell[13006, 391, 68, 1, 70, "Notes",
 CellID->7420],
Cell[13077, 394, 2431, 64, 70, "3ColumnTableMod",
 CellID->20383],
Cell[15511, 460, 445, 16, 70, "Notes",
 CellID->148252763],
Cell[15959, 478, 767, 29, 70, "Notes",
 CellID->71945347],
Cell[16729, 509, 811, 28, 70, "Notes",
 CellID->769229223],
Cell[17543, 539, 367, 12, 70, "Notes",
 CellID->151551424],
Cell[17913, 553, 348, 10, 70, "Notes",
 CellID->307511469]
}, Closed]],
Cell[CellGroupData[{
Cell[18298, 568, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->25079978],
Cell[CellGroupData[{
Cell[18682, 582, 147, 5, 70, "ExampleSection",
 CellID->76046162],
Cell[18832, 589, 130, 4, 70, "ExampleText",
 CellID->70173164],
Cell[CellGroupData[{
Cell[18987, 597, 325, 11, 28, "Input",
 CellID->497815861],
Cell[19315, 610, 322, 11, 121, "Output",
 CellID->502885084]
}, Open  ]],
Cell[19652, 624, 68, 1, 70, "ExampleText",
 CellID->332575430],
Cell[CellGroupData[{
Cell[19745, 629, 601, 21, 70, "Input",
 CellID->1608606553],
Cell[20349, 652, 465, 16, 121, "Output",
 CellID->1812471632]
}, Open  ]],
Cell[20829, 671, 125, 3, 70, "ExampleDelimiter",
 CellID->745831676],
Cell[20957, 676, 227, 8, 70, "ExampleText",
 CellID->159505980],
Cell[CellGroupData[{
Cell[21209, 688, 595, 19, 70, "Input",
 CellID->1410452276],
Cell[21807, 709, 561, 15, 70, "Output",
 CellID->1431372240]
}, Open  ]],
Cell[22383, 727, 78, 1, 70, "ExampleText",
 CellID->1002268619],
Cell[CellGroupData[{
Cell[22486, 732, 889, 29, 70, "Input",
 CellID->155186329],
Cell[23378, 763, 577, 16, 70, "Output",
 CellID->1171484045]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24004, 785, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[CellGroupData[{
Cell[24250, 796, 287, 8, 70, "ExampleSubsection",
 CellID->65322756],
Cell[24540, 806, 75, 1, 70, "ExampleText",
 CellID->251377458],
Cell[CellGroupData[{
Cell[24640, 811, 335, 11, 70, "Input",
 CellID->330837619],
Cell[24978, 824, 3332, 59, 70, "Output",
 Evaluatable->False,
 CellID->611847003]
}, Open  ]],
Cell[28325, 886, 70, 1, 70, "ExampleText",
 CellID->567932866],
Cell[CellGroupData[{
Cell[28420, 891, 266, 9, 70, "Input",
 CellID->473891562],
Cell[28689, 902, 330, 10, 133, "Output",
 CellID->515337999]
}, Open  ]],
Cell[29034, 915, 123, 3, 70, "ExampleDelimiter",
 CellID->2589442],
Cell[29160, 920, 80, 1, 70, "ExampleText",
 CellID->78934132],
Cell[CellGroupData[{
Cell[29265, 925, 249, 8, 70, "Input",
 CellID->139734327],
Cell[29517, 935, 13241, 222, 129, "Output",
 CellID->449252930]
}, Open  ]],
Cell[CellGroupData[{
Cell[42795, 1162, 260, 8, 70, "Input",
 CellID->43144859],
Cell[43058, 1172, 1004, 32, 90, "Output",
 CellID->176149623]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[44111, 1210, 240, 7, 70, "ExampleSubsection",
 CellID->444096084],
Cell[44354, 1219, 87, 1, 70, "ExampleText",
 CellID->702406104],
Cell[CellGroupData[{
Cell[44466, 1224, 596, 22, 70, "Input",
 CellID->621782369],
Cell[45065, 1248, 387, 13, 121, "Output",
 CellID->1315122764]
}, Open  ]],
Cell[45467, 1264, 125, 3, 70, "ExampleDelimiter",
 CellID->224282438],
Cell[45595, 1269, 91, 1, 70, "ExampleText",
 CellID->281101251],
Cell[CellGroupData[{
Cell[45711, 1274, 712, 25, 70, "Input",
 CellID->50227531],
Cell[46426, 1301, 462, 15, 121, "Output",
 CellID->307950084]
}, Open  ]],
Cell[46903, 1319, 125, 3, 70, "ExampleDelimiter",
 CellID->486674653],
Cell[47031, 1324, 92, 1, 70, "ExampleText",
 CellID->31495720],
Cell[CellGroupData[{
Cell[47148, 1329, 434, 14, 70, "Input",
 CellID->10940531],
Cell[47585, 1345, 389, 11, 121, "Output",
 CellID->351843830]
}, Open  ]],
Cell[47989, 1359, 125, 3, 70, "ExampleDelimiter",
 CellID->140540159],
Cell[48117, 1364, 64, 1, 70, "ExampleText",
 CellID->24286701],
Cell[CellGroupData[{
Cell[48206, 1369, 523, 18, 70, "Input",
 CellID->28967212],
Cell[48732, 1389, 372, 10, 121, "Output",
 CellID->653566288]
}, Open  ]],
Cell[49119, 1402, 125, 3, 70, "ExampleDelimiter",
 CellID->356381964],
Cell[49247, 1407, 66, 1, 70, "ExampleText",
 CellID->181849147],
Cell[CellGroupData[{
Cell[49338, 1412, 381, 12, 70, "Input",
 CellID->898741050],
Cell[49722, 1426, 446, 13, 70, "Output",
 CellID->191364859]
}, Open  ]],
Cell[50183, 1442, 125, 3, 70, "ExampleDelimiter",
 CellID->520740130],
Cell[50311, 1447, 215, 8, 70, "ExampleText",
 CellID->43424624],
Cell[CellGroupData[{
Cell[50551, 1459, 520, 17, 70, "Input",
 CellID->136431752],
Cell[51074, 1478, 404, 12, 70, "Output",
 CellID->378592923]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[51539, 1497, 223, 7, 70, "ExampleSection",
 CellID->359267121],
Cell[CellGroupData[{
Cell[51787, 1508, 278, 8, 70, "ExampleSubsection",
 CellID->78302160],
Cell[52068, 1518, 242, 8, 70, "ExampleText",
 CellID->993536701],
Cell[CellGroupData[{
Cell[52335, 1530, 878, 27, 70, "Input",
 CellID->6521209],
Cell[53216, 1559, 897, 27, 123, "Output",
 CellID->21846174]
}, Open  ]],
Cell[54128, 1589, 122, 3, 70, "ExampleDelimiter",
 CellID->626483],
Cell[54253, 1594, 189, 6, 70, "ExampleText",
 CellID->267665105],
Cell[CellGroupData[{
Cell[54467, 1604, 813, 26, 70, "Input",
 CellID->1816662917],
Cell[55283, 1632, 536, 17, 121, "Output",
 CellID->154587111]
}, Open  ]],
Cell[55834, 1652, 124, 3, 70, "ExampleDelimiter",
 CellID->25534924],
Cell[55961, 1657, 323, 12, 70, "ExampleText",
 CellID->1553717443],
Cell[CellGroupData[{
Cell[56309, 1673, 352, 11, 70, "Input",
 CellID->1265710601],
Cell[56664, 1686, 308, 10, 121, "Output",
 CellID->144320869]
}, Open  ]],
Cell[56987, 1699, 112, 3, 70, "ExampleText",
 CellID->289970787],
Cell[CellGroupData[{
Cell[57124, 1706, 606, 16, 70, "Input",
 CellID->697368794],
Cell[57733, 1724, 564, 16, 70, "Output",
 CellID->492064014]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[58346, 1746, 231, 7, 70, "ExampleSubsection",
 CellID->172386134],
Cell[58580, 1755, 126, 3, 70, "ExampleText",
 CellID->253527996],
Cell[CellGroupData[{
Cell[58731, 1762, 300, 10, 70, "Input",
 CellID->1195257669],
Cell[59034, 1774, 286, 9, 121, "Output",
 CellID->5446185]
}, Open  ]],
Cell[59335, 1786, 124, 3, 70, "ExampleDelimiter",
 CellID->88941731],
Cell[59462, 1791, 259, 8, 70, "ExampleText",
 CellID->195054605],
Cell[CellGroupData[{
Cell[59746, 1803, 352, 11, 70, "Input",
 CellID->2075400628],
Cell[60101, 1816, 308, 10, 121, "Output",
 CellID->496866246]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[60458, 1832, 230, 7, 70, "ExampleSubsection",
 CellID->50375713],
Cell[60691, 1841, 72, 1, 70, "ExampleText",
 CellID->187974734],
Cell[CellGroupData[{
Cell[60788, 1846, 548, 18, 70, "Input",
 CellID->1289235501],
Cell[61339, 1866, 622, 20, 123, "Output",
 CellID->902673974]
}, Open  ]],
Cell[61976, 1889, 124, 3, 70, "ExampleDelimiter",
 CellID->15418469],
Cell[62103, 1894, 83, 1, 70, "ExampleText",
 CellID->779429907],
Cell[CellGroupData[{
Cell[62211, 1899, 440, 13, 70, "Input",
 CellID->245582918],
Cell[62654, 1914, 365, 12, 70, "Output",
 CellID->215293576]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[63068, 1932, 237, 7, 70, "ExampleSubsection",
 CellID->543702913],
Cell[63308, 1941, 90, 1, 70, "ExampleText",
 CellID->155072301],
Cell[CellGroupData[{
Cell[63423, 1946, 381, 12, 70, "Input",
 CellID->389557921],
Cell[63807, 1960, 446, 13, 70, "Output",
 CellID->228102250]
}, Open  ]],
Cell[64268, 1976, 125, 3, 70, "ExampleDelimiter",
 CellID->979817465],
Cell[64396, 1981, 270, 8, 70, "ExampleText",
 CellID->83870],
Cell[CellGroupData[{
Cell[64691, 1993, 441, 13, 70, "Input",
 CellID->74893251],
Cell[65135, 2008, 478, 14, 70, "Output",
 CellID->612272161]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[65662, 2028, 228, 7, 70, "ExampleSubsection",
 CellID->809694842],
Cell[65893, 2037, 212, 8, 70, "ExampleText",
 CellID->154813376],
Cell[CellGroupData[{
Cell[66130, 2049, 298, 10, 70, "Input",
 CellID->94729581],
Cell[66431, 2061, 287, 9, 121, "Output",
 CellID->87738858]
}, Open  ]],
Cell[66733, 2073, 125, 3, 70, "ExampleDelimiter",
 CellID->524517898],
Cell[66861, 2078, 360, 12, 70, "ExampleText",
 CellID->576258550],
Cell[CellGroupData[{
Cell[67246, 2094, 349, 11, 70, "Input",
 CellID->227336428],
Cell[67598, 2107, 306, 10, 121, "Output",
 CellID->280082524]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[67953, 2123, 237, 7, 70, "ExampleSubsection",
 CellID->98672999],
Cell[68193, 2132, 124, 3, 70, "ExampleText",
 CellID->503567006],
Cell[CellGroupData[{
Cell[68342, 2139, 632, 21, 70, "Input",
 CellID->217617015],
Cell[68977, 2162, 426, 15, 70, "Output",
 CellID->1399061204]
}, Open  ]],
Cell[69418, 2180, 124, 3, 70, "ExampleDelimiter",
 CellID->16150127],
Cell[69545, 2185, 468, 16, 70, "ExampleText",
 CellID->1150080212],
Cell[CellGroupData[{
Cell[70038, 2205, 697, 23, 70, "Input",
 CellID->1177236633],
Cell[70738, 2230, 425, 16, 70, "Output",
 CellID->1103532328]
}, Open  ]],
Cell[71178, 2249, 125, 3, 70, "ExampleDelimiter",
 CellID->398053415],
Cell[71306, 2254, 468, 16, 70, "ExampleText",
 CellID->1223204625],
Cell[CellGroupData[{
Cell[71799, 2274, 695, 23, 70, "Input",
 CellID->539179644],
Cell[72497, 2299, 367, 12, 70, "Output",
 CellID->1758770015]
}, Open  ]],
Cell[72879, 2314, 125, 3, 70, "ExampleDelimiter",
 CellID->123550893],
Cell[73007, 2319, 99, 1, 70, "ExampleText",
 CellID->587774259],
Cell[CellGroupData[{
Cell[73131, 2324, 827, 25, 70, "Input",
 CellID->595498751],
Cell[73961, 2351, 585, 15, 70, "Output",
 CellID->1178019563]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[74607, 2373, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[74837, 2382, 84, 1, 70, "ExampleText",
 CellID->193335401],
Cell[CellGroupData[{
Cell[74946, 2387, 697, 22, 70, "Input",
 CellID->839834180],
Cell[75646, 2411, 2548, 48, 70, "Output",
 CellID->201952452]
}, Open  ]],
Cell[78209, 2462, 125, 3, 70, "ExampleDelimiter",
 CellID->351978554],
Cell[78337, 2467, 98, 1, 70, "ExampleText",
 CellID->528227269],
Cell[CellGroupData[{
Cell[78460, 2472, 799, 23, 70, "Input",
 CellID->148449963],
Cell[79262, 2497, 12411, 217, 70, "Output",
 CellID->702070537]
}, Open  ]],
Cell[91688, 2717, 125, 3, 70, "ExampleDelimiter",
 CellID->258198725],
Cell[91816, 2722, 317, 10, 70, "ExampleText",
 CellID->1260164775],
Cell[CellGroupData[{
Cell[92158, 2736, 872, 29, 70, "Input",
 CellID->1775953267],
Cell[93033, 2767, 615, 15, 70, "Output",
 CellID->250714425]
}, Open  ]],
Cell[93663, 2785, 125, 3, 70, "ExampleDelimiter",
 CellID->677451917],
Cell[93791, 2790, 69, 1, 70, "ExampleText",
 CellID->94935826],
Cell[CellGroupData[{
Cell[93885, 2795, 898, 28, 70, "Input",
 CellID->6077861],
Cell[94786, 2825, 564, 14, 70, "Output",
 CellID->1218878418]
}, Open  ]],
Cell[95365, 2842, 125, 3, 70, "ExampleDelimiter",
 CellID->228766541],
Cell[95493, 2847, 224, 8, 70, "ExampleText",
 CellID->255897645],
Cell[95720, 2857, 2831, 92, 70, "Input",
 CellID->1609458221],
Cell[CellGroupData[{
Cell[98576, 2953, 925, 29, 70, "Input",
 CellID->460302735],
Cell[99504, 2984, 2154, 50, 70, "Output",
 CellID->1367460505]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[101707, 3040, 238, 7, 70, "ExampleSection",
 CellID->1886024635],
Cell[101948, 3049, 338, 12, 70, "ExampleText",
 CellID->139373048],
Cell[CellGroupData[{
Cell[102311, 3065, 548, 18, 70, "Input",
 CellID->162100497],
Cell[102862, 3085, 501, 14, 70, "Output",
 CellID->419798815]
}, Open  ]],
Cell[CellGroupData[{
Cell[103400, 3104, 945, 27, 70, "Input",
 CellID->126335905],
Cell[104348, 3133, 629, 18, 70, "Output",
 CellID->110602051]
}, Open  ]],
Cell[104992, 3154, 125, 3, 70, "ExampleDelimiter",
 CellID->493427463],
Cell[105120, 3159, 344, 13, 70, "ExampleText",
 CellID->561333098],
Cell[CellGroupData[{
Cell[105489, 3176, 366, 12, 70, "Input",
 CellID->55081126],
Cell[105858, 3190, 299, 10, 51, "Output",
 CellID->199137227]
}, Open  ]],
Cell[CellGroupData[{
Cell[106194, 3205, 450, 15, 70, "Input",
 CellID->356828861],
Cell[106647, 3222, 301, 11, 36, "Output",
 CellID->24477242]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[106997, 3239, 228, 7, 70, "ExampleSection",
 CellID->589267740],
Cell[107228, 3248, 241, 8, 70, "ExampleText",
 CellID->740398586],
Cell[CellGroupData[{
Cell[107494, 3260, 813, 25, 70, "Input",
 CellID->437473124],
Cell[108310, 3287, 4324, 75, 70, "Output",
 Evaluatable->False,
 CellID->130132469]
}, Open  ]],
Cell[112649, 3365, 124, 3, 70, "ExampleDelimiter",
 CellID->45403825],
Cell[112776, 3370, 77, 1, 70, "ExampleText",
 CellID->698647122],
Cell[CellGroupData[{
Cell[112878, 3375, 733, 22, 70, "Input",
 CellID->1791293833],
Cell[113614, 3399, 596, 16, 70, "Output",
 CellID->1992415783]
}, Open  ]],
Cell[114225, 3418, 125, 3, 70, "ExampleDelimiter",
 CellID->286943363],
Cell[114353, 3423, 316, 10, 70, "ExampleText",
 CellID->139281443],
Cell[CellGroupData[{
Cell[114694, 3437, 1202, 40, 70, "Input",
 CellID->1898619465],
Cell[115899, 3479, 650, 17, 70, "Output",
 CellID->225035813]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[116610, 3503, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[116929, 3514, 1694, 62, 70, "SeeAlso",
 CellID->373283810]
}, Open  ]],
Cell[CellGroupData[{
Cell[118660, 3581, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[118981, 3592, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[119143, 3597, 148, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[119328, 3605, 305, 8, 70, "RelatedLinksSection"],
Cell[119636, 3615, 367, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[120040, 3632, 317, 9, 70, "MoreAboutSection",
 CellID->5941347],
Cell[120360, 3643, 157, 3, 70, "MoreAbout",
 CellID->65097005],
Cell[120520, 3648, 140, 3, 70, "MoreAbout",
 CellID->22657363],
Cell[120663, 3653, 167, 3, 70, "MoreAbout",
 CellID->97448354],
Cell[120833, 3658, 153, 3, 70, "MoreAbout",
 CellID->383272328],
Cell[120989, 3663, 174, 3, 70, "MoreAbout",
 CellID->26847230]
}, Open  ]],
Cell[121178, 3669, 27, 0, 70, "History"],
Cell[121208, 3671, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

