(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23052,        691]
NotebookOptionsPosition[     19407,        575]
NotebookOutlinePosition[     20912,        615]
CellTagsIndexPosition[     20827,        610]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Some Special Plots" :> 
          Documentation`HelpLookup["paclet:tutorial/SomeSpecialPlots"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Some Special Plots\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ListLogLinearPlot" :> 
          Documentation`HelpLookup["paclet:ref/ListLogLinearPlot"], "LogPlot" :> 
          Documentation`HelpLookup["paclet:ref/LogPlot"], "LogLogPlot" :> 
          Documentation`HelpLookup["paclet:ref/LogLogPlot"], "Plot" :> 
          Documentation`HelpLookup["paclet:ref/Plot"], "ParametricPlot" :> 
          Documentation`HelpLookup["paclet:ref/ParametricPlot"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ListLogLinearPlot\"\>", 
       2->"\<\"LogPlot\"\>", 3->"\<\"LogLogPlot\"\>", 4->"\<\"Plot\"\>", 
       5->"\<\"ParametricPlot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function Visualization" :> 
          Documentation`HelpLookup["paclet:guide/FunctionVisualization"], 
          "New in 6.0: Function Visualization" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FunctionVisualization"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Function Visualization\"\>", 
       2->"\<\"New in 6.0: Function Visualization\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["LogLinearPlot", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LogLinearPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LogLinearPlot"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates a log-linear plot of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " as a function of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LogLinearPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LogLinearPlot"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates log-linear plots of several functions ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogLinearPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogLinearPlot"]], "InlineFormula"],
 " effectively generates a curve in which ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " is plotted against ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Log",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Log"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ", but with tick marks indicating the original values of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogLinearPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogLinearPlot"]], "InlineFormula"],
 " makes logarithmic functions appear as straight lines."
}], "Notes",
 CellID->52897017],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogLinearPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogLinearPlot"]], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->312555850]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->298921302],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->245234916],

Cell[TextData[{
 "Make a plot with a logarithmic ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " scale:"
}], "ExampleText",
 CellID->177389336],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogLinearPlot", "[", 
  RowBox[{
   RowBox[{"Tanh", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "100"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->271881548],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WM1rVUcUv3n3vbdR41eNqV9NqZT68S+IC9EipRQXpYviIg1CsmgVE/sR
NZqoiYrd2E2FVBe1hX4sLBVLwUKpUCqUCqWCqFAsFLuoFJQuAsLzN3PuvDP3
zLlz30teDC93Zu787u+cOV8z977aPzK45+3+kaGB/r6X9/fvGxwaGO7bsXc/
bqVdSZJcxv9wb4J+Az37f7nRQOtfN+BaxdQqtCnaZVlbQVtB253Nu3FPNp96
8z4+9dok2WiuZtqOkmStNzbdJeZS5THx+IiF5lJrMmQ8EtUj5KgshXLcE8Zo
Xaa19zYJjjVt676oFDEfem8WHKvb1ru7RKunofWzDYqj5XPW9pmMqRIwdc9C
zw3BM9K+y0o1XmAudR+h44zmLvab0I5Ye2Nmk7VZu7SRz97FYtzr2dBlvcx2
zvqwyqwQOk8375qnPrEjY7fzGFXVJxbb8Q9X744fvWq60grSC8s1W7aBr+c0
tDmT3vjt773vfPt0pYc2uH//4Ruvf266pyOomZnH27dNF6NoRa/svPDo0Yzp
nsqtd6md3f3mF/fu/ZefDTkOjFy5/stfZaipyR+/u3KLUVmo2D/brXK80h1D
UfP0qVw4/yutJR/tdSEvFWPpK9IHykAlT58cZy2TX22JC8uHEYq4qt7qvDuC
NW1GGUwOw7fO5nKypurGcdA6m88idaXI2PXapw8e/G+6JwNv1jN9qqK1dTEd
Grx0849/+EkZLcR/cPT7az/9WYb66OzPX335exnqs4s3zn18PY9ifbiixDig
MhQvQ8EkMEwoibIbboAzTHdK5SB9OOdiKM65KUXSh2eufXPpJs/Gc835R8YP
SYKBYWaPK8y9aPzIsbS6xuqyj1TyJqyu7pTqe0VjsZHbwi6ra4iyiOIY5a5J
7lSxInmE6+xkEVtpFhof0T7COTQZ+FfLvlAfGB8uYAYZZQZl6q0eg8TBFZQ5
WEf2TbEEP2N0FHFx5pzISVohrHEiwsH7TwzFtUKThJKEwsSz5XkVq6Qk8c7t
fwfe+trjDPMrOAHKHY+YuNJrTC6n5O7odlpaIVef4wpHGKcamz8mVq7mnWSF
o+CuKOsssp+4ObaPB552GeYs5zKtR/iTnpRxRiiO6GMRFIhAl0cZSSuFVYs5
TA7H9OCI1iRwduoSCMVngYkIirWdyEnqzbQ8Fti59Z1qpVjLhBIP7e9UxMr7
gMYa36l8tt5GPr/GFbb42S7NrOXXskKWWUQ+cePggOPD/HBzbowH3vazyq3Y
tKvsk7x/Hm1Gj/xa4MdYDMUnGkaxJNZR55D6HImg2E9HcpLo7Y/PQDEOjj8d
RVx4LcXLqemORVDs27HA/vo7WMXzDH3/4rfPMSU+5M4k40BW8jVC+8MKp4t9
95YkM4s4uGJrHO3EbdpcK0o0ihs8MGdOf0zfQPmMfqjj3BzDhwI/F+XZc418
Bh1U42idHfN3EB1FXLx7jTZRRlKf0HFU5SAUZ9AHERT8hMKKyCxAPe+0xmsT
sMn7OX1eaOSrwnsqB6GwUWWod1XUescF+2BTTA547nR/gQ8Vb7xoJqrQGLkG
mQjBYUuh5tMs4sTy10ELcoQ4zIxqhOG+jkp5yT4Hi8OHKHWoY3A5fGD2e/vV
BAvEzy50z5wlm6H9ilxDbIEcQvCDuKQOb+zeuuWcjYHsiVpHVzo9D2yxrL1o
p8LvrEnXE8Zu1Lw=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->148589840]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1590272668],

Cell["Plot several functions:", "ExampleText",
 CellID->493069127],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogLinearPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Tanh", "[", "x", "]"}], ",", 
     RowBox[{"Erf", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "100"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70263232],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29874581]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2123082510],

Cell["Fill below a curve:", "ExampleText",
 CellID->59467018],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogLinearPlot", "[", 
  RowBox[{
   RowBox[{"Erf", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "100"}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Bottom"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->882275671],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WetLFUEUX++9SlBaaaaZlf9A1j8QQUQSIT0g+mARNwuuQfm6alZE9qE+
ZEQPMguSsncShvZW6GlZoVQaVhJYpEVFUPRBCLYzO7v37D27szN271V0Zs/u
b3/nzMw5v5nFwmA4tGlLMFxSHMwrqAiWhUqKK/OWlFbALX+Spmnt8FeWrcG1
DlfGX7uuQ+9s50IbAMAM6P3QTzV7H/Q+6NPM55adaT73m3Yqwfttvabls5Y9
NixNy7XZ7HIyawJocx47YhJrkiMMJg9FZRI/9PlETz/WG2zqklhv3JtHOGaO
OfZUKSIRcc8nHDljjjtNEtV4RJ2t8zxKjznaDJPJ52DyXh/3OOc63qHzO1Ua
sTE/KXaEO45FbuV+BBqX2c435yTX7Kfo0dU7mdhZtjm0qp5WO1a9XV/o7DR4
3GVejsPNZFdMhmXX73/wduCblsMaZkPPLjMkNsWnW7bJnxLxym6OnzfnGM+d
7d239x57oRaaCR7ImzcGamtuxYJkqzZtjFy9PZ83bbwaX2R/35fg+hYV5MjI
r1Urmr1GIkI4uX78+FO47LQ3knMuXNBoruS2/0Rau6fmX7zoZN/rrypca1af
73o8FF9k6da2tmtvvOITIdS4TBEwfozLACoRKkWA8FGb89ft7jh7ppfwR2ld
CnnP0D6HZlIUZ4ciazr1woudKZF1urFOPXYeaqvyGqMV7QCO6K0oODtQm5oU
P3bnGGL04rEfU5uqj3smpejOncbvkkditugcR2WS5bg6cmjoJ5ShChIV6n+R
bCTT9Wi9qRFyZY4RubTgVG/PsAoSdadGEF/xhpaOO4MqXKgmMuSO7bcvXXip
gsRalCEbj3cfOvjIayRYE4hQVzufS61xz9da+3ftvEt45SrnecZ0P7NjXYg8
UcUzD2MIcFQcZ+5++nFzSasXs4peGJHbouDceDaIhVtFi7g/rLnx8ff79ygU
nDiv3LTPLZuoHlQ78jhLj67uamFNcC6sbhmyJNQKyaWCrArfuNrSp4LE2hWN
5MjhrmNHn6hw4ZlahsQakSEx50XxvX/3fW3RRRUuPImKkVlkfaskyJXLm58/
+6SCxNWrcowkm6waItS0z+qphnHPB+ofnmjsJrxy7fOw6ZmM+0HtFvmhymf1
VO+ySJaI+GLRCH8kg1D7EuHHOS7UvkT743mF2RyOSfs427qiS/fvfYhms/J4
hh6dx2FhTXAuzEwZEnNBhkQ9kCFHR//CZ6L7SHLIWCuFXHzMeFqSIa9cfrWn
rlMFiXlZKYgPRgCKBhuNB1cOWZMKCbKzYzBceV0FCXsqeIfPbA/kTLLO5Y6R
5Fo1ARsh4yq31QTmqPsZRpaxnBtPnWURbldFi0PFzTJs2AZNj6UJ9zibNQEY
I2gKJBassg9O+Oybatis+lBCYmDmHGvtIKkhwzQffF4YZx+QHPjVQqxhX3fm
e8kJnYmGcWBX0c0mA+L8P5CW9A/OnOs1\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->274716888]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListLogLinearPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListLogLinearPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LogPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LogPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LogLogPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LogLogPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Plot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Plot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ParametricPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ParametricPlot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Some Special Plots",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SomeSpecialPlots"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Function Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionVisualization"]], "MoreAbout",
 CellID->94157675],

Cell[TextData[ButtonBox["New in 6.0: Function Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FunctionVisualization"]], "MoreAbout",
 CellID->697842450]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LogLinearPlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 58, 47.7583302}", "context" -> "System`", 
    "keywords" -> {
     "loglinear", "log-linear plot", "log-normal plot", "semi-logarithmic", 
      "semi log plot", "Bode plot", "frequency plot"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LogLinearPlot[f, {x, x_min, x_max}] generates a log-linear plot of f as \
a function of x from x_min to x_max. LogLinearPlot[{f_1, f_2, ...}, {x, \
x_min, x_max}] generates log-linear plots of several functions f_i.", 
    "synonyms" -> {"log linear plot"}, "title" -> "LogLinearPlot", "type" -> 
    "Symbol", "uri" -> "ref/LogLinearPlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8493, 264, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->298921302]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20684, 603}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2368, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2991, 82, 1578, 37, 70, "ObjectNameGrid"],
Cell[4572, 121, 2217, 73, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6826, 199, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7304, 216, 589, 20, 70, "Notes",
 CellID->1067943069],
Cell[7896, 238, 234, 7, 70, "Notes",
 CellID->52897017],
Cell[8133, 247, 323, 12, 70, "Notes",
 CellID->312555850]
}, Closed]],
Cell[CellGroupData[{
Cell[8493, 264, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->298921302],
Cell[CellGroupData[{
Cell[8878, 278, 148, 5, 70, "ExampleSection",
 CellID->245234916],
Cell[9029, 285, 158, 6, 70, "ExampleText",
 CellID->177389336],
Cell[CellGroupData[{
Cell[9212, 295, 225, 7, 28, "Input",
 CellID->271881548],
Cell[9440, 304, 1937, 36, 136, "Output",
 Evaluatable->False,
 CellID->148589840]
}, Open  ]],
Cell[11392, 343, 126, 3, 70, "ExampleDelimiter",
 CellID->1590272668],
Cell[11521, 348, 66, 1, 70, "ExampleText",
 CellID->493069127],
Cell[CellGroupData[{
Cell[11612, 353, 308, 10, 28, "Input",
 CellID->70263232],
Cell[11923, 365, 2424, 44, 133, "Output",
 Evaluatable->False,
 CellID->29874581]
}, Open  ]],
Cell[14362, 412, 126, 3, 70, "ExampleDelimiter",
 CellID->2123082510],
Cell[14491, 417, 61, 1, 70, "ExampleText",
 CellID->59467018],
Cell[CellGroupData[{
Cell[14577, 422, 275, 8, 28, "Input",
 CellID->882275671],
Cell[14855, 432, 1709, 32, 133, "Output",
 Evaluatable->False,
 CellID->274716888]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16625, 471, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[16944, 482, 1214, 44, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[18195, 531, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[18516, 542, 149, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[18702, 550, 299, 8, 70, "MoreAboutSection"],
Cell[19004, 560, 154, 3, 70, "MoreAbout",
 CellID->94157675],
Cell[19161, 565, 174, 3, 70, "MoreAbout",
 CellID->697842450]
}, Open  ]],
Cell[19350, 571, 27, 0, 70, "History"],
Cell[19380, 573, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

