(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27733,        797]
NotebookOptionsPosition[     23946,        676]
NotebookOutlinePosition[     25465,        717]
CellTagsIndexPosition[     25380,        712]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Some Special Plots" :> 
          Documentation`HelpLookup["paclet:tutorial/SomeSpecialPlots"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Some Special Plots\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ListLogLogPlot" :> 
          Documentation`HelpLookup["paclet:ref/ListLogLogPlot"], "LogPlot" :> 
          Documentation`HelpLookup["paclet:ref/LogPlot"], "LogLinearPlot" :> 
          Documentation`HelpLookup["paclet:ref/LogLinearPlot"], "Plot" :> 
          Documentation`HelpLookup["paclet:ref/Plot"], "ParametricPlot" :> 
          Documentation`HelpLookup["paclet:ref/ParametricPlot"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ListLogLogPlot\"\>", 
       2->"\<\"LogPlot\"\>", 3->"\<\"LogLinearPlot\"\>", 4->"\<\"Plot\"\>", 
       5->"\<\"ParametricPlot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function Visualization" :> 
          Documentation`HelpLookup["paclet:guide/FunctionVisualization"], 
          "New in 6.0: Function Visualization" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FunctionVisualization"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Function Visualization\"\>", 
       2->"\<\"New in 6.0: Function Visualization\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["LogLogPlot", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LogLogPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LogLogPlot"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates a log-log plot of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " as function of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LogLogPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LogLogPlot"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates log-log plots of several functions ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogLogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogLogPlot"]], "InlineFormula"],
 " effectively generates a curve in which ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Log",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Log"], "[", 
   StyleBox["f", "TI"], "]"}]], "InlineFormula"],
 " is plotted against ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Log",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Log"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ", but with tick marks indicating the original values of ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogLogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogLogPlot"]], "InlineFormula"],
 " makes power law functions appear as straight lines."
}], "Notes",
 CellID->52897017],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogLogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogLogPlot"]], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->138758103]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->66001029],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->13643507],

Cell["Powers show up as straight lines on a log-log plot:", "ExampleText",
 CellID->919901169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogLogPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"x", "^", "3"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "100"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->465768401],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->59001722]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1990842198],

Cell["Plot several functions:", "ExampleText",
 CellID->493069127],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogLogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "^", "2"}], ",", 
     RowBox[{"x", "^", "3"}], ",", 
     RowBox[{"x", "^", "4"}], ",", 
     RowBox[{"x", "^", "5"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", 
     RowBox[{"10", "^", "4"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->246711909],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9153129]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4388955],

Cell["Fill between curves: ", "ExampleText",
 CellID->39177397],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogLogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"10", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "-", 
        RowBox[{"6", "x"}], "+", "10"}], ")"}]}], ",", 
     RowBox[{"100", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", "100"}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0.1", ",", "1000"}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", "2", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->189745585],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->236173347]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListLogLogPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListLogLogPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LogPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LogPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LogLinearPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LogLinearPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Plot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Plot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ParametricPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ParametricPlot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Some Special Plots",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SomeSpecialPlots"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with LogLogPlot",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=LogLogPlot"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Function Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionVisualization"]], "MoreAbout",
 CellID->209900867],

Cell[TextData[ButtonBox["New in 6.0: Function Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FunctionVisualization"]], "MoreAbout",
 CellID->169941166]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LogLogPlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 58, 48.4770986}", "context" -> "System`", 
    "keywords" -> {
     "double-logarithmic plot", "double logarithmic plot", "loglog", 
      "log-log scale plot", "Bode plot", "frequency plot", "spectrum plot", 
      "complexity plot"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LogLogPlot[f, {x, x_min, x_max}] generates a log-log plot of f as \
function of x from x_min to x_max. LogLogPlot[{f_1, f_2, ...}, {x, x_min, \
x_max}] generates log-log plots of several functions f_i.", 
    "synonyms" -> {"log log plot"}, "title" -> "LogLogPlot", "type" -> 
    "Symbol", "uri" -> "ref/LogLogPlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8620, 271, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->66001029]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25238, 705}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2368, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2991, 82, 1575, 37, 70, "ObjectNameGrid"],
Cell[4569, 121, 2197, 73, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6803, 199, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7281, 216, 753, 27, 70, "Notes",
 CellID->1067943069],
Cell[8037, 245, 226, 7, 70, "Notes",
 CellID->52897017],
Cell[8266, 254, 317, 12, 70, "Notes",
 CellID->138758103]
}, Closed]],
Cell[CellGroupData[{
Cell[8620, 271, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->66001029],
Cell[CellGroupData[{
Cell[9004, 285, 147, 5, 70, "ExampleSection",
 CellID->13643507],
Cell[9154, 292, 94, 1, 70, "ExampleText",
 CellID->919901169],
Cell[CellGroupData[{
Cell[9273, 297, 264, 9, 28, "Input",
 CellID->465768401],
Cell[9540, 308, 2241, 41, 136, "Output",
 Evaluatable->False,
 CellID->59001722]
}, Open  ]],
Cell[11796, 352, 126, 3, 70, "ExampleDelimiter",
 CellID->1990842198],
Cell[11925, 357, 66, 1, 70, "ExampleText",
 CellID->493069127],
Cell[CellGroupData[{
Cell[12016, 362, 388, 13, 28, "Input",
 CellID->246711909],
Cell[12407, 377, 3940, 69, 137, "Output",
 Evaluatable->False,
 CellID->9153129]
}, Open  ]],
Cell[16362, 449, 123, 3, 70, "ExampleDelimiter",
 CellID->4388955],
Cell[16488, 454, 63, 1, 70, "ExampleText",
 CellID->39177397],
Cell[CellGroupData[{
Cell[16576, 459, 632, 21, 28, "Input",
 CellID->189745585],
Cell[17211, 482, 3181, 56, 131, "Output",
 Evaluatable->False,
 CellID->236173347]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20453, 545, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[20772, 556, 1214, 44, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[22023, 605, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[22344, 616, 149, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[22530, 624, 305, 8, 70, "RelatedLinksSection"],
Cell[22838, 634, 365, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23240, 651, 299, 8, 70, "MoreAboutSection"],
Cell[23542, 661, 155, 3, 70, "MoreAbout",
 CellID->209900867],
Cell[23700, 666, 174, 3, 70, "MoreAbout",
 CellID->169941166]
}, Open  ]],
Cell[23889, 672, 27, 0, 70, "History"],
Cell[23919, 674, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

