(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     41645,       1444]
NotebookOptionsPosition[     33841,       1172]
NotebookOutlinePosition[     35382,       1213]
CellTagsIndexPosition[     35296,       1208]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Relational and Logical Operators" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RelationalAndLogicalOperators"], 
          "Logical and Piecewise Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LogicalAndPiecewiseFunctions"], 
          "Solving Equations Involving Power Series" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SolvingEquationsInvolvingPowerSeries"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Relational and Logical Operators\"\>", 
       2->"\<\"Logical and Piecewise Functions\"\>", 
       3->"\<\"Solving Equations Involving Power Series\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Expand" :> Documentation`HelpLookup["paclet:ref/Expand"], 
          "PiecewiseExpand" :> 
          Documentation`HelpLookup["paclet:ref/PiecewiseExpand"], "Reduce" :> 
          Documentation`HelpLookup["paclet:ref/Reduce"], "Implies" :> 
          Documentation`HelpLookup["paclet:ref/Implies"], "Resolve" :> 
          Documentation`HelpLookup["paclet:ref/Resolve"], "And" :> 
          Documentation`HelpLookup["paclet:ref/And"], "Not" :> 
          Documentation`HelpLookup["paclet:ref/Not"], "Or" :> 
          Documentation`HelpLookup["paclet:ref/Or"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Expand\"\>", 2->"\<\"PiecewiseExpand\"\>", 
       3->"\<\"Reduce\"\>", 4->"\<\"Implies\"\>", 5->"\<\"Resolve\"\>", 
       6->"\<\"And\"\>", 7->"\<\"Not\"\>", 
       8->"\<\"Or\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Transformations" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicTransformations"], 
          "Inequalities" :> 
          Documentation`HelpLookup["paclet:guide/Inequalities"], 
          "Logic & Boolean Algebra" :> 
          Documentation`HelpLookup["paclet:guide/LogicAndBooleanAlgebra"], 
          "Manipulating Equations" :> 
          Documentation`HelpLookup["paclet:guide/ManipulatingEquations"], 
          "Polynomial Systems" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialSystems"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Algebraic Transformations\"\>", 2->"\<\"Inequalities\"\>", 
       3->"\<\"Logic & Boolean Algebra\"\>", 
       4->"\<\"Manipulating Equations\"\>", 
       5->"\<\"Polynomial Systems\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LogicalExpand", "ObjectName",
 CellID->13124],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LogicalExpand",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LogicalExpand"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]expands out expressions containing logical connectives \
such as ",
     Cell[BoxData["&&"], "InlineFormula"],
     " and\[NonBreakingSpace]",
     Cell[BoxData["||"], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16258]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogicalExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogicalExpand"]], "InlineFormula"],
 " applies distributive laws for logical operations. "
}], "Notes",
 CellID->8458],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogicalExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogicalExpand"]], "InlineFormula"],
 " generates ORs of ANDs corresponding to disjunctive normal form, with some \
contractions. "
}], "Notes",
 CellID->17577]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->227338851],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->13113064],

Cell["Expand out logic expressions:", "ExampleText",
 CellID->65129126],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", 
  RowBox[{"p", "&&", 
   RowBox[{"!", 
    RowBox[{"(", 
     RowBox[{"q", "||", "r"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->165989719],

Cell[BoxData[
 RowBox[{"p", "&&", 
  RowBox[{"!", "q"}], "&&", 
  RowBox[{"!", "r"}]}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->58814396]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->155230740],

Cell["\<\
Represent logic expressions as a disjunction of conjunctions (disjunctive \
normal form):\
\>", "ExampleText",
 CellID->541324402],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "||", "b"}], ")"}], "&&", 
   RowBox[{"!", 
    RowBox[{"(", 
     RowBox[{"c", "||", "d", "||", "e"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->445262727],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a", "&&", 
    RowBox[{"!", "c"}], "&&", 
    RowBox[{"!", "d"}], "&&", 
    RowBox[{"!", "e"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{"b", "&&", 
    RowBox[{"!", "c"}], "&&", 
    RowBox[{"!", "d"}], "&&", 
    RowBox[{"!", "e"}]}], ")"}]}]], "Output",
 ImageSize->{285, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->754074]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->105032630],

Cell["Simplify logic expressions:", "ExampleText",
 CellID->360240994],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", 
  RowBox[{"a", "||", 
   RowBox[{"!", "a"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33035831],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2352492]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", 
  RowBox[{"a", "&&", 
   RowBox[{"!", "a"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->47293031],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->325186119]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->538159280],

Cell[TextData[{
 "Expand logic expressions out to forms involving only ",
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Or",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Or"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Not",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Not"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->76780291],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", 
  RowBox[{"Xor", "[", 
   RowBox[{"p", ",", "q", ",", "r"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->863502828],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"p", "&&", "q", "&&", "r"}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{"p", "&&", 
    RowBox[{"!", "q"}], "&&", 
    RowBox[{"!", "r"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{"q", "&&", 
    RowBox[{"!", "p"}], "&&", 
    RowBox[{"!", "r"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{"r", "&&", 
    RowBox[{"!", "p"}], "&&", 
    RowBox[{"!", "q"}]}], ")"}]}]], "Output",
 ImageSize->{419, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->126110708]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->153919072],

Cell["Expand out combinations of equations:", "ExampleText",
 CellID->114736622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "==", "a"}], "&&", 
    RowBox[{"y", "==", "b"}]}], "||", 
   RowBox[{"x", "==", "a"}], "||", 
   RowBox[{"y", "==", "b"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->275801594],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", "a"}], "||", 
  RowBox[{"y", "\[Equal]", "b"}]}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->679848682]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->99331674],

Cell["Get separate equations for different terms in a series:", "ExampleText",
 CellID->163962352],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], "^", "2"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}], "\[Equal]", 
  RowBox[{"2", "+", "x"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31025358],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWM1OwkAQXtoiIKAgoPgLntSgXAxnb3ry4CMgMYFEIgFM9DE0vi92y24t
X4futlDFaBNoZ2fmm5+dzu72tj3uPvTb416nXb8ZtgfdXmdUv34a2kNmgrHE
C2Nsq8rs54n95Pz49Wr/GHvn/6Ycm7AR0H1H6g1Gn4F+DCG1bv8b9mBW3M+A
LgF9BCh54NeA3gE6CfqnwG+5XnmlskCfKPhFBX8f6A2F/KGCX1HwrZD+XzpZ
YOb0xi/ORBTONomc5oDm/KSQS4bAkfIpTXlLzKEh7qiHtBESP0/YixIPZjso
nqD4MM9rXhzLHQctRN0VXq0prPG7+IeYMKcs6bXNCJtUhfi10KNothAlHQkF
cmo/IA5VRYvbxZqjamrxnOB86KGoc0R6r8Q1fDgYJX+DTFdVXikSnayiGfRp
m1tOZfOVg3qbsDp+spY5iuyP8/rf4layk6+uv6oVKzOR8/qqRDGFFvq0R0Qq
a8HtvDF1UJzDVeqdMv6Mwue/1zFlZnD/t1gd0t0Rs49a31GlOKPxzM3/Cv/7
V/gDnawQq7jqzKIXdxVoDkrt9PUri1pn9efAuw/Hs+W8U4weenkpkeGJJlp1
YaTl+Sjapxvq5BzXqYZLcXKTlI5nRcYehJHooeL3CERdjhWZn0J8mQjsKdGq
MjcJmlVq14s2eZ1VSG1n1D3/y/q3CNqLWRD8tEIvI2hqtih5/LZmhtRHP4th
/PPNHKWh+iIjMyP15duOtVISctuOOYz7Cugm0LiTwq9vLV88uJ7gfq8B9AXp
1wDoY6DvFFbOKXqmQ/KaHIJUDfhBVji/AXSTjOUD6HutjLDEJ/wVCBs=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{376, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6698524]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->109439580],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    SuperscriptBox[
     RowBox[{"f", "[", "0", "]"}], "2"]}], "\[Equal]", "0"}], "&&", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"f", "[", "0", "]"}], " ", 
     RowBox[{
      SuperscriptBox["f", "\[Prime]",
       MultilineFunction->None], "[", "0", "]"}]}]}], "\[Equal]", "0"}], "&&",
   
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{
      SuperscriptBox["f", "\[Prime]",
       MultilineFunction->None], "[", "0", "]"}], "2"], "+", 
    RowBox[{
     RowBox[{"f", "[", "0", "]"}], " ", 
     RowBox[{
      SuperscriptBox["f", "\[Prime]\[Prime]",
       MultilineFunction->None], "[", "0", "]"}]}]}], "\[Equal]", 
   "0"}]}]], "Output",
 ImageSize->{391, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->8390342]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->189494608],

Cell["\<\
Convert multi-argument equations and inequalities to two-argument form:\
\>", "ExampleText",
 CellID->457769215],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[LessEqual]", 
   RowBox[{"y", "+", "1"}], "<", "z"}], "&&", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", "1"}], "\[Equal]", 
   RowBox[{
    RowBox[{"y", "^", "2"}], "-", "2"}], "\[Equal]", 
   RowBox[{
    RowBox[{"z", "^", "2"}], "-", "3"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->182130494],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[LessEqual]", 
   RowBox[{"1", "+", "y"}], "<", "z"}], "&&", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["x", "2"]}], "\[Equal]", 
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    SuperscriptBox["y", "2"]}], "\[Equal]", 
   RowBox[{
    RowBox[{"-", "3"}], "+", 
    SuperscriptBox["z", "2"]}]}]}]], "Output",
 ImageSize->{246, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->260837108]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->95425491],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    SuperscriptBox["y", "2"]}], "\[Equal]", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["x", "2"]}]}], "&&", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "3"}], "+", 
    SuperscriptBox["z", "2"]}], "\[Equal]", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["x", "2"]}]}], "&&", 
  RowBox[{
   RowBox[{"1", "+", "y"}], "<", "z"}], "&&", 
  RowBox[{"x", "\[LessEqual]", 
   RowBox[{"1", "+", "y"}]}]}]], "Output",
 ImageSize->{352, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27011659]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->150704095],

Cell[TextData[{
 "Expand negations of ",
 Cell[BoxData[
  ButtonBox["Element",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Element"]], "InlineFormula"],
 " statements:"
}], "ExampleText",
 CellID->240677055],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", 
  RowBox[{"!", 
   RowBox[{"Element", "[", 
    RowBox[{
     RowBox[{"x", "|", "y", "|", "z"}], ",", "Reals"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->94131038],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[NotElement]", "Reals"}], "||", 
  RowBox[{"y", "\[NotElement]", "Reals"}], "||", 
  RowBox[{"z", "\[NotElement]", "Reals"}]}]], "Output",
 ImageSize->{212, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->56362583]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28977029],

Cell["Prove tautologies:", "ExampleText",
 CellID->130208710],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"Implies", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"p", "||", 
       RowBox[{"!", "r"}]}], ")"}], "&&", "s"}], ",", 
    RowBox[{"Implies", "[", 
     RowBox[{
      RowBox[{"r", "&&", "s"}], ",", 
      RowBox[{
       RowBox[{"p", "&&", "q"}], "||", "p"}]}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7932192],

Cell[BoxData[
 RowBox[{"Implies", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"p", "||", 
      RowBox[{"!", "r"}]}], ")"}], "&&", "s"}], ",", 
   RowBox[{"Implies", "[", 
    RowBox[{
     RowBox[{"r", "&&", "s"}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"p", "&&", "q"}], ")"}], "||", "p"}]}], "]"}]}], 
  "]"}]], "Output",
 ImageSize->{345, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->304416306]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", "t", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->279863746],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->268843475]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->728548567],

Cell[TextData[{
 "The output of ",
 Cell[BoxData[
  ButtonBox["LogicalExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogicalExpand"]], "InlineFormula"],
 " is equivalent to the input:"
}], "ExampleText",
 CellID->64294676],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e1", "=", 
  RowBox[{"Implies", "[", 
   RowBox[{
    RowBox[{"Xor", "[", 
     RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "||", "b"}], ")"}], "&&", "c"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->661470581],

Cell[BoxData[
 RowBox[{"Implies", "[", 
  RowBox[{
   RowBox[{"a", "\[Xor]", "b", "\[Xor]", "c"}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "||", "b"}], ")"}], "&&", "c"}]}], "]"}]], "Output",
 ImageSize->{203, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->775006265]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e2", "=", 
  RowBox[{"LogicalExpand", "[", "e1", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->106212172],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a", "&&", "b"}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{"a", "&&", "c"}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{"b", "&&", "c"}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"!", "a"}], "&&", 
    RowBox[{"!", "b"}], "&&", 
    RowBox[{"!", "c"}]}], ")"}]}]], "Output",
 ImageSize->{310, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4496533]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"e1", "\[Equal]", "e2"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->899656842],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"True", ",", "True"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "True"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"True", ",", "True"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "True"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{405, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->411671933]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->999103529],

Cell["De Morgan's laws:", "ExampleText",
 CellID->679542254],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", 
  RowBox[{"!", 
   RowBox[{"(", 
    RowBox[{"a", "||", "b"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->380641729],

Cell[BoxData[
 RowBox[{
  RowBox[{"!", "a"}], "&&", 
  RowBox[{"!", "b"}]}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->266930773]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", 
  RowBox[{"!", 
   RowBox[{"(", 
    RowBox[{"a", "&&", "b"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->168723595],

Cell[BoxData[
 RowBox[{
  RowBox[{"!", "a"}], "||", 
  RowBox[{"!", "b"}]}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->74380392]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28838],

Cell[TextData[{
 "Expand an ",
 Cell[BoxData[
  ButtonBox["Xor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Xor"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " variables will always contain ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["2", 
    RowBox[{"n", "-", "1"}]], TraditionalForm]], "InlineMath"],
 " terms:"
}], "ExampleText",
 CellID->279830978],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LogicalExpand", "[", 
   RowBox[{"Xor", "@@", 
    RowBox[{"Array", "[", 
     RowBox[{
      RowBox[{
       SubscriptBox["x", "#"], "&"}], ",", "6"}], "]"}]}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21325634],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{580, 244},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->54851641]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->481819566],

Cell[BoxData["32"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->224472499]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1471],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Expand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Expand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PiecewiseExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PiecewiseExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Implies",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Implies"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Resolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Resolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["And",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/And"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Not",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Not"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Or",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Or"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30600]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26543],

Cell[TextData[ButtonBox["Relational and Logical Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RelationalAndLogicalOperators"]], "Tutorials",
 CellID->10925],

Cell[TextData[ButtonBox["Logical and Piecewise Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LogicalAndPiecewiseFunctions"]], "Tutorials",
 CellID->30964],

Cell[TextData[ButtonBox["Solving Equations Involving Power Series",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SolvingEquationsInvolvingPowerSeries"]], "Tutorials",
 CellID->13840]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->45241870],

Cell[TextData[ButtonBox["Algebraic Transformations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicTransformations"]], "MoreAbout",
 CellID->633100460],

Cell[TextData[ButtonBox["Inequalities",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Inequalities"]], "MoreAbout",
 CellID->55426639],

Cell[TextData[ButtonBox["Logic & Boolean Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LogicAndBooleanAlgebra"]], "MoreAbout",
 CellID->178025682],

Cell[TextData[ButtonBox["Manipulating Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ManipulatingEquations"]], "MoreAbout",
 CellID->1024438090],

Cell[TextData[ButtonBox["Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialSystems"]], "MoreAbout",
 CellID->304831862]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LogicalExpand - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 58, 42.7738276}", "context" -> "System`", 
    "keywords" -> {
     "Boolean algebra", "Boolean expansion", "Boolean expressions", "CNF", 
      "conjunctive normal form", "De Morgan's laws", 
      "disjunctive normal form", "DNF", "equations", "expansion", 
      "propositional logic", "simplification", "switching algebra", 
      "two-level logic"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LogicalExpand[expr] expands out expressions containing logical \
connectives such as && and ||. ", "synonyms" -> {"logical expand"}, "title" -> 
    "LogicalExpand", "type" -> "Symbol", "uri" -> "ref/LogicalExpand"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5838, 170, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->227338851]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 35153, 1201}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3462, 76, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4085, 103, 51, 1, 70, "ObjectName",
 CellID->13124],
Cell[4139, 106, 649, 20, 70, "Usage",
 CellID->16258]
}, Open  ]],
Cell[CellGroupData[{
Cell[4825, 131, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5303, 148, 227, 7, 70, "Notes",
 CellID->8458],
Cell[5533, 157, 268, 8, 70, "Notes",
 CellID->17577]
}, Closed]],
Cell[CellGroupData[{
Cell[5838, 170, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->227338851],
Cell[CellGroupData[{
Cell[6223, 184, 147, 5, 70, "ExampleSection",
 CellID->13113064],
Cell[6373, 191, 71, 1, 70, "ExampleText",
 CellID->65129126],
Cell[CellGroupData[{
Cell[6469, 196, 204, 7, 28, "Input",
 CellID->165989719],
Cell[6676, 205, 227, 8, 36, "Output",
 CellID->58814396]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6952, 219, 220, 7, 70, "ExampleSection",
 CellID->155230740],
Cell[7175, 228, 140, 4, 70, "ExampleText",
 CellID->541324402],
Cell[CellGroupData[{
Cell[7340, 236, 265, 9, 70, "Input",
 CellID->445262727],
Cell[7608, 247, 439, 16, 36, "Output",
 CellID->754074]
}, Open  ]],
Cell[8062, 266, 125, 3, 70, "ExampleDelimiter",
 CellID->105032630],
Cell[8190, 271, 70, 1, 70, "ExampleText",
 CellID->360240994],
Cell[CellGroupData[{
Cell[8285, 276, 151, 5, 70, "Input",
 CellID->33035831],
Cell[8439, 283, 159, 5, 36, "Output",
 CellID->2352492]
}, Open  ]],
Cell[CellGroupData[{
Cell[8635, 293, 151, 5, 70, "Input",
 CellID->47293031],
Cell[8789, 300, 162, 5, 36, "Output",
 CellID->325186119]
}, Open  ]],
Cell[8966, 308, 125, 3, 70, "ExampleDelimiter",
 CellID->538159280],
Cell[9094, 313, 458, 18, 70, "ExampleText",
 CellID->76780291],
Cell[CellGroupData[{
Cell[9577, 335, 173, 5, 70, "Input",
 CellID->863502828],
Cell[9753, 342, 560, 20, 36, "Output",
 CellID->126110708]
}, Open  ]],
Cell[10328, 365, 125, 3, 70, "ExampleDelimiter",
 CellID->153919072],
Cell[10456, 370, 80, 1, 70, "ExampleText",
 CellID->114736622],
Cell[CellGroupData[{
Cell[10561, 375, 271, 9, 70, "Input",
 CellID->275801594],
Cell[10835, 386, 241, 8, 36, "Output",
 CellID->679848682]
}, Open  ]],
Cell[11091, 397, 124, 3, 70, "ExampleDelimiter",
 CellID->99331674],
Cell[11218, 402, 98, 1, 70, "ExampleText",
 CellID->163962352],
Cell[CellGroupData[{
Cell[11341, 407, 295, 10, 70, "Input",
 CellID->31025358],
Cell[11639, 419, 1059, 21, 70, "Output",
 Evaluatable->False,
 CellID->6698524]
}, Open  ]],
Cell[CellGroupData[{
Cell[12735, 445, 109, 3, 70, "Input",
 CellID->109439580],
Cell[12847, 450, 907, 32, 36, "Output",
 CellID->8390342]
}, Open  ]],
Cell[13769, 485, 125, 3, 70, "ExampleDelimiter",
 CellID->189494608],
Cell[13897, 490, 122, 3, 70, "ExampleText",
 CellID->457769215],
Cell[CellGroupData[{
Cell[14044, 497, 355, 12, 70, "Input",
 CellID->182130494],
Cell[14402, 511, 507, 18, 36, "Output",
 CellID->260837108]
}, Open  ]],
Cell[CellGroupData[{
Cell[14946, 534, 108, 3, 70, "Input",
 CellID->95425491],
Cell[15057, 539, 648, 24, 36, "Output",
 CellID->27011659]
}, Open  ]],
Cell[15720, 566, 125, 3, 70, "ExampleDelimiter",
 CellID->150704095],
Cell[15848, 571, 212, 8, 70, "ExampleText",
 CellID->240677055],
Cell[CellGroupData[{
Cell[16085, 583, 229, 8, 70, "Input",
 CellID->94131038],
Cell[16317, 593, 309, 9, 36, "Output",
 CellID->56362583]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16675, 608, 226, 7, 70, "ExampleSection",
 CellID->28977029],
Cell[16904, 617, 61, 1, 70, "ExampleText",
 CellID->130208710],
Cell[CellGroupData[{
Cell[16990, 622, 398, 14, 70, "Input",
 CellID->7932192],
Cell[17391, 638, 487, 18, 36, "Output",
 CellID->304416306]
}, Open  ]],
Cell[CellGroupData[{
Cell[17915, 661, 109, 3, 70, "Input",
 CellID->279863746],
Cell[18027, 666, 161, 5, 36, "Output",
 CellID->268843475]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18237, 677, 237, 7, 70, "ExampleSection",
 CellID->728548567],
Cell[18477, 686, 233, 8, 70, "ExampleText",
 CellID->64294676],
Cell[CellGroupData[{
Cell[18735, 698, 299, 10, 70, "Input",
 CellID->661470581],
Cell[19037, 710, 336, 11, 36, "Output",
 CellID->775006265]
}, Open  ]],
Cell[CellGroupData[{
Cell[19410, 726, 134, 4, 70, "Input",
 CellID->106212172],
Cell[19547, 732, 465, 17, 36, "Output",
 CellID->4496533]
}, Open  ]],
Cell[CellGroupData[{
Cell[20049, 754, 504, 17, 70, "Input",
 CellID->899656842],
Cell[20556, 773, 538, 19, 36, "Output",
 CellID->411671933]
}, Open  ]],
Cell[21109, 795, 125, 3, 70, "ExampleDelimiter",
 CellID->999103529],
Cell[21237, 800, 60, 1, 70, "ExampleText",
 CellID->679542254],
Cell[CellGroupData[{
Cell[21322, 805, 177, 6, 70, "Input",
 CellID->380641729],
Cell[21502, 813, 217, 8, 36, "Output",
 CellID->266930773]
}, Open  ]],
Cell[CellGroupData[{
Cell[21756, 826, 177, 6, 70, "Input",
 CellID->168723595],
Cell[21936, 834, 216, 8, 36, "Output",
 CellID->74380392]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22201, 848, 224, 7, 70, "ExampleSection",
 CellID->28838],
Cell[22428, 857, 412, 16, 70, "ExampleText",
 CellID->279830978],
Cell[CellGroupData[{
Cell[22865, 877, 285, 10, 70, "Input",
 CellID->21325634],
Cell[23153, 889, 6032, 103, 70, "Output",
 Evaluatable->False,
 CellID->54851641]
}, Open  ]],
Cell[CellGroupData[{
Cell[29222, 997, 102, 3, 70, "Input",
 CellID->481819566],
Cell[29327, 1002, 159, 5, 36, "Output",
 CellID->224472499]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29547, 1014, 310, 9, 70, "SeeAlsoSection",
 CellID->1471],
Cell[29860, 1025, 1891, 71, 70, "SeeAlso",
 CellID->30600]
}, Open  ]],
Cell[CellGroupData[{
Cell[31788, 1101, 314, 9, 70, "TutorialsSection",
 CellID->26543],
Cell[32105, 1112, 172, 3, 70, "Tutorials",
 CellID->10925],
Cell[32280, 1117, 170, 3, 70, "Tutorials",
 CellID->30964],
Cell[32453, 1122, 190, 4, 70, "Tutorials",
 CellID->13840]
}, Open  ]],
Cell[CellGroupData[{
Cell[32680, 1131, 318, 9, 70, "MoreAboutSection",
 CellID->45241870],
Cell[33001, 1142, 161, 3, 70, "MoreAbout",
 CellID->633100460],
Cell[33165, 1147, 135, 3, 70, "MoreAbout",
 CellID->55426639],
Cell[33303, 1152, 157, 3, 70, "MoreAbout",
 CellID->178025682],
Cell[33463, 1157, 156, 3, 70, "MoreAbout",
 CellID->1024438090],
Cell[33622, 1162, 147, 3, 70, "MoreAbout",
 CellID->304831862]
}, Open  ]],
Cell[33784, 1168, 27, 0, 70, "History"],
Cell[33814, 1170, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

