(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29503,       1071]
NotebookOptionsPosition[     23536,        864]
NotebookOutlinePosition[     24899,        903]
CellTagsIndexPosition[     24814,        898]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Patterns and Transformation Rules" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PatternsAndTransformationRules"], 
          "String Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/StringPatterns"], 
          "Working with String Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/WorkingWithStringPatternsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Patterns and Transformation Rules\"\>", 
       2->"\<\"String Patterns\"\>", 
       3->"\<\"Working with String Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Shortest" :> Documentation`HelpLookup["paclet:ref/Shortest"], 
          "BlankSequence" :> 
          Documentation`HelpLookup["paclet:ref/BlankSequence"], "Repeated" :> 
          Documentation`HelpLookup["paclet:ref/Repeated"], "StringExpression" :> 
          Documentation`HelpLookup["paclet:ref/StringExpression"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Shortest\"\>", 
       2->"\<\"BlankSequence\"\>", 3->"\<\"Repeated\"\>", 
       4->"\<\"StringExpression\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Patterns" :> Documentation`HelpLookup["paclet:guide/Patterns"],
           "Rules & Patterns" :> 
          Documentation`HelpLookup["paclet:guide/RulesAndPatterns"], 
          "String Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/StringManipulation"], 
          "String Patterns" :> 
          Documentation`HelpLookup["paclet:guide/StringPatterns"], 
          "New in 6.0: Core Language" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60CoreLanguage"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Patterns\"\>", 
       2->"\<\"Rules & Patterns\"\>", 3->"\<\"String Manipulation\"\>", 
       4->"\<\"String Patterns\"\>", 
       5->"\<\"New in 6.0: Core Language\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Longest", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Longest",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Longest"], "[", 
       StyleBox["p", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]is a pattern object that matches the longest sequence \
consistent with the pattern ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31395]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Longest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Longest"]], "InlineFormula"],
 " works for both ordinary expression patterns and string patterns."
}], "Notes",
 CellID->29061],

Cell[TextData[{
 "If several ",
 Cell[BoxData[
  ButtonBox["Longest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Longest"]], "InlineFormula"],
 " objects occur in the same expression, those that appear first are given \
higher priority to match longest sequences."
}], "Notes",
 CellID->11968],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Longest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Longest"], "[", 
   RowBox[{
    StyleBox["p", "TI"], ",", 
    StyleBox["pri", "TI"]}], "]"}]], "InlineFormula"],
 " is given priority ",
 Cell[BoxData[
  StyleBox["pri", "TI"]], "InlineFormula"],
 " to be the longest sequence. Matches for longest sequences are tried first \
for ",
 Cell[BoxData[
  ButtonBox["Longest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Longest"]], "InlineFormula"],
 " objects with higher priorities."
}], "Notes",
 CellID->6492],

Cell[TextData[{
 "Priorities can be any expression, and are ordered in standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  ButtonBox["Sort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sort"]], "InlineFormula"],
 " order. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Longest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Longest"], "[", 
   StyleBox["p", "TI"], "]"}]], "InlineFormula"],
 " specifies the highest possible priority."
}], "Notes",
 CellID->6866],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Longest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Longest"]], "InlineFormula"],
 " objects with equal priorities are tried in the order they appear in the \
expression."
}], "Notes",
 CellID->6654],

Cell[TextData[{
 "If no explicit ",
 Cell[BoxData[
  ButtonBox["Longest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Longest"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Shortest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Shortest"]], "InlineFormula"],
 " is given, ordinary expression patterns are normally effectively assumed to \
be ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Shortest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Shortest"], "[", 
   StyleBox["p", "TI"], "]"}]], "InlineFormula"],
 ", while string patterns are assumed to be ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Longest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Longest"], "[", 
   StyleBox["p", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31615],

Cell[TextData[{
 "For ordinary expressions, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Longest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Longest"], "[", 
   StyleBox["p", "TI"], "]"}]], "InlineFormula"],
 " specifies that not just ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " itself, but also all parts of ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " should match the longest sequences."
}], "Notes",
 CellID->15584]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->226002752],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->531465210],

Cell[TextData[{
 "Require that ",
 Cell[BoxData["y__"], "InlineFormula"],
 " matches the longest sequence it can:"
}], "ExampleText",
 CellID->5572],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}], 
   "}"}], "/.", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x__", ",", 
     RowBox[{"Longest", "[", "y__", "]"}], ",", "z__"}], "}"}], "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "x", "}"}], ",", 
     RowBox[{"{", "y", "}"}], ",", 
     RowBox[{"{", "z", "}"}]}], "}"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29385],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "a", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], ",", 
   RowBox[{"{", "g", "}"}]}], "}"}]], "Output",
 ImageSize->{177, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38905504]
}, Open  ]],

Cell["\<\
The default is to have earlier patterns match shortest sequences:\
\>", "ExampleText",
 CellID->1652449782],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}], 
   "}"}], "/.", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x__", ",", "y__", ",", "z__"}], "}"}], "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "x", "}"}], ",", 
     RowBox[{"{", "y", "}"}], ",", 
     RowBox[{"{", "z", "}"}]}], "}"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15382],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "a", "}"}], ",", 
   RowBox[{"{", "b", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d", ",", "e", ",", "f", ",", "g"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{177, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->356723877]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->84901352],

Cell["Use priorities to affect ambiguous choices:", "ExampleText",
 CellID->116376390],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}], 
   "}"}], "/.", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Longest", "[", 
      RowBox[{"x__", ",", "2"}], "]"}], ",", 
     RowBox[{"Longest", "[", 
      RowBox[{"y__", ",", "1"}], "]"}]}], "}"}], "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "x", "}"}], ",", 
     RowBox[{"{", "y", "}"}]}], "}"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->90467406],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
   ",", 
   RowBox[{"{", "g", "}"}]}], "}"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->329947115]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}], 
   "}"}], "/.", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Longest", "[", 
      RowBox[{"x__", ",", "1"}], "]"}], ",", 
     RowBox[{"Longest", "[", 
      RowBox[{"y__", ",", "2"}], "]"}]}], "}"}], "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "x", "}"}], ",", 
     RowBox[{"{", "y", "}"}]}], "}"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->33142756],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "a", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->81448930]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19475243],

Cell["Find the longest sequence of integers:", "ExampleText",
 CellID->941757104],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
   "x", ",", "3", ",", "5", ",", "7", ",", "y", ",", "1", ",", "2", ",", "3", 
    ",", "4", ",", "z"}], "}"}], "/.", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a___", ",", 
     RowBox[{"Longest", "[", "b__Integer", "]"}], ",", "c___"}], "}"}], "->", 
   
   RowBox[{"{", "b", "}"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1983506511],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->255205934]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->604413080],

Cell["Consider the following variable length argument function:", \
"ExampleText",
 CellID->284921288],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", "b_", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "b"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->737840474],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->219106770],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"g", "[", "1", "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{"1", ",", "2"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->23232699],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->656747563]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Longest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Longest"]], "InlineFormula"],
 " to express it as one pattern:"
}], "ExampleText",
 CellID->167731487],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"Longest", "[", 
     RowBox[{
      RowBox[{"a_:", "x"}], ",", "1"}], "]"}], ",", 
    RowBox[{"Longest", "[", 
     RowBox[{"b_", ",", "2"}], "]"}]}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b"}], "}"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->133931668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "1", "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"1", ",", "2"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->31659415],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->7221679]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10325598],

Cell["\<\
For strings, the default is to have earlier patterns match longest character \
sequences:\
\>", "ExampleText",
 CellID->1532957833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<abcdefgef\>\"", ",", 
   RowBox[{
    RowBox[{"a__", "~~", "b__"}], "\[Rule]", 
    RowBox[{"a", "~~", "\"\<[\>\"", "~~", "b", " ", "~~", "\"\<]\>\""}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1998103102],

Cell[BoxData["\<\"abcdefge[f]\"\>"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->627387995]
}, Open  ]],

Cell["This is equivalent:", "ExampleText",
 CellID->726998250],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<abcdefgef\>\"", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Longest", "[", "a__", "]"}], "~~", "b__"}], "\[Rule]", 
    RowBox[{"a", "~~", "\"\<[\>\"", "~~", "b", " ", "~~", "\"\<]\>\""}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1752517095],

Cell[BoxData["\<\"abcdefge[f]\"\>"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->11814659]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->103214493],

Cell["Priorities are not supported in string expressions:", "ExampleText",
 CellID->1537048656],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<abcdefg\>\"", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Longest", "[", 
      RowBox[{"x__", ",", "1"}], "]"}], "~~", "y__"}], "\[Rule]", 
    RowBox[{"x", "~~", "\"\<X\>\"", "~~", "y"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1095971629],

Cell[BoxData[
 RowBox[{
  RowBox[{"StringExpression", "::", "\<\"invld\"\>"}], ":", 
  " ", "\<\"Element \\!\\(Longest[\\(\\(x__, 1\\)\\)]\\) is not a valid \
string or pattern element in \\!\\(\\(\\(Longest[\\(\\(x__, 1\\)\\)]\\)\\) ~~ \
y__\\).\"\>"}]], "Message", "MSG",
 CellID->651456504],

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\<\"abcdefg\"\>", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Longest", "[", 
      RowBox[{"x__", ",", "1"}], "]"}], "~~", "y__"}], "\[Rule]", 
    RowBox[{"x", "~~", "\<\"X\"\>", "~~", "y"}]}]}], "]"}]], "Output",
 ImageSize->{393, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->272100262]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32313],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Shortest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Shortest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BlankSequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BlankSequence"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Repeated",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Repeated"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringExpression"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14978]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32322],

Cell[TextData[ButtonBox["Patterns and Transformation Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PatternsAndTransformationRules"]], "Tutorials",
 CellID->244552785],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "Tutorials",
 CellID->8153],

Cell[TextData[ButtonBox["Working with String Patterns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/WorkingWithStringPatternsOverview"]], "Tutorials",
 CellID->22514736]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->568712669],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Patterns"]], "MoreAbout",
 CellID->370952939],

Cell[TextData[ButtonBox["Rules & Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RulesAndPatterns"]], "MoreAbout",
 CellID->281779371],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout",
 CellID->941989583],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringPatterns"]], "MoreAbout",
 CellID->198372864],

Cell[TextData[ButtonBox["New in 6.0: Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "MoreAbout",
 CellID->310403807]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Longest - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 59, 8.8838710}", "context" -> "System`", 
    "keywords" -> {
     "disambiguating pattern matches", "greedy match", 
      "longest pattern match", "longest sequence", 
      "priorities on pattern matches"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Longest[p] is a pattern object that matches the longest sequence \
consistent with the pattern p. ", "synonyms" -> {}, "title" -> "Longest", 
    "type" -> "Symbol", "uri" -> "ref/Longest"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9472, 297, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->226002752]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24671, 891}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2992, 67, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3615, 94, 1572, 37, 70, "ObjectNameGrid"],
Cell[5190, 133, 601, 19, 70, "Usage",
 CellID->31395]
}, Open  ]],
Cell[CellGroupData[{
Cell[5828, 157, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6306, 174, 230, 7, 70, "Notes",
 CellID->29061],
Cell[6539, 183, 299, 9, 70, "Notes",
 CellID->11968],
Cell[6841, 194, 581, 20, 70, "Notes",
 CellID->6492],
Cell[7425, 216, 502, 18, 70, "Notes",
 CellID->6866],
Cell[7930, 236, 250, 8, 70, "Notes",
 CellID->6654],
Cell[8183, 246, 786, 28, 70, "Notes",
 CellID->31615],
Cell[8972, 276, 463, 16, 70, "Notes",
 CellID->15584]
}, Closed]],
Cell[CellGroupData[{
Cell[9472, 297, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->226002752],
Cell[CellGroupData[{
Cell[9857, 311, 148, 5, 70, "ExampleSection",
 CellID->531465210],
Cell[10008, 318, 148, 5, 70, "ExampleText",
 CellID->5572],
Cell[CellGroupData[{
Cell[10181, 327, 453, 15, 28, "Input",
 CellID->29385],
Cell[10637, 344, 340, 11, 36, "Output",
 CellID->38905504]
}, Open  ]],
Cell[10992, 358, 117, 3, 70, "ExampleText",
 CellID->1652449782],
Cell[CellGroupData[{
Cell[11134, 365, 416, 14, 28, "Input",
 CellID->15382],
Cell[11553, 381, 344, 12, 36, "Output",
 CellID->356723877]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11946, 399, 219, 7, 70, "ExampleSection",
 CellID->84901352],
Cell[12168, 408, 86, 1, 70, "ExampleText",
 CellID->116376390],
Cell[CellGroupData[{
Cell[12279, 413, 499, 17, 70, "Input",
 CellID->90467406],
Cell[12781, 432, 321, 11, 36, "Output",
 CellID->329947115]
}, Open  ]],
Cell[CellGroupData[{
Cell[13139, 448, 499, 17, 70, "Input",
 CellID->33142756],
Cell[13641, 467, 319, 11, 36, "Output",
 CellID->81448930]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14009, 484, 226, 7, 70, "ExampleSection",
 CellID->19475243],
Cell[14238, 493, 81, 1, 70, "ExampleText",
 CellID->941757104],
Cell[CellGroupData[{
Cell[14344, 498, 393, 13, 70, "Input",
 CellID->1983506511],
Cell[14740, 513, 223, 7, 36, "Output",
 CellID->255205934]
}, Open  ]],
Cell[14978, 523, 125, 3, 70, "ExampleDelimiter",
 CellID->604413080],
Cell[15106, 528, 102, 2, 70, "ExampleText",
 CellID->284921288],
Cell[15211, 532, 190, 7, 70, "Input",
 CellID->737840474],
Cell[15404, 541, 216, 8, 70, "Input",
 CellID->219106770],
Cell[CellGroupData[{
Cell[15645, 553, 197, 7, 70, "Input",
 CellID->23232699],
Cell[15845, 562, 302, 11, 36, "Output",
 CellID->656747563]
}, Open  ]],
Cell[16162, 576, 214, 8, 70, "ExampleText",
 CellID->167731487],
Cell[16379, 586, 341, 12, 70, "Input",
 CellID->133931668],
Cell[CellGroupData[{
Cell[16745, 602, 197, 7, 70, "Input",
 CellID->31659415],
Cell[16945, 611, 300, 11, 36, "Output",
 CellID->7221679]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17294, 628, 236, 7, 70, "ExampleSection",
 CellID->10325598],
Cell[17533, 637, 141, 4, 70, "ExampleText",
 CellID->1532957833],
Cell[CellGroupData[{
Cell[17699, 645, 281, 8, 70, "Input",
 CellID->1998103102],
Cell[17983, 655, 176, 5, 36, "Output",
 CellID->627387995]
}, Open  ]],
Cell[18174, 663, 62, 1, 70, "ExampleText",
 CellID->726998250],
Cell[CellGroupData[{
Cell[18261, 668, 318, 9, 70, "Input",
 CellID->1752517095],
Cell[18582, 679, 175, 5, 36, "Output",
 CellID->11814659]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18806, 690, 230, 7, 70, "ExampleSection",
 CellID->103214493],
Cell[19039, 699, 95, 1, 70, "ExampleText",
 CellID->1537048656],
Cell[CellGroupData[{
Cell[19159, 704, 316, 9, 70, "Input",
 CellID->1095971629],
Cell[19478, 715, 293, 6, 70, "Message",
 CellID->651456504],
Cell[19774, 723, 404, 12, 36, "Output",
 CellID->272100262]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20239, 742, 311, 9, 70, "SeeAlsoSection",
 CellID->32313],
Cell[20553, 753, 967, 35, 70, "SeeAlso",
 CellID->14978]
}, Open  ]],
Cell[CellGroupData[{
Cell[21557, 793, 314, 9, 70, "TutorialsSection",
 CellID->32322],
Cell[21874, 804, 178, 3, 70, "Tutorials",
 CellID->244552785],
Cell[22055, 809, 139, 3, 70, "Tutorials",
 CellID->8153],
Cell[22197, 814, 178, 4, 70, "Tutorials",
 CellID->22514736]
}, Open  ]],
Cell[CellGroupData[{
Cell[22412, 823, 319, 9, 70, "MoreAboutSection",
 CellID->568712669],
Cell[22734, 834, 128, 3, 70, "MoreAbout",
 CellID->370952939],
Cell[22865, 839, 144, 3, 70, "MoreAbout",
 CellID->281779371],
Cell[23012, 844, 149, 3, 70, "MoreAbout",
 CellID->941989583],
Cell[23164, 849, 141, 3, 70, "MoreAbout",
 CellID->198372864],
Cell[23308, 854, 156, 3, 70, "MoreAbout",
 CellID->310403807]
}, Open  ]],
Cell[23479, 860, 27, 0, 70, "History"],
Cell[23509, 862, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

