(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25052,        848]
NotebookOptionsPosition[     20504,        690]
NotebookOutlinePosition[     21906,        729]
CellTagsIndexPosition[     21821,        724]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Precision" :> 
          Documentation`HelpLookup["paclet:tutorial/NumericalPrecision"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Numerical Precision\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Precision" :> Documentation`HelpLookup["paclet:ref/Precision"],
           "NumberQ" :> Documentation`HelpLookup["paclet:ref/NumberQ"], 
          "InexactNumberQ" :> 
          Documentation`HelpLookup["paclet:ref/InexactNumberQ"], 
          "MachinePrecision" :> 
          Documentation`HelpLookup["paclet:ref/MachinePrecision"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Precision\"\>", 
       2->"\<\"NumberQ\"\>", 3->"\<\"InexactNumberQ\"\>", 
       4->"\<\"MachinePrecision\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Atomic Elements of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AtomicElementsOfExpressions"], 
          "Precision & Accuracy Control" :> 
          Documentation`HelpLookup[
           "paclet:guide/PrecisionAndAccuracyControl"], 
          "Representation of Numbers" :> 
          Documentation`HelpLookup["paclet:guide/RepresentationOfNumbers"], 
          "Testing Expressions" :> 
          Documentation`HelpLookup["paclet:guide/TestingExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Atomic Elements of Expressions\"\>", 
       2->"\<\"Precision & Accuracy Control\"\>", 
       3->"\<\"Representation of Numbers\"\>", 
       4->"\<\"Testing Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MachineNumberQ", "ObjectName",
 CellID->17713],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MachineNumberQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MachineNumberQ"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is a machine\[Hyphen]precision real or complex number, and returns ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18958]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->135329310],

Cell["Check whether numbers are machine numbers or not.", "ExampleText",
 CellID->59581625],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MachineNumberQ", "[", 
  RowBox[{"Sin", "[", "1000.", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->274022047],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14650529]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MachineNumberQ", "[", 
  RowBox[{"Exp", "[", "1000.", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->131917819],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26842565]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->433032014],

Cell["Complex numbers:", "ExampleText",
 CellID->197259403],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MachineNumberQ", "[", 
  RowBox[{"1.", "+", 
   RowBox[{"0.", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->254331703],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->977264]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MachineNumberQ", "[", 
  RowBox[{"1.", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32901162],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->783960983]
}, Open  ]],

Cell["\<\
Complex numbers are only considered machine numbers if both real and \
imaginary parts are:\
\>", "ExampleText",
 CellID->223267730],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"r", ",", "i"}], "}"}], "=", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", "#", "]"}], ",", 
      RowBox[{"Im", "[", "#", "]"}]}], "}"}], "&"}], "[", 
   RowBox[{"1.", "+", "I"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->24675724],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.`", ",", "1"}], "}"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->624906518]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"MachineNumberQ", ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "i"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->311901840],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "False"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->438327155]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->394926114],

Cell["\<\
Solve a differential equation, stopping when out of the range of machine \
numbers:\
\>", "ExampleText",
 CellID->70602724],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "''"}], "[", "t", "]"}], "-", 
       RowBox[{"10", 
        RowBox[{
         RowBox[{"x", "'"}], "[", "t", "]"}]}], "+", " ", 
       RowBox[{"x", "[", "t", "]"}]}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
   "x", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<EventLocator\>\"", ",", 
      RowBox[{"\"\<Event\>\"", "\[RuleDelayed]", 
       RowBox[{"Not", "[", 
        RowBox[{"MachineNumberQ", "[", 
         RowBox[{"x", "[", "t", "]"}], "]"}], "]"}]}], ",", 
      RowBox[{"\"\<EventAction\>\"", "\[RuleDelayed]", 
       RowBox[{"Throw", "[", 
        RowBox[{
         RowBox[{"end", "=", "t"}], ",", "\"\<StopIntegration\>\""}], 
        "]"}]}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->863446480],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "72.16474221369002`"}], "}"}], "}"}], 
       ",", "\<\"<>\"\>"}], "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{344, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->485834346]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Abs", "[", 
     RowBox[{"First", "[", 
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], " ", "/.", " ", "%"}], "]"}], "]"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "end"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->218082341],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->105901763]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->96435367],

Cell[TextData[{
 "Any machine number has precision given as ",
 Cell[BoxData[
  ButtonBox["MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MachinePrecision"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->452634446],

Cell[BoxData[
 RowBox[{
  RowBox[{"xl", "=", 
   RowBox[{
    RowBox[{"RandomReal", "[", 
     RowBox[{"1", ",", "10"}], "]"}], "*", 
    RowBox[{"10", "^", 
     RowBox[{"RandomInteger", "[", 
      RowBox[{"400", ",", "10"}], "]"}]}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->132741055],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"MachineNumberQ", "[", "x", "]"}], ",", 
       RowBox[{"Precision", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "xl"}], "}"}]}], "]"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<x\>\"", ",", "\"\<Machine number\>\"", ",", "\"\<Precision\>\""}],
        "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19889240],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      StyleBox["\[Null]",
       ShowStringCharacters->False], 
      TagBox["\<\"x\"\>",
       HoldForm], 
      TagBox["\<\"Machine number\"\>",
       HoldForm], 
      TagBox["\<\"Precision\"\>",
       HoldForm]},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], 
      "2.01389330888875450753516815893817`15.954589770191005*^350", "False", 
      "15.954589770191005`"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], 
      "8.993491990824364901158105567`15.954589770191005*^355", "False", 
      "15.954589770191005`"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], 
      "3.170124691513769299433533888077363`15.954589770191005*^351", "False", 
      "15.954589770191005`"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], 
      "8.915225771349844`*^217", "True", "MachinePrecision"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], 
      "7.1340372463527712554309800907504`15.954589770191005*^311", "False", 
      "15.954589770191005`"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], 
      "9.422299243392196`*^51", "True", "MachinePrecision"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], 
      "5.24583943800023266845755643`15.954589770191005*^392", "False", 
      "15.954589770191005`"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], 
      "6.908728132114548`*^148", "True", "MachinePrecision"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], 
      "5.77362851381676644990648128441535`15.954589770191005*^340", "False", 
      "15.954589770191005`"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], 
      "8.764254023162618`*^248", "True", "MachinePrecision"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxDividers->{
     "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
      "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$4984834]]]], "Output",
 ImageSize->{399, 193},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TableForm=",
 CellID->811619953]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1200],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Precision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Precision"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InexactNumberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InexactNumberQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MachinePrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MachinePrecision"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26058]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17578],

Cell[TextData[ButtonBox["Numerical Precision",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalPrecision"]], "Tutorials",
 CellID->8365]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->571378832],

Cell[TextData[ButtonBox["Atomic Elements of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AtomicElementsOfExpressions"]], "MoreAbout",
 CellID->550709301],

Cell[TextData[ButtonBox["Precision & Accuracy Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecisionAndAccuracyControl"]], "MoreAbout",
 CellID->102200314],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "MoreAbout",
 CellID->618800420],

Cell[TextData[ButtonBox["Testing Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TestingExpressions"]], "MoreAbout",
 CellID->241286558]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MachineNumberQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 59, 17.9466030}", "context" -> "System`", 
    "keywords" -> {
     "machine real number", "machine complex number", 
      "test for floating point number", "double precision number test"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "MachineNumberQ[expr] returns True if expr is a machine-precision real or \
complex number, and returns False otherwise. ", 
    "synonyms" -> {"machine number q"}, "title" -> "MachineNumberQ", "type" -> 
    "Symbol", "uri" -> "ref/MachineNumberQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4246, 125, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21686, 717}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2631, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3254, 89, 52, 1, 70, "ObjectName",
 CellID->17713],
Cell[3309, 92, 900, 28, 70, "Usage",
 CellID->18958]
}, Open  ]],
Cell[CellGroupData[{
Cell[4246, 125, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4623, 139, 148, 5, 70, "ExampleSection",
 CellID->135329310],
Cell[4774, 146, 91, 1, 70, "ExampleText",
 CellID->59581625],
Cell[CellGroupData[{
Cell[4890, 151, 144, 4, 28, "Input",
 CellID->274022047],
Cell[5037, 157, 160, 5, 36, "Output",
 CellID->14650529]
}, Open  ]],
Cell[CellGroupData[{
Cell[5234, 167, 144, 4, 28, "Input",
 CellID->131917819],
Cell[5381, 173, 161, 5, 36, "Output",
 CellID->26842565]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5591, 184, 220, 7, 70, "ExampleSection",
 CellID->433032014],
Cell[5814, 193, 59, 1, 70, "ExampleText",
 CellID->197259403],
Cell[CellGroupData[{
Cell[5898, 198, 154, 5, 70, "Input",
 CellID->254331703],
Cell[6055, 205, 158, 5, 36, "Output",
 CellID->977264]
}, Open  ]],
Cell[CellGroupData[{
Cell[6250, 215, 133, 4, 70, "Input",
 CellID->32901162],
Cell[6386, 221, 162, 5, 36, "Output",
 CellID->783960983]
}, Open  ]],
Cell[6563, 229, 142, 4, 70, "ExampleText",
 CellID->223267730],
Cell[CellGroupData[{
Cell[6730, 237, 327, 12, 70, "Input",
 CellID->24675724],
Cell[7060, 251, 205, 7, 36, "Output",
 CellID->624906518]
}, Open  ]],
Cell[CellGroupData[{
Cell[7302, 263, 184, 6, 70, "Input",
 CellID->311901840],
Cell[7489, 271, 210, 7, 36, "Output",
 CellID->438327155]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[7748, 284, 227, 7, 70, "ExampleSection",
 CellID->394926114],
Cell[7978, 293, 133, 4, 70, "ExampleText",
 CellID->70602724],
Cell[CellGroupData[{
Cell[8136, 301, 1141, 34, 70, "Input",
 CellID->863446480],
Cell[9280, 337, 482, 17, 36, "Output",
 CellID->485834346]
}, Open  ]],
Cell[CellGroupData[{
Cell[9799, 359, 416, 13, 70, "Input",
 CellID->218082341],
Cell[10218, 374, 2352, 43, 70, "Output",
 Evaluatable->False,
 CellID->105901763]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12619, 423, 236, 7, 70, "ExampleSection",
 CellID->96435367],
Cell[12858, 432, 241, 8, 70, "ExampleText",
 CellID->452634446],
Cell[13102, 442, 300, 10, 70, "Input",
 CellID->132741055],
Cell[CellGroupData[{
Cell[13427, 456, 630, 20, 70, "Input",
 CellID->19889240],
Cell[14060, 478, 3515, 99, 228, "Output",
 CellID->811619953]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17636, 584, 310, 9, 70, "SeeAlsoSection",
 CellID->1200],
Cell[17949, 595, 969, 35, 70, "SeeAlso",
 CellID->26058]
}, Open  ]],
Cell[CellGroupData[{
Cell[18955, 635, 314, 9, 70, "TutorialsSection",
 CellID->17578],
Cell[19272, 646, 147, 3, 70, "Tutorials",
 CellID->8365]
}, Open  ]],
Cell[CellGroupData[{
Cell[19456, 654, 319, 9, 70, "MoreAboutSection",
 CellID->571378832],
Cell[19778, 665, 169, 3, 70, "MoreAbout",
 CellID->550709301],
Cell[19950, 670, 167, 3, 70, "MoreAbout",
 CellID->102200314],
Cell[20120, 675, 160, 3, 70, "MoreAbout",
 CellID->618800420],
Cell[20283, 680, 149, 3, 70, "MoreAbout",
 CellID->241286558]
}, Open  ]],
Cell[20447, 686, 27, 0, 70, "History"],
Cell[20477, 688, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

