(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     38690,       1433]
NotebookOptionsPosition[     29993,       1124]
NotebookOutlinePosition[     31436,       1163]
CellTagsIndexPosition[     31350,       1158]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Precision" :> 
          Documentation`HelpLookup["paclet:tutorial/NumericalPrecision"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Numerical Precision\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$MachinePrecision" :> 
          Documentation`HelpLookup["paclet:ref/$MachinePrecision"], 
          "Precision" :> Documentation`HelpLookup["paclet:ref/Precision"], 
          "Accuracy" :> Documentation`HelpLookup["paclet:ref/Accuracy"], "N" :> 
          Documentation`HelpLookup["paclet:ref/N"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"$MachinePrecision\"\>", 2->"\<\"Precision\"\>", 
       3->"\<\"Accuracy\"\>", 4->"\<\"N\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Precision & Accuracy Control" :> 
          Documentation`HelpLookup[
           "paclet:guide/PrecisionAndAccuracyControl"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Precision & Accuracy Control\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MachinePrecision", "ObjectName",
 CellID->11585],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["MachinePrecision",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/MachinePrecision"]], "InlineFormula"],
     " \[LineSeparator]is a symbol used to indicate machine\[Hyphen]number \
precision. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24041]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The numerical value of ",
 Cell[BoxData[
  ButtonBox["MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MachinePrecision"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["$MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MachinePrecision"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24423],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Precision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Precision"], "[", "1.", "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MachinePrecision"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24129],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MachinePrecision"]], "InlineFormula"],
 " is the default specification for precision in ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " and other numerical functions. "
}], "Notes",
 CellID->24229],

Cell[TextData[{
 "Approximate real numbers are assumed to have precision specified by ",
 Cell[BoxData[
  ButtonBox["MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MachinePrecision"]], "InlineFormula"],
 " if fewer than ",
 Cell[BoxData[
  ButtonBox["$MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MachinePrecision"]], "InlineFormula"],
 " explicit digits are entered. "
}], "Notes",
 CellID->4565],

Cell[TextData[{
 "The option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WorkingPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WorkingPrecision"], "->", "MachinePrecision"}]], 
  "InlineFormula"],
 " specifies that internal computations in numerical functions should be done \
with machine numbers. "
}], "Notes",
 CellID->6559],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MachinePrecision"]], "InlineFormula"],
 " is treated as a numeric constant, with attribute ",
 Cell[BoxData[
  ButtonBox["Constant",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Constant"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8932]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->130029117],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->284590315],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "5.6", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14369],

Cell[BoxData["MachinePrecision"], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22532]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2963],

Cell[BoxData["15.954589770191003`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2607]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2483],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MachinePrecision"]], "InlineFormula"],
 " is treated as an exact numeric quantity:"
}], "ExampleText",
 CellID->911],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NumericQ", "[", "MachinePrecision", "]"}], "&&", 
  RowBox[{"Not", "[", 
   RowBox[{"InexactNumberQ", "[", "MachinePrecision", "]"}], "]"}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->257105469],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->44932705]
}, Open  ]],

Cell["Use like any number: ", "ExampleText",
 CellID->528622919],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Round", "[", "MachinePrecision", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11635],

Cell[BoxData["16"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10067]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"MachinePrecision", ",", "50"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->712266440],

Cell[BoxData["15.\
9545897701910033463281614203981304187140637174917525271595559883464`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->262605614]
}, Open  ]],

Cell["The number of bits represented: ", "ExampleText",
 CellID->447812510],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "[", 
   RowBox[{"2.", ",", "10"}], "]"}], "MachinePrecision"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->21054746],

Cell[BoxData["53.`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->645797781]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32605187],

Cell[TextData[{
 "The machine number approximating ",
 Cell[BoxData[
  FormBox["e", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->48963173],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"E", ",", "MachinePrecision"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->228303004],

Cell[BoxData["2.718281828459045`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->81564958]
}, Open  ]],

Cell[TextData[{
 "An arbitrary precision number approximating ",
 Cell[BoxData[
  FormBox["e", TraditionalForm]], "InlineMath"],
 " to the same precision as machine numbers:"
}], "ExampleText",
 CellID->381705955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"E", ",", "$MachinePrecision"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->303704737],

Cell[BoxData["2.71828182845904523536028747136`15.954589770191003"], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->77558515]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->691702020],

Cell["\<\
Use machine number arithmetic to solve a differential equation:\
\>", "ExampleText",
 CellID->259626898],

Cell[BoxData[
 RowBox[{
  RowBox[{"ode", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
       RowBox[{"Sin", "[", 
        RowBox[{"x", "[", "t", "]"}], "]"}]}], "\[Equal]", 
      RowBox[{"Cos", "[", "t", "]"}]}], ",", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->413661034],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"msol", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{"ode", ",", "x", ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "100"}], "}"}], ",", 
    RowBox[{"WorkingPrecision", "\[Rule]", "MachinePrecision"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->87859545],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "100.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{323, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->437014182]
}, Open  ]],

Cell["Use double machine precision:", "ExampleText",
 CellID->98583381],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"bsol", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{"ode", ",", "x", ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "100"}], "}"}], ",", 
    RowBox[{"WorkingPrecision", "\[Rule]", 
     RowBox[{"2", " ", "MachinePrecision"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->83481535],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0", ",", "100.`31.909179540382006"}], "}"}], "}"}], 
       ",", "\<\"<>\"\>"}], "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{519, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->35024040]
}, Open  ]],

Cell["Compare the two solutions:", "ExampleText",
 CellID->166676942],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"x", "[", "t", "]"}], "/.", 
     RowBox[{"{", 
      RowBox[{"msol", ",", "bsol"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "100"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->580740110],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->115837198]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->325010800],

Cell["Evaluate to double machine precision:", "ExampleText",
 CellID->3221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Pi", ",", 
   RowBox[{"2", "MachinePrecision"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17870],

Cell[BoxData["3.141592653589793238462643383279502884197169399375`31.\
909179540382006"], "Output",
 ImageSize->{235, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->346741579]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->163562520],

Cell["\<\
Use machine precision for the default precision argument in a function \
definition:\
\>", "ExampleText",
 CellID->73245157],

Cell[BoxData[
 RowBox[{
  RowBox[{"cuberoot", "[", 
   RowBox[{"x_", ",", 
    RowBox[{"prec_:", "MachinePrecision"}]}], "]"}], ":=", 
  RowBox[{"s", "/.", 
   RowBox[{"FindRoot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"s", "^", "3"}], "-", "x"}], ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "1."}], "}"}], ",", 
     RowBox[{"WorkingPrecision", "\[Rule]", "prec"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->219139712],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cuberoot", "[", "2", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->462811466],

Cell[BoxData["1.2599210498948732`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->321562553]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cuberoot", "[", 
  RowBox[{"2", ",", "50"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->39987327],

Cell[BoxData["1.\
2599210498948731647672106072782283505702514647015079800819751121554`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->700269169]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->281904929],

Cell["\<\
Make sure computations are carried out with the same precision as machine \
numbers:\
\>", "ExampleText",
 CellID->39026634],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"$MinPrecision", "=", "MachinePrecision"}], ",", 
     RowBox[{"$MaxPrecision", "=", "MachinePrecision"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"Exp", "[", "1000.", "]"}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Exp", "[", "1000.1", "]"}], "-", 
       RowBox[{"Exp", "[", "999.9", "]"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"1000.1", "-", "999.9"}], ")"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25139004],

Cell[BoxData[
 RowBox[{"-", 
  "3.28509397356634110839354714`15.954589770191005*^431"}]], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->293141463]
}, Open  ]],

Cell["\<\
Without fixing the precision, the resulting precision may be lower:\
\>", "ExampleText",
 CellID->8540175],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Exp", "[", "1000.", "]"}], "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Exp", "[", "1000.1", "]"}], "-", 
     RowBox[{"Exp", "[", "999.9", "]"}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{"1000.1", "-", "999.9"}], ")"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->246285016],

Cell[BoxData[
 RowBox[{"-", 
  "3.28509397356634110839354897`10.176220863521483*^431"}]], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->726761076]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2432004],

Cell["\<\
Numbers with just a few digits entered are assumed to have machine precision:\
\
\>", "ExampleText",
 CellID->46111664],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", "1.23456789"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->132452023],

Cell[BoxData["1.23456789`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37246136]
}, Open  ]],

Cell[TextData[{
 "Precision is based on the number of digits when more than ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[LeftCeiling]", "$MachinePrecision", "\[RightCeiling]"}], "+", 
    "1"}], TraditionalForm]], "InlineMath"],
 " are entered:"
}], "ExampleText",
 CellID->176047431],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"y", "=", "1.234567890123456789"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17486813],

Cell[BoxData["1.234567890123456789`18.091514977212704"], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->258115006]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Precision", "[", "x", "]"}], ",", 
   RowBox[{"Precision", "[", "y", "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->377238855],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"MachinePrecision", ",", "18.091514977212704`"}], "}"}]], "Output",
 ImageSize->{191, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->703976764]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->84600763],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MachinePrecision"]], "InlineFormula"],
 " is a numerical constant while ",
 Cell[BoxData[
  ButtonBox["$MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MachinePrecision"]], "InlineFormula"],
 " evaluates to a number:"
}], "ExampleText",
 CellID->191995555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"$MachinePrecision", ",", "MachinePrecision"}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->746206151],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"15.954589770191003`", ",", "MachinePrecision"}], "}"}]], "Output",
 ImageSize->{191, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->148951255]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MachinePrecision"]], "InlineFormula"],
 " is numerically ",
 Cell[BoxData[
  ButtonBox["Equal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Equal"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["$MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MachinePrecision"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->353205968],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MachinePrecision", "\[Equal]", "$MachinePrecision"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->564656874],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->360369609]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MachinePrecision"]], "InlineFormula"],
 " is the machine precision approximation to ",
 Cell[BoxData[
  ButtonBox["MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MachinePrecision"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->56333446],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"{", 
   RowBox[{"$MachinePrecision", ",", "MachinePrecision"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->54612880],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"15.954589770191003`", ",", "15.954589770191003`"}], 
  "}"}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->45739297]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MachinePrecision", ",", "MachinePrecision"}], "}"}], ",", 
   "30"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->260151904],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "15.954589770191003`", ",", 
   "15.95458977019100334632816142039813010898`30."}], "}"}]], "Output",
 ImageSize->{296, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->35840896]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->572725093],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MachinePrecision"]], "InlineFormula"],
 " times the number of bits per digit gives the binary machine precision:"
}], "ExampleText",
 CellID->107065090],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MachinePrecision", "*", 
  RowBox[{"Log", "[", 
   RowBox[{"2.", ",", "10."}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->66355674],

Cell[BoxData["53.`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->355244594]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->324205],

Cell[TextData[{
 "Digits beyond the known precision are represented as ",
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->48521689],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealDigits", "[", 
  RowBox[{
   RowBox[{"22", "/", "7."}], ",", "10", ",", 
   RowBox[{"Round", "[", 
    RowBox[{"MachinePrecision", "+", "3"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1637],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "3", ",", "1", ",", "4", ",", "2", ",", "8", ",", "5", ",", "7", ",", "1",
      ",", "4", ",", "2", ",", "8", ",", "5", ",", "7", ",", "1", ",", "4", 
     ",", "3", ",", "Indeterminate", ",", "Indeterminate", ",", 
     "Indeterminate"}], "}"}], ",", "1"}], "}"}]], "Output",
 ImageSize->{382, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->297218245]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3584],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MachinePrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MachinePrecision"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Precision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Precision"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Accuracy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Accuracy"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29734]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22296],

Cell[TextData[ButtonBox["Numerical Precision",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalPrecision"]], "Tutorials",
 CellID->29855]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->59058804],

Cell[TextData[ButtonBox["Precision & Accuracy Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecisionAndAccuracyControl"]], "MoreAbout",
 CellID->263327035]
}, Open  ]],

Cell["New in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MachinePrecision - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 59, 18.2591110}", "context" -> "System`", 
    "keywords" -> {
     "machine number", "double precision numbers", "floating point precision",
       "double flouting point precision", "IEEE floating point", 
      "IEEE 53-bit precision", "machine mantissa length"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MachinePrecision is a symbol used to indicate machine-number precision. \
", "synonyms" -> {"machine precision"}, "title" -> "MachinePrecision", "type" -> 
    "Symbol", "uri" -> "ref/MachinePrecision"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6012, 205, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->130029117]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 31207, 1151}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2068, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2691, 77, 54, 1, 70, "ObjectName",
 CellID->11585],
Cell[2748, 80, 465, 14, 70, "Usage",
 CellID->24041]
}, Open  ]],
Cell[CellGroupData[{
Cell[3250, 99, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3728, 116, 359, 13, 70, "Notes",
 CellID->24423],
Cell[4090, 131, 350, 13, 70, "Notes",
 CellID->24129],
Cell[4443, 146, 372, 12, 70, "Notes",
 CellID->24229],
Cell[4818, 160, 442, 13, 70, "Notes",
 CellID->4565],
Cell[5263, 175, 351, 11, 70, "Notes",
 CellID->6559],
Cell[5617, 188, 358, 12, 70, "Notes",
 CellID->8932]
}, Closed]],
Cell[CellGroupData[{
Cell[6012, 205, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->130029117],
Cell[CellGroupData[{
Cell[6397, 219, 148, 5, 70, "ExampleSection",
 CellID->284590315],
Cell[CellGroupData[{
Cell[6570, 228, 103, 3, 28, "Input",
 CellID->14369],
Cell[6676, 233, 170, 5, 36, "Output",
 CellID->22532]
}, Open  ]],
Cell[CellGroupData[{
Cell[6883, 243, 92, 3, 28, "Input",
 CellID->2963],
Cell[6978, 248, 171, 5, 36, "Output",
 CellID->2607]
}, Open  ]],
Cell[7164, 256, 120, 3, 70, "ExampleDelimiter",
 CellID->2483],
Cell[7287, 261, 228, 7, 70, "ExampleText",
 CellID->911],
Cell[CellGroupData[{
Cell[7540, 272, 232, 7, 70, "Input",
 CellID->257105469],
Cell[7775, 281, 160, 5, 36, "Output",
 CellID->44932705]
}, Open  ]],
Cell[7950, 289, 64, 1, 70, "ExampleText",
 CellID->528622919],
Cell[CellGroupData[{
Cell[8039, 294, 112, 3, 70, "Input",
 CellID->11635],
Cell[8154, 299, 155, 5, 36, "Output",
 CellID->10067]
}, Open  ]],
Cell[CellGroupData[{
Cell[8346, 309, 136, 4, 70, "Input",
 CellID->712266440],
Cell[8485, 315, 236, 7, 36, "Output",
 CellID->262605614]
}, Open  ]],
Cell[8736, 325, 75, 1, 70, "ExampleText",
 CellID->447812510],
Cell[CellGroupData[{
Cell[8836, 330, 157, 5, 70, "Input",
 CellID->21054746],
Cell[8996, 337, 161, 5, 36, "Output",
 CellID->645797781]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9206, 348, 219, 7, 70, "ExampleSection",
 CellID->32605187],
Cell[9428, 357, 160, 6, 70, "ExampleText",
 CellID->48963173],
Cell[CellGroupData[{
Cell[9613, 367, 135, 4, 70, "Input",
 CellID->228303004],
Cell[9751, 373, 174, 5, 36, "Output",
 CellID->81564958]
}, Open  ]],
Cell[9940, 381, 213, 6, 70, "ExampleText",
 CellID->381705955],
Cell[CellGroupData[{
Cell[10178, 391, 136, 4, 70, "Input",
 CellID->303704737],
Cell[10317, 397, 207, 5, 36, "Output",
 CellID->77558515]
}, Open  ]],
Cell[10539, 405, 125, 3, 70, "ExampleDelimiter",
 CellID->691702020],
Cell[10667, 410, 114, 3, 70, "ExampleText",
 CellID->259626898],
Cell[10784, 415, 522, 18, 70, "Input",
 CellID->413661034],
Cell[CellGroupData[{
Cell[11331, 437, 302, 9, 70, "Input",
 CellID->87859545],
Cell[11636, 448, 468, 17, 36, "Output",
 CellID->437014182]
}, Open  ]],
Cell[12119, 468, 71, 1, 70, "ExampleText",
 CellID->98583381],
Cell[CellGroupData[{
Cell[12215, 473, 324, 9, 70, "Input",
 CellID->83481535],
Cell[12542, 484, 484, 17, 36, "Output",
 CellID->35024040]
}, Open  ]],
Cell[13041, 504, 69, 1, 70, "ExampleText",
 CellID->166676942],
Cell[CellGroupData[{
Cell[13135, 509, 336, 11, 70, "Input",
 CellID->580740110],
Cell[13474, 522, 3271, 58, 70, "Output",
 Evaluatable->False,
 CellID->115837198]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16794, 586, 227, 7, 70, "ExampleSection",
 CellID->325010800],
Cell[17024, 595, 75, 1, 70, "ExampleText",
 CellID->3221],
Cell[CellGroupData[{
Cell[17124, 600, 151, 5, 70, "Input",
 CellID->17870],
Cell[17278, 607, 229, 6, 36, "Output",
 CellID->346741579]
}, Open  ]],
Cell[17522, 616, 125, 3, 70, "ExampleDelimiter",
 CellID->163562520],
Cell[17650, 621, 134, 4, 70, "ExampleText",
 CellID->73245157],
Cell[17787, 627, 445, 14, 70, "Input",
 CellID->219139712],
Cell[CellGroupData[{
Cell[18257, 645, 104, 3, 70, "Input",
 CellID->462811466],
Cell[18364, 650, 176, 5, 36, "Output",
 CellID->321562553]
}, Open  ]],
Cell[CellGroupData[{
Cell[18577, 660, 127, 4, 70, "Input",
 CellID->39987327],
Cell[18707, 666, 235, 7, 36, "Output",
 CellID->700269169]
}, Open  ]],
Cell[18957, 676, 125, 3, 70, "ExampleDelimiter",
 CellID->281904929],
Cell[19085, 681, 134, 4, 70, "ExampleText",
 CellID->39026634],
Cell[CellGroupData[{
Cell[19244, 689, 557, 17, 70, "Input",
 CellID->25139004],
Cell[19804, 708, 230, 7, 36, "Output",
 CellID->293141463]
}, Open  ]],
Cell[20049, 718, 116, 3, 70, "ExampleText",
 CellID->8540175],
Cell[CellGroupData[{
Cell[20190, 725, 331, 11, 70, "Input",
 CellID->246285016],
Cell[20524, 738, 230, 7, 36, "Output",
 CellID->726761076]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20803, 751, 235, 7, 70, "ExampleSection",
 CellID->2432004],
Cell[21041, 760, 129, 4, 70, "ExampleText",
 CellID->46111664],
Cell[CellGroupData[{
Cell[21195, 768, 101, 3, 70, "Input",
 CellID->132452023],
Cell[21299, 773, 167, 5, 36, "Output",
 CellID->37246136]
}, Open  ]],
Cell[21481, 781, 295, 9, 70, "ExampleText",
 CellID->176047431],
Cell[CellGroupData[{
Cell[21801, 794, 110, 3, 70, "Input",
 CellID->17486813],
Cell[21914, 799, 197, 5, 36, "Output",
 CellID->258115006]
}, Open  ]],
Cell[CellGroupData[{
Cell[22148, 809, 189, 6, 70, "Input",
 CellID->377238855],
Cell[22340, 817, 237, 7, 36, "Output",
 CellID->703976764]
}, Open  ]],
Cell[22592, 827, 124, 3, 70, "ExampleDelimiter",
 CellID->84600763],
Cell[22719, 832, 389, 12, 70, "ExampleText",
 CellID->191995555],
Cell[CellGroupData[{
Cell[23133, 848, 146, 4, 70, "Input",
 CellID->746206151],
Cell[23282, 854, 237, 7, 36, "Output",
 CellID->148951255]
}, Open  ]],
Cell[23534, 864, 474, 17, 70, "ExampleText",
 CellID->353205968],
Cell[CellGroupData[{
Cell[24033, 885, 130, 3, 70, "Input",
 CellID->564656874],
Cell[24166, 890, 161, 5, 36, "Output",
 CellID->360369609]
}, Open  ]],
Cell[24342, 898, 378, 12, 70, "ExampleText",
 CellID->56333446],
Cell[CellGroupData[{
Cell[24745, 914, 177, 6, 70, "Input",
 CellID->54612880],
Cell[24925, 922, 242, 8, 36, "Output",
 CellID->45739297]
}, Open  ]],
Cell[CellGroupData[{
Cell[25204, 935, 205, 7, 70, "Input",
 CellID->260151904],
Cell[25412, 944, 272, 9, 36, "Output",
 CellID->35840896]
}, Open  ]],
Cell[25699, 956, 125, 3, 70, "ExampleDelimiter",
 CellID->572725093],
Cell[25827, 961, 264, 7, 70, "ExampleText",
 CellID->107065090],
Cell[CellGroupData[{
Cell[26116, 972, 163, 5, 70, "Input",
 CellID->66355674],
Cell[26282, 979, 161, 5, 36, "Output",
 CellID->355244594]
}, Open  ]],
Cell[26458, 987, 122, 3, 70, "ExampleDelimiter",
 CellID->324205],
Cell[26583, 992, 246, 8, 70, "ExampleText",
 CellID->48521689],
Cell[CellGroupData[{
Cell[26854, 1004, 234, 7, 70, "Input",
 CellID->1637],
Cell[27091, 1013, 482, 13, 54, "Output",
 CellID->297218245]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27634, 1033, 310, 9, 70, "SeeAlsoSection",
 CellID->3584],
Cell[27947, 1044, 947, 35, 70, "SeeAlso",
 CellID->29734]
}, Open  ]],
Cell[CellGroupData[{
Cell[28931, 1084, 314, 9, 70, "TutorialsSection",
 CellID->22296],
Cell[29248, 1095, 148, 3, 70, "Tutorials",
 CellID->29855]
}, Open  ]],
Cell[CellGroupData[{
Cell[29433, 1103, 318, 9, 70, "MoreAboutSection",
 CellID->59058804],
Cell[29754, 1114, 167, 3, 70, "MoreAbout",
 CellID->263327035]
}, Open  ]],
Cell[29936, 1120, 27, 0, 70, "History"],
Cell[29966, 1122, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

